#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include "include.h"

int find_save_fun args(( int type ));

void ed_struct(CHAR_DATA *ch, const struct save_type *save_table, char *argument )
{	int ed, i, count, type;
	char arg[MSL];

	arg[0] = '\0';
	argument = one_argument(argument, arg);

	if( arg[0] == '\0' )
	{	printf_to_char(ch, "That isn't a valid option. Please choose one of the following:\n\r\n\r");
		count = 0;
		for( i = 0; save_table[i].name != NULL; i++ )
			printf_to_char(ch, "\t[%d] %s\n\r", count++, save_table[i].name );
		return;
	}
	if(LOWER(arg[0]) == 'x' )
	{	PrintOLCMenu(ch);
		ch->desc->OLC_state = STATE_OLC_MENU;
		return;
	}

	if( ( ed = ed_lookup(arg, save_table) ) == -1 )
	{	printf_to_char(ch, "That isn't a valid option. Please use with no argument to get a list.\n\r" );
		return;
	}

	if( (type = find_save_fun(save_table[ed].type) ) == -1 )
	{	printf_to_char(ch, "Type not valid. Please report to immortal.\n\r" );
		return;
	}
	
	if(argument[0] == '\0' )
	{	printf_to_char(ch, "What would you like to change it too?\n\r" );
		return;
	}

	(*varfun_table[type].eCmd ) (ch, argument, save_table[ed].field, save_table, ed, save_table[ed].max );
	return;
}

int ed_lookup(char *name, const struct save_type *save_table)
{	int i, ed;
	
	if(is_number(name) )
	{	i = atoi(name);
		if( i < 0 )
			return -1;
		for(ed = 0; save_table[ed].name != NULL; ed++ );
		if(i >= ed )
			return -1;
		return i;
	}
	
	for(i=0;save_table[i].name != NULL; i++ )
	{	if(LOWER(name[0]) == LOWER(save_table[i].name[0]) 
		&& !str_prefix(name, save_table[i].name) )
		return i;
	}
	return -1;
}

VAR_EDITOR( ed_ints )
{	if( arg[0] == '\0' )
	{	printf_to_char(ch, "Syntax: <field> <value>\n\r");
		return;
	}

	if(!is_number(arg) )
	{	printf_to_char(ch, "You can only set it to numbers!\n\r");
		return;
	}

   **(int**) save_table[spot].field = atoi(arg);
   printf_to_char(ch, "%s value set to %d.\n\r", save_table[spot].name, **(int **) save_table[spot].field );
   return;
} 

VAR_EDITOR( ed_string )
{	char **ptr;

	if(arg[0] == '\0' )
	{	printf_to_char(ch, "Syntax: <field> <string>\n\r");
		return;
	}
	
	ptr = (char ** ) save_table[spot].field;
	free_string( *ptr );
	*ptr = str_dup(arg);
	printf_to_char(ch, "%s value set to %s.\n\r", save_table[spot].name, *ptr );
	return;
}

VAR_EDITOR( ed_str_array )
{	char **ptr;
	int i, slot;
	char AryMd[MSL];

	AryMd[0] = '\0';

	arg = one_argument(arg, AryMd);

	if( !max || max <= 0 )
	{	printf_to_char(ch, "Max not set. Please report this to an Immortal.\n\r");
		return;
	}

	if(AryMd[0] == '\0' )
	{	printf_to_char(ch, "Synatx: <field> <Array Spot> <string>\n\r" );
		printf_to_char(ch, "                - To See the Array's slots, use '<field> list'\n\r" );
		return;
	}
	ptr = (char ** ) save_table[spot].field;
	
	if(!strcasecmp(AryMd, "list" ) )
	{	for( i = 0 ; i < max ; i++ )
			printf_to_char(ch, "\t[%d] %s\n", i, ptr[i] );
		return;
	}
	
	if(arg[0] == '\0' )
	{	printf_to_char(ch, "Synatx: <field> <Array Spot> <string>\n\r" );
		printf_to_char(ch, "                - To See the Array's slots, use '<field> list'\n\r" );
		return;
	}
	
	if( !is_number(AryMd) )
	{	printf_to_char(ch, "The Array Spot must be a number or 'list'.\n\r" );
		return;
	}

	if( (slot = atoi(AryMd) ) >= max || slot < 0 )
	{	printf_to_char(ch, "The number must be larger or equil to 0, or less than %d.\n",max );
		return;
	}

	free_string(ptr[slot]);
	ptr[slot] = str_dup(arg);
	printf_to_char(ch, "Slot %d of the String array was set to \"%s.\"\n\r", slot, ptr[slot] );
	return;
}

VAR_EDITOR( ed_int_array )
{	int *ptr;
	int i, slot;
	char AryMd[MSL];

	AryMd[0] = '\0';

	arg = one_argument(arg, AryMd);

	if( !max || max <= 0 )
	{	printf_to_char(ch, "Max not set. Please report this to an Immortal.\n\r");
		return;
	}

	if(AryMd[0] == '\0' )
	{	printf_to_char(ch, "Synatx: <field> <Array Spot> <value>\n\r" );
		printf_to_char(ch, "                - To See the Array's slots, use '<field> list'\n\r" );
		return;
	}
	ptr = (int * ) save_table[spot].field;
	
	if(!strcasecmp(AryMd, "list" ) )
	{	for( i = 0 ; i < max ; i++ )
			printf_to_char(ch, "\t[%d] %d\n", i, ptr[i] );
		return;
	}
	
	if(arg[0] == '\0' )
	{	printf_to_char(ch, "Synatx: <field> <Array Spot> <value>\n\r" );
		printf_to_char(ch, "                - To See the Array's slots, use '<field> list'\n\r" );
		return;
	}
	
	if( !is_number(AryMd) )
	{	printf_to_char(ch, "The Array Spot must be a number or 'list'.\n\r" );
		return;
	}

	if( (slot = atoi(AryMd) ) >= max || slot < 0 )
	{	printf_to_char(ch, "The number must be larger or equil to 0, or less than %d.\n",max );
		return;
	}
	
	if( !is_number(arg) )
	{	printf_to_char(ch, "The Value must be a number.\n\r" );
		return;
	}

	
	ptr[slot] = atoi(arg);
	printf_to_char(ch, "Slot %d of the number array was set to %d.\n\r", slot, ptr[slot] );
	return;
}
