/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik Stfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

/***************************************************************************
*	ROM 2.4 is copyright 1993-1998 Russ Taylor			   *
*	ROM has been brought to you by the ROM consortium		   *
*	    Russ Taylor (rtaylor@hypercube.org)				   *
*	    Gabrielle Taylor (gtaylor@hypercube.org)			   *
*	    Brian Moore (zump@rom.org)					   *
*	By using this code, you have agreed to follow the terms of the	   *
*	ROM license, in the file Rom24/doc/rom.license			   *
***************************************************************************/

#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include "include.h"

/*
 * Local functions.
 */
void	check_assist	args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
bool	check_dodge	args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
void	check_killer	args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
bool	check_parry	args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
bool    check_shield_block     args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
void    dam_message 	args( ( CHAR_DATA *ch, CHAR_DATA *victim, int dam,
                            int dt, bool immune ) );
void	death_cry	args( ( CHAR_DATA *ch ) );
void	group_gain	args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
int	xp_compute	args( ( CHAR_DATA *gch, CHAR_DATA *victim, 
			    int total_levels ) );
bool	is_safe		args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
void	make_corpse	args( ( CHAR_DATA *ch ) );
void    one_hit         args( ( CHAR_DATA *ch, CHAR_DATA *victim, int dt, bool secondary ) );
void    mob_hit		args( ( CHAR_DATA *ch, CHAR_DATA *victim, int dt ) );
void	raw_kill	args( ( CHAR_DATA *victim, CHAR_DATA *killer ) );
void	set_fighting	args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
void	disarm		args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
extern  void            set_fighting(CHAR_DATA *ch, CHAR_DATA *victim);
bool    check_critical  args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
bool    check_counter   args( ( CHAR_DATA *ch, CHAR_DATA *victim, int dam, int dt ) );
void    crowd_brawl     args( ( CHAR_DATA *ch ) );
bool    check_steel_skin args( ( CHAR_DATA *ch, CHAR_DATA *victim ) ); 
bool    check_phase     args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
bool    check_force_shield args ( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
bool    check_static_shield args ( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
bool    check_flame_shield args ( ( CHAR_DATA *ch, CHAR_DATA *victim ) );


extern char *	const	dir_name	[];

#define MAX_SPECTATORS 100

/*
 * Control the fights going on.
 * Called periodically by update_handler.
 */
void violence_update( void )
{
    CHAR_DATA *ch;
    CHAR_DATA *ch_next;
    CHAR_DATA *victim;
    OBJ_DATA *obj, *obj_next;
    bool room_trig = FALSE;

    for ( ch = char_list; ch != NULL; ch = ch->next )
    {
	ch_next	= ch->next;

	if ( ( victim = ch->fighting ) == NULL || IN_ROOM(ch) == NULL )
	    continue;

	if ( IS_AWAKE(ch) && IN_ROOM(ch) == IN_ROOM(victim) )
        {
            crowd_brawl(ch);
	    
multi_hit( ch, victim, TYPE_UNDEFINED );
        }
	else
	    stop_fighting( ch, FALSE );

	if ( ( victim = ch->fighting ) == NULL )
	    continue;

	/*
	 * Fun for the whole family!
	 */
	check_assist(ch,victim);
    
       	if ( IS_NPC( ch ) )
	{
	    if ( HAS_TRIGGER_MOB( ch, TRIG_FIGHT ) )
                p_percent_trigger( ch, NULL, NULL, NULL, NULL, NULL, TRIG_FIGHT );  
	    if ( HAS_TRIGGER_MOB( ch, TRIG_HPCNT ) )
		p_hprct_trigger( ch, victim );
 	}
	if( ( victim = ch->fighting ) == NULL )
		continue;
       	for ( obj = ch->carrying; obj; obj = obj_next )
	{
	    obj_next = obj->next_content;

	    if ( obj->wear_loc != WEAR_NONE && HAS_TRIGGER_OBJ( obj, TRIG_FIGHT ) )
		p_percent_trigger( NULL, obj, NULL, victim, NULL, NULL, TRIG_FIGHT );
	}
	if( ( victim = ch->fighting ) == NULL )
		continue;	
	if ( HAS_TRIGGER_ROOM( IN_ROOM(ch), TRIG_FIGHT ) && room_trig == FALSE )
	{
	    room_trig = TRUE;
	    p_percent_trigger( NULL, NULL, IN_ROOM(ch), victim, NULL, NULL, TRIG_FIGHT );
	}
    }

    return;
}

/* for auto assisting */
void check_assist(CHAR_DATA *ch,CHAR_DATA *victim)
{
    CHAR_DATA *rch, *rch_next;

    for (rch = IN_ROOM(ch)->people; rch != NULL; rch = rch_next)
    {
	rch_next = rch->next_in_room;
	
	if (IS_AWAKE(rch) && rch->fighting == NULL && can_see(rch,victim))

	{
        if (RIDDEN(rch) == ch || MOUNTED(rch) == ch)
            multi_hit(rch,victim,TYPE_UNDEFINED);
	    /* quick check for ASSIST_PLAYER */
	    if (!IS_NPC(ch) && IS_NPC(rch) 
	    && IS_SET(rch->off_flags,ASSIST_PLAYERS)
	    &&  rch->level + 6 > victim->level)
	    {
               if(!is_safe(rch,ch))
               {
            
		  do_function(rch, &do_emote, "screams and attacks!");
		  multi_hit(rch,victim,TYPE_UNDEFINED);
               }
		  continue;
	    }

	    /* PCs next */
	    if (!IS_NPC(ch) )
	    {
		if ( ( (!IS_NPC(rch) && IS_SET(rch->act,PLR_AUTOASSIST))) 
		&&   is_same_group(ch,rch) 
		&&   !is_safe(rch, victim))
		    multi_hit (rch,victim,TYPE_UNDEFINED);
		
		continue;
	    }
  	
	    /* now check the NPC cases */
	    
 	    if (IS_NPC(ch))
	
	    {
		if ( (IS_NPC(rch) && IS_SET(rch->off_flags,ASSIST_ALL))

		||   (IS_NPC(rch) && rch->group && rch->group == ch->group)

		||   (IS_NPC(rch) && rch->race == ch->race 
		   && IS_SET(rch->off_flags,ASSIST_RACE))

		||   (IS_NPC(rch) && IS_SET(rch->off_flags,ASSIST_ALIGN)
		   &&   ((IS_GOOD(rch)    && IS_GOOD(ch))
		     ||  (IS_EVIL(rch)    && IS_EVIL(ch))
		     ||  (IS_NEUTRAL(rch) && IS_NEUTRAL(ch)))) 

		||   (rch->pIndexData == ch->pIndexData 
		   && IS_SET(rch->off_flags,ASSIST_VNUM)))

	   	{
		    CHAR_DATA *vch;
		    CHAR_DATA *target;
		    int number;

		    if (number_bits(1) == 0)
			continue;
		
		    target = NULL;
		    number = 0;
		    for (vch = IN_ROOM(ch)->people; vch; vch = vch->next)
		    {
			if (can_see(rch,vch)
			&&  is_same_group(vch,victim)
			&&  number_range(0,number) == 0)
			{
			    target = vch;
			    number++;
			}
		    }

                    if(target != NULL && (!is_safe(rch, target)))
		    {
			do_function(rch, &do_emote, "screams and attacks!");
			multi_hit(rch,target,TYPE_UNDEFINED);
		    }
		}	
	    }
	}
    }
}


/*
 * Do one group of attacks.
 */
void multi_hit( CHAR_DATA *ch, CHAR_DATA *victim, int dt )
{
    int     chance;

    /* decrement the wait */
    if (ch->desc == NULL)
	ch->wait = UMAX(0,ch->wait - PULSE_VIOLENCE);

    if (ch->desc == NULL)
	ch->daze = UMAX(0,ch->daze - PULSE_VIOLENCE); 


    /* no attacks for stunnies -- just a check */
    if (ch->position < POS_RESTING)
	return;

    if (IS_NPC(ch))
    {
	mob_hit(ch,victim,dt);
	return;
    }

    if (MOUNTED(ch))
    {
    	if (!mount_success(ch, MOUNTED(ch), FALSE))
	    send_to_char("You fall off your mount as you start your attacks!\n\r", ch);
    }
    one_hit( ch, victim, dt, FALSE );
    if(ch->wereform == MOON_FULL && ch->iswere)
    {
	one_hit(ch, victim, dt, FALSE );
	one_hit(ch, victim, dt, FALSE );
	one_hit(ch, victim, dt, FALSE );
    }
    if (get_eq_char (ch, WEAR_SECONDARY))
    {
        one_hit( ch, victim, dt, TRUE );
        if ( ch->fighting != victim )
            return;
    }

    if (ch->fighting != victim)
	return;

    if ( ch->fighting != victim || dt == skill_lookup("backstab"))
	return;

    chance = get_skill(ch,skill_lookup("second attack"))/2;

    if ( number_percent( ) < chance )
    {
	one_hit( ch, victim, dt, FALSE );
	check_improve(ch,skill_lookup("second attack"),TRUE,5);
	if ( ch->fighting != victim )
	    return;
    }

    chance = get_skill(ch,skill_lookup("third attack"))/4;

    if ( number_percent( ) < chance )
    {
	one_hit( ch, victim, dt, FALSE );
	check_improve(ch,skill_lookup("third attack"),TRUE,6);
	if ( ch->fighting != victim )
	    return;
    }

    chance = get_skill(ch,skill_lookup("fourth attack"))/4;


    if ( number_percent( ) < chance )
    {
        one_hit( ch, victim, dt, FALSE );
        check_improve(ch,skill_lookup("fourth attack"), TRUE,6);
        if ( ch->fighting != victim )
            return;
    }

    chance = get_skill(ch,skill_lookup("fifth attack"))/4;
   

    if ( number_percent( ) < chance )
    {
        one_hit( ch, victim, dt, FALSE );
        check_improve(ch,skill_lookup("fifth attack"), TRUE,6);     
        if ( ch->fighting != victim )
            return;
    }

    return;
}

/* procedure for all mobile attacks */
void mob_hit (CHAR_DATA *ch, CHAR_DATA *victim, int dt)
{
    int chance,number;
    CHAR_DATA *vch, *vch_next;

    one_hit(ch,victim,dt, FALSE);

    if (ch->fighting != victim)
	return;

    /* Area attack -- BALLS nasty! */
 
    if (IS_SET(ch->off_flags,OFF_AREA_ATTACK))
    {
	for (vch = IN_ROOM(ch)->people; vch != NULL; vch = vch_next)
	{
	    vch_next = vch->next;
	    if ((vch != victim && vch->fighting == ch))
		one_hit(ch,vch,dt, FALSE);
	}
    }

    if ((IS_SET(ch->off_flags,OFF_FAST) ))
	one_hit(ch,victim,dt, FALSE);

    if (ch->fighting != victim || dt == skill_lookup("backstab"))
	return;

    chance = get_skill(ch,skill_lookup("second attack"))/2;

    if (!IS_SET(ch->off_flags,OFF_FAST))
	chance /= 2;

    if (number_percent() < chance)
    {
	one_hit(ch,victim,dt, FALSE);
	if (ch->fighting != victim)
	    return;
    }

    chance = get_skill(ch,skill_lookup("third attack"))/4;

    if (!IS_SET(ch->off_flags,OFF_FAST))
	chance = 0;

    if (number_percent() < chance)
    {
	one_hit(ch,victim,dt, FALSE);
	if (ch->fighting != victim)
	    return;
    } 

    chance = get_skill(ch,skill_lookup("fourth attack"))/4;      

    if ( !IS_SET(ch->off_flags,OFF_FAST))
        chance = 0;

    if (number_percent() < chance)
    {
        one_hit(ch,victim,dt, FALSE);
        if (ch->fighting != victim)
            return;
    }

    /* oh boy!  Fun stuff! */

    if (ch->wait > 0)
	return;

    number = number_range(0,2);

    if (number == 1 && IS_SET(ch->act,ACT_MAGE))
    {
	/*  { mob_cast_mage(ch,victim); return; } */ ;
    }

    if (number == 2 && IS_SET(ch->act,ACT_CLERIC))
    {	
	/* { mob_cast_cleric(ch,victim); return; } */ ;
    }

    /* now for the skills */

    number = number_range(0,8);

    switch(number) 
    {
    case (0) :
	if (IS_SET(ch->off_flags,OFF_BASH))
	    do_function(ch, &do_bash, "");
	break;

    case (1) :
	if (IS_SET(ch->off_flags,OFF_DISARM) 
	|| (get_weapon_sn(ch) != skill_lookup("hand to hand") 
	&& (IS_SET(ch->act,ACT_WARRIOR)
   	||  IS_SET(ch->act,ACT_THIEF))))
	    do_function(ch, &do_disarm, "");
	break;

    case (2) :
	if (IS_SET(ch->off_flags,OFF_KICK))
	    do_function(ch, &do_kick, "");
	break;

    case (3) :
	if (IS_SET(ch->off_flags,OFF_KICK_DIRT))
	    do_function(ch, &do_dirt, "");
	break;

    case (4) :
	if (IS_SET(ch->off_flags,OFF_TAIL))
	{
	    do_function(ch, &do_tail, "");
	}
	break; 

    case (5) :
	if (IS_SET(ch->off_flags,OFF_TRIP))
	    do_function(ch, &do_trip, "");
	break;

    case (6) :
	if (IS_SET(ch->off_flags,OFF_CRUSH))
	{
	    /* do_function(ch, &do_crush, "") */ ;
	}
	break;
    case (7) :
	if (IS_SET(ch->off_flags,OFF_BACKSTAB))
	{
	    do_function(ch, &do_backstab, "");
	}
        break;
    case (8) :
        if (IS_SET(ch->off_flags,OFF_BLOODLUST))
        {
            do_function(ch, &do_bloodlust, "");
        }
    }
}
	

/*
 * Hit one guy once.
 */
void one_hit( CHAR_DATA *ch, CHAR_DATA *victim, int dt, bool secondary )
{
    OBJ_DATA *wield;
    int victim_ac;
    int thac0;
    int thac0_00;
    int thac0_32;
    int dam;
    int diceroll;
    int sn,skill;
    int dam_type;
    bool result;
	USE *use;

    sn = -1;


    /* just in case */
    if (victim == ch || ch == NULL || victim == NULL)
	return;

    /*
     * Can't beat a dead char!
     * Guard against weird room-leavings.
     */
    if ( victim->position == POS_DEAD || IN_ROOM(ch) != IN_ROOM(victim) )
	return;

    /*
     * Figure out the type of damage message.
     */

    if (!secondary)
        wield = get_eq_char( ch, WEAR_WIELD );
    else
        wield = get_eq_char( ch, WEAR_SECONDARY );

    if ( dt == TYPE_UNDEFINED )
    {
	dt = TYPE_HIT;
	if ( wield != NULL && ( use = get_obj_use(wield, UTYPE_WEAPON ) ) )
	    dt += use->value[3];
	else if(ch->wereform == MOON_FULL && ch->iswere)
  	     dt += attack_table[attack_lookup("claw")].damage;
	else
	    dt += ch->dam_type;
    }

    if (dt < TYPE_HIT)
    {
	if (wield != NULL)
    	    dam_type = attack_table[use->value[3]].damage;
    	else if (ch->wereform == MOON_FULL && ch->iswere)
	    dam_type = attack_table[attack_lookup("claw")].damage;
	else
    	    dam_type = attack_table[ch->dam_type].damage;
    }
    else if (dt >= TYPE_HIT && dt < TYPE_SPELL)
		dam_type = attack_table[dt - TYPE_HIT].damage;

    if (dam_type == -1)
	dam_type = DAM_BASH;

    /* get the weapon skill */
    sn = get_weapon_sn(ch);
    skill = 20 + get_weapon_skill(ch,sn);

    /*
     * Calculate to-hit-armor-class-0 versus armor.
     */
    if ( IS_NPC(ch) )
    {
	thac0_00 = 20;
	thac0_32 = -4;   /* as good as a thief */ 
	if (IS_SET(ch->act,ACT_WARRIOR))
	    thac0_32 = -10;
	else if (IS_SET(ch->act,ACT_THIEF))
	    thac0_32 = -4;
	else if (IS_SET(ch->act,ACT_CLERIC))
	    thac0_32 = 2;
	else if (IS_SET(ch->act,ACT_MAGE))
	    thac0_32 = 6;
    }
    else
    {
	thac0_00 = get_thac00(ch);
	thac0_32 = get_thac32(ch);
    }
    thac0  = interpolate( ch->level, thac0_00, thac0_32 );

    if (thac0 < 0)
        thac0 = thac0/2;

    if (thac0 < -5)
        thac0 = -5 + (thac0 + 5) / 2;

    thac0 -= GET_HITROLL(ch) * skill/100;
    thac0 += 5 * (100 - skill) / 100;

    if (dt == skill_lookup("backstab"))
	thac0 -= 10 * (100 - get_skill(ch,skill_lookup("backstab")));

    if (dt == skill_lookup("throatchop") )
    	thac0 -= 10 * (90 - get_skill(ch, skill_lookup("throatchop" )));

    if (dt == skill_lookup("cleave"))
        thac0 -= 10 * (100 - get_skill(ch,skill_lookup("cleave")));

    if (dt == skill_lookup("circle"))
        thac0 -= 10 * (100 - get_skill(ch,skill_lookup("circle")));

    if (dt == skill_lookup("whirlwind"))
        thac0 -= 10 * (100 - get_skill(ch,skill_lookup("whirlwind")));

    if (dt == skill_lookup("assassinate"))
        thac0 -= 10 * (100 - get_skill(ch,skill_lookup("assassinate"))); 

    if (dt == skill_lookup("spin"))
        thac0 -= 10 * (100 - get_skill(ch,skill_lookup("spin")));

    if (dt == skill_lookup("rage"))
        thac0 -= 10 * (100 - get_skill(ch,skill_lookup("rage")));
	victim_ac = 0;
    switch(dam_type)
    {
	case(DAM_PIERCE):victim_ac = GET_AC(victim,AC_PIERCE);	break;
	case(DAM_BASH):	 victim_ac = GET_AC(victim,AC_BASH);		break;
	case(DAM_SLASH): victim_ac = GET_AC(victim,AC_SLASH);	break;
	default:	 victim_ac = GET_AC(victim,AC_EXOTIC);	break;
    }; 
	

    /*
     * The moment of excitement!
     */
    while ( ( diceroll = number_bits( 5 ) ) >= 20 )
	;

    if(number_range(1,10) > 6 && IS_WEREWOLF(ch))
	diceroll = 19;
    if ( diceroll == 0
    || ( diceroll != 19 && diceroll < thac0  ) )
    {
	/* Miss. */
	damage( ch, victim, 0, dt, dam_type, TRUE );
	tail_chain( );
	return;
    }

    /*
     * Hit.
     * Calc damage.
     */
    if ( IS_NPC(ch) && (!ch->pIndexData->new_format || wield == NULL))
		if (!ch->pIndexData->new_format)
		{
			dam = number_range( ch->level / 2, ch->level * 3 / 2 );
			if ( wield != NULL )
				dam += dam / 2;
		}
		else
			dam = dice(ch->damage[DICE_NUMBER],ch->damage[DICE_TYPE]);
		
    else
    {
	if (sn != -1)
	    check_improve(ch,sn,TRUE,5);
	if ( wield != NULL )
	{
	    if (wield->pIndexData->new_format)
		dam = dice(use->value[1],use->value[2]) * skill/100;
	    else
	    	dam = number_range( use->value[1] * skill/100, 
				use->value[2] * skill/100);

	    if (get_eq_char(ch,WEAR_SHIELD) == NULL)  /* no shield = more */
		dam = dam * 11/10;

	    /* sharpness! */
	    if (IS_WEAPON_STAT(use,WEAPON_SHARP))
	    {
		int percent;

		if ((percent = number_percent()) <= (skill / 8))
		    dam = 2 * dam + (dam * 2 * percent / 100);
	    }
	}
	else if( ch->wereform == MOON_FULL && ch->iswere)
	    dam = number_range( ch->level / 2,  200 );
	else
	    dam = number_range( 1 + 4 * skill/100, 2 * ch->level/3 * skill/100);
    }

    /*
     * Bonuses.
     */
    if ( get_skill(ch,skill_lookup("enhanced damage")) > 0 )
    {
        diceroll = number_percent();
        if (diceroll <= get_skill(ch,skill_lookup("enhanced damage")))
        {
            check_improve(ch,skill_lookup("enhanced damage"),TRUE,6);
            dam += 2 * ( dam * diceroll/300);
        }
    }

    if ( get_skill(ch,skill_lookup("ultra damage")) > 0 )
    {
          diceroll = number_percent();
          if (diceroll <= get_skill(ch,skill_lookup("ultra damage")))
          {
            check_improve(ch,skill_lookup("ultra damage"),TRUE,6);
            dam += dam * diceroll/100;
          }
    }         

    if ( get_skill(ch,skill_lookup("hero damage")) > 0 )
    {
          diceroll = number_percent();
          if (diceroll <= get_skill(ch,skill_lookup("hero damage")))
          {
            check_improve(ch,skill_lookup("hero damage"),TRUE,6);
            dam += dam * diceroll/80;
          }
    }          


    if ( get_skill(ch,skill_lookup("warrior strength" ) ) > 0 )
    {
        diceroll = number_percent();
        if (diceroll <= get_skill(ch,skill_lookup("warrior strength" )))
        {
            check_improve(ch,skill_lookup("warrior strength" ),TRUE,6);
            dam += 2 * ( dam * diceroll/300);
        }
    }

/*testing for orc damage for the race orc*/
    if ( get_skill(ch,skill_lookup("minotaur damage")) > 0 )
    {
        diceroll = number_percent();
        if (diceroll <= get_skill(ch,skill_lookup("minotaur damage")))
        {
            check_improve(ch,skill_lookup("minotaur damage"),TRUE,5);
            dam += 2 * ( dam * diceroll/300);
        }
    }
    
	if ( get_skill(ch,skill_lookup("orc damage")) > 0 )
    {
        diceroll = number_percent();
        if (diceroll <= get_skill(ch,skill_lookup("orc damage")))
        {
            check_improve(ch,skill_lookup("orc damage"),TRUE,5);
            dam += (int)(2.5 * ( dam * diceroll/300));
        }
    }

    if ( get_skill(ch,skill_lookup("giant damage")) > 0 )
    {
        diceroll = number_percent();
        if (diceroll <= get_skill(ch,skill_lookup("giant damage")))
        {
            check_improve(ch,skill_lookup("giant damage"),TRUE,5);
            dam += 3 * ( dam * diceroll/300);
        }
    }

    if ( get_skill(ch,skill_lookup("dragon damage") ) > 0 )
    {
        diceroll = number_percent();
        if (diceroll <= get_skill(ch,skill_lookup("dragon damage")))
        {
            check_improve(ch,skill_lookup("dragon damage"),TRUE,5);
            dam += 4 * ( dam * diceroll/300);
        }
    }


    if ( check_critical(ch,victim) )
        dam = (int)(dam * 1.40);

    if ( !IS_AWAKE(victim) )
	dam *= 2;
     else if (victim->position < POS_FIGHTING)
	dam = dam * 3 / 2;

    if ( dt == skill_lookup("backstab") && wield != NULL) 
    {
    	if ( use->value[0] != 2 )
	    dam *= 2 + (ch->level / 10); 
	else 
	    dam *= 2 + (ch->level / 8);
    }
    if ( dt == skill_lookup("throatchop") && wield != NULL )
    	dam *= 2 +(ch->level/5 );
    if ( dt == skill_lookup("cleave") && wield != NULL)
    {      
        if ( use->value[0] != 2 )
            dam *= 2 + (ch->level / 14);
        else
            dam *= 2 + (ch->level / 10);
    }     

    if ( dt == skill_lookup("circle") && wield != NULL)
    {
        if ( use->value[0] != 2 )
           dam *= 2 + (ch->level / 10);
        else
           dam *= 2 + (ch->level / 8);
    }

    if ( dt == skill_lookup("whirlwind") && wield != NULL)
    {
        if ( use->value[0] != 2 )
           dam *= 2 + (ch->level / 10);
        else
           dam *= 2 + (ch->level / 8);
    }     
   
    if ( dt == skill_lookup("assassinate") && wield != NULL)
    {
        if ( use->value[0] != 2 )
           dam *= 2 + (ch->level / 10);
        else
           dam *= 2 + (ch->level / 8);
    }

    if ( dt == skill_lookup("spin") && wield != NULL)
    {
        if ( use->value[0] != 2 )
           dam *= 2 + (ch->level / 10);
        else
           dam *= 2 + (ch->level / 8);
    }          

    if ( dt == skill_lookup("rage") && wield != NULL)
    {
        if ( use->value[0] != 2 )
           dam *= 2 + (ch->level / 10);
        else
           dam *= 2 + (ch->level / 8);
    }    

    dam += GET_DAMROLL(ch) * UMIN(100,skill) /100;
	if(victim_ac == 0)
		victim_ac++;
	dam = (int)((float)dam - ( (float)dam * ((float)victim_ac/100.00)));
    if ( dam <= 0 )
	dam = 1;
	
    if ( !check_counter( ch, victim, dam, dt ) )
        result = damage( ch, victim, dam, dt, dam_type, TRUE );

    else return;
    
    /* but do we have a funky weapon? */
    if (result && wield != NULL)
    { 
	int dam;

        
	if (ch->fighting == victim && IS_WEAPON_STAT(use,WEAPON_FLAMING))
	{
	    dam = number_range(1,wield->level / 4 + 1);
	    xact_new("$n is burned by $p.",victim,wield,NULL,TO_ROOM,POS_RESTING,SUPPRESS_FLAGS);
	    xact_new("$p sears your flesh.",victim,wield,NULL,TO_CHAR,POS_RESTING,SUPPRESS_FLAGS);
	    fire_effect( (void *) victim,wield->level/2,dam,TARGET_CHAR);
	    damage(ch,victim,dam,0,DAM_FIRE,FALSE);
	}

	if (ch->fighting == victim && IS_WEAPON_STAT(use,WEAPON_FROST))
	{
	    dam = number_range(1,wield->level / 6 + 2);
	    xact_new("$p freezes $n.",victim,wield,NULL,TO_ROOM,POS_RESTING,SUPPRESS_FLAGS);
	    xact_new("The cold touch of $p surrounds you with ice.",
		victim,wield,NULL,TO_CHAR,POS_RESTING,SUPPRESS_FLAGS);
	    cold_effect(victim,wield->level/2,dam,TARGET_CHAR);
	    damage(ch,victim,dam,0,DAM_COLD,FALSE);
	}

    }

    tail_chain( );
    return;
}


/*
 * Inflict damage from a hit.
 */
bool damage(CHAR_DATA *ch,CHAR_DATA *victim,int dam,int dt,int dam_type,
	    bool show) 
{
    OBJ_DATA *corpse;
    bool immune;
    OBJ_DATA *wield;
    PET_DATA *pEt;
	int resist = 0;
	USE *use;
    wield = get_eq_char( ch, WEAR_WIELD ); 
	use = get_obj_use(wield, UTYPE_WEAPON);
    if ( victim->position == POS_DEAD )
	return FALSE;

    /* damage reduction */
    if ( dam > 35)
	dam = (dam - 35)/2 + 35;
    if ( dam > 80)
	dam = (dam - 80)/2 + 80; 
    if ( dam > 0 && ch->levelflux > 0 )
        dam += levelflux_dam( ch );

    if ( victim != ch )
    {
	/*
	 * Certain attacks are forbidden.
	 * Most other attacks are returned.
	 */
	if ( is_safe( ch, victim ) )
	    return FALSE;
	check_killer( ch, victim );

	if ( victim->position > POS_STUNNED )
	{
	    if ( victim->fighting == NULL )
            {
		set_fighting( victim, ch );
               	if ( IS_NPC( victim ) && HAS_TRIGGER_MOB( victim, TRIG_KILL ) )
		    p_percent_trigger( victim, NULL, NULL, ch, NULL, NULL, TRIG_KILL );
            }

	    if (victim->timer <= 4)
	    	victim->position = POS_FIGHTING;
	}

	if ( victim->position > POS_STUNNED )
	{
	    if ( ch->fighting == NULL )
		set_fighting( ch, victim );
	}

	/*
	 * More charm stuff.
	 */
	if ( victim->master == ch )
	    stop_follower( victim );
    }


            
    if ( dam > 1 && !IS_NPC(victim) 
    &&   victim->pcdata->condition[COND_DRUNK]  > 10 )
	dam = 9 * dam / 10;

	
    immune = FALSE;


    /*
     * Check for parry, and dodge.
     */
    if ( dt >= TYPE_HIT && dt < TYPE_SPELL && ch != victim && (number_range(1,10) < 4 && IS_WEREWOLF(ch) ) )
    {
        if ( check_parry( ch, victim ) )
        {
            OBJ_DATA *tmp1 = get_eq_char(victim, WEAR_WIELD);
            OBJ_DATA *tmp2 = get_eq_char(victim, WEAR_SECONDARY);
            if (tmp1 != NULL)
                check_damage_obj (victim, tmp1, 1);
            if (tmp2 != NULL)
                check_damage_obj (victim, tmp2, 1);
            return FALSE;
        }        
	if ( check_dodge( ch, victim ) )
	    return FALSE;
	if ( check_shield_block(ch,victim))
        {
            check_damage_obj(victim, get_eq_char(victim, WEAR_SHIELD), 2);
            check_damage_obj(ch, wield, 2); 
            return FALSE;
        }      
        if ( check_steel_skin( ch, victim ) )
	    return FALSE;
        if ( check_phase( ch, victim) )
            return FALSE;
    
  }

    check_damage_obj(victim, NULL, 2);
    check_damage_obj(ch, wield, 2); 
	if(dt >= TYPE_HIT && dt < TYPE_SPELL ) 
		resist = attack_table[dam_type].damage;
	else if( dt >= TYPE_SPELL )
		resist = dam_type;
	else if(wield)
		resist = attack_table[use->value[3]].damage;
	else if(ch->wereform == MOON_FULL && ch->iswere)
  	     resist = attack_table[attack_lookup("claw")].damage;
	else
	    resist = ch->dam_type;	
	
	if(ch->resist[resist] != 0 )
		dam +=(int)(((float)dam)/(((float)dam)/((float)ch->resist[resist]/100)));
    if (show)
    	dam_message( ch, victim, dam, dt, immune );

    if (dam == 0)
	return FALSE;

    /*
     * Hurt the victim.
     * Inform the victim of his new state.
     */

       victim->hit -= dam;

    if ( !IS_NPC(victim)
    &&   victim->level >= LEVEL_IMMORTAL
    &&   victim->hit < 1 )
	victim->hit = 1;
    update_pos( victim );

    switch( victim->position )
    {
    case POS_MORTAL:
	act( "$n is mortally wounded, and will die soon, if not aided.",
	    victim, NULL, NULL, TO_ROOM );
	send_to_char( 
	    "You are mortally wounded, and will die soon, if not aided.\n\r",
	    victim );
	break;

    case POS_INCAP:
	act( "$n is incapacitated and will slowly die, if not aided.",
	    victim, NULL, NULL, TO_ROOM );
	send_to_char(
	    "You are incapacitated and will slowly die, if not aided.\n\r",
	    victim );
	break;

    case POS_STUNNED:
	act( "$n is stunned, but will probably recover.",
	    victim, NULL, NULL, TO_ROOM );
	send_to_char("You are stunned, but will probably recover.\n\r",
	    victim );
	break;

    case POS_DEAD:
	act( "$n is DEAD!!", victim, 0, 0, TO_ROOM );
	send_to_char( "You have been KILLED!!\n\r\n\r", victim );
	break;

    default:
	if ( dam > victim->max_hit / 4 )
	    send_to_char( "That really did HURT!\n\r", victim );
	if ( victim->hit < victim->max_hit / 4 )
	    send_to_char( "You sure are BLEEDING!\n\r", victim );
	break;
    }

    /*
     * Sleep spells and extremely wounded folks.
     */
    if ( !IS_AWAKE(victim) )
	stop_fighting( victim, FALSE );

    /*
     * Payoff for killing things.
     */
    if ( victim->position == POS_DEAD )
    {

        if (IS_IN_WAR(ch) && IS_IN_WAR(victim))
        {
            check_war(ch, victim);
            return TRUE;
        }

        if (!IS_NPC(ch) && !IS_NPC(victim) &&
            IS_SET(IN_ROOM(ch)->room_flags, ROOM_ARENA) &&
            IS_SET(IN_ROOM(victim)->room_flags, ROOM_ARENA))
        {
            stop_fighting(victim, TRUE);
            death_cry(victim);
            char_from_room(victim);
            char_to_room(victim, get_room_index(ROOM_VNUM_TEMPLE));
            victim->hit = UMAX(1, victim->hit);
            victim->mana = UMAX(1, victim->mana);
            victim->move = UMAX(1, victim->move);
            update_pos(victim);
            do_look(victim, "auto");
            if (IN_ROOM(ch)->area->nplayer == 1)        
            {
                send_to_char("You emerge victorious in the arena!\n\r", ch);
                stop_fighting(ch, TRUE);
                char_from_room(ch);
                char_to_room(ch, get_room_index(ROOM_VNUM_TEMPLE));
                ch->hit = ch->max_hit;
                ch->mana = ch->max_mana;
                ch->move = ch->max_move;
                update_pos(ch);
                do_look(ch, "auto");
            }
            return TRUE;
        }                     

	group_gain( ch, victim );

	if ( !IS_NPC(victim) )
	{
	    sprintf( log_buf, "%s killed by %s at %d",
		victim->name,
		(IS_NPC(ch) ? ch->short_descr : ch->name),
		IN_ROOM(ch)->vnum );
	    log_string( log_buf );

            info( victim, 0, "[INFO]: %s just got CrEaMeD by %s at %s!",
                victim->name, (IS_NPC(ch) ? ch->short_descr : ch->name), IN_ROOM(ch)->name );

	    /*
	     * Dying penalty:
	     * 2/3 way back to previous level.
	     */

	    if ( victim->exp > exp_per_level(victim,victim->pcdata->points) 
			       * victim->level )
	        gain_exp( victim, (2 * (exp_per_level(victim,victim->pcdata->points)
			         * victim->level - victim->exp)/3) + 50 );
         }

    if (!IS_NPC(victim))
    {
        if (IS_NPC(ch))
            victim->pcdata->gamestat[MOB_DEATHS]++;
        else
        {
            victim->pcdata->gamestat[PK_DEATHS]++;
            ch->pcdata->gamestat[PK_KILLS]++;
        }
    }
    if (IS_NPC(victim))
    {
        if (!IS_NPC(ch))
            ch->pcdata->gamestat[MOB_KILLS]++;
    }

        sprintf( log_buf, "%s got toasted by %s at %s [room %d]",
            (IS_NPC(victim) ? victim->short_descr : victim->name),
            (IS_NPC(ch) ? ch->short_descr : ch->name),
            IN_ROOM(ch)->name, IN_ROOM(ch)->vnum);
 
        if (IS_NPC(victim))
            wiznet(log_buf,NULL,NULL,WIZ_MOBDEATHS,0,0);
        else
            wiznet(log_buf,NULL,NULL,WIZ_DEATHS,0,0);

       	if ( IS_NPC( victim ) && HAS_TRIGGER_MOB( victim, TRIG_DEATH) )
	{
	    victim->position = POS_STANDING;
	    p_percent_trigger( victim, NULL, NULL, ch, NULL, NULL, TRIG_DEATH );
	}

        /* Make the head for a bountied PC */
        if(!IS_NPC(victim) && !IS_NPC(ch)
        && is_bountied(victim))
        {
            char buf[MAX_STRING_LENGTH];
            char *name;
            OBJ_DATA *obj;

            name = str_dup(victim->name);
            obj = create_object(get_obj_index(OBJ_VNUM_SEVERED_HEAD),0);

            obj->extra_flags |= ITEM_NODROP|ITEM_NOUNCURSE;

            sprintf(buf, "%s %s", "head", name);
            free_string( obj->name );
            obj->name = str_dup( buf);

            sprintf( buf, obj->short_descr, name );
            free_string( obj->short_descr );
            obj->short_descr = str_dup( buf );

            sprintf( buf, obj->description, name );
            free_string( obj->description );
            obj->description = str_dup( buf );

            obj_to_char(obj,ch);
            free_string(name);
        }

	raw_kill( victim, ch );
 
        if (IS_NPC(ch)) /* is a mob */
	{
	    if (!IS_NPC(victim)) 
		victim->pcdata->deaths_mob += 1;
	}
        else 
	{
	    if IS_NPC(victim)
	    {
		ch->pcdata->kills_mob += 1;
	    }
            else 
	    {
	 	victim->pcdata->deaths_pc += 1;
		ch->pcdata->kills_pc += 1;
            }
	}

        if IS_NPC(victim) 
        {
           if ( !IS_SET(victim->form,FORM_UNDEAD))
   	       check_spirit(ch,victim);
        }

        if ( IS_NPC(victim ) && IS_SET( victim->act, ACT_PET ) ) 
        {
           if ( IS_SET( victim->act, ACT_PET ) ) 
           {
               for ( pEt = pet_list; pEt != NULL; pEt = pEt->next )
               {
                    if ( !str_cmp( victim->name, pEt->name ) && !str_cmp( victim->powner, pEt->cname ) )
                        break;
               }
              
               if ( pEt == NULL )
               {
                   dead_pet( victim, pEt );
               }
           }    
        } 

        /* dump the flags */
        if (ch != victim && !IS_NPC(ch) && !is_same_clan(ch,victim))
        {
            if (IS_SET(victim->act,PLR_KILLER))
                REMOVE_BIT(victim->act,PLR_KILLER);
            else
                REMOVE_BIT(victim->act,PLR_THIEF);
        }

        /* RT new auto commands */

	if (!IS_NPC(ch)
	&&  (corpse = get_obj_list(ch,"corpse",IN_ROOM(ch)->contents)) != NULL
	&&  get_obj_use(corpse, UTYPE_CORPSE_NPC) && can_see_obj(ch,corpse))
	{
	    OBJ_DATA *coins;

	    corpse = get_obj_list( ch, "corpse", IN_ROOM(ch)->contents ); 

	    if ( IS_SET(ch->act, PLR_AUTOLOOT) &&
		 corpse && corpse->contains) /* exists and not empty */
            {
		do_function(ch, &do_get, "all corpse");
	    }

 	    if (IS_SET(ch->act,PLR_AUTOGOLD) &&
	        corpse && corpse->contains  && /* exists and not empty */
		!IS_SET(ch->act,PLR_AUTOLOOT))
	    {
		if ((coins = get_obj_list(ch,"gcash",corpse->contains))
		     != NULL)
		{
		    do_function(ch, &do_get, "all.gcash corpse");
	      	}
	    }
            
	    if (IS_SET(ch->act, PLR_AUTOSAC))
	    {
       	        if (IS_SET(ch->act,PLR_AUTOLOOT) && corpse && corpse->contains)
       	      	{
		    return TRUE;  /* leave if corpse has treasure */
	      	}
	        else
		{
		    do_function(ch, &do_sacrifice, "corpse");
		}
	    }
	}

	return TRUE;
    }

    if ( victim == ch )
	return TRUE;

    /*
     * Take care of link dead people.
     */
    if ( !IS_NPC(victim) && victim->desc == NULL )
    {
	if ( number_range( 0, victim->wait ) == 0 )
	{
	    do_function(victim, &do_recall, "" );
	    return TRUE;
	}
    }

    /*
     * Wimp out?
     */
    if ( IS_NPC(victim) && dam > 0 && victim->wait < PULSE_VIOLENCE / 2)
    {
	if ( ( IS_SET(victim->act, ACT_WIMPY) && number_bits( 2 ) == 0
	&&   victim->hit < victim->max_hit / 5) 
	&&     IN_ROOM(victim->master) != IN_ROOM(victim) )
	{
	    do_function(victim, &do_flee, "" );
	}
    }

    if ( !IS_NPC(victim)
    &&   victim->hit > 0
    &&   victim->hit <= victim->wimpy
    &&   victim->wait < PULSE_VIOLENCE / 2 )
    {
	do_function (victim, &do_flee, "" );
    }

    tail_chain( );
    return TRUE;
}

bool is_safe(CHAR_DATA *ch, CHAR_DATA *victim)
{
    if (IN_ROOM(victim) == NULL || IN_ROOM(ch) == NULL)
	return TRUE;

    if (victim->fighting == ch || victim == ch)
	return FALSE;

    if (IS_IMMORTAL(ch) && ch->level > LEVEL_IMMORTAL)
	return FALSE;

    /* killing mobiles */
    if (IS_NPC(victim))
    {

	/* safe room? */
	if (IS_SET(IN_ROOM(victim)->room_flags,ROOM_SAFE))
	{
	    send_to_char("Not in this room.\n\r",ch);
	    return TRUE;
	}

	if (victim->pIndexData->pShop != NULL)
	{
	    send_to_char("The shopkeeper wouldn't like that.\n\r",ch);
	    return TRUE;
	}

	/* no killing healers, trainers, etc */
	if (IS_SET(victim->act,ACT_TRAIN)
	||  IS_SET(victim->act,ACT_PRACTICE)
	||  IS_SET(victim->act,ACT_IS_HEALER)
	||  IS_SET(victim->act,ACT_IS_CHANGER))
	{
            printf_to_char( ch, "I don't think the Gods would approve.\n\r" );
	    return TRUE;
	}

	if (!IS_NPC(ch))
	{
	    /* no pets */
	    if (IS_SET(victim->act,ACT_PET))
	    {
		act("But $N looks so cute and cuddly...",
		    ch,NULL,victim,TO_CHAR);
		return TRUE;
	    }

	    /* no charmed creatures unless owner */
	    if (ch != victim->master)
	    {
		send_to_char("You don't own that monster.\n\r",ch);
		return TRUE;
	    }
	}
    }
    /* killing players */
    else
    {
	/* NPC doing the killing */
	if (IS_NPC(ch))
	{
	    /* safe room check */
	    if (IS_SET(IN_ROOM(victim)->room_flags,ROOM_SAFE))
	    {
		send_to_char("Not in this room.\n\r",ch);
		return TRUE;
	    }

            if (IS_SET(victim->comm2, COMM_AUTO_AFK ) )
            {
                send_to_char("Not while they are afk.\n\r", ch );
                return TRUE;
            }

	}
	/* player doing the killing */
	else
	{


	    if (IS_SET(victim->act,PLR_KILLER) || IS_SET(victim->act,PLR_THIEF))
		return FALSE;

	    if (!is_clan(victim))
	    {
		send_to_char("They aren't in a clan, leave them alone.\n\r",ch);
		return TRUE;
	    }

        if (IS_SET( victim->comm2, COMM_AUTO_AFK ) )
        {   send_to_char("Not while they are auto afk.\n\r", ch );
            return TRUE;
        }

	    if (ch->level > victim->level + 8)
	    {
		send_to_char("Pick on someone your own size.\n\r",ch);
		return TRUE;
	    }
	}
    }
    return FALSE;
}
 
bool is_safe_spell(CHAR_DATA *ch, CHAR_DATA *victim, bool area )
{
    if (IN_ROOM(victim) == NULL || IN_ROOM(ch) == NULL)
        return TRUE;

    if (victim == ch && area)
	return TRUE;

    if (victim->fighting == ch || victim == ch)
	return FALSE;

    if (IS_IMMORTAL(ch) && ch->level > LEVEL_IMMORTAL && !area)
	return FALSE;

    /* killing mobiles */
    if (IS_NPC(victim))
    {
	/* safe room? */
	if (IS_SET(IN_ROOM(victim)->room_flags,ROOM_SAFE))
	    return TRUE;

	if (victim->pIndexData->pShop != NULL)
	    return TRUE;

	/* no killing healers, trainers, etc */
	if (IS_SET(victim->act,ACT_TRAIN)
	||  IS_SET(victim->act,ACT_PRACTICE)
	||  IS_SET(victim->act,ACT_IS_HEALER)
	||  IS_SET(victim->act,ACT_IS_CHANGER))
	    return TRUE;

	if (!IS_NPC(ch))
	{
	    /* no pets */
	    if (IS_SET(victim->act,ACT_PET))
	   	return TRUE;

	    /* no charmed creatures unless owner */
	    if ( (area || ch != victim->master))
		return TRUE;

	    /* legal kill? -- cannot hit mob fighting non-group member */
	    if (victim->fighting != NULL && !is_same_group(ch,victim->fighting))
		return TRUE;
	}
	else
	{
	    /* area effect spells do not hit other mobs */
	    if (area && !is_same_group(victim,ch->fighting))
		return TRUE;
	}
    }
    /* killing players */
    else
    {
	if (area && IS_IMMORTAL(victim) && victim->level > LEVEL_IMMORTAL)
	    return TRUE;

	/* NPC doing the killing */
	if (IS_NPC(ch))
	{
	    /* charmed mobs and pets cannot attack players while owned */
	    if ( ch->master != NULL
	    &&  ch->master->fighting != victim)
		return TRUE;
	
	    /* safe room? */
	    if (IS_SET(IN_ROOM(victim)->room_flags,ROOM_SAFE))
		return TRUE;

	    /* legal kill? -- mobs only hit players grouped with opponent*/
	    if (ch->fighting != NULL && !is_same_group(ch->fighting,victim))
		return TRUE;
	}

	/* player doing the killing */
	else
	{

	    if (is_safe_war(ch, victim))
	    {
		send_to_char("They're on YOUR team.\n\r", ch);
		return TRUE;
	    }

	    if (IS_SET(IN_ROOM(victim)->room_flags, ROOM_ARENA))
		return FALSE;

	    if (is_safe_war(ch, victim))
		return TRUE;

	    if (IS_SET(IN_ROOM(victim)->room_flags, ROOM_ARENA))
		return FALSE;

        if (!is_clan(ch))
		return TRUE;

	    if (IS_SET(victim->act,PLR_KILLER) || IS_SET(victim->act,PLR_THIEF))
		return FALSE;

	    if (!is_clan(victim))
		return TRUE;

	    if (ch->level > victim->level + 8)
		return TRUE;
	}

    }
    return FALSE;
}
/*
 * See if an attack justifies a KILLER flag.
 */
void check_killer( CHAR_DATA *ch, CHAR_DATA *victim )
{
    char buf[MAX_STRING_LENGTH];

    if (IS_SET(IN_ROOM(ch)->room_flags, ROOM_ARENA))
	return;

    /*
     * Follow charm thread to responsible character.
     * Attacking someone's charmed char is hostile!
     */
    while (victim->master != NULL )
	victim = victim->master;

    /*
     * NPC's are fair game.
     * So are killers and thieves.
     */
    if ( IS_NPC(victim)
    ||   IS_SET(victim->act, PLR_KILLER)
    ||   IS_SET(victim->act, PLR_THIEF))
	return;


    /*
     * NPC's are cool of course (as long as not charmed).
     * Hitting yourself is cool too (bleeding).
     * So is being immortal (Alander's idea).
     * And current killers stay as they are.
     */
    if ( IS_NPC(ch)
    ||   ch == victim
    ||   ch->level >= LEVEL_IMMORTAL
    ||   !is_clan(ch)
    ||   IS_SET(ch->act, PLR_KILLER) 
    ||	 ch->fighting  == victim)
	return;

    send_to_char( "*** You are now a KILLER!! ***\n\r", ch );
    SET_BIT(ch->act, PLR_KILLER);
    sprintf(buf,"$N is attempting to murder %s",victim->name);
    wiznet(buf,ch,NULL,WIZ_FLAGS,0,0);
    save_char_obj( ch );
    return;
}



/*
 * Check for parry.
 */
bool check_parry( CHAR_DATA *ch, CHAR_DATA *victim )
{
    int chance;

    if ( !IS_AWAKE(victim) )
	return FALSE;

    chance = get_skill(victim,skill_lookup("parry")) / 2;

    if ( get_eq_char( victim, WEAR_WIELD ) == NULL )
    {
	if (IS_NPC(victim))
	    chance /= 2;
	else
	    return FALSE;
    }

    if (!can_see(ch,victim))
	chance /= 2;

    if ( number_percent( ) >= chance + victim->level - ch->level )
	return FALSE;

    act( "You parry $n's attack.",  ch, NULL, victim, TO_VICT    );
    act( "$N parries your attack.", ch, NULL, victim, TO_CHAR    );
    check_improve(victim,skill_lookup("parry"),TRUE,6);
    return TRUE;
}

/*
 * Check for shield block.
 */
bool check_shield_block( CHAR_DATA *ch, CHAR_DATA *victim )
{
    int chance;

    if ( !IS_AWAKE(victim) )
        return FALSE;


    chance = get_skill(victim,skill_lookup("shield block")) / 5 + 3;


    if ( get_eq_char( victim, WEAR_SHIELD ) == NULL )
        return FALSE;

    if ( number_percent( ) >= chance + victim->level - ch->level )
        return FALSE;

    act( "You block $n's attack with your shield.",  ch, NULL, victim, 
TO_VICT    );
    act( "$N blocks your attack with a shield.", ch, NULL, victim, 
TO_CHAR    );
    check_improve(victim,skill_lookup("shield block"),TRUE,6);
    return TRUE;
}


/*
 * Check for dodge.
 */
bool check_dodge( CHAR_DATA *ch, CHAR_DATA *victim )
{
    int chance;

    if ( !IS_AWAKE(victim) )
	return FALSE;

    if ( MOUNTED(victim) )
	return FALSE;


    chance = get_skill(victim,skill_lookup("dodge")) / 2;

    if (!can_see(victim,ch))
	chance /= 2;

    if ( number_percent( ) >= chance + victim->level - ch->level )
        return FALSE;

    xact_new( "You dodge $n's attack.", ch, NULL, victim, TO_VICT, POS_RESTING, SUPPRESS_DODGE    );
    xact_new( "$N dodges your attack.", ch, NULL, victim, TO_CHAR, POS_RESTING, SUPPRESS_DODGE    );
    check_improve(victim,skill_lookup("dodge"),TRUE,6);
    return TRUE;
}



/*
 * Set position of a victim.
 */
void update_pos( CHAR_DATA *victim )
{
    if ( victim->hit > 0 )
    {
    	if ( victim->position <= POS_STUNNED )
	    victim->position = POS_STANDING;
	return;
    }

    if ( IS_NPC(victim) && victim->hit < 1 )
    {
	victim->position = POS_DEAD;
	return;
    }

    if ( victim->hit <= -11 )
    {
	victim->position = POS_DEAD;
	return;
    }

         if ( victim->hit <= -6 ) victim->position = POS_MORTAL;
    else if ( victim->hit <= -3 ) victim->position = POS_INCAP;
    else                          victim->position = POS_STUNNED;

    return;
}



/*
 * Start fights.
 */
void set_fighting( CHAR_DATA *ch, CHAR_DATA *victim )
{
    if ( ch->fighting != NULL )
    {
	bug( "Set_fighting: already fighting", 0 );
	return;
    }

   ch->fighting = victim;
    ch->position = POS_FIGHTING;

    return;
}



/*
 * Stop fights.
 */
void stop_fighting( CHAR_DATA *ch, bool fBoth )
{
    CHAR_DATA *fch;

    for ( fch = char_list; fch != NULL; fch = fch->next )
    {
	if ( fch == ch || ( fBoth && fch->fighting == ch ) )
	{
	    fch->fighting	= NULL;
	    fch->position	= IS_NPC(fch) ? fch->default_pos : POS_STANDING;
	    update_pos( fch );
	}
    }

    return;
}



/*
 * Make a corpse out of a character.
 */
void make_corpse( CHAR_DATA *ch )
{
    char buf[MAX_STRING_LENGTH];
    OBJ_DATA *corpse;
    OBJ_DATA *obj;
    OBJ_DATA *obj_next;
    char *name;
    ROOM_INDEX_DATA *location;
    location = get_room_index ( ROOM_VNUM_MORGUE );

    if ( IS_NPC(ch) )
    {
	name		= ch->short_descr;
	corpse		= create_object(get_obj_index(OBJ_VNUM_CORPSE_NPC), 0);
	corpse->timer	= number_range( 3, 6 );
	if ( ch->gold > 0 )
	{
	    obj_to_obj( create_money( ch->gold, ch->silver ), corpse );
	    ch->gold = 0;
	    ch->silver = 0;
	}
	corpse->cost = 0;
    }
    else
    {
	name		= ch->name;
	corpse		= create_object(get_obj_index(OBJ_VNUM_CORPSE_PC), 0);
	corpse->timer	= number_range( 25, 40 );
	REMOVE_BIT(ch->act,PLR_CANLOOT);
	if (!is_clan(ch))
	    corpse->owner = str_dup(ch->name);
	else
	{
	    corpse->owner = NULL;
	    if (ch->gold > 1 || ch->silver > 1)
	    {
		obj_to_obj(create_money(ch->gold / 2, ch->silver/2), corpse);
		ch->gold -= ch->gold/2;
		ch->silver -= ch->silver/2;
	    }
	}
		
	corpse->cost = 0;
    }

    corpse->level = ch->level;

    sprintf( buf, corpse->short_descr, name );
    free_string( corpse->short_descr );
    corpse->short_descr = str_dup( buf );

    sprintf( buf, corpse->description, name );
    free_string( corpse->description );
    corpse->description = str_dup( buf );

    for ( obj = ch->carrying; obj != NULL; obj = obj_next )
    {
	bool floating = FALSE;

	obj_next = obj->next_content;
	if (obj->wear_loc == WEAR_FLOAT && !IS_OBJ2_STAT( obj, ITEM_RELIC) )
	    floating = TRUE;
	obj_from_char( obj );
	if (get_obj_use(obj, UTYPE_POTION) )
	    obj->timer = number_range(500,1000);
	if (get_obj_use(obj, UTYPE_SCROLL) )
	    obj->timer = number_range(1000,2500);
	if (IS_SET(obj->extra_flags,ITEM_ROT_DEATH) && !floating)
	{
	    obj->timer = number_range(5,10);
	    REMOVE_BIT(obj->extra_flags,ITEM_ROT_DEATH);
	}
	REMOVE_BIT(obj->extra_flags,ITEM_VIS_DEATH);

        if (IS_OBJ_STAT(obj, ITEM_AUCTIONED))
  	    continue;

	if ( IS_SET( obj->extra_flags, ITEM_INVENTORY ) )
	    extract_obj( obj );
	else if (floating)
	{
	    if (IS_OBJ_STAT(obj,ITEM_ROT_DEATH)) /* get rid of it! */
	    { 
		if (obj->contains != NULL)
		{
		    OBJ_DATA *in, *in_next;

		    act("$p evaporates,scattering its contents.",
			ch,obj,NULL,TO_ROOM);
		    for (in = obj->contains; in != NULL; in = in_next)
		    {
			in_next = in->next_content;
			obj_from_obj(in);
			obj_to_room(in,IN_ROOM(ch));
		    }
		 }
		 else
		    act("$p evaporates.",
			ch,obj,NULL,TO_ROOM);
		 extract_obj(obj);
	    }
	    else
	    {
		act("$p falls to the floor.",ch,obj,NULL,TO_ROOM);
		obj_to_room(obj,IN_ROOM(ch));
	    }
	}
	else
	    obj_to_obj( obj, corpse );
    }

    if (IS_SET(IN_ROOM(ch)->room_flags, ROOM_ARENA))
	return;

    if ( IS_NPC(ch) )
    {
        obj_to_room( corpse,IN_ROOM(ch) );

    }
    else
    {   obj_to_room( corpse,location );  
    }

    return;
}



/*
 * Improved Death_cry contributed by Diavolo.
 */
void death_cry( CHAR_DATA *ch )
{
    ROOM_INDEX_DATA *was_in_room;
    char *msg;
    int door;
    int vnum;
	USE *use;

    vnum = 0;
    msg = "You hear $n's death cry.";

    switch ( number_bits(4))
    {
    case  0: msg  = "$n hits the ground ... DEAD.";			break;
    case  1: 
	if (ch->material == 0)
	{
	    msg  = "$n splatters blood on your armor.";		
	    break;
	}
    case  2: 							
	if (IS_SET(ch->parts,PART_GUTS))
	{
	    msg = "$n spills $s guts all over the floor.";
	    vnum = OBJ_VNUM_GUTS;
	}
	break;
    case  3: 
	if (IS_SET(ch->parts,PART_HEAD))
	{
	    msg  = "$n's severed head plops on the ground.";
	    vnum = OBJ_VNUM_SEVERED_HEAD;				
	}
	break;
    case  4: 
	if (IS_SET(ch->parts,PART_HEART))
	{
	    msg  = "$n's heart is torn from $s chest.";
	    vnum = OBJ_VNUM_TORN_HEART;				
	}
	break;
    case  5: 
	if (IS_SET(ch->parts,PART_ARMS))
	{
	    msg  = "$n's arm is sliced from $s dead body.";
	    vnum = OBJ_VNUM_SLICED_ARM;				
	}
	break;
    case  6: 
	if (IS_SET(ch->parts,PART_LEGS))
	{
	    msg  = "$n's leg is sliced from $s dead body.";
	    vnum = OBJ_VNUM_SLICED_LEG;				
	}
	break;
    case 7:
	if (IS_SET(ch->parts,PART_BRAINS))
	{
	    msg = "$n's head is shattered, and $s brains splash all over you.";
	    vnum = OBJ_VNUM_BRAINS;
	}
    }

    act( msg, ch, NULL, NULL, TO_ROOM );

    if ( vnum != 0 )
    {
	char buf[MAX_STRING_LENGTH];
	OBJ_DATA *obj;
	char *name;

	name		= IS_NPC(ch) ? ch->short_descr : ch->name;
	obj		= create_object( get_obj_index( vnum ), 0 );
	obj->timer	= number_range( 4, 7 );

	sprintf( buf, obj->short_descr, name );
	free_string( obj->short_descr );
	obj->short_descr = str_dup( buf );

	sprintf( buf, obj->description, name );
	free_string( obj->description );
	obj->description = str_dup( buf );

	if ( ( use = get_obj_use(obj, UTYPE_FOOD) ) )
	{
	    if (IS_SET(ch->form,FORM_POISON))
		use->value[3] = 1;
	    else if (!IS_SET(ch->form,FORM_EDIBLE))
		{	if( use == obj->use_list )
			{	obj->use_list = obj->use_list->next;
				free_use(use);
			}

			{	USE *tmp;
				for(tmp = obj->use_list ; tmp ; tmp = tmp->next );
				{	if(tmp->next == use )
					{	tmp->next = use->next;
						free_use(use);
					}
				}
			}
			use = new_use();
			use->use_type = UTYPE_TRASH;
			use_to_obj( obj, use);
		}

	}

	obj_to_room( obj, IN_ROOM(ch) );
    }

    if ( IS_NPC(ch) )
	msg = "You hear something's death cry.";
    else
	msg = "You hear someone's death cry.";

    was_in_room = IN_ROOM(ch);
    for ( door = 0; door <= 5; door++ )
    {
	EXIT_DATA *pexit;

	if ( ( pexit = (*(was_in_room->exit))[door] ) != NULL
	&&   pexit->u1.to_room != NULL
	&&   pexit->u1.to_room != was_in_room )
	{
	    act( msg, ch, NULL, NULL, TO_ROOM );
	}
    }

    return;
}



void raw_kill( CHAR_DATA *victim, CHAR_DATA *killer )
{
    int i;

    stop_fighting( victim, TRUE );
    death_cry( victim );
    make_corpse( victim );

    if (!IS_NPC( victim ) )
    {
        victim->pcdata->condition[COND_HUNGER] = 24;   
        victim->pcdata->condition[COND_THIRST] = 30;
    } 

    if (!IS_NPC (victim))
    { 
      if (IS_NPC(killer))  
      {
        kill_table[URANGE (0, killer->level, MAX_LEVEL - 1)].kills++;
        killer->pIndexData->kills++;
      }
    }
    else
    {
	victim->pIndexData->killed++;
	kill_table[URANGE(0, victim->level, MAX_LEVEL-1)].killed++;
	extract_char( victim, TRUE );
	return;
    } 

    extract_char( victim, FALSE );
    while ( victim->affected )
	affect_remove( victim, victim->affected );
    victim->affected_by	= race_table[victim->race].aff;
    for (i = 0; i < 4; i++)
    	victim->armor[i]= 100;
    victim->position	= POS_RESTING;
    victim->hit		= UMAX( 1, victim->hit  );
    victim->mana	= UMAX( 1, victim->mana );
    victim->move	= UMAX( 1, victim->move );
    victim->turned 	= FALSE;
    return;
}



void group_gain( CHAR_DATA *ch, CHAR_DATA *victim )
{
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *gch;
    CHAR_DATA *lch;
    int xp;
    int members;
    int group_levels;


    /*
     * Monsters don't get kill xp's or alignment changes.
     * P-killing doesn't help either.
     * Dying of mortal wounds or poison doesn't give xp to anyone!
     */
    if ( victim == ch )
	return;
    
    members = 0;
    group_levels = 0;
    for ( gch = IN_ROOM(ch)->people; gch != NULL; gch = gch->next_in_room )
    {
	if ( is_same_group( gch, ch ) )
        {
	    members++;
	    group_levels += IS_NPC(gch) ? gch->level / 2 : gch->level;
	}
    }

    if ( members == 0 )
    {
	bug( "Group_gain: members.", members );
	members = 1;
	group_levels = ch->level ;
    }

    lch = (ch->leader != NULL) ? ch->leader : ch;

    for ( gch = IN_ROOM(ch)->people; gch != NULL; gch = gch->next_in_room )
    {
	OBJ_DATA *obj;
	OBJ_DATA *obj_next;

	if ( !is_same_group( gch, ch ) || (IS_NPC(gch) && !IS_SET( gch->act, ACT_PET ) ) )
	    continue;

	xp = xp_compute( gch, victim, group_levels ); 
    if(members > 3 )
		xp /= members;
        if ( !IS_NPC(gch) && ch->level < LEVEL_HERO && !IS_SET( gch->comm2, COMM_AUTOLEVEL ) && gch->pcdata->current_exp >= exp_per_level( gch, gch->pcdata->points ) * 6 )
            send_to_char("Please go and level at the healer!\n\r", gch );

        else
	{
	    sprintf( buf, "You receive %d experience points.\n\r", xp );
	    send_to_char( buf, gch );
	    gain_exp( gch, xp );
	}

	for ( obj = gch->carrying; obj != NULL; obj = obj_next )
	{
	    obj_next = obj->next_content;
	    if ( obj->wear_loc == WEAR_NONE )
		continue;

            if ( IS_OBJ2_STAT(obj, ITEM_RELIC) && obj->xp_tolevel > 0 ) 
				if ( number_range(0, 1) == 1 ) 
					gain_object_exp( ch, obj, xp );
                         
	    if ( ( IS_OBJ_STAT(obj, ITEM_ANTI_EVIL)    && IS_EVIL(gch) )
	    ||   ( IS_OBJ_STAT(obj, ITEM_ANTI_GOOD)    && IS_GOOD(gch) )
	    ||   ( IS_OBJ_STAT(obj, ITEM_ANTI_NEUTRAL) && IS_NEUTRAL(gch) ) )
	    {
		act( "You are zapped by $p.", gch, obj, NULL, TO_CHAR );
		act( "$n is zapped by $p.",   gch, obj, NULL, TO_ROOM );
		obj_from_char( obj );
         
                if ( IS_OBJ_STAT(obj,ITEM_NODROP) )
                   obj_to_char( obj, gch );
                else
	 	   obj_to_room( obj, IN_ROOM(gch) );
	    }
	}
    }

    return;
}



/*
 * Compute xp for a kill.
 * Also adjust alignment of killer.
 * Edit this function to change xp computations.
 */
int xp_compute( CHAR_DATA *gch, CHAR_DATA *victim, int total_levels )
{
    int xp,base_exp;
    int align,level_range;
    int time_per_level;
    int bonus;

    level_range = victim->level - gch->level;
 
    /* compute the base exp */
    switch (level_range)
    {
 	default : 	base_exp =   0;		break;
	case -9 :	base_exp =   1;		break;
	case -8 :	base_exp =   2;		break;
	case -7 :	base_exp =   5;		break;
	case -6 : 	base_exp =   9;		break;
	case -5 :	base_exp =  11;		break;
	case -4 :	base_exp =  22;		break;
	case -3 :	base_exp =  33;		break;
	case -2 :	base_exp =  50;		break;
	case -1 :	base_exp =  66;		break;
	case  0 :	base_exp =  83;		break;
	case  1 :	base_exp =  99;		break;
	case  2 :	base_exp = 121;		break;
	case  3 :	base_exp = 143;		break;
	case  4 :	base_exp = 165;		break;
    } 
    
    if (level_range > 4)
	base_exp = 160 + 20 * (level_range - 4);

    if(IS_NPC(victim) )/* at max a mob with all of these is worth 5 levels above their own*/
    {

       if( victim->spec_fun != 0 )
       {
          if(   !str_cmp(spec_name(victim->spec_fun),"spec_breath_any")
             || !str_cmp(spec_name(victim->spec_fun),"spec_breath_acid")
             || !str_cmp(spec_name(victim->spec_fun),"spec_breath_fire")
             || !str_cmp(spec_name(victim->spec_fun),"spec_breath_frost")
             || !str_cmp(spec_name(victim->spec_fun),"spec_breath_gas")
             || !str_cmp(spec_name(victim->spec_fun),"spec_breath_lightning") )
             base_exp = (base_exp * 125) / 100;
           
          else if(   !str_cmp(spec_name(victim->spec_fun),"spec_cast_cleric")
                  || !str_cmp(spec_name(victim->spec_fun),"spec_cast_mage")
                  || !str_cmp(spec_name(victim->spec_fun),"spec_cast_undead") ) 
                base_exp = (base_exp * 120) / 100;
         
          else if( !str_cmp(spec_name(victim->spec_fun),"spec_poison") )
                base_exp = (base_exp * 110) / 100;
       }
    }

    /* do alignment computations */
   
    align = victim->alignment - gch->alignment;

    if (IS_SET(victim->act,ACT_NOALIGN))
    {
	/* no change */
    }

    
    /* calculate exp multiplier */
    if (IS_SET(victim->act,ACT_NOALIGN))
	xp = base_exp;

    else if (gch->alignment > 500)  /* for goodie two shoes */
    {
	if (victim->alignment < -750)
	    xp = (base_exp *4)/3;
   
 	else if (victim->alignment < -500)
	    xp = (base_exp * 5)/4;

        else if (victim->alignment > 750)
	    xp = base_exp / 4;

   	else if (victim->alignment > 500)
	    xp = base_exp / 2;

        else if (victim->alignment > 250)
	    xp = (base_exp * 3)/4; 

	else
	    xp = base_exp;
    }

    else if (gch->alignment < -500) /* for baddies */
    {
	if (victim->alignment > 750)
	    xp = (base_exp * 5)/4;
	
  	else if (victim->alignment > 500)
	    xp = (base_exp * 11)/10; 

   	else if (victim->alignment < -750)
	    xp = base_exp/2;

	else if (victim->alignment < -500)
	    xp = (base_exp * 3)/4;

	else if (victim->alignment < -250)
	    xp = (base_exp * 9)/10;

	else
	    xp = base_exp;
    }

    else if (gch->alignment > 200)  /* a little good */
    {

	if (victim->alignment < -500)
	    xp = (base_exp * 6)/5;

 	else if (victim->alignment > 750)
	    xp = base_exp/2;

	else if (victim->alignment > 0)
	    xp = (base_exp * 3)/4; 
	
	else
	    xp = base_exp;
    }

    else if (gch->alignment < -200) /* a little bad */
    {
	if (victim->alignment > 500)
	    xp = (base_exp * 6)/5;
 
	else if (victim->alignment < -750)
	    xp = base_exp/2;

	else if (victim->alignment < 0)
	    xp = (base_exp * 3)/4;

	else
	    xp = base_exp;
    }

    else /* neutral */
    {

	if (victim->alignment > 500 || victim->alignment < -500)
	    xp = (base_exp * 4)/3;

	else if (victim->alignment < 200 && victim->alignment > -200)
	    xp = base_exp/2;

 	else
	    xp = base_exp;
    }

    /* more exp at the low levels */
    if (gch->level < 70)
    	xp = 10 * xp / (gch->level + 4);
 
    /* reduce for playing time */
    
    {
	/* compute quarter-hours per level */
	time_per_level = 4 *
			 (gch->played + (int) (current_time - gch->logon))/3600
			 / gch->level;

	time_per_level = URANGE(5,time_per_level,15);
	if (gch->level < 25)  /* make it a curve */
	    time_per_level = UMAX(time_per_level,(15 - gch->level));
	xp = xp * time_per_level / 4;
    }
   
    /* randomize the rewards */
    xp = number_range (xp * 3/4, xp * 5/4);

    /* adjust for grouping */
    xp = xp * gch->level/( UMAX(1,total_levels -1) );

    bonus = xp;

    if (double_exp)
    {
        xp += bonus;
    }

    return xp;
}


void dam_message( CHAR_DATA *ch, CHAR_DATA *victim,int dam,int dt,bool immune )
{
    char buf1[256], buf2[256], buf3[256];
    const char *vs;
    const char *vp;
    const char *attack;
    char punct;

    if (ch == NULL || victim == NULL)
	return;

/*	 if ( dam ==   0 ) { vs = "miss";	vp = "misses";		}
    else if ( dam <=   4 ) { vs = "scratch";vp = "scratches";	}
    else if ( dam <=   8 ) { vs = "graze";	vp = "grazes";		}
    else if ( dam <=  12 ) { vs = "hit";	vp = "hits";		}
    else if ( dam <=  16 ) { vs = "injure";	vp = "injures";		}
    else if ( dam <=  20 ) { vs = "wound";	vp = "wounds";		}
    else if ( dam <=  24 ) { vs = "maul";   vp = "mauls";		}
    else if ( dam <=  28 ) { vs = "decimate";vp = "decimates";	}
    else if ( dam <=  32 ) { vs = "devastate";vp = "devastates";	}
    else if ( dam <=  36 ) { vs = "maim";	vp = "maims";		}
    else if ( dam <=  44 ) { vs = "MUTILATE";vp = "MUTILATES";	}
    else if ( dam <=  48 ) { vs = "DISEMBOWEL";vp = "DISEMBOWELS";	}
    else if ( dam <=  52 ) { vs = "DISMEMBER";vp = "DISMEMBERS";	}
    else if ( dam <=  56 ) { vs = "MASSACRE";vp = "MASSACRES";	}
    else if ( dam <=  60 ) { vs = "MANGLE";	vp = "MANGLES";		}
    else if ( dam <=  65 ) { vs = "*** MASSACRE ***";                            
                             vp = "*** MASSACRES ***";                  }
    else if ( dam <=  75 ) { vs = "*** DEVASTATE ***";
			     vp = "*** DEVASTATES ***";  		}
    else if ( dam <= 100 ) { vs = "*** DEMOLISH ***";
                             vp = "*** DEMOLISHES ***";                 }   
    else if ( dam <= 125)  { vs = "*** OBLITERATE ***";
			     vp = "*** OBLITERATES ***";		}
    else if ( dam <= 150)  { vs = ">>> ANNIHILATE <<<";
			     vp = ">>> ANNIHILATES <<<";		}
    else if ( dam <= 200)  { vs = "<<< ERADICATE >>>";
			     vp = "<<< ERADICATES >>>";			}
    else if ( dam <= 300)  { vs = "<--> VAPORIZE <-->";
                             vp = "<--> VAPORIZES <-->";      }    
    else if ( dam <= 400)  { vs = "<*><*><*> ELIMINATE <*><*><*>";
                             vp = "<*><*><*> ELIMINATES <*><*><*>";     }     
    else if ( dam <= 500)  { vs = "<*><*><*> DESTROY <*><*><*>";             
                             vp = "<*><*><*> DESTROYS <*><*><*>";       }
    else if ( dam <= 600 ) { vs = "<+><+><+> DISINTEGRATE <+><+><+>";
                             vp = "<+><+><+> DISINTEGRATES <+><+><+>";      }     
    else if ( dam <= 700 ) { vs = "_\\|/__\\|/_EXTERMINATE _\\|/__\\|/_";
                             vp = "_\\|/__\\|/_EXTERMINATES _\\|/__\\|/_"; }   
    else                   { vs = "do UnImAgInAbLE things to";
			     vp = "does UnImAgInAbLE things to";		}
*/

			 if ( dam ==   0 ) { vs = "miss";	vp = "misses";		}
    else if ( dam <=   4 ) { vs = "scratch";	vp = "scratches";	}
    else if ( dam <=   8 ) { vs = "graze";	vp = "grazes";		}
    else if ( dam <=  12 ) { vs = "hit";	vp = "hits";		}
    else if ( dam <=  16 ) { vs = "injure";	vp = "injures";		}
    else if ( dam <=  20 ) { vs = "wound";	vp = "wounds";		}
    else if ( dam <=  30 ) { vs = "maul";       vp = "mauls";		}
    else if ( dam <=  35 ) { vs = "decimate";	vp = "decimates";	}
    else if ( dam <=  45 ) { vs = "devastate";	vp = "devastates";	}
    else if ( dam <=  50 ) { vs = "maim";	vp = "maims";		}
    else if ( dam <=  55 ) { vs = "MUTILATE";	vp = "MUTILATES";	}
    else if ( dam <=  65 ) { vs = "DISEMBOWEL";	vp = "DISEMBOWELS";	}
    else if ( dam <=  75 ) { vs = "DISMEMBER";	vp = "DISMEMBERS";	}
    else if ( dam <=  80 ) { vs = "MASSACRE";	vp = "MASSACRES";	}
    else if ( dam <=  95 ) { vs = "MANGLE";	vp = "MANGLES";		}
    else if ( dam <=  125 ) { vs = "*** DEMOLISH ***";
			     vp = "*** DEMOLISHES ***";			}
    else if ( dam <=  250 ) { vs = "*** DEVASTATE ***";
			     vp = "*** DEVASTATES ***";			}
    else if ( dam <= 500)  { vs = "=== OBLITERATE ===";
			     vp = "=== OBLITERATES ===";		}
    else if ( dam <= 750)  { vs = ">>> ANNIHILATE <<<";
			     vp = ">>> ANNIHILATES <<<";		}
    else if ( dam <= 1000)  { vs = "<<< ERADICATE >>>";
			     vp = "<<< ERADICATES >>>";			}
    else                   { vs = "do UNSPEAKABLE things to";
			     vp = "does UNSPEAKABLE things to";		}

    punct   = (dam <= 24) ? '.' : '!';

    if(dt == TYPE_UNDEFINED  )
       dt = TYPE_HIT;

    if ( dt == TYPE_HIT )
    {
	if (ch  == victim)
	{
	    sprintf( buf1, "$n %s $melf%c",vp,punct);
	    sprintf( buf2, "You %s yourself%c",vs,punct);
	}
	else
	{
	    sprintf( buf1, "$n %s $N%c [%d]",  vp, punct, dam );
	    sprintf( buf2, "You %s $N%c [%d]", vs, punct, dam );
	    sprintf( buf3, "$n %s you%c [%d]", vp, punct, dam );
	}
    }
    else
    {
	if ( dt >= 0 && dt < MAX_SKILL )
	    attack	= skill_table[dt].noun_damage;
	else if ( dt >= TYPE_HIT && dt < TYPE_SPELL
	&& dt < TYPE_HIT + MAX_DAMAGE_MESSAGE) 
	    attack	= attack_table[dt - TYPE_HIT].noun;
	else if ( dt >= TYPE_SPELL )
		attack = spell_table[dt-TYPE_SPELL].name;
	else
	{
	    if(dt != 1000 )
	    {   bug( "Dam_message: bad dt %d.", dt );
	    	dt  = TYPE_HIT;
	    	attack  = attack_table[0].name;
	    }
	}

	if (immune)
	{
	    if (ch == victim)
	    {
		sprintf(buf1,"$n is unaffected by $s own %s.",attack);
		sprintf(buf2,"Luckily, you are immune to that.");
	    } 
	    else
	    {
	    	sprintf(buf1,"$N is unaffected by $n's %s!",attack);
	    	sprintf(buf2,"$N is unaffected by your %s!",attack);
	    	sprintf(buf3,"$n's %s is powerless against you.",attack);
	    }
	}

	else
	{
          if ( IS_SET(ch->act, PLR_AUTODAMAGE))
          {
	    if (ch == victim )
	    {
		sprintf( buf1, "$n's %s %s $m%c [%d]",attack,vp,punct, dam);
		sprintf( buf2, "Your %s %s you%c [%d]",attack,vp,punct, dam);
	    }

            else
            {
	    	sprintf( buf1, "$n's %s %s $N%c [%d]",  attack, vp, punct, 
dam 
);
	    	sprintf( buf2, "Your %s %s $N%c [%d]", attack, vp, punct, 
dam );
	    	sprintf( buf3, "$n's %s %s you%c [%d]", attack, vp, punct, 
dam );
	    }
          }

          else 
          {
            if ( ch == victim )
            {
		sprintf( buf1, "$n's %s %s $m%c",attack,vp,punct );
		sprintf( buf2, "Your %s %s you%c",attack,vp,punct );
            }

            else
            {
	        sprintf( buf1, "$n's %s %s $N%c [%d]",  attack, vp, punct, dam);
    	        sprintf( buf2, "Your %s %s $N%c [%d]",  attack, vp, punct, dam);
                sprintf( buf3, "$n's %s %s you%c [%d]", attack, vp, punct, dam);
            }
          }
        }
    }

    if (ch == victim)
    {
	act(buf1,ch,NULL,NULL,TO_ROOM);
	act(buf2,ch,NULL,NULL,TO_CHAR);
    }

    else
    {
    	act( buf1, ch, NULL, victim, TO_NOTVICT );
    	act( buf2, ch, NULL, victim, TO_CHAR );
    	act( buf3, ch, NULL, victim, TO_VICT );
    }

    return;
}



/*
 * Disarm a creature.
 * Caller must check for successful attack.
 */
void disarm( CHAR_DATA *ch, CHAR_DATA *victim )
{
    OBJ_DATA *obj;

    if ( ( obj = get_eq_char( victim, WEAR_WIELD ) ) == NULL )
	return;

    if ( IS_OBJ_STAT(obj,ITEM_NOREMOVE) || IS_OBJ_STAT( obj, ITEM_RELIC ) )
    {
	act("$S weapon won't budge!",ch,NULL,victim,TO_CHAR);
	act("$n tries to disarm you, but your weapon won't budge!",
	    ch,NULL,victim,TO_VICT);
	act("$n tries to disarm $N, but fails.",ch,NULL,victim,TO_NOTVICT);
	return;
    }

    act( "$n DISARMS you and sends your weapon flying!", 
	 ch, NULL, victim, TO_VICT    );
    act( "You disarm $N!",  ch, NULL, victim, TO_CHAR    );
    act( "$n disarms $N!",  ch, NULL, victim, TO_NOTVICT );

    obj_from_char( obj );
    if ( IS_OBJ_STAT(obj,ITEM_NODROP) || IS_OBJ_STAT(obj,ITEM_INVENTORY) ||
	IS_SET(IN_ROOM(victim)->room_flags, ROOM_ARENA) )
	obj_to_char( obj, victim );
    else
    {
	obj_to_room( obj, IN_ROOM(victim) );
	if (IS_NPC(victim) && victim->wait == 0 && can_see_obj(victim,obj))
	    get_obj(victim,obj,NULL);
    }

    return;
}

void do_bash( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    int chance;

    one_argument(argument,arg);
 
    if ( (chance = get_skill(ch,skill_lookup("bash"))) == 0
    ||	 (IS_NPC(ch) && !IS_SET(ch->off_flags,OFF_BASH))
    ||	 (!IS_NPC(ch)
    &&	  !can_use_skpell(ch, skill_lookup("bash"))))
    {	
	send_to_char("Bashing? What's that?\n\r",ch);
	return;
    }
 
    if (arg[0] == '\0')
    {
	victim = ch->fighting;
	if (victim == NULL)
	{
	    send_to_char("But you aren't fighting anyone!\n\r",ch);
	    return;
	}
    }
    if ( MOUNTED(ch) )
    {
        send_to_char("You can't bash while riding!\n\r", ch);
        return;
    }
 
    else if ((victim = get_char_room(ch, NULL, arg)) == NULL)
    {
	send_to_char("They aren't here.\n\r",ch);
	return;
    }

    if (victim->position < POS_FIGHTING)
    {
	act("You'll have to let $M get back up first.",ch,NULL,victim,TO_CHAR);
	return;
    } 

    if (victim == ch)
    {
	send_to_char("You try to bash your brains out, but fail.\n\r",ch);
	return;
    }

    if (is_safe(ch,victim))
	return;


    /* modifiers */

    /* size  and weight */
    chance += ch->carry_weight / 250;
    chance -= victim->carry_weight / 200;

    if (ch->size < victim->size)
	chance += (ch->size - victim->size) * 15;
    else
	chance += (ch->size - victim->size) * 10; 


    /* stats */
    chance += get_curr_stat(ch,STAT_STR);
    chance -= (get_curr_stat(victim,STAT_DEX) * 4)/3;
    chance -= GET_AC(victim,AC_BASH) /25;
    /* speed */
    if (IS_SET(ch->off_flags,OFF_FAST) )
        chance += 10;
    if (IS_SET(victim->off_flags,OFF_FAST) )
        chance -= 30;

    /* level */
    chance += (ch->level - victim->level);

    if (!IS_NPC(victim) 
	&& chance < get_skill(victim,skill_lookup("dodge")) )
    {	/*
        act("$n tries to bash you, but you dodge it.",ch,NULL,victim,TO_VICT);
        act("$N dodges your bash, you fall flat on your face.",ch,NULL,victim,TO_CHAR);
        WAIT_STATE(ch,skill_table[skill_lookup("bash")].beats);
        return;*/
	chance -= 3 * (get_skill(victim,skill_lookup("dodge")) - chance);
    }

    /* now the attack */
    if (number_percent() < chance )
    {
    
	act("$n sends you sprawling with a powerful bash!",
		ch,NULL,victim,TO_VICT);
	act("You slam into $N, and send $M flying!",ch,NULL,victim,TO_CHAR);
	act("$n sends $N sprawling with a powerful bash.",
		ch,NULL,victim,TO_NOTVICT);
	check_improve(ch,skill_lookup("bash"),TRUE,1);

	DAZE_STATE(victim, 3 * PULSE_VIOLENCE);
	WAIT_STATE(ch,skill_table[skill_lookup("bash")].beats);
	victim->position = POS_RESTING;
	damage(ch,victim,number_range(2,4 + 4 * ch->size + chance/20),skill_lookup("bash"),
	    DAM_BASH,FALSE);

        if (RIDDEN(victim))
    	{
            mount_success(RIDDEN(victim), victim, FALSE);
        }	
	
    }
    else
    {
	damage(ch,victim,0,skill_lookup("bash"),DAM_BASH,FALSE);
	act("You fall flat on your face!",
	    ch,NULL,victim,TO_CHAR);
	act("$n falls flat on $s face.",
	    ch,NULL,victim,TO_NOTVICT);
	act("You evade $n's bash, causing $m to fall flat on $s face.",
	    ch,NULL,victim,TO_VICT);
	check_improve(ch,skill_lookup("bash"),FALSE,1);
	ch->position = POS_RESTING;
	WAIT_STATE(ch,skill_table[skill_lookup("bash")].beats * 3/2); 
    }
	check_killer(ch,victim);
}

void do_dirt( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    int chance;

    one_argument(argument,arg);

    if ( (chance = get_skill(ch,skill_lookup("dirt"))) == 0
    ||   (IS_NPC(ch) && !IS_SET(ch->off_flags,OFF_KICK_DIRT))
    ||   (!IS_NPC(ch)
    &&    !can_use_skpell(ch, skill_lookup("dirt"))))
    {
	send_to_char("You get your feet dirty.\n\r",ch);
	return;
    }

    if (arg[0] == '\0')
    {
	victim = ch->fighting;
	if (victim == NULL)
	{
	    send_to_char("But you aren't in combat!\n\r",ch);
	    return;
	}
    }

    if ( MOUNTED(ch) )
    {
        send_to_char("You can't dirt while riding!\n\r", ch);
        return;
    }


    else if ((victim = get_char_room(ch, NULL, arg)) == NULL)
    {
	send_to_char("They aren't here.\n\r",ch);
	return;
    }

    if (victim == ch)
    {
	send_to_char("Very funny.\n\r",ch);
	return;
    }

    if (is_safe(ch,victim))
	return;


    /* modifiers */

    /* dexterity */
    chance += get_curr_stat(ch,STAT_DEX);
    chance -= 2 * get_curr_stat(victim,STAT_DEX);

    /* speed  */
    if (IS_SET(ch->off_flags,OFF_FAST))
	chance += 10;
    if (IS_SET(victim->off_flags,OFF_FAST) )
	chance -= 25;

    /* level */
    chance += (ch->level - victim->level) * 2;

    /* sloppy hack to prevent false zeroes */
    if (chance % 5 == 0)
	chance += 1;

    /* terrain */

    switch(IN_ROOM(ch)->sector_type)
    {
	case(SECT_INSIDE):		chance -= 20;	break;
	case(SECT_CITY):		chance -= 10;	break;
	case(SECT_FIELD):		chance +=  5;	break;
	case(SECT_FOREST):				break;
	case(SECT_HILLS):				break;
	case(SECT_MOUNTAIN):		chance -= 10;	break;
	case(SECT_WATER_SWIM):		chance  =  0;	break;
	case(SECT_WATER_NOSWIM):	chance  =  0;	break;
	case(SECT_AIR):			chance  =  0;  	break;
	case(SECT_DESERT):		chance += 10;   break;
    }

    if (chance == 0)
    {
	send_to_char("There isn't any dirt to kick.\n\r",ch);
	return;
    }

    /* now the attack */
    if (number_percent() < chance)
    {
	act("$n is blinded by the dirt in $s eyes!",victim,NULL,NULL,TO_ROOM);
	act("$n kicks dirt in your eyes!",ch,NULL,victim,TO_VICT);
        damage(ch,victim,number_range(2,5),skill_lookup("dirt"),DAM_NONE,FALSE);
	send_to_char("You can't see a thing!\n\r",victim);
	check_improve(ch,skill_lookup("dirt"),TRUE,2);
	WAIT_STATE(ch,skill_table[skill_lookup("dirt")].beats);
    }
    else
    {
	damage(ch,victim,0,skill_lookup("dirt"),DAM_NONE,TRUE);
	check_improve(ch,skill_lookup("dirt"),FALSE,2);
	WAIT_STATE(ch,skill_table[skill_lookup("dirt")].beats);
    }
	check_killer(ch,victim);
}

void do_trip( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    int chance;

    one_argument(argument,arg);

    if ( (chance = get_skill(ch,skill_lookup("trip"))) == 0
    ||   (IS_NPC(ch) && !IS_SET(ch->off_flags,OFF_TRIP))
    ||   (!IS_NPC(ch) 
	  && !can_use_skpell(ch, skill_lookup("trip"))))
    {
	send_to_char("Tripping?  What's that?\n\r",ch);
	return;
    }


    if (arg[0] == '\0')
    {
	victim = ch->fighting;
	if (victim == NULL)
	{
	    send_to_char("But you aren't fighting anyone!\n\r",ch);
	    return;
 	}
    }

    else if ((victim = get_char_room(ch, NULL, arg)) == NULL)
    {
	send_to_char("They aren't here.\n\r",ch);
	return;
    }

    if ( MOUNTED(ch) )
    {
        send_to_char("You can't trip while riding!\n\r", ch);
        return;
    }


    if (is_safe(ch,victim))
	return;

    
    if (victim->position < POS_FIGHTING)
    {
	act("$N is already down.",ch,NULL,victim,TO_CHAR);
	return;
    }

    if (victim == ch)
    {
	send_to_char("You fall flat on your face!\n\r",ch);
	WAIT_STATE(ch,2 * skill_table[skill_lookup("trip")].beats);
	act("$n trips over $s own feet!",ch,NULL,NULL,TO_ROOM);
	return;
    }

    /* modifiers */

    /* size */
    if (ch->size < victim->size)
        chance += (ch->size - victim->size) * 10;  /* bigger = harder to trip */

    /* dex */
    chance += get_curr_stat(ch,STAT_DEX);
    chance -= get_curr_stat(victim,STAT_DEX) * 3 / 2;

    /* speed */
    if (IS_SET(ch->off_flags,OFF_FAST))
	chance += 10;
    if (IS_SET(victim->off_flags,OFF_FAST))
	chance -= 20;

    /* level */
    chance += (ch->level - victim->level) * 2;


    /* now the attack */
    if (number_percent() < chance)
    {
	act("$n trips you and you go down!",ch,NULL,victim,TO_VICT);
	act("You trip $N and $N goes down!",ch,NULL,victim,TO_CHAR);
	act("$n trips $N, sending $M to the ground.",ch,NULL,victim,TO_NOTVICT);
	check_improve(ch,skill_lookup("trip"),TRUE,1);

	DAZE_STATE(victim,2 * PULSE_VIOLENCE);
        WAIT_STATE(ch,skill_table[skill_lookup("trip")].beats);
	victim->position = POS_RESTING;
	damage(ch,victim,number_range(2, 2 +  2 * victim->size),skill_lookup("trip"),
	    DAM_BASH,TRUE);
    }
    else
    {
	damage(ch,victim,0,skill_lookup("trip"),DAM_BASH,TRUE);
	WAIT_STATE(ch,skill_table[skill_lookup("trip")].beats*2/3);
	check_improve(ch,skill_lookup("trip"),FALSE,1);
    } 
	check_killer(ch,victim);
}



void do_kill( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Kill whom?\n\r", ch );
	return;
    }

    if ( ( victim = get_char_room( ch, NULL, arg ) ) == NULL )
    {
	send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( victim == ch )
    {
	send_to_char( "You hit yourself.  Ouch!\n\r", ch );
	multi_hit( ch, ch, TYPE_UNDEFINED );
	return;
    }

    if ( is_safe( ch, victim ) )
	return;


    if ( ch->master == victim )
    {
	act( "$N is your beloved master.", ch, NULL, victim, TO_CHAR );
	return;
    }

    if ( ch->position == POS_FIGHTING )
    {
	send_to_char( "You do the best you can!\n\r", ch );
	return;
    }

    if ( IS_NPC(victim))
    WAIT_STATE( ch, 1 * PULSE_VIOLENCE );
    if(IS_WEREWOLF(ch) )
	victim->turned = TRUE;
    if(IS_WEREWOLF(victim) )
	ch->turned = TRUE;
    check_killer( ch, victim );
    multi_hit( ch, victim, TYPE_UNDEFINED );
    return;
}



void do_murde( CHAR_DATA *ch, char *argument )
{
    send_to_char( "If you want to MURDER, spell it out.\n\r", ch );
    return;
}



void do_murder( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Murder whom?\n\r", ch );
	return;
    }

    if ((IS_NPC(ch) && IS_SET(ch->act,ACT_PET)))
	return;

    if ( ( victim = get_char_room( ch, NULL, arg ) ) == NULL )
    {
	send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( victim == ch )
    {
	send_to_char( "Suicide is a mortal sin.\n\r", ch );
	return;
    }

    if ( is_safe( ch, victim ) )
	return;


    if ( ch->master == victim )
    {
	act( "$N is your beloved master.", ch, NULL, victim, TO_CHAR );
	return;
    }

    if ( ch->position == POS_FIGHTING )
    {
	send_to_char( "You do the best you can!\n\r", ch );
	return;
    }

    WAIT_STATE( ch, 1 * PULSE_VIOLENCE );
    if (IS_NPC(ch))
	sprintf(buf, "Help! I am being attacked by %s!",ch->short_descr);
    else
    	sprintf( buf, "Help!  I am being attacked by %s!", ch->name );
    do_function(victim, &do_yell, buf );
    check_killer( ch, victim );
    multi_hit( ch, victim, TYPE_UNDEFINED );
    return;
}



void do_backstab( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA *obj;

    one_argument( argument, arg );

    if (arg[0] == '\0')
    {
        send_to_char("Backstab whom?\n\r",ch);
        return;
    }

    if ( MOUNTED(ch) )
    {
        send_to_char("You can't backstab while riding!\n\r", ch);
        return;
    }
 

    if (ch->fighting != NULL)
    {
	send_to_char("You're facing the wrong end.\n\r",ch);
	return;
    }
 
    else if ((victim = get_char_room(ch, NULL, arg)) == NULL)
    {
        send_to_char("They aren't here.\n\r",ch);
        return;
    }

    if ( victim == ch )
    {
	send_to_char( "How can you sneak up on yourself?\n\r", ch );
	return;
    }

    if ( is_safe( ch, victim ) )
      return;


    if ( ( obj = get_eq_char( ch, WEAR_WIELD ) ) == NULL)
    {
	send_to_char( "You need to wield a weapon to backstab.\n\r", ch );
	return;
    }

    if ( victim->hit < victim->max_hit / 3)
    {
	act( "$N is hurt and suspicious ... you can't sneak up.",
	    ch, NULL, victim, TO_CHAR );
	return;
    }

    check_killer( ch, victim );
    WAIT_STATE( ch, skill_table[skill_lookup("backstab")].beats );
    if ( number_percent( ) < get_skill(ch,skill_lookup("backstab"))
    || ( get_skill(ch,skill_lookup("backstab")) >= 2 && !IS_AWAKE(victim) ) )
    {
	check_improve(ch,skill_lookup("backstab"),TRUE,1);
	multi_hit( ch, victim, skill_lookup("backstab") );
    }
    else
    {
	check_improve(ch,skill_lookup("backstab"),FALSE,1);
	damage( ch, victim, 0, skill_lookup("backstab"),DAM_NONE,TRUE);
    }

    return;
}



void do_flee( CHAR_DATA *ch, char *argument )
{
    ROOM_INDEX_DATA *was_in;
    ROOM_INDEX_DATA *now_in;
    CHAR_DATA *victim;
    int attempt;

    if ( ( victim = ch->fighting ) == NULL )
    {
        if ( ch->position == POS_FIGHTING )
            ch->position = POS_STANDING;
	send_to_char( "You aren't fighting anyone.\n\r", ch );
	return;
    }

    if (IS_SET(IN_ROOM(ch)->room_flags, ROOM_ARENA))
	return;

    was_in = IN_ROOM(ch);
    for ( attempt = 0; attempt < 6; attempt++ )
    {
	EXIT_DATA *pexit;
	int door;

	door = number_door( );
	if ( ( pexit = (*(was_in->exit))[door] ) == 0
	||   pexit->u1.to_room == NULL
	||   IS_SET(pexit->exit_info, EX_CLOSED)
	||   number_range(0,ch->daze) != 0
	|| ( IS_NPC(ch)
	&&   IS_SET(pexit->u1.to_room->room_flags, ROOM_NO_MOB) ) )
	    continue;

	move_char( ch, door, FALSE );
	if ( ( now_in = IN_ROOM(ch) ) == was_in )
	    continue;

	act( "$n has fled!", ch, NULL, NULL, TO_ROOM );

	if ( !IS_NPC(ch) )
	{
	    send_to_char( "You flee from combat!\n\r", ch );
	}

	stop_fighting( ch, TRUE );
	return;
    }

    send_to_char( "PANIC! You couldn't escape!\n\r", ch );
    return;
}



void do_rescue( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    CHAR_DATA *fch;

    one_argument( argument, arg );
    if ( arg[0] == '\0' )
    {
	send_to_char( "Rescue whom?\n\r", ch );
	return;
    }

    if ( ( victim = get_char_room( ch, NULL, arg ) ) == NULL )
    {
	send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( victim == ch )
    {
	send_to_char( "What about fleeing instead?\n\r", ch );
	return;
    }

    if ( !IS_NPC(ch) && IS_NPC(victim) && !is_same_group(ch,victim))
    {
	send_to_char( "Doesn't need your help!\n\r", ch );
	return;
    }

    if ( ch->fighting == victim )
    {
	send_to_char( "Too late.\n\r", ch );
	return;
    }

    if ( ( fch = victim->fighting ) == NULL )
    {
	send_to_char( "That person is not fighting right now.\n\r", ch );
	return;
    }


    WAIT_STATE( ch, skill_table[skill_lookup("rescue")].beats );
    if ( number_percent( ) > get_skill(ch,skill_lookup("rescue")))
    {
	send_to_char( "You fail the rescue.\n\r", ch );
	check_improve(ch,skill_lookup("rescue"),FALSE,1);
	return;
    }

    act( "You rescue $N!",  ch, NULL, victim, TO_CHAR    );
    act( "$n rescues you!", ch, NULL, victim, TO_VICT    );
    act( "$n rescues $N!",  ch, NULL, victim, TO_NOTVICT );
    check_improve(ch,skill_lookup("rescue"),TRUE,1);

    stop_fighting( fch, FALSE );
    stop_fighting( victim, FALSE );

    check_killer( ch, fch );
    set_fighting( ch, fch );
    set_fighting( fch, ch );
    return;
}



void do_kick( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *victim;
    int number = 0;

    number = number_range( 0, 5 );

    if ( !IS_NPC(ch)
    &&   !can_use_skpell(ch, skill_lookup("kick")) )
    {
	send_to_char(
	    "You better leave the martial arts to fighters.\n\r", ch );
	return;
    }

    if (IS_NPC(ch) && !IS_SET(ch->off_flags,OFF_KICK))
	return;

    if ( MOUNTED(ch) )
    {
        send_to_char("You can't kick while riding!\n\r", ch);
        return;
    }

    if ( ( victim = ch->fighting ) == NULL )
    {
	send_to_char( "You aren't fighting anyone.\n\r", ch );
	return;
    }

    WAIT_STATE( ch, skill_table[skill_lookup("kick")].beats );
    if ( get_skill(ch,skill_lookup("kick")) > number_percent())
    {
	damage(ch,victim,number_range( 50, ch->level + 100 / 2 ), skill_lookup("kick"),DAM_BASH,TRUE);
	check_improve(ch,skill_lookup("kick"),TRUE,1);
        if ( number <= 1 )
        {
            printf_to_char( ch, "You make a series of lightning fast kicks right to %ss head!\n\r", victim->short_descr );
            damage(ch,victim,number_range( 150, ch->level + 200 / 2 ), skill_lookup("kick"), DAM_BASH, TRUE );
            damage(ch,victim,number_range( 150, ch->level + 200 / 2 ), skill_lookup("kick"), DAM_BASH, TRUE );
            check_improve(ch,skill_lookup("kick"),TRUE,1);
        }
    }
    else
    {
	damage( ch, victim, 0, skill_lookup("kick"),DAM_BASH,TRUE);
	check_improve(ch,skill_lookup("kick"),FALSE,1);
    }
	
    check_killer(ch,victim);
    return;
}


void do_disarm( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    int chance,hth,ch_weapon,vict_weapon,ch_vict_weapon;

    hth = 0;

    if ((chance = get_skill(ch,skill_lookup("disarm"))) == 0)
    {
	send_to_char( "You don't know how to disarm opponents.\n\r", ch );
	return;
    }

    if ( get_eq_char( ch, WEAR_WIELD ) == NULL 
    &&   ((hth = get_skill(ch,skill_lookup("hand to hand"))) == 0
    ||    (IS_NPC(ch) && !IS_SET(ch->off_flags,OFF_DISARM))))
    {
	send_to_char( "You must wield a weapon to disarm.\n\r", ch );
	return;
    }

    if ( ( victim = ch->fighting ) == NULL )
    {
	send_to_char( "You aren't fighting anyone.\n\r", ch );
	return;
    }

    if ( ( obj = get_eq_char( victim, WEAR_WIELD ) ) == NULL )
    {
	send_to_char( "Your opponent is not wielding a weapon.\n\r", ch );
	return;
    }

    /* find weapon skills */
    ch_weapon = get_weapon_skill(ch,get_weapon_sn(ch));
    vict_weapon = get_weapon_skill(victim,get_weapon_sn(victim));
    ch_vict_weapon = get_weapon_skill(ch,get_weapon_sn(victim));

    /* modifiers */

    /* skill */
    if ( get_eq_char(ch,WEAR_WIELD) == NULL)
	chance = chance * hth/150;
    else
	chance = chance * ch_weapon/100;

    chance += (ch_vict_weapon/2 - vict_weapon) / 2; 

    /* dex vs. strength */
    chance += get_curr_stat(ch,STAT_DEX);
    chance -= 2 * get_curr_stat(victim,STAT_STR);

    /* level */
    chance += (ch->level - victim->level) * 2;
 
    /* and now the attack */
    if (number_percent() < chance)
    {
    	WAIT_STATE( ch, skill_table[skill_lookup("disarm")].beats );
	disarm( ch, victim );
	check_improve(ch,skill_lookup("disarm"),TRUE,1);
    }
    else
    {
	WAIT_STATE(ch,skill_table[skill_lookup("disarm")].beats);
	act("You fail to disarm $N.",ch,NULL,victim,TO_CHAR);
	act("$n tries to disarm you, but fails.",ch,NULL,victim,TO_VICT);
	act("$n tries to disarm $N, but fails.",ch,NULL,victim,TO_NOTVICT);
	check_improve(ch,skill_lookup("disarm"),FALSE,1);
    }
    check_killer(ch,victim);
    return;
}



void do_sla( CHAR_DATA *ch, char *argument )
{
    send_to_char( "If you want to SLAY, spell it out.\n\r", ch );
    return;
}



void do_slay( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *victim;
    char arg[MAX_INPUT_LENGTH];

    one_argument( argument, arg );
    if ( arg[0] == '\0' )
    {
	send_to_char( "Slay whom?\n\r", ch );
	return;
    }

    if ( ( victim = get_char_room( ch, NULL, arg ) ) == NULL )
    {
	send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( ch == victim )
    {
	send_to_char( "Suicide is a mortal sin.\n\r", ch );
	return;
    }

    if ( !IS_NPC(victim) && victim->level >= get_trust(ch) )
    {
	send_to_char( "You failed.\n\r", ch );
	return;
    }

    act( "You slay $M in cold blood!",  ch, NULL, victim, TO_CHAR    );
    act( "$n slays you in cold blood!", ch, NULL, victim, TO_VICT    );
    act( "$n slays $N in cold blood!",  ch, NULL, victim, TO_NOTVICT );
    raw_kill( victim, ch );
    return;
}

void do_engage(CHAR_DATA *ch, char *argument)
{
  char arg[MAX_INPUT_LENGTH];
  CHAR_DATA *victim;
  int chance;

    /* Check for skill.  */
    if (   (get_skill(ch,skill_lookup("engage")) == 0 )
      || (    !IS_NPC(ch)
          &&  !can_use_skpell( ch, skill_lookup("engage") ) ) )
    {
      send_to_char("Engage?  You're not even dating!\n\r",ch);  /* Humor. :)  */
      return;
    }

    /* Must be fighting.  */
    if (ch->fighting == NULL)
    {
      send_to_char("You're not fighting anyone.\n\r",ch);
      return;
    }

    one_argument( argument, arg );

    /* Check for argument.  */
    if (arg[0] == '\0')
    {
      send_to_char("Engage who?\n\r",ch);
      return;
    }

    /* Check for victim.  */
    if ((victim = get_char_room(ch, NULL, arg)) == NULL)
    {
      send_to_char("Shadowbox some other time.\n\r",ch);
      return;
    }

    if (victim == ch)
    {
      send_to_char("Attacking yourself in combat isn't a smart thing.\n\r",ch);
      return;
    }

    if (ch->fighting == victim)
    {
      send_to_char("You're already pummelling that target as hard as you can!\n\r",ch);
      return;
    }

    /* Check for safe.  */
    if (is_safe(ch, victim))
    return;

    /* Check for charm.  */
    if (  ch->master == victim )
    {
      act( "$N is your beloved master.", ch, NULL, victim, TO_CHAR );
      return;
    }

    /* This lets higher-level characters engage someone that isn't already fighting them.
     Quite powerful.  Raise level as needed.  */
    if ((victim->fighting != ch) && (ch->level < 2 ) )
    {
      send_to_char("But they're not fighting you!\n\r",ch);
      return;
    }

    /* Get chance of success, and allow max 95%.  */
    chance = get_skill(ch,skill_lookup("engage"));
    chance = UMIN(chance,95);

    if (number_percent() < chance)
    {
      /* It worked!  */
      stop_fighting(ch,FALSE);

      set_fighting(ch,victim);
      if (victim->fighting == NULL)
        set_fighting(victim,ch);

      check_improve(ch,skill_lookup("engage"),TRUE,3);
      act("$n has turned $s attacks toward you!",ch,NULL,victim,TO_VICT);
      act("You turn your attacks toward $N.",ch,NULL,victim,TO_CHAR);
      act("$n has turned $s attacks toward $N!",ch,NULL,victim,TO_NOTVICT);
    }
    else
    {
      /* It failed!  */
      send_to_char("You couldn't get your attack in.\n\r",ch);
      check_improve(ch,skill_lookup("engage"),FALSE,3);
    }
}

bool check_airmail_dir(CHAR_DATA* ch, ROOM_INDEX_DATA* to_room, EXIT_DATA* pexit)
{
    return !(IS_SET(pexit->exit_info,EX_NOPASS)) ||
	   /* unenterable room */
    (!is_room_owner(ch,to_room) && room_is_private(to_room)) ||
	   /* elemental difficulties.. */
    (to_room->sector_type == SECT_AIR );
}

void airmail_damage(CHAR_DATA* ch, CHAR_DATA* victim, int num)
{
    int amount = number_range(5 * victim->size, 5 * victim->size * (num + 1));

    WAIT_STATE(ch, PULSE_VIOLENCE);
    damage(ch,victim, amount, 0, DAM_BASH, FALSE);
    check_killer(ch, victim);
}

void airmail_char(CHAR_DATA *ch, CHAR_DATA *victim, int door, CHAR_DATA* lst[], int* spectator_count, int num)
{
   ROOM_INDEX_DATA *in_room;
   ROOM_INDEX_DATA *to_room;
   EXIT_DATA *pexit;
   CHAR_DATA* target;
   int s;

   in_room = IN_ROOM(victim);
   pexit = (*(in_room->exit))[door];
   to_room = pexit->u1.to_room;

   /* End of the line */
   if(num <= 0)
   {
	   /* It didn't go far..  */
      if(in_room == IN_ROOM(ch))
      {
         act("With a mighty heave you throw $M $T.", ch, victim, dir_name[door], TO_CHAR);
	 act("With a mighty heave $n throws $N into the air!", ch, NULL, victim, TO_ROOM);
      }

      act("$n lands in an unceremonious heap.", victim, NULL, NULL, TO_ROOM);
      act("You hear a confused racket as $N completes $S erstwhile journey.", ch, NULL, victim, TO_CHAR);
      send_to_char("Your journey is suddenly arrested by the floor.\n\r", victim);

	  /* Keep the spectators informed.. */
      for(s = 0; s < *spectator_count; s++)
      {
	  act("You hear a confused racket as $N completes $S erstwhile journey.", lst[s], NULL, victim, TO_CHAR);
      }

      airmail_damage(ch, victim, num);
   }
   else if(pexit == NULL || to_room == NULL)
   {

	if(in_room == IN_ROOM(ch))
        {
	   act("With a mighty heave you throw $M $T.", ch, victim, dir_name[door], TO_CHAR);
	   act("With a mighty heave $n throws $N into the air!", ch, NULL, victim, TO_ROOM);
	}

        act("$n crashes into the wall and lands in a disgruntled heap.", victim, NULL, NULL, TO_ROOM);
        send_to_char("*CRUNCH* is the sound of you bouncing.\n\r", victim);

        if(in_room == IN_ROOM(ch))
        {
	   act("*CRUNCH* is the sound of $N bouncing.", ch, NULL, victim, TO_CHAR);
	}
        else
        {
	   act("You hear a confused racket as $N completes $S erstwhile journey.", ch, NULL, victim, TO_CHAR);

	   for(s = 0; s < *spectator_count; s++)
	   {
	       act("You hear a confused racket as $N completes $S erstwhile journey.", lst[s], NULL, victim, TO_CHAR);
           }
	}

        airmail_damage(ch, victim, num);
   }
   else if(!check_airmail_dir(ch, to_room, pexit))
   {
	act("$n gets a physics lesson from the $d and lands in a disgruntled heap.", victim, NULL, pexit->keyword, TO_ROOM);
        act("OWCH! is the sound of you missing the $d.", victim, NULL, pexit->keyword, TO_CHAR);

        if(in_room == IN_ROOM(ch))
        {
	   act("Ooooh!  With a neato crunch $N bounced!", ch, NULL, victim, TO_CHAR);
	}
	else
	{
	   act("You hear a confused racket as $N completes $S erstwhile journey.", ch, NULL, victim, TO_CHAR);

 	   for(s = 0; s < *spectator_count; s++)
	   {
	       act("You hear a confused racket as $N completes $S erstwhile journey.", lst[s], NULL, victim, TO_CHAR);
	   }
	}

        airmail_damage(ch, victim, num);
   }
   else 
   {
       if(ch->fighting != NULL)
       {
          stop_fighting(ch, TRUE);
          if(ch->position == POS_FIGHTING)
          {
            ch->position = POS_STANDING;
          }
       }

       if(in_room == IN_ROOM(ch))
       {  
	  act("With a mighty heave you throw $M $T.", ch, victim, dir_name[door], TO_CHAR);
	  act("With a mighty heave $n throws $N into the air!", ch, NULL, victim, TO_ROOM);

	  target = in_room->people;

	  while(target && *spectator_count < MAX_SPECTATORS)
	  {
	        if(target != ch && target != victim)
	        {
	   	   lst[(*spectator_count)++] = target;
   	        }

	        target = target->next_in_room;
          }
       }
       else
       {
	   act("You hear swooshing noises to the $T.", ch, victim, dir_name[door], TO_CHAR);
       }

       act("$n cuts a perfect arc as $E sails $T.", victim, NULL, dir_name[door], TO_ROOM);
       char_from_room(victim);
       char_to_room(victim, to_room);

       act("In a swoosh of air $n sails in looking quite confused.", victim, NULL, NULL, TO_ROOM);
       do_look(victim, "auto");

       target = to_room->people;

       while(target)
       {
 	   if(target == victim)
 	   {
	      target = target->next_in_room;
	      continue;
	   }

	   if((target->size + victim->size) * 10 > number_range(0, 200))
	   {
   	       act("The $n smashes headlong into $N!", victim, NULL, target, TO_ROOM);
               act("You smash into $N!", victim, NULL, target, TO_CHAR);
               act("$n crashes into you!", victim, NULL, target, TO_VICT);
	       act("There is a confused shriek as the $N crashes into someone.", ch, NULL, victim, TO_CHAR);

	       for(s = 0; s < *spectator_count; s++)
	       {
		   act("There is a confused shriek as the $N crashes into someone.", lst[s], NULL, victim, TO_CHAR);
	       }

	       airmail_damage(victim, target, num);
	       airmail_damage(target, victim, num);
	       break;
	   }
		  
	   target = target->next_in_room;
	  
          }

	  if(!target)
	  {
  		  /* Add spectators in this room */
		  target = to_room->people;
		  while(target && *spectator_count < MAX_SPECTATORS)
		  {
			  if(target != ch && target != victim)
			  {
				lst[(*spectator_count)++] = target;
			  }
			  target = target->next_in_room;
		  }

		  /* recurse to keep going */
	  airmail_char(ch, victim, door, lst, spectator_count, num - 1);
	  } 
    }

    return;
}

void do_throw(CHAR_DATA *ch, char *argument)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim = NULL;
    char* tmp;
    int door;
    int force = 3;
    CHAR_DATA* lst[MAX_SPECTATORS];
    int spectator_count = 0;
    int movem = (ch->level +5) / 2; 

	/* Get a victim */
    tmp = one_argument(argument,arg);
    victim = get_char_room(ch, NULL, arg);

    if (victim == NULL)
    {
	send_to_char("Who do you want to throw?\n\r",ch);
	return;
    }

    if (victim->level >= LEVEL_IMMORTAL )
    {
        send_to_char( "Are you stupid?\n\r", ch );
        return;
    }

    if ( ch->fighting != '\0' || victim->fighting != '\0' )
    {
        send_to_char( "Try doing it when neither one of you are fighting.\n\r", ch );
        return;
    }

	/* Figure out how far we can throw this sucker */
	/* Heavily weighted for physical size */
    force = URANGE(0,
    (get_curr_stat(ch, STAT_STR) / 5) - ((victim->size - ch->size) * 2), 5);

	/* Heh, not very far at all.. */
    if(force <= 0)
    {
		/* Oops, ya done pissed 'em off */
       send_to_char("You grunt and heave but they refuse to budge!\r\n", ch);
       damage(ch,victim,0,TYPE_UNDEFINED,DAM_BASH,FALSE);
       return;
    }

    if ( ch->move < movem )
    { 
        printf_to_char( ch, "You need at least %d movement to throw anything!\n\r", movem );
        return;
    }

	/* Get a direction or pick one.. */
    one_argument(tmp, arg);

    if(arg[0] == '\0') 
    door = number_door();
    if ( !str_cmp( arg, "n" ) || !str_cmp( arg, "north" ) ) door = 0;
    else if ( !str_cmp( arg, "e" ) || !str_cmp( arg, "east"  ) ) door = 1;
    else if ( !str_cmp( arg, "s" ) || !str_cmp( arg, "south" ) ) door = 2;
    else if ( !str_cmp( arg, "w" ) || !str_cmp( arg, "west"  ) ) door = 3;
    else if ( !str_cmp( arg, "u" ) || !str_cmp( arg, "up"    ) ) door = 4;
    else if ( !str_cmp( arg, "d" ) || !str_cmp( arg, "down"  ) ) door = 5;	
	else door = number_door();

    airmail_char(ch, victim, door, lst, &spectator_count, force);
    ch->move -= movem;
}

void do_whirlwind( CHAR_DATA *ch, char *argument )
{
   CHAR_DATA *pChar;
   CHAR_DATA *pChar_next;
   OBJ_DATA *wield;
   bool found = FALSE;
   
   if (    !IS_NPC( ch ) 
        && !can_use_skpell( ch, skill_lookup("whirlwind") ) )
   {
      send_to_char( "You don't know how to do that...\n\r", ch );
      return;
   }
 
   if ( ( wield = get_eq_char( ch, WEAR_WIELD ) ) == NULL )
   {
      send_to_char( "You need to wield a weapon first...\n\r", ch );
      return;
   }
   
   act( "$n holds $p firmly, and starts spinning round...", ch, wield, NULL, TO_ROOM );
   act( "You hold $p firmly, and start spinning round...",  ch, wield, NULL, TO_CHAR );
   
   pChar_next = NULL;   
   for ( pChar = IN_ROOM(ch)->people; pChar; pChar = pChar_next )
   {
      pChar_next = pChar->next_in_room;
      if ( IS_NPC( pChar ) )
      {
         found = TRUE;
         act( "$n turns towards YOU!", ch, NULL, pChar, TO_VICT    );
         multi_hit( ch, pChar, skill_lookup("whirlwind") );
      }
   }
   
   if ( !found )
   {
      act( "$n looks dizzy, and a tiny bit embarassed.", ch, NULL, NULL, TO_ROOM );
      act( "You feel dizzy, and a tiny bit embarassed.", ch, NULL, NULL, TO_CHAR );
   }
   
   WAIT_STATE( ch, skill_table[skill_lookup("whirlwind")].beats );
   
   if ( !found && number_percent() < 20 )
   {
      act( "$n loses $s balance and falls into a heap.",  ch, NULL, NULL, TO_ROOM );
      act( "You lose your balance and fall into a heap.", ch, NULL, NULL, TO_CHAR );
      ch->position = POS_STUNNED;
   }
   
   return;
}      

void do_circle( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA *obj;
 
    one_argument( argument, arg );
 
    if ( !IS_NPC( ch )
        && !can_use_skpell( ch, skill_lookup("circle") ) )
    {
        send_to_char( "You don't know how to do that.\n\r", ch );
        return;
    }

    if (arg[0] == '\0')
    {
        victim = ch->fighting;
        if (victim == NULL)
        {
            send_to_char("But you aren't fighting anyone!\n\r",ch);
            return;
        }
    }        
            
    else if ((victim = get_char_room(ch, NULL, arg)) == NULL)
    {
        send_to_char("They aren't here.\n\r",ch);
        return;
    }
 
    if (victim == ch)
    {
        send_to_char("You try and circle yourself but you just fall down.\n\r", ch );
        return;
    }

    if ( is_safe( ch, victim ) )
      return;
 
    if ( ( obj = get_eq_char( ch, WEAR_WIELD ) ) == NULL)
    {
        send_to_char( "You need to wield a weapon to circle.\n\r", ch );
        return;
    }
 
    check_killer( ch, victim );
    WAIT_STATE( ch, skill_table[skill_lookup("circle")].beats );
    if ( number_percent( ) < get_skill(ch,skill_lookup("circle"))
    || ( get_skill(ch,skill_lookup("circle")) >= 2 && !IS_AWAKE(victim) ) )
    {
        check_improve(ch,skill_lookup("circle"),TRUE,1);
        multi_hit( ch, victim, skill_lookup("circle") );
    }
    else
    {
        check_improve(ch,skill_lookup("circle"),FALSE,1);
        damage( ch, victim, 0, skill_lookup("circle"),DAM_NONE,TRUE);
    }
 
    return;
}
 
void do_surrender( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *mob;
    if ( (mob = ch->fighting) == NULL )
    {
	send_to_char( "But you're not fighting!\n\r", ch );
	return;
    }
    act( "You surrender to $N!", ch, NULL, mob, TO_CHAR );
    act( "$n surrenders to you!", ch, NULL, mob, TO_VICT );
    act( "$n tries to surrender to $N!", ch, NULL, mob, TO_NOTVICT );
    stop_fighting( ch, TRUE );
 
    if ( !IS_NPC( ch ) && IS_NPC( mob ) 
    &&   ( !HAS_TRIGGER_MOB( mob, TRIG_SURR ) 
        || !p_percent_trigger( mob, NULL, NULL, ch, NULL, NULL, TRIG_SURR ) ) )
    {
	act( "$N seems to ignore your cowardly act!", ch, NULL, mob, TO_CHAR );
	multi_hit( mob, ch, TYPE_UNDEFINED );
    }
}
 

bool check_critical(CHAR_DATA *ch, CHAR_DATA *victim)
{
        OBJ_DATA *obj;

        obj = get_eq_char(ch,WEAR_WIELD);

        if (
             ( get_eq_char(ch,WEAR_WIELD) == NULL ) || 
             ( get_skill(ch,skill_lookup("critical strike"))  <  1 ) ||
             ( get_weapon_skill(ch,get_weapon_sn(ch))  !=  100 ) ||
             ( number_range(0,100) > get_skill(ch,skill_lookup("critical strike")) )
           )
                return FALSE;

        if ( number_range(0,100) > 5 )
                return FALSE;

        act("$p CRITICALLY STRIKES $n!",victim,obj,NULL,TO_NOTVICT);
        act("CRITICAL STRIKE!",ch,NULL,victim,TO_VICT);
        check_improve(ch,skill_lookup("critical strike"),TRUE,6);
        return TRUE;
}


bool check_counter( CHAR_DATA *ch, CHAR_DATA *victim, int dam, int dt)
{
        int chance;
        int dam_type;
        OBJ_DATA *wield;
		USE *use;

        if (    ( get_eq_char(victim, WEAR_WIELD) == NULL ) ||
                ( !IS_AWAKE(victim) ) ||
                ( !can_see(victim,ch) ) ||
                ( get_skill(victim,skill_lookup("counter")) < 1 )
           )
           return FALSE;

        wield = get_eq_char(victim,WEAR_WIELD);

        chance = get_skill(victim,skill_lookup("counter")) / 8; /* changed to 8 and 4 respectively */
        chance += ( victim->level - ch->level ) / 4;
        chance += 2 * (get_curr_stat(victim,STAT_DEX) - get_curr_stat(ch,STAT_DEX));
        chance += get_weapon_skill(victim,get_weapon_sn(victim)) -
                        get_weapon_skill(ch,get_weapon_sn(ch));
        chance += (get_curr_stat(victim,STAT_STR) - get_curr_stat(ch,STAT_STR) );

    if ( number_percent( ) >= chance )
        return FALSE;

        dt = skill_lookup("counter");

    if ( dt == TYPE_UNDEFINED )
    {
	dt = TYPE_HIT;
	if ( wield != NULL && ( use = get_obj_use(wield, UTYPE_WEAPON ) ) )
	    dt += use->value[3];
	else 
            dt += ch->dam_type;
    }

    if (dt < TYPE_HIT)
    	if (wield != NULL)
    	    dam_type = attack_table[use->value[3]].damage;
    	else
    	    dam_type = attack_table[ch->dam_type].damage;
    else
    	dam_type = attack_table[dt - TYPE_HIT].damage;

    if (dam_type == -1)
	dam_type = DAM_BASH;

    act( "You reverse $n's attack and counter with your own!", ch, NULL, victim, TO_VICT    );
    act( "$N reverses your attack!", ch, NULL, victim, TO_CHAR    );

    damage(victim,ch,dam/2, skill_lookup("counter") , dam_type ,TRUE ); /* DAM MSG NUMBER!! */

    check_improve(victim,skill_lookup("counter"),TRUE,6);

    return TRUE;
}

void do_warcry(CHAR_DATA *ch, char *argument)
{
  AFFECT_DATA af;

  if (IS_NPC(ch) ||
      !can_use_skpell( ch, skill_lookup("warcry") ) )
  {
      send_to_char( "You don't know how to warcry.\n\r", ch );
      return;
  }
           
  if (is_affected(ch, skill_lookup("warcry")))
  {
      send_to_char("You are already affected by warcry.\n\r",ch);
      return;
  }   

  if (ch->mana < 30)
  {
      send_to_char("You can't concentrate enough right now.\n\r",ch);
      return;
  }

  WAIT_STATE( ch, skill_table[skill_lookup("warcry")].beats );

  if (number_percent() > ch->pcdata->learned[skill_lookup("warcry")])
  {
      send_to_char("You grunt softly.\n\r", ch);
      act("$n makes some soft grunting noises.", ch, NULL, NULL, TO_ROOM);
      return;
  }     

  ch->mana -= 30;

  af.where      = TO_AFFECTS;
  af.type      = skill_lookup("warcry");
  af.level       = ch->level;
  af.duration  = 6+ch->level;
  af.location  = APPLY_HITROLL;
  af.modifier  = ch->level / 8;
  af.bitvector = 0;    
  affect_to_char( ch, &af );
  af.location  = APPLY_SAVING_SPELL;
  af.modifier  = 0 - ch->level / 8;
  affect_to_char( ch, &af );
  send_to_char( "You feel righteous as you yell out your warcry.\n\r", ch );
  return;
}     

void do_assassinate( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA *obj;

    one_argument( argument, arg );

    if ( !IS_NPC( ch )
        && !can_use_skpell( ch, skill_lookup("assassinate") ) )
    {
        send_to_char( "You don't know to assassinate.\n\r", ch );
        return;
    }              

    if (arg[0] == '\0')
    {
        victim = ch->fighting;
        if (victim == NULL)
        {
            send_to_char("But you aren't fighting anyone!\n\r",ch);
            return;
        }
    }           
 
    else if ((victim = get_char_room(ch, NULL, arg)) == NULL)
    {
        send_to_char("They aren't here.\n\r",ch);
        return;
    }    
   
    if ( victim == ch )
    {
        send_to_char( "You can't assassinate yourself!\n\r", ch );
        return;
    }

    if ( is_safe( ch, victim ) )
      return;     

 
    if ( ( obj = get_eq_char( ch, WEAR_WIELD ) ) == NULL)
    {
        send_to_char( "You need to wield a weapon to assassinate.\n\r", ch );
        return;
    }     

    check_killer( ch, victim );
    WAIT_STATE( ch, skill_table[skill_lookup("assassinate")].beats );  
 
    if ( number_percent( ) < get_skill(ch,skill_lookup("assassinate"))
    || ( get_skill(ch,skill_lookup("assassinate")) >= 2 && !IS_AWAKE(victim) ) )
    {
        check_improve(ch,skill_lookup("assassinate"),TRUE,1);
        multi_hit( ch, victim, skill_lookup("assassinate") );
    }                      
    else
    {
        check_improve(ch,skill_lookup("assassinate"),FALSE,1);
        damage( ch, victim, 0, skill_lookup("assassinate"),DAM_NONE,TRUE);
    }

    return;
}          


void crowd_brawl(CHAR_DATA *ch)
{
    CHAR_DATA *rch, *rch_next, *vch, *vch_next;
    CHAR_DATA *is_fighting[45];
    SHOP_DATA *pshop;
    int chance;
    int counter;
    int to_fight;

    for (rch = IN_ROOM(ch)->people; rch != NULL; rch = rch_next)
    {
	rch_next = rch->next_in_room;

	chance = number_range(1,250);

	if ((rch->fighting == NULL)
	 &&((!IS_IMMORTAL(rch) && !IS_NPC(rch))
	 ||(IS_NPC(rch)
	 &&!(IS_SET(rch->act,ACT_TRAIN)
	 ||  IS_SET(rch->act,ACT_PRACTICE)
	 ||  IS_SET(rch->act,ACT_IS_HEALER)
	 ||  IS_SET(rch->act,ACT_IS_CHANGER)
	 || ((pshop = rch->pIndexData->pShop) != NULL))))
	 &&IS_AWAKE(rch)
	 &&(chance <= 5))
	{
	  counter = 0;
	  for (vch = IN_ROOM(ch)->people; vch != NULL; vch = vch_next)
	  {
	    vch_next = vch->next_in_room;

	    if ((vch->fighting != NULL) && (counter <= 44))
	    {
	      is_fighting[counter] = vch;
	      ++counter;

	      if ((IS_NPC(vch)) && (counter <= 44))
	      {
	        is_fighting[counter] = vch;
	        ++counter;
	      }
	      if ((IS_NPC(vch)) && (counter <= 44))
	      {
	        is_fighting[counter] = vch;
	        ++counter;
	      }
  	    }
	  }

	  to_fight = number_range(1,counter);
	  to_fight -= 1;

	  if (!IS_NPC(rch) && !IS_NPC(is_fighting[to_fight]))
	  {
	    if (is_same_clan(rch,is_fighting[to_fight]))
	      continue;

	    if (((UMAX(rch->level,is_fighting[to_fight]->level) -
		  UMIN(rch->level,is_fighting[to_fight]->level)) > 7)
	       ||(is_fighting[to_fight]->level < 10))
	      continue;
	  }
	  else if (IS_NPC(rch))
	  {
	    if (rch->pIndexData->vnum == 3708)
	      continue;
	  }

	  if (IS_IMMORTAL(is_fighting[to_fight]))
	    continue;

	  if ((rch->position <= POS_RESTING) && (chance > 1))
	    continue;

	  /* gotta see them to attack them */
	  if (!can_see(rch,is_fighting[to_fight]))
	    continue;

	  /* not against group members */
	  if (is_same_group(rch,is_fighting[to_fight]))
	    continue;

	  if (IS_SET(rch->act,ACT_PET)
	   &&((rch->master == is_fighting[to_fight])
	   ||(is_fighting[to_fight]->master == rch)
	   ||(is_fighting[to_fight]->master == rch->master)))
	    continue;

	  if (is_fighting[to_fight] != NULL)
	  {
	    rch->fighting = is_fighting[to_fight];
	    rch->position = POS_FIGHTING;
	    act("You find yourself caught up in the brawl!",rch,NULL,NULL,TO_CHAR);
	    act("$n finds $mself involved in the brawl.",rch,NULL,NULL,TO_ROOM);
	  }
	  else
	    bug("Crowd_brawl - person to fight is NULL.", 0);
	}
    }

    return;
}  


bool check_steel_skin(CHAR_DATA *ch,CHAR_DATA *victim ) 
{ 



  if (victim->subtype > 0)
  {
  xact_new( "$n's attack bounces off your steel skin.",ch,NULL,victim,TO_VICT, POS_RESTING, SUPPRESS_DODGE ); 
  xact_new( "Your attack bounces off $N's steel skin.",ch,NULL,victim,TO_CHAR, POS_RESTING, SUPPRESS_DODGE ); 
  victim->subtype--; 
  if(victim->subtype<=0) 
  { 
          send_to_char("Your skin feels soft once again.\n\r",victim); 
          affect_strip(victim,skill_lookup("steel skin")); 
  } 
      return TRUE; 
  } 
  
  return FALSE; 
} 

void do_bloodlust( CHAR_DATA *ch, char *argument)
{
  int chance, hp_percent;

  if ((chance = get_skill(ch,skill_lookup("bloodlust"))) == 0
  || (IS_NPC(ch) && !IS_SET(ch->off_flags,OFF_BLOODLUST))
  || (!IS_NPC(ch)
  && !can_use_skpell( ch, skill_lookup("bloodlust") ) ) )
  {
     send_to_char("You try to become consumed but nothing happens.\n\r",ch);
     return;
  }
 
  if (ch->position == POS_FIGHTING)
      chance += 10;

  hp_percent = 100 * ch->hit/ch->max_hit;
  chance += 25 - hp_percent/2;

  if (number_percent() < chance)
  {

      WAIT_STATE(ch,PULSE_VIOLENCE);
      ch->hit  = (int)(ch->hit * .90);
      ch->move = (int)(ch->move * .90);

      send_to_char("You shed your blood and feel battle lust take over!\n\r",ch);
      act("$n sheds some blood and is consumed by battle lust!",ch,NULL,NULL,TO_ROOM);
      check_improve(ch,skill_lookup("bloodlust"),TRUE,2);


  }

  else
  {
      WAIT_STATE(ch,3 * PULSE_VIOLENCE);
      ch->hit = (int)(ch->hit * .95);

      send_to_char("You shed some blood but nothing happens.\n\r",ch);
      check_improve(ch,skill_lookup("bloodlust"),FALSE,2);
  }
}



void do_knee( CHAR_DATA *ch, char *argument )
{
  CHAR_DATA *victim;
  int dam;

  if ( !IS_NPC(ch)
      && !can_use_skpell( ch, skill_lookup("knee") ) )
  {
      send_to_char("You better leave the martial arts to fighters.\n\r", ch );
      return;
  }

  if ( ( victim = ch->fighting ) == NULL )
  {
      send_to_char( "You aren't fighting anyone.\n\r", ch );
      return;
  } 

  WAIT_STATE( ch, skill_table[skill_lookup("knee")].beats );
 
  if ( get_skill(ch,skill_lookup("knee")) > number_percent())
  {
      check_improve(ch,skill_lookup("knee"),TRUE,1);
      act( "$n grabs your head and slams their knee into your face.", ch, NULL, victim, TO_VICT);
      act( "You grab $N and slam your knee into their face.", ch, NULL, victim, TO_CHAR);
      act( "$n grabs $N and slams $s knee into their face.", ch, NULL, victim, TO_NOTVICT);
      dam = number_range ( (ch->level * 7 ), ( 250 ));
      damage( ch, victim, dam, skill_lookup("knee"),DAM_BASH,TRUE);
      damage( ch, victim, dam, skill_lookup("knee"),DAM_BASH,TRUE);
      damage( ch, victim, dam, skill_lookup("knee"),DAM_BASH,TRUE);
  }

  else
  {
      check_improve(ch,skill_lookup("knee"),FALSE,1);
      act( "$n tries to knee you and misses.", ch, NULL, victim, TO_VICT);
      act( "You try to knee $N and miss.", ch, NULL, victim, TO_CHAR);
      act( "$n tries to knee $N and misses.", ch, NULL, victim, TO_NOTVICT);
      damage( ch, victim, 0, skill_lookup("knee"),DAM_BASH,TRUE);
  }

  return;
}


void do_srush( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *victim;
    char arg[MIL];
    OBJ_DATA *obj;
    int dam;
    int chance;
 
    one_argument( argument, arg );

    if ( get_skill(ch,skill_lookup("srush")) == 0
    ||	 (!IS_NPC(ch)
    &&	  !can_use_skpell( ch, skill_lookup("srush") ) ) )
    {	
	send_to_char("Shield Rush? What's that?\n\r",ch);
	return;
    }

    if (arg[0] == '\0')
    {
        victim = ch->fighting;
        if (victim == NULL)
        {
            send_to_char("But you aren't fighting anyone!\n\r",ch);
            return;
        }
    }          

    else if ((victim = get_char_room(ch, NULL, arg)) == NULL)
    {
        send_to_char("They aren't here.\n\r",ch);
        return;
    }        

    if (victim == ch)
    {
	send_to_char("Very funny.\n\r",ch);
	return;
    }
    
    if (is_safe(ch,victim))
        return;     

    if ( (obj = get_eq_char( ch, WEAR_SHIELD ) )== NULL )
    {
        send_to_char("You need a shield for this manuever.\n\r",ch);
        return;
    }

    /* modifiers */

    /* size  and weight */
    chance += ch->carry_weight / 250;
    chance -= victim->carry_weight / 200;

    if (ch->size < victim->size)
	chance += (ch->size - victim->size) * 15;
    else
	chance += (ch->size - victim->size) * 10; 


    /* stats */
    chance += get_curr_stat(ch,STAT_STR);
    chance -= (get_curr_stat(victim,STAT_DEX) * 4)/3;
    chance -= GET_AC(victim,AC_BASH) /25;
    /* speed */
    if (IS_SET(ch->off_flags,OFF_FAST) )
        chance += 10;
    if (IS_SET(victim->off_flags,OFF_FAST))
        chance -= 30;

    /* level */
    chance += (ch->level - victim->level);

    WAIT_STATE( ch, skill_table[skill_lookup("srush")].beats );
    if ( number_percent( ) < get_skill(ch,skill_lookup("srush"))
    || ( get_skill(ch,skill_lookup("srush")) >= 2 && !IS_AWAKE(victim) ) )
    {
        check_improve(ch,skill_lookup("srush"),TRUE,3);
	act( "$n knocks you off your feet with $s shield.", ch, NULL, victim, TO_VICT);
	act( "You knock $N off there feet with your shield.", ch, NULL, victim, TO_CHAR);
	act( "$n knocks $N of $S feet with there shield.", ch, NULL, victim, TO_NOTVICT);
	dam = dice( 425 + 25, 25 );
        damage( ch, victim, dam, skill_lookup("srush"),DAM_BASH,TRUE);
        DAZE_STATE(victim,2 * PULSE_VIOLENCE);  
        victim->position = POS_RESTING;
    }
    else
    {
        check_improve(ch,skill_lookup("srush"),FALSE,3);
	act( "$n tries to knock you off your feet.", ch, NULL, victim, TO_VICT);
	act( "You try to knock $N off $S feet.", ch, NULL, victim, TO_CHAR);
	act( "$n tries to knock $N off $S feet.", ch, NULL, victim, TO_NOTVICT);
        damage( ch, victim, 0, skill_lookup("srush"),DAM_BASH,TRUE);
    }
 
    return;
}


bool check_phase( CHAR_DATA *ch, CHAR_DATA *victim )
{
    int chance;

    if ( !IS_AWAKE(victim) )
	return FALSE;

    chance = get_skill(victim,skill_lookup("phase")) / 2;

    if (!can_see(victim,ch))
	chance /= 2;

    if ( number_percent( ) >= chance + victim->level - ch->level )
        return FALSE;

    xact_new( "Your body phases to avoid $n's attack.", ch, NULL, victim, TO_VICT, POS_RESTING, SUPPRESS_DODGE    );
    xact_new( "$N's body phases to avoid your attack.", ch, NULL, victim, TO_CHAR, POS_RESTING, SUPPRESS_DODGE    );
    check_improve(victim,skill_lookup("phase"),TRUE,6);
    return TRUE;
}


void do_spin( CHAR_DATA *ch, char *argument )
{
    char arg[MIL];
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    int chance;
  
    one_argument( argument, arg );

    if ( get_skill(ch,skill_lookup("spin")) == 0
    ||	 (!IS_NPC(ch)
    &&	  !can_use_skpell( ch, skill_lookup("spin") ) ) )
    {	
	send_to_char("You can't do a spinning slash attack.\n\r",ch);
	return;
    }

    if (arg[0] == '\0')
    {
        victim = ch->fighting;
        if (victim == NULL)
        {
            send_to_char("But you aren't fighting anyone!\n\r",ch);
            return;
        }
    }

    else if ((victim = get_char_room(ch, NULL, arg)) == NULL)
    {
        send_to_char("They aren't here.\n\r",ch);
        return;
    }         
 
    if ( ( obj = get_eq_char( ch, WEAR_WIELD ) ) == NULL)
    {
        send_to_char( "You need to wield a primary weapon to do a spinning slash attack.\n\r", ch );
        return;
    }
  
    WAIT_STATE( ch, skill_table[skill_lookup("spin")].beats );
    if ( number_percent( ) < get_skill(ch,skill_lookup("spin"))
    || ( get_skill(ch,skill_lookup("spin")) >= 2 && !IS_AWAKE(victim) ) )
    {
        check_improve(ch,skill_lookup("spin"),TRUE,1);
	act( "$n hits you with a spinning slash attack!", ch, NULL, victim, TO_VICT);
	act( "Your spinning slash attack strikes $N resulting in lots of blood!", ch, NULL, victim, TO_CHAR);
	act( "$n strikes $N with a spinning slash attack.", ch, NULL, victim, TO_NOTVICT);
        multi_hit( ch, victim, skill_lookup("spin") );
        if ( ( obj = get_eq_char( victim, WEAR_WIELD ) ) == NULL)
        {
            return;
        }
        if ( IS_OBJ_STAT(obj,ITEM_NOREMOVE))
        {
	    return;
        }
	chance = (get_skill(ch,skill_lookup("disarm"))/2);
	if (number_percent() <= chance )
	{
	    chance = (get_skill(ch,skill_lookup("disarm"))/2);
	    if (number_percent() <= chance )

	    act("Unable to block $n's spinning slash attack, your weapon tears free!",ch,NULL,victim,TO_VICT);
	    act("$N's weapon breaks free as you hit them with a spinning slash attack!",ch,NULL,victim,TO_CHAR);
	    check_improve(ch,skill_lookup("disarm"),TRUE,1);
            obj_from_char( obj );
            if ( IS_OBJ_STAT(obj,ITEM_NODROP) || IS_OBJ_STAT(obj,ITEM_INVENTORY ) )
        	obj_to_char( obj, victim );
            else
            {
	        obj_to_room( obj, IN_ROOM(victim) );
	        if (IS_NPC(victim) && victim->wait == 0 && can_see_obj(victim,obj))
	        get_obj(victim,obj,NULL);
            }
        }
    
    }
    else
    {
        check_improve(ch,skill_lookup("spin"),FALSE,1);
	act( "$n tries to hit you with a spinning slash attack.", ch, NULL, victim, TO_VICT);
	act( "$N dodges your spinning slash attack.", ch, NULL, victim, TO_CHAR);
	act( "$n does a spinnning slash attack on $N .", ch, NULL, victim, TO_NOTVICT);
        damage( ch, victim, 0, skill_lookup("spin"),DAM_NONE,TRUE);
    }
 
    return;
}

void do_rage( CHAR_DATA *ch, char *argument )
{
   CHAR_DATA *pChar;
   CHAR_DATA *pChar_next;
   OBJ_DATA *wield;
   int chance;

    chance = number_range( 1, 100);
   
    if ( get_skill(ch,skill_lookup("rage")) == 0
    ||	 (!IS_NPC(ch)
    &&	  !can_use_skpell( ch, skill_lookup("rage") ) ) )
   {
      send_to_char( "You don't know how to do that...\n\r", ch );
      return;
   }

   if ( ( wield = get_eq_char( ch, WEAR_WIELD ) ) == NULL )
   {
      send_to_char( "You need to wield a weapon first...\n\r", ch );
      return;
   }
   
   act( "In a rage $n attacks everyone in the room!", ch, wield, NULL, TO_ROOM );
   act( "In a rage you attack everything in the room!",  ch, wield, NULL, TO_CHAR );
   
    for ( pChar = char_list; pChar != NULL; pChar = pChar_next )
    {
        pChar_next        = pChar->next;

        if ( IN_ROOM(pChar) == NULL )
            continue;

        if ( IN_ROOM(pChar) == IN_ROOM(ch) )
        {
            if (is_safe(ch,pChar))
                return;    

            if ( pChar != ch && !is_safe_spell(ch,pChar,TRUE))
            {
                if (is_same_group(pChar,ch) )
                {
                    continue;
                }
         
        WAIT_STATE( ch, skill_table[skill_lookup("rage")].beats );
        act( "$n turns towards YOU!", ch, NULL, pChar, TO_VICT    );
	check_improve(ch,skill_lookup("rage"),TRUE,4);
        multi_hit( ch, pChar, skill_lookup("rage") );

        if (chance < 15)
        {
        act( "$n spins back toward YOU!", ch, NULL, pChar, TO_VICT    );
        act( "$n spins back to attack again!",  ch, wield, NULL, TO_ROOM );
        act( "You spin back to attack again!",  ch, wield, NULL, TO_CHAR );
        multi_hit( ch, pChar, skill_lookup("rage") );
            continue;
        }

      }
    }   
 
   }

   return;
} 

//Stances by Majik

void do_stance (CHAR_DATA * ch, char *argument)
{
    char arg[MAX_STRING_LENGTH];
    char *stances = "neutral aggressive defensive";      

    argument = one_argument (argument, arg);

    if (IS_NPC (ch))
    {
        send_to_char ("Only players can change stance.\n\r", ch);
        return;
    }

    if (arg[0] == '\0')
    {
        send_to_char ("Switch to which stance?\n\r", ch);
        printf_to_char( ch, "Valid stances are: %s\n\r", stances );
        return;
    }

    else
    {
        if (!str_prefix (arg, "neutral"))
        {   
            ch->stance = 0;
            ch->stance_hit_bonus = 0;
            ch->stance_ac_bonus = 0;
            send_to_char ("You are in a neutral stance.\n\r", ch);   
            return;
        }

        else if (!str_prefix (arg, "aggressive"))
        {
            ch->stance = 1;
            ch->stance_hit_bonus = ch->hitroll/2;
            ch->stance_ac_bonus = ch->armor[1]/4;
            send_to_char ("You are in an aggressive stance.\n\r", ch);   
            return;
        }

        else if (!str_prefix (arg, "defensive"))
        {
            ch->stance = 2;
            ch->stance_hit_bonus = (ch->hitroll/4) * -1;
            ch->stance_ac_bonus = (ch->armor[1]/2) * -1;
            send_to_char ("You are in an defensive stance.\n\r", ch);   
            return;
        }        

        else
        {
            send_to_char ("Valid stances are aggressive neutral and defensive.\n\r", ch);
            return;
        }
    }
}


/* Bowfire code -- actual firing function */
void do_fire( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim = NULL;
    OBJ_DATA *arrow;
    OBJ_DATA *bow;
    ROOM_INDEX_DATA *was_in_room;
    EXIT_DATA *pexit;
    int dam ,door ,chance;
	USE *aUse, *bUse;

    bow = get_eq_char(ch, WEAR_WIELD);
    if (bow == NULL)
    {
	send_to_char("What are you going to do, throw the arrow at them?\n\r", ch);
	return;
    }
	if( !( bUse = get_obj_use(bow, UTYPE_WEAPON) ) )
	{	send_to_char("You need to use a weapon to fire!\n\r",ch);
		return;
	}

    if (bUse->value[0] != WEAPON_BOW)
    {
	send_to_char("You might want to use a bow to fire that arrow with\n\r", ch);
	return;
    }    

    one_argument( argument, arg );
    if ( arg[0] == '\0' && ch->fighting == NULL )
    {
        send_to_char( "Fire an arrow at who?\n\r", ch );
        return;
    }

    if (!str_cmp(arg, "none") || !str_cmp(arg, "self") || victim == ch)
    {
        send_to_char("How exactly did you plan on firing an arrow at yourself?\n\r", ch );
        return;
    }

    if ( ( arrow = get_eq_char( ch, WEAR_HOLD ) ) == NULL )
    {
        send_to_char( "You hold nothing in your hand.\n\r", ch );
        return;
    }

    if ( !(aUse = get_obj_use(arrow, UTYPE_ARROW ) ) )
    {	send_to_char( "You can only a fire arrows or quarrels.\n\r", ch );
        return;
    }
	
    if ( arg[0] == '\0' )
    {
        if ( ch->fighting != NULL )
        {
            victim = ch->fighting;
        }
        else
        {
            send_to_char( "Fire at whom or what?\n\r", ch );
            return;
        }
    }
    else
    {
        
	/* See if who you are trying to shoot at is nearby... */

        if ( ( victim = get_char_room ( ch, NULL, arg ) ) == NULL)
        {
            was_in_room = IN_ROOM(ch);


            for( door=0 ; door<=5 && victim==NULL ; door++ )
             { 
                if ( (  pexit = (*(was_in_room->exit))[door] ) != NULL
                   &&   pexit->u1.to_room != NULL
                   &&   pexit->u1.to_room != was_in_room 
                   &&   !strcmp( pexit->u1.to_room->area->name ,
                                was_in_room->area->name ) )
                   { 
                     victim = get_char_room ( ch, NULL, arg ); 
                    }
               
              }


            if(victim==NULL)
              {
               send_to_char( "You can't find it.\n\r", ch );
               return;
              }
            else
              {  if(IS_SET(pexit->exit_info,EX_CLOSED))
                    { send_to_char("You can't fire through a door.",ch);
                      return;
                     } 
             }
        }
    }

    if((IN_ROOM(ch)) == (IN_ROOM(victim)))
    {
       send_to_char("Don't you think that standing a bit further away would be wise?\n\r", ch);
       return;
    }

    WAIT_STATE( ch, 2 * PULSE_VIOLENCE ); 

    if((aUse = get_obj_use(arrow, UTYPE_ARROW ) ) )
    {
        if ( victim != NULL )
        {
            act( "$n fires $p at $N.", ch,  arrow, victim, TO_NOTVICT );
            act( "You fire $p at $N.", ch,   arrow, victim, TO_CHAR );
            act( "$N fires $p at you.",ch,   arrow, victim, TO_VICT );
        }
      
        if (ch->level <   arrow->level
        ||  number_percent() >= 20 + get_skill(ch,skill_lookup("bow")) * 4/5 )
        {       
              act( "You fire $p missing, and it lands harmlessly on the ground.",
                 ch,  arrow,NULL,TO_CHAR);
              act( "$r fires $p missing, and it lands harmlessly on the ground.",
                 ch,  arrow,NULL,TO_ROOM);
              obj_from_char(arrow);
			  obj_to_room(arrow, IN_ROOM(victim));
              check_improve(ch,skill_lookup("bow"),FALSE,2);
        }

        else
        {      

              chance=dice(1,10);

    switch (chance)
    {
        case 1 :
	case 2 :
	case 3 :
	case 4 :
	case 5 :
	case 6 :
                        obj_from_char(arrow);
			obj_to_char(arrow, victim);
			wear_obj(victim, arrow,TRUE);
                        dam      =  dice(aUse->value[1],aUse->value[2]);
			damage( ch, victim, dam, skill_lookup("bow"), DAM_PIERCE, TRUE );						
			check_improve(ch,skill_lookup("bow"),TRUE,2);
			break;
	case 7 :
	case 8 :
	case 9 :
            obj_from_char(arrow);
			obj_to_char(arrow, victim);
			wear_obj(victim, arrow,TRUE);
                        dam      = 3 * ( dice(aUse->value[1],aUse->value[2]))/2;
			damage( ch, victim, dam, skill_lookup("bow"), DAM_PIERCE, TRUE );						
			check_improve(ch,skill_lookup("bow"),TRUE,2);
			break;
	case 10 :
            obj_from_char(arrow);
			obj_to_char(arrow, victim);
			wear_obj(victim, arrow,TRUE);
                        dam      =  2 * ( dice(aUse->value[1],aUse->value[2]));
			damage( ch, victim, dam, skill_lookup("bow"), DAM_PIERCE, TRUE );						
			check_improve(ch,skill_lookup("bow"),TRUE,2);
			break;
	}		
   }

  } 

    return;
}


void do_gouge( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    int chance;

    one_argument(argument,arg);

    if ( (chance = get_skill(ch,skill_lookup("gouge"))) == 0
    ||   (!IS_NPC(ch)
    &&    !can_use_skpell( ch, skill_lookup("gouge") ) ) )
    {
	send_to_char("You don't know how to gouge.\n\r",ch);
	return;
    }

    if (arg[0] == '\0')
    {
	victim = ch->fighting;
	if (victim == NULL)
	{
	    send_to_char("But you aren't in combat!\n\r",ch);
	    return;
	}
    }

    else if ((victim = get_char_room(ch, NULL, arg)) == NULL)
    {
	send_to_char("They aren't here.\n\r",ch);
	return;
    }

	if (victim == ch)
    {
	send_to_char("Very funny.\n\r",ch);
	return;
    }

    if (is_safe(ch,victim))
	return;

    chance += get_curr_stat(ch,STAT_DEX);
    chance -= 2 * get_curr_stat(victim,STAT_DEX);

    if (IS_SET(ch->off_flags,OFF_FAST))
	chance += 10;
    if (IS_SET(victim->off_flags,OFF_FAST))
	chance -= 25;

    chance += (ch->level - victim->level) * 2;

    if (chance % 5 == 0)
	chance += 1;

    if (number_percent() < chance)
    {
	act("$n is blinded by a poke in the eyes!",victim,NULL,NULL,TO_ROOM);
	act("$n gouges at your eyes!",ch,NULL,victim,TO_VICT);
        damage(ch,victim,number_range(50,75),skill_lookup("gouge"),DAM_NONE,FALSE);
	send_to_char("You see nothing but stars!\n\r",victim);
	check_improve(ch,skill_lookup("gouge"),TRUE,2);
	WAIT_STATE(ch,skill_table[skill_lookup("gouge")].beats);

   }
    else
    {
	damage(ch,victim,0,skill_lookup("gouge"),DAM_NONE,TRUE);
	check_improve(ch,skill_lookup("gouge"),FALSE,2);
	WAIT_STATE(ch,skill_table[skill_lookup("gouge")].beats);
    }
}


void do_tithe( CHAR_DATA *ch, char *argument )
{
	int	cost;/* amount of gold needed */
	int	fillup;/* amount of mana needed */
	int     paid;/*Full Amount Player can pay*/
        int     pumped;/*Amount of mana to be given back*/
        int     manacost = 3;

	if ( !IS_NPC( ch )
             && !can_use_skpell( ch, skill_lookup("tithe") ) )
	{
            send_to_char("You need a deity first!\n\r", ch);
	    return;
        }

	if (ch->mana >= ch->max_mana)
	{
            ch->mana = ch->max_mana;
	    send_to_char("You're already at full mana!\n\r", ch);
	    return;
        }

	fillup = ch->max_mana - ch->mana;

	cost = fillup * manacost;

	if (ch->gold >= cost) 
	{
            printf_to_char( ch, "Thank you for your tithing of %d gold!\n\r", cost );
	    ch->mana = ch->max_mana;
	    ch->gold -= cost;
	    return;
	}

	cost = ch->gold;
	paid = (cost-(cost % manacost));	
	pumped = paid/manacost;
	
	if(pumped > 0)
	{
           printf_to_char( ch, "Thank you for the tithing of %d gold!\n\r", paid );
	   ch->mana += pumped;
	   ch->gold -= paid;
	   return;
	}

	return;
}


void do_sharpen(CHAR_DATA *ch, char *argument)
{
  char arg1[MAX_INPUT_LENGTH];
  OBJ_DATA *obj;
  AFFECT_DATA af;
  int percent, skill;
  USE *use;


  argument = one_argument(argument, arg1);
  
  if (arg1[0] == '\0')
  {
    send_to_char("Sharpen what weapon?\n\r",ch);
    return;
  }

  if ((obj = get_obj_carry(ch, arg1, ch)) == NULL)
  {
    send_to_char("You do not have that weapon in your inventory.\n\r", ch );
    return;
  }
    
  if ((skill = get_skill(ch, skill_lookup("sharpen"))) < 1)
  {
    send_to_char("You don't have enough skill to enhance the edge of your weapon.\n\r",ch);
    return;
  }

  if ( ( use = get_obj_use(obj, UTYPE_WEAPON) ) )
  {
    if(IS_WEAPON_STAT(use,WEAPON_SHARP))
    {
      act("$p has already been sharpened.",ch,obj,NULL,TO_CHAR);
      return;
    }

    percent = number_percent();

    if(percent < skill)
    {
	WAIT_STATE(ch,PULSE_VIOLENCE);

        af.where      = TO_WEAPON;
        af.type       = skill_lookup("sharpen");
        af.level      = ch->level/2;
        af.duration   = 8;
        af.location   = 0;
        af.modifier   = 0;
        af.bitvector  = WEAPON_SHARP;
        affect_to_obj(obj,&af);
      
        act("$n silently sharpens the edge of $p.",ch,obj,NULL,TO_ROOM);
        act("you sharpen the edge of $p.",ch,obj,NULL,TO_CHAR);
        check_improve(ch,skill_lookup("sharpen"),TRUE,3);
    }
    else
    {
	WAIT_STATE(ch,2 * PULSE_VIOLENCE);
	send_to_char("Your attempt to sharpen your weapon fails.\n\r",ch);
	check_improve(ch,skill_lookup("sharpen"),FALSE,2);
    }
  }
}


void do_cleave( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA *obj;

    if ( MOUNTED(ch) ) 
    {
        send_to_char("You can't cleave while riding!\n\r", ch);
        return;
    }

    one_argument( argument, arg );

    if ( !IS_NPC(ch)
    &&   !can_use_skpell( ch, skill_lookup("cleave") ) )
      {
	send_to_char("You don't know how to cleave.\n\r",ch);
	return;
      }

    if ( arg[0] == '\0' )
    {
	send_to_char( "Cleave whom?\n\r", ch );
	return;
    }

    if ( ( victim = get_char_room( ch, NULL, arg ) ) == NULL )
    {
	send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( victim == ch )
    {
	send_to_char( "How can you sneak up on yourself?\n\r", ch );
	return;
    }

    if ( is_safe( ch, victim ) )
        return;

    if ( ( obj = get_eq_char( ch, WEAR_WIELD ) ) == NULL)
    {
	send_to_char( "You need to wield a weapon to cleave.\n\r", ch );
	return;
    }

    if ( (victim->hit < (0.9 * victim->max_hit)) &&
	 (IS_AWAKE(victim)) )
    {
	act( "$N is hurt and suspicious ... you can't sneak up.",
	    ch, NULL, victim, TO_CHAR );
	return;
    }

    WAIT_STATE( ch, skill_table[skill_lookup("cleave")].beats );
    if ( !IS_AWAKE(victim)
    ||   IS_NPC(ch)
    ||   number_percent( ) < get_skill(ch,skill_lookup("cleave")) )
    {
	check_improve(ch,skill_lookup("cleave"),TRUE,1);
	multi_hit(ch,victim,skill_lookup("cleave"));
    }
    
    else
    {
	check_improve(ch,skill_lookup("cleave"),FALSE,1);
	damage( ch, victim, 0, skill_lookup("cleave"),DAM_NONE, TRUE );
    }
  
    return;
}

void do_blackjack(CHAR_DATA *ch, char *argument)
{
    CHAR_DATA *victim;
    int chance;

    if ( MOUNTED(ch) ) 
    {
        send_to_char("You can't blackjack while riding!\n\r", ch);
        return;
    }

    if ( IS_NPC(ch) ||
	!can_use_skpell( ch, skill_lookup("blackjack") ) )

    {
	send_to_char("You can't do that.\n\r",ch);
	return;
    }

    if ( (victim = get_char_room(ch,NULL,argument)) == NULL)
      {
	send_to_char("You do not see that person here.\n\r",ch);
	return;
      }

    if (ch == victim)
      {
	send_to_char("Why do you want to blackjack yourself?\n\r",ch);
	return;
      }

    if (is_safe(ch,victim))
        return;

    WAIT_STATE(ch,skill_table[skill_lookup("blackjack")].beats);

    chance = (int)(0.5 * get_skill(ch,skill_lookup("blackjack")));
    chance += URANGE( 0, (get_curr_stat(ch,STAT_DEX)-20)*2, 10);
    chance += can_see(victim, ch) ? 0 : 5;

    if ( IS_NPC(victim) )
	if ( victim->pIndexData->pShop != NULL )
	   chance -= 40;
 
      if (IS_NPC(ch) || 
 	number_percent() < chance)
      {
	act("You hit $N on the head as hard as you can and watch them fall to the ground with a thud.",
	    ch,NULL,victim,TO_CHAR);
	act("You feel a sudden pain erupting through your skull as your hit on the head!",
	    ch,NULL,victim,TO_VICT);
	act("$n smacks $N as hard as $S can on the back of the head causing them to fall on the ground in a heap!",
	    ch,NULL,victim,TO_NOTVICT);
	check_improve(ch,skill_lookup("blackjack"),TRUE,1);
	
	if (IS_AWAKE(victim))
	  victim->position = POS_SLEEPING;
      }

      else 
      {
        printf_to_char( ch, "You try desperately to hit %s over the back of the head but fail miserably!\n\r", victim->name );
	damage(ch,victim,ch->level / 2,skill_lookup("blackjack"),DAM_NONE, TRUE);
	check_improve(ch,skill_lookup("blackjack"),FALSE,1);
      }
}

void do_stake( CHAR_DATA *ch, char *argument )
{
  char arg[MAX_INPUT_LENGTH];
  CHAR_DATA *victim;
  int chance;

  one_argument(argument,arg);
 
  if ( (chance = get_skill(ch,skill_lookup("stake"))) &&
        !can_use_skpell( ch, skill_lookup("stake")))
    {	
	send_to_char("Stake? What's that?\n\r",ch);
	return;
    }

    if (arg[0] == '\0')
    {
	victim = ch->fighting;
	if (victim == NULL)
	{
	    send_to_char("Stake What undead??\n\r",ch);
	    return;
	}
    }

    else if ((victim = get_char_room(ch, NULL, arg)) == NULL)
    {
	send_to_char("They aren't here.\n\r",ch);
	return;
    }

    if (!IS_NPC(victim) && !IS_VAMPIRE( victim ) )
    {
	send_to_char("You cannot stake someone who isn't a vampire.\n\r",ch);
	return;
    }

    if (IS_NPC(victim) && (!is_name("vampire",victim->name) &&
			   !is_name("undead", victim->name) &&
			   !is_name("zombie", victim->name) &&
			   !is_name("corpse", victim->name))) 
    {

	send_to_char("You cannot stake this mob.\n\r",ch);
	return;
    }

    if (victim == ch)
    {
	send_to_char("You aren't undead.. you cannot stake yourself.\n\r",ch);
	return;
    }

    if (is_safe(ch,victim))
	return;


    if ( ch->master == victim)
    {
	act("But $N is your friend!",ch,NULL,victim,TO_CHAR);
	return;
    }

    /* modifiers */

    if (ch->size < victim->size)
	chance += (ch->size - victim->size) * 15;
    else
	chance += (ch->size - victim->size) * 10; 


    /* stats */
    chance -= GET_AC(victim,AC_PIERCE) /25;
    /* speed */
    if (IS_SET(ch->off_flags,OFF_FAST))
        chance += 10;
    if (IS_SET(victim->off_flags,OFF_FAST))
        chance -= 10;

    /* level */
    chance += (ch->level - victim->level);

    /* now the attack */
    if (number_percent() < chance )
    {
    
	act("$n has stuck a stake in your heart!",
		ch,NULL,victim,TO_VICT);
	act("You slam a stake into $N!",ch,NULL,victim,TO_CHAR);
	act("$n shoves a stake into $N .",
		ch,NULL,victim,TO_NOTVICT);
	check_improve(ch,skill_lookup("stake"),TRUE,1);

	DAZE_STATE(victim, 3 * PULSE_VIOLENCE);
	WAIT_STATE(ch,skill_table[skill_lookup("stake")].beats);
	victim->position = POS_RESTING;
	
	damage(ch,victim,((ch->level*(dice((int)ch->level/4,6))) + ch->level),skill_lookup("stake"),
	    DAM_PIERCE,TRUE);
	
    }

    else
    {
	damage(ch,victim,0,skill_lookup("stake"),DAM_PIERCE,TRUE);
	act("You fall flat on your face!",
	    ch,NULL,victim,TO_CHAR);
	act("$n falls flat on $s face.",
	    ch,NULL,victim,TO_NOTVICT);
	act("You evade $n's stake, causing $m to fall flat on $s face.",
	    ch,NULL,victim,TO_VICT);
	check_improve(ch,skill_lookup("stake"),FALSE,1);
	ch->position = POS_RESTING;
	WAIT_STATE(ch,skill_table[skill_lookup("stake")].beats * 3/2); 
    }

    check_killer(ch,victim);

}

void do_tail(CHAR_DATA *ch, char *argument)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    int chance, dam;
    int knock;

    one_argument(argument,arg);
    
    if (IS_NPC(ch) )
	return;

    if ( (chance = get_skill(ch,skill_lookup("tail"))) == 0
    ||   (IS_NPC(ch) && !IS_SET(ch->off_flags,OFF_TAIL))
    ||   (!IS_NPC(ch)
    &&    !can_use_skpell( ch, skill_lookup("tail") )))
    {   
	send_to_char("You don't have a tail to strike with like that.\n\r",ch);
        return;
    }
 
    if (arg[0] == '\0')
    {
        victim = ch->fighting;
        if (victim == NULL)
        {
            send_to_char("But you aren't fighting anyone!\n\r",ch);
            return;
        }
    }

    else if ((victim = get_char_room(ch,NULL,arg)) == NULL)
    {
        send_to_char("They aren't here.\n\r",ch);
        return;
    }

    chance = URANGE(5,chance,90);

    chance += (ch->level - victim->level);
    chance -= get_curr_stat(victim,STAT_DEX);
    chance += get_curr_stat(ch,STAT_DEX)/3;
    chance += get_curr_stat(ch,STAT_STR)/3;

	act("$n violently lashes out with $s tail.",ch,0,0,TO_ROOM);
	send_to_char("You violently lash out with your tail!\n\r",ch);    

    if (number_percent() > chance)
    {
	damage(ch,victim,0,skill_lookup("tail"),DAM_BASH,TRUE);
	return;
    }

    dam = dice(ch->level, 3);
    knock = (ch->level + 15);
        
    damage(ch,victim,dam,skill_lookup("tail"),DAM_BASH,TRUE);
    if (number_percent() < knock)
    {
	act("$n is sent crashing to the ground by the force of the blow!",victim,0,0,TO_ROOM);
	send_to_char("The tail strike sends you crashing to the ground!\n\r",victim);
	WAIT_STATE(victim,( 3 * PULSE_VIOLENCE/2));
    }
    WAIT_STATE(ch,2*PULSE_VIOLENCE);
    return;
}

void do_mobslay( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *victim;
    char arg[MAX_INPUT_LENGTH];

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Mobslay who?\n\r", ch );
	return;
    }

    if ( ( victim = get_char_room( ch, NULL, arg ) ) == NULL )
    {
	send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( ch == victim )
    {
	send_to_char( "Suicide is a mortal sin.\n\r", ch );
	return;
    }

    if ( !IS_NPC(victim))
    {
	send_to_char( "You failed.\n\r", ch );
	return;
    }

    act( "You slay $M in cold blood!",  ch, NULL, victim, TO_CHAR    );
    act( "$n slays you in cold blood!", ch, NULL, victim, TO_VICT    );
    act( "$n slays $N in cold blood!",  ch, NULL, victim, TO_NOTVICT );
    raw_kill( victim, ch );
    return;
}


void do_rub( CHAR_DATA *ch, char *argument)
{
 int chance;

 if ( IS_NPC( ch ) )
 {
     send_to_char( "Sorry dude you can't rub your a mob!\n\r", ch );
     return;
 }

 if ((chance = get_skill(ch,skill_lookup("rub"))) == 0
    || !can_use_skpell( ch, skill_lookup("rub") ) )
 {
      send_to_char("You don't know the first thing about rubbing your eyes.\n\r",ch);
      return;
 }


 if(!is_affected(ch,skill_lookup("fire breath")) && !is_affected(ch,skill_lookup("dirt")))
 {
  send_to_char("Rubbing won't help that!\n\r",ch);
  return;
 }

 WAIT_STATE(ch,skill_table[skill_lookup("rub")].beats);
 chance = (chance*3)/4;
 if(number_percent()>chance)
 {
  send_to_char("You failed to rub your eyes clear!\n\r",ch);
  check_improve(ch,skill_lookup("rub"),FALSE,2);
  return;
 }

 if(is_affected(ch,skill_lookup("fire breath")))
  affect_strip(ch,skill_lookup("fire breath"));
 if(is_affected(ch,skill_lookup("dirt")))
  affect_strip(ch,skill_lookup("dirt"));
 send_to_char("You rubbed your eyes clear!\n\r",ch);
 check_improve(ch,skill_lookup("rub"),TRUE,2);
 return;

}


void do_throatchop( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA *obj;

    one_argument( argument, arg );

    if (arg[0] == '\0')
    {
        send_to_char("Chop who's throat?\n\r",ch);
        return;
    }

    if (ch->fighting != NULL)
    {
	send_to_char("You can't get at thier throat!\n\r",ch);
	return;
    }
 
    else if ((victim = get_char_room(ch, NULL, arg)) == NULL)
    {
        send_to_char("They aren't here.\n\r",ch);
        return;
    }

    if ( victim == ch )
    {
	send_to_char( "How can you sneak up on yourself?\n\r", ch );
	return;
    }

    if ( is_safe( ch, victim ) )
      return;


    if ( ( obj = get_eq_char( ch, WEAR_WIELD ) ) == NULL)
    {
	send_to_char( "You need to wield a weapon to chop thier throat.\n\r", ch );
	return;
    }

    if ( victim->hit < victim->max_hit / 2)
    {
	act( "$N is far to suspicious to be chopped.",
	    ch, NULL, victim, TO_CHAR );
	return;
    }

    check_killer( ch, victim );
    WAIT_STATE( ch, skill_table[skill_lookup("throatchop")].beats );
    if ( number_percent( ) < get_skill(ch,skill_lookup("throatchop"))
    || ( get_skill(ch,skill_lookup("throatchop")) >= 2 && !IS_AWAKE(victim) ) )
    {
	check_improve(ch,skill_lookup("throatchop"),TRUE,1);
	multi_hit( ch, victim, skill_lookup("throatchop") );
    }
    else
    {
	check_improve(ch,skill_lookup("throatchop"),FALSE,1);
	damage( ch, victim, 0, skill_lookup("throatchop"),DAM_NONE,TRUE);
    }

    return;
}



void do_rally(CHAR_DATA *ch, char *argument)
{
     CHAR_DATA *gch;
     int heal;
     int chance;

     if ((chance = get_skill(ch, skill_lookup("rally")) == 0 ) )
     {
          send_to_char("You scream and holler, but nobody listens.\n\r",ch);
          return;
     }


     if (ch->position == POS_FIGHTING)
          chance += 25;

     if (number_percent() > chance)
     {
          send_to_char("You try to rally your companions, but your efforts fail.\n\r", ch);
          act("$n tries to rally $s companions, but fails.",ch,NULL,NULL,TO_ROOM);
          WAIT_STATE(ch,PULSE_VIOLENCE * 2);
          return;
     }

     send_to_char("You call your companions to arms, promising them glory!\n\r", ch);
     act("$n calls $s companions to arms, promising great glory!", ch, NULL, NULL, TO_ROOM);

     for ( gch = IN_ROOM(ch)->people; gch != NULL; gch = gch->next_in_room )
     {
          if ( gch != ch && is_same_group(ch, gch) )
          {
               if ( !is_affected(gch,skill_lookup("rally") ) )
               {
                    AFFECT_DATA af;
                    send_to_char ("You answer the call to arms!\n\r", gch);

                    check_improve(ch,skill_lookup("rally"),TRUE,2);

                    af.type         = skill_lookup("rally");
                    af.level        = ch->level;
                    af.duration     = number_fuzzy(UMAX(2,ch->level / 8) );
                    af.modifier     = UMAX(1,ch->level/5);

                    af.bitvector = 0;

                    af.location     = APPLY_HITROLL;
                    af.where = TO_AFFECTS;
                    affect_to_char(gch,&af);

                    af.location     = APPLY_DAMROLL;
                    affect_to_char(gch,&af);

                    af.modifier = UMAX(1, ch->level/10);
                    af.location   = APPLY_STR;
                    affect_to_char(gch,&af);

               }
		/* Always do this part */

               heal = dice(1, ch->level) + ch->level / 3;
               gch->hit = UMIN( gch->hit + heal, gch->max_hit );
               send_to_char("You feel better!\n\r", gch);

               update_pos( gch );
          }
     }

     WAIT_STATE(ch,PULSE_VIOLENCE * 2);

}

void do_punch( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *victim;
    int number = 0;

    number = number_range( 0, 5 );

    if ( !IS_NPC(ch)
    &&   !can_use_skpell(ch, skill_lookup("punch")) )
    {
	send_to_char(
	    "You better leave the martial arts to fighters.\n\r", ch );
	return;
    }

    if ( MOUNTED(ch) )
    {
        send_to_char("You can't punch while riding!\n\r", ch);
        return;
    }

    if ( ( victim = ch->fighting ) == NULL )
    {
	send_to_char( "You aren't fighting anyone.\n\r", ch );
	return;
    }

    WAIT_STATE( ch, skill_table[skill_lookup("punch")].beats );
    if ( get_skill(ch,skill_lookup("punch")) > number_percent())
    {
	damage(ch,victim,number_range( 50, ch->level + 100 / 2 ), skill_lookup("punch"),DAM_BASH,TRUE);
        DAZE_STATE( victim, 3 * PULSE_VIOLENCE );
	check_improve(ch,skill_lookup("punch"),TRUE,1);
        if ( number <= 1 )
        {
            printf_to_char( ch, "You make a series of lightning fast punches right to %ss head!\n\r", victim->short_descr );
            damage(ch,victim,number_range( 80, ch->level + 100 / 2 ), skill_lookup("punch"), DAM_BASH, TRUE );
            damage(ch,victim,number_range( 80, ch->level + 100 / 2 ), skill_lookup("punch"), DAM_BASH, TRUE );
            check_improve(ch,skill_lookup("punch"),TRUE,1);
        }
    }
    else
    {
	damage( ch, victim, 0, skill_lookup("punch"),DAM_BASH,TRUE);
	check_improve(ch,skill_lookup("punch"),FALSE,1);
    }
	
    check_killer(ch,victim);
    return;
}

/* MARK - Add these ~ Davion */

bool check_tumble( CHAR_DATA *ch, CHAR_DATA *victim )
{
    int chance, skill;
    if (IS_NPC(victim))
	return FALSE;
    if (victim->level < skill_table[skill_lookup("tumble")].skill_level[victim->clss])
       return FALSE;
    if ( !IS_AWAKE(victim) )
        return FALSE;
    skill = victim->pcdata->learned[skill_lookup("tumble")];
    if( skill <= 1 )
        return FALSE;

    chance  = victim->pcdata->learned[skill_lookup("tumble")] / 7;/*was (2)*/
    chance += get_curr_stat(victim, STAT_DEX) / 8;/*was (3)*/
    chance -= ch->hitroll /9 + (ch->level <=5) + (ch->level <= 10);  /*was ()*/
    if ( number_percent( ) >= chance + victim->level - ch->level )
        return FALSE;
    act( "You tumble away from $n's blow.", ch, NULL, victim, TO_VICT    );
    act( "$N tumbles away from your blow.", ch, NULL, victim, TO_CHAR    );
    check_improve(victim,skill_lookup("tumble"),TRUE,6);
    return TRUE;
}

bool check_evade( CHAR_DATA *ch, CHAR_DATA *victim )
{
    int chance, skill;
    if (IS_NPC(victim))
	return FALSE;
    if ( !IS_AWAKE(victim) )
        return FALSE;
    if (victim->level < skill_table[skill_lookup("evade")].skill_level[victim->clss])
       return FALSE;
    skill = victim->pcdata->learned[skill_lookup("evade")];
    if( skill <= 1 )
        return FALSE;

    chance  = victim->pcdata->learned[skill_lookup("evade")] / 5;/*was (2)*/
    chance += get_curr_stat(victim, STAT_DEX)/6;/*was (4)*/
    chance -= ch->hitroll /9 + (ch->level <=5) + (ch->level <= 10);  
    if ( number_percent( ) >= chance + victim->level - ch->level )
        return FALSE;
    act( "You evade $n's attack.", ch, NULL, victim, TO_VICT    );
    act( "$N skillfully evades your attack.", ch, NULL, victim, TO_CHAR );
    check_improve(victim,skill_lookup("evade"),TRUE,6);
    return TRUE;
}

bool check_acrobatics( CHAR_DATA *ch, CHAR_DATA *victim )
{
    int chance, skill;
    if (IS_NPC(victim))
	return FALSE;
    if ( !IS_AWAKE(victim) )
        return FALSE;
    if (victim->level < skill_table[skill_lookup("acrobatics")].skill_level[victim->clss])
       return FALSE;
    skill = victim->pcdata->learned[skill_lookup("acrobatics")];
    if( skill <= 1 )
        return FALSE;

    chance  = victim->pcdata->learned[skill_lookup("acrobatics")] / 3;/*was (2)*/
    chance += get_curr_stat(victim, STAT_DEX) /3;/*was (2)*/
    chance -= ch->hitroll /9 + (ch->level <=5) + (ch->level <= 10);  
    if ( number_percent( ) >= chance + victim->level - ch->level )
        return FALSE;
    act( "You flip aside, avoiding $n's attack.", ch, NULL, victim, TO_VICT    );
    act( "$N flips away from your attack.", ch, NULL, victim, TO_CHAR    );
    check_improve(victim,skill_lookup("acrobatics"),TRUE,6);
    return TRUE;
}

bool check_blink( CHAR_DATA *ch, CHAR_DATA *victim )
{
    int chance, skill;

    if (IS_NPC(victim))
	return FALSE;
    if ( !IS_AWAKE(victim) )
        return FALSE;
    if (victim->level < skill_table[skill_lookup("blink")].skill_level[victim->clss])
       return FALSE;
    skill = victim->pcdata->learned[skill_lookup("blink")];
    if( skill <= 1 )
        return FALSE;

    chance  = victim->pcdata->learned[skill_lookup("blink")] / 1;

    if ( !IS_AWAKE(victim) )
        return FALSE;

    if (!can_see(victim,ch))
        chance /= 1;

    if ( number_percent( ) >= chance + victim->level - ch->level )
        return FALSE;
    act( "You blink out of existence and avoid $n's attack.", ch,NULL, victim, TO_VICT    );
    act( "$N seems to blink out of existence as you strike thin air.",ch, NULL, victim, TO_CHAR    );

    check_improve(victim,skill_lookup("blink"),TRUE,6);
    return TRUE;
}

void do_ambush( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    int fight;
    one_argument( argument, arg );
    if ( arg[0] == '\0' )
    {
        send_to_char( "Who are you ambushing?\n\r", ch );
        return;
    }
    if( !IS_NPC(ch) && ch->pcdata->learned[skill_lookup("ambush")] < 1 )
    {
        send_to_char( "You don't know how to ambush people.\n\r", ch );
        return;
    }


   
    if ( ( victim = get_char_room( ch, NULL, arg) ) == NULL )
    {
        send_to_char( "They aren't here.\n\r", ch );
        return;
    }
    if ( victim == ch )
    {
        send_to_char( "Just how do you ambush yourself?\n\r", ch );
        return;
    }
       
     if ( victim->hit < victim->max_hit * 3 / 5 )    
    {
        act("$N is in fear for $S life, and is too aware to be ambushed.",
            ch, NULL, victim, TO_CHAR );
        return;
    }
  
    if ( is_safe( ch, victim ) )
      return;

    if ( ( obj = get_eq_char( ch, WEAR_WIELD ) ) == NULL)
    {
        send_to_char( "You need to wield a weapon to ambush someone.\n\r", ch );
        return;
    }

    fight =0;
    if ( victim->position <= POS_SLEEPING )
        fight = 1;
    check_killer( ch, victim );
    WAIT_STATE( ch, skill_table[skill_lookup("ambush")].beats );
    if ( !IS_AWAKE(victim)
    ||   IS_NPC(ch)
    ||   number_percent( ) < ch->pcdata->learned[skill_lookup("ambush")] )
    {
        check_improve(ch,skill_lookup("ambush"),TRUE,1);
        one_hit( ch, victim, skill_lookup("ambush"),FALSE );
    }
        check_improve(ch,skill_lookup("ambush"),FALSE,1);
        damage( ch, victim, 0, skill_lookup("ambush") ,DAM_NONE,0 );
    
}

void do_headbutt( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *victim;

	 if(get_skill(ch,skill_lookup("headbutt"))==0)
	 {
		 send_to_char("Thats beyond your skills.\n\r",ch);
		 return;
	 }

    if ( !IS_NPC(ch)
    &&   ch->level < skill_table[skill_lookup("headbutt")].skill_level[ch->clss] )
    {
	send_to_char(
	    "You do not have horns.\n\r", ch );
	return;
    }

    if ( ( victim = ch->fighting ) == NULL )
    {
	send_to_char( "You aren't fighting anyone.\n\r", ch );
	return;
    }

    WAIT_STATE( ch, skill_table[skill_lookup("headbutt")].beats );
    if ( get_skill(ch,skill_lookup("headbutt")) > number_percent())
    {
	damage(ch,victim,number_range( 30, ch->level ), skill_lookup("headbutt"),DAM_BASH,TRUE);
	check_improve(ch,skill_lookup("headbutt"),TRUE,1);
    }
    else
    {
	damage( ch, victim, 0, skill_lookup("headbutt"),DAM_BASH,TRUE);
	check_improve(ch,skill_lookup("headbutt"),FALSE,1);
    }
	check_killer(ch,victim);
    return;

}

void do_caltraps(CHAR_DATA *ch, char *argument)
{
  CHAR_DATA *victim = ch->fighting;
  AFFECT_DATA af; 

  if (IS_NPC(ch) || ch->pcdata->learned[skill_lookup("caltraps")] < 1)
    {
      send_to_char("Huh?\n\r",ch);
      return;
    }

  if (victim == NULL)
    {
      send_to_char("You must be in combat.\n\r",ch);
      return;
    }

  if (is_safe(ch,victim))
    return;


  act("You throw a handful of sharp spikes at the feet of $N.",
      ch,NULL,victim,TO_CHAR);
  act("$n throws a handful of sharp spikes at your feet!",
      ch,NULL,victim,TO_VICT);

  WAIT_STATE(ch,skill_table[skill_lookup("caltraps")].beats);

  if (!IS_NPC(ch) && number_percent() >= ch->pcdata->learned[skill_lookup("caltraps")])
    {
      damage(ch,victim,0,skill_lookup("caltraps"),DAM_PIERCE,0);
      check_improve(ch,skill_lookup("caltraps"),FALSE,1);
      return;
    }

  damage(ch,victim,ch->level / 3,skill_lookup("caltraps"),DAM_PIERCE,0);

  if (!is_affected(victim,skill_lookup("caltraps")))
  {


    af.type         = skill_lookup("caltraps");
    af.level        = ch->level;
    af.duration     = 2;
    af.location     = APPLY_HITROLL;
    af.modifier     = -5;
    af.bitvector    = 0;
    affect_to_char(victim,&af);

    af.location     = APPLY_DEX;
    affect_to_char(victim,&af);

    af.location     = APPLY_DAMROLL;
    affect_to_char(victim,&af);

    act("$N starts limping.",ch,NULL,victim,TO_CHAR);
    act("You start to limp.",ch,NULL,victim,TO_VICT);
    check_improve(ch,skill_lookup("caltraps"),TRUE,1);


  }
}

void do_nerve_pinch(CHAR_DATA *ch, char *argument)
{
  CHAR_DATA *victim;
  char arg[MAX_INPUT_LENGTH];

  if(get_skill(ch,skill_lookup("nerve pinch"))==0)
	 {
		 send_to_char("Thats beyond your skills.\n\r",ch);
		 return;
	 }

  one_argument(argument,arg);
  if (ch->level < skill_table[skill_lookup("nerve pinch")].skill_level[ch->clss] )
    {
      send_to_char( "Huh?\n\r", ch );
      return;
    }
  if (ch->fighting == NULL)
    {
      send_to_char("You aren't fighting anyone.\n\r",ch);
      return;
    }

  victim = ch->fighting;

  if (is_safe(ch,victim))
	  return;

  if (is_affected(victim,skill_lookup("nerve pinch")))
    {
      send_to_char("That person's nerves are already in kinks.\n\r",ch);
      WAIT_STATE( ch, skill_table[skill_lookup("nerve pinch")].beats );
      return;
    }
  check_killer(ch,victim);
   WAIT_STATE( ch, skill_table[skill_lookup("nerve pinch")].beats );

  if (IS_NPC(ch) ||
      number_percent() < (ch->pcdata->learned[skill_lookup("nerve pinch")] + ch->level
                         + get_curr_stat(ch,STAT_DEX))/2)
    {
      AFFECT_DATA af;

      af.type   = skill_lookup("nerve pinch");
      af.level  = ch->level;
      af.duration = ch->level * PULSE_VIOLENCE/PULSE_TICK;
      af.location = APPLY_STR;
      af.modifier = -3;
      af.bitvector = 0;

      affect_to_char(victim,&af);
      act("$N screams in agony with your nerve pinch.",ch,NULL,victim,TO_CHAR);
      act("$n causes you great discomfort with $s nerve pinch.",ch,NULL,victim,TO_VICT);
      act("$n makes $N scream in agony with $s nerve pinch.",ch,NULL,victim,TO_NOTVICT);
      check_improve(ch,skill_lookup("nerve pinch"),TRUE,1);
    }
  else
    {
      send_to_char("You attack, but don't pinch the right spots and fail.\n\r",ch);
      act("$n tries to attack you with a nerve pinch, but fails.",
          ch,NULL,victim,TO_VICT);
      act("$n tries to attack $N with a nerve pinch, but fails.",
          ch,NULL,victim,TO_NOTVICT);
      check_improve(ch,skill_lookup("nerve pinch"),FALSE,1);
    }

    multi_hit(victim,ch,TYPE_UNDEFINED);
}

bool check_sidestep( CHAR_DATA *ch, CHAR_DATA *victim )
{
    int chance, skill;
    if (IS_NPC(victim))
	return FALSE;
    if (victim->level < skill_table[skill_lookup("sidestep")].skill_level[victim->clss])
       return FALSE;
    if ( !IS_AWAKE(victim) )
        return FALSE;
    skill = victim->pcdata->learned[skill_lookup("sidestep")];
    if( skill <= 1 )
        return FALSE;

    chance  = victim->pcdata->learned[skill_lookup("sidestep")] / 5;
    chance += get_curr_stat(victim, STAT_DEX)/6;
    chance -= ch->hitroll /9 + (ch->level <=5) + (ch->level <= 10);  
    if ( number_percent( ) >= chance + victim->level - ch->level )
        return FALSE;
    act( "You sidestep $n's attack.", ch, NULL, victim, TO_VICT    );
    act( "$N sidesteps your attack.", ch, NULL, victim, TO_CHAR    );
    check_improve(victim,skill_lookup("sidestep"),TRUE,6);
    return TRUE;
}

void do_stab(CHAR_DATA *ch, char *argument)
{
  CHAR_DATA *victim = ch->fighting;
  AFFECT_DATA af; 
  OBJ_DATA *wield;
  USE *use;
  wield = get_eq_char( ch, WEAR_WIELD );


  
  if (IS_NPC(ch) || ch->pcdata->learned[skill_lookup("stab")] < 1)
    {
      send_to_char("Huh?\n\r",ch);
      return;
    }

    if ( wield == NULL )
	{
	send_to_char("You can only stab while wielding a dagger.\n\r",ch);
	return;
	}
	use = get_obj_use(wield, UTYPE_WEAPON);
    if ( use->value[0] != WEAPON_DAGGER )
	{
	send_to_char("You can only stab while wielding a dagger.\n\r",ch);
	return;
	}

  if (victim == NULL)
    {
      send_to_char("You must be in combat.\n\r",ch);
      return;
    }

  if (is_safe(ch,victim))
    return;

/*  act("You stab your dagger in $N's stomach.",
      ch,NULL,victim,TO_CHAR);
  act("$n stabs you in your stomach with their dagger.",
      ch,NULL,victim,TO_VICT);
*/
  WAIT_STATE(ch,skill_table[skill_lookup("stab")].beats);

  if (!IS_NPC(ch) && number_percent() >= ch->pcdata->learned[skill_lookup("stab")])
    {
      damage(ch,victim,0,skill_lookup("stab"),DAM_PIERCE,0);
      check_improve(ch,skill_lookup("stab"),FALSE,1);
      return;
    }

  damage(ch,victim,ch->level / 3,skill_lookup("stab"),DAM_PIERCE,0);

  if (!is_affected(victim,skill_lookup("stab")))
  {


    af.type         = skill_lookup("stab");
    af.level        = ch->level;
    af.duration     = 6;
    af.location     = APPLY_DAMROLL;
    af.modifier     = -5;
    af.bitvector    = 0;
    affect_to_char(victim,&af);

    af.location     = APPLY_STR;
    affect_to_char(victim,&af);

 /*   act("$N starts bleeding badly from your stab.",ch,NULL,victim,TO_CHAR);
    act("You start to bleeding badly from your wound.",ch,NULL,victim,TO_VICT);*/
    check_improve(ch,skill_lookup("stab"),TRUE,1);
    one_hit(ch, victim, skill_lookup("stab"),FALSE);


  }
}
/*
void do_bear_call( CHAR_DATA *ch, char *argument )
{
  CHAR_DATA *gch;
  CHAR_DATA *bear;
  CHAR_DATA *bear2;
  AFFECT_DATA af;
  int i;
  
  if ( IS_NPC(ch) ||
	 ch->level < skill_table[skill_lookup("bear call")].skill_level[ch->clss] )
    {
      send_to_char("The bears won't listen to you.\n\r", ch);
      return;
    }

  if (is_affected(ch, skill_lookup("bear call")))
    {
      send_to_char("You cannot handle more bears right now.\n\r", ch);
      return;
    }

  if (ch->move < skill_table[skill_lookup("bear call")].min_mana)
    {
      send_to_char("You can't concentrate enough.\n\r", ch);
      return;
    }

  for (gch = char_list; gch != NULL; gch = gch->next)
    {
      if (IS_NPC(gch) && gch->master == ch &&
	  gch->pIndexData->vnum == MOB_VNUM_BEAR)
	{
	  send_to_char("What's wrong with the bear you've got?",ch);
	  return;
	}
    }

  if (number_percent() > get_skill(ch, skill_lookup("bear call")))
    {
      send_to_char("The bears fail to respond to your call.\n\r", ch);
      check_improve(ch, skill_lookup("bear call"), FALSE, 2);
      ch->move -= skill_table[skill_lookup("bear call")].min_mana / 2;
      return;
    }

  ch->move -= skill_table[skill_lookup("bear call")].min_mana;

  bear = create_mobile( get_mob_index(MOB_VNUM_BEAR) );

  for (i=0;i < MAX_STATS; i++)
    {
      bear->perm_stat[i] = UMIN(25,2 * ch->perm_stat[i]);
    }

  bear->max_hit = IS_NPC(ch)? ch->max_hit : ch->pcdata->perm_hit;
  bear->hit = bear->max_hit;
  bear->max_mana = IS_NPC(ch)? ch->max_mana : ch->pcdata->perm_mana;
  bear->mana = bear->max_mana;
  bear->alignment = ch->alignment;
  bear->level = UMIN(70,ch->level);
  for (i=0; i < 3; i++)
    bear->armor[i] = interpolate(bear->level,100,-100);
  bear->armor[3] = interpolate(bear->level,100,0);
  bear->gold = 0;

  if (IN_ROOM(ch)->sector_type == SECT_FOREST)
    {
    bear->name = str_dup("polar bear");
    bear->short_descr = str_dup("a polar bear");
    bear->long_descr = str_dup("A hulking polar bear is here.\n\r");
    bear->damroll += 10;
	}

  bear2 = create_mobile(bear->pIndexData);
  clone_mobile(bear,bear2);
  
  bear->master = bear2->master = ch;
  bear->leader = bear2->leader = ch;

  char_to_room(bear,IN_ROOM(ch));
  char_to_room(bear2,IN_ROOM(ch));
  send_to_char("Two bears come to your rescue!\n\r",ch);
  act("Two bears come to $n's rescue!",ch,NULL,NULL,TO_ROOM);

  af.type               = skill_lookup("bear call");
  af.level              = ch->level; 
  af.duration           = 24;
  af.bitvector          = 0;
  af.modifier           = 0;
  af.location           = APPLY_NONE;
  affect_to_char(ch, &af); 

  check_improve(ch, skill_lookup("bear call"), TRUE, 1);
  return;
}
*/
void do_lunge( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *victim;
    OBJ_DATA *wield;
	USE *use;

	wield = get_eq_char( ch, WEAR_WIELD );

	 if(get_skill(ch,skill_lookup("lunge"))==0)
	 {
		 send_to_char("Thats beyond your skills.\n\r",ch);
		 return;
	 }

    if ( !IS_NPC(ch)
    &&   ch->level < skill_table[skill_lookup("lunge")].skill_level[ch->clss] )
    {
        send_to_char(
            "Hmm?\n\r", ch );
        return;
    }
    if ( ( victim = ch->fighting ) == NULL )
    {
        send_to_char( "You aren't fighting anyone.\n\r", ch );
        return;
    }
    if ( wield == NULL )
	{
	send_to_char("You can only successfully lunge while wielding a sword.\n\r",ch);
	return;
	}
	use = get_obj_use(wield, UTYPE_WEAPON);
    if ( use->value[0] != WEAPON_SWORD )
	{
	send_to_char("You can only successfully lunge while wielding a sword.\n\r",ch);
	return;
	}
   
    WAIT_STATE( ch, skill_table[skill_lookup("lunge")].beats );
    if ( IS_NPC(ch) || number_percent( ) < ch->pcdata->learned[skill_lookup("lunge")] )
    {
	act ("$n thrusts $s sword forward in a swift, close range lunge.",
           ch, NULL, NULL, TO_ROOM);
	act ("You thrust your sword forward in a swift, close range lunge.", 
           ch, NULL, NULL, TO_CHAR); 
        damage( ch, victim, number_range( 75, ch->level+25 ), skill_lookup("lunge"),DAM_SLASH,1);
        check_improve(ch,skill_lookup("lunge"),TRUE,1);
	}
    else
    {
        damage( ch, victim, number_range( 75, ch->level+25 ), skill_lookup("lunge"),DAM_SLASH,1 );
        check_improve(ch,skill_lookup("lunge"),FALSE,1);
    }

    return;
}

void do_divine_healing( CHAR_DATA *ch, char *argument )
{
    /* Rhien (Blake Pell - rhien@dsl-mud.org <mailto:rhien@dsl-mud.org>), 3-07-2002
       Dark and Shattered Lands: <http://www.dsl-mud.org>
       This snippet is for public use as long as this comment block stays in tact */ 

    CHAR_DATA *victim;
	int chance;

	if ((chance = get_skill(ch,skill_lookup("divine healing"))) == 0)
    {
        send_to_char( "You don't know how to do that.\n\r", ch );
        return;
    }

    if (ch->move <= 100 || ch->mana <= 200 || ch->hit <= 800)
    {
        send_to_char("You are far too weak at the moment to use such an ability.\n\r", ch);
        return;
    }

    if ( argument[0] == '\0' )
    {
        send_to_char("You must specify somebody who deserves such a gift.\n\r", ch);
        return;
    } 

    if ( ( victim = get_char_room( ch,NULL, argument ) ) == NULL )
    {
        send_to_char("They are not here.\n\r", ch);
        return;
    } 

/*    if ( ch->pc_class != CLERIC_CLASS_LOOKUP )
    {
        send_to_char("Only those closest to their gods may give divine healing.\n\r", ch);
        return;
    } 
*/
    if ( IS_NPC(victim) || 
         ch->alignment != victim->alignment)
    {
        send_to_char("You cannot give them such a gift.\n\r", ch);
    } 

    // Now, the effects of the healing onto the players
    ch->hit = 100;
    ch->mana = 20;
    ch->move = 20; 
    victim->hit = victim->max_hit;
    victim->mana = victim->max_mana;
    victim->move = victim->max_move; 

    act( "$n kneels to the ground and calls to the gods!",ch, NULL, NULL, TO_ROOM );
    send_to_char("You kneel to the ground and call to the gods!\n\r", ch); 

    return;

}

void do_tame( CHAR_DATA *ch, char *argument )
{

    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    int chance;

    one_argument(argument,arg);

    if ( (chance = get_skill(ch,skill_lookup("tame"))) == 0
    ||   (!IS_NPC(ch)
    &&    ch->level < skill_table[skill_lookup("tame")].skill_level[ch->clss]))
    {
        send_to_char("Maybe you ought to practice on the cat at home first.\n\r",ch);
        return;
    }

    if (arg[0] == '\0')
    {
        victim = ch->fighting;
        if (victim == NULL)
        {
            send_to_char("Tame who?\n\r",ch);
            return;
        }
    }
    else if ((victim = get_char_room(ch,NULL, arg)) == NULL)
    {
        send_to_char("It's much easier to tame things that aren't here, huh?\n\r",ch);
        return;
    }
 
    if (victim->position < POS_RESTING)
    {
        act("Let $M wake up first.",ch,NULL,victim,TO_CHAR);
        return;
    }
    if (victim == ch)
    {
        send_to_char("You try hard to keep your temper in check.\n\r",ch);
        return;
    }

    if (is_safe(ch,victim))
        return;


    if (!IS_NPC(victim))
    {
        send_to_char("You can't tame another player!\n\r",ch);
        return;
    }


    if (!IS_SET((victim)->act,ACT_AGGRESSIVE))
    {
        send_to_char("They look pretty tame already.\n\r", ch);
        return;
    }

    /* Modifiers */

    /* Harder to tame a fighting person */
    if (victim->position == POS_FIGHTING)
        chance -= 10;

    /* Easier to tame when one is not waving a weapon about */
    if ( ( obj = get_eq_char( victim, WEAR_WIELD ) ) == NULL )
        chance += 10;
    else
        chance -= 10;

    if (number_percent() < chance + 2*(ch->level - victim->level))
    {
        stop_fighting(victim, TRUE);
        REMOVE_BIT(victim->act,ACT_AGGRESSIVE);

        /* Tamed creatures shouldn't assist */
        if ( IS_SET((victim)->off_flags, ASSIST_ALL) )
            REMOVE_BIT(victim->off_flags, ASSIST_ALL);
        if ( IS_SET((victim)->off_flags, ASSIST_ALIGN) )
            REMOVE_BIT(victim->off_flags, ASSIST_ALIGN);
        if ( IS_SET((victim)->off_flags, ASSIST_RACE) )
            REMOVE_BIT(victim->off_flags, ASSIST_RACE);
        if ( IS_SET((victim)->off_flags, ASSIST_PLAYERS) )
            REMOVE_BIT(victim->off_flags, ASSIST_PLAYERS);
        if ( IS_SET((victim)->off_flags, ASSIST_GUARD) )
            REMOVE_BIT(victim->off_flags, ASSIST_GUARD);
        if ( IS_SET((victim)->off_flags, ASSIST_VNUM) )
            REMOVE_BIT(victim->off_flags, ASSIST_VNUM);

        send_to_char("You have succeeded in taming the beast.\n\r", ch);
        send_to_char("You feel very tame.\n\r", victim);
        act("$n successfully tames $N!",
        ch,NULL,victim,TO_ROOM);

        check_improve(ch,skill_lookup("tame"),TRUE,1);

        WAIT_STATE(ch,skill_table[skill_lookup("tame")].beats);
    }
    else
    {
        send_to_char("You feel a wave of calm, but you're still MAD!\n\r", victim);
        act("$n attempts to tame $N, but fails.",
            ch,NULL,victim,TO_NOTVICT);
        act("You attempt to tame $N, but fail.",
            ch,NULL,victim,TO_CHAR);
        check_improve(ch,skill_lookup("bash"),FALSE,1);
        WAIT_STATE(ch,skill_table[skill_lookup("tame")].beats);
    }
}

void do_fire_arrow( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *victim;
    OBJ_DATA *wield;
    USE *use;

	wield = get_eq_char( ch, WEAR_WIELD );

	 if(get_skill(ch,skill_lookup("fire arrow"))==0)
	 {
		 send_to_char("Thats beyond your skills.\n\r",ch);
		 return;
	 }

    if ( !IS_NPC(ch)
    &&   ch->level < skill_table[skill_lookup("fire arrow")].skill_level[ch->clss] )
    {
        send_to_char("Hmm?\n\r", ch );
        return;
    }
    if ( ( victim = ch->fighting ) == NULL )
    {
        send_to_char( "You aren't fighting anyone.\n\r", ch );
        return;
    }
    if ( wield == NULL )
	{
	send_to_char("You can only use arrows with wielding a bow.\n\r",ch);
	return;
	}
	use = get_obj_use(wield, UTYPE_WEAPON);
    if ( use->value[0] != WEAPON_BOW )
	{
	send_to_char("You can only use arrows with wielding a bow.\n\r",ch);
	return;
	}
    if (ch->mana < 11)
    {
	send_to_char("You don't have the power right now.\n\r",ch);
	return;
    }

	ch->mana -= 11;
   
    WAIT_STATE( ch, skill_table[skill_lookup("fire arrow")].beats );
    if ( IS_NPC(ch) || number_percent( ) < ch->pcdata->learned[skill_lookup("fire arrow")] )
    {
        damage( ch, victim, number_range( 300, ch->level+50 ), skill_lookup("fire arrow"),DAM_FIRE,1);
        check_improve(ch,skill_lookup("fire arrow"),TRUE,1);
	}
    else
    {
        damage( ch, victim, number_range( 300, ch->level+50 ), skill_lookup("fire arrow"),DAM_FIRE,1 );
        check_improve(ch,skill_lookup("fire arrow"),FALSE,1);
    }

    return;
}

void do_ice_arrow( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *victim;
    OBJ_DATA *wield;
    USE *use;
	wield = get_eq_char( ch, WEAR_WIELD );

	 if(get_skill(ch,skill_lookup("ice arrow"))==0)
	 {
		 send_to_char("Thats beyond your skills.\n\r",ch);
		 return;
	 }

    if ( !IS_NPC(ch)
    &&   ch->level < skill_table[skill_lookup("ice arrow")].skill_level[ch->clss] )
    {
        send_to_char("Hmm?\n\r", ch );
        return;
    }
    if ( ( victim = ch->fighting ) == NULL )
    {
        send_to_char( "You aren't fighting anyone.\n\r", ch );
        return;
    }
    if ( wield == NULL )
	{
	send_to_char("You can only use arrows with wielding a bow.\n\r",ch);
	return;
	}
	use = get_obj_use(wield, UTYPE_WEAPON);
    if ( use->value[0] != WEAPON_BOW )
	{
	send_to_char("You can only use arrows with wielding a bow.\n\r",ch);
	return;
	}
    if (ch->mana < 11)
    {
	send_to_char("You don't have the power right now.\n\r",ch);
	return;
    }

	ch->mana -= 11;
   
    WAIT_STATE( ch, skill_table[skill_lookup("ice arrow")].beats );
    if ( IS_NPC(ch) || number_percent( ) < ch->pcdata->learned[skill_lookup("ice arrow")] )
    {
        damage( ch, victim, number_range( 300, ch->level+50 ), skill_lookup("ice arrow"),DAM_COLD,1);
        check_improve(ch,skill_lookup("ice arrow"),TRUE,1);
	}
    else
    {
        damage( ch, victim, number_range( 300, ch->level+50 ), skill_lookup("ice arrow"),DAM_COLD,1 );
        check_improve(ch,skill_lookup("ice arrow"),FALSE,1);
    }

    return;
}

void do_jab( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *victim;
    OBJ_DATA *wield;
    USE *use;

	wield = get_eq_char( ch, WEAR_WIELD );

	 if(get_skill(ch,skill_lookup("jab"))==0)
	 {
		 send_to_char("Thats beyond your skills.\n\r",ch);
		 return;
	 }

    if ( !IS_NPC(ch)
    &&   ch->level < skill_table[skill_lookup("jab")].skill_level[ch->clss] )
    {
        send_to_char("Hmm?\n\r", ch );
        return;
    }
    if ( ( victim = ch->fighting ) == NULL )
    {
        send_to_char( "You aren't fighting anyone.\n\r", ch );
        return;
    }
    if ( wield == NULL )
	{
	send_to_char("You can only do that with a staff.\n\r",ch);
	return;
	}
	use = get_obj_use(wield, UTYPE_WEAPON);
    if ( use->value[0] != WEAPON_SPEAR )
	{
	send_to_char("You can only do that with a staff.\n\r",ch);
	return;
	}
   
    WAIT_STATE( ch, skill_table[skill_lookup("jab")].beats );
    if ( IS_NPC(ch) || number_percent( ) < ch->pcdata->learned[skill_lookup("jab")] )
   {
/*	act ("$n thrusts $s sword forward in a swift, close range lunge.",
           ch, NULL, NULL, TO_ROOM);
	act ("You thrust your sword forward in a swift, close range lunge.", 
           ch, NULL, NULL, TO_CHAR); */
        damage( ch, victim, number_range( 25, ch->level+25 ), skill_lookup("jab"),DAM_PIERCE,1);
        check_improve(ch,skill_lookup("jab"),TRUE,1);
	}
    else
    {
        damage( ch, victim, number_range( 25, ch->level+25 ), skill_lookup("jab"),DAM_PIERCE,1 );
        check_improve(ch,skill_lookup("jab"),FALSE,1);
    }

    return;
}
