#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include "include.h"

void purge_obj_events(OBJ_DATA *pObj);

bool can_smelt(CHAR_DATA *ch)
{	OBJ_DATA *pObj;

	for( pObj = IN_ROOM(ch)->contents ; pObj ; pObj = pObj->next_content)
	{	if(get_obj_use(pObj,UTYPE_HEARTH) || get_obj_use(pObj, UTYPE_FURNACE ) )
			return TRUE;
	}

	return FALSE;
}

void do_smelt( CHAR_DATA *ch, char *argument )
{	char arg[MSL], arg2[MSL], arg3[MSL];
	OBJ_DATA *ore, *furnace, *container;
	USE *use, *fUse;
	int mL;

	if(!can_smelt(ch) )
	{	send_to_char("You need a furnace or a hearth to smelt something!\n\r",ch);
		return;
	}

	argument = one_argument(argument, arg);
	argument = one_argument(argument, arg2);
	argument = one_argument(argument, arg3);

	if(arg[0] == '\0' || arg2[0] == '\0' || arg3[0] == '\0')
	{	send_to_char("Syntax: smelt <ore> <pot> <furnace>\n\r",ch);
		return;
	}

	if( ( ore = get_obj_carry(ch, arg, ch) ) == NULL )
	{	send_to_char("You don't have that ore.\n\r",ch);
		return;
	}

	if( get_obj_use(ore, UTYPE_ORE ) )
	{	send_to_char("The ore should actually be ore.\n\r",ch);
		return;
	}

	if( ( container = get_obj_carry(ch, arg2, ch) ) == NULL )
	{	send_to_char("You don't have that container.\n\r",ch);
		return;
	}

	if( !(use = get_obj_use( container, UTYPE_POT ) ) )
	{	send_to_char("You can't use that as a pot!\n\r",ch);
		return;
	}
	mL = (int)(ore->weight * material_table[ore->material].density);
	if( ( mL + use->value[1] ) > use->value[0] )
	{	printf_to_char(ch, "%s is far to large to be placed inside %s.\n\r", ore->short_descr, container->short_descr );
		return;
	}
	
	if( container->contains )
	{	send_to_char("The point of smelting is to purify the ore. If you have something in the container, it wont be pure!\n\r",ch);
		return;
	}

	if( material_table[container->material].meltTmp < material_table[ore->material].smeltTmp )
	{	send_to_char("That container would surive that high a smelting temprature.\n\r",ch);
		printf_to_char(ch, "%d %d %s %s\n\r", material_table[container->material].meltTmp, material_table[ore->material].smeltTmp, material_table[container->material].name, container->name);
		return;
	}

	if( ( furnace = get_obj_here(ch, NULL, arg3) ) == NULL )
	{	send_to_char("That furnace or hearth isn't here.\n\r",ch);
		return;
	}

	if( get_obj_use(furnace, UTYPE_FURNACE) && get_obj_use(furnace, UTYPE_HEARTH ) )
	{	send_to_char("That isn't a furnace or a hearth!\n\r",ch);
		return;
	}
	if( ( fUse = get_obj_use(furnace, UTYPE_FURNACE ) )
	||  ( fUse = get_obj_use(furnace, UTYPE_HEARTH ) ) );

	if(fUse->value[0] < material_table[ore->material].smeltTmp )
	{	printf_to_char(ch,"%s is not hot enough to purify that ore.\n\r", furnace->short_descr );
		return;
	}

	obj_from_char(ore);
	obj_to_obj(ore, container);
	obj_from_char(container);
	obj_to_obj(container, furnace);

	printf_to_char(ch, "You place %s in %s, then put it in %s. All you can do is wait.\n\r", ore->short_descr, container->short_descr, furnace->short_descr);
	return;
}

void do_check(CHAR_DATA *ch, char *argument )
{	char arg[MSL], arg2[MSL];
	OBJ_DATA *check, *furnace, *tmp;
	USE *fUse;

	argument = one_argument(argument, arg);
	argument = one_argument(argument, arg2);

	if(arg[0] == '\0')
	{	send_to_char("Syntax: check <furnace> <object in furnace>\n\r",ch);
		send_to_char("Leaving out the last argument will show the furnace stats.\n\r",ch);
		return;
	}

	if( ( furnace = get_obj_here(ch, NULL, arg) ) == NULL )
	{	send_to_char("You can't find that furnace, or hearth.\n\r",ch);
		return;
	}

	if( !get_obj_use(furnace, UTYPE_FURNACE) && !get_obj_use(furnace, UTYPE_HEARTH ) )
	{	send_to_char("That isn't a furnace or a hearth!\n\r",ch);
		return;
	}
	if( ( fUse = get_obj_use(furnace, UTYPE_FURNACE ) )
	||  ( fUse = get_obj_use(furnace, UTYPE_HEARTH ) ) );

	printf_to_char(ch, "%s is %slit, and at %doC", furnace->short_descr, fUse->value[1] ? "" : "not ", furnace->temp );
	if( fUse->value[1] )
		printf_to_char(ch, " and will last for %d hours on the current supply of %s", fUse->value[2], fuel_table[fUse->value[3]].name );
	send_to_char(".\n\r",ch);
	if( arg2[0] == '\0' )
		return;
	for( check = furnace->contains ; check ; check = check->next_content )
	{	if(is_name(arg2, check->name) )
			break;
	}

	if(!check)
	{	printf_to_char(ch,"%s does not have that container in it.\n\r", furnace->short_descr);
		return;
	}

	if( check->temp < material_table[check->material].redTmp )
		printf_to_char(ch, "%s is begining to heat up.\n\r", check->short_descr );
	else if( check->temp < material_table[check->material].whiteTmp )
		printf_to_char(ch, "%s is begining to glow red hot.\n\r", check->short_descr );
	else if( check->temp < material_table[check->material].meltTmp )
		printf_to_char(ch, "%s is begining to glow white hot!\n\r", check->short_descr );
	else if( check->temp < material_table[check->material].smeltTmp )
		printf_to_char(ch, "%s has melted.\n\r",check->short_descr); /*chances are, I wont need any of these, cause if it lacks a container and melts in an oven or hearth. Its gone. */
	else if( check->temp < material_table[check->material].evapTmp )
		printf_to_char(ch, "%s has been purified.\n\r", check->short_descr);
	else
		printf_to_char(ch, "%s has evaporated.\n\r",check->short_descr );

	if( get_obj_use(check, UTYPE_POT) && check->contains )
	{	printf_to_char(ch,"In %s:\n\r", check->short_descr );
		for( tmp = check->contains ; tmp ; tmp = tmp->next_content )
		{	if( tmp->temp < material_table[tmp->material].redTmp )
				printf_to_char(ch, "\t%s is begining to heat up.\n\r", tmp->short_descr );
			else if( tmp->temp < material_table[tmp->material].whiteTmp )
				printf_to_char(ch, "\t%s is begining to glow red hot.\n\r", tmp->short_descr );
			else if( tmp->temp < material_table[tmp->material].meltTmp )
				printf_to_char(ch, "\t%s is begining to glow white hot!\n\r", tmp->short_descr );
			else if( tmp->temp < material_table[tmp->material].smeltTmp )
				printf_to_char(ch, "\t%s has melted.\n\r",tmp->short_descr);
			else if( tmp->temp < material_table[tmp->material].evapTmp )
				printf_to_char(ch, "\t%s has been purified.\n\r", tmp->short_descr);
			else /* Chances are I wont need anything past this, as if it's evaporated, its gone :) */
				printf_to_char(ch, "\t%s has evaporated.\n\r",tmp->short_descr );
		}
	}
	return;
}

void do_ignite(CHAR_DATA *ch, char *argument )
{	OBJ_DATA *furnace;
	USE *fUse;

	if(argument[0] == '\0' )
	{	send_to_char("Syntax: ignite <furnace>\n\r",ch);
		return;
	}

	if( ( furnace = get_obj_here(ch, NULL, argument) ) == NULL )
	{	send_to_char("There is no furnace or hearth by that name.\n\r",ch);
		return;
	}

	if( !get_obj_use(furnace, UTYPE_FURNACE) && !get_obj_use(furnace, UTYPE_HEARTH ) )
	{	send_to_char("That isn't a furnace or a hearth! You can't ignite that!\n\r",ch);
		return;
	}
	if( ( fUse = get_obj_use(furnace, UTYPE_FURNACE ) )
	||  ( fUse = get_obj_use(furnace, UTYPE_HEARTH ) ) );

	if( fUse->value[1] == TRUE )
	{	send_to_char("It's already burning.\n\r",ch);
		return;
	}
	if( fUse->value[3] == 0 || fUse->value[2] == 0)
	{	send_to_char("There's nothing in there to ignite!\n\r",ch);
		return;
	}

	printf_to_char(ch, "You ignite %s\n\r", furnace->short_descr );
	fUse->value[1] = TRUE;
	return;
}
bool moldable(OBJ_DATA *pObj, OBJ_DATA *clay )
{	return TRUE;
}

void do_mold( CHAR_DATA *ch, char *argument )
{	char arg[MSL], arg2[MSL];
	OBJ_DATA *clay, *pObj;

	argument = one_argument(argument, arg);
	argument = one_argument(argument, arg2);

	if( arg[0] == '\0' || arg2[0] == '\0' )
	{	send_to_char("Syntax: mold <clay> <object>\n\r",ch);
		return;
	}

	if( ( pObj = get_obj_carry(ch, arg2, ch ) )  == NULL )
	{	send_to_char("You don't have that object.\n\r",ch);
		return;
	}/*
	if( !moldable(pObj) )
	{	send_to_char("You can't mold that!\n\r",ch);
		return;
	}*/
	if( (clay = get_obj_carry(ch, arg2, ch) ) == NULL )
	{	send_to_char("You don't have that clay.\n\r",ch);
		return;
	}

	if( clay->size < pObj->size )
	{	send_to_char("You don't have nearly enough clay to make a mold of that.\n\r",ch);
		return;
	}

	if( clay->material == material_lookup("clay") )
	{	send_to_char("You need clay to mold casts for objects.\n\r",ch);
		return;
	}
	
	return;
}

void do_heat( CHAR_DATA *ch, char *argument )
{	OBJ_DATA *pObj;
	OBJ_DATA *hObj;
	OBJ_DATA *mat;
	char arg[MSL], arg2[MSL];
	bool found = FALSE;

	argument = one_argument(argument, arg);
	argument = one_argument(argument, arg2);
	if(arg[0] == '\0' )
	{	send_to_char("Syntax: heat <material> <hearth>\n\r",ch);
		send_to_char("                         Hearth is optional.\n\r",ch);
		return;
	}

	if(arg2[0] == '\0' )
	{	for( hObj = IN_ROOM(ch)->contents ; hObj ; hObj = hObj->next_content )
		{	if(get_obj_use(hObj, UTYPE_HEARTH) || get_obj_use(hObj, UTYPE_FURNACE ) )
			{	found = TRUE;
				break;
			}
		}
		if(!found)
		{	send_to_char("You need a hearth or a furnace to heat things.\n\r",ch);
			return;
		}
	}
	else
	{	if( ( hObj = get_obj_here(ch, NULL, arg2) ) == NULL )
		{	send_to_char("That hearth isn't here.\n\r",ch);
			return;
		}
	}
	if( ( pObj = get_eq_char(ch, WEAR_HOLD) ) == NULL )
	{	send_to_char("You arn't holding anything!\n\r",ch);
		return;
	}
	if( ( mat = get_obj_carry(ch, arg, ch) ) == NULL )
	{	send_to_char("You don't have that to put over in the hearth!\n\r",ch);
		return;
	}
	
	if(!get_specific_use(pObj->pIndexData, UTYPE_TONG) )
	{	send_to_char("You can't hold things while they're in the fire! Get some tongs.\n\r",ch);
		return;
	}
	
	act("You grab $p with your tongs and hold it over $P's flames.", ch, mat, hObj, TO_CHAR );
	pObj->holding = mat;
	event_to_obj(mat, ch, END_CHAR, hObj, 0, EVENT_HEAT_OBJ, 3);
	event_to_char(ch,END_CHAR, NULL, 0, EVENT_BUSY, 100 );
	return;
}

void do_retract( CHAR_DATA *ch, char *argument )
{	OBJ_DATA *pObj;
	OBJ_DATA *held;

	if( ( pObj = get_eq_char(ch, WEAR_HOLD ) ) == NULL )
	{	send_to_char("You arn't holding anything to retract.\n\r",ch);
		return;
	}
	if( !get_specific_use(pObj->pIndexData, UTYPE_TONG ) )
	{	send_to_char("You arn't even holding tongs.\n\r",ch);
		return;
	}

	if( ( held = pObj->holding ) == NULL )
	{	send_to_char("Your tongs arn't holding anything to retract.\n\r",ch);
		return;
	}

	purge_obj_events(held);
	purge_all_events(ch);
	printf_to_char(ch, "You pull your tongs and %s from the flames.\n\r", held->short_descr);
	return;
}

bool can_continue_forge( OBJ_DATA *pObj )
{	int i;
	if( pObj->complete >= 100 )
		return FALSE;
	for( i = 0; forge_table[i].name != NULL ; i++ )
	{	if(get_obj_use(pObj, forge_table[i].utype) )
			return TRUE;
	}
	return FALSE;
}

int bstyle_lookup( const char *name );

void do_hammer( CHAR_DATA *ch, char *argument )
{	char arg[MSL];
	OBJ_DATA *ore, *pObj;
	int shape;
	int style;
	bool blade = FALSE;
	char buf[MSL];

	argument = one_argument(argument, arg);

	if(!str_cmp(arg, "into") )
		argument = one_argument(argument, arg);

	if(arg[0] == '\0' )
	{	send_to_char("Syntax: hammer into <shape>\n\r",ch);
		send_to_char("You must be holding the item by hand, or by tongs.\n\r",ch);
		return;
	}


	if( ( pObj = get_eq_char(ch, WEAR_HOLD ) ) == NULL )
	{	send_to_char("You arn't holding anything to hammer!\n\r",ch);
		return;
	}

	if( !can_continue_forge( pObj) )
	{	if( !pObj->holding )
		{	send_to_char("You arn't holding anything you can hammer!\n\r",ch);
			return;
		}
		if(!can_continue_forge(pObj->holding) && !get_obj_use(pObj->holding, UTYPE_ORE))
		{	send_to_char("You arn't holding anything you can hammer!\n\r",ch);
			return;
		}
		ore = pObj->holding;
	}
	else
		ore = pObj;
	if( ore->temp < material_table[ore->material].redTmp )
	{	send_to_char("Hammering an object that isn't atleast red hot will just break it.\n\r",ch);
		return;
	}
		
	if(!str_cmp(arg, "integral" ) )
	{	char arg2[MSL];
		int integral;

		argument = one_argument(argument,arg2);
		
		if( ( integral = integral_lookup(arg2) ) == -1 )
		{	send_to_char("What type of integral is that?\n\r",ch);
			return;
		}

		if( !get_obj_use(ore, integral_table[integral].req_utype) )
		{	printf_to_char(ch, "You can't have a %s forged into that.\n\r",integral_table[integral].name);
			return;
		}

		send_to_char("You begin to prepare...\n\r",ch);
		ch->complete = 0;
		event_to_char(ch, END_CHAR, (void *) ore, 0, integral_table[integral].etype, 5 );
		return;
	}		

	if( (style = bstyle_lookup(arg) ) != -1 )
		blade = TRUE;
	
	if( ( shape = forge_lookup( blade ? argument : arg) ) == -1 )
	{	printf_to_char(ch, "What would you like to hammer it into? %d\n\r %d\n\r %s\n\r %s\n\r",blade, style, argument, arg );
		return;
	}
	if( forge_table[shape].utype == UTYPE_BLADE && style == -1)
	{	send_to_char("Syntax for forging blades: hammer <curved|straight> <length> <edge>\n\r",ch);
		return;
	}
	if( ore->weight < forge_table[shape].minOre )
	{	send_to_char("You don't have enough ore to create that.\n\r",ch);
		return;
	}
	
	if( material_table[ore->material].smeltTmp == -1 )
	{	send_to_char("That object can not be hammered into anything!\n\r",ch);
		return;
	}
	sprintf(buf, "%d", shape);
	ch->complete = 0;
	switch(style)
	{	case -1:
			break;
		case 0:
			send_to_char("You make preperations to begin hammering your ore into a straight blade\n\r",ch);
			event_to_char(ch, buf, (void *) ore, style, EVENT_STYLE, 5 );
			return;
		case 1:
			send_to_char("You make preperations to begin hammering your ore into a curved blade\n\r",ch);
			event_to_char(ch, buf, (void *) ore, style, EVENT_STYLE, 5 );
			return;
	}

	printf_to_char(ch, "You begin preperations to begin forging %s.\n\r", forge_table[shape].name );
	event_to_char(ch, END_CHAR, (void *)ore, shape, forge_table[shape].etype, 5 );
	return;
}
