/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,	   *
 *  Michael Seifert, Hans Henrik Stfeldt, Tom Madsen, and Katja Nyboe.   *
 *									   *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael	   *
 *  Chastain, Michael Quan, and Mitchell Tse.				   *
 *									   *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc	   *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.						   *
 *									   *
 *  Much time and thought has gone into this software and you are	   *
 *  benefitting.  We hope that you share your changes too.  What goes	   *
 *  around, comes around.						   *
 ***************************************************************************/
 
/***************************************************************************
*	ROM 2.4 is copyright 1993-1998 Russ Taylor			   *
*	ROM has been brought to you by the ROM consortium		   *
*	    Russ Taylor (rtaylor@hypercube.org)				   *
*	    Gabrielle Taylor (gtaylor@hypercube.org)			   *
*	    Brian Moore (zump@rom.org)					   *
*	By using this code, you have agreed to follow the terms of the	   *
*	ROM license, in the file Rom24/doc/rom.license			   *
***************************************************************************/

/* this is a listing of all the commands and command related data */

/* wrapper function for safe command execution */
void do_function args((CHAR_DATA *ch, DO_FUN *do_fun, char *argument));

/* for command types */
#define ML 	MAX_LEVEL	/* implementor */
#define L1	MAX_LEVEL - 1  	/* creator */
#define L2	MAX_LEVEL - 2	/* supreme being */
#define L3	MAX_LEVEL - 3	/* deity */
#define L4 	MAX_LEVEL - 4	/* god */
#define L5	MAX_LEVEL - 5	/* immortal */
#define L6	MAX_LEVEL - 6	/* demigod */
#define L7	MAX_LEVEL - 7	/* angel */
#define L8	MAX_LEVEL - 8	/* avatar */
#define IM	LEVEL_IMMORTAL 	/* avatar */
#define HE	LEVEL_HERO	/* hero */

#define COM_INGORE	1

/*
 * Command functions.
 * Defined in act_*.c (mostly).
 */
DECLARE_DO_FUN(	do_advance	);
DECLARE_DO_FUN( do_affects	);
DECLARE_DO_FUN( do_afk		);
DECLARE_DO_FUN( do_alia		);
DECLARE_DO_FUN( do_alias	);
DECLARE_DO_FUN(	do_allow	);
DECLARE_DO_FUN( do_answer	);
DECLARE_DO_FUN(	do_areas	);
DECLARE_DO_FUN(	do_at		);
DECLARE_DO_FUN( do_autoassist	);
DECLARE_DO_FUN( do_autodamage	);
DECLARE_DO_FUN( do_autoexit	);
DECLARE_DO_FUN( do_autogold	);
DECLARE_DO_FUN( do_autolist	);
DECLARE_DO_FUN( do_autoloot	);
DECLARE_DO_FUN( do_autosac	);
DECLARE_DO_FUN( do_autosplit	);
DECLARE_DO_FUN(	do_backstab	);
DECLARE_DO_FUN(	do_bamfin	);
DECLARE_DO_FUN(	do_bamfout	);
DECLARE_DO_FUN(	do_ban		);
DECLARE_DO_FUN( do_bash		);
DECLARE_DO_FUN( do_board	);
DECLARE_DO_FUN(	do_brandish	);
DECLARE_DO_FUN( do_brief	);
DECLARE_DO_FUN(	do_bug		);
DECLARE_DO_FUN(	do_buy		);
DECLARE_DO_FUN(	do_cast		);
DECLARE_DO_FUN( do_channels	);
DECLARE_DO_FUN( do_clone	);
DECLARE_DO_FUN(	do_close	);
DECLARE_DO_FUN(	do_colour	);
DECLARE_DO_FUN(	do_commands	);
DECLARE_DO_FUN( do_combine	);
DECLARE_DO_FUN( do_compact	);
DECLARE_DO_FUN(	do_compare	);
DECLARE_DO_FUN(	do_consider	);
DECLARE_DO_FUN(	do_copyover	);
DECLARE_DO_FUN( do_count	);
DECLARE_DO_FUN(	do_credits	);
DECLARE_DO_FUN( do_deaf		);
DECLARE_DO_FUN( do_delet	);
DECLARE_DO_FUN( do_delete	);
DECLARE_DO_FUN(	do_deny		);
DECLARE_DO_FUN(	do_description	);
DECLARE_DO_FUN( do_dirt		);
DECLARE_DO_FUN(	do_disarm	);
DECLARE_DO_FUN(	do_disconnect	);
DECLARE_DO_FUN(	do_down		);
DECLARE_DO_FUN(	do_drink	);
DECLARE_DO_FUN(	do_drop		);
DECLARE_DO_FUN( do_dump		);
DECLARE_DO_FUN(	do_east		);
DECLARE_DO_FUN(	do_eat		);
DECLARE_DO_FUN(	do_echo		);
DECLARE_DO_FUN(	do_emote	);
DECLARE_DO_FUN( do_enter	);
DECLARE_DO_FUN( do_envenom	);
DECLARE_DO_FUN(	do_equipment	);
DECLARE_DO_FUN(	do_examine	);
DECLARE_DO_FUN(	do_exits	);
DECLARE_DO_FUN(	do_fill		);
DECLARE_DO_FUN( do_flag		);
DECLARE_DO_FUN(	do_flee		);
DECLARE_DO_FUN(	do_follow	);
DECLARE_DO_FUN(	do_force	);
DECLARE_DO_FUN(	do_freeze	);
DECLARE_DO_FUN( do_gain		);
DECLARE_DO_FUN(	do_get		);
DECLARE_DO_FUN(	do_give		);
DECLARE_DO_FUN( do_gossip	);
DECLARE_DO_FUN(	do_goto		);
DECLARE_DO_FUN( do_grats	);
DECLARE_DO_FUN(	do_group	);
DECLARE_DO_FUN( do_groups	);
DECLARE_DO_FUN(	do_gtell	);
DECLARE_DO_FUN( do_guild    	);
DECLARE_DO_FUN(	do_help		);
DECLARE_DO_FUN(	do_hide		);
DECLARE_DO_FUN(	do_holylight	);
DECLARE_DO_FUN(	do_immtalk	);
DECLARE_DO_FUN( do_incognito	);
DECLARE_DO_FUN( do_clantalk	);
DECLARE_DO_FUN( do_imotd	);
DECLARE_DO_FUN(	do_inventory	);
DECLARE_DO_FUN(	do_invis	);
DECLARE_DO_FUN(	do_kick		);
DECLARE_DO_FUN(	do_kill		);
DECLARE_DO_FUN(	do_list		);
DECLARE_DO_FUN( do_load		);
DECLARE_DO_FUN(	do_lock		);
DECLARE_DO_FUN(	do_log		);
DECLARE_DO_FUN(	do_look		);
DECLARE_DO_FUN(	do_memory	);
DECLARE_DO_FUN(	do_mfind	);
DECLARE_DO_FUN(	do_mload	);
DECLARE_DO_FUN(	do_mlist	);
DECLARE_DO_FUN(	do_mset		);
DECLARE_DO_FUN(	do_mstat	);
DECLARE_DO_FUN(	do_mwhere	);
DECLARE_DO_FUN( do_motd		);
DECLARE_DO_FUN(	do_murde	);
DECLARE_DO_FUN(	do_murder	);
DECLARE_DO_FUN( do_music	);
DECLARE_DO_FUN( do_newlock	);
DECLARE_DO_FUN( do_nochannels	);
DECLARE_DO_FUN(	do_noemote	);
DECLARE_DO_FUN( do_nofollow	);
DECLARE_DO_FUN( do_noloot	);
DECLARE_DO_FUN(	do_north	);
DECLARE_DO_FUN(	do_noshout	);
DECLARE_DO_FUN(	do_notell	);
DECLARE_DO_FUN(	do_ofind	);
DECLARE_DO_FUN(	do_oload	);
DECLARE_DO_FUN(	do_olist	);
DECLARE_DO_FUN(	do_open		);
DECLARE_DO_FUN(	do_order	);
DECLARE_DO_FUN(	do_oset		);
DECLARE_DO_FUN(	do_ostat	);
DECLARE_DO_FUN( do_owhere	);
DECLARE_DO_FUN(	do_pardon	);
DECLARE_DO_FUN(	do_password	);
DECLARE_DO_FUN(	do_peace	);
DECLARE_DO_FUN( do_pecho	);
DECLARE_DO_FUN( do_permban	);
DECLARE_DO_FUN(	do_pick		);
DECLARE_DO_FUN( do_play		);
DECLARE_DO_FUN( do_pmote	);
DECLARE_DO_FUN(	do_pose		);
DECLARE_DO_FUN( do_pour		);
DECLARE_DO_FUN(	do_practice	);
DECLARE_DO_FUN( do_prefi	);
DECLARE_DO_FUN( do_prefix	);
DECLARE_DO_FUN( do_prompt	);
DECLARE_DO_FUN( do_protect	);
DECLARE_DO_FUN(	do_purge	);
DECLARE_DO_FUN(	do_put		);
DECLARE_DO_FUN(	do_quaff	);
DECLARE_DO_FUN( do_question	);
DECLARE_DO_FUN(	do_qui		);
DECLARE_DO_FUN( do_quiet	);
DECLARE_DO_FUN(	do_quit		);
DECLARE_DO_FUN( do_quote	);
DECLARE_DO_FUN( do_read		);
DECLARE_DO_FUN(	do_reboo	);
DECLARE_DO_FUN(	do_reboot	);
DECLARE_DO_FUN(	do_recall	);
DECLARE_DO_FUN(	do_recho	);
DECLARE_DO_FUN(	do_recite	);
DECLARE_DO_FUN(	do_remove	);
DECLARE_DO_FUN(	do_rent		);
DECLARE_DO_FUN( do_replay	);
DECLARE_DO_FUN(	do_reply	);
DECLARE_DO_FUN(	do_report	);
DECLARE_DO_FUN(	do_rescue	);
DECLARE_DO_FUN(	do_rest		);
DECLARE_DO_FUN(	do_restore	);
DECLARE_DO_FUN(	do_return	);
DECLARE_DO_FUN(	do_rlist	);
DECLARE_DO_FUN(	do_rset		);
DECLARE_DO_FUN(	do_rstat	);
DECLARE_DO_FUN( do_rules	);
DECLARE_DO_FUN(	do_sacrifice	);
DECLARE_DO_FUN(	do_save		);
DECLARE_DO_FUN(	do_say		);
DECLARE_DO_FUN(	do_scan		);
DECLARE_DO_FUN(	do_score	);
DECLARE_DO_FUN( do_scroll	);
DECLARE_DO_FUN( do_seize	);
DECLARE_DO_FUN(	do_sell		);
DECLARE_DO_FUN( do_set		);
DECLARE_DO_FUN(	do_shout	);
DECLARE_DO_FUN(	do_shutdow	);
DECLARE_DO_FUN(	do_shutdown	);
DECLARE_DO_FUN( do_sit		);
DECLARE_DO_FUN( do_skills	);
DECLARE_DO_FUN(	do_sla		);
DECLARE_DO_FUN(	do_slay		);
DECLARE_DO_FUN(	do_sleep	);
DECLARE_DO_FUN(	do_slookup	);
DECLARE_DO_FUN( do_smote	);
DECLARE_DO_FUN(	do_sneak	);
DECLARE_DO_FUN(	do_snoop	);
DECLARE_DO_FUN( do_socials	);
DECLARE_DO_FUN(	do_south	);
DECLARE_DO_FUN( do_sockets	);
DECLARE_DO_FUN( do_spells	);
DECLARE_DO_FUN(	do_split	);
DECLARE_DO_FUN(	do_sset		);
DECLARE_DO_FUN(	do_stance		);
DECLARE_DO_FUN(	do_stand	);
DECLARE_DO_FUN( do_stat		);
DECLARE_DO_FUN( do_story	);
DECLARE_DO_FUN( do_string	);
DECLARE_DO_FUN(	do_switch	);
DECLARE_DO_FUN(	do_tell		);
DECLARE_DO_FUN(	do_time		);
DECLARE_DO_FUN(	do_title	);
DECLARE_DO_FUN(	do_train	);
DECLARE_DO_FUN(	do_transfer	);
DECLARE_DO_FUN( do_trip		);
DECLARE_DO_FUN(	do_trust	);
DECLARE_DO_FUN(	do_typo		);
DECLARE_DO_FUN( do_unalias	);
DECLARE_DO_FUN(	do_unlock	);
DECLARE_DO_FUN( do_unlink       );
DECLARE_DO_FUN(	do_up		);
DECLARE_DO_FUN(	do_value	);
DECLARE_DO_FUN( do_version      );
DECLARE_DO_FUN(	do_visible	);
DECLARE_DO_FUN( do_violate	);
DECLARE_DO_FUN( do_vnum		);
DECLARE_DO_FUN(	do_wake		);
DECLARE_DO_FUN(	do_wear		);
DECLARE_DO_FUN(	do_weather	);
DECLARE_DO_FUN(	do_west		);
DECLARE_DO_FUN(	do_where	);
DECLARE_DO_FUN(	do_who		);
DECLARE_DO_FUN( do_whois	);
DECLARE_DO_FUN(	do_wimpy	);
DECLARE_DO_FUN(	do_wizhelp	);
DECLARE_DO_FUN(	do_wizlock	);
DECLARE_DO_FUN( do_wizlist	);
DECLARE_DO_FUN( do_wiznet	);
DECLARE_DO_FUN( do_pinfo	);
DECLARE_DO_FUN(	do_yell		);
DECLARE_DO_FUN(	do_zap		);
DECLARE_DO_FUN( do_zecho	);
DECLARE_DO_FUN( do_mount	);
DECLARE_DO_FUN( do_dismount	);
DECLARE_DO_FUN( do_olc          );
DECLARE_DO_FUN( do_asave        );
DECLARE_DO_FUN( do_alist        );
DECLARE_DO_FUN( do_resets       );       
DECLARE_DO_FUN( do_disable      );
DECLARE_DO_FUN( do_avatar       );
DECLARE_DO_FUN( do_fvlist       );
DECLARE_DO_FUN( do_sedit        );
DECLARE_DO_FUN( do_map          );
DECLARE_DO_FUN( do_engage       );
DECLARE_DO_FUN( do_ifollow      );
DECLARE_DO_FUN( do_throw        );
DECLARE_DO_FUN( do_rename       );
DECLARE_DO_FUN( do_pwipe        );
DECLARE_DO_FUN( do_omni         );
DECLARE_DO_FUN( do_implag       );
DECLARE_DO_FUN( do_unrestore    );
DECLARE_DO_FUN( do_whirlwind    );
DECLARE_DO_FUN( do_istat        );
DECLARE_DO_FUN( do_scatter      );
DECLARE_DO_FUN( do_circle       );
DECLARE_DO_FUN( do_pload        );
DECLARE_DO_FUN( do_punload      );
DECLARE_DO_FUN( do_wpeace       );
DECLARE_DO_FUN( do_second       );
DECLARE_DO_FUN( do_skillstat    );
DECLARE_DO_FUN( do_slist        );
DECLARE_DO_FUN( do_become       );
DECLARE_DO_FUN( do_push         );
DECLARE_DO_FUN( do_drag         );
DECLARE_DO_FUN( do_olevel       );
DECLARE_DO_FUN( do_mlevel       );
DECLARE_DO_FUN( do_lore         );
DECLARE_DO_FUN( do_hometown     );
DECLARE_DO_FUN( do_autoall      );
DECLARE_DO_FUN( do_doublexp     );
DECLARE_DO_FUN( do_surrender    );
DECLARE_DO_FUN( do_mob          );
DECLARE_DO_FUN( do_mpstat       );
DECLARE_DO_FUN( do_mpdump       );
DECLARE_DO_FUN( do_mpedit       );
DECLARE_DO_FUN( do_hedit        );
DECLARE_DO_FUN( do_opedit 	);
DECLARE_DO_FUN( do_rpedit 	);
DECLARE_DO_FUN( do_opdump 	);
DECLARE_DO_FUN( do_opstat 	);
DECLARE_DO_FUN( do_rpdump 	);
DECLARE_DO_FUN( do_rpstat 	);
DECLARE_DO_FUN( do_imp		);
DECLARE_DO_FUN( do_travel       );
DECLARE_DO_FUN( do_deposit	);
DECLARE_DO_FUN( do_withdraw     );
DECLARE_DO_FUN( do_share	);
DECLARE_DO_FUN( do_account	);
DECLARE_DO_FUN( do_change	);
DECLARE_DO_FUN( do_exchange     );
DECLARE_DO_FUN( do_tpspend      );
DECLARE_DO_FUN( do_tpgive       );
DECLARE_DO_FUN( do_restring     );
DECLARE_DO_FUN( do_divine       );
DECLARE_DO_FUN( do_astrip       );
DECLARE_DO_FUN( do_donate       );
DECLARE_DO_FUN( do_auction      );
DECLARE_DO_FUN( do_bid          ); 
DECLARE_DO_FUN( do_warcry       );
DECLARE_DO_FUN( do_pray         );
DECLARE_DO_FUN( do_godset       );
DECLARE_DO_FUN( do_use          );
DECLARE_DO_FUN( do_petname      );
DECLARE_DO_FUN( do_rental       );
DECLARE_DO_FUN( do_assassinate  );
DECLARE_DO_FUN( do_arealinks    );
DECLARE_DO_FUN( do_fremove      );
DECLARE_DO_FUN( do_btransfer    );
DECLARE_DO_FUN( do_finger       );
DECLARE_DO_FUN( do_track        );
DECLARE_DO_FUN( do_security     );
DECLARE_DO_FUN( do_repeat       );
DECLARE_DO_FUN( do_repop        );
DECLARE_DO_FUN( do_beep         );
DECLARE_DO_FUN( do_racetalk     );
DECLARE_DO_FUN( do_channel      );
DECLARE_DO_FUN( do_clear        );
DECLARE_DO_FUN( do_forge        );
DECLARE_DO_FUN( do_brew         );
DECLARE_DO_FUN( do_resize       );
DECLARE_DO_FUN( do_search       );
DECLARE_DO_FUN( do_ohide        );
DECLARE_DO_FUN( do_bounty       );
DECLARE_DO_FUN( do_newforge     );
DECLARE_DO_FUN( do_bloodlust    );
DECLARE_DO_FUN( do_knee         );
DECLARE_DO_FUN( do_srush        );
DECLARE_DO_FUN( do_spin         );
DECLARE_DO_FUN( do_peek         );
DECLARE_DO_FUN( do_rage         );
DECLARE_DO_FUN( do_whisper      );
DECLARE_DO_FUN( do_recl         );
DECLARE_DO_FUN( do_reclass      );   
DECLARE_DO_FUN( do_hero         );
DECLARE_DO_FUN( do_fire         );
DECLARE_DO_FUN( do_draw         );
DECLARE_DO_FUN( do_dislodge     );
DECLARE_DO_FUN( do_hint         );
DECLARE_DO_FUN( do_penter       );
DECLARE_DO_FUN( do_ooc          );
DECLARE_DO_FUN( do_cloak	);
DECLARE_DO_FUN( do_hood		);
DECLARE_DO_FUN( do_belt		);
DECLARE_DO_FUN( do_sheath	);
DECLARE_DO_FUN( do_unsheath	);
DECLARE_DO_FUN( do_strap	);
DECLARE_DO_FUN( do_save_guilds  );
DECLARE_DO_FUN( do_promote      );
DECLARE_DO_FUN( do_arshow       );
DECLARE_DO_FUN( do_reward       );
DECLARE_DO_FUN( do_check        );
DECLARE_DO_FUN( do_war          );
DECLARE_DO_FUN( do_newbie       );
DECLARE_DO_FUN( do_ftick        );
DECLARE_DO_FUN( do_auction_talk );
DECLARE_DO_FUN( do_openvlist    );
DECLARE_DO_FUN( do_boxrent      );
DECLARE_DO_FUN( do_store        );
DECLARE_DO_FUN( do_retrieve     );
DECLARE_DO_FUN( do_petcall      );
DECLARE_DO_FUN( do_mobdeaths    );
DECLARE_DO_FUN( do_mobkills     );
DECLARE_DO_FUN( do_nickname	);
DECLARE_DO_FUN( do_shortdescr   );
DECLARE_DO_FUN( do_gouge        );
DECLARE_DO_FUN( do_introduce	);
DECLARE_DO_FUN( do_immtitle     );
DECLARE_DO_FUN( do_announce     );
DECLARE_DO_FUN( do_smithing     );
DECLARE_DO_FUN( do_repair       );
DECLARE_DO_FUN( do_tally        );
DECLARE_DO_FUN( do_updatechar   );
DECLARE_DO_FUN( do_otype        );
DECLARE_DO_FUN( do_grantbp      );
DECLARE_DO_FUN( do_beseech      );
DECLARE_DO_FUN( do_tithe        );
DECLARE_DO_FUN( do_xpreset      );
DECLARE_DO_FUN( do_autolevel    );
DECLARE_DO_FUN( do_level        );
DECLARE_DO_FUN( do_petlevel     );
DECLARE_DO_FUN( do_turn		);
DECLARE_DO_FUN( do_bite		);
DECLARE_DO_FUN( do_affects2     );
DECLARE_DO_FUN( do_sharpen      );
DECLARE_DO_FUN( do_wpoint       );
DECLARE_DO_FUN( do_helptally    );
DECLARE_DO_FUN( do_silence      );
DECLARE_DO_FUN( do_munique      );
DECLARE_DO_FUN( do_cleave       );
DECLARE_DO_FUN( do_blackjack    );
DECLARE_DO_FUN( do_prand        );
DECLARE_DO_FUN( do_gpoint       );
DECLARE_DO_FUN( do_stake        );
DECLARE_DO_FUN( do_butcher      );
DECLARE_DO_FUN( do_tail         );
DECLARE_DO_FUN( do_doorbash     );
DECLARE_DO_FUN( do_reveal       );
DECLARE_DO_FUN( do_mtsteal      );
DECLARE_DO_FUN( do_timeout      );
DECLARE_DO_FUN( do_mobslay      );
DECLARE_DO_FUN( do_instaroom    );
DECLARE_DO_FUN( do_cwho         );
DECLARE_DO_FUN( do_roster	);
DECLARE_DO_FUN( do_petshow      );
DECLARE_DO_FUN( do_wiznetall    );
DECLARE_DO_FUN( do_map		);
DECLARE_DO_FUN( do_revert       );
DECLARE_DO_FUN( do_rub          );
DECLARE_DO_FUN( do_admin        );
DECLARE_DO_FUN( do_ibeep        );
DECLARE_DO_FUN( do_email	);
DECLARE_DO_FUN( do_convert      );
DECLARE_DO_FUN( do_statlist     );
DECLARE_DO_FUN( do_throatchop   );
DECLARE_DO_FUN( do_qsmith       );
DECLARE_DO_FUN( do_cmdlist );
DECLARE_DO_FUN( do_mine		);
DECLARE_DO_FUN( do_godchat	);
DECLARE_DO_FUN( do_autoweather  );
DECLARE_DO_FUN( do_wset         );
DECLARE_DO_FUN( do_build	);
DECLARE_DO_FUN( do_isignal      );
DECLARE_DO_FUN( do_fquit        );
DECLARE_DO_FUN( do_saveconst	);
DECLARE_DO_FUN( do_constval	);
DECLARE_DO_FUN( do_checkvnum	);
DECLARE_DO_FUN( do_petlist      );
DECLARE_DO_FUN( do_rally        );
DECLARE_DO_FUN( do_punch        );
DECLARE_DO_FUN( do_process	);
DECLARE_DO_FUN( do_rescind	);
DECLARE_DO_FUN( do_exalt	);
DECLARE_DO_FUN( do_denounce     );
DECLARE_DO_FUN( do_initiate	);
DECLARE_DO_FUN( do_purify       );
DECLARE_DO_FUN( do_trivia       );
DECLARE_DO_FUN( do_suppress     );
DECLARE_DO_FUN( do_house        );
DECLARE_DO_FUN( do_objbuy       );
DECLARE_DO_FUN( do_mobbuy       );
DECLARE_DO_FUN( do_invite       );
DECLARE_DO_FUN( do_home         );
DECLARE_DO_FUN( do_hname        );
DECLARE_DO_FUN( do_hdesc        );
DECLARE_DO_FUN( do_join         );
DECLARE_DO_FUN( do_boot         );        
DECLARE_DO_FUN( do_mrelic       );
DECLARE_DO_FUN( do_frecall      );
DECLARE_DO_FUN( do_away         );
DECLARE_DO_FUN( do_testfunc     );
DECLARE_DO_FUN( do_pcforge      );
DECLARE_DO_FUN( do_pshow        );
DECLARE_DO_FUN( do_post         );
DECLARE_DO_FUN( do_plist        );
DECLARE_DO_FUN( do_chmail       );
DECLARE_DO_FUN( do_clist		);
DECLARE_DO_FUN( do_restrict		);
DECLARE_DO_FUN( do_addjsp		);
DECLARE_DO_FUN( do_gredit		);
DECLARE_DO_FUN( do_mark			);
DECLARE_DO_FUN( do_devote		);
DECLARE_DO_FUN( do_speak		);
DECLARE_DO_FUN( do_position		);
DECLARE_DO_FUN( do_stop			);
DECLARE_DO_FUN( do_idle			);
DECLARE_DO_FUN( do_ignite		);
DECLARE_DO_FUN( do_smelt		);
DECLARE_DO_FUN( do_showmat		);
DECLARE_DO_FUN( do_heat			);
DECLARE_DO_FUN( do_retract		);
DECLARE_DO_FUN( do_wield		);
DECLARE_DO_FUN( do_grab			);
DECLARE_DO_FUN( do_move			);
DECLARE_DO_FUN( do_resist		);
DECLARE_DO_FUN( do_grant		);
DECLARE_DO_FUN( do_embed		);
DECLARE_DO_FUN( do_cast			);
DECLARE_DO_FUN( do_recharge		);
DECLARE_DO_FUN( do_hammer		);
DECLARE_DO_FUN( do_awardcmd		);
DECLARE_DO_FUN( do_layover		);
DECLARE_DO_FUN( do_printmap		);
DECLARE_DO_FUN( do_loadmap		);
