#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include "include.h"

/* For the OLC. Makes it so we can create an OLC Function!*/
#define LNGEDIT(cmd) bool cmd(CHAR_DATA *ch, char *argument )

LNGEDIT(lngedit_show)
{	LANGUAGE *pLng;
	int col = 0, n;
	WLANG_DATA *pWld;
	char buf[MSL], buf2[MSL];

	EDIT_LANGUAGE(ch, pLng);

	printf_to_char(ch, "Name: %10s\n\r\n\r", pLng->name );
	
	for( pWld = pLng->list; pWld; pWld = pWld->next )
	{	if(pWld->maxSpeach > 1 )
		{	sprintf(buf,"%4s:", pWld->string);
			for(n = 0; n < pWld->maxSpeach ; n++ )
			{	sprintf(buf2, "[%-4s]", pWld->speach[n]);
				strcat(buf, buf2);
			}
			printf_to_char(ch, "%-30s", buf);
			if(pWld->maxSpeach > 5 )
			{	send_to_char("\n\r",ch);
				if( !( (col+1) % 4) ) col+=2;
			}

		}
		else if( pWld->maxSpeach == 1 )
		{	sprintf(buf, "%4s:[%-4s]", pWld->string, *pWld->speach  );
			printf_to_char(ch, "%-30s", buf );
		}
		else
			continue;

		if( !(++col % 3 ) ) send_to_char("\n\r",ch);
	}
	if( col % 3 ) send_to_char("\n\r",ch);
	return FALSE;
}

LNGEDIT(lngedit_name)
{	LANGUAGE *pLng;

	EDIT_LANGUAGE(ch, pLng);
	
	if(argument[0] == '\0')
	{	send_to_char("Syntax: name <name>\n\r",ch);
		return TRUE;
	}

	free_string(pLng->name);
	pLng->name = str_dup(capitalize(argument));
	printf_to_char(ch, "Name set to %s\n\r",pLng->name);
	return TRUE;
}

int word_count(char *string)
{	int count = 0;

	while (*string != '\0')
	{	if(isspace(*string++))
			if(!isspace(*string) )
				count++;
	}

	return count;
}

LNGEDIT( lngedit_add )
{	LANGUAGE *pLng;
	char arg[MSL], **arg2;
	int args, i, size = 0;
	WLANG_DATA *pWld;

	EDIT_LANGUAGE(ch, pLng);
	
	argument = one_argument(argument, arg);
	
	if(arg[0] == '\0' )
	{	send_to_char("Syntax: add <string> <speach>\n\r",ch);
		send_to_char("        For multipul speach placements, seperate with space.\n\r",ch);
		return FALSE;
	}
	if( strlen(arg) > 1 )
	{	send_to_char("String must be no more than 1 characters.\n\r",ch);
		return FALSE;
	}
	args = word_count(argument)+1;
	arg2 = (char **) malloc(args * sizeof(char *) );
	for(i = 0; i < args ; i++ )
	{	arg2[i] = (char *)malloc(sizeof(char *) * MSL ); //I know MSL isn't neccesary here, but just watch!
		argument = one_argument(argument, arg2[i]);
	}

	
	for( i = 0; i < args ; i++ )
	{	if(arg2[i][0] == '\0' )
			break;
		size += strlen(arg2[i])+1;
	}
		
	if(arg2[0][0] == '\0' )
	{	send_to_char("Syntax: add <string> <speach>\n\r",ch);
		send_to_char("        For multipul speach placements, seperate with space.\n\r",ch);
		return FALSE;
	}
		
	pWld = new_wlang();
	if(!pLng->list)
		pLng->list = pWld;
	pWld->prev = pLng->last;
	if(pLng->last)
		pLng->last->next = pWld;
	pLng->last = pWld;
	pWld->string = str_dup(arg);
	pWld->speach = (char **) malloc(args * sizeof(char *) );
	for( i = 0; i < args; i++ )
	{	pWld->speach[i] = (char *) malloc(sizeof(char *) * strlen(arg2[i]) ); //See! See! MSL isn't perminant :)
		pWld->speach[i] = strdup(arg2[i]);
		free(arg2[i]);
	}
	free(arg2);
	pWld->maxSpeach = args;
	printf_to_char(ch, "New string added, %s with speach replacement(s) of ", arg );
	for( i = 0; i < args ; i++ )
		printf_to_char(ch, "%s ", pWld->speach[i]);
	send_to_char("\n\r",ch);
	return TRUE;
}

WLANG_DATA *get_by_string(char *string, LANGUAGE *pLng)
{	WLANG_DATA *pWld;
	
	for( pWld = pLng->list; pWld; pWld = pWld->next )
		if(!str_cmp(string, pWld->string) )
			return pWld;
	return NULL;
}

LNGEDIT( lngedit_remove )
{	LANGUAGE *pLng;
	WLANG_DATA *pWld;

	EDIT_LANGUAGE(ch, pLng);
	
	if(argument[0] == '\0')
	{	send_to_char("Syntax: remove <string>\n\r",ch);
		return FALSE;
	}
	
	if( ( pWld = get_by_string(argument, pLng) ) == NULL )
	{	send_to_char("There is no entry with that string.\n\r",ch);
		return FALSE;
	}

	if( pLng->list == pWld && pWld == pLng->last )
	{	pLng->list = NULL;
		pLng->last = NULL;
		free_wlang(pWld);
		send_to_char("Removed.\n\r",ch);
		return TRUE;
	}
	if( pLng->list == pWld )
	{	pWld->next->prev = pWld->prev;
		pLng->list = pWld->next;
		free_wlang(pWld);
		send_to_char("Removed.\n\r",ch);
		return TRUE;
	}
	if( pLng->last == pWld )
	{	pWld->prev->next = pWld->next;
		pLng->last = pWld->prev;
		free_wlang(pWld);
		send_to_char("Removed.\n\r",ch);
		return TRUE;
	}

	pWld->prev->next = pWld->next;
	pWld->next->prev = pWld->prev;
	free_wlang(pWld);
	send_to_char("Removed.\n\r",ch);
	return TRUE;
}
	
		
LNGEDIT(lngedit_move)
{	LANGUAGE *pLng;
	WLANG_DATA *move, *target;
	char arg[MSL], arg2[MSL], arg3[MSL];

	EDIT_LANGUAGE(ch, pLng);

	argument = one_argument(argument, arg);
	argument = one_argument(argument, arg2);
	argument = one_argument(argument, arg3);

	if(arg[0] == '\0' || arg2[0] == '\0' || arg3[0] == '\0' )
	{	send_to_char("Syntax: Move <string> after|before <string>\n\r",ch);
		return FALSE;
	}

	if( ( move = get_by_string(arg, pLng) ) == NULL )
	{	send_to_char("The string you want to move doesn't exist.\n\r",ch);
		return FALSE;
	}

	if( ( target = get_by_string(arg3, pLng ) ) == NULL )
	{	send_to_char("String you want to move too, doesn't exist.\n\r",ch);
		return FALSE;
	}

	if( move == pLng->list )
	{	move->next->prev = move->prev;
		pLng->list = move->next;
	}
	else if(move == pLng->last )
	{	move->prev->next = move->next;
		pLng->last = move->prev;
	}
	else
	{	move->prev->next = move->next;
		move->next->prev = move->prev;
	}


	if(!str_cmp(arg2, "before" ) )
	{	if( target == pLng->list )
		{	target->prev = move;
			move->next = target;
			pLng->list = move;
		}
		else
		{	target->prev->next = move;
			move->prev = target->prev;
			target->prev = move;
			move->next = target;
		}
		printf_to_char(ch, "%s moved before %s.\n\r", move->string, target->string );
		return TRUE;
	}
	if(!str_cmp( arg2, "after" ) )
	{	if(target == pLng->last )
		{	target->next = move;
			move->prev = target;
			pLng->last = move;
		}
		else
		{	target->next->prev = move;
			move->next = target->next;
			target->next = move;
			move->prev = target;
		}
		printf_to_char(ch, "%s moved after %s\n\r", move->string, target->string );
		return TRUE;
	}
	send_to_char("Syntax: Move <string> after|before <string>\n\r",ch);
	return FALSE;
}

LANGUAGE *language_lookup( const char *name )
{	LANGUAGE *pLng;

	for( pLng = language_list ; pLng ; pLng = pLng->next )
	{	if( LOWER(pLng->name[0]) == LOWER(name[0] )
		&& !str_prefix(name, pLng->name ) )
			return pLng;
	}
	return NULL;
}

LNGEDIT( lngedit_create )
{	LANGUAGE *pLng;

	if(argument[0] == '\0' )
	{	send_to_char("Syntax: create <name>\n\r",ch);
		return FALSE;
	}

	if( language_lookup(argument ) )
	{	send_to_char("That language already exists.\n\r",ch);
		return FALSE;
	}

	pLng = lang_new();
	pLng->next = language_list;
	language_list = pLng;
	free_string(pLng->name);
	pLng->name = str_dup(capitalize(argument) );
	ch->desc->editor = ED_LANGUAGE;
	ch->desc->pEdit = (void *) pLng;
	printf_to_char(ch, "%s created.\n\r",pLng->name);
	return TRUE;
}

LNGEDIT( lngedit_delete )
{	LANGUAGE *pLng, *tmp;

	if(argument[0] == '\0' )
	{	send_to_char("Syntax: create <name>\n\r",ch);
		return FALSE;
	}

	if( ( pLng = language_lookup(argument ) ) == NULL )
	{	send_to_char("That language doesn't exists.\n\r",ch);
		return FALSE;
	}
	if( pLng == language_list )
		language_list = pLng->next;
	else
		for( tmp = language_list; tmp ; tmp = tmp->next )
		{	if( tmp->next == pLng )
				tmp->next = pLng->next;
		}
	free_lang(pLng);
	return TRUE;
}

LNGEDIT( lngedit_list )
{	LANGUAGE *pLng;
	int count = 0, col = 0;

	for( pLng = language_list ; pLng; pLng = pLng->next )
	{	count++;
		printf_to_char(ch, "%-2d) %-15s", count, pLng->name );
		if(!(++col % 4) ) send_to_char("\n\r",ch);
	}
	if(col % 4 ) send_to_char("\n\r",ch);
	printf_to_char(ch, "{cYou have {w%d{c languages.{x\n\r",count);
	return TRUE;
}


#define STRING_NEW(string)           \
				free_string(string);  \
				string = str_dup("Not Set"); \

LANGUAGE * lang_free;
LANGUAGE * lang_new(void)
{	static LANGUAGE lang_zero;
	LANGUAGE *pLng;
	
	if(lang_free == NULL )
		pLng = (LANGUAGE *) alloc_perm(sizeof(*pLng) );
	else
	{	pLng = lang_free;
		lang_free = lang_free->next;
	}
	*pLng = lang_zero;
	STRING_NEW(pLng->name);
	return pLng;
}

void free_lang( LANGUAGE *pLng )
{	WLANG_DATA *pWld, *pWld_prev;

	free_string(pLng->name);

	for( pWld = pLng->last; pWld; pWld = pWld_prev )
	{	pWld_prev = pWld->prev;
		free_wlang(pWld);
	}
	pLng->last = NULL;
	pLng->list = NULL;
	pLng->next = lang_free;
	lang_free = pLng;
	return;
}

WLANG_DATA *wlang_free;
WLANG_DATA *new_wlang(void)
{	static WLANG_DATA wlang_zero;
	WLANG_DATA *pWld;

	if(wlang_free == NULL )
		pWld = (WLANG_DATA *) alloc_perm(sizeof(*pWld) );
	else
	{	pWld = wlang_free;
		wlang_free = wlang_free->next;
	}

	*pWld = wlang_zero;
	STRING_NEW(pWld->string);

	pWld->maxSpeach = -1;
	return pWld;
}

void free_wlang(WLANG_DATA *pWld)
{	int i;
	free_string(pWld->string);
	for(i = 0; i < pWld->maxSpeach ; i++ )
		free(pWld->speach[i]);
	free(pWld->speach);
	pWld->next = wlang_free;
	wlang_free = pWld;
	return;
}


void save_language(LANGUAGE *pLng, FILE *fp)
{	WLANG_DATA *pWld;
	int i;

	fprintf(fp, "Name %s~\n", pLng->name );
	for( pWld = pLng->list ; pWld ; pWld = pWld->next )
	{	fprintf(fp, "\nstring %s~\n", pWld->string );
		fprintf(fp, "Max %d\n", pWld->maxSpeach);
		for( i = 0; i < pWld->maxSpeach ; i++ )	
			fprintf(fp, "speach %s~\n", pWld->speach[i] );
	}
	fprintf(fp, "%s\n", END_CHAR);
	return;
}

void save_languages( void )
{	LANGUAGE *pLng;
	FILE *fp, *fpList;
	char path[MSL];

	if( ( fpList = file_open(LANG_LIST, "w" ) ) == NULL )
	{	logf2("Save_languages: Fopen LANG_LIST.");
		abort();
	}

	for(pLng = language_list ; pLng ; pLng = pLng->next )
	{	fprintf(fpList, "%s\n", pLng->name );
		sprintf(path, "%s%s", LANG_DIR, pLng->name);
		if( ( fp = file_open(path, "w") ) != NULL )
			save_language(pLng, fp);
		else
			logf2("Save_languages: fopen %s file failed.", pLng->name );
		file_close(fp);
	}
	fprintf(fpList, "%s\n", END_CHAR);
	file_close(fpList);
	return;
}

void load_language( FILE *fp, LANGUAGE *pLng )
{	char *word, *string;
	WLANG_DATA *pWld;
	int i = 0;
	string = &str_empty[0];

	for(word = fread_word(fp); str_cmp(word, END_CHAR); word = fread_word(fp) )
	{	if(!str_cmp(word, "Name" ) )
		{	SREAD(pLng->name);
			free_string(string);
			continue;
		}

		if(!str_cmp(word, "string") )
		{	pWld = new_wlang();
			SREAD(pWld->string);
			if(!pLng->list)
				pLng->list = pWld;
			pWld->prev = pLng->last;
			if(pLng->last)
				pLng->last->next = pWld;
			pLng->last = pWld;
			i = 0;
			continue;
		}

		if(!str_cmp(word, "Max") )
		{	pWld->maxSpeach = fread_number(fp);
			pWld->speach = (char **) malloc(sizeof(char *) * pWld->maxSpeach);
			continue;
		}

		if(!str_cmp(word, "speach") )
		{	SREAD(string);
			pWld->speach[i] = (char *) calloc(sizeof(char *),  strlen(string) );
			pWld->speach[i] = strdup(string);
			i++;
			free_string(string);
			continue;
		}
		logf2("Invalid keyword in language %s: %s", pLng->name, word);
	}
	return;
}

void load_languages( void )
{	FILE *fpList, *fp;
	char *word;
	char path[MSL];
	LANGUAGE *pLng;

	if( ( fpList = file_open(LANG_LIST, "r" ) ) == NULL )
	{	logf2("load_languages: Fopen LANG_LIST.");
		abort();
	}
	
	for(word = fread_word(fpList); str_cmp(word, END_CHAR); word = fread_word(fpList) )
	{	sprintf(path, "%s%s", LANG_DIR, word );

		if( ( fp = file_open(path, "r" ) ) != NULL )
		{	pLng = lang_new();
			pLng->next = language_list;
			language_list = pLng;
			load_language(fp, pLng);
			file_close(fp);
		}
	}
	file_close(fpList);
	return;
}

char *translate( LANGUAGE *pLng, char *string, int skill, int speakSK )
{	static char buf[MSL*4]; //Gotsta be big!
	char *ptr;
	WLANG_DATA *pWld;
	int i;
	bool found = FALSE;
	
	buf[0] = '\0';
	ptr = buf;
	while( *string != '\0' )
	{	found = FALSE;
		for( pWld = pLng->list ; pWld ; pWld = pWld->next )
		{	if((LOWER(pWld->string[0]) == LOWER(*string) ) && (skill <= number_range(0, 99) || speakSK <= number_range(0, 99) )
				&& !str_prefix(pWld->string, string) )
			{	i = number_range(0, pWld->maxSpeach-1);
				strcat(buf, pWld->speach[i] );
				i = strlen(pWld->speach[i]);
				while( i-- != 0 )
					ptr++;
				string++;
				found = TRUE;
				break;
			}

		}
		if(!found)
		{	*ptr++ = *string++;
			*ptr = '\0';
		}

	}

	return buf;
}
