/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik Stfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Thanks to abaddon for proof-reading our comm.c and pointing out bugs.  *
 *  Any remaining bugs are, of course, our work, not his.  :)              *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/
/***************************************************************************
*       ROM 2.4 is copyright 1993-1998 Russ Taylor                         *
*       ROM has been brought to you by the ROM consortium                  *
*           Russ Taylor (rtaylor@hypercube.org)                            *
*           Gabrielle Taylor (gtaylor@hypercube.org)                       *
*           Brian Moore (zump@rom.org)                                     *
*       By using this code, you have agreed to follow the terms of the     *
*       ROM license, in the file Rom24/doc/rom.license                     *
***************************************************************************/
#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#include <sys/time.h>
#endif
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include "merc.h"
#include "interp.h"
#include "recycle.h"
#include "tables.h"
#include "lookup.h"
#include "olc.h"
#include "const.h"

OCEAN_DATA *get_ocean_xy(int x, int y, int z);
#define MAX_OMAP 100

/* The new MAXMAP_X and MAXMAP_Y is the actual size of the display map.
   To get the space left and right of each room, you need a space before
   each room, and then you have one dangling at the end. Same for above
   and below, except you hang one dangling at the bottom. So I made new
   defines for the (MAX_Y*2)+1, instead of having that expression all
   over the code. Make expanding the map later easier.

   There's better ways to do this, but it works for now. Basically you use
   the MAXMAP_* defines when you want to traverse the entire map, for when
   you initialize it and so forth. For the actual room coordinates that you
   pass to areamapper, you use the normal MAX_* defines, so you can skip over
   the exit places more accurately. You could of course do all the calculations
   manually in the code, but eh.. it works.

   To expand it in the future, you could make the ROOM_ and EXIT_ flags be a
   bitvector, then set each room to the right roomflag, then for the exits
   you can add whatever combo of flags you'd like based on what kind of exit
   it is. Then you could have different exit symbols for one-way and two-ways
   exits, or if it's a door, and if it's a door, change color if it's open
   or closed or locked, etc.

   --Chilalin
 */


#define MAX_X 80
#define MAX_Y 30
#define MAXMAP_X (MAX_X*2+1)
#define MAXMAP_Y (MAX_Y*2+1)

#define MAX_DIR_CON 4

#define ROOM_NONE  0
#define ROOM_NORM  1
#define ROOM_UP    2
#define ROOM_DOWN  3
#define ROOM_IN    4
#define EXIT_NORTH 5
#define EXIT_SOUTH 6
#define EXIT_EAST  7
#define EXIT_WEST  8

void areamapper args( (ROOM_INDEX_DATA *pRoom, int x, int y, int rType) );
void mapexit	args( (int dir, int x, int y) );

int get_room_type args( (int dir) );
int dirconnect[MAXMAP_X*MAXMAP_Y][4];

int map[MAXMAP_X][MAXMAP_Y];


int setexit[6][3] ={ {0, -1, 0},{ 1, 0, 0},{ 0, 1, 0},{ -1, 0, 0}, {0, 0, 1}, { 0, 0, -1 }};

void do_map(CHAR_DATA *ch, char *argument)
{
    int i, x, y, strtX = 0;
    bool sendRow = FALSE, sColF= FALSE;
    ROOM_INDEX_DATA *pRoom;

    for(y = 0 ; y < MAXMAP_Y ; y++)
        for(x = 0 ; x < MAXMAP_X ; x++ )
            map[x][y] = 0;

    for(i = 0 ; i < MAXMAP_X*MAXMAP_Y ; i++ )
        for(x = 0 ; i < MAX_DIR_CON ; i++ )
            dirconnect[x][i] = 0;

    for(i = ch->in_room->area->min_vnum ; i < ch->in_room->area->max_vnum ; i++)
    {
        if( (pRoom = get_room_index(i)  )== NULL )
            continue;
        REMOVE_BIT(pRoom->room_flags, ROOM_MAPPED );
    }
    if(!ch->in_room)
    {
        send_to_char("Ooo your in twouble.\n\r",ch);
        return;
    }


    areamapper(ch->in_room, MAX_X/2, MAX_Y/2, ROOM_IN);
    for(x = 0; x<MAXMAP_X ; x++ )
    {
        for(i = 0; i < MAXMAP_Y ; i++ )
        {
            if(map[x][i] > 0 )
            {
                strtX = x;
                sColF = TRUE;
                break;
            }
        }
        if(sColF)
        {
            sColF=FALSE;
            break;
        }
    }
    for( y = 0; y < MAXMAP_Y ; y++ ) // Collum
    {
        for(x = 0; x<MAXMAP_X ; x++ )
        {
            if(map[x][y] > 0 )
            {
                sendRow = TRUE;
                break;
            }

        }

        if(sendRow)
        {
            for(x = strtX ; x < MAXMAP_X ; x++ ) // Row
            {
                switch( map[x][y] )
                {
                case ROOM_NONE:
                    send_to_char(" ",ch);
                    break;
                case ROOM_NORM:
                    send_to_char("+",ch);
                    break;
                case ROOM_UP:
                    send_to_char("+",ch);
                    break;
                case ROOM_DOWN:
                    send_to_char("+",ch);
                    break;
                case ROOM_IN:
                    send_to_char("*",ch);
                    break;
                case EXIT_NORTH:
                case EXIT_SOUTH:
                    send_to_char("|",ch);
                    break;
                case EXIT_EAST:
                case EXIT_WEST:
                    send_to_char("-",ch);
                    break;
                default:
                    send_to_char("X",ch);
                }
            }
            send_to_char("\n\r",ch);
        }
        sendRow = FALSE;
    }
}
#define DIR_NOUD 4
void areamapper(ROOM_INDEX_DATA *pRoom, int x, int y, int rType)
{
    int dir;
    int newx, newy;
    ROOM_INDEX_DATA *nRoom;
    EXIT_DATA *pExit;

    newx = ((x*2)+1);
    newy = ((y*2)+1);

    if(newx > MAXMAP_X || newy > MAXMAP_Y )
        return;

    if(map[newx][newy] != ROOM_IN )
        map[newx][newy] = rType;

    SET_BIT(pRoom->room_flags, ROOM_MAPPED );

    for(dir = 0; dir < DIR_NOUD ; dir ++ )
    {
        if( (pExit = (*(pRoom->exit))[dir] ) == NULL)
            continue;
        if( ((nRoom = pExit->u1.to_room ) == NULL) ||
           (nRoom->area != pRoom->area) )
            continue;
        mapexit( dir, newx+setexit[dir][DIR_X], newy+setexit[dir][DIR_Y] );

        if ( IS_SET(nRoom->room_flags, ROOM_MAPPED) )
            continue;


        areamapper(	nRoom, x + setexit[dir][DIR_X], y + setexit[dir][DIR_Y], get_room_type(dir) );
    }
}

int get_room_type(int dir)
{
	if (dir == DIR_UP)
		return ROOM_UP;
	if(dir == DIR_DOWN)
		return ROOM_DOWN;
	return ROOM_NORM;
}

void mapexit( int dir, int x, int y )
{
    switch( dir )
    {
    case DIR_NORTH:
    case DIR_SOUTH:
        map[x][y] = EXIT_NORTH;
        break;
    case DIR_EAST:
    case DIR_WEST:
        map[x][y] = EXIT_EAST;
        break;
    }
}
OCEAN_DATA *city_map[MAX_OMAP][MAX_OMAP];

bool is_shop( ROOM_INDEX_DATA *pR )
{	CHAR_DATA *keeper;

	for ( keeper = pR->people; keeper; keeper = keeper->next_in_room )
    {	if ( IS_NPC(keeper) && keeper->pIndexData->pShop )
			return TRUE;
    }
	return FALSE;
}

bool room_exists( OCEAN_DATA *pO )
{	if(!pO || IS_VIRTUAL(pO) )
		return FALSE;
	return TRUE;
}
/*
#define IS_LINKED(pR, door )  ( (*(pR)->exit)[rev_dir[(door)]] )

bool check_nw( ROOM_INDEX_DATA *room )
{       if( ((*(room->exit))[DIR_NORTH] && !IS_SET((*(room->exit))[DIR_NORTH]->exit_info, EX_HIDDEN)
          && (*((*(room->exit))[DIR_NORTH]->u1.to_room->exit))[DIR_WEST] )
          && ((*(room->exit))[DIR_WEST] && !IS_SET((*(room->exit))[DIR_WEST]->exit_info, EX_HIDDEN)
          &&  (*((*(room->exit))[DIR_WEST]->u1.to_room->exit))[DIR_NORTH] ) )
                return TRUE;
        return FALSE;
}
bool check_ne( ROOM_INDEX_DATA *room )
{       if( ((*(room->exit))[DIR_NORTH] && !IS_SET((*(room->exit))[DIR_NORTH]->exit_info, EX_HIDDEN)
          && (*((*(room->exit))[DIR_NORTH]->u1.to_room->exit))[DIR_EAST] )
          && ((*(room->exit))[DIR_EAST] && !IS_SET((*(room->exit))[DIR_EAST]->exit_info, EX_HIDDEN)
          &&  (*((*(room->exit))[DIR_EAST]->u1.to_room->exit))[DIR_NORTH] ) )
                return TRUE;
        return FALSE;
}
bool check_sw( ROOM_INDEX_DATA *room )
{       if( ((*room->exit)[DIR_SOUTH] && !IS_SET((*(room->exit))[DIR_SOUTH]->exit_info, EX_HIDDEN)
          && (*((*room->exit)[DIR_SOUTH]->u1.to_room->exit))[DIR_WEST] )
          && ((*room->exit)[DIR_WEST] && !IS_SET((*(room->exit))[DIR_WEST]->exit_info, EX_HIDDEN)
          &&  (*((*room->exit)[DIR_WEST]->u1.to_room->exit))[DIR_SOUTH] ) )
                return TRUE;
        return FALSE;
}
bool check_se( ROOM_INDEX_DATA *room )
{       if( ((*(room->exit))[DIR_SOUTH] && !IS_SET((*(room->exit))[DIR_SOUTH]->exit_info, EX_HIDDEN)
          && (*((*(room->exit))[DIR_SOUTH]->u1.to_room->exit))[DIR_EAST] )
          && ((*(room->exit))[DIR_EAST] && !IS_SET((*(room->exit))[DIR_EAST]->exit_info, EX_HIDDEN)
          &&  (*((*(room->exit))[DIR_EAST]->u1.to_room->exit))[DIR_SOUTH] ) )
                return TRUE;
        return FALSE;
}
*/
char * spot_one(OCEAN_DATA *pO, int depth, CHAR_DATA *ch)
{/*	static char buf[MSL];
	char buf2[MSL];
	OCEAN_DATA *to;
	buf[0] = '\0';

	if(depth == 0)
	{	if( !room_exists( ( to = get_ocean_xy(pO->x + setexit[DIR_NORTH][DIR_X], pO->y + setexit[DIR_NORTH][DIR_Y], pO->z) ) )
			|| !IS_LINKED(to->room, DIR_NORTH) 
			||  (!room_exists( ( to = get_ocean_xy(pO->x +setexit[DIR_WEST][DIR_X], pO->y + setexit[DIR_WEST][DIR_Y], pO->z) ) )
			|| !IS_LINKED(to->room, DIR_WEST) ))
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].wall);
			strcat(buf, buf2);
		}
		else if( !check_nw(pO->room)  )
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].wall);
			strcat(buf, buf2);
		}
		else
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].walk);
			strcat(buf, buf2);
		}
		
		if( (!room_exists( (to = get_ocean_xy(pO->x, pO->y + setexit[DIR_NORTH][DIR_Y], pO->z) ) ) 
		|| !IS_LINKED(to->room, DIR_NORTH) 
		&& !IS_VIRTUAL(to) && pO->sector_type != SECT_CITY) )
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].wall);
			strcat(buf, buf2);
		}
		else
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].walk);
			strcat(buf, buf2);;
		}
	
		if( ( ch->is_building() && BUILDING_CHECK(DIR_NORTH,ch)
						&& BUILDING_CHECK(DIR_EAST,ch) )
		||
			(!ch->is_building() && ((!room_exists( ( to = get_ocean_xy(pO->x, pO->y + setexit[DIR_NORTH][DIR_Y], pO->z) )  )
		|| !IS_LINKED(to->room, DIR_NORTH ) )
		||  (!room_exists( ( to = get_ocean_xy(pO->x +setexit[DIR_EAST][DIR_X], pO->y, pO->z) ) )
		|| !IS_LINKED(to->room, DIR_EAST )))))
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].wall);
			strcat(buf, buf2);
		}
		else if( !check_ne(pO->room) )
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].wall);
			strcat(buf, buf2);
		}
		else
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].walk);
			strcat(buf, buf2);
		}

		return buf;
	}

	if(depth == 1)
	{	if( (ch->is_building() && BUILDING_CHECK(DIR_WEST,ch) )
		|| (!ch->is_building() && (!room_exists( (to = get_ocean_xy(pO->x + setexit[DIR_WEST][DIR_X], pO->y, pO->z) ) ) ) 
		|| !IS_LINKED(to->room, DIR_WEST) ))
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].wall);
			strcat(buf, buf2);
		}
		else
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].walk);
			strcat(buf, buf2);
		}


		if(	(ch->is_building() && ch->in_room == pO->room ) ||
			(!ch->is_building() && ch->cordinate[CORD_X] == pO->x && ch->cordinate[CORD_Y] == pO->y) )
		{	sprintf(buf2, "{R@{x");
			strcat(buf, buf2);
		}
		else
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].walk);
			strcat(buf, buf2);
		}

		if( ( ch->is_building() && BUILDING_CHECK(DIR_EAST,ch) )
		|| ( !ch->is_building() && ( !room_exists( (to = get_ocean_xy(pO->x + setexit[DIR_EAST][DIR_X], pO->y, pO->z) ) )
		|| !IS_LINKED(to->room, DIR_EAST) )))
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].wall);
			strcat(buf, buf2);
		}
		else
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].walk);
			strcat(buf, buf2);
		}
		return buf;
	}
	if(depth == 2)
	{	if( (ch->is_building() && BUILDING_CHECK(DIR_SOUTH, ch) && BUILDING_CHECK(DIR_WEST,ch) )
		|| ( !ch->is_building() &&  (( !room_exists( ( to = get_ocean_xy(pO->x, pO->y + setexit[DIR_SOUTH][DIR_Y], pO->z) ) )
			|| !IS_LINKED(to->room, DIR_SOUTH) ) 
			|| ( !room_exists( (to = get_ocean_xy(pO->x +setexit[DIR_WEST][DIR_X], pO->y, pO->z) ) ) 
			|| !IS_LINKED(to->room, DIR_WEST) ) ) ) )
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].wall);
			strcat(buf, buf2);
		}
		else if( !check_sw(pO->room)  )
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].wall);
			strcat(buf, buf2);
		}
		else
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].walk);
			strcat(buf, buf2);
		}
		
		if( (ch->is_building() && BUILDING_CHECK(DIR_SOUTH, ch) )
		|| (!ch->is_building() && (!room_exists( (to = get_ocean_xy(pO->x, pO->y + setexit[DIR_SOUTH][DIR_Y], pO->z) ) )
		|| !IS_LINKED(to->room, DIR_SOUTH ) ) ))
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].wall);
			strcat(buf, buf2);
		}
		else
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].walk);
			strcat(buf, buf2);;
		}
	
		if( ( ch->is_building() && BUILDING_CHECK(DIR_SOUTH,ch) && BUILDING_CHECK(DIR_EAST,ch) )
		|| ( !ch->is_building() && ( ( !room_exists( (to = get_ocean_xy(pO->x, pO->y + setexit[DIR_SOUTH][DIR_Y], pO->z) ) )
			|| !IS_LINKED(to->room, DIR_SOUTH) )
			|| ( !room_exists( (to = get_ocean_xy(pO->x +setexit[DIR_EAST][DIR_X], pO->y, pO->z) ) )
			|| !IS_LINKED(to->room, DIR_EAST ) ) ) ))
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].wall);
			strcat(buf, buf2);
		}
		else if( !check_se(pO->room) )
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].wall);
			strcat(buf, buf2);
		}
		else
		{	sprintf(buf2, "%s", rgbsect_table[pO->sector_type].walk);
			strcat(buf, buf2);
		}

		return buf;
	}
*/
	static char buf[MSL];
	sprintf(buf, "   ");
	return buf;

		}


char * send_tri_list(CHAR_DATA *ch, int depth, OCEAN_DATA *pR )
{	static char buf[MSL];
	buf[0] = '\0';
	if( depth == 0 )
		strcat(buf, spot_one(pR, depth, ch));
	if( depth == 1 )
		strcat(buf, spot_one(pR, depth, ch));
	if( depth == 2 )
		strcat(buf, spot_one(pR, depth, ch));
	strcat(buf, "{x");
	return buf;
}

OCEAN_DATA *ocean_room;

void map_to_char( CHAR_DATA *ch, int width, int height )
{	int x, y, y2;
	int center = MAX_OMAP/2;
	int door = 0;
	bool found = FALSE;
	char line[MSL];
	int sent = 0;
	send_to_char("\n\r",ch);
	for( y = center-height; y < center+height ; y++ )
	{	for( x = center-height ; x < center+height; x++ )
			if(city_map[x][y] )
			{	found = TRUE;
				break;
			}
			if(found)
			{	sent++;
				for( door = 0; door < 3 ; door++ )
				{	line[0] = '\0';
					for( x = center-height ; x < center+height ; x++ )
					{	found = FALSE;
						for( y2 = center-height; y2 < center+height ; y2++ )
							if(city_map[x][y2] )
								found = TRUE;
						if(found)
						{
							if( city_map[x][y] == ocean_room )
								strcat(line, "{P   ");
							else if(!city_map[x][y] )
								strcat(line, "   ");
							else
								printf_to_char(ch, "(%d,%d,%d)", city_map[x][y]->x, city_map[x][y]->y, city_map[x][y]->z); //strcat(line, send_tri_list(ch, door, city_map[x][y]));
						}
					}
					printf_to_char(ch, " {c|{x\n\r");
				}
			}
		found = FALSE;
	}
	return;
}
void send_map_point(int sector, CHAR_DATA *ch)
{	switch(sector)
	{	case SECT_MAX:		send_to_char("R",ch);		break;
		case SECT_FOREST:	send_to_char("{g@{x",ch);		break;
		case SECT_FIELD:	send_to_char("{G\"{x",ch);	break;
		case SECT_HILLS:	send_to_char("{G^{x",ch);		break;
		case SECT_ROAD:		send_to_char("{y+{x",ch);		break;
		case SECT_WATER_SWIM:	send_to_char("{B:{x",ch);		break;
		case SECT_WATER_NOSWIM:	send_to_char("{b:{x",ch);		break;
		case SECT_AIR:		send_to_char("{C%{x",ch);		break;
		case SECT_DESERT:	send_to_char("{Y={x",ch);		break;
		case SECT_INSIDE:	send_to_char("{W%{x",ch);		break;
		case SECT_CITY:		send_to_char("{W#{x",ch);		break;
		case SECT_MOUNTAIN:	send_to_char("{D^{x",ch);		break;	
		case SECT_DOCK:		send_to_char("{Y#{x",ch);		break;
		case (SECT_MAX+1):	send_to_char("{D?{x",ch);		break;
		default: 		send_to_char("{R@{x",ch);
	} /* end switch1 */
}

int ocean_map[MAX_OMAP][MAX_OMAP];
void send_ocean_char(CHAR_DATA *);
void map_ocean( CHAR_DATA *ch )
{	OCEAN_DATA *pO;
	CHAR_DATA *vict;
	int a=0, b=0;
	int x, y, z, xstart = 0;
	int center = MAX_OMAP/2;
	x = ch->cordinate[CORD_X];
	y = ch->cordinate[CORD_Y];
	z = ch->cordinate[CORD_Z];	
	for( a = 0; a < MAX_OMAP ; a++ )
		for( b = 0; b < MAX_OMAP ; b++)
		{       if(z > 0)
			   ocean_map[a][b] = SECT_AIR;
			else
			   ocean_map[a][b] = -1;
			city_map[a][b] = NULL;
		}

	if(ch->is_building())
	{	ch->building_map();
		return;
	}


	ocean_room = (OCEAN_DATA *) calloc(1, sizeof(*ocean_room) );
	a = 0;
	b = 0;
	if( x < center )
		b = center-x;
	if( y < center )
		a = center-y;
	xstart = b;
	x -= center;
	y -= center;
	if(x < 0 )
		x = 0;
	if(y < 0 )
		y = 0;
	for(; a < MAX_OMAP && y < MAX_OCEAN_Y; a++ )
	{	x = ch->cordinate[CORD_X]-center;
		if( x < 0 )
			x = 0;
		b = xstart;
		for(; b < MAX_OMAP && x < MAX_OCEAN_X; b++ )
		{	if( ( pO = get_ocean_xy(x, y, z) ) )
			{	ocean_map[b][a] = pO->sector_type;
			}
			city_map[b][a] = pO ? pO : ocean_room ;
			x++;
		}
		y++;
	}
	ocean_map[center][center] = SECT_MAX * 2;
	printf_to_char(ch, "%d\n\r", xstart);
	if(!IS_VIRTUAL(ch->in_ocean) )
		map_to_char(ch, 5, 5 );
	else
		send_ocean_char(ch);
	do_function(ch, &do_exits, "auto");
	free(ocean_room);
	printf_to_char(ch, "x:%d y:%d z:%d\n\r", ch->cordinate[CORD_X], ch->cordinate[CORD_Y], ch->cordinate[CORD_Z] );
	printf_to_char(ch, "x:%d y:%d z:%d\n\r", ch->in_ocean->x, ch->in_ocean->y, ch->in_ocean->z);
	printf_to_char(ch, "Sector %d\n\r", ch->in_ocean->sector_type);
	printf_to_char(ch, "Vnum %d\n\r", ch->in_ocean->room ? ch->in_ocean->room->vnum : -1 );
	send_to_char("\n\r",ch);
	for(vict = IN_ROOM_LIST(ch) ; vict ; vict = vict->next_in_room)
		printf_to_char(ch, "\t%s\n\r", vict->name);

	return;
}

void send_ocean_char(CHAR_DATA *ch)
{	int x, y;
	int center = MAX_OMAP/2;
	bool found = FALSE;
	for( y = center-5 ; y < center + 5 ; y++ )
	{	for( x = center - 5 ; x < center + 5 ; x++ )
		{	if( ocean_map[x][y] != -1 )
			{	found = TRUE;
				break;
			}
		}
		if(found)
			for( x = center-5 ; x < center + 5; x++)
			{	if( ocean_map[x][y] >= 0 )
					send_map_point(ocean_map[x][y], ch);
				else if ( ocean_map[x][y] == -1)
				{	if(number_range(1, 6) == 2 )
						send_to_char("{g{P^{x",ch);
					else
						send_to_char("{P {x",ch);
				}
				else
					send_to_char(" ",ch);
			}
		found = FALSE;
		send_to_char("\n\r",ch);
	}
	return;
}


