/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik Stfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

/***************************************************************************
*	ROM 2.4 is copyright 1993-1998 Russ Taylor			   *
*	ROM has been brought to you by the ROM consortium		   *
*	    Russ Taylor (rtaylor@hypercube.org)				   *
*	    Gabrielle Taylor (gtaylor@hypercube.org)			   *
*	    Brian Moore (zump@rom.org)					   *
*	By using this code, you have agreed to follow the terms of the	   *
*	ROM license, in the file Rom24/doc/rom.license			   *
***************************************************************************/

#include <list>

/*
 * Accommodate old non-Ansi compilers.
 */
#if defined(TRADITIONAL)
#define DECLARE_OBJ_FUN( fun )		void fun( )
#define DECLARE_ROOM_FUN( fun )		void fun( )
#define const
#define args( list )			( )
#define DECLARE_DO_FUN( fun )		void fun( )
#define DECLARE_SPEC_FUN( fun )		bool fun( )
#define DECLARE_SONG_FUN( fun )         void fun( )
#define DECLARE_OBJ_FUN( fun )		OBJ_FUN	  fun
#define DECLARE_ROOM_FUN( fun )		ROOM_FUN  fun
#else
#define args( list )			list
#define DECLARE_DO_FUN( fun )		DO_FUN    fun
#define DECLARE_SPEC_FUN( fun )		SPEC_FUN  fun
#define DECLARE_SONG_FUN( fun )         void fun( )
#define DECLARE_OBJ_FUN( fun )		OBJ_FUN	  fun
#define DECLARE_ROOM_FUN( fun )		ROOM_FUN  fun
#endif

#define DECLARE_SPELL_FUN(cmd) DO_SPELL cmd
#define DECLARE_OLC_ED(cmd) OLC_ED cmd
#define OLC_EDITOR(cmd)	void cmd(CHAR_DATA *ch, char *arg)
#define DECLARE_OLC_MENU(cmd) OLC_MENU_FUN cmd
#define OLC_MENU(cmd) void cmd( CHAR_DATA *ch )
#define VAR_SAVER(cmd) void cmd( FILE *fp, void *save, const struct save_type *save_table, int spot, int max )
#define VAR_EDITOR(cmd) void cmd( CHAR_DATA *ch, char *arg, void *save, const struct save_type *save_table, int spot, int max )
#define VAR_LOADER(cmd) void cmd( FILE *fp, void *save, const struct save_type *save_table, int spot, int max )
#define DECLARE_VAR_ED(cmd) ED_VAR cmd
#define DECLARE_VAR_SV(cmd) VAR_SAVE cmd
#define DECLARE_VAR_LD(cmd) VAR_LOAD cmd
#define DECLARE_OLC_MENU(cmd) OLC_MENU_FUN cmd
#define DECLARE_OLC_ED(cmd) OLC_ED cmd

/*
 * Short scalar types.
 * Diavolo reports AIX compiler has bugs with short types.
 */
#if	!defined(FALSE)
#define FALSE	 0
#endif

#if	!defined(TRUE)
#define TRUE	 1
#endif

#if	defined(_AIX)
#if	!defined(const)
#define const
#endif
typedef int				sh_int;
typedef int				bool;
#define unix
#else
typedef int			sh_int;
#ifndef __cplusplus
typedef unsigned char			bool;
#endif
#endif

#define DEBUG


/*
 * Structure types.
 */
typedef struct	affect_data			AFFECT_DATA;
typedef struct	area_data			AREA_DATA;
typedef struct	ban_data			BAN_DATA;
typedef struct 	buf_type	 		BUFFER;
typedef struct	char_data			CHAR_DATA;
typedef struct	descriptor_data		DESCRIPTOR_DATA;
typedef struct	exit_data			EXIT_DATA;
typedef struct	extra_descr_data	EXTRA_DESCR_DATA;
typedef struct	help_data			HELP_DATA;
typedef struct	kill_data			KILL_DATA;
typedef struct	mem_data			MEM_DATA;
typedef struct	mob_index_data		MOB_INDEX_DATA;
typedef struct	note_data			NOTE_DATA;
typedef struct	obj_data			OBJ_DATA;
typedef struct	obj_index_data		OBJ_INDEX_DATA;
typedef struct	pc_data				PC_DATA;
typedef struct  gen_data			GEN_DATA;
typedef struct	reset_data			RESET_DATA;
typedef struct	room_index_data		ROOM_INDEX_DATA;
typedef struct	shop_data	    SHOP_DATA;
typedef struct	time_info_data	    TIME_INFO_DATA;
typedef struct	weather_data	    WEATHER_DATA;
typedef struct  bounty_data         BOUNTY_DATA;
typedef struct	colour_data	    COLOUR_DATA;
typedef struct  prog_list           PROG_LIST;
typedef struct  prog_code           PROG_CODE;
typedef struct  auction_data        AUCTION_DATA;
typedef struct  wiz_data            WIZ_DATA;
typedef struct  clan_type           CLAN_DATA;
typedef struct  war_data            WAR_DATA; 
typedef struct  nick_data	    NICK_DATA;
typedef struct  member_data	    MEMBER_DATA;
typedef struct  email_type	    EMAIL_DATA;
typedef struct  stat_data	    STAT_DATA;
typedef struct  command_type	    CMD_DATA;
typedef struct  mine_type	    MINE_DATA;
typedef struct  shaft_type          SHAFT_DATA;
typedef struct  pet_data            PET_DATA;
typedef struct	religion_type       RELIGION;
typedef struct	wearloc_type        WEAR_LOC;
 
typedef struct  house_data          HOUSE_DATA;
typedef struct  mail_data           MAIL_DATA;
typedef struct  group_type			GROUP_DATA;
typedef struct	lang_type			LANGUAGE;
typedef struct	word_lang_type		WLANG_DATA;
typedef struct	event_data			EVENT_DATA;
typedef struct	use_data			USE;
typedef struct	ocean_type			OCEAN_DATA;
typedef struct	node_type			NODE;
typedef struct	node2_type			NODE2;
typedef struct	building_type		BUILDING;
typedef struct	floor_type			FLOOR;
typedef struct	portal_type			PORTAL;

typedef void    OLC_ED				args( (CHAR_DATA *ch, char *arg ) );
typedef void	OLC_MENU_FUN		args( (CHAR_DATA *ch) );
typedef void	DO_SPELL			args( ( CHAR_DATA *ch, char *argument) );

/*
 * Function types.
 */
typedef	void DO_FUN	args( ( CHAR_DATA *ch, char *argument ) );
typedef bool SPEC_FUN	args( ( CHAR_DATA *ch ) );
typedef void SONG_FUN   args( ( int songnum, int level, CHAR_DATA *ch ) );
typedef void OBJ_FUN	args( ( OBJ_DATA *obj, char *argument ) );
typedef void ROOM_FUN	args( ( ROOM_INDEX_DATA *room, char *argument ) );


extern		std::list<BUILDING *>	building_list;

/*
 * String and memory management parameters.
 */
#define	MAX_KEY_HASH		1024
#define MAX_STRING_LENGTH	20000
#define MAX_INPUT_LENGTH	 5000
#define PAGELEN			   22
#define MAX_MEM_LIST            11

/* I am lazy :) */
#define MSL MAX_STRING_LENGTH
#define MIL MAX_INPUT_LENGTH
#define MAX_EXITS               4
#define MONEY                   "Silver"
/* max shares per level */
#define SHARE_MAX               5
#define AUCTION_LENGTH          5
#define MAX_VNUM                32768
#define MAX_STORAGE             15
#define MAX_QUOTES              10
#define MAX_WAYPOINT            10
#define MAX_ADMIN               3
#define LI3                     MAX_LEVEL/6
#define LI2                     MAX_LEVEL/3
#define LI1                     MAX_LEVEL 
#define MIN_TEMP                -40
#define MAX_TEMP                120
#define MOBJLEVEL               10
#define MAX_ITEM                1
#define MIN_XP                  2000
#define MIN_RAIN                0
#define MAX_SONGS				20
/*
 * Game parameters.
 * Increase the max'es if you add more of something.
 * Adjust the pulse numbers to suit yourself.
 */
extern int MAX_SKILL;
extern int MAX_CLAN;
extern int MAX_CLASS;
extern int MAX_PC_RACE;
extern int setexit[6][3];
#define DIR_X 0
#define DIR_Y 1
#define DIR_Z 2

#define MAX_GROUP		   35
#define MAX_IN_GROUP		   80
#define MAX_ALIAS		    5
#define GROUP_RANGE			6 /*The level range. Right now its +/- 6 */

#define MAX_RANK                    6 /* guild.c */
#define MAX_DAMAGE_MESSAGE	   34
#define MAX_LEVEL		   110
#define MAX_MINERALS		   12
#define MAX_OCEAN_X			500
#define MAX_OCEAN_Y			350
#define MAX_OCEAN_Z			100

#define LEVEL_HERO		   (MAX_LEVEL - 9)
#define LEVEL_IMMORTAL		   (MAX_LEVEL - 8)

#define PULSE_PER_SECOND	    4
#define PULSE_VIOLENCE		  ( 3 * PULSE_PER_SECOND)
#define PULSE_MOBILE		  ( 4 * PULSE_PER_SECOND)
#define PULSE_MUSIC		  ( 6 * PULSE_PER_SECOND)
#define PULSE_TICK		  (60 * PULSE_PER_SECOND)
#define PULSE_AREA		  (120 * PULSE_PER_SECOND)
#define PULSE_AUCTION             (30 * PULSE_PER_SECOND)
#define PULSE_HINT                (30 * PULSE_PER_SECOND)
#define PULSE_EVENT               ( 2 * PULSE_PER_SECOND)


#define IMPLEMENTOR		MAX_LEVEL
#define	CREATOR			(MAX_LEVEL - 1)
#define SUPREME			(MAX_LEVEL - 2)
#define DEITY			(MAX_LEVEL - 3)
#define GOD			(MAX_LEVEL - 4)
#define IMMORTAL		(MAX_LEVEL - 5)
#define DEMI			(MAX_LEVEL - 6)
#define ANGEL			(MAX_LEVEL - 7)
#define AVATAR			(MAX_LEVEL - 8)
#define HERO			LEVEL_HERO

#ifdef IMC
   #include "imc.h"
#endif

#define TYPE_HIT                     1000 // I guess it aint that bad.......... Ugggg
#define TYPE_SPELL					 2000 // Ok, so its catchy.
#define TYPE_UNDEFINED		-1 //This is in cause I dun wanna have to do more checks :)
#define DAM_NONE			-1
#define DAM_BASH			0
#define DAM_PIERCE			1
#define DAM_SLASH			2
#define DAM_FIRE			3
#define DAM_COLD			4
#define DAM_ELECTRIC		5
#define DAM_LIGHT			6
#define DAM_LIFE			7
#define DAM_DEATH			8
#define DAM_WATER			9
#define DAM_EARTH			10
#define MAX_RES				11

/*Align's for Races */
#define ALIGN_GOOD 	750
#define ALIGN_EVIL 	-750
#define ALIGN_NEUTRAL 	0

/* Max spells for sorcerers. Since counting wont be dynamic! */
#define MAX_LIFE			8
#define MAX_LIGHT			6
#define MAX_FIRE			6
#define MAX_WATER			5
#define MAX_EARTH			5
#define MAX_AIR				5

/* End character */
#define END_CHAR "$"
/*
 * ColoUr stuff v2.0, by Lope.
 */
#define CLEAR		"\e[0m"		/* Resets Colour	*/
#define C_RED		"\e[0;31m"	/* Normal Colours	*/
#define C_GREEN		"\e[0;32m"
#define C_YELLOW	"\e[0;33m"
#define C_BLUE		"\e[0;34m"
#define C_MAGENTA	"\e[0;35m"
#define C_CYAN		"\e[0;36m"
#define C_WHITE		"\e[0;37m"
#define C_D_GREY	"\e[1;30m"  	/* Light Colors		*/
#define C_B_RED		"\e[1;31m"
#define C_B_GREEN	"\e[1;32m"
#define C_B_YELLOW	"\e[1;33m"
#define C_B_BLUE	"\e[1;34m"
#define C_B_MAGENTA	"\e[1;35m"
#define C_B_CYAN	"\e[1;36m"
#define C_B_WHITE	"\e[1;37m"
#define CB_B_BLUE     "\e[1;44m"
#define COLOUR_NONE	7		/* White, hmm...	*/
#define RED		1		/* Normal Colours	*/
#define GREEN		2
#define YELLOW		3
#define BLUE		4
#define MAGENTA		5
#define CYAN		6
#define WHITE		7
#define BLACK		0

#define NORMAL		0		/* Bright/Normal colours */
#define BRIGHT		1

#define ALTER_COLOUR( type )	if( !str_prefix( argument, "red" ) )		\
				{						\
				    ch->pcdata->type[0] = NORMAL;		\
				    ch->pcdata->type[1] = RED;			\
				}						\
				else if( !str_prefix( argument, "hi-red" ) )	\
				{						\
				    ch->pcdata->type[0] = BRIGHT;		\
				    ch->pcdata->type[1] = RED;			\
				}						\
				else if( !str_prefix( argument, "green" ) )	\
				{						\
				    ch->pcdata->type[0] = NORMAL;		\
				    ch->pcdata->type[1] = GREEN;		\
				}						\
				else if( !str_prefix( argument, "hi-green" ) )	\
				{						\
				    ch->pcdata->type[0] = BRIGHT;		\
				    ch->pcdata->type[1] = GREEN;		\
				}						\
				else if( !str_prefix( argument, "yellow" ) )	\
				{						\
				    ch->pcdata->type[0] = NORMAL;		\
				    ch->pcdata->type[1] = YELLOW;		\
				}						\
				else if( !str_prefix( argument, "hi-yellow" ) )	\
				{						\
				    ch->pcdata->type[0] = BRIGHT;		\
				    ch->pcdata->type[1] = YELLOW;		\
				}						\
				else if( !str_prefix( argument, "blue" ) )	\
				{						\
				    ch->pcdata->type[0] = NORMAL;		\
				    ch->pcdata->type[1] = BLUE;		\
				}						\
				else if( !str_prefix( argument, "hi-blue" ) )	\
				{						\
				    ch->pcdata->type[0] = BRIGHT;		\
				    ch->pcdata->type[1] = BLUE;		\
				}						\
				else if( !str_prefix( argument, "magenta" ) )	\
				{						\
				    ch->pcdata->type[0] = NORMAL;		\
				    ch->pcdata->type[1] = MAGENTA;		\
				}						\
				else if( !str_prefix( argument, "hi-magenta" ) ) \
				{						\
				    ch->pcdata->type[0] = BRIGHT;		\
				    ch->pcdata->type[1] = MAGENTA;		\
				}						\
				else if( !str_prefix( argument, "cyan" ) )	\
				{						\
				    ch->pcdata->type[0] = NORMAL;		\
				    ch->pcdata->type[1] = CYAN;			\
				}						\
				else if( !str_prefix( argument, "hi-cyan" ) )	\
				{						\
				    ch->pcdata->type[0] = BRIGHT;		\
				    ch->pcdata->type[1] = CYAN;			\
				}						\
				else if( !str_prefix( argument, "white" ) )	\
				{						\
				    ch->pcdata->type[0] = NORMAL;		\
				    ch->pcdata->type[1] = WHITE;		\
				}						\
				else if( !str_prefix( argument, "hi-white" ) )	\
				{						\
				    ch->pcdata->type[0] = BRIGHT;		\
				    ch->pcdata->type[1] = WHITE;		\
				}						\
				else if( !str_prefix( argument, "grey" ) )	\
				{						\
				    ch->pcdata->type[0] = BRIGHT;		\
				    ch->pcdata->type[1] = BLACK;		\
				}						\
				else if( !str_prefix( argument, "beep" ) )	\
				{						\
				    ch->pcdata->type[2] = 1;			\
				}						\
				else if( !str_prefix( argument, "nobeep" ) )	\
				{						\
				    ch->pcdata->type[2] = 0;			\
				}						\
				else						\
				{						\
		send_to_char_bw( "Unrecognised colour, unchanged.\n\r", ch );	\
				    return;					\
				}

#define LOAD_COLOUR( field )	ch->pcdata->field[1] = fread_number( fp );	\
				if( ch->pcdata->field[1] > 100 )		\
				{						\
				    ch->pcdata->field[1] -= 100;		\
				    ch->pcdata->field[2] = 1;			\
				}						\
				else						\
				{						\
				    ch->pcdata->field[2] = 0;			\
				}						\
				if( ch->pcdata->field[1] > 10 )			\
				{						\
				    ch->pcdata->field[1] -= 10;			\
				    ch->pcdata->field[0] = 1;			\
				}						\
				else						\
				{						\
				    ch->pcdata->field[0] = 0;			\
				}


#define CREATE(result, type, number)                    \
do                                        \
{                                        \
   if (!((result) = (type *) calloc ((number), sizeof(type))))     \
     { perror("malloc failure"); abort(); }               \
} while(0)



#define RACE_CHANGE 0
#define CLASS_CHANGE 1

#define MIN_ALL 11 // Aint got a better place to put it.

/*
 * Site ban structure.
 */

#define BAN_SUFFIX		A
#define BAN_PREFIX		B
#define BAN_NEWBIES		C
#define BAN_ALL			D	
#define BAN_PERMIT		E
#define BAN_PERMANENT		F

/*
 * Clan flags
 */

#define GUILD_DELETED		A
#define GUILD_CHANGED		B
#define GUILD_INDEPENDENT 	C /* a "loner" guild */
#define GUILD_IMMORTAL		E /* immortal only clan */

//Sheath yes no stuff
#define SHEATH_YES 	0
#define SHEATH_NO	1


/******************************************
 * Variable types                         *
 ******************************************/
#define VAR_INT				0
#define VAR_STR				1
#define VAR_STR_ARRAY		2
#define VAR_INT_ARRAY		3
#define VAR_FLAG			4
/******************************************
 * Struct for saving structs               *
 ******************************************/
struct save_type
{	char	*	name;
	int			type;
	void	*	field;
	int			max;		// Only if its an array
};

/******************************************
 * Structure for OLC Editors              *
 ******************************************/
struct olc_ed_type
{	char *name;
	OLC_ED *editor;
	OLC_MENU_FUN *menu;
	int state;
	bool show;
};

#define TYPE_CHAR		0
#define TYPE_OBJ		1
/******************************************
 * One Event                              *
 ******************************************/
struct event_data
{	CHAR_DATA	*	ch;
	OBJ_DATA	*	obj;
	int				type;
	EVENT_DATA	*	next;		//The globle linked list.
	EVENT_DATA  *	next_event;	//The list on a the character/object.
	EVENT_DATA	*	prev;
	EVENT_DATA	*	prev_event;
	char		*	string;
	int				value;
	void		*	arg;
	int				delay;
	int				event;
	DO_FUN		*	do_fun;
};

#define EVENT_PRINT			0
#define BUILD_ENTRANCE		1
#define BUILD_SHAFT			2
#define BUILD_LINK			3
#define EVENT_MINE			4
#define EVENT_HEAT_OBJ		5
#define EVENT_BUSY			6
#define BUILD_BLADE			7
#define BUILD_HILT			8
#define EVENT_CHARGE		9
#define EVENT_SPELLDAM		10
#define EVENT_GENBEAST		11
#define EVENT_STYLE			12
#define EVENT_INT_HILT		13
#define BUILD_AXE			14
/******************************************
 * Structure Definition for Events        *
 ******************************************/
struct event_type
{	char *name;
	int event;
	char **cmdlist;
};

struct	ban_data
{
    BAN_DATA *	next;
    bool	valid;
    sh_int	ban_flags;
    sh_int	level;
    char *	name;
};

struct  wiz_data
{
    WIZ_DATA *  next;
    bool        valid;
    sh_int      level;
    char *      name;
};     

struct buf_type
{
    BUFFER *    next;
    bool        valid;
    sh_int      state;  /* error state of the buffer */
    sh_int      size;   /* size in k */
    char *      string; /* buffer's string */
};

/*
 * Bounty stuff -- by Gomi no sensei
 */

struct bounty_data
{
    BOUNTY_DATA *next;
    bool        valid;
    char *      name;
    int         amount;
};

#define POS_IMP			0
#define POS_BUILD		1
#define POS_QUEST		2
#define POS_ENFORCE		3
#define POS_HBUILD		4
#define POS_IMM			5
#define MAX_POS			6
struct wizcommand_type
{
    char *name;
    struct wizcommand_type *next;

};           

struct	hometown_type
{
	char	*name;
	int	recall;
	int	school;
	int	morgue;
	int	death;
        int     donation;
        int     postal;
};

struct auction_data 
{
   AUCTION_DATA *next;
   OBJ_DATA    *item;
   CHAR_DATA   *owner;
   CHAR_DATA   *high_bidder;
   sh_int       status;
   sh_int       number;
   long         bid;
   bool         valid;
};

struct pet_data
{
    PET_DATA            *next;
    char *              name;
    char *              cname;
    char *              short_desc;
    char *              long_desc;
    int                 cost;
    int                 vnum;
    int                 level;
    int                 max_hit;
    int                 max_mana;
    int                 max_move;
    int                 exp;
    int                 xp_tolevel;
    sh_int              levelflux;
    int                 practice;
    int                 train;
    int                 damroll;
    int                 hitroll;
    int                 armor[4];
    int                 gold;
    int                 silver;
    bool                valid;
};                               


struct house_data
{
    HOUSE_DATA *        next;
    char *		oname;
    char *              objname;
    char *              mobname;
    int                 ovalue;
    int                 mvalue;
    bool		valid;
};
    
struct mail_data
{
    MAIL_DATA * 	next;
    OBJ_DATA *          item;
    int                 box;
    char *              sender;
    char *              to_who;
    char *              subject;
    char *              text;
    char *              date;
    time_t              date_stamp;
    time_t              expire;
    sh_int              id;
    bool                valid;
};
    
struct song_type
{
     char *      name;                   /* Name of song */
     char *      listname;               /* name that shows on do_songs */
     sh_int      level;                  /* Average of player vs instrument */
     SONG_FUN *  song_fun;               /* function called for song */
     sh_int      minimum_position;       /* min position to play song */
     sh_int      min_mana;               /* min mana song takes */
     sh_int      beats;                  /* Waiting time after use */
};


/*
 * Drunk struct
 */
struct struckdrunk
{
	int	min_drunk_level;
	int	number_of_rep;
	char	*replacement[11];
};

 

struct unique_attrib_table
{
  char *descriptive;
};

struct weather_type 
{
   char * description;
};

struct cloud_type
{ 
  char *description;
};

struct rain_type
{
  char *description;
};

struct cloudy_description
{
  char *description;
};

struct hailstorm_description
{
  char *description;
};

struct thunderstorm_description
{ 
  char *description;
};

struct icestorm_description
{
  char *description;
};

struct snow_description
{ 
  char *description;
};

struct blizzard_description
{ 
  char *description;
};

struct foggy_description
{ 
  char *description;
};

struct lightning_description
{
  char *description;
};

struct breeze_description
{
  char *description;
};

struct wind_description
{
  char *description;
};

/* for statlist command*/
#define PK_KILLS         0
#define MOB_KILLS        1
#define PK_DEATHS        2
#define MOB_DEATHS       3
#define MAX_GAMESTAT     4

struct stat_data 
{
    STAT_DATA *next;
    bool valid;
    char *name;                     // name of character
    long gamestat[MAX_GAMESTAT];    // stat data
};

struct smith_type
{
    char * type;
    int cost;
};

struct gamble_item
{
  int vnum;
};      

struct house_item
{
  char *name;
  int cost;
  int vnum;
  int type;
};    

/*
 * Time and weather stuff.
 */
#define SUN_DARK		    0
#define SUN_RISE		    1
#define SUN_LIGHT		    2
#define SUN_SET			    3

#define SKY_CLOUDLESS		    0
#define SKY_CLOUDY		    1
#define SKY_RAINING		    2
#define SKY_LIGHTNING		    3
#define SKY_SNOWING                 4
#define SKY_BLIZZARD                5
#define SKY_FOGGY                   6
#define SKY_HAILSTORM               7
#define SKY_THUNDERSTORM            8
#define SKY_ICESTORM                9
#define SKY_BREEZE                  10
#define SKY_WIND                    11

#define MAX_RAIN                    7
#define MAX_CLOUD                   2
#define MAX_CLOUDY                  2
#define MAX_HAILSTORM               2
#define MAX_THUNDERSTORM            3
#define MAX_ICESTORM                2
#define MAX_SNOW                    2
#define MAX_BLIZZARD                2
#define MAX_FOGGY                   2
#define MAX_LIGHTNING               2
#define MAX_BREEZE                  2
#define MAX_WIND                    2
#define MAX_WEATHER                30

#define SPRING                      0
#define SUMMER                      1
#define FALL                        2
#define WINTER                      3

struct	time_info_data
{
    int		hour;
    int		day;
    int		month;
    int		year;
};

struct	weather_data
{
    int		change;
    int		sky;
    int		sunlight;
    int         season;
};

/*
 * Connected state for a channel.
 */
#define CON_PLAYING			 0
#define CON_GET_NAME			 1
#define CON_GET_OLD_PASSWORD		 2
#define CON_CONFIRM_NEW_NAME		 3
#define CON_GET_NEW_PASSWORD		 4
#define CON_CONFIRM_NEW_PASSWORD	 5
#define CON_GET_NEW_RACE		 6
#define CON_GET_NEW_SEX			 7
#define CON_GET_NEW_CLASS		 8
#define CON_GET_HAIR                     9
#define CON_GET_WEIGHT                  10
#define CON_GET_HEIGHT                  11
#define CON_GET_EYE                     12
#define CON_GET_ALIGNMENT		13
#define CON_GET_GOD                     14
#define CON_DEFAULT_CHOICE		15 
#define CON_GEN_GROUPS			16 
#define CON_PICK_WEAPON			17
#define CON_READ_IMOTD			18
#define CON_READ_MOTD			19
#define CON_BREAK_CONNECT		20
#define CON_COPYOVER_RECOVER            21
#define CON_NOTE_TO                     22
#define CON_NOTE_SUBJECT                23
#define CON_NOTE_EXPIRE                 24
#define CON_NOTE_TEXT                   25
#define CON_NOTE_FINISH                 26   
#define CON_MENU                        27
#define CON_GET_HOMETOWN                28
#define CON_ANSI			29
#define CON_SET_SHORT			30
#define CON_CREATION_MENU		31
#define CON_GET_EMAIL			32

/******************************************
 * OLC States                             *
 ******************************************/
#define STATE_NONE			 0
#define STATE_OLC_MENU		 1

/*
 * Descriptor (channel) structure.
 */
struct	descriptor_data
{
    DESCRIPTOR_DATA *	next;
    DESCRIPTOR_DATA *	snoop_by;
    CHAR_DATA *		character;
    CHAR_DATA *		original;
    bool		valid;
    char *		host;
    sh_int		descriptor;
    sh_int		connected;
	sh_int		OLC_state;
    bool		fcommand;
    char		inbuf		[4 * MAX_INPUT_LENGTH];
    char		incomm		[MAX_INPUT_LENGTH];
    char		inlast		[MAX_INPUT_LENGTH];
    int			repeat;
    char *		outbuf;
    int			outsize;
    int			outtop;
    char *		showstr_head;
    char *		showstr_point;
    void *              pEdit;		/* OLC */
    char **             pString;	/* OLC */
    int			editor;		/* OLC */
    bool		ansi;
	bool		walkabout;
};



/*
 * Attribute bonus structures.
 */
struct	str_app_type
{
    sh_int	tohit;
    sh_int	todam;
    sh_int	carry;
    sh_int	wield;
};

struct	int_app_type
{
    sh_int	learn;
};

struct	wis_app_type
{
    sh_int	practice;
};

struct	dex_app_type
{
    sh_int	defensive;
};

struct	con_app_type
{
    sh_int	hitp;
    sh_int	shock;
};



/*
 * TO types for act.
 */
#define TO_ROOM		    0
#define TO_NOTVICT	    1
#define TO_VICT		    2
#define TO_CHAR		    3
#define TO_ALL		    4

/*
 * Help table types.
 */
struct	help_data
{
    HELP_DATA *	next;
    HELP_DATA * next_area;
    sh_int	level;
    char *	keyword;
    char *	text;
    bool	changed;

};



/*
 * Shop types.
 */
#define MAX_TRADE	 5

struct	shop_data
{
    SHOP_DATA *	next;			/* Next shop in list		*/
    sh_int	keeper;			/* Vnum of shop keeper mob	*/
    sh_int	buy_type [MAX_TRADE];	/* Item types shop will buy	*/
    sh_int	profit_buy;		/* Cost multiplier for buying	*/
    sh_int	profit_sell;		/* Cost multiplier for selling	*/
    sh_int	open_hour;		/* First opening hour		*/
    sh_int	close_hour;		/* First closing hour		*/
};



/*
 * Per-class stuff.
 */

#define MAX_GUILD 	4
#define MAX_STATS 	5
#define STAT_STR 	0
#define STAT_INT	1
#define STAT_WIS	2
#define STAT_DEX	3
#define STAT_CON	4

struct	class_type
{
    char *	name;			/* the full name of the class */
    char *	who_name;	/* Three-letter name for 'who'	*/
    sh_int	attr_prime;		/* Prime attribute		*/
    int   *	weapon;			/* First weapon			*/
    sh_int	guild[MAX_GUILD];	/* Vnum of guild rooms		*/
    sh_int	skill_adept;		/* Maximum skill level		*/
    sh_int	thac0_00;		/* Thac0 for level  0		*/
    sh_int	thac0_32;		/* Thac0 for level 32		*/
    sh_int	hp_min;			/* Min hp gained on leveling	*/
    sh_int	hp_max;			/* Max hp gained on leveling	*/
    bool	fMana;			/* Class gains mana on level	*/
};

struct weapon_type
{
    char *	name;
    int	*	vnum;
    sh_int	type;
};

struct wiznet_type
{
    char *	name;
    long 	flag;
    int		level;
};

struct attack_type
{
    char *	name;			/* name */
    char *	noun;			/* message */
    int   	damage;			/* damage class */
};

struct weight_type
{
    char * name;
};

struct hair_type
{
    char * name;
};

struct height_type
{
    char * name;
};

struct eye_type
{
    char * name;
}; 

struct race_type
{
    char *	name;			/* call name of the race */
    bool	pc_race;		/* can be chosen by pcs */
    bool    imm_only;        /*immortal only pc*/
    long	act;			/* act bits for the race */
    long	aff;			/* aff bits for the race */
    long	off;			/* off bits for the race */
	int		resist[MAX_RES];
    long	form;			/* default form flag for the race */
    long	parts;			/* default parts for the race */
};


struct pc_race_type  /* additional data for pc races */
{
    char *	name;			/* MUST be in race_type */
    char *	who_name;
    sh_int	points;			/* cost in points of the race */
    sh_int *	class_mult;	/* exp multiplier for class, * 100 */
    char *	skills[5];		/* bonus skills for the race */
    sh_int 	stats[MAX_STATS];	/* starting stats */
    sh_int	max_stats[MAX_STATS];	/* maximum stats */
    sh_int	size;			/* aff bits for the race */
	char *	mCity;
};


struct spec_type
{
    char * 	name;			/* special function name */
    SPEC_FUN *	function;		/* the function */
};



/*
 * Data structure for notes.
 */

struct	note_data
{
    NOTE_DATA *	next;
    bool 	valid;
    sh_int	type;
    char *	sender;
    char *	date;
    char *	to_list;
    char *	subject;
    char *	text;
    time_t  	date_stamp;
    time_t	expire;
};

struct summoner_data
{
    char *name;
    int cost;
    int vnum;
};


/*
 * An affect.
 */
struct	affect_data
{
    AFFECT_DATA *	next;
    bool		valid;
    sh_int		where;
    sh_int		type;
    sh_int		level;
    sh_int		duration;
    sh_int		location;
    sh_int		modifier;
    int			bitvector;
};

/* where definitions */
#define TO_AFFECTS	0
#define TO_OBJECT	1
#define TO_IMMUNE	2
#define TO_RESIST	3
#define TO_VULN		4
#define TO_WEAPON	5
#define TO_AFFECTS2     6
#define TO_OBJECT2      7

/*
 * A kill structure (indexed by level).
 */
struct	kill_data
{
    sh_int		number;
    sh_int		killed;
    sh_int              kills;
};


struct	nick_data
{
	char * nickname;
	char * realname;
	char * shortd;
	bool valid;
	NICK_DATA *next;
};

#define MOON_FULL 	4
#define MOON_THREE	3
#define MOON_TWO	2
#define MOON_ONE	1
#define MOON_GONE	0

/*Continent variables */
#define CONT_CALNON    0
#define CONT_BEALOTH   1
#define CONT_PEKSOR    2
#define CONT_HIRROT    3
#define CONT_NONE      4
#define MAX_CONT       5

struct email_type
{
     EMAIL_DATA *next;
     char *name;
     char *email;
     bool valid;
};

extern EMAIL_DATA * email_first;

struct  command_type
{
    CMD_DATA	*	prev;
    CMD_DATA 	*	next;
    CMD_DATA	*	char_next;
    bool			valid;
    char * 	        name;
    DO_FUN *        do_fun;
    sh_int          position;
    sh_int          level;
    sh_int          log;
    sh_int          show;
    sh_int          cat;
	bool			disabled;
};
extern CMD_DATA * cmd_first;
extern CMD_DATA * cmd_last;

#define RANK_INITIATE		0
#define RANK_ACOLYTE		1
#define RANK_DISCIPLE		2
#define RANK_BISHOP			3
#define RANK_PRIEST			4
#define RANK_DEITY			5
#define RANK_GOD			6
#define MAX_RELG_RANK			7

#define FACTION_ONE			0
#define FACTION_TWO			1
#define MAX_FACTION			2

struct religion_type
{
	char *		name;
	char **		rank[MAX_RELG_RANK];
	bool		isfaction; // TRUE if faction.
	RELIGION *	main;    // For Factions only.
	char *		deity;   // For Factions only.
	char *		god;    // Main Religion Only.
	RELIGION *	next;
	bool		valid;
	char **		skpell[MAX_RELG_RANK];    
	RELIGION *  faction[MAX_FACTION];
	AREA_DATA **temple;
	int			donation_vnum;
	char *		sac_msg;
	char *		pmt_msg;
	char *		dmt_msg;
	char *		chan_name;
	char *		mark;
	int  *		devoteSpot;
	int			maxDevote;
	int			maxTemple;
};

/*
struct wearloc_type
{	WEAR_LOC		*		next;
	WEAR_LOC		*		prev;
	WEAR_LOC		*		layer;
	OBJ_DATA		*		belt_list;
	OBJ_DATA		*		sheath;
	char			*		name;
	char			*		eqmsg;
	sh_int					wear_loc;
	bool					belt;
	bool					sheathed;
	bool					valid;
	bool					race[MAX_PC_RACE];
};
*/
struct fix_type
{	int wear;
	int bit;
};

struct lang_type
{	char *name;
	WLANG_DATA *list;
	WLANG_DATA *last; //Gotta keep the order here.
	LANGUAGE *next;
};

struct word_lang_type
{	WLANG_DATA *next;
	WLANG_DATA *prev;
	char *string;
	char **speach;
	int maxSpeach;
};

#define POS_FRONT 0
#define POS_MIDDLE 1
#define POS_BACK 2

#define CRYSTAL_JET		0
#define CRYSTAL_CARN	1
#define CRYSTAL_BLOOD	2
#define CRYSTAL_AQUA	3
#define CRYSTAL_AMETH	4
#define CRYSTAL_QUARTZ	5
#define MAX_CRYSTAL		6

#define MAX_SORC_SPELL	8

extern const struct spell_type spell_table[];
struct spell_type
{	char *name;
	int mana;
//	DO_SPELL *spell;
	int level;
};
struct node_type
{	NODE *next;
	ROOM_INDEX_DATA *target;
	int x,y,z;
};
struct node2_type
{	NODE2 *next;
	OCEAN_DATA *target;
	int x,y,z;
};

struct building_type
{	public:
		int vnum;
		char *name;
		FLOOR *levels;
		int max_levels;
		int ground_level;
		CHAR_DATA *in_building;
		int interior[2];
		int exterior[2];
		AREA_DATA *in_area;
		//Methods
		building_type(std::list<BUILDING *> * tolist );
		~building_type();
		void destroy_levels();
		bool init_levels(int count);
		bool init_levels();
		void add_level( int floor );
		void rem_level( int floor );
		void setx( int x );
		void sety( int y );
		void addx( );
		void addy( );
		void remx( );
		void remy( );
		static BUILDING *find(int vnum )
		{	std::list<BUILDING *>::iterator i;
			for(i = building_list.begin(); i != building_list.end() ; i++ )
				if((*i)->vnum == vnum )
					return (*i);
			return NULL;
		}
};

struct floor_type
{	public:
		ROOM_INDEX_DATA *** rooms;
};

/***************************************************************************
 *                                                                         *
 *                   VALUES OF INTEREST TO AREA BUILDERS                   *
 *                   (Start of section ... start here)                     *
 *                                                                         *
 ***************************************************************************/

/*
 * Well known mob virtual numbers.
 * Defined in #MOBILES.
 */

/* RT ASCII conversions -- used so we can have letters in this file */

#define A		  	1
#define B			2
#define C			4
#define D			8
#define E			16
#define F			32
#define G			64
#define H			128

#define I			256
#define J			512
#define K		        1024
#define L		 	2048
#define M			4096
#define N		 	8192
#define O			16384
#define P			32768

#define Q			65536
#define R			131072
#define S			262144
#define T			524288
#define U			1048576
#define V			2097152
#define W			4194304
#define X			8388608

#define Y			16777216
#define Z			33554432
#define aa			67108864 	/* doubled due to conflicts */
#define bb			134217728
#define cc			268435456    
#define dd			536870912
#define ee			1073741824

/*
 * CLOAK_ bits for character mask.
 */
#define CLOAK_WEAR		(A)
#define CLOAK_REMOVE		(B)

/*
 * HOOD_ bits for character mask.
 */
#define HOOD_RAISED		(A)
#define HOOD_REMOVED		(B)


/*
 * ACT bits for mobs.
 * Used in #MOBILES.
 */
#define ACT_IS_NPC		(A)		/* Auto set for mobs	*/
#define ACT_SENTINEL	    	(B)		/* Stays in one room	*/
#define ACT_SCAVENGER	      	(C)		/* Picks up objects	*/
#define ACT_FORGER              (D)             /* Forger set           */
#define ACT_BOUNTY              (E)             /* Bounty set           */
#define ACT_AGGRESSIVE		(F)    		/* Attacks PC's		*/
#define ACT_STAY_AREA		(G)		/* Won't leave area	*/
#define ACT_WIMPY		(H)
#define ACT_PET			(I)		/* Auto set for pets	*/
#define ACT_TRAIN		(J)		/* Can train PC's	*/
#define ACT_PRACTICE		(K)		/* Can practice PC's	*/
#define ACT_MOUNT		(L)
#define ACT_UNDEAD		(O)	
#define ACT_CLERIC		(Q)
#define ACT_MAGE		(R)
#define ACT_THIEF		(S)
#define ACT_WARRIOR		(T)
#define ACT_NOALIGN		(U)
#define ACT_NOPURGE		(V)
#define ACT_OUTDOORS		(W)
#define ACT_INDOORS		(Y)
#define ACT_IS_HEALER		(aa)
#define ACT_GAIN		(bb)
#define ACT_UPDATE_ALWAYS	(cc)
#define ACT_IS_CHANGER		(dd)
#define ACT_LEVELER             (ee)

/* OFF bits for mobiles */
#define OFF_AREA_ATTACK         (A)
#define OFF_BACKSTAB            (B)
#define OFF_BASH                (C)
#define OFF_BERSERK             (D)
#define OFF_DISARM              (E)
#define OFF_DODGE               (F)
#define OFF_FADE                (G)
#define OFF_FAST                (H)
#define OFF_KICK                (I)
#define OFF_KICK_DIRT           (J)
#define OFF_PARRY               (K)
#define OFF_RESCUE              (L)
#define OFF_TAIL                (M)
#define OFF_TRIP                (N)
#define OFF_CRUSH		(O)
#define OFF_BLOODLUST           (V)
#define ASSIST_ALL       	(P)
#define ASSIST_ALIGN	        (Q)
#define ASSIST_RACE    	     	(R)
#define ASSIST_PLAYERS      	(S)
#define ASSIST_GUARD        	(T)
#define ASSIST_VNUM		(U)
#define OFF_FEED                (V)

/* return values for check_imm */
#define IS_NORMAL		0
#define IS_IMMUNE		1
#define IS_RESISTANT		2
#define IS_VULNERABLE		3
 
/* body form */
#define FORM_EDIBLE             (A)
#define FORM_POISON             (B)
#define FORM_MAGICAL            (C)
#define FORM_INSTANT_DECAY      (D)
#define FORM_OTHER              (E)  /* defined by material bit */
 
/* actual form */
#define FORM_ANIMAL             (G)
#define FORM_SENTIENT           (H)
#define FORM_UNDEAD             (I)
#define FORM_CONSTRUCT          (J)
#define FORM_MIST               (K)
#define FORM_INTANGIBLE         (L)
 
#define FORM_BIPED              (M)
#define FORM_CENTAUR            (N)
#define FORM_INSECT             (O)
#define FORM_SPIDER             (P)
#define FORM_CRUSTACEAN         (Q)
#define FORM_WORM               (R)
#define FORM_BLOB		(S)
 
#define FORM_MAMMAL             (V)
#define FORM_BIRD               (W)
#define FORM_REPTILE            (X)
#define FORM_SNAKE              (Y)
#define FORM_DRAGON             (Z)
#define FORM_AMPHIBIAN          (aa)
#define FORM_FISH               (bb)
#define FORM_COLD_BLOOD		(cc)	
 
/* body parts */
#define PART_HEAD               (A)
#define PART_ARMS               (B)
#define PART_LEGS               (C)
#define PART_HEART              (D)
#define PART_BRAINS             (E)
#define PART_GUTS               (F)
#define PART_HANDS              (G)
#define PART_FEET               (H)
#define PART_FINGERS            (I)
#define PART_EAR                (J)
#define PART_EYE		(K)
#define PART_LONG_TONGUE        (L)
#define PART_EYESTALKS          (M)
#define PART_TENTACLES          (N)
#define PART_FINS               (O)
#define PART_WINGS              (P)
#define PART_TAIL               (Q)
/* for combat */
#define PART_CLAWS              (U)
#define PART_FANGS              (V)
#define PART_HORNS              (W)
#define PART_SCALES             (X)
#define PART_TUSKS		(Y)

/*
 * Sex.
 * Used in #MOBILES.
 */
#define SEX_NEUTRAL		      0
#define SEX_MALE		      1
#define SEX_FEMALE		      2

// Stances by Majik
#define STANCE_NEUTRAL  0
#define STANCE_AGG      1
#define STANCE_DEF      2

/* AC types */
#define AC_PIERCE			0
#define AC_BASH				1
#define AC_SLASH			2
#define AC_EXOTIC			3

/* dice */
#define DICE_NUMBER			0
#define DICE_TYPE			1
#define DICE_BONUS			2

/* size */
#define SIZE_TINY			0
#define SIZE_SMALL			1
#define SIZE_MEDIUM			2
#define SIZE_LARGE			3
#define SIZE_HUGE			4
#define SIZE_GIANT			5
#define SIZE_UNKNOWN                    6


/*
 * Item types.
 * Used in #OBJECTS.
 */

/*
 * Material types
 */
#define	MAT_STEEL	1
#define	MAT_STONE	2
#define	MAT_BRASS	3
#define	MAT_BONE	4
#define	MAT_ENERGY	5
#define	MAT_MITHRIL	6
#define	MAT_COPPER	7
#define	MAT_SILK	8
#define	MAT_MARBLE	9
#define	MAT_GLASS	10
#define	MAT_WATER	11
#define	MAT_FLESH	12
#define	MAT_PLATINUM	13
#define	MAT_GRANITE	14
#define	MAT_LEATHER	15
#define	MAT_CLOTH	16
#define	MAT_GEMSTONE	17
#define	MAT_GOLD	18
#define	MAT_PORCELAIN	19
#define	MAT_OBSIDIAN	20
#define	MAT_DRAGONSCALE	21
#define	MAT_EBONY	22
#define	MAT_BRONZE	23
#define	MAT_WOOD	24
#define	MAT_SILVER	25
#define	MAT_IRON	26
#define	MAT_BLOODSTONE	27
#define	MAT_FOOD	28
#define	MAT_LEAD	29
#define	MAT_WAX		30
#define MAT_DIAMOND     31
#define MAT_CRYSTAL     32
#define MAT_VELLUM      33
#define MAT_PAPER       34
#define MAT_MEAT        35
#define MAT_PILL        36
#define MAT_LIQUID      37
#define MAT_ADAMANTITE  38
#define MAT_UNIQUE      39
#define MAT_UNKNOWN     40


/*
 * Extra flags.
 * Used in #OBJECTS.
 */
#define ITEM_GLOW		(A)
#define ITEM_HUM		(B)
#define ITEM_DARK		(C)
#define ITEM_LOCK		(D)
#define ITEM_EVIL		(E)
#define ITEM_INVIS		(F)
#define ITEM_MAGIC		(G)
#define ITEM_NODROP		(H)
#define ITEM_BLESS		(I)
#define ITEM_ANTI_GOOD		(J)
#define ITEM_ANTI_EVIL		(K)
#define ITEM_ANTI_NEUTRAL	(L)
#define ITEM_NOREMOVE		(M)
#define ITEM_INVENTORY		(N)
#define ITEM_NOPURGE		(O)
#define ITEM_ROT_DEATH		(P)
#define ITEM_VIS_DEATH		(Q)
#define ITEM_NOREPAIR           (R)
#define ITEM_NONMETAL		(S)
#define ITEM_NOLOCATE		(T)
#define ITEM_MELT_DROP		(U)
#define ITEM_HAD_TIMER		(V)
#define ITEM_SELL_EXTRACT	(W)
#define ITEM_QUEST              (X)
#define ITEM_BURN_PROOF		(Y)
#define ITEM_NOUNCURSE		(Z)
#define ITEM_NO_AUCTION         (aa)
#define ITEM_AUCTIONED          (bb)
#define ITEM_HIDDEN             (cc)
#define ITEM_LODGED             (dd)
#define ITEM_NOCOND             (ee)

/*
 * Second set of extra2 flags
 * Used in #OBJECTS 
 */
#define ITEM_UNIQUE             (A)
#define CORPSE_NO_ANIMATE       (B)
#define ITEM_SANC		(C)
#define ITEM_RELIC              (D)

/*
 * Wear flags.
 * Used in #OBJECTS.
 */

#define ITEM_TAKE		(A)
#define ITEM_WEAR_FINGER	(B)
#define ITEM_WEAR_NECK		(C)
#define ITEM_WEAR_BODY		(D)
#define ITEM_WEAR_HEAD		(E)
#define ITEM_WEAR_LEGS		(F)
#define ITEM_WEAR_FEET		(G)
#define ITEM_WEAR_HANDS		(H)
#define ITEM_WEAR_ARMS		(I)
#define ITEM_WEAR_SHIELD	(J)
#define ITEM_WEAR_ABOUT		(K)
#define ITEM_WEAR_WAIST		(L)
#define ITEM_WEAR_WRIST		(M)
#define ITEM_WIELD		(N)
#define ITEM_HOLD		(O)
#define ITEM_NO_SAC		(P)
#define ITEM_WEAR_FLOAT		(Q)
#define ITEM_WEAR_SHOULDER      (R)
#define ITEM_WEAR_CLOAK		(S)
#define ITEM_LAYER_ARMS		(T)
#define ITEM_LAYER_BODY		(U)
#define ITEM_LAYER_LEGS		(V)
#define ITEM_WEAR_BACK		(W)
#define ITEM_WEAR_HOOD		(X)

/* weapon class */
#define WEAPON_EXOTIC		0
#define WEAPON_SWORD		1
#define WEAPON_DAGGER		2
#define WEAPON_SPEAR		3
#define WEAPON_MACE			4
#define WEAPON_AXE			5
#define WEAPON_FLAIL		6
#define WEAPON_WHIP			7	
#define WEAPON_POLEARM		8
#define WEAPON_BOW          9
#define WEAPON_STAFF		10

/* weapon types */
#define WEAPON_FLAMING		(A)
#define WEAPON_FROST		(B)
#define WEAPON_VAMPIRIC		(C)
#define WEAPON_MANA_DRAIN       (D)
#define WEAPON_VORPAL		(E)
#define WEAPON_TWO_HANDS	(F)
#define WEAPON_SHOCKING		(G)
#define WEAPON_POISON		(H)
#define WEAPON_SHARP		(I)
#define WEAPON_ACIDIC           (J)

/* gate flags */
#define GATE_NORMAL_EXIT	(A)
#define GATE_NOCURSE		(B)
#define GATE_GOWITH		(C)
#define GATE_BUGGY		(D)
#define GATE_RANDOM		(E)

/* furniture flags */
#define STAND_AT		(A)
#define STAND_ON		(B)
#define STAND_IN		(C)
#define SIT_AT			(D)
#define SIT_ON			(E)
#define SIT_IN			(F)
#define REST_AT			(G)
#define REST_ON			(H)
#define REST_IN			(I)
#define SLEEP_AT		(J)
#define SLEEP_ON		(K)
#define SLEEP_IN		(L)
#define PUT_AT			(M)
#define PUT_ON			(N)
#define PUT_IN			(O)
#define PUT_INSIDE		(P)




/*
 * Apply types (for affects).
 * Used in #OBJECTS.
 */
#define APPLY_NONE		      0
#define APPLY_STR		      1
#define APPLY_DEX		      2
#define APPLY_INT		      3
#define APPLY_WIS		      4
#define APPLY_CON		      5
#define APPLY_SEX		      6
#define APPLY_CLASS		      7
#define APPLY_LEVEL		      8
#define APPLY_AGE		      9
#define APPLY_HEIGHT		     10
#define APPLY_WEIGHT		     11
#define APPLY_MANA		     12
#define APPLY_HIT		     13
#define APPLY_MOVE		     14
#define APPLY_GOLD		     15
#define APPLY_EXP		     16
#define APPLY_AC		     17
#define APPLY_HITROLL		     18
#define APPLY_DAMROLL		     19
#define APPLY_SAVES		     20
#define APPLY_SAVING_PARA	     20
#define APPLY_SAVING_ROD	     21
#define APPLY_SAVING_PETRI	     22
#define APPLY_SAVING_BREATH	     23
#define APPLY_SAVING_SPELL	     24
#define APPLY_SPELL_AFFECT	     25
#define APPLY_CAST_LEVEL             26
#define APPLY_CAST_ABILITY           27

/*
 * Values for containers (value[1]).
 * Used in #OBJECTS.
 */
#define CONT_CLOSEABLE		      1
#define CONT_PICKPROOF		      2
#define CONT_CLOSED		      4
#define CONT_LOCKED		      8
#define CONT_PUT_ON		     16




/*
 * Room flags.
 * Used in #ROOMS.
 */
#define ROOM_DARK		(A)
#define ROOM_DONATION           (B)
#define ROOM_NO_MOB		(C)
#define ROOM_INDOORS		(D)
#define ROOM_NOMAGIC            (E)
#define ROOM_MOUNT_SHOP		(F)
#define ROOM_BANK               (G)
#define ROOM_PRIVATE		(J)
#define ROOM_SAFE		(K)
#define ROOM_SOLITARY		(L)
#define ROOM_PET_SHOP		(M)
#define ROOM_NO_RECALL		(N)
#define ROOM_IMP_ONLY		(O)
#define ROOM_GODS_ONLY		(P)
#define ROOM_HEROES_ONLY	(Q)
#define ROOM_NEWBIES_ONLY	(R)
#define ROOM_LAW		(S)
#define ROOM_NOWHERE		(T)
#define ROOM_RENTAL             (U)
#define ROOM_RENTED             (W)
#define ROOM_CASINO             (X)
#define ROOM_ARENA              (Y)
#define ROOM_WAYPOINT           (Z)
#define ROOM_MAPPED		(aa)
#define ROOM_MINE		(bb)
#define ROOM_POSTAL             (cc)

/*
 * Directions.
 * Used in #ROOMS.
 */
#define DIR_NORTH		      0
#define DIR_EAST		      1
#define DIR_SOUTH		      2
#define DIR_WEST		      3
#define DIR_UP			      4
#define DIR_DOWN		      5



/*
 * Exit flags.
 * Used in #ROOMS.
 */
#define EX_ISDOOR		      (A)
#define EX_CLOSED		      (B)
#define EX_LOCKED		      (C)
#define EX_PICKPROOF		      (F)
#define EX_NOPASS		      (G)
#define EX_EASY			      (H)
#define EX_HARD			      (I)
#define EX_INFURIATING		      (J)
#define EX_NOCLOSE		      (K)
#define EX_NOLOCK		      (L)
#define EX_NOBASH                     (M)
#define EX_HIDDEN             (N)


/*
 * Sector types.
 * Used in #ROOMS.
 */
#define SECT_INSIDE		      0
#define SECT_CITY		      1
#define SECT_FIELD		      2
#define SECT_FOREST		      3
#define SECT_HILLS		      4
#define SECT_MOUNTAIN		      5
#define SECT_WATER_SWIM		      6
#define SECT_WATER_NOSWIM	      7
#define SECT_UNUSED		      8
#define SECT_AIR		      9
#define SECT_DESERT		     10
#define SECT_FARM		     11
#define SECT_DOCK			 12
#define SECT_BEACH			 13
#define SECT_ROAD			14
#define SECT_MAX		     15


/*
 * Sheath Strap locations.
 */
#define STRAP_NONE		-1
#define STRAP_THIGH		 0
#define STRAP_ANKLE		 1
#define STRAP_SHOULDER		 2
#define STRAP_WRIST_R		 3
#define STRAP_WRIST_L	 	 4
#define STRAP_MAX		 5

/*
 * Equpiment wear locations.
 * Used in #RESETS.
 */

#define WEAR_NONE		 			-1
#define WEAR_LIGHT					0
#define WEAR_HOOD					1
#define WEAR_HEAD					2
#define WEAR_CLOAK					3
#define WEAR_NECK_1					4
#define WEAR_NECK_2					5
#define WEAR_ABOUT					6
#define WEAR_BACK					7
#define WEAR_SHOULDER					8
#define WEAR_LAYER_ARMS					9
#define WEAR_ARMS					10
#define WEAR_WRIST_L					11
#define WEAR_WRIST_R					12
#define WEAR_HANDS					13
#define WEAR_FINGER_L					14
#define WEAR_FINGER_R					15
#define WEAR_LAYER_BODY					16
#define WEAR_BODY					17
#define WEAR_WAIST					18
#define WEAR_LAYER_LEGS					19
#define WEAR_LEGS					20
#define WEAR_FEET					21
#define WEAR_SHIELD					22
#define WEAR_WIELD					23
#define WEAR_SECONDARY					24
#define WEAR_HOLD					25
#define WEAR_FLOAT					26
#define WEAR_LODGE_LEG			            	27
#define WEAR_LODGE_ARM  		                28
#define WEAR_LODGE_RIB             			29
#define MAX_WEAR					30

/***************************************************************************
 *                                                                         *
 *                   VALUES OF INTEREST TO AREA BUILDERS                   *
 *                   (End of this section ... stop here)                   *
 *                                                                         *
 ***************************************************************************/

/*
 * Conditions.
 */
#define COND_DRUNK		      0
#define COND_FULL		      1
#define COND_THIRST		      2
#define COND_HUNGER		      3



/*
 * Positions.
 */
#define POS_DEAD		      0
#define POS_MORTAL		      1
#define POS_INCAP		      2
#define POS_STUNNED		      3
#define POS_SLEEPING		      4
#define POS_RESTING		      5
#define POS_SITTING		      6
#define POS_FIGHTING		      7
#define POS_STANDING		      8


/*
 * ACT bits for players.
 */
#define PLR_IS_NPC		(A)		/* Don't EVER set.	*/

/* RT auto flags */
#define PLR_AUTOASSIST		(C)
#define PLR_AUTODAMAGE		(D)
#define PLR_AUTOEXIT		(E)
#define PLR_AUTOLOOT		(F)
#define PLR_AUTOSAC             (G)
#define PLR_AUTOGOLD		(H)
#define PLR_AUTOSPLIT		(I)
#define PLR_TIMEOUT		(O)
#define PLR_TENNANT             (cc)
#define PLR_FREQUENT            (M)

/* RT personal flags */
#define PLR_HOLYLIGHT		(N)
#define PLR_CANLOOT		(P)
#define PLR_NOSUMMON		(Q)
#define PLR_NOFOLLOW		(R)
#define PLR_DEATH		(S)
#define PLR_COLOUR		(T)
#define PLR_MARK		(V)

/* penalty flags */
#define PLR_PERMIT		(U)
#define PLR_LOG			(W)
#define PLR_DENY		(X)
#define PLR_FREEZE		(Y)
#define PLR_THIEF		(Z)
#define PLR_KILLER		(aa)
#define PLR_IMPLAG              (bb)
#define PLR_REMORT              (K)
#define PLR_MORTAL_LEADER       (L)
#define	PLR_WAR                 (dd)
#define PLR_AUTOWEATHER         (ee)

/* weight values */

#define WEIGHT_SLENDER 	0
#define WEIGHT_SLIM    	1
#define WEIGHT_AVERAGE 	2
#define WEIGHT_STOCKY  	3
#define WEIGHT_HEAVY   	4
#define MAX_WEIGHT      5
/* Eye color values */

#define EYE_BLUE  	0
#define EYE_GREEN 	1
#define EYE_BROWN 	2
#define EYE_BLACK 	3
#define EYE_WHITE 	4
#define EYE_CLEAR 	5
#define EYE_RED   	6
#define MAX_EYE		7

/* Height values */

#define HEIGHT_SHORT   0
#define HEIGHT_MIDGET  1
#define HEIGHT_AVERAGE 2
#define HEIGHT_TALL    3
#define HEIGHT_GIANT   4
#define MAX_HEIGHT     5

/* Hair color values */

#define HAIR_BLOND  0
#define HAIR_RED    1
#define HAIR_BLACK  2
#define HAIR_BROWN  3
#define HAIR_WHITE  4
#define HAIR_BLUE   5
#define MAX_HAIR    6

// Chan flags - for Aethaellyn's new channel system.
#define CHAN_OOC                0
#define CHAN_GOSSIP             1
#define CHAN_QUOTE              2
#define CHAN_MUSIC              3
#define CHAN_QA                 4
#define CHAN_AUCT               5
#define CHAN_GRATS              6
#define CHAN_IMM                7
#define CHAN_CLAN               8
#define CHAN_IMP		9                                       
#define CHAN_HERO		10
#define CHAN_NEWBIE             11
#define CHAN_ADMIN              12
#define CHAN_GOD		13

/* RT comm flags -- may be used on both mobs and chars */
#define COMM_QUIET              (A)
#define COMM_DEAF            	(B)
#define COMM_NOWIZ              (C)
#define COMM_NOAUCTION          (D)
#define COMM_NOGOSSIP           (E)
#define COMM_NOQUESTION         (F)
#define COMM_NOMUSIC            (G)
#define COMM_NOCLAN		(H)
#define COMM_NOQUOTE		(I)
#define COMM_SHOUTSOFF		(J)
#define COMM_NOINFO             (K)

/* display flags */
#define COMM_COMPACT		(L)
#define COMM_BRIEF		(M)
#define COMM_PROMPT		(N)
#define COMM_COMBINE		(O)
#define COMM_TELNET_GA		(P)
#define COMM_SHOW_AFFECTS	(Q)
#define COMM_NOGRATS		(R)
#define COMM_NOENTER            (S)
#define COMM_NOPRAY             (aa)
#define COMM_NORACE             (bb)
#define COMM_NOHERO             (cc)
#define COMM_NOHINT             (dd)
#define COMM_PENTER             (ee)
#define COMM_NOOOC              (X)

/* penalties */
#define COMM_NOEMOTE		(T)
#define COMM_NOSHOUT		(U)
#define COMM_NOTELL		(V)
#define COMM_NOCHANNELS		(W) 
#define COMM_SNOOP_PROOF	(Y)
#define COMM_AFK		(Z)

/* More comm flags */
#define COMM_NOIMP              (A)
#define COMM_SHOW_ARMOR         (B)
#define COMM_NONEWBIE           (C)
#define COMM_AUTO_AFK           (D)
#define COMM_ANNOUNCE           (E)
#define COMM_AUTOLEVEL          (F)
#define COMM_PETLEVEL           (G)
#define COMM_NOADMIN            (H)

/* WIZnet flags */
#define WIZ_ON			(A)
#define WIZ_TICKS		(B)
#define WIZ_LOGINS		(C)
#define WIZ_SITES		(D)
#define WIZ_LINKS		(E)
#define WIZ_DEATHS		(F)
#define WIZ_RESETS		(G)
#define WIZ_MOBDEATHS		(H)
#define WIZ_FLAGS		(I)
#define WIZ_PENALTIES		(J)
#define WIZ_SACCING		(K)
#define WIZ_LEVELS		(L)
#define WIZ_SECURE		(M)
#define WIZ_SWITCHES		(N)
#define WIZ_SNOOPS		(O)
#define WIZ_RESTORE		(P)
#define WIZ_LOAD		(Q)
#define WIZ_NEWBIE		(R)
#define WIZ_PREFIX		(S)
#define WIZ_SPAM		(T)
#define WIZ_OLC         (U)
#define WIZ_UNIQUE		(V)

#define SUPPRESS_FLAGS          (A)
#define SUPPRESS_FLAG_EFFECTS   (B)
#define SUPPRESS_DODGE          (C)
#define SUPPRESS_STD            (D)
#define SUPPRESS_BURN           (E)
#define SUPPRESS_SHIELD         (F)
#define SUPPRESS_SHIELD_COMP    (G)          

typedef struct guild_rank       rankdata;

struct guild_rank
{
  char *rankname;               /* name of rank                         */
  char *skillname;              /* name of skill earned at this rank    */
};

/* mortal leader rights are as follows;
 ml[0] = can_guild
 ml[1] = can_deguild
 ml[2] = can_promote
 ml[3] = can_demote
*/

struct member_data
{
  MEMBER_DATA *next;
  char *name;
  int rank;
  int level;
  int flevel;
  bool valid;
  bool ldr;
  int laston;
};

struct clan_type
{
  MEMBER_DATA * member_first;
  long flags;                   /* flags for guild                      */
  char *name;			/* name of guild                        */
  char *who_name;		/* name sent for "who" command		*/
  int room[3];                  /* hall/morgue/temple rooms             */
  rankdata rank[MAX_RANK];	/* guilds rank system                   */
  int ml[4];			/* mortal leader rights 		*/
  char ** awarded;
  int	  maxAward;
};

#define	WAR_OFF     0
#define	WAR_WAITING 1
#define	WAR_RUNNING 2

struct war_data
{
    char *who;
    int min_level;
    int max_level;
    int inwar;
    int wartype;
    int timer;
    int iswar;
    int next;
};

/*
 * Prototype for a mob.
 * This is the in-memory version of #MOBILES.
 */
struct	mob_index_data
{
    AREA_DATA *		area;		/* OLC */
    PROG_LIST *         mprogs;
    MOB_INDEX_DATA *	next;
    MOB_INDEX_DATA *    in_room;
    SPEC_FUN *		spec_fun;
    SHOP_DATA *		pShop;
    sh_int		vnum;
    sh_int		group;
    bool		new_format;
    sh_int		count;
    sh_int		killed;
    char *		player_name;
    char *		short_descr;
    char *		long_descr;
    char *		description;
    long		act;
    long		affected_by;
    sh_int		alignment;
    sh_int		level;
    sh_int		hitroll;
    long		hit[3];
    long		mana[3];
    sh_int		damage[3];
    sh_int		ac[4];
    sh_int              cast_level;
    sh_int              cast_ability;
    sh_int              kills;
    long		off_flags;
	int			resist[MAX_RES];
    sh_int		start_pos;
    sh_int		default_pos;
    sh_int		sex;
    sh_int		race;
    long		wealth;
    long		form;
    long		parts;
    sh_int		size;
    char *		material;
    long                mprog_flags;
    long                affected2_by;
    int                 xp_tolevel;
	int			dam_type;
};



/* memory settings */
#define MEM_CUSTOMER	A	
#define MEM_SELLER	B
#define MEM_HOSTILE	C
#define MEM_AFRAID	D

/* memory for mobs */
struct mem_data
{
    MEM_DATA 	*next;
    bool	valid;
    int		id; 	
    int 	reaction;
    time_t 	when;
};
   

#include "board.h"
#include "buffer.h"


/*
 * One character (PC or NPC).
 */
struct	char_data
{
    CHAR_DATA *		next;
    CHAR_DATA *		next_in_room;
    CHAR_DATA *		master;
    CHAR_DATA *		leader;
    CHAR_DATA *		fighting;
    CHAR_DATA *		reply;
    CHAR_DATA *		pet;
	CHAR_DATA *		next_in_ocean;
	CHAR_DATA *		next_in_building;
    CHAR_DATA *         mprog_target;
    MEM_DATA *		memory;
    SPEC_FUN *		spec_fun;
    MOB_INDEX_DATA *	pIndexData;
    DESCRIPTOR_DATA *	desc;
    AFFECT_DATA *	affected;
/*    NOTE_DATA *		pnote; */
    OBJ_DATA *		carrying;
    OBJ_DATA *		on;
    ROOM_INDEX_DATA *	in_room;
    ROOM_INDEX_DATA *	was_in_room;
    AREA_DATA *		zone;
    PC_DATA *		pcdata;
    GEN_DATA *		gen_data;
	int			mineral [MAX_MINERALS];
    bool		valid;
    char *		name;
    long		id;
    sh_int		version;
    char *		short_descr;
    char *		long_descr;
    char *		description;
    char *		prompt;
    char *		prefix;
    sh_int		group;
    sh_int		clan;
    sh_int              rank;
    sh_int		sex;
    sh_int              stance;
    sh_int              stance_ac_bonus;
    sh_int              stance_hit_bonus;    
    sh_int              clss;
    sh_int		race;
    sh_int		level;
    sh_int		trust;
    int			played;
    int			lines;  /* for the pager */
    int                 subtype;
    int                 gpoint;
    time_t		logon;
    time_t              llogoff;
    sh_int		timer;
    sh_int		wait;
    sh_int		daze;
    long		hit;
    long  	        max_hit;
    long		mana;
    long		max_mana;
    long		move;
    long		max_move;
    long		gold;
    long		silver;
    int			exp;
    long		act;
    long		comm;   /* RT added to pad the vector */
    long                comm2;
    long		wiznet; /* wiz stuff */
    long		imm_flags;
    sh_int		invis_level;
    sh_int		incog_level;
    sh_int		position;
    sh_int		practice;
    sh_int		train;
    sh_int		carry_weight;
    sh_int		carry_number;
    sh_int		saving_throw;
    sh_int		alignment;
    sh_int		hitroll;
    sh_int		damroll;
    sh_int		armor[4];
    sh_int		wimpy;
    /* stats */
    sh_int		perm_stat[MAX_STATS];
    sh_int		mod_stat[MAX_STATS];
    /* parts stuff */
    long		form;
    long		parts;
    sh_int		size;
    char*		material;
    /* mobile stuff */
    long		off_flags;
    sh_int		damage[3];
    sh_int		start_pos;
    sh_int		default_pos;
    CHAR_DATA *		mount;
    bool		riding;    
    sh_int              hometown;
    sh_int              mprog_delay;
    /* cloak stuff */
    long		cloak;
    long		mask;
    int                 bp_points;
    int                 xp_tolevel;
    //Lycanthropy
    int 		bites;
    int 		bloodthirst;
    bool 		isvamp;
    bool		iswere;
    int			wereform;
    bool		turned;
    sh_int              wpoint[MAX_WAYPOINT];
    int                 fquit;
    int                 levelflux;
    char *              powner;
	LANGUAGE *			lang;
	EVENT_DATA		*	event_list;
	EVENT_DATA		*	event_last;
	int					complete;
	int					resist[MAX_RES];
	int					affected_by;
	int					affected_by2;
	int					dam_type;
    OCEAN_DATA  *	in_ocean;
	BUILDING	*	in_building;
    int 		cordinate[3];
	//Methods
	void to_building( BUILDING *pBld, int x, int y, int z );
	void move_building( int x, int y, int z, int door );
	bool is_building( );
	void building_map(BUILDING *build = NULL );
};

#define CHOSE_RACE 0
#define CHOSE_CLASS 1
#define CHOSE_GENDER 2
#define CHOSE_HOMETOWN 3
#define CHOSE_GOD 4
#define CHOSE_SHORT 5
#define CHOSE_ATTRIBUTES 6
#define MAX_CBOOL 7

/*
 * Data which only PC's have.
 */
struct	pc_data
{
    int 		security;	/* OLC */ /* Builder security */
    PC_DATA *		next;
    BUFFER * 		buffer;
    COLOUR_DATA *	code;		/* Data for coloUr configuration	*/
    NICK_DATA 	*	nick_first;
    MINE_DATA   *    	in_mine;
    SHAFT_DATA  *	in_shaft;
    RELIGION	*	religion;
	RELIGION	*	devoted;   //Just for devoting. Easier than a array of booleans, or a string.
	sh_int		rank;
    bool		valid;
    char *		pwd;
    char *		bamfin;
    char *		bamfout;
    char *		title;
    char *		title2;
    char *              host;
    long		perm_hit;
    long		perm_mana;
    long		perm_move;
    sh_int		true_sex;
    int                 weight;
    int                 height;
    int                 hair;
    int                 eye;
    sh_int              track_count;
    sh_int              nextquest;
    sh_int              countdown;
    int                 rentroom;
    sh_int              questpoints;
    sh_int              qps;
    sh_int              totaltpoints;
    CHAR_DATA *         tracking;
    int			last_level;
    long		current_exp;
    sh_int		condition	[4];
    sh_int		*learned	;
    bool		group_known	[MAX_GROUP];
    sh_int		points;
    bool              	confirm_delete;
    char *		alias[MAX_ALIAS];
    char * 		alias_sub[MAX_ALIAS];
    bool                confirm_remort;
    bool                stay_race;
    long		gold_bank;
    long		silver_bank;
    sh_int		shares;
    sh_int		share_level;
    sh_int     		shares_bought;
    sh_int		duration;
    int                 kills_mob;
    int                 kills_pc;
    int                 deaths_mob;
    int                 deaths_pc;
    BOARD_DATA *        board;
    time_t              last_note[MAX_BOARD]; 
    NOTE_DATA *         in_progress;
    int		idle_time;
    /*
     * Colour data stuff for config.
     */
    int			text[3];		/* {t */
    int			auction[3];		/*  */
    int			auction_text[3];	/*  */
    int			gossip[3];		/*  */
    int			gossip_text[3];		/*  */
    int			music[3];		/*  */
    int			music_text[3];		/*  */
    int			question[3];		/*  */
    int			question_text[3];	/*  */
    int			answer[3];		/*  */
    int			answer_text[3];		/*  */
    int			quote[3];		/*  */
    int			quote_text[3];		/*  */
    int			immtalk_text[3];	/*  */
    int			immtalk_type[3];	/*  */
    int			info[3];		/*  */
    int			say[3];			/*  */
    int			say_text[3];		/*  */
    int			tell[3];		/*  */
    int			tell_text[3];		/*  */
    int			reply[3];		/*  */
    int			reply_text[3];		/*  */
    int			gtell_text[3];		/*  */
    int			gtell_type[3];		/*  */
    int			wiznet[3];		/*  */
    int			room_title[3];		/*  */
    int			room_text[3];		/*  */
    int			room_exits[3];		/*  */
    int			room_things[3];		/*  */
    int			prompt[3];		/*  */
    int			fight_death[3];		/*  */
    int			fight_yhit[3];		/*  */
    int			fight_ohit[3];		/*  */
    int			fight_thit[3];		/*  */
    int			fight_skill[3];		/*  */
    sh_int              timeout;  
    OBJ_DATA *          box;
    bool                boxrented;
    sh_int              item_box;
    char *              immtitle;
    //Creation boolines
    bool		creation[MAX_CBOOL];
    char *		email;
    long                gamestat[MAX_GAMESTAT];
    //Mine locations
    int 		cordinate[3];
    //Idle thingy.
    long		last_typed;
    char    *		pretitle;
    sh_int              dblq;
    //Stuff for religion;
    int			bless;
    int                 suppress;
    int                 h_vnum;
    int                 hinvite;
    sh_int              horesets;
    sh_int              hmresets;
    bool                hchange;        
    char                *afk;
    sh_int              bcount;
    int                 mailid;
	int					positions[MAX_POS];
	int					nature[MAX_CRYSTAL];
	char		**		awarded;
	int					maxAward;
#ifdef IMC
    IMC_CHARDATA *imcchardata;
#endif
};

#define CORD_X 	0
#define CORD_Y  1
#define CORD_Z  2


/* Data for generating characters -- only used during generation */
struct gen_data
{
    GEN_DATA	*next;
    bool	valid;
    bool	*skill_chosen;
    bool	group_chosen[MAX_GROUP];
    int		points_chosen;
};



/*
 * Liquids.
 */
#define LIQ_WATER        0

struct	liq_type
{
    char *	liq_name;
    char *	liq_color;
    sh_int	liq_affect[5];
};



/*
 * Extra description data for a room or object.
 */
struct	extra_descr_data
{
    EXTRA_DESCR_DATA *next;	/* Next in list                     */
    bool valid;
    char *keyword;              /* Keyword in look/examine          */
    char *description;          /* What to see                      */
};



/*
 * Prototype for an object.
 */
struct	obj_index_data
{
    AREA_DATA *		area;	/* OLC */
    OBJ_INDEX_DATA *	next;
    EXTRA_DESCR_DATA *	extra_descr;
    AFFECT_DATA *	affected;
    bool		new_format;
    char *		name;
    char *		short_descr;
    char *		description;
    sh_int		vnum;
    sh_int		reset_num;
    int 		material;
    int			extra_flags;
    int                 extra2_flags;
    int			wear_flags;
    sh_int		level;
    sh_int 		condition;
    sh_int		count;
    sh_int		weight;
    sh_int              size;
    int			cost;
    PROG_LIST *		oprogs;
    long		oprog_flags;
    sh_int              plevel;
    int                 xp_tolevel;
    int                 exp;
	USE			*	use_list;
};

#define BTYPE_MAX 4
#define ATYPE_MAX 4

/*
 * One object.
 */
struct	obj_data
{
    OBJ_DATA *		next;
    OBJ_DATA *		next_content;
    OBJ_DATA *		contains;
    OBJ_DATA *		in_obj;
    OBJ_DATA *		on;
	OBJ_DATA *		holding;
    CHAR_DATA *		carried_by;
    CHAR_DATA *	oprog_target;
    EXTRA_DESCR_DATA *	extra_descr;
    AFFECT_DATA *	affected;
    OBJ_INDEX_DATA *	pIndexData;
    ROOM_INDEX_DATA *	in_room;
	EVENT_DATA		*	event_list;
	EVENT_DATA		*	event_last;
    bool		valid;
    bool		enchanted;
    char *	        owner;
    char *		name;
    char *		short_descr;
    char *		description;
    int			extra_flags;
    int                 extra2_flags;
    int			wear_flags;
    sh_int		wear_loc;
    sh_int		weight;
    int			cost;
    sh_int		level;
    sh_int 		condition;
    int			material;
    sh_int		timer;
    sh_int		oprog_delay;
    sh_int              size;
    int			belted_vnum;	// Vnum of the object this item is belted to.
    OBJ_DATA 		*sheathed_in;   // Vnum of the object that is sheathed.
    SHAFT_DATA	* 	in_shaft;
    int			strap_loc;    //Strap location.
    bool		part;
    int                 exp;
    sh_int              plevel;
    int                 xp_tolevel;
	int			temp;
	int			complete;
	USE		*	use_list;
	OBJ_DATA	*embedded;
};

#define MAX_VALUE 5
struct use_data
{	USE * next;
	int use_type;
	char * use_string;
	int value[MAX_VALUE];
	int	valueorig[MAX_VALUE];
};
#define UTYPE_AXE			0		//For chopping trees
#define UTYPE_TONG			1		//To hold things while in a hearth
#define UTYPE_POT			2		//To hold liquid in a hearth
#define UTYPE_ANVIL			3		//To hammer stuff on
#define UTYPE_HAMMER		4		//To hammer stuff with
#define UTYPE_BLADE			5		//A blade
#define UTYPE_BALL			6		//A ball
#define UTYPE_HHEAD			7		//A hammer head
#define UTYPE_HILT			8		//A hilt
#define UTYPE_POLE			9		//A pole.
#define UTYPE_AHEAD			10		//An axe head		
#define UTYPE_LIGHT		    11		//To make it a light
#define UTYPE_SCROLL		12		//A scroll
#define UTYPE_WEAPON		13		//A weapon
#define UTYPE_TREASURE		14		//A treasure
#define UTYPE_ARMOR		    15
#define UTYPE_POTION		16
#define UTYPE_CLOTHING		17
#define UTYPE_FURNITURE		18
#define UTYPE_TRASH		    19
#define UTYPE_CONTAINER		20
#define UTYPE_DRINK_CON		21
#define UTYPE_KEY		    22
#define UTYPE_FOOD		    23
#define UTYPE_MONEY		    24
#define UTYPE_BOAT		    25
#define UTYPE_CORPSE_NPC	26
#define UTYPE_CORPSE_PC		27
#define UTYPE_FOUNTAIN		28
#define UTYPE_PILL		    29
#define UTYPE_PROTECT		30
#define UTYPE_MAP		    31
#define UTYPE_PORTAL		32
#define UTYPE_WARP_STONE	33
#define UTYPE_ROOM_KEY		34
#define UTYPE_GEM		    35
#define UTYPE_JEWELRY		36
#define UTYPE_JUKEBOX		37
#define UTYPE_TOKEN         38
#define UTYPE_SOURCE        39
#define UTYPE_INSTRUMENT    40
#define UTYPE_SOCKET        41
#define UTYPE_QUIVER        42
#define UTYPE_ARROW	        43
#define UTYPE_BELT		    44
#define UTYPE_SHEATH		45
#define UTYPE_SKELETON      46
#define UTYPE_ORE		    47
#define UTYPE_LUMBER		48
#define UTYPE_HEARTH		49
#define UTYPE_FURNACE		50
#define UTYPE_CRYSTAL		51

/*
 * Exit data.
 */
struct	exit_data
{
    EXIT_DATA *		next;		/* OLC */
    char			*name;
	int				to;
	int			rs_flags;	/* OLC */
    int			orig_door;	/* OLC */
    MINE_DATA *		mine;
    SHAFT_DATA  *       to_shaft;
    int 		cord[3];
    union
    {	ROOM_INDEX_DATA *	to_room;
		sh_int			vnum;
    } u1;
    sh_int		exit_info;
    sh_int		key;
    char *		keyword;
    char *		description;
};



/*
 * Reset commands:
 *   '*': comment
 *   'M': read a mobile 
 *   'O': read an object
 *   'P': put object in object
 *   'G': give object to mobile
 *   'E': equip object to mobile
 *   'D': set state of door
 *   'R': randomize room exits
 *   'S': stop (end of list)
 */

/*
 * Area-reset definition.
 */
struct	reset_data
{
    RESET_DATA *	next;
    RESET_DATA *	prev;
    char		command;
    sh_int		arg1;
    sh_int		arg2;
    sh_int		arg3;
    sh_int		arg4;
};


/* New area_data for OLC */
struct	area_data
{
    AREA_DATA *		next;		/*
    AREA_DATA *		next_on_cont;
    RESET_DATA *	reset_first;     *  Removed for OLC reset system.
    RESET_DATA *	reset_last;	 */
    char *		name;
    char *		credits;
    int 		age;
    int 		nplayer;
    bool                empty;          /* ROM OLC */
    char *		file_name;	/* OLC */
    char *		builders;	/* OLC */ /* Listing of */
    char *		repop_msg;
    int			security;	/* OLC */ /* Value 1-9  */
    sh_int              min_vnum;
    sh_int              max_vnum;
    int			vnum;		/* OLC */ /* Area vnum  */
    int			area_flags;	/* OLC */
    int			continent;
    int			min_lev;
    int			max_lev;
    int                 min_temp;
    int                 max_temp;
    int                 temperature;
};

/*
 * Room type.
 */
void free_exit(EXIT_DATA *);
class ExitList
{	public:
	std::list<exit_data *> exits;
	EXIT_DATA * operator[](int door)
	{	std::list<EXIT_DATA *>::iterator i;
		if(exits.size() == 0)
			return NULL;
		for( i = exits.begin(); i != exits.end() ; i++ )
		{	if((*i)->to == door )
				return *i;
		}
		return NULL;
	}
	void Add(EXIT_DATA *pEx)
	{	exits.push_back(pEx);
		return;
	}
	void Remove(int door)
	{	if((*this)[door] != NULL)
		{	EXIT_DATA *pEx;
			pEx = (*this)[door];
			exits.remove(pEx);
			free_exit(pEx);
		}
		return;
	}

	void Remove(EXIT_DATA *pEx)
	{	exits.remove(pEx);
		free_exit(pEx);
		return;
	}
	void FixExits( BUILDING *);
};

#define MAX_MINE_X   25
#define MAX_MINE_Y   25
#define MAX_MINE_Z   5

struct mine_type
{   
    MINE_DATA  	*	next;
    char 	*	name;
    SHAFT_DATA  *	shaft_first;  
    SHAFT_DATA  *	shaft_last;
    ROOM_INDEX_DATA *   entrance;
	bool		valid;
    int                 mineral [MAX_MINERALS];
    int			map[MAX_MINE_X][MAX_MINE_Y][MAX_MINE_Z];
};


struct  shaft_type
{
    bool valid;
    SHAFT_DATA 	*	next;
    long 		parts;
    char 	*       desc;
    int 		mineral[MAX_MINERALS];
    int			complete;
	ExitList     * exit;
    int			cord[3];
};

struct	room_index_data
{
    RESET_DATA *	reset_first;	/* OLC */
    RESET_DATA *	reset_last;	/* OLC */
    RESET_DATA *	last_mob_reset;
    RESET_DATA *	last_obj_reset;
    ROOM_INDEX_DATA *	next;
    ROOM_INDEX_DATA *   map_next;
    CHAR_DATA *		people;
    OBJ_DATA *		contents;
    EXTRA_DESCR_DATA *	extra_descr;
    AREA_DATA *		area;
    ExitList	*exit;
    ROOM_INDEX_DATA *   next_track;
    ROOM_INDEX_DATA *   track_came_from;
    int		 	mineral [MAX_MINERALS];
    char *		name;
    char *		description;
    char *		owner;
    sh_int		vnum;
    int			room_flags;
    sh_int		light;
    sh_int		sector_type;
    sh_int		heal_rate;
    sh_int 		mana_rate;
    sh_int		clan; 
    PROG_LIST *		rprogs;
    CHAR_DATA *		rprog_target;
    long		rprog_flags;
    sh_int		rprog_delay;
    AFFECT_DATA         *affected;
    long                affected_by;
    int                 moisture;
	int					temp;
	int					x, y, z;
	//Methods
	void init_exits(int x, int y, int z, BUILDING *pBld);
	void unlink();
};


struct ocean_type
{	OCEAN_DATA *next, *prev;
	ROOM_INDEX_DATA *room;
	CHAR_DATA * people;
	int x, y, z;
	bool isvirtual, wild;
	int sector_type;
	//Methods
	OCEAN_DATA operator=(ROOM_INDEX_DATA *pR)
	{	static OCEAN_DATA pO;
		pO.isvirtual = false;
		pO.wild = false;
		pO.sector_type = pR->sector_type;
		pO.x = pO.y = pO.z = -1;
		pO.room = pR;
		return pO;
	} 
};

// Mineral Types
#define MIN_STEEL		0
#define MIN_IRON		1
#define MIN_COPPER		2
#define MIN_ADAMANTIUM		3
#define MIN_PLATINUM		4
#define MIN_BRONZE		5
#define MIN_SILVER		6
#define MIN_MARBLE		7
#define MIN_BRASS		8
#define MIN_GRANITE		9
#define MIN_ELECTRUM		10

/*
 *  Target types.
 */
#define TAR_IGNORE		    0
#define TAR_CHAR_OFFENSIVE	    1
#define TAR_CHAR_DEFENSIVE	    2
#define TAR_CHAR_SELF		    3
#define TAR_OBJ_INV		    4
#define TAR_OBJ_CHAR_DEF	    5
#define TAR_OBJ_CHAR_OFF	    6

#define TARGET_CHAR		    0
#define TARGET_OBJ		    1
#define TARGET_ROOM		    2
#define TARGET_NONE		    3



/*
 * Skills include spells as a particular case.
 */
struct	skill_type
{
    char *	name;			/* Name of skill		*/
    sh_int *	skill_level;	/* Level needed by class	*/
    sh_int *	rating;	/* How hard it is to learn	*/	
    sh_int	minimum_position;	/* Position for caster / user	*/
    sh_int	beats;			/* Waiting time after use	*/
    char *	noun_damage;		/* Damage message		*/
    char *	msg_off;		/* Wear off message		*/
    char *	msg_obj;		/* Wear off message for obects	*/
};

struct  group_type
{
    char *	name;
    int	 	type;
	char *	spells[MAX_IN_GROUP];
	GROUP_DATA *next;
};


#define TYPE_CLAN		0
#define TYPE_CLASS		1
#define TYPE_RELIGION	2
#define TYPE_RACE		3

/*
 * MOBprog definitions
 */                   
#define TRIG_ACT	(A)
#define TRIG_BRIBE	(B)
#define TRIG_DEATH	(C)
#define TRIG_ENTRY	(D)
#define TRIG_FIGHT	(E)
#define TRIG_GIVE	(F)
#define TRIG_GREET	(G)
#define TRIG_GRALL	(H)
#define TRIG_KILL	(I)
#define TRIG_HPCNT	(J)
#define TRIG_RANDOM	(K)
#define TRIG_SPEECH	(L)
#define TRIG_EXIT	(M)
#define TRIG_EXALL	(N)
#define TRIG_DELAY	(O)
#define TRIG_SURR	(P)
#define TRIG_GET        (Q)
#define TRIG_DROP	(R)
#define TRIG_SIT	(S)
#define TRIG_ALIAS	(T)
#define TRIG_WEAR	(U)
#define TRIG_REMOVE (V)

/*
 * Prog types
 */
#define PRG_MPROG	0
#define PRG_OPROG	1
#define PRG_RPROG	2

struct prog_list
{
    int                 trig_type;
    char *              trig_phrase;
    sh_int              vnum;
    char *              code;
    PROG_LIST *         next;
    bool                valid;
};

struct prog_code
{
    sh_int              vnum;
    char *              code;
    PROG_CODE *         next;
}; 


/*
 * Utility macros.
 */

#define IS_VALID(data)		((data) != NULL && (data)->valid)
#define VALIDATE(data)		((data)->valid = TRUE)
#define INVALIDATE(data)	((data)->valid = FALSE)
#define UMIN(a, b)		((a) < (b) ? (a) : (b))
#define UMAX(a, b)		((a) > (b) ? (a) : (b))
#define URANGE(a, b, c)		((b) < (a) ? (a) : ((b) > (c) ? (c) : (b)))
#define LOWER(c)		((c) >= 'A' && (c) <= 'Z' ? (c)+'a'-'A' : (c))
#define UPPER(c)		((c) >= 'a' && (c) <= 'z' ? (c)+'A'-'a' : (c))
#define IS_SET(flag, bit)	((flag) & (bit))
#define SET_BIT(var, bit)	((var) |= (bit))
#define REMOVE_BIT(var, bit)	((var) &= ~(bit))
#define CH(descriptor)  ((descriptor)->original ? \
(descriptor)->original : (descriptor)->character)     


/*
 * Character macros.
 */
#define IN_FACTION(ch)			( (ch)->pcdata->religion->isfaction )
#define HAS_RELIGION(ch)		( (ch)->pcdata->religion )
#define IS_SAME_RELIGION(ch, vct)	( (ch)->pcdata->religion == (vct)->pcdata->religion )
#define OBJ_IN_MINE(obj)		((obj)->in_shaft)
#define OBJ_SAME_SHAFT(ch, obj) 	 ( (ch)->pcdata->in_shaft == (obj)->in_shaft ) 
#define IS_SAME_SHAFT(ch, victim)        ( (ch)->pcdata->in_shaft == (victim)->pcdata->in_shaft )
#define IN_MINE(ch)        ( (ch)->pcdata->in_mine )
#define IS_WEREWOLF(ch)    ( (ch)->iswere && (ch)->wereform == MOON_FULL )
#define IS_VAMPIRE(ch)     ( (ch)->isvamp == TRUE )
#define IS_NPC(ch)		(IS_SET((ch)->act, ACT_IS_NPC))
#define IS_IMP(ch)	        (get_trust(ch) == MAX_LEVEL)
#define IS_IMMORTAL(ch)		(get_trust(ch) >= LEVEL_IMMORTAL)
#define IS_HERO(ch)		(get_trust(ch) >= LEVEL_HERO)
#define IS_TRUSTED(ch,level)	(get_trust((ch)) >= (level))
#define IS_AFFECTED(ch, sn)	(IS_SET((ch)->affected_by, (sn)))
#define IS_AFFECTED2(ch, sn)    (IS_SET((ch)->affected2_by, (sn)))
#define GET_AGE(ch)		((int) (17 + ((ch)->played \
				    + current_time - (ch)->logon )/72000))
#define IS_GOOD(ch)		(ch->alignment >= 350)
#define IS_EVIL(ch)		(ch->alignment <= -350)
#define IS_NEUTRAL(ch)		(!IS_GOOD(ch) && !IS_EVIL(ch))
#define IS_AWAKE(ch)		(ch->position > POS_SLEEPING)
#define GET_AC(ch,type)        ((ch)->armor[type])  
#define GET_HITROLL(ch)    \
        ((ch)->hitroll+str_app[get_curr_stat(ch,STAT_STR)].tohit + ch->stance_hit_bonus )
#define GET_DAMROLL(ch) \
		((ch)->damroll+str_app[get_curr_stat(ch,STAT_STR)].todam )
#define IS_OUTSIDE(ch)		(!IS_SET(				    \
				    (ch)->in_room->room_flags,		    \
				    ROOM_INDOORS))
#define WAIT_STATE(ch, npulse)	((ch)->wait = UMAX((ch)->wait, (npulse)))
#define DAZE_STATE(ch, npulse)  ((ch)->daze = UMAX((ch)->daze, (npulse)))
#define get_carry_weight(ch)	((ch)->carry_weight + (ch)->silver/10 +  \
						      (ch)->gold * 2 / 5)
#define MOUNTED(ch) \
		((!IS_NPC(ch) && ch->mount && ch->riding) ? ch->mount : NULL)
#define RIDDEN(ch) \
		((IS_NPC(ch) && ch->mount && ch->riding) ? ch->mount : NULL)
#define IS_DRUNK(ch)		((ch->pcdata->condition[COND_DRUNK] > 10))
#define act(format,ch,arg1,arg2,type)\
	act_new((format),(ch),(arg1),(arg2),(type),POS_RESTING)
#define HAS_TRIGGER_MOB(ch,trig) (IS_SET((ch)->pIndexData->mprog_flags,(trig)))
#define HAS_TRIGGER_OBJ(obj,trig) (IS_SET((obj)->pIndexData->oprog_flags,(trig)))
#define HAS_TRIGGER_ROOM(room,trig) (IS_SET((room)->rprog_flags,(trig)))
#define IS_SWITCHED( ch )       ( ch->desc && ch->desc->original )
#define IS_BUILDER(ch, Area)	( !IS_NPC(ch) && !IS_SWITCHED( ch ) &&	  \
				( ch->pcdata->security >= Area->security  \
				|| strstr( Area->builders, ch->name )	  \
				|| strstr( Area->builders, "All" ) ) )
#define GET_NAME(Ch)    (IS_NPC(Ch) ? (Ch)->short_descr : (Ch)->name)
#define IS_IN_WAR(ch)   (!IS_NPC(ch) && IS_SET((ch)->act, PLR_WAR) \
                         && IS_SET((ch)->in_room->room_flags, ROOM_ARENA))     
#define HAS_HOME(ch)    (!IS_NPC(ch) && ch->pcdata->h_vnum != 0 )
#define IS_HOME(ch)     ( ( ch->pcdata->h_vnum != 0 && (ch->in_room->vnum >= ch->pcdata->h_vnum) && (ch->in_room->vnum < ch->pcdata->h_vnum + 5 ) ) )                  
#define HAS_SPOS(ch, pos) ( ch->pcdata->positions[POS_IMP] ? ch->pcdata->positions[POS_IMP] : ch->pcdata->positions[pos] )
#define IN_ROOM(ch)   ( ch->in_ocean ? ch->in_ocean->room : ch->in_room )
#define IN_ROOM_LIST(ch) ( ch->in_ocean ?  ch->in_ocean->people : ch->in_room->people )
#define NEXT_IN_ROOM(ch) (  ch->next_in_ocean  )
#define IS_VIRTUAL(oc) ( (oc) ? (oc)->isvirtual : FALSE )
#define BUILDING_FOR(building) \
for( int z = 0; z <= (building)->max_levels ; z++ )	\
	for( int y = 0; y <= (building)->interior[1] ; y++ ) \
		for( int x = 0; x <= (building)->interior[0] ; x++ ) \
		{
/*
 * Object macros.
 */
#define IS_OBJ_STAT(obj, stat)	(IS_SET((obj)->extra_flags, (stat)))
#define IS_OBJ2_STAT(obj, stat)  (IS_SET((obj)->extra2_flags, (stat))) 
#define IS_WEAPON_STAT(obj,stat)(IS_SET((obj)->value[4],(stat)))
#define WEIGHT_MULT(use)	(use->use_type == UTYPE_CONTAINER ? \
	use->value[4] : 100)

#define HAS_EVENT(ch)   ( (ch)->event_list )

/*
 * Description macros.
 */

/*
 * Olc macros.
 */
#define IS_NULLSTR(str)		((str) == NULL || (str)[0] == '\0')
#define ENTRE(min,num,max)	( ((min) < (num)) && ((num) < (max)) )
#define CHECK_POS(a, b, c)      {                                       \
                                (a) = (b);                              \
                                if ( (a) < 0 )                          \
                                bug( "CHECK_POS : " c " == %d < 0", a );\
                                }                                           
#define EDIT_GUILD(Ch, Clan)    ( Clan = (CLAN_DATA *) Ch->desc->pEdit )

#define SREAD(sPtr)					  \
{                                     \
    char *sValue = fread_string(fp);  \
	free_string(sPtr);				  \
	sPtr = sValue;           \
}

#define DLINK(node, first)		\
			node->next = first;  \
			node->prev = NULL;   \
			if(node->next)      \
				node->next->prev = node;   \
			first = node;
#define DELINK(node, first)    \
			if(node->next) node->next->prev = node->prev;	\
			if(node->prev) node->prev->next = node->next;	\
			if(node == first) first = node->next;			
/*
 * Structure for a social in the socials table.
 */
struct	social_type
{
    char *     name;
    char *    char_no_arg;
    char *    others_no_arg;
    char *    char_found;
    char *    others_found;
    char *    vict_found;
    char *    char_not_found;
    char *    char_auto;
    char *    others_auto;
    char *    chan_emote;
};

struct postal_type
{
    int       pcount;
    int       vnum;
};


/*
 * Global constants.
 */

extern	const	struct	str_app_type	str_app		[51];
extern	const	struct	int_app_type	int_app		[51];
extern	const	struct	wis_app_type	wis_app		[51];
extern	const	struct	dex_app_type	dex_app		[51];
extern	const	struct	con_app_type	con_app		[51];

extern		struct	class_type	*class_table;
extern	const	struct	weapon_type	weapon_table	[];
extern	const	struct	wiznet_type	wiznet_table	[];
extern	const	struct	attack_type	attack_table	[];
extern  struct  race_type	*race_table;
extern	struct	pc_race_type	*pc_race_table;
extern  const	struct	spec_type	spec_table	[];
extern	const	struct	liq_type	liq_table	[];
extern		struct	skill_type	*skill_table;
extern		struct	material_type	*material_table;

extern  const   struct  eye_type        eye_table       [];
extern  const   struct  hair_type       hair_table      [];
extern  const   struct  height_type     height_table    [];
extern  const   struct  weight_type     weight_table    [];
extern          struct  social_type     *social_table;  
extern          struct  postal_type     *postal_table;
extern	const	struct	hometown_type	hometown_table	[];
extern  const   char    *osize_table                    [];
extern  const   char    *cond_table                     [];
extern  struct  unique_attrib_table     unique_table_weapon_suffix[];
extern  struct  unique_attrib_table     unique_table_armor_suffix[];
extern  const   char    *admin_table                    [];
extern	const	char	*stat_table[MAX_STATS];
extern  const   struct  smith_type      smith_table     [];
extern  const   struct  wind_description wind_table     [MAX_WIND];
extern  const   struct  breeze_description breeze_table [MAX_BREEZE];
extern  const   struct  rain_type rain_table     [MAX_RAIN];
extern  const   struct  hailstorm_description hailstorm_table [MAX_HAILSTORM];
extern  const   struct  cloud_type cloud_table   [MAX_CLOUD];
extern  const   struct  cloudy_description cloudy_table [MAX_CLOUDY];
extern  const   struct  lightning_description lightning_table [MAX_LIGHTNING];
extern  const   struct  thunderstorm_description thunderstorm_table [MAX_THUNDERSTORM];
extern  const   struct  foggy_description foggy_table [MAX_FOGGY];
extern  const   struct  blizzard_description blizzard_table [MAX_BLIZZARD];
extern  const   struct  snow_description snow_table [MAX_SNOW];
extern  const   struct  icestorm_description icestorm_table [MAX_ICESTORM];
extern  const   struct  gamble_item gamble_table [MAX_ITEM];   
extern  const   struct  house_item house_table []; 
extern  const   struct  weather_type weather_table [MAX_WEATHER];
extern  const   struct  summoner_data summoner_table [];
extern	const	struct	olc_ed_type olc_ed_table[];
extern	const	struct	var_type varfun_table[];
/*
 * Global variables.
 */
extern 		int			first_boot_time;
extern 		int			last_crash_time;

extern		RELIGION	  *     religion_list;
extern		HELP_DATA	  *	help_first;
extern		SHOP_DATA	  *	shop_first;
extern		GROUP_DATA	  * group_list;
extern		CHAR_DATA	  *	char_list;
extern		DESCRIPTOR_DATA   *	descriptor_list;
extern		OBJ_DATA	  *	object_list;
extern		LANGUAGE	  * language_list;
extern          BOUNTY_DATA       *     bounty_list;
extern          PET_DATA          *     pet_list;
extern          PROG_CODE         *     mprog_list;
extern          PROG_CODE         *     rprog_list;
extern          PROG_CODE         *     oprog_list;
extern		HOUSE_DATA	  *	house_list;;
extern          MAIL_DATA         *     mail_list;

extern		char			bug_buf		[];
extern		time_t			current_time;
extern		bool			fLogAll;
extern		FILE *			fpReserve;
extern		KILL_DATA		kill_table	[];
extern		char			log_buf		[];
extern		TIME_INFO_DATA		time_info;
extern		WEATHER_DATA		weather_info;
extern          NOTE_DATA         *     note_free;
extern          OBJ_DATA          *     obj_free;
extern          bool                    double_exp;
extern          int                     global_exp;
extern          bool                    MOBtrigger;
extern          WAR_DATA                war_info;  
extern          sh_int                  count_connections;
extern          sh_int                  max_unique;
extern          bool                    unique_set;
extern          sh_int                  display;
extern          int                     port, control;
extern          bool                    isignal;
extern			int		**				restrict;

/*
 * OS-dependent declarations.
 * These are all very standard library functions,
 *   but some systems have incomplete or non-ansi header files.
 */
#if	defined(_AIX)
char *	crypt		args( ( const char *key, const char *salt ) );
#endif

#if	defined(apollo)
int	atoi		args( ( const char *string ) );
void *	calloc		args( ( unsigned nelem, size_t size ) );
char *	crypt		args( ( const char *key, const char *salt ) );
#endif

#if	defined(hpux)
char *	crypt		args( ( const char *key, const char *salt ) );
#endif

#if	defined(linux)
char *	crypt		args( ( const char *key, const char *salt ) );
#endif

#if	defined(macintosh)
#define NOCRYPT
#if	defined(unix)
#undef	unix
#endif
#endif

#if	defined(MIPS_OS)
char *	crypt		args( ( const char *key, const char *salt ) );
#endif

#if	defined(MSDOS)
#define NOCRYPT
#if	defined(unix)
#undef	unix
#endif
#endif

#if	defined(NeXT)
char *	crypt		args( ( const char *key, const char *salt ) );
#endif

#if	defined(sequent)
char *	crypt		args( ( const char *key, const char *salt ) );
int	fclose		args( ( FILE *stream ) );
int	fprintf		args( ( FILE *stream, const char *format, ... ) );
int	fread		args( ( void *ptr, int size, int n, FILE *stream ) );
int	fseek		args( ( FILE *stream, long offset, int ptrname ) );
void	perror		args( ( const char *s ) );
int	ungetc		args( ( int c, FILE *stream ) );
#endif

#if	defined(sun)
char *	crypt		args( ( const char *key, const char *salt ) );
int	fclose		args( ( FILE *stream ) );
int	fprintf		args( ( FILE *stream, const char *format, ... ) );
#if	defined(SYSV)
size_t	fread		args( ( void *ptr, size_t size, size_t n, 
			    FILE *stream) );
#elif !defined(__SVR4)
int	fread		args( ( void *ptr, int size, int n, FILE *stream ) );
#endif
int	fseek		args( ( FILE *stream, long offset, int ptrname ) );
void	perror		args( ( const char *s ) );
int	ungetc		args( ( int c, FILE *stream ) );
#endif

#if	defined(ultrix)
char *	crypt		args( ( const char *key, const char *salt ) );
#endif



/*
 * The crypt(3) function is not available on some operating systems.
 * In particular, the U.S. Government prohibits its export from the
 *   United States to foreign countries.
 * Turn on NOCRYPT to keep passwords in plain text.
 */
#if	defined(NOCRYPT)
#define crypt(s1, s2)	(s1)
#endif



/*
 * Data files used by the server.
 *
 * AREA_LIST contains a list of areas to boot.
 * All files are read in completely at bootup.
 * Most output files (bug, idea, typo, shutdown) are append-only.
 *
 * The NULL_FILE is held open so that we have a stream handle in reserve,
 *   so players can go ahead and telnet to all the other descriptors.
 * Then we close it whenever we need to open a file (e.g. a save file).
 */
#if defined(macintosh)
#define PLAYER_DIR	""			/* Player files	*/
#define TEMP_FILE	"romtmp"
#define NULL_FILE	"proto.are"		/* To reserve one stream */
#endif

#if defined(MSDOS)
#define PLAYER_DIR	""			/* Player files */
#define TEMP_FILE	"romtmp"
#define NULL_FILE	"nul"			/* To reserve one stream */
#endif

#if defined(unix)
#define PLAYER_DIR      "../player/"        	/* Player files */
#define GOD_DIR         "../gods/"  		/* list of gods */
#define TEMP_FILE	"../player/romtmp"
#define NULL_FILE	"null.txt"		/* To reserve one stream */
#endif

#define RELG_DIR	"../data/religion/"
#define RELG_LIST	"../data/religion/religion.lst"
#define SKILL_DIR	"../data/skill/"
#define SKILLDAT	"skill.dat"
#define DATA_DIR	"../data/" /*Data dir */
#define AREA_LIST       "area.lst"  /* List of areas*/
#define BUG_FILE        "bugs.txt" /* For 'bug' and bug()*/
#define NEW_SAVE_TEST     "save_test.txt"/*testing new saves*/
#define TYPO_FILE       "typos.txt" /* For 'typo'*/
#define SHUTDOWN_FILE   "shutdown.txt"/* For 'shutdown'*/
#define BAN_FILE	"ban.txt"
#define MUSIC_FILE	"music.txt"
#define BOUNTY_FILE     "bounty.txt"
#define ILLEGAL_NAME_FILE	"illegalnames.txt"

#define WIZ_FILE        "wizlist.txt"
#define DATA_DIR        "../data/"
#define MAX_WHO_FILE    "../data/maxwho.txt"
#define NEW_AREA_DIR    "../new_area/"          /*new area*/
#define VERSION_FILE    "../data/version.txt"
#define COPYOVER_FILE   "copyover.data" /* copyover data */
#define EXE_FILE        "../src/alhaen" /* executable file */
#define STAT_FILE       "../data/statlist.txt"
#define PET_FILE        "../data/pet.txt"
#define BOOT_FILE	"../data/boot.time"
#define HOUSE_FILE      "../data/house.txt"
#define MAIL_FILE       "../data/mail.txt"
#define POSTAL_FILE     "../data/postal.txt"
#define RESTRICT_FILE	"../data/restrict.txt"
#define GROUP_FILE		"../data/group.txt"
#define LANG_LIST		"../data/lang/lang.lst"
#define LANG_DIR 		"../data/lang/"
#define CLASS_DIR		"../data/class/"
#define CLASS_FILE		"class.txt"
#define RACE_DIR		"../data/race/"
#define RACE_FILE		"race.txt"
#define PC_RACE_FILE	"race.pc"
#define MAT_FILE		"../data/material.txt"
/*
 * Our function prototypes.
 * One big lump ... this is every function in Merc.
 */
#define CD	CHAR_DATA
#define MID	MOB_INDEX_DATA
#define OD	OBJ_DATA
#define OID	OBJ_INDEX_DATA
#define RID	ROOM_INDEX_DATA
#define SF	SPEC_FUN
#define AD	AFFECT_DATA
#define PC      PROG_CODE
#define ED	EVENT_DATA
/* act_comm.c */
void  	check_sex	args( ( CHAR_DATA *ch) );
void	add_follower	args( ( CHAR_DATA *ch, CHAR_DATA *master ) );
void	stop_follower	args( ( CHAR_DATA *ch ) );
void 	nuke_pets	args( ( CHAR_DATA *ch ) );
void	die_follower	args( ( CHAR_DATA *ch ) );
bool	is_same_group	args( ( CHAR_DATA *ach, CHAR_DATA *bch ) );
void 	logf2 		args( ( char * fmt, ... ) ); 
void    info(CHAR_DATA * ch, int level, char * message, ...);
bool    can_be_sent     args( ( CHAR_DATA *ch, CHAR_DATA *vch, int channel ) );
void    set_auto_afk    args( ( CHAR_DATA *ch ) );

/* act_enter.c */
RID  *get_random_room   args ( (CHAR_DATA *ch) );

/* act_info.c */
void load_email         args( ( ) );
void save_email         args( ( ) );
void	set_title	args( ( CHAR_DATA *ch, char *title ) );
char * PERS_CHAN	args( ( CHAR_DATA *ch, CHAR_DATA *looker) );
void   display_bp       args( ( CHAR_DATA *ch, CHAR_DATA *victim) );
#define SUP_OO(ch,flag) (!IS_SET((ch)->pcdata->suppress,(flag))?"(ON)":"(OFF)")

/* act_move.c */
void	move_char	args( ( CHAR_DATA *ch, int door, bool follow ) );
bool    weather_move    args( ( CHAR_DATA *ch, ROOM_INDEX_DATA *to_room, EXIT_DATA *pexit ) );
void    weather_check   args( ( CHAR_DATA *ch ) );
void    ice             args( ( CHAR_DATA *ch ) );
void    blizzard        args( ( CHAR_DATA *ch ) );
void    fog             args( ( CHAR_DATA *ch ) );       
#define BITS_PER_INT             32
#define PATH_IS_FLAG(flag, bit)  ((unsigned)flag[bit/BITS_PER_INT]>>bit%BITS_PER_INT&01)
#define PATH_SET_FLAG(flag, bit) (flag[bit/BITS_PER_INT] |= 1 << bit%BITS_PER_INT)
#define PATH_MAX_VNUM 32768
#define PATH_MAX_DIR  6

/* act_obj.c */
bool can_loot		args( (CHAR_DATA *ch, OBJ_DATA *obj) );
void	wear_obj	args( (CHAR_DATA *ch, OBJ_DATA *obj, bool fReplace) );
void    get_obj         args( ( CHAR_DATA *ch, OBJ_DATA *obj,
                            OBJ_DATA *container ) );
bool    wear_obj_size   args( ( CHAR_DATA *ch, OBJ_DATA *obj ) );          
void show_strapped	args( (CHAR_DATA*ch,CHAR_DATA *victim, int location) );
OBJ_DATA *get_obj_sheath args( ( CHAR_DATA *ch, char *argument, OBJ_DATA *sheath ) );

/* act_wiz.c */
void wiznet		args( (char *string, CHAR_DATA *ch, OBJ_DATA *obj,
			       long flag, long flag_skip, int min_level ) );
void copyover_recover   args( (void));
int  const_lookup       args( ( const char *name ) );
			       
/* alias.c */
void 	substitute_alias args( (DESCRIPTOR_DATA *d, char *input) );

/* ban.c */
bool	check_ban	args( ( char *site, int type) );


/* comm.c */
char *	str_str		args( (char *str1, char *str2) );
void	show_string	args( ( struct descriptor_data *d, char *input) );
void	close_socket	args( ( DESCRIPTOR_DATA *dclose ) );
void	write_to_buffer	args( ( DESCRIPTOR_DATA *d, const char *txt,
			    int length ) );
void    send_to_desc    args( ( const char *txt, DESCRIPTOR_DATA *d ) );
void	send_to_char	args( ( const char *txt, CHAR_DATA *ch ) );
void	page_to_char	args( ( const char *txt, CHAR_DATA *ch ) );
void	act		args( ( const char *format, CHAR_DATA *ch,
			    const void *arg1, const void *arg2, int type ) );
void	act_new		args( ( const char *format, CHAR_DATA *ch, 
			    const void *arg1, const void *arg2, int type,
			    int min_pos) );
void	act_chan		args( ( const char *format, CHAR_DATA *ch, 
			    const void *arg1, const void *arg2, int type,
			    int min_pos) );
void    printf_to_char  args( ( CHAR_DATA *ch, char * fmt, ...));  
void	bugf		args( ( char *, ... ) );
void	send_to_desc    args( (const char *txt, DESCRIPTOR_DATA *d));
int 	colourdesc	args( ( char type, CHAR_DATA *ch, char *string ) );
void xact_new           args ( ( const char *format, CHAR_DATA *ch, const void *arg1,
                        const void *arg2, int type, int min_pos, int suppress ) );  
void xsend_to_char      args( (const char *txt, CHAR_DATA *ch, int suppress) );
void send_race_list		args( ( CHAR_DATA *ch) );
void send_class_list	args((CHAR_DATA *ch));
void load_restrict		args(());
void save_restrict		args(());
void send_to_room		args(( ROOM_INDEX_DATA *pRoom, char *fmt, ... ));
void etc				args(( CHAR_DATA *ch, int delay, char *fmt, ... ));


/* File open/close wrappers to handle fpreserve correctly in all cases.
 * Also does some basic error checking. -Chilalin
 */
FILE *  file_open	args( ( const char *path, const char *mode ) );
void	file_close	args( ( FILE *fp ) );
bool	file_exists	args( ( const char *path ) );

/*
 * Colour stuff by Lope
 */
int     colour          args( ( char type, CHAR_DATA *ch, char *string ) );
void   colourconv      args( ( char *buffer, const char *txt, CHAR_DATA *ch ) );
void    send_to_char_bw args( ( const char *txt, CHAR_DATA *ch ) );
void    page_to_char_bw args( ( const char *txt, CHAR_DATA *ch ) );    

//cmdedit.c
void   save_cmd_table   args( ( ) );       
void   load_cmd_list    args( ( ) );

/* db.c */
void load_groups		args(( ));
void save_groups		args(());
void    fix_resets      args( ( void ) );
char *	print_flags	args( ( int flag ));
void	boot_db		args( ( void ) );
void	area_update	args( ( void ) );
CD *	create_mobile	args( ( MOB_INDEX_DATA *pMobIndex ) );
void	clone_mobile	args( ( CHAR_DATA *parent, CHAR_DATA *clone) );
OD *	create_object	args( ( OBJ_INDEX_DATA *pObjIndex, int level ) );
void	clone_object	args( ( OBJ_DATA *parent, OBJ_DATA *clone ) );
void	clear_char	args( ( CHAR_DATA *ch ) );
char *	get_extra_descr	args( ( const char *name, EXTRA_DESCR_DATA *ed ) );
MID *	get_mob_index	args( ( int vnum ) );
OID *	get_obj_index	args( ( int vnum ) );
RID *	get_room_index	args( ( int vnum ) );
PC  *   get_prog_index  args( ( int vnum, int type ) ); 
char	fread_letter	args( ( FILE *fp ) );
int	fread_number	args( ( FILE *fp ) );
long 	fread_flag	args( ( FILE *fp ) );
char *	fread_string	args( ( FILE *fp ) );
char *  fread_string_eol args(( FILE *fp ) );
void	fread_to_eol	args( ( FILE *fp ) );
char *	fread_word	args( ( FILE *fp ) );
long	flag_convert	args( ( char letter) );
void *	alloc_mem	args( ( int sMem ) );
void *	alloc_perm	args( ( int sMem ) );
void	free_mem	args( ( void *pMem, int sMem ) );
char *	str_dup		args( ( const char *str ) );
void	free_string	args( ( char *pstr ) );
int	number_fuzzy	args( ( int number ) );
int	number_range	args( ( int from, int to ) );
int	number_percent	args( ( void ) );
int	number_door	args( ( void ) );
int	number_bits	args( ( int width ) );
long     number_mm       args( ( void ) );
int	dice		args( ( int number, int size ) );
int	interpolate	args( ( int level, int value_00, int value_32 ) );
void	smash_tilde	args( ( char *str ) );
bool	str_cmp		args( ( const char *astr, const char *bstr ) );
bool	str_prefix	args( ( const char *astr, const char *bstr ) );
bool	str_infix	args( ( const char *astr, const char *bstr ) );
bool	str_suffix	args( ( const char *astr, const char *bstr ) );
char *	capitalize	args( ( const char *str ) );
void	append_file	args( ( CHAR_DATA *ch, char *file, char *str ) );
void	bug		args( ( const char *str, int param ) );
void	log_string	args( ( const char *str ) );
void	tail_chain	args( ( void ) );
void 	load_helps_new  args( (  ) );
void    create_unique   args( ( void ) );
void	load_races		args(( void ));
void	load_classes	args(( void ));
void	load_pc_races	args(( void ));
void	fread_material	args(());
void	fwrite_material	args(());

/* effect.c */
void	acid_effect	args( (void *vo, int level, int dam, int target) );
void	cold_effect	args( (void *vo, int level, int dam, int target) );
void	fire_effect	args( (void *vo, int level, int dam, int target) );
void	poison_effect	args( (void *vo, int level, int dam, int target) );
void	shock_effect	args( (void *vo, int level, int dam, int target) );
void    sand_effect     args( (void *vo, int level, int dam, int target) );
/******************************************
 * event.c                                *
 ******************************************/
void		event_update		args(());
void		purge_all_events	args((CHAR_DATA *ch));
void		event_to_char		args((CHAR_DATA *ch, char *string, void *arg, int value, int type, int delay ));
void		execute_char_event	args((CHAR_DATA * ch, EVENT_DATA * event));
void		execute_obj_event	args((OBJ_DATA *pObj, EVENT_DATA *event));
void		event_movement		args((CHAR_DATA *ch ));
ED		*	get_specific_event	args(( CHAR_DATA *ch, int type ));
bool		check_eventcmd		args((CHAR_DATA *ch, char *cmd ));
void		free_event			args((CHAR_DATA *ch, OBJ_DATA *pObj, EVENT_DATA *event ));
ED		*	event_new args(());
void event_to_obj				args((OBJ_DATA *obj, CHAR_DATA *ch, char *string, void *arg, int value, int type, int delay ));
void		purge_obj_event		args((OBJ_DATA *));

/******************************************
 * ed_struct.c                            *
 ******************************************/
int			ed_lookup			args((char *name, const struct save_type *save_table));
void		ed_struct			args((CHAR_DATA *ch, const struct save_type *save_table, char *argument ));

/* fight.c */
bool 	is_safe		args( (CHAR_DATA *ch, CHAR_DATA *victim ) );
bool 	is_safe_spell	args( (CHAR_DATA *ch, CHAR_DATA *victim, bool area ) );
void	violence_update	args( ( void ) );
void	multi_hit	args( ( CHAR_DATA *ch, CHAR_DATA *victim, int dt ) );
bool	damage		args( ( CHAR_DATA *ch, CHAR_DATA *victim, int dam,
			        int dt, int clss, bool show ) );
bool    damage_old      args( ( CHAR_DATA *ch, CHAR_DATA *victim, int dam,
                                int dt, int clss, bool show ) );
void	update_pos	args( ( CHAR_DATA *victim ) );
void	stop_fighting	args( ( CHAR_DATA *ch, bool fBoth ) );
void	check_killer	args( ( CHAR_DATA *ch, CHAR_DATA *victim) );
/* handler.c */
AD  	*affect_find args( (AFFECT_DATA *paf, int sn));
void	affect_check	args( (CHAR_DATA *ch, int where, int vector) );
int	count_users	args( (OBJ_DATA *obj) );
void 	deduct_cost	args( (CHAR_DATA *ch, int cost) );
void	affect_enchant	args( (OBJ_DATA *obj) );
int 	check_immune	args( (CHAR_DATA *ch, int dam_type) );
int	weapon_lookup	args( ( const char *name) );
int	weapon_type	args( ( const char *name) );
char 	*weapon_name	args( ( int weapon_Type) );
char	*item_name	args( ( OBJ_DATA *obj) ); 
int	attack_lookup	args( ( const char *name) );
long	wiznet_lookup	args( ( const char *name) );
int	class_lookup	args( ( const char *name) );
bool	is_old_mob	args ( (CHAR_DATA *ch) );
int	get_skill	args( ( CHAR_DATA *ch, int sn ) );
int	get_weapon_sn	args( ( CHAR_DATA *ch ) );
int	get_weapon_skill args(( CHAR_DATA *ch, int sn ) );
int     get_age         args( ( CHAR_DATA *ch ) );
void	reset_char	args( ( CHAR_DATA *ch )  );
int	get_trust	args( ( CHAR_DATA *ch ) );
int	get_curr_stat	args( ( CHAR_DATA *ch, int stat ) );
int 	get_max_train	args( ( CHAR_DATA *ch, int stat ) );
int	can_carry_n	args( ( CHAR_DATA *ch ) );
int	can_carry_w	args( ( CHAR_DATA *ch ) );
bool	is_name		args( ( char *str, char *namelist ) );
bool    is_full_name    args( ( const char *str, char *namelist ) );
bool	is_exact_name	args( ( char *str, char *namelist ) );
void	affect_to_char	args( ( CHAR_DATA *ch, AFFECT_DATA *paf ) );
void	affect_to_obj	args( ( OBJ_DATA *obj, AFFECT_DATA *paf ) );
void	affect_remove	args( ( CHAR_DATA *ch, AFFECT_DATA *paf ) );
void	affect_remove_obj args( (OBJ_DATA *obj, AFFECT_DATA *paf ) );
void	affect_strip	args( ( CHAR_DATA *ch, int sn ) );
bool	is_affected	args( ( CHAR_DATA *ch, int sn ) );
void	affect_join	args( ( CHAR_DATA *ch, AFFECT_DATA *paf ) );
void	char_from_room	args( ( CHAR_DATA *ch ) );
void	char_to_room	args( ( CHAR_DATA *ch, ROOM_INDEX_DATA *pRoomIndex ) );
void	obj_to_char	args( ( OBJ_DATA *obj, CHAR_DATA *ch ) );
void	obj_from_char	args( ( OBJ_DATA *obj ) );
int	apply_ac	args( ( OBJ_DATA *obj, int iWear, int type ) );
OD *	get_eq_char	args( ( CHAR_DATA *ch, int iWear ) );
void	equip_char	args( ( CHAR_DATA *ch, OBJ_DATA *obj, int iWear ) );
void	unequip_char	args( ( CHAR_DATA *ch, OBJ_DATA *obj ) );
int	count_obj_list	args( ( OBJ_INDEX_DATA *obj, OBJ_DATA *list ) );
void	obj_from_room	args( ( OBJ_DATA *obj ) );
void	obj_to_room	args( ( OBJ_DATA *obj, ROOM_INDEX_DATA *pRoomIndex ) );
void	obj_to_obj	args( ( OBJ_DATA *obj, OBJ_DATA *obj_to ) );
void	obj_from_obj	args( ( OBJ_DATA *obj ) );
void	extract_obj	args( ( OBJ_DATA *obj ) );
void	extract_char	args( ( CHAR_DATA *ch, bool fPull ) );
CD *	get_char_room	args( ( CHAR_DATA *ch, ROOM_INDEX_DATA *room, char *argument ) );
CD *	get_char_world	args( ( CHAR_DATA *ch, char *argument ) );
CD *    get_char_id     args( ( long id ) );     
CD *	get_char_area	args( ( CHAR_DATA *ch, char *argument ) );
OD *	get_obj_type	args( ( OBJ_INDEX_DATA *pObjIndexData ) );
OD *	get_obj_list	args( ( CHAR_DATA *ch, char *argument,
			    OBJ_DATA *list ) );
OD *	get_obj_carry	args( ( CHAR_DATA *ch, char *argument, 
			    CHAR_DATA *viewer ) );
bool CAN_WEAR		args( (OBJ_DATA *obj, int part) );
OD *get_obj_wear	args( ( CHAR_DATA *ch, char *argument, bool character ));
OD *	get_obj_here	args( ( CHAR_DATA *ch, ROOM_INDEX_DATA *room, char *argument ) );
OD *	get_obj_world	args( ( CHAR_DATA *ch, char *argument ) );
OD *	create_money	args( ( int gold, int silver ) );
int	get_obj_number	args( ( OBJ_DATA *obj ) );
int	get_obj_weight	args( ( OBJ_DATA *obj ) );
int	get_true_weight	args( ( OBJ_DATA *obj ) );
bool	room_is_dark	args( ( ROOM_INDEX_DATA *pRoomIndex ) );
bool	is_room_owner	args( ( CHAR_DATA *ch, ROOM_INDEX_DATA *room) );
bool	room_is_private	args( ( ROOM_INDEX_DATA *pRoomIndex ) );
bool	can_see		args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
bool	can_see_obj	args( ( CHAR_DATA *ch, OBJ_DATA *obj ) );
bool	can_see_room	args( ( CHAR_DATA *ch, ROOM_INDEX_DATA *pRoomIndex) );
bool	can_drop_obj	args( ( CHAR_DATA *ch, OBJ_DATA *obj ) );
char *	affect_loc_name	args( ( int location ) );
char *	affect_bit_name	args( ( int vector ) );
char *  affect2_bit_name args( ( int vector ) );
char *	extra_bit_name	args( ( int extra_flags ) );
char *  extra2_bit_name args( ( int extra2_flags ) );
char * 	wear_bit_name	args( ( int wear_flags ) );
char *	act_bit_name	args( ( int act_flags ) );
char *	off_bit_name	args( ( int off_flags ) );
char *  imm_bit_name	args( ( int *imm_flags ) );
char * 	form_bit_name	args( ( int form_flags ) );
char *	part_bit_name	args( ( int part_flags ) );
char *	weapon_bit_name	args( ( int weapon_flags ) );
char *  comm_bit_name	args( ( int comm_flags ) );
char *  comm2_bit_name  args( ( int comm2_flags ) );
char *	cont_bit_name	args( ( int cont_flags) );
void    affect_to_room  args( (ROOM_INDEX_DATA *room, AFFECT_DATA *paf ) );
void	affect_remove_room args((ROOM_INDEX_DATA *room, AFFECT_DATA *paf) );
void	check_spirit	args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
char *  raffect_bit_name args( ( int vector ) ); 
bool check_color_string args( (char *string) );
void    obj_to_box      args( ( OBJ_DATA *obj, CHAR_DATA *ch ) );
void    obj_from_box    args( ( OBJ_DATA *obj ) );        
char *PERS		args( (CHAR_DATA *ch, CHAR_DATA *looker) );
bool has_nick_for_ch	args( (CHAR_DATA *ch, CHAR_DATA *victim) );
bool    is_admin        args( ( CHAR_DATA *ch ) );
void    timeout         args( ( CHAR_DATA *ch ) );
int     levelflux_dam   args( ( CHAR_DATA *ch ) );
MEMBER_DATA *member_lookup args( (CLAN_DATA *pClan, char *name) );
bool    can_pack        args( ( CHAR_DATA *ch ) );
CHAR_DATA *prog_char_room args( ( CHAR_DATA *ch, ROOM_INDEX_DATA *pRoom, char *argument ) );
void    dead_pet        args( ( CHAR_DATA *victim, PET_DATA *pEt ) );
void    revived_pet     args( ( CHAR_DATA *pet, PET_DATA *pEt ) );
char *  suppress_bit_name args( ( int suppress_flags) ); 
void	insert_new_pcrace args((struct race_type *entry, int spot ));
void	snarf_race		args(( struct race_type *new_race ));
void	snarf_pc_race	args(( struct pc_race_type *new_race ));
void	remove_pcrace	args(( int spot ));
void	remove_race		args(( int spot ));
void	realloc_vars	args((int changed));
void	snarf_class		args(( struct class_type *new_class ));
void	free_pcrace		args(( void ));
void	remove_class	args(( int spot ));
bool	has_use			args(( int type, OBJ_INDEX_DATA *pObj));
USE	 *	get_specific_use	args((OBJ_INDEX_DATA *pObj,int type));
int material_lookup			args((const char *name));
USE  *	get_obj_use			args( (OBJ_DATA *pObj, int type));
void	set_char_res		args( ( CHAR_DATA *ch ) );
void handle_virtual_room	args(( CHAR_DATA *ch, int fx, int fy, int fz, int tx, int ty, int tz));

/*
 * Colour Config
 */
void	default_colour	args( ( CHAR_DATA *ch ) );
void	all_colour	args( ( CHAR_DATA *ch, char *argument ) );


/* interp.c */
void	interpret	args( ( CHAR_DATA *ch, char *argument ) );
bool	is_number	args( ( char *arg ) );
int	number_argument	args( ( char *argument, char *arg ) );
int	mult_argument	args( ( char *argument, char *arg) );
char *	one_argument	args( ( char *argument, char *arg_first ) );
void    gen_wiz_table   args( (void) );   

/* Language.c */
int word_count	args((char *string));
WLANG_DATA *get_by_string args((char *string, LANGUAGE *pLng));
LANGUAGE * lang_new	args((void));
void free_wlang args((WLANG_DATA *pWld));
WLANG_DATA *new_wlang args((void));
void free_lang args(( LANGUAGE *pLng ));
LANGUAGE * language_lookup args(( const char *name ));
char *translate	args(( LANGUAGE *pLng, char *string, int skill, int speakSK ));
void load_languages args(( void ));
void load_language  args(( FILE *fp, LANGUAGE *pLng ));
void save_languages args(( void ));
void save_language	args((LANGUAGE *pLng, FILE *fp));

/* magic.c */
int	find_spell	args( ( CHAR_DATA *ch, const char *name) );
int 	mana_cost 	(CHAR_DATA *ch, int min_mana, int level);
int	skill_lookup	args( ( const char *name ) );
int	slot_lookup	args( ( int slot ) );
bool	saves_spell	args( ( int level, CHAR_DATA *victim, int dam_type ) );
void	obj_cast_spell	args( ( int sn, int level, CHAR_DATA *ch,
				    CHAR_DATA *victim, OBJ_DATA *obj ) );
bool can_use_skpell args(( CHAR_DATA * ch, int sn ));
bool is_prime_stat args((CHAR_DATA * ch, int stat));
bool has_spells		args((CHAR_DATA * ch));
int prime_class		args((CHAR_DATA *ch));
int skill_level args((CHAR_DATA * ch, int sn));
int skill_rating args((CHAR_DATA * ch, int sn));
int get_hp_gain args((CHAR_DATA * ch));
int get_mana_gain args((CHAR_DATA * ch));
int get_stat_bonus args((CHAR_DATA * ch, int pStat));
int get_thac00 args((CHAR_DATA * ch));
int get_thac32 args((CHAR_DATA * ch));
int get_hp_max args((CHAR_DATA * ch));
int lvl_bonus args((CHAR_DATA * ch));
bool is_race_skill args((CHAR_DATA * ch, int sn));
int hp_max args((CHAR_DATA *ch));
//skill_save.c
void save_skills_table args( ());
/******************************************
 * olc2.c                                  *
 ******************************************/
void		HandleEditor		args((CHAR_DATA *ch, char *arg ));
void		EditorMenu			args((CHAR_DATA *ch, char *arg ));
void		PrintOLCMenu		args((CHAR_DATA *ch));
int			GetEdByState		args(( int state ));
int			GetEdByArg			args(( char *arg ));
void		PrintLndMrkEdMenu	args((CHAR_DATA *ch));

//Religion.c
void religious_sacrifice args ( (CHAR_DATA *ch, OBJ_DATA *obj ) );
void save_religion  args ( () );
void load_religion  args ( () );
//recycle.c
EMAIL_DATA *  new_email		args ( ( void ) );
BUFFER *new_buf         args( () );
void free_nick		args ( (NICK_DATA *nick) );
NICK_DATA *new_nick	args( (void) );
void nick_to_char	args( ( CHAR_DATA *ch, NICK_DATA *nick ) );
MEMBER_DATA *new_member args( (void) );
void free_member	args( (MEMBER_DATA *member) );
void member_to_guild    args( ( CLAN_DATA *pClan, MEMBER_DATA *pmem ) );
void free_group			args(( GROUP_DATA *pGrp ));
GROUP_DATA *new_group	args(());
USE * new_use			args(());
void free_use			args((USE *pUse));

/* save.c */
void	save_char_obj	args( ( CHAR_DATA *ch ) );
bool	load_char_obj	args( ( DESCRIPTOR_DATA *d, char *name ) );
void	use_to_obj		args( (OBJ_DATA *pObj, USE *use ) );

/* skills.c */
bool 	parse_gen_groups args( ( CHAR_DATA *ch,char *argument ) );
void 	list_group_costs args( ( CHAR_DATA *ch ) );
void    list_group_known args( ( CHAR_DATA *ch ) );
int 	exp_per_level	args( ( CHAR_DATA *ch, int points ) );
void 	check_improve	args( ( CHAR_DATA *ch, int sn, bool success, 
				    int multiplier ) );
void strip_group		args((CHAR_DATA *ch, int type ));
void set_char_groups	args((CHAR_DATA *ch, int type ));
GROUP_DATA * 	group_lookup	args( (const char *name) );
void	gn_add		args( ( CHAR_DATA *ch, int gn) );
void 	gn_remove	args( ( CHAR_DATA *ch, int gn) );
void 	group_add	args( ( CHAR_DATA *ch, const char *name, bool deduct) );
void	group_remove	args( ( CHAR_DATA *ch, const char *name) );
int		exp_to_level	args( ( CHAR_DATA *ch ) );

/******************************************
 * struct_io.c                            *
 ******************************************/
void		load_table			args((const struct save_type *save_table, FILE *fp));
void		save_table			args((const struct save_type *save_table, FILE *fp));

/* special.c */
SF *	spec_lookup	args( ( const char *name ) );
char *	spec_name	args( ( SPEC_FUN *function ) );

/* teleport.c */
RID *	room_by_name	args( ( char *target, int level, bool error) );

/* update.c */
void	advance_level	args( ( CHAR_DATA *ch, bool hide ) );
void	gain_exp	args( ( CHAR_DATA *ch, int gain ) );
void	gain_condition	args( ( CHAR_DATA *ch, int iCond, int value ) );
void	update_handler	args( ( void ) );
void    advance_level_pet args( ( CHAR_DATA *pet, bool hide ) );
void    pet_gain_exp    args( ( CHAR_DATA *pet, int gain ) );
void    gain_object_exp args( ( CHAR_DATA *ch, OBJ_DATA *obj, int gain ) );

/* bounty.c */
bool is_bountied        args( (CHAR_DATA *ch) );
MEM_DATA *get_mem_data args((CHAR_DATA *ch, CHAR_DATA *target));  

#undef	CD
#undef	MID
#undef	OD
#undef	OID
#undef	RID
#undef	SF
#undef AD
#undef ED

/*****************************************************************************
 *                                    OLC                                    *
 *****************************************************************************/
/*
 * This structure is used in bit.c to lookup flags and stats.
 */
struct flag_type
{
    char * name;
    int  bit;
    bool settable;
};

/*
 * Object defined in limbo.are
 * Used in save.c to load objects that don't exist.
 */
#define OBJ_VNUM_DUMMY	1
#define OBJ_VNUM_BLANK  7

/*
 * Area flags.
 */
#define         AREA_NONE       0
#define         AREA_CHANGED    1	/* Area has been modified. */
#define         AREA_ADDED      2	/* Area has been added to. */
#define         AREA_LOADING    4	/* Used for counting in db.c */
#define		AREA_COMPLETE   5
#define         NO_UNIQUE       6

#define MAX_DIR	6
#define NO_FLAG -99	/* Must not be used in flags or stats. */


/*
 * Global Constants
 */
extern	char *	const	dir_name        [];
extern	const	sh_int	rev_dir         [];          /* sh_int - ROM OLC */
extern	const	struct	spec_type	spec_table	[];
extern  char *  const   rev_move        [];
extern char   *build_cmdevent	[];

/*
 * Global variables
 */
extern          AREA_DATA *             area_first;
extern          AREA_DATA *             area_last;
extern  	SHOP_DATA *             shop_last;

extern          int                     top_affect;
extern          int                     top_area;
extern          int                     top_ed;
extern          int                     top_exit;
extern          int                     top_help;
extern          int                     top_mob_index;
extern          int                     top_obj_index;
extern          int                     top_reset;
extern          int                     top_room;
extern          int                     top_shop;
extern          int                     top_vnum_mob;
extern          int                     top_vnum_obj;
extern          int                     top_vnum_room;

extern          char                    str_empty       [1];

extern  MOB_INDEX_DATA *        mob_index_hash  [MAX_KEY_HASH];
extern  OBJ_INDEX_DATA *        obj_index_hash  [MAX_KEY_HASH];
extern  ROOM_INDEX_DATA *       room_index_hash [MAX_KEY_HASH];
extern	OCEAN_DATA *			ocean_hash		[MAX_OCEAN_X][MAX_OCEAN_Z];
extern  AUCTION_DATA *          auction_list;

extern	EVENT_DATA			*event_list;

/* act_wiz.c */
/*
ROOM_INDEX_DATA *find_location( CHAR_DATA *ch, char *arg );
*/
/* db.c */
void	reset_area      args( ( AREA_DATA * pArea ) );
void	reset_room	args( ( ROOM_INDEX_DATA *pRoom ) );

/* string.c */
void	string_edit	args( ( CHAR_DATA *ch, char **pString ) );
void    string_append   args( ( CHAR_DATA *ch, char **pString ) );
char *	string_replace	args( ( char * origstr, char * oldstr, char * newstr ) );
void    string_add      args( ( CHAR_DATA *ch, char *argument ) );
char *  format_string   args( ( char *oldstring /*, bool fSpace */ ) );
char *  first_arg       args( ( char *argument, char *arg_first, bool fCase ) );
char *	string_unpad	args( ( char * argument ) );
char *	string_proper	args( ( char * argument ) );

/* olc.c */
bool	run_olc_editor	args( ( DESCRIPTOR_DATA *d ) );
char	*olc_ed_name	args( ( CHAR_DATA *ch ) );
char	*olc_ed_vnum	args( ( CHAR_DATA *ch ) );
CLAN_DATA *get_clan_data args( ( int clan ) );
int     qksort          args( ( void *data, int size, int esize, int i, int k, int (*compare)
           (const void *key1, const void *key2 ) ) );           
int     get_area_list_size args( ( void ) );
void add_use			args((OBJ_INDEX_DATA *pObj, USE *use, int type, char *string ));

/* olc_save.c */
void    save_guilds     args( ( CHAR_DATA *ch, char *argument ) );
char 	*fwrite_flag	args( ( long flags, char buf[] ) );
char 	*fix_string	args( ( const char *str ) );
void	save_specials	args( ( FILE *fp, AREA_DATA *pArea ) );
void	save_resets		args( ( FILE *fp, AREA_DATA *pArea ) );
void	save_shops		args( ( FILE *fp, AREA_DATA *pArea ) );
void	save_mobprogs	args( ( FILE *fp, AREA_DATA *pArea ) );
void	save_objprogs	args( ( FILE *fp, AREA_DATA *pArea ) );
void	save_roomprogs	args( ( FILE *fp, AREA_DATA *pArea ) );
void	save_help_new	args( () );
void	save_db			args(( void ));

/* special.c */
char *	spec_string	args( ( SPEC_FUN *fun ) );	/* OLC */

/* bit.c */
extern const struct flag_type 	area_flags[];
extern const struct flag_type	sex_flags[];
extern const struct flag_type	exit_flags[];
extern const struct flag_type	door_resets[];
extern const struct flag_type	room_flags[];
extern const struct flag_type	sector_flags[];
extern const struct flag_type	type_flags[];
extern const struct flag_type	extra_flags[];
extern const struct flag_type   extra2_flags[];
extern const struct flag_type	wear_flags[];
extern const struct flag_type	act_flags[];
extern const struct flag_type	affect_flags[];
extern const struct flag_type   affect2_flags[];
extern const struct flag_type	apply_flags[];
extern const struct flag_type	wear_loc_strings[];
extern const struct flag_type	wear_loc_flags[];
extern const struct flag_type	weapon_flags[];
extern const struct flag_type	container_flags[];
extern const struct flag_type	liquid_flags[];

/* ROM OLC: */

extern const struct flag_type   form_flags[];
extern const struct flag_type   part_flags[];
extern const struct flag_type   ac_type[];
extern const struct flag_type   size_flags[];
extern const struct flag_type   off_flags[];
extern const struct flag_type   res_flags[];
extern const struct flag_type   position_flags[];
extern const struct flag_type   weapon_class[];
extern const struct flag_type   weapon_type_olc[];


/*olc_save_new.c*/
void	fwrite_mobiles	args( ( FILE *fp, AREA_DATA *pArea ) );
void	fwrite_rooms	args( ( FILE *fp, AREA_DATA *pArea ) );
void	fwrite_objects	args( ( FILE *fp, AREA_DATA *pArea ) );
void	fwrite_area		args( ( AREA_DATA *pArea ) );
void load_const		args ( () );
void save_use		args(( USE *use, FILE *fp ));

/*olc_load_objs.c*/
void	fread_one_object		args( ( FILE *fp ) );
void	fread_affects		args( ( FILE *fp, OBJ_INDEX_DATA *pObjIndex ) );
void	append_new_save		args( ( char *file, char *str ) );
void	fread_objects			args( ( FILE *fp ) );
void	fread_use			args((OBJ_INDEX_DATA *pOI,  FILE *fp ));

/*olc_load_rooms.c*/
void	fread_one_room		args( ( FILE *fp ) );
void	fread_rooms			args( ( FILE *fp ) );

/*olc_load_rooms.c*/
void	fread_one_mobile		args( ( FILE *fp ) );
void	fread_mobiles			args( ( FILE *fp ) );



/*****************************************************************************
 *                                 OLC END                                   *
 *****************************************************************************/



void spell_check args((CHAR_DATA * ch, char *string));       


#define CAN_ACCESS(room)     ( !IS_SET(room->room_flags, ROOM_PRIVATE) \
                             &&   !IS_SET(room->room_flags, ROOM_SOLITARY) \
                             &&   !IS_SET(room->room_flags, ROOM_NEWBIES_ONLY) \
                             &&   !IS_SET(room->room_flags, ROOM_GODS_ONLY) \
                             &&   !IS_SET(room->room_flags, ROOM_IMP_ONLY) )

int	get_hometown	args( ( char *argument ) );

/* mob_prog.c */
void	program_flow	args( ( sh_int vnum, char *source, CHAR_DATA *mob, 
				OBJ_DATA *obj, ROOM_INDEX_DATA *room,
				CHAR_DATA *ch, const void *arg1,
				const void *arg2 ) );
void	p_act_trigger	args( ( char *argument, CHAR_DATA *mob, 
				OBJ_DATA *obj, ROOM_INDEX_DATA *room,
				CHAR_DATA *ch, const void *arg1,
				const void *arg2, int type ) );
bool	p_percent_trigger args( ( CHAR_DATA *mob, OBJ_DATA *obj,
				ROOM_INDEX_DATA *room, CHAR_DATA *ch, 
				const void *arg1, const void *arg2, int type ) );
void	p_bribe_trigger  args( ( CHAR_DATA *mob, CHAR_DATA *ch, int amount ) );
bool	p_exit_trigger   args( ( CHAR_DATA *ch, int dir, int type ) );
void	p_give_trigger   args( ( CHAR_DATA *mob, OBJ_DATA *obj, 
				ROOM_INDEX_DATA *room, CHAR_DATA *ch,
				OBJ_DATA *dropped, int type ) );
void 	p_greet_trigger  args( ( CHAR_DATA *ch, int type ) );
void	p_hprct_trigger  args( ( CHAR_DATA *mob, CHAR_DATA *ch ) );
bool    p_alias_trigger  args ( ( CHAR_DATA *ch, char *cmd, OBJ_DATA *pObj, int type, char *argument ) );

/* mob_cmds.c */
void	mob_interpret	args( ( CHAR_DATA *ch, char *argument ) );
void	obj_interpret	args( ( OBJ_DATA *obj, char *argument ) );
void    room_interpret	args( ( ROOM_INDEX_DATA *room, char *argument ) );

/* lookup.c */
int	race_lookup	args( ( const char *name) );
int	item_lookup	args( ( const char *name) );
int	liq_lookup	args( ( const char *name) );
OCEAN_DATA *get_ocean_xy(int x, int y, int z);



/* auction.c */
void    reset_auc args ((AUCTION_DATA * auc, bool forced));
int     count_auc args ((CHAR_DATA * ch));
void    auction_update args ((void));
long    advatoi args ((const char *s));
long    parsebet args ((const long currentbet, const char *argument));
AUCTION_DATA *auction_lookup args((sh_int num));
int     get_auc_id args((void));
bool    has_auction args((CHAR_DATA *ch));
void    auction_channel args ( ( CHAR_DATA *ch, char * message ) );

/* wizlist.c */
void	update_wizlist	args( ( CHAR_DATA *ch, int level ) );

/* drunk.c */
char	*makedrunk	args( (char *string, CHAR_DATA *ch) );
void spell_random args( (int sn, int level, CHAR_DATA * ch, void *vo, int target ) );


/* mount.c */
int     mount_success	args( ( CHAR_DATA *ch, CHAR_DATA *mount, int canattack ) );
void	do_buy_mount	args( ( CHAR_DATA *ch, char *argument ) );

//mine.c
SHAFT_DATA *get_shaft_cord	args( (MINE_DATA *pMine, int new_x, int new_y, int new_z ) );
void exit_mine args( ( CHAR_DATA *ch ) );
void put_char_mine args( ( CHAR_DATA *ch, EXIT_DATA *pexit ) );
void move_char_mine args ( (CHAR_DATA *ch, int door ) );
void char_from_mine args ( ( CHAR_DATA *ch ) );
MINE_DATA *new_mine args( (void) );
void free_mine	args( (MINE_DATA *mine) );
SHAFT_DATA *new_shaft args( (void) );
void free_shaft	args( (SHAFT_DATA *shaft) );
void look_mine	args ( ( CHAR_DATA *ch ) );
void fwrite_mine args ( (EXIT_DATA *pExit, FILE *fp ) );
void fread_mine args ( ( ROOM_INDEX_DATA *pRoom, FILE *fp) );
int	check_lumber args((CHAR_DATA *ch ));
void extract_lumber args((CHAR_DATA *ch, int amount ));
void new_entrance	args((ROOM_INDEX_DATA *pRoom, int door, EXIT_DATA *pExit, MINE_DATA *pMine, SHAFT_DATA **pShaft ));
void create_shaft	args(( MINE_DATA *pMine, SHAFT_DATA *pShaft, SHAFT_DATA **nShaft, int door, int new_x, int new_y, int new_z));
void create_link	args((SHAFT_DATA **nShaft, int door, SHAFT_DATA *pShaft ));
OBJ_DATA *create_ore args(( ROOM_INDEX_DATA *pRoom, int mineral ) );


/* channels */
char *get_pre args( (CHAR_DATA *ch, int channel) );
void do_newchan args ( ( CHAR_DATA *ch, char *argument, int channel) );
bool smote_check args ( (CHAR_DATA *ch, char *argument, char *emote, int channel ) );
bool echo_check args ( (CHAR_DATA *ch, char *argument, char *emote, int channel ) );
bool check_chansocial args ( ( CHAR_DATA *ch, char *command, char *argument, int channel ) );
char *get_emote args ( ( CHAR_DATA *ch, char *argument) );
int  social_lookup args ( (const char *name) ); 
int  strlen_color args ( (char *argument) );

/* guild.c */
extern	struct	clan_type	*clan_table;
char *  guild_bit_name  args( ( int guild_flags ) );
bool    is_clan         args( (CHAR_DATA *ch) );
bool    is_same_clan    args( (CHAR_DATA *ch, CHAR_DATA *victim) );
int 	clan_lookup	args( (const char *name) );
char 	*player_rank	args( (CHAR_DATA *ch) );
char	*player_clan	args( (CHAR_DATA *ch) );
bool	can_guild	args( (CHAR_DATA *ch) );
bool    can_deguild     args( (CHAR_DATA *ch) );
bool    can_promote     args( (CHAR_DATA *ch) );
bool    can_demote      args( (CHAR_DATA *ch) );

/* war.c */
void war_channel args((CHAR_DATA *ch, char *message));
void war_update args((void));
void auto_war args((void));
void check_war args((CHAR_DATA * ch, CHAR_DATA * victim));
bool is_safe_war args((CHAR_DATA * ch, CHAR_DATA * wch));
void war_talk args((CHAR_DATA * ch, char *argument));
void end_war args((void));
bool abort_race_war args((void));
bool abort_class_war args((void));
bool abort_clan_war args((void));
void extract_war args(( CHAR_DATA * ch ));
                                           

/* object_cond.c */
void show_obj_cond     args ( (CHAR_DATA *ch, OBJ_DATA *obj) );  
void check_damage_obj  args ( (CHAR_DATA *ch, OBJ_DATA *obj, int chance) );  
void damage_obj        args ( (CHAR_DATA *ch, OBJ_DATA *obj, int damage) );  
void set_obj_condition args ( (OBJ_DATA *obj, int condition) );

/* weather.c */
bool  number_chance     args( ( int num ) );
void  show_weather      args( ( CHAR_DATA *ch ) );
bool  IS_OUTDOORS       args( ( CHAR_DATA *ch ) );
int   temperature_change args( ( CHAR_DATA *ch ) );

/* act_mob.c */
void  save_pets         args( ( ) );


CMD_DATA *cmd_lookup args( ( const char *name ) );   

/* Socials */

void load_social_table();
void save_social_table(); 

/* Postal */

void load_postal_table();
void save_social_table();
void new_postal	args ( ( CHAR_DATA *ch ) );
