/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik Stfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

/***************************************************************************
*       ROM 2.4 is copyright 1993-1998 Russ Taylor                         *
*       ROM has been brought to you by the ROM consortium                  *
*           Russ Taylor (rtaylor@hypercube.org)                            *
*           Gabrielle Taylor (gtaylor@hypercube.org)                       *
*           Brian Moore (zump@rom.org)                                     *
*       By using this code, you have agreed to follow the terms of the     *
*       ROM license, in the file Rom24/doc/rom.license                     *
***************************************************************************/
#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#include <sys/time.h>
#endif
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <time.h>

#include "telnet.h"
#include "include.h"

bool	check_parse_name	args( ( char *name ) );
bool	check_reconnect		args( ( DESCRIPTOR_DATA *d, char *name, bool fConn ) );
bool	check_playing		args( ( DESCRIPTOR_DATA *d, char *name ) );
void	send_creation_menu  args( ( CHAR_DATA *ch ) );

extern bool	wizlock;
extern bool newlock;

#if defined(macintosh) || defined(MSDOS)
const char  echo_off_str  [] = { '\0' };
const char  echo_on_str [] = { '\0' };
#endif
  
#if defined(unix)
const char  echo_off_str  [] = { IAC, WILL, TELOPT_ECHO, '\0' };
const char  echo_on_str [] = { IAC, WONT, TELOPT_ECHO, '\0' };
#endif

/*
 * Deal with sockets that haven't logged in yet.
 */
void nanny( DESCRIPTOR_DATA *d, char *argument )
{
    EMAIL_DATA *pMail;
    DESCRIPTOR_DATA *d_old, *d_next;
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *ch;
    CHAR_DATA *vch;
    char *pwdnew;
    char *p;
    int iClass,race,i,weapon, wrap, counter;
    bool fOld, found;
	RELIGION *pRlg;

    if (d->connected != CON_NOTE_TEXT)
    {	while ( isspace(*argument) )
        argument++;
    }                             
	ch = d->character;

    switch ( d->connected )
    {    default:
			bug( "Nanny: bad d->connected %d.", d->connected );
			close_socket( d );
			return;
/***************************************************************************************************/
		case CON_GET_NAME:
			if ( argument[0] == '\0' )
			{	close_socket( d );
				return;
			}

			argument[0] = UPPER(argument[0]);
			if ( !check_parse_name( argument ) )
			{	write_to_buffer( d, "Illegal name, try another.\n\rName: ", 0 );
			    return;
			}
			fOld = load_char_obj( d, argument );
			ch   = d->character;
			if (IS_SET(ch->act, PLR_DENY))
			{	sprintf( log_buf, "Denying access to %s@%s.", argument, d->host );
			    log_string( log_buf );
				write_to_buffer( d, "You are denied access.\n\r", 0 );
			    close_socket( d );
				return;
			}

			if (check_ban(d->host,BAN_PERMIT) && !IS_SET(ch->act,PLR_PERMIT))
			{	write_to_buffer(d,"Your site has been banned from this mud.\n\r",0);
			    close_socket(d);
				return;
			}

			if ( check_reconnect( d, argument, FALSE ) )
				fOld = TRUE;
			else if ( wizlock && !IS_IMMORTAL(ch)) 
			{	write_to_buffer( d, "The game is wizlocked.\n\r", 0 );
				close_socket( d );	
				return;
			}
			

			if ( fOld )
			{	/* Old player */
			    write_to_buffer( d, "Password: ", 0 );
			    write_to_buffer( d, echo_off_str, 0 );
			    d->connected = CON_GET_OLD_PASSWORD;
			    return;
			}
			else
			{	/* New player */
		 	    if (newlock)
				{	write_to_buffer( d, "The game is newlocked.\n\r", 0 );
	                close_socket( d );
	                return;
		        }

				if (check_ban(d->host,BAN_NEWBIES))
			    {	send_to_desc( "{cNew players are not allowed from your site.{x\n\r",d);
					close_socket(d);
					return;
			    }
				sprintf( buf, "\n\r{cWe here at {wAl'haen{c prefer you keep your names rpish.\n\rWhich means, don't make inappropriate names. Make names\n\ras if it where Medieval times. Make them names, not\n\rsomething like {w\"{cBladedancer{w\"{c or such. Such names will be\n\rasked to be changed.{x\n\r\n\r");
			    send_to_desc(  buf, d );
			    sprintf( buf, "{cWould you like to keep {x\"{c%s{x\"{c as your name? {w({cY{w/{cN{w){x? ", argument );
				send_to_desc( buf, d );
			    d->connected = CON_CONFIRM_NEW_NAME;
				return;
			}
			break;

/***************************************************************************************************/
		case CON_GET_OLD_PASSWORD:
			#if defined(unix)
				write_to_buffer( d, "\n\r", 2 );
			#endif

			if ( strcmp( crypt( argument, ch->pcdata->pwd ), ch->pcdata->pwd ))
			{	send_to_desc( "{cWrong password.{x\n\r", d ); 
			        close_socket( d );
			    	sprintf( log_buf, "%s. Bad Password. IP: %s> %s", ch->name,d->host,argument);
				log_string( log_buf );
		        	sprintf( log_buf, "%s@%s bad password.", ch->name, d->host );
				wiznet(log_buf,NULL,NULL,WIZ_LOGINS,0,get_trust(ch));
				return;
			}
 
			write_to_buffer( d, echo_on_str, 0 );

			if (check_playing(d,ch->name))
				return;

			if ( check_reconnect( d, ch->name, TRUE ) )
				return;

			sprintf( log_buf, "%s@%s has connected.", ch->name, d->host );
			log_string( log_buf );
			wiznet(log_buf,NULL,NULL,WIZ_SITES,0,get_trust(ch));

			if ( IS_IMMORTAL(ch) )
			{
                            printf_to_char(ch, "{cPlease Pick An Option\n\r\n\rE:{x Enter Al'haen\n\r{cL:{x Leave Al'haen\n\r{cS:{x Al'haen Wizlist\n\r{cW:{x Activate Wizinviz\n\r{cH:{x Who's on Al'haen\n\r{cD:{x Delete\n\r\n\r{CEnter Selection{D-> {x"); 
			    d->connected = CON_MENU;
			}
	                else
			{	
                            printf_to_char(ch, "{cPlease Pick An Option\n\r\n\r{cE:{x Enter Al'haen\n\r{cL:{x Leave Al'haen\n\r{cS:{x Al'haen Wizlist\n\rH: Who's on Al'haen\n\rD: Delete\n\r\n\r{CEnter Selection{D-> {x");  
        	            d->connected = CON_MENU;
			}
	        break;                                             
/***************************************************************************************************/    
        case CON_MENU:
			switch ( *argument )
			{	case 'e': case 'E':
			        write_to_buffer(d,"\n\rLogging In\n\r",0);
			        if ( IS_IMMORTAL(ch) )
			        {	do_function(ch, &do_help, "imotd" );
			            d->connected = CON_READ_IMOTD;
				}
			        else
				{
 	                            do_function(ch, &do_help, "motd" );
			            d->connected = CON_READ_MOTD;
			        }
			        break;                                          
 
		         case 's': case 'S':
				write_to_buffer( d, "\n\rAl'haen Wizlist.\n\r",0);
				do_function(ch, &do_wizlist, "" );
		                write_to_buffer( d, "\n\r*[HIT RETURN]*\n\r",0);
			        break;

		        case 'l': case 'L':
			       write_to_buffer( d, "\n\rLeaving so soon!\n\r ", 0 );
		               close_socket(d);
			       break;

		        case 'h': case 'H':
			       write_to_buffer( d, "Who's on Al'haen.\n\r", 0 );
		               do_function(ch, &do_who, "" );
			       write_to_buffer( d, "\n\r*[HIT RETURN]*\n\r", 0 );
		               break;

			case 'w': case 'W':
		            if (IS_IMMORTAL(ch) )
			    {
                          	if(is_admin(ch) )
		                {	
                                   ch->invis_level = atoi(argument + 1);
				    
                                   if (ch->invis_level <= 1  || ch->invis_level > get_trust(ch))
			               ch->invis_level = get_trust(ch);
			        }
					    
                                else
				   ch->invis_level = LEVEL_IMMORTAL;
                                   printf_to_char( ch, "Invis level set to %d\n\r", ch->invis_level ); 
		            }
				
                            else
			        send_to_char( "Not at your level\n\r", ch );
				break;          

		        case 'd' : case 'D':
				do_function(ch, &do_delete, ""); 
		                printf_to_char( ch, "Entering or leaving Al'haen will remove your delete status.\n\r" );
			        write_to_buffer( d, "\n\r*[HIT RETURN]*\n\r",0);                 
		                break;        

	      	         	default:
                                printf_to_char(ch, "Please Pick An Option\n\r\n\rE: Enter Al'haen\n\rL: Leave Al'haen\n\rS: Al'haen Wizlist\n\rH: Who's on Al'haen\n\rD: Delete\n\r\n\rEnter Selection ->");  
			        break;
			}
	        break;

/***************************************************************************************************/

		case CON_NOTE_TO:
	        handle_con_note_to (d, argument);
		    break;

		case CON_NOTE_SUBJECT:
			handle_con_note_subject (d, argument);
			break; /* subject */

                case CON_NOTE_EXPIRE:
			handle_con_note_expire (d, argument);
			break;

                case CON_NOTE_TEXT:
			handle_con_note_text (d, argument);
	                break;

                case CON_NOTE_FINISH:
		        handle_con_note_finish (d, argument);
			break;            

/***************************************************************************************************/
 
	        case CON_BREAK_CONNECT:
			switch( *argument )
			{	case 'y' : case 'Y':
		            for ( d_old = descriptor_list; d_old != NULL; d_old = d_next )
					{	d_next = d_old->next;
						if (d_old == d || d_old->character == NULL)
						    continue;
						if (str_cmp(ch->name,d_old->original ? d_old->original->name : d_old->character->name))
						    continue;
						close_socket(d_old);
					}
				    if (check_reconnect(d,ch->name,TRUE))
	    				return;
				    write_to_buffer(d,"Reconnect attempt failed.\n\rName: ",0);
					if ( d->character != NULL )
		            {	nuke_pets( d->character );
		                free_char( d->character );
				        d->character = NULL;
					}
					d->connected = CON_GET_NAME;
				    break;

				case 'n' : case 'N':
				    write_to_buffer(d,"Name: ",0);
					if ( d->character != NULL )
		            {	nuke_pets( d->character );
		                free_char( d->character );
				        d->character = NULL;
					}
				    d->connected = CON_GET_NAME;
				    break;

				default:
				    write_to_buffer(d,"Please type Y or N? ",0);
				    break;
			}
			break;

/***************************************************************************************************/

		case CON_CONFIRM_NEW_NAME:
			switch ( *argument )
			{	case 'y': case 'Y':
				    sprintf( buf, "{cNew character.\n\r\n\r{cWhat password would you like for {c%s: %s{x",
					ch->name, echo_off_str );
				    send_to_desc( buf, d );
					d->connected = CON_GET_NEW_PASSWORD;
					SET_BIT( ch->act, PLR_COLOUR );
					break;

				case 'n': case 'N':
				    send_to_desc( "{cOk, what IS it, then?{x ",d );
					nuke_pets( d->character );
				    free_char( d->character );
					d->character = NULL;
					d->connected = CON_GET_NAME;
					break;

				default:
					send_to_desc("{cPlease type {wY{ces or {wN{co?{x ",d );
				    break;
			}
			break;

/***************************************************************************************************/

		case CON_GET_NEW_PASSWORD:
			#if defined(unix)
				write_to_buffer( d, "\n\r", 2 );
			#endif

			if ( strlen(argument) < 5 )
			{	send_to_desc( "{cPassword must be at least five characters long.\n\rPassword:{x ",d );
			    return;
			}

			pwdnew = crypt( argument, ch->name );
			for ( p = pwdnew; *p != '\0'; p++ )
			{	if ( *p == '~' )
			    {	send_to_desc( "{cNew password not acceptable, try again.\n\rPassword:{x ", d );
					return;
			    }
			}

			free_string( ch->pcdata->pwd );
			ch->pcdata->pwd	= str_dup( pwdnew );
			send_to_desc( "{cPlease retype password:{x ", d );
			d->connected = CON_CONFIRM_NEW_PASSWORD;
			break;

/***************************************************************************************************/

		case CON_CONFIRM_NEW_PASSWORD:
			#if defined(unix)
				write_to_buffer( d, "\n\r", 2 );
			#endif
			if ( strcmp( crypt( argument, ch->pcdata->pwd ), ch->pcdata->pwd ) )
			{	send_to_desc( "{cPasswords {wdon't{c match.\n\rRetype password:{x ", d );
			    d->connected = CON_GET_NEW_PASSWORD;
				return;
			}
			write_to_buffer( d, echo_on_str, 0 );

			for(i = 0; i < MAX_CBOOL ; i ++ )
				ch->pcdata->creation[i] = FALSE;

			send_creation_menu(ch);
			d->connected = CON_CREATION_MENU;
			break;

/***************************************************************************************************/

		case CON_CREATION_MENU:
			switch(UPPER( argument[0] ))
			{	
				case 'A':
					send_to_char("\n\r{cOne of the first step to becoming one with the land, is choosing\n\ra race. Choose wisely. Feel free to ask for help.\n\rPlease note, your alignment is selected depending on your race\n\r\n\r{x", ch);
					d->connected = CON_GET_NEW_RACE;
					send_race_list(ch);
					ch->pcdata->creation[CHOSE_RACE] = TRUE;
					send_to_char("\n\r\n\r{cPlease choose one of the following. You can use the name, or the corresponding number\n\r{CEnter race{D->{x ",ch);
					break;

				case 'B':
					counter = 1;
					wrap = 0;
					send_to_char( "\n\r{cNow, a class must be chosen. These are your choices:\n\r",ch);
					send_class_list(ch);
					send_to_char("\n\r\n\r{cPlease choose one listed. You can use the name or the corresponding number.\n\r{CEnter class{D->{x ",ch);

					d->connected = CON_GET_NEW_CLASS;
					break;
				case 'C':
					send_to_char("\n\r{cWhat would you like your gender to be? {wM{cale or {wF{cemale?\n\r{CEnter gender{D->{x ", ch);
					ch->pcdata->creation[CHOSE_GENDER] = TRUE;
					d->connected = CON_GET_NEW_SEX;
					break;
				case 'D':
					send_to_char( "\n\r{cNow to select a Hometown. Your choices are:\n\r{x", ch );
					counter = 1;
					for (i=0;hometown_table[i].name != NULL; ++i)
					{	sprintf(buf,"{c%d:{x %s\n\r", counter, hometown_table[i].name );
						send_to_char(buf,ch);
						counter++;
					}
					send_to_char( "\n\r{CEnter hometown{D->{x ", ch);
					ch->pcdata->creation[CHOSE_HOMETOWN] = TRUE;
					d->connected = CON_GET_HOMETOWN;
					break;
				case 'E':
					counter = 1;
				    send_to_char("\n\r{cThe following Religions are available:\n\r", ch);
					for ( pRlg = religion_list; pRlg ; pRlg = pRlg->next )
					{	printf_to_char(ch, "{c%s -{x %s\n\r", pRlg->name, pRlg->god );
						if(pRlg->faction[FACTION_ONE] )
							printf_to_char(ch, "\t{CFaction: %s {x- %s\n\r", pRlg->faction[FACTION_ONE]->name, pRlg->faction[FACTION_ONE]->deity ); 
						if(pRlg->faction[FACTION_TWO] )
							printf_to_char(ch, "\t{CFaction: %s {x- %s\n\r", pRlg->faction[FACTION_TWO]->name, pRlg->faction[FACTION_TWO]->deity ); 
					}
					send_to_char("{cNone -{x None.\n\r",ch);

					write_to_buffer(d,"\n\r",0);
					send_to_char( "{cWhere do you place your faith? (help for more information)?\n\r{CEnter religion{D-> {x", ch);
					ch->pcdata->creation[CHOSE_GOD] = TRUE;
					d->connected = CON_GET_GOD;
					break;
				case 'F':
					send_to_char("\n\r{cNow you must set your short description.\n\r\n\r",ch);
					send_to_char("Now, some guide lines for setting your short description are as follows:\n\r",ch);
					send_to_char("{c1:{x Please refrain from using actions within your short description.\n\r",ch);
					send_to_char("{c2:{x Please only put the most significant features of your character.\n\r",ch);
					send_to_char("{c3:{x Do not put common charactistics of your race in the short description.\n\r",ch);
					send_to_char("{c4:{x Make sure the description is valid in all positions, sitting, standing, ect...\n\r",ch);

					send_to_char("\n\r{cPlease set your short description at this time. Rember to keep it under 60 characters.\n\r{CEnter short descr{D->{x ",ch);
					ch->pcdata->creation[CHOSE_SHORT] = TRUE;
					d->connected = CON_SET_SHORT;
					break;
				case 'G':
					send_to_char("\n\r{cNow, which colour hair would you like?\n\r\n\r", ch);
					counter = 1;
					for(i = 0 ; i < MAX_HAIR ; i++)
					{	printf_to_char(ch, "{c%d:{x %s\n\r",counter, hair_table[i].name);
						counter++;
					}
					ch->pcdata->creation[CHOSE_ATTRIBUTES] = TRUE;
					send_to_char("\n\r{CEnter hair colour{D->{x ",ch);
					d->connected = CON_GET_HAIR;
					break;
				case 'H':
					send_to_char("\n\r{cWhats your email?\n\r{CEnter Email{D->{x ",ch);
					d->connected = CON_GET_EMAIL;
					break;
				case 'I':
					for(i = 0 ; i < MAX_CBOOL ; i++ )
					{	if(ch->pcdata->creation[i] == FALSE)
						{	send_to_char("{cYou must finish all selections, except E-Mail.{x\n\r",ch);
							send_creation_menu(ch);
							return;
						}
					}

			        write_to_buffer( d, "\n\r", 2 );
        			send_to_desc( "{cPlease pick a weapon from the following choices:\n\r{x",d);
      			    buf[0] = '\0';
					//set_class_skills(ch);
					ch->pcdata->learned[skill_lookup("dagger")] = 50;
				    for ( i = 0; weapon_table[i].name != NULL; i++)
        		        if (ch->pcdata->learned[skill_lookup(weapon_table[i].name)] > 0)
       			        {	strcat(buf,weapon_table[i].name);
             			    strcat(buf," ");
            			}
            			strcat(buf,"\n\r{CEnter Weapon{D->{x ");
            			send_to_desc(buf,d);
						d->connected = CON_PICK_WEAPON;;
						break;
				default:
					send_creation_menu(ch);
					break;
			}
			break;

/***************************************************************************************************/

		case CON_GET_EMAIL:
			if(argument[0] == '\0' )
			{   send_to_char("{cWhat was that?\n\r{CEnter e-mail{D->{x ",ch);
				return;
			}

			free_string(ch->pcdata->email);
			pMail = new_email();
			free_string(pMail->name);
			pMail->name = str_dup(ch->name);
			send_to_char("Email set.\n\r",ch);
			free_string(pMail->email);
			free_string(ch->pcdata->email );
			ch->pcdata->email = str_dup(argument);
			pMail->email = str_dup(argument );
			send_creation_menu(ch);
			d->connected = CON_CREATION_MENU;
			break;				

/***************************************************************************************************/

		case CON_GET_NEW_RACE:
			one_argument(argument,arg);

			if (!strcmp(arg,"help"))
			{	argument = one_argument(argument,arg);
			    if (argument[0] == '\0')
					do_function(ch, &do_help, "race help");
			    else
					do_function(ch, &do_help, argument);
		        write_to_buffer(d, "\n\r\n\r{cWhat race would you like to be (help for more information)?\n\r{CEnter race{D->{x  ",0);
			    break;
		  	}
			i = 1;
			if(is_number(argument) )
			{	for (race = 1; race <= MAX_PC_RACE ; race++ )
				{	if(i == atoi(argument) )
						break;
					if ( race_table[race].pc_race && !race_table[race].imm_only)
					    i++;
					else
						break;
				}
				if((atoi(argument) > i || atoi(argument) <= 0)
				|| (!race_table[i].pc_race || race_table[race].imm_only) )
				{	send_to_char("{cInvalid. Please choose again.\n\r{CEnter Race{D->{x ",ch);
					send_race_list(ch);
					return;
				}
				race = i;
			}
			else
				race = race_lookup(argument);
			if( ch->clss != -1 )
			{	if( restrict[ch->clss][race] )
			{	send_to_char("{cI'm sorry, this class/race combination is illegal.\n\r\n\r{x",ch);
				send_race_list(ch);
				send_to_char("\n\r\n\r{cPlease make another selection.\n\r{CEnter Race{D->{x ",ch);
				return;
			}
			}
			if (race == 0 || race >= MAX_PC_RACE)
			{	send_to_char("\n\r{cThat race does not exist in these lands.\n\r",ch);
		        send_to_char("The following races here, available are:{x\n\r\n\r",ch);
				counter = 1;
				send_race_list(ch);
				ch->pcdata->creation[CHOSE_RACE] = TRUE;
				send_to_char("\n\r\n\r{cPlease choose one of the following. You can use the name, or the corresponding number\n\r{CEnter race{D->{x ",ch);
        		break;
			}
			i =0;

			ch->race = race;
			set_char_groups(ch, TYPE_RACE);
			/* initialize stats */
			for (i = 0; i < MAX_STATS; i++)
				ch->perm_stat[i] = pc_race_table[race].stats[i];
			ch->affected_by = ch->affected_by|race_table[race].aff;
			set_char_res(ch);
			ch->form	= race_table[race].form;
			ch->parts	= race_table[race].parts;
			ch->pcdata->boxrented = 0;
			ch->pcdata->item_box = 0;                 
			for( i = 0; i < MAX_CRYSTAL ; i ++ )
				ch->pcdata->nature[i] = number_range(-100, 100);
			/* add cost */
			ch->pcdata->points = pc_race_table[race].points;
			ch->size = pc_race_table[race].size;
			send_creation_menu(ch);
			d->connected = CON_CREATION_MENU;
			break;
        
/***************************************************************************************************/

	    case CON_GET_NEW_SEX:
			switch ( argument[0] )
			{	case 'm': case 'M': ch->sex = SEX_MALE;    
					ch->pcdata->true_sex = SEX_MALE;
					break;
				case 'f': case 'F': ch->sex = SEX_FEMALE; 
				    ch->pcdata->true_sex = SEX_FEMALE;
					break;
				default:
				    send_to_char("{cHeh, whats that? Please choose one of the following:\n\r{wM{cale or {wF{cemale\n\r\n\r{CEnter gender{D->{x ", ch );
				    return;
			}
			send_creation_menu(ch);
			d->connected = CON_CREATION_MENU;
			break;

/***************************************************************************************************/

	    case CON_GET_NEW_CLASS:
			if(is_number(argument) )
				iClass = atoi(argument)-1;
			else
				iClass = class_lookup(argument);
			if ( iClass <= -1 || iClass >= MAX_CLASS)
			{	send_to_char( "\n\r{cThat is not a class on Al'haen, please choose one that exists.\n\r", ch);
				counter = 1;
				wrap = 0;
				send_to_char( "{cThese are your choices:{x\n\r",ch);
				send_class_list(ch);
				send_to_char("\n\r\n\r{cPlease choose one listed. You can use the name or the corresponding number.\n\r{CEnter class{D->{x ",ch);
				return;
			}
			if( restrict[iClass][ch->race] )
			{	send_to_char("{cI'm sorry, this class/race combination is illegal.{x\n\r\n\r",ch);
				send_class_list(ch);
				send_to_char("\n\r\n\r{cPlease make another selection.\n\r{CEnter Class{D-> {x",ch);
				return;
			}
			

		    /* Set the class. */
			ch->clss = iClass;  
			set_char_groups(ch, TYPE_CLASS);
		    /* Last class is ALWAYS -1 */
			sprintf( log_buf, "%s@%s new player.", ch->name, d->host );
			log_string( log_buf );
			wiznet("Newbie alert!  $N sighted.",ch,NULL,WIZ_NEWBIE,0,0);
		    wiznet(log_buf,NULL,NULL,WIZ_SITES,0,get_trust(ch));
			ch->pcdata->creation[CHOSE_CLASS] = TRUE;
			send_creation_menu(ch);
			d->connected = CON_CREATION_MENU;

			break;

/***************************************************************************************************/

	    case CON_GET_HOMETOWN:
			found = FALSE;
			if(is_number(argument) )
	        {	iClass = atoi(argument)-1;
				for (i = 0; hometown_table[i].name != NULL ; i++ )
				{	if (i == iClass)
					{	found = TRUE;
						break;
					}
				}
			}
			else
			{	iClass = get_hometown(argument); found = TRUE; }

			if (iClass <= -1 || !found)
			{	send_to_char( "\n\r{cThat's not a valid selection.{x\n\r", ch);
	    		send_to_char( "{cValid selections are:{x\n\r", ch);
				counter = 1;
				for (i=0;hometown_table[i].name != NULL; ++i)
				{	sprintf(buf,"{c%d:{x %s\n\r", counter, hometown_table[i].name );
					send_to_char(buf,ch);
					counter++;
				}
    			send_to_char( "\n\r{CEnter hometown{D->{x ", ch);
    			return;
	    	}
			ch->hometown = iClass;
			send_creation_menu(ch);
			d->connected = CON_CREATION_MENU;
			break;

/***************************************************************************************************/

	    case CON_GET_GOD:
		    one_argument(argument,arg);

			if (!strcmp(arg,"help"))
	        {	argument = one_argument(argument,arg);
				if (argument[0] == '\0')
					do_help(ch,"gods");
	            else
		            do_help(ch,argument);
		        send_to_char("{cWhere do you place your faith? (help for more information)?\n\r{CEnter religion{D-> ", ch);
			    break;
	        }
			if(!str_cmp(argument, "None" ) )
			{	send_to_char("{cYou have chosen the path of a Heathen. May the gods NOT be with you.\n\r\n\r", ch);
				ch->pcdata->religion = NULL;

				ch->pcdata->learned[skill_lookup("recall")] = 50;
				write_to_buffer( d, echo_on_str, 0 );
				send_creation_menu(ch);
				d->connected = CON_CREATION_MENU;
				break;
			}


			if( ( pRlg = religion_lookup(argument) ) == NULL )
			{	if( ( pRlg = faction_lookup(argument ) ) == NULL )
				{	send_to_char("{cThat isn't a valid Religion or Faction.\n\r{CEnter religion{D-> ",ch);
					return;
				}
			}

			printf_to_char(ch, "{cYour faith is placed in {x%s{c.{x\n\r\n\r", pRlg->name );
			ch->pcdata->religion = pRlg;
	                ch->pcdata->learned[skill_lookup("recall")] = 50;
	                write_to_buffer( d, echo_on_str, 0 );
			send_creation_menu(ch);
			d->connected = CON_CREATION_MENU;
			break;


/***************************************************************************************************/

		case CON_SET_SHORT:
			if(strlen(argument) > 60)
			{	send_to_char("{cYour short description is too long, please make it something shorter.\n\r{CEnter short descr{D->{x ",ch);
				return;
			}

			if(str_str(argument, ch->name) )
		    {	send_to_char("{cYour name must not be included in your short description.\n\r{CEnter short descr{D->{x ",ch);
				return;
			}

			if(strlen(argument) < 5)
			{	send_to_char("{cPfft. It has to be longer than that!\n\r{CEnter short descr{D->{x ",ch);
				return;
			}

			printf_to_char(ch, "{cYour short desc has been set too: {w%s{x\n\r",argument);
			free_string(ch->short_descr);
			ch->short_descr = str_dup(argument);
			send_creation_menu(ch);
			d->connected = CON_CREATION_MENU;
			break;

/***************************************************************************************************/

	    case CON_GET_HAIR:
			if(is_number(argument) )
				iClass = atoi(argument)-1;
			else
				iClass = hair_lookup(argument);

			if(iClass <= -1 || iClass >= MAX_HAIR )
			{	send_to_char("\n\r{cThat is not a valid colour. Your choices are:{x\n\r\n\r",ch);
				counter = 1;
				for(i = 0 ; i < MAX_HAIR ; i++)
				{	printf_to_char(ch, "{c%d:{x %s\n\r",counter, hair_table[i].name);
					counter++;
				}
				send_to_char("\n\r{CEnter hair colour{D->{x ",ch);
				break;
			}

			printf_to_char(ch, "{cYour hair colour is now {w%s{c.{x\n\r", hair_table[iClass].name);
			ch->pcdata->hair = iClass;
			d->connected = CON_GET_EYE;
			send_to_char("{cWhich colour eyes would you like?\n\r\n\r",ch);
			counter = 1;
			for(i = 0 ; i < MAX_EYE ; i++)
			{	printf_to_char(ch, "{c%d:{x %s\n\r",counter, eye_table[i].name);
				counter++;
			}
			send_to_char("\n\r{CEnter eye colour{D->{x ",ch);
			break;

/***************************************************************************************************/

		case CON_GET_EYE:
			if(is_number(argument) )
				iClass = atoi(argument)-1;
			else
				iClass = eye_lookup(argument);

			if(iClass <= -1 || iClass >= MAX_EYE )
			{	send_to_char("\n\r{cThat is not a valid colour. Your choices are:{x\n\r\n\r",ch);
				counter = 1;
				for(i = 0 ; i < MAX_EYE ; i++)
				{	printf_to_char(ch, "{c%d:{x %s\n\r",counter, eye_table[i].name);
					counter++;
				}
				send_to_char("\n\r{CEnter eye colour{D->{x ",ch);
				break;
			}

			printf_to_char(ch, "{cYour eye colour is now {w%s{x.\n\r", eye_table[iClass].name);
			ch->pcdata->eye = iClass;
			d->connected = CON_GET_HEIGHT;
			send_to_char("{cHow tall would you like to be?{x\n\r\n\r",ch);

			counter = 1;
			for(i = 0 ; i < MAX_HEIGHT ; i++)
			{	printf_to_char(ch, "{c%d:{x %s{x\n\r",counter, height_table[i].name);
				counter++;
			}
			send_to_char("\n\r{CEnter height{D->{x ",ch);	
			break;

/***************************************************************************************************/

		case CON_GET_HEIGHT:
			if(is_number(argument) )
				iClass = atoi(argument)-1;
			else
				iClass = height_lookup(argument);

			if(iClass <= -1 || iClass >= MAX_HEIGHT )
			{	send_to_char("\n\r{cThat is not a valid height. Your choices are:{x\n\r\n\r",ch);
				counter = 1;
				for(i = 0 ; i < MAX_HEIGHT ; i++)
				{	printf_to_char(ch, "{c%d:{x %s\n\r",counter, height_table[i].name);
					counter++;
				}
				send_to_char("\n\r{CEnter height{D->{x ",ch);
				break;
			}

			printf_to_char(ch, "{cYour height is now {W%s.\n\r", height_table[iClass].name);
			ch->pcdata->height = iClass;
			d->connected = CON_GET_WEIGHT;
			send_to_char("{cWhat type of physique would you like?\n\r\n\r",ch);

			counter = 1;
			for(i = 0 ; i < MAX_WEIGHT ; i++)
			{	printf_to_char(ch, "{c%d:{x %s\n\r",counter, weight_table[i].name);
				counter++;
			}
			send_to_char("\n\r{CEnter weight{D->{x ",ch);
			break;

/***************************************************************************************************/

	    case CON_GET_WEIGHT:
			if(is_number(argument) )
				iClass = atoi(argument)-1;
			else
				iClass = weight_lookup(argument);

			if(iClass <= -1 || iClass >= MAX_WEIGHT )
			{	send_to_char("\n\r{cThat is not a valid weight. Your choices are:\n\r\n\r",ch);
				counter = 1;
				for(i = 0 ; i < MAX_WEIGHT ; i++)
				{	printf_to_char(ch, "{c%d:{w %s{x\n\r",counter, weight_table[i].name);
					counter++;
				}
				send_to_char("\n\r{CEnter weight{D->{x ",ch);
				break;
			}

			printf_to_char(ch, "{cYour weight is now {W%s.{x\n\r", weight_table[iClass].name);
			ch->pcdata->height = iClass;
			send_creation_menu(ch);;
			d->connected = CON_CREATION_MENU;
			break;

/***************************************************************************************************/

	    case CON_PICK_WEAPON:
			write_to_buffer(d,"\n\r",2);
			weapon = weapon_lookup(argument);
			if (weapon == -1 || ch->pcdata->learned[skill_lookup(weapon_table[weapon].name)] <= 0)
			{	send_to_desc("{cThat's not a valid selection. Choices are:{x\n\r",d);
	            buf[0] = '\0';
		        for ( i = 0; weapon_table[i].name != NULL; i++)
			        if (ch->pcdata->learned[skill_lookup(weapon_table[i].name)] > 0)
				    {	strcat(buf,weapon_table[i].name);
					    strcat(buf," ");
	                }
			        strcat(buf,"\n\r{CEnter Weapon{D->{x ");
		            send_to_desc(buf,d);
				    return;
			}

			ch->pcdata->learned[skill_lookup(weapon_table[weapon].name)] = 
	        UMAX(40, ch->pcdata->learned[skill_lookup(weapon_table[weapon].name)]);
			write_to_buffer(d,"\n\r",2);
			do_function(ch, &do_help, "motd");
			d->connected = CON_READ_MOTD;
			break;


/***************************************************************************************************/

		case CON_READ_IMOTD:
			write_to_buffer(d,"\n\r",2);
	        do_function(ch, &do_help, "motd");
		    d->connected = CON_READ_MOTD;
			break;
/***************************************************************************************************/

	    case CON_READ_MOTD:
		    if ( ch->pcdata == NULL || ch->pcdata->pwd[0] == '\0')
			{	write_to_buffer( d, "Warning! Null password!\n\r",0 );
				write_to_buffer( d, "Please report old password with bug.\n\r",0);
				write_to_buffer( d, "Type 'password null <new password>' to fix.\n\r",0);
	        }

			write_to_buffer( d, "\n\rWelcome to Al'haen Please do not feed the mobiles.\n\r", 0 );
			ch->next	= char_list;
			char_list	= ch;
			d->connected	= CON_PLAYING;
			reset_char(ch);

			if( is_clan(ch) )
			{	MEMBER_DATA *pMem;
			    if( ( pMem = member_lookup(&clan_table[ch->clan], ch->name ) ) == NULL )
			    {	pMem = new_member();
					pMem->level = ch->level;
					pMem->flevel = ch->levelflux;
					pMem->name = str_dup(ch->name);
					pMem->rank = ch->rank;
					member_to_guild(&clan_table[ch->clan], pMem);
				}
			}
		
			if ( ch->level == 0 )
			{	
                            if(ch->clss == -1)
		               ch->clss = 0;
			        
                            ch->perm_stat[class_table[ch->clss].attr_prime] += 3;
			    ch->level	= 1;
			    ch->exp	= exp_per_level(ch,ch->pcdata->points);
			    ch->hit	= ch->max_hit;
			    ch->mana	= ch->max_mana;
			    ch->move	= ch->max_move;
			    ch->train	 = 3;
	    	     	    ch->practice = 5;
       
 	                    SET_BIT( ch->comm2, COMM_AUTOLEVEL );          
  
	 	            sprintf( buf, "The newbie\n\r");
			    send_to_char( buf, ch );

		   	    do_function( ch, &do_autoall, "on" );
			    //do_function (ch, &do_pack,"Self");
                            do_function( ch, &do_divine, "self");
				handle_virtual_room(ch, 0, 0, 0, 136, 299, 0);
			    char_to_room( ch, get_room_index(1) );
    			    send_to_char("\n\r",ch);
			    do_function(ch, &do_help, "newbie info");
				send_to_char("\n\r",ch);
			}
			else
			{
				handle_virtual_room(ch, 0, 0, 0, ch->cordinate[CORD_X], ch->cordinate[CORD_Y], ch->cordinate[CORD_Z]);
				char_to_room(ch, ch->in_ocean ? ch->in_ocean->room : NULL );
			}

			act( "$n has entered the game.", ch, NULL, NULL, TO_ROOM );

	        if (ch->mount != NULL)
                {	
                    char_to_room(ch->mount,ch->in_room);
	            act("$n has entered the game.",ch->mount,NULL,NULL,TO_ROOM);
		    add_follower(ch->mount, ch);
		    do_mount(ch, ch->mount->name);
	        }
	
	        send_to_char("\n", ch);
		do_unread(ch, "");  
         
	        if (ch->pcdata->host == NULL
		    || sizeof(ch->pcdata->host) == 0
			|| !str_cmp(ch->pcdata->host, "none"))
	        {	
                    sprintf(buf, "\n\rUpdating site login info: %s\n\r\n\r", d->host);
	            send_to_char(buf, ch);
		}
			
                else if (!str_cmp(ch->pcdata->host, d->host))
	        {	  
                    sprintf(buf, "\n\rUsual login: %s\n\r\n\r", ch->pcdata->host);
	            send_to_char(buf, ch);
                }       
		
	        else
	        {	
                    sprintf(buf, "\n\rLast login: %s\n\r", ch->pcdata->host);
	            send_to_char(buf, ch);
		    sprintf(buf, "Current login: %s\n\r\n\r", d->host);
		    send_to_char(buf, ch);
	        }
       
                free_string( ch->pcdata->host );
		ch->pcdata->host = str_dup(d->host);
		do_function(ch, &do_look, "auto" );
		wiznet("[LOGIN]: $N has left real life behind.",ch,NULL, WIZ_LOGINS,WIZ_SITES,get_trust(ch));
                count_connections++;

                for ( vch = char_list; vch != NULL; vch = vch->next )
	        {      
                     if (vch->in_room == ch->in_room)
	                 continue;
                         
                     if (IS_SET(vch->comm, COMM_PENTER) )
		         act("[INFO]: $n has decided to leave real life behind.",ch,0,vch,TO_VICT);
                }

		if (ch->pet != NULL)
		{	
                    char_to_room(ch->pet,ch->in_room);
		    act("$n has entered the game.",ch->pet,NULL,NULL,TO_ROOM);
		}

		if ( ch->pcdata->confirm_delete == TRUE )
	            ch->pcdata->confirm_delete = FALSE;
	        
	        if (IS_SET( ch->comm2, COMM_AUTO_AFK ) )  
	            REMOVE_BIT( ch->comm2, COMM_AUTO_AFK );  


		break;
/***************************************************************************************************/
		}

    return;
}


void send_creation_menu(CHAR_DATA *ch)
{	printf_to_char(ch, "{cWelcome to the {WAl'haen{c creation menu, %s{x\n\r", ch->name);
	send_to_char("{D==================================={x\n\r",ch);
	printf_to_char(ch,"{cA:{w Race Selection      -{D %s{x\n\r", ch->pcdata->creation[CHOSE_RACE] == TRUE ? pc_race_table[ch->race].name : "Not Chosen" );
	printf_to_char(ch,"{cB:{w Class Selection     -{D %s{x\n\r", ch->pcdata->creation[CHOSE_CLASS] == TRUE ? class_table[ch->clss].name : "Not Chosen" );
	printf_to_char(ch,"{cC:{w Gender Selection    -{D %s{x\n\r", ch->pcdata->creation[CHOSE_GENDER] == TRUE ? sex_table[ch->sex].name : "Not Chosen" );
	printf_to_char(ch,"{cD:{w Hometown Selection  -{D %s{x\n\r", ch->pcdata->creation[CHOSE_HOMETOWN] == TRUE ? hometown_table[ch->hometown].name : "Not Chosen");
	printf_to_char(ch,"{cE:{w Diety Selection     -{D %s{x\n\r", ch->pcdata->creation[CHOSE_GOD] == TRUE ? "Set" : "Not Chosen" );
	printf_to_char(ch,"{cF:{w Short Description   -{D %s{x\n\r", ch->pcdata->creation[CHOSE_SHORT] == TRUE ? ch->short_descr : "Not Chosen" );
	printf_to_char(ch,"{cG:{w Attribute Selection -{D %s{x\n\r", ch->pcdata->creation[CHOSE_ATTRIBUTES] == TRUE ? "Set" : "Not Chosen" );
    printf_to_char(ch,"{cH:{w E-Mail Address      -{D %s{x\n\r", email_lookup(ch->name) == NULL ? "Not Set" : ch->pcdata->email );
         send_to_char("{cI:{w Done",ch);
	send_to_char("\n\r{cPlease make a selection based off the corresponding letter.\n\r{CEnter selection{D->{x ",ch);
	return;
}

void send_race_list(CHAR_DATA *ch)
{	int race;
	int wrap = 0;
	int counter = 1;

	for(race = 1; race <= MAX_PC_RACE ; race++ )
	{	if (!race_table[race].pc_race || race_table[race].imm_only)
			break;
		printf_to_char(ch, "{c%2d:{x %-15s", counter, race_table[race].name,0);

		if(!(++wrap % 3) )	send_to_char("\n\r",ch);
		counter++;
		
	}
	send_to_char("\n\r\n\r",ch);
}

void send_class_list(CHAR_DATA *ch)
{	int iClass;
	int wrap = 0;
	int counter = 1;
	
	for ( iClass = 0; iClass < MAX_CLASS; iClass++ )
	{	printf_to_char(ch, " {c%-2d:{x %-15s ", counter, class_table[iClass].name );

		if(!(++wrap % 3))	send_to_char("\n\r",ch);
		counter++;
	}
}
