/*
 * Aalyreth MUD Server is copyright (c) 2000-2003 by Anthony Goins
 * and Anthony Dudas.  All rights reserved.
 *
 * By using any portion of this code including design or any
 * piece(whole or portion) of this base you are bound by the
 * license found in ../doc/License.txt.
 *
 * Information on getting a commercial license is found in
 * ../doc/Commercial_License.txt.
 *
 * Comments, suggestions and flames should be sent to
 * scapegoat@messiah.ath.cx
 *
 * This file is the main OLC module.
 */

 /* This file was taken from Aalyreth MUD Server, and modified by Davion */

#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include "include.h"

void HandleEditor(CHAR_DATA *ch, char *arg)
{	int Ed;
	
	// Forgot. we gotta can those extra spaces sent by something or other... or I'm wrong and no one will ever read this.
	while(isspace(*arg) ) arg++;

	if( ( Ed = GetEdByState(ch->desc->OLC_state) ) == -1 )
	{	PrintOLCMenu(ch);
		ch->desc->OLC_state = STATE_OLC_MENU;    
		return;
	}
	(*olc_ed_table[Ed].editor ) (ch, arg);
}

OLC_EDITOR(EditorMenu)
{	int i;
	
	if (arg[0] == '\0')
	{	send_to_char( "What are you going to edit?\n\r", ch);
		return;
	}

	switch (arg[0])
	{	case 'X': case 'x':
			ch->desc->OLC_state = STATE_NONE;
			send_to_char("Leaving OLC mode\n\r",ch);
		    break;
	
		default:
			i = GetEdByArg(arg);
			ch->desc->OLC_state = olc_ed_table[i].state;
			(*olc_ed_table[i].menu) (ch);
			break;
	}
}

OLC_MENU(PrintOLCMenu)
{	int i;
	int col = 0;
	bool found = FALSE;
	char buf[MSL];
	char buf2[MSL];

	send_to_char( "========================================================================\n\r", ch);
	send_to_char( "[ |         Welcome to The Other Realms Online Creation System       | ]\n\r", ch);
	send_to_char( "[ |          Written by Anthony \"Daurven\" Goins of Aalyreth          | ]\n\r", ch);
	send_to_char( "[ |                Ported to SS codebase by Davion                  | ]\n\r", ch);
	send_to_char( "[ |                                                                  | ]\n\r", ch);
	send_to_char( "[ |  To select an editor, type the number of the editor you wish to  | ]\n\r", ch);
	send_to_char( "[ |  use and press enter.  To exit the editor press \"X\" to exit.     | ]\n\r", ch);
	send_to_char( "[ |          To get help type help or help <subject>.                | ]\n\r", ch);
	send_to_char( "[ |------------------------------------------------------------------| ]\n\r[ | ", ch);
	for(i = 1; olc_ed_table[i].name != NULL ; i++ )
	{	if(!olc_ed_table[i].show)
			continue;
		sprintf(buf, "    [%d] %s", i, olc_ed_table[i].name );
		sprintf(buf2, "%-30s", buf );
		send_to_char(buf2,ch);
		if(++col % 3 == 0 ) send_to_char("\n\r[ | ",ch);
		found = TRUE;
	}
	if(!found)
		send_to_char( "        We don't currently have any OLC Editors                  | ]\n\r", ch);
	if(col % 3 ) send_to_char("\n\r",ch);
	send_to_char( "[ |------------------------------------------------------------------| ]\n\r", ch);
	send_to_char( "[ | [X] Exit Editor                                                  | ]\n\r", ch);
	send_to_char( "========================================================================\n\r", ch);
	send_to_char( "\n\r\n\rWhat is your choice? ", ch);
	return;
}


int GetEdByState( int state )
{	int i;
	for( i = 0; olc_ed_table[i].name != NULL; i++ )
	{	if( olc_ed_table[i].state == state )
			return i;
	}
	return -1;
}

int GetEdByArg ( char *arg )
{	int i, x;
	
	if( is_number(arg) )
	{	i = atoi(arg);
		for(x = 0; olc_ed_table[x].name != NULL; x++ );
		if(x < i || i < 1 )
			return 0;
		return i;
	}

	for(i = 0 ; olc_ed_table[i].name != NULL ; i++ )
	{	if(LOWER(arg[0]) == LOWER(olc_ed_table[i].name[0])
		&& !str_prefix(arg, olc_ed_table[i].name ) )
			return i;
	}
		
	return 0;
}

	
const struct olc_ed_type olc_ed_table[] =
{	{ "OLC Menu",			EditorMenu,		PrintOLCMenu,		STATE_OLC_MENU,			TRUE	},
	{ NULL, NULL, 0 }
};

