/* This is for sorcerers! */

#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include "include.h"

const struct spell_type spell_table[] =
{	{	"soul steal",		10,	/*&soul_steal,*/		10	},
	{	"heal",				10, /*&heal,*/				10	},
	{	"death burst",		5,	/*&death_burst,*/		1	},
	{	"ressurect",		30, /*&ressurect,*/			50	},
	{	"demon",			30, /*&raise_demon,*/		1	},
	{	"angel",			30,	/*&raise_angel,*/		1	},
	{	"blade drain",		5,	/*&blade_drain,*/		15	},
	{	"divine protection",15, /*&divine_protection,*/	50	},
	/*				End Life/Death						*/
	{	"light spear",		10, /*&light_spear,*/		1	},
	{	"dark energy",		10, /*&dark_energy,*/		1	},
	{	"shadow",			30, /*&raise_shadow,*/		1	},
	{	"aurora beast",		30, /*&raise_aurora,*/		1	},
	{	"engulf shadow",	20,	/*&engulf_shadow,*/		50	},
	{	"light flair",		20, /*&light_flair,*/		50	},
	/*				End Light/Darkness					*/
	{	"flame blast",		10, /*&flame_blast,*/		10	},
	{	"fire shield",		15, /*&fire_shield,*/		20	},
	{	"flame beast",		30, /*&riase_flame,*/		1	},
	{	"frost blast",		10, /*&frost_blast,*/		10	},
	{	"flame blade",		15,	/*&flame_blade,*/		20	},
	{	"frost blade",		15, /*&frost_blade,*/		20	},
	/*				End Flame							*/	
	{	"water spike",		10, /*&water_spike,*/		1	},
	{	"water shield",		15, /*&water_shield,*/		15	},
	{	"bubble",			30, /*&bubble,*/			20	},
	{	"typhloyd",			30,	/*&raise_typhloyd,*/	1	},
	{	"brittalize",		40, /*&brittalize,*/		50	},
	/*				End Water							*/
	{	"fly",				15, /*&fly,*/				10	},
	{	"lightning",		10, /*&lightning,*/			1	},
	{	"syphloyd",			30, /*&raise_syphloyd,*/	1	},
	{	"electric blade",	15, /*&electric_blade,*/	20	},
	{	"air cyclone",		20, /*&air_cyclone,*/		50	},
	/*				End Air								*/
	{	"earthquake",		20, /*&earthquake,*/		20	},
	{	"rock blast",		10, /*&rock_blast,*/		10	},
	{	"material skin",	15, /*&material_skin,*/		15	},
	{	"golem",			30, /*&raise_golem,*/		1	},
	{	"crystal rain",		15, /*&crystal_rain,*/		50	},
	/*				End Earth							*/
	{	NULL,				 0,	/*NULL,*/				0	}
};
/* Ok. Power is how powerful the spell. When I unlazify myself
   and put in charging, 1 will be fully charged, it'll do something
   like 2500 damage, asuming max roll, and the higher, the weaker. */
int calc_damage( CHAR_DATA *ch, OBJ_DATA *crystal, int power )
{	int cLvl = ch->level;
	int calc;
	USE *use;
	if(power == 0)
		power = 1;
	use = get_obj_use(crystal, UTYPE_CRYSTAL);
	calc = dice(cLvl, cLvl/power);
	if(calc < 0 )
		calc = 0;
	calc = calc/power;
	calc += (ch->pcdata->nature[use->value[0]]/power);
	return calc;
}


bool check_mana_pool( OBJ_DATA *crystal, int amount )
{	USE *use;
	if( !(use = get_obj_use(crystal, UTYPE_CRYSTAL) ) )
		return FALSE;
	
	if( use->value[2] < amount )
		return FALSE;
	return TRUE;
}

void drain_pool( OBJ_DATA *crystal, int amount )
{	USE *use;
	if( ! (use = get_obj_use(crystal, UTYPE_CRYSTAL) ) )
		return;

	use->value[2] -= amount;
	return;
}

int spell_lookup( const char *name )
{	int i;
	
	for( i = 0; spell_table[i].name != NULL ; i++ )
		if(!str_prefix(name, spell_table[i].name ) )
			return i;
	return -1;
}

int get_spell( const char *name, int sorc )
{	int i;
	for( i = 0 ; i < MAX_SORC_SPELL ; i++ )
	{	if(!str_prefix(name, sorcerer_table[sorc].spell[i]) )
			return i;
	}
	return -1;
}

int get_sorcerer( const char *name, int crystal )
{	int i;

	if(name && crystal  )
		bug("get_sorcerer: name && crystal",0);
	if(name)
	{	for( i = 0; sorcerer_table[i].name != NULL ; i++ )
			if(!str_prefix(name, sorcerer_table[i].name ) )
				return i;
		return -1;
	}

	for( i = 0; sorcerer_table[i].name != NULL ; i++ )
	{	if(sorcerer_table[i].crystal == crystal )
			return i;
	}
	return -1;
}
void do_embed(CHAR_DATA *ch, char *argument )
{	OBJ_DATA *crystal;
	OBJ_DATA *staff;
	char arg[MSL], arg2[MSL];
	USE *cUse;
	USE *sUse;

	argument = one_argument(argument, arg);
	argument = one_argument(argument, arg2);
	if(arg2[0] != '\0' && !str_cmp(arg2, "in") )
		argument = one_argument(argument,arg2);
	
	if(arg[0] == '\0' || arg2[0] == '\0' )
	{	send_to_char("Syntax: embed <crystal> [in] <staff>\n\r",ch);
		return;
	}

	if( !( crystal = get_obj_carry(ch, arg, ch) ) )
	{	send_to_char("You don't have that crystal.\n\r",ch);
		return;
	}

	if( !( staff = get_obj_carry(ch, arg2, ch) ) )
	{	send_to_char("You don't have that staff.\n\r",ch);
		return;
	}

	if( !(cUse = get_obj_use(crystal, UTYPE_CRYSTAL ) ) )
	{	if(crystal->use_list)
			send_to_char("That isn't a crystal.\n\r",ch);
		send_to_char(crystal->short_descr,ch);
		return;
	}
	
	if( !(sUse = get_obj_use(staff, UTYPE_WEAPON) ) || sUse->value[0] != WEAPON_STAFF  )
	{	send_to_char("That isn't a staff.\n\r",ch);
		return;
	}

	if(staff->embedded )
	{	send_to_char("There is already something embedded in this staff.\n\r",ch);
		return;
	}

	printf_to_char(ch, "You hold %s in your right hand, and %s in your left and stare at the two, concentrating your power.\n\r", crystal->short_descr, staff->short_descr);
	etc(ch, 2, "You begin to bring the two together as it crackles like splintering bone.\n\r");
	etc(ch, 4, "They connect for the first time. At the point of contact, an aura burns a deep red.\n\r");
	etc(ch, 6, "They begin to meld together, and burn into one another. The %s is now embedded in %s.\n\r", crystal->short_descr, staff->short_descr);
	staff->embedded = crystal;
	obj_from_char(crystal);
	return;
}

void do_cast(CHAR_DATA *ch, char *argument )
{	OBJ_DATA *staff;
	char spell[MSL];
	int i;
	int sn;
	USE *use;

	argument = one_argument(argument,spell);
	
	if(spell[0] == '\0' )
	{	send_to_char("What spell would you like to cast?\n\r",ch);
		return;
	}

	if( !( staff = get_eq_char(ch, WEAR_WIELD ) ) )
	{	send_to_char("You need a staff to cast spells.\n\r",ch);
		return;
	}
	if( !( use = get_obj_use(staff, UTYPE_WEAPON ) ) || use->value[0] != WEAPON_STAFF)
	{	send_to_char("You must be wielding a staff to cast spells.\n\r",ch);
		return;
	}
	if(!staff->embedded )
	{	send_to_char("You don't have a crystal! What do you expect to cast?\n\r",ch);
		return;
	}
	if( !( use = get_obj_use(staff->embedded, UTYPE_CRYSTAL ) ) )
	{	send_to_char("Seems the crystal in your staff isn't.. a... crystal... IMMORTAL!!!!\n\r",ch);
		return;
	}

	if( ( i = get_sorcerer( NULL, use->value[0] ) ) == -1)
	{	send_to_char("This crystal isn't set to a sorcerer type. Tell an Immortal.\n\r",ch);
		return;
	}

	if( ( get_spell(spell, i) ) == -1 )
	{	send_to_char("You can't cast that!\n\r",ch);
		return;
	}

	if( ( sn = spell_lookup( spell ) ) == -1 )
	{	send_to_char("... Tell an immortal. Just do it! DO IT!\n\r",ch);
		return;
	}

	if( !check_mana_pool(staff->embedded, spell_table[sn].mana) )
	{	send_to_char("You lack the mana in your pool to cast.\n\r",ch);
		return;
	}
	drain_pool(staff->embedded, spell_table[sn].mana);
	//(*spell_table[sn].spell)(ch, argument);
	send_to_char("Spell cast.\n\r",ch);
	return;
}

void do_recharge( CHAR_DATA *ch, char *argument )
{	OBJ_DATA *staff;
	USE *use;
	
	if( !( staff = get_eq_char(ch, WEAR_WIELD ) ) )
	{	send_to_char("You don't have a staff to charge.\n\r",ch);
		return;
	}
	if( !( use = get_obj_use(staff, UTYPE_WEAPON ) ) || use->value[0] != WEAPON_STAFF)
	{	send_to_char("You must be wielding a staff to charge.\n\r",ch);
		return;
	}

	if(!staff->embedded)
	{	send_to_char("There is nothing embedded into this staff to charge.\n\r",ch);
		return;
	}

	if( !(use = get_obj_use(staff->embedded, UTYPE_CRYSTAL ) ) )
	{	send_to_char("Find the nearest Immortal, and complain.\n\r",ch);
		return;
	}

	printf_to_char(ch, "You begin to charge %s.\n\r", staff->embedded->short_descr);
	event_to_char(ch, END_CHAR, (void *) staff->embedded, 0, EVENT_CHARGE, 1 );
	return;
}

int calc_hit( CHAR_DATA *pMob, int endour )
{	int calc[3] = { 0, 0, 0 };
	int hp;
	
	calc[DICE_NUMBER] = pMob->level/endour * pMob->level/endour;
	calc[DICE_TYPE]   = pMob->level/endour * pMob->level/endour;
	calc[DICE_BONUS]  = 100 / endour + endour;
	hp = dice( calc[DICE_NUMBER], calc[DICE_TYPE] ) + calc[DICE_BONUS];
	return hp;
}

void calc_dam( CHAR_DATA *pMob, int power )
{	int calc[3] = { 0, 0, 0 };

	calc[DICE_NUMBER] = (int)(pMob->level / ( (float)power + 0.5 ));
	calc[DICE_TYPE]   = pMob->level / ( power/2 );
	calc[DICE_BONUS]  = pMob->level / 2;

	pMob->damroll = calc[DICE_BONUS];
	pMob->damage[DICE_NUMBER]  = calc[DICE_NUMBER];
	pMob->damage[DICE_TYPE]	   = calc[DICE_TYPE];
	pMob->hitroll = pMob->level;
	return;
}


void soul_steal( CHAR_DATA *ch, char *argument )
{	CHAR_DATA *victim;
	char arg[MSL];

	argument = one_argument(argument, arg);

	if( arg[0] == '\0' )
	{	send_to_char("Who would you like to cast this againts?\n\r",ch);
		return;
	}

	if( !(victim = get_char_room(ch, NULL, arg) ) )
	{	send_to_char("Your desired target isn't present.\n\r",ch);
		return;
	}
	
	send_to_char("You begin to draw on the power of the Jet stones darker power of death.\n\r",ch);
	etc(ch, 2, "Darkness forms around the glimmering stone, a tornado of swirls encompass the tip of the staff.\n\r");
	etc(ch, 4, "The power of the Jet Stone draws from %s and fills you with life.\n\r", PERS(victim, ch) );
	event_to_char(ch, "soul steal", (void *) victim, DAM_DEATH, EVENT_SPELLDAM, 4 );
}

void heal(CHAR_DATA *ch, char *argument )
{	CHAR_DATA *victim;
	char arg[MSL];

	argument = one_argument(argument,arg);

	if(arg[0] == '\0' || !str_cmp(arg, "self") )
		victim = ch;
	else
		if(!(victim = get_char_room(ch, NULL, arg) ) )
		{	send_to_char("They arn't here.\n\r",ch);
			return;
		}
	
	send_to_char("As you draw on the energies of the Jet stone's powers of life, you glow a soft yellow.\n\r",ch);
	etc(ch, 2, "The aura spreads throughout your body.\n\r",ch);
	if(victim != ch)
		etc(ch, 4, "The aura encompasses %s and begins its mending properties.\n\r", PERS(victim, ch) );
	else
		etc(ch, 4, "The aura burns warms your soul and begins its mending properties.\n\r");
	event_to_char(ch, "heal", (void *) victim, DAM_LIFE, EVENT_SPELLDAM, 4 );
	return;
}

void death_burst( CHAR_DATA *ch, char *argument )
{	CHAR_DATA *victim;
	char arg[MSL];

	argument = one_argument(argument, arg);

	if( arg[0] == '\0' )
	{	send_to_char("Who would you like to cast this againts?\n\r",ch);
		return;
	}

	if( !(victim = get_char_room(ch, NULL, arg) ) )
	{	send_to_char("Your desired target isn't present.\n\r",ch);
		return;
	}
	
	send_to_char("Darkness shrouds your staff, as the shadow of a skull apears on the tip.\n\r",ch);
	etc(ch,1, "The shadow soon begins to glow with an incandescent green aura\n\r");
	etc(ch,2, "It fires off at %s, cackling maliciously while in flight!\n\r", PERS(victim,ch));
	event_to_char(ch, "death burst", (void *) victim, DAM_DEATH, EVENT_SPELLDAM, 2 );
	return;
}


/* Ok. Alittle about power. 
			15 == Weak
			10 == Descent
			5  == Very strong
	And Endour
			20 == Wont last long
			15 == last descently ;)
			10 == IMMORTAL!
 */
CHAR_DATA * gen_beast( CHAR_DATA *ch, OBJ_DATA *crystal, int vnum, int power, int endour )
{	CHAR_DATA *beast;

	if( (beast = create_mobile( get_mob_index(vnum) ) ) )
	{	beast->level = ch->level;
		beast->max_hit = calc_hit(beast, endour );
		beast->hit = beast->max_hit;
		calc_dam(beast, power);
		return beast;
	}
	return NULL;
}
void raise_demon(CHAR_DATA *ch, char *argument )
{	CHAR_DATA *demon;
	OBJ_DATA *staff;
	staff = get_eq_char(ch, WEAR_WIELD);
	demon = gen_beast(ch, staff->embedded, MOB_VNUM_DEMON, 8, 18 );
	printf_to_char(ch, "You concentrate on your crystal, feeling its power run through your body.\n\r",ch);
	etc(ch, 3, "The power of the Jet stone amplifys greatly, causing the room to dim.\n\r");
	etc(ch, 5, "A short distance in front of you, shadows begin to congregate, as a low rumble fills your ears.");
	etc(ch, 6, "%s shoots up from the ground, and stands infront of you ready to serve you.\n\r", demon->short_descr);
	event_to_char(ch, END_CHAR, (void *) demon, 0, EVENT_GENBEAST, 6);
	return;
}
void raise_angel(CHAR_DATA *ch, char *argument )
{	CHAR_DATA *demon;
	OBJ_DATA *staff;
	staff = get_eq_char(ch, WEAR_WIELD);
	demon = gen_beast(ch, staff->embedded, MOB_VNUM_ANGEL, 12, 13 );
	printf_to_char(ch, "You concentrate on your crystal, feeling its power run through your body.\n\r",ch);
	etc(ch, 3, "The power of the Jet stone amplifys greatly, causing the room to glow.\n\r");
	etc(ch, 5, "A short distance in front of you, aura's begin to congregate, as a low rumble fills your ears.");
	etc(ch, 6, "%s shoots up from the ground, and stands infront of you ready to serve you.\n\r", demon->short_descr);
	event_to_char(ch, END_CHAR, (void *) demon, 0, EVENT_GENBEAST, 6);
	return;
}
void raise_flame(CHAR_DATA *ch, char *argument )
{	CHAR_DATA *demon;
	OBJ_DATA *staff;
	staff = get_eq_char(ch, WEAR_WIELD);
	demon = gen_beast(ch, staff->embedded, MOB_VNUM_FBEAST, 10, 15 );
	printf_to_char(ch, "You concentrate on your crystal, feeling its power run through your body.\n\r",ch);
	etc(ch, 3, "The bloodstone causes your fluids to boil, as you begin to grow a flaming aura.\n\r");
	etc(ch, 5, "You concentrate on a spot infront of you, as small flickers of flames gather around the spot.\n\r");
	etc(ch, 6, "%s shoots up from the ground, and stands infront of you ready to serve you.\n\r", demon->short_descr);
	event_to_char(ch, END_CHAR, (void *) demon, 0, EVENT_GENBEAST, 6);
	return;
}
void raise_syphloyd(CHAR_DATA *ch, char *argument )
{	CHAR_DATA *demon;
	OBJ_DATA *staff;
	staff = get_eq_char(ch, WEAR_WIELD);
	demon = gen_beast(ch, staff->embedded, MOB_VNUM_SYPHLOYD, 14, 13 );
	printf_to_char(ch, "You concentrate on your crystal, feeling its power run through your body.\n\r",ch);
	etc(ch, 3, "The power of the Amethyst raises you a short distance into the air, your eyes pale\n\r");
	etc(ch, 5, "The tornado around you begin to focus itselves into one point.\n\r");
	etc(ch, 6, "%s shoots out of the tornado as it fades, and stands infront of you ready to serve you.\n\r", demon->short_descr);
	event_to_char(ch, END_CHAR, (void *) demon, 0, EVENT_GENBEAST, 6);
	return;
}

void raise_typhloyd(CHAR_DATA *ch, char *argument )
{	CHAR_DATA *demon;
	OBJ_DATA *staff;
	staff = get_eq_char(ch, WEAR_WIELD);
	demon = gen_beast(ch, staff->embedded, MOB_VNUM_TYPHLOYD, 10, 19 );
	printf_to_char(ch, "You concentrate on your crystal, feeling its power run through your body.\n\r",ch);
	etc(ch, 3, "The power of the Jet stone amplifys greatly, causing the room to dim.\n\r");
	etc(ch, 5, "A short distance in front of you, shadows begin to congregate, as a low rumble fills your ears.");
	etc(ch, 6, "%s shoots up from the ground, and stands infront of you ready to serve you.\n\r", demon->short_descr);
	event_to_char(ch, END_CHAR, (void *) demon, 0, EVENT_GENBEAST, 6);
	return;
}

/* These will need a major overhaul once materials are all figured out */
void raise_golem(CHAR_DATA *ch, char *argument )
{	CHAR_DATA *demon;
	OBJ_DATA *staff;
	staff = get_eq_char(ch, WEAR_WIELD);
	demon = gen_beast(ch, staff->embedded, MOB_VNUM_GOLEM, 7, 19 );
	printf_to_char(ch, "You concentrate on your crystal, feeling its power run through your body.\n\r",ch);
	etc(ch, 3, "The power of the quartz stone amplifys greatly, causing the room to shake.\n\r");
	etc(ch, 5, "The shaking lowers, and the ground infront of you cracks, and opens.");
	etc(ch, 6, "%s shoots up from the ground as it seals up, and stands infront of you ready to serve you.\n\r", demon->short_descr);
	event_to_char(ch, END_CHAR, (void *) demon, 0, EVENT_GENBEAST, 6);
	return;
}
void raise_shadow(CHAR_DATA *ch, char *argument )
{	CHAR_DATA *demon;
	OBJ_DATA *staff;
	staff = get_eq_char(ch, WEAR_WIELD);
	demon = gen_beast(ch, staff->embedded, MOB_VNUM_SHADOW, 5, 20 );
	printf_to_char(ch, "You concentrate on your crystal, feeling its power run through your body.\n\r",ch);
	etc(ch, 3, "The power of the Carnelian stone amplifys greatly, causing the room to dim.\n\r");
	etc(ch, 5, "A short distance in front of you, shadows begin to congregate, as a low rumble fills your ears.");
	etc(ch, 6, "%s shoots up from the ground, and stands infront of you ready to serve you.\n\r", demon->short_descr);
	event_to_char(ch, END_CHAR, (void *) demon, 0, EVENT_GENBEAST, 6);
	return;
}
void raise_aurora(CHAR_DATA *ch, char *argument )
{	CHAR_DATA *demon;
	OBJ_DATA *staff;
	staff = get_eq_char(ch, WEAR_WIELD);
	demon = gen_beast(ch, staff->embedded, MOB_VNUM_AURORA, 15, 10 );
	printf_to_char(ch, "You concentrate on your crystal, feeling its power run through your body.\n\r",ch);
	etc(ch, 3, "The power of the Carnelian stone amplifys greatly, causing the room to glow.\n\r");
	etc(ch, 5, "A short distance in front of you, an aurora begin to grow, as a low rumble fills your ears.");
	etc(ch, 6, "%s shoots up from the ground, and stands infront of you ready to serve you.\n\r", demon->short_descr);
	event_to_char(ch, END_CHAR, (void *) demon, 0, EVENT_GENBEAST, 6);
	return;
}
