/* Var saver functions. And tables saver. */

#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include "include.h"

/**********************************************************
 * Variable saving functions. Called by save_table()      *
 **********************************************************/
VAR_SAVER( save_ints )
{	if(!save)
	{	logf2("BUG: save_ints: save NULL" );
		return;
	}

	fprintf(fp, "%s %d\n", save_table[spot].name, **( int **) save );
	return;
}

VAR_SAVER( save_string )
{	if(!save)
	{	logf2("BUG: save_string: save NULL" );
		return;
	}

	fprintf(fp, "%s %s~\n", save_table[spot].name, *( char **) save );
	return;
}

VAR_SAVER( save_str_array )
{	int i;
	char **array;

	array = (char **) save;	
	
	if(!max || max <= 0 )
	{	logf2("BUG: save_str_array: max null or > 0" );
		return;
	}
	if(!save)
	{	logf2("BUG: save_str_array: save NULL" );
		return;
	}

	fprintf( fp, "%s\n", save_table[spot].name );
	for( i = 0; i < max ; i++ )
		fprintf(fp, "%s~\n", array[i] );
	return;
}

VAR_SAVER( save_int_array )
{	int i;
	int **array;

	array = (int **) save;

	if(!max || max <= 0 )
	{	logf2("BUG: save_int_array: max null or > 0" );
		return;
	}
	if(!save)
	{	logf2("BUG: save_int_array: save NULL" );
		return;
	}
	
	fprintf( fp, "%s\n", save_table[spot].name );
	for( i = 0; i < max ; i++ )
		fprintf(fp, "%d\n", *array[i] );
	return;
}

VAR_SAVER( save_bits )
{	char buf[MSL];

	if(!max || max <= 0 )
	{	logf2("BUG: save_int_array: max null or > 0" );
		return;
	}
	if(!save)
	{	logf2("BUG: save_int_array: save NULL" );
		return;
	}
	
	fprintf(fp, "%s %s\n", save_table[spot].name, fwrite_flag(*(int *) save, buf));
	return;
}

int find_save_fun( int type )
{	int i;
	for( i = 0; varfun_table[i].type != -1 ; i++ )
	{	if( varfun_table[i].type == type )
			return i;
	}
	return -1;
}

/**********************************************************
 * Variable loading functions. Called by load_table()     *
 **********************************************************/
VAR_LOADER( load_string )
{	SREAD( *(char **) save );
	return;
}

VAR_LOADER( load_ints )
{	**( int ** ) save = fread_number(fp);
	return;
}

VAR_LOADER( load_str_array )
{	int i;
	char **array;

	array = (char **) save;	

	for( i = 0 ; i < max ; i++ )
		SREAD( array[i] );
	return;
}

VAR_LOADER( load_int_array )
{	int i;
	int **array;

	for( i = 0; i < max ; i++ )
		*array[i] = fread_number(fp);
	save = (int **) realloc(array, sizeof(int) * max);
	return;
}

VAR_LOADER( load_bits )
{	save = (int *)fread_flag( fp );
	return;
}


/**********************************************************
 *Runs the saving of structures calls all var saver functs*
 **********************************************************/

void save_table(const struct save_type *save_table, FILE *fp )
{	int i;
	int type;

	for( i = 0; save_table[i].name != NULL ; i++ )
	{	if( ( type = find_save_fun(save_table[i].type ) ) == -1 )
		{	logf2("BUG: save_table: type == -1" );
			continue;
		}

		( *varfun_table[type].sCmd ) (fp, save_table[i].field, save_table, i, save_table[i].max );
	}

	fprintf(fp, "%s\n\n", END_CHAR );
	return;
}

/**********************************************************
 *Runs the loading of structures calls all var load functs*
 **********************************************************/

void load_table(const struct save_type *save_table, FILE *fp)
{	int i;
	int type;
	char *word;
	bool found;

	for(word = fread_word(fp); strcasecmp(word, END_CHAR) ; word = fread_word(fp) )
	{	found = FALSE;
		for( i = 0; save_table[i].name != NULL ; i++ )
		{	if(!strcasecmp(word, save_table[i].name) )
			{	found = TRUE;
				
				if( ( type = find_save_fun(save_table[i].type ) ) == -1 )
				{	logf2("BUG: save_table: type == -1" );
					exit(1);
				}
				
				( *varfun_table[type].lCmd) ( fp, save_table[i].field, save_table, i, save_table[i].max );
				break;
			}
		}
		if(!found)
		{	logf2("BUG: load_table: word not found. '%s'", word );
			fread_to_eol( fp );
		}
	}
}
