/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik Stfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

/***************************************************************************
*	ROM 2.4 is copyright 1993-1998 Russ Taylor			   *
*	ROM has been brought to you by the ROM consortium		   *
*	    Russ Taylor (rtaylor@hypercube.org)				   *
*	    Gabrielle Taylor (gtaylor@hypercube.org)			   *
*	    Brian Moore (zump@rom.org)					   *
*	By using this code, you have agreed to follow the terms of the	   *
*	ROM license, in the file Rom24/doc/rom.license			   *
***************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>
#include <ctype.h>
#include "include.h"

/*
 * Local functions.
 */
int	hit_gain	args( ( CHAR_DATA *ch ) );
int	mana_gain	args( ( CHAR_DATA *ch ) );
int	move_gain	args( ( CHAR_DATA *ch ) );
void	mobile_update	args( ( void ) );
void	weather_update	args( ( void ) );
void	char_update	args( ( void ) );
void	obj_update	args( ( void ) );
void	aggr_update	args( ( void ) );
void    quest_update    args( ( void ) );
bool    in_donation_room args( (OBJ_DATA *obj) );    
void    room_aff_update args( ( ROOM_INDEX_DATA *room ) );
void	newbie_update	args( ( void ) );
void    quest_update    args( ( void ) ); 
void    gquest_update   args( ( void ) );
void    olcautosave     args( ( void ) );
void    save_area       args( ( AREA_DATA *pArea ) );      
void    save_area_list  args( ( void ) );
void    gain_self_exp   args( ( CHAR_DATA *ch, int gain ) );
void    gain_bloodthirst args( ( CHAR_DATA *ch, int value ) );
void    check_werewolf  args( ( ) );
void    gain_object_exp args( ( CHAR_DATA *ch, OBJ_DATA *obj, int gain ) );
void    advance_level_object args( ( CHAR_DATA *ch, OBJ_DATA *obj ) );
int     mortal_online   args( ( CHAR_DATA *ch) );


/* used for saving */

int	save_number = 0;


int     global_exp;
sh_int  display;

/*
 * Advancement stuff.
 */
void advance_level( CHAR_DATA *ch, bool hide )
{
    char buf[MAX_STRING_LENGTH];
    int add_hp;
    int add_mana;
    int add_move;
    int add_prac;
    int hpbonus, movebonus, manabonus;
    MEMBER_DATA *pMem;
	
    ch->pcdata->share_level = ch->level;
    ch->pcdata->shares_bought = 0;

    hpbonus = ( ch->levelflux * 7 );
    manabonus = ( ch->levelflux * 7 );
    movebonus = ( ch->levelflux * 2 );

    ch->pcdata->last_level = 
	( ch->played + (int) (current_time - ch->logon) ) / 3600;

    add_hp    = con_app[get_curr_stat(ch,STAT_CON)].hitp + get_hp_gain(ch);
    add_mana 	= number_range(2,(2*get_curr_stat(ch,STAT_INT)
				  + get_curr_stat(ch,STAT_WIS))/5);
    if (!has_spells(ch)) 
	add_mana /= 2;
    add_move	= number_range( 1, (get_curr_stat(ch,STAT_CON)
				  + get_curr_stat(ch,STAT_DEX))/6 );
    add_prac	= wis_app[get_curr_stat(ch,STAT_WIS)].practice;

    add_hp = (add_hp * 9/10) + hpbonus;
    add_mana = (add_mana * 9/10) + manabonus;
    add_move = (add_move * 9/10) + movebonus;

    add_hp	= UMAX(  2, add_hp   );
    add_mana	= UMAX(  2, add_mana );
    add_move	= UMAX(  6, add_move );

    ch->max_hit 	+= add_hp;
    ch->max_mana	+= add_mana;
    ch->max_move	+= add_move;
    ch->practice	+= add_prac;
    ch->train		+= 1;
    ch->pcdata->perm_hit	+= add_hp;
    ch->pcdata->perm_mana	+= add_mana;
    ch->pcdata->perm_move	+= add_move;

    if (!hide)
    {
    	sprintf(buf,
	    "You gain %d hit point%s, %d mana, %d move, and %d practice%s.\n\r",
	    add_hp, add_hp == 1 ? "" : "s", add_mana, add_move,
	    add_prac, add_prac == 1 ? "" : "s");
	send_to_char( buf, ch );
    }

    if( is_clan(ch) )
    {
	if( (pMem = member_lookup(&clan_table[ch->clan], ch->name) ) != NULL )
	    pMem->level = ch->level;
    }
 
    return;
}   



void gain_exp( CHAR_DATA *ch, int gain )
{
    char buf[MAX_STRING_LENGTH];

    if ( IS_NPC(ch) || ch->level >= LEVEL_HERO || IS_WEREWOLF(ch))
	return;

    if (!IS_SET( ch->comm2, COMM_AUTOLEVEL ) )
    {
        gain_self_exp( ch, gain );    
        return;
    }

    if (IS_SET( ch->comm2, COMM_PETLEVEL ) && ch->pet != NULL )  
    {
        pet_gain_exp( ch->pet, gain );
	gain /= 2; // Pet got half of it. ;)
    }    

    ch->exp = UMAX( exp_per_level(ch,ch->pcdata->points), ch->exp + gain );
    
	while ( exp_to_level(ch) <= 0 )
    {
	send_to_char( "You raise a level!!  ", ch );
	ch->level += 1;
        if ( !IS_NPC(ch) && ch->pcdata->bcount++ == 10  ) 
        {
            ch->pcdata->bcount = 0;
            ch->pcdata->bless++;       
            printf_to_char( ch, "You have gained a blessing point!\n\r"  );
        }
	sprintf(buf,"%s gained level %d",ch->name,ch->level);
	log_string(buf);
	sprintf(buf,"$N has attained level %d!",ch->level);
	wiznet(buf,ch,NULL,WIZ_LEVELS,0,0);
	advance_level(ch,FALSE);
        info( ch, 0, "[INFO]: %s has just attained level %d!\n\r", ch->name, ch->level );
        affect_strip(ch,skill_lookup("plague"));
        affect_strip(ch,skill_lookup("poison"));
        affect_strip(ch,skill_lookup("blindness"));
        affect_strip(ch,skill_lookup("sleep"));
        affect_strip(ch,skill_lookup("curse"));

        ch->hit        = ch->max_hit;
        ch->mana       = ch->max_mana;
        ch->move       = ch->max_move;
        update_pos( ch);
        send_to_char( "[INFO]: Synon has given you the power to continue!\n\r", ch );
        save_char_obj(ch);
	}

    return;
}

void gain_self_exp( CHAR_DATA *ch, int gain )
{

    if (IS_SET( ch->comm2, COMM_PETLEVEL ) && ch->pet != NULL ) 
    {
        pet_gain_exp( ch->pet, gain );
	gain /= 2; // Pet got half of it. ;)
    }      

    if ( IS_NPC(ch) || ch->level >= LEVEL_HERO )
	return;

    if (ch->pcdata->current_exp > exp_per_level(ch,ch->pcdata->points) * 6)
    send_to_char( "You have already gained enough exp for five levels - go level up!\n\r", ch );

    else if (ch->pcdata->current_exp < exp_per_level(ch, ch->pcdata->points)) 
    {
        ch->pcdata->current_exp += gain;
 
	if ( ch->level < LEVEL_HERO && ch->pcdata->current_exp >= exp_per_level(ch, ch->pcdata->points))
	    send_to_char( "You may raise a level!! Go visit the healer and type level!!\n\r", ch );
    }
	
    else if (ch->pcdata->current_exp > exp_per_level(ch, ch->pcdata->points) * 5 && ch->pcdata->current_exp < exp_per_level(ch, ch->pcdata->points) * 6)
    {
        ch->pcdata->current_exp += gain; 
	send_to_char( "You may raise five levels!! You may not gain any more exp until you level at the healer!!\n\r", ch );
    }
        
    else
        ch->pcdata->current_exp += gain;

    return;
}   


void pet_gain_exp( CHAR_DATA *pet, int gain )
{
    char buf[MAX_STRING_LENGTH];

    if ( !IS_NPC(pet) || pet->level >= LEVEL_HERO || !IS_SET( pet->act, ACT_PET ) )
	return;

    pet->exp += gain;

    while ( pet->level < LEVEL_HERO && pet->exp >= pet->xp_tolevel )
    {
	pet->level++;
        pet->exp -= pet->xp_tolevel;
	sprintf(buf,"%s gained level %d",pet->name,pet->level);
	log_string(buf);
	sprintf(buf,"$N has attained level %d!",pet->level);
	wiznet(buf,pet,NULL,WIZ_LEVELS,0,0);
	advance_level_pet(pet,FALSE);
        affect_strip(pet,skill_lookup("plague"));
        affect_strip(pet,skill_lookup("poison"));
        affect_strip(pet,skill_lookup("blindness"));
        affect_strip(pet,skill_lookup("sleep"));
        affect_strip(pet,skill_lookup("curse"));
        sprintf( buf, "I just gained level %d!\n\r", pet->level );
        do_say( pet, buf );
        do_say( pet, "You can use the petshow command to see what my stats are now!\n\r" );
        pet->hit       = pet->max_hit;
        pet->mana      = pet->max_mana;
        pet->move      = pet->max_move;
        update_pos( pet);
        save_char_obj(pet);
    }

    return;  
}

void gain_object_exp( CHAR_DATA *ch, OBJ_DATA *obj, int gain )
{
	int leftover = 0;

    if ( IS_NPC(ch) || obj->plevel >= MOBJLEVEL || IS_WEREWOLF(ch) )
		return;

    printf_to_char( ch, "%s has gained %d exp.\n\r", capitalize( obj->short_descr ), gain );     
    obj->exp += gain;
    obj->xp_tolevel -= gain;

	if(obj->xp_tolevel <= 0 )
	{	obj->exp += obj->xp_tolevel;
		advance_level_object(ch,obj);
		leftover = ( obj->xp_tolevel * 1 );
		obj->plevel++;
		printf_to_char( ch, "%s has raised to level %d. To see your objects stats lore or identify it.\n\r", capitalize( obj->short_descr ), obj->plevel );
		obj->xp_tolevel = 1500 + ( obj->plevel * 150 );
		obj->xp_tolevel -= leftover;
		return;
	}
	return;
}


void advance_level_pet( CHAR_DATA *pet, bool hide )
{
    char buf[MSL];
    int add_hp = number_range( 20, 40 );
    int add_mana = number_range( 15, 30 );
    int add_move = number_range( 25, 40 );
    int add_ac = number_range( 10, 25 );
    int add_prac = number_range( 5, 10 );
    int hpbonus, manabonus, movebonus;
    int i;

    hpbonus   = ( pet->levelflux * 7 );
    manabonus = ( pet->levelflux * 7 );
    movebonus = ( pet->levelflux * 2 );    

    add_hp    = ( add_hp * 9/10 ) + hpbonus;
    add_mana  = ( add_mana * 9/10 ) + manabonus;
    add_move  = ( add_move * 9/10 ) + movebonus;
    add_prac  = add_prac * 4/5;
    add_ac    = add_ac * 9/10;

    add_hp    = UMAX(  2, add_hp   );
    add_mana  = UMAX(  2, add_mana );
    add_move  = UMAX(  6, add_move );

    pet->max_hit   += add_hp;
    pet->max_mana  += add_mana;
    pet->max_move  += add_move; 
    pet->practice  += add_prac;  
    pet->train	   ++;
    pet->damroll   += number_range( 1, 2 );
    pet->hitroll   += number_range( 1, 2 );
    pet->damage[DICE_NUMBER]++;
    pet->damage[DICE_TYPE]++;
    pet->damage[DICE_BONUS] = number_range( 4, 8 );
    for ( i = 0; i < 3; i++ )
         pet->armor[i] -= add_ac;    

    if (!hide)
    {
    	sprintf(buf,
	    "I gained %d hit point%s, %d mana, and %d moves.\n\r",
	    add_hp, add_hp == 1 ? "" : "s", add_mana, add_move);
	do_say( pet, buf );
    }

    return;
}   
void add_apply(OBJ_DATA * obj, int loc, int mod, int where, int type, int dur,int vector, int level);

void advance_level_object( CHAR_DATA *ch, OBJ_DATA *obj )
{
    int pbonus = number_range( 5, 10 );
    int bonus = number_range( 4, 8 );
	USE *use;
    pbonus  = pbonus * 9/10;
    bonus =   bonus * 8/10;

    pbonus  = UMAX(  6, pbonus );
    bonus = UMAX( 1, bonus );

    add_apply(obj, APPLY_DAMROLL, pbonus, TO_OBJECT, 0, -1, 0, obj->plevel * 5);
    add_apply(obj, APPLY_HITROLL, pbonus, TO_OBJECT, 0, -1, 0, obj->plevel * 5); 
    add_apply(obj, APPLY_HIT, pbonus, TO_OBJECT, 0, -1, 0, obj->plevel * 5);
    add_apply(obj, APPLY_MANA, pbonus, TO_OBJECT, 0, -1, 0, obj->plevel * 5);
    add_apply(obj, APPLY_MOVE, pbonus, TO_OBJECT, 0, -1, 0, obj->plevel * 5);

    if ( ( use = get_obj_use(obj, UTYPE_WEAPON) ) )
    {
        use->value[1] += bonus/4;
        use->value[2] += bonus/5;
    } 

    else if ( ( use = get_obj_use(obj, UTYPE_ARMOR) ) )
    {
        use->value[0] -= UMAX(1, obj->plevel);
        use->value[1] -= UMAX(1, obj->plevel);
        use->value[2] -= UMAX(1, obj->plevel);
        use->value[3] -= (5 * UMAX(1, obj->plevel)) / 10;
    }
   
    return;
}   

/*
 * Regeneration stuff.
 */
int hit_gain( CHAR_DATA *ch )
{	USE *use;
    int gain;
    int number;

    if (IN_ROOM(ch) == NULL)
	return 0;

    if ( IS_NPC(ch) )
    {
	gain =  10 + ch->level;


	switch(ch->position)
	{
	    default : 		gain /= 2;			break;
	    case POS_SLEEPING: 	gain = 3 * gain/2;		break;
	    case POS_RESTING:  					break;
	    case POS_FIGHTING:	gain /= 3;		 	break;
 	}

	
    }
    else
    {
	gain = UMAX(3,get_curr_stat(ch,STAT_CON) - 3 + ch->level/2); 
	gain += hp_max(ch) - 10;
 	number = number_percent();
	if (number < get_skill(ch,skill_lookup("fast healing")))
	{
	    gain += number * gain / 100;
	    if (ch->hit < ch->max_hit)
		check_improve(ch,skill_lookup("fast healing"),TRUE,8);
	}

	switch ( ch->position )
	{
	    default:	   	gain /= 4;			break;
	    case POS_SLEEPING: 					break;
	    case POS_RESTING:  	gain /= 2;			break;
	    case POS_FIGHTING: 	gain /= 6;			break;
	}

	if ( ch->pcdata->condition[COND_HUNGER]   == 0 )
	    gain /= 2;

	if ( ch->pcdata->condition[COND_THIRST] == 0 )
	    gain /= 2;
       
        if ( IN_ROOM(ch)->vnum == ch->pcdata->rentroom  && ch->silver > 0)
            gain *= 2;

        if ( IS_SET(ch->act, PLR_TENNANT) && ch->silver > 0)
            ch->silver -= 10;

        if ( ch->bloodthirst <= 0 && IS_VAMPIRE( ch ) )
		 gain = 0;

	 if ( ch->bloodthirst >= 0 && IS_VAMPIRE( ch ) && ( time_info.hour > 19 && time_info.hour < 5 ) )
		gain *= 2;
    }

    gain = gain * IN_ROOM(ch)->heal_rate / 100;
    
    gain *= 3;
    
    if (ch->on != NULL && ( use = get_obj_use(ch->on, UTYPE_FURNITURE) ) )
	gain = gain * use->value[3] / 100;

    return UMIN(gain, ch->max_hit - ch->hit);
}


int mana_gain( CHAR_DATA *ch )
{	USE *use;
    int gain;
    int number;

    if (IN_ROOM(ch) == NULL)
	return 0;

    if ( IS_NPC(ch) )
    {
	gain = 5 + ch->level;
	switch (ch->position)
	{
	    default:		gain /= 2;		break;
	    case POS_SLEEPING:	gain = 3 * gain/2;	break;
   	    case POS_RESTING:				break;
	    case POS_FIGHTING:	gain /= 3;		break;
    	}
    }
    else
    {
	gain = (get_curr_stat(ch,STAT_WIS) 
	      + get_curr_stat(ch,STAT_INT) + ch->level) / 2;
	number = number_percent();
	if (number < get_skill(ch,skill_lookup("meditation")))
	{
	    gain += number * gain / 100;
	    if (ch->mana < ch->max_mana)
	        check_improve(ch,skill_lookup("meditation"),TRUE,8);
	}

	if (!has_spells(ch))
	    gain /= 2;

	switch ( ch->position )
	{
	    default:		gain /= 4;			break;
	    case POS_SLEEPING: 					break;
	    case POS_RESTING:	gain /= 2;			break;
	    case POS_FIGHTING:	gain /= 6;			break;
	}

	if ( ch->pcdata->condition[COND_HUNGER]   == 0 )
	    gain /= 2;

	if ( ch->pcdata->condition[COND_THIRST] == 0 )
	    gain /= 2;
        if ( ch->bloodthirst <= 0 && IS_VAMPIRE( ch ) )
                 gain = 0;

         if ( ch->bloodthirst >= 0 && IS_VAMPIRE( ch ) && ( time_info.hour > 19 && time_info.hour < 5 ) )
                gain *= 2;

    }

    gain = gain * IN_ROOM(ch)->mana_rate / 100;

    gain *= 3;

    if (ch->on != NULL && ( use = get_obj_use(ch->on, UTYPE_FURNITURE) ) )
	gain = gain * use->value[4] / 100;


    return UMIN(gain, ch->max_mana - ch->mana);
}



int move_gain( CHAR_DATA *ch )
{	USE *use;
    int gain;

    if (IN_ROOM(ch) == NULL)
	return 0;

    if ( IS_NPC(ch) )
    {
	gain = ch->level;
    }

    else
    {
	gain = UMAX( 15, ch->level );

	switch ( ch->position )
	{
	case POS_SLEEPING: gain += get_curr_stat(ch,STAT_DEX);		break;
	case POS_RESTING:  gain += get_curr_stat(ch,STAT_DEX) / 2;	break;
	}

	if ( ch->pcdata->condition[COND_HUNGER]   == 0 )
	    gain /= 2;

	if ( ch->pcdata->condition[COND_THIRST] == 0 )
	    gain /= 2;

        if ( ch->bloodthirst <= 0 && IS_VAMPIRE( ch ) )
                 gain = 0;

         if ( ch->bloodthirst >= 0 && IS_VAMPIRE( ch ) && ( time_info.hour > 19 && time_info.hour < 5 ) )
                gain *= 2;

    }

    gain = gain * IN_ROOM(ch)->heal_rate/100;

    gain *= 3;

    if (ch->on != NULL && ( use = get_obj_use(ch->on, UTYPE_FURNITURE) ) )
	gain = gain * use->value[3] / 100;


    return UMIN(gain, ch->max_move - ch->move);
}



void gain_condition( CHAR_DATA *ch, int iCond, int value )
{
    int condition;

    if ( value == 0 || IS_NPC(ch) || ( ch->level >= LEVEL_HERO && iCond != COND_DRUNK ) )
	return;

    condition				= ch->pcdata->condition[iCond];

    if (condition == -1)
        return;

    ch->pcdata->condition[iCond]	= URANGE( 0, condition + value, 48 );

    if ( ch->pcdata->condition[iCond] == 0 )
    {
	switch ( iCond )
	{
	case COND_HUNGER:
	    send_to_char( "You are hungry.\n\r",  ch );
	    break;

	case COND_THIRST:
	    send_to_char( "You are thirsty.\n\r", ch );
	    break;

	case COND_DRUNK:
	    if ( condition != 0 )
		send_to_char( "You are sober.\n\r", ch );
	    break;
	}
    }

    return;
}



/*
 * Mob autonomous action.
 * This function takes 25% to 35% of ALL Merc cpu time.
 * -- Furey
 */
void mobile_update( void )
{
    CHAR_DATA *ch;
    CHAR_DATA *ch_next;
    EXIT_DATA *pexit;
    int door;

    /* Examine all mobs. */
    for ( ch = char_list; ch != NULL; ch = ch_next )
    {
	ch_next = ch->next;

	if ( !IS_NPC(ch) || IN_ROOM(ch) == NULL )
	    continue;

	if (IN_ROOM(ch)->area->empty && !IS_SET(ch->act,ACT_UPDATE_ALWAYS))
	    continue;

	/* Examine call for special procedure */
	if ( ch->spec_fun != 0 )
	{
	    if ( (*ch->spec_fun) ( ch ) )
		continue;
	}

	if (ch->pIndexData->pShop != NULL) /* give him some gold */
	    if ((ch->gold * 100 + ch->silver) < ch->pIndexData->wealth)
	    {
		ch->gold += ch->pIndexData->wealth * number_range(1,20)/5000000;
		ch->silver += ch->pIndexData->wealth * number_range(1,20)/50000;
	    }
	 
       	/*
	 * Check triggers only if mobile still in default position
	 */
	if ( ch->position == ch->pIndexData->default_pos )
	{
	    /* Delay */
	    if ( HAS_TRIGGER_MOB( ch, TRIG_DELAY) 
	    &&   ch->mprog_delay > 0 )
	    {
		if ( --ch->mprog_delay <= 0 )
		{
                    p_percent_trigger( ch, NULL, NULL, NULL, NULL, NULL, TRIG_ENTRY );  
		    continue;
		}
	    } 
	    if ( HAS_TRIGGER_MOB( ch, TRIG_RANDOM) )
	    {
		if( p_percent_trigger( ch, NULL, NULL, NULL, NULL, NULL, TRIG_RANDOM ) )
		continue;
	    }
	}

	/* That's all for sleeping / busy monster, and empty zones */
	if ( ch->position != POS_STANDING )
	    continue;

	/* Scavenge */
	if ( IS_SET(ch->act, ACT_SCAVENGER)
	&&   IN_ROOM(ch)->contents != NULL
        &&   !IS_SET(IN_ROOM(ch)->room_flags, ROOM_DONATION)
	&&   number_bits( 6 ) == 0 )
	{
	    OBJ_DATA *obj;
	    OBJ_DATA *obj_best;
	    int max;

	    max         = 1;
	    obj_best    = 0;
	    for ( obj = IN_ROOM(ch)->contents; obj; obj = obj->next_content )
	    {
		if ( CAN_WEAR(obj, ITEM_TAKE) && can_loot(ch, obj)
		     && obj->cost > max  && obj->cost > 0)
		{
		    obj_best    = obj;
		    max         = obj->cost;
		}
	    }

	    if ( obj_best )
	    {
		obj_from_room( obj_best );
		obj_to_char( obj_best, ch );
		act( "$n gets $p.", ch, obj_best, NULL, TO_ROOM );
	    }
	}

	/* Wander */
	if ( !IS_SET(ch->act, ACT_SENTINEL) 
	&& number_bits(3) == 0
	&& ( door = number_bits( 5 ) ) <= 5
	&& ( pexit = (*IN_ROOM(ch)->exit)[door] ) != NULL
	&&   pexit->u1.to_room != NULL
	&&   !IS_SET(pexit->exit_info, EX_CLOSED)
	&&   !IS_SET(pexit->u1.to_room->room_flags, ROOM_NO_MOB)
	&& ( !IS_SET(ch->act, ACT_STAY_AREA)
	||   pexit->u1.to_room->area == IN_ROOM(ch)->area ) 
	&& ( !IS_SET(ch->act, ACT_OUTDOORS)
	||   !IS_SET(pexit->u1.to_room->room_flags,ROOM_INDOORS)) 
	&& ( !IS_SET(ch->act, ACT_INDOORS)
	||   IS_SET(pexit->u1.to_room->room_flags,ROOM_INDOORS)))
	{
	    move_char( ch, door, FALSE );
	}
    }

    return;
}

/*
 * Update all chars, including mobs.
*/
void char_update( void )
{   
    CHAR_DATA *ch;
    CHAR_DATA *ch_next;
    CHAR_DATA *ch_quit;
    int  number = number_range( 1, 100 );
	USE *use;

    ch_quit	= NULL;

    /* update save counter */
    save_number++;

    if (save_number > 29)
	save_number = 0;

    for ( ch = char_list; ch != NULL; ch = ch_next )
    {
	AFFECT_DATA *paf;
	AFFECT_DATA *paf_next;
  
        if (!IS_VALID(ch)) 
        {
            bug("update_char: Trying to work with an invalidated character.\n", 0); 
            break;
        }

	ch_next = ch->next;

        if ( ch->timer > 30 )
            ch_quit = ch;

	if ( ch->position >= POS_STUNNED )
	{
            /* check to see if we need to go home */
            if (IS_NPC(ch) && ch->zone != NULL && ch->zone != IN_ROOM(ch)->area
            && ch->desc == NULL &&  ch->fighting == NULL && number_percent() < 5)
            {
            	act("$n wanders on home.",ch,NULL,NULL,TO_ROOM);
            	extract_char(ch,TRUE);
            	continue;
            }

	    if ( ch->hit  < ch->max_hit )
		ch->hit  += hit_gain(ch);
	    else
		ch->hit = ch->max_hit;

	    if ( ch->mana < ch->max_mana )
		ch->mana += mana_gain(ch);
	    else
		ch->mana = ch->max_mana;

	    if ( ch->move < ch->max_move )
		ch->move += move_gain(ch);
	    else
		ch->move = ch->max_move;
	}

	if ( ch->position == POS_STUNNED )
	    update_pos( ch );

        if ( !IS_NPC(ch) && mortal_online(ch) >= 5 && number == 1 )
        {
            do_function( ch, &do_divine, "all" );
            do_function( ch, &do_restore, "all" );
            info( ch, 0, "Divine grace has been granted to the mud.\n\r" );
        }

	if ( !IS_NPC(ch) && ch->level < LEVEL_IMMORTAL )
	{
	    OBJ_DATA *obj;

	    if ( ( obj = get_eq_char( ch, WEAR_LIGHT ) ) != NULL
	    &&   ( use = get_obj_use(obj, UTYPE_LIGHT ) )
	    &&   use->value[2] > 0 )
	    {
		if ( --use->value[2] == 0 && IN_ROOM(ch) != NULL )
		{
		    --IN_ROOM(ch)->light;
		    act( "$p goes out.", ch, obj, NULL, TO_ROOM );
		    act( "$p flickers and goes out.", ch, obj, NULL, TO_CHAR );
		    extract_obj( obj );
		}
	 	else if ( use->value[2] <= 5 && IN_ROOM(ch) != NULL)
		    act("$p flickers.",ch,obj,NULL,TO_CHAR);
	    }

            if ( ch->pcdata->timeout-- > 0 )
            {
                printf_to_char( ch, "You have %d ticks of timeout left!\n\r", ch->pcdata->timeout );

                if ( ch->pcdata->timeout == 0 )
                {
                    timeout( ch );
                }
            }     

	    if ( ++ch->timer >= 12 )
	    {
		    if ( ch->fighting != NULL )
			stop_fighting( ch, TRUE );
                    if ( ch->timer == 12 )
                    set_auto_afk( ch );
		    if (ch->level > 1)
		        save_char_obj( ch );
	    }

	    gain_condition( ch, COND_DRUNK,  -1 );
	    gain_condition( ch, COND_FULL, ch->size > SIZE_MEDIUM ? -4 : -2 );
	    gain_condition( ch, COND_THIRST, -1 );
	    gain_condition( ch, COND_HUNGER, ch->size > SIZE_MEDIUM ? -2 : -1);
            gain_bloodthirst( ch, -1 );
	}

	for ( paf = ch->affected; paf != NULL; paf = paf_next )
	{
	    paf_next	= paf->next;
	    if ( paf->duration > 0 )
	    {
		paf->duration--;
		if (number_range(0,4) == 0 && paf->level > 0)
		  paf->level--;  /* spell strength fades with time */
            }
	    else if ( paf->duration < 0 )
		;
	    else
	    {
		if ( paf_next == NULL
		||   paf_next->type != paf->type
		||   paf_next->duration > 0 )
		{
		    if ( paf->type > 0 && skill_table[paf->type].msg_off )
		    {
			send_to_char( skill_table[paf->type].msg_off, ch );
			send_to_char( "\n\r", ch );
		    }
		}
	  
		affect_remove( ch, paf );
	    }
	}

	if ( ch->position == POS_INCAP && number_range(0,1) == 0)
	{
	    damage( ch, ch, 1, TYPE_UNDEFINED, DAM_NONE,FALSE);
	}
	else if ( ch->position == POS_MORTAL )
	{
	    damage( ch, ch, 1, TYPE_UNDEFINED, DAM_NONE,FALSE);
	}
    }

    if ( global_exp-- >= -1 )
    {   

        display++;

        if ( display >= 3 && global_exp > 0 )
        {
            info( NULL, 0, "[INFO]: There are %d ticks of double exp left.\n\r", global_exp );
            display = 0;
            return;
        }
        
        if (global_exp == 0)
        {
            info( NULL, 0, "[INFO]: Double exp has run out!\n\r" ); 
            double_exp = FALSE;
            return;
        }
    }

    /*
     * Autosave and autoquit.
     * Check that these chars still exist.
     */
    for ( ch = char_list; ch != NULL; ch = ch_next )
    {
        ch_next = ch->next;

	if (ch->desc != NULL && ch->desc->descriptor % 30 == save_number)
	{
	    save_char_obj(ch);
	}

        if (ch == ch_quit)
	{
            do_function(ch, &do_quit, "" );
	}
    }

    return;
}
void update_obj_state( OBJ_DATA *pObj, int origTmp, int newTmp, bool increase, bool message)
{	char buf[MSL];
	bool extract = FALSE;
	bool found = FALSE;

	if( !increase )
	{
		if( origTmp > material_table[pObj->material].evapTmp && newTmp <= material_table[pObj->material].evapTmp)
		{	sprintf(buf,"Out of no where %s liquifies on the ground.", pObj->short_descr);
			found = TRUE;
		}

		if( origTmp > material_table[pObj->material].smeltTmp && newTmp <= material_table[pObj->material].smeltTmp)
		{	sprintf(buf,"%s cools from its purifying heat.", pObj->short_descr);
			found = TRUE;
		}

		if( origTmp > material_table[pObj->material].igniteTmp && newTmp <= material_table[pObj->material].igniteTmp)
		{	sprintf(buf,"The flames wrapped around %s die down.", pObj->short_descr );
			found = TRUE;
		}

		if( origTmp > material_table[pObj->material].meltTmp && newTmp <= material_table[pObj->material].meltTmp)
		{	sprintf(buf,"%s solidifies, still burning white hot.", pObj->short_descr );
			found = TRUE;
		}

		if( origTmp > material_table[pObj->material].whiteTmp && newTmp <= material_table[pObj->material].whiteTmp)
		{	sprintf(buf,"%s cools to burning red hot.", pObj->short_descr);
			found = TRUE;
		}

		if( origTmp > material_table[pObj->material].redTmp && newTmp <= material_table[pObj->material].redTmp)
		{	sprintf(buf,"%s cools; it's no longer burning red hot.", pObj->short_descr);
			found = TRUE;
		}

		if( origTmp > material_table[pObj->material].solidTmp && newTmp <= material_table[pObj->material].solidTmp)
		{	sprintf(buf,"%s is now solid.", pObj->short_descr );
			found = TRUE;
		}
	}
	else
	{	if( origTmp < material_table[pObj->material].solidTmp && newTmp >= material_table[pObj->material].solidTmp)
		{	sprintf(buf,"%s begins heating up.", pObj->short_descr);
			found = TRUE;
		}
		if( origTmp < material_table[pObj->material].redTmp && newTmp >= material_table[pObj->material].redTmp)
		{	sprintf(buf,"%s begins burning red hot.", pObj->short_descr );
			found = TRUE;
		}
		if( origTmp < material_table[pObj->material].whiteTmp && newTmp >= material_table[pObj->material].whiteTmp)
		{	sprintf(buf,"%s begins burning white hot!", pObj->short_descr );
			found = TRUE;
		}
		if( origTmp < material_table[pObj->material].meltTmp && newTmp >= material_table[pObj->material].meltTmp)
		{	sprintf(buf,"%s begins to melt.", pObj->short_descr );
			if( pObj->in_obj && ( get_obj_use(pObj, UTYPE_HEARTH) || get_obj_use(pObj, UTYPE_FURNACE) ) )
				extract = TRUE;
			found = TRUE;
		}
		if( origTmp < material_table[pObj->material].igniteTmp && newTmp >= material_table[pObj->material].igniteTmp)
		{	sprintf(buf,"%s bursts into flames.", pObj->short_descr );
			found = TRUE;
		}
		if( origTmp < material_table[pObj->material].smeltTmp && newTmp >= material_table[pObj->material].smeltTmp)
		{	int impure, weight, mL;
			USE *use;
			sprintf(buf,"%s purifies itself.", pObj->short_descr );
			use = get_obj_use(pObj, UTYPE_ORE);
			impure = 100 - use->value[1];
			weight = (pObj->weight / impure);
			pObj->weight -= weight;
			if( ( use = get_obj_use(pObj, UTYPE_POT ) ) )
			{	mL = (int)(weight * material_table[pObj->material].density);
				use->value[1] -= mL;
			}
			found = TRUE;
		}
		if( origTmp < material_table[pObj->material].evapTmp && newTmp >= material_table[pObj->material].evapTmp)
		{	sprintf(buf,"%s evaporates into thin air.", pObj->short_descr );
			found = TRUE;
		}
	}
	if( found && message )
	{	if(pObj->in_room)
			send_to_room(pObj->in_room, buf);
		else if(pObj->carried_by)
			send_to_room(IN_ROOM(pObj->carried_by), buf);
	}
	return;
}
EVENT_DATA *get_obj_event( OBJ_DATA *pObj, int type );
void update_obj_temp( OBJ_DATA *pObj)
{	int dif;
	int old = pObj->temp;
	CHAR_DATA *rch;
	USE *use;

	if(get_obj_event(pObj, EVENT_HEAT_OBJ ) )
		return;
	if( pObj->in_room && (( use = get_obj_use(pObj, UTYPE_FURNACE) ) || ( use = get_obj_use(pObj, UTYPE_HEARTH ) ) ))
	{	if(use->value[1])
		{
			if( pObj->temp > fuel_table[use->value[3]].maxTmp )
			{	dif = pObj->temp - fuel_table[use->value[3]].maxTmp;
				if( dif == 1 ) dif++;
				pObj->temp -= dif/2;
			}
			else if( pObj->temp < fuel_table[use->value[3]].maxTmp )
			{	dif = fuel_table[use->value[3]].maxTmp - pObj->temp;
				if( dif == 1 ) dif++;
				pObj->temp += (dif/2);
			}
			if( --use->value[2] <= 0 )
			{	rch = pObj->in_room->people;
				act("$p runs out of fuel and stops burning.", rch, pObj, NULL, TO_ROOM );
				use->value[1] = FALSE;
			}
		}
		else
		{	if( pObj->temp > pObj->in_room->temp )
			{	dif = pObj->temp - pObj->in_room->temp;
				if( dif == 1 ) dif++;
				pObj->temp -= dif/2;
			}
		}
		return;
	}			

	if( pObj->in_obj )
	{	if( pObj->temp == pObj->in_obj->temp )
		{	
			if(number_range(1,2) == 1 )
				pObj->temp++;
			else
				pObj->temp--;
			return;
		}
		if( pObj->temp > pObj->in_obj->temp )
		{	dif = pObj->temp - pObj->in_obj->temp;
			if( dif == 1 ) dif++;
			pObj->temp -= (dif/2);
			update_obj_state(pObj, old, pObj->temp, FALSE, FALSE);
			return;
		}

		if( pObj->temp < pObj->in_obj->temp )
		{	dif = pObj->in_obj->temp - pObj->temp;
			if( dif == 1 ) dif++;
			pObj->temp += (dif/2);
			update_obj_state(pObj, old, pObj->temp, TRUE, FALSE );
			return;
		}
	}

	if( pObj->carried_by )
	{	if( pObj->temp == IN_ROOM(pObj->carried_by)->temp )
		{	if(number_range(1,2) == 1 )
				pObj->temp++;
			else
				pObj->temp--;
			return;
		}
		if( pObj->temp > IN_ROOM(pObj->carried_by)->temp )
		{	dif = pObj->temp - IN_ROOM(pObj->carried_by)->temp;
			if( dif == 1 ) dif++;
			pObj->temp -= (dif/2);
			update_obj_state(pObj, old, pObj->temp, FALSE, FALSE);
			return;
		}
		if( pObj->temp < IN_ROOM(pObj->carried_by)->temp )
		{	dif = IN_ROOM(pObj->carried_by)->temp - pObj->temp;
			if( dif == 1 ) dif++;
			pObj->temp += (dif/2);
			update_obj_state(pObj, old, pObj->temp, TRUE, FALSE );
			return;
		}
	}

	if( pObj->in_room )
	{	if( pObj->temp == pObj->in_room->temp )
		{	if(number_range(1,2) == 1 )
				pObj->temp++;
			else
				pObj->temp--;
			return;
		}
		if( pObj->temp > pObj->in_room->temp )
		{	dif = pObj->temp - pObj->in_room->temp;
			if( dif == 1 ) dif++;
			pObj->temp -= (dif/2);
			update_obj_state(pObj, old, pObj->temp, FALSE, TRUE);
			return;
		}
		if( pObj->temp < pObj->in_room->temp )
		{	dif = pObj->in_room->temp - pObj->temp;
			if( dif == 1 ) dif++;
			pObj->temp += (dif/2);
			update_obj_state(pObj, old, pObj->temp, TRUE, TRUE );
			return;
		}
	}
	return;
}

/*
 * Update all objs.
 * This function is performance sensitive.
 */
void obj_update( void )
{   
    OBJ_DATA *obj;
    OBJ_DATA *obj_next;
    AFFECT_DATA *paf, *paf_next;
    int rand = number_range( 1, 5000 );
    
    if ( max_unique-- > 0 )    
    {	if ( rand <= 250 )
			create_unique();
    }

    for ( obj = object_list; obj != NULL; obj = obj_next )
    {	CHAR_DATA *rch;
		char *message;

		obj_next = obj->next;
	
		/* go through affects and decrement */
        for ( paf = obj->affected; paf != NULL; paf = paf_next )
        {	paf_next    = paf->next;
            if ( paf->duration > 0 )
            {	paf->duration--;
                if (number_range(0,4) == 0 && paf->level > 0)
					paf->level--;  /* spell strength fades with time */
            }
            else if ( paf->duration < 0 );
            else
            {	if ( paf_next == NULL
                ||   paf_next->type != paf->type
                ||   paf_next->duration > 0 )
                {	if ( paf->type > 0 && skill_table[paf->type].msg_obj )
                    {	if (obj->carried_by != NULL)
						{	rch = obj->carried_by;
						    act(skill_table[paf->type].msg_obj,
							rch,obj,NULL,TO_CHAR);
						}
						if (obj->in_room != NULL 
						&& obj->in_room->people != NULL)
						{
							rch = obj->in_room->people;
							act(skill_table[paf->type].msg_obj,
							rch,obj,NULL,TO_ALL);
						}
                    }
                }

                affect_remove_obj( obj, paf );
            }
        }
		update_obj_temp(obj);
		if(!obj) continue;
       	/*
	 * Oprog triggers!
	 */
		if ( obj->in_room || (obj->carried_by && IN_ROOM(obj->carried_by)))
		{	if(HAS_TRIGGER_OBJ( obj, TRIG_DELAY )
			&& obj->oprog_delay > 0 )
			{	if ( --obj->oprog_delay <= 0 )
					p_percent_trigger( NULL, obj, NULL, NULL, NULL, NULL, TRIG_DELAY );
			}
			else if(((obj->in_room && !obj->in_room->area->empty)
	    		 ||   obj->carried_by ) && HAS_TRIGGER_OBJ( obj, TRIG_RANDOM ) )
					p_percent_trigger( NULL, obj, NULL, NULL, NULL, NULL, TRIG_RANDOM );
		}

        if ( !obj )
            continue;

		if ( obj->timer <= 0 || --obj->timer > 0 )
		    continue;

        if (in_donation_room(obj))
            message = "$p shimmers and fades away.";
        else
		message = "$p crumbles into dust.";
		if( get_obj_use(obj, UTYPE_FOUNTAIN) )
			message = "$p dries up.";
		if( get_obj_use(obj, UTYPE_CORPSE_NPC)
		||  get_obj_use(obj, UTYPE_CORPSE_PC ) )
			message = "$p decays into dust.";
		if( get_obj_use(obj, UTYPE_FOOD) )
			message = "$p decomposes.";
		if( get_obj_use(obj, UTYPE_PORTAL) )
			 message = "$p fades out of existence.";
		if( get_obj_use(obj, UTYPE_CONTAINER) )
		{	if (CAN_WEAR(obj,ITEM_WEAR_FLOAT))
			{	if (obj->contains)
					message = "$p flickers and vanishes, spilling its contents on the floor.";
				else
					message = "$p flickers and vanishes.";
			}
			else
				message = "$p crumbles into dust.";
		}

		if ( obj->carried_by != NULL )
		{	if (IS_NPC(obj->carried_by) 
			&&  obj->carried_by->pIndexData->pShop != NULL)
				obj->carried_by->silver += obj->cost/5;
			else
			{	act( message, obj->carried_by, obj, NULL, TO_CHAR );
				if ( obj->wear_loc == WEAR_FLOAT)
					act(message,obj->carried_by,obj,NULL,TO_ROOM);
			}
		}
		else if ( obj->in_room != NULL
		&&      ( rch = obj->in_room->people ) != NULL )
		{
				act( message, rch, obj, NULL, TO_ROOM );
				act( message, rch, obj, NULL, TO_CHAR );
		}

        if (( get_obj_use(obj, UTYPE_CORPSE_PC) || obj->wear_loc == WEAR_FLOAT)
		&&  obj->contains)
		{   /* save the contents */
     	    OBJ_DATA *t_obj, *next_obj;
		    for (t_obj = obj->contains; t_obj != NULL; t_obj = next_obj)
		    {	next_obj = t_obj->next_content;
				obj_from_obj(t_obj);

				if (obj->in_obj) /* in another object */
				    obj_to_obj(t_obj,obj->in_obj);
				else if (obj->carried_by)  /* carried */
			    if (obj->wear_loc == WEAR_FLOAT)
					if (IN_ROOM(obj->carried_by) == NULL)
					    extract_obj(t_obj);
					else
					{  t_obj->carried_by = obj->carried_by;
					   obj_to_room(t_obj,IN_ROOM(obj->carried_by));
					}
				else
		    		obj_to_char(t_obj,obj->carried_by);
				else if (obj->in_room == NULL)  /* destroy it */
				    extract_obj(t_obj);

				else /* to a room */
                {	if (in_donation_room(obj))
                    {	if (t_obj->timer)
							SET_BIT(t_obj->extra_flags,ITEM_HAD_TIMER);
                        else
                            t_obj->timer = number_range(100,200);
                    }
		     
					obj_to_room(t_obj,obj->in_room);
                }  
			}
		}

		extract_obj( obj );
    }

    return;
}


void room_update( AREA_DATA *pArea )
{
	ROOM_INDEX_DATA *room;
	int vnum;

  for ( vnum = pArea->min_vnum; vnum <= pArea->max_vnum; vnum ++ )
	{
	  if ( (room = get_room_index(vnum)) )
		room_aff_update(room);
	}

   return;
}


void room_aff_update( ROOM_INDEX_DATA *room )
{
	AFFECT_DATA *paf;
	AFFECT_DATA *paf_next;

	for ( paf = room->affected; paf != NULL; paf = paf_next )
	{
	    paf_next	= paf->next;
	    if ( paf->duration > 0 )
	    {
		paf->duration--;
		if (number_range(0,4) == 0 && paf->level > 0)
		  paf->level--;  /* spell strength fades with time */
            }
	    else if ( paf->duration < 0 )
		;
	    else
	    {
		if ( paf_next == NULL
		||   paf_next->type != paf->type
		||   paf_next->duration > 0 )
		{
		    if ( paf->type > 0 && skill_table[paf->type].msg_off )
		    {
		/*	send_to_char( skill_table[paf->type].msg_off, ch);
			send_to_char( "\n\r", ch );  */
		    }
		}
	        
		affect_remove_room( room, paf );
	    }
	}

}

void hint_update( void )
{
  CHAR_DATA *ch;
  CHAR_DATA *ch_next;

  for (ch=char_list;ch!=NULL;ch=ch_next)
  {
      ch_next = ch->next;

    if(!IS_NPC(ch) && !IS_SET(ch->comm, COMM_NOHINT) )
    {
      send_to_char("[HINT]: ",ch);
      switch(number_range(0,20))
      {
        default: send_to_char("You can turn the hint channel off by typing hint.", ch); break;
        case 0: send_to_char("When you die you can find your corpse in the morgue one north and down of midgaard recall.",ch); break;
        case 1: send_to_char("Type commands for a list of working commands. If you are unsure what they do type help <commandname>",ch); break;
        case 2: send_to_char("The donation room is located north of the healer.",ch); break;
        case 3: send_to_char("The bank is located south one east and up from recall.",ch); break;
        case 4: send_to_char("The restringer is located south two and up one from recall.",ch); break;
        case 5: send_to_char("The summoner is three south and west of recall.",ch); break;
        case 6: send_to_char("The questmaster is three south of recall.",ch); break;
        case 7: send_to_char("The bounty processor is four south and east of recall.",ch); break;
        case 8: send_to_char("The gambling hall is south two east one and south two of recall.",ch); break;
        case 9: send_to_char("The forger is four south and west of midgaard recall.",ch); break;
        case 10: send_to_char("Additional spells can be bought at the healer. Type heal to see a list.",ch); break;
        case 11: send_to_char("The blacksmith is located three south and up of midgaard recall. He can repair your objects.",ch); break;
        case 12: send_to_char("You can choose three difference fighting stances. Aggressive, Neutral, and Defensive.", ch ); break;
        case 14: send_to_char("You can rent rooms at inns to gain an additional healing bonus. One is located east of Midgaard recall.", ch ); break;
        case 15: send_to_char("Objects have to be the same size as you to wear. They can be resized at any shopkeeper. Type resize and the name of the object.", ch ); break;      
        case 16: send_to_char("You can be awarded blessing points if you please your diety.\n\r", ch ); break;
        case 17: send_to_char("You can trade in your blessing points at the blesser for levels, pracs, trains, hp, mana, move etc.\n\r", ch ); break;
        case 18: send_to_char("You have the choice of leveling manually or automatically. \n\rUpon creation you will level automatically, if you wish to change this type autolevel. \n\rYou can then go to the healer and type level whenever you have gained enough experience.\n\r", ch ); break;
        case 19: send_to_char("Be on the lookout for unique objects, They load randomly so no telling where one could turn up.\n\r", ch ); break;
        case 20: send_to_char("New things are being added all the time. So read the boards to see what is being added.\n\r", ch ); break;
      }
      send_to_char("\n\r",ch);
    }
  }
    return;
}


void olcautosave( void )
{

   AREA_DATA *pArea;
   DESCRIPTOR_DATA *d;
   char buf[MAX_INPUT_LENGTH];
   
	void save_db( void );

        for ( d = descriptor_list; d != NULL; d = d->next )
        {

           if ( d->editor)
                   send_to_char( "OLC Autosaving:\n\r", d->character );
   	}

	do_function(NULL, &do_save_guilds, "");
        sprintf( buf, "None.\n\r" );

        for( pArea = area_first; pArea; pArea = pArea->next ) 
        {

            /* Save changed areas. */

            if ( IS_SET(pArea->area_flags, AREA_CHANGED) )
            {

                save_area( pArea );

                sprintf( buf, "%24s - '%s'", pArea->name, pArea->file_name );

                for ( d = descriptor_list; d != NULL; d = d->next )
                {

                   if ( d->editor )
                   {
                        send_to_char( buf, d->character );
                        send_to_char( "\n\r", d->character );

                   }

                }   

                REMOVE_BIT( pArea->area_flags, AREA_CHANGED );
            }

        }       

        if ( !str_cmp( buf, "None.\n\r" ) )
        {

           for ( d = descriptor_list; d != NULL; d = d->next )
           {
                if ( d->editor )
                        send_to_char( buf, d->character );
	   }     

        }

        return;
}


/*
 * Aggress.
 *
 * for each mortal PC
 *     for each mob in room
 *         aggress on some random PC
 *
 * This function takes 25% to 35% of ALL Merc cpu time.
 * Unfortunately, checking on each PC move is too tricky,
 *   because we don't the mob to just attack the first PC
 *   who leads the party into the room.
 *
 * -- Furey
 */
void aggr_update( void )
{
    CHAR_DATA *wch;
    CHAR_DATA *wch_next;
    CHAR_DATA *ch;
    CHAR_DATA *ch_next;
    CHAR_DATA *vch;
    CHAR_DATA *vch_next;
    CHAR_DATA *victim;

    for ( wch = char_list; wch != NULL; wch = wch_next )
    {
	wch_next = wch->next;
	if ( IS_NPC(wch)
	||   wch->level >= LEVEL_IMMORTAL
	||   IS_VIRTUAL(wch->in_ocean)
	||   IN_ROOM(wch) == NULL 
 	||   IN_ROOM(wch)->area->empty
        ||   IS_SET(IN_ROOM(wch)->room_flags,ROOM_SAFE) )
	    continue;

	for ( ch = IN_ROOM(wch)->people; ch != NULL; ch = ch_next )
	{
	    int count;

	    ch_next	= ch->next_in_room;

	    if ( !IS_NPC(ch)
	    ||   !IS_SET(ch->act, ACT_AGGRESSIVE)
	    ||   ch->fighting != NULL
	    ||   !IS_AWAKE(ch)
	    ||   ( IS_SET(ch->act, ACT_WIMPY) && IS_AWAKE(wch) )
	    ||   !can_see( ch, wch ) 
	    ||   number_bits(1) == 0)
		continue;

	    /*
	     * Ok we have a 'wch' player character and a 'ch' npc aggressor.
	     * Now make the aggressor fight a RANDOM pc victim in the room,
	     *   giving each 'vch' an equal chance of selection.
	     */
	    count	= 0;
	    victim	= NULL;
	    for ( vch = IN_ROOM(wch)->people; vch != NULL; vch = vch_next )
	    {
		vch_next = vch->next_in_room;

		if ( !IS_NPC(vch)
		&&   vch->level < LEVEL_IMMORTAL
		&&   ch->level >= vch->level - 5 
		&&   ( !IS_SET(ch->act, ACT_WIMPY) || !IS_AWAKE(vch) )
		&&   can_see( ch, vch ) )
		{
		    if ( number_range( 0, count ) == 0 )
			victim = vch;
		    count++;
		}
	    }

	    if ( victim == NULL )
		continue;

            if (RIDDEN(ch))
	    {
		if (!mount_success(RIDDEN(wch), ch, FALSE))
		{
		    send_to_char("Your mount escapes your control!\n\r", RIDDEN(ch));
		    multi_hit( ch, victim, TYPE_UNDEFINED );
		}
		else
		{
		    send_to_char("You manage to keep your mount under control.\n\r", RIDDEN(ch));
		}
	    }
	    else 
   	        multi_hit( ch, victim, TYPE_UNDEFINED );
	}
    }

    return;
}



/*
 * Handle all kinds of updates.
 * Called once per pulse from game loop.
 * Random times to defeat tick-timing clients and players.
 */

void update_handler( void )
{
    static  int     pulse_area;
    static  int     pulse_mobile;
    static  int     pulse_violence;
    static  int     pulse_point;
    static  int	    pulse_music;
    static  int     pulse_auction;
    static  int     pulse_hint;
	
	event_update();

    if ( --pulse_area     <= 0 )
    {
	pulse_area	= PULSE_AREA;
	/* number_range( PULSE_AREA / 2, 3 * PULSE_AREA / 2 ); */
	area_update	( );
        olcautosave     ( );
    }

    if ( --pulse_music	  <= 0 )
    {
	pulse_music	= PULSE_MUSIC;
	song_update();
    }
   

    if (--pulse_auction <= 0)
    {
        pulse_auction = PULSE_AUCTION;
        auction_update ();
    }

    if ( --pulse_hint <= 0)
    {
      pulse_hint = PULSE_HINT;
      hint_update ( );
    }

    if ( --pulse_mobile   <= 0 )
    {
	pulse_mobile	= PULSE_MOBILE;
	mobile_update	( );
    }

    if ( --pulse_violence <= 0 )
    {
	pulse_violence	= PULSE_VIOLENCE;
	violence_update	( );
    }

    if ( --pulse_point    <= 0 )
    {
	wiznet("TICK!",NULL,NULL,WIZ_TICKS,0,0);
	pulse_point     = PULSE_TICK;
/* number_range( PULSE_TICK / 2, 3 * PULSE_TICK / 2 ); */
//	weather_update	( );
	char_update	( );
	obj_update	( );
    war_update ( );

    }

    aggr_update( );
    tail_chain( );
    return;
}

void gain_bloodthirst( CHAR_DATA *ch, int value )
{
    int cond, dam;
    
    if ( !IS_VAMPIRE(ch ) )
	return;

    cond = ch->bloodthirst;
  
    if ( ch->bloodthirst >= 0 )
      ch->bloodthirst = URANGE( 0, cond + value, 48 );	
    
    switch ( ch->bloodthirst )
    {
	case 2: 	  
		send_to_char( "The first pangs denoting your endless thirst for blood returning claw\n\rat your throat.\n\r", ch );
		break;
	case 1: 
		send_to_char( "Bloodthirst begins to tear relentlessly at your very soul.\n\r", ch );
		break;
	default:
		break;
   }

   if ( ch->bloodthirst == 0 )
   {
	send_to_char( "Thirst for blood rages through you, screaming to find a victim.\n\r", ch );
   	return;
   }

   if ( ch->bloodthirst < 0 )
   {
	send_to_char( "Thirst for blood rages through you, screaming to find a victim.\n\rYou begin to ache with weakness!\n\r", ch );
	dam = number_fuzzy( number_range( 1, 10 ) );
      damage(ch,ch,dam,0,DAM_NONE,FALSE);
   	return;
   }
  
   return;
}
