#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include "merc.h"
#include "interp.h"
#include "windgate.h"

/*
 * windgate_table()
 *
 * All windgates =
 */
const struct windgate_type windgate_table[] =
{
    {"Hell",    10404,
    {SYMBOL_CIRCLE, SYMBOL_LINE, SYMBOL_LINE},
    NO_MIN_LEVEL,
    FALSE,     FALSE,      -1,      -1},
   
    {"Midgaard",    3005,
    {SYMBOL_LINE, SYMBOL_LINE, SYMBOL_LINE},
    NO_MIN_LEVEL,
    FALSE,     FALSE,      -1,      -1},

    {NULL, -1, {-1, -1, -1}, -1, FALSE, FALSE, -1, -1}
};

/* symbol_table[]
 * Uh, symbols, easier this way
 */

const struct symbol_type symbol_table[] =
{
    {"none",        SYMBOL_NONE,        "with boggled look on your face"},
    {"Square",      SYMBOL_SQUARE,      "with a reddish glow"},
    {"Triangle",    SYMBOL_TRIANGLE,    "with a greenish glow"},
    {"Circle",      SYMBOL_CIRCLE,      "with a white glow"},
    {"Star",        SYMBOL_STAR,        "with a grey glow"},
    {"Pentagon",    SYMBOL_PENTAGON,    "with a dark light"},
    {"Line",        SYMBOL_LINE,        "with a purple glow"},
    {"Sun",         SYMBOL_SUN,         "with a golden glow"},
    {"Moon",        SYMBOL_MOON,        "with a blueish glow"},
    {"Hand",        SYMBOL_HAND,        "with a loud hum"},
    {NULL, -1}
};

/*
 * cmd_press()
 *
 * I like stargate. So Pfft on all of you.
 * Ok so this is how it works, the player 'presses' the symbols in order
 * to open up the gate. If it works, the gate activates and creates a portal
 * of types to that location.
 */
void do_press(CHAR_DATA * ch, char *argument)
{
    char arg1[MSL];
    char buf[MSL];
    OBJ_DATA * obj;
    bool IS_WINDGATE = FALSE;
    int symbol;
    int i;
    
    argument = one_argument (argument, arg1);
    
    for (obj = ch->in_room->contents; obj; obj = obj->next_content)
    {
        if (obj->item_type == ITEM_WINDGATE)
        {
            IS_WINDGATE = TRUE;
            break;
        }
    }
    
    if (arg1[0] == '\0')
    {
        if (!IS_WINDGATE || obj == NULL)
        {
            send_to_char("You cannot find a windgate here.\n", ch);
            return;
        }
        send_to_char("Which symbol do you wish to press?\n", ch);
        return;
    }
    
    /* Ok find the symbol from the list */
    symbol = -1;
    for (i = 0; i < MAX_SYMBOL; i++)
    {
        if (symbol_table[i].name == NULL)
            break;
        if (LOWER (arg1[0]) == LOWER (symbol_table[i].name[0]) && !str_prefix (arg1, symbol_table[i].name))
            symbol = i;
    }
    
    if (symbol == -1)
    {
        send_to_char("That is NOT a symbol!\nValid symbols are:\n", ch);

        for (i = 0; i < MAX_SYMBOL; i++)
        {
            if (symbol_table[i].name == NULL)
                break;
            sprintf(buf, "%s ", symbol_table[i].name);
            send_to_char(buf, ch);
        }
        send_to_char("\n", ch);
        return;
    }
    
    sprintf(buf, "You press the %s symbol and it lights up with %s.\n", 
        symbol_table[symbol].name,
        symbol_table[symbol].press_string);
    send_to_char(buf, ch);
    
    
    fix_lights(ch, obj, symbol);
    
    if (obj->value[4] == 0)
    {
        sprintf(buf, "Currently, the %s, %s and %s lights are lit up.\n", 
            symbol_table[obj->value[0]].name,
            symbol_table[obj->value[1]].name,
            symbol_table[obj->value[2]].name);
        send_to_char(buf, ch);
    }
    
}

/*
 * fix_lights()
 *
 *  Ugh, handle the lighting of the windgate
 */
void fix_lights(CHAR_DATA * ch, OBJ_DATA * obj, int symbol)
{
    if (obj->value[0] == 0)
    {
        obj->value[0] = symbol;
        return;
    }
    if (obj->value[1] == 0)
    {
        obj->value[1] = symbol;
        return;
    }
    if (obj->value[2] == 0)
    {
        obj->value[2] = symbol;
        /* Last symbol, check to see if it activates the gate! */
        check_valid_sequence(ch, obj);
        return;
    }
    /* Ok, so no possible symbol availible, lets reset the thing */
    reset_windgate(ch, obj);
    return;
}

/*
 * reset_windgate()
 *
 * Simple utility to reset the gate. Used on invalid sequence, and on boot
 */
void reset_windgate(CHAR_DATA * ch, OBJ_DATA * obj)
{
    obj->value[0] = 0;
    obj->value[1] = 0;
    obj->value[2] = 0;
    obj->value[3] = 0;
    obj->value[4] = 0;
    send_to_char("\n\nAll the lights on the gate fade.\n\n", ch);
    return;
}

/*
 * check_valid_sequence()
 *
 * checks to see if the windgate's values match up with a valid location, if so
 * open the gate up, and reset the symbols
 */
void check_valid_sequence(CHAR_DATA * ch, OBJ_DATA * obj)
{
    int i;
    char buf[MSL];

    for (i = 0; i <= MAX_GATES; i++)
    {
        if (windgate_table[i].name == NULL)
            return;
        
        if (windgate_table[i].symbol[0] == obj->value[0] &&
            windgate_table[i].symbol[1] == obj->value[1] &&
            windgate_table[i].symbol[2] == obj->value[2] &&
            ch->level >= windgate_table[i].min_level     &&
            !windgate_table[i].disabled)
        {   /* Ok checks out, open the gate */
            reset_windgate(ch, obj);
            sprintf(buf, "\n\nA strange swirling vortex opens up in the center of the windgate, leading to %s.\n\n\n",
                windgate_table[i].name);
            send_to_char(buf, ch);
            obj->value[4] = windgate_table[i].vnum;
            return;
        }
    }

    send_to_char("\n\nAll the lights on the gate fade.\n\n", ch);
    reset_windgate(ch, obj);
    return;
}
            
    

/*
 * cmd_windgate()
 *
 * Immortal utility to see all windgates
 */
void do_windgate(CHAR_DATA * ch, char *argument)
{
    int i;
    char buf[MSL];
    
    send_to_char(" Current Windgates in the universe...\n\n", ch);
    send_to_char("Gate Name       | Symbol 1  Symbol 2  Symbol 3     | Min | X/Y\n", ch);
    send_to_char("----------------|----------------------------------|-----|------\n", ch);
    for (i = 0; i <= MAX_GATES; i++)
    {
        if (windgate_table[i].name == NULL)
            return;
        
        sprintf(buf, "%-15s | %-10s %-10s %-10s | %-3d | %d/%d\n",
            windgate_table[i].name,
            symbol_table[windgate_table[i].symbol[0]].name,
            symbol_table[windgate_table[i].symbol[1]].name,
            symbol_table[windgate_table[i].symbol[2]].name,
            windgate_table[i].min_level,
            windgate_table[i].x,
            windgate_table[i].y);
        send_to_char(buf, ch);
    }
    send_to_char("\nThat is all the gates we have!\n\n", ch);
    return;
}

char * return_gatesymbol(int symbol)
{
    return symbol_table[symbol].name;
}

