/*
 * windgate.h
 */

/* Symbol defines for usage of the Windgates */
#define SYMBOL_NONE         0
#define SYMBOL_SQUARE       1
#define SYMBOL_TRIANGLE     2
#define SYMBOL_RECTANGLE    3
#define SYMBOL_CIRCLE       4
#define SYMBOL_STAR         5
#define SYMBOL_PENTAGON     6
#define SYMBOL_LINE         7
#define SYMBOL_SUN          8
#define SYMBOL_MOON         9
#define SYMBOL_HAND         10
#define MAX_SYMBOL          11

#define MAX_GATES           2

/* Worded define for easy reading */
#define NO_MIN_LEVEL        1

/* Table structure */
struct windgate_type
{
    char    * name;     /* Name to where it goes        */
    int     vnum;       /* What vnum their location is  */
    int     symbol[3];  /* the 4 symbols used travel    */
    int     min_level;  /* Min level to activate it     */
    bool    disabled;   /* is it disabled?              */
    bool    to_wild;    /* Does it go to the wildnerness*/
    int     x;          /* if to_wild, what X           */
    int     y;          /* if to_wild, what Y           */
};

struct symbol_type
{
    char    * name;
    int     symbol;
    char    * press_string;
};

extern const struct windgate_type windgate_table [];
extern const struct symbol_type symbol_table [];

/* Stuff */
void do_press              (CHAR_DATA * ch, char *argument);
void fix_lights             (CHAR_DATA * ch, OBJ_DATA * obj, int symbol);
void reset_windgate         (CHAR_DATA * ch, OBJ_DATA * obj);
void check_valid_sequence   (CHAR_DATA * ch, OBJ_DATA * obj);
void do_windgate           (CHAR_DATA * ch, char *argument);
char * return_gatesymbol    (int symbol);

