/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

/***************************************************************************
*	ROM 2.4 is copyright 1993-1995 Russ Taylor			   *
*	ROM has been brought to you by the ROM consortium		   *
*	    Russ Taylor (rtaylor@pacinfo.com)				   *
*	    Gabrielle Taylor (gtaylor@pacinfo.com)			   *
*	    Brian Moore (rom@rom.efn.org)				   *
*	By using this code, you have agreed to follow the terms of the	   *
*	ROM license, in the file Rom24/doc/rom.license			   *
***************************************************************************/

/*************************************************************************** 
*       ROT 1.4 is copyright 1996-1997 by Russ Walsh                       * 
*       By using this code, you have agreed to follow the terms of the     * 
*       ROT license, in the file doc/rot.license                           * 
***************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <time.h>
#include "merc.h"
#include "magic.h"

char *const dir_name[] = {
    "{RN{rorth{x", "{GE{gast{x", "{BS{bouth{x", "{CW{cest{x", "{MU{mp{x",
    "{WD{Down{x",
    "north", "east", "south", "west", "up", "down"
};

const sh_int rev_dir[] = {
    2, 3, 0, 1, 5, 4, 2, 3, 0, 1, 5, 4
};

const sh_int movement_loss[SECT_MAX] = {
    1, 2, 2, 3, 4, 6, 4, 1, 6, 10, 6
};

/* item type list */
const struct item_type item_table[] = {
    {ITEM_LIGHT, "light"},
    {ITEM_SCROLL, "scroll"},
    {ITEM_WAND, "wand"},
    {ITEM_STAFF, "staff"},
    {ITEM_WEAPON, "weapon"},
    {ITEM_TREASURE, "treasure"},
    {ITEM_ARMOR, "armor"},
    {ITEM_POTION, "potion"},
    {ITEM_CLOTHING, "clothing"},
    {ITEM_FURNITURE, "furniture"},
    {ITEM_TRASH, "trash"},
    {ITEM_CONTAINER, "container"},
    {ITEM_DRINK_CON, "drink"},
    {ITEM_KEY, "key"},
    {ITEM_FOOD, "food"},
    {ITEM_MONEY, "money"},
    {ITEM_BOAT, "boat"},
    {ITEM_CORPSE_NPC, "npc_corpse"},
    {ITEM_CORPSE_PC, "pc_corpse"},
    {ITEM_FOUNTAIN, "fountain"},
    {ITEM_PILL, "pill"},
    {ITEM_PROTECT, "protect"},
    {ITEM_MAP, "map"},
    {ITEM_PORTAL, "portal"},
    {ITEM_WARP_STONE, "warp_stone"},
    {ITEM_ROOM_KEY, "room_key"},
    {ITEM_GEM, "gem"},
    {ITEM_JEWELRY, "jewelry"},
    {ITEM_JUKEBOX, "jukebox"},
    {ITEM_DEMON_STONE, "demon_stone"},
    {ITEM_EXIT, "exit"},
    {ITEM_PIT, "pit"},
    {ITEM_SLOT_MACHINE, "slot_machine"},
    {0, NULL}
};

/* weapon selection table */
const struct weapon_type weapon_table[] = {
    {"sword", OBJ_VNUM_SCHOOL_SWORD, WEAPON_SWORD, &gsn_sword},
    {"mace", OBJ_VNUM_SCHOOL_MACE, WEAPON_MACE, &gsn_mace},
    {"dagger", OBJ_VNUM_SCHOOL_DAGGER, WEAPON_DAGGER, &gsn_dagger},
    {"axe", OBJ_VNUM_SCHOOL_AXE, WEAPON_AXE, &gsn_axe},
    {"staff", OBJ_VNUM_SCHOOL_STAFF, WEAPON_SPEAR, &gsn_spear},
    {"flail", OBJ_VNUM_SCHOOL_FLAIL, WEAPON_FLAIL, &gsn_flail},
    {"whip", OBJ_VNUM_SCHOOL_WHIP, WEAPON_WHIP, &gsn_whip},
    {"polearm", OBJ_VNUM_SCHOOL_POLEARM, WEAPON_POLEARM, &gsn_polearm},
    {NULL, 0, 0, NULL}
};

/* wiznet table and prototype for future flag setting */

const struct wiznet_type wiznet_table[] = {
    {"on", WIZ_ON, 0},
    {"prefix", WIZ_PREFIX, 0},
    {"ticks", WIZ_TICKS, 0},
    {"logins", WIZ_LOGINS, IM},
    {"sites", WIZ_SITES, L4},
    {"links", WIZ_LINKS, L7},
    {"newbies", WIZ_NEWBIE, 0},
    {"spam", WIZ_SPAM, L5},
    {"deaths", WIZ_DEATHS, IM},
    {"resets", WIZ_RESETS, L4},
    {"mobdeaths", WIZ_MOBDEATHS, L4},
    {"flags", WIZ_FLAGS, L5},
    {"penalties", WIZ_PENALTIES, L5},
    {"saccing", WIZ_SACCING, L5},
    {"levels", WIZ_LEVELS, 0},
    {"load", WIZ_LOAD, L2},
    {"restore", WIZ_RESTORE, L2},
    {"snoops", WIZ_SNOOPS, L2},
    {"switches", WIZ_SWITCHES, L2},
    {"secure", WIZ_SECURE, L1},
    {"mem", WIZ_MEM, L5},
    {"bugs", WIZ_BUGS, L5},
    {NULL, 0, 0}
};

/* attack table  -- not very organized :(
 * Be sure to keep MAX_DAMAGE_MESSAGE up
 * to date in merc.h
 */
const struct attack_type attack_table[] = {
    {"none", "hit", -1},        /*  0 */
    {"slice", "slice", DAM_SLASH},
    {"stab", "stab", DAM_PIERCE},
    {"slash", "slash", DAM_SLASH},
    {"whip", "whip", DAM_SLASH},
    {"claw", "claw", DAM_SLASH},    /*  5 */
    {"blast", "blast", DAM_BASH},
    {"pound", "pound", DAM_BASH},
    {"crush", "crush", DAM_BASH},
    {"grep", "grep", DAM_SLASH},
    {"bite", "bite", DAM_PIERCE},   /* 10 */
    {"pierce", "pierce", DAM_PIERCE},
    {"suction", "suction", DAM_BASH},
    {"beating", "beating", DAM_BASH},
    {"digestion", "digestion", DAM_ACID},
    {"charge", "charge", DAM_BASH}, /* 15 */
    {"slap", "slap", DAM_BASH},
    {"punch", "punch", DAM_BASH},
    {"wrath", "wrath", DAM_ENERGY},
    {"magic", "magic", DAM_ENERGY},
    {"divine", "divine power", DAM_HOLY},   /* 20 */
    {"cleave", "cleave", DAM_SLASH},
    {"scratch", "scratch", DAM_PIERCE},
    {"peck", "peck", DAM_PIERCE},
    {"peckb", "peck", DAM_BASH},
    {"chop", "chop", DAM_SLASH},    /* 25 */
    {"sting", "sting", DAM_PIERCE},
    {"smash", "smash", DAM_BASH},
    {"shbite", "shocking bite", DAM_LIGHTNING},
    {"flbite", "flaming bite", DAM_FIRE},
    {"frbite", "freezing bite", DAM_COLD},  /* 30 */
    {"acbite", "acidic bite", DAM_ACID},
    {"chomp", "chomp", DAM_PIERCE},
    {"drain", "life drain", DAM_NEGATIVE},
    {"thrust", "thrust", DAM_PIERCE},
    {"slime", "slime", DAM_ACID},
    {"shock", "shock", DAM_LIGHTNING},
    {"thwack", "thwack", DAM_BASH},
    {"flame", "flame", DAM_FIRE},
    {"chill", "chill", DAM_COLD},
    {"typo", "typo", DAM_SLASH},    /* 40 */
    {NULL, NULL, 0}
};

/* race table */
const struct race_type race_table[] = {
/*
    {
	name,		pc_race?,
	act bits, act2 bits,
	aff_by bits,
	off bits,
	imm,
	res,
	vuln,
	shd bits,
	form,		parts 
    },
*/
    {"unique", FALSE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},

    {
     "Human", TRUE,
     0,
     0,
     0,
     0,
     0,
     0,
     0,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},

    {
     "Mutant", TRUE,
     0,
     0,
     0,
     0,
     0,
     RES_SLASH,
     VULN_MENTAL,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},

    {
     "Elf", TRUE,
     0,
     0,
     AFF_INFRARED,
     0,
     0,
     RES_CHARM,
     VULN_IRON,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},

    {
     "Ent", TRUE,
     0,
     0,
     AFF_INFRARED,
     0,
     0,
     RES_CHARM,
     VULN_FIRE,
     SHD_BRIAR,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},

    {
     "Drow", TRUE,
     0,
     AFF_HIDE | AFF_INFRARED,
     0,
     0,
     RES_CHARM,
     VULN_IRON,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},

    {
     "Dwarf", TRUE,
     0,
     0,
     AFF_INFRARED,
     0,
     0,
     RES_POISON | RES_DISEASE,
     VULN_DROWNING,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},

    {
     "Giant", TRUE,
     0,
     0,
     0,
     0,
     0,
     RES_FIRE | RES_COLD,
     VULN_MENTAL | VULN_LIGHTNING,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},

    {
     "Gryphon", TRUE,
     0,
     AFF_FLYING,
     0,
     0,
     RES_POISON,
     VULN_LIGHTNING,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},

    {
     "Pixie", TRUE,
     0,
     0,
     AFF_FLYING | AFF_DETECT_MAGIC | AFF_INFRARED,
     0,
     0,
     RES_CHARM | RES_MENTAL,
     VULN_IRON,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K | P},

    {
     "Halfling", TRUE,
     0,
     0,
     AFF_PASS_DOOR,
     0,
     0,
     RES_POISON | RES_DISEASE,
     VULN_LIGHT,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},

    {
     "Halforc", TRUE,
     0,
     0,
     AFF_BERSERK,
     0,
     0,
     RES_MAGIC | RES_WEAPON,
     VULN_MENTAL,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},
    {
     "Orc", TRUE,
     0,
     0,
     AFF_BERSERK,
     0,
     0,
     RES_MAGIC | RES_WEAPON,
     VULN_MENTAL,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},
    {
     "Ogre", TRUE,
     0,
     0,
     AFF_BERSERK,
     0,
     0,
     RES_MAGIC | RES_WEAPON,
     VULN_MENTAL,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},
    {
     "Goblin", TRUE,
     0,
     0,
     AFF_INFRARED,
     0,
     0,
     RES_MENTAL,
     VULN_SILVER | VULN_LIGHT | VULN_WOOD | VULN_HOLY,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},

    {
     "Imp", TRUE,
     0,
     0,
     AFF_FLYING,
     0,
     0,
     RES_MENTAL,
     VULN_SILVER | VULN_LIGHT | VULN_WOOD | VULN_HOLY,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},

    {
     "Halfelf", TRUE,
     0,
     0,
     AFF_FARSIGHT,
     0,
     0,
     0,
     0,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},

    {
     "Avian", TRUE,
     0,
     0,
     AFF_FLYING | AFF_DETECT_INVIS | AFF_DETECT_HIDDEN | AFF_FARSIGHT |
     AFF_INFRARED,
     0,
     0,
     RES_LIGHTNING,
     VULN_DISEASE | VULN_POISON,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K | P},
    {
     "Pheonix", TRUE,
     0,
     0,
     AFF_FLYING | AFF_FARSIGHT,
     0,
     IMM_FIRE,
     0,
     VULN_COLD,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K | P},

    {
     "Gnome", TRUE,
     0,
     0,
     AFF_INFRARED,
     0,
     0,
     RES_MENTAL,
     VULN_DROWNING,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},

    {
     "Draconian", TRUE,
     0,
     0,
     AFF_FLYING,
     0,
     IMM_POISON | IMM_DISEASE,
     RES_FIRE | RES_COLD,
     VULN_SLASH | VULN_PIERCE | VULN_LIGHTNING,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K | P | Q},

    {
     "Centaur", TRUE,
     0,
     0,
     0,
     0,
     0,
     0,
     0,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},

    {
     "Gnoll", TRUE,
     0,
     0,
     AFF_DETECT_HIDDEN | AFF_DARK_VISION,
     0,
     0,
     0,
     VULN_SILVER,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K | U | V},

    {
     "Heucuva", TRUE,
     0,
     0,
     AFF_DARK_VISION,
     0,
     IMM_NEGATIVE | IMM_POISON | IMM_DISEASE,
     RES_WEAPON,
     VULN_HOLY | VULN_LIGHT | VULN_SILVER,
     0,
     A | H | M | V, A | B | C | G | H | I | J | K},

    {
     "Demon", TRUE,
     0,
     0,
     AFF_HASTE | AFF_BERSERK,
     0,
     IMM_FIRE,
     0,
     VULN_HOLY | VULN_COLD | VULN_SILVER | VULN_LIGHT,
     0,
     A | H | M | V, A | B | C | G | H | I | J | K},

    {
     "Kenku", TRUE,
     0,
     0,
     AFF_FARSIGHT | AFF_DETECT_HIDDEN | AFF_INFRARED | AFF_FLYING,
     0,
     0,
     RES_COLD,
     0,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K | P},

    {
     "Minotaur", TRUE,
     0,
     0,
     AFF_FARSIGHT,
     0,
     IMM_POISON,
     0,
     VULN_BASH,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K | W},

    {
     "Satyr", TRUE,
     0,
     0,
     AFF_DETECT_HIDDEN | AFF_DETECT_EVIL | AFF_DETECT_GOOD,
     0,
     IMM_FIRE,
     RES_NEGATIVE,
     VULN_HOLY | VULN_LIGHT,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},

    {
     "Shockling", TRUE,
     0,
     0,
     0,
     0,
     IMM_LIGHTNING,
     0,
     0,
     SHD_SHOCK,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},
    {
     "Iceling", TRUE,
     0,
     0,
     0,
     0,
     IMM_COLD,
     0,
     0,
     SHD_ICE,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},
    {
     "Fireling", TRUE,
     0,
     0,
     0,
     0,
     IMM_FIRE,
     0,
     0,
     SHD_FIRE,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},
    {
     "Titan", TRUE,
     0,
     0,
     AFF_DETECT_INVIS | AFF_BERSERK,
     0,
     IMM_CHARM,
     RES_WEAPON,
     0,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K},

    {"Dragon", TRUE,
     0,
     0,
     AFF_INFRARED | AFF_FLYING,
     0,
     0,
     RES_FIRE | RES_BASH | RES_CHARM,
     VULN_PIERCE | VULN_COLD,
     SHD_FIRE,
     A | H | Z, A | C | D | E | F | G | H | I | J | K | P | Q | U | V | X},

    {
     "bat", FALSE,
     0,
     0,
     AFF_FLYING | AFF_DARK_VISION,
     OFF_DODGE | OFF_FAST,
     0,
     0,
     VULN_LIGHT,
     0,
     A | G | V, A | C | D | E | F | H | J | K | P},

    {
     "bear", FALSE,
     0,
     0,
     0,
     OFF_CRUSH | OFF_DISARM | OFF_BERSERK,
     0,
     RES_BASH | RES_COLD,
     0,
     0,
     A | G | V, A | B | C | D | E | F | H | J | K | U | V},

    {
     "cat", FALSE,
     0,
     0,
     AFF_DARK_VISION,
     OFF_FAST | OFF_DODGE,
     0,
     0,
     0,
     0,
     A | G | V, A | C | D | E | F | H | J | K | Q | U | V},

    {
     "centipede", FALSE,
     0,
     0,
     AFF_DARK_VISION,
     0,
     0,
     RES_PIERCE | RES_COLD,
     VULN_BASH,
     0,
     A | B | G | O, A | C | K},

    {
     "dog", FALSE,
     0,
     0,
     0,
     OFF_FAST,
     0,
     0,
     0,
     0,
     A | G | V, A | C | D | E | F | H | J | K | U | V},

    {
     "doll", FALSE,
     0,
     0,
     0,
     0,
     IMM_COLD | IMM_POISON | IMM_HOLY | IMM_NEGATIVE | IMM_MENTAL |
     IMM_DISEASE | IMM_DROWNING,
     RES_BASH | RES_LIGHT,
     VULN_SLASH | VULN_FIRE | VULN_ACID | VULN_LIGHTNING | VULN_ENERGY,
     0,
     E | J | M | cc, A | B | C | G | H | K},
/*
    { 	"dragon", 		FALSE, 
	0,
    0,
	AFF_INFRARED|AFF_FLYING,
	0,
	0,
	RES_FIRE|RES_BASH|RES_CHARM, 
	VULN_PIERCE|VULN_COLD,
	0,
	A|H|Z,		A|C|D|E|F|G|H|I|J|K|P|Q|U|V|X
    },
*/
    {
     "fido", FALSE,
     0,
     0,
     0,
     OFF_DODGE | ASSIST_RACE,
     0,
     0,
     VULN_MAGIC,
     0,
     A | B | G | V, A | C | D | E | F | H | J | K | Q | V},

    {
     "fox", FALSE,
     0,
     0,
     AFF_DARK_VISION,
     OFF_FAST | OFF_DODGE,
     0,
     0,
     0,
     0,
     A | G | V, A | C | D | E | F | H | J | K | Q | V},

    {
     "hobgoblin", FALSE,
     0,
     0,
     AFF_INFRARED,
     0,
     0,
     RES_DISEASE | RES_POISON,
     0,
     0,
     A | H | M | V, A | B | C | D | E | F | G | H | I | J | K | Y},

    {
     "kobold", FALSE,
     0,
     0,
     AFF_INFRARED,
     0,
     0,
     RES_POISON,
     VULN_MAGIC,
     0,
     A | B | H | M | V, A | B | C | D | E | F | G | H | I | J | K | Q},

    {
     "lizard", FALSE,
     0,
     0,
     0,
     0,
     0,
     RES_POISON,
     VULN_COLD,
     0,
     A | G | X | cc, A | C | D | E | F | H | K | Q | V},

    {
     "modron", FALSE,
     0,
     0,
     AFF_INFRARED,
     ASSIST_RACE | ASSIST_ALIGN,
     IMM_CHARM | IMM_DISEASE | IMM_MENTAL | IMM_HOLY | IMM_NEGATIVE,
     RES_FIRE | RES_COLD | RES_ACID,
     0,
     0,
     H, A | B | C | G | H | J | K},
/*
    {
	"orc",			FALSE,
	0,
    0,
	AFF_INFRARED,
	0,
	0,
	RES_DISEASE,
	VULN_LIGHT,
	0,
	A|H|M|V,	A|B|C|D|E|F|G|H|I|J|K
    },
*/
    {
     "pig", FALSE,
     0,
     0,
     0,
     0,
     0,
     0,
     0,
     0,
     A | G | V, A | C | D | E | F | H | J | K},

    {
     "rabbit", FALSE,
     0,
     0,
     0,
     OFF_DODGE | OFF_FAST,
     0,
     0,
     0,
     0,
     A | G | V, A | C | D | E | F | H | J | K},

    {
     "school monster", FALSE,
     ACT_NOALIGN,
     0,
     0,
     0,
     IMM_CHARM | IMM_SUMMON,
     0,
     VULN_MAGIC,
     0,
     A | M | V, A | B | C | D | E | F | H | J | K | Q | U},

    {
     "snake", FALSE,
     0,
     0,
     0,
     0,
     0,
     RES_POISON,
     VULN_COLD,
     0,
     A | G | X | Y | cc, A | D | E | F | K | L | Q | V | X},

    {
     "song bird", FALSE,
     0,
     0,
     AFF_FLYING,
     OFF_FAST | OFF_DODGE,
     0,
     0,
     0,
     0,
     A | G | W, A | C | D | E | F | H | K | P},

    {
     "troll", FALSE,
     0,
     0,
     AFF_REGENERATION | AFF_INFRARED | AFF_DETECT_HIDDEN,
     OFF_BERSERK,
     0,
     RES_CHARM | RES_BASH,
     VULN_FIRE | VULN_ACID,
     0,
     A | B | H | M | V, A | B | C | D | E | F | G | H | I | J | K | U | V},

    {
     "water fowl", FALSE,
     0,
     0,
     AFF_SWIM | AFF_FLYING,
     0,
     0,
     RES_DROWNING,
     0,
     0,
     A | G | W, A | C | D | E | F | H | K | P},

    {
     "wolf", FALSE,
     0,
     0,
     AFF_DARK_VISION,
     OFF_FAST | OFF_DODGE,
     0,
     0,
     0,
     0,
     A | G | V, A | C | D | E | F | J | K | Q | V},

    {
     "wyvern", FALSE,
     0,
     0,
     AFF_FLYING | AFF_DETECT_INVIS | AFF_DETECT_HIDDEN,
     OFF_BASH | OFF_FAST | OFF_DODGE,
     IMM_POISON,
     0,
     VULN_LIGHT,
     0,
     A | B | G | Z, A | C | D | E | F | H | J | K | Q | V | X},

    {"unique", FALSE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},

    {
     NULL, 0, 0, 0, 0, 0, 0, 0}
};

const struct pc_race_type pc_race_table[] = {
    {
     "null race", "",
     0,
     {100, 100, 100, 100, 100, 100, 100,
      100, 100, 100, 100, 100, 100, 100},
     {""},
     {13, 13, 13, 13, 13},
     {18, 18, 18, 18, 18},
     0, 0},

/*
    {
	"race name", 	short name,
	points,
	{ class multipliers },
	{ bonus skills },
	{ base stats },
	{ max stats },
	size, 
        recall,
        tier
    },
*/
    {
     "Human", "Human",
     0,
     {100, 100, 100, 100, 100, 100, 100,
      90, 90, 90, 90, 90, 90, 90,
      85, 85, 85, 85, 85, 85, 85,
      85, 85, 85, 85, 85, 85, 85},
     {""},
     {13, 13, 13, 13, 13},
     {18, 18, 18, 18, 18},
     SIZE_MEDIUM,
     ROOM_VNUM_ALTAR,
     A | B | C | D},

    {
     "Mutant", "Mutant",
     4,
     {100, 115, 110, 100, 100, 100, 100,
      90, 90, 90, 90, 90, 90, 90,
      85, 85, 85, 85, 85, 85, 85,
      85, 85, 85, 85, 85, 85, 85},
     {""},
     {15, 11, 11, 13, 15},
     {20, 14, 14, 18, 20},
     SIZE_MEDIUM,
     1405,
     A | B | C | D},

    {
     "Elf", "Elf",
     5,
     {100, 125, 100, 120, 120, 105, 115,
      90, 113, 90, 108, 95, 95, 104,
      85, 105, 85, 100, 90, 90, 100,
      85, 105, 85, 100, 90, 90, 100},
     {"sneak", "hide"},
     {12, 14, 13, 15, 11},
     {16, 25, 18, 21, 15},
     SIZE_SMALL,
     18052,
     A | B | C | D},

    {
     "Ent", "Ent",
     7,
     {100, 125, 100, 120, 120, 105, 115,
      90, 113, 90, 108, 95, 95, 104,
      85, 105, 85, 100, 90, 90, 100,
      85, 105, 85, 100, 90, 90, 100},
     {"bash"},
     {12, 14, 13, 15, 16},
     {16, 20, 18, 21, 25},
     SIZE_LARGE,
     18052,
     A | B | C | D},

    {
     "Drow", "Drow",
     6,
     {100, 125, 100, 120, 120, 105, 115,
      90, 113, 90, 108, 95, 95, 104,
      85, 105, 85, 100, 90, 90, 100,
      85, 105, 85, 100, 90, 90, 100},
     {"dodge"},
     {12, 14, 13, 15, 11},
     {16, 20, 18, 21, 15},
     SIZE_SMALL,
     ROOM_VNUM_ALTAR,
     A | B | C | D},

    {
     "Dwarf", "Dwarf",
     8,
     {150, 100, 125, 100, 110, 110, 110,
      135, 90, 113, 90, 113, 99, 99,
      130, 85, 105, 85, 105, 95, 95,
      130, 85, 105, 85, 105, 95, 95},
     {"berserk"},
     {14, 12, 13, 11, 15},
     {20, 16, 19, 15, 21},
     SIZE_MEDIUM,
     ROOM_VNUM_ALTAR,
     A | B | C | D},

    {
     "Giant", "Giant",
     6,
     {200, 125, 150, 105, 125, 150, 120,
      180, 113, 135, 95, 135, 135, 108,
      175, 105, 130, 90, 130, 130, 100,
      175, 105, 130, 90, 130, 130, 100},
     {"bash", "fast healing"},
     {16, 11, 13, 11, 14},
     {22, 15, 18, 15, 20},
     SIZE_LARGE,
     1000,
     A | B | C | D},

    {
     "Gryphon", "Gryph",
     7,
     {100, 125, 100, 120, 120, 105, 115,
      90, 113, 90, 108, 95, 95, 104,
      85, 105, 85, 100, 90, 90, 100,
      85, 105, 85, 100, 90, 90, 100},
     {"berserk"},
     {12, 14, 13, 10, 15},
     {18, 16, 18, 13, 18},
     SIZE_MEDIUM,
     ROOM_VNUM_ALTAR,
     A | B | C | D},

    {
     "Pixie", "Pixie",
     6,
     {100, 100, 120, 200, 150, 100, 150,
      90, 90, 108, 180, 95, 90, 135,
      85, 85, 100, 175, 90, 85, 130,
      85, 85, 100, 175, 90, 85, 130},
     {""},
     {10, 15, 15, 15, 10},
     {14, 21, 21, 20, 14},
     SIZE_TINY,
     ROOM_VNUM_ALTAR,
     A | B | C | D},

    {
     "Halfling", "Hfling",
     5,
     {105, 120, 100, 150, 150, 120, 120,
      95, 108, 90, 135, 108, 108, 108,
      90, 100, 85, 130, 100, 100, 100,
      90, 100, 85, 130, 100, 100, 100},
     {"sneak", "hide"},
     {11, 14, 12, 15, 13},
     {15, 20, 16, 21, 18},
     SIZE_SMALL,
     18052,
     A | B | C | D},

    {
     "Halforc", "Hf-Orc",
     6,
     {200, 200, 120, 100, 125, 150, 105,
      180, 180, 108, 90, 135, 135, 95,
      175, 175, 100, 85, 130, 130, 90,
      175, 175, 100, 85, 130, 130, 90},
     {"fast healing"},
     {14, 11, 11, 14, 15},
     {19, 15, 15, 20, 21},
     SIZE_MEDIUM,
     ROOM_VNUM_TEMPLE,
     A | B | C | D},
    {
     "Orc", "Orc",
     7,
     {200, 200, 120, 100, 125, 150, 105,
      180, 180, 108, 90, 135, 135, 95,
      175, 175, 100, 85, 130, 130, 90,
      175, 175, 100, 85, 130, 130, 90},
     {"fast healing"},
     {16, 11, 11, 14, 15},
     {22, 13, 13, 19, 23},
     SIZE_MEDIUM,
     1416,
     A | B | C | D},
    {
     "Ogre", "Ogre",
     7,
     {200, 200, 120, 100, 125, 150, 105,
      180, 180, 108, 90, 135, 135, 95,
      175, 175, 100, 85, 130, 130, 90,
      175, 175, 100, 85, 130, 130, 90},
     {"fast healing"},
     {16, 11, 11, 14, 15},
     {24, 14, 13, 16, 23},
     SIZE_MEDIUM,
     1416,
     A | B | C | D},

    {
     "Goblin", "Goblin",
     5,
     {105, 125, 110, 125, 120, 120, 110,
      95, 113, 99, 113, 99, 108, 99,
      90, 105, 95, 105, 95, 100, 95,
      90, 105, 95, 105, 95, 100, 95},
     {"sneak", "hide"},
     {11, 14, 12, 15, 14},
     {16, 20, 16, 19, 20},
     SIZE_SMALL,
     1411,
     A | B | C | D},

    {
     "Imp", "Imp",
     5,
     {105, 125, 110, 125, 120, 120, 110,
      95, 113, 99, 113, 99, 108, 99,
      90, 105, 95, 105, 95, 100, 95,
      90, 105, 95, 105, 95, 100, 95},
     {"sneak", "hide"},
     {11, 8, 12, 15, 14},
     {14, 12, 16, 19, 16},
     SIZE_SMALL,
     ROOM_VNUM_ALTAR,
     A | B | C | D},

    {
     "Halfelf", "Hf-Elf",
     2,
     {105, 105, 105, 105, 105, 105, 105,
      95, 95, 95, 95, 95, 95, 95,
      90, 90, 90, 90, 90, 90, 90,
      90, 90, 90, 90, 90, 90, 90},
     {""},
     {12, 13, 14, 13, 13},
     {17, 18, 19, 18, 18},
     SIZE_MEDIUM,
     18052,
     A | B | C | D},

    {
     "Avian", "Avian",
     5,
     {110, 105, 150, 125, 120, 100, 120,
      99, 95, 135, 113, 108, 90, 108,
      95, 90, 130, 105, 100, 85, 100,
      95, 90, 130, 105, 100, 85, 100},
     {""},
     {12, 14, 15, 11, 12},
     {17, 19, 20, 16, 17},
     SIZE_LARGE,
     ROOM_VNUM_ALTAR,
     A | B | C | D},
    {
     "Pheonix", "Pheox",
     6,
     {110, 105, 150, 125, 120, 100, 120,
      99, 95, 135, 113, 108, 90, 108,
      95, 90, 130, 105, 100, 85, 100,
      95, 90, 130, 105, 100, 85, 100},
     {""},
     {12, 14, 15, 11, 12},
     {18, 19, 20, 16, 17},
     SIZE_LARGE,
     ROOM_VNUM_ALTAR,
     A | B | C | D},

    {
     "Gnome", "Gnome",
     4,
     {100, 110, 150, 150, 125, 105, 150,
      90, 99, 135, 135, 99, 95, 135,
      85, 95, 130, 130, 95, 90, 130,
      85, 95, 130, 130, 95, 90, 130},
     {""},
     {11, 15, 14, 12, 12},
     {16, 20, 19, 15, 15},
     SIZE_SMALL,
     ROOM_VNUM_ALTAR,
     A | B | C | D},

    {
     "Draconian", "Dracon",
     11,
     {125, 150, 200, 100, 110, 125, 150,
      113, 135, 180, 90, 108, 113, 135,
      105, 130, 175, 85, 100, 105, 130,
      105, 130, 175, 85, 100, 105, 130},
     {"fast healing"},
     {16, 13, 12, 11, 15},
     {22, 18, 16, 15, 21},
     SIZE_HUGE,
     1000,
     A | B | C | D},

    {
     "Centaur", "Centr",
     9,
     {100, 110, 100, 175, 110, 110, 95,
      90, 100, 90, 165, 100, 100, 85,
      85, 95, 85, 160, 95, 95, 80,
      85, 95, 85, 160, 95, 95, 80},
     {"enhanced damage"},
     {15, 12, 10, 8, 16},
     {20, 17, 15, 13, 21},
     SIZE_LARGE,
     ROOM_VNUM_ALTAR,
     A | B | C | D},

    {
     "Gnoll", "Gnoll",
     7,
     {110, 110, 125, 110, 175, 110, 110,
      100, 100, 115, 100, 165, 100, 100,
      95, 95, 110, 95, 160, 95, 95,
      95, 95, 110, 95, 160, 95, 95},
     {""},
     {15, 11, 10, 16, 15},
     {20, 16, 15, 20, 19},
     SIZE_LARGE,
     1423,
     A | B | C | D},

    {
     "Heucuva", "Heuc",
     10,
     {110, 110, 110, 100, 110, 110, 100,
      100, 100, 100, 90, 100, 100, 90,
      95, 95, 95, 85, 95, 95, 85,
      95, 95, 95, 85, 95, 95, 85},
     {"second attack"},
     {20, 5, 5, 20, 20},
     {25, 10, 10, 25, 25},
     SIZE_MEDIUM,
     ROOM_VNUM_ALTAR,
     A | B | C | D},

    {
     "Demon", "Demon",
     10,
     {110, 110, 110, 100, 110, 110, 100,
      100, 100, 100, 90, 100, 100, 90,
      95, 95, 95, 85, 95, 95, 85,
      95, 95, 95, 85, 95, 95, 85},
     {"berserk"},
     {15, 10, 10, 13, 16},
     {22, 15, 16, 19, 22},
     SIZE_MEDIUM,
     ROOM_VNUM_ALTAR,
     A | B | C | D},

    {
     "Kenku", "Kenku",
     5,
     {125, 110, 150, 150, 110, 125, 180,
      115, 100, 140, 140, 100, 115, 170,
      110, 95, 135, 135, 95, 110, 165,
      110, 95, 135, 135, 95, 110, 165},
     {"meditation"},
     {14, 14, 16, 15, 14},
     {19, 19, 21, 20, 19},
     SIZE_MEDIUM,
     ROOM_VNUM_ALTAR,
     A | B | C | D},

    {
     "Minotaur", "Minotr",
     7,
     {110, 110, 110, 95, 110, 110, 110,
      100, 100, 100, 85, 100, 100, 100,
      95, 95, 95, 80, 95, 95, 95,
      95, 95, 95, 80, 95, 95, 95},
     {"enhanced damage"},
     {18, 11, 10, 11, 17},
     {23, 16, 15, 16, 22},
     SIZE_LARGE,
     ROOM_VNUM_ALTAR,
     A | B | C | D},

    {
     "Satyr", "Satyr",
     6,
     {110, 110, 110, 175, 110, 110, 150,
      100, 100, 100, 165, 100, 100, 140,
      95, 95, 95, 160, 95, 95, 135,
      95, 95, 95, 160, 95, 95, 135},
     {""},
     {18, 14, 5, 9, 16},
     {23, 19, 10, 14, 21},
     SIZE_LARGE,
     ROOM_VNUM_ALTAR,
     A | B | C | D},

    {
     "Shockling", "Shock",
     12,
     {200, 125, 200, 105, 125, 150, 120,
      180, 113, 165, 95, 135, 135, 108,
      175, 105, 160, 90, 130, 130, 105,
      175, 105, 160, 90, 130, 130, 105},
     {"bash", "fast healing"},
     {10, 12, 13, 12, 17},
     {19, 16, 18, 16, 25},
     SIZE_MEDIUM,
     ROOM_VNUM_ALTAR,
     A | B | C | D},
    {
     "Iceling", "Icel",
     12,
     {200, 125, 200, 105, 125, 150, 120,
      180, 113, 165, 95, 135, 135, 108,
      175, 105, 160, 90, 130, 130, 105,
      175, 105, 160, 90, 130, 130, 105},
     {"bash", "fast healing"},
     {10, 12, 13, 12, 17},
     {19, 16, 18, 16, 25},
     SIZE_MEDIUM,
     ROOM_VNUM_ALTAR,
     A | B | C | D},
    {
     "Fireling", "Firel",
     12,
     {200, 125, 200, 105, 125, 150, 120,
      180, 113, 165, 95, 135, 135, 108,
      175, 105, 160, 90, 130, 130, 105,
      175, 105, 160, 90, 130, 130, 105},
     {"bash", "fast healing"},
     {10, 12, 13, 12, 17},
     {19, 16, 18, 16, 25},
     SIZE_MEDIUM,
     ROOM_VNUM_ALTAR,
     A | B | C | D},

    {
     "Titan", "Titan",
     11,
     {180, 105, 130, 105, 105, 130, 100,
      170, 93, 115, 95, 95, 115, 98,
      165, 90, 110, 90, 90, 110, 90,
      165, 90, 110, 90, 90, 110, 90},
     {"fast healing"},
     {20, 13, 13, 10, 20},
     {25, 18, 18, 15, 25},
     SIZE_GIANT,
     1000,
     A | B | C | D},

    {
     "Dragon", "Dragn",
     30,
     {280, 280, 280, 280, 280, 280, 280,
      275, 275, 275, 275, 275, 275, 275,
      270, 270, 270, 270, 270, 270, 270,
      270, 270, 270, 270, 270, 270, 270},
     {"berserk"},
     {20, 20, 20, 20, 20},
     {25, 25, 25, 25, 25},
     SIZE_GIANT,
     1000,
     A | B | C | D}

};

/*
 * Class table.
 */
const struct class_type class_table[MAX_CLASS] = {

/*
    {
	name, who, attr_prime, weapon,
	{guild1, guild2, guild3}, thac0_00, thac0_32, hp_min, hp_max, mana?,
	base_group, default_group
    }
*/

    {
     "Mage", "Mag", STAT_INT, OBJ_VNUM_SCHOOL_DAGGER,
     {3018, 9618, 18113}, 75, 20, 6, 10, 20, TRUE,
     "mage basics", "mage default",
     TIER_01,
     TIER_02},

    {
     "Cleric", "Cle", STAT_WIS, OBJ_VNUM_SCHOOL_MACE,
     {3003, 9619, 5699}, 75, 20, 2, 10, 20, TRUE,
     "cleric basics", "cleric default",
     TIER_01,
     TIER_02},

    {
     "Rogue", "Rog", STAT_DEX, OBJ_VNUM_SCHOOL_DAGGER,
     {3028, 9639, 5633}, 75, 20, -4, 14, 24, FALSE,
     "rogue basics", "rogue default",
     TIER_01,
     TIER_02},

    {
     "Warrior", "War", STAT_STR, OBJ_VNUM_SCHOOL_SWORD,
     {3022, 9633, 5613}, 75, 20, -10, 20, 30, FALSE,
     "warrior basics", "warrior default",
     TIER_01,
     TIER_02},

    {
     "Tracker", "Trk", STAT_STR, OBJ_VNUM_SCHOOL_SPEAR,
     {3372, 9752, 18111}, 75, 20, -4, 14, 24, TRUE,
     "tracker basics", "tracker default",
     TIER_01,
     TIER_02},

    {
     "Druid", "Dru", STAT_WIS, OBJ_VNUM_SCHOOL_POLEARM,
     {3369, 9755, 18111}, 75, 20, 0, 10, 20, TRUE,
     "druid basics", "druid default",
     TIER_01,
     TIER_02},
    {
     "Revenant", "Rev", STAT_CON, OBJ_VNUM_SCHOOL_DAGGER,
     {3375, 9758, 18113}, 75, 20, -30, 12, 22, TRUE,
     "revenant basics", "revenant default",
     TIER_01,
     TIER_02},

    {
     "Wizard", "Wiz", STAT_INT, OBJ_VNUM_SCHOOL_DAGGER,
     {3018, 9618, 18113}, 75, 10, -4, 25, 35, TRUE,
     "wizard basics", "wizard default",
     TIER_02,
     TIER_03},

    {
     "Priest", "Prs", STAT_WIS, OBJ_VNUM_SCHOOL_MACE,
     {3003, 9619, 5699}, 75, 10, 2, 25, 35, TRUE,
     "priest basics", "priest default",
     TIER_02,
     TIER_03},

    {
     "Thief", "Thi", STAT_DEX, OBJ_VNUM_SCHOOL_DAGGER,
     {3028, 9639, 5633}, 75, 10, -14, 30, 40, FALSE,
     "thief basics", "thief default",
     TIER_02,
     TIER_03},

    {
     "Berserker", "Brk", STAT_STR, OBJ_VNUM_SCHOOL_SWORD,
     {3022, 9633, 5613}, 75, 10, -20, 40, 50, FALSE,
     "warrior basics", "warrior default",
     TIER_02,
     TIER_03},

    {
     "Hunter", "Hnt", STAT_INT, OBJ_VNUM_SCHOOL_DAGGER,
     {3372, 9752, 18111}, 75, 10, -14, 26, 36, TRUE,
     "hunter basics", "hunter default",
     TIER_02,
     TIER_03},

    {
     "Shaman", "Shm", STAT_WIS, OBJ_VNUM_SCHOOL_POLEARM,
     {3369, 9755, 18111}, 75, 10, -10, 25, 35, TRUE,
     "shaman basics", "shaman default",
     TIER_02,
     TIER_03},
    {
     "Vampire", "Vam", STAT_CON, OBJ_VNUM_SCHOOL_DAGGER,
     {3375, 9758, 18113}, 75, 20, -30, 26, 36, TRUE,
     "vampire basics", "vampire default",
     TIER_02,
     TIER_03},

    {
     "Invoker", "Inv", STAT_INT, OBJ_VNUM_SCHOOL_DAGGER,
     {3018, 9618, 18113}, 75, 10, -4, 30, 40, TRUE,
     "invoker basics", "invoker default",
     TIER_03,
     TIER_04},

    {
     "Bishop", "Bsh", STAT_WIS, OBJ_VNUM_SCHOOL_MACE,
     {3003, 9619, 5699}, 75, 10, 2, 30, 40, TRUE,
     "bishop basics", "bishop default",
     TIER_03,
     TIER_04},

    {
     "Mercenary", "Mrc", STAT_DEX, OBJ_VNUM_SCHOOL_DAGGER,
     {3028, 9639, 5633}, 75, 10, -14, 40, 50, FALSE,
     "mercenary basics", "mercenary default",
     TIER_03,
     TIER_04},

    {
     "Gladiator", "Gld", STAT_STR, OBJ_VNUM_SCHOOL_SWORD,
     {3022, 9633, 5613}, 75, 10, -20, 55, 65, FALSE,
     "gladiator basics", "gladiator default",
     TIER_03,
     TIER_04},
    {
     "Ranger", "Ran", STAT_INT, OBJ_VNUM_SCHOOL_DAGGER,
     {3372, 9752, 18111}, 75, 10, -14, 38, 48, TRUE,
     "ranger basics", "ranger default",
     TIER_03,
     TIER_04},

    {
     "Sage", "Sge", STAT_WIS, OBJ_VNUM_SCHOOL_POLEARM,
     {3369, 9755, 18111}, 75, 10, -10, 35, 45, TRUE,
     "sage basics", "sage default",
     TIER_03,
     TIER_04},

    {
     "Lich", "Lic", STAT_CON, OBJ_VNUM_SCHOOL_DAGGER,
     {3375, 9758, 18113}, 75, 10, -40, 38, 48, TRUE,
     "lich basics", "lich default",
     TIER_03,
     TIER_04},

    {
     "Sorcerer", "Sor", STAT_INT, OBJ_VNUM_SCHOOL_DAGGER,
     {3018, 9618, 18113}, 75, 10, -4, 40, 50, TRUE,
     "sorcerer basics", "sorcerer default",
     TIER_04,
     TIER_04},

    {
     "Templar", "Tmp", STAT_WIS, OBJ_VNUM_SCHOOL_MACE,
     {3003, 9619, 5699}, 75, 10, 2, 40, 50, TRUE,
     "templar basics", "templar default",
     TIER_04,
     TIER_04},

    {
     "Assassin", "Asn", STAT_DEX, OBJ_VNUM_SCHOOL_DAGGER,
     {3028, 9639, 5633}, 75, 10, -14, 48, 58, FALSE,
     "assassin basics", "assassin default",
     TIER_04,
     TIER_04},

    {
     "Knight", "Kni", STAT_STR, OBJ_VNUM_SCHOOL_SWORD,
     {3022, 9633, 5613}, 75, 10, -20, 75, 85, FALSE,
     "knight basics", "knight default",
     TIER_04,
     TIER_04},
    {
     "Strider", "Str", STAT_INT, OBJ_VNUM_SCHOOL_DAGGER,
     {3372, 9752, 18111}, 75, 10, -14, 48, 58, TRUE,
     "strider basics", "strider default",
     TIER_04,
     TIER_04},

    {
     "Elder", "Eld", STAT_WIS, OBJ_VNUM_SCHOOL_POLEARM,
     {3369, 9755, 18111}, 75, 10, -10, 45, 55, TRUE,
     "elder basics", "elder default",
     TIER_04,
     TIER_04},

    {
     "Cainite", "Cnt", STAT_CON, OBJ_VNUM_SCHOOL_DAGGER,
     {3375, 9758, 18113}, 75, 10, -40, 58, 68, TRUE,
     "cainite basics", "cainite default",
     TIER_04,
     TIER_04}

};

/*
 * Titles.
 */
char *const title_table[MAX_CLASS][MAX_LEVEL + 1][2] = {

/*	Mage	*/

    {
     {"Man", "Woman"},

     {"Novice of Magic", "Novice of Magic"},
     {"Apprentice of Magic", "Apprentice of Magic"},
     {"Spell Novice", "Spell Novice"},
     {"Spell Student", "Spell Student"},
     {"Scholar of Magic", "Scholar of Magic"},
     {"Scholar of Wizardry", "Scholar of Wizardry"},
     {"Delver in Scrolls", "Delveress in Scrolls"},
     {"Delver in Spells", "Delveress in Spells"},
     {"Medium of Magic", "Medium of Magic"},
     {"Medium of Wizardry", "Medium of Wizardry"},
     {"Scribe of Magic", "Scribess of Magic"},
     {"Scribe of Wizardry", "Scribess of Wizardry"},
     {"Minor Seer", "Minor Seeress"},
     {"Seer", "Seeress"},
     {"Minor Sage", "Minor Sage"},
     {"Sage", "Sage"},
     {"Minor Illusionist", "Minor Illusionist"},
     {"Illusionist", "Illusionist"},
     {"Minor Abjurer", "Minor Abjuress"},
     {"Abjurer", "Abjuress"},
     {"Minor Invoker", "Minor Invoker"},
     {"Invoker", "Invoker"},
     {"Minor Enchanter", "Minor Enchantress"},
     {"Enchanter", "Enchantress"},
     {"Minor Conjurer", "Minor Conjuress"},
     {"Conjurer", "Conjuress"},
     {"Minor Magician", "Minor Witch"},
     {"Magician", "Witch"},
     {"Minor Creator", "Minor Creator"},
     {"Creator", "Creator"},
     {"Minor Savant", "Minor Savant"},
     {"Savant", "Savant"},
     {"Minor Magus", "Minor Craftess"},
     {"Magus", "Craftess"},
     {"Minor Wizard", "Minor Wizard"},
     {"Wizard", "Wizard"},
     {"Minor Warlock", "Minor War Witch"},
     {"Warlock", "War Witch"},
     {"Minor Sorcerer", "Minor Sorceress"},
     {"Sorcerer", "Sorceress"},
     {"Elder Sorcerer", "Elder Sorceress"},
     {"Elder Sorcerer", "Elder Sorceress"},
     {"Grand Sorcerer", "Grand Sorceress"},
     {"Grand Sorcerer", "Grand Sorceress"},
     {"Great Sorcerer", "Great Sorceress"},
     {"Great Sorcerer", "Great Sorceress"},
     {"Golem Maker", "Golem Maker"},
     {"Golem Maker", "Golem Maker"},
     {"Greater Golem Maker", "Greater Golem Maker"},
     {"Greater Golem Maker", "Greater Golem Maker"},
     {"Maker of Stones", "Maker of Stones",},
     {"Maker of Stones", "Maker of Stones",},
     {"Maker of Potions", "Maker of Potions",},
     {"Maker of Potions", "Maker of Potions",},
     {"Maker of Scrolls", "Maker of Scrolls",},
     {"Maker of Scrolls", "Maker of Scrolls",},
     {"Maker of Wands", "Maker of Wands",},
     {"Maker of Wands", "Maker of Wands",},
     {"Maker of Staves", "Maker of Staves",},
     {"Maker of Staves", "Maker of Staves",},
     {"Demon Summoner", "Demon Summoner"},
     {"Demon Summoner", "Demon Summoner"},
     {"Greater Demon Summoner", "Greater Demon Summoner"},
     {"Greater Demon Summoner", "Greater Demon Summoner"},
     {"Dragon Charmer", "Dragon Charmer"},
     {"Dragon Charmer", "Dragon Charmer"},
     {"Greater Dragon Charmer", "Greater Dragon Charmer"},
     {"Greater Dragon Charmer", "Greater Dragon Charmer"},
     {"Master of all Magic", "Master of all Magic"},
     {"Master of all Magic", "Master of all Magic"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Mage Hero", "Mage Heroine"},
     {"Squire of Magic", "Squire of Magic"},
     {"Knight of Magic", "Dame of Magic"},
     {"Demigod of Magic", "Demigoddess of Magic"},
     {"Immortal of Magic", "Immortal of Magic"},
     {"God of Magic", "Goddess of Magic"},
     {"Deity of Magic", "Deity of Magic"},
     {"Supremity of Magic", "Supremity of Magic"},
     {"Creator", "Creator"},
     {"Supreme Deity", "Supreme Deity"}
     },

/*	Cleric	*/

    {
     {"Man", "Woman"},

     {"Believer", "Believer"},
     {"Believer", "Believer"},
     {"Attendant", "Attendant"},
     {"Attendant", "Attendant"},
     {"Acolyte", "Acolyte"},
     {"Acolyte", "Acolyte"},
     {"Novice", "Novice"},
     {"Novice", "Novice"},
     {"Missionary", "Missionary"},
     {"Missionary", "Missionary"},
     {"Adept", "Adept"},
     {"Adept", "Adept"},
     {"Deacon", "Deaconess"},
     {"Deacon", "Deaconess"},
     {"Vicar", "Vicaress"},
     {"Vicar", "Vicaress"},
     {"Priest", "Priestess"},
     {"Priest", "Priestess"},
     {"Minister", "Lady Minister"},
     {"Minister", "Lady Minister"},
     {"Canon", "Canon"},
     {"Canon", "Canon"},
     {"Levite", "Levitess"},
     {"Levite", "Levitess"},
     {"Curate", "Curess"},
     {"Curate", "Curess"},
     {"Monk", "Nun"},
     {"Monk", "Nun"},
     {"Healer", "Healess"},
     {"Healer", "Healess"},
     {"Chaplain", "Chaplain"},
     {"Chaplain", "Chaplain"},
     {"Expositor", "Expositress"},
     {"Expositor", "Expositress"},
     {"Bishop", "Bishop"},
     {"Bishop", "Bishop"},
     {"Arch Bishop", "Arch Lady of the Church"},
     {"Arch Bishop", "Arch Lady of the Church"},
     {"Patriarch", "Matriarch"},
     {"Patriarch", "Matriarch"},
     {"Elder Patriarch", "Elder Matriarch"},
     {"Elder Patriarch", "Elder Matriarch"},
     {"Grand Patriarch", "Grand Matriarch"},
     {"Grand Patriarch", "Grand Matriarch"},
     {"Great Patriarch", "Great Matriarch"},
     {"Great Patriarch", "Great Matriarch"},
     {"Demon Killer", "Demon Killer"},
     {"Demon Killer", "Demon Killer"},
     {"Greater Demon Killer", "Greater Demon Killer"},
     {"Greater Demon Killer", "Greater Demon Killer"},
     {"Cardinal of the Sea", "Cardinal of the Sea"},
     {"Cardinal of the Sea", "Cardinal of the Sea"},
     {"Cardinal of the Earth", "Cardinal of the Earth"},
     {"Cardinal of the Earth", "Cardinal of the Earth"},
     {"Cardinal of the Air", "Cardinal of the Air"},
     {"Cardinal of the Air", "Cardinal of the Air"},
     {"Cardinal of the Ether", "Cardinal of the Ether"},
     {"Cardinal of the Ether", "Cardinal of the Ether"},
     {"Cardinal of the Heavens", "Cardinal of the Heavens"},
     {"Cardinal of the Heavens", "Cardinal of the Heavens"},
     {"Avatar of an Immortal", "Avatar of an Immortal"},
     {"Avatar of an Immortal", "Avatar of an Immortal"},
     {"Avatar of a Deity", "Avatar of a Deity"},
     {"Avatar of a Deity", "Avatar of a Deity"},
     {"Avatar of a Supremity", "Avatar of a Supremity"},
     {"Avatar of a Supremity", "Avatar of a Supremity"},
     {"Avatar of an Implementor", "Avatar of an Implementor"},
     {"Avatar of an Implementor", "Avatar of an Implementor"},
     {"Master of all Divinity", "Mistress of all Divinity"},
     {"Master of all Divinity", "Mistress of all Divinity"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Holy Hero", "Holy Heroine"},
     {"Holy Squire", "Holy Squire"},
     {"Holy Knight", "Holy Dame"},
     {"Demigod", "Demigoddess",},
     {"Immortal", "Immortal"},
     {"God", "Goddess"},
     {"Deity", "Deity"},
     {"Supreme Master", "Supreme Mistress"},
     {"Creator", "Creator"},
     {"Supreme Deity", "Supreme Deity"}
     },

/*	Thief	*/

    {
     {"Man", "Woman"},

     {"Pilferer", "Pilferess"},
     {"Pilferer", "Pilferess"},
     {"Footpad", "Footpad"},
     {"Footpad", "Footpad"},
     {"Filcher", "Filcheress"},
     {"Filcher", "Filcheress"},
     {"Pick-Pocket", "Pick-Pocket"},
     {"Pick-Pocket", "Pick-Pocket"},
     {"Sneak", "Sneak"},
     {"Sneak", "Sneak"},
     {"Pincher", "Pincheress"},
     {"Pincher", "Pincheress"},
     {"Cut-Purse", "Cut-Purse"},
     {"Cut-Purse", "Cut-Purse"},
     {"Snatcher", "Snatcheress"},
     {"Snatcher", "Snatcheress"},
     {"Sharper", "Sharpress"},
     {"Sharper", "Sharpress"},
     {"Rogue", "Rogue"},
     {"Rogue", "Rogue"},
     {"Robber", "Robber"},
     {"Robber", "Robber"},
     {"Magsman", "Magswoman"},
     {"Magsman", "Magswoman"},
     {"Highwayman", "Highwaywoman"},
     {"Highwayman", "Highwaywoman"},
     {"Burglar", "Burglaress"},
     {"Burglar", "Burglaress"},
     {"Thief", "Thief"},
     {"Thief", "Thief"},
     {"Knifer", "Knifer"},
     {"Knifer", "Knifer"},
     {"Quick-Blade", "Quick-Blade"},
     {"Quick-Blade", "Quick-Blade"},
     {"Killer", "Murderess"},
     {"Killer", "Murderess"},
     {"Brigand", "Brigand"},
     {"Brigand", "Brigand"},
     {"Cut-Throat", "Cut-Throat"},
     {"Cut-Throat", "Cut-Throat"},
     {"Spy", "Spy"},
     {"Spy", "Spy"},
     {"Grand Spy", "Grand Spy"},
     {"Grand Spy", "Grand Spy"},
     {"Master Spy", "Master Spy"},
     {"Master Spy", "Master Spy"},
     {"Assassin", "Assassin"},
     {"Assassin", "Assassin"},
     {"Greater Assassin", "Greater Assassin"},
     {"Greater Assassin", "Greater Assassin"},
     {"Master of Vision", "Mistress of Vision"},
     {"Master of Vision", "Mistress of Vision"},
     {"Master of Hearing", "Mistress of Hearing"},
     {"Master of Hearing", "Mistress of Hearing"},
     {"Master of Smell", "Mistress of Smell"},
     {"Master of Smell", "Mistress of Smell"},
     {"Master of Taste", "Mistress of Taste"},
     {"Master of Taste", "Mistress of Taste"},
     {"Master of Touch", "Mistress of Touch"},
     {"Master of Touch", "Mistress of Touch"},
     {"Crime Lord", "Crime Mistress"},
     {"Crime Lord", "Crime Mistress"},
     {"Infamous Crime Lord", "Infamous Crime Mistress"},
     {"Infamous Crime Lord", "Infamous Crime Mistress"},
     {"Greater Crime Lord", "Greater Crime Mistress"},
     {"Greater Crime Lord", "Greater Crime Mistress"},
     {"Master Crime Lord", "Master Crime Mistress"},
     {"Master Crime Lord", "Master Crime Mistress"},
     {"Godfather", "Godmother"},
     {"Godfather", "Godmother"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Assassin Hero", "Assassin Heroine"},
     {"Squire of Death", "Squire of Death",},
     {"Knight of Death", "Dame of Death"},
     {"Demigod of Assassins", "Demigoddess of Assassins"},
     {"Immortal Assasin", "Immortal Assassin"},
     {"God of Assassins", "God of Assassins",},
     {"Deity of Assassins", "Deity of Assassins"},
     {"Supreme Master", "Supreme Mistress"},
     {"Creator", "Creator"},
     {"Supreme Deity", "Supreme Deity"}
     },

/*	Warrior	*/

    {
     {"Man", "Woman"},

     {"Swordpupil", "Swordpupil"},
     {"Swordpupil", "Swordpupil"},
     {"Recruit", "Recruit"},
     {"Recruit", "Recruit"},
     {"Sentry", "Sentress"},
     {"Sentry", "Sentress"},
     {"Fighter", "Fighter"},
     {"Fighter", "Fighter"},
     {"Soldier", "Soldier"},
     {"Soldier", "Soldier"},
     {"Warrior", "Warrior"},
     {"Warrior", "Warrior"},
     {"Veteran", "Veteran"},
     {"Veteran", "Veteran"},
     {"Swordsman", "Swordswoman"},
     {"Swordsman", "Swordswoman"},
     {"Fencer", "Fenceress"},
     {"Fencer", "Fenceress"},
     {"Combatant", "Combatess"},
     {"Combatant", "Combatess"},
     {"Hero", "Heroine"},
     {"Hero", "Heroine"},
     {"Myrmidon", "Myrmidon"},
     {"Myrmidon", "Myrmidon"},
     {"Swashbuckler", "Swashbuckleress"},
     {"Swashbuckler", "Swashbuckleress"},
     {"Mercenary", "Mercenaress"},
     {"Mercenary", "Mercenaress"},
     {"Swordmaster", "Swordmistress"},
     {"Swordmaster", "Swordmistress"},
     {"Lieutenant", "Lieutenant"},
     {"Lieutenant", "Lieutenant"},
     {"Champion", "Lady Champion"},
     {"Champion", "Lady Champion"},
     {"Dragoon", "Lady Dragoon"},
     {"Dragoon", "Lady Dragoon"},
     {"Cavalier", "Lady Cavalier"},
     {"Cavalier", "Lady Cavalier"},
     {"Knight", "Lady Knight"},
     {"Knight", "Lady Knight"},
     {"Grand Knight", "Grand Knight"},
     {"Grand Knight", "Grand Knight"},
     {"Master Knight", "Master Knight"},
     {"Master Knight", "Master Knight"},
     {"Strider", "Strider"},
     {"Strider", "Strider"},
     {"Grand Strider", "Grand Strider"},
     {"Grand Strider", "Grand Strider"},
     {"Demon Slayer", "Demon Slayer"},
     {"Demon Slayer", "Demon Slayer"},
     {"Greater Demon Slayer", "Greater Demon Slayer"},
     {"Greater Demon Slayer", "Greater Demon Slayer"},
     {"Dragon Slayer", "Dragon Slayer"},
     {"Dragon Slayer", "Dragon Slayer"},
     {"Greater Dragon Slayer", "Greater Dragon Slayer"},
     {"Greater Dragon Slayer", "Greater Dragon Slayer"},
     {"Underlord", "Underlord"},
     {"Underlord", "Underlord"},
     {"Overlord", "Overlord"},
     {"Overlord", "Overlord"},
     {"Baron of Thunder", "Baroness of Thunder"},
     {"Baron of Thunder", "Baroness of Thunder"},
     {"Baron of Storms", "Baroness of Storms"},
     {"Baron of Storms", "Baroness of Storms"},
     {"Baron of Tornadoes", "Baroness of Tornadoes"},
     {"Baron of Tornadoes", "Baroness of Tornadoes"},
     {"Baron of Hurricanes", "Baroness of Hurricanes"},
     {"Baron of Hurricanes", "Baroness of Hurricanes"},
     {"Baron of Meteors", "Baroness of Meteors"},
     {"Baron of Meteors", "Baroness of Meteors"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Knight Hero", "Knight Heroine"},
     {"Squire of War", "Squire of War"},
     {"Knight of War", "Dame of War"},
     {"Demigod of War", "Demigoddess of War"},
     {"Immortal Warlord", "Immortal Warlord"},
     {"God of War", "God of War"},
     {"Deity of War", "Deity of War"},
     {"Supreme Master of War", "Supreme Mistress of War"},
     {"Creator", "Creator"},
     {"Supreme Deity", "Supreme Deity"}
     },

/*	Ranger	*/

    {
     {"Man", "Woman"},

     {"Apprentice of the Hunt", "Apprentice of the Hunt"},
     {"Student of the Hunt", "Student of the Hunt"},
     {"Student of the Hunt", "Student of the Hunt"},
     {"Runner", "Runner"},
     {"Runner", "Runner"},
     {"Strider", "Strider"},
     {"Strider", "Strider"},
     {"Scout", "Scout"},
     {"Scout", "Scout"},
     {"Master Scout", "Master Scout"},
     {"Master Scout", "Master Scout"},
     {"Explorer", "Explorer"},
     {"Explorer", "Explorer"},
     {"Tracker", "Tracker"},
     {"Tracker", "Tracker"},
     {"Survivalist", "Survivalist"},
     {"Survivalist", "Survivalist"},
     {"Watcher", "Watcher"},
     {"Watcher", "Watcher"},
     {"Hunter", "Hunter"},
     {"Hunter", "Hunter"},
     {"Woodsman", "Woodswoman"},
     {"Woodsman", "Woodswoman"},
     {"Guide", "Guide"},
     {"Guide", "Guide"},
     {"Pathfinder", "Pathfinder"},
     {"Pathfinder", "Pathfinder"},
     {"Stalker", "Stalker"},
     {"Stalker", "Stalker"},
     {"Predator", "Predator"},
     {"Predator", "Predator"},
     {"Deerhunter", "Deerhunter"},
     {"Deerhunter", "Deerhunter"},
     {"Elkhunter", "Elkhunter"},
     {"Elkhunter", "Elkhunter"},
     {"Boarhunter", "Boarhunter"},
     {"Boarhunter", "Boarhunter"},
     {"Bearhunter", "Bearhunter"},
     {"Bearhunter", "Bearhunter"},
     {"Falconer", "Falconer"},
     {"Falconer", "Falconer"},
     {"Hawker", "Hawker"},
     {"Hawker", "Hawker"},
     {"Manhunter", "Manhunter"},
     {"Manhunter", "Manhunter"},
     {"Gianthunter", "Gianthunter"},
     {"Gianthunter", "Gianthunter"},
     {"Adept of the Hunt", "Adept of the Hunt"},
     {"Adept of the Hunt", "Adept of the Hunt"},
     {"Lord of the Hunt", "Lady of the Hunt"},
     {"Lord of the Hunt", "Lady of the Hunt"},
     {"Master of the Hunt", "Mistress of the Hunt"},
     {"Master of the Hunt", "Mistress of the Hunt"},
     {"Fox", "Fox"},
     {"Coyote", "Coyote"},
     {"Lynx", "Lynx"},
     {"Wolf", "Wolf"},
     {"Panther", "Panther"},
     {"Cougar", "Cougar"},
     {"Jaguar", "Jaguar"},
     {"Tiger", "Tiger"},
     {"Lion", "Lion"},
     {"Bear", "Bear"},
     {"Beastmaster", "Beastmaster"},
     {"Beastmaster", "Beastmaster"},
     {"Overlord of Beasts", "Overlord of Beasts"},
     {"Overlord of Beasts", "Overlord of Beasts"},
     {"Dragonhunter", "Dragonhunter"},
     {"Dragonhunter", "Dragonhunter"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Ranger Hero", "Ranger Heroine"},
     {"Squire of the Hunt", "Squire of the Hunt"},
     {"Knight of the Hunt", "Dame of the Hunt"},
     {"Demigod of Beasts", "Demigoddess of Beasts"},
     {"Immortal Hunter", "Immortal Huntress"},
     {"God of Beasts", "Goddess of Beasts"},
     {"Deity of Beasts", "Deity of Beasts"},
     {"Supremity of Beasts", "Supremity of Beasts"},
     {"Creator", "Creator"},
     {"Supreme Deity", "Supreme Deity"},
     },

/*	Druid	*/

    {
     {"Man", "Woman"},

     {"Apprentice of Nature", "Apprentice of Nature"},
     {"Student of Nature", "Student of Nature"},
     {"Student of Nature", "Student of Nature"},
     {"Scholar of Nature", "Scholar of Nature"},
     {"Scholar of Nature", "Scholar of Nature"},
     {"Neophyte", "Neophyte"},
     {"Neophyte", "Neophyte"},
     {"Naturalist", "Naturalist"},
     {"Naturalist", "Naturalist"},
     {"Forester", "Forestress"},
     {"Forester", "Forestress"},
     {"Student of Earth", "Student of Earth"},
     {"Student of Earth", "Student of Earth"},
     {"Student of Air", "Student of Air"},
     {"Student of Air", "Student of Air"},
     {"Student of Water", "Student of Water"},
     {"Student of Water", "Student of Water"},
     {"Student of Fire", "Student of Fire"},
     {"Student of Fire", "Student of Fire"},
     {"Student of Life", "Student of Life"},
     {"Student of Life", "Student of Life"},
     {"Student of The Elements", "Student of The Elements"},
     {"Student of The Elements", "Student of The Elements"},
     {"Herbalist", "Herbalist"},
     {"Herbalist", "Herbalist"},
     {"Philosopher", "Philosopher"},
     {"Philosopher", "Philosopher"},
     {"Sage", "Sage"},
     {"Sage", "Sage"},
     {"Prophet", "Prophetess"},
     {"Prophet", "Prophetess"},
     {"Adept of Earth", "Adept of Earth"},
     {"Adept of Earth", "Adept of Earth"},
     {"Adept of Air", "Adept of Air"},
     {"Adept of Air", "Adept of Air"},
     {"Adept of Water", "Adept of Water"},
     {"Adept of Water", "Adept of Water"},
     {"Adept of Fire", "Adept of Fire"},
     {"Adept of Fire", "Adept of Fire"},
     {"Adept of Life", "Adept of Life"},
     {"Adept of Life", "Adept of Life"},
     {"Adept of The Elements", "Adept of The Elements"},
     {"Adept of The Elements", "Adept of The Elements"},
     {"Druid of Earth", "Druidess of Earth"},
     {"Druid of Earth", "Druidess of Earth"},
     {"Druid of Air", "Druidess of Air"},
     {"Druid of Air", "Druidess of Air"},
     {"Druid of Water", "Druidess of Water"},
     {"Druid of Water", "Druidess of Water"},
     {"Druid of Fire", "Druidess of Fire"},
     {"Druid of Fire", "Druidess of Fire"},
     {"Druid of Life", "Druidess of Life"},
     {"Druid of Life", "Druidess of Life"},
     {"Druid of The Elements", "Druidess of The Elements"},
     {"Druid of The Elements", "Druidess of The Elements"},
     {"Sage of Earth", "Sage of Earth"},
     {"Sage of Earth", "Sage of Earth"},
     {"Sage of Air", "Sage of Air"},
     {"Sage of Air", "Sage of Air"},
     {"Sage of Water", "Sage of Water"},
     {"Sage of Water", "Sage of Water"},
     {"Sage of Fire", "Sage of Fire"},
     {"Sage of Fire", "Sage of Fire"},
     {"Sage of Life", "Sage of Life"},
     {"Sage of Life", "Sage of Life"},
     {"Sage of The Elements", "Sage of The Elements"},
     {"Sage of The Elements", "Sage of The Elements"},
     {"Master of Earth", "Mistress of Earth"},
     {"Master of Earth", "Mistress of Earth"},
     {"Master of Air", "Mistress of Air"},
     {"Master of Air", "Mistress of Air"},
     {"Master of Water", "Mistress of Water"},
     {"Master of Water", "Mistress of Water"},
     {"Master of Fire", "Mistress of Fire"},
     {"Master of Fire", "Mistress of Fire"},
     {"Master of Life", "Mistress of Life"},
     {"Master of Life", "Mistress of Life"},
     {"Master of The Elements", "Mistress of The Elements"},
     {"Master of The Elements", "Mistress of The Elements"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Druid Hero", "Druid Heroine"},
     {"Squire of The Elements", "Squire of The Elements"},
     {"Knight of The Elements", "Dame of The Elements"},
     {"Demigod of Nature", "Demigoddess of Nature"},
     {"Immortal Sage", "Immortal Sage"},
     {"God of The Elements", "Goddess of The Elements"},
     {"Deity of The Elements", "Deity of The Elements"},
     {"Supremity of The Elements", "Supremity of The Elements"},
     {"Creator", "Creator"},
     {"Supreme Diety", "Supreme Diety"},
     },

/*	Revenant	*/

    {
     {"Man", "Woman"},

     {"Blood Student", "Blood Student"},
     {"Scholar of Blood", "Scholar of Blood"},
     {"Scholar of Blood", "Scholar of Blood"},
     {"Student of the Night", "Student of the Night"},
     {"Student of the Night", "Student of the Night"},
     {"Student of Death", "Student of Death"},
     {"Student of Death", "Student of Death"},
     {"Lesser Imp", "Lesser Imp"},
     {"Greater Imp", "Greater Imp"},
     {"Illusionist", "Illusionist"},
     {"Illusionist", "Illusionist"},
     {"Seducer", "Seductress"},
     {"Seducer", "Seductress"},
     {"Stalker", "Stalker"},
     {"Stalker", "Stalker"},
     {"Stalker of Blood", "Stalker of Blood"},
     {"Stalker of Blood", "Stalker of Blood"},
     {"Stalker of Night", "Stalker of Night"},
     {"Stalker of Night", "Stalker of Night"},
     {"Stalker of Death", "Stalker of Death"},
     {"Stalker of Death", "Stalker of Death"},
     {"Shadow", "Shadow"},
     {"Shadow", "Shadow"},
     {"Shadow of Blood", "Shadow of Blood"},
     {"Shadow of Blood", "Shadow of Blood"},
     {"Shadow of Night", "Shadow of Night"},
     {"Shadow of Night", "Shadow of Night"},
     {"Shadow of Death", "Shadow of Death"},
     {"Shadow of Death", "Shadow of Death"},
     {"Killer", "Killer"},
     {"Killer", "Killer"},
     {"Murderer", "Murderer"},
     {"Murderer", "Murderer"},
     {"Incubus", "Succubus"},
     {"Incubus", "Succubus"},
     {"Nightstalker", "Nightstalker"},
     {"Nightstalker", "Nightstalker"},
     {"Revenant", "Revenant"},
     {"Revenant", "Revenant"},
     {"Lesser Vrolok", "Lesser Vrolok"},
     {"Vrolok", "Vrolok"},
     {"Greater Vrolok", "Greater Vrolok"},
     {"Demon Servant", "Demon Servant"},
     {"Demon Servant", "Demon Servant"},
     {"Adept of Blood", "Adept of Blood"},
     {"Adept of Blood", "Adept of Blood"},
     {"Adept of Night", "Adept of Night"},
     {"Adept of Night", "Adept of Night"},
     {"Adept of Death", "Adept of Death"},
     {"Adept of Death", "Adept of Death"},
     {"Demon Seeker", "Demon Seeker"},
     {"Demon Seeker", "Demon Seeker"},
     {"Lord of Blood", "Lady of Blood"},
     {"Lord of Blood", "Lady of Blood"},
     {"Lord of Night", "Lady of Night"},
     {"Lord of Night", "Lady of Night"},
     {"Lord of Death", "Lady of Death"},
     {"Lord of Death", "Lady of Death"},
     {"Demon Knight", "Demon Dame"},
     {"Demon Knight", "Demon Dame"},
     {"Master of Blood", "Mistress of Blood"},
     {"Master of Blood", "Mistress of Blood"},
     {"Master of Night", "Mistress of Night"},
     {"Master of Night", "Mistress of Night"},
     {"Master of Death", "Mistress of Death"},
     {"Master of Death", "Mistress of Death"},
     {"Lord of Demons", "Lady of Demons"},
     {"Lord of Demons", "Lady of Demons"},
     {"Baron of Demons", "Baroness of Demons"},
     {"Baron of Demons", "Baroness of Demons"},
     {"Master of Demons", "Mistress of Demons"},
     {"Master of Demons", "Mistress of Demons"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Vampire Hero", "Vampire Heroine"},
     {"Squire of Blood", "Squire of Blood"},
     {"Knight of Blood", "Dame of Blood"},
     {"Demigod of the Night", "Demigoddess of the Night"},
     {"Immortal Undead", "Immortal Undead"},
     {"God of Death", "Goddess of Death"},
     {"Deity of Death", "Deity of Death"},
     {"Supremity of Death", "Supremity of Death"},
     {"Creator", "Creator"},
     {"Supreme Diety", "Supreme Deity"},
     },

/*	Wizard	*/

    {
     {"Man", "Woman"},

     {"Novice of Magic", "Novice of Magic"},
     {"Apprentice of Magic", "Apprentice of Magic"},
     {"Spell Novice", "Spell Novice"},
     {"Spell Student", "Spell Student"},
     {"Scholar of Magic", "Scholar of Magic"},
     {"Scholar of Wizardry", "Scholar of Wizardry"},
     {"Delver in Scrolls", "Delveress in Scrolls"},
     {"Delver in Spells", "Delveress in Spells"},
     {"Medium of Magic", "Medium of Magic"},
     {"Medium of Wizardry", "Medium of Wizardry"},
     {"Scribe of Magic", "Scribess of Magic"},
     {"Scribe of Wizardry", "Scribess of Wizardry"},
     {"Minor Seer", "Minor Seeress"},
     {"Seer", "Seeress"},
     {"Minor Sage", "Minor Sage"},
     {"Sage", "Sage"},
     {"Minor Illusionist", "Minor Illusionist"},
     {"Illusionist", "Illusionist"},
     {"Minor Abjurer", "Minor Abjuress"},
     {"Abjurer", "Abjuress"},
     {"Minor Invoker", "Minor Invoker"},
     {"Invoker", "Invoker"},
     {"Minor Enchanter", "Minor Enchantress"},
     {"Enchanter", "Enchantress"},
     {"Minor Conjurer", "Minor Conjuress"},
     {"Conjurer", "Conjuress"},
     {"Minor Magician", "Minor Witch"},
     {"Magician", "Witch"},
     {"Minor Creator", "Minor Creator"},
     {"Creator", "Creator"},
     {"Minor Savant", "Minor Savant"},
     {"Savant", "Savant"},
     {"Minor Magus", "Minor Craftess"},
     {"Magus", "Craftess"},
     {"Minor Wizard", "Minor Wizard"},
     {"Wizard", "Wizard"},
     {"Minor Warlock", "Minor War Witch"},
     {"Warlock", "War Witch"},
     {"Minor Sorcerer", "Minor Sorceress"},
     {"Sorcerer", "Sorceress"},
     {"Elder Sorcerer", "Elder Sorceress"},
     {"Elder Sorcerer", "Elder Sorceress"},
     {"Grand Sorcerer", "Grand Sorceress"},
     {"Grand Sorcerer", "Grand Sorceress"},
     {"Great Sorcerer", "Great Sorceress"},
     {"Great Sorcerer", "Great Sorceress"},
     {"Golem Maker", "Golem Maker"},
     {"Golem Maker", "Golem Maker"},
     {"Greater Golem Maker", "Greater Golem Maker"},
     {"Greater Golem Maker", "Greater Golem Maker"},
     {"Maker of Stones", "Maker of Stones",},
     {"Maker of Stones", "Maker of Stones",},
     {"Maker of Potions", "Maker of Potions",},
     {"Maker of Potions", "Maker of Potions",},
     {"Maker of Scrolls", "Maker of Scrolls",},
     {"Maker of Scrolls", "Maker of Scrolls",},
     {"Maker of Wands", "Maker of Wands",},
     {"Maker of Wands", "Maker of Wands",},
     {"Maker of Staves", "Maker of Staves",},
     {"Maker of Staves", "Maker of Staves",},
     {"Demon Summoner", "Demon Summoner"},
     {"Demon Summoner", "Demon Summoner"},
     {"Greater Demon Summoner", "Greater Demon Summoner"},
     {"Greater Demon Summoner", "Greater Demon Summoner"},
     {"Dragon Charmer", "Dragon Charmer"},
     {"Dragon Charmer", "Dragon Charmer"},
     {"Greater Dragon Charmer", "Greater Dragon Charmer"},
     {"Greater Dragon Charmer", "Greater Dragon Charmer"},
     {"Master of all Magic", "Master of all Magic"},
     {"Master of all Magic", "Master of all Magic"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Master Wizard", "Master Wizard"},
     {"Wizard Hero", "Wizard Heroine"},
     {"Squire of Magic", "Squire of Magic"},
     {"Knight of Magic", "Dame of Magic"},
     {"Demigod of Magic", "Demigoddess of Magic"},
     {"Immortal of Magic", "Immortal of Magic"},
     {"God of Magic", "Goddess of Magic"},
     {"Deity of Magic", "Deity of Magic"},
     {"Supremity of Magic", "Supremity of Magic"},
     {"Creator", "Creator"},
     {"Supreme Deity", "Supreme Deity"}
     },

/*	Priest	*/

    {
     {"Man", "Woman"},

     {"Believer", "Believer"},
     {"Believer", "Believer"},
     {"Attendant", "Attendant"},
     {"Attendant", "Attendant"},
     {"Acolyte", "Acolyte"},
     {"Acolyte", "Acolyte"},
     {"Novice", "Novice"},
     {"Novice", "Novice"},
     {"Missionary", "Missionary"},
     {"Missionary", "Missionary"},
     {"Adept", "Adept"},
     {"Adept", "Adept"},
     {"Deacon", "Deaconess"},
     {"Deacon", "Deaconess"},
     {"Vicar", "Vicaress"},
     {"Vicar", "Vicaress"},
     {"Priest", "Priestess"},
     {"Priest", "Priestess"},
     {"Minister", "Lady Minister"},
     {"Minister", "Lady Minister"},
     {"Canon", "Canon"},
     {"Canon", "Canon"},
     {"Levite", "Levitess"},
     {"Levite", "Levitess"},
     {"Curate", "Curess"},
     {"Curate", "Curess"},
     {"Monk", "Nun"},
     {"Monk", "Nun"},
     {"Healer", "Healess"},
     {"Healer", "Healess"},
     {"Chaplain", "Chaplain"},
     {"Chaplain", "Chaplain"},
     {"Expositor", "Expositress"},
     {"Expositor", "Expositress"},
     {"Bishop", "Bishop"},
     {"Bishop", "Bishop"},
     {"Arch Bishop", "Arch Lady of the Church"},
     {"Arch Bishop", "Arch Lady of the Church"},
     {"Patriarch", "Matriarch"},
     {"Patriarch", "Matriarch"},
     {"Elder Patriarch", "Elder Matriarch"},
     {"Elder Patriarch", "Elder Matriarch"},
     {"Grand Patriarch", "Grand Matriarch"},
     {"Grand Patriarch", "Grand Matriarch"},
     {"Great Patriarch", "Great Matriarch"},
     {"Great Patriarch", "Great Matriarch"},
     {"Demon Killer", "Demon Killer"},
     {"Demon Killer", "Demon Killer"},
     {"Greater Demon Killer", "Greater Demon Killer"},
     {"Greater Demon Killer", "Greater Demon Killer"},
     {"Cardinal of the Sea", "Cardinal of the Sea"},
     {"Cardinal of the Sea", "Cardinal of the Sea"},
     {"Cardinal of the Earth", "Cardinal of the Earth"},
     {"Cardinal of the Earth", "Cardinal of the Earth"},
     {"Cardinal of the Air", "Cardinal of the Air"},
     {"Cardinal of the Air", "Cardinal of the Air"},
     {"Cardinal of the Ether", "Cardinal of the Ether"},
     {"Cardinal of the Ether", "Cardinal of the Ether"},
     {"Cardinal of the Heavens", "Cardinal of the Heavens"},
     {"Cardinal of the Heavens", "Cardinal of the Heavens"},
     {"Avatar of an Immortal", "Avatar of an Immortal"},
     {"Avatar of an Immortal", "Avatar of an Immortal"},
     {"Avatar of a Deity", "Avatar of a Deity"},
     {"Avatar of a Deity", "Avatar of a Deity"},
     {"Avatar of a Supremity", "Avatar of a Supremity"},
     {"Avatar of a Supremity", "Avatar of a Supremity"},
     {"Avatar of an Implementor", "Avatar of an Implementor"},
     {"Avatar of an Implementor", "Avatar of an Implementor"},
     {"Master of all Divinity", "Mistress of all Divinity"},
     {"Master of all Divinity", "Mistress of all Divinity"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Divine Hero", "Divine Heroine"},
     {"Divine Squire", "Divine Squire"},
     {"Divine Knight", "Divine Dame"},
     {"Demigod", "Demigoddess",},
     {"Immortal", "Immortal"},
     {"God", "Goddess"},
     {"Deity", "Deity"},
     {"Supreme Master", "Supreme Mistress"},
     {"Creator", "Creator"},
     {"Supreme Deity", "Supreme Deity"}
     },

/*	Mercenary	*/

    {
     {"Man", "Woman"},

     {"Pilferer", "Pilferess"},
     {"Pilferer", "Pilferess"},
     {"Footpad", "Footpad"},
     {"Footpad", "Footpad"},
     {"Filcher", "Filcheress"},
     {"Filcher", "Filcheress"},
     {"Pick-Pocket", "Pick-Pocket"},
     {"Pick-Pocket", "Pick-Pocket"},
     {"Sneak", "Sneak"},
     {"Sneak", "Sneak"},
     {"Pincher", "Pincheress"},
     {"Pincher", "Pincheress"},
     {"Cut-Purse", "Cut-Purse"},
     {"Cut-Purse", "Cut-Purse"},
     {"Snatcher", "Snatcheress"},
     {"Snatcher", "Snatcheress"},
     {"Sharper", "Sharpress"},
     {"Sharper", "Sharpress"},
     {"Rogue", "Rogue"},
     {"Rogue", "Rogue"},
     {"Robber", "Robber"},
     {"Robber", "Robber"},
     {"Magsman", "Magswoman"},
     {"Magsman", "Magswoman"},
     {"Highwayman", "Highwaywoman"},
     {"Highwayman", "Highwaywoman"},
     {"Burglar", "Burglaress"},
     {"Burglar", "Burglaress"},
     {"Thief", "Thief"},
     {"Thief", "Thief"},
     {"Knifer", "Knifer"},
     {"Knifer", "Knifer"},
     {"Quick-Blade", "Quick-Blade"},
     {"Quick-Blade", "Quick-Blade"},
     {"Killer", "Murderess"},
     {"Killer", "Murderess"},
     {"Brigand", "Brigand"},
     {"Brigand", "Brigand"},
     {"Cut-Throat", "Cut-Throat"},
     {"Cut-Throat", "Cut-Throat"},
     {"Spy", "Spy"},
     {"Spy", "Spy"},
     {"Grand Spy", "Grand Spy"},
     {"Grand Spy", "Grand Spy"},
     {"Master Spy", "Master Spy"},
     {"Master Spy", "Master Spy"},
     {"Assassin", "Assassin"},
     {"Assassin", "Assassin"},
     {"Greater Assassin", "Greater Assassin"},
     {"Greater Assassin", "Greater Assassin"},
     {"Master of Vision", "Mistress of Vision"},
     {"Master of Vision", "Mistress of Vision"},
     {"Master of Hearing", "Mistress of Hearing"},
     {"Master of Hearing", "Mistress of Hearing"},
     {"Master of Smell", "Mistress of Smell"},
     {"Master of Smell", "Mistress of Smell"},
     {"Master of Taste", "Mistress of Taste"},
     {"Master of Taste", "Mistress of Taste"},
     {"Master of Touch", "Mistress of Touch"},
     {"Master of Touch", "Mistress of Touch"},
     {"Crime Lord", "Crime Mistress"},
     {"Crime Lord", "Crime Mistress"},
     {"Infamous Crime Lord", "Infamous Crime Mistress"},
     {"Infamous Crime Lord", "Infamous Crime Mistress"},
     {"Greater Crime Lord", "Greater Crime Mistress"},
     {"Greater Crime Lord", "Greater Crime Mistress"},
     {"Master Crime Lord", "Master Crime Mistress"},
     {"Master Crime Lord", "Master Crime Mistress"},
     {"Godfather", "Godmother"},
     {"Godfather", "Godmother"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Master Mercenary", "Master Mercenary"},
     {"Assassin Hero", "Assassin Heroine"},
     {"Squire of Death", "Squire of Death",},
     {"Knight of Death", "Dame of Death"},
     {"Demigod of Assassins", "Demigoddess of Assassins"},
     {"Immortal Assasin", "Immortal Assassin"},
     {"God of Assassins", "God of Assassins",},
     {"Deity of Assassins", "Deity of Assassins"},
     {"Supreme Master", "Supreme Mistress"},
     {"Creator", "Creator"},
     {"Supreme Deity", "Supreme Deity"}
     },

/*	Gladiator	*/

    {
     {"Man", "Woman"},

     {"Swordpupil", "Swordpupil"},
     {"Swordpupil", "Swordpupil"},
     {"Recruit", "Recruit"},
     {"Recruit", "Recruit"},
     {"Sentry", "Sentress"},
     {"Sentry", "Sentress"},
     {"Fighter", "Fighter"},
     {"Fighter", "Fighter"},
     {"Soldier", "Soldier"},
     {"Soldier", "Soldier"},
     {"Warrior", "Warrior"},
     {"Warrior", "Warrior"},
     {"Veteran", "Veteran"},
     {"Veteran", "Veteran"},
     {"Swordsman", "Swordswoman"},
     {"Swordsman", "Swordswoman"},
     {"Fencer", "Fenceress"},
     {"Fencer", "Fenceress"},
     {"Combatant", "Combatess"},
     {"Combatant", "Combatess"},
     {"Hero", "Heroine"},
     {"Hero", "Heroine"},
     {"Myrmidon", "Myrmidon"},
     {"Myrmidon", "Myrmidon"},
     {"Swashbuckler", "Swashbuckleress"},
     {"Swashbuckler", "Swashbuckleress"},
     {"Mercenary", "Mercenaress"},
     {"Mercenary", "Mercenaress"},
     {"Swordmaster", "Swordmistress"},
     {"Swordmaster", "Swordmistress"},
     {"Lieutenant", "Lieutenant"},
     {"Lieutenant", "Lieutenant"},
     {"Champion", "Lady Champion"},
     {"Champion", "Lady Champion"},
     {"Dragoon", "Lady Dragoon"},
     {"Dragoon", "Lady Dragoon"},
     {"Cavalier", "Lady Cavalier"},
     {"Cavalier", "Lady Cavalier"},
     {"Knight", "Lady Knight"},
     {"Knight", "Lady Knight"},
     {"Grand Knight", "Grand Knight"},
     {"Grand Knight", "Grand Knight"},
     {"Master Knight", "Master Knight"},
     {"Master Knight", "Master Knight"},
     {"Strider", "Strider"},
     {"Strider", "Strider"},
     {"Grand Strider", "Grand Strider"},
     {"Grand Strider", "Grand Strider"},
     {"Demon Slayer", "Demon Slayer"},
     {"Demon Slayer", "Demon Slayer"},
     {"Greater Demon Slayer", "Greater Demon Slayer"},
     {"Greater Demon Slayer", "Greater Demon Slayer"},
     {"Dragon Slayer", "Dragon Slayer"},
     {"Dragon Slayer", "Dragon Slayer"},
     {"Greater Dragon Slayer", "Greater Dragon Slayer"},
     {"Greater Dragon Slayer", "Greater Dragon Slayer"},
     {"Underlord", "Underlord"},
     {"Underlord", "Underlord"},
     {"Overlord", "Overlord"},
     {"Overlord", "Overlord"},
     {"Baron of Thunder", "Baroness of Thunder"},
     {"Baron of Thunder", "Baroness of Thunder"},
     {"Baron of Storms", "Baroness of Storms"},
     {"Baron of Storms", "Baroness of Storms"},
     {"Baron of Tornadoes", "Baroness of Tornadoes"},
     {"Baron of Tornadoes", "Baroness of Tornadoes"},
     {"Baron of Hurricanes", "Baroness of Hurricanes"},
     {"Baron of Hurricanes", "Baroness of Hurricanes"},
     {"Baron of Meteors", "Baroness of Meteors"},
     {"Baron of Meteors", "Baroness of Meteors"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Master Gladiator", "Master Gladiator"},
     {"Centurian Hero", "Centurian Heroine"},
     {"Squire of War", "Squire of War"},
     {"Knight of War", "Dame of War"},
     {"Demigod of War", "Demigoddess of War"},
     {"Immortal Warlord", "Immortal Warlord"},
     {"God of War", "God of War"},
     {"Deity of War", "Deity of War"},
     {"Supreme Master of War", "Supreme Mistress of War"},
     {"Creator", "Creator"},
     {"Supreme Deity", "Supreme Deity"}
     },

/*	Strider	*/

    {
     {"Man", "Woman"},

     {"Apprentice of the Hunt", "Apprentice of the Hunt"},
     {"Student of the Hunt", "Student of the Hunt"},
     {"Student of the Hunt", "Student of the Hunt"},
     {"Runner", "Runner"},
     {"Runner", "Runner"},
     {"Strider", "Strider"},
     {"Strider", "Strider"},
     {"Scout", "Scout"},
     {"Scout", "Scout"},
     {"Master Scout", "Master Scout"},
     {"Master Scout", "Master Scout"},
     {"Explorer", "Explorer"},
     {"Explorer", "Explorer"},
     {"Tracker", "Tracker"},
     {"Tracker", "Tracker"},
     {"Survivalist", "Survivalist"},
     {"Survivalist", "Survivalist"},
     {"Watcher", "Watcher"},
     {"Watcher", "Watcher"},
     {"Hunter", "Hunter"},
     {"Hunter", "Hunter"},
     {"Woodsman", "Woodswoman"},
     {"Woodsman", "Woodswoman"},
     {"Guide", "Guide"},
     {"Guide", "Guide"},
     {"Pathfinder", "Pathfinder"},
     {"Pathfinder", "Pathfinder"},
     {"Stalker", "Stalker"},
     {"Stalker", "Stalker"},
     {"Predator", "Predator"},
     {"Predator", "Predator"},
     {"Deerhunter", "Deerhunter"},
     {"Deerhunter", "Deerhunter"},
     {"Elkhunter", "Elkhunter"},
     {"Elkhunter", "Elkhunter"},
     {"Boarhunter", "Boarhunter"},
     {"Boarhunter", "Boarhunter"},
     {"Bearhunter", "Bearhunter"},
     {"Bearhunter", "Bearhunter"},
     {"Falconer", "Falconer"},
     {"Falconer", "Falconer"},
     {"Hawker", "Hawker"},
     {"Hawker", "Hawker"},
     {"Manhunter", "Manhunter"},
     {"Manhunter", "Manhunter"},
     {"Gianthunter", "Gianthunter"},
     {"Gianthunter", "Gianthunter"},
     {"Adept of the Hunt", "Adept of the Hunt"},
     {"Adept of the Hunt", "Adept of the Hunt"},
     {"Lord of the Hunt", "Lady of the Hunt"},
     {"Lord of the Hunt", "Lady of the Hunt"},
     {"Master of the Hunt", "Mistress of the Hunt"},
     {"Master of the Hunt", "Mistress of the Hunt"},
     {"Fox", "Fox"},
     {"Coyote", "Coyote"},
     {"Lynx", "Lynx"},
     {"Wolf", "Wolf"},
     {"Panther", "Panther"},
     {"Cougar", "Cougar"},
     {"Jaguar", "Jaguar"},
     {"Tiger", "Tiger"},
     {"Lion", "Lion"},
     {"Bear", "Bear"},
     {"Beastmaster", "Beastmaster"},
     {"Beastmaster", "Beastmaster"},
     {"Overlord of Beasts", "Overlord of Beasts"},
     {"Overlord of Beasts", "Overlord of Beasts"},
     {"Dragonhunter", "Dragonhunter"},
     {"Dragonhunter", "Dragonhunter"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Master Strider", "Master Strider"},
     {"Strider Hero", "Strider Heroine"},
     {"Squire of the Hunt", "Squire of the Hunt"},
     {"Knight of the Hunt", "Dame of the Hunt"},
     {"Demigod of Beasts", "Demigoddess of Beasts"},
     {"Immortal Hunter", "Immortal Huntress"},
     {"God of Beasts", "Goddess of Beasts"},
     {"Deity of Beasts", "Deity of Beasts"},
     {"Supremity of Beasts", "Supremity of Beasts"},
     {"Creator", "Creator"},
     {"Supreme Deity", "Supreme Deity"},
     },

/*	Sage	*/

    {
     {"Man", "Woman"},

     {"Apprentice of Nature", "Apprentice of Nature"},
     {"Student of Nature", "Student of Nature"},
     {"Student of Nature", "Student of Nature"},
     {"Scholar of Nature", "Scholar of Nature"},
     {"Scholar of Nature", "Scholar of Nature"},
     {"Neophyte", "Neophyte"},
     {"Neophyte", "Neophyte"},
     {"Naturalist", "Naturalist"},
     {"Naturalist", "Naturalist"},
     {"Forester", "Forestress"},
     {"Forester", "Forestress"},
     {"Student of Earth", "Student of Earth"},
     {"Student of Earth", "Student of Earth"},
     {"Student of Air", "Student of Air"},
     {"Student of Air", "Student of Air"},
     {"Student of Water", "Student of Water"},
     {"Student of Water", "Student of Water"},
     {"Student of Fire", "Student of Fire"},
     {"Student of Fire", "Student of Fire"},
     {"Student of Life", "Student of Life"},
     {"Student of Life", "Student of Life"},
     {"Student of The Elements", "Student of The Elements"},
     {"Student of The Elements", "Student of The Elements"},
     {"Herbalist", "Herbalist"},
     {"Herbalist", "Herbalist"},
     {"Philosopher", "Philosopher"},
     {"Philosopher", "Philosopher"},
     {"Sage", "Sage"},
     {"Sage", "Sage"},
     {"Prophet", "Prophetess"},
     {"Prophet", "Prophetess"},
     {"Adept of Earth", "Adept of Earth"},
     {"Adept of Earth", "Adept of Earth"},
     {"Adept of Air", "Adept of Air"},
     {"Adept of Air", "Adept of Air"},
     {"Adept of Water", "Adept of Water"},
     {"Adept of Water", "Adept of Water"},
     {"Adept of Fire", "Adept of Fire"},
     {"Adept of Fire", "Adept of Fire"},
     {"Adept of Life", "Adept of Life"},
     {"Adept of Life", "Adept of Life"},
     {"Adept of The Elements", "Adept of The Elements"},
     {"Adept of The Elements", "Adept of The Elements"},
     {"Druid of Earth", "Druidess of Earth"},
     {"Druid of Earth", "Druidess of Earth"},
     {"Druid of Air", "Druidess of Air"},
     {"Druid of Air", "Druidess of Air"},
     {"Druid of Water", "Druidess of Water"},
     {"Druid of Water", "Druidess of Water"},
     {"Druid of Fire", "Druidess of Fire"},
     {"Druid of Fire", "Druidess of Fire"},
     {"Druid of Life", "Druidess of Life"},
     {"Druid of Life", "Druidess of Life"},
     {"Druid of The Elements", "Druidess of The Elements"},
     {"Druid of The Elements", "Druidess of The Elements"},
     {"Sage of Earth", "Sage of Earth"},
     {"Sage of Earth", "Sage of Earth"},
     {"Sage of Air", "Sage of Air"},
     {"Sage of Air", "Sage of Air"},
     {"Sage of Water", "Sage of Water"},
     {"Sage of Water", "Sage of Water"},
     {"Sage of Fire", "Sage of Fire"},
     {"Sage of Fire", "Sage of Fire"},
     {"Sage of Life", "Sage of Life"},
     {"Sage of Life", "Sage of Life"},
     {"Sage of The Elements", "Sage of The Elements"},
     {"Sage of The Elements", "Sage of The Elements"},
     {"Master of Earth", "Mistress of Earth"},
     {"Master of Earth", "Mistress of Earth"},
     {"Master of Air", "Mistress of Air"},
     {"Master of Air", "Mistress of Air"},
     {"Master of Water", "Mistress of Water"},
     {"Master of Water", "Mistress of Water"},
     {"Master of Fire", "Mistress of Fire"},
     {"Master of Fire", "Mistress of Fire"},
     {"Master of Life", "Mistress of Life"},
     {"Master of Life", "Mistress of Life"},
     {"Master of The Elements", "Mistress of The Elements"},
     {"Master of The Elements", "Mistress of The Elements"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Sage Hero", "Sage Heroine"},
     {"Squire of The Elements", "Squire of The Elements"},
     {"Knight of The Elements", "Dame of The Elements"},
     {"Demigod of Nature", "Demigoddess of Nature"},
     {"Immortal Sage", "Immortal Sage"},
     {"God of The Elements", "Goddess of The Elements"},
     {"Deity of The Elements", "Deity of The Elements"},
     {"Supremity of The Elements", "Supremity of The Elements"},
     {"Creator", "Creator"},
     {"Supreme Diety", "Supreme Diety"},
     },

/*	Vampire	*/
    {
     {"Man", "Woman"},

     {"Blood Student", "Blood Student"},
     {"Scholar of Blood", "Scholar of Blood"},
     {"Scholar of Blood", "Scholar of Blood"},
     {"Student of the Night", "Student of the Night"},
     {"Student of the Night", "Student of the Night"},
     {"Student of Death", "Student of Death"},
     {"Student of Death", "Student of Death"},
     {"Lesser Imp", "Lesser Imp"},
     {"Greater Imp", "Greater Imp"},
     {"Illusionist", "Illusionist"},
     {"Illusionist", "Illusionist"},
     {"Seducer", "Seductress"},
     {"Seducer", "Seductress"},
     {"Stalker", "Stalker"},
     {"Stalker", "Stalker"},
     {"Stalker of Blood", "Stalker of Blood"},
     {"Stalker of Blood", "Stalker of Blood"},
     {"Stalker of Night", "Stalker of Night"},
     {"Stalker of Night", "Stalker of Night"},
     {"Stalker of Death", "Stalker of Death"},
     {"Stalker of Death", "Stalker of Death"},
     {"Shadow", "Shadow"},
     {"Shadow", "Shadow"},
     {"Shadow of Blood", "Shadow of Blood"},
     {"Shadow of Blood", "Shadow of Blood"},
     {"Shadow of Night", "Shadow of Night"},
     {"Shadow of Night", "Shadow of Night"},
     {"Shadow of Death", "Shadow of Death"},
     {"Shadow of Death", "Shadow of Death"},
     {"Killer", "Killer"},
     {"Killer", "Killer"},
     {"Murderer", "Murderer"},
     {"Murderer", "Murderer"},
     {"Incubus", "Succubus"},
     {"Incubus", "Succubus"},
     {"Nightstalker", "Nightstalker"},
     {"Nightstalker", "Nightstalker"},
     {"Revenant", "Revenant"},
     {"Revenant", "Revenant"},
     {"Lesser Vrolok", "Lesser Vrolok"},
     {"Vrolok", "Vrolok"},
     {"Greater Vrolok", "Greater Vrolok"},
     {"Demon Servant", "Demon Servant"},
     {"Demon Servant", "Demon Servant"},
     {"Adept of Blood", "Adept of Blood"},
     {"Adept of Blood", "Adept of Blood"},
     {"Adept of Night", "Adept of Night"},
     {"Adept of Night", "Adept of Night"},
     {"Adept of Death", "Adept of Death"},
     {"Adept of Death", "Adept of Death"},
     {"Demon Seeker", "Demon Seeker"},
     {"Demon Seeker", "Demon Seeker"},
     {"Lord of Blood", "Lady of Blood"},
     {"Lord of Blood", "Lady of Blood"},
     {"Lord of Night", "Lady of Night"},
     {"Lord of Night", "Lady of Night"},
     {"Lord of Death", "Lady of Death"},
     {"Lord of Death", "Lady of Death"},
     {"Demon Knight", "Demon Dame"},
     {"Demon Knight", "Demon Dame"},
     {"Master of Blood", "Mistress of Blood"},
     {"Master of Blood", "Mistress of Blood"},
     {"Master of Night", "Mistress of Night"},
     {"Master of Night", "Mistress of Night"},
     {"Master of Death", "Mistress of Death"},
     {"Master of Death", "Mistress of Death"},
     {"Lord of Demons", "Lady of Demons"},
     {"Lord of Demons", "Lady of Demons"},
     {"Baron of Demons", "Baroness of Demons"},
     {"Baron of Demons", "Baroness of Demons"},
     {"Master of Demons", "Mistress of Demons"},
     {"Master of Demons", "Mistress of Demons"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Master Lich", "Master Lich"},
     {"Lich Hero", "Lich Heroine"},
     {"Squire of Blood", "Squire of Blood"},
     {"Knight of Blood", "Dame of Blood"},
     {"Demigod of the Night", "Demigoddess of the Night"},
     {"Immortal Undead", "Immortal Undead"},
     {"God of Death", "Goddess of Death"},
     {"Deity of Death", "Deity of Death"},
     {"Supremity of Death", "Supremity of Death"},
     {"Creator", "Creator"},
     {"Supreme Diety", "Supreme Deity"},
     },
/*	Sorcerer	*/

    {
     {"Man", "Woman"},

     {"Novice of Magic", "Novice of Magic"},
     {"Apprentice of Magic", "Apprentice of Magic"},
     {"Spell Novice", "Spell Novice"},
     {"Spell Student", "Spell Student"},
     {"Scholar of Magic", "Scholar of Magic"},
     {"Scholar of Wizardry", "Scholar of Wizardry"},
     {"Delver in Scrolls", "Delveress in Scrolls"},
     {"Delver in Spells", "Delveress in Spells"},
     {"Medium of Magic", "Medium of Magic"},
     {"Medium of Wizardry", "Medium of Wizardry"},
     {"Scribe of Magic", "Scribess of Magic"},
     {"Scribe of Wizardry", "Scribess of Wizardry"},
     {"Minor Seer", "Minor Seeress"},
     {"Seer", "Seeress"},
     {"Minor Sage", "Minor Sage"},
     {"Sage", "Sage"},
     {"Minor Illusionist", "Minor Illusionist"},
     {"Illusionist", "Illusionist"},
     {"Minor Abjurer", "Minor Abjuress"},
     {"Abjurer", "Abjuress"},
     {"Minor Invoker", "Minor Invoker"},
     {"Invoker", "Invoker"},
     {"Minor Enchanter", "Minor Enchantress"},
     {"Enchanter", "Enchantress"},
     {"Minor Conjurer", "Minor Conjuress"},
     {"Conjurer", "Conjuress"},
     {"Minor Magician", "Minor Witch"},
     {"Magician", "Witch"},
     {"Minor Creator", "Minor Creator"},
     {"Creator", "Creator"},
     {"Minor Savant", "Minor Savant"},
     {"Savant", "Savant"},
     {"Minor Magus", "Minor Craftess"},
     {"Magus", "Craftess"},
     {"Minor Wizard", "Minor Wizard"},
     {"Wizard", "Wizard"},
     {"Minor Warlock", "Minor War Witch"},
     {"Warlock", "War Witch"},
     {"Minor Sorcerer", "Minor Sorceress"},
     {"Sorcerer", "Sorceress"},
     {"Elder Sorcerer", "Elder Sorceress"},
     {"Elder Sorcerer", "Elder Sorceress"},
     {"Grand Sorcerer", "Grand Sorceress"},
     {"Grand Sorcerer", "Grand Sorceress"},
     {"Great Sorcerer", "Great Sorceress"},
     {"Great Sorcerer", "Great Sorceress"},
     {"Golem Maker", "Golem Maker"},
     {"Golem Maker", "Golem Maker"},
     {"Greater Golem Maker", "Greater Golem Maker"},
     {"Greater Golem Maker", "Greater Golem Maker"},
     {"Maker of Stones", "Maker of Stones",},
     {"Maker of Stones", "Maker of Stones",},
     {"Maker of Potions", "Maker of Potions",},
     {"Maker of Potions", "Maker of Potions",},
     {"Maker of Scrolls", "Maker of Scrolls",},
     {"Maker of Scrolls", "Maker of Scrolls",},
     {"Maker of Wands", "Maker of Wands",},
     {"Maker of Wands", "Maker of Wands",},
     {"Maker of Staves", "Maker of Staves",},
     {"Maker of Staves", "Maker of Staves",},
     {"Demon Summoner", "Demon Summoner"},
     {"Demon Summoner", "Demon Summoner"},
     {"Greater Demon Summoner", "Greater Demon Summoner"},
     {"Greater Demon Summoner", "Greater Demon Summoner"},
     {"Dragon Charmer", "Dragon Charmer"},
     {"Dragon Charmer", "Dragon Charmer"},
     {"Greater Dragon Charmer", "Greater Dragon Charmer"},
     {"Greater Dragon Charmer", "Greater Dragon Charmer"},
     {"Master of all Magic", "Master of all Magic"},
     {"Master of all Magic", "Master of all Magic"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Mage Hero", "Mage Heroine"},
     {"Squire of Magic", "Squire of Magic"},
     {"Knight of Magic", "Dame of Magic"},
     {"Demigod of Magic", "Demigoddess of Magic"},
     {"Immortal of Magic", "Immortal of Magic"},
     {"God of Magic", "Goddess of Magic"},
     {"Deity of Magic", "Deity of Magic"},
     {"Supremity of Magic", "Supremity of Magic"},
     {"Creator", "Creator"},
     {"Supreme Deity", "Supreme Deity"}
     },

    /*  Bishop    */

    {
     {"Man", "Woman"},

     {"Believer", "Believer"},
     {"Believer", "Believer"},
     {"Attendant", "Attendant"},
     {"Attendant", "Attendant"},
     {"Acolyte", "Acolyte"},
     {"Acolyte", "Acolyte"},
     {"Novice", "Novice"},
     {"Novice", "Novice"},
     {"Missionary", "Missionary"},
     {"Missionary", "Missionary"},
     {"Adept", "Adept"},
     {"Adept", "Adept"},
     {"Deacon", "Deaconess"},
     {"Deacon", "Deaconess"},
     {"Vicar", "Vicaress"},
     {"Vicar", "Vicaress"},
     {"Priest", "Priestess"},
     {"Priest", "Priestess"},
     {"Minister", "Lady Minister"},
     {"Minister", "Lady Minister"},
     {"Canon", "Canon"},
     {"Canon", "Canon"},
     {"Levite", "Levitess"},
     {"Levite", "Levitess"},
     {"Curate", "Curess"},
     {"Curate", "Curess"},
     {"Monk", "Nun"},
     {"Monk", "Nun"},
     {"Healer", "Healess"},
     {"Healer", "Healess"},
     {"Chaplain", "Chaplain"},
     {"Chaplain", "Chaplain"},
     {"Expositor", "Expositress"},
     {"Expositor", "Expositress"},
     {"Bishop", "Bishop"},
     {"Bishop", "Bishop"},
     {"Arch Bishop", "Arch Lady of the Church"},
     {"Arch Bishop", "Arch Lady of the Church"},
     {"Patriarch", "Matriarch"},
     {"Patriarch", "Matriarch"},
     {"Elder Patriarch", "Elder Matriarch"},
     {"Elder Patriarch", "Elder Matriarch"},
     {"Grand Patriarch", "Grand Matriarch"},
     {"Grand Patriarch", "Grand Matriarch"},
     {"Great Patriarch", "Great Matriarch"},
     {"Great Patriarch", "Great Matriarch"},
     {"Demon Killer", "Demon Killer"},
     {"Demon Killer", "Demon Killer"},
     {"Greater Demon Killer", "Greater Demon Killer"},
     {"Greater Demon Killer", "Greater Demon Killer"},
     {"Cardinal of the Sea", "Cardinal of the Sea"},
     {"Cardinal of the Sea", "Cardinal of the Sea"},
     {"Cardinal of the Earth", "Cardinal of the Earth"},
     {"Cardinal of the Earth", "Cardinal of the Earth"},
     {"Cardinal of the Air", "Cardinal of the Air"},
     {"Cardinal of the Air", "Cardinal of the Air"},
     {"Cardinal of the Ether", "Cardinal of the Ether"},
     {"Cardinal of the Ether", "Cardinal of the Ether"},
     {"Cardinal of the Heavens", "Cardinal of the Heavens"},
     {"Cardinal of the Heavens", "Cardinal of the Heavens"},
     {"Avatar of an Immortal", "Avatar of an Immortal"},
     {"Avatar of an Immortal", "Avatar of an Immortal"},
     {"Avatar of a Deity", "Avatar of a Deity"},
     {"Avatar of a Deity", "Avatar of a Deity"},
     {"Avatar of a Supremity", "Avatar of a Supremity"},
     {"Avatar of a Supremity", "Avatar of a Supremity"},
     {"Avatar of an Implementor", "Avatar of an Implementor"},
     {"Avatar of an Implementor", "Avatar of an Implementor"},
     {"Master of all Divinity", "Mistress of all Divinity"},
     {"Master of all Divinity", "Mistress of all Divinity"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Master Priest", "Master Priestess"},
     {"Divine Hero", "Divine Heroine"},
     {"Divine Squire", "Divine Squire"},
     {"Divine Knight", "Divine Dame"},
     {"Demigod", "Demigoddess",},
     {"Immortal", "Immortal"},
     {"God", "Goddess"},
     {"Deity", "Deity"},
     {"Supreme Master", "Supreme Mistress"},
     {"Creator", "Creator"},
     {"Supreme Deity", "Supreme Deity"}
     },

/*Assassin*/

    {
     {"Man", "Woman"},

     {"Pilferer", "Pilferess"},
     {"Pilferer", "Pilferess"},
     {"Footpad", "Footpad"},
     {"Footpad", "Footpad"},
     {"Filcher", "Filcheress"},
     {"Filcher", "Filcheress"},
     {"Pick-Pocket", "Pick-Pocket"},
     {"Pick-Pocket", "Pick-Pocket"},
     {"Sneak", "Sneak"},
     {"Sneak", "Sneak"},
     {"Pincher", "Pincheress"},
     {"Pincher", "Pincheress"},
     {"Cut-Purse", "Cut-Purse"},
     {"Cut-Purse", "Cut-Purse"},
     {"Snatcher", "Snatcheress"},
     {"Snatcher", "Snatcheress"},
     {"Sharper", "Sharpress"},
     {"Sharper", "Sharpress"},
     {"Rogue", "Rogue"},
     {"Rogue", "Rogue"},
     {"Robber", "Robber"},
     {"Robber", "Robber"},
     {"Magsman", "Magswoman"},
     {"Magsman", "Magswoman"},
     {"Highwayman", "Highwaywoman"},
     {"Highwayman", "Highwaywoman"},
     {"Burglar", "Burglaress"},
     {"Burglar", "Burglaress"},
     {"Thief", "Thief"},
     {"Thief", "Thief"},
     {"Knifer", "Knifer"},
     {"Knifer", "Knifer"},
     {"Quick-Blade", "Quick-Blade"},
     {"Quick-Blade", "Quick-Blade"},
     {"Killer", "Murderess"},
     {"Killer", "Murderess"},
     {"Brigand", "Brigand"},
     {"Brigand", "Brigand"},
     {"Cut-Throat", "Cut-Throat"},
     {"Cut-Throat", "Cut-Throat"},
     {"Spy", "Spy"},
     {"Spy", "Spy"},
     {"Grand Spy", "Grand Spy"},
     {"Grand Spy", "Grand Spy"},
     {"Master Spy", "Master Spy"},
     {"Master Spy", "Master Spy"},
     {"Assassin", "Assassin"},
     {"Assassin", "Assassin"},
     {"Greater Assassin", "Greater Assassin"},
     {"Greater Assassin", "Greater Assassin"},
     {"Master of Vision", "Mistress of Vision"},
     {"Master of Vision", "Mistress of Vision"},
     {"Master of Hearing", "Mistress of Hearing"},
     {"Master of Hearing", "Mistress of Hearing"},
     {"Master of Smell", "Mistress of Smell"},
     {"Master of Smell", "Mistress of Smell"},
     {"Master of Taste", "Mistress of Taste"},
     {"Master of Taste", "Mistress of Taste"},
     {"Master of Touch", "Mistress of Touch"},
     {"Master of Touch", "Mistress of Touch"},
     {"Crime Lord", "Crime Mistress"},
     {"Crime Lord", "Crime Mistress"},
     {"Infamous Crime Lord", "Infamous Crime Mistress"},
     {"Infamous Crime Lord", "Infamous Crime Mistress"},
     {"Greater Crime Lord", "Greater Crime Mistress"},
     {"Greater Crime Lord", "Greater Crime Mistress"},
     {"Master Crime Lord", "Master Crime Mistress"},
     {"Master Crime Lord", "Master Crime Mistress"},
     {"Godfather", "Godmother"},
     {"Godfather", "Godmother"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Assassin Hero", "Assassin Heroine"},
     {"Squire of Death", "Squire of Death",},
     {"Knight of Death", "Dame of Death"},
     {"Demigod of Assassins", "Demigoddess of Assassins"},
     {"Immortal Assasin", "Immortal Assassin"},
     {"God of Assassins", "God of Assassins",},
     {"Deity of Assassins", "Deity of Assassins"},
     {"Supreme Master", "Supreme Mistress"},
     {"Creator", "Creator"},
     {"Supreme Deity", "Supreme Deity"}
     },

/*Berserker Class*/

    {
     {"Man", "Woman"},

     {"Swordpupil", "Swordpupil"},
     {"Swordpupil", "Swordpupil"},
     {"Recruit", "Recruit"},
     {"Recruit", "Recruit"},
     {"Sentry", "Sentress"},
     {"Sentry", "Sentress"},
     {"Fighter", "Fighter"},
     {"Fighter", "Fighter"},
     {"Soldier", "Soldier"},
     {"Soldier", "Soldier"},
     {"Warrior", "Warrior"},
     {"Warrior", "Warrior"},
     {"Veteran", "Veteran"},
     {"Veteran", "Veteran"},
     {"Swordsman", "Swordswoman"},
     {"Swordsman", "Swordswoman"},
     {"Fencer", "Fenceress"},
     {"Fencer", "Fenceress"},
     {"Combatant", "Combatess"},
     {"Combatant", "Combatess"},
     {"Hero", "Heroine"},
     {"Hero", "Heroine"},
     {"Myrmidon", "Myrmidon"},
     {"Myrmidon", "Myrmidon"},
     {"Swashbuckler", "Swashbuckleress"},
     {"Swashbuckler", "Swashbuckleress"},
     {"Mercenary", "Mercenaress"},
     {"Mercenary", "Mercenaress"},
     {"Swordmaster", "Swordmistress"},
     {"Swordmaster", "Swordmistress"},
     {"Lieutenant", "Lieutenant"},
     {"Lieutenant", "Lieutenant"},
     {"Champion", "Lady Champion"},
     {"Champion", "Lady Champion"},
     {"Dragoon", "Lady Dragoon"},
     {"Dragoon", "Lady Dragoon"},
     {"Cavalier", "Lady Cavalier"},
     {"Cavalier", "Lady Cavalier"},
     {"Knight", "Lady Knight"},
     {"Knight", "Lady Knight"},
     {"Grand Knight", "Grand Knight"},
     {"Grand Knight", "Grand Knight"},
     {"Master Knight", "Master Knight"},
     {"Master Knight", "Master Knight"},
     {"Strider", "Strider"},
     {"Strider", "Strider"},
     {"Grand Strider", "Grand Strider"},
     {"Grand Strider", "Grand Strider"},
     {"Demon Slayer", "Demon Slayer"},
     {"Demon Slayer", "Demon Slayer"},
     {"Greater Demon Slayer", "Greater Demon Slayer"},
     {"Greater Demon Slayer", "Greater Demon Slayer"},
     {"Dragon Slayer", "Dragon Slayer"},
     {"Dragon Slayer", "Dragon Slayer"},
     {"Greater Dragon Slayer", "Greater Dragon Slayer"},
     {"Greater Dragon Slayer", "Greater Dragon Slayer"},
     {"Underlord", "Underlord"},
     {"Underlord", "Underlord"},
     {"Overlord", "Overlord"},
     {"Overlord", "Overlord"},
     {"Baron of Thunder", "Baroness of Thunder"},
     {"Baron of Thunder", "Baroness of Thunder"},
     {"Baron of Storms", "Baroness of Storms"},
     {"Baron of Storms", "Baroness of Storms"},
     {"Baron of Tornadoes", "Baroness of Tornadoes"},
     {"Baron of Tornadoes", "Baroness of Tornadoes"},
     {"Baron of Hurricanes", "Baroness of Hurricanes"},
     {"Baron of Hurricanes", "Baroness of Hurricanes"},
     {"Baron of Meteors", "Baroness of Meteors"},
     {"Baron of Meteors", "Baroness of Meteors"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Knight Hero", "Knight Heroine"},
     {"Squire of War", "Squire of War"},
     {"Knight of War", "Dame of War"},
     {"Demigod of War", "Demigoddess of War"},
     {"Immortal Warlord", "Immortal Warlord"},
     {"God of War", "God of War"},
     {"Deity of War", "Deity of War"},
     {"Supreme Master of War", "Supreme Mistress of War"},
     {"Creator", "Creator"},
     {"Supreme Deity", "Supreme Deity"}
     },

/*	Elder	*/

    {
     {"Man", "Woman"},

     {"Apprentice of Nature", "Apprentice of Nature"},
     {"Student of Nature", "Student of Nature"},
     {"Student of Nature", "Student of Nature"},
     {"Scholar of Nature", "Scholar of Nature"},
     {"Scholar of Nature", "Scholar of Nature"},
     {"Neophyte", "Neophyte"},
     {"Neophyte", "Neophyte"},
     {"Naturalist", "Naturalist"},
     {"Naturalist", "Naturalist"},
     {"Forester", "Forestress"},
     {"Forester", "Forestress"},
     {"Student of Earth", "Student of Earth"},
     {"Student of Earth", "Student of Earth"},
     {"Student of Air", "Student of Air"},
     {"Student of Air", "Student of Air"},
     {"Student of Water", "Student of Water"},
     {"Student of Water", "Student of Water"},
     {"Student of Fire", "Student of Fire"},
     {"Student of Fire", "Student of Fire"},
     {"Student of Life", "Student of Life"},
     {"Student of Life", "Student of Life"},
     {"Student of The Elements", "Student of The Elements"},
     {"Student of The Elements", "Student of The Elements"},
     {"Herbalist", "Herbalist"},
     {"Herbalist", "Herbalist"},
     {"Philosopher", "Philosopher"},
     {"Philosopher", "Philosopher"},
     {"Sage", "Sage"},
     {"Sage", "Sage"},
     {"Prophet", "Prophetess"},
     {"Prophet", "Prophetess"},
     {"Adept of Earth", "Adept of Earth"},
     {"Adept of Earth", "Adept of Earth"},
     {"Adept of Air", "Adept of Air"},
     {"Adept of Air", "Adept of Air"},
     {"Adept of Water", "Adept of Water"},
     {"Adept of Water", "Adept of Water"},
     {"Adept of Fire", "Adept of Fire"},
     {"Adept of Fire", "Adept of Fire"},
     {"Adept of Life", "Adept of Life"},
     {"Adept of Life", "Adept of Life"},
     {"Adept of The Elements", "Adept of The Elements"},
     {"Adept of The Elements", "Adept of The Elements"},
     {"Druid of Earth", "Druidess of Earth"},
     {"Druid of Earth", "Druidess of Earth"},
     {"Druid of Air", "Druidess of Air"},
     {"Druid of Air", "Druidess of Air"},
     {"Druid of Water", "Druidess of Water"},
     {"Druid of Water", "Druidess of Water"},
     {"Druid of Fire", "Druidess of Fire"},
     {"Druid of Fire", "Druidess of Fire"},
     {"Druid of Life", "Druidess of Life"},
     {"Druid of Life", "Druidess of Life"},
     {"Druid of The Elements", "Druidess of The Elements"},
     {"Druid of The Elements", "Druidess of The Elements"},
     {"Sage of Earth", "Sage of Earth"},
     {"Sage of Earth", "Sage of Earth"},
     {"Sage of Air", "Sage of Air"},
     {"Sage of Air", "Sage of Air"},
     {"Sage of Water", "Sage of Water"},
     {"Sage of Water", "Sage of Water"},
     {"Sage of Fire", "Sage of Fire"},
     {"Sage of Fire", "Sage of Fire"},
     {"Sage of Life", "Sage of Life"},
     {"Sage of Life", "Sage of Life"},
     {"Sage of The Elements", "Sage of The Elements"},
     {"Sage of The Elements", "Sage of The Elements"},
     {"Master of Earth", "Mistress of Earth"},
     {"Master of Earth", "Mistress of Earth"},
     {"Master of Air", "Mistress of Air"},
     {"Master of Air", "Mistress of Air"},
     {"Master of Water", "Mistress of Water"},
     {"Master of Water", "Mistress of Water"},
     {"Master of Fire", "Mistress of Fire"},
     {"Master of Fire", "Mistress of Fire"},
     {"Master of Life", "Mistress of Life"},
     {"Master of Life", "Mistress of Life"},
     {"Master of The Elements", "Mistress of The Elements"},
     {"Master of The Elements", "Mistress of The Elements"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Master Sage", "Master Sage"},
     {"Sage Hero", "Sage Heroine"},
     {"Squire of The Elements", "Squire of The Elements"},
     {"Knight of The Elements", "Dame of The Elements"},
     {"Demigod of Nature", "Demigoddess of Nature"},
     {"Immortal Sage", "Immortal Sage"},
     {"God of The Elements", "Goddess of The Elements"},
     {"Deity of The Elements", "Deity of The Elements"},
     {"Supremity of The Elements", "Supremity of The Elements"},
     {"Creator", "Creator"},
     {"Supreme Diety", "Supreme Diety"},
     },

/*lich*/

    {
     {"Man", "Woman"},

     {"Blood Student", "Blood Student"},
     {"Scholar of Blood", "Scholar of Blood"},
     {"Scholar of Blood", "Scholar of Blood"},
     {"Student of the Night", "Student of the Night"},
     {"Student of the Night", "Student of the Night"},
     {"Student of Death", "Student of Death"},
     {"Student of Death", "Student of Death"},
     {"Lesser Imp", "Lesser Imp"},
     {"Greater Imp", "Greater Imp"},
     {"Illusionist", "Illusionist"},
     {"Illusionist", "Illusionist"},
     {"Seducer", "Seductress"},
     {"Seducer", "Seductress"},
     {"Stalker", "Stalker"},
     {"Stalker", "Stalker"},
     {"Stalker of Blood", "Stalker of Blood"},
     {"Stalker of Blood", "Stalker of Blood"},
     {"Stalker of Night", "Stalker of Night"},
     {"Stalker of Night", "Stalker of Night"},
     {"Stalker of Death", "Stalker of Death"},
     {"Stalker of Death", "Stalker of Death"},
     {"Shadow", "Shadow"},
     {"Shadow", "Shadow"},
     {"Shadow of Blood", "Shadow of Blood"},
     {"Shadow of Blood", "Shadow of Blood"},
     {"Shadow of Night", "Shadow of Night"},
     {"Shadow of Night", "Shadow of Night"},
     {"Shadow of Death", "Shadow of Death"},
     {"Shadow of Death", "Shadow of Death"},
     {"Killer", "Killer"},
     {"Killer", "Killer"},
     {"Murderer", "Murderer"},
     {"Murderer", "Murderer"},
     {"Incubus", "Succubus"},
     {"Incubus", "Succubus"},
     {"Nightstalker", "Nightstalker"},
     {"Nightstalker", "Nightstalker"},
     {"Revenant", "Revenant"},
     {"Revenant", "Revenant"},
     {"Lesser Vrolok", "Lesser Vrolok"},
     {"Vrolok", "Vrolok"},
     {"Greater Vrolok", "Greater Vrolok"},
     {"Demon Servant", "Demon Servant"},
     {"Demon Servant", "Demon Servant"},
     {"Adept of Blood", "Adept of Blood"},
     {"Adept of Blood", "Adept of Blood"},
     {"Adept of Night", "Adept of Night"},
     {"Adept of Night", "Adept of Night"},
     {"Adept of Death", "Adept of Death"},
     {"Adept of Death", "Adept of Death"},
     {"Demon Seeker", "Demon Seeker"},
     {"Demon Seeker", "Demon Seeker"},
     {"Lord of Blood", "Lady of Blood"},
     {"Lord of Blood", "Lady of Blood"},
     {"Lord of Night", "Lady of Night"},
     {"Lord of Night", "Lady of Night"},
     {"Lord of Death", "Lady of Death"},
     {"Lord of Death", "Lady of Death"},
     {"Demon Knight", "Demon Dame"},
     {"Demon Knight", "Demon Dame"},
     {"Master of Blood", "Mistress of Blood"},
     {"Master of Blood", "Mistress of Blood"},
     {"Master of Night", "Mistress of Night"},
     {"Master of Night", "Mistress of Night"},
     {"Master of Death", "Mistress of Death"},
     {"Master of Death", "Mistress of Death"},
     {"Lord of Demons", "Lady of Demons"},
     {"Lord of Demons", "Lady of Demons"},
     {"Baron of Demons", "Baroness of Demons"},
     {"Baron of Demons", "Baroness of Demons"},
     {"Master of Demons", "Mistress of Demons"},
     {"Master of Demons", "Mistress of Demons"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Vampire Hero", "Vampire Heroine"},
     {"Squire of Blood", "Squire of Blood"},
     {"Knight of Blood", "Dame of Blood"},
     {"Demigod of the Night", "Demigoddess of the Night"},
     {"Immortal Undead", "Immortal Undead"},
     {"God of Death", "Goddess of Death"},
     {"Deity of Death", "Deity of Death"},
     {"Supremity of Death", "Supremity of Death"},
     {"Creator", "Creator"},
     {"Supreme Diety", "Supreme Deity"},
     },
/*	Mage	*/

    {
     {"Man", "Woman"},

     {"Novice of Magic", "Novice of Magic"},
     {"Apprentice of Magic", "Apprentice of Magic"},
     {"Spell Novice", "Spell Novice"},
     {"Spell Student", "Spell Student"},
     {"Scholar of Magic", "Scholar of Magic"},
     {"Scholar of Wizardry", "Scholar of Wizardry"},
     {"Delver in Scrolls", "Delveress in Scrolls"},
     {"Delver in Spells", "Delveress in Spells"},
     {"Medium of Magic", "Medium of Magic"},
     {"Medium of Wizardry", "Medium of Wizardry"},
     {"Scribe of Magic", "Scribess of Magic"},
     {"Scribe of Wizardry", "Scribess of Wizardry"},
     {"Minor Seer", "Minor Seeress"},
     {"Seer", "Seeress"},
     {"Minor Sage", "Minor Sage"},
     {"Sage", "Sage"},
     {"Minor Illusionist", "Minor Illusionist"},
     {"Illusionist", "Illusionist"},
     {"Minor Abjurer", "Minor Abjuress"},
     {"Abjurer", "Abjuress"},
     {"Minor Invoker", "Minor Invoker"},
     {"Invoker", "Invoker"},
     {"Minor Enchanter", "Minor Enchantress"},
     {"Enchanter", "Enchantress"},
     {"Minor Conjurer", "Minor Conjuress"},
     {"Conjurer", "Conjuress"},
     {"Minor Magician", "Minor Witch"},
     {"Magician", "Witch"},
     {"Minor Creator", "Minor Creator"},
     {"Creator", "Creator"},
     {"Minor Savant", "Minor Savant"},
     {"Savant", "Savant"},
     {"Minor Magus", "Minor Craftess"},
     {"Magus", "Craftess"},
     {"Minor Wizard", "Minor Wizard"},
     {"Wizard", "Wizard"},
     {"Minor Warlock", "Minor War Witch"},
     {"Warlock", "War Witch"},
     {"Minor Sorcerer", "Minor Sorceress"},
     {"Sorcerer", "Sorceress"},
     {"Elder Sorcerer", "Elder Sorceress"},
     {"Elder Sorcerer", "Elder Sorceress"},
     {"Grand Sorcerer", "Grand Sorceress"},
     {"Grand Sorcerer", "Grand Sorceress"},
     {"Great Sorcerer", "Great Sorceress"},
     {"Great Sorcerer", "Great Sorceress"},
     {"Golem Maker", "Golem Maker"},
     {"Golem Maker", "Golem Maker"},
     {"Greater Golem Maker", "Greater Golem Maker"},
     {"Greater Golem Maker", "Greater Golem Maker"},
     {"Maker of Stones", "Maker of Stones",},
     {"Maker of Stones", "Maker of Stones",},
     {"Maker of Potions", "Maker of Potions",},
     {"Maker of Potions", "Maker of Potions",},
     {"Maker of Scrolls", "Maker of Scrolls",},
     {"Maker of Scrolls", "Maker of Scrolls",},
     {"Maker of Wands", "Maker of Wands",},
     {"Maker of Wands", "Maker of Wands",},
     {"Maker of Staves", "Maker of Staves",},
     {"Maker of Staves", "Maker of Staves",},
     {"Demon Summoner", "Demon Summoner"},
     {"Demon Summoner", "Demon Summoner"},
     {"Greater Demon Summoner", "Greater Demon Summoner"},
     {"Greater Demon Summoner", "Greater Demon Summoner"},
     {"Dragon Charmer", "Dragon Charmer"},
     {"Dragon Charmer", "Dragon Charmer"},
     {"Greater Dragon Charmer", "Greater Dragon Charmer"},
     {"Greater Dragon Charmer", "Greater Dragon Charmer"},
     {"Master of all Magic", "Master of all Magic"},
     {"Master of all Magic", "Master of all Magic"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Master Mage", "Master Mage"},
     {"Mage Hero", "Mage Heroine"},
     {"Squire of Magic", "Squire of Magic"},
     {"Knight of Magic", "Dame of Magic"},
     {"Demigod of Magic", "Demigoddess of Magic"},
     {"Immortal of Magic", "Immortal of Magic"},
     {"God of Magic", "Goddess of Magic"},
     {"Deity of Magic", "Deity of Magic"},
     {"Supremity of Magic", "Supremity of Magic"},
     {"Creator", "Creator"},
     {"Supreme Deity", "Supreme Deity"}
     },

/*	Cleric	*/

    {
     {"Man", "Woman"},

     {"Believer", "Believer"},
     {"Believer", "Believer"},
     {"Attendant", "Attendant"},
     {"Attendant", "Attendant"},
     {"Acolyte", "Acolyte"},
     {"Acolyte", "Acolyte"},
     {"Novice", "Novice"},
     {"Novice", "Novice"},
     {"Missionary", "Missionary"},
     {"Missionary", "Missionary"},
     {"Adept", "Adept"},
     {"Adept", "Adept"},
     {"Deacon", "Deaconess"},
     {"Deacon", "Deaconess"},
     {"Vicar", "Vicaress"},
     {"Vicar", "Vicaress"},
     {"Priest", "Priestess"},
     {"Priest", "Priestess"},
     {"Minister", "Lady Minister"},
     {"Minister", "Lady Minister"},
     {"Canon", "Canon"},
     {"Canon", "Canon"},
     {"Levite", "Levitess"},
     {"Levite", "Levitess"},
     {"Curate", "Curess"},
     {"Curate", "Curess"},
     {"Monk", "Nun"},
     {"Monk", "Nun"},
     {"Healer", "Healess"},
     {"Healer", "Healess"},
     {"Chaplain", "Chaplain"},
     {"Chaplain", "Chaplain"},
     {"Expositor", "Expositress"},
     {"Expositor", "Expositress"},
     {"Bishop", "Bishop"},
     {"Bishop", "Bishop"},
     {"Arch Bishop", "Arch Lady of the Church"},
     {"Arch Bishop", "Arch Lady of the Church"},
     {"Patriarch", "Matriarch"},
     {"Patriarch", "Matriarch"},
     {"Elder Patriarch", "Elder Matriarch"},
     {"Elder Patriarch", "Elder Matriarch"},
     {"Grand Patriarch", "Grand Matriarch"},
     {"Grand Patriarch", "Grand Matriarch"},
     {"Great Patriarch", "Great Matriarch"},
     {"Great Patriarch", "Great Matriarch"},
     {"Demon Killer", "Demon Killer"},
     {"Demon Killer", "Demon Killer"},
     {"Greater Demon Killer", "Greater Demon Killer"},
     {"Greater Demon Killer", "Greater Demon Killer"},
     {"Cardinal of the Sea", "Cardinal of the Sea"},
     {"Cardinal of the Sea", "Cardinal of the Sea"},
     {"Cardinal of the Earth", "Cardinal of the Earth"},
     {"Cardinal of the Earth", "Cardinal of the Earth"},
     {"Cardinal of the Air", "Cardinal of the Air"},
     {"Cardinal of the Air", "Cardinal of the Air"},
     {"Cardinal of the Ether", "Cardinal of the Ether"},
     {"Cardinal of the Ether", "Cardinal of the Ether"},
     {"Cardinal of the Heavens", "Cardinal of the Heavens"},
     {"Cardinal of the Heavens", "Cardinal of the Heavens"},
     {"Avatar of an Immortal", "Avatar of an Immortal"},
     {"Avatar of an Immortal", "Avatar of an Immortal"},
     {"Avatar of a Deity", "Avatar of a Deity"},
     {"Avatar of a Deity", "Avatar of a Deity"},
     {"Avatar of a Supremity", "Avatar of a Supremity"},
     {"Avatar of a Supremity", "Avatar of a Supremity"},
     {"Avatar of an Implementor", "Avatar of an Implementor"},
     {"Avatar of an Implementor", "Avatar of an Implementor"},
     {"Master of all Divinity", "Mistress of all Divinity"},
     {"Master of all Divinity", "Mistress of all Divinity"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Master Cleric", "Master Cleric"},
     {"Holy Hero", "Holy Heroine"},
     {"Holy Squire", "Holy Squire"},
     {"Holy Knight", "Holy Dame"},
     {"Demigod", "Demigoddess",},
     {"Immortal", "Immortal"},
     {"God", "Goddess"},
     {"Deity", "Deity"},
     {"Supreme Master", "Supreme Mistress"},
     {"Creator", "Creator"},
     {"Supreme Deity", "Supreme Deity"}
     },

/*	Thief	*/

    {
     {"Man", "Woman"},

     {"Pilferer", "Pilferess"},
     {"Pilferer", "Pilferess"},
     {"Footpad", "Footpad"},
     {"Footpad", "Footpad"},
     {"Filcher", "Filcheress"},
     {"Filcher", "Filcheress"},
     {"Pick-Pocket", "Pick-Pocket"},
     {"Pick-Pocket", "Pick-Pocket"},
     {"Sneak", "Sneak"},
     {"Sneak", "Sneak"},
     {"Pincher", "Pincheress"},
     {"Pincher", "Pincheress"},
     {"Cut-Purse", "Cut-Purse"},
     {"Cut-Purse", "Cut-Purse"},
     {"Snatcher", "Snatcheress"},
     {"Snatcher", "Snatcheress"},
     {"Sharper", "Sharpress"},
     {"Sharper", "Sharpress"},
     {"Rogue", "Rogue"},
     {"Rogue", "Rogue"},
     {"Robber", "Robber"},
     {"Robber", "Robber"},
     {"Magsman", "Magswoman"},
     {"Magsman", "Magswoman"},
     {"Highwayman", "Highwaywoman"},
     {"Highwayman", "Highwaywoman"},
     {"Burglar", "Burglaress"},
     {"Burglar", "Burglaress"},
     {"Thief", "Thief"},
     {"Thief", "Thief"},
     {"Knifer", "Knifer"},
     {"Knifer", "Knifer"},
     {"Quick-Blade", "Quick-Blade"},
     {"Quick-Blade", "Quick-Blade"},
     {"Killer", "Murderess"},
     {"Killer", "Murderess"},
     {"Brigand", "Brigand"},
     {"Brigand", "Brigand"},
     {"Cut-Throat", "Cut-Throat"},
     {"Cut-Throat", "Cut-Throat"},
     {"Spy", "Spy"},
     {"Spy", "Spy"},
     {"Grand Spy", "Grand Spy"},
     {"Grand Spy", "Grand Spy"},
     {"Master Spy", "Master Spy"},
     {"Master Spy", "Master Spy"},
     {"Assassin", "Assassin"},
     {"Assassin", "Assassin"},
     {"Greater Assassin", "Greater Assassin"},
     {"Greater Assassin", "Greater Assassin"},
     {"Master of Vision", "Mistress of Vision"},
     {"Master of Vision", "Mistress of Vision"},
     {"Master of Hearing", "Mistress of Hearing"},
     {"Master of Hearing", "Mistress of Hearing"},
     {"Master of Smell", "Mistress of Smell"},
     {"Master of Smell", "Mistress of Smell"},
     {"Master of Taste", "Mistress of Taste"},
     {"Master of Taste", "Mistress of Taste"},
     {"Master of Touch", "Mistress of Touch"},
     {"Master of Touch", "Mistress of Touch"},
     {"Crime Lord", "Crime Mistress"},
     {"Crime Lord", "Crime Mistress"},
     {"Infamous Crime Lord", "Infamous Crime Mistress"},
     {"Infamous Crime Lord", "Infamous Crime Mistress"},
     {"Greater Crime Lord", "Greater Crime Mistress"},
     {"Greater Crime Lord", "Greater Crime Mistress"},
     {"Master Crime Lord", "Master Crime Mistress"},
     {"Master Crime Lord", "Master Crime Mistress"},
     {"Godfather", "Godmother"},
     {"Godfather", "Godmother"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Master Thief", "Master Thief"},
     {"Assassin Hero", "Assassin Heroine"},
     {"Squire of Death", "Squire of Death",},
     {"Knight of Death", "Dame of Death"},
     {"Demigod of Assassins", "Demigoddess of Assassins"},
     {"Immortal Assasin", "Immortal Assassin"},
     {"God of Assassins", "God of Assassins",},
     {"Deity of Assassins", "Deity of Assassins"},
     {"Supreme Master", "Supreme Mistress"},
     {"Creator", "Creator"},
     {"Supreme Deity", "Supreme Deity"}
     },

/*	Warrior	*/

    {
     {"Man", "Woman"},

     {"Swordpupil", "Swordpupil"},
     {"Swordpupil", "Swordpupil"},
     {"Recruit", "Recruit"},
     {"Recruit", "Recruit"},
     {"Sentry", "Sentress"},
     {"Sentry", "Sentress"},
     {"Fighter", "Fighter"},
     {"Fighter", "Fighter"},
     {"Soldier", "Soldier"},
     {"Soldier", "Soldier"},
     {"Warrior", "Warrior"},
     {"Warrior", "Warrior"},
     {"Veteran", "Veteran"},
     {"Veteran", "Veteran"},
     {"Swordsman", "Swordswoman"},
     {"Swordsman", "Swordswoman"},
     {"Fencer", "Fenceress"},
     {"Fencer", "Fenceress"},
     {"Combatant", "Combatess"},
     {"Combatant", "Combatess"},
     {"Hero", "Heroine"},
     {"Hero", "Heroine"},
     {"Myrmidon", "Myrmidon"},
     {"Myrmidon", "Myrmidon"},
     {"Swashbuckler", "Swashbuckleress"},
     {"Swashbuckler", "Swashbuckleress"},
     {"Mercenary", "Mercenaress"},
     {"Mercenary", "Mercenaress"},
     {"Swordmaster", "Swordmistress"},
     {"Swordmaster", "Swordmistress"},
     {"Lieutenant", "Lieutenant"},
     {"Lieutenant", "Lieutenant"},
     {"Champion", "Lady Champion"},
     {"Champion", "Lady Champion"},
     {"Dragoon", "Lady Dragoon"},
     {"Dragoon", "Lady Dragoon"},
     {"Cavalier", "Lady Cavalier"},
     {"Cavalier", "Lady Cavalier"},
     {"Knight", "Lady Knight"},
     {"Knight", "Lady Knight"},
     {"Grand Knight", "Grand Knight"},
     {"Grand Knight", "Grand Knight"},
     {"Master Knight", "Master Knight"},
     {"Master Knight", "Master Knight"},
     {"Strider", "Strider"},
     {"Strider", "Strider"},
     {"Grand Strider", "Grand Strider"},
     {"Grand Strider", "Grand Strider"},
     {"Demon Slayer", "Demon Slayer"},
     {"Demon Slayer", "Demon Slayer"},
     {"Greater Demon Slayer", "Greater Demon Slayer"},
     {"Greater Demon Slayer", "Greater Demon Slayer"},
     {"Dragon Slayer", "Dragon Slayer"},
     {"Dragon Slayer", "Dragon Slayer"},
     {"Greater Dragon Slayer", "Greater Dragon Slayer"},
     {"Greater Dragon Slayer", "Greater Dragon Slayer"},
     {"Underlord", "Underlord"},
     {"Underlord", "Underlord"},
     {"Overlord", "Overlord"},
     {"Overlord", "Overlord"},
     {"Baron of Thunder", "Baroness of Thunder"},
     {"Baron of Thunder", "Baroness of Thunder"},
     {"Baron of Storms", "Baroness of Storms"},
     {"Baron of Storms", "Baroness of Storms"},
     {"Baron of Tornadoes", "Baroness of Tornadoes"},
     {"Baron of Tornadoes", "Baroness of Tornadoes"},
     {"Baron of Hurricanes", "Baroness of Hurricanes"},
     {"Baron of Hurricanes", "Baroness of Hurricanes"},
     {"Baron of Meteors", "Baroness of Meteors"},
     {"Baron of Meteors", "Baroness of Meteors"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Master Warrior", "Master Warrior"},
     {"Knight Hero", "Knight Heroine"},
     {"Squire of War", "Squire of War"},
     {"Knight of War", "Dame of War"},
     {"Demigod of War", "Demigoddess of War"},
     {"Immortal Warlord", "Immortal Warlord"},
     {"God of War", "God of War"},
     {"Deity of War", "Deity of War"},
     {"Supreme Master of War", "Supreme Mistress of War"},
     {"Creator", "Creator"},
     {"Supreme Deity", "Supreme Deity"}
     },

/*	Ranger	*/

    {
     {"Man", "Woman"},

     {"Apprentice of the Hunt", "Apprentice of the Hunt"},
     {"Student of the Hunt", "Student of the Hunt"},
     {"Student of the Hunt", "Student of the Hunt"},
     {"Runner", "Runner"},
     {"Runner", "Runner"},
     {"Strider", "Strider"},
     {"Strider", "Strider"},
     {"Scout", "Scout"},
     {"Scout", "Scout"},
     {"Master Scout", "Master Scout"},
     {"Master Scout", "Master Scout"},
     {"Explorer", "Explorer"},
     {"Explorer", "Explorer"},
     {"Tracker", "Tracker"},
     {"Tracker", "Tracker"},
     {"Survivalist", "Survivalist"},
     {"Survivalist", "Survivalist"},
     {"Watcher", "Watcher"},
     {"Watcher", "Watcher"},
     {"Hunter", "Hunter"},
     {"Hunter", "Hunter"},
     {"Woodsman", "Woodswoman"},
     {"Woodsman", "Woodswoman"},
     {"Guide", "Guide"},
     {"Guide", "Guide"},
     {"Pathfinder", "Pathfinder"},
     {"Pathfinder", "Pathfinder"},
     {"Stalker", "Stalker"},
     {"Stalker", "Stalker"},
     {"Predator", "Predator"},
     {"Predator", "Predator"},
     {"Deerhunter", "Deerhunter"},
     {"Deerhunter", "Deerhunter"},
     {"Elkhunter", "Elkhunter"},
     {"Elkhunter", "Elkhunter"},
     {"Boarhunter", "Boarhunter"},
     {"Boarhunter", "Boarhunter"},
     {"Bearhunter", "Bearhunter"},
     {"Bearhunter", "Bearhunter"},
     {"Falconer", "Falconer"},
     {"Falconer", "Falconer"},
     {"Hawker", "Hawker"},
     {"Hawker", "Hawker"},
     {"Manhunter", "Manhunter"},
     {"Manhunter", "Manhunter"},
     {"Gianthunter", "Gianthunter"},
     {"Gianthunter", "Gianthunter"},
     {"Adept of the Hunt", "Adept of the Hunt"},
     {"Adept of the Hunt", "Adept of the Hunt"},
     {"Lord of the Hunt", "Lady of the Hunt"},
     {"Lord of the Hunt", "Lady of the Hunt"},
     {"Master of the Hunt", "Mistress of the Hunt"},
     {"Master of the Hunt", "Mistress of the Hunt"},
     {"Fox", "Fox"},
     {"Coyote", "Coyote"},
     {"Lynx", "Lynx"},
     {"Wolf", "Wolf"},
     {"Panther", "Panther"},
     {"Cougar", "Cougar"},
     {"Jaguar", "Jaguar"},
     {"Tiger", "Tiger"},
     {"Lion", "Lion"},
     {"Bear", "Bear"},
     {"Beastmaster", "Beastmaster"},
     {"Beastmaster", "Beastmaster"},
     {"Overlord of Beasts", "Overlord of Beasts"},
     {"Overlord of Beasts", "Overlord of Beasts"},
     {"Dragonhunter", "Dragonhunter"},
     {"Dragonhunter", "Dragonhunter"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Master Ranger", "Master Ranger"},
     {"Ranger Hero", "Ranger Heroine"},
     {"Squire of the Hunt", "Squire of the Hunt"},
     {"Knight of the Hunt", "Dame of the Hunt"},
     {"Demigod of Beasts", "Demigoddess of Beasts"},
     {"Immortal Hunter", "Immortal Huntress"},
     {"God of Beasts", "Goddess of Beasts"},
     {"Deity of Beasts", "Deity of Beasts"},
     {"Supremity of Beasts", "Supremity of Beasts"},
     {"Creator", "Creator"},
     {"Supreme Deity", "Supreme Deity"},
     },

/*	Druid	*/

    {
     {"Man", "Woman"},

     {"Apprentice of Nature", "Apprentice of Nature"},
     {"Student of Nature", "Student of Nature"},
     {"Student of Nature", "Student of Nature"},
     {"Scholar of Nature", "Scholar of Nature"},
     {"Scholar of Nature", "Scholar of Nature"},
     {"Neophyte", "Neophyte"},
     {"Neophyte", "Neophyte"},
     {"Naturalist", "Naturalist"},
     {"Naturalist", "Naturalist"},
     {"Forester", "Forestress"},
     {"Forester", "Forestress"},
     {"Student of Earth", "Student of Earth"},
     {"Student of Earth", "Student of Earth"},
     {"Student of Air", "Student of Air"},
     {"Student of Air", "Student of Air"},
     {"Student of Water", "Student of Water"},
     {"Student of Water", "Student of Water"},
     {"Student of Fire", "Student of Fire"},
     {"Student of Fire", "Student of Fire"},
     {"Student of Life", "Student of Life"},
     {"Student of Life", "Student of Life"},
     {"Student of The Elements", "Student of The Elements"},
     {"Student of The Elements", "Student of The Elements"},
     {"Herbalist", "Herbalist"},
     {"Herbalist", "Herbalist"},
     {"Philosopher", "Philosopher"},
     {"Philosopher", "Philosopher"},
     {"Sage", "Sage"},
     {"Sage", "Sage"},
     {"Prophet", "Prophetess"},
     {"Prophet", "Prophetess"},
     {"Adept of Earth", "Adept of Earth"},
     {"Adept of Earth", "Adept of Earth"},
     {"Adept of Air", "Adept of Air"},
     {"Adept of Air", "Adept of Air"},
     {"Adept of Water", "Adept of Water"},
     {"Adept of Water", "Adept of Water"},
     {"Adept of Fire", "Adept of Fire"},
     {"Adept of Fire", "Adept of Fire"},
     {"Adept of Life", "Adept of Life"},
     {"Adept of Life", "Adept of Life"},
     {"Adept of The Elements", "Adept of The Elements"},
     {"Adept of The Elements", "Adept of The Elements"},
     {"Druid of Earth", "Druidess of Earth"},
     {"Druid of Earth", "Druidess of Earth"},
     {"Druid of Air", "Druidess of Air"},
     {"Druid of Air", "Druidess of Air"},
     {"Druid of Water", "Druidess of Water"},
     {"Druid of Water", "Druidess of Water"},
     {"Druid of Fire", "Druidess of Fire"},
     {"Druid of Fire", "Druidess of Fire"},
     {"Druid of Life", "Druidess of Life"},
     {"Druid of Life", "Druidess of Life"},
     {"Druid of The Elements", "Druidess of The Elements"},
     {"Druid of The Elements", "Druidess of The Elements"},
     {"Sage of Earth", "Sage of Earth"},
     {"Sage of Earth", "Sage of Earth"},
     {"Sage of Air", "Sage of Air"},
     {"Sage of Air", "Sage of Air"},
     {"Sage of Water", "Sage of Water"},
     {"Sage of Water", "Sage of Water"},
     {"Sage of Fire", "Sage of Fire"},
     {"Sage of Fire", "Sage of Fire"},
     {"Sage of Life", "Sage of Life"},
     {"Sage of Life", "Sage of Life"},
     {"Sage of The Elements", "Sage of The Elements"},
     {"Sage of The Elements", "Sage of The Elements"},
     {"Master of Earth", "Mistress of Earth"},
     {"Master of Earth", "Mistress of Earth"},
     {"Master of Air", "Mistress of Air"},
     {"Master of Air", "Mistress of Air"},
     {"Master of Water", "Mistress of Water"},
     {"Master of Water", "Mistress of Water"},
     {"Master of Fire", "Mistress of Fire"},
     {"Master of Fire", "Mistress of Fire"},
     {"Master of Life", "Mistress of Life"},
     {"Master of Life", "Mistress of Life"},
     {"Master of The Elements", "Mistress of The Elements"},
     {"Master of The Elements", "Mistress of The Elements"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Master Druid", "Master Druid"},
     {"Druid Hero", "Druid Heroine"},
     {"Squire of The Elements", "Squire of The Elements"},
     {"Knight of The Elements", "Dame of The Elements"},
     {"Demigod of Nature", "Demigoddess of Nature"},
     {"Immortal Sage", "Immortal Sage"},
     {"God of The Elements", "Goddess of The Elements"},
     {"Deity of The Elements", "Deity of The Elements"},
     {"Supremity of The Elements", "Supremity of The Elements"},
     {"Creator", "Creator"},
     {"Supreme Diety", "Supreme Diety"},
     },

/*	Revenant	*/

    {
     {"Man", "Woman"},

     {"Blood Student", "Blood Student"},
     {"Scholar of Blood", "Scholar of Blood"},
     {"Scholar of Blood", "Scholar of Blood"},
     {"Student of the Night", "Student of the Night"},
     {"Student of the Night", "Student of the Night"},
     {"Student of Death", "Student of Death"},
     {"Student of Death", "Student of Death"},
     {"Lesser Imp", "Lesser Imp"},
     {"Greater Imp", "Greater Imp"},
     {"Illusionist", "Illusionist"},
     {"Illusionist", "Illusionist"},
     {"Seducer", "Seductress"},
     {"Seducer", "Seductress"},
     {"Stalker", "Stalker"},
     {"Stalker", "Stalker"},
     {"Stalker of Blood", "Stalker of Blood"},
     {"Stalker of Blood", "Stalker of Blood"},
     {"Stalker of Night", "Stalker of Night"},
     {"Stalker of Night", "Stalker of Night"},
     {"Stalker of Death", "Stalker of Death"},
     {"Stalker of Death", "Stalker of Death"},
     {"Shadow", "Shadow"},
     {"Shadow", "Shadow"},
     {"Shadow of Blood", "Shadow of Blood"},
     {"Shadow of Blood", "Shadow of Blood"},
     {"Shadow of Night", "Shadow of Night"},
     {"Shadow of Night", "Shadow of Night"},
     {"Shadow of Death", "Shadow of Death"},
     {"Shadow of Death", "Shadow of Death"},
     {"Killer", "Killer"},
     {"Killer", "Killer"},
     {"Murderer", "Murderer"},
     {"Murderer", "Murderer"},
     {"Incubus", "Succubus"},
     {"Incubus", "Succubus"},
     {"Nightstalker", "Nightstalker"},
     {"Nightstalker", "Nightstalker"},
     {"Revenant", "Revenant"},
     {"Revenant", "Revenant"},
     {"Lesser Vrolok", "Lesser Vrolok"},
     {"Vrolok", "Vrolok"},
     {"Greater Vrolok", "Greater Vrolok"},
     {"Demon Servant", "Demon Servant"},
     {"Demon Servant", "Demon Servant"},
     {"Adept of Blood", "Adept of Blood"},
     {"Adept of Blood", "Adept of Blood"},
     {"Adept of Night", "Adept of Night"},
     {"Adept of Night", "Adept of Night"},
     {"Adept of Death", "Adept of Death"},
     {"Adept of Death", "Adept of Death"},
     {"Demon Seeker", "Demon Seeker"},
     {"Demon Seeker", "Demon Seeker"},
     {"Lord of Blood", "Lady of Blood"},
     {"Lord of Blood", "Lady of Blood"},
     {"Lord of Night", "Lady of Night"},
     {"Lord of Night", "Lady of Night"},
     {"Lord of Death", "Lady of Death"},
     {"Lord of Death", "Lady of Death"},
     {"Demon Knight", "Demon Dame"},
     {"Demon Knight", "Demon Dame"},
     {"Master of Blood", "Mistress of Blood"},
     {"Master of Blood", "Mistress of Blood"},
     {"Master of Night", "Mistress of Night"},
     {"Master of Night", "Mistress of Night"},
     {"Master of Death", "Mistress of Death"},
     {"Master of Death", "Mistress of Death"},
     {"Lord of Demons", "Lady of Demons"},
     {"Lord of Demons", "Lady of Demons"},
     {"Baron of Demons", "Baroness of Demons"},
     {"Baron of Demons", "Baroness of Demons"},
     {"Master of Demons", "Mistress of Demons"},
     {"Master of Demons", "Mistress of Demons"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Master Vampire", "Master Vampire"},
     {"Vampire Hero", "Vampire Heroine"},
     {"Squire of Blood", "Squire of Blood"},
     {"Knight of Blood", "Dame of Blood"},
     {"Demigod of the Night", "Demigoddess of the Night"},
     {"Immortal Undead", "Immortal Undead"},
     {"God of Death", "Goddess of Death"},
     {"Deity of Death", "Deity of Death"},
     {"Supremity of Death", "Supremity of Death"},
     {"Creator", "Creator"},
     {"Supreme Diety", "Supreme Deity"},
     }

};
/*
 * Attribute bonus tables.
 */
const struct str_app_type str_app[26] = {
    {-5, -4, 0, 0},             /* 0  */
    {-5, -4, 3, 1},             /* 1  */
    {-3, -2, 3, 2},
    {-3, -1, 10, 3},            /* 3  */
    {-2, -1, 25, 4},
    {-2, -1, 55, 5},            /* 5  */
    {-1, 0, 80, 6},
    {-1, 0, 90, 7},
    {0, 0, 100, 8},
    {0, 0, 100, 9},
    {0, 0, 115, 10},            /* 10  */
    {0, 0, 115, 11},
    {0, 0, 130, 12},
    {0, 0, 130, 13},            /* 13  */
    {0, 1, 140, 14},
    {1, 1, 150, 15},            /* 15  */
    {1, 2, 165, 16},
    {2, 3, 180, 22},
    {2, 3, 200, 25},            /* 18  */
    {3, 4, 225, 30},
    {3, 5, 250, 35},            /* 20  */
    {4, 6, 300, 40},
    {4, 6, 350, 45},
    {5, 7, 400, 50},
    {5, 8, 450, 55},
    {6, 9, 500, 60}             /* 25   */
};

const struct int_app_type int_app[26] = {
    {3},                        /*  0 */
    {5},                        /*  1 */
    {7},
    {8},                        /*  3 */
    {9},
    {10},                       /*  5 */
    {12},
    {16},
    {22},
    {26},
    {32},                       /* 10 */
    {40},
    {50},
    {55},
    {64},
    {70},                       /* 15 */
    {74},
    {80},
    {88},                       /* 18 */
    {90},
    {98},                       /* 20 */
    {102},
    {106},
    {110},
    {112},
    {114}                       /* 25 */
};

const struct wis_app_type wis_app[26] = {
    {0},                        /*  0 */
    {0},                        /*  1 */
    {0},
    {0},                        /*  3 */
    {0},
    {1},                        /*  5 */
    {1},
    {1},
    {1},
    {1},
    {1},                        /* 10 */
    {1},
    {1},
    {1},
    {1},
    {2},                        /* 15 */
    {2},
    {2},
    {3},                        /* 18 */
    {3},
    {3},                        /* 20 */
    {3},
    {4},
    {4},
    {4},
    {5}                         /* 25 */
};

const struct dex_app_type dex_app[26] = {
    {60},                       /* 0 */
    {50},                       /* 1 */
    {50},
    {40},
    {30},
    {20},                       /* 5 */
    {10},
    {0},
    {0},
    {0},
    {0},                        /* 10 */
    {0},
    {0},
    {0},
    {0},
    {-10},                      /* 15 */
    {-15},
    {-20},
    {-30},
    {-40},
    {-50},                      /* 20 */
    {-60},
    {-75},
    {-90},
    {-105},
    {-120}                      /* 25 */
};

const struct con_app_type con_app[26] = {
    {0, 20},                    /*  0 */
    {1, 25},                    /*  1 */
    {2, 30},
    {3, 35},                    /*  3 */
    {4, 40},
    {5, 45},                    /*  5 */
    {6, 50},
    {7, 55},
    {8, 60},
    {9, 65},
    {10, 70},                   /* 10 */
    {11, 75},
    {12, 80},
    {13, 85},
    {14, 88},
    {15, 90},                   /* 15 */
    {16, 95},
    {17, 97},
    {18, 100},                  /* 18 */
    {19, 105},
    {20, 110},                  /* 20 */
    {25, 115},
    {30, 120},
    {40, 125},
    {45, 150},
    {60, 160}                   /* 25 */
};

/*
 * Liquid properties.
 * Used in world.obj.
 * Be sure MAX_LIQUID in merc.h matches
 * the number of entries below.
 */
const struct liq_type liq_table[] = {
/*    name			color	proof, full, thirst, food, ssize */
    {"water", "clear", {0, 1, 10, 0, 16}},
    {"beer", "amber", {12, 1, 8, 1, 12}},
    {"red wine", "burgundy", {30, 1, 8, 1, 5}},
    {"ale", "brown", {15, 1, 8, 1, 12}},
    {"dark ale", "dark", {16, 1, 8, 1, 12}},

    {"whisky", "golden", {120, 1, 5, 0, 2}},
    {"lemonade", "pink", {0, 1, 9, 2, 12}},
    {"firebreather", "boiling", {190, 0, 4, 0, 2}},
    {"local specialty", "clear", {151, 1, 3, 0, 2}},
    {"slime mold juice", "green", {0, 2, -8, 1, 2}},

    {"milk", "white", {0, 2, 9, 3, 12}},
    {"tea", "tan", {0, 1, 8, 0, 6}},
    {"coffee", "black", {0, 1, 8, 0, 6}},
    {"blood", "red", {0, 2, -1, 2, 6}},
    {"salt water", "clear", {0, 1, -2, 0, 1}},

    {"coke", "brown", {0, 2, 9, 2, 12}},
    {"root beer", "brown", {0, 2, 9, 2, 12}},
    {"elvish wine", "green", {35, 2, 8, 1, 5}},
    {"white wine", "golden", {28, 1, 8, 1, 5}},
    {"champagne", "golden", {32, 1, 8, 1, 5}},

    {"mead", "honey-colored", {34, 2, 8, 2, 12}},
    {"rose wine", "pink", {26, 1, 8, 1, 5}},
    {"benedictine wine", "burgundy", {40, 1, 8, 1, 5}},
    {"vodka", "clear", {130, 1, 5, 0, 2}},
    {"cranberry juice", "red", {0, 1, 9, 2, 12}},

    {"orange juice", "orange", {0, 2, 9, 3, 12}},
    {"absinthe", "green", {200, 1, 4, 0, 2}},
    {"brandy", "golden", {80, 1, 5, 0, 4}},
    {"aquavit", "clear", {140, 1, 5, 0, 2}},
    {"schnapps", "clear", {90, 1, 5, 0, 2}},

    {"icewine", "purple", {50, 2, 6, 1, 5}},
    {"amontillado", "burgundy", {35, 2, 8, 1, 5}},
    {"sherry", "red", {38, 2, 7, 1, 5}},
    {"framboise", "red", {50, 1, 7, 1, 5}},
    {"rum", "amber", {151, 1, 4, 0, 2}},

    {"cordial", "clear", {100, 1, 5, 0, 2}},
    {"dr pepper", "brown", {0, 2, 9, 2, 12}},
    {NULL, NULL, {0, 0, 0, 0, 0}}
};

/*
 * The skill and spell table.
 * Slot numbers must never be changed as they appear in #OBJECTS sections.
 */
#define SLOT(n)	n

const struct skill_type skill_table[MAX_SKILL] = {

/*
 * Magic spells.
 */

/*
    {
	"NAME",
	{ SKILL_LEVELS 1st TIER,
	  SKILL_LEVELS 2nd TIER },
	{ DIFFICULTY 1st TIER,
	  DIFFICULTY 2nd TIER },
	SPELL_FUN,		TARGET,		MIN_POSITION,
	GSN,		SOCKET,	SLOT(#),	MIN_MANA,	BEATS,
	"DAMAGE NOUN",	"OFF MESSAGE",	"OFF MESSAGE (OBJ)"
    }

	NAME		Name of Spell/Skill
	SKILL_LEVELS	Levels to obtain spell/skill per class
	DIFFICULTY	Spells: multiplier for base mana
			Skills: charge for gaining skill
	SPELL_FUN	Routine to call for spells
	TARGET		Legal targets
	MIN_POSTITION	Position for caster/user
	GSN		gsn for skills and some spells
	SOCKET		Can spell be cast on person from same socket
			(to limit multiplaying)
	SLOT(#)		A unique slot number for spells
	MIN_MANA	Base mana for spells (multiplied by DIFFICULTY)
	BEATS		Waiting time after use
	DAMAGE NOUN	Damage Message
	OFF MESSAGE	Wear off message
	OFF MESSAGE (OBJ)	Wear off message for objects
      
      Mage, Cleric, Thief, Warrior, Ranger, Druid, Vampire
*/

    {
     "reserved",
     {299, 299, 299, 299, 299, 299, 299,
      299, 299, 299, 299, 299, 299, 299,
      299, 299, 299, 299, 299, 299, 299,
      299, 299, 299, 299, 299, 299, 299},
     {199, 199, 199, 199, 199, 199, 199,
      199, 199, 199, 199, 199, 199, 199,
      199, 199, 199, 199, 199, 199, 199,
      199, 199, 199, 199, 199, 199, 199},
     0, TAR_IGNORE, POS_STANDING,
     NULL, TRUE, SLOT ( 0 ), 0, 0,
     "", "", ""},

    {
     "drain blade",
     {163, 173, 203, 203, 203, 203, 203,
      153, 163, 203, 203, 203, 203, 203,
      143, 153, 203, 203, 203, 203, 203,
      133, 143, 203, 203, 203, 203, 203},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_drain_blade, TAR_OBJ_INV, POS_STANDING,
     NULL, TRUE, SLOT ( 736 ), 20, 0,
     "drain blade", "!drain!", "Your weapon looses it's vampiric abilities"},

    {
     "vorpal blade",
     {191, 201, 203, 203, 203, 203, 203,
      181, 191, 203, 203, 203, 203, 203,
      171, 181, 203, 203, 203, 203, 203,
      161, 171, 203, 203, 203, 203, 203},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_vorpal_blade, TAR_OBJ_INV, POS_STANDING,
     NULL, TRUE, SLOT ( 796 ), 20, 0,
     "vorpal blade", "!vorpal!", "Your weapon's edge gets dull"},

    {
     "flame blade",
     {176, 186, 203, 203, 203, 203, 203,
      166, 176, 203, 203, 203, 203, 203,
      156, 166, 203, 203, 203, 203, 203,
      146, 156, 203, 203, 203, 203, 203},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_flame_blade, TAR_OBJ_INV, POS_STANDING,
     NULL, TRUE, SLOT ( 196 ), 20, 0,
     "flame blade", "!flame!", "Your weapon's flaming aura fades out"},

    {
     "shocking blade",
     {184, 194, 203, 203, 203, 203, 203,
      174, 184, 203, 203, 203, 203, 203,
      164, 174, 203, 203, 203, 203, 203,
      154, 164, 203, 203, 203, 203, 203},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_shocking_blade, TAR_OBJ_INV, POS_STANDING,
     NULL, TRUE, SLOT ( 245 ), 20, 0,
     "shocking blade", "!shock!", "Your weapon's shocking aura dies out"},

    {
     "sharp blade",
     {134, 144, 203, 203, 203, 203, 203,
      124, 134, 203, 203, 203, 203, 203,
      114, 124, 203, 203, 203, 203, 203,
      104, 114, 203, 203, 203, 203, 203},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_sharp_blade, TAR_OBJ_INV, POS_STANDING,
     NULL, TRUE, SLOT ( 340 ), 20, 0,
     "sharp blade", "!sharp!", "Your weapon's edge gets dull"},

    {
     "frost blade",
     {120, 130, 203, 203, 203, 203, 203,
      110, 120, 203, 203, 203, 203, 203,
      100, 110, 203, 203, 203, 203, 203,
      90, 100, 203, 203, 203, 203, 203},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_frost_blade, TAR_OBJ_INV, POS_STANDING,
     NULL, TRUE, SLOT ( 506 ), 20, 0,
     "frost blade", "!frost!", "Your weapon's frosty aura slowly melts away"},

    {
     "4x",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_4x, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, TRUE, SLOT ( 799 ), 20, 1,
     "Your murderous rage ebbs.", "Your murderous rage ebbs.",
     "Your murderous rage ebbs."},
    {
     "sate",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_sate, TAR_CHAR_DEFENSIVE, POS_FIGHTING,
     NULL, FALSE, SLOT ( 284 ), 50, 12,
     "", "!Sate!", ""},
    {
     "quench",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_quench, TAR_CHAR_DEFENSIVE, POS_FIGHTING,
     NULL, FALSE, SLOT ( 286 ), 50, 12,
     "", "!Quench!", ""},
    {
     "heroes feast",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_heroes_feast, TAR_CHAR_DEFENSIVE, POS_FIGHTING,
     NULL, FALSE, SLOT ( 299 ), 50, 12,
     "", "!Heroes Feast!", ""},
    {
     "holy mace",
     {203, 190, 203, 203, 203, 203, 203,
      203, 180, 203, 203, 203, 203, 203,
      203, 170, 203, 203, 203, 203, 203,
      203, 160, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2},
     spell_holy_mace, TAR_IGNORE, POS_STANDING,
     NULL, TRUE, SLOT ( 696 ), 30, 12,
     "", "!Create Rose!", ""},

    {
     "acid rain",
     {180, 190, 203, 203, 203, 203, 203,
      170, 180, 203, 203, 203, 203, 203,
      160, 170, 203, 203, 203, 203, 203,
      150, 160, 203, 203, 203, 203, 203},
     {1, 2, 1, 1, 1, 1, 1,
      1, 2, 1, 1, 1, 1, 1,
      1, 2, 1, 1, 1, 1, 1,
      1, 2, 1, 1, 1, 1, 1},
     spell_acid_rain, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 70 ), 200, 12,
     "acid rain", "!Acid Rain!", ""},

    {
     "acid blast",
     {55, 93, 203, 203, 120, 55, 85,
      45, 83, 203, 203, 110, 45, 75,
      35, 73, 203, 203, 100, 35, 65,
      25, 63, 203, 203, 100, 25, 55},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_acid_blast, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 70 ), 20, 12,
     "acid blast", "!Acid Blast!", ""},

    {
     "animate",
     {203, 203, 203, 203, 203, 203, 65,
      203, 203, 203, 203, 203, 203, 55,
      203, 203, 203, 203, 203, 203, 45,
      203, 203, 203, 203, 203, 203, 35},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_animate, TAR_OBJ_INV, POS_STANDING,
     NULL, TRUE, SLOT ( 239 ), 20, 12,
     "", "!Animate!", ""},

    {
     "armor",
     {25, 20, 203, 203, 203, 40, 203,
      15, 10, 203, 203, 203, 30, 203,
      10, 5, 203, 203, 203, 20, 203,
      8, 2, 203, 203, 203, 15, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_armor, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, FALSE, SLOT ( 1 ), 5, 12,
     "", "You feel less armored.", ""},
    {
     "anger",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_anger, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 150 ), 5, 12,
     "", "You calm down.", ""},

    {
     "blade bless",
     {160, 120, 203, 203, 203, 203, 203,
      150, 110, 203, 203, 203, 203, 203,
      140, 100, 203, 203, 203, 203, 203,
      130, 90, 203, 203, 203, 203, 203},
     {2, 2, 4, 4, 4, 2, 4,
      2, 2, 4, 4, 4, 2, 4,
      2, 2, 4, 4, 4, 2, 4,
      2, 2, 4, 4, 4, 2, 4},
     spell_blade_bless, TAR_OBJ_INV, POS_STANDING,
     NULL, TRUE, SLOT ( 516 ), 100, 24,
     "", "!BLADE BLESS!", ""},
    {
     "bless",
     {95, 20, 203, 203, 203, 96, 203,
      75, 10, 203, 203, 203, 86, 203,
      65, 5, 203, 203, 203, 76, 203,
      55, 2, 203, 203, 203, 66, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_bless, TAR_OBJ_CHAR_DEF, POS_STANDING,
     NULL, FALSE, SLOT ( 3 ), 5, 12,
     "", "You feel less righteous.",
     "$p's holy aura fades."},

    {
     "blindness",
     {34, 35, 203, 203, 65, 44, 34,
      24, 25, 203, 203, 55, 34, 24,
      14, 15, 203, 203, 55, 24, 24,
      8, 10, 203, 203, 45, 14, 14},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_blindness, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     &gsn_blindness, TRUE, SLOT ( 4 ), 5, 12,
     "", "You can see again.", ""},

    {
     "brage",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      202, 203, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_blind_rage, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 156 ), 5, 12,
     "", "You calm down.", ""},
    {
     "burning hands",
     {23, 87, 203, 203, 203, 93, 110,
      13, 77, 203, 203, 203, 83, 100,
      3, 67, 203, 203, 203, 73, 90,
      1, 57, 203, 203, 203, 63, 80},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_burning_hands, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 5 ), 15, 12,
     "burning hands", "!Burning Hands!", ""},

    {
     "call lightning",
     {40, 56, 203, 203, 30, 48, 203,
      30, 46, 203, 203, 20, 38, 203,
      20, 36, 203, 203, 20, 38, 203,
      20, 36, 203, 203, 20, 38, 203},
     {1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1},
     spell_call_lightning, TAR_IGNORE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 6 ), 15, 12,
     "lightning bolt", "!Call Lightning!", ""},

    {
     "calm",
     {105, 42, 203, 203, 90, 46, 59,
      95, 32, 203, 203, 80, 36, 49,
      85, 22, 203, 203, 70, 26, 39,
      75, 12, 203, 203, 60, 16, 29},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_calm, TAR_IGNORE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 509 ), 30, 12,
     "", "You have lost your peace of mind.", ""},
    {
     "call darkness",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 202},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_call_darkness, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 711 ), 200, 12,
     "{DP{wo{Dw{we{Dr{ws{x of {DD{ba{Dr{bk{Dn{be{Ds{bs{x", "!Vampire Blast!",
     ""},

    {
     "leech",
     {203, 203, 203, 203, 203, 203, 180,
      203, 203, 203, 203, 203, 203, 180,
      203, 203, 203, 203, 203, 203, 170,
      203, 203, 203, 203, 203, 203, 160},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_leech, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 711 ), 150, 12,
     "{Dl{be{De{bc{Dh{x", "!Vampire Blast!", ""},
    {
     "camouflage",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_camouflage, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, FALSE, SLOT ( 265 ), 20, 12,
     "", "Your camoflage disapears.", ""},

    {
     "cancellation",
     {61, 51, 203, 203, 203, 96, 203,
      51, 41, 203, 203, 203, 86, 203,
      41, 31, 203, 203, 203, 76, 203,
      31, 21, 203, 203, 203, 66, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_cancellation, TAR_CHAR_DEFENSIVE, POS_FIGHTING,
     NULL, FALSE, SLOT ( 507 ), 20, 12,
     "" "!cancellation!", ""},

    {
     "cause critical",
     {25, 55, 203, 203, 203, 203, 21,
      15, 45, 203, 203, 203, 203, 11,
      5, 35, 203, 203, 203, 203, 6,
      2, 25, 203, 203, 203, 203, 4},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_cause_critical, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 63 ), 20, 12,
     "spell", "!Cause Critical!", ""},

    {
     "cause light",
     {5, 2, 203, 203, 203, 203, 5,
      1, 1, 203, 203, 203, 203, 4,
      1, 1, 203, 203, 203, 203, 1,
      1, 1, 203, 203, 203, 203, 1},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_cause_light, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 62 ), 15, 12,
     "spell", "!Cause Light!", ""},

    {
     "cause serious",
     {25, 23, 203, 203, 203, 190, 11,
      15, 13, 203, 203, 203, 180, 9,
      5, 8, 203, 203, 203, 170, 3,
      2, 4, 203, 203, 203, 160, 1},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_cause_serious, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 64 ), 17, 12,
     "spell", "!Cause Serious!", ""},

    {
     "chain lightning",
     {75, 203, 203, 203, 203, 203, 203,
      65, 203, 203, 203, 203, 203, 203,
      55, 203, 203, 203, 203, 203, 203,
      45, 203, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_chain_lightning, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 500 ), 25, 12,
     "lightning", "!Chain Lightning!", ""},

    {
     "change sex",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_change_sex, TAR_CHAR_DEFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 82 ), 15, 12,
     "", "Your body feels familiar again.", ""},

    {
     "charm person",
     {50, 30, 50, 203, 50, 203, 43,
      40, 20, 40, 203, 40, 203, 33,
      30, 10, 30, 203, 30, 203, 23,
      20, 5, 20, 203, 20, 203, 15},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_charm_person, TAR_CHAR_OFFENSIVE, POS_STANDING,
     &gsn_charm_person, TRUE, SLOT ( 7 ), 5, 12,
     "", "You feel more self-confident.", ""},

    {
     "chill touch",
     {12, 180, 203, 203, 203, 22, 40,
      2, 170, 203, 203, 203, 12, 30,
      1, 160, 203, 203, 203, 6, 20,
      1, 150, 203, 203, 203, 4, 10},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_chill_touch, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 8 ), 15, 12,
     "chilling touch", "You feel less cold.", ""},

    {
     "colour spray",
     {32, 203, 203, 203, 203, 20, 203,
      22, 203, 203, 203, 203, 10, 203,
      12, 203, 203, 203, 203, 5, 203,
      6, 203, 203, 203, 203, 2, 203},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_colour_spray, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 10 ), 15, 12,
     "colour spray", "!Colour Spray!", ""},

    {
     "concentration",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_concentration, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, FALSE, SLOT ( 651 ), 1, 18,
     "concentration", "!Concentration!", ""},

    {
     "conjure",
     {85, 203, 203, 203, 203, 95, 203,
      75, 203, 203, 203, 203, 85, 203,
      65, 203, 203, 203, 203, 75, 203,
      55, 203, 203, 203, 203, 65, 203},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_conjure, TAR_IGNORE, POS_STANDING,
     NULL, TRUE, SLOT ( 280 ), 100, 12,
     "", "!Conjure!", ""},

    {
     "continual light",
     {11, 8, 203, 203, 7, 5, 203,
      1, 7, 203, 203, 1, 4, 203,
      1, 3, 203, 203, 1, 1, 203,
      1, 1, 203, 203, 1, 1, 203},
     {1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2},
     spell_continual_light, TAR_IGNORE, POS_STANDING,
     NULL, TRUE, SLOT ( 57 ), 7, 12,
     "", "!Continual Light!", ""},

    {
     "control weather",
     {203, 48, 203, 203, 32, 20, 203,
      203, 38, 203, 203, 22, 10, 203,
      203, 28, 203, 203, 12, 5, 203,
      203, 18, 203, 203, 6, 2, 203},
     {1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2},
     spell_control_weather, TAR_IGNORE, POS_STANDING,
     NULL, TRUE, SLOT ( 11 ), 25, 12,
     "", "!Control Weather!", ""},
    {
     "create bed",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2},
     spell_create_bed, TAR_IGNORE, POS_STANDING,
     NULL, TRUE, SLOT ( 126 ), 5, 12,
     "", "!Create Food!", ""},

    {
     "create food",
     {29, 10, 203, 203, 6, 7, 203,
      19, 1, 203, 203, 1, 6, 203,
      9, 1, 203, 203, 1, 4, 203,
      4, 1, 203, 203, 1, 2, 203},
     {1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2},
     spell_create_food, TAR_IGNORE, POS_STANDING,
     NULL, TRUE, SLOT ( 12 ), 5, 12,
     "", "!Create Food!", ""},

    {
     "create rose",
     {42, 21, 203, 203, 16, 11, 203,
      32, 11, 203, 203, 6, 1, 203,
      22, 6, 203, 203, 4, 1, 203,
      12, 4, 203, 203, 2, 1, 203},
     {1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2},
     spell_create_rose, TAR_IGNORE, POS_STANDING,
     NULL, TRUE, SLOT ( 511 ), 30, 12,
     "", "!Create Rose!", ""},

    {
     "create spring",
     {38, 34, 203, 203, 26, 24, 203,
      28, 24, 203, 203, 16, 14, 203,
      18, 14, 203, 203, 6, 4, 203,
      8, 4, 203, 203, 4, 2, 203},
     {1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2},
     spell_create_spring, TAR_IGNORE, POS_STANDING,
     NULL, TRUE, SLOT ( 80 ), 20, 12,
     "", "!Create Spring!", ""},

    {
     "create water",
     {25, 5, 203, 203, 2, 3, 203,
      15, 1, 203, 203, 1, 2, 203,
      5, 1, 203, 203, 1, 1, 203,
      3, 1, 203, 203, 1, 1, 203},
     {1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2},
     spell_create_water, TAR_OBJ_INV, POS_STANDING,
     NULL, TRUE, SLOT ( 13 ), 5, 12,
     "", "!Create Water!", ""},

    {
     "cry",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_cry, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 680 ), 20, 12,
     "spell", "You stop your crying.", ""},
    {
     "cure blindness",
     {170, 11, 203, 203, 13, 16, 203,
      160, 1, 203, 203, 3, 6, 203,
      150, 1, 203, 203, 1, 2, 203,
      140, 1, 203, 203, 1, 1, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_cure_blindness, TAR_CHAR_DEFENSIVE, POS_FIGHTING,
     NULL, FALSE, SLOT ( 14 ), 5, 12,
     "", "!Cure Blindness!", ""},

    {

     "cure critical",
     {203, 25, 203, 203, 49, 37, 203,
      203, 15, 203, 203, 39, 27, 203,
      203, 5, 203, 203, 29, 17, 203,
      203, 2, 203, 203, 19, 7, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_cure_critical, TAR_CHAR_DEFENSIVE, POS_FIGHTING,
     NULL, FALSE, SLOT ( 15 ), 20, 12,
     "", "!Cure Critical!", ""},

    {
     "cure disease",
     {203, 26, 203, 203, 28, 32, 203,
      203, 16, 203, 203, 18, 22, 203,
      203, 6, 203, 203, 8, 12, 203,
      203, 3, 203, 203, 4, 6, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_cure_disease, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, FALSE, SLOT ( 501 ), 20, 12,
     "", "!Cure Disease!", ""},

    {
     "cure light",
     {203, 4, 203, 203, 3, 8, 203,
      203, 3, 203, 203, 1, 1, 203,
      203, 1, 203, 203, 1, 1, 203,
      203, 1, 203, 203, 1, 1, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_cure_light, TAR_CHAR_DEFENSIVE, POS_FIGHTING,
     NULL, FALSE, SLOT ( 16 ), 10, 12,
     "", "!Cure Light!", ""},

    {
     "cure poison",
     {203, 28, 203, 203, 37, 33, 203,
      203, 18, 203, 203, 27, 23, 203,
      203, 18, 203, 203, 27, 23, 203,
      203, 8, 203, 203, 17, 13, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_cure_poison, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, FALSE, SLOT ( 43 ), 5, 12,
     "", "!Cure Poison!", ""},

    {
     "cure serious",
     {203, 24, 203, 203, 34, 24, 203,
      203, 14, 203, 203, 24, 14, 203,
      203, 4, 203, 203, 14, 4, 203,
      203, 2, 203, 203, 7, 2, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_cure_serious, TAR_CHAR_DEFENSIVE, POS_FIGHTING,
     NULL, FALSE, SLOT ( 61 ), 15, 12,
     "", "!Cure Serious!", ""},

    {
     "curse",
     {45, 35, 203, 203, 203, 38, 45,
      35, 25, 203, 203, 203, 28, 35,
      25, 15, 203, 203, 203, 18, 25,
      18, 10, 203, 203, 203, 10, 15},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_curse, TAR_OBJ_CHAR_OFF, POS_FIGHTING,
     &gsn_curse, TRUE, SLOT ( 17 ), 20, 12,
     "curse", "The curse wears off.",
     "$p is no longer impure."},

    {
     "dark gift",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 202},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_dark_gift, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 535 ), 200, 12,
     "", "Your assosiation with the dark side fails.", ""},
    {
     "demonfire",
     {76, 68, 203, 203, 203, 203, 77,
      66, 58, 203, 203, 203, 203, 67,
      56, 48, 203, 203, 203, 203, 57,
      46, 38, 203, 203, 203, 203, 47},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_demonfire, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 505 ), 20, 12,
     "torments", "!Demonfire!", ""},

    {
     "detect evil",
     {22, 22, 203, 203, 10, 203, 17,
      12, 12, 203, 203, 5, 203, 7,
      6, 5, 203, 203, 1, 203, 4,
      3, 2, 203, 203, 1, 203, 3},
     {1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1},
     spell_detect_evil, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 18 ), 5, 12,
     "", "The red in your vision disappears.", ""},

    {
     "detect good",
     {22, 22, 203, 203, 10, 203, 17,
      12, 12, 203, 203, 1, 203, 7,
      10, 10, 203, 203, 1, 203, 4,
      5, 5, 203, 203, 1, 203, 2},
     {1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1},
     spell_detect_good, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 513 ), 5, 12,
     "", "The gold in your vision disappears.", ""},

    {
     "detect hidden",
     {24, 22, 24, 203, 29, 26, 18,
      14, 12, 14, 203, 19, 16, 8,
      6, 4, 6, 203, 10, 8, 4,
      3, 2, 3, 203, 5, 4, 2},
     {1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1},
     spell_detect_hidden, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 44 ), 5, 12,
     "", "You feel less aware of your surroundings.",
     ""},

    {
     "detect invis",
     {25, 16, 11, 203, 25, 25, 4,
      15, 6, 1, 203, 15, 15, 3,
      11, 4, 1, 203, 9, 9, 2,
      6, 2, 1, 203, 4, 5, 1},
     {1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1},
     spell_detect_invis, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 19 ), 5, 12,
     "", "You no longer see invisible objects.",
     ""},

    {
     "detect magic",
     {26, 11, 8, 203, 24, 21, 3,
      16, 1, 1, 203, 14, 11, 2,
      12, 1, 1, 203, 12, 11, 2,
      6, 1, 1, 203, 6, 5, 1},
     {1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1},
     spell_detect_magic, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 20 ), 5, 12,
     "", "The detect magic wears off.", ""},

    {
     "detect poison",
     {27, 14, 18, 203, 8, 11, 11,
      17, 4, 8, 203, 4, 5, 5,
      10, 2, 4, 203, 2, 3, 3,
      5, 1, 2, 203, 1, 2, 2},
     {1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1},
     spell_detect_poison, TAR_OBJ_INV, POS_STANDING,
     NULL, TRUE, SLOT ( 21 ), 5, 12,
     "", "!Detect Poison!", ""},

    {
     "dispel evil",
     {203, 30, 203, 203, 203, 35, 53,
      203, 20, 203, 203, 203, 25, 43,
      203, 10, 203, 203, 203, 15, 33,
      203, 5, 203, 203, 203, 7, 23},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_dispel_evil, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 22 ), 15, 12,
     "dispel evil", "!Dispel Evil!", ""},

    {
     "dispel good",
     {203, 30, 203, 203, 203, 35, 53,
      203, 20, 203, 203, 203, 25, 43,
      203, 10, 203, 203, 203, 15, 33,
      203, 5, 203, 203, 203, 7, 23},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_dispel_good, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 512 ), 15, 12,
     "dispel good", "!Dispel Good!", ""},

    {
     "dispel magic",
     {68, 48, 203, 203, 203, 45, 203,
      58, 38, 203, 203, 203, 35, 203,
      48, 28, 203, 203, 203, 25, 203,
      38, 18, 203, 203, 203, 15, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_dispel_magic, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 59 ), 15, 12,
     "", "!Dispel Magic!", ""},
    {
     "divine protection",
     {203, 175, 203, 203, 203, 203, 203,
      203, 165, 203, 203, 203, 203, 203,
      203, 155, 203, 203, 203, 203, 203,
      203, 145, 203, 203, 203, 203, 203},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_divine_protection, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, FALSE, SLOT ( 505 ), 20, 12,
     "", "Your holy protection fades.", ""},
    {
     "divine fury",
     {203, 55, 203, 203, 203, 203, 203,
      203, 45, 203, 203, 203, 203, 203,
      203, 35, 203, 203, 203, 203, 203,
      203, 25, 203, 203, 203, 203, 203},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_divine_fury, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, FALSE, SLOT ( 725 ), 20, 12,
     "{WDivine Fury{x", "Divine Fury!", ""},
    {
     "dragon skin",
     {120, 75, 203, 203, 203, 100, 203,
      110, 65, 203, 203, 203, 90, 203,
      100, 55, 203, 203, 203, 80, 203,
      90, 45, 203, 203, 203, 70, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_dragon_skin, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, FALSE, SLOT ( 174 ), 5, 12,
     "", "Your skin returns to its normal state.", ""},
    {
     "dragon wisdom",
     {60, 30, 203, 203, 203, 50, 203,
      50, 20, 203, 203, 203, 40, 203,
      40, 10, 203, 203, 203, 30, 203,
      30, 5, 203, 203, 203, 20, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_dragon_wisdom, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, FALSE, SLOT ( 39 ), 20, 12,
     "", "You feel less wise.", ""},
    {
     "earthquake",
     {53, 20, 203, 203, 36, 11, 76,
      43, 10, 203, 203, 26, 1, 66,
      33, 5, 203, 203, 16, 1, 56,
      23, 3, 203, 203, 6, 1, 46},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_earthquake, TAR_IGNORE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 23 ), 15, 12,
     "earthquake", "!Earthquake!", ""},

    {
     "empower",
     {36, 40, 203, 203, 203, 42, 203,
      26, 30, 203, 203, 203, 32, 203,
      20, 20, 203, 203, 203, 22, 203,
      20, 20, 203, 203, 203, 22, 203},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_empower, TAR_IGNORE, POS_RESTING,
     NULL, TRUE, SLOT ( 234 ), 40, 12,
     "", "!Empower!", ""},

    {
     "enchant armor",
     {41, 90, 203, 203, 203, 203, 203,
      31, 80, 203, 203, 203, 203, 203,
      21, 70, 203, 203, 203, 203, 203,
      21, 70, 203, 203, 203, 203, 203},
     {2, 2, 4, 4, 4, 2, 4,
      2, 2, 4, 4, 4, 2, 4,
      2, 2, 4, 4, 4, 2, 4,
      2, 2, 4, 4, 4, 2, 4},
     spell_enchant_armor, TAR_OBJ_INV, POS_STANDING,
     NULL, TRUE, SLOT ( 510 ), 100, 24,
     "", "!Enchant Armor!", ""},

    {
     "enchant weapon",
     {42, 90, 203, 203, 203, 203, 203,
      32, 80, 203, 203, 203, 203, 203,
      22, 70, 203, 203, 203, 203, 203,
      22, 70, 203, 203, 203, 203, 203},
     {2, 2, 4, 4, 4, 2, 4,
      2, 2, 4, 4, 4, 2, 4,
      2, 2, 4, 4, 4, 2, 4,
      2, 2, 4, 4, 4, 2, 4},
     spell_enchant_weapon, TAR_OBJ_INV, POS_STANDING,
     NULL, TRUE, SLOT ( 24 ), 100, 24,
     "", "!Enchant Weapon!", ""},

    {
     "energy drain",
     {58, 44, 203, 203, 203, 203, 10,
      48, 34, 203, 203, 203, 203, 5,
      38, 24, 203, 203, 203, 203, 1,
      28, 14, 203, 203, 203, 203, 1},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_energy_drain, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 25 ), 35, 12,
     "energy drain", "!Energy Drain!", ""},

    {
     "faerie fire",
     {12, 5, 203, 203, 17, 2, 92,
      2, 4, 203, 203, 7, 1, 82,
      1, 3, 203, 203, 2, 1, 72,
      1, 1, 203, 203, 1, 1, 62},
     {1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2},
     spell_faerie_fire, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 72 ), 5, 12,
     "faerie fire", "The pink aura around you fades away.",
     ""},

    {
     "faerie fog",
     {28, 41, 203, 203, 35, 18, 203,
      18, 31, 203, 203, 25, 8, 203,
      10, 21, 203, 203, 25, 4, 203,
      3, 11, 203, 203, 15, 2, 203},
     {1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2},
     spell_faerie_fog, TAR_IGNORE, POS_STANDING,
     NULL, TRUE, SLOT ( 73 ), 12, 12,
     "faerie fog", "!Faerie Fog!", ""},

    {
     "farsight",
     {4, 8, 203, 203, 15, 9, 6,
      3, 7, 203, 203, 5, 8, 5,
      2, 4, 203, 203, 2, 4, 3,
      2, 4, 203, 203, 2, 4, 3},
     {1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1},
     spell_farsight, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, FALSE, SLOT ( 521 ), 5, 12,
     "", "The green in your vision disappears.",
     ""},

    {
     "fireball",
     {54, 89, 203, 203, 203, 44, 81,
      44, 79, 203, 203, 203, 34, 71,
      34, 69, 203, 203, 203, 24, 61,
      24, 59, 203, 203, 203, 14, 51},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_fireball, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 26 ), 15, 12,
     "fireball", "!Fireball!", ""},

    {
     "fireproof",
     {25, 24, 203, 203, 203, 21, 203,
      15, 14, 203, 203, 203, 11, 203,
      10, 10, 203, 203, 203, 6, 203,
      5, 5, 203, 203, 203, 3, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_fireproof, TAR_OBJ_INV, POS_STANDING,
     NULL, TRUE, SLOT ( 523 ), 10, 12,
     "", "", "$p's protective aura fades."},

    {
     "fireshield",
     {60, 55, 203, 203, 203, 75, 203,
      50, 45, 203, 203, 203, 65, 203,
      40, 35, 203, 203, 203, 55, 203,
      30, 25, 203, 203, 203, 45, 203},
     {3, 3, 5, 5, 5, 3, 5,
      3, 3, 5, 5, 5, 3, 5,
      3, 3, 5, 5, 5, 3, 5,
      3, 3, 5, 5, 5, 3, 5},
     spell_fireshield, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, FALSE, SLOT ( 411 ), 75, 12,
     "fireball", "Your firey shield gutters out.",
     ""},
    {
     "firestorm",
     {90, 105, 203, 203, 203, 110, 203,
      80, 95, 203, 203, 203, 100, 203,
      70, 85, 203, 203, 203, 90, 203,
      70, 85, 203, 203, 203, 90, 203},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_fire_storm, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 651 ), 100, 12,
     "{Rf{Yi{Rr{Ye {Rs{Yt{Ro{Yr{Rm", "!FIRESTORM!", ""},

    {
     "flamestrike",
     {34, 40, 203, 203, 203, 30, 47,
      24, 30, 203, 203, 203, 20, 37,
      14, 20, 203, 203, 203, 10, 27,
      4, 20, 203, 203, 203, 5, 17},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_flamestrike, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 65 ), 20, 12,
     "flamestrike", "!Flamestrike!", ""},

    {
     "floating disc",
     {7, 19, 203, 203, 45, 15, 203,
      6, 9, 203, 203, 35, 10, 203,
      1, 4, 203, 203, 25, 2, 203,
      1, 2, 203, 203, 15, 2, 203},
     {1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2,
      1, 1, 2, 2, 1, 1, 2},
     spell_floating_disc, TAR_IGNORE, POS_STANDING,
     NULL, TRUE, SLOT ( 522 ), 40, 24,
     "", "!Floating disc!", ""},

    {
     "fly",
     {19, 36, 203, 203, 31, 66, 33,
      9, 26, 203, 203, 21, 56, 23,
      4, 16, 203, 203, 11, 46, 13,
      2, 10, 203, 203, 6, 36, 7},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_fly, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, FALSE, SLOT ( 56 ), 10, 18,
     "", "You slowly float to the ground.", ""},

    {
     "frenzy",
     {66, 48, 203, 203, 57, 203, 55,
      56, 38, 203, 203, 47, 203, 45,
      46, 28, 203, 203, 37, 203, 35,
      36, 18, 203, 203, 27, 203, 25},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_frenzy, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, FALSE, SLOT ( 504 ), 30, 24,
     "", "Your rage ebbs.", ""},

    {
     "gate",
     {84, 84, 203, 203, 92, 81, 96,
      74, 74, 203, 203, 82, 71, 86,
      64, 64, 203, 203, 72, 61, 76,
      54, 44, 203, 203, 62, 51, 66},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_gate, TAR_IGNORE, POS_FIGHTING,
     NULL, FALSE, SLOT ( 83 ), 80, 12,
     "", "!Gate!", ""},

    {
     "gods armor",
     {203, 190, 203, 203, 203, 203, 203,
      203, 180, 203, 203, 203, 203, 203,
      203, 170, 203, 203, 203, 203, 203,
      203, 160, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_gods_armor, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, FALSE, SLOT ( 195 ), 120, 12,
     "", "You are no longer godly.", ""},
    {
     "giant strength",
     {41, 42, 202, 202, 37, 31, 37,
      31, 32, 202, 202, 27, 21, 27,
      21, 22, 202, 202, 17, 11, 17,
      15, 16, 202, 202, 12, 6, 12},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_giant_strength, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, FALSE, SLOT ( 39 ), 20, 12,
     "", "You feel weaker.", ""},

    {
     "harm",
     {43, 46, 203, 203, 203, 41, 203,
      33, 36, 203, 203, 203, 31, 203,
      23, 26, 203, 203, 203, 21, 203,
      15, 16, 203, 203, 203, 15, 203},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_harm, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 27 ), 35, 12,
     "harm spell", "!Harm!,		" ""},

    {
     "haste",
     {52, 54, 203, 203, 60, 26, 52,
      42, 44, 203, 203, 50, 16, 42,
      32, 34, 203, 203, 40, 6, 32,
      22, 24, 203, 203, 20, 5, 22},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_haste, TAR_CHAR_DEFENSIVE, POS_FIGHTING,
     NULL, FALSE, SLOT ( 502 ), 30, 12,
     "", "You feel yourself slow down.", ""},

    {
     "heal",
     {203, 62, 203, 203, 85, 95, 203,
      203, 52, 203, 203, 75, 85, 203,
      203, 42, 203, 203, 65, 75, 203,
      203, 32, 203, 203, 55, 65, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_heal, TAR_CHAR_DEFENSIVE, POS_FIGHTING,
     NULL, FALSE, SLOT ( 28 ), 50, 12,
     "", "!Heal!", ""},

    {
     "heat metal",
     {73, 42, 203, 203, 203, 22, 203,
      63, 32, 203, 203, 203, 12, 203,
      53, 22, 203, 203, 203, 6, 203,
      43, 12, 203, 203, 203, 6, 203},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_heat_metal, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 516 ), 25, 18,
     "spell", "!Heat Metal!", ""},

    {
     "holy word",
     {203, 71, 203, 203, 203, 77, 203,
      203, 61, 203, 203, 203, 67, 203,
      203, 51, 203, 203, 203, 57, 203,
      203, 41, 203, 203, 203, 47, 203},
     {2, 2, 4, 4, 4, 2, 4,
      2, 2, 4, 4, 4, 2, 4,
      2, 2, 4, 4, 4, 2, 4,
      2, 2, 4, 4, 4, 2, 4},
     spell_holy_word, TAR_IGNORE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 506 ), 200, 24,
     "divine wrath", "!Holy Word!", ""},

    {
     "iceshield",
     {45, 40, 203, 203, 203, 55, 203,
      35, 30, 203, 203, 203, 45, 203,
      25, 20, 203, 203, 203, 35, 203,
      15, 10, 203, 203, 203, 15, 203},
     {3, 3, 5, 5, 5, 3, 5,
      3, 3, 5, 5, 5, 3, 5,
      3, 3, 5, 5, 5, 3, 5,
      3, 3, 5, 5, 5, 3, 5},
     spell_iceshield, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 410 ), 75, 12,
     "chilling touch", "Your icy shield slowly melts away.",
     ""},

    {
     "identify",
     {30, 32, 35, 203, 46, 42, 28,
      20, 22, 25, 203, 36, 32, 18,
      10, 12, 15, 203, 26, 22, 10,
      5, 6, 8, 203, 16, 12, 6},
     {1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1},
     spell_identify, TAR_OBJ_INV, POS_STANDING,
     NULL, TRUE, SLOT ( 53 ), 12, 24,
     "", "!Identify!", ""},

    {
     "immolation",
     {203, 195, 203, 203, 203, 203, 203,
      203, 185, 203, 203, 203, 203, 203,
      203, 175, 203, 203, 203, 203, 203,
      203, 165, 203, 203, 203, 203, 203},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_immolation, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 666 ), 350, 30,
     "", "The {Rf{ri{Rr{re{Rs{x that surround you slowly fade", ""},

    {
     "infravision",
     {20, 26, 203, 203, 203, 18, 12,
      10, 16, 203, 203, 203, 8, 2,
      5, 8, 203, 203, 203, 5, 1,
      3, 4, 203, 203, 203, 3, 1},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_infravision, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, FALSE, SLOT ( 77 ), 5, 18,
     "", "You no longer see in the dark.", ""},
    {
     "invigorate",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 202, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_invigorate, TAR_OBJ_CHAR_DEF, POS_STANDING,
     NULL, FALSE, SLOT ( 393 ), 1200, 12,
     "", "You feel less invigorated!",
     "$p's is less invigorated."},

    {
     "invisibility",
     {9, 37, 17, 203, 12, 39, 13,
      8, 27, 7, 203, 2, 29, 3,
      7, 27, 7, 203, 2, 29, 3,
      4, 17, 4, 203, 1, 19, 2},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_invis, TAR_OBJ_CHAR_DEF, POS_STANDING,
     &gsn_invis, FALSE, SLOT ( 29 ), 5, 12,
     "", "You are no longer invisible.",
     "$p fades into view."},

    {
     "know alignment",
     {24, 17, 203, 203, 36, 27, 33,
      14, 7, 203, 203, 26, 17, 23,
      10, 4, 203, 203, 26, 9, 13,
      5, 2, 203, 203, 16, 4, 7},
     {1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1},
     spell_know_alignment, TAR_CHAR_DEFENSIVE, POS_FIGHTING,
     NULL, FALSE, SLOT ( 58 ), 9, 12,
     "", "!Know Alignment!", ""},

    {
     "lightning bolt",
     {35, 46, 203, 203, 40, 42, 91,
      25, 36, 203, 203, 30, 32, 81,
      15, 26, 203, 203, 20, 22, 71,
      7, 16, 203, 203, 20, 12, 61},
     {1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1},
     spell_lightning_bolt, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 30 ), 15, 12,
     "lightning bolt", "!Lightning Bolt!", ""},

    {
     "locate object",
     {37, 30, 203, 203, 38, 35, 24,
      27, 20, 203, 203, 28, 25, 14,
      17, 10, 203, 203, 18, 15, 4,
      7, 5, 203, 203, 8, 7, 2},
     {1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1},
     spell_locate_object, TAR_IGNORE, POS_STANDING,
     NULL, TRUE, SLOT ( 31 ), 20, 18,
     "", "!Locate Object!", ""},

    {
     "magic missile",
     {10, 203, 203, 203, 203, 12, 203,
      5, 203, 203, 203, 203, 2, 203,
      1, 203, 203, 203, 203, 1, 203,
      1, 203, 203, 203, 203, 1, 203},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_magic_missile, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 32 ), 15, 12,
     "magic missile", "!Magic Missile!", ""},
    {
     "mana shield",
     {190, 180, 203, 203, 203, 203, 203,
      185, 175, 203, 203, 203, 203, 203,
      175, 165, 203, 203, 203, 203, 203,
      165, 155, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 1, 1,
      2, 2, 2, 2, 2, 1, 1,
      2, 2, 2, 2, 2, 1, 1,
      2, 2, 2, 2, 2, 1, 1},
     spell_mana_shield, TAR_CHAR_SELF, POS_STANDING,
     NULL, TRUE, SLOT ( 32 ), 15, 12,
     "mana shield", "Your {Bm{bana{x shield fades away!", ""},

    {
     "ward",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      202, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 1, 1,
      2, 2, 2, 2, 2, 1, 1,
      2, 2, 2, 2, 2, 1, 1,
      5, 2, 2, 2, 2, 1, 1},
     spell_ward, TAR_IGNORE, POS_STANDING,
     NULL, TRUE, SLOT ( 32 ), 15, 12,
     "ward", "You are no longer warded!", ""},

    {
     "mass healing",
     {203, 75, 203, 203, 85, 85, 203,
      203, 65, 203, 203, 75, 75, 203,
      203, 55, 203, 203, 65, 65, 203,
      203, 45, 203, 203, 55, 55, 203},
     {2, 2, 4, 4, 2, 2, 2,
      2, 2, 4, 4, 2, 2, 2,
      2, 2, 4, 4, 2, 2, 2,
      2, 2, 4, 4, 2, 2, 2},
     spell_mass_healing, TAR_IGNORE, POS_STANDING,
     NULL, FALSE, SLOT ( 508 ), 100, 36,
     "", "!Mass Healing!", ""},

    {
     "mass invis",
     {53, 49, 203, 203, 55, 203, 54,
      43, 39, 203, 203, 45, 203, 44,
      33, 29, 203, 203, 35, 203, 34,
      23, 19, 203, 203, 25, 203, 24},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_mass_invis, TAR_IGNORE, POS_STANDING,
     &gsn_mass_invis, FALSE, SLOT ( 69 ), 20, 24,
     "", "You are no longer invisible.", ""},
    {
     "master healing",
     {203, 150, 203, 203, 203, 203, 203,
      203, 140, 203, 203, 203, 203, 203,
      203, 140, 203, 203, 203, 203, 203,
      203, 130, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_master_healing, TAR_CHAR_DEFENSIVE, POS_FIGHTING,
     NULL, FALSE, SLOT ( 208 ), 50, 12,
     "", "!Master Healing!", ""},
    {
     "meteor storm",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      202, 203, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_meteor_storm, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 204 ), 200, 12,
     "{Dm{re{Rte{ro{Dr{W storm{x", "!Armageddon!", ""},
    {
     "nexus",
     {140, 140, 203, 203, 140, 203, 140,
      130, 130, 203, 203, 130, 203, 130,
      120, 120, 203, 203, 120, 203, 120,
      110, 110, 203, 203, 110, 203, 110},
     {2, 2, 4, 4, 4, 2, 4,
      2, 2, 4, 4, 4, 2, 4,
      2, 2, 4, 4, 4, 2, 4,
      2, 2, 4, 4, 4, 2, 4},
     spell_nexus, TAR_IGNORE, POS_STANDING,
     NULL, FALSE, SLOT ( 520 ), 150, 36,
     "", "!Nexus!", ""},

    {
     "pass door",
     {68, 63, 49, 203, 60, 203, 42,
      58, 53, 39, 203, 50, 203, 32,
      48, 43, 29, 203, 40, 203, 22,
      38, 33, 19, 203, 30, 203, 12},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_pass_door, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 74 ), 20, 12,
     "", "You feel solid again.", ""},

    {
     "plague",
     {56, 34, 203, 203, 59, 39, 65,
      46, 24, 203, 203, 49, 29, 55,
      36, 14, 203, 203, 39, 19, 45,
      26, 4, 203, 203, 29, 9, 35},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_plague, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     &gsn_plague, TRUE, SLOT ( 503 ), 20, 12,
     "sickness", "Your sores vanish.", ""},

    {
     "poison",
     {33, 24, 203, 203, 49, 27, 22,
      23, 14, 203, 203, 39, 17, 12,
      15, 4, 203, 203, 39, 9, 6,
      7, 3, 203, 203, 29, 5, 3},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_poison, TAR_OBJ_CHAR_OFF, POS_FIGHTING,
     &gsn_poison, TRUE, SLOT ( 33 ), 10, 12,
     "poison", "You feel less sick.",
     "The poison on $p dries up."},

    {
     "portal",
     {130, 130, 203, 203, 130, 203, 130,
      120, 120, 203, 203, 120, 203, 120,
      110, 110, 203, 203, 110, 203, 110,
      100, 100, 203, 203, 100, 203, 100},
     {2, 2, 4, 4, 4, 2, 4,
      2, 2, 4, 4, 4, 2, 4,
      2, 2, 4, 4, 4, 2, 4,
      2, 2, 4, 4, 4, 2, 4},
     spell_portal, TAR_IGNORE, POS_STANDING,
     NULL, FALSE, SLOT ( 519 ), 100, 24,
     "", "!Portal!", ""},

    {
     "protection evil",
     {54, 18, 203, 203, 64, 19, 66,
      44, 8, 203, 203, 54, 9, 56,
      34, 4, 203, 203, 44, 2, 46,
      24, 4, 203, 203, 34, 2, 36},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_protection_evil, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 34 ), 5, 12,
     "", "You feel less protected.", ""},

    {
     "protection good",
     {54, 18, 203, 203, 64, 19, 66,
      44, 8, 203, 203, 54, 9, 56,
      34, 4, 203, 203, 44, 5, 46,
      24, 4, 203, 203, 34, 5, 36},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_protection_good, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 514 ), 5, 12,
     "", "You feel less protected.", ""},

    {
     "protection voodoo",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 202, 203, 203, 203, 203, 203},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_protection_voodoo, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 345 ), 5, 12,
     "", "", ""},

    {
     "quest pill",
     {210, 210, 210, 210, 210, 210, 210,
      210, 210, 210, 210, 210, 210, 210,
      210, 210, 210, 210, 210, 210, 210,
      210, 210, 210, 210, 210, 210, 210},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_quest_pill, TAR_CHAR_SELF, POS_STANDING,
     NULL, TRUE, SLOT ( 530 ), 5, 18,
     "", "!Quest Pill!", ""},

    {
     "ray of truth",
     {203, 69, 203, 203, 203, 96, 203,
      203, 59, 203, 203, 203, 86, 203,
      203, 49, 203, 203, 203, 76, 203,
      203, 39, 203, 203, 203, 66, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_ray_of_truth, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 518 ), 20, 12,
     "ray of truth", "!Ray of Truth!", ""},

    {
     "recharge",
     {28, 63, 203, 203, 203, 52, 203,
      18, 53, 203, 203, 203, 42, 203,
      8, 43, 203, 203, 203, 32, 203,
      4, 33, 203, 203, 203, 22, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_recharge, TAR_OBJ_INV, POS_STANDING,
     NULL, TRUE, SLOT ( 517 ), 60, 24,
     "", "!Recharge!", ""},

    {
     "refresh",
     {26, 9, 203, 203, 18, 10, 16,
      16, 4, 203, 203, 8, 1, 6,
      6, 4, 203, 203, 6, 1, 6,
      3, 2, 203, 203, 3, 1, 3},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_refresh, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, FALSE, SLOT ( 81 ), 12, 18,
     "refresh", "!Refresh!", ""},

    {
     "remove curse",
     {103, 35, 203, 203, 93, 49, 203,
      93, 25, 203, 203, 83, 39, 203,
      83, 15, 203, 203, 73, 29, 203,
      73, 7, 203, 203, 63, 19, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_remove_curse, TAR_OBJ_CHAR_DEF, POS_STANDING,
     NULL, FALSE, SLOT ( 35 ), 5, 12,
     "", "!Remove Curse!", ""},

    {
     "restore mana",
     {195, 190, 203, 203, 203, 203, 203,
      185, 180, 203, 203, 203, 203, 203,
      175, 170, 203, 203, 203, 203, 203,
      165, 160, 203, 203, 203, 203, 203},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_restore_mana, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, FALSE, SLOT ( 251 ), 1, 18,
     "restore mana", "!Restore Mana!", ""},

    {
     "resurrect",
     {203, 203, 203, 203, 203, 203, 28,
      203, 203, 203, 203, 203, 203, 18,
      203, 203, 203, 203, 203, 203, 9,
      203, 203, 203, 203, 203, 203, 5},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_resurrect, TAR_IGNORE, POS_STANDING,
     NULL, TRUE, SLOT ( 235 ), 35, 12,
     "", "!Resurrect!", ""},

    {
     "sanctuary",
     {142, 39, 203, 203, 198, 150, 203,
      132, 29, 203, 203, 188, 140, 203,
      122, 19, 203, 203, 178, 130, 203,
      112, 9, 203, 203, 168, 120, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_sanctuary, TAR_CHAR_DEFENSIVE, POS_STANDING,
     &gsn_sanctuary, FALSE, SLOT ( 36 ), 75, 12,
     "", "The white aura around your body fades.",
     ""},

    {
     "shield",
     {80, 70, 203, 203, 88, 80, 203,
      70, 60, 203, 203, 78, 70, 203,
      60, 50, 203, 203, 68, 60, 203,
      50, 40, 203, 203, 58, 50, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_shield, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, FALSE, SLOT ( 67 ), 12, 18,
     "", "Your force shield shimmers then fades away.",
     ""},

    {
     "shocking grasp",
     {30, 203, 203, 203, 203, 30, 27,
      20, 203, 203, 203, 203, 20, 17,
      10, 203, 203, 203, 203, 15, 9,
      5, 203, 203, 203, 203, 7, 5},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_shocking_grasp, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 53 ), 15, 12,
     "shocking grasp", "!Shocking Grasp!", ""},

    {
     "shockshield",
     {80, 50, 203, 203, 203, 90, 203,
      70, 40, 203, 203, 203, 80, 203,
      60, 30, 203, 203, 203, 70, 203,
      50, 20, 203, 203, 203, 60, 203},
     {3, 3, 5, 5, 5, 3, 5,
      3, 3, 5, 5, 5, 3, 5,
      3, 3, 5, 5, 5, 3, 5,
      3, 3, 5, 5, 5, 3, 5},
     spell_shockshield, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 412 ), 75, 12,
     "lightning bolt", "Your crackling shield sizzles and fades.",
     ""},

    {
     "acidshield",
     {100, 90, 203, 203, 203, 101, 203,
      90, 80, 203, 203, 203, 91, 203,
      80, 70, 203, 203, 203, 81, 203,
      70, 60, 203, 203, 203, 71, 203},
     {2, 1, 5, 5, 5, 3, 5,
      2, 1, 5, 5, 5, 3, 5,
      2, 1, 5, 5, 5, 3, 5,
      2, 1, 5, 5, 5, 3, 5},
     spell_acidshield, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 536 ), 75, 12,
     "acidic blast", "Your acidic shield fades away.",
     ""},

    {
     "poisonshield",
     {35, 15, 203, 203, 203, 25, 203,
      25, 10, 203, 203, 203, 20, 203,
      15, 5, 203, 203, 203, 10, 203,
      7, 3, 203, 203, 203, 5, 203},
     {2, 1, 5, 5, 5, 3, 5,
      2, 1, 5, 5, 5, 3, 5,
      2, 1, 5, 5, 5, 3, 5,
      2, 1, 5, 5, 5, 3, 5},
     spell_poisonshield, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 882 ), 75, 12,
     "poisonous shield", "Your poisonous shield clears up.",
     ""},
    {
     "briarshield",
     {203, 203, 203, 203, 55, 55, 203,
      203, 203, 203, 203, 45, 45, 203,
      203, 203, 203, 203, 35, 35, 203,
      203, 203, 203, 203, 25, 25, 203},
     {2, 1, 5, 5, 5, 3, 5,
      2, 1, 5, 5, 5, 3, 5,
      2, 1, 5, 5, 5, 3, 5,
      2, 1, 5, 5, 5, 3, 5},
     spell_briarshield, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 492 ), 75, 12,
     "{gt{yh{go{yr{gn{yy {xprick", "Your thorny shield fades away.",
     ""},

    {
     "sleep",
     {40, 203, 203, 203, 21, 203, 35,
      30, 203, 203, 203, 11, 203, 25,
      20, 203, 203, 203, 6, 203, 15,
      10, 203, 203, 203, 3, 203, 8},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_sleep, TAR_CHAR_OFFENSIVE, POS_STANDING,
     &gsn_sleep, TRUE, SLOT ( 38 ), 15, 12,
     "", "You feel less tired.", ""},

    {
     "slow",
     {55, 40, 203, 203, 60, 66, 51,
      45, 30, 203, 203, 50, 56, 41,
      35, 20, 203, 203, 40, 46, 31,
      25, 10, 203, 203, 30, 36, 21},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_slow, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 515 ), 30, 12,
     "", "You feel yourself speed up.", ""},

    {
     "stone skin",
     {99, 70, 203, 203, 100, 90, 203,
      89, 60, 203, 203, 90, 80, 203,
      79, 50, 203, 203, 80, 70, 203,
      69, 40, 203, 203, 70, 60, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_stone_skin, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 66 ), 12, 18,
     "", "Your skin feels soft again.", ""},

    {
     "summon",
     {88, 90, 203, 203, 95, 203, 85,
      78, 80, 203, 203, 85, 203, 75,
      68, 70, 203, 203, 75, 203, 65,
      58, 60, 203, 203, 65, 203, 55},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_summon, TAR_IGNORE, POS_STANDING,
     NULL, FALSE, SLOT ( 40 ), 50, 12,
     "", "!Summon!", ""},

    {
     "summon familiar",
     {203, 203, 203, 203, 203, 203, 40,
      203, 203, 203, 203, 203, 203, 30,
      203, 203, 203, 203, 203, 203, 20,
      203, 203, 203, 203, 203, 203, 10},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_summon_familiar, TAR_IGNORE, POS_STANDING,
     NULL, TRUE, SLOT ( 956 ), 100, 12,
     "", "!Summon Familiar!", ""},

    {
     "superior healing",
     {203, 125, 203, 203, 203, 203, 203,
      203, 115, 203, 203, 203, 203, 203,
      203, 105, 203, 203, 203, 203, 203,
      203, 95, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_superior_healing, TAR_CHAR_DEFENSIVE, POS_FIGHTING,
     NULL, FALSE, SLOT ( 298 ), 50, 12,
     "", "!Superior Healing!", ""},

    {
     "teleport",
     {44, 44, 203, 203, 59, 203, 59,
      34, 34, 203, 203, 49, 203, 49,
      24, 24, 203, 203, 39, 203, 39,
      14, 14, 203, 203, 29, 203, 29},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_teleport, TAR_CHAR_SELF, POS_FIGHTING,
     NULL, TRUE, SLOT ( 2 ), 35, 12,
     "", "!Teleport!", ""},

    {
     "transport",
     {45, 46, 203, 203, 45, 53, 51,
      35, 36, 203, 203, 35, 43, 41,
      25, 26, 203, 203, 25, 33, 31,
      15, 16, 203, 203, 15, 23, 21},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_transport, TAR_OBJ_TRAN, POS_STANDING,
     NULL, FALSE, SLOT ( 524 ), 30, 12,
     "", "!Transport!", ""},

    {
     "ventriloquate",
     {1, 203, 2, 203, 5, 203, 4,
      1, 203, 1, 203, 1, 203, 3,
      1, 203, 1, 203, 1, 203, 3,
      1, 203, 1, 203, 1, 203, 3},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 1, 1, 1},
     spell_ventriloquate, TAR_IGNORE, POS_STANDING,
     NULL, TRUE, SLOT ( 41 ), 5, 12,
     "", "!Ventriloquate!", ""},

    {
     "voodoo",
     {203, 80, 203, 203, 203, 203, 65,
      203, 70, 203, 203, 203, 203, 55,
      203, 60, 203, 203, 203, 203, 45,
      203, 50, 203, 203, 203, 203, 35},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_voodoo, TAR_IGNORE, POS_STANDING,
     NULL, TRUE, SLOT ( 286 ), 80, 12,
     "", "!Voodoo!", ""},

    {
     "weaken",
     {31, 28, 203, 203, 40, 31, 25,
      21, 18, 203, 203, 30, 21, 15,
      11, 12, 203, 203, 20, 14, 8,
      6, 6, 203, 203, 10, 7, 4},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_weaken, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 68 ), 20, 12,
     "spell", "You feel stronger.", ""},

    {
     "word of recall",
     {63, 56, 203, 203, 47, 203, 73,
      53, 46, 203, 203, 37, 203, 63,
      43, 36, 203, 203, 27, 203, 53,
      33, 26, 203, 203, 17, 203, 43},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_word_of_recall, TAR_CHAR_SELF, POS_RESTING,
     NULL, TRUE, SLOT ( 42 ), 5, 12,
     "", "!Word of Recall!", ""},
    {
     "vampire blast",
     {203, 203, 203, 203, 203, 203, 70,
      203, 203, 203, 203, 203, 203, 60,
      203, 203, 203, 203, 203, 203, 50,
      203, 203, 203, 203, 203, 203, 40},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_vampire_blast, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 711 ), 200, 12,
     "{Dv{ba{Dm{bp{Di{br{De {Gb{glast{x", "!Vampire Blast!", ""},

    {
     "vampiric laceration",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_vampiric_laceration, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, TRUE, SLOT ( 859 ), 400, 20,
     "", "Your evil rage ebbs.", ""},

/*
 * Dragon breath
 */
    {
     "acid breath",
     {102, 203, 203, 203, 203, 203, 203,
      92, 203, 203, 203, 203, 203, 203,
      82, 203, 203, 203, 203, 203, 203,
      72, 203, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_acid_breath, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 200 ), 100, 24,
     "blast of acid", "!Acid Breath!", ""},

    {
     "fire breath",
     {120, 203, 203, 203, 203, 203, 203,
      110, 203, 203, 203, 203, 203, 203,
      100, 203, 203, 203, 203, 203, 203,
      90, 203, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_fire_breath, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 201 ), 200, 24,
     "blast of flame", "The smoke leaves your eyes.", ""},

    {
     "frost breath",
     {87, 203, 203, 203, 203, 203, 203,
      67, 203, 203, 203, 203, 203, 203,
      57, 203, 203, 203, 203, 203, 203,
      47, 203, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_frost_breath, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 469 ), 125, 24,
     "blast of frost", "!Frost Breath!", ""},

    {
     "gas breath",
     {107, 203, 203, 203, 203, 203, 203,
      97, 203, 203, 203, 203, 203, 203,
      87, 203, 203, 203, 203, 203, 203,
      77, 203, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_gas_breath, TAR_IGNORE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 605 ), 175, 24,
     "blast of gas", "!Gas Breath!", ""},

    {
     "lightning breath",
     {130, 203, 203, 203, 203, 203, 203,
      120, 203, 203, 203, 203, 203, 203,
      110, 203, 203, 203, 203, 203, 203,
      100, 203, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_lightning_breath, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 204 ), 150, 24,
     "blast of lightning", "!Lightning Breath!", ""},

/*
New Spells in magic3.c most by Taka of Ghost Dancer Mud
*/
    {
     "screen",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_screen, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, TRUE, SLOT ( 66 ), 12, 18,
     "", "You are nolonger cloaked in a protective screen.", ""},

    {
     "stone meld",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_stone_meld, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, TRUE, SLOT ( 66 ), 12, 18,
     "", "Your skin is nolonger stone.", ""},

    {
     "acid storm",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_acidstorm, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 70 ), 60, 12,
     "acid storm", "!Acid Storm!"},

    {
     "ice rain",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_icerain, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 70 ), 125, 12,
     "ice rain", "!Ice Rain!"},

    {
     "ice storm",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_icestorm, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 70 ), 60, 12,
     "ice storm", "!Ice Storm!"},

    {
     "fire rain",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_firerain, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 70 ), 125, 12,
     "fire rain", "!Fire Rain!"},

    {
     "mud skin",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_mud_skin, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, TRUE, SLOT ( 66 ), 5, 18,
     "", "Your skin feels clean again.", ""},

    {
     "moss skin",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_moss_skin, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, TRUE, SLOT ( 66 ), 12, 18,
     "", "Your skin feels dry again.", ""},

    {
     "bark skin",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_bark_skin, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, TRUE, SLOT ( 66 ), 12, 18,
     "", "Your skin feels soft again.", ""},

    {
     "steel skin",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_steel_skin, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, TRUE, SLOT ( 66 ), 12, 18,
     "", "Your skin feels soft again.", ""},

    {
     "emerald skin",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_emerald_skin, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, TRUE, SLOT ( 66 ), 12, 18,
     "", "Your skin loses it's green glow.", ""},

    {
     "ruby skin",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_ruby_skin, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, TRUE, SLOT ( 66 ), 12, 18,
     "", "Your skin loses it's red glow.", ""},

    {
     "diamond skin",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_diamond_skin, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, TRUE, SLOT ( 66 ), 12, 18,
     "", "Your skin loses it's brilliance.", ""},

    {
     "mystic armor",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_mystic_armor, TAR_CHAR_DEFENSIVE, POS_STANDING,
     NULL, TRUE, SLOT ( 0 ), 10, 6,
     "mystic armor", "The mystical armor protecting you fades away!", ""},

    {
     "ice bolt",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_ice_bolt, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 0 ), 35, 12,
     "ice bolt", "!ice_bolt!", ""},

    {
     "fre bolt",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_fire_bolt, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 0 ), 35, 12,
     "fire bolt", "!fire_bolt!", ""},

    {
     "acid bolt",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_acid_bolt, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 0 ), 35, 12,
     "acid bolt", "!acid_bolt!", ""},

    {
     "gas bolt",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_gas_bolt, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 0 ), 35, 12,
     "gas bolt", "!gas_bolt!", ""},

    {
     "fireblast",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_fireblast, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 0 ), 35, 12,
     "fire blast", "!fireblast!", ""},

    {
     "iceblast",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_iceblast, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 0 ), 35, 12,
     "ice blast", "!iceblast!", ""},

    {
     "gasblast",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_gasblast, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 0 ), 35, 12,
     "gas blast", "!gasblast!", ""},

    {
     "electricblast",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_electricblast, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 0 ), 35, 12,
     "electric blast", "!electricblast!", ""},

    {
     "lightningblast",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_lightningblast, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 0 ), 35, 12,
     "lightning blast", "!lightningblast!", ""},

/*
 * Spells for mega1.are from Glop/Erkenbrand.
 */
    {
     "general purpose",
     {204, 204, 204, 204, 204, 204, 204,
      204, 204, 204, 204, 204, 204, 204,
      204, 204, 204, 204, 204, 204, 204,
      204, 204, 204, 204, 204, 204, 204},
     {0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0},
     spell_general_purpose, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 401 ), 0, 12,
     "general purpose ammo", "!General Purpose Ammo!", ""},

    {
     "high explosive",
     {204, 204, 204, 204, 204, 204, 204,
      204, 204, 204, 204, 204, 204, 204,
      204, 204, 204, 204, 204, 204, 204,
      204, 204, 204, 204, 204, 204, 204},
     {0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0},
     spell_high_explosive, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 402 ), 0, 12,
     "high explosive ammo", "!High Explosive Ammo!", ""},

/*Mangans Spells/skills*/
    {
     "banish",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_banish, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 702 ), 20, 12,
     "banish", "You have been forgiven.",
     "$p is no longer banished."},

    {
     "blood blast",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_blood_blast, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 713 ), 25, 12,
     "{Rb{rl{Ro{ro{Rd {Bb{yl{Ba{ys{Bt", "!Blood Blast!", ""},

    {
     "earthrise",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 202, 203, 203},
     {1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1,
      1, 1, 2, 2, 1, 1, 1},
     spell_earthrise, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 710 ), 500, 12,
     "{ge{ba{gr{Bt{gh {Dr{ri{Ds{re", "!Earthrise!", ""},

    {
     "immortal wrath",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     spell_immortal_wrath, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     NULL, TRUE, SLOT ( 710 ), 500, 12,
     "{BImm{Wor{Btal {DW{RR{WA{RT{DH", "!Immortal Wrath!", ""},

    {
     "powersurge",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      202, 203, 203, 203, 203, 203, 203},
     {1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2,
      1, 1, 2, 2, 2, 1, 2},
     spell_powersurge, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 717 ), 1200, 12,
     "", "Your strength returns to normal.",
     "$n's strength returns to normal."},

    {
     "shadow barrier",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {1, 1, 2, 1, 1, 1, 1,
      1, 1, 2, 1, 1, 1, 1,
      1, 1, 2, 1, 1, 1, 1,
      1, 1, 1, 2, 1, 1, 1},
     spell_shadow_barrier, TAR_CHAR_SELF, POS_STANDING,
     NULL, FALSE, SLOT ( 714 ), 100, 18,
     "", "The shadows surrounding vanish as the light returns.", ""},

    {
     "mistblend",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 202,},
     {1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1,
      1, 1, 2, 2, 2, 1, 1},
     spell_mistblend, TAR_CHAR_SELF, POS_STANDING,
     &gsn_mistblend, FALSE, SLOT ( 715 ), 5, 12,
     "", "The mist no longer hides you.",
     "$p emerges from the mist."},
/********************************/

/* combat and weapons skills */

    {
     "axe",
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     {6, 6, 5, 3, 4, 6, 5,
      6, 6, 5, 3, 4, 6, 5,
      6, 6, 6, 3, 4, 6, 5,
      6, 6, 6, 3, 4, 6, 5},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_axe, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Axe!", ""},

    {
     "dagger",
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     {2, 3, 2, 1, 2, 3, 1,
      2, 2, 1, 1, 1, 2, 1,
      2, 2, 1, 1, 1, 2, 1,
      2, 3, 2, 1, 2, 3, 1,},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_dagger, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Dagger!", ""},

    {
     "flail",
     {1, 2, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     {6, 3, 6, 3, 4, 3, 5,
      6, 3, 6, 3, 4, 3, 5,
      6, 3, 6, 3, 4, 3, 5,
      5, 2, 5, 2, 3, 2, 4},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_flail, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Flail!", ""},

    {
     "mace",
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     {5, 1, 3, 2, 3, 2, 3,
      5, 1, 3, 2, 3, 2, 3,
      5, 1, 3, 2, 3, 2, 3,
      4, 1, 3, 1, 2, 1, 2},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_mace, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Mace!", ""},

    {
     "polearm",
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     {6, 6, 6, 3, 3, 2, 5,
      6, 6, 6, 3, 3, 2, 5,
      6, 6, 6, 3, 3, 2, 5,
      5, 5, 5, 2, 2, 1, 4},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_polearm, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Polearm!", ""},

    {
     "shield block",
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     {6, 4, 6, 1, 2, 4, 3,
      6, 4, 6, 1, 2, 4, 3,
      6, 4, 6, 1, 2, 4, 3,
      5, 3, 5, 1, 1, 3, 2},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_shield_block, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Shield!", ""},

    {
     "shield levitation",
     {60, 55, 203, 203, 203, 90, 203,
      50, 45, 203, 203, 203, 85, 203,
      40, 35, 203, 203, 203, 80, 203,
      30, 25, 203, 203, 203, 75, 203},
     {4, 4, -1, -1, -1, 5, -1,
      4, 4, -1, -1, -1, 5, -1,
      3, 3, -1, -1, -1, 4, -1,
      3, 3, -1, -1, -1, 4, -1},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_shield_levitation, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Shield Levitation!", ""},

    {
     "spear",
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     {4, 4, 4, 2, 1, 3, 5,
      4, 4, 4, 2, 1, 3, 5,
      4, 4, 4, 2, 1, 3, 5,
      3, 3, 3, 1, 1, 2, 4},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_spear, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Spear!", ""},

    {
     "sword",
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     {5, 6, 3, 1, 2, 4, 3,
      5, 6, 3, 1, 2, 4, 3,
      5, 6, 3, 1, 2, 4, 3,
      4, 5, 2, 1, 1, 3, 2},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_sword, TRUE, SLOT ( 0 ), 0, 0,
     "", "!sword!", ""},

    {
     "whip",
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     {6, 5, 5, 3, 3, 4, 5,
      6, 5, 5, 3, 3, 4, 5,
      6, 5, 5, 3, 3, 4, 5,
      5, 4, 4, 3, 2, 3, 4},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_whip, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Whip!", ""},

    {
     "assassinate",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 202, 203, 203, 203, 203},
     {0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0,
      0, 0, 12, 0, 0, 0, 0},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_assassinate, TRUE, SLOT ( 0 ), 0, 10,
     "assassinate", "!Assassinate!", ""},

    {
     "backstab",
     {203, 203, 15, 25, 203, 203, 40,
      203, 203, 12, 20, 203, 203, 35,
      203, 203, 9, 15, 203, 203, 30,
      203, 203, 6, 10, 203, 203, 25},
     {0, 0, 8, 10, 0, 0, 12,
      0, 0, 8, 10, 0, 0, 12,
      0, 0, 8, 10, 0, 0, 12,
      0, 0, 7, 9, 0, 0, 11},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_backstab, TRUE, SLOT ( 0 ), 0, 24,
     "{gB{Da{gc{Dk{gs{Dt{ga{Db{x", "!Backstab!", ""},

    {
     "blackjack",
     {203, 203, 90, 203, 203, 203, 203,
      203, 203, 80, 203, 203, 203, 203,
      203, 203, 70, 203, 203, 203, 203,
      203, 203, 60, 203, 203, 203, 203},
     {-1, -1, 3, -1, -1, -1, -1,
      -1, -1, 3, -1, -1, -1, -1,
      -1, -1, 3, -1, -1, -1, -1,
      -1, -1, 2, -1, -1, -1, -1},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_blackjack, TRUE, SLOT ( 0 ), 0, 24,
     "{bblackjack{x", "!Backstab!", ""},

    {
     "bash",
     {203, 203, 203, 40, 203, 203, 203,
      203, 203, 203, 30, 203, 203, 203,
      203, 203, 203, 20, 203, 203, 203,
      203, 203, 203, 10, 203, 203, 203},
     {0, 0, 0, 2, 0, 0, 0,
      0, 0, 0, 2, 0, 0, 0,
      0, 0, 0, 2, 0, 0, 0,
      0, 0, 0, 1, 0, 0, 0},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_bash, TRUE, SLOT ( 0 ), 0, 24,
     "bash", "!Bash!", ""},

    {
     "berserk",
     {203, 203, 203, 27, 203, 203, 203,
      203, 203, 203, 17, 203, 203, 203,
      203, 203, 203, 7, 203, 203, 203,
      203, 203, 203, 4, 203, 203, 203},
     {0, 0, 0, 2, 0, 0, 0,
      0, 0, 0, 2, 0, 0, 0,
      0, 0, 0, 2, 0, 0, 0,
      0, 0, 0, 1, 0, 0, 0},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_berserk, TRUE, SLOT ( 0 ), 0, 24,
     "", "You feel your pulse slow down.", ""},

    {
     "circle",
     {203, 203, 65, 165, 203, 203, 203,
      203, 203, 55, 155, 203, 203, 203,
      203, 203, 45, 145, 203, 203, 203,
      203, 203, 35, 135, 203, 203, 203},
     {0, 0, 4, 0, 0, 0, 0,
      0, 0, 4, 0, 0, 0, 0,
      0, 0, 4, 0, 0, 0, 0,
      0, 0, 3, 0, 0, 0, 0},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_circle, TRUE, SLOT ( 0 ), 0, 24,
     "{Ycircle{x", "!Circle!", ""},

    {
     "counter",
     {203, 203, 140, 135, 203, 203, 160,
      203, 203, 130, 125, 203, 203, 150,
      203, 203, 120, 115, 203, 203, 140,
      203, 203, 110, 105, 203, 203, 130},
     {0, 0, 6, 8, 8, 0, 6,
      0, 0, 6, 8, 8, 0, 6,
      0, 0, 6, 8, 8, 0, 6,
      0, 0, 6, 8, 8, 0, 6},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_counter, TRUE, SLOT ( 0 ), 0, 0,
     "{Rc{yo{Ru{yn{Rt{ye{Rr{Ya{rt{Yt{ra{Yc{rk{x", "!COUNTER!", ""},

    {
     "critical strike",
     {203, 203, 160, 155, 203, 203, 203,
      203, 203, 150, 145, 203, 203, 203,
      203, 203, 140, 135, 203, 203, 203,
      203, 203, 130, 125, 203, 203, 203},
     {0, 0, 6, 8, 0, 0, 0,
      0, 0, 6, 8, 0, 0, 0,
      0, 0, 6, 8, 0, 0, 0,
      0, 0, 6, 8, 0, 0, 0},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_critical, TRUE, SLOT ( 0 ), 0, 0,
     "{RC{Yr{Ri{Yt{Ri{Yc{Ra{Yl {RS{Yt{Rr{Yi{Rk{Ye{x", "!Critical Strike!",
     ""},

    {
     "call wild",
     {203, 203, 203, 203, 120, 203, 203,
      203, 203, 203, 203, 110, 203, 203,
      203, 203, 203, 203, 100, 203, 203,
      203, 203, 203, 203, 100, 203, 203},
     {0, 0, 0, 0, 4, 0, 0,
      0, 0, 0, 0, 4, 0, 0,
      0, 0, 0, 0, 4, 0, 0,
      0, 0, 0, 0, 3, 0, 0},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_call_wild, TRUE, SLOT ( 0 ), 0, 24,
     "", "You feel the your rage ebb.", ""},

    {
     "dirt kicking",
     {203, 203, 4, 4, 1, 9, 3,
      203, 203, 1, 1, 1, 8, 2,
      203, 203, 1, 1, 1, 6, 1,
      203, 203, 1, 1, 1, 6, 1},
     {0, 0, 4, 4, 4, 6, 2,
      0, 0, 4, 4, 4, 6, 2,
      0, 0, 3, 3, 3, 5, 1},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_dirt, TRUE, SLOT ( 0 ), 0, 24,
     "kicked dirt", "You rub the dirt out of your eyes.", ""},

    {
     "disarm",
     {203, 203, 18, 18, 32, 203, 20,
      203, 203, 8, 8, 22, 203, 10,
      203, 203, 5, 5, 22, 203, 6,
      203, 203, 5, 5, 12, 203, 6},
     {0, 0, 6, 3, 5, 0, 3,
      0, 0, 6, 3, 5, 0, 3,
      0, 0, 6, 3, 5, 0, 3,
      0, 0, 5, 2, 4, 0, 2},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_disarm, TRUE, SLOT ( 0 ), 0, 24,
     "", "!Disarm!", ""},

    {
     "dodge",
     {203, 203, 1, 19, 10, 203, 10,
      203, 203, 1, 9, 1, 203, 1,
      203, 203, 1, 9, 1, 203, 1,
      203, 203, 1, 9, 1, 203, 1},
     {0, 0, 4, 6, 5, 0, 2,
      0, 0, 4, 6, 5, 0, 2,
      0, 0, 3, 5, 4, 0, 1,
      0, 0, 3, 5, 4, 0, 2},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_dodge, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Dodge!", ""},

    {
     "dual wield",
     {203, 203, 35, 10, 30, 203, 203,
      203, 203, 25, 5, 20, 203, 203,
      203, 203, 15, 3, 10, 203, 203,
      203, 203, 8, 3, 6, 203, 203},
     {0, 0, 3, 2, 3, 0, 0,
      0, 0, 3, 2, 3, 0, 0,
      0, 0, 3, 2, 3, 0, 0,
      0, 0, 2, 1, 3, 0, 0},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_dual_wield, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Dual Wield!", ""},

    {
     "enhanced damage",
     {203, 203, 203, 1, 30, 203, 33,
      203, 203, 203, 1, 20, 203, 22,
      203, 203, 203, 1, 20, 203, 12,
      203, 203, 203, 1, 20, 203, 7},
     {0, 0, 0, 3, 6, 0, 7,
      0, 0, 0, 3, 6, 0, 7,
      0, 0, 0, 3, 6, 0, 7,
      0, 0, 0, 2, 5, 0, 6},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_enhanced_damage, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Enhanced Damage!", ""},

    {
     "envenom",
     {203, 203, 15, 90, 19, 203, 9,
      203, 203, 5, 80, 9, 203, 1,
      203, 203, 2, 70, 9, 203, 1,
      203, 203, 2, 60, 9, 203, 1},
     {0, 0, 4, 6, 1, 0, 3,
      0, 0, 4, 6, 1, 0, 3,
      0, 0, 4, 6, 1, 0, 3,
      0, 0, 3, 5, 1, 0, 2},
     spell_null, TAR_IGNORE, POS_RESTING,
     &gsn_envenom, TRUE, SLOT ( 0 ), 0, 36,
     "", "!Envenom!", ""},

    {
     "feed",
     {203, 203, 203, 203, 203, 203, 10,
      203, 203, 203, 203, 203, 203, 1,
      203, 203, 203, 203, 203, 203, 1,
      203, 203, 203, 203, 203, 203, 1},
     {0, 0, 0, 0, 0, 0, 2,
      0, 0, 0, 0, 0, 0, 2,
      0, 0, 0, 0, 0, 0, 2,
      0, 0, 0, 0, 0, 0, 1},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_feed, TRUE, SLOT ( 0 ), 0, 24,
     "feed", "!Feed!", ""},

    {
     "gouge",
     {203, 203, 52, 203, 203, 203, 203,
      203, 203, 42, 203, 203, 203, 203,
      203, 203, 32, 203, 203, 203, 203,
      203, 203, 22, 203, 203, 203, 203},
     {0, 0, 2, 0, 0, 0, 0,
      0, 0, 2, 0, 0, 0, 0,
      0, 0, 2, 0, 0, 0, 0,
      0, 0, 1, 0, 0, 0, 0},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_gouge, TRUE, SLOT ( 0 ), 0, 24,
     "gouge", "Your vision clears.", ""},

    {
     "grip",
     {203, 203, 203, 25, 203, 203, 203,
      203, 203, 203, 10, 203, 203, 203,
      203, 203, 203, 5, 203, 203, 203,
      203, 203, 203, 3, 203, 203, 203},
     {0, 0, 0, 2, 0, 0, 0,
      0, 0, 0, 2, 0, 0, 0,
      0, 0, 0, 2, 0, 0, 0,
      0, 0, 0, 1, 0, 0, 0},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_grip, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Grip!", ""},

    {
     "hand to hand",
     {203, 203, 22, 9, 22, 203, 12,
      203, 203, 12, 8, 12, 203, 2,
      203, 203, 6, 4, 6, 203, 1,
      203, 203, 6, 4, 6, 203, 1},
     {0, 0, 4, 2, 4, 0, 2,
      0, 0, 4, 2, 4, 0, 2,
      0, 0, 4, 2, 4, 0, 2,
      0, 0, 3, 1, 3, 0, 1},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_hand_to_hand, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Hand to Hand!", ""},

    {
     "kick",
     {203, 18, 21, 12, 20, 17, 15,
      203, 8, 11, 2, 10, 7, 5,
      203, 6, 8, 1, 8, 5, 3,
      203, 6, 8, 1, 8, 5, 3},
     {0, 4, 6, 3, 4, 6, 2,
      0, 4, 6, 3, 4, 6, 2,
      0, 4, 6, 3, 4, 6, 2,
      0, 3, 5, 2, 3, 5, 1},
     spell_null, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
     &gsn_kick, TRUE, SLOT ( 0 ), 0, 12,
     "kick", "!Kick!", ""},

    {
     "parry",
     {203, 203, 19, 1, 15, 27, 17,
      203, 203, 9, 1, 5, 17, 7,
      203, 203, 8, 1, 3, 10, 5,
      203, 203, 8, 1, 3, 10, 5},
     {0, 0, 4, 4, 5, 5, 2,
      0, 0, 4, 4, 5, 5, 2,
      0, 0, 4, 4, 5, 5, 2,
      0, 0, 3, 3, 4, 4, 1},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_parry, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Parry!", ""},

    {
     "rescue",
     {203, 203, 203, 1, 13, 203, 203,
      203, 203, 203, 1, 3, 203, 203,
      203, 203, 203, 1, 2, 203, 203,
      203, 203, 203, 1, 2, 203, 203},
     {0, 0, 0, 4, 3, 0, 0,
      0, 0, 0, 4, 3, 0, 0,
      0, 0, 0, 4, 3, 0, 0,
      0, 0, 0, 3, 2, 0, 0},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_rescue, TRUE, SLOT ( 0 ), 0, 12,
     "", "!Rescue!", ""},

    {
     "trip",
     {203, 203, 2, 22, 25, 203, 5,
      203, 203, 1, 12, 15, 203, 1,
      203, 203, 1, 6, 8, 203, 1,
      203, 203, 1, 6, 8, 203, 1},
     {0, 0, 4, 8, 5, 0, 3,
      0, 0, 4, 8, 5, 0, 3,
      0, 0, 4, 8, 5, 0, 3,
      0, 0, 3, 7, 4, 0, 2},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_trip, TRUE, SLOT ( 0 ), 0, 24,
     "trip", "!Trip!", ""},
    {
     "thrust",
     {203, 203, 203, 203, 120, 203, 203,
      203, 203, 203, 203, 110, 203, 203,
      203, 203, 203, 203, 100, 203, 203,
      203, 203, 203, 203, 90, 203, 203},
     {0, 0, 0, 0, 4, 0, 0,
      0, 0, 0, 0, 4, 0, 0,
      0, 0, 0, 0, 4, 0, 0,
      0, 0, 0, 0, 4, 0, 0},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_thrust, TRUE, SLOT ( 0 ), 0, 24,
     "thrust", "!Thrust!", ""},

    {
     "stun",
     {203, 203, 203, 45, 203, 203, 203,
      203, 203, 203, 35, 203, 203, 203,
      203, 203, 203, 25, 203, 203, 203,
      203, 203, 203, 15, 203, 203, 203},
     {0, 0, 0, 3, 0, 0, 0,
      0, 0, 0, 3, 0, 0, 0,
      0, 0, 0, 3, 0, 0, 0,
      0, 0, 0, 2, 0, 0, 0},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_stun, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Stun!", ""},

    {
     "second attack",
     {85, 36, 18, 7, 1, 25, 20,
      75, 26, 8, 6, 1, 15, 10,
      65, 16, 6, 5, 1, 8, 8,
      55, 16, 6, 5, 1, 8, 8},
     {7, 8, 5, 3, 4, 8, 2,
      7, 8, 5, 3, 4, 8, 2,
      7, 8, 5, 3, 4, 8, 2,
      6, 7, 4, 2, 3, 7, 1},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_second_attack, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Second Attack!", ""},

    {
     "third attack",
     {155, 203, 36, 18, 29, 203, 30,
      145, 203, 26, 8, 19, 203, 20,
      135, 203, 26, 6, 10, 203, 15,
      125, 203, 16, 6, 5, 203, 15},
     {0, 0, 9, 4, 7, 0, 3,
      0, 0, 9, 4, 7, 0, 3,
      0, 0, 9, 4, 7, 0, 3,
      0, 0, 8, 3, 6, 0, 2},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_third_attack, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Third Attack!", ""},

    {
     "fourth attack",
     {203, 203, 90, 65, 120, 203, 80,
      203, 203, 80, 45, 110, 203, 70,
      203, 203, 70, 35, 100, 203, 60,
      203, 203, 60, 25, 90, 203, 50},
     {0, 0, 10, 4, 5, 0, 10,
      0, 0, 10, 4, 5, 0, 10,
      0, 0, 10, 4, 5, 0, 10,
      0, 0, 9, 3, 4, 0, 9},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_fourth_attack, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Fourth Attack!", ""},

    {
     "fifth attack",
     {203, 203, 130, 80, 140, 203, 130,
      203, 203, 120, 70, 130, 203, 120,
      203, 203, 110, 60, 120, 203, 110,
      203, 203, 100, 50, 110, 203, 100},
     {0, 0, 7, 4, 5, 0, 12,
      0, 0, 6, 3, 4, 0, 12,
      0, 0, 6, 3, 4, 0, 12,
      0, 0, 6, 3, 4, 0, 11},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_fifth_attack, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Fifth Attack!", ""},
    {
     "sixth attack",
     {203, 203, 160, 150, 201, 203, 203,
      203, 203, 150, 140, 195, 203, 203,
      203, 203, 140, 130, 185, 203, 203,
      203, 203, 130, 120, 175, 203, 203},
     {0, 0, 0, 10, 10, 0, 0,
      0, 0, 0, 8, 8, 0, 0,
      0, 0, 0, 8, 8, 0, 0,
      0, 0, 0, 6, 6, 0, 0},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_sixth_attack, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Sixth Attack!", ""},
    {
     "seventh attack",
     {203, 203, 203, 202, 203, 203, 203,
      203, 203, 203, 190, 203, 203, 203,
      203, 203, 203, 180, 203, 203, 203,
      203, 203, 203, 170, 203, 203, 203},
     {0, 0, 0, 0, 14, 0, 0,
      0, 0, 0, 0, 13, 0, 0,
      0, 0, 0, 0, 13, 0, 0,
      0, 0, 0, 0, 12, 0, 0},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_seventh_attack, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Seventh Attack!", ""},

/* non-combat skills */

    {
     "fast healing",
     {203, 13, 203, 9, 55, 34, 2,
      203, 12, 203, 1, 45, 24, 1,
      203, 10, 203, 1, 35, 14, 1,
      203, 6, 203, 1, 25, 7, 1},
     {0, 5, 0, 4, 8, 5, 1,
      0, 5, 0, 4, 8, 5, 1,
      0, 5, 0, 4, 8, 5, 1,
      0, 4, 0, 3, 7, 4, 1},
     spell_null, TAR_IGNORE, POS_SLEEPING,
     &gsn_fast_healing, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Fast Healing!", ""},

    {
     "haggle",
     {203, 203, 1, 203, 42, 203, 203,
      203, 203, 1, 203, 32, 203, 203,
      203, 203, 1, 203, 22, 203, 203,
      203, 203, 1, 203, 22, 203, 203},
     {0, 0, 3, 0, 5, 0, 0,
      0, 0, 3, 0, 5, 0, 0,
      0, 0, 3, 0, 5, 0, 0,
      0, 0, 2, 0, 4, 0, 0},
     spell_null, TAR_IGNORE, POS_RESTING,
     &gsn_haggle, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Haggle!", ""},

    {
     "hide",
     {203, 203, 1, 18, 5, 203, 1,
      203, 203, 1, 8, 1, 203, 1,
      203, 203, 1, 5, 1, 203, 1,
      203, 203, 1, 5, 1, 203, 1},
     {0, 0, 4, 6, 5, 0, 3,
      0, 0, 4, 6, 5, 0, 3,
      0, 0, 4, 6, 5, 0, 3,
      0, 0, 3, 5, 4, 0, 2},
     spell_null, TAR_IGNORE, POS_RESTING,
     &gsn_hide, TRUE, SLOT ( 0 ), 0, 12,
     "", "!Hide!", ""},

    {
     "lore",
     {35, 15, 9, 203, 5, 14, 203,
      25, 5, 1, 203, 4, 4, 203,
      15, 3, 1, 203, 2, 2, 203,
      15, 3, 1, 203, 2, 2, 203},
     {6, 6, 4, 0, 4, 5, 0,
      6, 6, 4, 0, 4, 5, 0,
      5, 5, 3, 0, 3, 4, 0},
     spell_null, TAR_IGNORE, POS_RESTING,
     &gsn_lore, TRUE, SLOT ( 0 ), 0, 36,
     "", "!Lore!", ""},

    {
     "meditation",
     {9, 9, 203, 203, 15, 13, 203,
      8, 1, 203, 203, 5, 3, 203,
      6, 1, 203, 203, 3, 3, 203,
      6, 1, 203, 203, 3, 3, 203},
     {5, 5, 0, 0, 6, 6, 0,
      5, 5, 0, 0, 6, 6, 0,
      5, 5, 0, 0, 6, 6, 0,
      4, 4, 0, 0, 5, 5, 6},
     spell_null, TAR_IGNORE, POS_SLEEPING,
     &gsn_meditation, TRUE, SLOT ( 0 ), 0, 0,
     "", "Meditation", ""},

    {
     "nervestrike",
     {203, 203, 140, 203, 203, 203, 203,
      203, 203, 130, 203, 203, 203, 203,
      203, 203, 120, 203, 203, 203, 203,
      203, 203, 110, 203, 203, 203, 203},
     {0, 0, 4, 0, 0, 0, 0,
      0, 0, 4, 0, 0, 0, 0,
      0, 0, 3, 0, 0, 0, 0,
      0, 0, 3, 0, 0, 0, 0},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_nervestrike, TRUE, SLOT ( 0 ), 0, 24,
     "{RN{rervestrik{Re{x", "!Rampage!", ""},
    {
     "garrote",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_garrote, TRUE, SLOT ( 0 ), 0, 24,
     "{Dga{grr{Dote{x", "You can breathe again!", ""},

    {
     "ambush",
     {203, 203, 203, 203, 140, 203, 203,
      203, 203, 203, 203, 130, 203, 203,
      203, 203, 203, 203, 120, 203, 203,
      203, 203, 203, 203, 110, 203, 203},
     {0, 0, 0, 0, 8, 0, 0,
      0, 0, 0, 0, 8, 0, 0,
      0, 0, 0, 0, 7, 0, 0,
      0, 0, 0, 0, 7, 0, 0},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_ambush, TRUE, SLOT ( 0 ), 0, 24,
     "{ga{ym{gb{yu{gs{yh{x", "!Rampage!", ""},

    {
     "peek",
     {203, 203, 1, 203, 203, 203, 4,
      203, 203, 1, 203, 203, 203, 1,
      203, 203, 1, 203, 203, 203, 1,
      203, 203, 1, 203, 203, 203, 1},
     {0, 0, 3, 0, 0, 0, 4,
      0, 0, 3, 0, 0, 0, 4,
      0, 0, 3, 0, 0, 0, 4,
      0, 0, 2, 0, 0, 0, 3},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_peek, TRUE, SLOT ( 0 ), 0, 0,
     "", "!Peek!", ""},

    {
     "pick lock",
     {203, 203, 10, 203, 203, 203, 37,
      203, 203, 6, 203, 203, 203, 27,
      203, 203, 4, 203, 203, 203, 17,
      203, 203, 4, 203, 203, 203, 17},
     {0, 0, 4, 0, 0, 0, 8,
      0, 0, 4, 0, 0, 0, 8,
      0, 0, 4, 0, 0, 0, 8,
      0, 0, 3, 0, 0, 0, 7},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_pick_lock, TRUE, SLOT ( 0 ), 0, 12,
     "", "!Pick!", ""},

    {
     "sneak",
     {203, 203, 6, 15, 2, 203, 2,
      203, 203, 5, 5, 1, 203, 1,
      203, 203, 5, 5, 1, 203, 1,
      203, 203, 5, 5, 1, 203, 1},
     {0, 0, 4, 6, 3, 0, 1,
      0, 0, 4, 6, 3, 0, 1,
      0, 0, 4, 6, 3, 0, 1,
      0, 0, 3, 5, 2, 0, 1},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_sneak, TRUE, SLOT ( 0 ), 0, 12,
     "", "You no longer feel stealthy.", ""},

    {
     "swalk",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 202, 203, 203, 203, 203},
     {0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0,
      0, 0, 8, 0, 0, 0, 0},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_swalk, TRUE, SLOT ( 0 ), 0, 12,
     "", "You emerge from the depths of the shadows.", ""},

    {
     "steal",
     {203, 203, 7, 203, 203, 203, 203,
      203, 203, 5, 203, 203, 203, 203,
      203, 203, 3, 203, 203, 203, 203,
      203, 203, 3, 203, 203, 203, 203},
     {0, 0, 4, 0, 0, 0, 0,
      0, 0, 4, 0, 0, 0, 0,
      0, 0, 4, 0, 0, 0, 0,
      0, 0, 3, 0, 0, 0, 0},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_steal, TRUE, SLOT ( 0 ), 0, 24,
     "", "!Steal!", ""},

    {
     "scrolls",
     {2, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     {2, 3, 5, 8, 7, 3, 8,
      2, 3, 5, 8, 7, 3, 8,
      2, 3, 5, 8, 7, 3, 8,
      1, 2, 4, 7, 6, 2, 7},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_scrolls, TRUE, SLOT ( 0 ), 0, 24,
     "", "!Scrolls!", ""},

    {
     "staves",
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     {2, 3, 5, 8, 7, 3, 8,
      2, 3, 5, 8, 7, 3, 8,
      2, 3, 5, 8, 7, 3, 8,
      1, 2, 4, 7, 6, 2, 7},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_staves, TRUE, SLOT ( 0 ), 0, 12,
     "", "!Staves!", ""},

    {
     "strike",
     {203, 203, 203, 203, 60, 203, 203,
      203, 203, 203, 203, 50, 203, 203,
      203, 203, 203, 203, 40, 203, 203,
      203, 203, 203, 203, 50, 203, 203},
     {0, 0, 0, 0, 4, 0, 0,
      0, 0, 0, 0, 4, 0, 0,
      0, 0, 0, 0, 3, 0, 0,
      0, 0, 0, 0, 3, 0, 0},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_strike, TRUE, SLOT ( 0 ), 0, 24,
     "{Rs{rt{Rr{ri{Rk{re{x", "!Rampage!", ""},

    {
     "track",
     {203, 203, 203, 203, 20, 203, 203,
      203, 203, 203, 203, 10, 203, 203,
      203, 203, 203, 203, 8, 203, 203,
      203, 203, 203, 203, 8, 203, 203},
     {0, 0, 0, 0, 2, 0, 0,
      0, 0, 0, 0, 2, 0, 0,
      0, 0, 0, 0, 1, 0, 0,
      0, 0, 0, 0, 1, 0, 0},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_track, TRUE, SLOT ( 0 ), 0, 12,
     "", "!Track!", ""},

    {
     "wands",
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     {2, 3, 5, 8, 7, 3, 8,
      2, 3, 5, 8, 7, 3, 8,
      2, 3, 5, 8, 7, 3, 8,
      1, 2, 5, 7, 6, 2, 7},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_wands, TRUE, SLOT ( 0 ), 0, 12,
     "", "!Wands!", ""},
    {
     "whirlwind",
     {203, 203, 203, 60, 203, 203, 203,
      203, 203, 203, 50, 203, 203, 203,
      203, 203, 203, 40, 203, 203, 203,
      203, 203, 203, 40, 203, 203, 203},
     {0, 0, 0, 4, 0, 0, 0,
      0, 0, 0, 4, 0, 0, 0,
      0, 0, 0, 4, 0, 0, 0,
      0, 0, 0, 3, 0, 0, 0},
     spell_null, TAR_IGNORE, POS_FIGHTING,
     &gsn_whirlwind, TRUE, SLOT ( 0 ), 0, 24,
     "whirl wind", "!whirl wind!", ""},
    {
     "rampage",
     {203, 203, 203, 140, 203, 203, 203,
      203, 203, 203, 130, 203, 203, 203,
      203, 203, 203, 120, 203, 203, 203,
      203, 203, 203, 120, 203, 203, 203},
     {0, 0, 0, 4, 0, 0, 0,
      0, 0, 0, 3, 0, 0, 0,
      0, 0, 0, 3, 0, 0, 0,
      0, 0, 0, 3, 0, 0, 0},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_rampage, TRUE, SLOT ( 0 ), 0, 24,
     "{RR{rampag{Re{x", "!Rampage!", ""},

    {
     "sharpen",
     {203, 203, 203, 155, 203, 203, 203,
      203, 203, 203, 145, 203, 203, 203,
      203, 203, 203, 135, 203, 203, 203,
      203, 203, 203, 125, 203, 203, 203},
     {0, 0, 0, 4, 0, 0, 0,
      0, 0, 0, 3, 0, 0, 0,
      0, 0, 0, 3, 0, 0, 0,
      0, 0, 0, 3, 0, 0, 0},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_sharpen, TRUE, SLOT ( 0 ), 0, 24,
     "", "", ""},
    {
     "stake",
     {203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203,
      203, 203, 203, 203, 203, 203, 203},
     {0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_stake, TRUE, SLOT ( 0 ), 0, 24,
     "", "", ""},

    {
     "recall",
     {1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      1, 1, 1, 1, 1, 1, 1},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_recall, TRUE, SLOT ( 0 ), 0, 12,
     "", "!Recall!", ""},

    {
     "eyerub",
     {10, 10, 10, 10, 10, 10, 10,
      10, 10, 10, 10, 10, 10, 10,
      5, 5, 5, 5, 5, 5, 5,
      5, 5, 5, 5, 5, 5, 5},
     {2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2,
      2, 2, 2, 2, 2, 2, 2},
     spell_null, TAR_IGNORE, POS_STANDING,
     &gsn_rub, TRUE, SLOT ( 0 ), 0, 24,
     "", "!RUB!", ""}

};

const struct group_type group_table[MAX_GROUP] = {

    {
     "rom basics",
     {0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0},
     {"scrolls", "staves", "wands", "recall",}
     },

    {
     "mage basics",
     {0, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"dagger"}
     },

    {
     "cleric basics",
     {-1, 0, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"mace"}
     },

    {
     "rogue basics",
     {-1, -1, 0, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"dagger", "steal", "pass door"}
     },

    {
     "warrior basics",
     {-1, -1, -1, 0, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"sword", "second attack", "dual wield"}
     },

    {
     "tracker basics",
     {-1, -1, -1, -1, 0, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"spear", "second attack", "track"}
     },

    {
     "druid basics",
     {-1, -1, -1, -1, -1, 0, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"polearm", "invisibility"}
     },

    {
     "revenant basics",
     {-1, -1, -1, -1, -1, -1, 0,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"dagger", "hide", "sneak", "summon familiar"}
     },

    {
     "wizard basics",
     {-1, -1, -1, -1, -1, -1, -1,
      0, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"dagger"}
     },

    {
     "priest basics",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, 0, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"mace"}
     },

    {
     "thief basics",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, 0, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"dagger", "steal", "grip", "pass door"}
     },
/*
    {
	"berserker basics",
	{ -1, -1, -1, -1, -1, -1, -1,
	  -1, -1, -1,  0, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1
        -1, -1, -1, -1, -1, -1, -1},
	{ "sword", "second attack", "dual wield" }
    },
*/
    {
     "hunter basics",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, 0, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"dagger", "second attack", "track"}
     },

    {
     "shaman basics",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, 0, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"polearm", "invisibility"}
     },
    {
     "vampire basics",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, 0,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"dagger", "hide", "sneak", "summon familiar"}
     },
    {
     "invoker basics",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      0, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"dagger"}
     },
    {
     "bishop basics",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, 0, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"mace"}
     },
    {
     "mercenary basics",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, 0, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"dagger", "steal", "pass door"}
     },
    {
     "gladiator basics",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, 0, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"sword", "second attack", "dual wield"}
     },
    {
     "ranger basics",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, 0, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"spear", "second attack", "track"}
     },

    {
     "sage basics",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, 0, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"polearm", "invisibility"}
     },
    {
     "lich basics",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, 0,
      -1, -1, -1, -1, -1, -1, -1},
     {"dagger", "hide", "sneak", "feed", "summon familiar"}
     },
    {
     "sorcerer basics",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      0, -1, -1, -1, -1, -1, -1},
     {"dagger"}
     },
    {
     "templar basics",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, 0, -1, -1, -1, -1, -1},
     {"mace"}
     },
    {
     "assassin basics",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, 0, -1, -1, -1, -1},
     {"dagger", "steal", "pass door"}
     },
    {
     "knight basics",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, 0, -1, -1, -1},
     {"sword", "second attack", "dual wield"}
     },
    {
     "strider basics",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, 0, -1, -1},
     {"spear", "second attack", "track"}
     },

    {
     "elder basics",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, 0, -1},
     {"polearm", "invisibility"}
     },
    {
     "cainite basics",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, 0},
     {"dagger", "hide", "sneak", "feed", "summon familiar"}
     },

    {
     "mage default",
     {40, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "lore",
      "beguiling",
      "combat",
      "detection",
      "enhancement",
      "illusion",
      "maladictions",
      "protective",
      "shielding",
      "transportation",
      "weather"}
     },

    {
     "cleric default",
     {-1, 40, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "flail",
      "attack",
      "benedictions",
      "creation",
      "curative",
      "detection",
      "healing",
      "maladictions",
      "protective",
      "shield block",
      "transportation",
      "weather"}
     },

    {
     "thief default",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, 40, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "backstab",
      "circle",
      "disarm",
      "dodge",
      "hide",
      "mace",
      "peek",
      "pick lock",
      "sneak",
      "sword",
      "trip",
      "second attack",
      "charm person"}
     },

    {
     "warrior default",
     {-1, -1, -1, 40, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "weaponsmaster",
      "bash",
      "disarm",
      "enhanced damage",
      "grip",
      "parry",
      "rescue",
      "shield block",
      "third attack",
      "fourth attack"}
     },

    {
     "ranger default",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, 40, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "weaponsmaster",
      "dirt kick",
      "enhanced damage",
      "envenom",
      "hand to hand",
      "kick",
      "parry",
      "shield block",
      "third attack",
      "curative",
      "healing",
      "transportation",
      "earthquake"}
     },

    {
     "druid default",
     {-1, -1, -1, -1, -1, 40, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "lore",
      "shield block",
      "second attack",
      "attack",
      "benedictions",
      "combat",
      "creation",
      "curative",
      "healing",
      "protective",
      "weather",
      "harm"}
     },

    {
     "revenant default",
     {-1, -1, -1, -1, -1, -1, 40,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "backstab",
      "disarm",
      "dodge",
      "fast healing",
      "feed",
      "hand to hand",
      "shield block",
      "beguiling",
      "detection",
      "enhancement",
      "illusion",
      "maladictions",
      "transportation",
      "combat"}
     },

    {
     "wizard default",
     {-1, -1, -1, -1, -1, -1, -1,
      40, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "lore",
      "beguiling",
      "combat",
      "detection",
      "enhancement",
      "illusion",
      "maladictions",
      "protective",
      "shielding",
      "transportation",
      "weather",
      "cure blindness"}
     },

    {
     "priest default",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, 40, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "flail",
      "shield block",
      "attack",
      "benedictions",
      "creation",
      "curative",
      "detection",
      "healing",
      "maladictions",
      "protective",
      "transportation",
      "weather"}
     },

    {
     "mercenary default",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, 40, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "backstab",
      "circle",
      "disarm",
      "dodge",
      "dual wield",
      "hide",
      "mace",
      "peek",
      "pick lock",
      "sneak",
      "sword",
      "trip",
      "second attack",
      "charm person"}
     },

    {
     "gladiator default",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, 40, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "weaponsmaster",
      "bash",
      "disarm",
      "enhanced damage",
      "parry",
      "rescue",
      "shield block",
      "third attack",
      "fourth attack"}
     },

    {
     "strider default",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, 40, -1, -1},
     {
      "weaponsmaster",
      "dual wield",
      "enhanced damage",
      "envenom",
      "hand to hand",
      "kick",
      "parry",
      "third attack",
      "beguiling",
      "curative",
      "healing",
      "protective",
      "transportation"}
     },

    {
     "sage default",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, 40, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "lore",
      "shield block",
      "second attack",
      "attack",
      "benedictions",
      "combat",
      "creation",
      "curative",
      "healing",
      "protective",
      "weather"}
     },

    {
     "vampire default",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, 40,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "backstab",
      "disarm",
      "dodge",
      "fast healing",
      "feed",
      "hand to hand",
      "shield block",
      "beguiling",
      "detection",
      "enhancement",
      "illusion",
      "maladictions",
      "transportation",
      "combat"}
     },

    {
     "sorcerer default",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      40, -1, -1, -1, -1, -1, -1},
     {
      "lore",
      "beguiling",
      "combat",
      "detection",
      "enhancement",
      "illusion",
      "maladictions",
      "protective",
      "shielding",
      "transportation",
      "weather"}
     },

    {
     "bishop default",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, 40, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "flail",
      "attack",
      "benedictions",
      "creation",
      "curative",
      "detection",
      "healing",
      "maladictions",
      "protective",
      "shield block",
      "transportation",
      "weather"}
     },
    {
     "assassin default",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, 40, -1, -1, -1, -1},
     {
      "backstab",
      "circle",
      "disarm",
      "dodge",
      "hide",
      "mace",
      "peek",
      "pick lock",
      "sneak",
      "sword",
      "trip",
      "second attack",
      "charm person"}
     },                         /*
                                   {
                                   "berserker default",
                                   { -1, -1, -1, -1, -1, -1, -1,
                                   -1, -1, -1, 40, -1, -1, -1,
                                   -1, -1, -1, -1, -1, -1, -1,
                                   -1, -1, -1, -1, -1, -1, -1 },
                                   {
                                   "weaponsmaster",
                                   "bash",
                                   "disarm",
                                   "enhanced damage", 
                                   "grip",
                                   "parry",
                                   "rescue",
                                   "shield block",
                                   "third attack",
                                   "fourth attack"
                                   }      
                                   }, */

    {
     "hunter default",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, 40, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "weaponsmaster",
      "dual wield",
      "enhanced damage",
      "envenom",
      "hand to hand",
      "kick",
      "parry",
      "third attack",
      "beguiling",
      "curative",
      "healing",
      "protective",
      "transportation"}
     },

    {
     "elder default",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, 40, -1},
     {
      "lore",
      "shield block",
      "second attack",
      "attack",
      "benedictions",
      "combat",
      "creation",
      "curative",
      "healing",
      "protective",
      "weather"}
     },

    {
     "lich default",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, 40,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "backstab",
      "detection",
      "disarm",
      "dodge",
      "fast healing",
      "hand to hand",
      "shield block",
      "beguiling",
      "enhancement",
      "illusion",
      "maladictions",
      "transportation"}
     },

    {
     "invoker default",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      40, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "lore",
      "beguiling",
      "combat",
      "detection",
      "enhancement",
      "illusion",
      "maladictions",
      "protective",
      "shielding",
      "transportation",
      "weather"}
     },

    {
     "templar default",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, 40, -1, -1, -1, -1, -1},
     {
      "flail",
      "attack",
      "benedictions",
      "creation",
      "curative",
      "detection",
      "healing",
      "maladictions",
      "protective",
      "shield block",
      "transportation",
      "weather"}
     },
    {
     "rogue default",
     {-1, -1, 40, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "backstab",
      "circle",
      "disarm",
      "dodge",
      "hide",
      "mace",
      "peek",
      "pick lock",
      "sneak",
      "sword",
      "trip",
      "second attack",
      "charm person"}
     },
    {
     "knight default",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, 40, -1, -1, -1},
     {
      "weaponsmaster",
      "bash",
      "disarm",
      "enhanced damage",
      "grip",
      "parry",
      "rescue",
      "shield block",
      "third attack",
      "fourth attack"}
     },

    {
     "tracker default",
     {-1, -1, -1, -1, 40, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "weaponsmaster",
      "dual wield",
      "enhanced damage",
      "envenom",
      "hand to hand",
      "kick",
      "parry",
      "third attack",
      "beguiling",
      "curative",
      "healing",
      "protective",
      "transportation"}
     },

    {
     "shaman default",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, 40, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {
      "lore",
      "shield block",
      "second attack",
      "attack",
      "benedictions",
      "combat",
      "creation",
      "curative",
      "healing",
      "protective",
      "weather"}
     },

    {
     "cainite default",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, 40},
     {
      "backstab",
      "detection",
      "disarm",
      "dodge",
      "fast healing",
      "hand to hand",
      "shield block",
      "beguiling",
      "enhancement",
      "illusion",
      "maladictions",
      "transportation"}
     },
    {
     "weaponsmaster",
     {40, 40, 40, 20, 30, 40, 40,
      40, 40, 40, 20, 30, 40, 40,
      40, 40, 40, 20, 30, 40, 40,
      40, 40, 40, 20, 30, 40, 40},
     {"axe", "dagger", "flail", "mace", "polearm", "spear", "sword",
      "whip"}
     },

    {
     "attack",
     {6, 5, -1, -1, -1, 6, 5,
      5, 4, -1, -1, -1, 5, 4,
      5, 4, -1, -1, -1, 5, 4,
      4, 4, -1, -1, -1, 5, 4},
     {"demonfire", "dispel evil", "dispel good", "earthquake",
      "flamestrike", "heat metal", "ray of truth"}
     },

    {
     "beguiling",
     {5, 4, -1, -1, 5, -1, 6,
      4, 3, -1, -1, 4, -1, 5,
      4, 3, -1, -1, 4, -1, 5,
      3, 3, -1, -1, 4, -1, 5},
     {"animate", "calm", "charm person", "resurrect", "sleep"}
     },

    {
     "benedictions",
     {2, 4, -1, -1, 5, 4, 3,
      1, 3, -1, -1, 4, 3, 2,
      1, 3, -1, -1, 4, 3, 2,
      1, 3, -1, -1, 4, 3, 2},
     {"bless", "calm", "frenzy", "holy word", "remove curse", "dark gift",
      "warriors rage",
      "invigorate", "immolation", "anger", "vampiric embrace"}
     },

    {
     "combat",
     {5, 5, -1, -1, 4, 6, 5,
      4, 4, -1, -1, 3, 5, 4,
      4, 4, -1, -1, 3, 5, 4,
      3, 4, -1, -1, 3, 5, 4},
     {"burning hands", "chill touch",
      "colour spray", "magic missile",
      "shocking grasp", "vampire blast", "divine fury", "meteor storm",
      "call darkness", "leech"}
     },
    {
     "elemental defense",
     {-1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1},
     {"stone meld", "screen", "mud skin", "moss skin", "bark skin",
      "steel skin", "emerald skin", "ruby skin", "diamond skin"}
     },

    {
     "elemental offense",
     {2, 2, -1, -1, -1, -1, -1,
      2, 2, -1, -1, -1, -1, -1,
      1, 1, -1, -1, -1, -1, -1,
      1, 1, -1, -1, -1, -1, -1},
     {"ice rain", "fire rain", "acid rain", "acid storm", "firestorm",
      "ice storm",
      "ice bolt", "fire bolt", "gas bolt", "acid bolt", "fire blast",
      "ice blast",
      "gas blast", "electric blast", "lighting blast", "fire ball",
      "lighting bolt",
      "chain lightning"}
     },

    {
     "creation",
     {4, 4, -1, -1, 7, 4, -1,
      3, 3, -1, -1, 6, 3, -1,
      3, 3, -1, -1, 6, 3, -1,
      2, 3, -1, -1, 6, 3, -1},
     {"continual light", "create food", "create spring", "create water",
      "create rose", "conjure", "empower", "floating disc", "create bed",
      "holy mace"}
     },

    {
     "curative",
     {-1, 4, -1, -1, 7, 5, -1,
      -1, 3, -1, -1, 6, 4, -1,
      -1, 3, -1, -1, 6, 4, -1,
      -1, 3, -1, -1, 6, 4, -1},
     {"cure blindness", "cure disease", "cure poison", "heroes feast"}
     },

    {
     "detection",
     {4, 3, 6, -1, 3, 6, 4,
      3, 2, 5, -1, 2, 5, 3,
      3, 2, 5, -1, 2, 5, 3,
      2, 2, 5, -1, 2, 5, 3},
     {"detect evil", "detect good", "detect hidden", "detect invis",
      "detect magic", "detect poison", "farsight", "identify",
      "know alignment", "locate object"}
     },

    {
     "draconian",
     {8, 4, -1, -1, -1, -1, -1,
      7, 3, -1, -1, -1, -1, -1,
      7, 3, -1, -1, -1, -1, -1,
      6, 3, -1, -1, -1, -1, -1},
     {"acid breath", "fire breath", "frost breath", "gas breath",
      "lightning breath"}
     },

    {
     "enchantment",
     {4, 7, -1, -1, -1, 3, -1,
      3, 6, -1, -1, 3, 3, -1,
      3, 6, -1, -1, 3, 3, -1,
      2, 6, -1, -1, 3, 3, -1},
     {"enchant armor", "enchant weapon", "fireproof", "recharge",
      "drain blade",
      "vorpal blade",
      "sharp blade ", " shocking blade ", " flame blade ", " shocking blade ",
      " frost blade ", " blade bless "}}, {" enhancement ", {5, 6, -1, -1, 4,
                                                             4, 6,
                                                             4, 5, -1, -1, 3,
                                                             3, 5,
                                                             4, 5, -1, -1, 3,
                                                             3, 5,
                                                             3, 5, -1, -1, 3,
                                                             3, 5},
                                           {"giant strength", "brage",
                                            "haste",
                                            "infravision", "refresh",
                                            "dragon skin", "dragon wisdom"}
                                           },

    {
     "harmful",
     {3, 4, -1, -1, -1, -1, 6,
      2, 3, -1, -1, -1, 4, 5,
      2, 3, -1, -1, -1, 4, 5,
      1, 3, -1, -1, -1, 4, 5},
     {"cause critical", "cause light", "cause serious", "harm"}
     },

    {
     "healing",
     {-1, 3, -1, -1, 5, 4, -1,
      -1, 2, -1, -1, 4, 3, -1,
      -1, 2, -1, -1, 4, 3, -1,
      -1, 2, -1, -1, 4, 3, -1},
     {"cure critical", "cure light", "cure serious", "heal",
      "mass healing", "superior healing", "master healing", "concentration",
      "restore mana"}
     },

    {
     "illusion",
     {4, 6, 7, -1, 7, -1, 4,
      3, 5, 6, -1, 6, -1, 3,
      3, 5, 6, -1, 6, -1, 3,
      2, 5, 6, -1, 6, -1, 3},
     {"invis", "mass invis", "ventriloquate", "camouflage"}
     },

    {
     "maladictions",
     {5, 5, -1, -1, 6, 8, 5,
      4, 4, -1, -1, 5, 7, 4,
      4, 4, -1, -1, 5, 7, 4,
      3, 4, -1, -1, 5, 7, 4},
     {"blindness", "change sex", "curse", "energy drain", "plague",
      "poison", "slow", "voodoo", "weaken", "cry"}
     },

    {
     "protective",
     {4, 4, -1, -1, 7, 5, 7,
      3, 3, -1, -1, 6, 4, 6,
      3, 3, -1, -1, 6, 4, 6,
      2, 3, -1, -1, 6, 4, 6},
     {"armor", "cancellation", "dispel magic", "fireproof",
      "protection evil", "protection good", "sanctuary", "shield",
      "stone skin", "immolation", "gods armor", "divine protection"}
     },

    {
     "shielding",
     {8, 8, -1, -1, -1, 8, -1,
      6, 7, -1, -1, -1, 7, -1,
      6, 7, -1, -1, -1, 7, -1,
      5, 7, -1, -1, -1, 7, -1},
     {"iceshield", "fireshield", "shockshield", "acidshield", "poisonshield",
      "briarshield",
      "mana shield", "ward"}
     },

    {
     "transportation",
     {4, 4, -1, -1, 5, 7, 4,
      3, 3, -1, -1, 4, 6, 3,
      3, 3, -1, -1, 4, 6, 3,
      2, 3, -1, -1, 4, 6, 3},
     {"fly", "gate", "nexus", "pass door", "portal", "summon", "teleport",
      "transport", "word of recall"}
     },

    {
     "weather",
     {4, 4, -1, -1, 5, 5, 7,
      3, 3, -1, -1, 4, 4, 6,
      3, 3, -1, -1, 4, 4, 6,
      2, 3, -1, -1, 4, 4, 6},
     {"call lightning", "control weather", "faerie fire", "faerie fog",
      "lightning bolt"}
     },
    {
     "bladecraft",
     {8, 9, -1, -1, -1, -1, -1,
      7, 8, -1, -1, -1, -1, -1,
      7, 8, -1, -1, -1, -1, -1,
      6, 7, -1, -1, -1, -1, -1},
     {"drain blade", "vorpal blade", "flame blade", "shocking blade",
      "frost blade", "sharp blade"}
     }
};
