/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,	   *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 *									   *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael	   *
 *  Chastain, Michael Quan, and Mitchell Tse.				   *
 *									   *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc	   *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.						   *
 *									   *
 *  Much time and thought has gone into this software and you are	   *
 *  benefitting.  We hope that you share your changes too.  What goes	   *
 *  around, comes around.						   *
 ***************************************************************************/

/***************************************************************************
*	ROM 2.4 is copyright 1993-1995 Russ Taylor			   *
*	ROM has been brought to you by the ROM consortium		   *
*	    Russ Taylor (rtaylor@pacinfo.com)				   *
*	    Gabrielle Taylor (gtaylor@pacinfo.com)			   *
*	    Brian Moore (rom@rom.efn.org)				   *
*	By using this code, you have agreed to follow the terms of the	   *
*	ROM license, in the file Rom24/doc/rom.license			   *
***************************************************************************/

/*************************************************************************** 
*       ROT 1.4 is copyright 1996-1997 by Russ Walsh                       * 
*       By using this code, you have agreed to follow the terms of the     * 
*       ROT license, in the file doc/rot.license                           * 
***************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <string.h>
#include <time.h>
#include "merc.h"

CH_CMD ( do_ignor )
{
    send_to_char ( "I'm sorry, forget must be entered in full.\n\r", ch );
    return;
}

CH_CMD ( do_ignore )
{
    CHAR_DATA *rch;
    char arg[MAX_INPUT_LENGTH], buf[MAX_STRING_LENGTH];
    DESCRIPTOR_DATA *d;
    int pos;
    bool found = FALSE;

    if ( ch->desc == NULL )
        rch = ch;
    else
        rch = ch->desc->original ? ch->desc->original : ch;

    if ( IS_NPC ( rch ) )
        return;

    smash_tilde ( argument );

    argument = one_argument ( argument, arg );

    if ( arg[0] == '\0' )
    {
        if ( rch->pcdata->forget[0] == NULL )
        {
            send_to_char ( "You are not forgetting anyone.\n\r", ch );
            return;
        }
        send_to_char ( "You are currently forgetting:\n\r", ch );

        for ( pos = 0; pos < MAX_FORGET; pos++ )
        {
            if ( rch->pcdata->forget[pos] == NULL )
                break;

            sprintf ( buf, "    %s\n\r", rch->pcdata->forget[pos] );
            send_to_char ( buf, ch );
        }
        return;
    }

    for ( pos = 0; pos < MAX_FORGET; pos++ )
    {
        if ( rch->pcdata->forget[pos] == NULL )
            break;

        if ( !str_cmp ( arg, rch->pcdata->forget[pos] ) )
        {
            send_to_char ( "You have already forgotten that person.\n\r",
                           ch );
            return;
        }
    }

    for ( d = descriptor_list; d != NULL; d = d->next )
    {
        CHAR_DATA *wch;

        if ( d->connected != CON_PLAYING || !can_see ( ch, d->character ) )
            continue;

        wch = ( d->original != NULL ) ? d->original : d->character;

        if ( !can_see ( ch, wch ) )
            continue;

        if ( !str_cmp ( arg, wch->name ) )
        {
            found = TRUE;
            if ( wch == ch )
            {
                send_to_char
                    ( "You forget yourself for a moment, but it passes.\n\r",
                      ch );
                return;
            }
            if ( wch->level >= LEVEL_IMMORTAL )
            {
                send_to_char ( "That person is very hard to forget.\n\r",
                               ch );
                return;
            }
        }
    }

    if ( !found )
    {
        send_to_char ( "No one by that name is playing.\n\r", ch );
        return;
    }

    for ( pos = 0; pos < MAX_FORGET; pos++ )
    {
        if ( rch->pcdata->forget[pos] == NULL )
            break;
    }

    if ( pos >= MAX_FORGET )
    {
        send_to_char ( "Sorry, you have reached the forget limit.\n\r", ch );
        return;
    }

    /* make a new forget */
    rch->pcdata->forget[pos] = str_dup ( arg );
    sprintf ( buf, "You are now deaf to %s.\n\r", arg );
    send_to_char ( buf, ch );
}

CH_CMD ( do_remembe )
{
    send_to_char ( "I'm sorry, remember must be entered in full.\n\r", ch );
    return;
}

CH_CMD ( do_remember )
{
    CHAR_DATA *rch;
    char arg[MAX_INPUT_LENGTH], buf[MAX_STRING_LENGTH];
    int pos;
    bool found = FALSE;

    if ( ch->desc == NULL )
        rch = ch;
    else
        rch = ch->desc->original ? ch->desc->original : ch;

    if ( IS_NPC ( rch ) )
        return;

    argument = one_argument ( argument, arg );

    if ( arg[0] == '\0' )
    {
        if ( rch->pcdata->forget[0] == NULL )
        {
            send_to_char ( "You are not forgetting anyone.\n\r", ch );
            return;
        }
        send_to_char ( "You are currently forgetting:\n\r", ch );

        for ( pos = 0; pos < MAX_FORGET; pos++ )
        {
            if ( rch->pcdata->forget[pos] == NULL )
                break;

            sprintf ( buf, "    %s\n\r", rch->pcdata->forget[pos] );
            send_to_char ( buf, ch );
        }
        return;
    }

    for ( pos = 0; pos < MAX_FORGET; pos++ )
    {
        if ( rch->pcdata->forget[pos] == NULL )
            break;

        if ( found )
        {
            rch->pcdata->forget[pos - 1] = rch->pcdata->forget[pos];
            rch->pcdata->forget[pos] = NULL;
            continue;
        }

        if ( !str_cmp ( arg, rch->pcdata->forget[pos] ) )
        {
            send_to_char ( "Forget removed.\n\r", ch );
            free_string ( rch->pcdata->forget[pos] );
            rch->pcdata->forget[pos] = NULL;
            found = TRUE;
        }
    }

    if ( !found )
        send_to_char ( "No one by that name is forgotten.\n\r", ch );
}
