/******************************************************************************
 Copyright 2000-2001 Richard Woolcock.  All rights reserved.  This software may
 only be used, copied, modified, distributed or sub-licensed under the terms of
 the Glad license, which must always be included with any distributions of this
 software.  This copyright notice must remain unmodified at the top of any file
 containing any of the code found within this file.
 ******************************************************************************/

/******************************************************************************
 File Name        : combat.h
 ******************************************************************************
 Description      : The combat system.
 ******************************************************************************
 Revision History :

 Date/Author : DD-MMM-YYYY   <author's name>
 Description : <description of change>

 Date/Author : 15-Jan-2001   Richard Woolcock (aka KaVir).
 Description : Initial version for Glad 2.0a.
 ******************************************************************************/

#ifndef COMBAT_HEADER
#define COMBAT_HEADER

/******************************************************************************
 Required macros.
 ******************************************************************************/

#define CMBT(f)      void Cmbt##f##(body_t* pstBody, ap_t eLocation)

/******************************************************************************
 Required types.
 ******************************************************************************/

typedef struct
{
   char  *szRequirements; /* The move requirements                      */
   void (*pfnFunction)(body_t* pstBody, ap_t eLocation); 
                          /* A pointer to the attack function           */
   int    iSpeed;         /* Speed delay                                */
   int    iAttack;        /* Attack bonus                               */
   int    iDefence;       /* Defense bonus                              */
   int    iDamage;        /* Damage bonus                               */
   char  *szBlockTxt;     /* The text you see when an attack is blocked */
} cmbt_table_t;

/******************************************************************************
 Externally available commands.
 ******************************************************************************/

extern const cmbt_table_t *kstCmbtTable[];

/******************************************************************************
 Global operation prototypes.
 ******************************************************************************/

void Combat     ( body_t *pstBody, ap_t eLocation, char chMove, table_t eTable );
void (*CombatCmd( body_t *pstBody, char *szCmd, ap_t eLocation ))(body_t*, ap_t);
void PushMove   ( char *szTxt, char chMove );
bool IsBlocked  ( body_t *pstBody, char *szAttack, int iAttack );
int  GetEnhancedDamage( body_t *pstBody );

CMBT(Null);

#endif /* COMBAT_HEADER */
