/******************************************************************************
 Copyright 2000-2001 Richard Woolcock.  All rights reserved.  This software may
 only be used, copied, modified, distributed or sub-licensed under the terms of
 the Glad license, which must always be included with any distributions of this
 software.  This copyright notice must remain unmodified at the top of any file
 containing any of the code found within this file.
 ******************************************************************************/

/******************************************************************************
 File Name        : commands.h
 ******************************************************************************
 Description      : All commands used by the players.
 ******************************************************************************
 Revision History :

 Date/Author : DD-MMM-YYYY   <author's name>
 Description : <description of change>

 Date/Author : 15-Jan-2001   Richard Woolcock (aka KaVir).
 Description : Initial version for Glad 2.0a.
 ******************************************************************************/

#ifndef COMMANDS_HEADER
#define COMMANDS_HEADER

/******************************************************************************
 Required types.
 ******************************************************************************/

typedef struct
{
   char      *szCommand;
   void     (*pfnFunction)(conn_t* pstConn, char* szCmd, char* szTxt);
   status_t   eType;
} cmd_table_t;

/******************************************************************************
 Required macros.
 ******************************************************************************/

#define CMD(f) void Cmd##f##(conn_t*pstConn,char*szCmd,char*szTxt)

/******************************************************************************
 Externally available commands.
 ******************************************************************************/

extern const cmd_table_t kstCmdTable[];

/******************************************************************************
 Global operation prototypes.
 ******************************************************************************/

CMD(LeftHand);
CMD(RightHand);
CMD(Feet);
CMD(Eyes);
CMD(Quit);
CMD(Shutdown);
CMD(Create);
CMD(Say);
CMD(Chat);
CMD(Emote);
CMD(Prompt);
CMD(Commands);
CMD(Who);
CMD(Challenge);
CMD(Accept);
CMD(Train);
CMD(Leave);
CMD(Str);
CMD(Dex);
CMD(Sta);
CMD(Siz);
CMD(Wit);
CMD(Score);
CMD(Help);
CMD(Credits);

#endif /* COMMANDS_HEADER */
