/******************************************************************************
 Copyright 2000-2001 Richard Woolcock.  All rights reserved.  This software may
 only be used, copied, modified, distributed or sub-licensed under the terms of
 the Glad license, which must always be included with any distributions of this
 software.  This copyright notice must remain unmodified at the top of any file
 containing any of the code found within this file.
 ******************************************************************************/

/******************************************************************************
 File Name        : glad.h
 ******************************************************************************
 Description      : Contains the core functionality of the mud.
 ******************************************************************************
 Revision History :

 Date/Author : DD-MMM-YYYY   <author's name>
 Description : <description of change>

 Date/Author : 15-Jan-2001   Richard Woolcock (aka KaVir).
 Description : Initial version for Glad 2.0a.
 ******************************************************************************/

#ifndef GLAD_HEADER
#define GLAD_HEADER

/******************************************************************************
 Required literals.
 ******************************************************************************/

#define STR          0 /* Strength */
#define DEX          1 /* Dexterity */
#define STA          2 /* Stamina */
#define SIZ          3 /* Size */
#define WIT          4 /* Wits */

/******************************************************************************
 Required operation prototypes.
 ******************************************************************************/

/* Game functions */
void     GameLoop        ( int iControl );
void     Update          ( void );
void     Log             ( char* szTxt, ... );

/* Mud functions */
void     TrainStat       ( conn_t  * pstConn, char* szTxt, int iStat, int iNum );
char   * StatusName      ( body_t  * pstBody );
conn_t * FindPerson      ( char    * szTxt );
body_t * FindBody        ( char    * szTxt );
void     FreeBody        ( body_t ** ppstBody );
int      RollDice        ( int       iSides );

/* Character functions */
int      GetHealth       ( body_t *  pstBody );
int      GetAttack       ( body_t *  pstBody );
int      GetDefence      ( body_t *  pstBody );
int      GetDamage       ( body_t *  pstBody );
int      GetSpeed        ( body_t *  pstBody );
int      GetRoom         ( conn_t *  pstConn );
char   * GetName         ( conn_t *  pstConn );
status_t GetStatus       ( conn_t *  pstConn );

#endif /* GLAD_HEADER */
