/******************************************************************************
 Copyright 2000-2001 Richard Woolcock.  All rights reserved.  This software may
 only be used, copied, modified, distributed or sub-licensed under the terms of
 the Glad license, which must always be included with any distributions of this
 software.  This copyright notice must remain unmodified at the top of any file
 containing any of the code found within this file.
 ******************************************************************************/

/******************************************************************************
 File Name        : sockets.h
 ******************************************************************************
 Description      : Contains the socket handling code.
 ******************************************************************************
 Revision History :

 Date/Author : DD-MMM-YYYY   <author's name>
 Description : <description of change>

 Date/Author : 15-Jan-2001   Richard Woolcock (aka KaVir).
 Description : Initial version for Glad 2.0a.
 ******************************************************************************/

#ifndef SOCKETS_HEADER
#define SOCKETS_HEADER

/******************************************************************************
 Required literals.
 ******************************************************************************/

#define MAX_BUF        4096 /* Storage size used for many char arrays */
#define MAX_TRAIN        30 /* Max number of trains allowed */
#define PORT           3003 /* The port number of the mud */
#define MAX_TECHNIQUES   10 /* The max number of techniques stored */

/******************************************************************************
 Required types.
 ******************************************************************************/

typedef enum
{
   FALSE,
   TRUE
} bool;

typedef enum
{
   MALE,
   FEMALE
} sex_t;

typedef enum
{
   TO_USER,
   TO_ROOM,
   TO_WORLD,
   TO_ALL
} out_t;

typedef enum
{
   CROWD=1,
   CITIZEN=2,
   TRAINING=4,
   GLADIATOR=8,
   CHALLENGER=16,
   FIGHTING=32,
   CORRUPTED_PFILE=64,
   ALL=127
} status_t;

typedef enum
{
   AP_LEFT_HAND,
   AP_RIGHT_HAND,
   AP_EYES,
   AP_LEGS,
   AP_MAX
} ap_t;

typedef enum
{
   TABLE_HANDS,
   TABLE_LEGS,
   TABLE_EYES,
   TABLE_MAX /* This should always be last */
} table_t;

typedef struct body body_t;
typedef struct connection conn_t;

struct body
{
   status_t eStatus;
   conn_t*  pstConn;
   body_t*  pstOpponent;
   char     a_chName[16];
   char     a_chPassword[16];
   char     a_chTechniques[AP_MAX][MAX_TECHNIQUES+1];
   char  *  szPrompt;
   int      iStats[5];
   sex_t    eSex;
   int      iRoom;
   int      iWin;
   int      iLoss;
   int      iKill;
   int      iDam;
   table_t  eTable[AP_MAX];     /* Combat table being used     */
   int      iCmbtIndex[AP_MAX]; /* Index of combat table       */
   int      iSpeed[AP_MAX];     /* Speed per location.         */
   int      iActions[AP_MAX];   /* Action points per location. */
   bool     bBusy[AP_MAX];      /* Is the hand/legs/eyes busy? */
   void (*  pfnAttack[AP_MAX])( body_t* pstBody, ap_t eLocation );
   body_t*  pstPrev;
   body_t*  pstNext;
};

struct connection
{
   body_t*  pstBody;
   char     a_chInBuf[MAX_BUF];
   char     a_chOutBuf[MAX_BUF];
   int      iSocket;
   int      iInLen;
   int      iOutLen;
   int      iIp;
   conn_t*  pstPrev;
   conn_t*  pstNext;
};

/******************************************************************************
 Required global variables.
 ******************************************************************************/

extern body_t     stBodyEmpty;   /* Empty body structure for initialisation */
extern conn_t     stConnEmpty;   /* Empty connection structure for initialisation */
extern conn_t     *pstFirstConn; /* Connection list */
extern body_t     *pstFirstBody; /* Body list */
extern fd_set      a_sFd;        /* Array of socket flags */
extern bool        bShutdown;    /* When TRUE, shut mud down */
extern FILE       *pFile;        /* File pointer */

/******************************************************************************
 Required operation prototypes.
 ******************************************************************************/

/* Socket functions */
int    InitSocket       ( void );
void   CloseSocket      ( int iSocket );

/* Input functions */
bool    GetInput        ( conn_t* pstConn );
void    ParseInput      ( conn_t* pstConn );

/* Output functions */
void    PutOutput       ( conn_t* pstConn, out_t eOut, char*szTxt, ... );
void    SendToBody      ( body_t* pstBody, out_t eOut, char*szTxt, ... );
void    FlushOutput     ( conn_t* pstConn );
void    PutPrompt       ( conn_t* pstConn );

/* Connection functions */
bool    NewConnection   ( int     iSocket );
void    CloseConnection ( conn_t* pstConn );

#endif /* SOCKETS_HEADER */
