/******************************************************************************
 Copyright 1999-2001 Richard Woolcock.  All rights reserved.  This software may
 only be used, copied, modified, distributed or sub-licensed under the terms of
 the Glad license, which must always be included with any distributions of this
 software.  This copyright notice must remain unmodified at the top of any file
 containing any of the code found within this file.
 ******************************************************************************/

/******************************************************************************
 File Name        : string.h
 ******************************************************************************
 Description      : Contains the string manipulation functions.
 ******************************************************************************
 Revision History :

 Date/Author : DD-MMM-YYYY   <author's name>
 Description : <description of change>

 Date/Author : 15-Jan-2001   Richard Woolcock (aka KaVir).
 Description : Initial version for Glad 2.0a.
 ******************************************************************************/

#ifndef STRING_HEADER
#define STRING_HEADER

/******************************************************************************
 Required types.
 ******************************************************************************/

typedef enum
{
   CMP_LESS    = -1,
   CMP_EQUAL   = 0,
   CMP_GREATER = 1
} cmp_t;

/******************************************************************************
 Required operation prototypes.
 ******************************************************************************/

char * ChopToken     ( char     * * pszTxt );
cmp_t  StringCompare ( const char * kszFirst, const char * kszSecond );
bool   StringPrefix  ( char       * szPart,   char       * szWhole );
bool   StringInfix   ( char       * szPart,   char       * szWhole );
bool   StringPostfix ( char       * szPart,   char       * szWhole );
bool   StringAlpha   ( char       * szTxt );
char * GetBar        ( char       * szTxt );

#endif /* STRING_HEADER */
