#include <stdio.h>
#include "defs.h"
#if	defined (WIN32)
#	include <compat/compat.h>
#else
#	include <dirent.h>
#endif
//#include "compat/compat.h"
#include "str.h"

#include "files.h"

int			line_number;

void xungetc(int c, FILE *fp);
int xgetc(FILE *fp);

const char *fread_string(FILE *fp)
{
	char buf[MAX_STRING_LENGTH];
	char *plast;
	int c;

	plast = buf;

	/*
	 * Skip blanks.
	 * Read first char.
	 */
	do
		c = xgetc(fp);
	while (isspace(c));

	for (;;) {
		/*
		 * Back off the char type lookup,
		 *   it was too dirty for portability.
		 *   -- Furey
		 */

		if (plast - buf >= sizeof(buf) - 1) {
			printf("fread_string: line too long (truncated)", 0);
			buf[sizeof(buf)-1] = '\0';
			return str_dup(buf);
		}

		switch (c) {
		default:
			*plast++ = c;
			break;

		case EOF:
			printf("fread_string:EOF");
			return str_empty;

		case '\r':
			break;

		case '~':
			if ((c = xgetc(fp)) == '~') {
				*plast++ = c;
				break;
			}
			xungetc(c, fp);
			*plast = '\0';
			return str_dup(buf);
		}
		c = xgetc(fp);
	}
}

char * fread_word (FILE * fp)
{
    static char word [MAX_INPUT_LENGTH] ;
    char * pword ;
    char   cEnd  ;

    do cEnd = xgetc(fp) ;
    while (cEnd && isspace(cEnd)) ;

    if (cEnd == EOF) return NULL ;

    if (cEnd == '\'' || cEnd == '"')
        pword   = word ;
    else
    {
        word[0] = cEnd     ;
        pword   = word + 1 ;
        cEnd    = ' '      ;
    }

    for (; pword < word + MAX_INPUT_LENGTH ; pword++)
    {
        *pword = xgetc (fp) ;

        if (*pword == EOF)
        {
            *pword = '\0' ;
            return word ;
        }

        if ((cEnd == ' ') ? isspace(*pword) : (*pword == cEnd))
        {
            if (cEnd == ' ') xungetc (*pword, fp) ;

		    *pword = '\0' ;
		    return word ;
		}
	}

	printf ("fread_word: word too long") ;
	return NULL ;
}

char fread_letter(FILE *fp)
{
    char c ;

    do c = xgetc(fp) ;
    while (c != EOF && isspace(c)) ;

    return c ;
}

void fread_to_eol (FILE * fp)
{
    char c ;

    do c = xgetc(fp) ;
    while (c != EOF && c != '\n' && c != '\r') ;

    if (c == EOF) return ;

    do c = xgetc(fp) ;
    while (c == '\n' || c == '\r') ;

    if (c == EOF) return ;

	xungetc(c, fp) ;
	return ;
}

int xgetc(FILE *fp)
{
	int c = getc(fp);
	if (c == '\n')
		line_number++;
	return c;
}

void xungetc(int c, FILE *fp)
{
	if (c == '\n')
		line_number--;
	ungetc(c, fp);
}

int fread_number(FILE *fp)
{
	int number;
	bool sign;
	char c;

	do
		c = xgetc(fp);
	while (isspace(c));

	number = 0;

	sign   = FALSE;
	if (c == '+')
		c = xgetc(fp);
	else if (c == '-') {
		sign = TRUE;
		c = xgetc(fp);
	}

	if (!isdigit(c)) {
		printf("fread_number: bad format");
		exit(1);
	}

	while (isdigit(c)) {
		number = number * 10 + c - '0';
		c      = xgetc(fp);
	}

	if (sign)
		number = 0 - number;

	if (c == '|')
		number += fread_number(fp);
	else if (c != ' ')
		xungetc(c, fp);

	return number;
}