#ifndef _STR_H_
#define _STR_H_

const char *	str_dup		(const char *str);
const char *	str_add		(const char *str,...);
void		free_string	(const char *str);
const char *	str_printf	(const char *format,...);

extern char	str_empty[1];
	
char *	strnzcpy(char *dest, const char *src, size_t);
char *	strnzcat(char *dest, const char *src, size_t);
char *	strnzncat(char *dest, const char *src, size_t len, size_t count);
char *fmt_color_str(const char *txt, int max);
char * fmt_wrap_str(char * txt, int len, const char * pad);

#if !defined (WIN32)
char *	strlwr(const char *s);
#endif

int	str_cmp		(const char *astr, const char *bstr);
int	str_ncmp	(const char *astr, const char *bstr, size_t len);
bool	str_prefix	(const char *astr, const char *bstr);
bool	str_infix	(const char *astr, const char *bstr);
bool	str_suffix	(const char *astr, const char *bstr);

int hashstr(const char *s, int maxn, int hashs);

int cmpstr(const void*, const void*);

#endif
