/* $Id: act_comm.c,v 1.666 2004/09/20 10:49:45 shrike Exp $                         */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>

#if !defined (WIN32)
#include <unistd.h>
#include <sys/time.h>
#endif

#include "merc.h"
#include "quest.h"
#include "gquest.h"
#include "mob_prog.h"
#include "obj_prog.h"
#include "auction.h"
#include "fight.h"
#include "skills.h"
#include "db/lang.h"
#include "db/gsn.h"
#include "riddle.h"
#include "wanderers.h"

/* command procedures needed  */
DECLARE_DO_FUN(do_quit      );
DECLARE_DO_FUN(do_quit_count    );
DECLARE_DO_FUN(do_replay    );
DECLARE_DO_FUN(do_look      );
DECLARE_DO_FUN(do_help      );

void toast_evil_cheating_bastards   (int id);
void links_pull     (CHAR_DATA *ch);
void do_quit_org    (CHAR_DATA *ch, const char *argument, bool Count);
void agent_net_printf   (CHAR_DATA *ch, CHAR_DATA *victim, int);

extern STAT_DATA stat_record;
extern void wq_quit (CHAR_DATA * ch);

const char *fread_string_eol(FILE *fp);
extern void start_find_master (CHAR_DATA * ch);
extern FILE *fpReserve;

void char_flags_to_string_lo(CHAR_DATA *ch, BUFFER *buf) {

    if (IS_AFFECTED(ch, AFF_INVIS))     buf_add(buf, "(Inv)");
    if (IS_AFFECTED(ch, AFF_HIDE))      buf_add(buf, "(Hide)");
    if (IS_AFFECTED(ch, AFF_CHARM))     buf_add(buf, "(Charm)");
    if (IS_AFFECTED(ch, AFF_IMP_INVIS))     buf_add(buf, "(Imp_inv)");
    if (IS_AFFECTED(ch, AFF_FADE))      buf_add(buf, "(Fade)");
    if (IS_AFFECTED(ch, AFF_CAMOUFLAGE))    buf_add(buf, "(Cam)");
    if (IS_AFFECTED(ch, AFF_TRAP))      buf_add(buf, "(Trap)");

    if (IS_SET(ch->form, FORM_VAMPIRE))       buf_add(buf, "(Vamp)");
    if (IS_SET(ch->form, FORM_MECH))          buf_add(buf, "(Mech)");
    if (IS_SET(ch->form, FORM_DEMON_FIRE))    buf_add(buf, "(DFire)");
    if (IS_SET(ch->form, FORM_DEMON_EARTH))   buf_add(buf, "(DEarth)");
    if (IS_SET(ch->form, FORM_DEMON_WATER))   buf_add(buf, "(DWater)");
    if (IS_SET(ch->form, FORM_DEMON_AIR))     buf_add(buf, "(DAir)");
    
    if ((ch->doppel != NULL) && (ch->doppel != ch)) {
        if (ch->doppel->name != NULL) {
        buf_add(buf, "(Doppel: ");
        buf_add(buf, ch->doppel->name);
        buf_add(buf, ")");
        }
        else
        log_printf("char_flag_to_string_lo: NULL doppel name, ch %s", ch->name);
    }

    if (IS_IMMORTAL(ch))            buf_add(buf,"(Imm)");
    if (ch->invis_level >= LEVEL_HERO)  buf_add(buf,"(Wizi)");
    
}

void do_cutreply (CHAR_DATA * ch, const char * argument)
{
    CHAR_DATA * victim ;
    char        arg [MAX_INPUT_LENGTH] ;

    argument = one_argument(argument, arg, sizeof(arg));

    if ((victim = get_char_world_ext(ch, arg, GET_F_NO_CHECK_CAN_SEE)))
    {
        if (victim->reply == ch)
        {
            victim->reply = NULL;
            act_puts("Replay is cut for $N.", ch, NULL, victim, TO_CHAR, POS_DEAD);
        }

        if (victim->repeat == ch)
        {
            victim->repeat = NULL;
            act_puts("Repeat is cut for $N.", ch, NULL, victim, TO_CHAR, POS_DEAD);
        }

        return ;
    }
  
    for (victim = char_list ; victim != NULL ; victim = victim->next)
    {
        if (victim->reply == ch) 
        {
            victim->reply = NULL;  
            act_puts("Replay is cut for $N.", ch, NULL, victim, TO_CHAR, POS_DEAD);
        }

        if (victim->repeat == ch)
        {
            victim->repeat = NULL;
            act_puts("Repeat is cut for $N.", ch, NULL, victim, TO_CHAR, POS_DEAD);
        }
    }
}


DO_FUN(do_afk)
{
    if (IS_SET(ch->comm, COMM_AFK))
        do_replay(ch, str_empty);
    else
        act("You are in {MAFK{x mode now.", ch, NULL, NULL, TO_CHAR);
    TOGGLE_BIT(ch->comm, COMM_AFK);
}

DO_FUN(do_peacefu)
{
    act("{WAttention! If you want to proceed in mode NO_PK you should enter a command completely.{x", ch, NULL, NULL, TO_CHAR);
}

DO_FUN(do_peaceful)
{
    int clan;

    if (IS_NPC(ch))
    {
        act("Huh?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    clan = ch->clan;

    if (clan && ch->clan)
    {
        act("But you are clanmember!!!", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_AFFECTED(ch, AFF_CHARM))
    {
        act("You should be free for charm to become peacefull!",
            ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_SET(ch->comm, PLR_PEACE))
    {
        act("You are already the most peace player in the world.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    TOGGLE_BIT(ch->comm, PLR_PEACE);
    act("You are in {RNO_PK{z mode now!", ch, NULL, NULL, TO_CHAR);
    info(ch, 0, "{r[{RINFO{r]{W : %s activate {GPeaceful{z mode.{x\n", ch->name);
// wiznet_printf (ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0, "%s   {MPEACEFUL{z.\n", ch->name);
    if (ch->pcdata->headprice > 0)
        ch->pcdata->headprice = 0;

    save_char_obj (ch, FALSE, FALSE);
}

/* RT code to delete yourself */

DO_FUN(do_delet)
{
    char_act("You need to enter a command entirely to remove the character.", ch);
}

void do_delete (CHAR_DATA * ch, const char * argument)
{
    if (IS_NPC(ch)) return ;

    if (IS_IMMORTAL(ch) && !IS_TRUSTED(ch, IMPLEMENTOR))
    {
        char_act("    implementor    .\n,   ,      :)", ch);
        return ;
    }

    if (ch->level >= 30)
    {
        char_act("The players who have reached 30 levels, cannot remove the character.", ch);
        return ;
    }

    if (IS_SET(ch->plr_flags, PLR_CONFIRM_DELETE))
    {
        CLAN_MEMBER * member ;
        CLAN_MEMBER * prev   ;
        clan_t   * clan   ;

        char * name ;

        if (argument[0] != '\0')
        {
            act("Removing of the character is cancelled.", ch, NULL, NULL, TO_CHAR);
            REMOVE_BIT (ch->plr_flags, PLR_CONFIRM_DELETE);
            return ;
        }

        // remove from clanlist if this player was a clan member
        clan = CLAN (ch->clan);
        if (clan)
        {
            prev = NULL ;
            for (member = clan->member_list ; member ; prev = member, member = member->next)
            {
                if (str_cmp (member->name, ch->name)) continue ;
    
                // memory clean-up
                free_string (member->name);
                free_string (member->last_login);
    
                if (prev) prev->next   = member->next ;
                else clan->member_list = member->next ;
    
                --clan->cur_clan_members ;
    
                free (member);
                break ;
            }
        }

        wiznet ("$N has removed $gN{his} character.", ch, NULL, 0, 0, 0);
        RESET_FIGHT_TIME (ch);
        links_pull(ch);
        name = capitalize(ch->name);
        do_quit_count(ch, str_empty);
        dunlink (PLAYER_PATH, name);
        return ;
    }

    if (argument[0] != '\0')
    {
        act("Simply type 'delete' without any parameters.", ch, NULL, NULL, TO_CHAR);
        return ;
    }

    char_act(" 'delete'    .\n{R!{x      !\n '{Cdelete{x'   ,    .", ch); 
    SET_BIT (ch->plr_flags, PLR_CONFIRM_DELETE);
    wiznet  ("$N is going to remove $gn{his} character.", ch, NULL, 0, 0, ch->level);
}
        

/* RT code to display channel status */

DO_FUN(do_channels)
{
    /* lists all channels and their status */
    char_act("{R  channel     status{x", ch);
    char_act("{G--------------------{x", ch);
    
    act_puts("music          $t", ch, 
    !IS_SET(ch->comm, COMM_NOMUSIC) ?  "ON" : "OFF"
    , NULL, TO_CHAR | ACT_TRANS, POS_DEAD);
     
    act_puts("gossip         $t", ch,
     !IS_SET(ch->comm, COMM_NOGOSSIP) ?  "ON" : "OFF"
    , NULL, TO_CHAR | ACT_TRANS, POS_DEAD);
         
    act_puts("ooc            $t", ch,
     !IS_SET(ch->comm, COMM_NOOOC) ?  "ON" : "OFF"
    , NULL, TO_CHAR | ACT_TRANS, POS_DEAD);

    act_puts("hero           $t", ch,
     !IS_SET(ch->comm, COMM_NOHERO) ?  "ON" : "OFF"
    , NULL, TO_CHAR | ACT_TRANS, POS_DEAD);

    act_puts("chat           $t", ch,
     (IS_SET(ch->comm, COMM_CHAT)) ?  "ON" : "OFF"
    , NULL, TO_CHAR | ACT_TRANS, POS_DEAD);

    act_puts("auction        $t", ch,
     !IS_SET(ch->comm, COMM_NOAUCTION) ?  "ON" : "OFF"
    , NULL, TO_CHAR | ACT_TRANS, POS_DEAD);

    act_puts("ask/answer     $t", ch,
     !IS_SET(ch->comm, COMM_NOASK) ?  "ON" : "OFF"
    , NULL, TO_CHAR | ACT_TRANS, POS_DEAD);

    act_puts("humor          $t", ch,
     !IS_SET(ch->comm, COMM_NOHUMOR) ?  "ON" : "OFF"
    , NULL, TO_CHAR | ACT_TRANS, POS_DEAD);

    if (IS_IMMORTAL(ch)) {
        act_puts("god channel    $t", ch,
         !IS_SET(ch->comm,COMM_NOWIZ) ?  "ON" : "OFF"
    , NULL, TO_CHAR | ACT_TRANS, POS_DEAD);
    }

    act_puts("tells          $t", ch,
     !IS_SET(ch->comm, COMM_DEAF) ?  "ON" : "OFF"
    , NULL, TO_CHAR | ACT_TRANS, POS_DEAD);

    act_puts("quiet mode     $t", ch,
     IS_SET(ch->comm, COMM_QUIET) ?  "ON" : "OFF"
    , NULL, TO_CHAR | ACT_TRANS, POS_DEAD);

    char_act("{G--------------------{x", ch);
    char_act("{R information    :{x", ch);

    if (IS_SET(ch->comm, COMM_NOSEND))
        char_act("You do not receive a parcel.", ch);

    if (IS_SET(ch->comm, COMM_NOGIVE))
        char_act("You do not accept objects from others.", ch);

    if (IS_SET(ch->comm, COMM_SNOOP_PROOF))
        char_act("You are impregnable for snooping.", ch);
    
    act_puts("  $j $qj{}  .", ch, (const void*) (ch->lines+2), NULL, TO_CHAR, POS_DEAD);

    if (IS_SET(ch->comm, COMM_NOTELL))
         char_act("    'tell'.", ch);
    
    if (IS_SET(ch->comm, COMM_NOCHANNELS))
        char_act("     .", ch);

    if (IS_SET(ch->comm, COMM_NOEMOTE))
         char_act("    'emotions'.", ch);
}

DO_FUN(do_deaf)
{
    if (IS_SET(ch->comm,COMM_DEAF)) {
        act("  ,   .", ch, NULL, NULL, TO_CHAR);
        REMOVE_BIT(ch->comm, COMM_DEAF);
    }
    else {
        act("   ,   .", ch, NULL, NULL, TO_CHAR);
        SET_BIT(ch->comm, COMM_DEAF);
    }
}

/* RT quiet blocks out all communication */

DO_FUN(do_quiet)
{
    if (IS_SET(ch->comm,COMM_QUIET)) {
         act("' ' .", ch, NULL, NULL, TO_CHAR);
         REMOVE_BIT(ch->comm, COMM_QUIET);
    }
    else {
        act("    'say'  'emote'.", ch, NULL, NULL, TO_CHAR);
        SET_BIT(ch->comm, COMM_QUIET);
    }
}

DO_FUN(do_replay)
{
    if (IS_NPC(ch)) {
        act("   .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    page_to_char(buf_string(ch->pcdata->buffer), ch);
    buf_clear(ch->pcdata->buffer);
}

const char *garble(CHAR_DATA *ch, const char *i)
{
    static char not_garbled[] = "?!()[]{},.:;'\" ";
    static char buf[MAX_STRING_LENGTH];
    char *o;

    if (!is_affected(ch, gsn_garble))
        return i;

    for (o = buf; *i && o-buf < sizeof(buf)-1; i++, o++) {
        if (strchr(not_garbled, *i))
            *o = *i;
        else
            *o = number_range(' ', 254);
    }
    *o = '\0';
    return buf;
}

DO_FUN(do_say)
{
    OBJ_DATA *obj;
    OBJ_INDEX_DATA *riddle_obj;
  
    if (argument[0] == '\0') 
    {
        act(" ?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    // riddle portal stuff
    for (obj = ch->in_room->contents; obj != NULL; obj = obj->next_content) 
    {
        if ((obj->pIndexData->item_type == ITEM_PORTAL) &&
            (obj->pIndexData->riddle))
        {
            riddle_obj = get_obj_index(obj->pIndexData->riddle);
            if (!riddle_obj)
                break;

            if (is_name(argument, riddle_lookup(riddle_obj->value[2])->answer))
            {
                //char_printf(ch, "You can enter %s!\n", mlstr_cval(obj->short_descr,ch));
                enter_portal(ch, obj);
                return;
            }
        }
    }

    act_say(ch, "$t", argument);
}

void do_tell_raw(CHAR_DATA *ch, CHAR_DATA *victim, const char *msg)
{
    if (IS_SET(ch->comm, COMM_NOTELL)) {
        char_act("    .", ch);
        return;
    }
    
    if (victim == NULL 
    || (IS_NPC(victim) && victim->in_room != ch->in_room)) {
        char_act("  .", ch);
        return;
    }

    if (IS_SET(victim->comm, (COMM_QUIET | COMM_DEAF))
    &&  !IS_IMMORTAL(ch) && !IS_IMMORTAL(victim)) {
        act_puts("$N   .", ch, NULL, victim, TO_CHAR, POS_DEAD);
        return;
    }

    act_tell("$t", ch, msg, victim);

}

DO_FUN(do_tell)
{
    char arg[MAX_INPUT_LENGTH];

    argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0' || argument[0] == '\0') 
    {
        act(" ? ?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    do_tell_raw(ch, get_char_world(ch, arg), argument);
}

DO_FUN(do_reply)
{
    do_tell_raw(ch, ch->reply, argument);
}

DO_FUN(do_repeat)
{
    do_tell_raw(ch, ch->repeat, argument);
}

DO_FUN(do_gtell)
{
    CHAR_DATA *gch;
    int i;
    int flags;
    char arg[MAX_INPUT_LENGTH]; 

    if (argument[0] == '\0') {
        act("     ?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_SET(ch->comm, COMM_NOTELL)) {
        act("    !", ch, NULL, NULL, TO_CHAR);
        return;
    }

    argument = garble(ch, argument);
    flags = TO_VICT | ACT_TOBUF | ACT_SPEECH(ch);
    for (i = 0, gch = char_list; gch; gch = gch->next) {
        if (is_same_group(gch, ch)) 
        {
            act_puts("$n  : '{G$t{x'", ch, argument, gch, flags, POS_DEAD);

            if ((!str_cmp (argument,"where are you?")) ||
                (!str_cmp (argument,"where")) ||
                (!str_cmp (argument," ?")) ||
                (!str_cmp (argument,"")))
            {
                if ((!IS_NPC(ch)) &&
                    (IS_SET(ch->pcdata->wishes, WISH_GROUP)) &&
                    (IS_NPC(gch)) &&
                    (IS_AFFECTED(gch,AFF_CHARM)) && 
                    (gch->master == ch))
                {
                    if (IS_AFFECTED(gch, AFF_BLIND))
                        do_gtell (gch, GETMSG ("Master, I can not see!", ch->lang));
                    else if (gch->in_room == ch->in_room)
                        do_gtell (gch, GETMSG ("Master, I am near you!", ch->lang));
                    else 
                    {
                        sprintf (arg, GETMSG ("Master, I'm in %s!", ch->lang), mlstr_cval(gch->in_room->name, ch));
                        do_gtell (gch, arg);
                    }
                }
            }
            else if (!str_cmp (argument, "goto me") || !str_cmp (argument, "find me"))
            {
                if (IS_NPC (gch) && gch->master == ch && IS_SET (gch->abilities, EA_AUTO_FIND))
                {
                    if (IS_AFFECTED(gch, AFF_BLIND))
                        do_gtell (gch, GETMSG ("Master, I can not see!", ch->lang));
                    else
                        SET_BIT (gch->actions, CA_AUTO_FIND);
                }
            }
            else if (!str_cmp (argument, "link"))
            {
                if (IS_NPC (gch) && gch->master == ch && IS_SET (gch->abilities, EA_MANA_LINK)
                    && gch->in_room == ch->in_room)
                {
                    ch->mana += gch->mana / 5;
                    gch->mana = 0;
                    act("$n transfers $gn{his} mana to $N.", gch, NULL, ch, TO_ROOM | TO_NOTVICT);
                    act("$n transfers $gn{his} mana to you.", gch, NULL, ch, TO_VICT);
                    ch->mana = UMIN (ch->mana, ch->max_mana);
                }
            }
            else if (!str_cmp (argument, "rescue"))
            {
                if (IS_NPC (gch) && gch->master == ch && IS_SET (gch->abilities, EA_AUTO_RESC))
                {
                    if (IS_SET (gch->actions, CA_CAN_RESCUE))
                    {
                        do_gtell (gch, GETMSG ("Yes, master! I will not try to rescue you!", ch->lang));
                        REMOVE_BIT (gch->actions, CA_CAN_RESCUE);
                    }
                    else
                    {
                        do_gtell (gch, GETMSG ("Yes, master! I will try to rescue you!", ch->lang));
                        SET_BIT (gch->actions, CA_CAN_RESCUE);
                    }
                }
            }
            i++;
        }
    }

    if (i > 1)
        act_puts("  : '{G$t{x'", ch, argument, NULL, TO_CHAR | ACT_SPEECH(ch), POS_DEAD);
    else
        act("  ()  .     .", ch, NULL, NULL, TO_CHAR);
}

DO_FUN(do_emote)
{
    if (!IS_NPC(ch) && IS_SET(ch->comm, COMM_NOEMOTE)) {
        act("     (emotions).", ch, NULL, NULL, TO_CHAR);
        return;
    }
    
    if (argument[0] == '\0') {
        act("Emote ?", ch, NULL, NULL, TO_CHAR);
        return;
    }
    
    argument = garble(ch, argument);
    act("$n $T", ch, NULL, argument,
        TO_ROOM | ACT_TOBUF | ACT_NOTRIG | ACT_NOTWIT);
    act("$n $T", ch, NULL, argument, TO_CHAR | ACT_NOTRIG);
}

DO_FUN(do_pmote)
{
    CHAR_DATA *vch;
    const char *letter,*name;
    char last[MAX_INPUT_LENGTH], temp[MAX_STRING_LENGTH];
    int matches = 0;
    int flags;

    if (!IS_NPC(ch) && IS_SET(ch->comm, COMM_NOEMOTE)) {
        act("     (emotions).", ch, NULL, NULL, TO_CHAR);
        return;
    }
    
    if (argument[0] == '\0') {
        act("Emote ?", ch, NULL, NULL, TO_CHAR);
        return;
    }
    
    argument = garble(ch, argument);
    act("$n $t", ch, argument, NULL, TO_CHAR);

    flags = TO_CHAR | ACT_TOBUF | ACT_NOTWIT | ACT_NOTRIG;

    for (vch = ch->in_room->people; vch != NULL; vch = vch->next_in_room) {
        if (vch->desc == NULL || vch == ch)
            continue;

        if ((letter = strstr(argument, vch->name)) == NULL) {
            act("$N $t", vch, argument, ch, flags);
            continue;
        }

        strnzcpy(temp, sizeof(temp),argument);
        temp[strlen(argument) - strlen(letter)] = '\0';
        last[0] = '\0';
        name = vch->name;
    
        for (; *letter != '\0'; letter++) { 
            if (*letter == '\'' && matches == strlen(vch->name)) {
                strnzcat(temp, sizeof(temp), "r");
                continue;
            }

            if (*letter == 's' && matches == strlen(vch->name)) {
                matches = 0;
                continue;
            }
        
            if (matches == strlen(vch->name))
                matches = 0;

            if (*letter == *name) {
                matches++;
                name++;
                if (matches == strlen(vch->name)) {
                    strnzcat(temp, sizeof(temp), "you");
                    last[0] = '\0';
                    name = vch->name;
                    continue;
                }
                strnzncat(last, sizeof(last), letter,1);
                continue;
            }

            matches = 0;
            strnzcat(temp, sizeof(temp), last);
            strnzncat(temp, sizeof(temp), letter,1);
            last[0] = '\0';
            name = vch->name;
        }

        act("$N $t", vch, temp, ch, flags);
    }
}

DO_FUN(do_immtalk)
{
    DESCRIPTOR_DATA *d;

    if (argument[0] == '\0') {
        TOGGLE_BIT(ch->comm, COMM_NOWIZ);
        if (IS_SET(ch->comm, COMM_NOWIZ))
            act("Immortal channel is now OFF", ch, NULL, NULL, TO_CHAR);
        else
            act("Immortal channel is now ON", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_SET(ch->comm, COMM_NOCHANNELS)) {
        act("     .", ch, NULL, NULL, TO_CHAR);
        return;
    }
    
    if (IS_SET(ch->comm, COMM_NOWIZ))
        do_immtalk(ch, str_empty);

    act_puts("$n: {C$t{x", ch, argument, NULL, TO_CHAR, POS_DEAD);
    for (d = descriptor_list; d; d = d->next) {
        CHAR_DATA *victim = d->original ? d->original : d->character;

        if (d->connected == CON_PLAYING
        &&  IS_IMMORTAL(victim)
        &&  !IS_SET(victim->comm, COMM_NOWIZ))
            act_puts("$n: {C$t{x", ch, argument, d->character, TO_VICT | ACT_TOBUF, POS_DEAD);
    }
}

DO_FUN(do_devtalk)
{
    DESCRIPTOR_DATA *d;

    if (argument[0] == '\0') {
        TOGGLE_BIT(ch->comm, COMM_DEV);
        if (IS_SET(ch->comm, COMM_DEV))
            act("Developers channel is now ON", ch, NULL, NULL, TO_CHAR);
        else
            act("Developers channel is now OFF", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!IS_SET(ch->comm, COMM_DEV))
        do_devtalk(ch, str_empty);

    act_puts("$n: {W[{CDEV{W] {C$t{x", ch, argument, NULL, TO_CHAR, POS_DEAD);
    for (d = descriptor_list; d; d = d->next) {
        CHAR_DATA *victim = d->original ? d->original : d->character;

        if (d->connected == CON_PLAYING
            &&  IS_SET(victim->comm, COMM_DEV))
            act_puts("$n: {W[{CDEV{W] {C$t{x", ch, argument, d->character, TO_VICT | ACT_TOBUF, POS_DEAD);
    }
}

DO_FUN(do_btalk)
{
    DESCRIPTOR_DATA *d;

    if (argument[0] == '\0') {
        TOGGLE_BIT(ch->comm, COMM_BTALK);
        if (IS_SET(ch->comm, COMM_BTALK))
            act("Builders channel is now ON", ch, NULL, NULL, TO_CHAR);
        else
            act("Builders channel is now OFF", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!IS_SET(ch->comm, COMM_BTALK))
        do_btalk(ch, str_empty);

    act_puts("$n: {W[{CBTALK{W] {C$t{x", ch, argument, NULL, TO_CHAR, POS_DEAD);
    for (d = descriptor_list; d; d = d->next) {
        CHAR_DATA *victim = d->original ? d->original : d->character;

        if (d->connected == CON_PLAYING
            &&  IS_SET(victim->comm, COMM_BTALK))
            act_puts("$n: {W[{CBTALK{W] {C$t{x", ch, argument, d->character, TO_VICT | ACT_TOBUF, POS_DEAD);
    }
}

DO_FUN(do_yell)
{
    if (IS_SET(ch->comm, COMM_NOCHANNELS)) {
         char_act("     .", ch);
         return;
    }
    if (argument[0] == '\0') {
        char_act(" ?", ch);
        return;
    }

    act_yell(ch, "$t", argument, NULL);
}

DO_FUN(do_shout)
{
    DESCRIPTOR_DATA *d;
    BUFFER *buf=NULL;
    
    if (IS_NPC(ch) && IS_AFFECTED(ch, AFF_CHARM))
        return;

    if (argument[0] == '\0') {
                act("   ?", ch, NULL, NULL, TO_CHAR);
                  return;
        }

    if (IS_SET(ch->comm, COMM_NOCHANNELS)) {
         act("     .", ch, NULL, NULL, TO_CHAR);
         return;
    }

    argument = garble(ch, argument);
    act_puts("  '{R$t{x'", ch, argument, NULL, TO_CHAR | ACT_NODEAF, POS_DEAD);

    for (d = descriptor_list; d; d = d->next) {
        if (d->connected == CON_PLAYING
        &&  d->character != ch) 
            act_puts("$n  '{R$t{x'", ch, argument, d->character, TO_VICT | ACT_NOTWIT | ACT_STRANS | ACT_NODEAF, POS_DEAD);
    }
/* Edited by Simon. Log shout to file */
    if (!IS_NPC(ch)) {
        buf = buf_new(-1);
        char_flags_to_string_lo(ch, buf);
        log_channels("Shout: [%s] %s '%s'", buf_string(buf), ch->name, argument);
        buf_free(buf);
    }
}

DO_FUN(do_ooc)
{
    DESCRIPTOR_DATA *d;
    BUFFER *buf=NULL;
    const char *str;

    if (IS_NPC(ch) && IS_AFFECTED(ch, AFF_CHARM))
        return;

    if (argument[0] == '\0') {
        TOGGLE_BIT(ch->comm, COMM_NOOOC);
        if (IS_SET(ch->comm, COMM_NOOOC))
            act("    OOC.", ch, NULL, NULL, TO_CHAR);
        else 
            act("   OOC.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_SET(ch->comm, COMM_NOCHANNELS)) {
         act("     .", ch, NULL, NULL, TO_CHAR);
         return;
    }
    
    if (IS_SET(ch->comm, COMM_NOOOC))
        do_ooc(ch, str_empty);
    WAIT_STATE(ch, PULSE_VIOLENCE);

    argument = garble(ch, argument);
    act_puts("{Y[OOC]{x  : '{y$t{x'", ch, argument, NULL, TO_CHAR, POS_DEAD);

    for (d = descriptor_list; d; d = d->next) {
        if (d->connected == CON_PLAYING
        &&  d->character != ch
        &&  !IS_SET(d->character->comm, COMM_NOOOC))
        {
            if (IS_IMMORTAL(ch) && !can_see(d->character, ch))
                str = "{Y[OOC]{z $gn{} '{y$t{x'";
            else
                str = "{Y[OOC]{z $U '{y$t{x'";
    
            act_puts3(str, ch, argument, d->character, ch->name, TO_VICT | ACT_NOTWIT, POS_DEAD);
        }
    }
/* Edited by Simon. Log music to file. */
    if (!IS_NPC(ch)) {
        buf = buf_new(-1);
        char_flags_to_string_lo(ch, buf);
        log_channels("OOC: [%s] %s '%s'", buf_string(buf), ch->name, argument);
        buf_free(buf);
    }
}


DO_FUN(do_herotalk)
{
    DESCRIPTOR_DATA *d;
    BUFFER *buf=NULL;
    const char *str;

    if (IS_NPC(ch) && IS_AFFECTED(ch, AFF_CHARM))
        return;

    if ((ch->level) < 81)
        return;

    if (argument[0] == '\0') {
        TOGGLE_BIT(ch->comm, COMM_NOHERO);
        if (IS_SET(ch->comm, COMM_NOHERO))
            act("    HEROTALK.", ch, NULL, NULL, TO_CHAR);
        else 
            act("   HEROTALK.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_SET(ch->comm, COMM_NOCHANNELS)) {
         act("     .", ch, NULL, NULL, TO_CHAR);
         return;
    }
    
    if (IS_SET(ch->comm, COMM_NOHERO) || ((ch->level) < 81))
        do_herotalk(ch, str_empty);
    WAIT_STATE(ch, PULSE_VIOLENCE);

    argument = garble(ch, argument);
    act_puts("{C[{WHERO{C]{x  {W: '{G$t{x'", ch, argument, NULL, TO_CHAR, POS_DEAD);

    for (d = descriptor_list; d; d = d->next) {
        if (d->connected == CON_PLAYING
        &&  d->character != ch
        &&  (d->character->level > 80)
        &&  !IS_SET(d->character->comm, COMM_NOHERO))
        {
            if (IS_IMMORTAL(ch) && !can_see(d->character, ch))
                str = "{C[{WHERO{C]{x $gn{} '{G$t{x'";
            else
                str = "{C[{WHERO{C]{x $U '{G$t{x'";
            act_puts3(str, ch, argument, d->character, ch->name, TO_VICT | ACT_NOTWIT, POS_DEAD);

        }
    }
/* Edited by Simon. Log music to file. */
    if (!IS_NPC(ch)) {
        buf = buf_new(-1);
        char_flags_to_string_lo(ch, buf);
        log_channels("HERO: [%s] %s '%s'", buf_string(buf), ch->name, argument);
        buf_free(buf);
    }
}

DO_FUN(do_chat)
{
    DESCRIPTOR_DATA *d;
    BUFFER *buf=NULL;
    const char *str;

    if (IS_NPC(ch) && IS_AFFECTED(ch, AFF_CHARM))
        return;

    if (argument[0] == '\0') {
        TOGGLE_BIT(ch->comm, COMM_CHAT);
        if (!IS_SET(ch->comm, COMM_CHAT))
            act("    CHAT.", ch, NULL, NULL, TO_CHAR);
        else 
            act("   CHAT.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!IS_SET(ch->comm, COMM_CHAT))
        do_chat(ch, str_empty);
    WAIT_STATE(ch, PULSE_VIOLENCE);

    argument = garble(ch, argument);
    act_puts("{m[{MCHAT{m]{x  {x: '{M$t{x'", ch, argument, NULL, TO_CHAR | ACT_NODEAF, POS_DEAD);

    for (d = descriptor_list; d; d = d->next) {
        if (d->connected == CON_PLAYING
        &&  d->character != ch
        &&  IS_SET(d->character->comm, COMM_CHAT))
        {
            if (IS_IMMORTAL(ch) && !can_see(d->character, ch))
                str = "{m[{MCHAT{m]{x $gn{} '{M$t{x'";
            else
                str = "{m[{MCHAT{m]{x $U '{M$t{x'";
            act_puts3(str, ch, argument, d->character, ch->name, TO_VICT | ACT_NOTWIT, POS_DEAD);
        }
    }
    if (!IS_NPC(ch)) {
        buf = buf_new(-1);
        char_flags_to_string_lo(ch, buf);
        log_channels("CHAT: [%s] %s '%s'", buf_string(buf), ch->name, argument);
        buf_free(buf);
    }
}

DO_FUN(do_music)
{
    DESCRIPTOR_DATA *d;
    BUFFER *buf=NULL;

    if (IS_NPC(ch) && IS_AFFECTED(ch, AFF_CHARM))
        return;

    if (argument[0] == '\0') {
        TOGGLE_BIT(ch->comm, COMM_NOMUSIC);
        if (IS_SET(ch->comm, COMM_NOMUSIC))
            act("    .", ch, NULL, NULL, TO_CHAR);
        else 
            act("   .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_SET(ch->comm, COMM_NOCHANNELS)) {
         act("     .", ch, NULL, NULL, TO_CHAR);
         return;
    }
    
    if (IS_SET(ch->comm, COMM_NOMUSIC))
        do_music(ch, str_empty);
    WAIT_STATE(ch, PULSE_VIOLENCE);

    argument = garble(ch, argument);
    act_puts(" ϣ: '{c$t{x'", ch, argument, NULL, TO_CHAR | ACT_NODEAF, POS_DEAD);

    for (d = descriptor_list; d; d = d->next) {
        if (d->connected == CON_PLAYING
        &&  d->character != ch
        &&  !IS_SET(d->character->comm, COMM_NOMUSIC))
            act_puts("$n ϣ: '{c$t{x'", ch, argument, d->character, TO_VICT | ACT_SPEECH(ch), POS_DEAD);
    }
/* Edited by Simon. Log music to file. */
    if (!IS_NPC(ch)) {
        buf = buf_new(-1);
        char_flags_to_string_lo(ch, buf);
        log_channels("Music: [%s] %s '%s'", buf_string(buf), ch->name, argument);
        buf_free(buf);
    }
}

DO_FUN(do_ask)
{
    DESCRIPTOR_DATA *d;
    BUFFER *buf;

    if (IS_NPC(ch) && IS_AFFECTED(ch, AFF_CHARM))
        return;

    if (argument[0] == '\0') {
        TOGGLE_BIT(ch->comm, COMM_NOASK);
        if (IS_SET(ch->comm, COMM_NOASK))
            act("      .", ch, NULL, NULL, TO_CHAR);
        else 
            act("     .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_SET(ch->comm, COMM_NOCHANNELS)) {
         act("     .", ch, NULL, NULL, TO_CHAR);
         return;
    }
    
    if (IS_SET(ch->comm, COMM_NOASK))
        do_ask(ch, str_empty);
    WAIT_STATE(ch, PULSE_VIOLENCE);

    argument = garble(ch, argument);
    act_puts(" : '{B$t{x'", ch, argument, NULL, TO_CHAR | ACT_NODEAF, POS_DEAD);

    for (d = descriptor_list; d; d = d->next) {
        if (d->connected == CON_PLAYING
        &&  d->character != ch
        &&  !IS_SET(d->character->comm, COMM_NOASK))
            act_puts("$n : '{B$t{x'", ch, argument, d->character, TO_VICT | ACT_SPEECH(ch), POS_DEAD);
    }
/* Edited by Simon. Log ask to file */
    if (!IS_NPC(ch)) {
        buf = buf_new(-1);
        char_flags_to_string_lo(ch, buf);
        log_channels("Ask: [%s] %s '%s'", buf_string(buf), ch->name, argument);
        buf_free(buf);
    }
}

DO_FUN(do_answer)
{
    DESCRIPTOR_DATA *d;
    BUFFER *buf;

    if (IS_NPC(ch) && IS_AFFECTED(ch, AFF_CHARM))
        return;

    if (argument[0] == '\0') {
        TOGGLE_BIT(ch->comm, COMM_NOASK);
        if (IS_SET(ch->comm, COMM_NOASK))
            act("      .", ch, NULL, NULL, TO_CHAR);
        else 
            act("     .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_SET(ch->comm, COMM_NOCHANNELS)) {
         act("     .", ch, NULL, NULL, TO_CHAR);
         return;
    }
    
    if (IS_SET(ch->comm, COMM_NOASK))
        do_answer(ch, str_empty);
    WAIT_STATE(ch, PULSE_VIOLENCE);

    argument = garble(ch, argument);
    act_puts(" : '{B$t{x'", ch, argument, NULL, TO_CHAR | ACT_NODEAF, POS_DEAD);

    for (d = descriptor_list; d; d = d->next) {
        if (d->connected == CON_PLAYING
        &&  d->character != ch
        &&  !IS_SET(d->character->comm, COMM_NOASK))
            act_puts("$n : '{B$t{x'", ch, argument, d->character, TO_VICT | ACT_SPEECH(ch), POS_DEAD);
    }
/* Edited by Simon. Log answer to file */
    if (!IS_NPC(ch)) {
        buf = buf_new(-1);
        char_flags_to_string_lo(ch, buf);
        log_channels("Answer: [%s] %s '%s'", buf_string(buf), ch->name, argument);
        buf_free(buf);
    }
}

DO_FUN(do_humor)
{
    DESCRIPTOR_DATA *d;
    BUFFER *buf;

    if (IS_NPC(ch) && IS_AFFECTED(ch, AFF_CHARM))
        return;

    if (argument[0] == '\0') {
        TOGGLE_BIT(ch->comm, COMM_NOHUMOR);
        if (IS_SET(ch->comm, COMM_NOHUMOR))
            act("    .", ch, NULL, NULL, TO_CHAR);
        else 
            act("   .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_SET(ch->comm, COMM_NOCHANNELS)) {
         act("     .", ch, NULL, NULL, TO_CHAR);
         return;
    }
    
    if (IS_SET(ch->comm, COMM_NOHUMOR))
        do_humor(ch, str_empty);
    WAIT_STATE(ch, PULSE_VIOLENCE);

    argument = garble(ch, argument);
    act_puts(" : '{W$t{x'", ch, argument, NULL, TO_CHAR | ACT_NODEAF, POS_DEAD);

    for (d = descriptor_list; d; d = d->next) {
        if (d->connected == CON_PLAYING
        &&  d->character != ch
        &&  !IS_SET(d->character->comm, COMM_NOHUMOR))
            act_puts("$n : '{W$t{x'", ch, argument, d->character, TO_VICT | ACT_SPEECH(ch), POS_DEAD);
    }
/* Edited by Simon. Log humor to file */
    if (!IS_NPC(ch)) {
        buf = buf_new(-1);
        char_flags_to_string_lo(ch, buf);
        log_channels("Humor: [%s] %s '%s'", buf_string(buf), ch->name, argument);
        buf_free(buf);
    }
}

DO_FUN(do_gossip)
{
    DESCRIPTOR_DATA *d;
    BUFFER *buf;
    
    if (IS_NPC(ch) && IS_AFFECTED(ch, AFF_CHARM))
        return;

    if (argument[0] == '\0') {
        TOGGLE_BIT(ch->comm, COMM_NOGOSSIP);
        if (IS_SET(ch->comm, COMM_NOGOSSIP))
            act("     .", ch, NULL, NULL, TO_CHAR);
        else 
            act("  ,   .", ch, NULL, NULL, TO_CHAR);
        return;
    }

        if (IS_SET(ch->comm, COMM_NOCHANNELS)) {
         act("     .", ch, NULL, NULL, TO_CHAR);
         return;
    }

        if (IS_SET(ch->comm, COMM_NOGOSSIP))
                do_gossip(ch, str_empty);
        WAIT_STATE(ch, PULSE_VIOLENCE);

    argument = garble(ch, argument);
    act_puts(" : '{Y$t{x'", ch, argument, NULL, TO_CHAR | ACT_NODEAF, POS_DEAD);

    for (d = descriptor_list; d; d = d->next) {
        if (d->connected == CON_PLAYING
        &&  d->character != ch
        &&  !IS_SET(d->character->comm, COMM_NOGOSSIP))
            act_puts("$n : '{Y$t{x'", ch, argument, d->character, TO_VICT | ACT_SPEECH(ch), POS_DEAD);
    }
/* Edited by Simon. Log gossip to file */
    if (!IS_NPC(ch)) {
        buf = buf_new(-1);
        char_flags_to_string_lo(ch, buf);
        log_channels("Gossip: [%s] %s '%s'", buf_string(buf), ch->name, argument);
        buf_free(buf);
    }
}

DO_FUN(do_rtalk)
{
    religion_t *religion;
    CHAR_DATA *vch;
    int flags;

    religion = religion_lookup(ch->religion);
    if (!ch->religion || religion == NULL) {
        char_act("   .", ch);
        return;
    }

    if (argument[0] == '\0') {
        TOGGLE_BIT(ch->comm, COMM_NORTALK);
        if (IS_SET(ch->comm, COMM_NORTALK))
            char_act("     .", ch);
        else 
            char_act("    .", ch);
        return;
    }

    if (IS_SET(ch->comm, COMM_NORTALK))
        do_rtalk(ch, str_empty);
    
    if (!IS_NULLSTR(religion->rtalk_self))
        act_puts(religion->rtalk_self, ch, argument, NULL, TO_CHAR | ACT_NODEAF, POS_DEAD);
    else
        act_puts("{C[{WReligion{C]{w $n: {M$t{x", ch, argument, NULL, TO_CHAR | ACT_NODEAF, POS_DEAD);
    
    flags = TO_VICT | ACT_TOBUF | ACT_NODEAF;

    for (vch = char_list; vch; vch = vch->next)
    {
        if (vch->religion == ch->religion
        &&  vch != ch
        &&  !IS_SET(vch->comm, COMM_NORTALK)) 
        {
            if (!IS_NULLSTR(religion->rtalk_other))
                act_puts(religion->rtalk_other, ch, argument, vch, flags, POS_DEAD);
            else
                act_puts("{C[{WReligion{C]{w $n: {M$t{x", ch, argument, vch, flags, POS_DEAD);
                
        }
    }
}

DO_FUN(do_clan)
{
    if (argument[0] == '\0') 
    {
        TOGGLE_BIT(ch->comm, COMM_NOCLAN);
        if (IS_SET(ch->comm, COMM_NOCLAN))
            char_act("     .", ch);
        else 
            char_act("    .", ch);
        return;
    }

    if (IS_SET(ch->comm, COMM_NOCLAN))
        do_clan(ch, str_empty);

    act_clan(ch, "$t", argument);
}

DO_FUN(do_allytalk)
{
    if (argument[0] == '\0') 
    {
        TOGGLE_BIT(ch->comm, COMM_NOCLAN);
        if (IS_SET(ch->comm, COMM_NOCLAN))
            char_act("     .", ch);
        else 
            char_act("    .", ch);
        return;
    }

    if (IS_SET(ch->comm, COMM_NOCLAN))
        do_allytalk(ch, str_empty);

    act_allytalk(ch, "$t", argument);
}

DO_FUN(do_admin)
{
    DESCRIPTOR_DATA *d;

    if (IS_NPC(ch))
        return;

    if (IS_SET(ch->comm, COMM_NOCHANNELS)) 
    {
         char_act("       .", ch);
         return;
    }
    
    act("   {CAstrum Metaphora{x  !", ch, NULL, NULL, TO_CHAR);

    if (argument[0] == '\0')
        argument = "?";

    for (d = descriptor_list; d; d = d->next) 
    {
        CHAR_DATA *victim = d->original ? d->original : d->character;

        if (d->connected == CON_PLAYING
        &&  IS_IMMORTAL(victim)
        &&  !IS_SET(victim->comm, COMM_NOWIZ))
            act_puts("{Y$n{y   {W{y: '{G$t{x'", ch, argument, d->character, TO_VICT | ACT_TOBUF, POS_DEAD);
     }

    WAIT_STATE(ch, 3 * PULSE_VIOLENCE);
}

void agent_net_printf(CHAR_DATA *ch, CHAR_DATA *victim, int condition)
{
    DESCRIPTOR_DATA *d;
        int sk, sn;
    CHAR_DATA *doppel_vic = victim;
    //CHAR_DATA *agent;
    AFFECT_DATA *paf = NULL;
    const char *rname;
    bool anet_work = 0;
    
    if ((IS_NPC(ch) || IS_NPC(victim)) && (condition != ANET_WANTED_FOUND)) 
        return;
    if (ch == victim) 
        return;
    if (IS_IMMORTAL(ch) || IS_IMMORTAL(victim)) 
        return;
    sn = sn_lookup("agent net");
    if (is_affected(victim, gsn_doppelganger)) 
        doppel_vic = victim->doppel;
    rname = mlstr_cval(ch->in_room->name, ch);
    for (d = descriptor_list; d; d = d->next) 
        if ((d->connected == CON_PLAYING) 
        && ((sk = get_skill(d->character, sn)) > 0)) {
            if (ch == d->character) 
                continue;
            if (d->character && IS_IMMORTAL(d->character) &&
                !IS_SET(d->character->comm, COMM_AGENTNET))
                continue;

//            sk = sk * 2 / 3;
/*            for (agent = ch->in_room->people; agent; agent = agent->next_in_room) {
                if (IS_NPC(agent) 
                && (
                    (agent->pIndexData->pShop != NULL)
                    || IS_SET(agent->pIndexData->off_flags,ASSIST_GUARD)
                    || IS_SET(agent->pIndexData->act, ACT_QUESTOR)
                    || IS_SET(agent->pIndexData->act, ACT_HEALER)
                    ))
                    break;
            }*/
            switch (condition) {
            case ANET_KILLED :
            /*if (agent && (number_percent() < (sk - 50) * 2)) {
                act_puts("{x[Agent net]{B   {W$r{B,   {W$U{B.", d->character, ch->in_room, victim->in_room->area->name, TO_CHAR | ACT_NOLF, POS_DEAD);
                act_puts("{C $i{B $gi{} {C$c1{$N}{B.{x", d->character, victim, ch, TO_CHAR, POS_DEAD);
                anet_work = 1;
                check_improve(d->character, sn, TRUE, 1);
                break;
            }*/
                if (number_percent() > sk) break;
                act_puts3("{x[Agent net]{B  {W$r{B,   {W$T{B $gI{} {C$I{B!{x", d->character, ch->in_room, victim->in_room->area->name, ch, TO_CHAR, POS_DEAD);
                anet_work = 1;
                check_improve(d->character, sn, TRUE, 1);
                break;
            case ANET_ATTACK :
                if ((number_percent() > sk) /*&& (agent == NULL)*/) break;
                /*if (agent != NULL)
                {*/
                    act_puts("{x[Agent net] {C$i{B $gi{}  {C$c1{$N}{B", d->character, victim, ch, TO_CHAR | ACT_NOLF, POS_DEAD);
                    act_puts("  {W$r{B   {W$T{B.{x", d->character, ch->in_room, victim->in_room->area->name, TO_CHAR | ACT_NOUCASE, POS_DEAD);
                /*}
                else 
                    act_puts3("{x[Agent net] {C$T{B $gN{}  {W$r{B    {W$U{B!{x",
                        d->character, ch->in_room, ch->name, victim->in_room->area->name, TO_CHAR, POS_DEAD);
                */
                anet_work = 1;
                check_improve(d->character, sn, TRUE, 1);
                break;
            case ANET_WANTED_FOUND :
                if (number_percent() > sk) break;
                act_puts("{x[Agent net]{B   {W$t{B $gN{} $gN{} {C$T{B!{x",
                    d->character, victim->in_room->area->name, victim->name, TO_CHAR, POS_DEAD);
                anet_work = 1;
                check_improve(d->character, sn, TRUE, 1);
                break;
            case ANET_SET_WANTED :
                act_puts("{x[Agent net] {C$i{B $gi{}  {C$c1{$N}{B.{x", d->character, ch, victim, TO_CHAR, POS_DEAD);
                  anet_work = 1;
                  break;
            case ANET_REMOVE_WANTED :
                act_puts("{x[Agent net] {C$i{B $gi{}  {C$c1{$N}{B.{x", d->character, ch, victim, TO_CHAR, POS_DEAD);
                  anet_work = 1;
                  break;
            case ANET_ARREST :
                act_puts("{x[Agent net] {C$i{B $gi{} {C$c1{$N}{B.{x", d->character, ch, victim, TO_CHAR, POS_DEAD);
                anet_work = 1;
                break;
            case ANET_CONDEMN :
                for (paf = victim->affected; paf; paf = paf->next)
                    if (paf->type == gsn_arrest) break;
                if (paf == NULL) break;
                if (paf->duration != -1)
                    act_puts3("{x[Agent net] {C$i{B $gi{} {C$c1{$N}{B  $J $qJ{}.{x", d->character, ch, victim, (const void *) paf->duration, TO_CHAR, POS_DEAD);
                else 
                    act_puts("{x[Agent net] {C$i{B $gi{} {C$c1{$N}{B .{x", d->character, ch, victim, TO_CHAR, POS_DEAD);
                anet_work = 1;
                break;
            case ANET_FREE :
                act_puts("{x[Agent net] {C$i{B $gi{} {C$c1{$N}{B   {x", d->character, ch, victim, TO_CHAR, POS_DEAD);
                anet_work = 1;
                break;
            } //switch
            
            if (!anet_work) 
                 check_improve(d->character, sn, FALSE, 1);
        } 
}

DO_FUN(do_pose)
{
}

bool for_bug(CHAR_DATA *ch, const char *argument, char *filename)
{
    char arg[MAX_STRING_LENGTH];

    if (IS_NPC(ch))
        return TRUE;

    if (argument[0] == 0)
    {
    if (IS_IMMORTAL(ch))
    {
        FILE *fp;

        fclose(fpReserve);

        if ( ( fp = fopen( filename, "r" ) ) == NULL )
        {
        act("Could not open the file!", ch , NULL, NULL, TO_CHAR);
        }
        else
        {
        const char *str = NULL;
        int j = 0;

        while (!feof(fp))
        {
            if (str)
            free_string(str);

            if ((str = fread_string_eol(fp)) == str_empty)
            break;
            act_puts("#$j $T", ch, (const void *) j, str, TO_CHAR, POS_DEAD);
            j++;
        }
        fclose( fp );
        }

        fpReserve = fopen(NULL_FILE, "r");
    }
    else
        act("   ?", ch, NULL, NULL, TO_CHAR);

    return TRUE;
    }

    argument = one_argument(argument, arg, sizeof(arg));
    if (IS_IMMORTAL(ch)
    && (!str_cmp(arg, "") || !str_cmp(arg, "delete")))
    {
        int line;
    FILE *fp;

    one_argument(argument, arg, sizeof(arg));
    if (!is_number(arg) || (line = atoi(arg)) < 0)
    {
        act("       0.", ch, NULL, NULL, TO_CHAR);
        return TRUE;
    }

    fclose(fpReserve);
    if ( ( fp = fopen( filename, "r" ) ) == NULL )
    {
        act("Could not open the file!", ch , NULL, NULL, TO_CHAR);
    }
    else
    {
        const char *str = NULL;
        int j = 0, i = 0;
        char buf[5 * MAX_STRING_LENGTH];

        buf[0] = '\0';
        while (!feof(fp))
        {
        if (str)
            free_string(str);

        if ((str = fread_string_eol(fp)) == str_empty)
            break;

        if (j != line)
        {
            strnzcat(buf, sizeof(buf), str);
            strnzcat(buf, sizeof(buf), "\n");
            act_puts("#$j $T", ch, (const void *) i, str, TO_CHAR, POS_DEAD);
            i++;
        }

        j++;
        }

        fclose( fp );

        if ( ( fp = fopen( filename, "w" ) ) == NULL )
            act("Could not open the file!", ch , NULL, NULL, TO_CHAR);
        else
        {
            fprintf(fp, buf);
            act("Ok.", ch, NULL, NULL, TO_CHAR);
            fclose(fp);
        }
    }

    fpReserve = fopen(NULL_FILE, "r");
    return TRUE;
    }
    return FALSE;
}


DO_FUN(do_bug)
{
    if (for_bug(ch, argument, "tmp/"BUG_FILE))
        return;

    append_file(ch, BUG_FILE, argument);
    act(" .", ch, NULL, NULL, TO_CHAR);
    wiznet_printf(ch, NULL, WIZ_BUGS, 0, 92, "BUG: [%6d] $N: %s\n",
            ch->in_room? ch->in_room->vnum: 0,
            argument);
    return;
}

DO_FUN(do_typo)
{
    if (for_bug(ch, argument, "tmp/"TYPO_FILE))
        return;

    append_file(ch, TYPO_FILE, argument);
    act("Typo logged.", ch, NULL, NULL, TO_CHAR);
    wiznet_printf(ch, NULL, WIZ_BUGS, 0, 92, "TYPO: [%6d] $N: %s\n",
            ch->in_room? ch->in_room->vnum: 0,
            argument);
    return;
}

DO_FUN(do_rent)
{
    act("      ,   (save)    (quit).", ch, NULL, NULL, TO_CHAR);
    return;
}


DO_FUN(do_qui)
{
    act("    (QUIT),    .", ch, NULL, NULL, TO_CHAR);
    return;
}


DO_FUN(do_quit)
{
    do_quit_org(ch, argument, FALSE);
    return;
}

DO_FUN(do_quit_count)
{
    do_quit_org(ch, argument, TRUE);
    return;
}

void do_quit_org(CHAR_DATA *ch, const char *argument, bool Count)
{
    DESCRIPTOR_DATA *d;
    CHAR_DATA *vch;
    OBJ_DATA *obj,*obj_next;
    int id;
    CHAR_DATA *mirror;
    clan_t *clan = NULL;

    if (IS_NPC(ch))
        return;

    if (ch->position == POS_FIGHTING)
    {
        char_act(" !  !.", ch);
        return;
    }

    if (ch->position < POS_STUNNED)
    {
        char_act("   .", ch);
        return;
    }

    if (IS_AFFECTED(ch, AFF_CHARM))
    {
        char_act("      ?", ch);
        return;
    }

    if (IS_SET(ch->plr_flags, PLR_NOSOUL))
    {
        char_act("      ?", ch);
        return;
    }

    if (IS_AFFECTED(ch, AFF_SLEEP))
    {
        char_act("   ,     .", ch);
        return;
    }

    if (ch->in_war)
        war_quit (ch);

    // can't surrender - war is not started
    if (ch->in_war)
    {
        char_act("You can't quit now. Wait for the beginning of the war, then try to surrender.", ch);
        return;
    }
    if (ch->pcdata != NULL)
        if (ch->pcdata->wquest != NULL)
            wq_quit (ch);

    if (auction.item != NULL && ch == auction.buyer)
    {
        char_act(",       .", ch);
        return;
    }

    if (auction.item != NULL && ch == auction.seller)
    {
        char_act(",       .", ch);
        return;
    }

    if (!ch->in_room)
        return;

    if (!ch->in_room->area)
        return;

    if (!IS_IMMORTAL(ch))
    {
        if (IS_PUMPED(ch))
        {
            char_act("    !     .", ch);
            return;
        }

        if (is_affected(ch, gsn_witch_curse))
        {
            char_act(" . ,   !", ch);
            return;
        }

        clan = CLAN(ch->clan);

        if (ch->in_room->area->clan
        && ch->in_room->area->clan != ch->clan
        && CLAN(ch->clan)->diplomacy[ch->in_room->area->clan] != DIP_ALLY
        && ch->in_room->vnum != ROOM_VNUM_RULER_CELL)
        {
            char_act("    .", ch);
            return;
        }

        if (ch->in_room && IS_RAFFECTED(ch->in_room, RAFF_ESPIRIT))
        {
            char_act("       .", ch);
            return;
        }

        if (!get_skill(ch, gsn_evil_spirit)
        && is_affected(ch, gsn_evil_spirit))
        {
            char_act("      .", ch);
            return;
        }
    
        if (Contacted(ch) != NULL)
        {
            char_act("You cannot leave until you broke telepathic contact with someone.", ch);
            return;
        }
    }

    if (HAS_SKILL(ch, sn_lookup("mirror")))
    {
        for (mirror = char_list; mirror != NULL; mirror = mirror->next)
        if ((mirror != ch) && (mirror->name == ch->name))
        {
            handle_death(mirror, mirror);
            mirror = char_list;
        }
    }

    char_act(",      .", ch);
    char_act(" {c{x .  {R<(*)><(*)> U.N.S.P.E.A.K.A.B.L.E. <(*)><(*)>{z !", ch);

    if (!IS_IMMORTAL(ch) && ch->level < 10
    && !IS_SET(ch->plr_flags, PLR_CONFIRM_DELETE))
        act_puts("     $j $qj{}.",
            ch, (const void *) (ch->level*2), NULL, TO_CHAR, POS_DEAD);

    act_puts("$n  .", ch, NULL, NULL, TO_ROOM, POS_RESTING);
    log_printf("%s   .", ch->name);

    wiznet_printf(ch,NULL,WIZ_LOGINS,0,ch->level,
        "{W$N{x     (%s).",
        !IS_NULLSTR(ch->pcdata->host) ? ch->pcdata->host : "unknown");

    if (ch->stance != STANCE_NORMAL)
    {
        ch->stance = STANCE_NORMAL;
        affect_strip(ch, gsn_stance);
    }

    if (ch->style != STYLE_NORMAL)
    {
        ch->style = STYLE_NORMAL;
        affect_strip(ch, gsn_style);
    }

    if (ch->mount != NULL)
        ch->mount->mount = NULL;
    /*
     * remove quest objs for this char, drop quest objs for other chars
     */
    for (obj = ch->carrying; obj != NULL; obj = obj_next)
    {
        obj_next = obj->next_content;

        if (is_clan_item(obj))
        {
            extract_obj(obj);
            continue;
        }
        if (obj->pIndexData->vnum == OBJ_VNUM_MAGIC_JAR)
        {
            extract_obj(obj);
            continue;
        }

        if (obj->pIndexData->limit != -1 
        && (obj->pIndexData->count > obj->pIndexData->limit))
        {
            extract_obj(obj);
            continue;
        }

        if ((obj->pIndexData->limit != -1)
        && (obj->wear_loc == WEAR_NONE))
        {
            obj_from_char(obj);
            obj_to_room(obj,ch->in_room);
            continue;
        }
        if (obj->pIndexData->vnum >= QUEST_OBJ_FIRST
        &&  obj->pIndexData->vnum <= QUEST_OBJ_LAST)
        {
            if (obj->ed == NULL
            || strstr(mlstr_mval(obj->ed->description), ch->name) != NULL)
                extract_obj(obj);
            else if (obj->carried_by == ch)
            {
                obj_from_char(obj);
                obj_to_room(obj,ch->in_room);
            }
        }
    }

    for (vch = char_list; vch; vch = vch->next)
    {
        if (is_affected(vch, gsn_doppelganger)
        &&  vch->doppel == ch)
        {
            char_act("     ,     .", vch);
            affect_strip(vch, gsn_doppelganger);
            vch->doppel = vch;
        }

        if (vch->guarded_by == ch)
        {
            act("   $n.", vch, NULL, ch, TO_VICT);
            act("$N   .", vch, NULL, ch, TO_CHAR);
            act("$N   $n.", vch, NULL, ch, TO_NOTVICT);
            ch->guarding = NULL;
            vch->guarded_by = NULL;
        }

        if (vch->last_fought == ch)
        {
            vch->last_fought = NULL;
            back_home(vch);
        }

        if (vch->hunting == ch)
            vch->hunting = NULL;

        if (vch->hunter == ch)
            vch->hunter = NULL;

        remove_contact(vch, ch);
    }
    free_contacts(ch);

    if (ch->guarded_by != NULL)
    {
        ch->guarded_by->guarding = NULL;
        ch->guarded_by = NULL;
    }

    /*
     * After extract_char the ch is no longer valid!
     */
    save_char_obj(ch, FALSE, TRUE);
    id = ch->id;
    d = ch->desc;
    if (Count)
         extract_char(ch, TRUE);
    else
         extract_char_nocount(ch, TRUE);

    if (d)
        close_descriptor(d);

    toast_evil_cheating_bastards(id);
}

void toast_evil_cheating_bastards(int id)
{
    DESCRIPTOR_DATA *d, *d_next;
    /* toast evil cheating bastards    */
    for (d = descriptor_list; d; d = d_next)
    {
        CHAR_DATA *tch;

        d_next = d->next;
        tch = d->original ? d->original : d->character;
        if (tch && tch->id == id)
        {
            extract_char_nocount(tch, TRUE);
            close_descriptor(d);
        } 
    }
}

DO_FUN(do_save)
{
    if (IS_NPC(ch))
        return;

    if (ch->level < 1) 
    {
        act("    1   ,  .", 
            ch, NULL, NULL, TO_CHAR);
        return;
    }
    save_char_obj(ch, FALSE, FALSE);
    WAIT_STATE(ch, PULSE_VIOLENCE);
}

DO_FUN(do_follow)
{
/* RT changed to allow unlimited following and follow the NOFOLLOW rules */
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0') 
    {
        act("  ?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((victim = get_char_room(ch, arg)) == NULL) 
    {
        act("  .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_AFFECTED(ch, AFF_CHARM) && ch->master != NULL && !IS_NPC(ch)) 
    {
        act("    $N!", ch, NULL,ch->master,TO_CHAR);
        return;
    }

    if (victim == ch) 
    {
        if (ch->master == NULL) 
        {
            act("     .", ch, NULL, NULL, TO_CHAR);
            return;
        }
        stop_follower(ch);
        return;
    }

    if (!IS_NPC(victim)
    && IS_SET(victim->plr_flags, PLR_NOFOLLOW)
    && !IS_IMMORTAL(ch)) 
    {
        act("$N   .\n", ch, NULL, victim, TO_CHAR);
        return;
    }

    REMOVE_BIT(ch->plr_flags, PLR_NOFOLLOW);
    
    if (ch->master != NULL)
        stop_follower(ch);

    add_follower(ch, victim);
}

void add_follower(CHAR_DATA *ch, CHAR_DATA *master)
{
    if (ch->master != NULL) 
    {
        bug("Add_follower: null master.", 0);
        return;
    }

    ch->master        = master;
    ch->leader        = NULL;

    if (can_see(master, ch))
        act_puts("$n    .", ch, NULL, master, TO_VICT, POS_RESTING);
    act_puts("    $N.", ch, NULL, master, TO_CHAR, POS_RESTING);
}

void stop_follower(CHAR_DATA *ch)
{
    if (ch->master == NULL) 
    {
        bug("Stop_follower: null master.", 0);
        return;
    }

    if (IS_AFFECTED(ch, AFF_CHARM)) 
    {
        REMOVE_BIT(ch->affected_by, AFF_CHARM);
        affect_bit_strip(ch, TO_AFFECTS, AFF_CHARM);
    }

    if (can_see(ch->master, ch) && ch->in_room != NULL) 
    {
        act_puts("$n     .", ch, NULL, ch->master, TO_VICT, POS_RESTING);
        act_puts("     $N.", ch, NULL, ch->master, TO_CHAR, POS_RESTING);
    }

    if (ch->master->pet == ch)
        ch->master->pet = NULL;

    ch->master = NULL;
    ch->leader = NULL;
    if (IS_NPC(ch) && ch->fighting != NULL)
        stop_fighting(ch, FALSE);
}

/* nukes charmed monsters and pets */
void nuke_pets(CHAR_DATA *ch)
{    
    CHAR_DATA *pet;

    if ((pet = ch->pet) != NULL)
    {
        stop_follower(pet);
//        if (pet->in_room != NULL)
//            act("$N   .",ch,NULL,pet,TO_NOTVICT);
        extract_char_nocount(pet,TRUE);
    }
    ch->pet = NULL;

    return;
}

void die_follower(CHAR_DATA *ch)
{
    CHAR_DATA *fch;
    CHAR_DATA *fch_next;
    CHAR_DATA *pet;

    if (ch->master != NULL)
        stop_follower(ch);

    ch->leader = NULL;

    if ((pet = ch->pet) != NULL)
    {
        stop_follower(pet);
//        if (pet->in_room != NULL)
//            act("$N   .",ch,NULL,pet,TO_NOTVICT);
        extract_char_nocount(pet,TRUE);
    }

    ch->pet = NULL;

    for (fch = char_list; fch != NULL; fch = fch_next) {
        fch_next = fch->next;
        if (fch->master == ch)
            stop_follower(fch);
        if (fch->leader == ch)
            fch->leader = NULL;
    }
}

DO_FUN(do_order)
{
    char arg[MAX_INPUT_LENGTH],arg2[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    CHAR_DATA *och;
    CHAR_DATA *och_next;
    bool found;
    bool fAll;

    argument = one_argument(argument, arg, sizeof(arg));
    one_argument(argument, arg2, sizeof(arg2));

    if (arg[0] == '\0' || argument[0] == '\0') 
    {
        act("   ?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_AFFECTED(ch, AFF_CHARM)) 
    {
        act("    ,    .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!str_cmp(arg, "all") || !str_cmp(argument, "")) 
    {
        fAll   = TRUE;
        victim = NULL;
    } else {
        fAll   = FALSE;
        if ((victim = get_char_room(ch, arg)) == NULL) 
        {
            act("  .", ch, NULL, NULL, TO_CHAR);
            return;
        }

        if (victim == ch) 
        {
            act(", !", ch, NULL, NULL, TO_CHAR);
            return;
        }

        if (!IS_AFFECTED(victim, AFF_CHARM) || victim->master != ch 
        || (IS_IMMORTAL(victim) && victim->level >= ch->level)) 
        {
            act("  !", ch, NULL, NULL, TO_CHAR);
            return;
        }
    }

    found = FALSE;
    for (och = ch->in_room->people; och != NULL; och = och_next) 
    {
        och_next = och->next_in_room;

        if (IS_AFFECTED(och, AFF_CHARM)
        && och->master == ch
        && (fAll || och == victim)) 
        {
            found = TRUE;
            act("$n  : '$t'.", ch, argument,  och, TO_VICT);
            interpret_raw(och, argument, TRUE);
            /*    ,  !
            if (!IS_NPC(och) && number_percent() < (11 - get_curr_stat(ch, STAT_CHA) + get_curr_stat(och, STAT_CHA)))
            {
                REMOVE_BIT(och->affected_by, AFF_CHARM);
                affect_bit_strip(och, TO_AFFECTS, AFF_CHARM);
                    act("$N    .",ch,NULL,och,TO_CHAR);
                act("       !", och, NULL, NULL, TO_CHAR);           
            }*/         
        }
    }

    if (found) 
    {
        WAIT_STATE(ch,PULSE_VIOLENCE);
        act("Ok.", ch, NULL, NULL, TO_CHAR);
    }
    else
        act("   .", ch, NULL, NULL, TO_CHAR);
}

CHAR_DATA* leader_lookup(CHAR_DATA* ch)
{
    CHAR_DATA* res;
    if (ch == NULL)
        return NULL;
    for (res = ch; res->leader != NULL; res = res->leader)
        ;
    return res;
}

DO_FUN(do_group)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    int sn;

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0') {
        CHAR_DATA *gch;

        act_puts("$N's group:", ch, NULL, leader_lookup(ch), TO_CHAR, POS_DEAD);

        for (gch = char_list; gch != NULL; gch = gch->next)
            if (is_same_group(gch, ch))
            {
                if (IS_NPC (gch))
                {
                    if (IS_SET(gch->pIndexData->act, ACT_RECEIVE_LEVEL))
                        char_printf(ch,
                            "[%2d %s] %-16s %d/%d  "
                            "%d/%d  %d/%d   %5d tnl\n",
                            gch->level,
                            class_who_name(gch),
                            fix_short(PERS(gch, ch)),
                            gch->hit,   gch->max_hit,
                            gch->mana,  gch->max_mana,
                            gch->move,  gch->max_move,
                            gch->mob_tnl);
                    else
                        char_printf(ch,
                            "[%2d %s] %-16s %d/%d  "
                            "%d/%d  %d/%d \n",
                            gch->level,
                            class_who_name(gch),
                            fix_short(PERS(gch, ch)),
                            gch->hit,   gch->max_hit,
                            gch->mana,  gch->max_mana,
                            gch->move,  gch->max_move);
                }
                else
                    char_printf(ch,
                        "[%2d %s] %-16s %d/%d  "
                        "%d/%d  %d/%d   %5d tnl\n",
                        gch->level,
                        class_who_name(gch),
                        fix_short(PERS(gch, ch)),
                        gch->hit,   gch->max_hit,
                        gch->mana,  gch->max_mana,
                        gch->move,  gch->max_move,
                        exp_to_level(gch));

            }
        return;
    }

    if ((victim = get_char_room(ch, arg)) == NULL) 
    {
        act("  .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (victim == ch) 
    {
        act("?   ?!", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (ch->master != NULL || ch->leader != NULL) 
    {
        act("      !", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (victim->master != ch && ch != victim) 
    {
        act("$N    .", ch, NULL, victim, TO_CHAR);
        return;
    }
    
    if (IS_AFFECTED(victim, AFF_CHARM)) 
    {
        act("        .", 
            ch, NULL, NULL, TO_CHAR);
        return;
    }
    
    if (IS_AFFECTED(ch, AFF_CHARM)) 
    {
        act(",   ,    $gn{}!",
            ch, NULL, victim, TO_VICT);
        return;
    }


    if (is_same_group(victim, ch) && ch != victim) 
    {
        if (ch->guarding == victim || victim->guarded_by == ch) 
        {
            act("   $N.", ch, NULL, victim, TO_CHAR);
            act("$n   .",
                ch, NULL, victim, TO_VICT);
            act("$n   $N.",
               ch, NULL, victim, TO_NOTVICT);
            victim->guarded_by = NULL;
            ch->guarding       = NULL;
        }

        victim->leader = NULL;
        act_puts("$n  $N  $gn{} .", ch, NULL, victim, TO_NOTVICT, POS_SLEEPING);
        act_puts("$n    $gn{} .", ch, NULL, victim, TO_VICT, POS_SLEEPING);
        act_puts("  $N   .", ch, NULL, victim, TO_CHAR, POS_SLEEPING);

        if (victim->guarded_by != NULL
        && !is_same_group(victim,victim->guarded_by)) 
        {
            act("   $N.", victim->guarded_by, NULL, victim, TO_CHAR);
            act("$n   .", victim->guarded_by, NULL, victim, TO_VICT);
            act("$n   $N.", victim->guarded_by, NULL, victim, TO_NOTVICT);
            victim->guarded_by->guarding = NULL;
            victim->guarded_by           = NULL;
        }
        return;
    }

    if (ch->level - victim->level < -8 || ch->level - victim->level > 8) 
    {
        act_puts("$N      $n.", 
            ch, NULL, victim, TO_NOTVICT, POS_SLEEPING);
        act_puts("      $n.", 
            ch, NULL, victim, TO_VICT, POS_SLEEPING);
        act_puts("$N      .", 
            ch, NULL, victim, TO_CHAR, POS_SLEEPING);
        return;
    }

    if (IS_GOOD(ch) && IS_EVIL(victim)) 
    {
        act_puts("     $n!", 
            ch, NULL, victim, TO_VICT, POS_SLEEPING);
        act_puts("$N     !", 
            ch, NULL, victim, TO_CHAR, POS_SLEEPING);
        return;
    }

    if (IS_GOOD(victim) && IS_EVIL(ch)) 
    {
        act_puts("     $n!", 
            ch, NULL, victim, TO_VICT, POS_SLEEPING);
        act_puts("$N     !", 
            ch, NULL, victim, TO_CHAR, POS_SLEEPING);
        return;
    }

    if ((victim->ethos == ETHOS_LAWFUL && ch->ethos == ETHOS_CHAOTIC)
    || (ch->ethos == ETHOS_LAWFUL && victim->ethos == ETHOS_CHAOTIC)) 
    {
        act_puts("  .      ...", 
            ch, NULL, victim, TO_VICT, POS_SLEEPING);
        act_puts("  .      ...", 
            ch, NULL, victim, TO_CHAR, POS_SLEEPING);
        return;
    }

    sn = sn_lookup("ruler aura");
    if ((HAS_SKILL(ch, sn) && HAS_SKILL(victim, gsn_disperse))
    || (HAS_SKILL(ch, gsn_disperse) && HAS_SKILL(victim, sn))
    || (HAS_SKILL(ch, gsn_mastering_spell) 
    && HAS_SKILL(victim, gsn_spellbane))
    || (HAS_SKILL(ch, gsn_spellbane) 
    && HAS_SKILL(victim, gsn_mastering_spell))) 
    {
        act_puts("   $n,      $gn{} ?", 
            ch, NULL, victim, TO_VICT, POS_SLEEPING);
        act_puts("   $N,     $N   ?", 
            ch, NULL, victim, TO_CHAR, POS_SLEEPING);
        return;
    }

    victim->leader = ch;
    act_puts("$N    $n.", ch, NULL, victim, TO_NOTVICT, POS_SLEEPING);
    act_puts("    $n.", ch, NULL, victim, TO_VICT, POS_SLEEPING);
    act_puts("$N    .", ch, NULL, victim, TO_CHAR, POS_SLEEPING);
}



/*
 * 'Split' originally by Gnort, God of Chaos.
 */
DO_FUN(do_split)
{
    char buf[MAX_STRING_LENGTH];
    char arg1[MAX_INPUT_LENGTH],arg2[MAX_INPUT_LENGTH];
    CHAR_DATA *gch;
    int members;
    int amount_gold = 0, amount_silver = 0;
    int share_gold, share_silver;
    int extra_gold, extra_silver;

    argument = one_argument(argument, arg1, sizeof(arg1));
    one_argument(argument, arg2, sizeof(arg2));

    if (arg1[0] == '\0')
    {
        act(" ?", ch, NULL, NULL, TO_CHAR);
        return;
    }
    
    amount_silver = atoi(arg1);

    if (arg2[0] != '\0')
        amount_gold = atoi(arg2);

    if (amount_gold < 0 || amount_silver < 0)
    {
        act("    .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (amount_gold == 0 && amount_silver == 0)
    {
        act("   ,      .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (ch->gold <  amount_gold || ch->silver < amount_silver)
    {
        act("     .", ch, NULL, NULL, TO_CHAR);
        return;
    }
    
    members = 0;
    for (gch = ch->in_room->people; gch != NULL; gch = gch->next_in_room)
    {
    if (is_same_group(gch, ch) && !IS_AFFECTED(gch,AFF_CHARM))
        members++;
    }

    if (members < 2)
    {
        act("   .", ch, NULL, NULL, TO_CHAR);
        return;
    }
        
    share_silver = amount_silver / members;
    extra_silver = amount_silver % members;

    share_gold   = amount_gold / members;
    extra_gold   = amount_gold % members;

    if (share_gold == 0 && share_silver == 0)
    {
        act("  , !", ch, NULL, NULL, TO_CHAR);
        return;
    }

    ch->silver  -= amount_silver;
    ch->silver  += share_silver + extra_silver;
    ch->gold    -= amount_gold;
    ch->gold    += share_gold + extra_gold;

    if (share_silver > 0)
        act_puts3("  $j {W$qj{}{x $qj{}.    $J {W$qJ{}{x.", ch, (const void *) amount_silver, NULL, (const void *) (share_silver + extra_silver), TO_CHAR, POS_RESTING);

    if (share_gold > 0)
        act_puts3("  $j {W$qj{}{x $qj{}.    $J {W$qJ{}{x.", ch, (const void *) amount_gold, NULL, (const void *) (share_gold + extra_gold), TO_CHAR, POS_RESTING);

    if (share_gold == 0)
    snprintf(buf, sizeof(buf), "$n  $j {W$qj{}{x .   -- %d {W{x.", share_silver);
    else if (share_silver == 0)
    snprintf(buf, sizeof(buf), "$n  $J {Y$qJ{}{x .   -- %d {Y{x.", share_gold);
    else
    snprintf(buf, sizeof(buf),
"$n  $j {W$qj{}{x  $J {Y$qJ{}{x ,    %d {W{x  %d {Y{x.", share_silver, share_gold);

    for (gch = ch->in_room->people; gch != NULL; gch = gch->next_in_room) {
    if (gch != ch && is_same_group(gch,ch) && !IS_AFFECTED(gch,AFF_CHARM)) {
        act_puts3(buf, ch, (const void *) amount_silver, gch, (const void *) amount_gold, TO_VICT, POS_RESTING);
        gch->gold += share_gold;
        gch->silver += share_silver;
    }
    }

    return;
}

DO_FUN(do_speak)
{
    char arg[MAX_INPUT_LENGTH];
    int language;
    race_t *r;

    if (IS_NPC(ch)
    ||  (r = race_lookup(ch->pcdata->race)) == NULL
    ||  !r->pcdata)
        return;

    argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0') {
        act("    $t.", ch, flag_string(slang_table, ch->slang), NULL, TO_CHAR);
        act("  :", ch, NULL, NULL, TO_CHAR);
        act("$FR13{common} $t", ch, flag_string(slang_table, r->pcdata->slang), NULL, TO_CHAR);
        return;
    }

    if ((language = flag_value(slang_table, arg)) < 0) {
        act("      .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (language >= SLANG_MAX)
        ch->slang = r->pcdata->slang;
    else
        ch->slang = language;
    
    act("    $t.", ch, flag_string(slang_table, ch->slang), NULL, TO_CHAR);
}

DO_FUN(do_twit)
{
    char arg[MAX_STRING_LENGTH];

    if (IS_NPC(ch)) {
        act("?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0') {
        act_puts(" twitlist [$t]", ch, ch->pcdata->twitlist, NULL, TO_CHAR, POS_DEAD);
        return;
    }

    name_toggle(ch, arg, "Twitlist", &ch->pcdata->twitlist);
}

bool is_linked(CHAR_DATA *ch, CHAR_DATA *vch)
{
    return is_name_raw(ch->name, 
                       vch->pcdata->linked_list, 
                       str_cmp);
}

bool has_links(CHAR_DATA *ch)
{
    return (!IS_NULLSTR(ch->pcdata->linked_list) 
            && str_cmp(ch->pcdata->linked_list, ch->name));
}

void links_pull(CHAR_DATA *ch)
{
    CHAR_DATA *wch;
    const char *buf = str_empty;
    static char name[MAX_STRING_LENGTH];
    const char *p;

    if (IS_NPC(ch) || ch->pcdata == NULL)
        return;
    
    /* Build correct linked list first. */
    p = ch->pcdata->linked_list;
    for (;;)
    {
        bool loaded = FALSE;
        p = one_argument(p, name, sizeof(name));
        if (name[0] == '\0')
            break;
        if (!str_cmp(name, ch->name))
            continue;
        if ((wch = gq_findchar(name)) == NULL)
        {
            loaded = TRUE;
            wch = char_load_special(name);
        }
        if (wch == NULL)
        {
            log_printf("Illegal name %s in %s's linked list [%s].",
                            name, ch->name, ch->pcdata->linked_list);
            continue;
        }
        if (wch == ch)
            continue;
        name_add(NULL, name, "Links", &buf);
        if (loaded)
            char_nuke(wch);
    }
    /* And now, assign this list to all it's members. */
    p = buf;
    for (;;)
    {
        bool loaded = FALSE;
        p = one_argument(p, name, sizeof(name));
        if (name[0] == '\0')
            break;
        if ((wch = gq_findchar(name)) == NULL)
        {
            loaded = TRUE;
            wch = char_load_special(name);
        }
        if (wch == NULL)
        {
            log_printf("Illegal name %s in %s's FIXED linked list [%s]!",
                            name, ch->name, buf);
            continue;
        }
        free_string(wch->pcdata->linked_list);
        wch->pcdata->linked_list = str_dup(buf);
        if (loaded)
            char_nuke(wch);
    }
    free_string(buf);
    free_string(ch->pcdata->linked_list);
    ch->pcdata->linked_list = str_dup(ch->name);
}

void links_fix(CHAR_DATA *ch)
{
    CHAR_DATA *wch;
    char buf[MAX_STRING_LENGTH];
    static char name[MAX_STRING_LENGTH];
    const char *p;

    if (IS_NPC(ch) || ch->pcdata == NULL)
        return;

    strnzcpy(buf, sizeof(buf), capitalize(ch->name));   
    /* Build correct linked list first. */
    p = ch->pcdata->linked_list;
    for (;;)
    {
        bool loaded = FALSE;
        p = one_argument(p, name, sizeof(name));
        if (name[0] == '\0')
            break;
        if ((wch = gq_findchar(name)) == NULL)
        {
            loaded = TRUE;
            wch = char_load_special(name);
        }
        if (wch == NULL)
        {
            log_printf("Illegal name %s in %s's linked list [%s].",
                            name, ch->name, ch->pcdata->linked_list);
            continue;
        }
        if (!is_name_raw(name, buf, str_cmp))
        {
            strnzcat(buf, sizeof(buf), " ");
            strnzcat(buf, sizeof(buf), capitalize(wch->name));
        }
        if (loaded)
            char_nuke(wch);
    }
    /* And now, assign this list to all it's members. */
    p = buf;
    for (;;)
    {
        bool loaded = FALSE;
        p = one_argument(p, name, sizeof(name));
        if (name[0] == '\0')
            break;
        if ((wch = gq_findchar(name)) == NULL)
        {
            loaded = TRUE;
            wch = char_load_special(name);
        }
        if (wch == NULL)
        {
            log_printf("Illegal name %s in %s's FIXED linked list [%s]!",
                            name, ch->name, buf);
            continue;
        }
        free_string(wch->pcdata->linked_list);
        wch->pcdata->linked_list = str_dup(buf);
        if (loaded)
            char_nuke(wch);
    }
}

void links_cat(CHAR_DATA *ch, CHAR_DATA *vch1, CHAR_DATA *vch2)
{
    CHAR_DATA *wch;
    static char buf[MAX_STRING_LENGTH];
    static char name[MAX_STRING_LENGTH];
    const char *p;
    if (is_linked(vch1, vch2) && is_linked(vch2, vch1))  
    {
        if (ch == vch1)
            char_act("But you are already linked!", ch);
        else
            char_act("But they are already linked!", ch);
        return;
    }
    name_add(ch, vch1->name, "Links", &vch1->pcdata->linked_list);
    name_add(ch, vch2->name, "Links", &vch2->pcdata->linked_list);
    if (strlen(vch1->pcdata->linked_list) + 
        strlen(vch2->pcdata->linked_list) + 2 > sizeof(buf))
    {
        log_printf("Links: failed linking %s and %s -- too much multies.",
                        vch1->name, vch2->name);
        return;
    }
    strnzcpy(buf, sizeof(buf), vch1->pcdata->linked_list);
    strnzcat(buf, sizeof(buf), " ");
    strnzcat(buf, sizeof(buf), vch2->pcdata->linked_list);
    
    free_string(vch1->pcdata->linked_list);
    vch1->pcdata->linked_list = str_dup(buf);
    free_string(vch2->pcdata->linked_list);
    vch2->pcdata->linked_list = str_dup(buf);
    if (ch == vch1)
    {
        act_puts("You linked yourself with $N, and now your common linked list is: [$t].", ch, buf, vch2, TO_CHAR, POS_DEAD);
        act_puts("$n linked $gn{himself} with you, and now your common linked list is: [$t].", ch, buf, vch2, TO_VICT, POS_DEAD);
    }
    else
    {
        act_puts3("You linked $i with $I, and now their common linked list is: [$T].", ch, vch1, buf, vch2, TO_CHAR, POS_DEAD);
        act_puts3("$n linked $i with you, and now your common linked list is: [$U].", ch, vch1, vch2, buf, TO_VICT, POS_DEAD);
        act_puts3("$n linked you with $i, and now your common linked list is: [$U].", ch, vch2, vch1, buf, TO_VICT, POS_DEAD);
    }
    save_char_obj(vch1, FALSE, FALSE);
    save_char_obj(vch2, FALSE, FALSE);
    
    p = buf;
    for(;;)
    {
        bool loaded = FALSE;
        p = one_argument(p, name, sizeof(name));

        if (name[0] == '\0')
            break;

        if ((wch = gq_findchar(name)) == NULL)
        {    
            loaded = TRUE;
            wch = char_load_special(name);
        }
        if (wch == NULL)
        {
            log_printf("Illegal name %s in %s/%s linked list [%s].",
                        name, vch1->name, vch2->name, buf);
                continue;
        }
        if (wch == vch1 || wch == vch2)
            continue;
        free_string(wch->pcdata->linked_list);
        wch->pcdata->linked_list = str_dup(buf);
        if (!loaded)
        {
            if (ch == vch1)
                act_puts3("$n linked $gn{himself} with $i, and now your common linked list is: [$U].", ch, vch2, wch, buf, TO_VICT, POS_DEAD);
            else
            {
                act_puts3("$n linked $i with $I, and you are now linked to their common list: ", ch, vch1, wch, vch2, TO_VICT | ACT_NOLF, POS_DEAD);
                act_puts("[$t].", ch, buf, wch, TO_VICT, POS_DEAD);
            }
        }
        if (loaded)
            char_nuke(wch);
    }
}

DO_FUN(do_links)
{
    char command[MAX_STRING_LENGTH];
    char name[MAX_STRING_LENGTH];
    char name2[MAX_STRING_LENGTH];
    const char *pwd_crypted, *pwd_crypted2;
    CHAR_DATA *wch;
    bool loaded = FALSE;
    bool supervisor = IS_IMMORTAL(ch) && ch->level >= MAX_LEVEL - 5;
    
    if (IS_NPC(ch) || ch->desc == NULL) {
        char_act("Go away, stupid animal!", ch);
        return;
    }

    argument = one_argument(argument, command, sizeof(command));
    argument = one_argument(argument, name, sizeof(name));
    argument = one_argument(argument, name2, sizeof(name2));
    
    if (command[0] == '\0') {
        if (supervisor)
            do_help(ch, "'SUPERLINKS'");
        act_puts("You are linked to: [$t]", ch, ch->pcdata->linked_list, NULL, TO_CHAR, POS_DEAD);
        return;
    }
    if (IS_NULLSTR(name))
    {
        char_act("Incorrect character request (argument).", ch);
        return;
    }
    
    if ((wch = gq_findchar(name)) == NULL)
    {    
        loaded = TRUE;
        wch = char_load_special(name);
    }
    if (wch == NULL)
    {
        act_puts("Someone named $t doesn't exist!", ch, name, NULL, TO_CHAR, POS_DEAD);
        return;
    }
    
    if (supervisor && !str_cmp(command, "show"))
    {
        act_puts("$N is linked to: [$t]", ch, wch->pcdata->linked_list, wch, TO_CHAR, POS_DEAD);
        if (loaded)
            char_nuke(wch);
        return;
    }

    if (supervisor && (!str_cmp(command, "remove") 
                      || !str_cmp(command, "pull")))
    {
        links_pull(wch);
        act_puts("Ok. $N is pulled from linked lists and now is linked to: [$t]", ch, wch->pcdata->linked_list, wch, TO_CHAR, POS_DEAD);
        if (loaded)
            char_nuke(wch);
        return;
    }

    if (supervisor && !str_cmp(command, "fix"))
    {
        links_fix(wch);
        act_puts("Ok. $N's linked list fixed and now it is: [$t]", ch, wch->pcdata->linked_list, wch, TO_CHAR, POS_DEAD);
        if (loaded)
            char_nuke(wch);
        return;
    }
    
    if (!str_cmp(command, "add"))
    {
        pwd_crypted = str_dup(ch->pcdata->pwd);
        pwd_crypted2 = str_dup(wch->pcdata->pwd);
        if (strcmp(pwd_crypted, pwd_crypted2))
        {
            act_puts("Your passwords doesn't compare.", ch, NULL, wch, TO_CHAR, POS_DEAD);
            log_printf("Links: passwords of %s and %s@%s doesn't compare.", 
                            wch->name, ch->name, ch->desc->host);
            free_string(pwd_crypted);
            free_string(pwd_crypted2);
            if (loaded)
                char_nuke(wch);
            return;
        }
        links_cat(ch, ch, wch);
        if (loaded)
            char_nuke(wch);
        return;
    }
    if (supervisor && !str_cmp(command, "cat"))
    {
        CHAR_DATA *wch2;
        bool loaded2 = FALSE;
        if (IS_NULLSTR(name2))
        {
            char_act("Incorrect character request (argument).", ch);
            if (loaded)
                char_nuke(wch);
            return;
        }
        if (!str_cmp(name, name2))
        {
            act_puts("You can't cat the character with $gN{himself}", ch, NULL, wch, TO_CHAR, POS_DEAD);
            if (loaded)
                char_nuke(wch);
            return;
        }
        if ((wch2 = gq_findchar(name2)) == NULL)
        {    
            loaded2 = TRUE;
            wch2 = char_load_special(name2);
        }
        if (wch2 == NULL)
        {
            act_puts("Someone named $t doesn't exist!", ch, name2, NULL, TO_CHAR, POS_DEAD);
            if (loaded)
                char_nuke(wch);
            return;
        }
        links_cat(ch, wch, wch2);
        if (loaded2)
            char_nuke(wch2);
        if (loaded)
            char_nuke(wch);
        return;
    }
/*
 * Unknown command. Show the syntax.
 */ 

    do_help(ch, "'LINKS'");
    if (IS_IMMORTAL(ch))
        do_help(ch, "'SUPERLINKS'");
    return;
}

DO_FUN(do_qptrans)
{
    char name[MAX_STRING_LENGTH];
    char arg[MAX_STRING_LENGTH];
    int amount;
    bool loaded = FALSE;
    CHAR_DATA *victim;
    
    argument = one_argument(argument, name, sizeof(name));
    one_argument(argument, arg, sizeof(arg));

    if (IS_NPC(ch))
        return;

    if (IS_SET(ch->comm, PLR_PEACE))
    {
        act("   [NO PK]    QP.", ch, NULL, NULL, TO_CHAR);
        return;
    }
    if (IS_NULLSTR(name) || IS_NULLSTR(arg))
    {
        char_act("Usage: qptrans <character> <amount>", ch);
        return;
    }
    amount = atoi(arg);
    if (amount <= 1)
    {
        char_act("Ammount of transaction should be at least 2 points.", ch);
        return;
    }
    if (amount > ch->pcdata->questpoints)
    {
        act_puts3("You can't transaction $j $qj{quest points}, you have only $J.", ch, (const void *) amount, NULL, (const void *) ch->pcdata->questpoints, TO_CHAR, POS_DEAD);
        return;
    }
    if (ch->level < 30)
    {
        char_act("You should be at least 30 level to grant your quest points.", ch);
        return;
    }
    victim = gq_findchar(name);
    if (victim == ch)
    {
        char_act("It's stupid.", ch);
        return;
    }
    if (victim == NULL)
    {
        loaded = TRUE;
        victim = char_load_special(name);
    }
    if (victim == NULL)
    {
        act_puts("You can't find anyone named $t.", ch, name, NULL, TO_CHAR, POS_DEAD);
        return;
    }
    if (!is_linked(victim, ch))
    {
        act_puts("You aren't linked with $N. So you can't help $gn{him}.", ch, NULL, victim, TO_CHAR, POS_DEAD);
        return;
    }
    ch->pcdata->questpoints -= 2*(amount/2);
    victim->pcdata->questpoints += amount/2;
    ch->pcdata->qpbalance -= 2*(amount/2);
    victim->pcdata->qpbalance += 2*(amount/2);
    log_printf("%s transmited %d(%d) qp to %s.",
                    ch->name, 2*(amount/2), amount/2, victim->name);
    act_puts3("$j $qj{quest points} taken from your account, and half of them ($J) deposited to $N's.", ch, (const void *) (2*(amount/2)), victim, (const void *) (amount/2), TO_CHAR, POS_DEAD);
    if (loaded)
        char_nuke(victim);
}


DO_FUN(do_lang)
{
    char arg[MAX_STRING_LENGTH];
    int lang;
    lang_t *l;

    if (langs.nused == 0) {
        char_act("  .", ch);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));

    if (*arg == '\0') {
        l = varr_get(&langs, ch->lang);
        if (l == NULL) {
            log_printf("do_lang: %s: lang == %d\n",
                   ch->name, ch->lang);
            l = VARR_GET(&langs, ch->lang = 0);
        }
        act_puts(" : '$t'.", ch, l->name, NULL, TO_CHAR, POS_DEAD);
        return;
    }

    lang = lang_lookup(arg);
    if (lang < 0) {
        act_puts(":  [ ", ch, NULL, NULL, TO_CHAR | ACT_NOLF, POS_DEAD);
        for (lang = 0; lang < langs.nused; lang++) {
            l = VARR_GET(&langs, lang);
            if (IS_SET(l->flags, LANG_HIDDEN))
                continue;
            act_puts("$t$T", ch, lang == 0 ? str_empty : " | ", l->name, TO_CHAR | ACT_NOLF, POS_DEAD);
        }
        char_act(" ]", ch);
        return;
    }

    ch->lang = lang;
    do_lang(ch, str_empty);
    do_look(ch, str_empty);
}

DO_FUN(do_trust)
{   
    char arg[MAX_INPUT_LENGTH];
    
    if (IS_NPC(ch)) {
        act("Huh?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0') 
    {
        if (!ch->pcdata->trust) 
        {
            act("You do not allow anyone to cast questionable spells on you.", ch, NULL, NULL, TO_CHAR);
            return;
        }

        if (IS_SET(ch->pcdata->trust, TRUST_ALL)) 
        {
            act("You allow everyone to cast questionable spells on you.", ch, NULL, NULL, TO_CHAR);
            return;
        }
        if (IS_SET(ch->pcdata->trust, TRUST_CLAN)) 
            act("You trust your clan with questionable spells.", ch, NULL, NULL, TO_CHAR);
        if (IS_SET(ch->pcdata->trust, TRUST_GROUP))
            act("You trust your group with questionable spells.", ch, NULL, NULL, TO_CHAR);
        if (IS_SET(ch->pcdata->trust, TRUST_ALIGN))
            act("You trust your align people with questionable spells.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!str_cmp(arg, "clan") || !str_cmp(argument, "")) 
    {
        if (ch->clan == 0) 
        {
            act("You are not in clan.", ch, NULL, NULL, TO_CHAR);
            return;
        };

        TOGGLE_BIT(ch->pcdata->trust, TRUST_CLAN);
        if (IS_SET(ch->pcdata->trust, TRUST_CLAN)) 
        {
            REMOVE_BIT(ch->pcdata->trust, TRUST_ALL);
            act("You now trust your clan with questionable spells.", ch, NULL, NULL, TO_CHAR);
        }
        else 
            act("You no longer trust your clan with questionable spells.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!str_cmp(arg, "group") || !str_prefix(argument, "")) 
    {
        TOGGLE_BIT(ch->pcdata->trust, TRUST_GROUP);
        if (IS_SET(ch->pcdata->trust, TRUST_GROUP)) 
        {
            REMOVE_BIT(ch->pcdata->trust, TRUST_ALL);
            act("You allow your group to cast questionable spells on you.", ch, NULL, NULL, TO_CHAR);
        }
        else
            act("You no longer trust your group with questionable spells.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!str_cmp(arg, "align") || !str_prefix(argument, "")) 
    {
        TOGGLE_BIT(ch->pcdata->trust, TRUST_ALIGN);
        if (IS_SET(ch->pcdata->trust, TRUST_ALIGN)) 
        {
            REMOVE_BIT(ch->pcdata->trust, TRUST_ALL);
            act("You allow your align people to cast questionable spells on you.", ch, NULL, NULL, TO_CHAR);
        }
        else
            act("You no longer trust your align people with questionable spells.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!str_cmp(arg, "all") || !str_cmp(argument, "")) 
    {
        ch->pcdata->trust = TRUST_ALL;
        act("You allow everyone to cast questionable spells on you.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!str_cmp(arg, "none") || !str_prefix(argument, "")) 
    {
        ch->pcdata->trust = 0;
        act("You do not allow anyone to cast questionable spells on you.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    act("Syntax: trust {{ group | align | clan | all | none }", ch, NULL, NULL, TO_CHAR);
    act("{x       {{  |  |  |  |  }", ch, NULL, NULL, TO_CHAR);
}

DO_FUN(do_judge)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    clan_t *clan;
    
    clan = CLAN(ch->clan);
    if (!IS_SET(clan->flags, CLAN_RULERS)) {
        act("?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0') {
        act(" ?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((victim = get_char_world(ch, arg)) == NULL) {
        act("  .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_NPC(victim)) {
        act(" , .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_IMMORTAL(victim) && !IS_IMMORTAL(ch)) {
        char_act("   ,   {C{x!", ch);
        return;
    }

    act_puts3("$N is $t-$U.", ch, flag_string(ethos_table, victim->ethos), victim, flag_string(align_names, NALIGN(victim)), TO_CHAR | ACT_TRANS, POS_RESTING);
            
}

DO_FUN(do_condemn)
{
    char          arg[MAX_INPUT_LENGTH];
    CHAR_DATA    *victim;
    AFFECT_DATA   af;
    clan_t       *clan;
    int           tic;
    
    
    clan = CLAN(ch->clan);
    
    if (!IS_SET(clan->flags, CLAN_RULERS) || (!IS_IMMORTAL(ch))) 
    {
        act("Huh?", ch, NULL, NULL, TO_CHAR);
        return;
    }
    
    argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0') 
    { 
        act("condemn <char name> <xxx|free>", ch, NULL, NULL, TO_CHAR);
        act("   xxx  -   <char name>  ", ch, NULL, NULL, TO_CHAR);
        act("   free -  <char name>   ", ch, NULL, NULL, TO_CHAR);
        act("   life -  ", ch, NULL, NULL, TO_CHAR);
        return;
    }
    
    if (((victim = get_char_world(ch, arg)) == NULL) || IS_NPC(victim)) 
    {
        act("  .", ch, NULL, NULL, TO_CHAR);
        return;
    }
    
    if (!is_affected(victim, gsn_arrest)) 
    {
        act("      .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    one_argument(argument, arg, sizeof(arg));
    
    if (arg[0] == '\0') 
    {
        act("   ?", ch, NULL, NULL, TO_CHAR);
        return;
    }
    
    if (!str_prefix(arg, "free") || !str_prefix(arg, ""))
    {
        affect_strip(victim, gsn_arrest);
        act("  .", victim, NULL, NULL, TO_CHAR);
        agent_net_printf(ch, victim, ANET_FREE);
        return;
    }

    if (!str_prefix(arg, "life") || !str_prefix(arg, ""))
    {
        if(!IS_IMMORTAL(ch))
        {
            act("     .", victim, NULL, NULL, TO_CHAR);
            return;
        }

        tic = -1;
    }
    else 
    {
        if (!is_number(arg)) 
        {
            act("  ?", ch, NULL, NULL, TO_CHAR);
            return;
        }

        tic = atoi(arg);
        
        if (tic < 0) 
        {
            act("   .", ch, NULL, NULL, TO_CHAR);
            return;
        }

        if (tic > victim->level * 4) 
        {
            act("    .", ch, NULL, NULL, TO_CHAR);
            return;
        }
    }
    
    affect_strip(victim, gsn_arrest);
    af.where = TO_AFFECTS;
    af.type = gsn_arrest;
    af.level = ch->level;
    af.duration = tic;
    af.bitvector = 0;
    af.location = APPLY_MOVE;
    af.modifier = -1 * (victim->max_move - 30);
    affect_to_char(victim, &af);

    agent_net_printf(ch, victim, ANET_CONDEMN); 
}
DO_FUN(do_wanted)
{
    char         arg[MAX_INPUT_LENGTH];
    char         arg2[MAX_INPUT_LENGTH];
    bool         set = FALSE;
    CHAR_DATA   *victim;
    clan_t      *clan;
    clan_t      *victim_clan;
    
    clan = CLAN(ch->clan);
    
    if (!IS_SET(clan->flags, CLAN_RULERS) && !IS_IMMORTAL(ch)) 
    {
        act("?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));
    argument = one_argument(argument, arg2, sizeof(arg2));
    
    if (arg[0] == '\0') 
    {
        act("  ?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (arg2[0] == '\0') 
    {
        act("   ? (set/remove)", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!str_prefix(arg2, "set") || !str_prefix(arg2, ""))
        set = TRUE;

    if (!str_prefix(arg2, "remove") || !str_prefix(arg2, ""))
        set = FALSE;

    if ((victim = get_char_world(ch, arg)) == NULL) 
    {
        act("  .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_NPC(victim)) 
    {
        act(" , .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_IMMORTAL(victim) && ch->level < victim->level) 
    {
        act("    ,   $N.", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (ch->pcdata->clan_status == CLAN_NEWBIE) 
    {
        act("   ,    $N.", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (victim == ch) 
    {
        act("      .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    victim_clan = CLAN(victim->clan);

    if(victim_clan != NULL)
    {
        if (IS_SET(victim_clan->flags, CLAN_RULERS) && !IS_IMMORTAL(ch))
        {
            act("  !       .", ch, NULL, NULL, TO_CHAR);
            return;
        }
    }

    if (is_affected(ch, gsn_arrest)) 
    {
        act("  .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_SET(victim->in_room->room_flags, ROOM_LAW)) {

        if (set) SET_BIT(victim->plr_flags, PLR_WANTED);
        else REMOVE_BIT(victim->plr_flags, PLR_WANTED);

        if (IS_SET(victim->plr_flags, PLR_WANTED)) {
            AFFECT_DATA af;

            affect_strip(victim, gsn_wanted);

            af.where = TO_AFFECTS;
            af.type = gsn_wanted;
            af.level = ch->level;
            af.duration = victim->level << 1;
            af.bitvector = 0;
            af.location = APPLY_NONE;
            af.modifier = 0;

            affect_to_char(victim, &af);

            act_puts("$N   !!!", ch, NULL, victim, TO_CHAR, POS_DEAD);
            agent_net_printf(ch, victim, ANET_SET_WANTED);
            act("  {R !!!{x", victim, NULL, NULL, TO_CHAR);

            ++stat_record.wanted_set;
        }
        else {
            affect_strip(victim, gsn_wanted);
            act_puts("$N    .", ch, NULL, victim, TO_CHAR, POS_DEAD);
            act("    .", victim, NULL, NULL, TO_CHAR);
            agent_net_printf(ch, victim, ANET_REMOVE_WANTED);
        }
    }
    else {
        act("$N    LAW !", ch, NULL, victim, TO_CHAR);
    }
        WAIT_STATE(ch,4 * PULSE_VIOLENCE);
    return;
}

void do_headprice( CHAR_DATA *ch, const char *argument )
{
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    clan_t *clan = NULL;

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));
    
    if (arg1[0] == '\0' || arg2[0] == '\0')
    {
        act("    ?  ?\n\rSyntax: headprice <victim> <amount>", ch, NULL, NULL, TO_CHAR);
        return;
    }
    
    if ((victim = get_char_world(ch, arg1)) == NULL)
    {
        act("Such here is not present!", ch, NULL, NULL, TO_CHAR);
        return;
    }
  
    if (IS_NPC(victim))
    {
        act("     Hunters!", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!str_cmp(arg2, "cancel")
    || !str_cmp(arg2, ""))
    {
        clan = clan_lookup(ch->clan);

        if (IS_IMMORTAL(ch)
        || (clan && IS_SET(clan->flags, CLAN_HIDDEN)))
        {
            if (ch->pcdata->clan_status == CLAN_LEADER
            || ch->pcdata->clan_status == CLAN_SECOND)
            {
                act("   .", ch, NULL, NULL, TO_CHAR);
                victim->pcdata->headprice = 0;
                return;
            } else if (IS_IMMORTAL(ch))
            {
                act("   .", ch, NULL, NULL, TO_CHAR);
                victim->pcdata->headprice = 0;
                return;
            } else
            {
                act("   .", ch, NULL, NULL, TO_CHAR);
                return;
            }
        }
        return;
    }

    if (is_number(arg2))
    {
        int amount;
        amount = atoi(arg2);

        clan = clan_lookup(ch->clan);
        if (amount <= 0
        || IS_IMMORTAL(victim)
        || (clan && IS_SET(clan->flags, CLAN_HIDDEN))
        || ch == victim)
        {
            act("    .", ch, NULL, NULL, TO_CHAR);
            return;
        }
        clan = clan_lookup(victim->clan);
        if (clan && IS_SET(clan->flags, CLAN_HIDDEN))
        {
            act("    .", ch, NULL, NULL, TO_CHAR);
            return;
        }
        if (!in_PK (ch, victim) && !IS_IMMORTAL (ch))
        {
            act("    ϣ !", ch, NULL, NULL, TO_CHAR);
            return;
        }

        if ((ch->pcdata->bank_g + ch->gold) < amount && !IS_IMMORTAL(ch))
        {
            act("    !", ch, NULL, NULL, TO_CHAR);
            return;
        }

        if (amount < victim->level)
        {
/*
            act("    {C$N{x: {Y$j {x.",
                ch, (const void *) victim->level, victim, TO_CHAR);
*/
            act("   !", ch, NULL, NULL, TO_CHAR);
            return;
        }
        if (!IS_IMMORTAL(ch))
        {
            ch->pcdata->bank_g -= amount;
            if (ch->pcdata->bank_g < 0)
            {
                ch->gold += ch->pcdata->bank_g;
                ch->pcdata->bank_g = 0;
            }
        }
        victim->pcdata->headprice += amount;
        act("You have appointed compensation in {Y$j gold {xfor a head of {C$N {x. ",
            ch, (const void *) amount, victim, TO_CHAR);       //T 
        act("$N has appointed compensation in {Y$j gold {x for your head {x.",
            victim, (const void *) amount, ch, TO_CHAR); //T
        if (IS_IMMORTAL(ch))
            act("The head {C$N {x now costs {Y$j gold {x.", 
                ch, (const void *) victim->pcdata->headprice, victim, TO_CHAR); //T
        return;
    }
}

void do_element( CHAR_DATA *ch, const char *argument )
{
    int chance;
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));
    
    if (IS_NPC(ch))
    {
        act("MOBs don't have pcdata!", ch, NULL, NULL, TO_CHAR);
        return;
    }
    if ((chance = get_skill (ch, gsn_cannon)) == 0)
    {
        char_act("Huh?", ch);
        return ;
    }
    if (arg1[0] == '\0')
    {
        act("Syntax: element <fire | cold | energy | sound>",
            ch, NULL, NULL, TO_CHAR);
        if (IS_IMMORTAL(ch))
            act("Syntax: element cancel <victim>",
                ch, NULL, NULL, TO_CHAR);
        if (ch->pcdata->element == 0)
            act("Your element status : NONE.", ch, NULL, NULL, TO_CHAR);
        else if (ch->pcdata->element == 1)
            act("Your element status : FIRE.", ch, NULL, NULL, TO_CHAR);
        else if (ch->pcdata->element == 2)
            act("Your element status : COLD.", ch, NULL, NULL, TO_CHAR);
        else if (ch->pcdata->element == 3)
            act("Your element status : ENERGY.", ch, NULL, NULL, TO_CHAR);
        else if (ch->pcdata->element == 4)
            act("Your element status : SOUND.", ch, NULL, NULL, TO_CHAR);
        else
        {
            act("BUGGY! Please note to graymage, if U see it!", ch, NULL, NULL, TO_CHAR);
            ch->pcdata->element = 0;
        }
        return;
    }
    if (ch->pcdata->element != 0 && !IS_IMMORTAL(ch))
    {
        act("You already choose your element status.", ch, NULL, NULL, TO_CHAR);
        return;
    }
    if (chance < 100)
    {
        char_act("You must mastered CANNON!!!", ch);
        return ;
    }
    if (!str_cmp(arg1, "fire") || !str_cmp(arg1, ""))
    {
        act("Your element status : FIRE.", ch, NULL, NULL, TO_CHAR);
        ch->pcdata->element = 1;
        return;
    }
    if (!str_cmp(arg1, "cold") || !str_cmp(arg1, ""))
    {
        act("Your element status : COLD.", ch, NULL, NULL, TO_CHAR);
        ch->pcdata->element = 2;
        return;
    }
    if (!str_cmp(arg1, "energy") || !str_cmp(arg1, ""))
    {
        act("Your element status : ENERGY.", ch, NULL, NULL, TO_CHAR);
        ch->pcdata->element = 3;
        return;
    }
    if (!str_cmp(arg1, "sound") || !str_cmp(arg1, ""))
    {
        act("Your element status : SOUND.", ch, NULL, NULL, TO_CHAR);
        ch->pcdata->element = 4;
        return;
    }

    if (!IS_IMMORTAL(ch) || arg2[0] == '\0')
    {
        do_help(ch, "ELEMENT");
        return;
    }

    if ((victim = get_char_world(ch, arg2)) == NULL)
    {
        act("Such here is not present!", ch, NULL, NULL, TO_CHAR);
        return;
    }
  
    if (IS_NPC(victim))
    {
        act("MOBs don't have pcdata!", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((!str_cmp(arg1, "cancel")
    || !str_cmp(arg1, ""))
    && IS_IMMORTAL(ch))
    {
        act("Canceling all elemental", ch, NULL, NULL, TO_CHAR);
        victim->pcdata->element = 0;
        return;
    } else
    {
        act("What a fuck U wanna do?", ch, NULL, NULL, TO_CHAR);
        return;
    }
}

/*-----------------------------------------------------------------------------
 * toggle bit stuff
 */
typedef struct toggle_t toggle_t;

struct toggle_t 
{
    const char *name;       /* flag name                            */
    const char *desc;       /* toggle description                   */
    flag_t     *f;          /* flag table                           */
    flag64_t    bit;        /* flag bit                             */
    const char *msg_on;     /* msg to print when flag toggled on    */
    const char *msg_off;    /* ---//--- off                         */
    int         min_level;
};

static toggle_t    *toggle_lookup     (const char *name);
static void         toggle_print      (CHAR_DATA *ch, toggle_t *t);
static flag64_t*    toggle_bits       (CHAR_DATA *ch, toggle_t *t);

#define MSG_TOGGLE_AFF_ON        "    'score'."
#define MSG_TOGGLE_AFF_OFF       "     'score'."
#define MSG_TOGGLE_BRIEF_ON      "  ."
#define MSG_TOGGLE_BRIEF_OFF     "  ."
#define MSG_TOGGLE_ON            "$t ."
#define MSG_TOGGLE_OFF           "$t ."
#define MSG_TOGGLE_COLOR_ON      "{BC{Ro{Yl{Co{Gr{x is now {RON{x, !"
#define MSG_TOGGLE_COLOR_OFF     "  , *sigh*"
#define MSG_TOGGLE_COMBO_ON      "Combined inventory selected."
#define MSG_TOGGLE_COMBO_OFF     "Long inventory selected."
#define MSG_TOGGLE_ENG_ON        "You will not see english obj/mob names anymore."
#define MSG_TOGGLE_ENG_OFF       "You will now see english obj/mob names."
#define MSG_TOGGLE_TELNET_ON     "Telnet parser is ON."
#define MSG_TOGGLE_TELNET_OFF    "Telnet parser is OFF."
#define MSG_TOGGLE_IAC_ON        "    ."
#define MSG_TOGGLE_IAC_OFF       "IACs     ."
#define MSG_TOGGLE_VERB_ON       "Now you will see verbose messages."
#define MSG_TOGGLE_VERB_OFF      "You will no longer see verbose messages."
#define MSG_TOGGLE_PROMPT_ON     "  ."
#define MSG_TOGGLE_PROMPT_OFF    "   ."
#define MSG_TOGGLE_GQUEST_ON     "Now you'll hear beautiful global quest information."
#define MSG_TOGGLE_GQUEST_OFF    "You will no longer hear global quest garbage."
#define MSG_TOGGLE_MEMO_ON       "Now you will set memorials on kill." 
#define MSG_TOGGLE_MEMO_OFF      "Now you will not set memorials on kill."
#define MSG_TOGGLE_AGENT_ON      "Now you will see agentnet info."
#define MSG_TOGGLE_AGENT_OFF     "Now you will not see agentnet info." 
#define MSG_TOGGLE_WAR_ON        "Now you will see war info."
#define MSG_TOGGLE_WAR_OFF       "Now you will not see war info." 
#define MSG_TOGGLE_FOLLOWT_ON    "Now you will follow tracks."
#define MSG_TOGGLE_FOLLOWT_OFF   "Now you will not follow tracks."
#define MSG_TOGGLE_VNUM_ON       "Now you will see vnum of mob and objects."
#define MSG_TOGGLE_VNUM_OFF      "Now you will not see vnum of mob and objects"
#define MSG_TOGGLE_ASSIST_ON     "You will now assist when needed."
#define MSG_TOGGLE_ASSIST_OFF    "Autoassist removed."
#define MSG_TOGGLE_DAMAGE_ON     "Autodamage is currently ON."
#define MSG_TOGGLE_DAMAGE_OFF    "Autodamage is currently OFF."
#define MSG_TOGGLE_EXITS_ON      "Exits will now be displayed."
#define MSG_TOGGLE_EXITS_OFF     "Exits will no longer be displayed."
#define MSG_TOGGLE_GOLD_ON       "Automatic gold looting set."
#define MSG_TOGGLE_GOLD_OFF      "Autogold removed."
#define MSG_TOGGLE_SILVER_ON     "Automatic silver looting set."
#define MSG_TOGGLE_SILVER_OFF    "Autosilver removed."
#define MSG_TOGGLE_LOOK_ON       "Automatic corpse examination set."
#define MSG_TOGGLE_LOOK_OFF      "Autolooking removed."
#define MSG_TOGGLE_LOOT_ON       "Automatic corpse looting set."
#define MSG_TOGGLE_LOOT_OFF      "Autolooting removed."
#define MSG_TOGGLE_SAC_ON        "Automatic corpse sacrificing set."
#define MSG_TOGGLE_SAC_OFF       "Autosacrificing removed."
#define MSG_TOGGLE_SPLIT_ON      "Automatic gold splitting set."
#define MSG_TOGGLE_SPLIT_OFF     "Autosplitting removed."
#define MSG_TOGGLE_TITLE_ON      "        ."
#define MSG_TOGGLE_TITLE_OFF     "        ."
#define MSG_TOGGLE_NOSUMM_ON     "         {RPK{x ."
#define MSG_TOGGLE_NOSUMM_OFF    "     ."
#define MSG_TOGGLE_FOLLOW_OFF    "You do not welcome followers."
#define MSG_TOGGLE_FOLLOW_ON     "You accept followers."
#define MSG_TOGGLE_RUSSKILL_OFF  "Skill names are shown in english."
#define MSG_TOGGLE_RUSSKILL_ON   "Skill names are shown in russian."
#define MSG_TOGGLE_RUSEXIT_OFF   "Exits are shown in english."
#define MSG_TOGGLE_RUSEXIT_ON    "Exits are shown in russian."
#define MSG_TOGGLE_RUSNAMES_OFF  "Players' names are shown in english."
#define MSG_TOGGLE_RUSNAMES_ON    "Players' names are shown in russian."


#define MSG_TOGGLE_AFFECTS     "show affects in score"
#define MSG_TOGGLE_BRIEF       "brief descriptions"
#define MSG_TOGGLE_BUST        "bust prompt when hp, mp, mv changed"
#define MSG_TOGGLE_COLOR       "ANSI colors"
#define MSG_TOGGLE_COMPACT     "compact mode"
#define MSG_TOGGLE_COMBINE     "combined items in inventory list"
#define MSG_TOGGLE_LONG        "long flags mode"
#define MSG_TOGGLE_NOENG       "do not display english obj/mob names"
#define MSG_TOGGLE_NOTELNET    "no telnet parser"
#define MSG_TOGGLE_NOIAC       "no IACs in output"
#define MSG_TOGGLE_NOVERBOSE   "no verbose messages"
#define MSG_TOGGLE_PROMPT      "show prompt"
#define MSG_TOGGLE_QUIET       "quiet mode in string editor"
#define MSG_TOGGLE_NOGQUEST    "do not show gquest info and gquest talks"
#define MSG_TOGGLE_MEMORIAL    "memorials on kill"
#define MSG_TOGGLE_AGENTNET    "agentnet info"
#define MSG_TOGGLE_WARINFO     "war info"
#define MSG_TOGGLE_TRACK       "follow tracks automatically"
#define MSG_TOGGLE_VNUM        "show vnum info for mob and objects"
#define MSG_TOGGLE_AUTOASSIST  "makes you help group members in combat"
#define MSG_TOGGLE_SHOWDAMAGE  "show damage in combat"
#define MSG_TOGGLE_SHOWEXIT    "display room exits upon entering a room"
#define MSG_TOGGLE_AUTOGOLD    "take all gold from corspes"
#define MSG_TOGGLE_AUTOSILVER  "take all silver from corspes"
#define MSG_TOGGLE_AUTOLOOK    "automatically look in corpse after combat"
#define MSG_TOGGLE_AUTOLOOT    "take all equipment from corpses"
#define MSG_TOGGLE_AUTOSPLIT   "split up spoils from combat among your group members"
#define MSG_TOGGLE_AUTOSAC     "sacrifice corpses (if autoloot is on, only empty corpses)"
#define MSG_TOGGLE_AUTOWEATHE  "automatically show weather at movement"
#define MSG_TOGGLE_AUTOTITLE   "automaticaly change title on level gain"
#define MSG_TOGGLE_FOLLOW      "restrict followes"
#define MSG_TOGGLE_NOSUMM      "resrict summoning for non PK-range players"
#define MSG_TOGGLE_RUSSKILL    "show skill names in russian"
#define MSG_TOGGLE_RUSEXIT     "show exits in russian"
#define MSG_TOGGLE_RUSNAMES    "show players' names in russian"

/*
 * alphabetize these table by name if you are adding new entries
 */
toggle_t toggle_table[] =
{
  { "affects",     MSG_TOGGLE_AFFECTS,    comm_flags,    COMM_SHOWAFF,      MSG_TOGGLE_AFF_ON,     MSG_TOGGLE_AFF_OFF,       1 },
  { "brief",       MSG_TOGGLE_BRIEF,      comm_flags,    COMM_BRIEF,        MSG_TOGGLE_BRIEF_ON,   MSG_TOGGLE_BRIEF_OFF,     1 },
  { "bust prompt", MSG_TOGGLE_BUST,       comm_flags,    COMM_BUST_PROMPT,  MSG_TOGGLE_ON,         MSG_TOGGLE_OFF,           1 },
  { "color",       MSG_TOGGLE_COLOR,      comm_flags,    COMM_COLOR,        MSG_TOGGLE_COLOR_ON,   MSG_TOGGLE_COLOR_OFF,     1 },
  { "compact",     MSG_TOGGLE_COMPACT,    comm_flags,    COMM_COMPACT,      MSG_TOGGLE_ON,         MSG_TOGGLE_OFF,           1 },
  { "combine",     MSG_TOGGLE_COMBINE,    comm_flags,    COMM_COMBINE,      MSG_TOGGLE_COMBO_ON,   MSG_TOGGLE_COMBO_OFF,     1 },
  { "long flags",  MSG_TOGGLE_LONG,       comm_flags,    COMM_LONG,         MSG_TOGGLE_ON,         MSG_TOGGLE_OFF,           1 },
  { "noeng",       MSG_TOGGLE_NOENG,      comm_flags,    COMM_NOENG,        MSG_TOGGLE_ENG_ON,     MSG_TOGGLE_ENG_OFF,       1 },
  { "notelnet",    MSG_TOGGLE_NOTELNET,   comm_flags,    COMM_NOTELNET,     MSG_TOGGLE_TELNET_OFF, MSG_TOGGLE_TELNET_ON,     1 },
  { "noiac",       MSG_TOGGLE_NOIAC,      comm_flags,    COMM_NOIAC,        MSG_TOGGLE_IAC_OFF,    MSG_TOGGLE_IAC_ON,        1 },
  { "noverbose",   MSG_TOGGLE_NOVERBOSE,  comm_flags,    COMM_NOVERBOSE,    MSG_TOGGLE_VERB_OFF,   MSG_TOGGLE_VERB_ON,       1 },
  { "prompt",      MSG_TOGGLE_PROMPT,     comm_flags,    COMM_PROMPT,       MSG_TOGGLE_PROMPT_ON,  MSG_TOGGLE_PROMPT_OFF,    1 },
  { "quiet edit",  MSG_TOGGLE_QUIET,      comm_flags,    COMM_QUIET_EDITOR, MSG_TOGGLE_ON,         MSG_TOGGLE_OFF,           1 },
  { "nogquest",    MSG_TOGGLE_NOGQUEST,   comm_flags,    COMM_NOGQUEST,     MSG_TOGGLE_GQUEST_OFF, MSG_TOGGLE_GQUEST_ON,     1 },
  { "memorial",    MSG_TOGGLE_MEMORIAL,   comm_flags,    COMM_MEMORIAL,     MSG_TOGGLE_MEMO_ON,    MSG_TOGGLE_MEMO_OFF,      1 },
  { "agentnet",    MSG_TOGGLE_AGENTNET,   comm_flags,    COMM_AGENTNET,     MSG_TOGGLE_AGENT_ON,   MSG_TOGGLE_AGENT_OFF,     1 }, 
  { "warinfo",     MSG_TOGGLE_WARINFO,    comm_flags,    COMM_WARINFO,      MSG_TOGGLE_WAR_ON,     MSG_TOGGLE_WAR_OFF,       1 }, 
  { "track",       MSG_TOGGLE_TRACK,      comm_flags,    COMM_TRACK,        MSG_TOGGLE_FOLLOWT_ON, MSG_TOGGLE_FOLLOWT_OFF,   1 },
  { "vnum",        MSG_TOGGLE_VNUM,       comm2_flags,   COMM2_VNUM_SHOW,   MSG_TOGGLE_VNUM_ON,    MSG_TOGGLE_VNUM_OFF,     92 },
  { "assist",      MSG_TOGGLE_AUTOASSIST, plr_flags,     PLR_AUTOASSIST,    MSG_TOGGLE_ASSIST_ON,  MSG_TOGGLE_ASSIST_OFF,    1 },
  { "showdamage",  MSG_TOGGLE_SHOWDAMAGE, plr_flags,     PLR_AUTODAMAGE,    MSG_TOGGLE_DAMAGE_ON,  MSG_TOGGLE_DAMAGE_OFF,    1 },
  { "showexit",    MSG_TOGGLE_SHOWEXIT,   plr_flags,     PLR_AUTOEXIT,      MSG_TOGGLE_EXITS_ON,   MSG_TOGGLE_EXITS_OFF,     1 },
  { "gold",        MSG_TOGGLE_AUTOGOLD,   plr_flags,     PLR_AUTOGOLD,      MSG_TOGGLE_GOLD_ON,    MSG_TOGGLE_GOLD_OFF,      1 },
  { "silver",      MSG_TOGGLE_AUTOSILVER, plr_flags,     PLR_AUTOSILVER,    MSG_TOGGLE_SILVER_ON,  MSG_TOGGLE_SILVER_OFF,    1 },
  { "look",        MSG_TOGGLE_AUTOLOOK,   plr_flags,     PLR_AUTOLOOK,      MSG_TOGGLE_LOOK_ON,    MSG_TOGGLE_LOOK_OFF,      1 },
  { "loot",        MSG_TOGGLE_AUTOLOOT,   plr_flags,     PLR_AUTOLOOT,      MSG_TOGGLE_LOOT_ON,    MSG_TOGGLE_LOOT_OFF,      1 },
  { "split",       MSG_TOGGLE_AUTOSPLIT,  plr_flags,     PLR_AUTOSPLIT,     MSG_TOGGLE_SPLIT_ON,   MSG_TOGGLE_SPLIT_OFF,     1 },
  { "sacrifi",     MSG_TOGGLE_AUTOSAC,    plr_flags,     PLR_AUTOSAC,       MSG_TOGGLE_SAC_ON,     MSG_TOGGLE_SAC_OFF,       1 },
  { "weather",     MSG_TOGGLE_AUTOWEATHE, plr_flags,     PLR_AUTOWEATHER,   MSG_TOGGLE_ON,         MSG_TOGGLE_OFF,           1 },
  { "title",       MSG_TOGGLE_AUTOTITLE,  plr_flags,     PLR_AUTOTITLE,     MSG_TOGGLE_TITLE_ON,   MSG_TOGGLE_TITLE_OFF,     1 },
  { "nosummon",    MSG_TOGGLE_NOSUMM,     plr_flags,     PLR_NOSUMMON,      MSG_TOGGLE_NOSUMM_ON,  MSG_TOGGLE_NOSUMM_OFF,    1 },
  { "nofollow",    MSG_TOGGLE_FOLLOW,     plr_flags,     PLR_NOFOLLOW,      MSG_TOGGLE_FOLLOW_OFF, MSG_TOGGLE_FOLLOW_ON,     1 },
  { "russkill",    MSG_TOGGLE_RUSSKILL,   comm2_flags,   COMM2_RUSSKILLS,   MSG_TOGGLE_RUSSKILL_ON,MSG_TOGGLE_RUSSKILL_OFF,  1 },
  { "rusexit" ,    MSG_TOGGLE_RUSEXIT,    comm2_flags,   COMM2_RUSEXIT,     MSG_TOGGLE_RUSEXIT_ON, MSG_TOGGLE_RUSEXIT_OFF,   1 },
  { "rusnames" ,   MSG_TOGGLE_RUSNAMES,   comm2_flags,   COMM2_RUSNAMES,    MSG_TOGGLE_RUSNAMES_ON,MSG_TOGGLE_RUSNAMES_OFF,  1 },
  { NULL }
};

DO_FUN(do_toggle)
{
    toggle_t *t;
    char arg[MAX_INPUT_LENGTH];

    argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0') 
    {
        act("Current settings:", ch, NULL, NULL, TO_CHAR);
        for (t = toggle_table; t->name; t++)
            if (ch->level >= t->min_level)
                  toggle_print(ch, t);
        return;
    }

    for (; arg[0]; argument = one_argument(argument, arg, sizeof(arg))) 
    {
        flag64_t* bits;

        if ((t = toggle_lookup(arg)) == NULL  ||  (bits = toggle_bits(ch, t)) == NULL)
            continue;

        if (ch->level >= t->min_level)
        {
            TOGGLE_BIT(*bits, t->bit);
            act_puts(IS_SET(*bits, t->bit) ? t->msg_on : t->msg_off, ch, t->desc, NULL, TO_CHAR, POS_DEAD);
        }
    }
}

static toggle_t *toggle_lookup(const char *name)
{
    toggle_t *t;

    for (t = toggle_table; t->name; t++)
        if (!str_prefix(name, t->name))
            break;
    return t;
}

static void toggle_print(CHAR_DATA *ch, toggle_t *t)
{
    flag64_t *bits;

    if ((bits = toggle_bits(ch, t)) < 0)
        return;

    act_puts3("  $FL10{$T} - ", ch, t->desc, t->name, IS_SET(*bits, t->bit) ? "ON" : "OFF", TO_CHAR | ACT_NOLF , POS_DEAD);
    act_puts3("$FL3{$U} ($t)", ch, t->desc, t->name, IS_SET(*bits, t->bit) ? "ON" : "OFF", TO_CHAR | ACT_TRANS, POS_DEAD);
}

static flag64_t* toggle_bits(CHAR_DATA *ch, toggle_t *t)
{
    if (t->f == comm_flags)
        return &ch->comm;
        
    if (t->f == comm2_flags)
        return &ch->comm2;

    if (t->f == plr_flags)
        return &ch->plr_flags;
        
    return NULL;
}

/* How to make a string look drunk... by Apex (robink@htsa.hva.nl) */
/* Modified and enhanced for envy(2) by the Maniac from Mythran */
/* Further mods/upgrades for ROM 2.4 by Kohl Desenee */

char *makedrunk( char *string, CHAR_DATA * ch )
{
/* This structure defines all changes for a character */
    static struct struckdrunk drunk[] = {
        {3, 10,
         {"a", "a", "a", "A", "aa", "ah", "Ah", "ao", "aw", "oa", "ahhhh"}},
        {8, 5,
         {"b", "b", "b", "B", "B", "vb"}},
        {3, 5,
         {"c", "c", "C", "cj", "sj", "zj"}},
        {5, 2,
         {"d", "d", "D"}},
        {3, 3,
         {"e", "e", "eh", "E"}},
        {4, 5,
         {"f", "f", "ff", "fff", "fFf", "F"}},
        {8, 2,
         {"g", "g", "G"}},
        {9, 6,
         {"h", "h", "hh", "hhh", "Hhh", "HhH", "H"}},
        {7, 6,
         {"i", "i", "Iii", "ii", "iI", "Ii", "I"}},
        {9, 5,
         {"j", "j", "jj", "Jj", "jJ", "J"}},
        {7, 2,
         {"k", "k", "K"}},
        {3, 2,
         {"l", "l", "L"}},
        {5, 8,
         {"m", "m", "mm", "mmm", "mmmm", "mmmmm", "MmM", "mM", "M"}},
        {6, 6,
         {"n", "n", "nn", "Nn", "nnn", "nNn", "N"}},
        {3, 6,
         {"o", "o", "ooo", "ao", "aOoo", "Ooo", "ooOo"}},
        {3, 2,
         {"p", "p", "P"}},
        {5, 5,
         {"q", "q", "Q", "ku", "ququ", "kukeleku"}},
        {4, 2,
         {"r", "r", "R"}},
        {2, 5,
         {"s", "ss", "zzZzssZ", "ZSssS", "sSzzsss", "sSss"}},
        {5, 2,
         {"t", "t", "T"}},
        {3, 6,
         {"u", "u", "uh", "Uh", "Uhuhhuh", "uhU", "uhhu"}},
        {4, 2,
         {"v", "v", "V"}},
        {4, 2,
         {"w", "w", "W"}},
        {5, 6,
         {"x", "x", "X", "ks", "iks", "kz", "xz"}},
        {3, 2,
         {"y", "y", "Y"}},
        {2, 9,
         {"z", "z", "ZzzZz", "Zzz", "Zsszzsz", "szz", "sZZz", "ZSz", "zZ", "Z"}}
    };

    static char buf[7 * MAX_INPUT_LENGTH];
    char temp;
    int pos = 0;
    int drunklevel;
    int randomnum;

    buf[0] = '\0';

    /* Check how drunk a person is... */
    if ( IS_NPC( ch ) )
        drunklevel = 0;
    else
        drunklevel = ch->pcdata->condition[COND_DRUNK];

    if ( drunklevel > 0 )
    {
        do
        {
            temp = toupper( *string );
            if ( ( temp >= 'A' ) && ( temp <= 'Z' ) )
            {
                if ( drunklevel > drunk[temp - 'A'].min_drunk_level )
                {
                    randomnum =
                        number_range( 0, drunk[temp - 'A'].number_of_rep );
                    strnzcpy(buf+pos, sizeof(buf) - pos * sizeof(char),
                            drunk[temp - 'A'].replacement[randomnum] );
                    pos += strlen( drunk[temp - 'A'].replacement[randomnum] );
                }
                else
                    buf[pos++] = *string;
            }
            else
            {
                if ( ( temp >= '0' ) && ( temp <= '9' ) )
                {
                    temp = '0' + number_range( 0, 9 );
                    buf[pos++] = temp;
                }
                else
                    buf[pos++] = *string;
            }
        }
        while ( *string++ );
        buf[pos] = '\0';        /* Mark end of the string... */
        strnzcpy(string, sizeof(string), buf );
        return ( string );
    }
    return ( string );
}

void info( CHAR_DATA * ch, int level, const char * message, ...)
{
    char buf[MAX_STRING_LENGTH];
    DESCRIPTOR_DATA * d;
    va_list args;

    va_start(args,message);
    vsnprintf(buf, MAX_STRING_LENGTH, message, args);
    va_end(args);

    for ( d = descriptor_list; d; d = d->next )
    {
        if (d->connected == CON_PLAYING
        && d->character != ch
        && d->character->level >= level
        && IS_SET(d->character->comm, COMM_INFO))
           char_act(buf, d->character);
    }
}

void do_info(CHAR_DATA * ch, const char * argument)
{
    if (IS_SET(ch->comm,COMM_INFO))
    {
        char_act("Info channel is now OFF.", ch);
        REMOVE_BIT(ch->comm, COMM_INFO);
    }
    else
    {
        char_act("Info channel is now ON.", ch);
        SET_BIT(ch->comm, COMM_INFO);
    }
}

DO_FUN(do_listen)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    argument = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0') 
    {
        act("Listen whom?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((victim = get_char_room(ch, arg)) == NULL) 
    {
        act("They aren't here.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!IS_NULLSTR(mlstr_mval(victim->listen_data)))
    {
        act("$N tells you:", ch, NULL, victim, TO_CHAR);
        act("{G", ch, NULL, NULL, TO_CHAR | ACT_NOLF);
        char_mlact(victim->listen_data, ch);
        act("{x", ch, NULL, NULL, TO_CHAR | ACT_NOLF);
    }
    else
        act("$gN{He} has nothing to tell you.", ch, NULL, victim, TO_CHAR);
}
