/* $Id: act_info.c,v 1.666 2004/09/20 10:49:46 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
 /************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/


#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <stdarg.h>

#if !defined (WIN32)
#include <unistd.h>
#include <sys/time.h>
#endif
#include <ctype.h>

#include "merc.h"
#include "update.h"
#include "quest.h"
#include "obj_prog.h"
#include "fight.h"
#include "db/db.h"
#include "db/lang.h"
#include "riddle.h"
#include "rating.h"
#include "wanderers.h"
#include "conquer.h"
#include "wquest.h"
#include "shamans.h"

#define MAX_SKILL 1024

#if defined(SUNOS) || defined(SVR4)
#include <crypt.h>
#endif

extern STAT_DATA stat_record;

/* command procedures needed */
DECLARE_DO_FUN(do_exits         );
DECLARE_DO_FUN(do_look          );
DECLARE_DO_FUN(do_help          );
DECLARE_DO_FUN(do_affects       );
DECLARE_DO_FUN(do_saffects      );
DECLARE_DO_FUN(do_gaffects      );
DECLARE_DO_FUN(do_murder        );
DECLARE_DO_FUN(do_say           );
DECLARE_DO_FUN(do_alist         );

char *get_stat_alias(CHAR_DATA *ch, int which);
void    bust_a_prompt           (CHAR_DATA *ch);
void look_window( CHAR_DATA *ch, OBJ_DATA *obj );
void look_gate  ( CHAR_DATA *ch, OBJ_DATA *obj );

bool            wizlock;        /* Game is wizlocked        */
bool            newlock;        /* Game is newlocked        */

extern MOB_EXTRA created_golem_extra[];
//TODO: test
static int show_order[] = {
    WEAR_LIGHT,
    WEAR_HEAD,
    WEAR_EAR,
    WEAR_FACE,
    WEAR_NECK_1,
    WEAR_ABOUT,
    WEAR_ARMS,
    WEAR_BODY,
    WEAR_WAIST,
    WEAR_WRIST_L,
    WEAR_WRIST_R,
    WEAR_FINGER_L,
    WEAR_FINGER_R,
    WEAR_HANDS,
    WEAR_WIELD,
    WEAR_SECOND_WIELD,
    WEAR_SHIELD,
    WEAR_HOLD,
    WEAR_LEGS,
    WEAR_FEET,
    WEAR_TAIL,
    WEAR_TATTOO,
    WEAR_CLANMARK,
    WEAR_PLUG_IN,
    WEAR_FLOAT,
    -1
};

typedef struct pskill
{
    char name[22];
    int  prac;
} pskill;

/* for do_count */
int max_on = 0;

/*
 * Local functions.
 */
char *  format_obj_to_char      (OBJ_DATA *obj, CHAR_DATA *ch, bool fShort);
void    show_list_to_char       (OBJ_DATA *list, CHAR_DATA *ch,
                                 bool fShort, bool fShowNothing);
void    show_char_to_char_0     (CHAR_DATA *victim, CHAR_DATA *ch);
void    show_char_to_char_1     (CHAR_DATA *victim, CHAR_DATA *ch);
void    show_char_to_char       (CHAR_DATA *list, CHAR_DATA *ch);
void    show_wanted_desk        (CHAR_DATA *ch);

#define strend(s) (strchr(s, '\0'))

char *format_obj_to_char(OBJ_DATA *obj, CHAR_DATA *ch, bool fShort)
{
    static char buf[MAX_STRING_LENGTH];

    buf[0] = '\0';
    if ((fShort && mlstr_null(obj->short_descr))  || mlstr_null(obj->description))
        return str_empty;

    if (IS_SET(ch->comm, COMM_LONG))
    {
        if (IS_OBJ_STAT(obj, ITEM_INVIS))
            strnzcat(buf, sizeof(buf), GETMSG("({yInvisible{x) ", ch->lang));
        if (IS_OBJ_STAT(obj, ITEM_DARK))
            strnzcat(buf, sizeof(buf), GETMSG("({DDark{x) ", ch->lang));
        if (IS_AFFECTED(ch, AFF_DETECT_EVIL) && IS_OBJ_STAT(obj, ITEM_EVIL))
            strnzcat(buf, sizeof(buf), GETMSG("({RRed Aura{x) ", ch->lang));
        if (IS_AFFECTED(ch, AFF_DETECT_GOOD) && IS_OBJ_STAT(obj, ITEM_BLESS))
            strnzcat(buf, sizeof(buf), GETMSG("({BBlue Aura{x) ", ch->lang));
        if (IS_AFFECTED(ch, AFF_DETECT_MAGIC)  && IS_OBJ_STAT(obj, ITEM_MAGIC))
            strnzcat(buf, sizeof(buf), GETMSG("({MMagic{x) ", ch->lang));
        if (IS_OBJ_STAT(obj, ITEM_GLOW))
            strnzcat(buf, sizeof(buf), GETMSG("({WGlow{x) ", ch->lang));
        if (IS_OBJ_STAT(obj, ITEM_HUM))
            strnzcat(buf, sizeof(buf), GETMSG("({Y{x) ", ch->lang));
    } else
    {
        static char FLAGS[] = "{x[{y.{D.{R.{B.{M.{W.{Y.{x] ";
        strnzcpy(buf, sizeof(buf), FLAGS);
        if (IS_OBJ_STAT(obj, ITEM_INVIS))                                          buf[5]  = 'I';
        if (IS_OBJ_STAT(obj, ITEM_DARK))                                           buf[8]  = 'D';
        if (IS_AFFECTED(ch, AFF_DETECT_EVIL)   && IS_OBJ_STAT(obj, ITEM_EVIL))     buf[11] = 'E';
        if (IS_AFFECTED(ch, AFF_DETECT_GOOD)   && IS_OBJ_STAT(obj,ITEM_BLESS))     buf[14] = 'B';
        if (IS_AFFECTED(ch, AFF_DETECT_MAGIC)  && IS_OBJ_STAT(obj, ITEM_MAGIC))    buf[17] = 'M';
        if (IS_OBJ_STAT(obj, ITEM_GLOW))                                           buf[20] = 'G';
        if (IS_OBJ_STAT(obj, ITEM_HUM))                                            buf[23] = 'H';

    }

// FIXME:     

    if (!IS_NPC(ch) && IS_SET(ch->comm2, COMM2_VNUM_SHOW))
        if (ch->pcdata->security > 1 || IS_IMMORTAL (ch))
        {
            char buf1[MAX_STRING_LENGTH];
            snprintf(buf1, sizeof(buf1), "[%6d] ", obj->pIndexData->vnum);
            strnzcat(buf, sizeof(buf), buf1);
        }

    if (fShort)
    {
        strnzcat(buf, sizeof(buf), format_short(obj->short_descr, obj->name, ch, 0));

        if (obj->pIndexData->vnum > 5  && (obj->condition < COND_EXCELLENT))
        {
            char buf2[MAX_STRING_LENGTH];
            snprintf(buf2, sizeof(buf2), " [%s]",  GETMSG(get_cond_alias(obj), ch->lang));
            strnzcat(buf, sizeof(buf), buf2);
        }
        return buf;
    }

    if (obj->in_room != NULL && IS_WATER(obj->in_room))
    {
        char* p;

        p = strend(buf);
        strnzcat(buf, sizeof(buf), format_short(obj->short_descr, obj->name, ch, 0));
        p[0] = UPPER(p[0]);
        switch (dice(1,3))
        {
            case 1:
                strnzcat(buf, sizeof(buf), GETMSG("    .", ch->lang));
                break;
            case 2:
                strnzcat(buf, sizeof(buf), GETMSG("   .", ch->lang));
                break;
            case 3:
                strnzcat(buf, sizeof(buf), GETMSG("   .", ch->lang));
                break;
        }
    } else
        strnzcat(buf, sizeof(buf), format_descr(obj->description, ch));
    return buf;
}

/*
 * Show a list to a character.
 * Can coalesce duplicated items.
 */
void show_list_to_char(OBJ_DATA *list, CHAR_DATA *ch, bool fShort, bool fShowNothing)
{
    BUFFER       *output;
    const char  **prgpstrShow;
    int          *prgnShow;
    char         *pstrShow;
    OBJ_DATA     *obj;
    int           nShow;
    int           iShow;
    int           count;
    bool          fCombine;

    if (ch->desc == NULL)
        return;

    /*
     * Alloc space for output lines.
     */
    output = buf_new(-1);

    count = 0;
    for (obj = list; obj != NULL; obj = obj->next_content)
        count++;
    prgpstrShow = malloc(count * sizeof(char *));
    prgnShow    = malloc(count * sizeof(int)  );
    nShow   = 0;

    /*
     * Format the list of objects.
     */
    for (obj = list; obj != NULL; obj = obj->next_content)
    {
        if (obj->wear_loc == WEAR_NONE && can_see_obj(ch, obj))
        {
            pstrShow = format_obj_to_char(obj, ch, fShort);

            fCombine = FALSE;

            if (IS_NPC(ch) || IS_SET(ch->comm, COMM_COMBINE))
            {
                /*
                 * Look for duplicates, case sensitive.
                 * Matches tend to be near end so run loop
                 * backwords.
                 */
                for (iShow = nShow - 1; iShow >= 0; iShow--)
                {
                    if (!strcmp(prgpstrShow[iShow], pstrShow))
                    {
                        prgnShow[iShow]++;
                        fCombine = TRUE;
                        break;
                    }
                }
            }

            /*
             * Couldn't combine, or didn't want to.
             */
            if (!fCombine)
            {
                prgpstrShow [nShow] = str_dup(pstrShow);
                prgnShow    [nShow] = 1;
                nShow++;
            }
        }
    }

    /*
     * Output the formatted list.
     */
    for (iShow = 0; iShow < nShow; iShow++)
    {
        if (prgpstrShow[iShow][0] == '\0')
            continue;

        if (IS_NPC(ch) || IS_SET(ch->comm, COMM_COMBINE))
        {
            if (prgnShow[iShow] != 1)
                buf_printf(output, "(%2d) ", prgnShow[iShow]);
            else
                buf_add(output,"     ");
        }

        buf_add(output, prgpstrShow[iShow]);
        buf_add(output,"\n");
        free_string(prgpstrShow[iShow]);
    }

    if (fShowNothing && nShow == 0)
    {
        if (IS_NPC(ch) || IS_SET(ch->comm, COMM_COMBINE))
            char_puts("     ", ch);
        act(".", ch, NULL, NULL, TO_CHAR);
    }

    page_to_char(buf_string(output),ch);

    /*
     * Clean up.
     */
    buf_free(output);
    free(prgpstrShow);
    free(prgnShow);
}

#define FLAG_SET(pos, c, exp) (FLAGS[pos] = (exp) ? (flags = TRUE, c) : '.')

void show_char_to_char_0(CHAR_DATA *victim, CHAR_DATA *ch)
{
    const char *msg = str_empty;
    const void *arg = str_empty;
    const void *arg3 = str_empty;
    flag32_t flags = 0;

    if (is_affected(victim, gsn_doppelganger)  && (IS_NPC(ch) || !IS_SET(ch->plr_flags, PLR_HOLYLIGHT)))
        victim = victim->doppel;

    if (IS_NPC(victim))
    {
        if (IS_IMMORTAL(ch) && IS_SET(ch->comm2, COMM2_VNUM_SHOW))
            act_puts("{D[{w$j{D]{x ", ch, (const void *)victim->pIndexData->vnum, victim, TO_CHAR | ACT_NOLF, POS_DEAD);

        if (!IS_NPC(ch) && ch->pcdata->questmob > 0   && victim->hunter == ch)
            act_puts("{r[{RTARGET{r]{x ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
    } else
    {
        if (IS_SET(victim->plr_flags, PLR_WANTED) && IS_IMMORTAL(ch))
            act_puts("({RWanted{x) ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);

        if (IS_SET(victim->comm, COMM_AFK))
            act_puts("{w[{MAFK{w]{x ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
    }

    if (IS_SET(ch->comm, COMM_LONG))
    {
        if (IS_AFFECTED(victim, AFF_INVIS))
            act_puts("({y{x) ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
        if (IS_AFFECTED(victim, AFF_HIDE))
            act_puts("({D{x) ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
        if (IS_AFFECTED(victim, AFF_CHARM))
            act_puts("({m{x) ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
        if (IS_AFFECTED(victim, AFF_PASS_DOOR))
            act_puts("({c{x) ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
        if (IS_AFFECTED(victim, AFF_FAERIE_FIRE))
            act_puts("({M {x) ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
        if (IS_UNDEAD(victim) && IS_AFFECTED(ch, AFF_DETECT_UNDEAD))
            act_puts("({DUndead{x) ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
        if (RIDDEN(victim))
            act_puts("({G{x) ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
        if (IS_AFFECTED(victim,AFF_IMP_INVIS))
            act_puts("({b{x) ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
        if (IS_EVIL(victim) && IS_AFFECTED(ch, AFF_DETECT_EVIL))
            act_puts("({R {x) ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
        if (IS_GOOD(victim) && IS_AFFECTED(ch, AFF_DETECT_GOOD))
            act_puts("({Y {x) ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
        if (IS_AFFECTED(victim, AFF_SANCTUARY))
            act_puts("({W {x) ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
        if (IS_AFFECTED(victim, AFF_BLACK_SHROUD))
            act_puts("({D {x) ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
        if (IS_AFFECTED(victim, AFF_FADE))
            act_puts("({y{x) ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
        if (IS_AFFECTED(victim, AFF_CAMOUFLAGE))
            act_puts("({g{x) ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
        if (IS_AFFECTED(victim, AFF_TRAP))
            act_puts("({D{x) ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
        if (IS_AFFECTED(victim, AFF_EARTHFADE))
            act_puts("({r {x) ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
        if (IS_AFFECTED(victim, AFF_PROTECTION))
            act_puts("({c{x)", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
    } else
    {
        static char FLAGS[] =
        "{x[{y.{D.{m.{c.{M.{D.{G.{b.{R.{Y.{W.{y.{g.{r.{c.{x] ";
        bool flags = FALSE;

        FLAG_SET( 5, 'I', IS_AFFECTED(victim, AFF_INVIS));
        FLAG_SET( 8, 'H', IS_AFFECTED(victim, AFF_HIDE));
        FLAG_SET(11, 'C', IS_AFFECTED(victim, AFF_CHARM));
        FLAG_SET(14, 'T', IS_AFFECTED(victim, AFF_PASS_DOOR));
        if (IS_AFFECTED(victim, AFF_TRAP))
        {
            FLAG_SET(17, 'T', TRUE);
            FLAG_SET(16, 'D', TRUE);
        } else if (IS_AFFECTED(victim, AFF_FAERIE_FIRE))
        {
            FLAG_SET(17, 'P', TRUE);
            FLAG_SET(16, 'M', TRUE);
        } else
        {
            FLAG_SET(17, 'P', FALSE);
            FLAG_SET(16, 'M', FALSE);
        }
        FLAG_SET(20, 'U', IS_UNDEAD(victim) && IS_AFFECTED(ch, AFF_DETECT_UNDEAD));
        FLAG_SET(23, 'R', RIDDEN(victim));
        FLAG_SET(26, 'I', IS_AFFECTED(victim, AFF_IMP_INVIS));
        FLAG_SET(29, 'E', IS_EVIL(victim) && IS_AFFECTED(ch, AFF_DETECT_EVIL));
        FLAG_SET(32, 'G', IS_GOOD(victim) && IS_AFFECTED(ch, AFF_DETECT_GOOD));
        FLAG_SET(35, 'S', IS_AFFECTED(victim, AFF_SANCTUARY));
        FLAG_SET(34, 'W', IS_AFFECTED(victim, AFF_SANCTUARY));

        if (IS_AFFECTED(victim, AFF_BLACK_SHROUD))
        {
            FLAG_SET(35, 'B', TRUE);
            FLAG_SET(34, 'D', TRUE);
        }

        FLAG_SET(38, 'C', IS_AFFECTED(victim, AFF_CAMOUFLAGE));
        FLAG_SET(41, 'F', IS_AFFECTED(victim, AFF_FADE));
        FLAG_SET(44, 'E', IS_AFFECTED(victim, AFF_EARTHFADE));
        FLAG_SET(47, 'P', IS_AFFECTED(victim, AFF_PROTECTION));

        if (flags)
            char_puts(FLAGS, ch);
    }

    if (victim->invis_level >= LEVEL_HERO)
        act_puts("[{WWizi{x] ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
    if (victim->incog_level >= LEVEL_HERO)
        act_puts("[{DIncog{x] ", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);

    if (IS_NPC(victim) && victim->position == victim->start_pos)
    {
        const char *p = format_descr(victim->long_descr, ch);

        if (!IS_NULLSTR(p))     /* for the hell of "It" (#2006) :) */
            act_puts(p, ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
        return;
    }


    if (IS_IMMORTAL(victim))
        act_puts("{W", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);
    else
        act_puts("{x", ch, NULL, victim, TO_CHAR | ACT_NOLF, POS_DEAD);

    switch (victim->position)
    {
        case POS_DEAD:
            msg = "$N {xis DEAD!!";
            break;

        case POS_MORTAL:
            msg = "$N {xis mortally wounded.";
            break;

        case POS_INCAP:
            msg = "$N {xis incapacitated.";
            break;

        case POS_STUNNED:
            msg = "$N {xis lying here stunned.";
            break;

        case POS_SLEEPING:
            if (victim->on == NULL)
            {
                msg = "$N {xis sleeping here.";
                break;
            }

            arg = victim->on;
            if (IS_SET(victim->on->value[2], SLEEP_AT))
                msg = "$N {xis sleeping at $p.";
            else if (IS_SET(victim->on->value[2], SLEEP_ON))
                msg = "$N {xis sleeping on $p.";
            else
                msg = "$N {xis sleeping in $p.";
            break;

        case POS_RESTING:
            if (victim->on == NULL)
            {
                msg = "$N {xis resting here.";
                break;
            }

            arg = victim->on;
            if (IS_SET(victim->on->value[2], REST_AT))
                msg = "$N {xis resting at $p.";
            else if (IS_SET(victim->on->value[2], REST_ON))
                msg = "$N {xis resting on $p.";
            else
                msg = "$N {xis resting in $p.";
            break;

        case POS_SITTING:
            if (victim->on == NULL)
            {
                msg = "$N {xis sitting here.";
                break;
            }

            arg = victim->on;
            if (IS_SET(victim->on->value[2], SIT_AT))
                msg = "$N {xis sitting at $p.";
            else if (IS_SET(victim->on->value[2], SIT_ON))
                msg = "$N {xis sitting on $p.";
            else
                msg = "$N {xis sitting in $p.";
            break;

        case POS_STANDING:
            if (victim->on == NULL)
            {
                if (!IS_NPC(victim)
                    &&  !IS_SET(ch->comm, COMM_BRIEF)
                    && victim->pcdata->title)
                    arg = victim->pcdata->title;

                if (MOUNTED(victim))
                {
                    arg3 = MOUNTED(victim);
                    msg = "$N{x$t {xis here, riding $I.";
                } else
                    msg = "$N{x$t {xis here.";
                break;
            }

            arg = victim->on;
            if (IS_SET(victim->on->value[2],STAND_AT))
                msg = "$N {xis standing at $p.";
            else if (IS_SET(victim->on->value[2],STAND_ON))
                msg = "$N {xis standing on $p.";
            else
                msg = "$N {xis standing in $p.";
            break;

        case POS_FIGHTING:
            if (victim->fighting == NULL)
            {
                arg = "thin air??";
                flags = ACT_TRANS;
                msg = "$N {xis here, fighting with $t.";
            } else if (victim->fighting == ch)
            {
                arg = "YOU!";
                flags = ACT_TRANS;
                msg = "$N {xis here, fighting with $t.";
            } else if (victim->in_room == victim->fighting->in_room)
            {
                arg = victim->fighting;
                msg = "$N {xis here, fighting with $i.";
            } else
            {
                arg = "someone who left??";
                flags = ACT_TRANS;
                msg = "$N {xis here, fighting with $t.";
            }
            break;
    }

    act_puts3(msg, ch, arg, victim, arg3, TO_CHAR | ACT_FORMSH | flags, POS_DEAD);

}

char* wear_loc_names[] =
{
    "<>          $t",
    "< >         $t",
    "< >         $t",
    "< >            $t",
    "< >             $t",
    "< >           $t",
    "< >         $t",
    "< >          $t",
    "< >        $t",
    "< >          $t",
    "< >         $t",
    "<>               $t",
    "< >       $t",
    "< >      $t",
    "<  > $t",
    "<  >$t",
    "<>            $t",
    "<  >    $t",
    "< >      $t",
    "< >$t",
    "< >     $t",
    "< >     $t",
    "<>          $t",
    "<  >$t",
    "< >         $t",
    "< >           $t",
};

void show_obj_to_char(CHAR_DATA *ch, OBJ_DATA *obj, flag32_t wear_loc)
{
    bool can_see = can_see_obj(ch, obj);
    act(wear_loc_names[wear_loc], ch,  can_see ? format_obj_to_char(obj, ch, TRUE) : "-",  NULL, TO_CHAR | (can_see ? 0 : ACT_TRANS));
}

void do_lore_area(CHAR_DATA *ch, const char* argument)
{
    int chance;
    int index;
    int mana;
    AREA_DATA *pArea;
    char arg[MAX_INPUT_LENGTH];

    mana = SKILL(sn_lookup("lore"))->min_mana;
    if (ch->mana < mana)
    {
        char_act("You don't have enough mana.", ch);
        return;
    }
    ch->mana -= mana;

    pArea = NULL;
    index = number_range(2, area_last->vnum);

    argument = one_argument(argument, arg, sizeof(arg));
    chance = get_skill(ch, sn_lookup("lore"));
    chance -= 20;
    if (IS_AFFECTED(ch, AFF_BLIND))
        chance = 0;

    if (chance == 80 || number_percent() < chance)
        pArea = ch->in_room->area;
    else
        pArea = area_lookup(index);

    if (pArea != NULL)
        char_printf(ch, "You are in %s{x area.\n", pArea->name);
    else
        log_printf("Invalid area vnum generated : %d !", index);

    return;
}

void show_char_to_char_1(CHAR_DATA *victim, CHAR_DATA *ch)
{
    OBJ_DATA *obj;
    int i;
    int percent;
    bool found;
    char *msg;
    const char *desc;
    const char *immdesc;
    CHAR_DATA *doppel = victim;
    CHAR_DATA *mirror = victim;

    if (is_affected(victim, gsn_doppelganger))
    {
        if (IS_NPC(ch)  || !IS_SET(ch->plr_flags, PLR_HOLYLIGHT))
        {
            doppel = victim->doppel;

            if (is_affected(victim, gsn_mirror))
                mirror = victim->doppel;
        }
    }

    if (can_see(victim, ch))
    {
        if (ch == victim)
            act("$n looks at $gn{himself}.", ch, NULL, NULL, TO_ROOM);
        else
        {
            act("$n looks at you.", ch, NULL, victim, TO_VICT);
            act("$n looks at $N.", ch, NULL, victim, TO_NOTVICT);
        }
    }

    if (IS_NPC(doppel))
        desc = mlstr_cval(doppel->description, ch);
    else
        desc = mlstr_mval(doppel->description);

    immdesc = mlstr_cval(victim->immdesc, ch);

    if (IS_IMMORTAL(ch) && !IS_NULLSTR(immdesc))
    {
        char_act("------------- DESCRIPTION FROM GOD'S --------------", ch);
        act_puts("$t", ch, immdesc, victim, TO_CHAR, POS_DEAD);
        char_act("---------------------------------------------------", ch);
    }

    if (!IS_NULLSTR(desc))
        act_puts(desc, ch, NULL, victim, TO_CHAR, POS_DEAD);
    else
        act_puts("You see nothing special about $gN{him}.",   ch, NULL, victim, TO_CHAR, POS_DEAD);

    if (MOUNTED(victim))
        act_puts("{x$N is riding $i.",   ch, MOUNTED(victim), victim, TO_CHAR, POS_DEAD);
    if (RIDDEN(victim))
        act_puts("{x$N is being ridden by $i.", ch, RIDDEN(victim), victim, TO_CHAR, POS_DEAD);

    if (victim->max_hit > 0)
        percent = (100 * victim->hit) / victim->max_hit;
    else
        percent = -1;

    if (percent >= 100)
        msg = "{C  {x.";
    else if (percent >= 90)
        msg = "{b  {x.";
    else if (percent >= 75)
        msg = "{B    {x.";
    else if (percent >= 50)
        msg = "{y$gN{} $gN{}  {x.";
    else if (percent >= 30)
        msg = "{M {x.";
    else if (percent >= 15)
        msg = "{R  {x.";
    else if (percent >= 0)
        msg = "{r  {x.";
    else
        msg = "{D $gN{}{x.";

    if (!IS_IMMORTAL(doppel))
    {
        act_puts("{x($t) ",
            ch, race_name(doppel->race), NULL, TO_CHAR | ACT_NOLF, POS_DEAD);
        if (!IS_NPC(doppel))
            act_puts("($t) ",
                ch, class_name(doppel), NULL, TO_CHAR | ACT_NOLF, POS_DEAD);
        act_puts("($t) ",
            ch, flag_string(sex_table, doppel->sex), NULL, TO_CHAR | ACT_NOLF, POS_DEAD);
    }

    act_puts3("$t$N$U ",
        ch, IS_IMMORTAL(victim) ? "{C" : str_empty, victim, IS_IMMORTAL(victim) ? "{x" : str_empty, TO_CHAR | ACT_NOLF, POS_DEAD);
    act_puts(msg, ch, NULL, victim, TO_CHAR | ACT_NOUCASE, POS_DEAD);

    found = FALSE;
    for (i = 0; show_order[i] != -1; i++)
        if ((obj = get_eq_char(mirror, show_order[i]))
        && can_see_obj(ch, obj))
        {
            if (!found)
            {
                char_act(str_empty, ch);
                act("$N is using:", ch, NULL, victim, TO_CHAR);
                found = TRUE;
            }

            show_obj_to_char(ch, obj, show_order[i]);
        }

    for (obj = mirror->carrying; obj; obj = obj->next_content)
        if (obj->wear_loc == WEAR_STUCK_IN
        && can_see_obj(ch, obj))
        {
            if (!found)
            {
                char_act(str_empty, ch);
                act("$N is using:", ch, NULL, victim, TO_CHAR);
                found = TRUE;
            }
            show_obj_to_char(ch, obj, WEAR_STUCK_IN);
        }

    if (victim != ch
    && (!IS_IMMORTAL(victim) || IS_IMMORTAL(ch))
    && !IS_NPC(ch)
    && number_percent() < get_skill(ch, gsn_peek))
    {
        act("You peek at the inventory:", ch, NULL, NULL, TO_CHAR);
        check_improve(ch, gsn_peek, TRUE, 4);
        show_list_to_char(mirror->carrying, ch, TRUE, TRUE);
    }
}

void show_char_to_char(CHAR_DATA *list, CHAR_DATA *ch)
{
    CHAR_DATA *rch;
    int life_count = 0;

    for (rch = list; rch; rch = rch->next_in_room)
    {
        if (rch == ch  || (!IS_TRUSTED(ch, rch->incog_level)  && ch->in_room != rch->in_room))
            continue;

        if (!IS_TRUSTED(ch, rch->invis_level))
        {
            AREA_DATA *pArea;

            if (!IS_NPC(rch))
                continue;

            pArea = area_vnum_lookup(rch->pIndexData->vnum);

            if (pArea == NULL  || !IS_BUILDER(ch, pArea))
                continue;
        }

        if (can_see(ch, rch))
            show_char_to_char_0(rch, ch);
        else
        {
            if (room_is_dark(ch) && IS_AFFECTED(rch, AFF_INFRARED))
                act("You see {rglowing red eyes{x watching YOU!",  ch, NULL, NULL, TO_CHAR);
            life_count++;
        }
    }

    if (list->in_room == ch->in_room    && life_count   && IS_AFFECTED(ch, AFF_DETECT_LIFE))
        act("You feel $j more life $qj{forms} in the room.",    ch, (const void*) life_count, NULL, TO_CHAR);
}

DO_FUN(do_clear)
{
    if (!IS_NPC(ch))
        char_puts("\033[0;0H\033[2J", ch);
}

/* changes your scroll */
DO_FUN(do_scroll)
{
    char arg[MAX_INPUT_LENGTH];
    int lines;

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        act_puts("You currently display $j lines per page.",
            ch, (const void *) (ch->lines + 2), NULL, TO_CHAR, POS_DEAD);
        return;
    }

    if (!is_number(arg))
    {
        act("You must provide a number.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    lines = atoi(arg);
    if (lines < SCROLL_MIN || lines > SCROLL_MAX)
    {
        act_puts3("Valid scroll range is $j..$J.",
            ch, (const void *) SCROLL_MIN, NULL, (const void *) SCROLL_MAX, TO_CHAR, POS_DEAD);
        return;
    }

    act_puts("Scroll set to $j lines.",
        ch, (const void *) lines, NULL, TO_CHAR, POS_DEAD);
    ch->lines = lines - 2;
}

/* RT does socials */
DO_FUN(do_socials)
{
    char arg[MAX_INPUT_LENGTH];
    int  i;
    BUFFER *output;

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        do_alist(ch, "social");
        return;
    }

    if(str_cmp(arg,"list"))
    {
        act("Syntax: {C'socials'{x or {C'socials list'{x", ch, NULL, NULL, TO_CHAR);
        return;
    }

    output = buf_new(-1);

    for (i = 0; i < socials.nused; i++)
    {
        social_t *soc = (social_t*) VARR_GET(&socials, i);

        buf_printf(output, "%-12s  %-12s  ", soc->name, soc->alias);
        buf_printf(output, "%s\n\r", soc->description);

    }

    buf_printf(output,"\n\r");
    page_to_char(buf_string(output), ch);
    buf_free(output);

}

/* RT Commands to replace news, motd, imotd, etc from ROM */
DO_FUN(do_motd)
{
    do_help(ch, "motd");
}

DO_FUN(do_imotd)
{
    do_help(ch, "imotd");
}

DO_FUN(do_rules)
{
    do_help(ch, "rules");
}

DO_FUN(do_story)
{
    do_help(ch, "story");
}

DO_FUN(do_wizlist)
{
    do_help(ch, "wizlist");
}

DO_FUN(do_form)
{
    char arg[MAX_INPUT_LENGTH];
    int rulecl, i, max;
    int sex_flip[] = {SEX_MALE, SEX_FEMALE, SEX_NEUTRAL, SEX_PLURAL};
    lang_t *l;

    argument = one_argument(argument, arg, sizeof(arg));
    if ((l = varr_get(&langs, ch->lang)) == NULL)
    {
        char_act("You have unknown language.", ch);
        return;
    }
    if (IS_NULLSTR(arg) || IS_NULLSTR(argument))
    {
        do_help(ch, "'WORD FORMS'");
        return;
    }
    if (!str_prefix(arg, "genders") || !str_prefix(arg, ""))
    {
        rulecl = RULES_GENDER;
        max = 4;
    } else if (!str_prefix(arg, "cases") || !str_prefix(arg, ""))
    {
        rulecl = RULES_CASE;
        max = 7;
    } else if (!str_prefix(arg, "qtys") || !str_prefix(arg, ""))
    {
        rulecl = RULES_QTY;
        max = 6;
    } else
    {
        do_help(ch, "'WORD FORMS'");
        return;
    }

    if (irule_find(l->rules + rulecl, arg) != NULL)
        char_act("Found implicit rule.", ch);
    if (erule_lookup(l->rules + rulecl, arg) != NULL)
        char_act("Found explicit rule.", ch);

    for (i=0; i < max; i++)
    {
        if (rulecl == RULES_GENDER)
            act_puts3("$J($j). [$gj{$T}{x]", ch, (const void *) (sex_flip[i]), argument, (const void *) i, TO_CHAR, POS_DEAD);
        if (rulecl == RULES_CASE)
            act_puts("$j. [$cj{$T}{x]", ch, (const void *)i, argument, TO_CHAR, POS_DEAD);
        if (rulecl == RULES_QTY)
            act_puts("$j. [$qj{$T}{x]", ch, (const void *)i, argument, TO_CHAR, POS_DEAD);
    }
}

/* RT this following section holds all the auto commands from ROM, as well as
   replacements for config */
#define do_print_sw(ch, swname, sw) \
                char_printf(ch, "%-16s %s\n", swname, sw ? "ON" : "OFF");

char *prepare_prompt(const char *str)
{
    char new_prompt[MAX_STRING_LENGTH];
    char *temp = new_prompt;
    while (*str)
        if (*str != '{')
            *(temp++) = *(str++);
        else
        {
            *(temp++) = *(str);
            *(temp++) = *(str++);
        }
    return strdup(new_prompt);

}

DO_FUN(do_prompt)
{
    const char *prompt;
    char *temp;

    if (argument[0] == '\0')
    {
        bust_a_prompt(ch);
        return;
    }
    if (!str_prefix(argument, "show"))
    {

        temp = prepare_prompt(ch->prompt);
        char_printf(ch, "Current prompt is '%s'.\n", temp);
        free(temp);

//                char_printf(ch, "  '%s'.\n", ch->prompt);
        return;
    }

    if (!str_cmp(argument, "all") || !str_cmp(argument, "default"))
        prompt = str_dup(DEFAULT_PROMPT);
    else
        prompt = str_printf("%s ", argument);

    free_string(ch->prompt);
    ch->prompt = prompt;

    temp = prepare_prompt(ch->prompt);
    char_printf(ch, "Prompt set to '%s'.\n", temp);
    free(temp);

//        char_printf(ch, "  '%s'.\n", ch->prompt);
}

DO_FUN(do_nofollow)
{
    if (IS_NPC(ch))
    {
        act("Huh?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    TOGGLE_BIT(ch->plr_flags, PLR_NOFOLLOW);
    if (IS_SET(ch->plr_flags,PLR_NOFOLLOW))
    {
        act("You no longer accept followers.", ch, NULL, NULL, TO_CHAR);
        die_follower(ch);
    } else
        act("You now accept followers.", ch, NULL, NULL, TO_CHAR);
}
DO_FUN(do_notrack)
{
    if (IS_NPC(ch))
        return;

    TOGGLE_BIT(ch->comm, COMM_TRACK);
    if (IS_SET(ch->comm, COMM_TRACK))
        char_act("Now you will follow tracks.", ch);
    else
        char_act("Now you will not follow tracks.", ch);
}


DO_FUN(do_nosummon)
{
    if (IS_NPC(ch))
        return;

    TOGGLE_BIT(ch->plr_flags, PLR_NOSUMMON);
    if (IS_SET(ch->plr_flags, PLR_NOSUMMON))
        char_act("         PK .", ch);
    else
        char_act("     .", ch);
}

void do_look_in(CHAR_DATA* ch, const char *argument)
{
    OBJ_DATA *obj;
    clan_t *clan = NULL;

    if ((obj = get_obj_here(ch, argument)) == NULL)
    {
        act("You don't see that here.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    switch (obj->pIndexData->item_type)
    {
        default:
            act("That is not a container.", ch, NULL, NULL, TO_CHAR);
            break;

        case ITEM_DRINK_CON:
            if (obj->value[1] <= 0 && obj->value[0] != -1)
            {
                act("It is empty.", ch, NULL, NULL, TO_CHAR);
                break;
            }

            act("It's $t filled with a $T liquid.", 
                ch, 
                (const void *) (obj->value[1] == obj->value[0] ? "full-" :
                obj->value[1] < obj->value[0] / 4 ? "less than half-" :
                obj->value[1] < 3 * obj->value[0] / 4 ?
                "about half-" : "more than half-"),
                (const void *) liquid_color(obj->value[2]),
                TO_CHAR | ACT_TRANS);
            break;

        case ITEM_CONTAINER:
        case ITEM_SCABBARD:
        case ITEM_CORPSE_NPC:
        case ITEM_CORPSE_PC:
            clan = is_clan_altar(obj);
            if ((clan == NULL) || (clan != CLAN(ch->clan)))
                if (IS_SET(obj->value[1], CONT_CLOSED))
                {
                    act("It is closed.", ch, NULL, NULL, TO_CHAR);
                    if (!IS_IMMORTAL(ch))
                        break;
                }

            act_puts("$p holds : ", ch, obj, NULL, TO_CHAR, POS_DEAD);
            show_list_to_char(obj->contains, ch, TRUE, TRUE);
            break;

        }
}

DO_FUN(do_look)
{
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    char arg3 [MAX_INPUT_LENGTH];
    EXIT_DATA *pexit;
    CHAR_DATA *victim;
    //CHAR_DATA *person;
    OBJ_DATA *obj;
    ED_DATA *ed;
    int door;
    int number,count;
    //int numpeople;
    //ROOM_INDEX_DATA *location;
    riddle_t *riddle;

    if (ch->desc == NULL)
        return;

    if (ch->position < POS_SLEEPING)
    {
        char_act("You can't see anything but stars!", ch);
        return;
    }

    if (ch->position == POS_SLEEPING)
    {
        char_act("You can't see anything, you're sleeping!", ch);
        return;
    }

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));
    number = number_argument(arg1, arg3, sizeof(arg3));
    count = 0;

    if (arg1[0] == '\0' || !str_cmp(arg1, "auto"))
    {

        /* 'look' or 'look auto' */
        if (!room_is_dark(ch) && check_blind_raw(ch))
        {

            const char *name;
            const char *engname;

            name = mlstr_cval(ch->in_room->name, ch);
            engname = mlstr_mval(ch->in_room->name);
            act_puts("{W{W$t", ch, name, NULL, TO_CHAR | ACT_NOLF, POS_DEAD);
            if (ch->lang && name != engname)
                act_puts(" ($t){R{x", ch, engname, NULL, TO_CHAR | ACT_NOLF, POS_DEAD);
            else
                act_puts("{R{x", ch, NULL, NULL, TO_CHAR | ACT_NOLF, POS_DEAD);

            if (IS_IMMORTAL(ch) || IS_BUILDER(ch, ch->in_room->area))
                act_puts(" [$j]", ch, (const void *) ch->in_room->vnum, NULL, TO_CHAR | ACT_NOLF, POS_DEAD);

            char_act(str_empty, ch);

            if (arg1[0] == '\0' ||
                (!IS_NPC(ch) && !IS_SET(ch->comm, COMM_BRIEF)))
                act_puts(mlstr_cval(ch->in_room->description, ch), ch, ch->in_room, NULL, TO_CHAR, POS_DEAD);

            if (!IS_NPC(ch) && IS_SET(ch->plr_flags, PLR_AUTOEXIT))
            {
                char_act(str_empty, ch);
                do_exits(ch, "auto");
            }
        } else
            char_act("It is pitch black...", ch);

        if (IS_SET(ch->plr_flags, PLR_AUTOWEATHER) && IS_OUTDOORS(ch))
            show_weather(ch);

        show_list_to_char(ch->in_room->contents, ch, FALSE, FALSE);
        show_char_to_char(ch->in_room->people, ch);
        if (!str_cmp(arg1, "auto"))
            relation_effect(ch);

        return;
    }

    if (!check_blind(ch))
        return;

    if (!str_cmp(arg1, "i")
    || !str_cmp(arg1, "in")
    || !str_cmp(arg1,"on")
    || !str_cmp(arg1, ""))
    {
        /* 'look in' */
        if (arg2[0] == '\0')
        {
            char_act("Look in what?", ch);
            return;
        }
        do_look_in(ch, arg2);
        return;
    }

    if ((victim = get_char_room(ch, arg1)) != NULL)
    {
        show_char_to_char_1(victim, ch);

        /* Love potion */
        if (is_affected(ch, gsn_love_potion) && (victim != ch) && !IS_AFFECTED(victim, AFF_CHARM))
        {
            AFFECT_DATA af;

            affect_strip(ch, gsn_love_potion);

            if (ch->master)
                stop_follower(ch);
            add_follower(ch, victim);
            ch->leader = victim;

            af.where        = TO_AFFECTS;
            af.type         = gsn_charm_person;
            af.level        = ch->level;
            af.duration     = number_fuzzy(victim->level / 4);
            af.bitvector    = AFF_CHARM;
            af.modifier     = 0;
            af.location     = 0;
            affect_to_char(ch, &af);

            act("Isn't $n just so nice?", victim, NULL, ch, TO_VICT);
            act("$N looks at you with adoring eyes.", victim, NULL, ch, TO_CHAR);
            act("$N looks at $n with adoring eyes.", victim, NULL, ch, TO_NOTVICT);
        }
        return;
    }

    for (obj = ch->carrying; obj != NULL; obj = obj->next_content)
    {
        if (can_see_obj(ch, obj))
        {
            /* player can see object */
            if (obj->pIndexData->item_type == ITEM_RIDDLE &&
                is_name(arg3, obj->pIndexData->name))
            {
                riddle = riddle_lookup(obj->pIndexData->value[2]);
                if (riddle)
                    char_act(mlstr_cval(riddle->question, ch), ch);
                else
                    char_act("Somthing is wrong.", ch);
                return;
            }

            ed = ed_lookup(arg3, obj->ed);

            if (ed != NULL)
            {
                if (++count == number)
                {
                    char_mlact(ed->description, ch);
                    return;
                } else
                    continue;
            }

            ed = ed_lookup(arg3, obj->pIndexData->ed);

            if (ed != NULL)
            {
                if (++count == number)
                {
                    char_mlact(ed->description, ch);
                    return;
                } else
                    continue;
            }

            if (is_name(arg3, obj->name))
                if (++count == number)
                {
                    char_act("You see nothing special about it.", ch);
                    return;
                }
        }
    }

    for (obj = ch->in_room->contents; obj != NULL; obj = obj->next_content)
    {
        if (can_see_obj(ch, obj))
        {
            if (obj->pIndexData->item_type == ITEM_RIDDLE &&
                is_name(arg3, obj->pIndexData->name))
            {
                riddle = riddle_lookup(obj->pIndexData->value[2]);
                if (riddle)
                    char_act(mlstr_cval(riddle->question, ch), ch);
                else
                    char_act("Somthing is wrong.", ch);
                return;
            }

            ed = ed_lookup(arg3, obj->ed);
            if (ed != NULL)
            {
                if (++count == number)
                {
                    char_mlact(ed->description, ch);
                    return;
                }
            }

            ed = ed_lookup(arg3, obj->pIndexData->ed);
            if (ed != NULL)
            {
                if (++count == number)
                {
                    char_mlact(ed->description, ch);
                    return;
                }
            }
        }

        if (is_name(arg3, obj->name))
        {
            if (++count == number)
            {
                if (obj->pIndexData->vnum == OBJ_VNUM_WANTED_DESK)
                {
                    show_wanted_desk(ch);
                    return;
                } else
                {
                    if (obj->pIndexData->item_type == ITEM_WINDOW) // For look windows
                    {
                        look_window(ch, obj);
                        return;
                    }

                    if (obj->pIndexData->item_type == ITEM_PORTAL)
                    {
                        look_gate(ch, obj);
                        return;
                    }

                    act_puts(format_descr(obj->description, ch), ch, obj, obj, TO_CHAR, POS_DEAD);
                    return;
                }
            }
        }
    }

    ed = ed_lookup(arg3, ch->in_room->ed);
    if (ed != NULL)
    {
        if (++count == number)
        {
            char_mlact(ed->description, ch);
            return;
        }
    }

    if (count > 0 && count != number)
    {
        if (count == 1)
            act_puts("You only see one $t here.", ch, arg3, NULL, TO_CHAR, POS_DEAD);
        else
            act_puts("You only see $j of those here.",
                ch, (const void*) count, NULL, TO_CHAR, POS_DEAD);
        return;
    }

    if (!str_cmp(arg1, "n")
    || !str_cmp(arg1, "north")
    || !str_cmp(arg1, "")
    || !str_cmp(arg1, ""))
        door = 0;
    else if (!str_cmp(arg1, "e")
    || !str_cmp(arg1, "east")
    || !str_cmp(arg1, "")
    || !str_cmp(arg1, ""))
        door = 1;
    else if (!str_cmp(arg1, "s")
    || !str_cmp(arg1, "south")
    || !str_cmp(arg1, "")
    || !str_cmp(arg1, ""))
        door = 2;
    else if (!str_cmp(arg1, "w")
    || !str_cmp(arg1, "west")
    || !str_cmp(arg1, "")
    || !str_cmp(arg1, ""))
        door = 3;
    else if (!str_cmp(arg1, "u")
    || !str_cmp(arg1, "up" )
    || !str_cmp(arg1, "")
    || !str_cmp(arg1, ""))
        door = 4;
    else if (!str_cmp(arg1, "d")
    || !str_cmp(arg1, "down")
    || !str_cmp(arg1, "")
    || !str_cmp(arg1, "")
    || !str_cmp(arg1, "")
    || !str_cmp(arg1, ""))
        door = 5;
    else
    {
        char_act("You don't see that here.", ch);
        return;
    }

    /* 'look direction' */
    if ((pexit = ch->in_room->exit[door]) == NULL)
    {
        char_act(" .", ch);
        return;
    }

    if (!IS_NULLSTR(mlstr_mval(pexit->description)))
        char_mlact(pexit->description, ch);
    else
        char_act("Nothing special there.", ch);

    if (pexit->keyword    != NULL
    && pexit->keyword[0] != '\0'
    && pexit->keyword[0] != ' ')
    {
        if (IS_SET(pexit->exit_info, EX_CLOSED))
            act_puts("The $d is closed.", ch, NULL, pexit->keyword, TO_CHAR, POS_DEAD);
        else if (IS_SET(pexit->exit_info, EX_ISDOOR))
            act_puts("The $d is open.", ch, NULL, pexit->keyword, TO_CHAR, POS_DEAD);
    }
}

DO_FUN(do_examine)
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;

    one_argument(argument, arg, sizeof(arg));

    if (ch->desc == NULL)
        return;

    if (ch->position < POS_SLEEPING)
    {
        act("You can't see anything but stars!", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (ch->position == POS_SLEEPING)
    {
        act("You can't see anything, you're sleeping!", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!check_blind(ch))
        return;

    if (arg[0] == '\0')
    {
        act("Examine what?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!str_cmp(arg, "tattoo") || !str_cmp(arg, ""))
    {
        do_examine_tattoo (ch, argument);
        return;
    }

    do_look(ch, arg);

    if ((obj = get_obj_here(ch, arg)) != NULL)
    {
        switch (obj->pIndexData->item_type)
        {
            case ITEM_MONEY:
                if (obj->value[0] == 0)
                {
                    if (obj->value[1] == 0)
                        act("Odd...there's no coins in the pile.", ch, NULL, NULL, TO_CHAR);
                    else if (obj->value[1] == 1)
                        act("Wow. One gold coin.", ch, NULL, NULL, TO_CHAR);
                    else
                        char_printf(ch, "There are %d gold coins in this pile.\n", obj->value[1]);
                } else if (obj->value[1] == 0)
                {
                    if (obj->value[0] == 1)
                        act("Wow. One silver coin.", ch, NULL, NULL, TO_CHAR);
                    else
                        char_printf(ch, "There are %d silver coins in this pile.\n", obj->value[0]);
                } else
                    char_printf(ch, "There are %d gold and %d silver coins in this pile.\n", obj->value[1], obj->value[0]);
                break;

            case ITEM_DRINK_CON:
            case ITEM_CONTAINER:
            case ITEM_SCABBARD:
            case ITEM_CORPSE_NPC:
            case ITEM_CORPSE_PC:
                    do_look_in(ch, argument);
                break;
            case ITEM_KEYRING:
                    list_keys(ch, obj);
                    break;
        }
    }
}

/*
 * Thanks to Zrin for auto-exit part.
 */
char dirs[6][2][MAX_INPUT_LENGTH] = 
{
    {"north", ""},
    {"east",  ""},
    {"south", ""},
    {"west",  ""},
    {"up",    ""},
    {"down",  ""}
};

DO_FUN(do_exits)
{
    extern char * const dir_name[];
    EXIT_DATA *pexit;
    bool found;
    bool fAuto;
    int door;

    fAuto  = !str_cmp(argument, "auto");

    if (fAuto)
        act_puts("{C[Exits :", ch, NULL, NULL, TO_CHAR | ACT_NOLF, POS_DEAD);
    else if (IS_IMMORTAL(ch) || IS_BUILDER(ch, ch->in_room->area))
        act_puts("Obvious exits from room $j : ", ch, (const void *) ch->in_room->vnum, NULL, TO_CHAR, POS_DEAD);
    else
        act("Obvious exits : ", ch, NULL, NULL, TO_CHAR);

    found = FALSE;
    for (door = 0; door < MAX_DIR; door++)
    {
        if ((pexit = ch->in_room->exit[door]) != NULL
        && pexit->to_room.r != NULL
        && can_see_room(ch, pexit->to_room.r)
        && !IS_SET(pexit->exit_info, EX_INVIS)
        && check_blind_raw(ch))
        {
            bool show_closed = FALSE;

            if (IS_SET(pexit->exit_info, EX_CLOSED))
            {
                int chance;

                if (IS_IMMORTAL(ch))
                    show_closed = TRUE;
                else if ((chance = get_skill(ch, gsn_perception)))
                {
                    if (number_percent() < chance)
                    {
                        check_improve(ch, gsn_perception, TRUE, 5);
                        show_closed = TRUE;
                    }
                }
                if (!show_closed)
                    continue;
            }

            found = TRUE;
            if (fAuto)
            {
                if (IS_SET(ch->comm2, COMM2_RUSEXIT))
                    act_puts(" $t$T", ch, dirs[door][1], show_closed ? "*" : str_empty, TO_CHAR | ACT_NOLF, POS_DEAD);
                else
                    act_puts(" $t$T", ch, dirs[door][0], show_closed ? "*" : str_empty, TO_CHAR | ACT_NOLF, POS_DEAD);
            }
            else
            {
                act_puts3("{C$t$T{x - $U", ch,
                          fmt_color_str(capitalize(dir_name[door]), 5),
                          show_closed ? "*" : str_empty,
                          (room_dark(pexit->to_room.r) &&
                           !IS_SET(ch->plr_flags, PLR_HOLYLIGHT)) ?
                          "Too dark to tell" :
                          mlstr_cval(pexit->to_room.r->name, ch),
                          TO_CHAR | ACT_NOLF, POS_DEAD);
                if (IS_IMMORTAL(ch) || IS_BUILDER(ch, pexit->to_room.r->area))
                    act_puts(" [$j]", ch, (const void *) pexit->to_room.r->vnum, NULL, TO_CHAR | ACT_NOLF, POS_DEAD);
                char_act(str_empty, ch);
            }
        }
    }

    if (!found)
        act_puts(fAuto ? " none" : "None.", ch, NULL, NULL, TO_CHAR | (fAuto? ACT_NOLF : 0), POS_DEAD);

    if (fAuto)
        act_puts("]{x", ch, NULL, NULL, TO_CHAR, POS_DEAD);
}

DO_FUN(do_worth)
{
    char_printf(ch, "You have %d gold, %d silver", ch->gold, ch->silver);
    if (!IS_NPC(ch) && ch->level < LEVEL_HERO)
        char_printf(ch, ", and %d experience (%d exp to level)",
                    ch->exp, exp_to_level(ch));
    act(".", ch, NULL, NULL, TO_CHAR);

    if (!IS_NPC(ch))
    {
        act_puts("You have killed $j $T",
                 ch, (const void*) ch->pcdata->has_killed,
                 IS_GOOD(ch) ? "non-goods" :
                 IS_EVIL(ch) ? "non-evils" :
                 "non-neutrals",
                 TO_CHAR | ACT_NOLF | ACT_TRANS, POS_DEAD);
        act_puts(" and $j $T.",
                 ch, (const void*) ch->pcdata->anti_killed,
                 IS_GOOD(ch) ? "goods" :
                 IS_EVIL(ch) ? "evils" :
                 "neutrals",
                 TO_CHAR | ACT_TRANS, POS_DEAD);
    }
}
/* GM :    .  .
    "the Moon", "the Bull", "Deception", "Thunder", "the Horror",
    "the Kingdom", "Rancour", "the Crypt", "the Tutor",
    "Tranquility", "the Great Gods", "Freedom"
*/
char *  const   day_name        [] =
{
    "", "", "", "", "",
    " ", ""
};

/*
    "the Winter Wolf", "the Frost Giant",
    "the Spring", "Nature", "Futility", "the Dragon",
    "the Sun", "the Heat", "the Dark Shades",
    "the Long Shadows", "the Ancient Darkness", "the Great Evil"
*/
char *  const   month_name      [] =
{       " ",                                   // 0
    " ", " ",              //1,2
    "", "", "",                  //3,4,5
    "", "", "",                     //6,7,8
    " ", "", " ",      //9,10,11
    "",                                           //12
    " ", " ",  "",
    " "
};

DO_FUN(do_time)
{
    extern char str_boot_time[];
    char *suf, *sufh;
    int day;

    day     = time_info.day + 1;

    if (day > 4 && day <  20)
        suf = str_empty;
    else if (day % 10 ==  1)
        suf = str_empty;
    else if (day % 10 ==  2)
        suf = str_empty;
    else if (day % 10 ==  3)
        suf = str_empty;
    else
        suf = str_empty;

    if (time_info.hour == 1 || time_info.hour == 21)
        sufh = str_empty;
    else if (time_info.hour != 0
             && (time_info.hour < 5 || time_info.hour > 21))
        sufh = "";
    else
        sufh = "";

#if 0
    char_printf(ch,
                " %d  %s,  %s, %d %s  %s.  %d   .\n",
                (time_info.hour % 12 == 0) ? 12 : time_info.hour %12,
                time_info.hour >= 12 ? " " : " ",
                day_name[day % 7],
                day, suf, month_name[time_info.month],
                time_info.year);
#endif
    act_puts3(" $j $qj{},  $T, $J", ch, (const void *) time_info.hour, day_name[day % 7], (const void *) day, TO_CHAR | ACT_NOLF | ACT_TRANS, POS_DEAD);
    act_puts(",  $t.", ch, month_name[time_info.month], NULL, TO_CHAR | ACT_TRANS, POS_DEAD);


    if (!IS_SET(ch->in_room->room_flags,ROOM_INDOORS) || IS_IMMORTAL(ch))
        act_puts("  $t.", ch,
                 (time_info.hour>=5 && time_info.hour<9) ?
                 GETMSG("", ch->lang) :
                 (time_info.hour>=9 && time_info.hour<12) ?
                 GETMSG("", ch->lang) :
                 (time_info.hour>=12 && time_info.hour<18) ?
                 GETMSG("", ch->lang) :
                 (time_info.hour>=18 && time_info.hour<21) ?
                 GETMSG("", ch->lang) :
                 GETMSG("", ch->lang),
                 NULL, TO_CHAR, POS_RESTING);

    if (!IS_IMMORTAL(ch))
        return;

    act_puts("\nAstrum Metaphora   $t\n  $T.",
             ch, str_boot_time, strtime(time(NULL)), TO_CHAR, POS_DEAD);
    if (reboot_counter == -1)
        char_act("   .", ch);
    else
        act_puts("     $j .", ch, (const void *) reboot_counter, NULL, TO_CHAR, POS_DEAD);
    return;
}

DO_FUN(do_date)
{
    char_printf(ch, "%s\n", strtime(time(NULL)));
}

DO_FUN(do_help)
{
    BUFFER *output;
    output = buf_new(ch->lang);
    help_show(ch, output, argument);
    page_to_char(buf_string(output), ch);
    buf_free(output);
}

#define PC_PRACTICER    123

void do_who_raw (CHAR_DATA * ch, CHAR_DATA * wch, BUFFER * output)
{
    clan_t  * clan    = NULL ;
    clan_t  * clan_ch = NULL ;
    race_t  * r ;
    class_t * cl ;

    if ((cl = class_lookup (wch->class)) == NULL
    || (r  = race_lookup  (wch->race))  == NULL
    || !r->pcdata)
        return ;

    buf_add (output, "{W[") ;

    if (wch->level > LEVEL_HERO)
    {
        switch (wch->level)
        {
            case IMPLEMENTOR: buf_add (output, "{C IMPLEMENTOR ") ; break ;
            case CREATOR:     buf_add (output, "{W   CREATOR   ") ; break ;
            case SUPREME:     buf_add (output, "{W   SUPREME   ") ; break ;
            case DEITY:       buf_add (output, "{W    DEITY    ") ; break ;
            case GOD:         buf_add (output, "{W     GOD     ") ; break ;
            case IMMORTAL:    buf_add (output, "{W   IMMORTAL  ") ; break ;
            case DEMI:        buf_add (output, "{W   DEMIGOD   ") ; break ;
            case ANGEL:       buf_add (output, "{W    ANGEL    ") ; break ;
            case AVATAR:      buf_add (output, "{w    AVATAR   ") ; break ;
//        case HERO:        buf_add (output, "{G    HERO     ") ; break ;
        }

    } else
    {
        if ((ch && (IS_IMMORTAL (ch)
        || ch == wch
        || is_affected (ch, gsn_detection)))
        || wch->level == LEVEL_HERO
        || get_curr_stat (wch, STAT_CHA) < 16
        || IS_SET (wch->comm, PLR_PEACE))
            buf_printf (output, "%3d ", wch->level) ;
        else
            buf_add    (output, "    ") ;

        if (wch->level == LEVEL_HERO)
        {
            if (ch && (IS_IMMORTAL (ch) || is_affected (ch, gsn_detection)))
            {
                buf_add    (output, "{G") ;
                buf_printf (output, "%5.5s",  r->pcdata->who_name) ;
                buf_printf (output, " %3.3s", cl->who_name) ;
            } else buf_add (output, "{GHERO ") ;
        } else
        {
            if (ch && (IS_IMMORTAL (ch) || is_affected (ch, gsn_detection)))
            {
                buf_add    (output, "{w") ;
                buf_printf (output, "%5.5s",  r->pcdata->who_name) ;
                buf_printf (output, " %3.3s", cl->who_name) ;
            } else buf_printf (output, "%5.5s", r->pcdata->who_name) ;
        }
    }

    buf_add (output, "{W]{x") ;

    clan = clan_lookup (wch->clan) ;

    if (ch) clan_ch = clan_lookup (ch->clan) ;

    if (wch->clan && clan
        && (!IS_SET(clan->flags, CLAN_HIDDEN)
        || (ch && (wch->clan == ch->clan
        || IS_IMMORTAL(ch)))))
    {
        int len = (12 - strlen (clan->name)) / 2 ;
        char sName [MAX_INPUT_LENGTH] ;
        sName [0] = '\0' ;

        strnzncat(sName, sizeof(sName), "                      ", len) ;
        strnzcat(sName, sizeof(sName), clan->name) ;
        buf_printf (output, "{W[{Y%-12.12s{W]{x ", sName) ;
    } 
    else
        if (IS_SET(wch->comm, PLR_PEACE)) buf_add (output, "{W[{G   NO PK    {W]{x ") ;
    else
        if (wch->level < PK_MIN_LEVEL)    buf_add (output, "{W[{G   Newbie   {W]{x ") ;
    else
        if (!IS_IMMORTAL(wch))            buf_add (output, "{W[            ]{x ") ;

    if (!IS_SET(ch->comm, COMM_LONG) && !IS_IMMORTAL(wch))
    {
        buf_add (output, "{c[") ;

        if (IS_AFFECTED (wch, AFF_INVIS))      buf_add (output, "{yI") ;
        else                                   buf_add (output, "{y.") ;

        if (IS_AFFECTED (wch, AFF_HIDE))       buf_add (output, "{DH") ;
        else                                   buf_add (output, "{D.") ;

        if (IS_AFFECTED (wch, AFF_TRAP))       buf_add (output, "{DT") ;
        else                                   buf_add (output, "{D.") ;

        if (IS_AFFECTED (wch, AFF_IMP_INVIS))  buf_add (output, "{bI") ;
        else                                   buf_add (output, "{b.") ;

        if (IS_AFFECTED (wch, AFF_CAMOUFLAGE)) buf_add (output, "{yC") ;
        else                                   buf_add (output, "{y.") ;

        if (IS_AFFECTED (wch, AFF_FADE))       buf_add (output, "{gF") ;
        else                                   buf_add (output, "{g.") ;

        if (IS_AFFECTED (wch, AFF_EARTHFADE))  buf_add (output, "{rE") ;
        else                                   buf_add (output, "{r.") ;

        buf_add (output, "{c]{x ") ;
    }

    if (wch->level > LEVEL_HERO)
        buf_add (output, " {x") ;

    if (IS_SET (wch->comm, COMM_AFK)) buf_add (output, "{m[{MAFK{m]{x ") ;
    if (wch->status == PC_PRACTICER) buf_add (output, "{g[{GTeacher{g]{x ") ;

    if (wch->invis_level) buf_printf (output, "({WWizi%d{x) ",  wch->invis_level) ;
    if (wch->incog_level) buf_printf (output, "({DIncog%d{x) ", wch->incog_level) ;

    if (IS_SET(wch->plr_flags, PLR_TESTER))
        buf_printf (output, "{C[{cTester{C] {x");

    if (wch->pcdata->security == 1)
        buf_printf (output, "{C[{cTester{C] {x") ;

//TODO: remove with security need

    if (wch->pcdata->security > 1 && !IS_IMMORTAL (wch))
        buf_printf (output, "{C[{cBuilder{C] {x") ;

    if (IS_SET (wch->plr_flags, PLR_GHOST) && IS_IMMORTAL(ch))
        buf_printf (output, "{C[{cGhost{C] {x") ;

    if (ch && (IS_IMMORTAL(ch) || is_affected (ch, gsn_detection) || ch == wch))
    {
        if (IS_ROOM_AFFECTED (wch->in_room, RAFF_ESPIRIT)
        && is_affected(wch, gsn_evil_spirit))
            buf_add (output, "{C[{cEvil Inside{C]{x ") ;

        if (is_affected(wch, gsn_garble))
            buf_add (output, "{C[{cGarble{C]{x ") ;

        if (is_affected(wch, gsn_deafen))
            buf_add (output, "{C[{cDeafen{C]{x ") ;

        if (IS_AFFECTED (wch, AFF_CHARM))
        {
            if (wch->master != NULL)
            {
                buf_add (output, "{C[{cCharmed by: ") ;
                buf_add (output, wch->master->name) ;
                buf_add (output, "{C]{x ") ;
            } 
            else
            {
                buf_add (output, "{C[{cCharm{C]{x ") ;
                log_printf ("NULL master name, ch %s", wch->name) ;
            }
        }

        if (IS_SET (wch->form, FORM_VAMPIRE))     buf_add (output, "{C[{cVamp{C]{x ")   ;
        if (IS_SET (wch->form, FORM_MECH))        buf_add (output, "{C[{cMech{C]{x ")   ;
        if (IS_SET (wch->form, FORM_DEMON_FIRE))  buf_add (output, "{C[{cDFire{C]{x ")  ;
        if (IS_SET (wch->form, FORM_DEMON_EARTH)) buf_add (output, "{C[{cDEarth{C]{x ") ;
        if (IS_SET (wch->form, FORM_DEMON_WATER)) buf_add (output, "{C[{cDWater{C]{x ") ;
        if (IS_SET (wch->form, FORM_DEMON_AIR))   buf_add (output, "{C[{cDAir{C]{x ")   ;

        if ((wch->doppel != NULL) && (wch->doppel != wch))
        {
            if (wch->doppel->name != NULL)
            {
                buf_add (output, "{C[{cDoppel: ") ;
                buf_add (output, wch->doppel->name) ;
                buf_add (output, "{C]{x ") ;
            } else log_printf ("do_who_raw: NULL doppel name, ch %s", wch->name) ;
        }

        if (wch->guarded_by != NULL)
        {
            buf_add (output, "{C[{cGuarded by: ") ;
            buf_add (output, wch->guarded_by->name) ;
            buf_add (output, "{C]{x ") ;
        }
    }

    if (ch && in_PK (ch, wch) && !IS_IMMORTAL (ch) && !IS_IMMORTAL (wch))
        buf_add (output, "{r[{RPK{r]{x ") ;

    if (wch->pcdata->headprice > 0)
    {
        if (IS_IMMORTAL(ch) || (clan_ch && IS_SET(clan_ch->flags, CLAN_HIDDEN)))
            buf_printf (output, "{G({W {Y%d{G){x ", wch->pcdata->headprice) ;
    }

    if (ch && IS_SET (wch->plr_flags, PLR_WANTED)
    && (IS_IMMORTAL (ch) || (clan_ch && IS_SET(clan_ch->flags, CLAN_RULERS))
    || (clan_ch && IS_SET (clan_ch->flags, CLAN_HIDDEN)) || (ch == wch)))
        buf_add (output, "{R( ){x ") ;

    if (ch && is_affected(wch, gsn_arrest)
    && (IS_IMMORTAL(ch) || (clan_ch && IS_SET(clan_ch->flags, CLAN_RULERS))))
        buf_add (output, "{G(){x ") ;

    buf_add (output, wch->pcdata->pretitle) ;

    if (IS_IMMORTAL(wch))
    {
        if (wch->imm_name) buf_printf (output, "%s{x",   wch->imm_name) ;
        else               buf_printf (output, "{C%s{x", wch->name) ;
    } 
    else 
        //buf_add (output, wch->name) ;
        (IS_SET(ch->comm2, COMM2_RUSNAMES) && wch->pcdata && wch->pcdata->rusnames[0]) ? buf_add (output, wch->pcdata->rusnames[0]) : buf_add (output, wch->name);


    buf_add (output, wch->pcdata->title) ;

    buf_add (output, "\n") ;
}

#define WHO_F_IMM       (A)             /* imm only                     */
#define WHO_F_PK        (B)             /* PK only                      */
#define WHO_F_TATTOO    (C)             /* same tattoo only             */
#define WHO_F_CLAN      (D)             /* clan only                    */
#define WHO_F_RCLAN     (E)             /* specified clans only         */
#define WHO_F_RRACE     (F)             /* specified races only         */
#define WHO_F_RCLASS    (G)             /* specified classes only       */

DO_FUN(do_who)
{
    BUFFER *output;
    DESCRIPTOR_DATA *d;
    int flags = 0;

    int iLevelLower = 0;
    int iLevelUpper = MAX_LEVEL-1;

    int tattoo_vnum = 0;    /* who tattoo data */
    OBJ_DATA *obj;

    int nNumber;
    int nMatch = 0;
    int count = 0;

    int n;

    const char *clan_names = str_empty;
    const char *race_names = str_empty;
    const char *class_names = str_empty;

    /*
     * Parse arguments.
     */
    nNumber = 0;
    for (;;)
    {
        int i;
        char arg[MAX_INPUT_LENGTH];

        argument = one_argument(argument, arg, sizeof(arg));
        if (arg[0] == '\0')
            break;

        if (!str_prefix(arg, "immortals")
        || !str_prefix(arg, "")
        || !str_prefix(arg, ""))
        {
            SET_BIT(flags, WHO_F_IMM);
            continue;
        }

        if (!str_cmp(arg, "pk")
        || !str_cmp(arg, ""))
        {
            SET_BIT(flags, WHO_F_PK);
            continue;
        }

        if (!str_cmp(arg, "tattoo")
        || !str_cmp(arg, ""))
        {
            if ((obj = get_eq_char(ch, WEAR_TATTOO)) == NULL)
            {
                act("    !", ch, NULL, NULL, TO_CHAR);
                goto bail_out;
            }
            SET_BIT(flags, WHO_F_TATTOO);
            tattoo_vnum = obj->pIndexData->vnum;
            continue;
        }

        if (!str_cmp(arg, "clan")
        || !str_cmp(arg, ""))
        {
            SET_BIT(flags, WHO_F_CLAN);
            continue;
        }

        if ((i = cln_lookup(arg)) > 0)
        {
            name_add(ch, CLAN(i)->name, NULL, &clan_names);
            SET_BIT(flags, WHO_F_RCLAN);
            continue;
        }

        if ((i = rn_lookup(arg)) > 0 && RACE(i)->pcdata)
        {
            name_add(ch, RACE(i)->name, NULL, &race_names);
            SET_BIT(flags, WHO_F_RRACE);
            continue;
        }

        if (!IS_IMMORTAL(ch))
            continue;

        if ((i = cn_lookup(arg)) >= 0)
        {
            name_add(ch, CLASS(i)->name, NULL, &class_names);
            SET_BIT(flags, WHO_F_RCLASS);
            continue;
        }

        if (is_number(arg))
        {
            switch (++nNumber)
            {
                case 1:
                    iLevelLower = atoi(arg);
                    break;
                case 2:
                    iLevelUpper = atoi(arg);
                    break;
                default:
                    char_printf(ch, "%s: explicit argument (skipped)\n", arg);
                    break;
            }
            continue;
        }
    }

    /*
     * Now show matching chars.
     */
    output = buf_new(ch->lang);
    for (n = 0; n < 2; n++)
    {
        if (n == 1 && nMatch > 0)
        {
            if (IS_IMMORTAL(ch) && (wizlock || newlock || IS_SET(muddy_mode, MUDDY_TEST_MODE) || !IS_SET(muddy_mode, MUDDY_NEWBIES)))
                buf_add(output, "{D==========================   {W  !!!{D   ==========================={x\n");

            if (wizlock && IS_IMMORTAL(ch))
                buf_add(output, "   {M* {R : {Y  WIZLOCK !!!{x\n");

            if (newlock && IS_IMMORTAL(ch))
                buf_add(output, "   {M* {R : {Y  NEWLOCK !!!{x\n");

            if (IS_SET(muddy_mode, MUDDY_TEST_MODE) && IS_IMMORTAL(ch))
                 buf_add(output, "{M*            {R : {Y   !!!{x\n");

            if (!IS_SET(muddy_mode, MUDDY_NEWBIES) && IS_IMMORTAL(ch))
                 buf_add(output, "{M*            {R : {Y   !!!{x\n");

            buf_add(output, "{D================================================================================{x\n");
        }

        if( n == 1)
        {
             if (IS_SET(muddy_mode, MUDDY_TEST_MODE) && !IS_IMMORTAL(ch))
             {
                 buf_add(output, "{D==========================   {W  !!!{D   ==========================={x\n");
                 buf_add(output, "{M*            {R : {Y   !!!{x\n");
                 buf_add(output, "{D================================================================================{x\n");
             }
        }

        for (d = descriptor_list; d; d = d->next)
        {
            CHAR_DATA *wch;

            clan_t *clan;
            race_t *race;
            class_t *class;

            if (d->connected != CON_PLAYING)
                continue;

            wch = d->original ? d->original : d->character;
            if (!wch || !can_see(ch, wch))
                continue;

            if ((n == 0 && !IS_IMMORTAL(wch))
            || (n == 1 && IS_IMMORTAL(wch)))
            {
                continue;
            }

            count++;
            if (!IS_IMMORTAL(ch)
            && ch != wch
            && !is_affected(ch, gsn_detection)
            && IS_SET(wch->form, FORM_VAMPIRE | FORM_MECH | FORM_DEMON))
                continue;


            if (wch->level < iLevelLower
            || wch->level > iLevelUpper
            || (IS_SET(flags, WHO_F_IMM) && wch->level < LEVEL_IMMORTAL && !(wch->pcdata->security > 0))
            || (IS_SET(flags, WHO_F_PK) && !in_PK(ch, wch))
            || (IS_SET(flags, WHO_F_CLAN) && !wch->clan))
            {
                continue;
            }

            if (IS_SET(flags, WHO_F_TATTOO))
            {
                if ((obj = get_eq_char(wch, WEAR_TATTOO)) == NULL
                || tattoo_vnum != obj->pIndexData->vnum)
                {
                    continue;
                }
            }

            if (IS_SET(flags, WHO_F_RCLAN | WHO_F_CLAN))
            {
                if (!wch->clan
                || (clan = clan_lookup(wch->clan)) == NULL
                || (IS_SET(clan->flags, CLAN_HIDDEN)
                && wch->clan != ch->clan
                && !IS_IMMORTAL(ch))
                || (!IS_SET(flags, WHO_F_CLAN)
                && !is_name(clan->name, clan_names)))
                {
                    continue;
                }
            }

            if (IS_SET(flags, WHO_F_RRACE))
            {
                if ((race = race_lookup(wch->race)) == NULL
                || !is_name(race->name, race_names))
                {
                    continue;
                }
            }

            if (IS_SET(flags, WHO_F_RCLASS))
            {
                if ((class = class_lookup(wch->class)) == NULL
                || !is_name(class->name, class_names))
                {
                    continue;
                }
            }

            nMatch++;
            do_who_raw(ch, wch, output);
        }
    }

    max_on = UMAX(count, max_on);
    if (flags == 0)
        buf_printf(output, "{x\n    Astrum Metaphora");
    buf_printf(output, "{x\n : %d.   : %d.\n", nMatch, max_on);
    page_to_char(buf_string(output), ch);
    buf_free(output);

    bail_out:
    free_string(clan_names);
    free_string(class_names);
    free_string(race_names);
}

DO_FUN(do_nowhois)
{
    char arg[MAX_INPUT_LENGTH];

    argument = one_argument(argument, arg, sizeof(arg));
    if (IS_NPC(ch))
    {
        return;
    }

    if (arg[0] == '\0') TOGGLE_BIT(ch->comm, COMM_NOWHOIS);
    if (!strcmp(arg, "on")) SET_BIT(ch->comm, COMM_NOWHOIS);
    if (!strcmp(arg, "off")) REMOVE_BIT(ch->comm, COMM_NOWHOIS);

    if (!IS_SET(ch->comm, COMM_NOWHOIS))
        act("        .", ch, NULL, NULL, TO_CHAR);
    else
        act("        .", ch, NULL, NULL, TO_CHAR);
}

/* whois command */
DO_FUN(do_whois)
{
    char arg[MAX_INPUT_LENGTH];
    char buf[MAX_STRING_LENGTH];
    const char *heshe = "He(she)";
    const char *immdesc;
    BUFFER *output = NULL;
    clan_t *clan;
    religion_t *religion;
    CHAR_DATA *wch = NULL;
    bool loaded = FALSE;

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        char_act("You must provide a name.", ch);
        return;
    }

    if (!strcmp("self", arg) || !str_cmp(arg, "") || !str_cmp(arg, ""))
        wch = ch;
    else
        wch = gq_findchar(arg);
    if (wch == NULL)
    {
        loaded = TRUE;
        wch = char_load_special(arg);
    }
    if (wch == NULL)
    {
        char_act("    .", ch);
        return;
    }

    if (IS_SET(wch->comm, COMM_NOWHOIS) && ch != wch && !IS_IMMORTAL(ch))
    {
        char_act("     .", ch);
        if (loaded)
            char_nuke(wch);
        return;
    }

    if (output == NULL)
        output = buf_new(ch->lang);

    immdesc = mlstr_cval (wch->immdesc, ch);

    if (IS_IMMORTAL(ch) && !IS_NULLSTR(immdesc))
    {
        buf_printf(output, "{x---------------    -----------------\n\r");
        buf_printf(output, "%s{x", immdesc);
    }

    buf_printf(output, "{x---------------------------------------------------\n");

    if (IS_IMMORTAL(wch) && wch->imm_name)
    {
        buf_printf(output, "%s{x%s{x aka %s {x(%s{x), the %s %s.\n",
               wch->pcdata->pretitle, wch->imm_name, wch->name, wch->pcdata->title,
               flag_string(sex_table, wch->sex),
               race_name(ORG_RACE(wch)));
    } else
    {
        buf_printf(output, "%s{x%s (%s{x), the %s %s.\n",
               wch->pcdata->pretitle, wch->name, wch->pcdata->title,
               flag_string(sex_table, wch->sex),
               race_name(ORG_RACE(wch)));
    }
    snprintf(buf, sizeof(buf), "%s-%s",
             flag_string(ethos_table, wch->ethos),
             IS_GOOD(wch)    ? "good" :
             IS_NEUTRAL(wch) ? "neutral" :
             IS_EVIL(wch)    ? "evil" :
             "unknown");

    buf_printf(output,
               "Lvl: %d+(%d) Class: %s  Align: %s.\n",
               wch->level,
               wch->aff_level,
               class_name(wch),buf);

    clan = clan_lookup(wch->clan);
    if (wch->clan && clan && !IS_IMMORTAL(wch))
    {
        if (wch->pcdata->clan_status != -1)
        {
            switch (wch->pcdata->clan_status)
            {
                case CLAN_COMMONER: buf_add(output, "Commoner"); break;
                case CLAN_SECOND: buf_add(output, "Secondary Leader"); break;
                case CLAN_LEADER: buf_add(output, "Clan Leader"); break;
                case CLAN_NEWBIE: buf_add(output, "Newbie"); break;
                case CLAN_VETERAN: buf_add(output, "Veteran"); break;
                case CLAN_ELITE: buf_add(output, "Elite"); break;
                default: buf_add(output, "Commoner");
            }
        }
        buf_printf(output, "{x of clan %s, {x", clan->name);
    }
    buf_printf(output, "%s %d years old.\n", heshe, get_age(wch));

/*  ... (c) GrayMage //   --  , , 
                                  // : ...
        buf_printf(output, "Kills %d %s and %d %s.\n",
                    wch->pcdata->has_killed,
                    IS_GOOD(ch) ? GETMSG("non-goods", ch->lang) :
                    IS_EVIL(ch) ? GETMSG("non-evils", ch->lang) :
                                  GETMSG("non-neutrals", ch->lang),
                    wch->pcdata->anti_killed,
                    IS_GOOD(ch) ? GETMSG("goods", ch->lang) :
                    IS_EVIL(ch) ? GETMSG("evils", ch->lang) :
                                  GETMSG("neutrals", ch->lang));
*/
    if (!IS_IMMORTAL(wch))
    {
        buf_printf(output, "Joined to %d and completed %d global quests.\n", wch->pcdata->StatAllGlobalQuests, wch->pcdata->StatWinGlobalQuests);
        buf_printf(output, "Requested %d and completed %d quests.\n", wch->pcdata->questnumber, wch->pcdata->questcomplete);
        buf_printf(output, "Earned %d bonus points and %d quest points.\n", wch->pcdata->bp_earned, wch->pcdata->qp_earned);
    }

    religion = religion_lookup(wch->religion);
    if (wch->religion && religion && !IS_IMMORTAL(wch)
    && !IS_SET(religion->flags, RELIGION_HIDDEN))
        buf_printf(output,"Believes the religion of %s.\n", religion->name);

    if (IS_MARRYED(wch))
        buf_printf(output,"%s is married with %s.\n", wch->name, wch->pcdata->marryed);

//        do_who_raw(ch, wch, output);

    buf_add(output, "{x");
    page_to_char(buf_string(output), ch);
    buf_free(output);
    if (loaded)
        char_nuke(wch);
}

DO_FUN(do_count)
{
    int count;
    DESCRIPTOR_DATA *d;

    count = 0;

    for (d = descriptor_list; d != NULL; d = d->next)
        if (d->connected == CON_PLAYING && can_see(ch, d->character))
            count++;

    max_on = UMAX(count,max_on);

    act_puts("  $j $qj{}, ", ch, (const void *) count, NULL, TO_CHAR | ACT_NOLF, POS_DEAD);
    if (max_on == count)
        act_puts(" ", ch, NULL, NULL, TO_CHAR | ACT_NOUCASE, POS_DEAD);
    else
        act_puts("    $j.", ch, (const void *) max_on, NULL, TO_CHAR | ACT_NOUCASE, POS_DEAD);
}

DO_FUN(do_inventory)
{
    char_act("You are carrying : ", ch);
    show_list_to_char(ch->carrying, ch, TRUE, TRUE);
}

DO_FUN(do_equipment)
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int i;
    bool found;
    bool show_all = FALSE;

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] != '\0'  && (!str_prefix(arg, "all")  || !str_prefix(arg, "") || !str_cmp(argument, "")))
        show_all = TRUE;

    act("You are using : ", ch, NULL, NULL, TO_CHAR);
    found = FALSE;
    for (i = 0; show_order[i] >= 0; i++)
    {
        if ((obj = get_eq_char(ch, show_order[i])) != NULL)
        {
            show_obj_to_char(ch, obj, show_order[i]);
            found = TRUE;
        } else if (class_can_wear(ch, show_order[i])  && race_can_wear(ch, show_order[i])  && show_all)
        {
            if ((show_order[i] == WEAR_HOLD  || show_order[i] == WEAR_SHIELD)  && get_eq_char(ch, WEAR_SECOND_WIELD) != NULL)
            {
                continue;
            }

            if (show_order[i] == WEAR_SECOND_WIELD  && (get_eq_char(ch, WEAR_SHIELD) != NULL  || get_eq_char(ch, WEAR_HOLD) != NULL))
            {
                continue;
            }

            if ((show_order[i] == WEAR_TATTOO  && ch->religion == 0)   || (show_order[i] == WEAR_CLANMARK    && ch->clan == 0))
            {
                continue;
            }

            act(wear_loc_names[show_order[i]], ch, "{G<{z{rnothing{z{G>{z", NULL, TO_CHAR);
            found = TRUE;
        }

    }

    for (obj = ch->carrying; obj != NULL; obj = obj->next_content)
    {
        if (obj->wear_loc != WEAR_STUCK_IN)
            continue;

        show_obj_to_char(ch, obj, WEAR_STUCK_IN);
        found = TRUE;
    }

    if (!found)
        act("Nothing.", ch, NULL, NULL, TO_CHAR);
}

DO_FUN(do_compare)
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    OBJ_DATA *obj1;
    OBJ_DATA *obj2;
    int value1;
    int value2;
    char *cmsg;

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));
    if (arg1[0] == '\0')
    {
        act("Compare what to what?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((obj1 = get_obj_carry(ch, arg1)) == NULL)
    {
        act("You do not have that item.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (arg2[0] == '\0')
    {
        for (obj2 = ch->carrying; obj2 != NULL; obj2 = obj2->next_content)
            if (obj2->wear_loc != WEAR_NONE
            && can_see_obj(ch,obj2)
            && obj1->pIndexData->item_type == obj2->pIndexData->item_type
            && (obj1->wear_flags & obj2->wear_flags & ~ITEM_TAKE))
                break;

        if (obj2 == NULL)
        {
            act("You aren't wearing anything comparable.", ch, NULL, NULL, TO_CHAR);
            return;
        }
    } else if ((obj2 = get_obj_carry(ch,arg2)) == NULL)
    {
        act("You do not have that item.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    cmsg            = NULL;
    value1  = 0;
    value2  = 0;

    if (obj1 == obj2)
        cmsg = "You compare $p to $p.  It looks about the same.";
    else if (obj1->pIndexData->item_type != obj2->pIndexData->item_type)
        cmsg = "You can't compare $p and $P.";
    else
    {
        switch (obj1->pIndexData->item_type)
        {
            default:
                cmsg = "You can't compare $p and $P.";
                break;

            case ITEM_ARMOR:
                value1 = obj1->value[0]+obj1->value[1]+obj1->value[2];
                value2 = obj2->value[0]+obj2->value[1]+obj2->value[2];
                break;

            case ITEM_WEAPON:
                value1 = (1 + obj1->value[2]) * obj1->value[1];
                value2 = (1 + obj2->value[2]) * obj2->value[1];
                break;
        }
    }

    if (cmsg == NULL)
    {
        if (value1 == value2)
            cmsg = "$p and $P look about the same.";
        else if (value1  > value2)
            cmsg = "$p looks better than $P.";
        else
            cmsg = "$p looks worse than $P.";
    }

    act(cmsg, ch, obj1, obj2, TO_CHAR);
}

DO_FUN(do_credits)
{
    do_help(ch, "muddy");
}

DO_FUN(do_where)
{
    char arg[MAX_INPUT_LENGTH];
    AREA_DATA *pArea;
    CHAR_DATA *victim;
    DESCRIPTOR_DATA *d;
    bool found;
    bool fPKonly = FALSE;
    BUFFER *output;
    int sn, mana = 0;
    int chance = 0;
    int index;
    AREA_DATA *pArea2;

    if (!ch->in_room || !ch->in_room->area)
    {
        log_printf("BUG [do_where]! Char %s not in area.", ch->name);
        return;
    }

    one_argument(argument, arg, sizeof(arg));

    if (!check_blind(ch))
        return;

    if (room_is_dark(ch))
    {
        char_act("It's too dark to see.", ch);
        return;
    }

    if (IS_SET(ch->in_room->room_flags, ROOM_NOWHERE)
    && !IS_IMMORTAL(ch))
    {
        char_act("You can not understand, where you are.", ch);
        return;
    }

    sn = sn_lookup("lore");
    pArea2 = NULL;
    index = number_range(2, area_last->vnum);

    chance = get_skill(ch, sn);

    mana = SKILL(sn_lookup("lore"))->min_mana;
    if (ch->mana < mana)
        chance /= 2;
    else
        ch->mana -= mana;

    if (chance < 1)
        chance = 50;

    if (number_percent() < chance)
    {
        pArea2 = ch->in_room->area;
        check_improve(ch, sn, TRUE, 15);
    } 
    else
    {
        pArea2 = area_lookup(index);
    }

    if (!str_cmp(arg,"pk")
        || !str_cmp(arg, ""))
    {
        fPKonly = TRUE;
    }
    WAIT_STATE(ch, 1);

    if (arg[0] == '\0' || fPKonly)
    {
        pArea = ch->in_room->area;
        output = buf_new(ch->lang);

        if (IS_IMMORTAL(ch))
            buf_printf(output,"RVnum : [%d-%d] AVnum : %d (%d) in %s.\n",
                       pArea->min_vnum, pArea->max_vnum,
                       pArea->vnum, pArea->security,
                       pArea->file_name);

        if (ch->sector_level > 0)
            buf_add(output, "You feel yourself comfortably here.\n");
        else if (ch->sector_level < 0)
            buf_add(output, "You feel yourself uncomfortably here.\n");

        if (pArea->clan_owner)
            buf_printf(output, "This area belongs to %s clan.\n", pArea->clan_owner->name);

        if ( IS_SET(ch->in_room->room_flags, ROOM_FRESHWATER_FISH) )
        {
            if(number_percent() < get_skill(ch, gsn_lore_fishing))
            {
                buf_printf(output,"     .\n");
                check_improve(ch, gsn_lore_fishing, TRUE, 1);
            }
            else
                check_improve(ch, gsn_lore_fishing, FALSE, 1);
        }
        if ( IS_SET(ch->in_room->room_flags, ROOM_SALTWATER_FISH) )
        {
            if(number_percent() < get_skill(ch, gsn_lore_fishing))
            {
                buf_printf(output,"     .\n");
                check_improve(ch, gsn_lore_fishing, TRUE, 1);
            }
            else
                check_improve(ch, gsn_lore_fishing, FALSE, 1);
        }

        if (IS_SET (ch->in_room->area->flags, AREA_UNDER_CONSTRUCTION))
        {
            buf_printf(output,"    .\n");
        }

        page_to_char(buf_string(output), ch);
        buf_free(output);
        act("Players in your area ({G$t{x):",
            ch, pArea2->name, NULL, TO_CHAR);

        found = FALSE;
        for (d = descriptor_list; d; d = d->next)
        {
            if (d->connected == CON_PLAYING
            && (victim = d->character) != NULL
            && !IS_NPC(victim)
            && (!fPKonly || in_PK(ch, victim))
            && victim->in_room != NULL
            && victim->in_room->area == ch->in_room->area
            && !is_affected(victim, gsn_stealth))
            {
                CHAR_DATA *doppel;
                found = TRUE;

                if (is_affected(victim, gsn_doppelganger)
                && (IS_NPC(ch)
                || !IS_SET(ch->plr_flags, PLR_HOLYLIGHT)))
                    doppel = victim->doppel;
                else
                    doppel = victim;

                if (can_see(ch, victim))
                //act_puts3("$FL28{$t $N} $R", ch,
                act_puts3("$FL28{$t $T} $R", ch,
                          (in_PK(ch, doppel)
                           && !IS_IMMORTAL(ch)
                           && !IS_IMMORTAL(doppel)) ? "{r[{RPK{r]{x" : "    ",
                          //victim,
                          (IS_SET(ch->comm2, COMM2_RUSNAMES) && victim->pcdata && victim->pcdata->rusnames[0]) ? victim->pcdata->rusnames[0] : victim->name,
                          victim->in_room,
                          TO_CHAR | ACT_TRANS, POS_RESTING);
                else
                {
                    // char can't see victim, but the spy can help
                    clan_t * clan = clan_lookup (ch->clan);

                    if (clan && altar_works (ch, OUTPOST_POS) && IS_SET (clan->conq_flags, CLAN_WITH_SPY))
                        act_puts3("$FL28{$t $T} $R", ch,
                                  (in_PK(ch, doppel)
                                   && !IS_IMMORTAL(ch)
                                   && !IS_IMMORTAL(doppel)) ? "{r[{RPK{r]{x" : "    ",
                                  "someone",
                                  victim->in_room,
                                  TO_CHAR | ACT_TRANS, POS_RESTING);

                }
            }
        }
        if (!found)
            act(".", ch, NULL, NULL, TO_CHAR);
    } 
    else
    {
        int number = number_argument(argument, arg, sizeof(arg));
        int count = 0;

        found = FALSE;
        for (victim = char_list; victim != NULL; victim = victim->next)
        {
            if (victim->in_room != NULL
                && victim->in_room->area == ch->in_room->area
                && can_see(ch, victim)
                //&& is_name(arg, victim->name)
                && is_name_rus(victim, arg)
                && !is_affected(victim, gsn_stealth))
            {
                if (++count == number)
                {
                    found = TRUE;
                    act("$FL28{$N} $r", ch, victim->in_room, victim, TO_CHAR);
                    break;
                }
            }
        }
        if (!found)
            act("You don't find $T.", ch, NULL, arg, TO_CHAR);
    }
}

DO_FUN(do_consider)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    char *cmsg;
    char *align;
    int diff;

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        act("Consider killing whom?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((victim = get_char_room(ch, arg)) == NULL)
    {
        act("They aren't here.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (victim == ch)
    {
        act("Suicide is against your way.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!in_PK(ch, victim))
    {
        act("Don't even think about it.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!IS_NPC(victim) && IS_SET(victim->comm, PLR_PEACE))
    {
        act("Uh-you! Peace mudder!", ch, NULL, NULL, TO_CHAR);
        return;
    }

    diff = victim->level - ch->level;

    if (diff <= -10)        cmsg = "You can kill $N naked and weaponless.";
    else if (diff <=  -5)   cmsg = "$N is no match for you.";
    else if (diff <=  -2)   cmsg = "$N looks like an easy kill.";
    else if (diff <=   2)   cmsg = "The perfect match!";
    else if (diff <=   7)   cmsg = "$N says '{GDo you feel lucky, punk?{x'.";
    else if (diff <=   12)  cmsg = "$N laughs at you mercilessly.";
    else                    cmsg = "Death will thank you for your gift.";

    if (IS_EVIL(ch) && IS_EVIL(victim))
        align = "$N     .";
    else if (IS_GOOD(victim) && IS_GOOD(ch))
        align = "$N   .";
    else if (IS_GOOD(victim) && IS_EVIL(ch))
        align = "$N  ,       .";
    else if (IS_EVIL(victim) && IS_GOOD(ch))
        align = "$N     .";
    else if (IS_NEUTRAL(ch) && IS_EVIL(victim))
        align = "$N  .";
    else if (IS_NEUTRAL(ch) && IS_GOOD(victim))
        align = "$N  .";
    else if (IS_NEUTRAL(ch) && IS_NEUTRAL(victim))
        align = "$N     .";
    else
        align = "$N   .";

    act(cmsg, ch, NULL, victim, TO_CHAR);
    act(align, ch, NULL, victim, TO_CHAR);
}

void set_title(CHAR_DATA *ch, const char *title)
{
    char buf[MAX_TITLE_LENGTH];
    static char nospace[] = "-.,!?':";

    buf[0] = '\0';

    if (title)
    {
        if (strchr(nospace, *cstrfirst(title)) == NULL)
        {
            buf[0] = ' ';
            buf[1] = '\0';
        }

        strnzcat(buf, sizeof(buf), title);
    }

    free_string(ch->pcdata->title);
    ch->pcdata->title = str_dup(buf);
}

void set_pretitle(CHAR_DATA *ch, const char *pretitle)
{
    char buf[MAX_TITLE_LENGTH] ;
    static char nospace[] = "-.,!?':" ;

    strnzcpy (buf, sizeof(buf), pretitle) ;

    if (pretitle && pretitle [strlen (pretitle) - 1] != ' ' &&
        strchr (nospace, pretitle [strlen (pretitle) - 1]) == 0 &&
        strlen (buf) < MAX_TITLE_LENGTH - 1)
    {
        buf[strlen (buf)]   = ' '  ;
        buf[strlen (buf)+1] = '\0' ;
    }

    free_string (ch->pcdata->pretitle) ;
    ch->pcdata->pretitle = str_dup (buf) ;
}

DO_FUN(do_title)
{
    if (IS_NPC(ch))
        return;

    if (IS_AFFECTED(ch, AFF_CHARM))
        return;

    if (IS_SET(ch->plr_flags, PLR_NOTITLE))
    {
        act("You can't change your title.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (argument[0] == '\0')
    {
        act("Change your title to what?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (strstr(argument, "{/"))
    {
        char_act("Illegal characters in title.", ch);
        return;
    }

    if ((ch->pcdata->questpoints < 50)
    && !IS_IMMORTAL(ch))
    {
        act("       .",
            ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!IS_IMMORTAL(ch))
        ch->pcdata->questpoints -= 50;

    set_title(ch, argument);
    char_printf(ch, "Now you : %s %s.\n", ch->name, ch->pcdata->title);

    if (IS_SET(ch->plr_flags, PLR_AUTOTITLE))
        act("\n!     AUTOTITLE!", ch, NULL, NULL, TO_CHAR);
}

DO_FUN(do_description)
{
    char arg[MAX_STRING_LENGTH];

    if (IS_NPC(ch))
    {
        act("Huh?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    one_argument(argument, arg, sizeof(arg));

    if (!str_cmp(arg, "edit")
    || !str_cmp(arg, ""))
    {
        string_append(ch, mlstr_convert(&ch->description, -1));
        return;
    }

    char_printf(ch, "Your description is : \n"
                "%s\n"
                "Use 'desc edit' to edit your description.\n",
                mlstr_mval(ch->description));
}

DO_FUN(do_report)
{
    CHAR_DATA * pet;
    BUFFER    * output = NULL;
    char        arg [MAX_STRING_LENGTH];
    MOB_EXTRA * ability;


    // report pet - output info about pet with receive_level act flag
    // syntax: report pet <pet_name>
    argument = one_argument(argument, arg, sizeof(arg));

    if (!str_cmp (arg, "pet"))
    {
        // checks, checks, checks
        if (argument[0] == '\0')
        {
            char_act ("Syntax: {creport pet <pet_name>{x", ch);
            return;
        }
        pet = get_char_room (ch, argument);
        if (pet == NULL)
        {
            char_printf (ch, "You can't find %s in this room.\n", argument);
            return;
        }
        if (!IS_NPC (pet))
        {
            act("$N is not a mobile. Just ask $gN{him}.", ch, NULL, pet, TO_CHAR);
            return;
        }
        if ((!IS_AFFECTED(pet, AFF_CHARM) || (pet->master != ch)) && !IS_IMMORTAL(ch))
        {
            act("$N is not your pet.", ch, NULL, pet, TO_CHAR);
            return;
        }
        if (!IS_SET(pet->pIndexData->act, ACT_RECEIVE_LEVEL))
        {
            act("It's simple mobile. You can't retrieve any special information about it.", ch, NULL, pet, TO_CHAR);
            return;
        }

        // Yes! It's right mobile!
        output = buf_new(ch->lang);
        buf_add(output,    "\n    {G/~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\\{x\n");
        buf_printf(output, "{x    {G|             {CDetailed info for {W%-20s          {G|{x\n", fix_short(mlstr_cval(pet->short_descr, ch)));
        buf_add(output,    "{x    {G|-----------------------------------------------------------|{x\n");

        buf_printf(output, "{x    {G|    {WCurrent rank: {c%2d{x,  {WExperience to next rank:{c%5d{x       {G|{x\n",
            pet->mob_rank, pet->mob_tnl);
        buf_add(output,    "{x    {G|                                                           |{x\n");

        buf_add(output,    "{x    {G|    {WVital statistics:                                      {G|{x\n");
        buf_printf(output, "{x    {G|        {WHit points {C: {y%5d{x/{y%5d{x   {WMana    {C: {y%5d{x/{y%5d{x   {G|{x\n",
            pet->hit, pet->max_hit,pet->mana, pet->max_mana );
        buf_printf(output, "{x    {G|        {WHitroll    {C:{R%4d{x           {WDamroll {C:{R%4d           {G|{x\n",
            pet->hitroll, pet->damroll );

        if (pet->extra_attacks || pet->abilities)
        {
            buf_add(output,"{x    {G|-----------------------------------------------------------|{x\n");
            buf_add(output,"{x    {G|    {WExtra abilities:                                       {G|{x\n");
            if (pet->extra_attacks)
                buf_printf(output, "{x    {G|        {WExtra attacks        {C:{R%2d{x                           {G|{x\n",
                    pet->extra_attacks);
            for (ability = created_golem_extra; ability->name != NULL; ++ability)
                if (IS_SET(pet->abilities, ability->flag))
                    buf_printf(output, "{x    {G|        {W%-40s           {G|{x\n", GETMSG (ability->name, ch->lang));
        }

        buf_add(output,    "{x    {G|___________________________________________________________|{x\n");
        buf_add(output, "{x");

        page_to_char(buf_string(output), ch);
        buf_free(output);
        return;
    }

    doprintf(do_say, ch, "I have %d/%d hp %d/%d mana %d/%d mv.",
        ch->hit, ch->max_hit,
        ch->mana, ch->max_mana,
        ch->move, ch->max_move);
}

/*
 * 'Wimpy' originally by Dionysos.
 */
DO_FUN(do_wimpy)
{
    char arg[MAX_INPUT_LENGTH];
    int wimpy;

    if (IS_SAMURAI(ch))
    {
        char_printf(ch, "You don't deal with wimpies, or such feary things.\n");
        if (ch->wimpy != 0)
            ch->wimpy = 0;
        return;
    }

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
        wimpy = ch->max_hit / 5;
    else
        wimpy = atoi(arg);

    if (wimpy < 0)
    {
        act("Your courage exceeds your wisdom.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (wimpy > ch->max_hit / 2)
    {
        act("Such cowardice ill becomes you.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    ch->wimpy       = wimpy;

    char_printf(ch, "Wimpy set to %d hit points.\n", wimpy);
    return;
}

DO_FUN(do_password)
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    const char *pwdold;
    const char *pwdnew;

    if (IS_NPC(ch))
        return;

    argument = first_arg(argument, arg1, sizeof(arg1), FALSE);
    argument = first_arg(argument, arg2, sizeof(arg2), FALSE);

    pwdold = ch->pcdata->pwd;

    if (arg1[0] == '\0' || arg2[0] == '\0')
    {
        act(": password < > < >.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (strcmp(str_crypt(arg1), pwdold))
    {
        WAIT_STATE(ch, 40);
        act(" .   10 ...", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (strlen(arg2) < 5)
    {
        char_act("       .", ch);
        return;
    }

    /*
     * No tilde allowed because of player file format.
     */
    pwdnew = arg2;
    if (strchr(pwdnew, '~') != NULL)
    {
        char_act("  ,  .", ch);
        return;
    }
    pwdnew = str_crypt(arg2);
    free_string(ch->pcdata->pwd);
    ch->pcdata->pwd = str_dup(pwdnew);
    act("  .", ch, NULL, NULL, TO_CHAR);
    save_char_obj(ch, FALSE, FALSE);
    return;
}

void scan_list(ROOM_INDEX_DATA *scan_room, CHAR_DATA *ch, int depth, int door)
{
    CHAR_DATA *rch;

    if (scan_room == NULL)
        return;

    for (rch = scan_room->people; rch != NULL; rch = rch->next_in_room)
    {
        if (rch == ch || !can_see(ch, rch))
            continue;
        act("-       $N.", ch, NULL, rch, TO_CHAR);
    }
}

DO_FUN(do_scan2)
{
    extern char *const dir_name[];
    EXIT_DATA *pExit;
    int door;

    if (IS_NPC(ch) || ch->level < LEVEL_IMMORTAL)
        act("$n looks all around.", ch, NULL, NULL, TO_ROOM);
    if (!check_blind(ch))
        return;

    act("Looking around you see : ", ch, NULL, NULL, TO_CHAR);

    act("{Chere{x : ", ch, NULL, NULL, TO_CHAR);
    scan_list(ch->in_room, ch, 0, -1);
    for (door = 0; door < 6; door++)
    {
        if ((pExit = ch->in_room->exit[door]) == NULL
            || !pExit->to_room.r
            || !can_see_room(ch,pExit->to_room.r))
            continue;
        if (IS_SET(pExit->exit_info, EX_INVIS)
            && pExit->to_room.r->people == NULL)
            continue;
        char_printf(ch, "{C%s{x:\n", dir_name[door]);
        if (IS_SET(pExit->exit_info, EX_CLOSED))
        {
            act("{x     You see closed door.", ch, NULL, NULL, TO_CHAR);
            continue;
        }
        if (IS_SET(pExit->exit_info, EX_NOSCAN))
        {
            act("     -     .", ch, NULL, NULL, TO_CHAR);
            continue;
        }
        scan_list(pExit->to_room.r, ch, 1, door);
    }
}

DO_FUN(do_scan)
{
    char dir[MAX_INPUT_LENGTH];
    ROOM_INDEX_DATA *in_room;
    ROOM_INDEX_DATA *to_room;
    EXIT_DATA *exit;        /* pExit */
    int door;
    int range;
    int i, j = 0;
    CHAR_DATA *person;
    int numpeople;
    bool        found;
    extern bool exploring;

    one_argument(argument, dir, sizeof(dir));

    if (dir[0] == '\0')
    {
        do_scan2(ch, str_empty);
        return;
    }

    if (!str_prefix(dir, ""))
        door = 4;
    else if (!str_prefix(dir, ""))
        door = 5;
    else
    {
        switch (dir[0])
        {
            case 'N':
            case 'n':
            case '':
            case '':
                door = 0;
                break;
            case 'E':
            case 'e':
            case '':
            case '':
                door = 1;
                break;
            case 'S':
            case 's':
            case '':
            case '':
                door = 2;
                break;
            case 'W':
            case 'w':
            case '':
            case '':
                door = 3;
                break;
            case 'U':
            case 'u':
//  case '':
//  case '':
//  case '':
//  case '':
                door = 4;
                break;
            case 'D':
            case 'd':
            case '':
            case '':
//  case '':
//  case '':
//  case '':
//  case '':
                door = 5;
                break;
            default:
                act("Wrong direction.", ch, NULL, NULL, TO_CHAR);
                return;
        }
    }

    act("$n scans $t.", ch, dir_name[door], NULL, TO_ROOM | ACT_TRANS);
    if (!check_blind(ch))
        return;

    act_puts("You scan $t.", ch, dir_name[door], NULL, TO_CHAR | ACT_TRANS, POS_DEAD);

    range = 1 + ch->level/10;

    in_room = ch->in_room;
    for (i = 1; i <= range; i++)
    {
        exit = in_room->exit[door];
        if (!exit)
            return;
        to_room = exit->to_room.r;
        if (!to_room)
            return;

        if (IS_SET(exit->exit_info, EX_CLOSED)
        && can_see_room(ch, exit->to_room.r))
        {
            act("     You see closed door.", ch, NULL, NULL, TO_CHAR);
            return;
        }

        if (IS_SET(exit->exit_info, EX_NOSCAN)
        && can_see_room(ch, exit->to_room.r))
        {
            act("     -     .", ch, NULL, NULL, TO_CHAR);
            return;
        }
        for (numpeople = 0, person = to_room->people; person != NULL;
            person = person->next_in_room)
            if (can_see(ch,person))
            {
                numpeople++;
                break;
            }

        if (exploring && ch->pcdata && IS_SET(ch->pcdata->wishes, WISH_SHOWSCRY))
        {
            // GM : Check for EXPLORING
            found = FALSE;
            if (ch->pcdata->last_visited)
            {
                if (!str_cmp (ch->pcdata->last_visited->name, to_room->area->name))
                {
                    for (j = 0 ; j < ch->pcdata->last_visited->explored_room_count ; ++j)
                    {
                        if (ch->pcdata->last_visited->explored_room_vnums [j] == to_room->vnum)
                            found = TRUE;
                    }
                }
            }
            if (!found)
                char_printf(ch, "{R***** Range %d *****{x\n", i);
            else
                char_printf(ch, "{G***** Range %d *****{x\n", i);

            if (numpeople)
            {
                show_char_to_char(to_room->people, ch);
                act(str_empty, ch, NULL, NULL, TO_CHAR);
            }
        } else if (numpeople)
        {
            char_printf(ch, "***** Range %d *****\n", i);
            show_char_to_char(to_room->people, ch);
            act(str_empty, ch, NULL, NULL, TO_CHAR);
        }
        in_room = to_room;
    }
}

DO_FUN(do_request)
{
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA  *obj;
    AFFECT_DATA af;

    if (is_affected(ch, gsn_reserved))
    {
        act("Wait for a while to request again.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));

    if (IS_NPC(ch))
        return;

    if (arg1[0] == '\0' || arg2[0] == '\0')
    {
        act("Request what from whom?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((victim = get_char_room(ch, arg2)) == NULL)
    {
        act("They aren't here.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!IS_NPC(victim))
    {
        act("Why don't you just ask the player?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!IS_GOOD(victim))
    {
        do_say(victim, "I will not give anything to you.");
        if (IS_EVIL(victim))
        {
            do_say(victim, "Die, evil!");
            do_murder(victim, ch->name);
        }
        return;
    }


    if (!IS_GOOD(ch))
    {
        do_say(victim, "I will not give anything to someone so impure.");
        return;
    }

    if (ch->move < (50 + ch->level))
    {
        do_say(victim, "You look rather tired, "
                   "why don't you rest a bit first?");
        return;
    }

    if (IS_CLAN_GUARD(victim))
    {
        act("    .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    WAIT_STATE(ch, PULSE_VIOLENCE);
    ch->move -= 10;
    ch->move = UMAX(ch->move, 0);

    if (victim->level >= (2 * ch->level))
    {
        do_say(victim, " ݣ  , .");
        return;
    }

    if ((obj = get_obj_carry(victim , arg1)) == NULL
    && (obj = get_obj_wear(victim, arg1)) == NULL)
    {
        do_say(victim, "Sorry, I don't have that.");
        return;
    }
    if (IS_SET(obj->extra_flags, ITEM_INVENTORY))
    {
        do_say(victim, "Sorry, but this obj is only for trade.");
        return;
    }
    if (!IS_GOOD(victim))
    {
        do_say(victim, "I'm not about to give you anything!");
        do_murder(victim, ch->name);
        return;
    }

    if (obj->wear_loc != WEAR_NONE)
        unequip_char(victim, obj);

    if (!can_drop_obj(ch, obj))
    {
        do_say(victim, "Sorry, I can't let go of it.  It's cursed.");
        return;
    }

    if (ch->carry_number + get_obj_number(obj) > can_carry_n(ch))
    {
        act("Your hands are full.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (ch->carry_weight + get_obj_weight(obj) > can_carry_w(ch))
    {
        act("You can't carry that much weight.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!can_see_obj(ch, obj))
    {
        act("You don't see that.", ch, NULL, victim, TO_CHAR);
        return;
    }

    obj_from_char(obj);
    obj_to_char(obj, ch);
    act("$n requests $p from $N.", ch, obj, victim, TO_NOTVICT);
    act("You request $p from $N.", ch, obj, victim, TO_CHAR);
    act("$n requests $p from you.", ch, obj, victim, TO_VICT);

    oprog_call(OPROG_GIVE, obj, ch, victim);

    ch->move -= (50 + ch->level);
    ch->move = UMAX(ch->move, 0);
    ch->hit -= 3 * (ch->level / 2);
    ch->hit = UMAX(ch->hit, 0);

    act("You feel grateful for the trust of $N.", ch, NULL, victim, TO_CHAR);
//    act("and for the goodness you have seen in the world.", ch, NULL, NULL, TO_CHAR);

    af.type = gsn_reserved;
    af.where = TO_AFFECTS;
    af.level = ch->level;
//        af.duration = ch->level / 10;
    af.duration = 1;
    af.location = APPLY_NONE;
    af.modifier = 0;
    af.bitvector = 0;
    affect_to_char(ch, &af);
}

DO_FUN(do_hometown)
{
    int amount;
    int htn;
    race_t *r;
    class_t *cl;

    if (IS_NPC(ch))
    {
        act_puts("You can't change your hometown!",
                 ch, NULL, NULL, TO_CHAR, POS_DEAD);
        return;
    }

    if ((r = race_lookup(ORG_RACE(ch))) == NULL
    || !r->pcdata
    || (cl = class_lookup(ch->class)) == NULL)
        return;

    if (!IS_SET(ch->in_room->room_flags, ROOM_REGISTRY))
    {
        act_puts("You have to be in the Registry to change your hometown.",
                 ch, NULL, NULL, TO_CHAR, POS_DEAD);
        return;
    }

    if ((htn = hometown_permanent(ch)) >= 0)
    {
        act_puts("Your hometown is $t, permanently. You can't change your hometown.", ch, hometown_name(htn), NULL, TO_CHAR | ACT_TRANS, POS_DEAD);
        return;
    }

    amount = (ch->level * 250) + 1000;

    if (argument[0] == '\0')
    {
        act_puts("The change of hometown will cost you $j gold.",  ch, (const void*) amount, NULL, TO_CHAR, POS_DEAD);
        act_puts("Choose from: ", ch, NULL, NULL, TO_CHAR, POS_DEAD);
        hometown_print_avail(ch);
        char_act(".", ch);
        return;
    }

    if ((htn = htn_lookup(argument)) < 0)
    {
        act_puts("That's not a valid hometown.",  ch, NULL, NULL, TO_CHAR, POS_DEAD);
        return;
    }

    if (htn == ch->hometown)
    {
        act_puts("But you already live in $t!",  ch, hometown_name(htn), NULL,  TO_CHAR | ACT_TRANS, POS_DEAD);
        return;
    }

    if (hometown_restrict(HOMETOWN(htn), ch))
    {
        act_puts("You are not allowed there.",   ch, NULL, NULL, TO_CHAR, POS_DEAD);
        return;
    }

    if (ch->pcdata->bank_g < amount)
    {
        act_puts("You don't have enough money in bank to change hometowns!",  ch, NULL, NULL, TO_CHAR, POS_DEAD);
        return;
    }

    ch->hometown = htn;
    act_puts("Now your hometown is $t.",  ch, hometown_name(ch->hometown),  NULL, TO_CHAR | ACT_TRANS, POS_DEAD);
}

DO_FUN(do_detect_hidden)
{
    AFFECT_DATA     af;
    int             chance;
    int             sn;

    if ((sn = sn_lookup("detect hide")) < 0
        ||  (chance = get_skill(ch, sn)) == 0)
    {
        act("Huh?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_AFFECTED(ch, AFF_DETECT_HIDDEN))
    {
        act("       . ", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (number_percent() > chance)
    {
        char_act("    ,     .", ch);
        check_improve(ch, sn, FALSE, 1);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = LVL(ch);
    af.duration  = LVL(ch);
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = AFF_DETECT_HIDDEN;
    affect_to_char(ch, &af);
    act("  .", ch, NULL, NULL, TO_CHAR);
    check_improve(ch, sn, TRUE, 1);
}

DO_FUN(do_ultravision)
{
    AFFECT_DATA     af;
    int             chance;
    int             sn;

    if ((sn = sn_lookup("ultravision")) < 0
        || (chance = get_skill(ch, sn)) == 0)
    {
        act("Huh?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (is_affected(ch, gsn_ultravision))
    {
        act("Ultravision status is ON.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (number_percent() > chance)
    {
        char_act("Ultravision status is FAIL.", ch);
        check_improve(ch, sn, FALSE, 1);
        WAIT_STATE(ch, SKILL(gsn_ultravision)->beats/2);
        return;
    }

    af.where     = TO_AFFECTS;
    af.type      = sn;
    af.level     = LVL(ch);
    af.duration  = LVL(ch);
    af.location  = APPLY_NONE;
    af.modifier  = 0;
    af.bitvector = AFF_DETECT_HIDDEN;
    affect_to_char(ch, &af);

    af.bitvector = AFF_ACUTE_VISION;
    affect_to_char(ch, &af);

    af.bitvector = AFF_DETECT_INVIS;
    affect_to_char(ch, &af);

    act("Your eyes are open.", ch, NULL, NULL, TO_CHAR);
    check_improve(ch, sn, TRUE, 1);
    WAIT_STATE(ch, SKILL(gsn_ultravision)->beats);
}

DO_FUN(do_identify)
{
    OBJ_DATA *obj;
    CHAR_DATA *rch;

    if ((obj = get_obj_carry(ch, argument)) == NULL)
    {
        act("   .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    for (rch = ch->in_room->people; rch != NULL; rch = rch->next_in_room)
        if (IS_NPC(rch) && rch->pIndexData->vnum == MOB_VNUM_SAGE)
            break;

    if (!rch)
    {
        char_act("        .", ch);
        return;
    }

    if (IS_IMMORTAL(ch))
        act("$n   !", rch, obj, ch, TO_VICT);
    else if (ch->gold < 1)
    {
        act("$n   $p.", rch, obj, 0, TO_ROOM);
        act("     1 .", ch, NULL, NULL, TO_CHAR);
        return;
    } else
    {
        ch->gold -= 1;
        act("  .", ch, NULL, NULL, TO_CHAR);
    }

    act("$n gives a wise look at $p.", rch, obj, 0, TO_ROOM);
    spell_identify(0, 0, ch, obj ,0);
}

DO_FUN(do_score)
{
    char buf2[MAX_INPUT_LENGTH];
    char title[MAX_STRING_LENGTH], year[MAX_STRING_LENGTH];
    const char *name;
    int ekle = 0;
    int delta;
    static char cur_color[MAX_STATS], max_color[MAX_STATS];
    int i, slevel = 0;
    AFFECT_DATA *paf;
    int svs = 0;
    class_t *cl;
    //race_t *r;
    BUFFER *output;

    for (paf = ch->affected;paf; paf = paf->next)
        if (paf->location == APPLY_SPELL_AFFECT)
            slevel += paf->modifier;

    for (i = 0; i < MAX_STATS; i++)
    {
        if (ch->perm_stat[i] < get_curr_stat(ch, i))
            max_color[i] = (get_curr_stat(ch, i) < get_max_train(ch, i)) ?
                           'Y' : 'G';
        else if (ch->perm_stat[i] > get_curr_stat(ch, i))
            max_color[i] = 'r';
        else
            max_color[i] = (get_curr_stat(ch, i) < get_max_train(ch, i)) ?
                           'Y' : 'G';

        if (ch->perm_stat[i] < get_max_train(ch, i))
            cur_color[i] = 'Y';
        else if (ch->perm_stat[i] > get_max_train(ch, i))
            cur_color[i] = 'w';
        else cur_color[i] = 'G';
    }

    if ((cl = class_lookup(ch->class)) == NULL)
        return;

    output = buf_new(ch->lang);
    buf_add(output, "\n      {G/~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~/~~\\{x\n");

    if (IS_NPC(ch))
        strnzcpy(title, sizeof(title), " $gn{}.");
    else
        strnzcpy(title, sizeof(title), ch->pcdata->title);
    name = IS_NPC(ch) ? capitalize(mlstr_val(ch->short_descr, ch->lang)) :
           (ch->imm_name) ? ch->imm_name : ch->name;
    delta = strlen(title) - cstrlen(title) + MAX_CHAR_NAME - cstrlen(name);
    title[32+delta] = '\0';

    if (get_age(ch) % 10 == 1)
        strnzcpy(year, sizeof(year), " ");
    else if (get_age(ch) % 10 == 2 || get_age(ch) % 10 == 3 || get_age(ch) % 10 == 4)
        strnzcpy(year, sizeof(year), "");
    else strnzcpy(year, sizeof(year), " ");
    snprintf(buf2, sizeof(buf2), "     {G|{x   %%s%%-%ds {Y%%3d %%s        {G|____|{x\n", 33+delta);
    buf_printf(output, buf2, name, title, get_age(ch), year);

    buf_add(output, "     {G|{C+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+{G|{x\n");

    if (slevel == 0)
    {
        buf_printf(output, "     {G| {R : {x%-3d (%+3d)    {C|  {RStr:  {x{%c%2d{z ({%c%2d{z) {C| {R   : {x%-10.10s{G|{x\n",
               ch->level,
               ch->aff_level,
               cur_color[STAT_STR],
               ch->perm_stat[STAT_STR], max_color[STAT_STR],
               get_curr_stat(ch,STAT_STR),
               religion_name(ch->religion));
    } else
    {
        buf_printf(output, "     {G| {R : {x%-3d (%+3d%+3d) {C|  {RStr:  {x{%c%2d{z ({%c%2d{z) {C| {R   : {x%-10.10s{G|{x\n",
               ch->level,
               ch->aff_level, slevel,
               cur_color[STAT_STR],
               ch->perm_stat[STAT_STR], max_color[STAT_STR],
               get_curr_stat(ch,STAT_STR),
               religion_name(ch->religion));
    }

    buf_printf(output,
               "     {G| {R    : {x%-11.11s  {C|  {RInt:  {x{%c%2d{z ({%c%2d{z) {C| {R   :  {x%4d     {G|{x\n",
               race_name(ch->race),
               cur_color[STAT_INT],
               ch->perm_stat[STAT_INT], max_color[STAT_INT],
               get_curr_stat(ch, STAT_INT),
               ch->practice);

    buf_printf(output,
               "     {G| {R     : {x%-11.11s  {C|  {RWis:  {x{%c%2d{z ({%c%2d{z) {C| {R:  {x%4d     {G|{x\n",
               GETMSG(flag_string(sex_table, ch->sex), ch->lang),
               cur_color[STAT_WIS],
               ch->perm_stat[STAT_WIS], max_color[STAT_WIS],
               get_curr_stat(ch,STAT_WIS),
               ch->train);

    buf_printf(output,
               "     {G| {R   : {x%-12.12s {C|  {RDex:  {x{%c%2d{z ({%c%2d{z) {C| {R : {x%5d     {G|{x\n",
               IS_NPC(ch) ? "" : cl->name,
               cur_color[STAT_DEX],
               ch->perm_stat[STAT_DEX], max_color[STAT_DEX], get_curr_stat(ch,STAT_DEX),
               IS_NPC(ch) ? 0 : ch->pcdata->questpoints);

    buf_printf(output,
               "     {G| {R: {x$FL12{%s} {C|  {RCon:  {x{%c%2d{z ({%c%2d{z) {C| {R   : {x%5d     {G|{x\n",
               IS_GOOD(ch) ? "$gn{}" :
               IS_EVIL(ch) ? "$gn{}" :
               "$gn{}",
               cur_color[STAT_CON],
               ch->perm_stat[STAT_CON], max_color[STAT_CON], get_curr_stat(ch,STAT_CON),
               IS_NPC(ch) ? 0 : ch->pcdata->bonuspoints);

    buf_printf(output,
               "     {G| {REthos   : {x$FL12{%s} {C|  {RCha:  {x{%c%2d{z ({%c%2d{z) {C| {R%-10.10s:  {x%4d     {G|{x\n",
               IS_NPC(ch) ? "" :
               ch->ethos == ETHOS_LAWFUL ? "$gn{}" :
               ch->ethos == ETHOS_NEUTRAL ? "$gn{}" :
               ch->ethos == ETHOS_CHAOTIC ? "$gn{}" :
               "",
               cur_color[STAT_CHA],
               ch->perm_stat[STAT_CHA], max_color[STAT_CHA], get_curr_stat(ch,STAT_CHA),
               IS_SAMURAI(ch) ? "" : "Wimpy" ,
               IS_SAMURAI(ch) ? ch->pcdata->death : ch->wimpy);

    snprintf(buf2, sizeof(buf2), " %s %s.",
             GETMSG("", ch->lang),
             GETMSG(flag_string(position_names, ch->position), ch->lang));
    buf_printf(output, "     {G| {R     : {x%-16.16s{RLck:  {x{%c%2d{z ({%c%2d{z) {C|{x%-23.23s{G|{x\n",
               IS_NPC(ch) ? "Midgaard" : hometown_name(ch->hometown),
               cur_color[STAT_LCK],
               ch->perm_stat[STAT_LCK], max_color[STAT_LCK], get_curr_stat(ch,STAT_LCK),
               buf2);
    if (!IS_NPC(ch))
    {
        buf_add(output, "     {G|{C+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+{G|{x\n");
        buf_printf (output, "     {G| {Y $gn{}  {W%3d%%{z,    {W%6d%%{z                  {G|{x\n",
                    count_skill_percent(ch), count_all_skill_percent(ch));
    }
    buf_add(output, "     {G|{C+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+{G|{x{x\n");

    if (ch->guarding != NULL)
    {
        ekle = 1;
        buf_printf(output,
                   "     {G| {G : {x%-12.12s                                  {G|{x\n",
                   ch->guarding->name);
    }

    if (ch->guarded_by != NULL)
    {
        ekle = 1;
        buf_printf(output,
                   "     {G| {G : {x%-12.12s                                {G|{x\n",
                   ch->guarded_by->name);
    }

    if (!IS_NPC(ch))
    {
        if (ch->pcdata->condition[COND_DRUNK] > 10)
        {
            ekle = 1;
            buf_printf(output,
                       "     {G| {G $gn{}.                                                      {G|{x\n");
        }

        if (ch->pcdata->condition[COND_THIRST] <= 0)
        {
            ekle = 1;
            buf_printf(output,
                       "     {G| {Y  .                                                 {G|{x\n");
        }
/*              if (ch->pcdata->condition[COND_FULL]   ==       0) */
        if (ch->pcdata->condition[COND_HUNGER] <= 0)
        {
            ekle = 1;
            buf_printf(output,
                       "     {G| {Y $gn{}.                                                     {G|{x\n");
        }

        if (IS_SET(ch->plr_flags, PLR_GHOST))
        {
            ekle = 1;
            buf_add(output,
                    "     {G| {c .                                                     {G|{x\n");
        }

        if (ch->pcdata->condition[COND_BLOODLUST] <= 0)
        {
            ekle = 1;
            buf_printf(output,
                       "     {G| {R  .{x                                             {G|{x\n");
        }

        if (ch->pcdata->condition[COND_DESIRE] <=  0)
        {
            ekle = 1;
            buf_printf(output,
                       "     {G| {Y  .{x                                              {G|{x\n");
        }
    }

    if (!IS_IMMORTAL(ch) && IS_PUMPED(ch))
    {
        ekle = 1;
        buf_printf(output,
                   "     {G| {R    !                                 {G|{x\n");
    }

    if (ekle)
        buf_add(output,
                "     {G|{C+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+{G|{x\n");

    buf_printf(output,
               "     {G| {R      {C:{z   {x%3d/%-4d          {R  : {x%5d   {G|{x\n",
               ch->carry_number, can_carry_n(ch),
               GET_AC(ch,AC_EXOTIC));

    buf_printf(output, "     {G| {R    {C:{z {x");
    if (get_carry_weight(ch) < 100000)
        buf_printf(output, "%5d/%-9d    ", get_carry_weight(ch), can_carry_w(ch));
    else
        buf_printf(output, "%9d/%-9d", get_carry_weight(ch), can_carry_w(ch));
    buf_printf(output, " {R     : {x%5d   {G|{x\n", GET_AC(ch,AC_BASH));

    buf_printf(output,
               "     {G| {R  {C:{z   {Y%-10d        {R     : {x%5d   {G|{x\n",
               ch->gold,GET_AC(ch,AC_PIERCE));

    buf_printf(output,
               "     {G| {R    {C:{z   {W%-10d        {R   : {x%5d   {G|{x\n",
               ch->silver,GET_AC(ch,AC_SLASH));

    if (HAS_SKILL(ch, gsn_spellbane))
        svs = -1*get_skill(ch, gsn_spellbane);
    else
        svs = ch->saving_throw;

    if (IS_AFFECTED(ch, AFF_BERSERK))
        svs -= 10;

    if (HAS_SKILL(ch, gsn_adv_magic_evasion))
        svs -= (get_skill(ch, gsn_adv_magic_evasion) / 3);
    else
        svs -= (get_skill(ch, gsn_magic_evasion) / 8);

    if (HAS_SKILL(ch, gsn_spellbane))
        svs = UMAX(svs, -80);

    buf_printf(output,
               "     {G| {R    {C:{z   {x%-6d            {RSaves vs Spell    : {x%5d   {G|{x\n",
               ch->exp, svs);

    buf_printf(output,
               "     {G| {R . {C:{z   {x%-6d            {RHitP: {x%5d/%-5d           {G|{x\n",
               IS_NPC(ch) ? 0 : exp_to_level(ch), ch->hit, ch->max_hit);

    buf_printf(output,
               "     {G| {RHitroll       {C:{z   {x%-3d               {RMana: {x%5d/%-5d           {G|{x\n",
               GET_HITROLL(ch),ch->mana, ch->max_mana);
    buf_printf(output,
               "     {G| {RDamroll       {C:{z   {x%-3d               {RMove: {x%5d/%-5d           {G|{x\n",
               GET_DAMROLL(ch), ch->move, ch->max_move);
    buf_add(output, "  {G/~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~/   |{x\n");
    buf_add(output, "  {G\\________________________________________________________________\\__/{x\n");

    if (IS_SET(ch->comm, COMM_SHOWAFF))
        show_affects(ch, output);
    char_act(buf_string(output), ch);
    buf_free(output);
}

DO_FUN(do_oscore)
{
    class_t *cl;
    religion_t *religion;
    char buf2[MAX_STRING_LENGTH];
    int i;
    BUFFER *output;

    if ((cl = class_lookup(ch->class)) == NULL)
        return;

    output = buf_new(ch->lang);

    buf_printf(output, "%s %s%s\n{x",
               GETMSG("", ch->lang),
               IS_NPC(ch) ? capitalize(mlstr_val(ch->short_descr, ch->lang)) :
               ch->name,
               IS_NPC(ch) ? " The Believer of Chronos." : ch->pcdata->title);

    buf_printf(output, " {c%d{x, {c%d{x  (%d ).\n",
               ch->level, get_age(ch),
               (ch->played + (int) (current_time - ch->logon)) / 3600);
    if (ch->pcdata != NULL)
        buf_printf(output, "  %d ()  $gn{} %d%%  .\n",
                   DAYS_TO_PLAY, 100*ch->pcdata->limit_timer/(TPD*DAYS_TO_PLAY));

    buf_printf(output,
               ": {c%s{x  : {c%s{x  : {c%s{x  "
               ": {c%s{x\n",
               race_name(ch->race),
               GETMSG(flag_string(sex_table, ch->sex), ch->lang),
               IS_NPC(ch) ? "mobile" : cl->name,
               IS_NPC(ch) ? "Midgaard" : hometown_name(ch->hometown));

    buf_printf(output,
               "  {c%d{x/{c%d{x , {c%d{x/{c%d{x , "
               "{c%d{x/{c%d{x .\n",
               ch->hit, ch->max_hit, ch->mana, ch->max_mana,
               ch->move, ch->max_move);

    buf_printf(output,
               "  {c%d{x   "
               "{c%d{x .\n",
               ch->practice, ch->train);

    buf_printf(output, "  {c%d{x/{c%d{x  "
               "  {c%ld{x/{c%d{x .\n",
               ch->carry_number, can_carry_n(ch),
               get_carry_weight(ch), can_carry_w(ch));

    if (ch->level > 20 || IS_NPC(ch))
        buf_printf(output,
                   "Str: {c%d{x({c%d{x)  Int: {c%d{x({c%d{x)  "
                   "Wis: {c%d{x({c%d{x)  Dex: {c%d{x({c%d{x)  "
                   "Con: {c%d{x({c%d{x)  Cha: {c%d{x({c%d{x)  "
                   "Lck: {c%d{x({c%d{x)\n",
                   ch->perm_stat[STAT_STR], get_curr_stat(ch, STAT_STR),
                   ch->perm_stat[STAT_INT], get_curr_stat(ch, STAT_INT),
                   ch->perm_stat[STAT_WIS], get_curr_stat(ch, STAT_WIS),
                   ch->perm_stat[STAT_DEX], get_curr_stat(ch, STAT_DEX),
                   ch->perm_stat[STAT_CON], get_curr_stat(ch, STAT_CON),
                   ch->perm_stat[STAT_CHA], get_curr_stat(ch, STAT_CHA),
                   ch->perm_stat[STAT_LCK], get_curr_stat(ch, STAT_LCK));
    else
        buf_printf(output,
                   "Str: {c%-9s{x Wis: {c%-9s{x Con: {c%-9s{x\n"
                   "Int: {c%-9s{x Dex: {c%-9s{x Cha: {c%-11s{x\n",
                   get_stat_alias(ch, STAT_STR),
                   get_stat_alias(ch, STAT_WIS),
                   get_stat_alias(ch, STAT_CON),
                   get_stat_alias(ch, STAT_INT),
                   get_stat_alias(ch, STAT_DEX),
                   get_stat_alias(ch, STAT_CHA));

    snprintf(buf2, sizeof(buf2),
             "  {c%d{x    %s%s%s.\n",
             ch->exp,
             ch->gold + ch->silver == 0 ? " " :
             ch->gold ? "%ld {Y{x " : str_empty,
             ch->silver ? " %ld {W{x " : str_empty,
             ch->gold + ch->silver ? ch->gold + ch->silver == 1 ?
             "" : "" : str_empty);
    if (ch->gold)
        buf_printf(output, buf2, ch->gold, ch->silver);
    else
        buf_printf(output, buf2, ch->silver);

    /* KIO shows exp to level */
    if (!IS_NPC(ch) && ch->level < LEVEL_HERO)
        buf_printf(output, "    {c%d{x    .\n",
                   exp_to_level(ch));

    if (!IS_NPC(ch))
        buf_printf(output,
                   " : {c%d{x.  "
                   "%s: {c%d{x.\n",
                   ch->pcdata->questpoints,
                   IS_NPC(ch) ? "Quest?" : (IS_ON_QUEST(ch) ?
                                            "Quest Time" : "Next Quest"),
                   IS_NPC(ch) ? 0 : abs(ch->pcdata->questtime));

    if (IS_SAMURAI(ch))
        buf_printf(output, " {c%d{x .",
                   ch->pcdata->death);
    else
        buf_printf(output, "   {c%d{x .", ch->wimpy);

    if (ch->guarding != NULL)
        buf_printf(output, "   : {W%s{x", ch->guarding->name);

    if (ch->guarded_by != NULL)
        buf_printf(output, "   : {W%s{x",
                   ch->guarded_by->name);
    buf_add(output, "\n");

    if (!IS_NPC(ch))
    {
        if (ch->pcdata->condition[COND_DRUNK] > 10)
            buf_add(output, " {c$gn{}{x.\n");

        if (ch->pcdata->condition[COND_THIRST] <= 0)
            buf_add(output, "  {r{x.\n");

/*              if (ch->pcdata->condition[COND_FULL] == 0) */
        if (ch->pcdata->condition[COND_HUNGER] <= 0)
            buf_add(output, "  {r{x.\n");
        if (ch->pcdata->condition[COND_BLOODLUST] <= 0)
            buf_add(output, "  {r{x.\n");
        if (ch->pcdata->condition[COND_DESIRE] <= 0)
            buf_add(output, " {g {x.\n");
        if (IS_SET(ch->plr_flags, PLR_GHOST))
            buf_add(output, " {D{x.\n");
    }

    buf_printf(output, " %s.\n",
               GETMSG(flag_string(position_names, ch->position), ch->lang));

    if ((ch->position == POS_SLEEPING || ch->position == POS_RESTING ||
         ch->position == POS_FIGHTING || ch->position == POS_STANDING)
        && !IS_IMMORTAL(ch) && IS_PUMPED(ch))
        buf_add(output, "  {r{x  {R{x!\n");

    /* print AC values */
    if (ch->level >= 25)
    {
        buf_printf(output,
                   ":  : {c%d{x   : {c%d{x  "
                   " : {c%d{x   : {c%d{x\n",
                   GET_AC(ch, AC_PIERCE), GET_AC(ch, AC_BASH),
                   GET_AC(ch, AC_SLASH), GET_AC(ch, AC_EXOTIC));

        buf_printf(output,
                   "Saves vs. spell: {c%d{x\n",
                   ch->saving_throw);
    } else
    {
        for (i = 0; i < 4; i++)
        {
            static char* ac_name[4] = {
                "{c{x",
                "{c{x",
                "{c{x",
                "{c{x"
            };

            buf_add(output, " ");
            if (GET_AC(ch,i) >= 101)
                buf_printf(output,
                           "{c  $gn{}{x  %s.\n",
                           ac_name[i]);
            else if (GET_AC(ch,i) >= 80)
                buf_printf(output,
                           "{c  $gn{}{x  %s.\n",
                           ac_name[i]);
            else if (GET_AC(ch,i) >= 60)
                buf_printf(output, "{c $gn{}{x  %s.\n",
                           ac_name[i]);
            else if (GET_AC(ch,i) >= 40)
                buf_printf(output, "{c $gn{}{x  %s.\n",
                           ac_name[i]);
            else if (GET_AC(ch,i) >= 20)
                buf_printf(output, "{c $gn{}{x  %s.\n",
                           ac_name[i]);
            else if (GET_AC(ch,i) >= 0)
                buf_printf(output, "{c{x  %s.\n",
                           ac_name[i]);
            else if (GET_AC(ch,i) >= -20)
                buf_printf(output, "{c {x  %s.\n",
                           ac_name[i]);
            else if (GET_AC(ch,i) >= -40)
                buf_printf(output, "{c  {x  %s.\n",
                           ac_name[i]);
            else if (GET_AC(ch,i) >= -60)
                buf_printf(output, "{c {x  %s.\n",
                           ac_name[i]);
            else if (GET_AC(ch,i) >= -80)
                buf_printf(output, "{c {x  %s.\n",
                           ac_name[i]);
            else if (GET_AC(ch,i) >= -100)
                buf_printf(output, "{c {x  %s.\n",
                           ac_name[i]);
            else
                buf_printf(output, "{c {x  %s.\n",
                           ac_name[i]);
        }
    }

    /* RT wizinvis and holy light */
    if (IS_IMMORTAL(ch))
    {
        buf_printf(output, "Holy Light: {c%s{x",
                   IS_SET(ch->plr_flags, PLR_HOLYLIGHT) ?
                   "" : "");

        if (ch->invis_level)
            buf_printf(output, "  : {c %d{x",
                       ch->invis_level);

        if (ch->incog_level)
            buf_printf(output, "  : {c %d{x",
                       ch->incog_level);
        buf_add(output, "\n");
    }

    if (ch->level >= 20)
        buf_printf(output, "Hitroll: {c%d{x  Damroll: {c%d{x.\n",
                   GET_HITROLL(ch), GET_DAMROLL(ch));

    buf_add(output, "  ");
    if (IS_GOOD(ch))
        buf_add(output, " .");
    else if (IS_EVIL(ch))
        buf_add(output, " .");
    else
        buf_add(output, " .");

    switch (ch->ethos)
    {
        case ETHOS_LAWFUL:
            buf_add(output, "  You have a lawful ethos.\n");
            break;
        case ETHOS_NEUTRAL:
            buf_add(output, "  You have a neutral ethos.\n");
            break;
        case ETHOS_CHAOTIC:
            buf_add(output, "  You have a chaotic ethos.\n");
            break;
        default:
            buf_add(output, "  You have no ethos");
            if (!IS_NPC(ch))
                buf_add(output, ",    !\n");
            else
                buf_add(output, ".\n");
    }

    religion = religion_lookup(ch->religion);

    if (ch->religion && religion)
        buf_printf(output,"   %s.\n",
                   religion->name);
    else
        buf_add(output, "      .\n");
    if (IS_SET(ch->comm, COMM_SHOWAFF))
        show_affects(ch, output);
    char_act(buf_string(output), ch);
    buf_free(output);
}

DO_FUN(do_affects)
{
    BUFFER *output;

    output = buf_new(ch->lang);
    show_affects(ch, output);
    page_to_char(buf_string(output), ch);
    buf_free(output);
}

DO_FUN(do_saffects)
{
    race_t *r;
    class_t *cl;
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    AFFECT_DATA *paf;
    BUFFER *output;
    int i, max_hp, max_mana, max_move;

    argument = one_argument(argument, arg, sizeof(arg));
    output = buf_new(-1);

    if (IS_NPC(ch))
    {
        act(" NPC   ...", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (ch->level < 10)
    {
        act("      !", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!IS_SET(ch->pcdata->wishes, WISH_SAFFECTS) & !IS_IMMORTAL(ch))
    {
        act("Now you must buy this command for QP. (HELP WISH)", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((cl = class_lookup(ch->class)) == NULL)
        return;

    r = RACE(ORG_RACE(ch));

    buf_printf(output, "Name: %s (%s) Race: %s (%s)  Sex: %s\n",
               ch->name, ch->pcdata->title,
               race_name(ch->race), race_name(ORG_RACE(ch)),
               flag_string(sex_table, ch->sex));

    snprintf(buf, sizeof(buf), "%s-%s",
             flag_string(ethos_table, ch->ethos),
             IS_GOOD(ch)    ? "good" :
             IS_NEUTRAL(ch) ? "neutral" :
             IS_EVIL(ch)    ? "evil" :
             "unknown");

    buf_printf(output,
               "Lv: %d+(%d) Class: %s  Align: %s\n",
               ch->level,
               ch->aff_level,
               class_name(ch),buf);

    buf_printf(output, "Str: %d(%d) Int: %d(%d) Wis: %d(%d) Dex: %d(%d) Con: %d(%d) Cha: %d(%d) Lck: %d(%d)\n",
               ch->perm_stat[STAT_STR],
               get_curr_stat(ch,STAT_STR),
               ch->perm_stat[STAT_INT],
               get_curr_stat(ch,STAT_INT),
               ch->perm_stat[STAT_WIS],
               get_curr_stat(ch,STAT_WIS),
               ch->perm_stat[STAT_DEX],
               get_curr_stat(ch,STAT_DEX),
               ch->perm_stat[STAT_CON],
               get_curr_stat(ch,STAT_CON),
               ch->perm_stat[STAT_CHA],
               get_curr_stat(ch,STAT_CHA),
               ch->perm_stat[STAT_LCK],
               get_curr_stat(ch,STAT_LCK));

    max_hp = (ch->perm_stat[STAT_CON] + r->pcdata->hp_bonus + cl->hp_rate) * ch->level -
        ch->pcdata->perm_hit + ch->pcdata->quest_hp_gained;

    max_mana = (ch->perm_stat[STAT_INT] + ch->perm_stat[STAT_WIS] +
        r->pcdata->mana_bonus + cl->mana_rate) * ch->level -
        ch->pcdata->perm_mana + ch->pcdata->quest_mana_gained;

    max_move = ((ch->perm_stat[STAT_CON] + ch->perm_stat[STAT_DEX]) / 4) * ch->level -
        ch->pcdata->perm_move;

    buf_printf(output, "Hp: %d/%d+%d  Mana: %d/%d+%d  Move: %d/%d+%d\n",
               ch->hit,         ch->max_hit,    max_hp,
               ch->mana,        ch->max_mana,   max_mana,
               ch->move,        ch->max_move,   max_move);

    buf_printf(output,"You belive the religion of %s.\n",
               religion_name(ch->religion));

    buf_printf(output,"Armor: pierce: %d  bash: %d  slash: %d  exotic: %d\n",
               GET_AC(ch,AC_PIERCE), GET_AC(ch,AC_BASH),
               GET_AC(ch,AC_SLASH),  GET_AC(ch,AC_EXOTIC));

    buf_printf(output,
               "Hit: %d  Dam: %d  Saves: %d  Size: %d'  Position: %s  Wimpy: %d\n",
               GET_HITROLL(ch), GET_DAMROLL(ch), ch->saving_throw,
               ch->size, flag_string(position_table, ch->position),
               ch->wimpy);

    buf_printf(output,
               "Thirst: %d  Hunger: %d  Full: %d  "
               "Drunk: %d Bloodlust: %d Desire: %d\n",
               ch->pcdata->condition[COND_THIRST],
               ch->pcdata->condition[COND_HUNGER],
               ch->pcdata->condition[COND_FULL],
               ch->pcdata->condition[COND_DRUNK],
               ch->pcdata->condition[COND_BLOODLUST],
               ch->pcdata->condition[COND_DESIRE]);

    if (ch->immunes)
        buf_printf(output, "Immune to: %s\n",
                   flag_string(imm_flags, ch->immunes));

    for (i = 0; i < MAX_DAM; i++)
    {
        if (ch->resists[i] != 0)
            buf_printf(output, "Resist to %s: %d%%\n",
                       flag_string(dam_flags, i), ch->resists[i]);
    }


    if (ch->affected_by)
        buf_printf(output, "Affected by %s\n",
                   flag_string(affect_flags, ch->affected_by));

    for (paf = ch->affected; paf != NULL; paf = paf->next)
    {
        if (paf->where == TO_RESIST)
        {
            buf_printf(output,
                       "Spell: '{c%s{x' modifies resistance to %s by {c%d%%{x for {c%d{x hours, level {c%d{x.\n",
                       skill_name(paf->type),
                       flag_string(dam_flags, paf->bitvector),
                       paf->modifier,
                       paf->duration,
                       paf->level
                      );
            continue;
        }
        buf_printf(output,
                   "Spell: '{c%s{x' modifies {c%s{x by {c%d{x for {c%d{x hours with bits {c%s{x, level {c%d{x.\n",
                   skill_name(paf->type),
                   flag_string(apply_flags, paf->location),
                   paf->modifier,
                   paf->duration,
                   flag_string(affect_flags, paf->bitvector),
                   paf->level
                  );
    }

    if (ch->clan)
    {
        buf_printf(output,
                   "Last fought: [%s]\n",
                   ch->last_fought ? ch->last_fought->name : "none",
                   strtime(ch->last_fight_time));
    }

    page_to_char(buf_string(output), ch);
    buf_free(output);
}

DO_FUN(do_gaffects)
{
    CHAR_DATA *gch;
    int i;
    int flags;
    BUFFER *output;

    if (IS_SET(ch->comm, COMM_NOTELL))
    {
        act("    !", ch, NULL, NULL, TO_CHAR);
        return;
    }

    flags = TO_VICT | ACT_TOBUF | ACT_STRANS |
            (IS_NPC(ch) && !IS_AFFECTED(ch, AFF_CHARM) ? ACT_TRANS : 0);

    for (i = 0, gch = char_list; gch; gch = gch->next)
    {
        if (is_same_group(gch, ch)
            && !is_affected(gch, gsn_deafen)
            && gch != ch)
        {

            act_puts("$n says to group:\n", ch, NULL, gch, flags, POS_DEAD);
            output = buf_new(gch->lang);
            show_affects(ch, output);
            page_to_char(buf_string(output), gch);
            buf_free(output);

            i++;
        }
    }

    if (i > 0 && !is_affected(ch, gsn_deafen))
        act_puts("You says to group your affect's.{x'", ch, argument, NULL, TO_CHAR, POS_DEAD);
    else
        act("Yor don't have any group.", ch, NULL, NULL, TO_CHAR);
}

/* object condition aliases */
char *get_cond_alias(OBJ_DATA *obj)
{
    char *stat;
    int istat = obj->condition;

    if (istat >= COND_EXCELLENT)       stat = "{g{x";
    else if (istat >= COND_FINE)            stat = "{g{x";
    else if (istat >= COND_GOOD)            stat = "{y{x";
    else if (istat >= COND_AVERAGE)         stat = "{m{x";
    else if (istat >= COND_POOR)            stat = "{r{x";
    else                                    stat = "{R{x";

    return stat;
}

const char get_color(int pract)
{
    if (pract == 1)
        return 'r';
    else if (pract > 1 && pract <= 50)
        return 'R';
    else if (pract > 50 && pract < 100)
        return 'Y';
    else return 'G';
}

int sort_function(const void *a, const void *b)
{
    return( str_cmp((char *)a,(char *)b) );
}

/* new practice */
DO_FUN(do_practice)
{
    CHAR_DATA   *mob;
    int         sn;
    skill_t  *sk;
    pcskill_t    *ps;
    class_t  *cl;
    class_skill_t *cs;
    int         adept;
    bool        found;
    int         rating;
    char        arg[MAX_STRING_LENGTH];
    char        arg1[MAX_STRING_LENGTH];
    pskill      tab[MAX_SKILL];

    if (IS_NPC(ch))
        return;

    if (argument[0] == '\0')
    {
        BUFFER *output;
        int nskill = 0;
        int col = 0;
        int i;

        for (i = 0; i < ch->pcdata->learned.nused; i++)
        {
            ps = VARR_GET(&ch->pcdata->learned, i);

            if (ps->percent == 0
                ||  (sk = skill_lookup(ps->sn)) == NULL
                ||  skill_level(ch, ps->sn) > ch->level)
                continue;

            if (IS_SET(ch->comm2, COMM2_RUSSKILLS))
                antisubstitute_skill_alias(sk->name, tab[nskill].name, 22);
            else
                strnzcpy(tab[nskill].name, 22, sk->name);
            
            tab[nskill++].prac = ps->percent;
        }

        qsort((void *)tab, nskill, sizeof(pskill), sort_function);

        output = buf_new(ch->lang);

        for (i=0; i < nskill; i++)
        {
            buf_printf(output, "%-22s {%c%3d%%{z  ", tab[i].name,
                       get_color(tab[i].prac), tab[i].prac);
            if (++col % 3 == 0)
                buf_add(output, "\n");
        }
        buf_printf(output, "\nYou have {W%d{z practice sessions left.\n",
                   ch->practice);

        page_to_char(buf_string(output), ch);
        buf_free(output);

        return;
    }

    if ((cl = CLASS(ch->class)) == NULL)
    {
        log_printf("do_practice: %s: class %d: unknown", ch->name, ch->class);
        return;
    }

    if (ch->practice <= 0)
    {
        act("You have no practice sessions left.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    one_argument(argument, arg1, sizeof(arg));
    substitute_skill_alias(arg1, arg, sizeof(arg));

    if ((ps = skill_vlookup(&ch->pcdata->learned, arg)) == NULL
        ||  ps->percent == 0
        ||  skill_level(ch, sn = ps->sn) > ch->level)
    {
        act("You can't practice that.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (sn == gsn_vampire)
    {
        act("You can't practice that, only available at questor.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    found = FALSE;
    sk = SKILL(sn);
    for (mob = ch->in_room->people; mob != NULL; mob = mob->next_in_room)
    {
        if (!IS_NPC(mob)
            || !IS_SET(mob->pIndexData->act, ACT_PRACTICE))
            continue;

        found = TRUE;

        if (IS_SET(sk->flags, SKILL_CLAN))
        {
            if (ch->clan == mob->clan)
                break;
            continue;
        }

        if ((mob->pIndexData->practicer == 0
             && (sk->group == GROUP_NONE
                 || IS_SET(sk->group,  GROUP_SUMMONING | GROUP_HARMFUL | GROUP_PROTECTIVE
                           | GROUP_DETECTION | GROUP_WEATHER | GROUP_COVERT | GROUP_CRAFT
                           | GROUP_NATURAL )))
            ||  IS_SET(mob->pIndexData->practicer, sk->group))
            break;
    }

    if (mob == NULL)
    {
        if (found)
            char_act("You can't do that here. Use 'slook skill', 'help practice' for more info.", ch);
        else
            char_act("You couldn't find anyone who can teach you.", ch);
        return;
    }

    adept = cl->skill_adept;
    if (IS_SET(ch->pcdata->wishes, WISH_LEARNUP2))
        adept += 10;
    if (ps->percent >= adept)
    {
        char_printf(ch, "You are already learned at {W%s{z.\n", sk->name);
        return;
    }

    ch->practice--;

    cs = class_skill_lookup(cl, sn);
    rating = cs ? UMAX(cs->rating, 1) : 1;
    ps->percent += int_app[get_curr_stat(ch,STAT_INT)].learn / rating;

    if (ps->percent < adept)
    {
        act("You practice {W$T{z.", ch, NULL, sk->name, TO_CHAR);
        act("$n practices {W$T{z.", ch, NULL, sk->name, TO_ROOM);
    } else
    {
        ps->percent = adept;
        act("You are now learned at {W$T{z.", ch, NULL, sk->name, TO_CHAR);
        act("$n is now learned at {W$T{z.", ch, NULL, sk->name, TO_ROOM);
    }
}

DO_FUN(do_qppractice)
{
    CHAR_DATA   *mob;
    skill_t  *sk;
    pcskill_t    *ps;
    class_t  *cl;
    bool        found;
    char        arg[MAX_STRING_LENGTH];
    int         sn;
    int         adept;

    if (IS_NPC(ch))
        return;

    if (argument[0] == '\0')
    {
        act("On what skill you wants to spend quest points?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((cl = CLASS(ch->class)) == NULL)
    {
        log_printf("do_practice: %s: class %d: unknown", ch->name, ch->class);
        return;
    }

    one_argument(argument, arg, sizeof(arg));

    if ((ps = skill_vlookup(&ch->pcdata->learned, arg)) == NULL
        ||  ps->percent == 0
        ||  skill_level(ch, sn = ps->sn) > ch->level)
    {
        act("You can't practice that.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    adept = cl->skill_adept;
    if (ps->percent < adept)
    {
        char_act("You must have this skill at adept level.", ch);
        return;
    }

    sk = SKILL(sn);
    if (ps->percent >= 70)
    {
        char_printf (ch, "You are already learned at {W%s{z on {W%d%%{z.\n", sk->name, ps->percent);
//        char_printf(ch, "You are already learned at {W%s{z.\n", sk->name);
        return;
    }

    if (ch->pcdata->questpoints < 200)
    {
        act("  200  .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    found = FALSE;
    for (mob = ch->in_room->people; mob != NULL; mob = mob->next_in_room)
    {
        if (!IS_NPC(mob)
            || !IS_SET(mob->pIndexData->act, ACT_PRACTICE))
            continue;

        found = TRUE;

        if (IS_SET(sk->flags, SKILL_CLAN))
        {
            if (ch->clan == mob->clan)
                break;
            continue;
        }

        if ((mob->pIndexData->practicer == 0
             && (sk->group == GROUP_NONE
                 || IS_SET(sk->group,  GROUP_SUMMONING | GROUP_HARMFUL | GROUP_PROTECTIVE
                           | GROUP_DETECTION | GROUP_WEATHER | GROUP_COVERT | GROUP_CRAFT
                           | GROUP_NATURAL )))
            ||  IS_SET(mob->pIndexData->practicer, sk->group))
            break;
    }

    if (mob == NULL)
    {
        if (found)
            char_act("You can't do that here. Use 'slook skill', 'help practice' for more info.", ch);
        else
            char_act("You couldn't find anyone who can teach you.", ch);
        return;
    }

    ch->pcdata->questpoints -= 200;
    if (ps->percent < 60)
        ps->percent = 60;
    else
        ps->percent = 70;

    char_printf (ch, "   {W%s{z  {W%d%%{z.\n", sk->name, ps->percent);
//    act("You are now learned at {W$T{z.", ch, NULL, sk->name, TO_CHAR);
    act("$n is now learned at {W$T{z.", ch, NULL, sk->name, TO_ROOM);
}

DO_FUN(do_bppractice)
{
    CHAR_DATA   *mob;
    skill_t  *sk;
    pcskill_t    *ps;
    class_t  *cl;
    bool        found;
    char        arg[MAX_STRING_LENGTH];
    int         sn;
    int         adept;

    if (IS_NPC(ch))
        return;

    if (argument[0] == '\0')
    {
        act("On what skill you wants to spend bonus points?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((cl = CLASS(ch->class)) == NULL)
    {
        log_printf("do_practice: %s: class %d: unknown", ch->name, ch->class);
        return;
    }

    one_argument(argument, arg, sizeof(arg));

    if ((ps = skill_vlookup(&ch->pcdata->learned, arg)) == NULL
        ||  ps->percent == 0
        ||  skill_level(ch, sn = ps->sn) > ch->level)
    {
        act("You can't practice that.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    adept = cl->skill_adept;
    if (ps->percent < adept)
    {
        char_act("You must have this skill at adept level.", ch);
        return;
    }

    sk = SKILL(sn);
    if (ps->percent >= 100)
    {
        char_printf(ch, "You are already master at {W%s{z.\n", sk->name);
        return;
    }

    if (ch->pcdata->bonuspoints < 1)
    {
        act("  1  .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    found = FALSE;
    for (mob = ch->in_room->people; mob != NULL; mob = mob->next_in_room)
    {
        if (!IS_NPC(mob)
            || !IS_SET(mob->pIndexData->act, ACT_PRACTICE))
            continue;

        found = TRUE;

        if (IS_SET(sk->flags, SKILL_CLAN))
        {
            if (ch->clan == mob->clan)
                break;
            continue;
        }

        if ((mob->pIndexData->practicer == 0
             && (sk->group == GROUP_NONE
                 || IS_SET(sk->group,  GROUP_SUMMONING | GROUP_HARMFUL | GROUP_PROTECTIVE
                           | GROUP_DETECTION | GROUP_WEATHER | GROUP_COVERT | GROUP_CRAFT
                           | GROUP_NATURAL )))
            ||  IS_SET(mob->pIndexData->practicer, sk->group))
            break;
    }

    if (mob == NULL)
    {
        if (found)
            char_act("You can't do that here. Use 'slook skill', 'help practice' for more info.", ch);
        else
            char_act("You couldn't find anyone who can teach you.", ch);
        return;
    }

    ch->pcdata->bonuspoints -= 1;
    ps->percent++;
    char_printf (ch, "   {W%s{z  {W%d%%{z.\n", sk->name, ps->percent);
//    act("You are now learned at {W$T{z.", ch, NULL, sk->name, TO_CHAR);
    act("$n  {W$T{z   .", ch, NULL, sk->name, TO_ROOM);
}

DO_FUN(do_camp)
{
    AFFECT_DATA af;
    int sn;
    int chance;
    int mana;

    if ((sn = sn_lookup("camp")) < 0
    || (chance = get_skill(ch, sn)) == 0)
    {
        act("Huh?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (is_affected(ch, sn))
    {
        char_act("You don't have enough power to handle more camp areas.", ch);
        return;
    }

    if (IS_SET(ch->in_room->room_flags, ROOM_SAFE | ROOM_PEACE | ROOM_PRIVATE)
    || (ch->in_room->sector_type != SECT_FIELD
    && ch->in_room->sector_type != SECT_FOREST
    && ch->in_room->sector_type != SECT_MOUNTAIN
    && ch->in_room->sector_type != SECT_HILLS))
    {
        char_act("There are not enough leaves to camp here.", ch);
        return;
    }

    mana = SKILL(sn)->min_mana;
    if (ch->mana < mana)
    {
        char_act("You don't have enough mana to make a camp.", ch);
        return;
    }
    ch->mana -= mana;

    if (number_percent() > chance)
    {
        act("You failed to make your camp.", ch, NULL, NULL, TO_CHAR);
        check_improve(ch, sn, FALSE, 4);
        return;
    }

    check_improve(ch, sn, TRUE, 4);
    WAIT_STATE(ch, SKILL(sn)->beats);

    act("You succeeded to make your camp.", ch, NULL, NULL, TO_CHAR);
    act("$n succeeded to make camp.", ch, NULL, NULL, TO_ROOM);

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = LVL(ch);
    af.duration     = 12;
    af.bitvector    = 0;
    af.modifier     = 0;
    af.location     = APPLY_NONE;
    affect_to_char(ch, &af);

    af.where        = TO_ROOM_CONST;
    af.type         = sn;
    af.level        = LVL(ch);
    af.duration     = LVL(ch) / 20;
    af.bitvector    = 0;
    af.modifier     = 2 * LVL(ch);
    af.location     = APPLY_ROOM_HEAL;
    affect_to_room(ch->in_room, &af);

    af.modifier     = LVL(ch);
    af.location     = APPLY_ROOM_MANA;
    affect_to_room(ch->in_room, &af);
}

DO_FUN(do_demand)
{
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA  *obj;
    int chance;

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));

    if (IS_NPC(ch))
        return;

    if (ch->class != CLASS_ANTI_PALADIN)
    {
        act("    .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (arg1[0] == '\0' || arg2[0] == '\0')
    {
        act("    ?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((victim = get_char_room(ch, arg2)) == NULL)
    {
        act("  .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!IS_NPC(victim))
    {
        char_act("        ?", ch);
        return;
    }

    if (IS_CLAN_GUARD(victim))
    {
        act("    .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    WAIT_STATE(ch, PULSE_VIOLENCE);

    chance = IS_EVIL(victim) ? 10 : IS_GOOD(victim) ? -5 : 0;
    chance += (get_curr_stat(ch,STAT_CHA) - 15) * 10;
    chance += LVL(ch) - LVL(victim);

    if (victim->level >= ch->level + 10 || victim->level >= ch->level * 2)
        chance = 0;

    if (number_percent() > chance)
    {
        do_say(victim, "    !");
        do_murder(victim, ch->name);
        return;
    }

    if (((obj = get_obj_carry(victim , arg1)) == NULL
         &&   (obj = get_obj_wear(victim, arg1)) == NULL)
        ||  IS_SET(obj->extra_flags, ITEM_INVENTORY))
    {
        do_say(victim, ",    .");
        return;
    }


    if (obj->wear_loc != WEAR_NONE)
        unequip_char(victim, obj);

    if (!can_drop_obj(ch, obj))
    {
        do_say(victim, " ,      . "
               " ,  ");
        return;
    }

    if (ch->carry_number + get_obj_number(obj) > can_carry_n(ch))
    {
        act("  .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (ch->carry_weight + get_obj_weight(obj) > can_carry_w(ch))
    {
        act("     .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!can_see_obj(ch, obj))
    {
        act("   .", ch, NULL, victim, TO_CHAR);
        return;
    }

    obj_from_char(obj);
    obj_to_char(obj, ch);
    act("$n  $p  $N.", ch, obj, victim, TO_NOTVICT);
    act("  $p  $N.",     ch, obj, victim, TO_CHAR  );
    act("$n    $p.", ch, obj, victim, TO_VICT  );

    oprog_call(OPROG_GIVE, obj, ch, victim);
    act("     .", ch, NULL, NULL, TO_CHAR);
}

DO_FUN(do_make_arrow)
{
    OBJ_DATA *arrow;
    AFFECT_DATA af, saf;
    int count, color, mana, wait;
    char arg[MAX_INPUT_LENGTH];
    char *str = "wooden";
    int chance;
    int sn;
    int sk = 0;

    if (IS_NPC(ch))
        return;

    if ((sn = sn_lookup("make arrow")) < 0
        ||  (chance = get_skill(ch, sn)) == 0)
    {
        act("     .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (ch->in_room->sector_type != SECT_FIELD
        &&  ch->in_room->sector_type != SECT_FOREST
        &&  ch->in_room->sector_type != SECT_HILLS)
    {
        act("     .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    mana = SKILL(sn)->min_mana;
    wait = SKILL(sn)->beats;

    color = -1;
    argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
        color = 0;
    else if (!str_prefix(arg, "green")
             || !str_prefix(arg, "")
             || !str_prefix(arg, "̣"))
    {
        color = sn_lookup("green arrow");
        saf.bitvector   = WEAPON_POISON;
        str = "green";
    } else if (!str_prefix(arg, "red")
               || !str_prefix(arg, ""))
    {
        color = sn_lookup("red arrow");
        saf.bitvector   = WEAPON_FLAMING;
        str = "red";
    } else if (!str_prefix(arg, "white")
               || !str_prefix(arg, ""))
    {
        color = sn_lookup("white arrow");
        saf.bitvector   = WEAPON_FROST;
        str = "white";
    } else if (!str_prefix(arg, "blue")
               || !str_prefix(arg, ""))
    {
        color = sn_lookup("blue arrow");
        saf.bitvector   = WEAPON_SHOCKING;
        str = "blue";
    }

    if ((color) && ((sk = get_skill(ch, color)) < 1))
    {
        char_act("       .", ch);
        return;
    }

    if (color)
    {
        mana += SKILL(color)->min_mana;
        wait += SKILL(color)->beats;
    }

    if (ch->mana < mana)
    {
        char_act("        .", ch);
        return;
    }

    ch->mana -= mana;
    WAIT_STATE(ch, wait);

    if (color > 0) chance = chance * sk / 100;
    act(" $gn{}  !", ch, NULL, NULL, TO_CHAR);
    act("$n $gn{}  !",ch,NULL,NULL,TO_ROOM);
    for (count = 0; count < LVL(ch) / 5; count++)
    {
        if (number_percent() > chance)
        {
            char_act("     ,   .", ch);
            check_improve(ch, sn, FALSE, 3);
            if (color)
                check_improve(ch, color, FALSE, 3);
            continue;
        }

        check_improve(ch, sn, TRUE, 3);
        if (color)
            check_improve(ch, color, TRUE, 3);

        arrow = create_named_obj(get_obj_index(OBJ_VNUM_RANGER_ARROW),
                                 ch->level, str);
        arrow->level = ch->level;
        arrow->value[1] = 4 + LVL(ch) / 10;
        arrow->value[2] = 4 + LVL(ch) / 10;

        af.where         = TO_OBJECT;
        af.type          = sn;
        af.level         = LVL(ch);
        af.duration      = -1;
        af.location      = APPLY_HITROLL;
        af.modifier      = LVL(ch) / 10;
        af.bitvector     = 0;
        affect_to_obj(arrow, &af);

        af.where        = TO_OBJECT;
        af.type         = sn;
        af.level        = LVL(ch);
        af.duration     = -1;
        af.location     = APPLY_DAMROLL;
        af.modifier     = LVL(ch) / 10;
        af.bitvector    = 0;
        affect_to_obj(arrow, &af);

        if (color)
        {
            saf.where        = TO_WEAPON;
            saf.type         = color;
            saf.level        = LVL(ch);
            saf.duration     = -1;
            saf.location     = 0;
            saf.modifier     = 0;
            affect_to_obj(arrow, &saf);
        }

        obj_to_char(arrow, ch);
        act_puts("  $gn{} $c6{$p}.", ch, arrow, NULL, TO_CHAR, POS_DEAD);
        arrow = NULL;
    }
}

DO_FUN(do_make_bow)
{
    OBJ_DATA *      bow;
    AFFECT_DATA     af;
    int             mana;
    int             sn;
    int             chance;

    if (IS_NPC(ch))
        return;

    if ((sn = sn_lookup("make bow")) < 0
        ||  (chance = get_skill(ch, sn)) == 0)
    {
        act("     .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (ch->in_room->sector_type != SECT_FIELD
        &&  ch->in_room->sector_type != SECT_FOREST
        &&  ch->in_room->sector_type != SECT_HILLS)
    {
        act("   .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    mana = SKILL(sn)->min_mana;
    if (ch->mana < mana)
    {
        char_act("   ,   .", ch);
        return;
    }
    ch->mana -= mana;
    WAIT_STATE(ch, SKILL(sn)->beats);

    if (number_percent() > chance)
    {
        char_act("        .", ch);
        check_improve(ch, sn, FALSE, 1);
        return;
    }
    check_improve(ch, sn, TRUE, 1);

    bow = create_obj(get_obj_index(OBJ_VNUM_RANGER_BOW), ch->level);
    bow->level = ch->level;
    bow->value[1] = 4 + LVL(ch) / 15;
    bow->value[2] = 5 + LVL(ch) / 15;

    af.where        = TO_OBJECT;
    af.type         = sn;
    af.level        = LVL(ch);
    af.duration     = -1;
    af.location     = APPLY_HITROLL;
    af.modifier     = LVL(ch) / 10;
    af.bitvector    = 0;
    affect_to_obj(bow, &af);

    af.where        = TO_OBJECT;
    af.type         = sn;
    af.level        = LVL(ch);
    af.duration     = -1;
    af.location     = APPLY_DAMROLL;
    af.modifier     = LVL(ch) / 10;
    af.bitvector    = 0;
    affect_to_obj(bow, &af);

    obj_to_char(bow, ch);
    act_puts("   $p.", ch, bow, NULL, TO_CHAR, POS_DEAD);
}

DO_FUN(do_make_quiver)
{
    char arg[MAX_STRING_LENGTH];
    AFFECT_DATA af;
    OBJ_DATA *quiver;
    OBJ_DATA *part;
    int chance;
    int sn;

    sn = sn_lookup("make arrow");
    if ((chance = get_skill(ch, sn)) < 1)
    {
        act("     ,    .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == 0)
    {
        act("  ?", ch, NULL, NULL, TO_CHAR);
        return;
    }
    if ((part = get_obj_carry(ch, arg)) == NULL)
    {
        act("   .", ch, NULL, NULL, TO_CHAR);
        return;
    }
    if (part->pIndexData->vnum == OBJ_VNUM_SLICED_ARM
        ||  part->pIndexData->vnum == OBJ_VNUM_SLICED_LEG
        ||  part->pIndexData->vnum == OBJ_VNUM_SEVERED_HEAD
        ||  part->pIndexData->vnum == OBJ_VNUM_TORN_HEART
        ||  part->pIndexData->vnum == OBJ_VNUM_GUTS)
    {
        if (number_percent() < 30)
        {
            quiver = create_obj(
                               get_obj_index(OBJ_VNUM_RANGER_QUIVER), ch->level);
            af.where        = TO_OBJECT;
            af.type         = gsn_trophy;
            af.level        = LVL(ch);
            af.duration     = -1;
            af.location     = APPLY_DAMROLL;
            af.modifier     = LVL(ch) / 30;
            af.bitvector    = 0;
            affect_to_obj(quiver, &af);

            af.location     = APPLY_HITROLL;
            af.modifier     = LVL(ch) / 10;
            affect_to_obj(quiver, &af);

            quiver->value[0] += LVL(ch);
            quiver->value[3] += LVL(ch) / 5;

            obj_to_char(quiver, ch);
            act("    .", ch, NULL, NULL, TO_CHAR);
            act("$n    ",
                ch, NULL, NULL, TO_ROOM);
            extract_obj(part);
            return;
        }
        act("     .", ch, NULL, NULL, TO_CHAR);
        extract_obj(part);
        return;
    }
    act("       .", ch, NULL, NULL, TO_CHAR);
}

DO_FUN(do_make_wand)
{
    OBJ_DATA    *wand;
    OBJ_DATA    *wood;
    AFFECT_DATA af;
    char arg[MAX_INPUT_LENGTH];
    int sn;
    int chance;
    int mana;

    one_argument(argument, arg, sizeof(arg));

    if ((sn = sn_lookup("creation")) < 0
        || (chance = get_skill(ch, sn)) == 0)
    {
        act("You don't know how to create.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (is_affected(ch, gsn_creation))
    {
        act("You aren't ready for creation.",
            ch, NULL, NULL, TO_CHAR);
        return;
    }

    mana = SKILL(sn)->min_mana;
    if (ch->mana < mana)
    {
        act("You don't have sufficiently mana for creation.",
            ch, NULL, NULL, TO_CHAR);
        return;
    }

    for (wood = ch->carrying; wood != NULL; wood = wood->next_content)
        if (wood->pIndexData->vnum == OBJ_VNUM_WOOD)
            break;

    if (wood == NULL)
    {
        act("You need wood for this creation.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    WAIT_STATE(ch, SKILL(sn)->beats);

    if (number_percent() > chance)
    {
        act("You failed to create!", ch, NULL, NULL, TO_CHAR);
        check_improve(ch, sn, FALSE, 2);
        ch->mana -= mana/2;
        return;
    }

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = ch->level;
    af.duration     = ch->level / 5;
    af.modifier     = 0;
    af.bitvector    = 0;
    af.location     = 0;
    affect_to_char(ch,&af);

    check_improve(ch, sn, TRUE, 2);
    ch->mana -= mana;

    wand = create_obj(get_obj_index(OBJ_VNUM_WAND), ch->level);
    act_puts("You have successfully made $p.",
             ch, wand, NULL, TO_CHAR, POS_DEAD);
    act_puts("$n has successfully made $p.",
             ch, wand, NULL, TO_ROOM, POS_DEAD);

    extract_obj(wood);
    obj_to_room (wand, ch->in_room);
    do_look (ch, "auto");
}

DO_FUN(do_make_staff)
{
    OBJ_DATA    *staff;
    OBJ_DATA    *wood;
    AFFECT_DATA af;
    char arg[MAX_INPUT_LENGTH];
    int sn;
    int chance;
    int mana;

    one_argument(argument, arg, sizeof(arg));

    if ((sn = sn_lookup("creation")) < 0
        || (chance = get_skill(ch, sn)) == 0)
    {
        act("You don't know how to create.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (is_affected(ch, gsn_creation))
    {
        act("You aren't ready for creation.",
            ch, NULL, NULL, TO_CHAR);
        return;
    }

    mana = SKILL(sn)->min_mana;
    if (ch->mana < mana)
    {
        act("You don't have sufficiently mana for creation.",
            ch, NULL, NULL, TO_CHAR);
        return;
    }

    for (wood = ch->carrying; wood != NULL; wood = wood->next_content)
        if (wood->pIndexData->vnum == OBJ_VNUM_WOOD)
            break;

    if (wood == NULL)
    {
        act("You need wood for this creation.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    WAIT_STATE(ch, SKILL(sn)->beats);

    if (number_percent() > chance)
    {
        act("You failed to create!", ch, NULL, NULL, TO_CHAR);
        check_improve(ch, sn, FALSE, 2);
        ch->mana -= mana/2;
        return;
    }

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = ch->level;
    af.duration     = ch->level / 5;
    af.modifier     = 0;
    af.bitvector    = 0;
    af.location     = 0;
    affect_to_char(ch,&af);

    check_improve(ch, sn, TRUE, 2);
    ch->mana -= mana;

    staff = create_obj(get_obj_index(OBJ_VNUM_STAFF), ch->level);
    act_puts("You have successfully made $p.",
             ch, staff, NULL, TO_CHAR, POS_DEAD);
    act_puts("$n has successfully made $p.",
             ch, staff, NULL, TO_ROOM, POS_DEAD);

    extract_obj(wood);
    obj_to_room (staff, ch->in_room);
    do_look (ch, "auto");
}

DO_FUN(do_make_scroll)
{
    OBJ_DATA    *scroll;
    OBJ_DATA    *wood;
    AFFECT_DATA af;
    char arg[MAX_INPUT_LENGTH];
    int sn;
    int chance;
    int mana;
    int i;

    one_argument(argument, arg, sizeof(arg));

    if ((sn = sn_lookup("creation")) < 0
        || (chance = get_skill(ch, sn)) == 0)
    {
        act("You don't know how to create.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (is_affected(ch, gsn_creation))
    {
        act("You aren't ready for creation.",
            ch, NULL, NULL, TO_CHAR);
        return;
    }

    mana = SKILL(sn)->min_mana;
    if (ch->mana < mana)
    {
        act("You don't have sufficiently mana for creation.",
            ch, NULL, NULL, TO_CHAR);
        return;
    }

    for (wood = ch->carrying; wood != NULL; wood = wood->next_content)
        if (wood->pIndexData->vnum == OBJ_VNUM_WOOD)
            break;

    if (wood == NULL)
    {
        act("You need wood for this creation.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    WAIT_STATE(ch, SKILL(sn)->beats);

    if (number_percent() + 25 > chance)
    {
        act("You failed to create!", ch, NULL, NULL, TO_CHAR);
        check_improve(ch, sn, FALSE, 2);
        ch->mana -= mana/2;
        return;
    }

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = ch->level;
    af.duration     = ch->level / 5;
    af.modifier     = 0;
    af.bitvector    = 0;
    af.location     = 0;
    affect_to_char(ch,&af);

    check_improve(ch, sn, TRUE, 2);
    ch->mana -= mana;

    extract_obj(wood);

    i = UMAX(1, LVL(ch)/30);

    while (i--)
    {
        scroll = create_obj(get_obj_index(OBJ_VNUM_SCROLL_SCRIBING), ch->level);
        act_puts("You have successfully made $p.",
                 ch, scroll, NULL, TO_CHAR, POS_DEAD);
        act_puts("$n has successfully made $p.",
                 ch, scroll, NULL, TO_ROOM, POS_DEAD);
        obj_to_room (scroll, ch->in_room);
    }
    do_look (ch, "auto");
}

DO_FUN(do_make_axe)
{
    OBJ_DATA        *axe;
    OBJ_DATA        *part;
    OBJ_DATA        *wood;
    char arg[MAX_INPUT_LENGTH];
    AFFECT_DATA     af;
    int             mana;
    int             sn;
    int             chance;

    if (IS_NPC(ch))
        return;

    one_argument(argument, arg, sizeof(arg));

    if ((sn = sn_lookup("make axe")) < 0
        || (chance = get_skill(ch, sn)) == 0)
    {
        act("     .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (is_affected(ch, gsn_make_axe))
    {
        act("      !", ch, NULL, NULL, TO_CHAR);
        return;
    }

    for (wood = ch->carrying; wood != NULL; wood = wood->next_content)
        if (wood->pIndexData->vnum == OBJ_VNUM_WOOD)
            break;

    if (wood == NULL)
    {
        act("You need wood for this creation.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (arg[0] == '\0')
    {
        act("   ?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((part = get_obj_carry(ch, arg)) == NULL)
    {
        act("   .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (part->pIndexData->vnum != OBJ_VNUM_CHUNK_IRON)
    {
        act("     .",
            ch, NULL, NULL, TO_CHAR);
        return;
    }

    mana = SKILL(sn)->min_mana;
    if (ch->mana < mana)
    {
        char_act("   ,   .", ch);
        return;
    }

    WAIT_STATE(ch, SKILL(sn)->beats);

    if (number_percent() > chance)
    {
        char_act("        .", ch);
        check_improve(ch, sn, FALSE, 1);
        extract_obj(part);
        ch->mana -= mana/2;
        return;
    }

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = ch->level;
    af.duration     = ch->level / 5;
    af.modifier     = 0;
    af.bitvector    = 0;
    af.location     = 0;
    affect_to_char(ch,&af);

    check_improve(ch, sn, TRUE, 2);
    ch->mana -= mana;

    axe = create_obj(get_obj_index(OBJ_VNUM_BLOODY_AXE), ch->level);
    act("   !", ch, NULL, NULL, TO_CHAR);
    act("$n   !",ch,NULL,NULL,TO_ROOM);

    axe->value[1] = 1 + number_fuzzy(ch->level / 4);
    axe->level = ch->level;

    af.where        = TO_OBJECT;
    af.type         = sn;
    af.level        = ch->level;
    af.duration     = -1;
    af.modifier     = 3 + number_fuzzy(ch->level / 7);
    af.bitvector    = 0;

    af.location     = APPLY_HITROLL;
    affect_to_obj(axe, &af);

    af.modifier     = 3 + number_fuzzy(ch->level / 7);
    af.location     = APPLY_DAMROLL;
    affect_to_obj(axe, &af);

    af.modifier     = number_fuzzy(ch->level);
    af.location     = APPLY_HIT;
    affect_to_obj(axe, &af);

    obj_to_char(axe, ch);
    extract_obj(part);
    extract_obj(wood);
}

DO_FUN(do_make_grenade)
{
    OBJ_DATA    *grenade;
    OBJ_DATA    *gems;
    OBJ_DATA    *part;
    char arg[MAX_INPUT_LENGTH];
    AFFECT_DATA af;
    int mana, sn, chance, i;

    if (IS_NPC(ch))
        return;

    one_argument(argument, arg, sizeof(arg));

    if ((sn = sn_lookup("grenade")) < 0
        || (chance = get_skill(ch, sn)) == 0)
    {
        act("     .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (is_affected(ch, gsn_grenade))
    {
        act("Wait for a moment!", ch, NULL, NULL, TO_CHAR);
        return;
    }

    for (gems = ch->carrying; gems != NULL; gems = gems->next_content)
        if (gems->pIndexData->vnum == OBJ_VNUM_GEMS)
            break;

    if (gems == NULL)
    {
        act("You need gems to make grenade.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (arg[0] == '\0')
    {
        act("   ?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((part = get_obj_carry(ch, arg)) == NULL)
    {
        act("   .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((part->pIndexData->vnum != OBJ_VNUM_CHUNK_IRON)
        && (part->pIndexData->vnum != OBJ_VNUM_CHUNK_COPPER)
        && (part->pIndexData->vnum != OBJ_VNUM_CHUNK_GOLD))
    {
        act("     .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    mana = SKILL(sn)->min_mana;
    if (ch->mana < mana)
    {
        act("   ,   .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    WAIT_STATE(ch, SKILL(sn)->beats);

    if (number_percent() > chance)
    {
        act("     .", ch, NULL, NULL, TO_CHAR);
        check_improve(ch, sn, FALSE, 1);
        extract_obj(part);
        extract_obj(gems);
        ch->mana -= mana/2;
        return;
    }

    af.where        = TO_AFFECTS;
    af.type         = sn;
    af.level        = ch->level;
    af.duration     = 2;
    af.modifier     = 0;
    af.bitvector    = 0;
    af.location     = 0;
    affect_to_char(ch,&af);

    check_improve(ch, sn, TRUE, 2);
    ch->mana -= mana;

    i = UMAX(1, LVL(ch)/30);

    while (i--)
    {
        grenade = create_obj(get_obj_index(OBJ_VNUM_GRENADE), ch->level);

        grenade->value[1] = 1 + number_fuzzy(ch->level / 4);
        grenade->level = ch->level;
        act_puts("You have successfully made $p.",
                 ch, grenade, NULL, TO_CHAR, POS_DEAD);
        act_puts("$n has successfully made $p.",
                 ch, grenade, NULL, TO_ROOM, POS_DEAD);

        obj_to_char(grenade,ch);
    }
/*
    act("  !", ch, NULL, NULL, TO_CHAR);
    act("$n  !",ch,NULL,NULL,TO_ROOM);
*/
    extract_obj(part);
    extract_obj(gems);
}

DO_FUN(do_make_cloak)
{
    OBJ_DATA    *cloak;
    OBJ_DATA    *part;
    char arg[MAX_INPUT_LENGTH];
    int mana;

    if (IS_NPC(ch))
        return;

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        act("   ?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((part = get_obj_carry(ch, arg)) == NULL)
    {
        act("   .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (part->pIndexData->vnum != OBJ_VNUM_SKIN)
    {
        act("     .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    mana = ch->level * 10;
    if (ch->mana < mana)
    {
        act("   ,   .",
            ch, NULL, NULL, TO_CHAR);
        return;
    }

    WAIT_STATE(ch, 3 * PULSE_VIOLENCE);

    if (number_percent() > LVL(ch))
    {
        act("     .", ch, NULL, NULL, TO_CHAR);
        extract_obj(part);
        ch->mana -= mana/2;
        return;
    }

    ch->mana -= mana;

    cloak = create_obj(get_obj_index(OBJ_VNUM_DWARVEN_CLOAK), ch->level);
    act("   !", ch, NULL, NULL, TO_CHAR);
    act("$n   !", ch, NULL, NULL, TO_ROOM);

    cloak->level = ch->level;

    obj_to_char(cloak, ch);
    extract_obj(part);
}

DO_FUN(do_make_belt)
{
    OBJ_DATA    *belt;
    OBJ_DATA    *part;
    char arg[MAX_INPUT_LENGTH];
    int mana;

    if (IS_NPC(ch))
        return;

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        act("   ?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((part = get_obj_carry(ch, arg)) == NULL)
    {
        act("   .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (part->pIndexData->vnum != OBJ_VNUM_SKIN)
    {
        act("     .", ch, NULL, NULL, TO_CHAR);
        return;
    }

    mana = ch->level * 10;
    if (ch->mana < mana)
    {
        act("   ,   .",
            ch, NULL, NULL, TO_CHAR);
        return;
    }

    WAIT_STATE(ch, 3 * PULSE_VIOLENCE);

    if (number_percent() > LVL(ch))
    {
        act("     .", ch, NULL, NULL, TO_CHAR);
        extract_obj(part);
        ch->mana -= mana/2;
        return;
    }

    ch->mana -= mana;

    belt = create_obj(get_obj_index(OBJ_VNUM_DWARVEN_BELT), ch->level);
    act("     !", ch, NULL, NULL, TO_CHAR);
    act("$n     !", ch, NULL, NULL, TO_ROOM);

    belt->level = ch->level;

    obj_to_char(belt, ch);
    extract_obj(part);
}

DO_FUN(do_make_gold)
{
    OBJ_DATA *obj;
    OBJ_DATA *bar;
    OBJ_DATA *hammer;
    OBJ_DATA *pliers;
    char arg[MAX_INPUT_LENGTH];
    int mana, wait;
    int chance, count;
    int sn;

    argument = one_argument(argument, arg, sizeof(arg));

    if ((sn = sn_lookup("smithery")) < 0
        || (chance = get_skill(ch, sn)) == 0)
    {
        act("You are not a blacksmith!", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (arg[0] == '\0')
    {
        act("Make gold from what?", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((hammer = get_eq_char(ch, WEAR_HOLD)) == NULL)
    {
        act("You are not holding a hammer.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (hammer->pIndexData->vnum != OBJ_VNUM_HAMMER)
    {
        act("That is not a right hammer.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((pliers = get_eq_char(ch, WEAR_WIELD)) == NULL)
    {
        act("You do not have pliers in your hand.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (pliers->pIndexData->vnum != OBJ_VNUM_PLIERS)
    {
        act("You should have forge pliers to forge.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((bar = get_obj_carry(ch, arg)) == NULL)
    {
        act("You do not have a bar of that metal.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (bar->pIndexData->vnum == OBJ_VNUM_GOLD_ORE)
    {
        act("You must first SMELT this piece of ore.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (bar->pIndexData->vnum != OBJ_VNUM_CHUNK_GOLD)
    {
        act("Even you are not so silly to do this.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    /* Looking for the forge in the room */
    for (obj = ch->in_room->contents; obj; obj= obj->next_content)
        if (obj->pIndexData->vnum == OBJ_VNUM_FORGE)
            break;

    if (obj == NULL)
    {
        act("You lack the forge.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    /* Looking for the anvil in the room */
    obj = NULL;

    for (obj = ch->in_room->contents; obj; obj= obj->next_content)
        if (obj->pIndexData->vnum == OBJ_VNUM_ANVIL)
            break;

    if (obj == NULL)
    {
        act("You need an anvil to forge!", ch, NULL, NULL, TO_CHAR);
        return;
    }

    /* Looking for the coal in the inventory */
    obj = NULL;

    for (obj = ch->carrying; obj != NULL; obj = obj->next_content)
        if (obj->pIndexData->vnum == OBJ_VNUM_CHUNK_COAL)
            break;

    if (obj == NULL)
    {
        act("You need coal to work.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    mana = SKILL(sn)->min_mana;
    wait = SKILL(sn)->beats;

    if (ch->mana < mana)
    {
        act("You don't have enough energy to work in the smithy.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    ch->mana -= mana;
    WAIT_STATE(ch, wait);

    act("You begin to work on the anvil with your hammer.", ch, NULL, NULL, TO_CHAR);
    act("$n begins to work on the anvil with the hammer.", ch, NULL, NULL, TO_ROOM);

    if (number_percent() > chance)
    {
        act("You failed to make it. Try again later.", ch, NULL, NULL, TO_CHAR);
        check_improve(ch, sn, FALSE, 3);
        return;
    }

    check_improve(ch, sn, TRUE, 3);
    obj_from_char(bar);
    obj_from_char(obj);

    count = number_range(10, 20);

    if (number_percent() < get_curr_stat(ch, STAT_LCK))
    {
        count *= 2;

        if (number_bits(2) == 0)
            count *= 2;
    }
    char_printf(ch, "You have successfully made %d gold pieces.\n", count);
    ch->gold += count;
    stat_record.gold_made += count;
}

DO_FUN(do_make_love)
{
    act("{WMake {Clove{W, not {Rwar{W!{x", ch, NULL, NULL, TO_ALL);
}

DO_FUN(do_make)
{
    char arg[MAX_INPUT_LENGTH];

    argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        act("    (bow), (arrow), (quiver),",
            ch, NULL, NULL, TO_CHAR);
        act("(axe), (grenade), (wand) (staff), (scroll),",
            ch, NULL, NULL, TO_CHAR);
        act(" (cloak),    (belt), (love)  (gold).",
            ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!str_prefix(arg, "cloak")
        || !str_prefix(arg, ""))
    {
        do_make_cloak(ch, argument);
    }
    if (!str_prefix(arg, "belt")
        || !str_prefix(arg, ""))
    {
        do_make_belt(ch, argument);
    }
    if (!str_prefix(arg, "arrow")
        || !str_prefix(arg, ""))
    {
        do_make_arrow(ch, argument);
    } else if (!str_prefix(arg, "bow")
               || !str_prefix(arg, ""))
    {
        do_make_bow(ch, argument);
    } else if (!str_prefix(arg, "quiver")
               || !str_prefix(arg, ""))
    {
        do_make_quiver(ch, argument);
    } else if (!str_prefix(arg, "axe")
               || !str_prefix(arg, ""))
    {
        do_make_axe(ch, argument);
    } else if (!str_prefix(arg, "grenade")
               || !str_prefix(arg, ""))
    {
        do_make_grenade(ch, argument);
    } else if (!str_prefix(arg, "wand")
               || !str_prefix(arg, ""))
    {
        do_make_wand(ch, argument);
    } else if (!str_prefix(arg, "staff")
               || !str_prefix(arg, ""))
    {
        do_make_staff(ch, argument);
    } else if (!str_prefix(arg, "scroll")
               || !str_prefix(arg, ""))
    {
        do_make_scroll(ch, argument);
    }
    else if (!str_prefix(arg, "gold")
             || !str_prefix(arg, ""))
    {
        do_make_gold(ch, argument);
    }
    else if (!str_prefix(arg, "love")
             || !str_prefix(arg, ""))
    {
        do_make_love(ch, argument);
    }
    else if (!str_prefix(arg, "tattoo")
             || !str_prefix(arg, ""))
    {
        do_make_tattoo(ch, argument);
    }
    else if (!str_prefix(arg, "paint")
             || !str_prefix(arg, ""))
    {
        do_make_paint(ch, argument);
    }
    else
        do_make(ch, str_empty);
}

void show_wanted_desk(CHAR_DATA *ch)
{
    BUFFER *output = NULL;
    BUFFER *output2 = NULL;
    DESCRIPTOR_DATA *d;

    for (d = descriptor_list; d != NULL; d = d->next)
    {
        CHAR_DATA *wch;

        if (d->connected != CON_PLAYING)
            continue;
        wch = (d->original != NULL) ? d->original : d->character;
        if (IS_SET(wch->plr_flags, PLR_WANTED))
        {
            if (output == NULL) output = buf_new(-1);
            do_who_raw(ch, wch, output);
        }
        if (wch->pcdata->headprice > 0)
        {
            if (output2 == NULL) output2 = buf_new(-1);
            do_who_raw(ch, wch, output2);
        }
    }

    if (output == NULL)
    {
        act("  $gn{}       .", ch, NULL, NULL, TO_CHAR);
//        return;
    } else
    {
        act("  ,  :\n", ch, NULL, NULL, TO_CHAR);
        buf_add(output, "{x\n       ,    !\n");
        page_to_char(buf_string(output), ch);
        buf_free(output);
    }

// HEAD PRICE BOUNTY
    if (output2 == NULL)
    {
        act("  $gn{}      .", ch, NULL, NULL, TO_CHAR);
//        return;
    } else
    {
        act("  ,    :\n", ch, NULL, NULL, TO_CHAR);
        buf_add(output2, "{x\n     !\n");
        page_to_char(buf_string(output2), ch);
        buf_free(output2);
    }
// return;
}


void do_noexp( CHAR_DATA *ch, const char *argument )
{
    char arg[MAX_INPUT_LENGTH];

    one_argument( argument, arg , sizeof(arg ));

    if (arg[0] == '\0')
    {
        do_help(ch, "'NOEXP SYNTAX'");
        return;
    }

    if (!str_cmp(arg, "on")
        || !str_cmp(arg, ""))
    {

        char_act("     .", ch);
        SET_BIT(ch->plr_flags, PLR_NOEXP);
        return;
    }

    if (!str_cmp(arg, "off")
        || !str_cmp(arg, ""))
    {
        char_act("    .", ch);
        REMOVE_BIT(ch->plr_flags, PLR_NOEXP);
        return;
    }
}

void do_bonus( CHAR_DATA *ch, const char *argument )
{
    OBJ_INDEX_DATA *pObjIndex;
    OBJ_DATA *bonus_obj;
    OBJ_DATA *obj;
    char arg[MAX_INPUT_LENGTH];
    int vnum ;

    one_argument( argument, arg, sizeof(arg) );

    if (arg[0] == '\0')
    {
        do_help(ch, "'BONUS SYNTAX'");
        return;
    }

    if (IS_NPC(ch)) return;

    if (is_number(arg))
    {
        vnum = atoi(arg);

        if (ch->level < 55)
        {
            act("Bonus system and objects unavailable until 55 level.",
                ch, NULL, NULL, TO_CHAR);
            return;
        }
        if (ch->pcdata->bonuspoints < 1)
        {
            act("You must have one bonus poit for this.",
                ch, NULL, NULL, TO_CHAR);
            return;
        }
        if (ch->in_room->vnum != ROOM_VNUM_TEMPLE)
        {
            act("You must be deep inside Great Temple.",
                ch, NULL, NULL, TO_CHAR);
            return;
        }

        if ((pObjIndex = get_obj_index(vnum)) == NULL
        || vnum < 51400
        || vnum > 52499)
        {
            char_printf(ch, "You type : %d, but no bonus object with this vnum.\n",
                        vnum);
            WAIT_STATE(ch, 768);
            return;
        }

        bonus_obj = create_obj(pObjIndex, ch->level);

        if (!is_name(str_dup(ch->name), bonus_obj->name))
        {
            act("Aborted! You must enter correct number!",
                ch, NULL, NULL, TO_CHAR);
            extract_obj(bonus_obj);
            WAIT_STATE(ch, 768);
            return;
        }

        bonus_obj->owner = str_dup(ch->name);

        for (obj = object_list; obj != NULL; obj = obj->next)
        {
            if (bonus_obj->pIndexData->vnum == obj->pIndexData->vnum
            && obj != bonus_obj)
            {
                act("Aborted! Find your bonus object, it's in the world!",
                    ch, NULL, NULL, TO_CHAR);
                extract_obj(bonus_obj);
                WAIT_STATE(ch, 768);
                return;
            }
        }

        ch->pcdata->bonuspoints -= 1;
        obj_to_char(bonus_obj, ch);
        act("$n pray's for $p!", ch, bonus_obj, NULL, TO_ROOM);
        wiznet("$N bonus_return $p.",
               ch, bonus_obj, WIZ_LOAD, WIZ_SECURE, ch->level);
        act("Ok.", ch, NULL, NULL, TO_CHAR);
        WAIT_STATE(ch, 128);
        return;
    }

    if (!str_cmp(arg, "on")
    || !str_cmp(arg, ""))
    {
        if (ch->level < 55)
        {
            act("Bonus system and objects unavailable until 55 level.",
                ch, NULL, NULL, TO_CHAR);
            return;
        }

        ch->exp_tl = 0;
        ch->exp = exp_for_level(ch, ch->level);

        act("Bonus system status : ON.", ch, NULL, NULL, TO_CHAR);
        SET_BIT(ch->comm, COMM_BONUS);
        return;
    }

    if (!str_cmp(arg, "off")
    || !str_cmp(arg, ""))
    {
        act("Bonus system status : OFF.", ch, NULL, NULL, TO_CHAR);
        REMOVE_BIT(ch->comm,COMM_BONUS);
        return;
    }

    if (!str_prefix(arg,"info")
    || !str_prefix(arg, ""))
    {
        char_printf(ch, "You have {W%d{x bonus point's.\n", ch->pcdata->bonuspoints);
        if (IS_SET(ch->comm, COMM_BONUS))
        {
            act("Bonus system status : ON.", ch, NULL, NULL, TO_CHAR);
        } else
        {
            act("Bonus system status : OFF.", ch, NULL, NULL, TO_CHAR);
        }
    }
/*
    if (!str_prefix(arg,"eq"))
    {
    }
*/
    return;
}

DO_FUN(do_fix)
{
    reset_char(ch);
}

void look_window( CHAR_DATA *ch, OBJ_DATA *obj )
{
    char              buf[MAX_STRING_LENGTH];
    ROOM_INDEX_DATA * window_room;
    int               numpeople;
    CHAR_DATA       * person;
    WQ_QUESTDATA    * wquest;

    if (obj->value[0] == 0)
    {
        sprintf(buf, "%s\n\r", format_descr(obj->description,ch));
        send_to_char(buf, ch);
        return;
    }

    if (get_room_index(obj->value[0]) == NULL)
    {
        send_to_char( "!!BUG!! Window looks into a NULL room! Please report!\n\r", ch );
        bug( "look_window: Window %d looks into a null room!!!", obj->pIndexData->vnum );
        return;
    } else
    {
        if (!IS_NPC(ch))
        {
            window_room = get_room_index(obj->value[0]);
            act("Looking through the window you can see", ch, NULL, NULL, TO_CHAR);
            act(format_descr(window_room->name,ch), ch, NULL, NULL, TO_CHAR);
            act (mlstr_cval (window_room->description,ch), ch, NULL, NULL, TO_CHAR);
            show_list_to_char(window_room->contents, ch, FALSE, FALSE );
            send_to_char("\n\r", ch);

            for (numpeople = 0, person = window_room->people; person != NULL; person = person->next_in_room)
                if (can_see(ch,person))
                {
                    numpeople++;
                    break;
                }

            if (numpeople)
            {
                show_char_to_char(window_room->people, ch);
                act(str_empty, ch, NULL, NULL, TO_CHAR);
            }

            // wquest stuff
            wquest = wq_findquest (ch);
            if (wquest != NULL)
            {
                WQ_QUESTPLR * plr;
                int qp_reward, exp_reward;

                plr = wq_findplr (ch);
                if (plr != NULL && plr->visited > -1)
                {
                    if ((plr->visited < wquest->room_count)
                        && (obj == (OBJ_DATA *) wquest->windows[plr->visited]))
                    {
                        ++plr->visited;

                        // add qp
                        qp_reward = plr->visited * 3;
                        ch->pcdata->questpoints += qp_reward;
                        ch->pcdata->qp_earned += qp_reward;
                        act ("You've just completed a part of your quest!\nYou receive {C$j{x questpoints!\n",
                            ch, (const void *) qp_reward, NULL, TO_CHAR);

                        // add bp
                        if (   ((wquest->type == WQ_TYPE_PERSONAL) && (number_percent () == 1))
                            || ((wquest->type == WQ_TYPE_MULTIPLAYER) && (number_percent () < 4)))
                        {
                            ch->pcdata->bonuspoints += 1;
                            ch->pcdata->bp_earned += 1;
                            char_act ("You receive {C1{x bp!", ch);
                        }

                        // add experience
                        if (plr->visited > 3)
                        {
                            exp_reward = number_range (LVL(ch), LVL (ch) * (plr->visited - 3));
                            gain_exp (ch, exp_reward) ;
                            act ("You receive {R$j{x experience points!", ch, (const void *) exp_reward, NULL, TO_CHAR);
                        }

                    }
                    if (plr->visited == wquest->room_count)
                    {
                        char_act ("Go to the last room to complete your quest.", ch);
                    }
                }
            }
            return;
        }
    }

}


void look_gate( CHAR_DATA *ch, OBJ_DATA *obj )
{
    ROOM_INDEX_DATA * location;
    int               numpeople;
    CHAR_DATA       * person;


    if (get_room_index(obj->value[3]) == NULL)
    {
        send_to_char( "You in general can see nothing here.\n\r", ch );
        bug( "look_gate: Gate looks into a null room!!!", obj->pIndexData->vnum );
        return;
    }

    act("$n peers intently into $p.", ch, obj, NULL, TO_ROOM);
    act("You peer into $p.", ch, obj, NULL, TO_CHAR);

    if (IS_NPC(ch))
    {
        return;
    }

    if (!IS_SET(obj->value[2], GATE_TRANSPARENT))
    {
        act("The unsteady darkness hides all from you.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_SET(obj->value[2], GATE_NORMAL_EXIT) && !IS_SET(obj->value[1], EX_CLOSED))
        location = get_room_index(obj->value[3]);

    else if (IS_SET(obj->value[2], GATE_BUGGY) &&  !IS_SET(obj->value[1], EX_CLOSED))
        location = get_random_room(ch);

    else
    {
        act("The portal shimmers out of existance, stopping you from seeing through it.", ch, NULL, NULL, TO_CHAR);
        return;
    }
    act("Through the shimmering portal you see:\n\r",ch, NULL, NULL, TO_CHAR);
    act(format_descr(location->name,ch), ch, NULL, NULL, TO_CHAR);
    show_list_to_char( location->contents, ch, FALSE, FALSE );

    for (numpeople = 0, person = location->people; person != NULL; person = person->next_in_room)
        if (can_see(ch,person))
        {
            numpeople++;
            break;
        }

    if (numpeople)
    {
        show_char_to_char(location->people, ch);
        act(str_empty, ch, NULL, NULL, TO_CHAR);
    }

    return;
}


int count_skill_percent (CHAR_DATA * ch)
{
    int skill_percent = 0, j, i = 0;
    skill_t  *sk;
    pcskill_t    *ps;

    if (IS_NPC(ch))
        return 0;

    for (j = 0; j < ch->pcdata->learned.nused; j++)
    {
        ps = VARR_GET(&ch->pcdata->learned, j);

        if (ps->percent == 0
        || (sk = skill_lookup(ps->sn)) == NULL
        || skill_level(ch, ps->sn) > ch->level)
            continue;

        skill_percent += ps->percent;
        i++;
    }
    if (i == 0)
        skill_percent = 0;
    else
        skill_percent = skill_percent / i;

    return skill_percent;
}

int count_all_skill_percent (CHAR_DATA * ch)
{
    class_t *cl;
    race_t *r;
    int j, all_skill_percent = 0, temp = 0;
    qtrouble_t * qt;

    if (IS_NPC(ch))
        return 0;

    if ((cl = class_lookup(ch->class)) == NULL)
        return 0;

    all_skill_percent += count_skill_percent(ch);
    all_skill_percent += LVL(ch);
    all_skill_percent += get_age(ch);
    all_skill_percent += ch->pcdata->pc_killed;
    all_skill_percent -= ch->pcdata->pc_died;
    all_skill_percent += ch->pcdata->StatWinGlobalQuests;
    all_skill_percent += ch->pcdata->questcomplete;
    if (ch->religion && religion_lookup(ch->religion))
        all_skill_percent += 10;

    if (IS_MARRYED(ch))
        all_skill_percent += 10;
    all_skill_percent += ch->pcdata->TotalExploredRooms / 100;

    for (j = 0, qt = ch->pcdata->qtrouble ; qt ; qt = qt->next)
    {
        j++;
    }
    all_skill_percent += j * 10;
    switch (ch->pcdata->clan_status)
    {
        case CLAN_LEADER:   all_skill_percent += 50 ; break ;
        case CLAN_SECOND:   all_skill_percent += 35 ; break ;
        case CLAN_ELITE:    all_skill_percent += 20 ; break ;
        case CLAN_VETERAN:  all_skill_percent += 10 ; break ;
        case CLAN_COMMONER: all_skill_percent -= 0  ; break ;
        case CLAN_NEWBIE:   all_skill_percent -= 10 ; break ;
        default:            all_skill_percent -= 10 ; break ;
    }

    if (IS_SET(ch->pcdata->wishes, WISH_SHOWSCRY)) all_skill_percent += 50 ;
    if (IS_SET(ch->pcdata->wishes, WISH_EXPRATE1)) all_skill_percent += 60 ;
    if (IS_SET(ch->pcdata->wishes, WISH_EXPRATE2)) all_skill_percent += 120;
    if (IS_SET(ch->pcdata->wishes, WISH_SPELLUP1)) all_skill_percent += 30 ;
    if (IS_SET(ch->pcdata->wishes, WISH_SPELLUP2)) all_skill_percent += 60 ;
    if (IS_SET(ch->pcdata->wishes, WISH_LEARNUP2)) all_skill_percent += 30 ;
    if (IS_SET(ch->pcdata->wishes, WISH_LEARNUP1)) all_skill_percent += 60 ;

    r = RACE(ORG_RACE(ch));

    //  ,   ... temp ,     
    //       :)   ...
    temp = ((get_curr_stat(ch,STAT_CON) + r->pcdata->hp_bonus
             + cl->hp_rate) * ch->level);
    if (temp > ch->pcdata->perm_hit)
        all_skill_percent -= (temp - ch->pcdata->perm_hit) / 10;

    temp = ((get_curr_stat(ch,STAT_INT) + get_curr_stat(ch,STAT_WIS)
             + r->pcdata->mana_bonus + cl->mana_rate) * ch->level);
    if (temp > ch->pcdata->perm_hit)
        all_skill_percent -= (temp - ch->pcdata->perm_mana) / 100;

    temp = (((get_curr_stat(ch,STAT_CON) + get_curr_stat(ch,STAT_DEX))
             / 4) * ch->level);
    if (temp > ch->pcdata->perm_hit)
        all_skill_percent -= (temp - ch->pcdata->perm_move) / 100;

    return all_skill_percent;

}
