/* $Id: act_move.c,v 1.666 2004/09/20 10:49:46 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

 /************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/


#include <sys/types.h>
#if !defined (WIN32)
#include <sys/time.h>
#endif
#include <stdio.h>
#include <string.h>
#include "merc.h"
#include "update.h"
#include "mob_prog.h"
#include "obj_prog.h"
#include "fight.h"

extern bool check_recovery   (CHAR_DATA *ch, CHAR_DATA *victim);
extern bool check_roll       (CHAR_DATA *);
extern bool check_jammer     (CHAR_DATA *);
extern bool check_perception (CHAR_DATA *, CHAR_DATA *);
extern bool check_mirror_image (CHAR_DATA *, CHAR_DATA *);
extern bool check_dodge    (CHAR_DATA *ch, CHAR_DATA *victim);
extern bool is_safe_rspell_nom (int level, CHAR_DATA* victim);


char *  const   dir_name    []      =
    {
        "north", "east", "south", "west", "up", "down"
    };

const   int rev_dir     []      =
    {
        2, 3, 0, 1, 5, 4
    };

const   int movement_loss   [SECT_MAX]  =
    {
        1, 2, 2, 3, 4, 6, 4, 1, 6, 10, 6
    };

DECLARE_DO_FUN(do_look      );
DECLARE_DO_FUN(do_yell      );
DECLARE_DO_FUN(do_wear      );

void agent_net_printf(CHAR_DATA *ch, CHAR_DATA *victim, int condition);

/*
 * Local functions.
 */
int fish_number(int type);
int find_door   (CHAR_DATA *ch, char *arg);
int     find_exit   (CHAR_DATA *ch, char *arg);
bool    has_key     (CHAR_DATA *ch, int key);
int mount_success   (CHAR_DATA *ch, CHAR_DATA *mount, int canattack);
bool    move_char_org   (CHAR_DATA *ch, int door, bool follow, bool is_charge);

void move_char(CHAR_DATA *ch, int door, bool follow)
{
    move_char_org(ch, door, follow, FALSE);
}

bool move_char_org(CHAR_DATA *ch, int door, bool follow, bool is_charge)
{
    CHAR_DATA *fch;
    CHAR_DATA *fch_next;
    CHAR_DATA *mount;
    ROOM_INDEX_DATA *in_room;
    ROOM_INDEX_DATA *to_room;
    EXIT_DATA *pexit;
    bool room_has_pc;
    OBJ_DATA *obj;
    OBJ_DATA *obj_next;
    int act_flags;

    if (RIDDEN(ch) && !IS_NPC(ch->mount))
        return move_char_org(ch->mount,door,follow, is_charge);

    if (IS_AFFECTED(ch, AFF_WEB)
            || (MOUNTED(ch) && IS_AFFECTED(ch->mount, AFF_WEB)))
    {
        WAIT_STATE(ch, PULSE_VIOLENCE);
        if (number_percent() < str_app[IS_NPC(ch) ?
                                       20 : get_curr_stat(ch,STAT_STR)].tohit * 5)
        {
            affect_strip(ch, gsn_web);
            REMOVE_BIT(ch->affected_by, AFF_WEB);
            char_act("When you attempt to leave the room, you break the webs holding you tight.", ch);
            act_puts("$n struggles against the webs which hold $gn{him} in place, and break it.", ch, NULL, NULL, TO_ROOM, POS_RESTING);
        }
        else
        {
            char_act("You attempt to leave the room, but the webs hold you tight.", ch);
            act_puts("$n struggles vainly against the webs which hold $gn{him} in place.", ch, NULL, NULL, TO_ROOM, POS_RESTING);
            return FALSE;
        }
    }

    if (door < 0 || door >= MAX_DIR)
    {
        bug("Do_move: bad door %d.", door);
        return FALSE;
    }

    if (IS_AFFECTED(ch, AFF_HIDE | AFF_FADE)
            && !IS_AFFECTED(ch, AFF_SNEAK))
    {
        REMOVE_BIT(ch->affected_by, AFF_HIDE);
        char_act("You step out of shadows.", ch);
        act_puts("$n steps out of shadows.", ch, NULL, NULL, TO_ROOM, POS_RESTING);
    }

    if (IS_AFFECTED(ch, AFF_TRAP))
    {
        REMOVE_BIT(ch->affected_by, AFF_TRAP);
        char_act("You blew your cover.", ch);
        act_puts("$n blews the cover.", ch, NULL, NULL, TO_ROOM, POS_RESTING);
    }

    if (IS_AFFECTED(ch, AFF_EARTHFADE))
    {
        affect_bit_strip(ch, TO_AFFECTS, AFF_EARTHFADE);
        WAIT_STATE(ch, PULSE_VIOLENCE * 2);
        act("You fade to your neutral form.", ch, NULL, NULL, TO_CHAR);
        act("Earth forms $n in front of you.",ch, NULL, NULL, TO_ROOM);
    }

    if (IS_AFFECTED(ch, AFF_CAMOUFLAGE))
    {
        int chance;

        if ((chance = get_skill(ch, gsn_camouflage_move)) == 0)
        {
            REMOVE_BIT(ch->affected_by, AFF_CAMOUFLAGE);
            char_act("You step out from your cover.", ch);
            act_puts("$n steps out of the cover.", ch, NULL, NULL, TO_ROOM, POS_RESTING);
        }
        else if (number_percent() < chance)
            check_improve(ch, gsn_camouflage_move, TRUE, 5);
        else
        {
            REMOVE_BIT(ch->affected_by, AFF_CAMOUFLAGE);
            char_act("You step out from your cover.", ch);
            act_puts("$n steps out of the cover.", ch, NULL, NULL, TO_ROOM, POS_RESTING);
            check_improve(ch, gsn_camouflage_move, FALSE, 5);
        }
    }

    /*
     * Exit trigger, if activated, bail out. Only PCs are triggered.
     */

    if (!IS_NPC(ch)
            && (p_exit_trigger( ch, door, PRG_MPROG )
                || p_exit_trigger( ch, door, PRG_OPROG )
                || p_exit_trigger( ch, door, PRG_RPROG )))
        return FALSE;

    in_room = ch->in_room;
    if ((pexit = in_room->exit[door]) == NULL
            || (to_room = pexit->to_room.r) == NULL
            || (!IS_NPC(ch) && !can_see_room(ch, pexit->to_room.r)))
    {
        char_act("Alas, you cannot go that way.", ch);
        return FALSE;
    }

    if (IS_ROOM_AFFECTED(in_room, RAFF_RANDOMIZER) && !is_charge)
    {
        int d0;
        while (1)
        {
            d0 = number_range(0, MAX_DIR-1);
            if ((pexit = in_room->exit[d0]) == NULL
                    || (to_room = pexit->to_room.r) == NULL
                    || !can_see_room(ch, pexit->to_room.r))
                continue;
            door = d0;
            break;
        }
    }

    if (IS_SET(pexit->exit_info, EX_CLOSED)
            && (!(IS_AFFECTED(ch, AFF_PASS_DOOR)
                  || IS_SET(ch->plr_flags, PLR_GHOST))
                || IS_SET(pexit->exit_info, EX_NOPASS))
            && !IS_TRUSTED(ch, ANGEL))
    {
        if (IS_AFFECTED(ch, AFF_PASS_DOOR)
                && IS_SET(pexit->exit_info, EX_NOPASS))
        {
            act_puts("You failed to pass through the $d.",
                     ch, NULL, pexit->keyword, TO_CHAR, POS_RESTING);
            act_puts("$n tries to pass through the $d, but $gn{he} failes",
                     ch, NULL, pexit->keyword, TO_ROOM, POS_RESTING);
        }
        else
            act_puts("The $d is closed.", ch, NULL, pexit->keyword, TO_CHAR, POS_RESTING);
        return FALSE;
    }

    if (IS_AFFECTED(ch, AFF_CHARM)
            && ch->master != NULL
            && in_room == ch->master->in_room)
    {
        char_act("What? And leave your beloved master?", ch);
        return FALSE;
    }

    if (IS_ROOM_AFFECTED(in_room, RAFF_ESPIRIT)
            && !IS_ROOM_AFFECTED(to_room, RAFF_ESPIRIT)
            && is_affected(ch, gsn_evil_spirit))
    {
        act_puts("Evil spirit holds you in the place.", ch, NULL, NULL, TO_CHAR, POS_RESTING);
        act("Evil spirit holds $n in the place.", ch, NULL, NULL, TO_ROOM);
        return FALSE;
    }

    if (ch->size > pexit->size)
    {
        act_puts("This passage is too small for you.", ch, NULL, NULL, TO_CHAR, POS_RESTING);
        return FALSE;
    }

    if (!check_war_move (ch, to_room, FALSE))
        return FALSE;

    if ((count_used_space(to_room) + ch->size) > to_room->space)
    {
        act_puts("There too little place for you.",
                 ch, NULL, NULL, TO_CHAR, POS_RESTING);
        return FALSE;
    }

    if (room_is_private(to_room))
    {
        char_act("That room is private right now.", ch);
        return FALSE;
    }

    if (MOUNTED(ch))
    {
        if (MOUNTED(ch)->position < POS_FIGHTING)
        {
            char_act("Your mount must be standing.", ch);
            return FALSE;
        }
        if (!mount_success(ch, MOUNTED(ch), FALSE))
        {
            char_act("Your mount subbornly refuses to go that way.", ch);
            return FALSE;
        }
    }

    if (!IS_NPC(ch))
    {
        int move;

        if (!IS_IMMORTAL(ch) && IS_PUMPED(ch)
                && IS_SET(to_room->room_flags, ROOM_PEACE))
        {
            char_act("You feel too bloody to go in there now.", ch);
            return FALSE;
        }

        if (!MOUNTED(ch)
                &&  ch->position > POS_RESTING
                &&  ch->pcdata->condition[COND_DRUNK] > (number_percent() >> 1)
                &&  number_bits(3) == 1)
        {
            char_act("You are trying to do a step, but stumble and fall.", ch);
            act("$n is trying to do a step, but stumbles and falls.", ch, NULL, NULL, TO_NOTVICT);
            ch->position = POS_RESTING;
            return FALSE;
        }

        if (in_room->sector_type == SECT_AIR || to_room->sector_type == SECT_AIR)
        {
            if (MOUNTED(ch))
            {
                if (!IS_AFFECTED(MOUNTED(ch), AFF_FLYING))
                {
                    char_act("Your mount can't fly.", ch);
                    return FALSE;
                }
            }
            else if (!(IS_AFFECTED(ch, AFF_FLYING)
                       || IS_SET(ch->plr_flags, PLR_GHOST))
                     && !IS_IMMORTAL(ch))
            {
                char_act("You can't fly.", ch);
                return FALSE;
            }
        }

        if ((in_room->sector_type == SECT_WATER_NOSWIM
                || to_room->sector_type == SECT_WATER_NOSWIM)
                && (MOUNTED(ch) && !IS_AFFECTED(MOUNTED(ch),AFF_FLYING)))
        {
            char_act("You can't take your mount there.", ch);
            return FALSE;
        }

        if ((in_room->sector_type == SECT_WATER_NOSWIM
                || to_room->sector_type == SECT_WATER_NOSWIM)
                && (!MOUNTED(ch) && !IS_AFFECTED(ch, AFF_FLYING)
                    && !IS_AFFECTED(ch, AFF_SWIM)
                    && !IS_SET(ch->plr_flags, PLR_GHOST)
                    && !IS_IMMORTAL(ch)))
        {
            OBJ_DATA *obj;
            bool found = FALSE;

            /*
             * Look for a boat.
             */
            for (obj = ch->carrying; obj != NULL; obj = obj->next_content)
            {
                if (obj->pIndexData->item_type == ITEM_BOAT)
                {
                    found = TRUE;
                    break;
                }
            }
            if (!found)
            {
                char_act("You need a boat to go there.", ch);
                return FALSE;
            }
        }

        move = (movement_loss[UMIN(SECT_MAX-1, in_room->sector_type)]
                + movement_loss[UMIN(SECT_MAX-1, to_room->sector_type)])/2;

        if (is_affected(ch, gsn_thumbling))
            move *= 2;
        else
        {
            if (IS_AFFECTED(ch,AFF_FLYING)
                    || IS_AFFECTED(ch,AFF_HASTE))
                move /= 2;

            if (IS_AFFECTED(ch,AFF_SLOW))
                move *= 2;
        }

        if (!MOUNTED(ch) && ch->move < move)
        {
            char_act("You are too exhausted.", ch);
            return FALSE;
        }

        if (!MOUNTED(ch)
                && (ch->in_room->sector_type == SECT_DESERT || IS_WATER(ch->in_room)))
            WAIT_STATE(ch, 2+IS_AFFECTED(ch,AFF_SLOW)?2:0);
        else
            WAIT_STATE(ch, 1+IS_AFFECTED(ch,AFF_SLOW)?1:0);

        if (!MOUNTED(ch))
            ch->move -= move;
    }

    if (IS_ROOM_AFFECTED(in_room, RAFF_PROTECTION))
    {
        act ("You destroy the circle of protection guarded the room.", ch, NULL, NULL, TO_CHAR);
        act ("$n destroys the circle of protection guarded the room.", ch, NULL, NULL, TO_ROOM);
        affect_strip_room (in_room, sn_lookup ("circle of protection"));
    }

    if (IS_ROOM_AFFECTED(to_room, RAFF_PROTECTION))
    {
        int sn;
        AFFECT_DATA* paf;

        if ((sn = sn_lookup ("circle of protection")) != -1)
        {
            if ((paf = affect_find (to_room->affected, sn)) != NULL)
            {
                if (!is_safe_rspell_nom (paf->level, ch))
                {
                    // here we will deal with circle of protection
                    char_act("Powerful circle blocks your way.", ch);
                    WAIT_STATE (ch, PULSE_VIOLENCE);
                    if (--paf->modifier <= 0)
                    {
                        act ("You destroy the circle of protection guarded the room.", ch, NULL, NULL, TO_CHAR);
                        if (to_room->people != NULL)
                            act ("Someone destroys the circle of protection guarded the room.", to_room->people, NULL, NULL, TO_ALL);
                        affect_strip_room (to_room, sn);
                    }
                    return FALSE;
                }
            }
            else
                bug ("Bad paf for circle of protection", 0);
        }
        else
            bug ("Bad sn for circle of protection", 0);
    }

    if (!IS_AFFECTED(ch, AFF_SNEAK)
            && !IS_AFFECTED(ch, AFF_CAMOUFLAGE)
            && ch->invis_level < LEVEL_HERO)
        act_flags = TO_ROOM;
    else
        act_flags = TO_ROOM | ACT_NOMORTAL;

    if (!IS_NPC(ch)
            && ch->in_room->sector_type != SECT_INSIDE
            && ch->in_room->sector_type != SECT_CITY
            && number_percent() < get_skill(ch, gsn_quiet_movement)
            && !is_charge)
    {
        act(MOUNTED(ch) ? "$n leaves, riding on $N." :
            IS_AFFECTED(ch, AFF_FLYING) ? "$n flies away." : "$n leaves.",
            ch, NULL, MOUNTED(ch), act_flags);
        check_improve(ch,gsn_quiet_movement,TRUE,1);
    }
    else if (is_charge)
    {
        act("$n spurs $gn{his} $N, leaving $t.",
            ch, dir_name[door], ch->mount,  TO_ROOM | ACT_TRANS);
    }
    else
    {
        act(MOUNTED(ch) ? "$n leaves $t, riding on $N." :
            IS_AFFECTED(ch, AFF_FLYING) ? "$n flies away $t." :
            "$n leaves $t.",
            ch, dir_name[door], MOUNTED(ch), act_flags | ACT_TRANS);
    }

    if (IS_AFFECTED(ch, AFF_CAMOUFLAGE)
            &&  to_room->sector_type != SECT_FOREST
            &&  to_room->sector_type != SECT_MOUNTAIN
            &&  to_room->sector_type != SECT_HILLS)
    {
        REMOVE_BIT(ch->affected_by, AFF_CAMOUFLAGE);
        char_act("You step out from your cover.", ch);
        act_puts("$n steps out of the cover.", ch, NULL, NULL, TO_ROOM, POS_RESTING);
    }

    // room record for tracking
    if (!IS_NPC (ch) && ch->in_room)
        room_record (ch->name, in_room, door);

    // fishing stuff
    if ((IS_SET (ch->in_room->room_flags, ROOM_SALTWATER_FISH)
            || IS_SET (ch->in_room->room_flags, ROOM_FRESHWATER_FISH))
            && (IS_SET (ch->comm, COMM_FISHING) || IS_SET (ch->comm, COMM_FISH_ON)))
    {
        REMOVE_BIT (ch->comm, COMM_FISHING);
        REMOVE_BIT (ch->comm, COMM_FISH_ON);
        act("You pack up your fishing gear and move on.",
            ch , NULL, NULL, TO_CHAR);
    }

    mount = MOUNTED (ch);

    // move char from the source room
    // this removes riding flag from char
    char_from_room (ch);

    if (!IS_AFFECTED (ch, AFF_SNEAK)
            && ch->invis_level < LEVEL_IMMORTAL)
        act_flags = TO_ROOM ;
    else
        act_flags = TO_ROOM | ACT_NOMORTAL ;

    // move char to the destination room
    char_to_room (ch, to_room);

    if (!is_charge)
        act((mount && ch->mount) ? "$n has arrived, riding $N." : IS_AFFECTED (ch, AFF_FLYING) ? "$n has flown in." : "$n has arrived.", ch, NULL, mount, act_flags);

    if (!JUST_KILLED (ch))
        do_look (ch, "auto");

    // move horse to the room (this part has been moved to char_to_room ())
    // ch->mount can be resetted in raffects.c
    if (mount && ch->mount == mount)
    {
        char_from_room (mount);
        char_to_room   (mount, to_room);
        ch->riding     = TRUE ;
        mount->riding  = TRUE ;
    }
    else if (mount)
    {
        char_from_room (mount);
        char_to_room   (mount, to_room);
        ch->riding     = FALSE ;
        mount->riding  = FALSE ;
    }
    else
        ch->mount = NULL ;

    if (in_room == to_room) /* no circular follows */
        return TRUE ;

    if (!follow)
        for (fch = in_room->people ; fch != NULL ; fch = fch_next)
        {
            fch_next = fch->next_in_room ;

            if (fch->master != ch || fch->position != POS_STANDING
                    || !can_see_room (fch, to_room))
                continue ;

            if (IS_SET (ch->in_room->room_flags, ROOM_LAW) && IS_NPC (fch)
                    && IS_SET (fch->pIndexData->act, ACT_AGGRESSIVE))
            {
                act_puts("You can't bring $N into the city.", ch, NULL, fch, TO_CHAR, POS_DEAD);
                act("You aren't allowed in the city.", fch, NULL, NULL, TO_CHAR);
                continue ;
            }

            act_puts("You follow $N.", fch, NULL, ch, TO_CHAR, POS_DEAD);
            move_char (fch, door, TRUE);
        }

    if (JUST_KILLED (ch))
        return(is_charge && ch->mount == NULL ? FALSE : TRUE);

    room_has_pc = FALSE ;

    for (fch = to_room->people ; fch != NULL ; fch = fch_next)
    {
        fch_next = fch->next_in_room ;

        if (!IS_NPC (fch))
        {
            room_has_pc = TRUE ;
            break ;
        }
    }

    if (!room_has_pc)
        return(is_charge && ch->mount == NULL ? FALSE : TRUE);

    for (fch = to_room->people ; fch != NULL ; fch = fch_next)
    {
        fch_next = fch->next_in_room ;

        // greet progs for items carried by people in room
        for (obj = fch->carrying ; obj != NULL ; obj = obj_next)
        {
            obj_next = obj->next_content ;
            oprog_call (OPROG_GREET, obj, ch, NULL);
        }
    }

    // entry programs for items
    for (obj = ch->carrying ; obj != NULL ; obj = obj_next)
    {
        obj_next = obj->next_content ;
        oprog_call (OPROG_ENTRY, obj, NULL, NULL);
    }

    /*
     * If someone is following the char, these triggers get activated
     * for the followers before the char, but it's safer this way...
     */
    if (IS_NPC (ch) && HAS_TRIGGER_MOB (ch, TRIG_ENTRY) && !IS_AFFECTED(ch, AFF_CHARM))
        p_percent_trigger (ch, NULL, NULL, NULL, NULL, NULL, TRIG_ENTRY);

    if (!IS_NPC(ch))
    {
        p_greet_trigger(ch, PRG_MPROG);
        p_greet_trigger(ch, PRG_OPROG);
        p_greet_trigger(ch, PRG_RPROG);
    }


    for (obj = ch->in_room->contents ; obj != NULL ; obj = obj_next)
    {
        obj_next = obj->next_content ;
        oprog_call (OPROG_GREET, obj, ch, NULL);
    }

    for (obj = ch->in_room->contents; obj; obj= obj->next_content)
    {
        if (obj->pIndexData->vnum == OBJ_VNUM_MINE)
        {
            act_puts("You have successfully found $p! Yes!!!", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n has successfully found $p! Yes!!!", ch, obj, NULL, TO_ROOM);
            if (number_percent() < (50 - get_curr_stat(ch, STAT_LCK)))
                do_get(ch, "mine");
        }
        if (obj->pIndexData->vnum == OBJ_VNUM_FUNPILL)
        {
            act_puts("You have successfully found $p! Yes!!!", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n has successfully found $p! Yes!!!", ch, obj, NULL, TO_ROOM);
            if (number_percent() < (get_curr_stat(ch, STAT_LCK) * 3))
                do_sacrifice(ch, "funpill");
            else
            {
                do_get(ch, "funpill");
                do_eat(ch, "funpill");
            }
        }
    }

    return(is_charge && ch->mount == NULL ? FALSE : TRUE);
}



DO_FUN(do_north)
{
    move_char(ch, DIR_NORTH, FALSE);
}



DO_FUN(do_east)
{
    move_char(ch, DIR_EAST, FALSE);
}



DO_FUN(do_south)
{
    move_char(ch, DIR_SOUTH, FALSE);
}



DO_FUN(do_west)
{
    move_char(ch, DIR_WEST, FALSE);
}



DO_FUN(do_up)
{
    move_char(ch, DIR_UP, FALSE);
}



DO_FUN(do_down)
{
    move_char(ch, DIR_DOWN, FALSE);
}



int find_exit(CHAR_DATA *ch, char *arg)
{
    int door;

    if (!str_cmp(arg, "n")
            || !str_cmp(arg, "north")
            || !str_cmp(arg, "")
            || !str_cmp(arg, ""))
    {
        door = 0;
    }
    else if (!str_cmp(arg, "e")
             || !str_cmp(arg, "east")
             || !str_cmp(arg, "")
             || !str_cmp(arg, ""))
    {
        door = 1;
    }
    else if (!str_cmp(arg, "s")
             || !str_cmp(arg, "south")
             || !str_cmp(arg, "")
             || !str_cmp(arg, ""))
    {
        door = 2;
    }
    else if (!str_cmp(arg, "w")
             || !str_cmp(arg, "west")
             || !str_cmp(arg, "")
             || !str_cmp(arg, ""))
    {
        door = 3;
    }
    else if (!str_cmp(arg, "u")
             || !str_cmp(arg, "up")
             || !str_cmp(arg, "")
             || !str_cmp(arg, ""))
    {
        door = 4;
    }
    else if (!str_cmp(arg, "d")
             || !str_cmp(arg, "down")
             || !str_cmp(arg, "")
             || !str_cmp(arg, "")
             || !str_cmp(arg, "")
             || !str_cmp(arg, ""))
    {
        door = 5;
    }
    else
    {
        act_puts("I see no exit $T here.", ch, NULL, arg, TO_CHAR, POS_DEAD);
        return -1;
    }

    return door;
}


int find_door(CHAR_DATA *ch, char *arg)
{
    EXIT_DATA *pexit;
    int door;

    if (!str_cmp(arg, "n")
            || !str_cmp(arg, "north")
            || !str_cmp(arg, "")
            || !str_cmp(arg, ""))
    {
        door = 0;
    }
    else if (!str_cmp(arg, "e")
             || !str_cmp(arg, "east")
             || !str_cmp(arg, "")
             || !str_cmp(arg, ""))
    {
        door = 1;
    }
    else if (!str_cmp(arg, "s")
             || !str_cmp(arg, "south")
             || !str_cmp(arg, "")
             || !str_cmp(arg, ""))
    {
        door = 2;
    }
    else if (!str_cmp(arg, "w")
             || !str_cmp(arg, "west")
             || !str_cmp(arg, "")
             || !str_cmp(arg, ""))
    {
        door = 3;
    }
    else if (!str_cmp(arg, "u")
             || !str_cmp(arg, "up")
             || !str_cmp(arg, "")
             || !str_cmp(arg, ""))
    {
        door = 4;
    }
    else if (!str_cmp(arg, "d")
             || !str_cmp(arg, "down")
             || !str_cmp(arg, "")
             || !str_cmp(arg, "")
             || !str_cmp(arg, "")
             || !str_cmp(arg, ""))
    {
        door = 5;
    }
    else
    {
        for (door = 0; door <= 5; door++)
        {
            if ((pexit = ch->in_room->exit[door]) != NULL
                    &&   IS_SET(pexit->exit_info, EX_ISDOOR)
                    &&   pexit->keyword != NULL
                    &&   is_name(arg, pexit->keyword))
                return door;
        }
        act_puts("I see no $T here.", ch, NULL, arg, TO_CHAR, POS_DEAD);
        return -1;
    }

    if ((pexit = ch->in_room->exit[door]) == NULL)
    {
        act_puts("I see no door $T here.", ch, NULL, arg, TO_CHAR, POS_DEAD);
        return -1;
    }

    if (!IS_SET(pexit->exit_info, EX_ISDOOR))
    {
        char_act("You can't do that.", ch);
        return -1;
    }

    return door;
}

DO_FUN(do_open)
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int door;

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Open what?", ch);
        return;
    }

    if ((obj = get_obj_here(ch, arg)) != NULL)
    {
        /* open portal */
        if (obj->pIndexData->item_type == ITEM_PORTAL)
        {
            if (!IS_SET(obj->value[1], EX_ISDOOR))
            {
                char_act("You can't do that.", ch);
                return;
            }

            if (!IS_SET(obj->value[1], EX_CLOSED))
            {
                char_act("It's already open.", ch);
                return;
            }

            if (IS_SET(obj->value[1], EX_LOCKED))
            {
                char_act("It's locked.", ch);
                return;
            }

            REMOVE_BIT(obj->value[1], EX_CLOSED);
            act_puts("You open $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n opens $p.", ch, obj, NULL, TO_ROOM);
            return;
        }

        /* 'open object' */
        if (obj->pIndexData->item_type != ITEM_CONTAINER)
        {
            act_puts("$p not a container.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act("  .", ch);
        }
        if (!IS_SET(obj->value[1], CONT_CLOSED))
        {
            act_puts("$p already open.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act("  .", ch); return;
        }
        if (!IS_SET(obj->value[1], CONT_CLOSEABLE))
        {
            act_puts("You can't do that with $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act("    .", ch); return;
        }
        if (IS_SET(obj->value[1], CONT_LOCKED))
        {
            act_puts("$p locked.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act(".", ch); return;
        }

        REMOVE_BIT(obj->value[1], CONT_CLOSED);
        act_puts("You open $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        act("$n opens $p.", ch, obj, NULL, TO_ROOM);
        return;
    }

    if ((door = find_door(ch, arg)) >= 0)
    {
        /* 'open door' */
        ROOM_INDEX_DATA *to_room;
        EXIT_DATA *pexit;
        EXIT_DATA *pexit_rev;

        pexit = ch->in_room->exit[door];
        if (!IS_SET(pexit->exit_info, EX_CLOSED))
        {
            char_act("It's already open.", ch);
            return;
        }
        if ( IS_SET(pexit->exit_info, EX_LOCKED))
        {
            char_act("It's locked.", ch);
            return;
        }

        REMOVE_BIT(pexit->exit_info, EX_CLOSED);
        act("$n opens the $d.", ch, NULL, pexit->keyword, TO_ROOM);
        char_act("Ok.", ch);

        /* open the other side */
        if ((to_room   = pexit->to_room.r           ) != NULL
                &&   (pexit_rev = to_room->exit[rev_dir[door]]) != NULL
                &&   pexit_rev->to_room.r == ch->in_room)
        {
            ROOM_INDEX_DATA *in_room;

            REMOVE_BIT(pexit_rev->exit_info, EX_CLOSED);

            in_room = ch->in_room;
            ch->in_room = to_room;
            act("The $d opens.", ch, NULL, pexit_rev->keyword,
                TO_ROOM);
            ch->in_room = in_room;
        }
        return;
    }
}

DO_FUN(do_close)
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int door;

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Close what?", ch);
        return;
    }

    if ((obj = get_obj_here(ch, arg)) != NULL)
    {
        /* portal stuff */
        if (obj->pIndexData->item_type == ITEM_PORTAL)
        {

            if (!IS_SET(obj->value[1],EX_ISDOOR)
                    || IS_SET(obj->value[1],EX_NOCLOSE))
            {
                char_act("You can't do that.", ch);
                return;
            }

            if (IS_SET(obj->value[1],EX_CLOSED))
            {
                char_act("It's already closed.", ch);
                return;
            }

            SET_BIT(obj->value[1],EX_CLOSED);
            act_puts("You close $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n closes $p.", ch, obj, NULL, TO_ROOM);
            return;
        }

        /* 'close object' */
        if (obj->pIndexData->item_type != ITEM_CONTAINER)
        {
            act_puts("$p not a container.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act("  .", ch); return;
        }
        if (IS_SET(obj->value[1], CONT_CLOSED))
        {
            act_puts("$p already closed.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act("  .", ch); return;
        }
        if (!IS_SET(obj->value[1], CONT_CLOSEABLE))
        {
            act_puts("You can't do that with $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act("    .", ch); return;
        }

        SET_BIT(obj->value[1], CONT_CLOSED);
        act_puts("You close $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        act("$n closes $p.", ch, obj, NULL, TO_ROOM);
        return;
    }

    if ((door = find_door(ch, arg)) >= 0)
    {
        /* 'close door' */
        ROOM_INDEX_DATA *to_room;
        EXIT_DATA *pexit;
        EXIT_DATA *pexit_rev;

        pexit   = ch->in_room->exit[door];
        if (IS_SET(pexit->exit_info, EX_CLOSED))
        {
            char_act("It's already closed.", ch);
            return;
        }

        SET_BIT(pexit->exit_info, EX_CLOSED);
        act("$n closes $d.", ch, NULL, pexit->keyword, TO_ROOM);
        char_act("Ok.", ch);

        /* close the other side */
        if ((to_room   = pexit->to_room.r           ) != NULL
                &&   (pexit_rev = to_room->exit[rev_dir[door]]) != 0
                &&   pexit_rev->to_room.r == ch->in_room)
        {
            ROOM_INDEX_DATA *in_room;

            SET_BIT(pexit_rev->exit_info, EX_CLOSED);
            in_room = ch->in_room;
            ch->in_room = to_room;
            act("The $d closes.", ch, NULL, pexit_rev->keyword, TO_ROOM);
            ch->in_room = in_room;
        }
        return;
    }
}

/*
 * Added can_see check. Kio.
 */
/*
bool has_key(CHAR_DATA *ch, int key)
{
    OBJ_DATA *obj;

    for (obj = ch->carrying; obj; obj = obj->next_content)
        if (obj->pIndexData->vnum == key   &&  can_see_obj(ch, obj))
            return TRUE;

    return FALSE;
}

*/

bool has_key( CHAR_DATA *ch, int key )
{
    OBJ_DATA *obj;
    KEY_DATA *keys;

    for ( obj = ch->carrying; obj != NULL; obj = obj->next_content )
    {
      if ( obj->pIndexData->vnum == key &&  can_see_obj(ch, obj))
          return TRUE;
    }

    // look for the keyring in players inventory
    obj = find_keyring(ch);

    // no keyring found ?
    if (!obj) return FALSE;

    // loop thru the keys on keyring and see if there is a matching key
    for (keys = obj->keys; keys != NULL; keys = keys->next)
    {
      if ( keys->index->vnum == key )
      {
          char_act("After some searching of your keyring, you found a key that seems to fit the lock.", ch);
          return TRUE;
      }
    }

    // no keys found
    return FALSE;
}

bool has_key_ground(CHAR_DATA *ch, int key)
{
    OBJ_DATA *obj;

    for (obj = ch->in_room->contents; obj; obj = obj->next_content)
        if (obj->pIndexData->vnum == key
                &&  can_see_obj(ch, obj))
            return TRUE;

    return FALSE;
}

DO_FUN(do_lock)
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int door;

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Lock what?", ch);
        return;
    }

    if ((obj = get_obj_here(ch, arg)) != NULL)
    {
        /* portal stuff */
        if (obj->pIndexData->item_type == ITEM_PORTAL)
        {
            if (!IS_SET(obj->value[1], EX_ISDOOR)
                    ||  IS_SET(obj->value[1], EX_NOCLOSE))
            {
                char_act("You can't do that.", ch);
                return;
            }
            if (!IS_SET(obj->value[1], EX_CLOSED))
            {
                char_act("It's not closed.", ch);
                return;
            }

            if (obj->value[4] < 0 || IS_SET(obj->value[1], EX_NOLOCK))
            {
                char_act("It can't be locked.", ch);
                return;
            }

            if (!has_key(ch, obj->value[4]))
            {
                char_act("You lack the key.", ch);
                return;
            }

            if (IS_SET(obj->value[1], EX_LOCKED))
            {
                char_act("It's already locked.", ch);
                return;
            }

            SET_BIT(obj->value[1], EX_LOCKED);
            act_puts("You lock $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n locks $p.", ch, obj, NULL, TO_ROOM);
            return;
        }

        /* 'lock object' */
        if (obj->pIndexData->item_type != ITEM_CONTAINER)
        {
            act_puts("$p not a container.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act("  .", ch); return;
        }
        if (!IS_SET(obj->value[1], CONT_CLOSED))
        {
            act_puts("$p not closed.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act("  .", ch); return;
        }
        if (obj->value[2] < 0)
        {
            act_puts("$p can't be locked.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act("  .", ch); return;
        }
        if (!has_key(ch, obj->value[2]))
        {
            act_puts("You lack the key from $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act("   .", ch); return;
        }
        if (IS_SET(obj->value[1], CONT_LOCKED))
        {
            act_puts("$p already locked.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act("  .", ch); return;
        }

        SET_BIT(obj->value[1], CONT_LOCKED);
        act_puts("You lock $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        act("$n locks $p.", ch, obj, NULL, TO_ROOM);
        return;
    }

    if ((door = find_door(ch, arg)) >= 0)
    {
        /* 'lock door' */
        ROOM_INDEX_DATA *to_room;
        EXIT_DATA *pexit;
        EXIT_DATA *pexit_rev;

        pexit   = ch->in_room->exit[door];
        if (!IS_SET(pexit->exit_info, EX_CLOSED))
        {
            char_act("It's not closed.", ch);
            return;
        }
        if (pexit->key < 0)
        {
            char_act("It can't be locked.", ch);
            return;
        }
        if (!has_key(ch, pexit->key)
                && !has_key_ground(ch, pexit->key))
        {
            char_act("You lack the key.", ch);
            return;
        }
        if (IS_SET(pexit->exit_info, EX_LOCKED))
        {
            char_act("It's already locked.", ch);
            return;
        }

        SET_BIT(pexit->exit_info, EX_LOCKED);
        char_act("*Click*", ch);
        act("$n locks the $d.", ch, NULL, pexit->keyword, TO_ROOM);

        /* lock the other side */
        if ((to_room   = pexit->to_room.r           ) != NULL
                &&   (pexit_rev = to_room->exit[rev_dir[door]]) != 0
                &&   pexit_rev->to_room.r == ch->in_room)
        {
            ROOM_INDEX_DATA *in_room;

            SET_BIT(pexit_rev->exit_info, EX_LOCKED);

            in_room = ch->in_room;
            ch->in_room = to_room;
            act("The $d clicks.",
                ch, NULL, pexit_rev->keyword, TO_ROOM);
            ch->in_room  = in_room;
        }
        return;
    }
}

DO_FUN(do_unlock)
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int door;

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Unlock what?", ch);
        return;
    }

    if ((obj = get_obj_here(ch, arg)) != NULL)
    {
        /* portal stuff */
        if (obj->pIndexData->item_type == ITEM_PORTAL)
        {
            if (IS_SET(obj->value[1],EX_ISDOOR))
            {
                char_act("You can't do that.", ch);
                return;
            }

            if (!IS_SET(obj->value[1],EX_CLOSED))
            {
                char_act("It's not closed.", ch);
                return;
            }

            if (obj->value[4] < 0)
            {
                char_act("It can't be unlocked.", ch);
                return;
            }

            if (!has_key(ch, obj->value[4]))
            {
                char_act("You lack the key.", ch);
                return;
            }

            if (!IS_SET(obj->value[1], EX_LOCKED))
            {
                char_act("It's already unlocked.", ch);
                return;
            }

            REMOVE_BIT(obj->value[1], EX_LOCKED);
            act_puts("You unlock $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n unlocks $p.", ch, obj, NULL, TO_ROOM);
            return;
        }

        /* 'unlock object' */
        if (obj->pIndexData->item_type != ITEM_CONTAINER)
        {
            act_puts("$p not a container.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act("  .", ch); return;
        }
        if (!IS_SET(obj->value[1], CONT_CLOSED))
        {
            act_puts("$p not closed.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act("  .", ch); return;
        }
        if (obj->value[2] < 0)
        {
            act_puts("$p can't be unlocked.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act("  .", ch); return;
        }
        if (!has_key(ch, obj->value[2]))
        {
            act_puts("You lack the key from $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act("   .", ch); return;
        }
        if (!IS_SET(obj->value[1], CONT_LOCKED))
        {
            act_puts("$p already unlocked.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act("  .", ch); return;
        }

        REMOVE_BIT(obj->value[1], CONT_LOCKED);
        act_puts("You unlock $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        act("$n unlocks $p.", ch, obj, NULL, TO_ROOM);
        return;
    }

    if ((door = find_door(ch, arg)) >= 0)
    {
        /* 'unlock door' */
        ROOM_INDEX_DATA *to_room;
        EXIT_DATA *pexit;
        EXIT_DATA *pexit_rev;

        pexit = ch->in_room->exit[door];

        if (!IS_SET(pexit->exit_info, EX_CLOSED))
        {
            char_act("It's not closed.", ch);
            return;
        }
        if (pexit->key < 0)
        {
            char_act("It can't be unlocked.", ch);
            return;
        }
        if (!has_key(ch, pexit->key) &&
                !has_key_ground(ch, pexit->key))
        {
            char_act("You lack the key.", ch);
            return;
        }
        if (!IS_SET(pexit->exit_info, EX_LOCKED))
        {
            char_act("It's already unlocked.", ch);
            return;
        }

        REMOVE_BIT(pexit->exit_info, EX_LOCKED);
        char_act("*Click*", ch);
        act("$n unlocks the $d.", ch, NULL, pexit->keyword, TO_ROOM);

        /* unlock the other side */
        if ((to_room   = pexit->to_room.r           ) != NULL
                &&   (pexit_rev = to_room->exit[rev_dir[door]]) != NULL
                &&   pexit_rev->to_room.r == ch->in_room)
        {
            ROOM_INDEX_DATA *in_room;

            REMOVE_BIT(pexit_rev->exit_info, EX_LOCKED);

            in_room = ch->in_room;
            ch->in_room = to_room;
            act("The $d clicks.",
                ch, NULL, pexit_rev->keyword, TO_ROOM);
            ch->in_room = in_room;
        }
        return;
    }
}

DO_FUN(do_pick)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *gch;
    OBJ_DATA *obj;
    int door;
    int chance;
    //FIXME: EVENT *e;

    if ((chance = get_skill(ch, gsn_pick)) == 0)
    {
        char_act("Huh?", ch);
        return;
    }

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Pick what?", ch);
        return;
    }

    if (IS_SET(muddy_mode, MUDDY_EVENTS))
        create_char_event(ch, evn_char_test, 10);//Test nafig

    if (MOUNTED(ch))
    {
        char_act("You can't pick while mounted.", ch);
        return;
    }

    WAIT_STATE(ch, SKILL(gsn_pick)->beats);

    /* look for guards */
    for (gch = ch->in_room->people; gch; gch = gch->next_in_room)
    {
        if (IS_NPC(gch)
                && IS_AWAKE(gch)
                && ch->level + 5 < gch->level)
        {
            act("$N is standing too close to lock.", ch, NULL, gch, TO_CHAR);
            return;
        }
    }

    if (!IS_NPC(ch) && number_percent() > chance)
    {
        char_act("You failed.", ch);
        check_improve(ch, gsn_pick, FALSE, 2);
        return;
    }

    if ((obj = get_obj_here(ch, arg)) != NULL)
    {
        /* portal stuff */
        if (obj->pIndexData->item_type == ITEM_PORTAL)
        {
            if (!IS_SET(obj->value[1],EX_ISDOOR))
            {
                char_act("You can't do that.", ch);
                return;
            }

            if (!IS_SET(obj->value[1],EX_CLOSED))
            {
                char_act("It's not closed.", ch);
                return;
            }

            if (obj->value[4] < 0)
            {
                char_act("It can't be unlocked.", ch);
                return;
            }

            if (IS_SET(obj->value[1],EX_PICKPROOF))
            {
                char_act("You failed.", ch);
                return;
            }

            REMOVE_BIT(obj->value[1],EX_LOCKED);
            act_puts("You pick the lock on $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n picks the lock on $p.", ch, obj, NULL, TO_ROOM);
            check_improve(ch, gsn_pick, TRUE, 2);
            return;
        }

        /* 'pick object' */
        if (obj->pIndexData->item_type != ITEM_CONTAINER)
        {
            act_puts("$p not a container.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act("  .", ch); return;
        }
        if (!IS_SET(obj->value[1], CONT_CLOSED))
        {
            act_puts("$p not closed.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act(" .", ch); return;
        }
        if (obj->value[2] < 0)
        {
            act_puts("$p can't be unlocked.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act("  .", ch); return;
        }
        if (!IS_SET(obj->value[1], CONT_LOCKED))
        {
            act_puts("$p already unlocked.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
            //            char_act("  .", ch); return;
        }
        if (IS_SET(obj->value[1], CONT_PICKPROOF))
        {
            char_act("You failed.", ch);
            return;
        }

        REMOVE_BIT(obj->value[1], CONT_LOCKED);
        act_puts("You pick the lock on $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        act("$n picks the lock on $p.", ch, obj, NULL, TO_ROOM);
        check_improve(ch, gsn_pick, TRUE, 2);
        return;
    }

    if ((door = find_door(ch, arg)) >= 0)
    {
        /* 'pick door' */
        ROOM_INDEX_DATA *to_room;
        EXIT_DATA *pexit;
        EXIT_DATA *pexit_rev;

        pexit = ch->in_room->exit[door];
        if (!IS_SET(pexit->exit_info, EX_CLOSED) && !IS_IMMORTAL(ch))
        {
            char_act("It's not closed.", ch);
            return;
        }
        if (pexit->key < 0 && !IS_IMMORTAL(ch))
        {
            char_act("It can't be picked.", ch);
            return;
        }
        if (!IS_SET(pexit->exit_info, EX_LOCKED))
        {
            char_act("It's already unlocked.", ch);
            return;
        }
        if (IS_SET(pexit->exit_info, EX_PICKPROOF) && !IS_IMMORTAL(ch))
        {
            char_act("You failed.", ch);
            return;
        }

        REMOVE_BIT(pexit->exit_info, EX_LOCKED);
        char_act("*Click*", ch);
        act("$n picks the $d.", ch, NULL, pexit->keyword, TO_ROOM);
        check_improve(ch, gsn_pick, TRUE, 2);

        /* pick the other side */
        if ((to_room   = pexit->to_room.r           ) != NULL
                &&   (pexit_rev = to_room->exit[rev_dir[door]]) != NULL
                &&   pexit_rev->to_room.r == ch->in_room)
            REMOVE_BIT(pexit_rev->exit_info, EX_LOCKED);
    }
}

DO_FUN(do_stand)
{
    OBJ_DATA *obj = NULL;

    if (argument[0] != '\0')
    {
        if (ch->position == POS_FIGHTING)
        {
            char_act("Maybe you should finish fighting first?", ch);
            return;
        }
        obj = get_obj_list(ch,argument,ch->in_room->contents);
        if (obj == NULL)
        {
            char_act("You don't see that here.", ch);
            return;
        }
        if (obj->pIndexData->item_type != ITEM_FURNITURE
                || (!IS_SET(obj->value[2],STAND_AT)
                    && !IS_SET(obj->value[2],STAND_ON)
                    && !IS_SET(obj->value[2],STAND_IN)))
        {
            char_act("You can't seem to find a place to stand.", ch);
            return;
        }
        if (ch->on != obj && count_users(obj) >= obj->value[0])
        {
            act_puts("There's no room to stand on $p.",
                     ch, obj, NULL, TO_ROOM, POS_DEAD);
            return;
        }
    }
    switch (ch->position)
    {
    case POS_SLEEPING:
        if (IS_AFFECTED(ch, AFF_SLEEP))
        {
            char_act("You can't wake up!", ch);
            return;
        }

        if (obj == NULL)
        {
            char_act("You wake and stand up.", ch);
            act("$n wakes and stands up.", ch, NULL, NULL, TO_ROOM);

            ch->on = NULL;
        }
        else if (IS_SET(obj->value[2],STAND_AT))
        {
            act_puts("You wake and stand at $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n wakes and stands at $p.", ch, obj, NULL, TO_ROOM);

        }
        else if (IS_SET(obj->value[2],STAND_ON))
        {
            act_puts("You wake and stand on $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n wakes and stands on $p.", ch, obj, NULL, TO_ROOM);
        }
        else
        {
            act_puts("You wake and stand in $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n wakes and stands in $p.", ch, obj, NULL, TO_ROOM);
        }

        ch->position = POS_STANDING;
        do_look(ch,"auto");
        break;

    case POS_RESTING:
    case POS_SITTING:
        if (obj == NULL)
        {
            char_act("You stand up.", ch);
            act("$n stands up.", ch, NULL, NULL, TO_ROOM);
            ch->on = NULL;
        }
        else if (IS_SET(obj->value[2],STAND_AT))
        {
            act_puts("You stand at $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n stands at $p.", ch, obj, NULL, TO_ROOM);
        }
        else if (IS_SET(obj->value[2],STAND_ON))
        {
            act_puts("You stand on $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n stands on $p.", ch, obj, NULL, TO_ROOM);
        }
        else
        {
            act_puts("You stand in $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n stands in $p.", ch, obj, NULL, TO_ROOM);
        }
        ch->position = POS_STANDING;
        break;

    case POS_STANDING:
        char_act("You are already standing.", ch);
        break;

    case POS_FIGHTING:
        char_act("You are already fighting!", ch);
        break;
    }

    if (IS_HARA_KIRI(ch))
    {
        char_act("You feel your blood heats your body.", ch);
        REMOVE_BIT(ch->plr_flags, PLR_HARA_KIRI);
    }
}

DO_FUN(do_rest)
{
    OBJ_DATA *obj = NULL;

    if (ch->position == POS_FIGHTING)
    {
        char_act("You are already fighting!", ch);
        return;
    }

    if (MOUNTED(ch))
    {
        char_act("You can't rest while mounted.", ch);
        return;
    }

    if (RIDDEN(ch))
    {
        char_act("You can't rest while being ridden.", ch);
        return;
    }

    if (IS_AFFECTED(ch, AFF_SLEEP))
    {
        char_act("You are already sleeping.", ch);
        return;
    }

    /* okay, now that we know we can rest, find an object to rest on */
    if (argument[0] != '\0')
    {
        obj = get_obj_list(ch,argument,ch->in_room->contents);
        if (obj == NULL)
        {
            char_act("You don't see that here.", ch);
            return;
        }
    }
    else
        obj = ch->on;

    if (obj != NULL)
    {
        if (obj->pIndexData->item_type != ITEM_FURNITURE
                ||  (!IS_SET(obj->value[2],REST_ON) &&
                     !IS_SET(obj->value[2],REST_IN) &&
                     !IS_SET(obj->value[2],REST_AT)))
        {
            char_act("You can't rest on that.", ch);
            return;
        }

        if (obj != NULL && ch->on != obj
                &&  count_users(obj) >= obj->value[0])
        {
            act_puts("There's no more room on $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
        }

        ch->on = obj;
        if (HAS_TRIGGER_OBJ(obj, TRIG_SIT))
            p_percent_trigger( NULL, obj, NULL, ch, NULL, NULL, TRIG_SIT );
    }

    switch (ch->position)
    {
    case POS_SLEEPING:
        if (obj == NULL)
        {
            char_act("You wake up and start resting.", ch);
            act("$n wakes up and starts resting.",
                ch, NULL, NULL, TO_ROOM);

        }
        else if (IS_SET(obj->value[2],REST_AT))
        {
            act_puts("You wake up and rest at $p.",
                     ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n wakes up and rests at $p.",
                ch, obj, NULL, TO_ROOM);
        }
        else if (IS_SET(obj->value[2],REST_ON))
        {
            act_puts("You wake up and rest on $p.",
                     ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n wakes up and rests on $p.",
                ch, obj, NULL, TO_ROOM);
        }
        else
        {
            act_puts("You wake up and rest in $p.",
                     ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n wakes up and rests in $p.",
                ch, obj, NULL, TO_ROOM);
        }
        ch->position = POS_RESTING;
        break;

    case POS_RESTING:
        char_act("You are already resting.", ch);
        break;

    case POS_STANDING:
        if (obj == NULL)
        {
            char_act("You rest.", ch);
            act("$n sits down and rests.", ch, NULL, NULL, TO_ROOM);
        }
        else if (IS_SET(obj->value[2], REST_AT))
        {
            act_puts("You sit down at $p and rest.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n sits down at $p and rests.", ch, obj, NULL, TO_ROOM);
        }
        else if (IS_SET(obj->value[2], REST_ON))
        {
            act_puts("You sit down on $p and rest.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n sits down on $p and rests.", ch, obj, NULL, TO_ROOM);
        }
        else
        {
            act_puts("You sit down in $p and rest.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n sits down in $p and rests.", ch, obj, NULL, TO_ROOM);
        }
        ch->position = POS_RESTING;
        break;

    case POS_SITTING:
        if (obj == NULL)
        {
            char_act("You rest.", ch);
            act("$n rests.", ch, NULL, NULL, TO_ROOM);
        }
        else if (IS_SET(obj->value[2],REST_AT))
        {
            act_puts("You rest at $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n rests at $p.", ch, obj, NULL, TO_ROOM);
        }
        else if (IS_SET(obj->value[2],REST_ON))
        {
            act_puts("You rest on $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n rests on $p.", ch, obj, NULL, TO_ROOM);
        }
        else
        {
            act_puts("You rest in $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n rests in $p.", ch, obj, NULL, TO_ROOM);
        }
        ch->position = POS_RESTING;
        break;
    }

    if (IS_HARA_KIRI(ch))
    {
        char_act("You feel your blood heats your body.", ch);
        REMOVE_BIT(ch->plr_flags, PLR_HARA_KIRI);
    }
}

DO_FUN(do_sit)
{
    OBJ_DATA *obj = NULL;

    if (ch->position == POS_FIGHTING)
    {
        char_act("Maybe you should finish fighting first?", ch);
        return;
    }

    if (MOUNTED(ch))
    {
        char_act("You can't sit while mounted.", ch);
        return;
    }

    if (RIDDEN(ch))
    {
        char_act("You can't sit while being ridden.", ch);
        return;
    }

    if (IS_AFFECTED(ch, AFF_SLEEP))
    {
        char_act("You are already sleeping.", ch);
        return;
    }

    /* okay, now that we know we can sit, find an object to sit on */
    if (argument[0] != '\0')
    {
        obj = get_obj_list(ch,argument,ch->in_room->contents);
        if (obj == NULL)
        {
            char_act("You don't see that here.", ch);
            return;
        }
    }
    else
        obj = ch->on;

    if (obj != NULL)
    {
        if (obj->pIndexData->item_type != ITEM_FURNITURE
                ||  (!IS_SET(obj->value[2],SIT_ON)
                     &&   !IS_SET(obj->value[2],SIT_IN)
                     &&   !IS_SET(obj->value[2],SIT_AT)))
        {
            char_act("You can't sit on that.", ch);
            return;
        }

        if (obj != NULL &&  ch->on != obj &&  count_users(obj) >= obj->value[0])
        {
            act_puts("There's no more room on $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
        }

        ch->on = obj;

        if (HAS_TRIGGER_OBJ(obj, TRIG_SIT))
            p_percent_trigger( NULL, obj, NULL, ch, NULL, NULL, TRIG_SIT );
    }

    switch (ch->position)
    {
    case POS_SLEEPING:
        if (obj == NULL)
        {
            char_act("You wake and sit up.", ch);
            act("$n wakes and sits up.", ch, NULL, NULL, TO_ROOM);
        }
        else if (IS_SET(obj->value[2],SIT_AT))
        {
            act_puts("You wake and sit at $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n wakes and sits at $p.", ch, obj, NULL, TO_ROOM);
        }
        else if (IS_SET(obj->value[2],SIT_ON))
        {
            act_puts("You wake and sit on $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n wakes and sits on $p.", ch, obj, NULL, TO_ROOM);
        }
        else
        {
            act_puts("You wake and sit in $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n wakes and sits in $p.", ch, obj, NULL, TO_ROOM);
        }

        ch->position = POS_SITTING;
        break;

    case POS_RESTING:
        if (obj == NULL)
            char_act("You stop resting.", ch);
        else if (IS_SET(obj->value[2],SIT_AT))
        {
            act_puts("You sit at $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n sits at $p.", ch, obj, NULL, TO_ROOM);
        }
        else if (IS_SET(obj->value[2],SIT_ON))
        {
            act_puts("You sit on $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n sits on $p.", ch, obj, NULL, TO_ROOM);
        }
        else
        {
            act_puts("You sit in $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n sits in $p.", ch, obj, NULL, TO_ROOM);
        }
        ch->position = POS_SITTING;
        break;

    case POS_SITTING:
        char_act("You are already sitting down.", ch);
        break;

    case POS_STANDING:
        if (obj == NULL)
        {
            char_act("You sit down.", ch);
            act("$n sits down on the ground.", ch, NULL, NULL, TO_ROOM);
        }
        else if (IS_SET(obj->value[2], SIT_AT))
        {
            act_puts("You sit down at $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n sits down at $p.", ch, obj, NULL, TO_ROOM);
        }
        else if (IS_SET(obj->value[2],SIT_ON))
        {
            act_puts("You sit down on $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n sits down on $p.", ch, obj, NULL, TO_ROOM);
        }
        else
        {
            act_puts("You sit down in $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            act("$n sits down in $p.", ch, obj, NULL, TO_ROOM);
        }
        ch->position = POS_SITTING;
        break;
    }

    if (IS_HARA_KIRI(ch))
    {
        char_act("You feel your blood heats your body.", ch);
        REMOVE_BIT(ch->plr_flags, PLR_HARA_KIRI);
    }
}

DO_FUN(do_sleep)
{
    OBJ_DATA *obj = NULL;

    if (MOUNTED(ch))
    {
        char_act("You can't sleep while mounted.", ch);
        return;
    }

    if (RIDDEN(ch))
    {
        char_act("You can't sleep while being ridden.", ch);
        return;
    }

    if (is_affected (ch, gsn_insomnia))
    {
        char_act("But you can't sleep!", ch);
        return;
    }

    if (ch->class == CLASS_VAMPIRE)
    {
        if ( weather_info.sunlight != SUN_LIGHT && weather_info.sunlight != SUN_RISE)
        {
            act("Vampire sleeps at daytime!", ch, NULL, NULL, TO_CHAR);
            return;
        }
    }
    else if (IS_UNDEAD(ch))
    {
        act("You are undead and can't sleep.", ch, NULL, NULL, TO_CHAR);
        return;
    }
    switch (ch->position)
    {
    case POS_SLEEPING:
        char_act("You are already sleeping.", ch);
        break;

    case POS_RESTING:
    case POS_SITTING:
    case POS_STANDING:
        if (argument[0] == '\0' && ch->on == NULL)
        {
            char_act("You go to sleep.", ch);
            act("$n goes to sleep.", ch, NULL, NULL, TO_ROOM);
        }
        else
        { /* find an object and sleep on it */
            if (argument[0] == '\0')
                obj = ch->on;
            else
                obj = get_obj_list(ch, argument, ch->in_room->contents);

            if (obj == NULL)
            {
                char_act("You don't see that here.", ch);
                return;
            }

            if (obj->pIndexData->item_type != ITEM_FURNITURE
                    || (!IS_SET(obj->value[2], SLEEP_ON)
                        && !IS_SET(obj->value[2],SLEEP_IN)
                        && !IS_SET(obj->value[2],SLEEP_AT)))
            {
                char_act("You can't sleep on that.", ch);
                return;
            }

            if (ch->on != obj &&  count_users(obj) >= obj->value[0])
            {
                act_puts("There's no room on $p for you.",
                         ch, obj, NULL, TO_CHAR, POS_DEAD);
                return;
            }

            ch->on = obj;

            if (HAS_TRIGGER_OBJ(obj, TRIG_SIT))
                p_percent_trigger( NULL, obj, NULL, ch, NULL, NULL, TRIG_SIT );

            if (IS_SET(obj->value[2], SLEEP_AT))
            {
                act_puts("You go to sleep at $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
                act("$n goes to sleep at $p.", ch, obj, NULL, TO_ROOM);
            }
            else if (IS_SET(obj->value[2], SLEEP_ON))
            {
                act_puts("You go to sleep on $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
                act("$n goes to sleep on $p.", ch, obj, NULL, TO_ROOM);
            }
            else
            {
                act_puts("You go to sleep in $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
                act("$n goes to sleep in $p.", ch, obj, NULL, TO_ROOM);
            }
        }
        ch->position = POS_SLEEPING;
        break;

    case POS_FIGHTING:
        char_act("You are already fighting.", ch);
        break;
    }
}

DO_FUN(do_wake)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        do_stand(ch, argument);
        return;
    }

    if (!IS_AWAKE(ch))
    {
        char_act("You are asleep yourself!", ch);
        return;
    }

    if ((victim = get_char_room(ch, arg)) == NULL)
    {
        char_act("They aren't here.", ch);
        return;
    }

    if (IS_AWAKE(victim))
    {
        act_puts("$N is already awake.", ch, NULL, victim, TO_CHAR, POS_DEAD);
        return;
    }

    if (IS_AFFECTED(victim, AFF_SLEEP))
    {
        act_puts("You can't wake $gN{him}!", victim, NULL, ch, TO_VICT, POS_DEAD);
        return;
    }

    act_puts("$n wakes you.", ch, NULL, victim, TO_VICT, POS_SLEEPING);
    do_stand(victim, str_empty);
    return;
}

DO_FUN(do_sneak)
{
    AFFECT_DATA af;
    int     chance;

    if ((chance = get_skill(ch, gsn_sneak)) == 0)
    {
        char_act("Huh?", ch);
        return;
    }

    if (MOUNTED(ch))
    {
        char_act("You can't sneak while mounted.", ch);
        return;
    }

    char_act("You attempt to move silently.", ch);
    affect_strip(ch, gsn_sneak);

    if (IS_AFFECTED(ch, AFF_SNEAK))
        return;

    if (number_percent() < chance)
    {
        check_improve(ch, gsn_sneak, TRUE, 3);
        af.where     = TO_AFFECTS;
        af.type      = gsn_sneak;
        af.level     = LVL(ch);
        af.duration  = LVL(ch);
        af.location  = APPLY_NONE;
        af.modifier  = 0;
        af.bitvector = AFF_SNEAK;
        affect_to_char(ch, &af);
    }
    else
        check_improve(ch, gsn_sneak, FALSE, 3);
}

DO_FUN(do_hide)
{
    int chance;
    flag32_t sector;

    if ((chance = get_skill(ch, gsn_hide)) == 0)
    {
        char_act("Huh?", ch);
        return;
    }

    if (MOUNTED(ch))
    {
        char_act("You can't hide while mounted.", ch);
        return;
    }

    if (RIDDEN(ch))
    {
        char_act("You can't hide while being ridden.", ch);
        return;
    }

    if (IS_AFFECTED(ch, AFF_FAERIE_FIRE))
    {
        char_act("You cannot hide while glowing.", ch);
        return;
    }

    char_act("You attempt to hide.", ch);

    sector = ch->in_room->sector_type;
    if (sector == SECT_FOREST
            || sector == SECT_HILLS
            || sector == SECT_MOUNTAIN)
        chance += 15;
    else if (sector == SECT_CITY)
        chance -= 15;

    if (number_percent() < chance)
    {
        SET_BIT(ch->affected_by, AFF_HIDE);
        check_improve(ch, gsn_hide, TRUE, 3);
    }
    else
    {
        REMOVE_BIT(ch->affected_by, AFF_HIDE);
        check_improve(ch, gsn_hide, FALSE, 3);
    }
}

DO_FUN(do_camouflage)
{
    int     sn;
    int     chance;
    flag32_t     sector;

    if ((sn = sn_lookup("camouflage")) < 0
            ||  (chance = get_skill(ch, sn)) == 0)
    {
        char_act("You don't know how to camouflage yourself.", ch);
        return;
    }

    if (MOUNTED(ch))
    {
        char_act("You can't camouflage while mounted.", ch);
        return;
    }

    if (RIDDEN(ch))
    {
        char_act("You can't camouflage while being ridden.", ch);
        return;
    }

    if (IS_AFFECTED(ch, AFF_FAERIE_FIRE))
    {
        char_act("You can't camouflage yourself while glowing.", ch);
        return;
    }

    sector = ch->in_room->sector_type;
    if (sector != SECT_FOREST
            && sector != SECT_HILLS
            && sector != SECT_MOUNTAIN)
    {
        char_act("There's no cover here.", ch);
        act("$n tries to camouflage $gn{himself} against the lone leaf on the ground.",
            ch, NULL, NULL, TO_ROOM);
        return;
    }

    char_act("You attempt to camouflage yourself.", ch);
    WAIT_STATE(ch, SKILL(sn)->beats);

    if (IS_AFFECTED(ch, AFF_CAMOUFLAGE))
        REMOVE_BIT(ch->affected_by, AFF_CAMOUFLAGE);

    if (IS_NPC(ch) || number_percent() < chance)
    {
        SET_BIT(ch->affected_by, AFF_CAMOUFLAGE);
        check_improve(ch, sn, TRUE, 1);
    }
    else
        check_improve(ch, sn, FALSE, 1);
}

DO_FUN(do_trap)
{
    int chance;

    if ((chance = get_skill(ch, gsn_trap)) == 0)
    {
        char_act("Huh?", ch);
        return;
    }

    if (IS_PUMPED(ch))
    {
        char_act("You can't trap while pumped.", ch);
        return;
    }

    if (MOUNTED(ch))
    {
        char_act("You can't trap while mounted.", ch);
        return;
    }

    if (RIDDEN(ch))
    {
        char_act("You can't trap while being ridden.", ch);
        return;
    }

    if (IS_AFFECTED(ch, AFF_FAERIE_FIRE))
    {
        char_act("You can't trap while glowing.", ch);
        return;
    }

    if (IS_AFFECTED(ch, AFF_TRAP))
    {
        char_act("You are in trap!", ch);
        return;
    }

    if (number_percent() < chance)
    {
        SET_BIT(ch->affected_by, AFF_TRAP);
        char_act("You trap.", ch);
        check_improve(ch, gsn_trap, TRUE, 3);
    }
    else
    {
        REMOVE_BIT(ch->affected_by, AFF_TRAP);
        char_act("You attempt to trap.", ch);
        check_improve(ch, gsn_trap, FALSE, 3);
    }
}

/*
 * Contributed by Alander
 */
DO_FUN(do_visible)
{
    if (IS_AFFECTED(ch, AFF_SLEEP))
    {
        char_act(" .", ch);
        return;
    }
    if (IS_AFFECTED(ch, AFF_HIDE | AFF_FADE | AFF_TRAP))
    {
        char_act("You step out of shadows.", ch);
        REMOVE_BIT(ch->affected_by, AFF_HIDE | AFF_FADE | AFF_TRAP);
        act_puts("$n steps out of shadows.", ch, NULL, NULL, TO_ROOM, POS_RESTING);
    }

    if (is_affected(ch, gsn_stealth))
    {
        affect_strip(ch, gsn_stealth);
        char_act("   .", ch);
    }

    if (IS_AFFECTED(ch, AFF_CAMOUFLAGE))
    {
        char_act("You step out from your cover.", ch);
        REMOVE_BIT(ch->affected_by, AFF_CAMOUFLAGE);
        act_puts("$n steps out of the cover.", ch, NULL, NULL, TO_ROOM, POS_RESTING);
    }

    if (IS_AFFECTED(ch, AFF_INVIS | AFF_IMP_INVIS))
    {
        char_act("You fade into existence.", ch);
        affect_bit_strip(ch, TO_AFFECTS, AFF_INVIS | AFF_IMP_INVIS);
        REMOVE_BIT(ch->affected_by, AFF_INVIS | AFF_IMP_INVIS);
        act("$n fades into existence.", ch, NULL, NULL, TO_ROOM);
    }

    if (IS_AFFECTED(ch, AFF_EARTHFADE))
    {
        affect_bit_strip(ch, TO_AFFECTS, AFF_EARTHFADE);
        WAIT_STATE(ch, PULSE_VIOLENCE * 2);
        act("You fade to your neutral form.", ch, NULL, NULL, TO_CHAR);
        act("Earth forms $n in front of you.", ch, NULL, NULL, TO_ROOM);
    }
}

DO_FUN(do_recall)
{
    ROOM_INDEX_DATA *location;

    if (IS_NPC(ch))
    {
        char_act("Only players can recall.", ch);
        return;
    }

    if (ch->level >= 10)
    {
        char_act("Recall is for only levels below 10.", ch);
        return;
    }

    if (ch->desc)
    {
        if (IS_PUMPED(ch))
        {
            char_act("You are too pumped to pray now.", ch);
            return;
        }
        location = get_recall(ch);
    }
    else
        location = get_random_recall();

    act("$n prays for transportation!", ch, NULL, NULL, TO_ROOM);

    if (location == NULL)
    {
        char_act("You are completely lost.", ch);
        return;
    }

    if (ch->in_room == location)
        return;

    if (IS_SET(ch->in_room->room_flags, ROOM_NORECALL)
            || IS_AFFECTED(ch, AFF_CURSE)
            || IS_RAFFECTED(ch->in_room, RAFF_CURSE))
    {
        char_act("The gods have forsaken you.", ch);
        return;
    }

    ch->move /= 2;
    act("$n disappears.", ch, NULL, NULL, TO_ROOM);
    char_from_room(ch);
    char_to_room(ch, location);
    act("$n comes up for the room.", ch, NULL, NULL, TO_ROOM);
    if (!JUST_KILLED(ch))
        do_look(ch, "auto");

    if (ch->pet != NULL)
    {
        act("$n disappears.", ch->pet, NULL, NULL, TO_ROOM);
        char_from_room(ch->pet);
        char_to_room(ch->pet, location);
        act("$n comes up for the room.", ch->pet, NULL, NULL, TO_ROOM);
        if (!JUST_KILLED(ch->pet))
            do_look(ch->pet, "auto");
    }
}

DO_FUN(do_train)
{
    CHAR_DATA *mob;
    int stat = - 1;
    char *pOutput = NULL;
    int cost, temp = 0;
    race_t *r;
    class_t *cl;


    if (IS_NPC(ch))
        return;

    if ((cl = class_lookup(ch->class)) == NULL)
    {
        log_printf("do_train", "%s: unknown class %d",
                   ch->name, ch->class);
        return;
    }

    r = RACE(ORG_RACE(ch));
    //  r = RACE(ch->race);

    /*
     * Check for trainer.
     */
    for (mob = ch->in_room->people; mob; mob = mob->next_in_room)
        if (IS_NPC(mob)
                && IS_SET(mob->pIndexData->act, ACT_PRACTICE | ACT_TRAIN | ACT_GAIN))
            break;

    if (mob == NULL)
    {
        char_act("You can't do that here.", ch);
        return;
    }

    if (argument[0] == '\0')
    {
        act_puts("You have $j training sessions.",
                 ch, (const void *) ch->train, NULL, TO_CHAR, POS_DEAD);
        argument = "foo";
    }

    cost = 1;

    if (!str_cmp(argument, "str"))
    {
        stat        = STAT_STR;
        pOutput     = "strength";
    }
    else if (!str_cmp(argument, "int"))
    {
        stat        = STAT_INT;
        pOutput     = "intelligence";
    }
    else if (!str_cmp(argument, "wis"))
    {
        stat        = STAT_WIS;
        pOutput     = "wisdom";
    }
    else if (!str_cmp(argument, "dex"))
    {
        stat        = STAT_DEX;
        pOutput     = "dexterity";
    }
    else if (!str_cmp(argument, "con"))
    {
        stat        = STAT_CON;
        pOutput     = "constitution";
    }
    else if (!str_cmp(argument, "cha"))
    {
        stat        = STAT_CHA;
        pOutput     = "charisma";
    }
    else if (!str_cmp(argument, "lck"))
    {
        stat        = STAT_LCK;
        pOutput     = "luck";
    }
    else if (!str_cmp(argument, "hp"))
        cost = 3;
    else if (!str_cmp(argument, "mana"))
        cost = 2;
    else if (!str_cmp(argument, "move"))
        cost = 2;
    else
    {
        act_puts3("You can train:$t$T$U", ch,
                  (ch->perm_stat[STAT_STR] < get_max_train(ch,STAT_STR)) ?
                  " str," : str_empty,
                  (ch->perm_stat[STAT_INT] < get_max_train(ch,STAT_INT)) ?
                  " int," : str_empty,
                  (ch->perm_stat[STAT_WIS] < get_max_train(ch,STAT_WIS)) ?
                  " wis," : str_empty,
                  TO_CHAR | ACT_NOLF, POS_DEAD);
        act_puts3("$t$T$U", ch,
                  (ch->perm_stat[STAT_DEX] < get_max_train(ch,STAT_DEX)) ?
                  " dex," : str_empty,
                  (ch->perm_stat[STAT_CON] < get_max_train(ch,STAT_CON)) ?
                  " con," : str_empty,
                  (ch->perm_stat[STAT_CHA] < get_max_train(ch,STAT_CHA)) ?
                  " cha," : str_empty,
                  TO_CHAR | ACT_NOLF, POS_DEAD);
        act_puts("$t hit points, mana or move.", ch,
                 (ch->perm_stat[STAT_LCK] < get_max_train(ch,STAT_LCK)) ?
                 " lck," : str_empty, NULL, TO_CHAR, POS_DEAD);

        if (FALSE)
            act("You have nothing left to train!", ch, NULL, NULL, TO_CHAR);

        return;
    }

    if (!str_cmp("hp", argument))
    {
        if ( cost > ch->train )
        {
            char_act("You don't have enough training sessions.", ch);
            return;
        }

        temp = (get_curr_stat(ch,STAT_CON) + r->pcdata->hp_bonus + cl->hp_rate) * ch->level + ch->pcdata->quest_hp_gained;

        if (ch->pcdata->perm_hit < temp)
        {
            ch->train -= cost;
            ch->pcdata->perm_hit += 10;
            ch->pcdata->perm_hit = UMIN(ch->pcdata->perm_hit, temp);
            ch->max_hit += 10;
            ch->hit += 10;
            act("Your health increases.",ch,NULL,NULL,TO_CHAR);
            act("$n's health increases.",ch,NULL,NULL,TO_ROOM);
        }
        else
        {
            act("Your hit points are at maximum!", ch, NULL, NULL, TO_CHAR);
        }
        return;
    }

    if (!str_cmp("mana",argument))
    {
        if ( cost > ch->train )
        {
            char_act("You don't have enough training sessions.", ch);
            return;
        }

        temp = (get_curr_stat(ch,STAT_INT) + get_curr_stat(ch,STAT_WIS) +
                r->pcdata->mana_bonus + cl->mana_rate) * ch->level + ch->pcdata->quest_mana_gained;

        if (ch->pcdata->perm_mana < temp)
        {
            ch->train -= cost;
            ch->pcdata->perm_mana += 10;
            ch->pcdata->perm_mana = UMIN (ch->pcdata->perm_mana, temp);
            ch->max_mana += 10;
            ch->mana += 10;
            act("Your mana increases.",ch,NULL,NULL,TO_CHAR);
            act("$n's mana increases.",ch,NULL,NULL,TO_ROOM);
        }
        else
        {
            act("Your mana is at maximum!", ch, NULL, NULL, TO_CHAR);
        }
        return;
    }

    if (!str_cmp("move",argument))
    {
        if ( cost > ch->train )
        {
            char_act("You don't have enough training sessions.", ch);
            return;
        }

        temp = ((get_curr_stat(ch,STAT_CON) + get_curr_stat(ch,STAT_DEX)) / 4) * ch->level;

        if (ch->pcdata->perm_move < temp)
        {
            ch->train -= cost;
            ch->pcdata->perm_move += 10;
            ch->pcdata->perm_move = UMIN (ch->pcdata->perm_move, temp);
            ch->max_move += 10;
            ch->move += 10;
            act("Your moves increase.", ch, NULL, NULL, TO_CHAR);
            act("$n's moves increase.", ch, NULL, NULL, TO_ROOM);
        }
        else
        {
            act("Your moves are at maximum!", ch, NULL, NULL, TO_CHAR);
        }
        return;
    }

    if (ch->perm_stat[stat] >= get_max_train(ch,stat))
    {
        act_puts("Your $T is already at maximum.", ch, NULL, pOutput, TO_CHAR, POS_DEAD);
        return;
    }

    if (ch->train < 1)
    {
        char_act("You don't have enough training sessions.", ch);
        return;
    }

    ch->train--;
    ch->perm_stat[stat] += 1;
    act_puts("Your $T increases!", ch, NULL, pOutput, TO_CHAR | ACT_TRANS, POS_DEAD);
    act("$n's $T increases!", ch, NULL, pOutput, TO_ROOM | ACT_TRANS);
}

DO_FUN(do_track)
{
    ROOM_HISTORY_DATA *rh;
    EXIT_DATA *pexit;
    static char *door[] = { "north","east","south","west","up","down",
                            "that way"};
    int d;
    int chance;

    if ((chance = get_skill(ch, gsn_track)) == 0)
    {
        char_act("There are no train tracks here.", ch);
        return;
    }

    if (JUST_KILLED(ch))
        return;

    WAIT_STATE(ch, SKILL(gsn_track)->beats);
    act("$n checks the ground for tracks.", ch, NULL, NULL, TO_ROOM);

    if (number_percent() < chance)
    {
        if (IS_NPC(ch))
        {
            ch->status = 0;
            if (ch->last_fought != NULL
                    &&  !IS_SET(ch->pIndexData->act, ACT_NOTRACK))
                add_mind(ch, ch->last_fought->name);
        }

        for (rh = ch->in_room->history; rh != NULL; rh = rh->next)
            if (is_name(argument, rh->name))
            {
                check_improve(ch, gsn_track, TRUE, 1);
                if ((d = rh->went) == -1)
                    continue;
                act("$T's tracks lead $t.", ch, door[d], rh->name, TO_CHAR | ACT_TRANS);
                if ((pexit = ch->in_room->exit[d]) != NULL
                        &&  IS_SET(pexit->exit_info, EX_ISDOOR)
                        &&  pexit->keyword != NULL)
                    doprintf(do_open, ch, "%s", door[d]);
                if (IS_NPC (ch) || IS_SET (ch->comm, COMM_TRACK))
                    move_char(ch, rh->went, FALSE);
                return;
            }
    }

    char_act("You don't see any tracks.", ch);

    if (IS_NPC(ch))
        ch->status = 5; /* for stalker */

    check_improve(ch, gsn_track, FALSE, 1);
}

void do_vampire(CHAR_DATA* ch, const char* argument)
{
    AFFECT_DATA af;
    int level, duration, damroll_mod;
    int chance;

    if (IS_SET(ch->form, FORM_VAMPIRE))
    {
        char_act("But you are already vampire. Kill them! Kill them!", ch);
        return;
    }

    if ((chance = get_skill(ch, gsn_vampire)) == 0)
    {
        char_act("You try to show yourself even more ugly.", ch);
        return ;
    }

    if (chance < 100)
    {
        char_act("Go and ask the questor. He'll help you.", ch);
        return ;
    }

    if (weather_info.sunlight == SUN_LIGHT
            ||  weather_info.sunlight == SUN_RISE)
    {
        char_act("You should wait for the evening or night to transform to a vampire.", ch);
        return ;
    }

    level = LVL(ch);
    duration = level / 10 + 5 ;

    if (LVL(ch) < 50)
        damroll_mod = LVL(ch);
    else if (LVL(ch) < 80)
        damroll_mod = LVL(ch) * 2;
    else
        damroll_mod = LVL(ch) * 3;

    af.type      = gsn_vampire ;
    af.level     = level       ;
    af.duration  = duration    ;

    // negative immunity
    af.where     = TO_RESIST   ;
    af.location  = APPLY_NONE  ;
    af.modifier  = 40;
    af.bitvector = DAM_NEGATIVE ;
    affect_to_char (ch, &af);

    // vampires vulnerabilities
    af.where     = TO_RESIST  ;
    af.location  = APPLY_NONE ;
    af.modifier  = -40 ;
    af.bitvector = DAM_HOLY   ;
    affect_to_char (ch, &af);

    af.where     = TO_RESIST  ;
    af.location  = APPLY_NONE ;
    af.modifier  = -40 ;
    af.bitvector = DAM_SILVER ;
    affect_to_char (ch, &af);

    // haste
    af.where     = TO_AFFECTS ;
    af.location  = APPLY_DEX  ;
    af.modifier  = number_range (5, 10);
    af.bitvector = AFF_HASTE  ;
    affect_to_char (ch, &af);

    // giant strength
    af.location  = APPLY_STR ;
    af.modifier  = number_range (10, 15);
    af.bitvector = 0 ;
    affect_to_char (ch, &af);

    // hit point
    af.where     = TO_AFFECTS ;
    af.location  = APPLY_HIT;
    af.modifier  = damroll_mod * 2;
    af.bitvector = 0;
    affect_to_char(ch, &af);

    // size
    af.where     = TO_FORM    ;
    af.location  = APPLY_SIZE ;
    af.modifier  = 3;
    af.bitvector = FORM_UNDEAD | FORM_VAMPIRE ;
    affect_to_char (ch, &af);

    // damroll
    af.where     = TO_AFFECTS    ;
    af.location  = APPLY_DAMROLL ;
    af.modifier  = damroll_mod   ;
    af.bitvector = AFF_FLYING | AFF_DETECT_INVIS | AFF_DETECT_IMP_INVIS ;
    affect_to_char (ch, &af);

    char_act("You feel yourself getting greater and greater.", ch);
    act_puts("You cannot recognize $n anymore.", ch, NULL, NULL, TO_ROOM, POS_RESTING);
}

DO_FUN(do_soulswitch)
{
    /* GM :   .      .
        char arg[MAX_INPUT_LENGTH];
        CHAR_DATA *victim;

        if (!IS_NPC(ch) || (ch->pIndexData->vnum != MOB_VNUM_SOUL))
        {
        char_act("   ?..", ch);
        return;
        }

        one_argument(argument, arg, sizeof(arg));
        if (arg[0] == '\0')
        {
        char_act("  ?", ch);
        return;
        }
        if ((victim = get_char_room(ch, arg)) == NULL)
        {
        char_act("  ..", ch);
        return;
        }
        if (victim == ch)
        {
        char_act("  ,    ..", ch);
        return;
        }

        if (IS_NPC(victim))
        {
        if (!IS_CLAN_GUARD(victim) && victim->level <= LEVEL_HERO)
        {
            act_puts("   $N!", ch, NULL, victim, TO_CHAR, POS_DEAD);
            ch->desc->character = victim;
            victim->desc = ch-> desc;
            ch->desc = NULL;
            victim->comm = ch->comm;
            victim->lines = ch->lines;
            extract_char(ch, TRUE);
            return;
        }
        else
        {
            char_act("      .", ch);
            return;
        }
        }
        if (victim->desc == NULL && victim != ch->desc->original)
        {
        char_act("        (lostlink).", ch);
        return;
        }


        if ((victim != ch->desc->original) && (victim->desc->snoop_by != NULL))
        {
        char_act("-   ..", ch);
        return;
        }
    */
    /* -     */
    /*
        ch->desc->character             = ch->desc->original;
        ch->desc->original              = NULL;
        ch->desc->character->desc       = ch->desc;
    */
    /*ch->desc                        = NULL;*/
    /*    if (victim == ch->desc->character)
        {
        char_act("    ....", victim);
        ch->desc = NULL;
        extract_char(ch, TRUE);
        return;
        }
        else
        {
        if (victim->level > LEVEL_HERO || saves_spell(victim->level,victim, DAM_NEGATIVE))
        {
            char_act("      !.", ch->desc->character);
            char_act("  !", ch);
            do_look(ch->desc->character, "auto");
            ch->desc->character->mana = 0;
            ch->desc->character->move = 0;
            ch->desc = NULL;
            extract_char(ch, TRUE);
            return;
        }
        else
        {
            TOGGLE_BIT(ch->desc->character->plr_flags, PLR_SOUL);
            act("     $N.",
                ch->desc->character, NULL, victim, TO_CHAR);
            victim->desc->snoop_by = ch->desc->character->desc;
            ch->desc = NULL;
            extract_char(ch, TRUE);
            return;
        }
        }
    */
}

DO_FUN(do_resoul)
{
    /* GM :      ?    .
        CHAR_DATA *soul;
        DESCRIPTOR_DATA *d;

        if (IS_NPC(ch) && ch->desc != NULL)
        {
        char_act("     .", ch);
        soul = create_mob(get_mob_index(MOB_VNUM_SOUL));
        char_to_room(soul,ch->in_room);
        ch->desc->character = soul;
        soul->desc = ch->desc;
        ch->desc = NULL;
        soul->comm = ch->comm;
        soul->lines = ch->lines;
        do_look(soul, "auto");
        return;
        }

        if (!IS_NPC(ch) && IS_SET(ch->plr_flags, PLR_SOUL))
        {
        char_act("            !.", ch);
        for (d = descriptor_list; d != NULL; d = d->next)
            if (d->snoop_by == ch->desc)
                d->snoop_by = NULL;
        REMOVE_BIT(ch->plr_flags, PLR_SOUL);
        do_look(ch, "auto");
        return;
        }
        char_act("Huh?", ch);
    */
}


DO_FUN(do_vbite)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    int chance;

    one_argument(argument, arg, sizeof(arg));

    if ((chance = get_skill(ch, gsn_vampiric_bite)) == 0)
    {
        char_act("You don't know how to bite creatures.", ch);
        return;
    }

    if (!IS_SET(ch->form, FORM_VAMPIRE))
    {
        char_act("You must transform vampire before biting.", ch);
        return;
    }

    if (arg[0] == '\0')
    {
        char_act("Bite whom?", ch);
        return;
    }

    WAIT_STATE(ch, SKILL(gsn_vampiric_bite)->beats);

    if ((victim = get_char_room(ch, arg)) == NULL)
    {
        char_act("They aren't here.", ch);
        return;
    }

    if (victim->position != POS_SLEEPING)
    {
        char_act("They must be sleeping.", ch);
        return;
    }

    if (IS_NPC(ch) && !IS_NPC(victim))
        return;

    if (victim == ch)
    {
        char_act("How can you sneak upon yourself?", ch);
        return;
    }

    if (victim->fighting != NULL)
    {
        char_act("You can't bite a fighting person.", ch);
        return;
    }

    if (is_safe(ch, victim))
        return;

    if (victim->hit < (8 * victim->max_hit / 10) && (IS_AWAKE(victim)))
    {
        act_puts("$N is hurt and suspicious ... doesn't worth up.",
                 ch, NULL, victim, TO_CHAR, POS_DEAD);
        return;
    }

    if (current_time-victim->last_fight_time < 200 && IS_AWAKE(victim))
    {
        act_puts("$N is hurt and suspicious ... doesn't worth up.",
                 ch, NULL, victim, TO_CHAR, POS_DEAD);
        return;
    }

    if (!IS_AWAKE(victim)
            && (IS_NPC(ch)
                || number_percent() < ((chance * 7 / 10) + (2 * (LVL(ch) - LVL(victim))) )))
    {
        check_improve(ch,gsn_vampiric_bite,TRUE,1);
        one_hit(ch, victim, gsn_vampiric_bite, WEAR_WIELD);
    }
    else
    {
        check_improve(ch, gsn_vampiric_bite, FALSE, 1);
        damage(ch, victim, 0, gsn_vampiric_bite, DAM_NONE, DAMF_SHOW);
    }
    if (!IS_NPC(victim) && victim->position==POS_FIGHTING)
    {
        act_yell(victim, "Help! $i tried to bite me!", ch, "yells in panic");
        agent_net_printf(victim, ch, ANET_ATTACK);
    }
}

DO_FUN(do_bash_door)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *gch;
    int chance;
    int damage_bash,door;
    int beats;

    ROOM_INDEX_DATA *to_room;
    EXIT_DATA *pexit;
    EXIT_DATA *pexit_rev;

    one_argument(argument, arg, sizeof(arg));

    if ((chance = get_skill(ch, gsn_bash_door)) == 0)
    {
        char_act("Bashing? What's that?", ch);
        return;
    }

    if (MOUNTED(ch))
    {
        char_act("You can't bash doors while mounted.", ch);
        return;
    }

    if (RIDDEN(ch))
    {
        char_act("You can't bash doors while being ridden.", ch);
        return;
    }

    if (arg[0] == '\0')
    {
        char_act("Bash wich door or direction?", ch);
        return;
    }

    if (ch->fighting)
    {
        char_act("Wait until the fight finishes.", ch);
        return;
    }

    /* look for guards */
    for (gch = ch->in_room->people; gch; gch = gch->next_in_room)
        if (IS_NPC(gch)
                && IS_AWAKE(gch) && ch->level + 5 < gch->level)
        {
            act_puts("$N is standing too close to door.",
                     ch, NULL, gch, TO_CHAR, POS_DEAD);
            return;
        }

    if ((door = find_door(ch, arg)) < 0)
        return;

    pexit = ch->in_room->exit[door];

    if (!IS_SET(pexit->exit_info, EX_CLOSED))
    {
        char_act("It's already open.", ch);
        return;
    }

    if (!IS_SET(pexit->exit_info, EX_LOCKED))
    {
        char_act("Just try to open it.", ch);
        return;
    }

    if (IS_SET(pexit->exit_info, EX_NOPASS))
    {
        char_act("A mystical shield protects exit.", ch);
        return;
    }

    chance -= 90;

    /* modifiers */

    /* size and weight */
    //    chance += get_carry_weight(ch) / 100;
    chance += ch->size * 2;

    /* stats */
    chance += get_curr_stat(ch, STAT_STR);

    if (IS_AFFECTED(ch, AFF_FLYING))
        chance -= 10;

    act_puts("You slam into $d, and try to break $d!",
             ch, NULL, pexit->keyword, TO_CHAR, POS_DEAD);
    act("$n slams into $d, and tries to break it!",
        ch, NULL, pexit->keyword, TO_ROOM);

    if (room_dark(ch->in_room))
        chance /= 2;

    beats = SKILL(gsn_bash_door)->beats;
    /* now the attack */
    if (number_percent() < chance)
    {
        check_improve(ch, gsn_bash_door, TRUE, 1);

        REMOVE_BIT(pexit->exit_info, EX_LOCKED);
        REMOVE_BIT(pexit->exit_info, EX_CLOSED);
        act("$n bashes the $d and breaks the lock.",
            ch, NULL, pexit->keyword, TO_ROOM);
        char_act("You successed to open the door.", ch);

        /* open the other side */
        if ((to_room = pexit->to_room.r) != NULL
                && (pexit_rev = to_room->exit[rev_dir[door]]) != NULL
                && pexit_rev->to_room.r == ch->in_room)
        {
            ROOM_INDEX_DATA *in_room;

            REMOVE_BIT(pexit_rev->exit_info, EX_CLOSED);
            REMOVE_BIT(pexit_rev->exit_info, EX_LOCKED);

            in_room = ch->in_room;
            ch->in_room = to_room;
            act("$n bashes the $d and breaks the lock.",
                ch, NULL, pexit->keyword, TO_ROOM);
            ch->in_room = in_room;
        }

        check_improve(ch, gsn_bash_door, TRUE, 1);
        WAIT_STATE(ch, beats);
    }
    else
    {
        char_act("You fall flat on your face!", ch);
        act_puts("$n falls flat on $gn{his} face.",
                 ch, NULL, NULL, TO_ROOM, POS_RESTING);
        check_improve(ch, gsn_bash_door, FALSE, 1);
        ch->position = POS_RESTING;
        WAIT_STATE(ch, beats * 3 / 2);
        damage_bash = ch->damroll + number_range(4, 4 + ch->size + chance / 5);
        damage(ch, ch, damage_bash, gsn_bash_door, DAM_BASH, DAMF_SHOW);
    }
}

DO_FUN(do_blink)
{
    char arg[MAX_INPUT_LENGTH];

    if (get_skill(ch, gsn_blink) == 0)
    {
        char_act("Huh?", ch);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        act_puts("Your current blink status: $t.",
                 ch, IS_SET(ch->plr_flags, PLR_BLINK) ? "ON" : "OFF", NULL, TO_CHAR | ACT_TRANS, POS_DEAD);
        return;
    }

    if (!str_cmp(arg, "ON") || !str_cmp(arg, ""))
    {
        SET_BIT(ch->plr_flags, PLR_BLINK);
        char_act("Now, your current blink status is ON.", ch);
        return;
    }

    if (!str_cmp(arg, "OFF")
            || !str_cmp(arg, ""))
    {
        REMOVE_BIT(ch->plr_flags, PLR_BLINK);
        char_act("Now, your current blink status is OFF.", ch);
        return;
    }

    act_puts("What's that? Is $t a status?", ch, arg, NULL, TO_CHAR, POS_DEAD);
}

DO_FUN(do_kidnap)
{
    char arg[MAX_INPUT_LENGTH];
    AFFECT_DATA af;
    ROOM_INDEX_DATA *pRoomIndex;
    CHAR_DATA *victim;
    int chance;
    int i;
    bool r_found = FALSE;

    if ((chance = get_skill(ch, gsn_kidnap)) == 0)
    {
        char_act("Huh?", ch);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));

    if (ch->fighting != NULL)
    {
        char_act("Wait until the fight finishes.", ch);
        return;
    }
    if (arg[0] == '\0')
    {
        char_act("Kidnap whom?", ch);
        return;
    }
    else if ((victim = get_char_room(ch, arg)) == NULL)
    {
        WAIT_STATE(ch, SKILL(gsn_kidnap)->beats);
        char_act("They aren't there.", ch);
        return;
    }
    WAIT_STATE(ch, SKILL(gsn_kidnap)->beats);

    if (is_safe(ch, victim))
        return;

    if (IS_SET(ch->in_room->room_flags, ROOM_BATTLE_ARENA))
    {
        char_act("You can't kidnap on Battle Arena!", ch);
        return;
    }

    if (victim->fighting != NULL)
    {
        char_act("You can't kidnap fighting victim.", ch);
        return;
    }
    if (victim == ch)
    {
        char_act("That's pointless.", ch);
        return;
    }

    if (ch->mana < 70)
    {
        char_act("You don't have enough power.", ch);
        return;
    }

    if (is_affected(ch, gsn_kidnap))
    {
        char_act("This skill is used too recently.", ch);
        return;
    }


    ch->mana -= 70;
    //     chance /=2; // 50% // commented by Aseroth
    if (IS_AWAKE(victim))
        chance /= 2; //    25%
    chance += URANGE(0, (get_curr_stat(ch, STAT_DEX)-20)*2, 10); //  
    chance -= URANGE(0, (get_curr_stat(victim, STAT_DEX)-20)*2, 10); //   

    if (IS_SET(victim->in_room->room_flags, ROOM_NORECALL))
        chance = 0;

    if (IS_IMMORTAL(victim) && (ch->level < victim->level))
        chance = 0;

    //    --  ,    

    if (number_percent() > chance
            || (IS_NPC(victim)
                && ((IS_SET(victim->pIndexData->act, ACT_QUESTOR))
                    || (IS_SET(victim->pIndexData->act, ACT_PRACTICE))
                    || (IS_SET(victim->pIndexData->act, ACT_TRAIN))
                    || (IS_SET(victim->pIndexData->act, ACT_HEALER))
                    || (IS_SET(victim->pIndexData->act, ACT_CHANGER))
                    || (IS_SET(victim->pIndexData->act, ACT_AREA_GUARD))
                    || (IS_SET(victim->pIndexData->act, ACT_CLAN_GUARD)))))
    {
        check_improve(ch, gsn_kidnap, FALSE, 1);
        act("You trying kidnap $N, but failed.",
            ch, NULL, victim, TO_CHAR);
        act("$n trying kidnap you!",
            ch, NULL, victim, TO_VICT);
        act("$n trying kidnap $N, but failed.",
            ch, NULL, victim, TO_NOTVICT);
        if (!IS_AWAKE(victim))
            return;
        damage(ch, victim, 0, gsn_kidnap, DAM_NONE, TRUE);
        return;
    }
    else
    {
        check_improve(ch, gsn_kidnap, TRUE, 1);
        for (i = 0; i < 5000 ; i++)
        {
            if ((pRoomIndex = get_room_index(number_range(ch->in_room->area->min_vnum, ch->in_room->area->max_vnum))) == NULL)
                continue;
            /*        if ((ch->in_room->vnum < 500 || ch->in_room->vnum > 600)
                    &&  (pRoomIndex->vnum > 500 && pRoomIndex->vnum < 600))
                    continue;*/
            if (can_see_room(ch,pRoomIndex)
                    && !room_is_private(pRoomIndex)
                    && !IS_SET(pRoomIndex->room_flags, ROOM_NOSUMMON)
                    && !IS_SET(pRoomIndex->room_flags, ROOM_IMP_ONLY)
                    && !IS_SET(pRoomIndex->room_flags, ROOM_GODS_ONLY)
                    && ch->in_room->area == pRoomIndex->area)
            {
                r_found = TRUE;
                break;
            }
        }
        //    -- !!   
        if (!r_found)
        {
            char_act("Hmm.. you just don't know that to do with this body!", ch);
            bug("do_kidnap: room in %d not found!! muttafucka!!", ch->in_room->area->vnum);
            return;
        }

        af.where     = TO_AFFECTS;
        af.type      = gsn_kidnap;
        af.level     = ch->level;
        af.duration  = 0;
        af.location  = 0;
        af.modifier  = 0;
        af.bitvector = 0;
        affect_to_char(ch, &af);


        act("$n snatch $N.",
            ch, NULL, victim, TO_NOTVICT);
        act("$n throws something under legs and disappear with $N in smoke.",
            ch, NULL, victim, TO_NOTVICT);
        act("You snatch $N and disappear.",
            ch, NULL, victim, TO_CHAR);
        act("$n kidnap you!",
            ch, NULL, victim, TO_VICT);
        char_from_room(victim);
        char_from_room(ch);
        char_to_room(ch, pRoomIndex);
        char_to_room(victim, pRoomIndex);
        act("$n and $N suddenly come up from the smoke.",ch, NULL, victim, TO_NOTVICT);
    }
    do_look(ch, "auto");
    if (!IS_AWAKE(victim))
        return;
    do_look(victim, "auto");
    multi_hit(victim, ch, TYPE_UNDEFINED);
}

DO_FUN(do_vanish)
{
    ROOM_INDEX_DATA *pRoomIndex;
    int chance;
    int sn;
    int i;
    bool found;

    if ((sn = sn_lookup("vanish")) < 0
            ||  (chance = get_skill(ch, sn)) == 0)
    {
        char_act("Huh?", ch);
        return;
    }

    if (ch->mana < 25)
    {
        char_act("You don't have enough power.", ch);
        return;
    }
    ch->mana -= 25;
    WAIT_STATE(ch, SKILL(sn)->beats);

    if (number_percent() > chance)
    {
        char_act("You failed.", ch);
        check_improve(ch, sn, FALSE, 1);
        return;
    }

    if (ch->in_room == NULL
            || IS_SET(ch->in_room->room_flags, ROOM_NORECALL)
            || IS_RAFFECTED(ch->in_room, RAFF_PREVENT))
    {
        char_act("You failed.", ch);
        return;
    }

    found = FALSE;
    for (i = 0; i < 50 ; i++)
    {
        if ((pRoomIndex = get_room_index(number_range(ch->in_room->area->min_vnum, ch->in_room->area->max_vnum))) == NULL)
            continue;
        if ((ch->in_room->vnum < 500 || ch->in_room->vnum > 600)
                && (pRoomIndex->vnum > 500 && pRoomIndex->vnum < 600))
            continue;
        if (can_see_room(ch,pRoomIndex)
                && !room_is_private(pRoomIndex)
                && !IS_SET(pRoomIndex->room_flags, ROOM_NOSUMMON)
                && !IS_SET(pRoomIndex->room_flags, ROOM_IMP_ONLY)
                && !IS_SET(pRoomIndex->room_flags, ROOM_GODS_ONLY)
                && ch->in_room->area == pRoomIndex->area)
        {
            found = TRUE;
            break;
        }
    }

    act_puts("$n throws down a small globe.", ch, NULL, NULL, TO_ROOM, POS_RESTING);
    check_improve(ch, sn, TRUE, 1);

    if (!found)
    {
        char_act("You failed.", ch);
        return;
    }

    if (!IS_NPC(ch) && ch->fighting != NULL && number_bits(1) == 1)
    {
        char_act("You failed.", ch);
        return;
    }

    act_puts("$n is gone!", ch, NULL, NULL, TO_ROOM, POS_RESTING);

    char_from_room(ch);
    char_to_room(ch, pRoomIndex);
    act_puts("$n appears from nowhere.", ch, NULL, NULL, TO_ROOM, POS_RESTING);
    do_look(ch, "auto");
    stop_fighting(ch, TRUE);
}

DO_FUN(do_fade)
{
    int chance;
    if ((chance=get_skill(ch, gsn_fade)) == 0)
    {
        char_act("Huh?", ch);
        return;
    }

    if (MOUNTED(ch))
    {
        char_act("You can't fade while mounted.", ch);
        return;
    }

    if (RIDDEN(ch))
    {
        char_act("You can't fade while being ridden.", ch);
        return;
    }

    char_act("You attempt to fade.", ch);
    if (number_percent()<=chance)
    {
        SET_BIT(ch->affected_by, AFF_FADE);
        check_improve(ch, gsn_fade, TRUE, 3);
    }
    else
        check_improve(ch, gsn_fade, FALSE, 3);
}

DO_FUN(do_vtouch)
{
    CHAR_DATA *victim;
    AFFECT_DATA af;
    int chance, dt;
    int sn;

    if ((sn = sn_lookup("vampiric touch")) < 0
            || (chance = get_skill(ch, sn)) == 0)
    {
        char_act("You lack the skill to draining touch.", ch);
        return;
    }

    if (!IS_SET(ch->form, FORM_VAMPIRE))
    {
        char_act("Let it be.", ch);
        return;
    }
    if (ch->move < 30)
    {
        char_act("You are too tired.", ch);
        return;
    }

    if (IS_AFFECTED(ch, AFF_CHARM))
    {
        char_act("You don't want to drain your master.", ch);
        return;
    }

    WAIT_STATE(ch, SKILL(sn)->beats);

    if ((victim = get_char_room(ch, argument)) == NULL)
    {
        char_act("They aren't here.", ch);
        return;
    }

    if (ch == victim)
    {
        char_act("Even you are not so stupid.", ch);
        return;
    }

    if (victim->fighting)
    {
        char_act("You can't touch a fighting person.", ch);
        return ;
    }

    if (is_affected(victim, sn))
        return;

    if (is_safe(ch, victim))
        return;

    if (is_affected (victim, gsn_insomnia))
    {
        act("But $N can't sleep.", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (MOUNTED(victim))
    {
        char_act("You can't touch rider.", ch);
        return;
    }

    chance = chance * 4 / 5;
    if ((dt = current_time - victim->last_fight_time) < 300)
        chance -= (300 - dt) / 10;
    if (current_time - ch->last_fight_time < 300)
        chance -= 5;
    if (IS_NPC(victim) && victim->pIndexData->pShop != NULL)
        chance -= 40;
    if (is_affected(ch, gsn_protective_shield))
        chance -= 10;
    if (is_affected(victim, gsn_protective_shield))
        chance -= 20;

    chance += (LVL(ch) - LVL(victim)) * 2;
    if (check_perception(victim, ch))
        chance = 0;

    SET_FIGHT_TIME(victim);
    SET_FIGHT_TIME(ch);

    ch->move -= 20;

    if (check_mirror_image(ch, victim))
        return;

    if (number_percent() < chance
            && !IS_CLAN_GUARD(victim)
            && !IS_IMMORTAL(victim)
            && !IS_UNDEAD(victim))
    {
        act_puts("You deadly touch $n's neck and put $gn{him} to nightmares.",
                 victim, NULL, ch, TO_VICT, POS_DEAD);
        act("$N deadly touches your neck and puts you to nightmares.",
            victim, NULL, ch, TO_CHAR);
        act("$N deadly touches $n's neck and puts $gn{him} to nightmares.",
            victim, NULL, ch, TO_NOTVICT);
        check_improve(ch, sn, TRUE, 1);

        af.type         = sn;
        af.where        = TO_AFFECTS;
        af.level        = LVL(ch);
        //af.duration     = LVL(ch) / 20 + 1;
        af.duration     = IS_SET (muddy_mode, MUDDY_RANDOM_SLEEP) ?
                          number_range (0, LVL(ch) / 20 + 1) :  // new value
                          LVL(ch) / 20 + 1;                     // old value
        af.location     = APPLY_NONE;
        af.modifier     = 0;
        af.bitvector    = AFF_SLEEP;
        affect_join(victim,&af);

        if (IS_AWAKE(victim))
            victim->position = POS_SLEEPING;
    }
    else
    {
        damage(ch, victim, 0, sn, DAM_NONE, DAMF_SHOW);
        check_improve(ch, sn, FALSE, 1);
    }
}

DO_FUN(do_fly)
{
    char arg[MAX_INPUT_LENGTH];

    /*  if (IS_NPC(ch))
        return;
    */
    argument = one_argument(argument, arg, sizeof(arg));

    if (!str_cmp(arg,"up")
            || !str_cmp(arg, ""))
    {
        race_t *r;

        if (is_affected(ch, gsn_thumbling))
        {
            char_act("Stop jumping like a crazy rabbit first.", ch);
            return;
        }

        if (IS_AFFECTED(ch, AFF_FLYING))
        {
            char_act("You are already flying.", ch);
            return;
        }

        if (is_bit_affected(ch, TO_AFFECTS, AFF_FLYING)
                || ((r = race_lookup(ch->race)) && (r->aff & AFF_FLYING))
                || has_obj_affect(ch, AFF_FLYING))
        {
            SET_BIT(ch->affected_by, AFF_FLYING);
            char_act("You start to fly.", ch);
            act("$n start to fly.", ch, NULL, NULL, TO_ROOM);
        }
        else
        {
            char_act("To fly find potion or wings.", ch);
            return;
        }
    }
    else if (!str_cmp(arg,"down")
             || !str_cmp(arg, ""))
    {
        if (IS_AFFECTED(ch, AFF_FLYING))
        {
            REMOVE_BIT(ch->affected_by, AFF_FLYING);
            char_act("You slowly touch the ground.", ch);
            act("$n slowly touch the ground.", ch, NULL, NULL, TO_ROOM);
        }
        else
        {
            char_act("You are already on the ground.", ch);
            return;
        }
    }
    else
    {
        char_act("Type fly with 'up' or 'down'.", ch);
        return;
    }

    WAIT_STATE(ch, SKILL(gsn_fly)->beats);
}

DO_FUN(do_push)
{
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    EXIT_DATA *pexit;
    int percent;
    int door;
    int sn;

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));

    if (arg1[0] == '\0' || arg2[0] == '\0')
    {
        char_act("Push whom to what direction?", ch);
        return;
    }

    if (MOUNTED(ch))
    {
        char_act("You can't push while mounted.", ch);
        return;
    }

    if (RIDDEN(ch))
    {
        char_act("You can't push while being ridden.", ch);
        return;
    }

    if (IS_NPC(ch) && IS_SET(ch->affected_by, AFF_CHARM)
            && (ch->master != NULL))
    {
        char_act("You are too dazed to push anyone.", ch);
        return;
    }

    if (IS_SET(ch->in_room->room_flags, ROOM_BATTLE_ARENA))
    {
        char_act("You can't push on Battle Arena.", ch);
        return;
    }

    if ((sn = sn_lookup("push")) < 0)
        return;

    WAIT_STATE(ch, SKILL(sn)->beats);

    if ((victim = get_char_room(ch, arg1)) == NULL)
    {
        char_act("They aren't here.", ch);
        return;
    }

    if (!IS_NPC(victim) && victim->desc == NULL)
    {
        char_act("You can't do that.", ch);
        return;
    }

    if (victim == ch)
    {
        char_act("That's pointless.", ch);
        return;
    }

    if (victim->position == POS_FIGHTING)
    {
        char_act("Wait until the fight finishes.", ch);
        return;
    }

    if ((door = find_exit(ch, arg2)) < 0)
        return;

    if ((pexit = ch->in_room->exit[door])
            && IS_SET(pexit->exit_info, EX_ISDOOR))
    {
        if (IS_SET(pexit->exit_info, EX_CLOSED))
        {
            char_act("The door is closed.", ch);
            return;
        }
        if (IS_SET(pexit->exit_info, EX_LOCKED))
        {
            char_act("The door is locked.", ch);
            return;
        }
    }

    if (IS_AFFECTED(ch, AFF_WEB))
    {
        char_act("You're webbed, and want to do WHAT?!?", ch);
        act("$n stupidly tries to push $N while webbed.", ch, NULL, victim, TO_ROOM);
        return;
    }

    if (IS_AFFECTED(victim, AFF_WEB))
    {
        act_puts("You attempt to push $n, but the webs hold $gn{him} in place.",
                 victim, NULL, ch, TO_VICT, POS_DEAD);
        act_puts("$N attempts to push $n, but fails as the webs hold $n in place.",
                 victim, NULL, ch, TO_NOTVICT, POS_RESTING);
        return;
    }

    if (is_safe(ch,victim))
        return;

    if (sn > 0)
        percent  = number_percent() + (IS_AWAKE(victim) ? 40 : -80);
    else
        percent  = 1;
    percent += can_see(victim, ch) ? -10 : 0;
    percent += IS_AWAKE(victim) ? 40 : -80;

    if (victim->position == POS_FIGHTING
            || (IS_NPC(victim) && IS_SET(victim->pIndexData->act, ACT_NOTRACK))
            || (!IS_NPC(ch) && percent > get_skill(ch, sn)))
    {
        /*
         * Failure.
         */

        char_act("Oops.", ch);
        if (!IS_AFFECTED(victim, AFF_SLEEP))
        {
            victim->position = victim->position == POS_SLEEPING ?
                               POS_STANDING : victim->position;
            act_puts("$n tried to push you.", ch, NULL, victim, TO_VICT, POS_RESTING);
        }
        act_puts("$n tried to push $N.", ch, NULL, victim, TO_NOTVICT, POS_RESTING);

        if (IS_AWAKE(victim))
        {
            act_yell(victim, "Keep your hands out of me, $i!", ch, "yells hysterical");
            agent_net_printf(victim, ch, ANET_ATTACK);
        }
        if (!IS_NPC(ch) && IS_NPC(victim))
        {
            check_improve(ch, sn, FALSE, 2);
            multi_hit(victim, ch, TYPE_UNDEFINED);
        }
        return;
    }

    act("You push $N to $t.", ch, dir_name[door], victim, TO_CHAR | ACT_TRANS);
    act("$n pushes you to $t.", ch, dir_name[door], victim, TO_VICT | ACT_TRANS);
    act("$n pushes $N to $t.", ch, dir_name[door], victim, TO_NOTVICT | ACT_TRANS);
    move_char(victim, door, FALSE);

    check_improve(ch, sn, TRUE, 1);
}

DO_FUN(do_crecall)
{
    ROOM_INDEX_DATA *location;
    clan_t *clan;
    AFFECT_DATA af;
    int sn;

    if ((sn = sn_lookup("clan recall")) < 0
            || get_skill(ch, sn) == 0
            || (clan = clan_lookup(ch->clan)) == NULL)
    {
        char_act("Huh?", ch);
        return;
    }

    if (is_affected(ch, sn))
    {
        char_act("You can't pray now.", ch);
        return;
    }

    if (ch->desc && IS_PUMPED(ch))
    {
        char_act("You are too pumped to pray now.", ch);
        return;
    }

    act(clan->msg_prays, ch, NULL, NULL, TO_ROOM);

    if ((location = get_room_index(clan->recall_vnum)) == NULL)
    {
        char_act("You are completely lost.", ch);
        return;
    }

    if (ch->in_room == location)
        return;

    if (!check_war_move (ch, location, FALSE))
        return;

    if (IS_SET(ch->in_room->room_flags, ROOM_NORECALL)
            || IS_AFFECTED(ch, AFF_CURSE)
            || IS_RAFFECTED(ch->in_room, RAFF_ESPIRIT)
            || IS_RAFFECTED(ch->in_room, RAFF_CURSE))
    {
        char_act("The gods have forsaken you.", ch);
        return;
    }

    /*
     * clan recall works always
     */
    if (number_percent() < get_percent(ch, sn))
    {

        ch->move /= 2;
        act(clan->msg_vanishes, ch, NULL, NULL, TO_ROOM);
        char_from_room(ch);
        char_to_room(ch, location);
        act("$n comes up for the room.", ch, NULL, NULL, TO_ROOM);
        do_look(ch, "auto");
        check_improve(ch, gsn_clan_recall, TRUE, 2);

        if (ch->pet != NULL)
        {
            char_from_room(ch->pet);
            char_to_room(ch->pet, location);
            do_look(ch->pet, "auto");
        }

        af.type      = sn;
        af.level     = LVL(ch);
        af.duration  = SKILL(sn)->beats;
        af.location  = APPLY_NONE;
        af.modifier  = 0;
        af.bitvector = 0;
        affect_to_char(ch, &af);
    }
    else
    {
        char_act("You failed.", ch);
        check_improve(ch, gsn_clan_recall, FALSE, 2);
    }
}

DO_FUN(do_escape)
{
    ROOM_INDEX_DATA *was_in;
    ROOM_INDEX_DATA *now_in;
    EXIT_DATA *pexit;
    CHAR_DATA *victim;
    char arg[MAX_INPUT_LENGTH];
    int door;
    int chance;
    int sn;

    if ((sn = sn_lookup("escape")) < 0 || (chance = get_skill(ch, sn)) == 0)
    {
        do_flee(ch, argument);
        return;
    }

    if ((victim = ch->fighting) == NULL)
    {
        if (ch->position == POS_FIGHTING)
            ch->position = POS_STANDING;
        char_act("You aren't fighting anyone.", ch);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Escape to what direction?", ch);
        return;
    }

    if (MOUNTED(ch))
    {
        char_act("You can't escape while mounted.", ch);
        return;
    }

    if (RIDDEN(ch))
    {
        char_act("You can't escape while being ridden.", ch);
        return;
    }

    if (IS_RAFFECTED(ch->in_room, RAFF_PREVENT))
        chance -= 1;

    was_in = ch->in_room;

    if ((door = find_exit(ch, arg)) < 0
            || number_range(0, ch->daze) != 0)
    {
        char_act("PANIC! You couldn't escape!", ch);
        return;
    }

    if ((pexit = was_in->exit[door]) == 0
            || pexit->to_room.r == NULL
            || (IS_SET(pexit->exit_info, EX_CLOSED)
                && (!IS_AFFECTED(ch, AFF_PASS_DOOR)
                    || IS_SET(pexit->exit_info, EX_NOPASS))
                && !IS_TRUSTED(ch, ANGEL))
            || (IS_SET(pexit->exit_info, EX_NOFLEE))
            || (IS_NPC(ch)
                && IS_SET(pexit->to_room.r->room_flags, ROOM_NOMOB)))
    {
        char_act("Something prevents you to escape that direction.", ch);
        return;
    }

    if (number_percent() > chance)
    {
        char_act("You failed to escape.", ch);
        check_improve(ch, sn, FALSE, 1);
        return;
    }

    check_improve(ch, sn, TRUE, 1);
    move_char(ch, door, FALSE);
    if ((now_in = ch->in_room) == was_in)
    {
        char_act("It's pointless to escape there.", ch);
        return;
    }

    ch->in_room = was_in;
    act_puts("$n has escaped!", ch, NULL, NULL, TO_ROOM, POS_RESTING);
    ch->in_room = now_in;

    if (!IS_NPC(ch))
    {
        char_act("You escaped from combat!", ch);
    }
    else /* Once fled, the mob will not go after */
        ch->last_fought = NULL;

    stop_fighting(ch, TRUE);
}

DO_FUN(do_layhands)
{
    CHAR_DATA *victim;
    AFFECT_DATA af;
    int sn;
    int mana;

    if ((sn = sn_lookup("lay hands")) < 0
            ||  get_skill(ch, sn) == 0)
    {
        char_act("You lack the skill to heal others with touching.", ch);
        return;
    }

    WAIT_STATE(ch, SKILL(sn)->beats);

    if ((victim = get_char_room(ch, argument)) == NULL)
    {
        char_act("They aren't here.", ch);
        return;
    }

    if (is_affected(ch, sn))
    {
        char_act("You can't concentrate enough.", ch);
        return;
    }

    if ((mana=SKILL(sn)->min_mana) > ch->mana)
    {
        char_act("No mana.", ch);
        return;
    }

    ch->mana -= mana;

    af.type = sn;
    af.where = TO_AFFECTS;
    af.level = LVL(ch);
    af.duration = 2;
    af.location = APPLY_NONE;
    af.modifier = 0;
    af.bitvector = 0;
    affect_to_char (ch, &af);
    if (CAN_HEAL(ch, victim))
    {
        victim->hit = UMIN(victim->hit + LVL(ch) * 2, victim->max_hit);
        update_pos(victim);
        char_act("A warm feeling fills your body.", victim);

        if (IS_AFFECTED(victim, AFF_BLIND))
            spell_cure_blindness(sn_lookup("cure blindness"), LVL(ch),
                                 ch, (void*)victim, TARGET_CHAR);
        if (IS_AFFECTED(victim, AFF_PLAGUE))
            spell_cure_disease (sn_lookup("cure disease"), LVL(ch),
                                ch, (void*)victim, TARGET_CHAR);
        if (IS_AFFECTED(victim, AFF_POISON))
            spell_cure_poison(sn_lookup("cure poison"), LVL(ch),
                              ch, (void*)victim, TARGET_CHAR);
        if (ch != victim)
            char_act("Ok.", ch);
    }
    else
    {
        act("Your touch burns $N's flesh!", ch, NULL, victim, TO_CHAR);
        act("$n's touch burns your flesh!", ch, NULL, victim, TO_VICT);
        act("$n's touch burns $N's flesh!", ch, NULL, victim, TO_NOTVICT);
        if (!is_safe(ch, victim))
            damage(ch, victim, LVL(ch), sn, DAM_HOLY, TRUE);
    }
    check_improve(ch, sn, TRUE, 1);
}

int mount_success(CHAR_DATA *ch, CHAR_DATA *mount, int canattack)
{
    int percent;
    int success;
    int chance = 0;

    chance = get_skill(ch, gsn_riding) + get_skill(ch, gsn_dragon_riding)
             + get_skill(ch, gsn_animal_riding);

    if (chance == 0)
        return FALSE;

    percent = number_percent() + (ch->level < mount->level ?
                                  (mount->level - ch->level) * 3 :
                                  (mount->level - ch->level) * 2);

    if (!ch->fighting)
        percent -= 25;

    if (!IS_NPC(ch) && IS_DRUNK(ch))
    {
        percent += chance / 2;
        char_act("Due to your being under the influence, riding seems a bit harder...", ch);
    }

    success = percent - chance;

    if (success <= 0)
    { /* Success */
        check_improve(ch, gsn_riding, TRUE, 1);
        check_improve(ch, gsn_dragon_riding, TRUE, 1);
        check_improve(ch, gsn_animal_riding, TRUE, 1);
        return TRUE;
    }

    check_improve(ch, gsn_riding, FALSE, 1);
    check_improve(ch, gsn_dragon_riding, FALSE, 1);
    check_improve(ch, gsn_animal_riding, FALSE, 1);
    if (success >= 10 && MOUNTED(ch) == mount)
    {
        act_puts("You lose control and fall off of $N.",
                 ch, NULL, mount, TO_CHAR, POS_DEAD);
        act_puts("$n loses control and falls off of $N.",
                 ch, NULL, mount, TO_NOTVICT, POS_RESTING);
        act_puts("$n loses control and falls off of you.",
                 ch, NULL, mount, TO_VICT, POS_SLEEPING);

        ch->riding = FALSE;
        mount->riding = FALSE;
        if (ch->position > POS_STUNNED)
            ch->position=POS_SITTING;

        ch->hit -= 5;
        update_pos(ch);
    }
    if (success >= 40 && canattack)
    {
        act_puts("$N doesn't like the way you've been treating $gN{him}.",
                 ch, NULL, mount, TO_CHAR, POS_DEAD);
        act("$N doesn't like the way $n has been treating $gN{him}.",
            ch, NULL, mount, TO_NOTVICT);
        act_puts("You don't like the way $n has been treating you.",
                 ch, NULL, mount, TO_VICT, POS_SLEEPING);

        act_puts("$N snarls and attacks you!", mount, NULL, ch, TO_VICT, POS_DEAD);
        act_puts("$N snarls and attacks $n!", mount, NULL, ch, TO_NOTVICT, POS_RESTING);
        act_puts("You snarl and attack $n!", mount, NULL, ch, TO_CHAR, POS_SLEEPING);

        damage(mount, ch, number_range(1, mount->level),
               gsn_kick, DAM_BASH, DAMF_SHOW);
    }
    return FALSE;
}

/*
 * It is not finished yet to implement all.
 */
DO_FUN(do_mount)
{
    char        arg[MAX_INPUT_LENGTH];
    CHAR_DATA * mount;

    argument = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        if (ch->mount && ch->mount->in_room == ch->in_room)
            mount = ch->mount;
        else
        {
            char_act("Mount what?", ch);
            return;
        }
    }
    else if ((mount = get_char_room(ch, arg)) == NULL)
    {
        char_act("You don't see that here.", ch);
        return;
    }

    if (!IS_NPC(mount) || !IS_SET(mount->pIndexData->act, ACT_RIDEABLE)
            || IS_SET(mount->pIndexData->act, ACT_NOTRACK))
    {
        char_act("You can't ride that.", ch);
        return;
    }

    if (mount->level - 5 > ch->level)
    {
        char_act("That beast is too powerful for you to ride.", ch);
        return;
    }

    if ((mount->mount) && (!mount->riding) && (mount->mount != ch))
    {
        act("$i belongs to $N, not you.", ch, mount, mount->mount, TO_CHAR);
        return;
    }

    if (mount->position < POS_STANDING)
    {
        char_act("Your mount must be standing.", ch);
        return;
    }

    if (RIDDEN(mount))
    {
        char_act("This beast is already ridden.", ch);
        return;
    }
    else if (MOUNTED(ch))
    {
        char_act("You are already riding.", ch);
        return;
    }

    if (!mount_success(ch, mount, TRUE))
    {
        char_act("You fail to mount the beast.", ch);
        return;
    }

    if ((HAS_SKILL(ch, gsn_dragon_riding) && mount->pIndexData->vnum != MOB_VNUM_DRAGON)
            || (HAS_SKILL(ch, gsn_animal_riding) && mount->pIndexData->vnum != MOB_VNUM_BIG_LION))
    {
        char_act("You fail to mount the beast.", ch);
        return;
    }

    if (mount->pIndexData->vnum == MOB_VNUM_DRAGON
            && mount->master != ch)
    {
        char_act("You can't ride that.", ch);
        return;
    }

    if (mount->pIndexData->vnum == MOB_VNUM_BIG_LION
            && mount->master != ch)
    {
        char_act("You can't ride that.", ch);
        return;
    }

    act_puts("You hop on $N's back.", ch, NULL, mount, TO_CHAR, POS_DEAD);
    act("$n hops on $N's back.", ch, NULL, mount, TO_NOTVICT);
    act_puts("$n hops on your back!", ch, NULL, mount, TO_VICT, POS_SLEEPING);
    if (ch->stance != STANCE_NORMAL)
    {
        char_act("You drop your fighting stance and concentrate on staying mounted.", ch);
        affect_strip(ch, gsn_stance);
    }
    ch->stance = STANCE_NORMAL;
    ch->mount = mount;
    ch->riding = TRUE;
    mount->mount = ch;
    mount->riding = TRUE;

    affect_strip(ch, gsn_mount_fighting);

    if (number_percent () < get_skill (ch, gsn_mount_fighting))
    {
        AFFECT_DATA af ;

        af.where     = TO_AFFECTS;
        af.type      = gsn_mount_fighting;
        af.level     = LVL (ch);
        af.duration  = -1;
        af.modifier  = (-1)*(LVL (ch) * 3 + 27);
        af.location  = APPLY_AC;
        af.bitvector = 0;
        affect_to_char (ch, &af);
    }

    affect_strip(ch, gsn_mount_control);

    if (number_percent () < get_skill (ch, gsn_mount_control))
    {
        AFFECT_DATA af ;

        af.where     = TO_AFFECTS;
        af.type      = gsn_mount_control;
        af.level     = LVL (ch);
        af.duration  = -1;
        af.modifier  = (-1)*(LVL (ch)*3 + 27) / 2;
        af.location  = APPLY_AC;
        af.bitvector = 0;
        affect_to_char (ch, &af);

        check_improve (ch, gsn_mount_control, 2, TRUE);
    }
    else
        check_improve (ch, gsn_mount_control, 2, FALSE);

    affect_bit_strip(ch, TO_AFFECTS, AFF_INVIS | AFF_IMP_INVIS | AFF_SNEAK);
    REMOVE_BIT(ch->affected_by, AFF_HIDE | AFF_FADE | AFF_CAMOUFLAGE |
               AFF_TRAP | AFF_INVIS | AFF_IMP_INVIS | AFF_SNEAK);
}

DO_FUN(do_dismount)
{
    CHAR_DATA *mount;

    if ((mount = MOUNTED(ch)))
    {
        act_puts("You dismount from $N.", ch, NULL, mount, TO_CHAR, POS_DEAD);
        act("$n dismounts from $N.", ch, NULL, mount, TO_NOTVICT);
        act_puts("$n dismounts from you.", ch, NULL, mount, TO_VICT, POS_SLEEPING);

        if (is_affected(ch, gsn_mount_fighting))
            affect_strip(ch, gsn_mount_fighting);

        if (is_affected(ch, gsn_mount_control))
            affect_strip(ch, gsn_mount_control);

        ch->riding = FALSE;
        ch->mount = NULL;
        mount->riding = FALSE;
        mount->mount = NULL;
    }
    else
    {
        char_act("You aren't mounted.", ch);
        return;
    }
}

int send_arrow(CHAR_DATA *ch, CHAR_DATA *victim,OBJ_DATA *arrow,
               int door, int chance ,int bonus)
{
    EXIT_DATA *pExit;
    ROOM_INDEX_DATA *dest_room;
    AFFECT_DATA *paf;
    int damroll = 0, hitroll = 0, sn;
    AFFECT_DATA af;

    if (arrow->level > ch->level)
    {
        act("You can't use $p! $p falls down.", ch, arrow, NULL, TO_CHAR);
        obj_to_room(arrow, ch->in_room);
        return FALSE;
    }
    if (arrow->value[0] == WEAPON_SPEAR)
        sn = gsn_spear;
    else if (arrow->value[0] == WEAPON_SHURIKEN)
        sn = gsn_shuriken;
    else if (arrow->value[0] == WEAPON_KNIFE)
        sn = gsn_knife;
    else if (arrow->value[0] == WEAPON_GRENADE)
        sn = gsn_grenade;
    else
        sn = gsn_arrow;

    for (paf = arrow->affected; paf != NULL; paf = paf->next)
    {
        if (paf->location == APPLY_DAMROLL)
            damroll += paf->modifier;
        if (paf->location == APPLY_HITROLL)
            hitroll += paf->modifier;
    }

    dest_room = ch->in_room;
    chance += (hitroll + str_app[get_curr_stat(ch,STAT_STR)].tohit
               + (get_curr_stat(ch,STAT_DEX) - 18)) * 2;
    damroll *= 10;
    while (1)
    {
        chance -= 10;
        if (victim->in_room == dest_room)
        {
            if (number_percent() < chance)
            {
                if (check_obj_dodge(ch, victim, arrow, chance))
                    return 0;
                act("$p strikes you!", victim, arrow, NULL, TO_CHAR);
                act_puts("Your $p strikes $N!", ch, arrow, victim, TO_CHAR, POS_DEAD);

                if (ch->in_room == victim->in_room)
                    act("$n's $p strikes $N!", ch, arrow, victim, TO_NOTVICT);
                else
                {
                    act("$n's $p strikes $N!", ch, arrow, victim, TO_ROOM);
                    act("$p strikes $n!", victim, arrow, NULL, TO_ROOM);
                }

                if (is_safe(ch, victim)
                        || (IS_NPC(victim)
                            && IS_SET(victim->pIndexData->act, ACT_NOTRACK)))
                {
                    act("$p falls from $n doing no visible damage...",
                        victim, arrow, NULL, TO_ROOM);
                    act("$p falls from $N doing no visible damage...",
                        ch, arrow, victim, TO_CHAR);
                    obj_to_room(arrow, victim->in_room);
                }
                else
                {
                    int dam;

                    dam = dice(arrow->value[1], arrow->value[2]);
                    dam = number_range(dam, 2 * dam);
                    dam += damroll + bonus
                           + (10 * str_app[get_curr_stat(ch, STAT_STR)].todam);

                    if (IS_WEAPON_STAT(arrow, WEAPON_POISON))
                    {
                        int level;
                        AFFECT_DATA *poison, af;

                        if ((poison = affect_find(arrow->affected,gsn_poison)) == NULL)
                            level = arrow->level;
                        else
                            level = poison->level;
                        if (!saves_spell(level,victim,DAM_POISON))
                        {
                            char_act("You feel poison coursing through your veins.", victim);
                            act("$n is poisoned by the venom on $p.",
                                victim, arrow, NULL, TO_ROOM);

                            af.where     = TO_AFFECTS;
                            af.type      = gsn_poison;
                            af.level     = level * 3/4;
                            af.duration  = level / 2;
                            af.location  = APPLY_STR;
                            af.modifier  = -5;
                            af.bitvector = AFF_POISON;
                            affect_join(victim, &af);
                        }

                    }
                    if (IS_WEAPON_STAT(arrow, WEAPON_FLAMING))
                    {
                        act("$n is burned by $p.", victim, arrow, NULL, TO_ROOM);
                        act("$p sears your flesh.", victim, arrow, NULL, TO_CHAR);
                        fire_effect((void *) victim,arrow->level,dam,TARGET_CHAR);
                    }
                    if (IS_WEAPON_STAT(arrow, WEAPON_FROST))
                    {
                        act("$p freezes $n.", victim, arrow, NULL, TO_ROOM);
                        act("The cold touch of $p surrounds you with ice.",
                            victim, arrow, NULL, TO_CHAR);
                        cold_effect(victim,arrow->level,dam,TARGET_CHAR);
                    }
                    if (IS_WEAPON_STAT(arrow, WEAPON_SHOCKING))
                    {
                        act("$n is struck by lightning from $p.",
                            victim, arrow, NULL, TO_ROOM);
                        act("You are shocked by $p.", victim, arrow, NULL, TO_CHAR);
                        shock_effect(victim,arrow->level,dam,TARGET_CHAR);
                    }

                    if (dam > victim->max_hit / 10
                            && number_percent() < 50
                            && arrow->value[0] != WEAPON_GRENADE)
                    {
                        af.where     = TO_AFFECTS;
                        af.type      = sn;
                        af.level     = ch->level;
                        af.duration  = -1;
                        af.location  = APPLY_HITROLL;
                        af.modifier  = - (dam / 20);
                        if (IS_NPC(victim))
                            af.bitvector = 0;
                        else
                            af.bitvector = AFF_CORRUPTION;

                        affect_join(victim, &af);

                        obj_to_char(arrow, victim);
                        equip_char(victim, arrow, WEAR_STUCK_IN);
                    }
                    else
                        obj_to_room(arrow, victim->in_room);

                    if (arrow->value[0] == WEAPON_GRENADE
                            && number_percent() < 25)
                    {
                        act_puts("$p blasted beside $N's head!",
                                 ch, arrow, victim, TO_CHAR, POS_DEAD);
                        act_puts("$p blasted beside your head!",
                                 victim, arrow, NULL, TO_CHAR, POS_DEAD);
                        dam += victim->max_hit / 3;
                    }
                    damage(ch, victim, dam, sn, DAM_PIERCE, DAMF_SHOW);
                    path_to_track(ch, victim, door);

                    if (!IS_NPC(victim))
                    {
                        act_yell(victim, "Die, $i! You, villainous polecat!", ch, NULL);
                        agent_net_printf(victim, ch, ANET_ATTACK);
                    }
                }
                if (arrow->value[0] == WEAPON_GRENADE)
                    obj_from_room(arrow);
                return TRUE;
            }
            else
            {
                if (arrow->value[0] == WEAPON_GRENADE)
                {
                    obj_to_room(arrow, victim->in_room);
                    obj_from_room(arrow);
                    act("$p sticks in the ground and explodes! But misses you.", victim, arrow, NULL, TO_ALL);
                }
                else
                {
                    obj_to_room(arrow, victim->in_room);
                    act("$p sticks in the ground at your feet!", victim, arrow, NULL, TO_ALL);
                }
                return FALSE;
            }
        }
        pExit = dest_room->exit[ door ];
        if (!pExit)
            break;
        else
        {
            dest_room = pExit->to_room.r;
            if (dest_room->people)
                act("$p sails into the room from the $T!",
                    dest_room->people, arrow, dir_name[rev_dir[door]], TO_ALL);
        }
    }
    return FALSE;
}

static OBJ_DATA *find_arrow(CHAR_DATA *ch)
{
    OBJ_DATA *arrow;
    OBJ_DATA *obj;

    if ((arrow = get_eq_char(ch, WEAR_HOLD)))
        return arrow;

    for (obj = ch->carrying; obj; obj = obj->next_content)
    {
        if (obj->wear_loc == WEAR_NONE
                ||  obj->pIndexData->item_type != ITEM_CONTAINER
                ||  !IS_SET(obj->value[1], CONT_QUIVER)
                ||  !obj->contains)
            continue;
        return obj->contains;
    }

    return NULL;
}
DO_FUN(do_charge)
{
    CHAR_DATA* victim;
    OBJ_DATA* wield;
    int chance, direction, range, i, wait;
    EXIT_DATA *pexit;
    ROOM_INDEX_DATA *to_room;

    char arg1[512], arg2[512];

    if (IS_NPC (ch) || !(chance = get_skill (ch, gsn_charge)))
    {
        char_act("Huh?", ch);
        return ;
    }

    argument = one_argument(argument, arg1, sizeof(arg1));
    one_argument(argument, arg2, sizeof(arg2));

    if (arg1 == '\0' || arg2 == '\0')
    {
        char_act("Charge whom?", ch);
        return ;
    }

    if ((wield = get_eq_char (ch, WEAR_WIELD)) == NULL)
    {
        char_act("You need a weapon to charge.", ch);
        return ;
    }

    if (wield->value [0] != WEAPON_LANCE && wield->value [0] != WEAPON_SPEAR)
    {
        char_act("You need lance or spear to charge.", ch);
        return;
    }

    if ((direction = find_exit (ch, arg1)) < 0 || direction >= MAX_DIR)
    {
        char_act("Charge whom?", ch);
        return;
    }

    if ((victim = find_char (ch, arg2, direction, (range = LVL(ch) / 10))) == NULL)
    {
        WAIT_STATE (ch, MISSING_TARGET_DELAY);
        return;
    }

    if (ch->in_room == victim->in_room)
    {
        act("$N is here. Just MURDER $gN{him}.", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (IS_ROOM_AFFECTED (ch->in_room, RAFF_ESPIRIT)
            && !IS_ROOM_AFFECTED (victim->in_room, RAFF_ESPIRIT)
            && is_affected (ch, gsn_evil_spirit))
    {
        char_act("Evil inside you cancel your charge!", ch);
        return;
    }

    if (MOUNTED(ch) == NULL)
    {
        char_act("You have to be riding.", ch);
        return;
    }

    if (is_safe (ch, victim))
        return;

    if ((!IS_NPC(victim) && (victim->hit < victim->max_hit*9/10))
            || (IS_NPC(victim) && (victim->hit < victim->max_hit*7/10)))
    {
        act("$N is already bleeding, your honour do not allow you attack $gN{him}.",
            ch, NULL, victim, TO_CHAR);
        return;
    }

    chance = chance * get_skill (ch, gsn_riding) / 100 ;

    for (i = 0 ; i < range ; i++)
    {
        if (!move_char_org(ch, direction, FALSE, TRUE))
            return;
        if (ch->in_room == victim->in_room)
            break;
    }

    act("$n gallops from $t, charging you!",
        ch, dir_name[rev_dir[direction]], victim, TO_VICT);

    act("$n gallops from $t, charging $N!",
        ch, dir_name[rev_dir[direction]], victim, TO_NOTVICT);

    if (!IS_NPC (victim) && victim->position == POS_FIGHTING)
    {
        act_yell(victim, "Help! $i trying to kill me!", ch, NULL);
        agent_net_printf (victim, ch, ANET_ATTACK);
    }

    wait = 12 ;

    // make chance smaller, so there will be some chance to miss the target
    chance -= (chance / 4);

    if (number_percent () < chance)
    {
        if (check_roll (victim))
            return;

        one_hit (ch, victim, gsn_charge, WEAR_WIELD);

        if (check_recovery (victim, ch))
            wait /= 2 ;
        else if (check_jammer (victim))
            wait /= 2 ;

        DAZE_STATE (victim, wait);
        WAIT_STATE (ch, SKILL(gsn_charge)->beats);

        check_improve (ch, gsn_charge, TRUE, 1);
    }
    else
    {
        damage (ch, victim, 0, gsn_charge, DAM_NONE, TRUE);
        check_improve (ch, gsn_charge, FALSE, 1);

        if (number_percent () > (chance * 3 / 4))
        {
            if ((pexit = ch->in_room->exit[direction]) == NULL
                    || (to_room = pexit->to_room.r) == NULL
                    || !can_see_room(ch, to_room)
                    || IS_ROOM_AFFECTED(ch->in_room, RAFF_RANDOMIZER)
                    || IS_SET(pexit->exit_info, EX_CLOSED))
            {
                WAIT_STATE (ch, SKILL(gsn_charge)->beats * 1.4);
                return;
            }
            else
            {
                act("$n cannot hold $gn{his} $N.",
                    ch, dir_name[direction], ch->mount, TO_NOTVICT);

                act("You cannot hold your $N.",
                    ch, NULL, ch->mount, TO_CHAR);

                move_char (ch, direction, FALSE);
                WAIT_STATE (ch, SKILL (gsn_charge)->beats * 1.2);
                return;
            }
        }
        WAIT_STATE (ch, SKILL(gsn_charge)->beats);
    }
}

DO_FUN(do_shoot)
{
    CHAR_DATA *victim;
    OBJ_DATA *wield;
    OBJ_DATA *arrow;
    char arg1[512],arg2[512];
    bool success;
    int chance, direction,master,bonus;
    int range = (ch->level / 10) + 1;
    int i;
    int master_shoot; //Edit by Simon check mastering bow
    int sn;

    if (IS_NPC(ch))
        return; /* Mobs can't use bows */

    if (IS_NPC(ch) || (chance = get_skill(ch, gsn_bow)) == 0)
    {
        char_act("You don't know how to shoot.", ch);
        return;
    }

    argument = one_argument(argument, arg1, sizeof(arg1));
    one_argument(argument, arg2, sizeof(arg2));

    if (arg1[0] == '\0' || arg2[0] == '\0')
    {
        char_act("Shoot what direction and whom?", ch);
        return;
    }

    if (ch->fighting)
    {
        char_act("You cannot concentrate on shooting arrows.", ch);
        return;
    }

    direction = find_exit(ch, arg1);

    if (direction < 0 || direction >= MAX_DIR)
    {
        char_act("Shoot which direction and whom?", ch);
        return;
    }

    WAIT_STATE(ch, SKILL(gsn_bow)->beats);

    if ((victim = find_char(ch, arg2, direction, range)) == NULL)
    {
        char_act("They aren't there.", ch);
        return;
    }

    if (!IS_NPC(victim) && victim->desc == NULL)
    {
        char_act("You can't do that.", ch);
        return;
    }

    if (victim == ch)
    {
        char_act("That's pointless.", ch);
        return;
    }

    wield = get_eq_char(ch, WEAR_WIELD);

    if (!wield || wield->pIndexData->item_type != ITEM_WEAPON
            || wield->value[0] != WEAPON_BOW)
    {
        char_act("You need a bow to shoot!", ch);
        return;
    }

    if (get_eq_char(ch, WEAR_SECOND_WIELD)
            || get_eq_char(ch, WEAR_SHIELD))
    {
        char_act("Your second hand should be free!", ch);
        return;
    }

    if ((arrow = find_arrow(ch)) == NULL)
    {
        char_act("You need an arrow to shoot!", ch);
        return;
    }

    if (arrow->pIndexData->item_type != ITEM_WEAPON
            ||  arrow->value[0] != WEAPON_ARROW)
    {
        char_act("That's not the right kind of arrow!", ch);
        return;
    }

    if (is_safe(ch, victim))
        return;

    chance = (chance - 50) * 2;
    if (ch->position == POS_SLEEPING)
        chance += 40;
    if (ch->position == POS_RESTING)
        chance += 10;
    if (victim->position == POS_FIGHTING)
        chance -= 40;
    chance += GET_HITROLL(ch);

    sn = sn_lookup("mastering bow");
    master=get_skill(ch, sn);
    master_shoot = number_range(1, master / 50 + 1);
    if (master<50)
        master=0;
    else
        master-=35;
    for (i = 0; i < master_shoot; i++)
    {
        bonus=dice(wield->value[1],wield->value[2]);
        if (number_percent()<master)
        {
            act("You shoot $p to $T like a master.",
                ch, arrow, dir_name[direction], TO_CHAR);
            act("$n shoots $p to $T like a master.",
                ch, arrow, dir_name[direction], TO_ROOM);
            bonus*=dice(2,3);
        }
        else
        {
            act_puts("You shoot $p to $T.",
                     ch, arrow, dir_name[direction], TO_CHAR, POS_DEAD);
            act_puts("$n shoots $p to $T.",
                     ch, arrow, dir_name[direction], TO_ROOM, POS_RESTING);
        }
        if ((arrow = find_arrow(ch)) == NULL)
            break;
        if (arrow->carried_by)
            obj_from_char(arrow);
        else if (arrow->in_obj)
            obj_from_obj(arrow);

        success = send_arrow(ch, victim, arrow, direction, chance,bonus);
        check_improve(ch, gsn_bow, success, 1);
        if (get_skill(ch, sn) > 0)
            check_improve(ch, sn, success, 1);
    }
}

char *find_way(CHAR_DATA *ch,ROOM_INDEX_DATA *rstart, ROOM_INDEX_DATA *rend)
{
    int direction;
    static char buf[1024];
    EXIT_DATA *pExit;
    char buf2[2];

    snprintf(buf, sizeof(buf), "Bul: ");
    while (1)
    {
        if ((rend == rstart))
            return buf;
        if ((direction = find_path(rstart->vnum,rend->vnum,ch,-40000,0)) == -1)
        {
            strnzcat(buf, sizeof(buf), " BUGGY");
            return buf;
        }
        if (direction < 0 || direction > 5)
        {
            strnzcat(buf, sizeof(buf), " VERY BUGGY");
            return buf;
        }
        buf2[0] = dir_name[direction][0];
        buf2[1] = '\0';
        strnzcat(buf, sizeof(buf), buf2);
        /* find target room */
        pExit = rstart->exit[ direction ];
        if (!pExit)
        {
            strnzcat(buf, sizeof(buf), " VERY VERY BUGGY");
            return buf;
        }
        else
            rstart = pExit->to_room.r;
    }
}

DO_FUN(do_human)
{
    AFFECT_DATA af;

    if (!IS_SET(ch->form, FORM_CHANGED))
    {
        act("You are already a human.", ch, NULL, NULL, TO_CHAR);
        return;
    }
    act("You return to your original size.", ch, NULL, NULL, TO_CHAR);

    if (IS_SET(ch->form, FORM_MECH))
    {
        affect_strip(ch, gsn_mech);
        return;
    }
    if (IS_SET(ch->form, FORM_BEAR))
    {
        affect_strip(ch, gsn_bearform);
        return;
    }
    if (IS_SET(ch->form, FORM_WOLF))
    {
        affect_strip(ch, gsn_wolfform);
        return;
    }
    if (IS_SET(ch->form, FORM_VAMPIRE))
    {
        affect_strip(ch, gsn_vampire);
        return;
    }
    if (IS_SET(ch->form, FORM_DEMON))
    {
        if (IS_SET(ch->form, FORM_DEMON_AIR))
            affect_strip(ch, gsn_demon_air);
        if (IS_SET(ch->form, FORM_DEMON_WATER))
            affect_strip(ch, gsn_demon_water);
        if (IS_SET(ch->form, FORM_DEMON_FIRE))
            affect_strip(ch, gsn_demon_fire);
        if (IS_SET(ch->form, FORM_DEMON_EARTH))
            affect_strip(ch, gsn_demon_earth);


        af.type         = gsn_demon_time;
        af.where        = TO_RESIST;
        af.level        = LVL(ch);
        af.duration     = 6;
        af.bitvector    = DAM_SILVER;
        af.modifier     = 0;
        af.location     = APPLY_NONE;
        affect_to_char(ch, &af);
        /*
                af.where        = TO_AFFECTS;
                af.modifier     = UMAX(1,LVL(ch) / 2);
                af.bitvector    = 0;
                af.location     = APPLY_HITROLL;
                affect_to_char(ch, &af);

                af.modifier     = UMAX(1,LVL(ch) / 2);
                af.bitvector    = 0;
                af.location     = APPLY_DAMROLL;
                affect_to_char(ch,&af);
        */
        return;
    }
}

DO_FUN(do_body)
{
    do_human(ch, str_empty);
}

DO_FUN(do_throw_spear)
{
    CHAR_DATA *victim;
    OBJ_DATA *spear;
    char arg1[512],arg2[512];
    bool success;
    int chance,direction;
    int range = (ch->level / 10) + 1;

    if (IS_NPC(ch) || (chance = get_skill(ch, gsn_spear)) == 0)
    {
        char_act("You don't know how to throw a spear.", ch);
        return;
    }

    argument = one_argument(argument, arg1, sizeof(arg1));
    one_argument(argument, arg2, sizeof(arg2));

    if (arg1[0] == '\0' || arg2[0] == '\0')
    {
        char_act("Throw spear what direction and whom?", ch);
        return;
    }

    if (ch->fighting)
    {
        char_act("You cannot concentrate on throwing spears.", ch);
        return;
    }

    direction = find_exit(ch, arg1);
    if (direction < 0 || direction >= MAX_DIR)
    {
        char_act("Throw which direction and whom?", ch);
        return;
    }

    WAIT_STATE(ch, SKILL(gsn_spear)->beats);

    if ((victim = find_char(ch, arg2, direction, range)) == NULL)
    {
        char_act("They aren't there.", ch);
        return;
    }

    if (!IS_NPC(victim) && victim->desc == NULL)
    {
        char_act("You can't do that.", ch);
        return;
    }

    if (victim == ch)
    {
        char_act("That's pointless.", ch);
        return;
    }

    spear = get_eq_char(ch, WEAR_WIELD);
    if (!spear || spear->pIndexData->item_type != ITEM_WEAPON
            ||  spear->value[0] != WEAPON_SPEAR)
    {
        char_act("You need a spear to throw!", ch);
        return;
    }

    if (get_eq_char(ch,WEAR_SECOND_WIELD) || get_eq_char(ch,WEAR_SHIELD))
    {
        char_act("Your second hand should be free!", ch);
        return;
    }

    if (is_safe(ch, victim))
        return;

    chance = (chance - 50) * 2;
    if (ch->position == POS_SLEEPING)
        chance += 40;
    if (ch->position == POS_RESTING)
        chance += 10;
    if (victim->position == POS_FIGHTING)
        chance -= 40;
    chance += GET_HITROLL(ch);

    act("You throw $p to $T.", ch, spear, dir_name[ direction ], TO_CHAR);
    act("$n throws $p to $T.", ch, spear, dir_name[ direction ], TO_ROOM);

    obj_from_char(spear);
    success = send_arrow(ch,victim,spear,direction,chance,
                         dice(spear->value[1],spear->value[2]));
    check_improve(ch, gsn_spear, success, 1);
}

DO_FUN(do_throw_shuriken)
{
    CHAR_DATA *victim;
    OBJ_DATA *shuriken;
    char arg1[512],arg2[512];
    bool success;
    int chance,direction;
    int range = (ch->level / 10) + 1;

    if (IS_NPC(ch) || (chance = get_skill(ch, gsn_shuriken)) == 0)
    {
        char_act("You don't know how to throw a shuriken.", ch);
        return;
    }

    argument = one_argument(argument, arg1, sizeof(arg1));
    one_argument(argument, arg2, sizeof(arg2));

    if (arg1[0] == '\0' || arg2[0] == '\0')
    {
        char_act("Throw shuriken what direction and whom?", ch);
        return;
    }

    if (ch->fighting)
    {
        char_act("You cannot concentrate on throwing shurikens.", ch);
        return;
    }

    direction = find_exit(ch, arg1);
    if (direction < 0 || direction >= MAX_DIR)
    {
        char_act("Throw shuriken what direction and whom?", ch);
        return;
    }

    WAIT_STATE(ch, SKILL(gsn_spear)->beats);

    if ((victim = find_char(ch, arg2, direction, range)) == NULL)
    {
        char_act("They aren't there.", ch);
        return;
    }

    if (!IS_NPC(victim) && victim->desc == NULL)
    {
        char_act("You can't do that.", ch);
        return;
    }

    if (victim == ch)
    {
        char_act("That's pointless.", ch);
        return;
    }

    shuriken = get_eq_char(ch, WEAR_HOLD);
    if (!shuriken || shuriken->pIndexData->item_type != ITEM_WEAPON
            ||  shuriken->value[0] != WEAPON_SHURIKEN)
    {
        char_act("You need a shuriken to throw!", ch);
        return;
    }

    if (get_eq_char(ch, WEAR_SHIELD))
    {
        char_act("Your second hand should be free!", ch);
        return;
    }

    if (is_safe(ch,victim))
        return;

    chance = (chance - 50) * 2;
    chance += GET_HITROLL(ch);

    act("You throw $p to $T.", ch, shuriken, dir_name[ direction ], TO_CHAR);
    act("$n throws $p to $T.", ch, shuriken, dir_name[ direction ], TO_ROOM);

    obj_from_char(shuriken);
    do_wear(ch, "shuriken");
    success = send_arrow(ch,victim,shuriken,direction,chance,
                         dice(shuriken->value[1],shuriken->value[2]));
    check_improve(ch, gsn_shuriken, success, 1);
}

/*
DO_FUN(do_throw_shuriken)
{
    CHAR_DATA *victim;
    OBJ_DATA *shuriken;
    char arg1[512],arg2[512];
    bool success;
    int i, chance, direction, num_throw;
    int range = (ch->level / 10) + 1;

    if (IS_NPC(ch) || (chance = get_skill(ch, gsn_shuriken)) == 0) {
    char_act("     .", ch);
    return;
    }

    argument = one_argument(argument, arg1, sizeof(arg1));
    one_argument(argument, arg2, sizeof(arg2));

    if (arg1[0] == '\0' || arg2[0] == '\0') {
    char_act("       ?", ch);
    return;
    }

    if (ch->fighting) {
    char_act("      .", ch);
    return;
    }

    direction = find_exit(ch, arg1);
    if (direction < 0 || direction >= MAX_DIR) {
    char_act("       ?", ch);
    return;
    }

    WAIT_STATE(ch, SKILL(gsn_shuriken)->beats);

    if ((victim = find_char(ch, arg2, direction, range)) == NULL) {
    char_act("  .", ch);
    return;
    }

    if (!IS_NPC(victim) && victim->desc == NULL) {
    char_act("    .", ch);
    return;
    }

    if (victim == ch) {
    char_act("     .", ch);
    return;
    }

    shuriken = get_eq_char(ch, WEAR_HOLD);
    if (!shuriken || shuriken->pIndexData->item_type != ITEM_WEAPON
    ||  shuriken->value[0] != WEAPON_SHURIKEN) {
    char_act("  !", ch);
    return;
    }

    if (is_safe(ch,victim))
    return;

    num_throw = number_range(1, chance / 20 + 1);

    chance = (chance - 50) * 2;
    chance += GET_HITROLL(ch) / 5;

    for (i = 0; i < num_throw; i++) {
    act("  $p  $T.", ch, shuriken, dir_name[direction], TO_CHAR);
    act("$n  $p  $T.", ch, shuriken, dir_name[direction], TO_ROOM);
            obj_from_char(shuriken);
            success = send_arrow(ch, victim, shuriken, direction, chance,
                           dice(shuriken->value[1],shuriken->value[2]));
            check_improve(ch, gsn_shuriken, success, 1);
            do_wear(ch, "shuriken");
            shuriken = get_eq_char(ch, WEAR_HOLD);
            if (!shuriken || shuriken->pIndexData->item_type != ITEM_WEAPON
                || shuriken->value[0] != WEAPON_SHURIKEN
            || (chance -= 20) < 0)
        break;
    }
}

*/

/* random room generation procedure */
ROOM_INDEX_DATA  *get_random_room(CHAR_DATA *ch)
{
    ROOM_INDEX_DATA *room;

    for (; ;)
    {
        //room = get_room_index(number_range(0, 65535));
        room = get_room_index(number_range(0, 300000));

        if (!room)
            continue;

        if (can_see_room(ch,room)
                &&  !room_is_private(room)
                &&  !IS_SET(room->room_flags, ROOM_SAFE | ROOM_PEACE | ROOM_GODS_ONLY | ROOM_IMP_ONLY)
                &&  !IS_SET(room->area->flags, AREA_UNDER_CONSTRUCTION)
                &&  (!IS_NPC(ch) ||
                     !IS_SET(ch->pIndexData->act, ACT_AGGRESSIVE) ||
                     !IS_SET(room->room_flags, ROOM_LAW)))
            break;
    }

    return room;
}

/* RT Enter portals */
DO_FUN(do_enter)
{
    ROOM_INDEX_DATA *location;
    ROOM_INDEX_DATA *old_room;
    OBJ_DATA *portal;
    CHAR_DATA *fch, *fch_next, *mount;

    if (ch->fighting != NULL)
        return;

    /* nifty portal stuff */
    if (argument[0] == '\0')
    {
        char_act("Nope, can't do it.", ch);
        return;
    }

    old_room = ch->in_room;
    portal = get_obj_list(ch, argument, ch->in_room->contents);

    if (portal == NULL)
    {
        char_act("You don't see that here.", ch);
        return;
    }

    if (portal->pIndexData->riddle)
    {
        char_act("You must answer the riddle to enter!", ch);
        return;
    }

    if (portal->pIndexData->item_type != ITEM_PORTAL
            || (IS_SET(portal->value[1], EX_CLOSED)
                && !IS_TRUSTED(ch, ANGEL)))
    {
        char_act("You can't seem to find a way in.", ch);
        return;
    }

    if (is_affected(ch, gsn_evil_spirit))
    {
        char_act("Evil spirit prevents you from leaving...", ch);
        return;
    }

    if (IS_SET(portal->value[2], GATE_NOCURSE)
            && !IS_TRUSTED(ch, ANGEL)
            && (IS_AFFECTED(ch, AFF_CURSE)
                || IS_SET(old_room->room_flags, ROOM_NORECALL)
                || IS_RAFFECTED(old_room, RAFF_CURSE)))
    {
        char_act("Something prevents you from leaving...", ch);
        return;
    }

    if (IS_SET(portal->value[2], GATE_NOPUMPED) && IS_PUMPED(ch))
    {
        char_act("You are too pumped to do this.", ch);
        return;
    }


    if (IS_SET(portal->value[2], GATE_RANDOM) || portal->value[3] == -1)
    {
        location = get_random_room(ch);
        portal->value[3] = location->vnum; /* keeps record */
    }
    else if (IS_SET(portal->value[2], GATE_BUGGY) && (number_percent() < 5))
        location = get_random_room(ch);
    else
        location = get_room_index(portal->value[3]);

    if (location == NULL
            || location == old_room
            || !can_see_room(ch, location)
            || (room_is_private(location) && !IS_TRUSTED(ch, IMPLEMENTOR)))
    {
        act("$p doesn't seem to go anywhere.", ch, portal,NULL,TO_CHAR);
        return;
    }

    if (!check_war_move (ch, location, FALSE))
        return;

    if (IS_NPC(ch) && IS_SET(ch->pIndexData->act, ACT_AGGRESSIVE)
            && IS_SET(location->room_flags, ROOM_LAW))
    {
        char_act("Something prevents you from leaving...", ch);
        return;
    }

    act(MOUNTED(ch) ? "$n steps into $p, riding on $N." :
        "$n steps into $p.",
        ch, portal, MOUNTED(ch), TO_ROOM);

    act(IS_SET(portal->value[2], GATE_NORMAL_EXIT) ?
        "You enter $p." :
        "You walk through $p and find yourself somewhere else...",
        ch, portal, NULL, TO_CHAR);

    mount = MOUNTED(ch);
    char_from_room(ch);
    char_to_room(ch, location);

    if (IS_SET(portal->value[2], GATE_GOWITH))
    {/* take the gate along */
        obj_from_room(portal);
        obj_to_room(portal, location);
    }

    if (IS_SET(portal->value[2], GATE_NORMAL_EXIT))
        act(mount ? "$n has arrived, riding $N" : "$n has arrived.",
            ch, portal, mount, TO_ROOM);
    else
        act(mount ? "$n has arrived through $p, riding $N." :
            "$n has arrived through $p.",
            ch, portal, mount, TO_ROOM);

    if (!JUST_KILLED(ch))
        do_look(ch,"auto");

    if (mount)
    {
        char_from_room(mount);
        char_to_room(mount, location);
        ch->riding = TRUE;
        mount->riding = TRUE;
    }

    /* charges */
    if (portal->value[0] > 0)
    {
        portal->value[0]--;
        if (portal->value[0] == 0)
            portal->value[0] = -1;
    }

    /* protect against circular follows */
    if (old_room == location)
        return;

    for (fch = old_room->people; fch != NULL; fch = fch_next)
    {
        fch_next = fch->next_in_room;

        /* no following through dead portals */
        if (portal == NULL || portal->value[0] == -1)
            continue;

        if (fch->master != ch || fch->position != POS_STANDING)
            continue;

        if (IS_SET(ch->in_room->room_flags,ROOM_LAW)
                && IS_NPC(fch)
                && IS_SET(fch->pIndexData->act, ACT_AGGRESSIVE))
        {
            act("You can't bring $N into the city.", ch, NULL, fch, TO_CHAR);
            act("You aren't allowed in the city.", fch, NULL, NULL, TO_CHAR);
            continue;
        }

        act("You follow $N.", fch, NULL, ch, TO_CHAR);
        do_enter(fch,argument);
    }

    if (portal != NULL && portal->value[0] == -1)
    {
        act("$p fades out of existence.", ch, portal, NULL, TO_CHAR);
        if (ch->in_room == old_room)
            act("$p fades out of existence.",
                ch, portal, NULL, TO_ROOM);
        else if (old_room->people != NULL)
        {
            act("$p fades out of existence.",
                old_room->people, portal, NULL, TO_CHAR);
            act("$p fades out of existence.",
                old_room->people,portal,NULL,TO_ROOM);
        }
        extract_obj(portal);
    }

    if (JUST_KILLED(ch))
        return;

    /*
     * If someone is following the char, these triggers get
     * activated for the followers before the char,
     * but it's safer this way...
     */
    if (IS_NPC(ch) && HAS_TRIGGER_MOB(ch, TRIG_ENTRY))
        p_percent_trigger(ch, NULL, NULL, NULL, NULL, NULL, TRIG_ENTRY);

    if (!IS_NPC(ch))
    {
        p_greet_trigger( ch, PRG_MPROG );
        p_greet_trigger( ch, PRG_OPROG );
        p_greet_trigger( ch, PRG_RPROG );
    }

}

DO_FUN(do_settraps)
{
    int chance;

    if ((chance = get_skill(ch, gsn_settraps)) == 0)
    {
        char_act("You don't know how to set traps.", ch);
        return;
    }

    if (!ch->in_room)
        return;

    if (IS_SET(ch->in_room->room_flags, ROOM_LAW))
    {
        char_act("A mystical power protects the room.", ch);
        return;
    }

    WAIT_STATE(ch, SKILL(gsn_settraps)->beats);

    if (IS_NPC(ch) || number_percent() <  chance * 7 / 10)
    {
        AFFECT_DATA af,af2;

        check_improve(ch,gsn_settraps,TRUE,1);

        if (is_affected_room(ch->in_room, gsn_settraps))
        {
            char_act("This room has already trapped.", ch);
            return;
        }

        if (is_affected(ch,gsn_settraps))
        {
            char_act("This skill is used too recently.", ch);
            return;
        }

        af.where     = TO_ROOM_AFFECTS;
        af.type      = gsn_settraps;
        af.level     = LVL(ch);
        af.duration  = LVL(ch) / 10;
        af.location  = APPLY_NONE;
        af.modifier  = 0;
        af.bitvector = RAFF_THIEF_TRAP;
        affect_to_room(ch->in_room, &af);

        af2.where     = TO_AFFECTS;
        af2.type      = gsn_settraps;
        af2.level     = LVL(ch);

        if (!IS_IMMORTAL(ch) && IS_PUMPED(ch))
            af2.duration  = 1;
        else
            af2.duration = LVL(ch) / 10;

        af2.modifier  = 0;
        af2.location  = APPLY_NONE;
        af2.bitvector = 0;
        affect_to_char(ch, &af2);
        char_act("You set the room with your trap.", ch);
        act("$n set the room with the trap.", ch, NULL, NULL, TO_ROOM);
        return;
    }
    else
    {
        check_improve(ch, gsn_settraps, FALSE, 1);
        char_act("You failed set the trap.", ch);
        act("$n failed set the trap.",ch,NULL,NULL,TO_ROOM);
    }

    return;
}

DO_FUN(do_thumbling)
{
    int chance, mana;
    AFFECT_DATA af;

    if (IS_NPC(ch) || (chance = get_skill(ch, gsn_thumbling)) == 0)
    {
        char_act("You don't know how to do that.", ch);
        return;
    }

    if (is_affected(ch, gsn_thumbling))
    {
        affect_strip(ch, gsn_thumbling);
        char_act("Ok.", ch);
        return;
    }

    WAIT_STATE(ch, SKILL(gsn_thumbling)->beats);

    mana = SKILL(gsn_thumbling)->min_mana;
    if (ch->mana < mana)
    {
        char_act("You don't have enough power.", ch);
        return;
    }
    if (IS_AFFECTED(ch, AFF_FLYING))
    {
        char_act("Touch the ground first.", ch);
        return;
    }

    if (number_percent() > chance * 9 / 10)
    {
        act("You failed to reach the true source of tennis ball power.",
            ch, NULL, NULL, TO_CHAR);
        act("$n falls to the ground.", ch, NULL, NULL, TO_ROOM);
        check_improve(ch, gsn_thumbling, FALSE, 1);
        ch->mana -= mana / 2;
        return;
    }

    ch->mana -= mana;

    af.where        = TO_AFFECTS;
    af.type         = gsn_thumbling;
    af.level        = ch->level;
    af.duration     = -1;
    af.bitvector    = 0;

    af.modifier     = LVL(ch) / 5;
    af.location     = APPLY_HITROLL;
    affect_to_char(ch, &af);

    af.location     = APPLY_DAMROLL;
    af.bitvector    = AFF_HASTE;
    affect_to_char(ch, &af);

    act("You start to jump like a tennis ball!", ch, NULL, NULL, TO_CHAR);
    act("$n starts to jump like a tennis ball!", ch, NULL, NULL, TO_ROOM);

    check_improve(ch, gsn_thumbling, TRUE, 1);
}

DO_FUN(do_throw_knife)
{
    CHAR_DATA *victim;
    OBJ_DATA *knife;
    char arg1[512],arg2[512];
    bool success;
    int chance,direction;
    int range = (ch->level / 10) + 1;

    if (IS_NPC(ch) || (chance = get_skill(ch, gsn_knife)) == 0)
    {
        char_act("You don't know how to throw a knife.", ch);
        return;
    }

    argument = one_argument(argument, arg1, sizeof(arg1));
    one_argument(argument, arg2, sizeof(arg2));

    if (arg1[0] == '\0' || arg2[0] == '\0')
    {
        char_act("Throw knife what direction and whom?", ch);
        return;
    }

    if (ch->fighting)
    {
        char_act("You cannot concentrate on throwing knifes.", ch);
        return;
    }

    direction = find_exit(ch, arg1);
    if (direction < 0 || direction >= MAX_DIR)
    {
        char_act("Throw which direction and whom?", ch);
        return;
    }

    WAIT_STATE(ch, SKILL(gsn_spear)->beats);

    if ((victim = find_char(ch, arg2, direction, range)) == NULL)
    {
        char_act("They aren't there.", ch);
        return;
    }

    if (!IS_NPC(victim) && victim->desc == NULL)
    {
        char_act("You can't do that.", ch);
        return;
    }

    if (victim == ch)
    {
        char_act("That's pointless.", ch);
        return;
    }

    knife = get_eq_char(ch, WEAR_HOLD);
    if (!knife || knife->pIndexData->item_type != ITEM_WEAPON
            || knife->value[0] != WEAPON_KNIFE)
    {
        char_act("You need a knife to throw!", ch);
        return;
    }

    if (get_eq_char(ch, WEAR_WIELD))
    {
        char_act("Your hand should be free!", ch);
        return;
    }

    if (is_safe(ch, victim))
        return;

    chance = (chance - 50) * 2;
    chance += GET_HITROLL(ch);

    act("You throw $p to $T.", ch, knife, dir_name[ direction ], TO_CHAR);
    act("$n throws $p to $T.", ch, knife, dir_name[ direction ], TO_ROOM);

    obj_from_char(knife);
    do_wear(ch, "knife");
    success = send_arrow(ch, victim, knife, direction, chance,
                         dice(knife->value[1], knife->value[2]));
    check_improve(ch, gsn_knife, success, 1);
}

DO_FUN(do_throw_grenade)
{
    CHAR_DATA *victim;
    OBJ_DATA *grenade;
    char arg1[512],arg2[512];
    bool success;
    int chance,direction;
    int range = (ch->level / 10) + 1;

    if (IS_NPC(ch) || (chance = get_skill(ch, gsn_grenade)) == 0)
    {
        char_act("You don't know how to throw a grenade.", ch);
        return;
    }

    argument = one_argument(argument, arg1, sizeof(arg1));
    one_argument(argument, arg2, sizeof(arg2));

    if (arg1[0] == '\0' || arg2[0] == '\0')
    {
        char_act("Throw grenade what direction and whom?", ch);
        return;
    }

    if (ch->fighting)
    {
        char_act("You cannot concentrate on throwing grenades.", ch);
        return;
    }

    direction = find_exit(ch, arg1);
    if (direction < 0 || direction >= MAX_DIR)
    {
        char_act("Throw grenade what direction and whom?", ch);
        return;
    }

    WAIT_STATE(ch, SKILL(gsn_spear)->beats);

    if ((victim = find_char(ch, arg2, direction, range)) == NULL)
    {
        char_act("They aren't there.", ch);
        return;
    }

    if (!IS_NPC(victim) && victim->desc == NULL)
    {
        char_act("You can't do that.", ch);
        return;
    }

    if (victim == ch)
    {
        char_act("That's pointless.", ch);
        return;
    }

    grenade = get_eq_char(ch, WEAR_HOLD);
    if (!grenade || grenade->pIndexData->item_type != ITEM_WEAPON
            || grenade->value[0] != WEAPON_GRENADE)
    {
        char_act("You need a grenade to throw!", ch);
        return;
    }

    if (get_eq_char(ch, WEAR_WIELD))
    {
        char_act("Your hand should be free!", ch);
        return;
    }

    if (is_safe(ch, victim))
        return;

    chance = (chance - 50) * 2;
    chance += GET_HITROLL(ch);

    act("You throw $p to $T.", ch, grenade, dir_name[ direction ], TO_CHAR);
    act("$n throws $p to $T.", ch, grenade, dir_name[ direction ], TO_ROOM);

    obj_from_char(grenade);
    do_wear(ch, "grenade");
    success = send_arrow(ch, victim, grenade, direction, chance,
                         dice(grenade->value[1], grenade->value[2]));
    check_improve(ch, gsn_grenade, success, 1);
}

DO_FUN(do_snare)
{
    int chance;

    if ((chance = get_skill(ch, gsn_snare)) == 0)
    {
        char_act("You don't know how to set snare.", ch);
        return;
    }

    if (!ch->in_room)
        return;

    if (IS_SET(ch->in_room->room_flags, ROOM_LAW))
    {
        char_act("A mystical power protects the room.", ch);
        return;
    }

    if (ch->in_room->sector_type != SECT_FIELD
            && ch->in_room->sector_type != SECT_FOREST
            && ch->in_room->sector_type != SECT_HILLS)
    {
        char_act("You can do this only in forest.", ch);
        if (ch->in_room->sector_type != SECT_CITY
                ||  ch->in_room->sector_type != SECT_INSIDE
                ||  ch->in_room->sector_type != SECT_MOUNTAIN)
            act("$n trying make hole in ground, for setting a trap.",
                ch, NULL, NULL, TO_ROOM);
        else if (ch->in_room->sector_type != SECT_WATER_SWIM
                 || ch->in_room->sector_type != SECT_WATER_NOSWIM)
            act("$n trying cast his line out into the water... fisherman, maybe.",
                ch, NULL, NULL, TO_ROOM);
        else if (ch->in_room->sector_type != SECT_AIR)
            act("$n tryed to bolt a trap for nearest cloud.",
                ch, NULL, NULL, TO_ROOM);
        return;
    }

    WAIT_STATE(ch, SKILL(gsn_snare)->beats);

    if (IS_NPC(ch) || number_percent() <  chance * 7 / 10)
    {
        AFFECT_DATA af,af2;

        check_improve(ch, gsn_snare, TRUE, 1);

        if (is_affected_room(ch->in_room, gsn_snare))
        {
            char_act("This room has already snared.", ch);
            return;
        }

        if (is_affected(ch, gsn_snare))
        {
            char_act("This skill is used too recently.", ch);
            return;
        }

        af.where    = TO_ROOM_AFFECTS;
        af.type     = gsn_snare;
        af.level    = LVL(ch);
        af.duration = LVL(ch) / 10;
        af.location = APPLY_NONE;
        af.modifier = 0;
        af.bitvector    = RAFF_RANGER_TRAP;
        affect_to_room(ch->in_room, &af);

        af2.where   = TO_AFFECTS;
        af2.type    = gsn_snare;
        af2.level   = LVL(ch);

        if (!IS_IMMORTAL(ch) && IS_PUMPED(ch))
            af2.duration = 1;
        else
            af2.duration = LVL(ch) / 10;

        af2.modifier  = 0;
        af2.location  = APPLY_NONE;
        af2.bitvector = 0;
        affect_to_char(ch, &af2);

        char_act("You set the room with your trap.", ch);
        act("$n set the room with the trap.", ch, NULL, NULL, TO_ROOM);

        return;
    }
    else
    {
        check_improve(ch, gsn_snare, FALSE, 1);
        char_act("You failed set the trap.", ch);
        act("$n faild set the trap.", ch, NULL, NULL, TO_ROOM);
    }
    return;
}

DO_FUN(do_cannon)
{
    CHAR_DATA *victim;
    char arg1[512],arg2[512];
    int dam,dam1,dam2,mana;
    int chance,direction,range;
    int autoshots;
    int level= LVL(ch);

    if (IS_NPC(ch) || (chance = get_skill(ch, gsn_cannon)) == 0)
    {
        char_act("Cannon? What is this?", ch);
        return;
    }

    argument = one_argument(argument, arg1, sizeof(arg1));
    one_argument(argument, arg2, sizeof(arg2));

    /*
        if (arg1[0] == '\0' || arg2[0] == '\0') {
        char_act("      !?", ch);
        return;
        }
    */

    if (arg1[0] != '\0' || arg2[0] != '\0')
    {
        direction = find_exit(ch, arg1);
        if (direction < 0 || direction >= MAX_DIR)
        {
            char_act("Shoot what direction and whom?", ch);
            return;
        }

        range = (1 + (get_skill(ch, gsn_range_master_unit)/50)
                 + (get_skill(ch, gsn_achilles_targeting_unit)/30));
        check_improve(ch, gsn_range_master_unit, TRUE, 1);
        check_improve(ch, gsn_achilles_targeting_unit, TRUE, 1);

        if ((victim = find_char(ch, arg2, direction, range)) == NULL)
        {
            WAIT_STATE(ch, MISSING_TARGET_DELAY);
            return;
        }

        if (IS_NPC(victim) &&  victim->in_room != ch->in_room)
        {
            if (room_is_private(ch->in_room))
            {
                char_act("You can't use cannon in privat room.", ch);
                WAIT_STATE(ch, SKILL(gsn_cannon)->beats);
                return;
            }

            if (IS_SET(victim->pIndexData->act, ACT_NOTRACK)
                    && !IS_AFFECTED(victim, AFF_CHARM))
            {
                act_puts("You can't shoot $N with such distances.",
                         ch, NULL, victim, TO_CHAR, POS_DEAD);
                WAIT_STATE(ch, SKILL(gsn_cannon)->beats);
                return;
            }
        }
    }
    else
    {
        direction = 0;
        victim = ch->fighting;
        if (victim == NULL || victim->in_room != ch->in_room)
        {
            char_act("Shoot what direction and whom?", ch);
            WAIT_STATE (ch, MISSING_TARGET_DELAY);
            return;
        }
    }

    WAIT_STATE(ch, SKILL(gsn_cannon)->beats);

    if (!IS_NPC(victim) && victim->desc == NULL)
    {
        char_act("You can't do that.", ch);
        return;
    }

    if (victim == ch)
    {
        char_act("That's pointless.", ch);
        return;
    }

    mana = (SKILL(gsn_cannon)->min_mana + level);
    if (ch->mana < mana)
    {
        char_act("You don't have enough power.", ch);
        return;
    }
    ch->mana -= mana;

    act("$n shoot $N from cannon.", ch, NULL, victim, TO_NOTVICT);
    act("$n shoot you from cannon!", ch, NULL, victim, TO_VICT);
    act("You shoot $N from cannon!", ch, NULL, victim, TO_CHAR);

    if (is_safe(ch, victim))
        return;

    if (number_percent() >= chance)
    {
        damage(ch, victim, 0, gsn_cannon, DAM_FIRE, TRUE);
        path_to_track(ch,victim,direction);
        check_improve(ch, gsn_cannon, FALSE, 1);
        return;
    }

    autoshots = get_skill(ch, gsn_auto_cannon) / 45;

    if (IS_AFFECTED(ch, AFF_HASTE)
            && number_percent() < get_curr_stat(ch, STAT_LCK))
        autoshots++;
    if (IS_AFFECTED(ch, AFF_SLOW)
            && number_percent() > get_curr_stat(ch, STAT_LCK))
        autoshots--;

    autoshots = UMAX(1, autoshots);
    check_improve(ch, gsn_auto_cannon, TRUE, 1);

    while (autoshots--)
    {
        // 1+5+10=16
        dam1 = (1 + (get_skill(ch, gsn_damage_control) / 20)
                + (get_skill(ch, gsn_adv_damage_control) / 10));
        // 1+8+8 =17
        dam2 = (1 + (get_skill(ch, gsn_damage_control) / 12)
                + (get_skill(ch, gsn_adv_damage_control) / 12));

        check_improve(ch, gsn_damage_control, TRUE, 1);
        check_improve(ch, gsn_adv_damage_control, TRUE, 1);

        dam = number_range(level * dam1, level * dam2);

        if (direction > 0)
        {
            if (check_dodge(ch, victim))
                dam -= dam / 4;
        }
        else
        {
            if (check_dodge(ch, victim))
                dam -= dam / 8;
        }

        if (IS_NPC(victim))
            dam *= 2;

        if ((saves_spell(level, victim, DAM_FIRE) && ch->pcdata->element == 1)
                || (saves_spell(level, victim, DAM_COLD) && ch->pcdata->element == 2)
                || (saves_spell(level, victim, DAM_ENERGY) && ch->pcdata->element == 3)
                || (saves_spell(level, victim, DAM_SOUND) && ch->pcdata->element == 4))
            dam /= 2;
        else
        {
            if (number_percent() < get_skill(ch, gsn_cannon))
            {
                if (ch->pcdata->element == 1) // FIRE
                    fire_effect(victim, level, dam * 2 / 3, TARGET_CHAR);
                else if (ch->pcdata->element == 2) // COLD
                    cold_effect(victim, level, dam * 2 / 3, TARGET_CHAR);
                else if (ch->pcdata->element == 4) // SOUND
                    sound_effect(victim, level, dam * 2 / 3, TARGET_CHAR);
                else if (ch->pcdata->element == 3) // ENERGY
                {
                    if (is_affected(victim, gsn_protective_shield)
                            && number_percent() < 45)
                    {
                        act_puts("    ,  $N.",
                                 ch, NULL, victim, TO_CHAR, POS_FIGHTING);
                        act_puts(" $n    .",
                                 ch, NULL, victim, TO_VICT, POS_FIGHTING);
                        act_puts(" $n     $N.",
                                 ch, NULL, victim, TO_NOTVICT, POS_FIGHTING);
                        affect_strip(victim, gsn_protective_shield);
                    }
                    if (is_affected(victim, gsn_shield)
                            && number_percent() < 60)
                    {
                        act_puts("    ,  $N.",
                                 ch, NULL, victim, TO_CHAR, POS_FIGHTING);
                        act_puts(" $n    .",
                                 ch, NULL, victim, TO_VICT, POS_FIGHTING);
                        act_puts(" $n     $N.",
                                 ch, NULL, victim, TO_NOTVICT, POS_FIGHTING);
                        affect_strip(victim, gsn_shield);
                    }
                    if (is_affected(victim, gsn_field)
                            && number_percent() < 30)
                    {
                        act_puts("    ,  $N.",
                                 ch, NULL, victim, TO_CHAR, POS_FIGHTING);
                        act_puts(" $n  ϣ  .",
                                 ch, NULL, victim, TO_VICT, POS_FIGHTING);
                        act_puts(" $n     $N.",
                                 ch, NULL, victim, TO_NOTVICT, POS_FIGHTING);
                        affect_strip(victim, gsn_field);
                    }
                }
            }
        }

        if (JUST_KILLED(victim))
            return;

        if (ch->pcdata->element == 1)
            damage(ch, victim, dam, gsn_cannon, DAM_FIRE, TRUE);
        else if (ch->pcdata->element == 2)
            damage(ch, victim, dam, gsn_cannon, DAM_COLD, TRUE);
        else if (ch->pcdata->element == 3)
            damage(ch, victim, dam, gsn_cannon, DAM_ENERGY, TRUE);
        else if (ch->pcdata->element == 4)
            damage(ch, victim, dam, gsn_cannon, DAM_SOUND, TRUE);
        else
            damage(ch, victim, dam / 2, gsn_cannon, DAM_FIRE, TRUE);

        if (JUST_KILLED(victim))
            return;
    }
    if (victim->in_room != ch->in_room)
        path_to_track(ch,victim,direction);
}

DO_FUN(do_castout)
{
    OBJ_DATA * pole;
    int fail, sk;

    if (IS_SET(ch->comm, COMM_FISHING))
    {
        act("You are already fishing!", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((pole = get_eq_char(ch, WEAR_HOLD)) == NULL
            || pole->pIndexData->item_type != ITEM_POLE)
    {
        act("You need to be holding a fishing pole first.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (!ch->in_room
            || (!IS_SET(ch->in_room->room_flags, ROOM_SALTWATER_FISH)
                && !IS_SET(ch->in_room->room_flags, ROOM_FRESHWATER_FISH)))
    {
        act("This is not a good place to fish, you'll want to find a better spot.",
            ch, NULL, NULL, TO_CHAR);
        return;
    }

    fail = number_percent();
    if (IS_AFFECTED(ch, AFF_BLIND))
    {
        sk = get_skill(ch, gsn_blind_fishing);
        if (number_percent() < sk)
            check_improve(ch, gsn_blind_fishing, TRUE, 1);
        else
        {
            check_improve(ch, gsn_blind_fishing, FALSE, 1);
            fail = -30;
            if( sk == 0 )
            {
                act("You don't know how to fish blinded.", ch, NULL, NULL, TO_CHAR);
                return;
            }
        }
    }

    if (is_affected(ch, gsn_deafen))
    {
        sk = get_skill(ch, gsn_mute_fishing);
        if (number_percent() < sk)
            check_improve(ch, gsn_mute_fishing, TRUE, 1);
        else
        {
            check_improve(ch, gsn_mute_fishing, FALSE, 1);
            fail = -30;
            if (sk == 0)
            {
                act("You don't know how to fish deafened.", ch, NULL, NULL, TO_CHAR);
                return;
            }
        }
    }

    if(MOUNTED(ch))
    {
        if (!(sk = get_skill (ch, gsn_mounted_fishing)))
        {
            act("You don't know how to fish mounted.", ch, NULL, NULL, TO_CHAR);
            return;
        }
        if(number_percent() < sk - 3)
        {
            act("You are tangled with $N and fall down.", ch, NULL, ch->mount, TO_CHAR);
            act("$n is tangled with you and falls down.", ch, NULL, ch->mount, TO_VICT);
            act("$n is tangled with $N and falls down.", ch, NULL, ch->mount, TO_NOTVICT);
            if(ch->mount != NULL && ch->mount != ch)
            {
                ch->mount->mount = NULL;
                ch->mount->position = POS_RESTING;
            }
            ch->mount = NULL;
            ch->position = POS_RESTING;
            damage (ch, ch, dice(4,6), gsn_mounted_fishing, DAM_BASH, TRUE);
            WAIT_STATE(ch, 15);
            check_improve (ch, gsn_mounted_fishing, FALSE, 1);
            return;
        }
        else
            check_improve(ch, gsn_mounted_fishing, TRUE, 1);
    }

    // check for mastering fishing
    sk = get_skill(ch, gsn_mastering_fishing);
    if (number_percent() < sk-9 )
    {
        check_improve(ch, gsn_mastering_fishing, TRUE, 2);
        fail *= 3;
    }
    else
        check_improve(ch, gsn_mastering_fishing, FALSE, 2);

    // check for improved fishing
    sk = get_skill(ch, gsn_improved_fishing);
    if ( number_percent() < sk-10 )
    {
        check_improve(ch, gsn_improved_fishing, TRUE, 2);
        fail += 15;
    }
    else
        check_improve(ch, gsn_improved_fishing, FALSE, 2);

    // check for expert fishing
    sk = get_skill(ch, gsn_expert_fishing);
    if( number_percent() < (sk - 8) && fail > 0)
    {
        check_improve(ch, gsn_expert_fishing, TRUE, 2);
        fail = 100;
    }
    else
        check_improve(ch, gsn_expert_fishing, FALSE, 2);

    if (fail <= 30
            && number_percent() > (get_skill(ch, gsn_craft_fishing) - 5))
    {
        act("You pull your arm back and try to cast out your line, but "
            "it gets all tangled up.\r\nTry again.",
            ch, 0, 0, TO_CHAR);
        act("$n pulls $gn{his} arm back, trying to cast $gn{his} fishing line out into the "
            "water,\r\nbut ends up just a bit tangled.",
            ch, 0, 0, TO_ROOM);
        check_improve(ch, gsn_fishing, FALSE, 4);
        check_improve(ch, gsn_craft_fishing, FALSE, 6);
        WAIT_STATE(ch, 23 * 100 /
                   (100 +
                    get_skill(ch, gsn_mastering_fishing)/2 +
                    get_skill(ch, gsn_improved_fishing))/2 );
        return;
    }

    // Ok, now they've gone through the checks, now set them fishing
    SET_BIT(ch->comm, COMM_FISHING);
    act("You cast your line out into the water, hoping for a bite.",
        ch, 0, 0, TO_CHAR);
    act("$n casts $gn{his} line out into the water, hoping to catch some food.",
        ch, 0, 0, TO_ROOM);
    check_improve(ch, gsn_fishing, TRUE, 4);
    check_improve(ch, gsn_craft_fishing, TRUE, 6);
    WAIT_STATE(ch, 25 * 100 /
               (100 +
                get_skill(ch, gsn_improved_fishing) / 2 +
                get_skill(ch, gsn_craft_fishing)) );
    return;
}

DO_FUN(do_reelin)
{
    int success, fish_num, sk;
    OBJ_DATA *pole;
    OBJ_DATA *fish;

    if (!IS_SET(ch->comm, COMM_FISHING))
    {
        act("You aren't even fishing!", ch, 0, 0, TO_CHAR);
        return;
    }

    if (!IS_SET(ch->comm, COMM_FISH_ON)
            && (number_percent() > get_skill(ch, gsn_craft_fishing)/4))
    {
        act("You reel in your line, but alas... nothing on the end.\r\n"
            "Better luck next time.", ch, 0, 0, TO_CHAR);
        REMOVE_BIT(ch->comm, COMM_FISHING);
        act("$n reels $gn{his} line in, but with nothing on the end.",
            ch, 0, 0, TO_ROOM);
        check_improve(ch, gsn_fishing, FALSE, 8);
        check_improve(ch, gsn_craft_fishing, FALSE, 8);
        WAIT_STATE(ch, 27 * 100 /
                   (100 +
                    get_skill(ch, gsn_mastering_fishing) /2 +
                    get_skill(ch, gsn_craft_fishing) / 2));
        return;
    }

    REMOVE_BIT(ch->comm, COMM_FISHING);
    REMOVE_BIT(ch->comm, COMM_FISH_ON);

    // Ok, they are fishing and have a fish on
    success = number_percent() + get_skill(ch, gsn_fishing)/10;

    if (ch->carry_number >= can_carry_n(ch))
    {
        char_act("You need some space in inventory for fish.", ch);
        return;
    }
    if (get_carry_weight(ch) >= can_carry_w(ch))
    {
        char_act("You can't carry any fish.", ch);
        return;
    }

    if ((pole = get_eq_char(ch, WEAR_HOLD)) == NULL
            || pole->pIndexData->item_type != ITEM_POLE)
    {
        act("You need to be holding a fishing pole first.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if (IS_AFFECTED(ch, AFF_BLIND))
    {
        sk = get_skill(ch, gsn_blind_fishing);
        if (number_percent() < sk)
            check_improve(ch, gsn_blind_fishing, TRUE, 1);
        else
        {
            check_improve(ch, gsn_blind_fishing, FALSE, 1);
            success -= 30;
            if (sk == 0)
            {
                act("You don't know how to fish blinded.", ch, NULL, NULL, TO_CHAR);
                return;
            }
        }
    }

    if (MOUNTED(ch))
    {
        if (!(sk = get_skill(ch, gsn_mounted_fishing)))
        {
            act("You don't know how to fish mounted.", ch, NULL, NULL, TO_CHAR);
            return;
        }
        if (number_percent() < sk - 3)
        {
            act("You are tangled with $N and fall down.", ch, NULL, ch->mount, TO_CHAR);
            act("$n is tangled with you and falls down.", ch, NULL, ch->mount, TO_VICT);
            act("$n is tangled with $N and falls down.", ch, NULL, ch->mount, TO_NOTVICT);
            if (ch->mount != NULL && ch->mount != ch)
            {
                ch->mount->mount = NULL;
                ch->mount->position = POS_RESTING;
            }
            ch->mount = NULL;
            ch->position = POS_RESTING;
            damage(ch, ch, dice(4,6), TYPE_UNDEFINED, DAM_BASH, TRUE);
            damage(ch, ch, dice(4,6), gsn_mounted_fishing, DAM_BASH, TRUE);
            WAIT_STATE(ch, 15 * 100 /
                       (100 + get_skill(ch, gsn_mastering_fishing)));
            check_improve(ch, gsn_mounted_fishing, FALSE, 1);
            return;
        }
        else
            check_improve(ch, gsn_mounted_fishing, TRUE, 1);
    }

    sk = get_skill(ch, gsn_mastering_fishing);
    if ( number_percent() < sk-9 )
    {
        check_improve(ch, gsn_mastering_fishing, TRUE, 1);
        success *= 2;
    }
    else
        check_improve(ch, gsn_mastering_fishing, FALSE, 1);

    sk = get_skill(ch, gsn_improved_fishing);
    if ( number_percent() < sk-10 )
    {
        check_improve(ch, gsn_improved_fishing, TRUE, 1);
        success += 20;
    }
    else
        check_improve(ch, gsn_improved_fishing, FALSE, 1);

    sk = get_skill(ch, gsn_expert_fishing);
    if ( number_percent() < (sk - 8) && success > 0)
    {
        check_improve(ch, gsn_expert_fishing, TRUE, 1);
        success = 100;
    }
    else
        check_improve(ch, gsn_expert_fishing, FALSE, 1);

    if (success <= 60
            && number_percent() > (get_skill(ch, gsn_craft_fishing) - 7))
    {
        act("You reel in your line, putting up a good fight, but you "
            "lose him!\r\nTry again?", ch, 0, 0, TO_CHAR);
        act("$n reels $gn{his} line in, fighting with whatever is on the end, but loses "
            "the catch.", ch, 0, 0, TO_ROOM);
        check_improve(ch, gsn_fishing, FALSE, 2);
        check_improve(ch, gsn_craft_fishing, FALSE, 1);
        WAIT_STATE(ch, 29 * 100 /
                   (100 +
                    get_skill(ch, gsn_improved_fishing) +
                    get_skill(ch, gsn_mastering_fishing)/2) );
        SET_FIGHT_TIME(ch);
        return;
    }

    check_improve(ch, gsn_winter_fishing, TRUE, 1);
    check_improve(ch, gsn_outraging_fishing, TRUE, 1);
    check_improve(ch, gsn_fishing, TRUE, 1);
    check_improve(ch, gsn_craft_fishing, TRUE, 1);

    if ( skill_level(ch, gsn_fishing) > 1)
        set_skill (ch, gsn_fishing, 2);
    update_special_skills (ch, TRUE);

    if (ch->pcdata)
        ++ch->pcdata->fishes_caught;

    // black scroll
    if (number_range (1,8)==1
            && !IS_SET(ch->in_room->room_flags, ROOM_PEACE))
    {
        fish = create_obj(get_obj_index(30148), 0);
        act("You reel in a strange bottle, it contains $p! Very nice catch!",
            ch, fish, 0, TO_CHAR);
        act("WOW! $n reels in a strange bottle, containing $p!",
            ch, fish, 0, TO_ROOM);
        fish->level = ch->level;
        fish->value[0] = fish->level + 10;
        obj_to_char(fish, ch);
        WAIT_STATE(ch, 48);
        gain_exp(ch, number_range (ch->level/2, ch->level*3/2));
        SET_FIGHT_TIME(ch);
        return;
    }

    if (IS_SET(ch->in_room->room_flags, ROOM_SALTWATER_FISH))
    {
        fish_num = fish_number(0);
        fish = create_obj(get_obj_index(fish_num), 0);
        act("You reel in $p! Nice catch!", ch, fish, 0, TO_CHAR);
        act("Wow! $n reels in a helluva catch! Looks like $p!",
            ch, fish, 0, TO_ROOM);
        obj_to_char(fish, ch);
        WAIT_STATE(ch, 36 * 100 /
                   (100 +
                    get_skill(ch, gsn_improved_fishing)*2/3 +
                    get_skill(ch, gsn_mastering_fishing)*2/3 +
                    get_skill(ch, gsn_craft_fishing)*2/3) );
        SET_FIGHT_TIME(ch);
        if (!IS_SET(ch->in_room->room_flags, ROOM_PEACE))
        {
            if (number_range(1,6) < 5)
                gain_exp(ch, number_range (ch->level/2 + 10, ch->level*3/2));
            else
            {
                int add_qp = number_range(1,4);
                ch->pcdata->questpoints += add_qp;
                ch->pcdata->qp_earned += add_qp;
            }
        }

        if (number_percent() < (30-get_curr_stat(ch,STAT_LCK)))
        {
            CHAR_DATA *demon;
            int i, level, bonus;
            demon = create_mob(get_mob_index(30100));
            level = LVL(ch) + 3;
            bonus = 5 + level/7;
            for (i=0;i < MAX_STATS; i++)
            {
                demon->perm_stat[i] = ch->perm_stat[i];
            }
            demon->max_hit = 4 * URANGE(ch->pcdata->perm_hit,ch->hit,30000);
            demon->hit = demon->max_hit;
            demon->max_mana = 3 * ch->pcdata->perm_mana;
            demon->mana = demon->max_mana;
            demon->level = ch->level + bonus;
            demon->hitroll = 20 + 3*level/2;
            for (i=0; i < 3; i++)
                demon->armor[i] = interpolate(demon->level,100,-100);
            demon->armor[3] = interpolate(demon->level,100,0);
            demon->gold = 0;
            demon->timer = 0;
            demon->damage[DICE_NUMBER] = number_range(level/15, level/10);
            demon->damage[DICE_TYPE] = number_range(level/3, level/2);
            demon->damage[DICE_BONUS] = number_range(level/2, level);
            char_to_room(demon, ch->in_room);
            if (number_range(1,50) > get_curr_stat(ch,STAT_LCK))
                multi_hit(demon, ch, TYPE_UNDEFINED);
        }
        return;
    }
    else if (IS_SET(ch->in_room->room_flags, ROOM_FRESHWATER_FISH))
    {
        fish_num = fish_number(1);
        fish = create_obj(get_obj_index(fish_num), 0);
        act("You reel in $p! Nice catch!", ch, fish, 0, TO_CHAR);
        obj_to_char(fish, ch);
        WAIT_STATE(ch, 33 * 100 /
                   (100 +
                    get_skill(ch, gsn_improved_fishing)*2/3 +
                    get_skill(ch, gsn_mastering_fishing)*2/3 +
                    get_skill(ch, gsn_craft_fishing)*2/3) );

        SET_FIGHT_TIME(ch);
        if (!IS_SET(ch->in_room->room_flags, ROOM_PEACE))
        {
            if (number_range(1,8) < 6)
                gain_exp(ch, number_range (ch->level/2 + 10, ch->level*5/3));
            else
            {
                int add_qp = number_range(2,3);
                ch->pcdata->questpoints += add_qp;
                ch->pcdata->qp_earned += add_qp;
            }
        }
        if (number_percent() < (30-get_curr_stat(ch,STAT_LCK)))
        {
            CHAR_DATA *demon;
            int i, level, bonus;
            demon = create_mob(get_mob_index(30106));
            level = LVL(ch) + 3;
            bonus = 4 + level/6;
            for (i=0;i < MAX_STATS; i++)
            {
                demon->perm_stat[i] = ch->perm_stat[i];
            }
            demon->max_hit = 4 * URANGE(ch->pcdata->perm_hit,ch->hit,30000);
            demon->hit = demon->max_hit;
            demon->max_mana = 3 * ch->pcdata->perm_mana;
            demon->mana = demon->max_mana;
            demon->level = ch->level + bonus;
            demon->hitroll = 15 + 5*level/3;
            for (i=0; i < 3; i++)
                demon->armor[i] = interpolate(demon->level,100,-100);
            demon->armor[3] = interpolate(demon->level,100,0);
            demon->gold = 0;
            demon->timer = 0;
            demon->damage[DICE_NUMBER] = number_range(level/15, level/10);
            demon->damage[DICE_TYPE] = number_range(level/3, level/2);
            demon->damage[DICE_BONUS] = number_range(level/2, level);
            char_to_room(demon, ch->in_room);
            if (number_range(1,45) > get_curr_stat(ch, STAT_LCK))
                multi_hit(demon, ch, TYPE_UNDEFINED);
        }
        return;
    }
    else
        act("You should never see this message, please report it.",
            ch, 0, 0, TO_CHAR);
    return;
}

// find vnum for fish caught
int fish_number (int type)
{
    int fsize, ssize;
    int fresh[] =
        { 30100, 30101, 30102, 30103, 30104, 30105, 30106, 30107,
          30108, 30130, 30131, 30132, 30133, 30134, 30135, 30136,
          30137, 30139, 30140, 30157, 30158, 30159, 30160, 30161,
          30162, 30163, 30164, 30165, 30166, 30167, 30168, 30169,
          30170, 30114, 30154, 0 };
    int salt[] =
        { 7512,  19057, 9564,  30100, 30109, 30138, 30141, 30151,
          30152, 0};

    for (fsize = 0; fresh[fsize] != 0; fsize++)
        ;
    for (ssize = 0; salt[ssize] != 0; ssize++)
        ;

    if (type == 0)
        return salt[number_range(0, ssize-1)];
    else
        return fresh[number_range(0, fsize-1)];
}

void do_forest(CHAR_DATA* ch, const char* argument)
{
    char arg[MAX_STRING_LENGTH];
    AFFECT_DATA af;
    bool attack;

    if (IS_NPC(ch) || !get_skill(ch, gsn_forest_fighting))
    {
        char_act("Huh?", ch);
        return;
    }

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        char_act("Usage: forest {{ attack|defence|normal}", ch);
        return;
    }

    if (!str_prefix(arg, "normal"))
    {
        if (!is_affected(ch, gsn_forest_fighting))
        {
            char_act("You do not use your knowledge of forest in fight.", ch);
            return;
        }
        else
        {
            char_act("You stop using your knowledge of forest in fight.", ch);
            affect_strip(ch, gsn_forest_fighting);
            return;
        }
    }

    if (!str_prefix(arg, "defence"))
        attack = FALSE;
    else if (!str_prefix(arg, "attack"))
        attack = TRUE;
    else
    {
        do_forest(ch, str_empty);
        return;
    }

    if (is_affected(ch, gsn_forest_fighting))
        affect_strip(ch, gsn_forest_fighting);

    check_improve (ch, gsn_forest_fighting, TRUE, 8);

    af.where        = TO_AFFECTS;
    af.type         = gsn_forest_fighting;
    af.level        = ch->level;
    af.duration     = -1;
    af.bitvector    = 0;

    if (attack)
    {
        af.modifier = LVL(ch)/8;
        af.location = APPLY_HITROLL;
        affect_to_char(ch, &af);
        af.location = APPLY_DAMROLL;
        char_act("You feel yourself wild.", ch);
        act("$n looks wild.", ch, NULL, NULL, TO_ROOM);
    }
    else
    {
        af.modifier = -LVL(ch);
        af.location = APPLY_AC;
        char_act("You feel yourself protected.", ch);
        act("$n looks protected.", ch, NULL, NULL, TO_ROOM);
    }
    affect_to_char(ch, &af);
}

DO_FUN (do_shiftweapon)
{
    OBJ_DATA *  weapon, * sec_weapon;

    weapon = get_eq_char(ch, WEAR_WIELD);
    sec_weapon = get_eq_char(ch, WEAR_SECOND_WIELD);
    if ( !weapon || !sec_weapon )
    {
        char_act("You must try to equip two weapons first.", ch);
        return;
    }

    if (IS_SET(sec_weapon->extra_flags, ITEM_NOREMOVE))
    {
        act_puts("    $p.", ch, sec_weapon, NULL, TO_CHAR, POS_DEAD);
        return;
    }

    unequip_char(ch, sec_weapon);
    if ((sec_weapon->pIndexData->item_type == ITEM_WEAPON)
            && IS_OBJ_STAT(sec_weapon, ITEM_DEATH))
    {
        act("The black mist around $p fades away.", ch, sec_weapon, NULL, TO_ALL);
        REMOVE_BIT(sec_weapon->extra_flags, ITEM_DEATH);
    }
    if ((sec_weapon->pIndexData->item_type == ITEM_WEAPON)
            && IS_OBJ_STAT(sec_weapon, ITEM_SINGING))
    {
        act("$p .", ch, sec_weapon, NULL, TO_ALL);
        REMOVE_BIT(sec_weapon->extra_flags,ITEM_SINGING);
    }

    if (IS_SET(weapon->extra_flags, ITEM_NOREMOVE))
    {
        act_puts("    $p.", ch, weapon, NULL, TO_CHAR, POS_DEAD);
        return;
    }

    unequip_char(ch, weapon);
    if ((weapon->pIndexData->item_type == ITEM_WEAPON) && IS_OBJ_STAT(weapon, ITEM_DEATH))
    {
        act("The black mist around $p fades away.", ch, weapon, NULL, TO_ALL);
        REMOVE_BIT(weapon->extra_flags, ITEM_DEATH);
    }
    if ((weapon->pIndexData->item_type == ITEM_WEAPON) && IS_OBJ_STAT(weapon, ITEM_SINGING))
    {
        act("$p .", ch, weapon, NULL, TO_ALL);
        REMOVE_BIT(weapon->extra_flags, ITEM_SINGING);
    }


    if (equip_char(ch, sec_weapon, WEAR_WIELD) == NULL)
        return;
    if (equip_char(ch, weapon, WEAR_SECOND_WIELD) == NULL)
        return;

    if (is_affected(ch, gsn_deathgrip) && !IS_OBJ_STAT(weapon, ITEM_DEATH))
    {
        SET_BIT(weapon->extra_flags, ITEM_DEATH);
        act("$p flickers with dark power.", ch, weapon, NULL, TO_ALL);
    }

    if (!is_affected(ch, gsn_deathgrip) && IS_OBJ_STAT(weapon, ITEM_DEATH))
    {
        REMOVE_BIT(weapon->extra_flags, ITEM_DEATH);
    }

    if (is_affected(ch, gsn_weaponsong) && !IS_OBJ_STAT(weapon, ITEM_SINGING))
    {
        int my_chance = get_skill(ch, gsn_weaponsong);

        if (IS_WEAPON_STAT(weapon, WEAPON_FLAMING))
            my_chance -= 10;
        if (IS_WEAPON_STAT(weapon, WEAPON_FROST))
            my_chance -= 10;
        if (IS_WEAPON_STAT(weapon, WEAPON_SHARP))
            my_chance -= 10;
        if (IS_WEAPON_STAT(weapon, WEAPON_VORPAL))
            my_chance -= 10;
        if (IS_WEAPON_STAT(weapon, WEAPON_SHOCKING))
            my_chance -= 10;
        if (IS_WEAPON_STAT(weapon, WEAPON_RADIATION))
            my_chance -= 10;

        /*        if (ch->mana > ch->level)
                    ch->mana -= ch->level;
                else
                {
                    char_act("   .. ", ch);
                    my_chance = 0;
                }*/

        if (number_percent() < my_chance)
        {
            SET_BIT( weapon->extra_flags, ITEM_SINGING);
            act("$p     .", ch, weapon, NULL, TO_CHAR);
            act("$p     $n.", ch, weapon, ch, TO_NOTVICT);
        }
        else
        {
            act("$p ..", ch, weapon, NULL, TO_CHAR);
        }
    }

    if (!is_affected(ch, gsn_weaponsong) && IS_OBJ_STAT(weapon, ITEM_SINGING))
    {
        REMOVE_BIT(weapon->extra_flags, ITEM_SINGING);
    }

    act("$n swiftly shifts weapons.", ch, NULL, NULL, TO_ROOM);
    char_act("You shift your weapons.", ch);
}
