/*  $Id: act_obj.c,v 1.666 2004/09/20 10:49:46 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
 /************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/


#include <sys/types.h>
#if !defined (WIN32)
#include <sys/time.h>
#endif
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "merc.h"
#include "quest.h"
#include "update.h"
#include "mob_prog.h"
#include "obj_prog.h"
#include "fight.h"
#include "conquer.h"
#include "war.h"
#include "gambling.h"
#include "shamans.h"

extern STAT_DATA stat_record;

void interpret_social(social_t *soc, CHAR_DATA *ch, const char *argument);

DECLARE_DO_FUN(do_split     );
DECLARE_DO_FUN(do_say       );
DECLARE_DO_FUN(do_scan      );
DECLARE_DO_FUN(do_mount     );
DECLARE_DO_FUN(do_yell      );
DECLARE_DO_FUN(do_dismount  );
DECLARE_DO_FUN(do_lore_area );

void agent_net_printf(CHAR_DATA *ch, CHAR_DATA *victim, int);
/*
 * Local functions.
 */
CHAR_DATA * find_keeper (CHAR_DATA * ch);
uint        get_cost    (CHAR_DATA * keeper, OBJ_DATA * obj, bool fBuy);
void        obj_to_keeper   (OBJ_DATA * obj, CHAR_DATA * ch);
OBJ_DATA *  get_obj_keeper  (CHAR_DATA * ch, CHAR_DATA * keeper,
                             const char *argument);
void        sac_obj     (CHAR_DATA * ch, OBJ_DATA *obj);
void        sac_obj_all     (CHAR_DATA * ch, OBJ_DATA *obj);
AFFECT_DATA *   affect_find (AFFECT_DATA * paf, int sn);

CHAR_DATA * find_forger args ((CHAR_DATA * ch));

CHAR_DATA * find_forger (CHAR_DATA *ch)
{
    CHAR_DATA * forger;

    for (forger = ch->in_room->people; forger != NULL; forger = forger->next_in_room)
    {
        if (!IS_NPC(forger))
            continue;

        if (IS_NPC(forger) && IS_SET(forger->pIndexData->act, ACT_FORGER))
            return forger;
    }

    if (forger == NULL)
    {
        char_act("You can't do that here.", ch);
        return NULL;
    }

    return NULL;
}

void do_forger( CHAR_DATA *ch, const char *argument )
{
    OBJ_DATA  * obj;
    CHAR_DATA * forger;
    char    weapon[MAX_INPUT_LENGTH];
    char *  words;
    int     cost = 0;

    if (IS_NPC(ch))
        return;

    forger = find_forger(ch);

    if (!forger)
        return;

    if (argument[0] == '\0')
    {
        act("       {C$N{x offers following improvements : ", ch, NULL, forger, TO_CHAR);
        char_act("{c--------------------------------------------------{x", ch);
        char_act("{w  bless      {g:{w bless object             {g|{w  {W   5 {CQP{x", ch);
        char_act("{w  poison     {g:{w poison weapon            {g|{w  {W   5 {CQP{x", ch);
        char_act("{w  sharp      {g:{w sharp weapon             {g|{w  {W  20 {CQP{x", ch);
        char_act("{w  flame      {g:{w flaming weapon           {g|{w  {W1800 {CQP{x", ch);
        char_act("{w  drain      {g:{w vampiric weapon          {g|{w  {W1800 {CQP{x", ch);
        char_act("{w  shocking   {g:{w electric weapon          {g|{w  {W1800 {CQP{x", ch);
        char_act("{w  frost      {g:{w frost weapon             {g|{w  {W1800 {CQP{x", ch);
        char_act("{w  vorpal     {g:{w vorpal weapon            {g|{w  {W 800 {CQP{x", ch);
        char_act("{w  nodrop     {g:{w make nodrop object       {g|{w  {W 800 {CQP{x", ch);
        char_act("{w  noremove   {g:{w make noremove weapon     {g|{w  {W 800 {CQP{x", ch);
//        char_act("{w  enchant    {g:{w enchant weapon           {g|{w  {W 800 {CQP{x", ch);
        char_act("{w  fireproof  {g:{w make fireproof object    {g|{w  {W1000 {CQP{x", ch);
        char_act("{w  noalign    {g:{w remove object aligment   {g|{w  {W1500 {CQP{x", ch);
        char_act("{w  noloot     {g:{w make noloot object       {g|{w  {W9999 {CQP{x", ch);
        char_act("{w hidurability{g:{w make hidurability object {g|{w  {W1500 {CQP{x", ch);
        char_act("{w indestructab{g:{w make indestructable objec{g|{w  {W5000 {CQP{x", ch);
//  char_act("{w  radiation  {g:{w radiation weapon         {g|{w  {W5000 {CQP{x", ch);
        char_act("{c--------------------------------------------------{x", ch);
        char_act("       Type {Cforger <object> <type>{x for forger ", ch);
        char_act("            and pray GrayMage for success.        ", ch);
        return;
    }

    argument = one_argument( argument, weapon, sizeof(weapon));

    if ((obj = get_obj_carry(ch, weapon)) == NULL)
    {
        act("$N says : '{GYou're not carrying that.{x'", ch, NULL, forger, TO_CHAR);
        return;
    }

    if (!str_prefix(argument,"fireproof"))
        cost = 2;
    if (!str_prefix(argument,"hidurability"))
        cost = 2;
    if (!str_prefix(argument,"indestructable"))
        cost = 2;
    if (!str_prefix(argument,"bless"))
        cost = 2;
    if (!str_prefix(argument,"nodrop"))
        cost = 2;
    if (!str_prefix(argument,"noalign"))
        cost = 2;
    if (!str_prefix(argument,"noloot"))
        cost = 2;

    if (obj->pIndexData->item_type != ITEM_WEAPON && cost != 2)
    {
        act("$N says : '{GThis is not a weapon! See menu difference: {wobject{G and {wweapon{G!{x'", ch, NULL, forger, TO_CHAR);
        return;
    }

    if ( argument[0] == '\0' )
    {
        act("$N says : '{GPardon? type 'forger' to see the list of modifications.{x'", ch, NULL, forger, TO_CHAR);
        return;
    }

    if (check_material(obj, "unique"))
    {
        act("$N says : '{GPardon. I can't forger this.{x'", ch, NULL, forger, TO_CHAR);
        return;
    }

    if ((obj->timer > 0)
    || (obj->pIndexData->limit != -1))
    //    || IS_WEAPON_STAT(obj, WEAPON_KATANA))
    {
        act("$N says : '{GPardon. You can't forger this.{x'", ch, NULL, forger, TO_CHAR);
        return;
    }


    if (!str_prefix(argument,"bless"))
    {
        if (IS_OBJ_STAT(obj,ITEM_BLESS))
        {
            act("$N says : '{G$p {Gis already blessed.{x'", ch, obj, forger, TO_CHAR);
            return;
        }

        words = "belessa";
        cost  = 5;

        if ( cost > ch->pcdata->questpoints )
        {
            act("$N says : '{GYou do not have enough QP for my services'", ch, NULL, forger, TO_CHAR);
            return;
        }
        act("$n utters the words '$T'.", forger, NULL, words, TO_ROOM);

        spell_bless( 0, forger->level, forger, obj, TARGET_OBJ );

        if (IS_OBJ_STAT(obj,ITEM_BLESS))
        {
            act("$N gives $p to $n.", ch, obj, forger, TO_ROOM);
            act("$N says : '{GTake care with $p{G, now is a lot powerful.{x'", ch, obj, forger, TO_CHAR);
            ch->pcdata->questpoints         -= cost;
        }
        else
            act("$N says : '{GI'm sorry I can't help you.{x'", ch, NULL, forger, TO_CHAR);
        return;
    }

    if (!str_prefix(argument,"poison"))
    {
        if (IS_WEAPON_STAT(obj, WEAPON_POISON))
        {
            act("$N says : '{G$p {Gis already poisoned.{x'", ch, obj, forger, TO_CHAR);
            return;
        }

        words = "poisana";
        cost  = 5;

        if ( cost > ch->pcdata->questpoints )
        {
            act("$N says : '{GYou do not have enough QP for my services'", ch, NULL, forger, TO_CHAR);
            return;
        }
        act("$n utters the words '$T'.", forger, NULL, words, TO_ROOM);

        spell_poison( 0, forger->level, forger, obj, TARGET_OBJ );

        if (IS_WEAPON_STAT(obj, WEAPON_POISON))
        {
            act("$N gives $p to $n.", ch, obj, forger, TO_ROOM);
            act("$N says : '{GTake care with $p{G, now is a lot powerful.{x'", ch, obj, forger, TO_CHAR);
            ch->pcdata->questpoints         -= cost;
        }
        else
            act("$N says : '{GI'm sorry I can't help you.{x'", ch, NULL, forger, TO_CHAR);
        return;
    }

    if (!str_prefix(argument,"sharp"))
    {
        if (IS_WEAPON_STAT( obj, WEAPON_SHARP) )
        {
            act("$N says : '{G$p {Gis already sharp.{x'", ch, obj, forger, TO_CHAR);
            return;
        }

        words = "gpabras braoculo";
        cost  = 20;

        if ( cost > ch->pcdata->questpoints )
        {
            act("$N says : '{GYou do not have enough QP for my services'", ch, NULL, forger, TO_CHAR);
            return;
        }

        act("$n utters the words '$T'.", forger, NULL, words, TO_ROOM);

        spell_sharp_blade( 0, forger->level, forger, obj, TARGET_OBJ );

        if ( IS_WEAPON_STAT ( obj, WEAPON_SHARP) )
        {
            act("$N gives $p to $n.", ch, obj, forger, TO_ROOM);
            act("$N says : '{GTake care with $p{G, now is a lot powerful.{x'", ch, obj, forger, TO_CHAR);
            ch->pcdata->questpoints         -= cost;
        }
        else
            act("$N says : '{GI'm sorry I can't help you.{x'", ch, NULL, forger, TO_CHAR);
        return;
    }

    if (!str_prefix(argument,"flame"))
    {
        if (IS_WEAPON_STAT( obj, WEAPON_FLAMING) )
        {
            act("$N says : '{G$p {Gis already flaming.{x'", ch, obj, forger, TO_CHAR);
            return;
        }

        words = "yrawz braoculo";
        cost  = 1800;

        if ( cost > ch->pcdata->questpoints )
        {
            act("$N says : '{GYou do not have enough QP for my services'", ch, NULL, forger, TO_CHAR);
            return;
        }

        act("$n utters the words '$T'.", forger, NULL, words, TO_ROOM);

        spell_flame_blade( 0, forger->level, forger, obj, TARGET_OBJ );

        if ( IS_WEAPON_STAT ( obj, WEAPON_FLAMING) )
        {
            act("$N gives $p to $n.", ch, obj, forger, TO_ROOM);
            act("$N says : '{GTake care with $p{G, now is a lot powerful.{x'", ch, obj, forger, TO_CHAR);
            ch->pcdata->questpoints         -= cost;
        }
        else
            act("$N says : '{GI'm sorry I can't help you.{x'", ch, NULL, forger, TO_CHAR);
        return;
    }

    if (!str_prefix(argument,"drain"))
    {
        if (IS_WEAPON_STAT( obj, WEAPON_VAMPIRIC) )
        {
            act("$N says : '{G$p {Gis already vampiric.{x'", ch, obj, forger, TO_CHAR);
            return;
        }

        words = "egruui braoculo";
        cost  = 1800;

        if ( cost > ch->pcdata->questpoints )
        {
            act("$N says : '{GYou do not have enough QP for my services'", ch, NULL, forger, TO_CHAR);
            return;
        }

        act("$n utters the words '$T'.", forger, NULL, words, TO_ROOM);

        spell_drain_blade( 0, forger->level, forger, obj, TARGET_OBJ );

        if ( IS_WEAPON_STAT ( obj, WEAPON_VAMPIRIC) )
        {
            act("$N gives $p to $n.", ch, obj, forger, TO_ROOM);
            act("$N says : '{GTake care with $p{G, now is a lot powerful.{x'", ch, obj, forger, TO_CHAR);
            ch->pcdata->questpoints        -= cost;
        }
        else
            act("$N says : '{GI'm sorry I can't help you.{x'", ch, NULL, forger, TO_CHAR);
        return;
    }

    if (!str_prefix(argument,"shocking"))
    {
        if (IS_WEAPON_STAT( obj, WEAPON_SHOCKING) )
        {
            act("$N says : '{G$p {Gis already electrical.{x'", ch, obj, forger, TO_CHAR);
            return;
        }

        words = "gpaqtuio braoculo";
        cost  = 1800;

        if ( cost > ch->pcdata->questpoints )
        {
            act("$N says : '{GYou do not have enough QP for my services'", ch, NULL, forger, TO_CHAR);
            return;
        }

        act("$n utters the words '$T'.", forger, NULL, words, TO_ROOM);

        spell_shocking_blade( 0, forger->level, forger, obj, TARGET_OBJ );

        if ( IS_WEAPON_STAT ( obj, WEAPON_SHOCKING) )
        {
            act("$N gives $p to $n.", ch, obj, forger, TO_ROOM);
            act("$N says : '{GTake care with $p{G, now is a lot powerful.{x'", ch, obj, forger, TO_CHAR);
            ch->pcdata->questpoints        -= cost;
        }
        else
            act("$N says : '{GI'm sorry I can't help you.{x'", ch, NULL, forger, TO_CHAR);
        return;
    }

    if (!str_prefix(argument,"frost"))
    {
        if (IS_WEAPON_STAT( obj, WEAPON_FROST) )
        {
            act("$N says : '{G$p {Gis already frost.{x'", ch, obj, forger, TO_CHAR);
            return;
        }

        words = "yfagh braoculo";
        cost  = 1800;

        if ( cost > ch->pcdata->questpoints )
        {
            act("$N says : '{GYou do not have enough QP for my services'", ch, NULL, forger, TO_CHAR);
            return;
        }

        act("$n utters the words '$T'.", forger, NULL, words, TO_ROOM);

        spell_frost_blade( 0, forger->level, forger, obj, TARGET_OBJ );

        if ( IS_WEAPON_STAT ( obj, WEAPON_FROST) )
        {
            act("$N gives $p to $n.", ch, obj, forger, TO_ROOM);
            act("$N says : '{GTake care with $p{G, now is a lot powerful.{x'", ch, obj, forger, TO_CHAR);
            ch->pcdata->questpoints         -= cost;
        }
        else
            act("$N says : '{GI'm sorry I can't help you.{x'", ch, NULL, forger, TO_CHAR);
        return;
    }

    if (!str_prefix(argument,"vorpal"))
    {
        if (IS_WEAPON_STAT( obj, WEAPON_VORPAL) )
        {
            act("$N says : '{G$p {Gis already vorpal.{x'", ch, obj, forger, TO_CHAR);
            return;
        }

        words = "zafsar braoculo";
        cost  = 800;

        if ( cost > ch->pcdata->questpoints )
        {
            act("$N says : '{GYou do not have enough QP for my services'", ch, NULL, forger, TO_CHAR);
            return;
        }

        act("$n utters the words '$T'.", forger, NULL, words, TO_ROOM);

        spell_vorpal_blade( 0, forger->level, forger, obj, TARGET_OBJ );

        if ( IS_WEAPON_STAT ( obj, WEAPON_VORPAL) )
        {
            act("$N gives $p to $n.", ch, obj, forger, TO_ROOM);
            act("$N says : '{GTake care with $p{G, now is a lot powerful.{x'", ch, obj, forger, TO_CHAR);
            ch->pcdata->questpoints         -= cost;
        }
        else
            act("$N says : '{GI'm sorry I can't help you.{x'", ch, NULL, forger, TO_CHAR);
        return;
    }

    if (!str_prefix(argument,"nodrop"))
    {
        if (IS_OBJ_STAT(obj,ITEM_NODROP))
        {
            act("$N says : '{G$p {Gis already nodrop.{x'", ch, obj, forger, TO_CHAR);
            return;
        }

        words = "nodropa itema";
        cost  = 800;

        if ( cost > ch->pcdata->questpoints )
        {
            act("$N says : '{GYou do not have enough QP for my services'", ch, NULL, forger, TO_CHAR);
            return;
        }

        act("$n utters the words '$T'.", forger, NULL, words, TO_ROOM);

        SET_BIT(obj->extra_flags,ITEM_NODROP);

        if (IS_OBJ_STAT(obj,ITEM_NODROP))
        {
            act("$N gives $p to $n.", ch, obj, forger, TO_ROOM);
            act("$N says : '{GTake care with $p{G, now is a lot powerful.{x'", ch, obj, forger, TO_CHAR);
            ch->pcdata->questpoints         -= cost;
        }
        else
            act("$N says : '{GI'm sorry I can't help you.{x'", ch, NULL, forger, TO_CHAR);
        return;
    }

    if (!str_prefix(argument,"noremove"))
    {
        if (IS_OBJ_STAT(obj,ITEM_NOREMOVE))
        {
            act("$N says : '{G$p {Gis already noremove.{x'", ch, obj, forger, TO_CHAR);
            return;
        }

        words = "noremova itema";
        cost  = 800;

        if ( cost > ch->pcdata->questpoints )
        {
            act("$N says : '{GYou do not have enough QP for my services'", ch, NULL, forger, TO_CHAR);
            return;
        }

        act("$n utters the words '$T'.", forger, NULL, words, TO_ROOM);

        SET_BIT(obj->extra_flags,ITEM_NOREMOVE);

        if (IS_OBJ_STAT(obj,ITEM_NOREMOVE))
        {
            act("$N gives $p to $n.", ch, obj, forger, TO_ROOM);
            act("$N says : '{GTake care with $p{G, now is a lot powerful.{x'", ch, obj, forger, TO_CHAR);
            ch->pcdata->questpoints         -= cost;
        }
        else
            act("$N says : '{GI'm sorry I can't help you.{x'", ch, NULL, forger, TO_CHAR);
        return;
    }

    if (!str_prefix(argument,"enchant"))
    {

        words = "enchanta superia";
        cost  = 800;

        if ( cost > ch->pcdata->questpoints )
        {
            act("$N says : '{GYou do not have enough QP for my services'", ch, NULL, forger, TO_CHAR);
            return;
        }

        act("$n utters the words '$T'.", forger, NULL, words, TO_ROOM);

        spell_enchant_weapon( 0, forger->level, forger, obj, TARGET_OBJ );

        act("$N gives $p to $n.", ch, obj, forger, TO_ROOM);
        act("$N says : '{GTake care with $p{G, now is a lot powerful.{x'", ch, obj, forger, TO_CHAR);
        ch->pcdata->questpoints         -= cost;
        return;
    }

    if (!str_prefix(argument,"noalign"))
    {

        if (!IS_OBJ_STAT(obj, ITEM_ANTI_EVIL))
            if (!IS_OBJ_STAT(obj, ITEM_ANTI_GOOD))
                if (!IS_OBJ_STAT(obj, ITEM_ANTI_NEUTRAL))
                {
                    act("$N says : '{G$p {Gis already have no align.{x'", ch, obj, forger, TO_CHAR);
                    return;
                }

        words = "aligna peredelka";
        cost  = 1500;

        if ( cost > ch->pcdata->questpoints )
        {
            act("$N says : '{GYou do not have enough QP for my services'", ch, NULL, forger, TO_CHAR);
            return;
        }

        act("$n utters the words '$T'.", forger, NULL, words, TO_ROOM);

        if (IS_OBJ_STAT(obj, ITEM_ANTI_NEUTRAL))
            REMOVE_BIT(obj->extra_flags,ITEM_ANTI_NEUTRAL);

        if (IS_OBJ_STAT(obj, ITEM_ANTI_GOOD))
            REMOVE_BIT(obj->extra_flags,ITEM_ANTI_GOOD);

        if (IS_OBJ_STAT(obj, ITEM_ANTI_EVIL))
            REMOVE_BIT(obj->extra_flags,ITEM_ANTI_EVIL);

        act("$N gives $p to $n.", ch, obj, forger, TO_ROOM);
        act("$N says : '{GTake care with $p{G, now is a lot powerful.{x'", ch, obj, forger, TO_CHAR);
        ch->pcdata->questpoints         -= cost;
        return;
    }

    if (!str_prefix(argument,"noloot"))
    {

        //if (IS_OBJ_STAT(obj, ITEM_CONTAINER))
        if (obj->pIndexData->item_type == ITEM_CONTAINER)
        {
            act("$N says : '{G$p {Gis container! Gods forbidden to do it noloot.{x'", ch, obj, forger, TO_CHAR);
            return;
        }
        if (IS_OBJ_STAT(obj, ITEM_NOLOOT))
        {
            act("$N says : '{G$p {Gis already noloot.{x'", ch, obj, forger, TO_CHAR);
            return;
        }

        words = "noluta poluta";
        cost  = 9999;

        if ( cost > ch->pcdata->questpoints )
        {
            act("$N says : '{GYou do not have enough QP for my services'", ch, NULL, forger, TO_CHAR);
            return;
        }

        act("$n utters the words '$T'.", forger, NULL, words, TO_ROOM);

        SET_BIT(obj->extra_flags,ITEM_NOLOOT);

        act("$N gives $p to $n.", ch, obj, forger, TO_ROOM);
        act("$N says : '{GTake care with $p{G, now is a lot powerful.{x'", ch, obj, forger, TO_CHAR);
        ch->pcdata->questpoints         -= cost;
        return;
    }

    if (!str_prefix(argument,"fireproof"))
    {
        if (IS_OBJ_STAT(obj, ITEM_BURN_PROOF))
        {
            act("$N says : '{G$p {Gis already fireproof.{x'",
                ch, obj, forger, TO_CHAR);
            return;
        }
        words = "fire proofa";
        cost  = 1000;
        if ( cost > ch->pcdata->questpoints )
        {
            act("$N says : '{GYou do not have enough QP for my services'",
                ch, NULL, forger, TO_CHAR);
            return;
        }
        act("$n utters the words '$T'.",
            forger, NULL, words, TO_ROOM);
        SET_BIT(obj->extra_flags, ITEM_BURN_PROOF);
        act("$N gives $p to $n.",
            ch, obj, forger, TO_ROOM);
        act("$N says : '{GTake care with $p{G, now is a lot powerful.{x'",
            ch, obj, forger, TO_CHAR);
        ch->pcdata->questpoints -= cost;
        return;
    }

    if (!str_prefix(argument,"hidurability"))
    {
        if (IS_OBJ_STAT(obj, ITEM_HIDURABILITY))
        {
            act("$N says : '{G$p {Gis already high durability.{x'",
                ch, obj, forger, TO_CHAR);
            return;
        }
        words = "itema impruva";
        cost  = 1500;
        if ( cost > ch->pcdata->questpoints )
        {
            act("$N says : '{GYou do not have enough QP for my services'",
                ch, NULL, forger, TO_CHAR);
            return;
        }
        act("$n utters the words '$T'.",
            forger, NULL, words, TO_ROOM);
        SET_BIT(obj->extra_flags, ITEM_HIDURABILITY);
        act("$N gives $p to $n.",
            ch, obj, forger, TO_ROOM);
        act("$N says : '{GTake care with $p{G, now is a lot powerful.{x'",
            ch, obj, forger, TO_CHAR);
        ch->pcdata->questpoints -= cost;
        return;
    }

    if (!str_prefix(argument,"indestructable"))
    {
        if (IS_OBJ_STAT(obj, ITEM_INDESTRUCTABLE))
        {
            act("$N says : '{G$p {Gis already anaffected by weapon damage.{x'",
                ch, obj, forger, TO_CHAR);
            return;
        }
        words = "itema indestructable";
        cost  = 5000;
        if ( cost > ch->pcdata->questpoints )
        {
            act("$N says : '{GYou do not have enough QP for my services'",
                ch, NULL, forger, TO_CHAR);
            return;
        }
        act("$n utters the words '$T'.",
            forger, NULL, words, TO_ROOM);
        SET_BIT(obj->extra_flags, ITEM_INDESTRUCTABLE);
        act("$N gives $p to $n.",
            ch, obj, forger, TO_ROOM);
        act("$N says : '{GTake care with $p{G, now is a lot powerful.{x'",
            ch, obj, forger, TO_CHAR);
        ch->pcdata->questpoints -= cost;
        return;
    }

    act("$N says : '{GPardon? Type 'forger' to see the list of modifications.{x'",
        ch, NULL, forger, TO_CHAR);

    return;
}

bool is_same_obj(OBJ_DATA *obj, OBJ_DATA *obj1)
{
    if (obj1 == NULL
    || obj == NULL
    || mlstr_cmp(obj1->short_descr, obj->short_descr)
    || obj1->pIndexData->vnum != obj->pIndexData->vnum)
        return FALSE;

    return TRUE;
}

/* RT part of the corpse looting code */
bool can_loot(CHAR_DATA * ch, OBJ_DATA * obj)
{
    if (IS_IMMORTAL(ch))
        return TRUE;

    if (obj->pIndexData->item_type != ITEM_CORPSE_PC)
        return TRUE;

    /*
     * PC corpses in the ROOM_BATTLE_ARENA rooms can be looted
     * only by owners
     */
    if (obj->in_room != NULL
    && IS_SET(obj->in_room->room_flags, ROOM_BATTLE_ARENA)
    && obj->owner != NULL && str_cmp(ch->name, obj->owner))
        return FALSE;
/*
 * Peacefuls can loot only own corpses.
 */
    if (IS_SET(ch->comm, PLR_PEACE) && obj->owner != NULL
    && str_cmp(ch->name,obj->owner))
        return FALSE;
/*
 * Nobody can loot corpse of peaceful, except himself.
 */
    if (obj->value[2] && obj->owner
    && str_cmp(ch->name,obj->owner)
    && !ch->in_room->area->clan)
        return FALSE;

    return TRUE;
}

int can_get_obj(CHAR_DATA * ch, OBJ_DATA * obj, bool message)
{
    CHAR_DATA      *rch;

    if (!CAN_WEAR(obj, ITEM_TAKE)
    || ((obj->pIndexData->item_type == ITEM_CORPSE_PC
    || obj->pIndexData->item_type == ITEM_CORPSE_NPC)
    && (!IS_NPC(ch) || IS_AFFECTED(ch, AFF_CHARM))
    && !IS_IMMORTAL(ch)
    && str_cmp(ch->name, obj->owner)))
    {
        if (message)
            char_act("You can't take that.", ch);
        return 1; // return FALSE; just can't take
    }
    /* can't even get limited eq which does not match alignment */
    if (obj->pIndexData->limit != -1 && !IS_IMMORTAL(ch))
    {
        if ((IS_OBJ_STAT(obj, ITEM_ANTI_EVIL) && IS_EVIL(ch))
        || (IS_OBJ_STAT(obj, ITEM_ANTI_GOOD) && IS_GOOD(ch))
        || (IS_OBJ_STAT(obj, ITEM_ANTI_NEUTRAL) && IS_NEUTRAL(ch)))
        {
            if (message)
            {
                act_puts("You are zapped by $p and drop it.",
                    ch, obj, NULL, TO_CHAR, POS_DEAD);
                act_puts("$n is zapped by $p and drops it.",
                    ch, obj, NULL, TO_ROOM, POS_RESTING);
            }
            return 2; // return FALSE; align check failed
        }
    }
    if (ch->carry_number + get_obj_number(obj) > can_carry_n(ch))
    {
        if (message)
            act_puts("$d: you can't carry that many items.",
                ch, NULL, obj->name, TO_CHAR, POS_DEAD);
        return 3; // return FALSE; U can't carry so much! that's it
    }
    if (get_carry_weight(ch) + get_obj_weight(obj) > can_carry_w(ch))
    {
        if (message)
            act_puts("$d: you can't carry that much weight.",
                ch, NULL, obj->name, TO_CHAR, POS_DEAD);
        return 4; // return FALSE; u can't carry so much weight
    }
    if (obj->in_room != NULL)
    {
        for (rch = obj->in_room->people; rch != NULL;
            rch = rch->next_in_room)
            if (rch->on == obj)
            {
                if (message)
                    act_puts("$N uses $p.", ch, obj, rch, TO_CHAR, POS_DEAD);
                return 5; // return FALSE; obj is in use
            }
    }
    if (obj->pIndexData->item_type == ITEM_MONEY)
    {
        if (get_carry_weight(ch) + obj->value[0] / 10
            + obj->value[1] * 2 / 5 > can_carry_w(ch))
        {
            if (message)
                act_puts("$d: you can't carry that much weight.",
                    ch, NULL, obj->name, TO_CHAR, POS_DEAD);
            return 4; // return FALSE; u can't carry so much weight
        }
        return 0; // return TRUE;
    }

    return 0; // return TRUE;
}


void get_obj(CHAR_DATA * ch, OBJ_DATA * obj, OBJ_DATA * container, bool message)
{
    /* variables for AUTOSPLIT */
    CHAR_DATA      *gch;
    int             members;

    if (container != NULL)
    {
        if (IS_SET(container->pIndexData->extra_flags, ITEM_PIT)
            &&  !CAN_WEAR(container, ITEM_TAKE)
            &&  !IS_OBJ_STAT(obj, ITEM_HAD_TIMER))
            obj->timer = 0;
        if (message)
        {
            act_puts("You get $p from $P.", ch, obj, container, TO_CHAR, POS_DEAD);
            act("$n gets $p from $P.",
                ch, obj, container, TO_ROOM | (IS_AFFECTED(ch, AFF_SNEAK) ? ACT_NOMORTAL : 0));
        }
        REMOVE_BIT(obj->extra_flags, ITEM_HAD_TIMER);
        obj_from_obj(obj);
    }
    else
    {
        if (message)
        {
            act_puts("You get $p.", ch, obj, container, TO_CHAR, POS_DEAD);
            act("$n gets $p.", ch, obj, container,
                TO_ROOM | (IS_AFFECTED(ch, AFF_SNEAK) ? ACT_NOMORTAL : 0));
        }
        obj_from_room(obj);
    }

    if (obj->pIndexData->item_type == ITEM_MONEY)
    {
        ch->silver += obj->value[0];
        ch->gold += obj->value[1];
        if (IS_SET(ch->plr_flags, PLR_AUTOSPLIT))
        {
            members = 0;
            for (gch = ch->in_room->people; gch != NULL;
                gch = gch->next_in_room)
            {
                if (!IS_AFFECTED(gch, AFF_CHARM)
                    && is_same_group(gch, ch))
                    members++;
            }

            if (members > 1 && (obj->value[0] > 1
                                || obj->value[1]))
                doprintf(do_split, ch, "%d %d", obj->value[0], obj->value[1]);
        }
    }
    else
    {
        obj_to_char(obj, ch);

        if (HAS_TRIGGER_OBJ(obj, TRIG_GET))
           p_give_trigger( NULL, obj, NULL, ch, obj, TRIG_GET);

        if (HAS_TRIGGER_ROOM(ch->in_room, TRIG_GET))
           p_give_trigger(NULL, NULL, ch->in_room, ch, obj, TRIG_GET);

        oprog_call(OPROG_GET, obj, ch, NULL);
    }

}

int draw(CHAR_DATA * ch, const char *argument)
{
    char            arg1[MAX_INPUT_LENGTH];
    char            arg2[MAX_INPUT_LENGTH];
    OBJ_DATA       *obj = NULL;
//    OBJ_DATA       *obj;
    OBJ_DATA       *container;
    bool found = FALSE;
    int loc;

    argument = one_argument(argument, arg1, sizeof(arg1));
    if (!str_cmp(arg1, "with"))
        argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));
    if (!str_cmp(arg2, "from"))
        argument = one_argument(argument, arg2, sizeof(arg2));

    for (container = ch->carrying; container; container = container->next_content)
    {
        if (container->wear_loc == WEAR_NONE
        || container->pIndexData->item_type != ITEM_SCABBARD
        || !container->contains)
            continue;
        if (arg2[0] != '\0' && !is_name(arg2, container->name))
            continue;
        for (obj = container->contains; obj != NULL; obj = obj->next_content)
        {
            if (arg1[0] == '\0' || is_name(arg1, obj->name))
            {
                found = TRUE;
                break;
            }
        }
        if (found)
            break;
    }

    if (!found || obj == NULL)
    {
        if (arg1[0] == '\0')
            act("You haven't weapons in your scabbards.", ch, NULL, NULL, TO_CHAR);
        else
            act("You can't find this weapon in your scabbards.", ch, NULL, NULL, TO_CHAR);
        return 0;
    }

    loc = WEAR_WIELD;
    if (get_eq_char(ch, loc) != NULL)
    {
        loc = WEAR_SECOND_WIELD;
        if (get_eq_char(ch, loc) != NULL
        || get_eq_char(ch, WEAR_SHIELD) != NULL
        || get_eq_char(ch, WEAR_HOLD) != NULL
        || get_skill(ch, gsn_second_weapon) < 2)
        {
            act("You can't wield more weapons.", ch, NULL, NULL, TO_CHAR);
            return 0;
        }
    }

    act_puts("You arm $p from $P.", ch, obj, container, TO_CHAR, POS_DEAD);
    act("$n arms $p from $P.",
        ch, obj, container, TO_ROOM | (IS_AFFECTED(ch, AFF_SNEAK) ? ACT_NOMORTAL : 0));

    obj_from_obj(obj);
    obj_to_char(obj, ch);
    equip_char(ch, obj, loc);
    oprog_call(OPROG_GET, obj, ch, NULL);
    return loc;
}

void do_draw(CHAR_DATA * ch, const char *argument)
{
    draw(ch, argument);
}

void do_quickdraw(CHAR_DATA * ch, const char *argument)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA *wield;
    int chance, loc;

    if ((chance = get_skill(ch, gsn_iaitsu)) == 0)
    {
        act("You don't know the art of iaitsu.",
            ch, NULL, NULL, TO_CHAR);
        return;
    }
    argument = one_argument(argument, arg, sizeof(arg));
    if (!str_cmp(arg, "at"))
        argument = one_argument(argument, arg, sizeof(arg));

    victim = get_char_room(ch, arg);

    if (victim == NULL)
        victim = ch->fighting;

    if (victim == NULL)
    {
        act("You can't find your victim here.",
            ch, NULL, NULL, TO_CHAR);
        return;
    }
    if (victim == ch
    || is_safe(ch, victim))
    {
        act("You can't do that.", ch, NULL, NULL, TO_CHAR);
        return;
    }

    if ((!IS_NPC(victim) && (victim->hit < victim->max_hit * 9 / 10))
    || (IS_NPC(victim) && (victim->hit < victim->max_hit * 7 / 10)))
    {
        act("$N is already bleeding, your honour do not allow you attack $gN{him}.",
            ch, NULL, victim, TO_CHAR);
        return;
    }

    if (is_affected(ch, gsn_adv_fury)
    || (is_affected(ch, gsn_fury)
    && !IS_NPC(victim)))
    {
        act("Your FURY do not allow you attack $gN{him}.",
            ch, NULL, victim, TO_CHAR);
        return;
    }

    if ((wield = get_eq_char(ch, WEAR_WIELD)) != NULL)
    {
        act("You're already wielding $p.", ch, wield, NULL, TO_CHAR);
        return;
    }
    loc = draw(ch, argument);
    if (loc != WEAR_WIELD)
        return;
    if ((wield = get_eq_char(ch, loc)) == NULL)
        return;

    WAIT_STATE(ch, SKILL(gsn_iaitsu)->beats);

    if (number_percent() < chance)
    {
        check_improve(ch, gsn_iaitsu, TRUE, 3);
        one_hit(ch, victim, gsn_iaitsu, loc);
    } else
    {
        act("You move clumsily and $p falls from your hands.",
            ch, wield, NULL, TO_CHAR);
        act("$p falls from $n's clumsy hands.",
            ch, wield, NULL, TO_ROOM);
        check_improve(ch, gsn_iaitsu, FALSE, 3);
        obj_from_char(wield);

        if (IS_OBJ_STAT(wield, ITEM_NODROP)
        || IS_OBJ_STAT(wield, ITEM_INVENTORY)
        || (ch->in_room
        && IS_SET(ch->in_room->room_flags, ROOM_BATTLE_ARENA)))
            obj_to_char(wield, ch);
        else
            obj_to_room(wield, ch->in_room);
    }
}

void do_get(CHAR_DATA * ch, const char *argument)
{
    char            arg1[MAX_INPUT_LENGTH];
    char            arg2[MAX_INPUT_LENGTH];
    OBJ_DATA       *obj, *obj_next, *obj_curr;
    OBJ_DATA       *container;
    bool            found, cfound;
    int             count = 1, canGetResult;

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));

    if (!str_cmp(arg2, "from") || !str_cmp(arg2, ""))
        argument = one_argument(argument, arg2, sizeof(arg2));

    /* Get type. */
    if (arg1[0] == '\0')
    {
        char_act("Get what?", ch);
        return;
    }

    if ( is_number(arg1))
    {
        OBJ_DATA *get_coins=NULL;
        count = atoi(arg1);
        if (count <= 0
        || (str_cmp(arg2, "gold") && str_cmp(arg2, "silver")
        && str_cmp(arg2, "") && str_cmp(arg2, "")))
        {
            char_act("Syntax: <get> <amount> <silver|gold>", ch);
            return;
        }
        for (obj = ch->in_room->contents; obj != NULL; obj = obj->next_content)
            if ( obj->pIndexData->item_type == ITEM_MONEY)
            {
                if (!str_cmp(arg2, "gold") || !str_cmp(arg2, ""))
                {
                    if ( obj->value[1] >= count)
                    {
                        obj_to_room(get_coins=create_money(count, 0), ch->in_room);
                    } else
                    {
                        char_act("Here no so many gold.", ch);
                        return;
                    }
                }

                if (!str_cmp(arg2, "silver") || !str_cmp(arg2, ""))
                {
                    if (obj->value[0] >= count)
                    {
                        obj_to_room(get_coins=create_money(0, count), ch->in_room);
                    } else
                    {
                        char_act("Here no so many silver.", ch);
                        return;
                    }
                }

                if (!can_get_obj(ch, get_coins, TRUE))
                {
                    get_obj(ch, get_coins, NULL, TRUE);
                    extract_obj(obj);
                } else
                {
                    extract_obj(get_coins);
                }
                return;
            }

    }

    if (arg2[0] == '\0')
    {
        if ((str_cmp(arg1, "all") && str_prefix("all.", arg1))
        && (str_cmp(arg1, "") && str_prefix(".", arg1)))
        {
            /* 'get obj' */
            obj = get_obj_list(ch, arg1, ch->in_room->contents);
            if (obj == NULL)
            {
                act_puts("You see no $T here.", ch, NULL, arg1, TO_CHAR, POS_DEAD);
                return;
            }
            if (!can_get_obj(ch, obj, TRUE))
                get_obj(ch, obj, NULL, TRUE);
        } else
        {
            /* 'get all' or 'get all.obj' */
            found = FALSE;
            for (obj = ch->in_room->contents; obj != NULL; obj = obj_next)
            {
                obj_next = obj->next_content;
                if ((arg1[3] == '\0' || is_name(arg1+4, obj->name))
                && can_see_obj(ch, obj))
                {
                    found = TRUE;
                    obj_curr = obj;

                    canGetResult = can_get_obj(ch, obj, TRUE);
                    // magic number '3' -- can't carry so much objs
                    if (canGetResult == 3)
                        break;

                    if (canGetResult == 0)
                    {
                        cfound = FALSE;
                        get_obj(ch, obj, NULL, FALSE);
                        if (obj_next != NULL
                        && is_same_obj(obj_curr, obj_next)
                        && !can_get_obj(ch, obj_next, FALSE))
                        {
                            count++;
                            cfound = TRUE;
                        }

                        if (!cfound)
                        {
                            if (count > 1)
                            {
                                act_puts("$n gets $P[$j].",
                                    ch, (const void *) count, obj, TO_ROOM | (IS_AFFECTED(ch,  AFF_SNEAK) ?  ACT_NOMORTAL : 0), POS_RESTING);
                                act_puts("You get $P[$j].",
                                    ch, (const void *) count, obj, TO_CHAR, POS_DEAD);
                            } else
                            {
                                act_puts("You get $p.",
                                    ch, obj, NULL, TO_CHAR, POS_DEAD);
                                act("$n gets $p.",
                                    ch, obj, NULL, TO_ROOM | (IS_AFFECTED(ch, AFF_SNEAK) ? ACT_NOMORTAL : 0));
                            }
                            count = 1;
                        }
                        if (obj->pIndexData->item_type == ITEM_MONEY)
                            extract_obj(obj);
                    }
                }
            }

            if (!found)
            {
                if (arg1[3] == '\0')
                    char_act("You see nothing here..", ch);
                else
                    act_puts("You see no $T here.", ch, NULL, arg1+4, TO_CHAR, POS_DEAD);
            }
        }
        return;
    }
    /* 'get ... container' */
    if (!str_cmp(arg2, "all") || !str_prefix("all.", arg2)
    || !str_cmp(arg2, "") || !str_prefix(".", arg2))
    {
        char_act("You can't do that.", ch);
        return;
    }
    if ((container = get_obj_here(ch, arg2)) == NULL)
    {
        act_puts("You see no $T here.", ch, NULL, arg2, TO_CHAR, POS_DEAD);
        return;
    }
    switch (container->pIndexData->item_type)
    {
    default:
        char_act("That is not a container.", ch);
        return;

    case ITEM_CONTAINER:
    case ITEM_CORPSE_NPC:
        break;

    case ITEM_CORPSE_PC:
        if (!can_loot(ch, container))
        {
            char_act("You can't do that.", ch);
            return;
        }
    }

    if (IS_SET(container->value[1], CONT_CLOSED))
    {
        act_puts("The $d is closed.", ch, NULL, container->name, TO_CHAR, POS_DEAD);
        return;
    }
    if ((str_cmp(arg1, "all") && str_prefix("all.", arg1))
    && (str_cmp(arg1, "") && str_prefix(".", arg1)))
    {
        /* 'get obj container' */
        obj = get_obj_list(ch, arg1, container->contains);
        if (obj == NULL)
        {
            act_puts("I see nothing like that in the $T.",
                ch, NULL, arg2, TO_CHAR, POS_DEAD);
            return;
        }
        if (!can_get_obj(ch, obj, TRUE))
            get_obj(ch, obj, container, TRUE);
    } else
    {
        /* 'get all container' or 'get all.obj container' */
        if (container->pIndexData->vnum == OBJ_VNUM_PIT
        && !IS_IMMORTAL(ch))
        {
            char_act("Don't be so greedy!", ch);
            return;
        }
        found = FALSE;
        count = 1;
        for (obj = container->contains; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            if ((arg1[3] == '\0' || is_name(&arg1[4], obj->name))
            && can_see_obj(ch, obj))
            {
                found = TRUE;
                obj_curr = obj;

                canGetResult = can_get_obj(ch, obj, TRUE);
                // magic number '3' -- can't carry so much objs
                if (canGetResult == 3)
                    break;

                if (canGetResult == 0)
                {
                    cfound = FALSE;
                    get_obj(ch, obj, container, FALSE);
                    if (obj_next != NULL
                    && is_same_obj(obj_curr, obj_next)
                    && !can_get_obj(ch, obj_next, FALSE))
                    {
                        count++;
                        cfound = TRUE;
                    }
                    if (!cfound)
                    {
                        if (count > 1)
                        {
                            act_puts3("$n gets $p[$J] from $P.",
                                ch, obj, container, (const void *) count, TO_ROOM | (IS_AFFECTED(ch,  AFF_SNEAK) ?  ACT_NOMORTAL : 0), POS_RESTING);
                            act_puts3("You get $p[$J] from $P.",
                                ch, obj, container, (const void *) count, TO_CHAR, POS_RESTING);
                        } else
                        {
                            act("You get $p from $P.", ch, obj, container, TO_CHAR);
                            act("$n gets $p from $P.", ch, obj, container,
                                TO_ROOM | (IS_AFFECTED(ch, AFF_SNEAK) ? ACT_NOMORTAL : 0));
                        }
                        count = 1;
                    }
                    if (obj->pIndexData->item_type == ITEM_MONEY)
                        extract_obj(obj);
                }
            }
        }

        if (!found)
        {
            if (arg1[3] == '\0')
                act_puts("You see nothing in the $T.", ch, NULL, arg2, TO_CHAR, POS_DEAD);
            else
                act_puts("You see nothing like that in the $T.",
                    ch, NULL, arg2, TO_CHAR, POS_DEAD);
        }
    }
}

int scabbard_type(int weapon_type)
{
    int type;
    switch (weapon_type)
    {
    case WEAPON_SWORD:
        type = 1;
        break;
    case WEAPON_DAGGER:
    case WEAPON_KNIFE:
        type = 2;
        break;
    case WEAPON_MACE:
    case WEAPON_AXE:
    case WEAPON_FLAIL:
        type = 3;
        break;
    case WEAPON_SPEAR:
    case WEAPON_POLEARM:
    case WEAPON_LANCE:
    case WEAPON_WHIP:
        type = 4;
        break;
    default:
        type = 0;
    }
    return type;
}

bool sheathe(CHAR_DATA *ch, OBJ_DATA *container, OBJ_DATA *obj, int* count, bool message)
{
    if ((container->value[1] != scabbard_type(obj->value[0]))
    || (obj->pIndexData->item_type != ITEM_WEAPON))
    {
        act_puts("You can't put $P in the $p.",
            ch, container, obj, TO_CHAR, POS_DEAD);
        return FALSE;
    }

    if ((obj->pIndexData->limit != -1)
    && (container->pIndexData->limit == -1))
    {
        act_puts("This unworthy container won't hold $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        return FALSE;
    }

    if (!IS_WEAPON_STAT(obj, WEAPON_KATANA)
    && IS_SET(obj->pIndexData->extra_flags, ITEM_QUEST)
    && (!IS_SET(container->pIndexData->extra_flags, ITEM_QUEST)
    || container->owner == NULL
    || obj->owner == NULL
    || container->owner != obj->owner))
    {
        act_puts("This unworthy container won't hold $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        return FALSE;
    }

    (*count)++;
    if (*count > container->value[2])
    {
        act_puts("It is unsafe to put so much weapons in the $p.",
            ch, container, NULL, TO_CHAR, POS_DEAD);
        return FALSE;
    }

    if (get_obj_weight(obj) + get_true_weight(container) > (container->value[0] * 10)
    || get_obj_weight(obj) > (container->value[3] * 10))
    {
        act_puts("The $p is not located in $P.", ch, obj, container, TO_CHAR, POS_DEAD);
        return FALSE;
    }

    if (ch->fighting != NULL)
    {
        char_act("You can't do this while fighting.", ch);
        return FALSE;
    }

    obj_from_char(obj);
    obj_to_obj(obj, container);

    if (message)
    {
        act_puts("$n puts $p in $P.", ch, obj, container, TO_ROOM, POS_RESTING);
        act_puts("You put $p in $P.", ch, obj, container, TO_CHAR, POS_DEAD);
    }
    return TRUE;
}

void do_sheathe(CHAR_DATA * ch, const char *argument)
{
    char        arg1[MAX_INPUT_LENGTH];
    char        arg2[MAX_INPUT_LENGTH];
    OBJ_DATA    *container;
    OBJ_DATA    *obj = NULL;
    OBJ_DATA    *objc;
    int         count, type;

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));

    if (!str_cmp(arg2, "in") || !str_cmp(arg2, "into") || !str_cmp(arg2, ""))
        argument = one_argument(argument, arg2, sizeof(arg2));


    if (arg1[0] != '\0')
    {
        if ((obj = get_obj_wear(ch, arg1)) == NULL)
        {
            act_puts("You are not armed any $T.", ch, NULL, arg1, TO_CHAR, POS_DEAD);
            return;
        }
    } else
    {
        obj = get_eq_char(ch, WEAR_SECOND_WIELD);
        if (obj == NULL)
            obj = get_eq_char(ch, WEAR_WIELD);
        if (obj == NULL)
        {
            act("But you are unarmed!", ch, NULL, NULL, TO_CHAR);
            return;
        }
    }

    if ((IS_OBJ_STAT(obj, ITEM_NOREMOVE) || IS_OBJ_STAT(obj, ITEM_NODROP))
    && !IS_WEAPON_STAT(obj, WEAPON_KATANA))
    {
        act("You can't get of $p.", ch, obj, NULL, TO_CHAR);
        return;
    }

    type = scabbard_type(obj->value[0]);

    for (container = ch->carrying; container; container = container->next_content)
    {
        if (container->wear_loc == WEAR_NONE
        || container->pIndexData->item_type != ITEM_SCABBARD)
            continue;
        if (arg2[0] != '\0' && !is_name(arg2, container->name))
            continue;
        if (container->value[1] != type)
            continue;
        break;
    }

    if (container == NULL)
    {
        act("You haven't a proper weapon container for $p.",
            ch, obj, NULL, TO_CHAR);
        return;
    }

    if (container->pIndexData->item_type != ITEM_SCABBARD)
    {
        act("$p it is not intended for storage of the weapon.",
            ch, container, NULL, TO_CHAR);
        return;
    }

    if (obj->timer > 0)
    {
        act_puts("$p decays, you should wait a little.",
            ch, obj, NULL, TO_CHAR, POS_DEAD);
        return;
    }

    count = 0;
    for (objc = container->contains; objc; objc = objc->next_content)
        count++;

    sheathe(ch, container, obj, &count, TRUE);
}

bool put_obj(CHAR_DATA *ch, OBJ_DATA *container, OBJ_DATA *obj, int* count, bool message)
{
    OBJ_DATA *  objc;

    if (IS_SET(container->value[1], CONT_QUIVER)
    && (obj->pIndexData->item_type != ITEM_WEAPON
    || obj->value[0] != WEAPON_ARROW))
    {
        act_puts("You can only put arrows in $p.",
            ch, container, NULL, TO_CHAR, POS_DEAD);
        return FALSE;
    }

    if (container->pIndexData->vnum == OBJ_VNUM_PIT
    && !CAN_WEAR(obj, ITEM_TAKE))
    {
        if (obj->timer)
            SET_BIT(obj->extra_flags, ITEM_HAD_TIMER);
        else
            obj->timer = number_range(100, 200);
    }

    if (obj->pIndexData->limit != -1)
    {
        act_puts("This unworthy container won't hold $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        return FALSE;
    }

    if (IS_SET(obj->pIndexData->extra_flags, ITEM_QUEST)
    && (container->pIndexData->vnum != QUEST_VNUM_SONG
    || container->owner == NULL || obj->owner == NULL
    || container->owner != obj->owner) )
    {
        act_puts("This unworthy container won't hold $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        return FALSE;
    }

    if (obj->pIndexData->item_type == ITEM_POTION
    && IS_SET(container->wear_flags, ITEM_TAKE)
    && !IS_SET(container->value[1], CONT_ROOMY))
    {
        int pcount = 0;
        for (objc = container->contains; objc; objc = objc->next_content)
            if (objc->pIndexData->item_type == ITEM_POTION)
                pcount++;
        if (pcount > 15)
        {
            act_puts("It's not safe to put more potions into $p.",
                ch, container, NULL, TO_CHAR, POS_DEAD);
            return FALSE;
        }
    }

    (*count)++;
    if (*count > container->value[0])
    {
        act_puts("It's not safe to put that much items into $p.",
            ch, container, NULL, TO_CHAR, POS_DEAD);
        return FALSE;
    }

    if (get_obj_weight(obj) + get_true_weight(container) >
        (container->value[0] * 10)
    || get_obj_weight(obj) > (container->value[3] * 10))
    {
        act_puts3("$p is not located $U $P.",
            ch, obj, container, IS_SET(container->value[1], CONT_PUT_ON) ? "on" : "in", TO_CHAR, POS_DEAD);
        return FALSE;
    }

    obj_from_char(obj);
    obj_to_obj(obj, container);

    if (message)
    {
        act_puts3("$n puts $p $U $P.",
            ch, obj, container, IS_SET(container->value[1], CONT_PUT_ON) ? "on" : "in", TO_ROOM, POS_RESTING);
        act_puts3("You put $p $U $P.",
            ch, obj, container, IS_SET(container->value[1], CONT_PUT_ON) ? "on" : "in", TO_CHAR, POS_DEAD);
    }
    return TRUE;
}

void do_put(CHAR_DATA * ch, const char *argument)
{
    char        arg1[MAX_INPUT_LENGTH];
    char        arg2[MAX_INPUT_LENGTH];
    OBJ_DATA    *container;
    OBJ_DATA    *obj = NULL;
    OBJ_DATA    *obj_next, *obj_curr;
    OBJ_DATA    *objc;
    clan_t   *clan = NULL;
    int         count, pcount = 1;
    bool        found, cfound;

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));

    if (!str_cmp(arg2, "in") || !str_cmp(arg2, "on")
    || !str_cmp(arg2, "") || !str_cmp(arg2, ""))
        argument = one_argument(argument, arg2, sizeof(arg2));

    if (arg1[0] == '\0' || arg2[0] == '\0')
    {
        char_act("Put what in what?", ch);
        return;
    }

    if (!str_cmp(arg2, "all") || !str_prefix("all.", arg2))
    {
        char_act("You can't do that.", ch);
        return;
    }

    if ((container = get_obj_here(ch, arg2)) == NULL)
    {
        act_puts("You see no $T here.", ch, NULL, arg2, TO_CHAR, POS_DEAD);
        return;
    }

    if ((container->pIndexData->item_type != ITEM_CONTAINER)
    && (container->pIndexData->item_type != ITEM_CORPSE_NPC)
    && (container->pIndexData->item_type != ITEM_CORPSE_PC))
    {
        char_act("That is not a container.", ch);
        return;
    }

    clan = is_clan_altar(container);
    if ((clan == NULL) || (clan != CLAN(ch->clan)))
        if (IS_SET(container->value[1], CONT_CLOSED))
        {
            act_puts("The $d is closed.", ch, NULL, container->name, TO_CHAR, POS_DEAD);
            if (!IS_IMMORTAL(ch))
                return;
        }

    if ((str_cmp(arg1, "all") && str_prefix("all.", arg1))
    && (str_cmp(arg1, "") && str_prefix(".", arg1)))
    {
        /* 'put obj container' */
        if ((obj = get_obj_carry(ch, arg1)) == NULL)
        {
            char_act("You do not have that item.", ch);
            return;
        }

        if (obj == container)
        {
            char_act("You can't fold it into itself.", ch);
            return;
        }

        if (!can_drop_obj(ch, obj))
        {
            char_act("You can't let go of it.", ch);
            return;
        }

        if (WEIGHT_MULT(obj) != 100)
        {
            char_act("You have a feeling that would be a bad idea.", ch);
            return;
        }

        if (container->pIndexData->item_type == ITEM_CORPSE_PC)
        {
            char_act("You have a feeling that would be a bad idea.", ch);
            act("$n tries to thrust $p in $P.", ch, obj, container, TO_ROOM);
            return;
        }

        if (obj->pIndexData->item_type == ITEM_CORPSE_PC)
        {
            char_act("To bury it would be necessary...", ch);
            return;
        }

        if (obj->pIndexData->limit != -1)
        {
            act_puts("This unworthy container won't hold $p.",
                ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
        }

        if (obj->timer > 0)
        {
            act_puts("$p decays, you should wait a little.", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
        }

        count = 0;
        for (objc = container->contains; objc; objc = objc->next_content)
            count++;

        put_obj(ch, container, obj, &count, TRUE);
    } else
    {
        if (!IS_NPC(ch) && IS_AFFECTED(ch, AFF_CHARM))
        {
            do_say(ch, "Nah, I won't do that.");
            return;
        }

        count = 0;
        for (objc = container->contains; objc; objc = objc->next_content)
            count++;

        /* 'put all container' or 'put all.obj container' */
        for (obj = ch->carrying; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;

            if ((arg1[3] == '\0' || is_name(&arg1[4], obj->name))
            && can_see_obj(ch, obj)
            && WEIGHT_MULT(obj) == 100
            && obj->wear_loc == WEAR_NONE
            && obj != container
            && obj->timer == 0
            && can_drop_obj(ch, obj))
            {
                cfound = FALSE;
                obj_curr = obj;
                found = put_obj(ch, container, obj, &count, FALSE);

                if (found && is_same_obj(obj_curr, obj_next))
                {
                    pcount++;
                    cfound = TRUE;
                }
                if (!cfound)
                {
                    if (pcount > 1)
                    {
                        act("$n puts $P[$j] ",
                            ch, (const void *) pcount, obj, TO_ROOM | ACT_NOLF);
                        act("$t $P.\n",
                            ch, IS_SET(container->value[1], CONT_PUT_ON) ? "on" : "into", container, TO_ROOM | ACT_NOUCASE);
                        act_puts("You put $P[$j] ",
                            ch, (const void *) pcount, obj, TO_CHAR | ACT_NOLF, POS_DEAD);
                        act_puts("$t $P.\n",
                            ch, IS_SET(container->value[1], CONT_PUT_ON) ? "on" : "into", container, TO_CHAR | ACT_NOUCASE, POS_DEAD);
                    } else
                    {
                        if (found)
                        {
                            act_puts3("$n puts $p $U $P.",
                                ch, obj, container, IS_SET(container->value[1], CONT_PUT_ON) ? "on" : "into", TO_ROOM, POS_RESTING);
                            act_puts3("You put $p $U $P.",
                                ch, obj, container, IS_SET(container->value[1], CONT_PUT_ON) ? "on" : "into", TO_CHAR, POS_DEAD);
                        }
                    }
                    pcount = 1;
                }
            }
        }
    }
}

void drop_obj(CHAR_DATA *ch, OBJ_DATA *obj, bool message)
{
    obj_from_char(obj);
    obj_to_room(obj, ch->in_room);

    if (message)
    {
        act("$n drops $p.",
            ch, obj, NULL, TO_ROOM | (IS_AFFECTED(ch, AFF_SNEAK) ? ACT_NOMORTAL : 0));
        act_puts("You drop $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
    }
    if (obj->pIndexData->vnum == OBJ_VNUM_POTION_VIAL
    && number_percent() < 51)
        switch (ch->in_room->sector_type)
        {
        case SECT_FOREST:
        case SECT_DESERT:
        case SECT_AIR:
        case SECT_WATER_NOSWIM:
        case SECT_WATER_SWIM:
        case SECT_FIELD:
            break;
        default:
            act("$p cracks and shaters into tiny pieces.",
                ch, obj, NULL, TO_ROOM);
            act("$p cracks and shaters into tiny pieces.",
                ch, obj, NULL, TO_CHAR);
            extract_obj(obj);
            return;
        }

    oprog_call(OPROG_DROP, obj, ch, NULL);

    if (HAS_TRIGGER_OBJ(obj, TRIG_DROP))
        p_give_trigger(NULL, obj, NULL, ch, obj, TRIG_DROP);

    if (HAS_TRIGGER_ROOM(ch->in_room, TRIG_DROP))
        p_give_trigger(NULL, NULL, ch->in_room, ch, obj, TRIG_DROP);

    if (!may_float(obj) && cant_float(obj) && IS_WATER(ch->in_room))
    {
        act("$p sinks down the water.", ch, obj, NULL,
            TO_ROOM | (IS_AFFECTED(ch, AFF_SNEAK) ? ACT_NOMORTAL : 0));
        act("$p sinks down the water.", ch, obj, NULL, TO_CHAR);
        extract_obj(obj);
    } else if (IS_OBJ_STAT(obj, ITEM_MELT_DROP))
    {
        act("$p dissolves into smoke.", ch, obj, NULL,
            TO_ROOM | (IS_AFFECTED(ch, AFF_SNEAK) ? ACT_NOMORTAL : 0));
        act("$p dissolves into smoke.", ch, obj, NULL, TO_CHAR);
        extract_obj(obj);
    }
}

void do_drop(CHAR_DATA * ch, const char *argument)
{
    char            arg[MAX_INPUT_LENGTH];
    OBJ_DATA       *obj;
    OBJ_DATA       *obj_next;
    bool            found, cfound ;
    int             count = 1;

    argument = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Drop what?", ch);
        return;
    }
    if (is_number(arg))
    {
        /* 'drop NNNN coins' */
        int             amount, gold = 0, silver = 0;
        amount = atoi(arg);
        argument = one_argument(argument, arg, sizeof(arg));
        if (amount <= 0
        || (str_cmp(arg, "coins") && str_cmp(arg, "coin") && str_cmp(arg, "")
        && str_cmp(arg, "gold") && str_cmp(arg, "silver")
        && str_cmp(arg, "") && str_cmp(arg, "")))
        {
            char_act("You can't do that.", ch);
            return;
        }
        if (!str_cmp(arg, "coins") || !str_cmp(arg, "coin")
        || !str_cmp(arg, "silver") || !str_cmp(arg, "")
        || !str_cmp(arg, ""))
        {
            if (ch->silver < amount)
            {
                char_act("You don't have that much silver.", ch);
                return;
            }
            ch->silver -= amount;
            silver = amount;
        }
        else
        {
            if (ch->gold < amount)
            {
                char_act("You don't have that much gold.", ch);
                return;
            }
            ch->gold -= amount;
            gold = amount;
        }

        for (obj = ch->in_room->contents; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;

            switch (obj->pIndexData->vnum)
            {
            case OBJ_VNUM_SILVER_ONE:
                silver += 1;
                extract_obj(obj);
                break;

            case OBJ_VNUM_GOLD_ONE:
                gold += 1;
                extract_obj(obj);
                break;

            case OBJ_VNUM_SILVER_SOME:
                silver += obj->value[0];
                extract_obj(obj);
                break;

            case OBJ_VNUM_GOLD_SOME:
                gold += obj->value[1];
                extract_obj(obj);
                break;

            case OBJ_VNUM_COINS:
                silver += obj->value[0];
                gold += obj->value[1];
                extract_obj(obj);
                break;
            }
        }

        obj = create_money(gold, silver);
        obj_to_room(obj, ch->in_room);
        act("$n drops some coins.", ch, NULL, NULL,
            TO_ROOM | (IS_AFFECTED(ch, AFF_SNEAK) ? ACT_NOMORTAL : 0));
        char_act("Ok.", ch);
        if (IS_WATER(ch->in_room))
        {
            extract_obj(obj);
            act("The coins sink down, and disapear in the water.",
                ch, NULL, NULL,TO_ROOM | (IS_AFFECTED(ch, AFF_SNEAK) ? ACT_NOMORTAL : 0));
            char_act("The coins sink down, and disapear in the water.", ch);
        }
        return;
    }
    if ((str_cmp(arg, "all") && str_prefix("all.", arg))
    && (str_cmp(arg, "") && str_prefix(".", arg)))
    {
        /* 'drop obj' */
        if ((obj = get_obj_carry(ch, arg)) == NULL)
        {
            char_act("You do not have that item.", ch);
            return;
        }
        if (!can_drop_obj(ch, obj))
        {
            char_act("You can't let go of it.", ch);
            return;
        }
        drop_obj(ch, obj, TRUE);
    } else
    {
/* 'drop all' or 'drop all.obj' */

        if (!IS_NPC(ch) && IS_AFFECTED(ch, AFF_CHARM))
        {
            do_say(ch, "Nah, I won't do that.");
            return;
        }

        found = FALSE;
        for (obj = ch->carrying; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;

            if ((arg[3] == '\0' || is_name(&arg[4], obj->name))
            && can_see_obj(ch, obj)
            && obj->wear_loc == WEAR_NONE
            && can_drop_obj(ch, obj))
            {
                found = TRUE;
                cfound = FALSE;
                if (is_same_obj(obj, obj->next_content))
                {
                    count++;
                    cfound = TRUE;
                }
                if (!cfound)
                {
                    if (count > 1)
                    {
                        act("$n drops $P[$j].", ch, (const void *) count, obj,
                            TO_ROOM | (IS_AFFECTED(ch, AFF_SNEAK) ? ACT_NOMORTAL : 0));
                        act("You drop $P[$j].",
                            ch, (const void *) count, obj, TO_CHAR);
                    }
                    else
                    {
                        act("$n drops $p.", ch, obj, NULL,
                            TO_ROOM | (IS_AFFECTED(ch, AFF_SNEAK) ? ACT_NOMORTAL : 0));
                        act("You drop $p.", ch, obj, NULL, TO_CHAR);
                    }
                    count = 1;
                }
                drop_obj(ch, obj, FALSE);
            }
        }

        if (!found)
        {
            if (arg[3] == '\0')
                act_puts("You are not carrying anything.", ch, NULL, arg, TO_CHAR, POS_DEAD);
            else
                act_puts("You are not carrying any $T.", ch, NULL, &arg[4], TO_CHAR, POS_DEAD);
        }
    }
}

void do_label(CHAR_DATA* ch, const char *argument)
{
    OBJ_DATA *  obj;
    char obj_name[MAX_INPUT_LENGTH];
    char label[MAX_INPUT_LENGTH];
    char buff[MAX_INPUT_LENGTH];

    if (IS_NPC(ch)) return;

    argument = first_arg(argument, obj_name, sizeof(obj_name), FALSE);
    first_arg(argument, label, sizeof(label), FALSE);

    if (!obj_name[0])
    {
        char_act("Label what?", ch);
        return;
    }

    if (!label[0])
    {
        char_act("How do you want to label it?", ch);
        return;
    }

    if ((obj=get_obj_carry(ch,obj_name)) == NULL)
    {
        char_act("You don't have that object.", ch);
        return;
    }

    if (is_name(label, obj->name))
    {
        char_act("Such label already is on object.", ch);
        return;
    }

    if (ch->pcdata->questpoints < 10)
    {
        char_act("You do not have enough questpoints for labeling.", ch);
        return;
    }


    if ((strlen(obj->name)+strlen(label)+1) >=MAX_INPUT_LENGTH)
    {
        char_act("You can't label this object with this label.", ch);
        return;
    }
    buff[0] = '\0';
    strnzcat(buff, sizeof(buff), obj->name);
    strnzcat(buff, sizeof(buff), " ");
    strnzcat(buff, sizeof(buff), label);
    free_string(obj->name);
    obj->name = strdup(buff);
    ch->pcdata->questpoints -= 10;
    char_act("Ok.", ch);
    return;
}


DO_FUN(do_nogive)
{
    TOGGLE_BIT(ch->comm, COMM_NOGIVE);
    if (IS_SET(ch->comm, COMM_NOGIVE))
        char_act("You any more do not accept items from others. ", ch);
    else
        char_act("Now you accept items from others.", ch);
}

void do_give(CHAR_DATA * ch, const char *argument)
{
    char            arg[MAX_INPUT_LENGTH];
    CHAR_DATA      *victim;
    OBJ_DATA       *obj;

    argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        char_act("   ?", ch);
        return;
    }

    if (is_number(arg))
    {
        /* 'give NNNN coins victim' */
        int             amount;
        bool            silver;

        amount = atoi(arg);

        argument = one_argument(argument, arg, sizeof(arg));
        if (arg[0] == '\0')
        {
            do_give(ch, str_empty);
            return;
        }

        if (amount <= 0
        || (str_cmp(arg, "coins") && str_cmp(arg, "coin")
        && str_cmp(arg, "gold") && str_cmp(arg, "silver")))
        {
            char_act(",      .", ch);
            return;
        }

        silver = str_cmp(arg, "gold");

        argument = one_argument(argument, arg, sizeof(arg));
        if (!str_cmp(arg, "to"))
            argument = one_argument(argument, arg, sizeof(arg));
        if (arg[0] == '\0')
        {
            do_give(ch, str_empty);
            return;
        }

        if ((victim = get_char_room(ch, arg)) == NULL)
        {
            char_act("  .", ch);
            return;
        }

        if ((!silver && ch->gold < amount)
        || (silver && ch->silver < amount))
        {
            char_act("    .", ch);
            return;
        }

        if ((silver && get_carry_weight(victim) + amount*SILVER_WEIGHT > can_carry_w(victim))
        || (!silver && get_carry_weight(victim) + amount*GOLD_WEIGHT > can_carry_w(victim)))
        {
            char_act("     .", ch);
            return;
        }

        if (silver)
        {
            ch->silver -= amount;
            victim->silver += amount;
        } else
        {
            ch->gold -= amount;
            victim->gold += amount;
        }

        act_puts3("$n   $J $t.", ch, silver ? "silver" : "gold", victim, (const void *) amount, TO_VICT | ACT_TRANS, POS_RESTING);
        act("$n  $N  .", ch, NULL, victim, TO_NOTVICT);
        act_puts3("  $N $J $t.", ch, silver ? "silver" : "gold", victim, (const void *) amount, TO_CHAR | ACT_TRANS, POS_RESTING);

        /*
         * Bribe trigger
         */
        if (IS_NPC(victim) && HAS_TRIGGER_MOB(victim, TRIG_BRIBE))
            p_bribe_trigger(victim, ch, silver ? amount : amount * 100);

        if (IS_NPC(victim)
            &&  IS_SET(victim->pIndexData->act, ACT_CHANGER))
        {
            int             change;
            change = (silver ? 95 * amount / 100 / 100
                      : 95 * amount);


            if (!silver && change > victim->silver)
                victim->silver += change;

            if (silver && change > victim->gold)
                victim->gold += change;

            if (change < 1 && can_see(victim, ch))
            {
                act_tell(",      .", victim, NULL, ch);
                doprintf(do_give, victim, "%d %s %s", amount, silver ? "silver" : "gold", ch->name);
            }
            else if (can_see(victim, ch))
            {
                doprintf(do_give, victim, "%d %s %s", change, silver ? "gold" : "silver", ch->name);
                if (silver)
                    doprintf(do_give, victim, "%d silver %s", (95 * amount / 100 - change * 100), ch->name);
                act_tell(",  !", victim, NULL, ch);
            }
            victim->silver = 0;
            victim->gold = 0;
        }
        return;
    }

    if ((obj = get_obj_carry(ch, arg)) == NULL)
    {
        char_act("    .", ch);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));
    if (!str_cmp(arg, "to"))
        argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        do_give(ch, str_empty);
        return;
    }

    if (obj->wear_loc != WEAR_NONE)
    {
        char_act("  .", ch);
        return;
    }

    if ((victim = get_char_room(ch, arg)) == NULL)
    {
        char_act("  .", ch);
        return;
    }

    if (IS_NPC(victim) && victim->pIndexData->pShop != NULL
    && !HAS_TRIGGER_MOB(victim, TRIG_GIVE))
    {
        do_tell_raw(victim, ch, ",    ?");
        return;
    }

    if (IS_NPC(victim)
    && is_affected (victim, gsn_mirror))
    {
        act("    $N!", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (!can_drop_obj(ch, obj))
    {
        char_act("     .", ch);
        return;
    }

    if (victim->carry_number + get_obj_number(obj) > can_carry_n(victim))
    {
        act(" $c1{$N} .", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (get_carry_weight(victim) + get_obj_weight(obj) > can_carry_w(victim))
    {
        act("$N     .", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (IS_SET(obj->pIndexData->extra_flags, ITEM_QUEST)
    && !IS_IMMORTAL(ch) && !IS_IMMORTAL(victim))
    {
        act_puts("   $gn{},   $p $c2{$N}.",
            ch, obj, victim, TO_CHAR, POS_DEAD);
        return;
    }

    if (!can_see_obj(victim, obj))
    {
        act("$N   .", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (obj->pIndexData->limit != -1)
    {
        if ((IS_OBJ_STAT(obj, ITEM_ANTI_EVIL) && IS_EVIL(victim))
        || (IS_OBJ_STAT(obj, ITEM_ANTI_GOOD) && IS_GOOD(victim))
        || (IS_OBJ_STAT(obj, ITEM_ANTI_NEUTRAL) && IS_NEUTRAL(victim)))
        {
            act("$gN{}       .",
                ch, NULL, victim, TO_CHAR);
            return;
        }
    }

    if (IS_SET(victim->comm, COMM_NOGIVE)
    && !IS_IMMORTAL(ch))
    {
        act("$N     .",
            ch, NULL, victim, TO_CHAR);
        return;
    }

    obj_from_char(obj);
    obj_to_char(obj, victim);
    act("$n  $p $c2{$N}.", ch, obj, victim, TO_NOTVICT | ACT_NOTRIG);
    act("$n   $p.", ch, obj, victim, TO_VICT | ACT_NOTRIG);
    act("  $p $c2{$N}.", ch, obj, victim, TO_CHAR | ACT_NOTRIG);

    if (HAS_TRIGGER_OBJ(obj, TRIG_GIVE))
        p_give_trigger(NULL, obj, NULL, ch, obj, TRIG_GIVE);

    if (HAS_TRIGGER_ROOM( ch->in_room, TRIG_GIVE))
       p_give_trigger(NULL, NULL, ch->in_room, ch, obj, TRIG_GIVE);

    if (IS_NPC(victim)
    && IS_SET(victim->pIndexData->act, ACT_CHANGER)
    && (obj->pIndexData->item_type == ITEM_MONEY))
    {
        act("$N     $p  .",ch, obj, victim, TO_CHAR | ACT_NOTRIG);
        ch->gold += obj->value[0];
        extract_obj(obj);
    }
    /*
     * Give trigger
    */
    if (IS_NPC(victim) && HAS_TRIGGER_MOB(victim, TRIG_GIVE))
        p_give_trigger(victim, NULL, NULL, ch, obj, TRIG_GIVE);

    oprog_call(OPROG_GIVE, obj, ch, victim);
}

/* for poisoning weapons and food/drink */
void do_envenom(CHAR_DATA * ch, const char *argument)
{
    OBJ_DATA       *obj;
    AFFECT_DATA     af;
    int     percent, chance;
    int     sn;

    /* find out what */
    if (argument == '\0')
    {
        char_act("  ?", ch);
        return;
    }
    obj = get_obj_list(ch, argument, ch->carrying);

    if (obj == NULL)
    {
        char_act("    .", ch);
        return;
    }

    if ((sn = sn_lookup("envenom")) < 0
    || (chance = get_skill(ch, sn)) == 0)
    {
        char_act("   ???", ch);
        return;
    }

    if (obj->pIndexData->item_type == ITEM_FOOD || obj->pIndexData->item_type == ITEM_DRINK_CON)
    {
        if (IS_OBJ_STAT(obj, ITEM_BLESS)
        || IS_OBJ_STAT(obj, ITEM_BURN_PROOF))
        {
            act("     $p.", ch, obj, NULL, TO_CHAR);
            return;
        }

        WAIT_STATE(ch, SKILL(sn)->beats);
        if (number_percent() < chance)
        {    /* success! */
            act("$n  $p  .",
                ch, obj, NULL, TO_ROOM);
            act("  $p  .",
                ch, obj, NULL, TO_CHAR);
            if (!obj->value[3])
            {
                obj->value[3] = 1;
                check_improve(ch, sn, TRUE, 4);
            }
            return;
        }
        act("     $p.", ch, obj, NULL, TO_CHAR);
        if (!obj->value[3])
            check_improve(ch, sn, FALSE, 4);
        return;
    } else if (obj->pIndexData->item_type == ITEM_WEAPON)
    {
        if (IS_WEAPON_STAT(obj, WEAPON_FLAMING)
        || IS_WEAPON_STAT(obj, WEAPON_FROST)
        || IS_WEAPON_STAT(obj, WEAPON_VAMPIRIC)
        || IS_WEAPON_STAT(obj, WEAPON_SHARP)
        || IS_WEAPON_STAT(obj, WEAPON_VORPAL)
        || IS_WEAPON_STAT(obj, WEAPON_RADIATION)
        || IS_WEAPON_STAT(obj, WEAPON_SHOCKING))
            chance/=2;

        if (IS_WEAPON_STAT(obj, WEAPON_HOLY)
        || IS_OBJ_STAT(obj, ITEM_BLESS)
        || IS_OBJ_STAT(obj, ITEM_BURN_PROOF))
        {
            act("    $p.",
                ch, obj, NULL, TO_CHAR);
            return;
        }
        if (obj->value[3] < 0
        || attack_table[obj->value[3]].damage == DAM_BASH)
        {
            char_act("     .", ch);
            return;
        }
        if (IS_WEAPON_STAT(obj, WEAPON_POISON))
        {
            act("$p  $gp{}.", ch, obj, NULL, TO_CHAR);
            return;
        }

        WAIT_STATE(ch, SKILL(sn)->beats);
        percent = number_percent();
        if (percent < chance)
        {
            af.where = TO_WEAPON;
            af.type = gsn_poison;
            af.level = LVL(ch) * percent / 100;
            af.duration = LVL(ch) * percent / 100;
            af.location = 0;
            af.modifier = 0;
            af.bitvector = WEAPON_POISON;
            affect_to_obj(obj, &af);

            act("$n  $p  .", ch, obj, NULL,
                TO_ROOM | (IS_AFFECTED(ch, AFF_SNEAK) ? ACT_NOMORTAL : 0));
            act("  $p  .", ch, obj, NULL, TO_CHAR);
            check_improve(ch, sn, TRUE, 3);
            return;
        } else
        {
            act("     $p.", ch, obj, NULL, TO_CHAR);
            check_improve(ch, sn, FALSE, 3);
            return;
        }
    }
    act("    $p.", ch, obj, NULL, TO_CHAR);
}

void do_fill(CHAR_DATA * ch, const char *argument)
{
    char            arg[MAX_INPUT_LENGTH];
    OBJ_DATA       *obj;
    OBJ_DATA       *fountain;
    bool            found;
    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act(" ?", ch);
        return;
    }
    if ((obj = get_obj_carry(ch, arg)) == NULL)
    {
        char_act("    .", ch);
        return;
    }
    found = FALSE;
    for (fountain = ch->in_room->contents; fountain != NULL; fountain = fountain->next_content)
    {
        if (fountain->pIndexData->item_type == ITEM_FOUNTAIN)
        {
            found = TRUE;
            break;
        }
    }

    if (!found)
    {
        char_act("  !", ch);
        return;
    }
    if (obj->pIndexData->item_type != ITEM_DRINK_CON)
    {
        char_act("    .", ch);
        return;
    }
    if (obj->value[1] != 0 && obj->value[2] != fountain->value[2])
    {
        char_act("     .", ch);
        return;
    }
    if (obj->value[1] >= obj->value[0] && obj->value[0] >= 0)
    {
        char_act("  .", ch);
        return;
    }
    //act_puts3("  $p $U  $P.", ch, obj, fountain, liq_table[fountain->value[2]].liq_name, TO_CHAR, POS_RESTING);
    //act_puts3("$n  $p $U  $P.",  ch, obj, fountain, liq_table[fountain->value[2]].liq_name, TO_ROOM, POS_RESTING);

    act_puts3("  $p $c4{$U}  $c1{$P}.", ch, obj, fountain, liquid_name(fountain->value[2]), TO_CHAR | ACT_TRANS, POS_RESTING);
    act_puts3("$n  $p $c4{$U}  $c1{$P}.",  ch, obj, fountain, liquid_name(fountain->value[2]), TO_ROOM | ACT_TRANS, POS_RESTING);

    obj->value[2] = fountain->value[2];
    obj->value[1] = obj->value[0];

}

void do_pour(CHAR_DATA * ch, const char *argument)
{
    char            arg[MAX_STRING_LENGTH];
    OBJ_DATA       *out, *in;
    CHAR_DATA      *vch = NULL;
    int             amount;
    argument = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0' || argument[0] == '\0')
    {
        char_act("   ?", ch);
        return;
    }
    if ((out = get_obj_carry(ch, arg)) == NULL)
    {
        char_act(" $gn{}   .", ch);
        return;
    }
    if (out->pIndexData->item_type != ITEM_DRINK_CON)
    {
        char_act("   .", ch);
        return;
    }
    if (!str_cmp(argument, "out"))
    {
        if (out->value[1] == 0)
        {
            char_act(" .", ch);
            return;
        }
                //act_puts3("$gn{} $gn{} $c3{$p},  $c3{$T} $U.",
        //    ch, out, liq_table[out->value[2]].liq_name, IS_WATER(ch->in_room) ? " " : " ", TO_CHAR | ACT_TRANS, POS_RESTING);

        //act_puts3("$n $gn{} $c3{$p},  $c3{$T} $U.",
        //    ch, out, liq_table[out->value[2]].liq_name, IS_WATER(ch->in_room) ? " " : " ", TO_ROOM | ACT_TRANS, POS_RESTING);
        act_puts3("$gn{} $gn{} $c3{$p},  $c3{$T} $U.",
            ch, out, liquid_name(out->value[2]), IS_WATER(ch->in_room) ? " " : " ", TO_CHAR | ACT_TRANS, POS_RESTING);

        act_puts3("$n $gn{} $c3{$p},  $c3{$T} $U.",
            ch, out, liquid_name(out->value[2]), IS_WATER(ch->in_room) ? " " : " ", TO_ROOM | ACT_TRANS, POS_RESTING);

        out->value[1] = 0;
        //out->value[2] = -1;

        return;
    }
    if ((in = get_obj_here(ch, argument)) == NULL)
    {
        vch = get_char_room(ch, argument);

        if (vch == NULL)
        {
            char_act(" ?", ch);
            return;
        }
        in = get_eq_char(vch, WEAR_HOLD);

        if (in == NULL)
        {
            act(" $gn{}  .", ch, out, NULL, TO_CHAR);
            return;
        }
    }
    if (in->pIndexData->item_type != ITEM_DRINK_CON)
    {
        char_act("$gn{} $gn{}      .", ch);
        return;
    }
    if (in == out)
    {
        char_act("$gn{}  $gn{}   !", ch);
        return;
    }
    if (in->value[1] != 0 && in->value[2] != out->value[2])
    {
        char_act(" -  .", ch);
        return;
    }
    if (out->value[1] == 0)
    {
        act("    $c1{$p}.", ch, out, NULL, TO_CHAR);
        return;
    }
    if (in->value[0] < 0)
    {
        act("$gn{}    $c3{$p}.", ch, in, NULL, TO_CHAR);
        return;
    }
    if (in->value[1] >= in->value[0])
    {
        act("$p  $gp{}  .", ch, in, NULL, TO_CHAR);
        return;
    }
    amount = UMIN(out->value[1], in->value[0] - in->value[1]);

    in->value[1] += amount;
    if (out->value[0]>0) out->value[1] -= amount;
    in->value[2] = out->value[2];

    if (vch == NULL)
    {
        act_puts3("$gn{} $gn{} $c3{$U}  $c1{$p}  $c3{$P}.",
            ch, out, in, /*liq_table[out->value[2]].liq_name*/liquid_name(out->value[2]), TO_CHAR | ACT_TRANS, POS_RESTING);
        act_puts3("$n $gn{} $c3{$U}  $c1{$p}  $c3{$P}.",
            ch, out, in, /*liq_table[out->value[2]].liq_name*/liquid_name(out->value[2]), TO_ROOM | ACT_TRANS, POS_RESTING);
    } else
    {
        act("$gn{} $gn{}  $c1{$t}  $c1{$N}.",  ch, liquid_name(out->value[2])/*liq_table[out->value[2]].liq_name*/, vch, TO_CHAR);
        act("$n $gn{} $gN{}  $c1{$t}.",  ch, liquid_name(out->value[2])/*liq_table[out->value[2]].liq_name*/, vch, TO_VICT);
        act("$n $gn{}  $c1{$t}  $c1{$N}.", ch, liquid_name(out->value[2])/*liq_table[out->value[2]].liq_name*/, vch, TO_NOTVICT);
    }

}

void do_drink(CHAR_DATA * ch, const char *argument)
{
    char            arg[MAX_INPUT_LENGTH];
    OBJ_DATA       *obj;
    int             amount;
    int             liquid;
    liquid_t       *lq;

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        for (obj = ch->in_room->contents; obj; obj= obj->next_content)
        {
            if (obj->pIndexData->item_type == ITEM_FOUNTAIN)
                break;
        }

        if (obj == NULL)
        {
            char_act(" ?", ch);
            return;
        }
    } else
    {
        if ((obj = get_obj_here(ch, arg)) == NULL)
        {
            char_act("    .", ch);
            return;
        }
    }

    if (!IS_NPC(ch) && ch->pcdata->condition[COND_DRUNK] > 10)
    {
        char_act("    . !", ch);
        return;
    }
    switch (obj->pIndexData->item_type)
    {
    default:
        char_act("    .", ch);
        return;

    case ITEM_FOUNTAIN:
        if ((liquid = obj->value[2]) < 0)
        {
            bug("Do_drink: bad liquid number %d.", liquid);
            liquid = obj->value[2] = 0;
        }

        lq = LIQUID(liquid);

        if (lq == NULL)
        {
              bug("Do_drink: lq NULL from liquid number %d.", liquid);
              lq = LIQUID(0);
        }

        amount = lq->ssize *3;
        //amount = liq_table[liquid].liq_affect[4] * 3;

        break;

    case ITEM_DRINK_CON:
        if (obj->value[1] == 0)
        {
            char_act(" .", ch);
            return;
        }
        if ((liquid = obj->value[2]) < 0)
        {
            bug("Do_drink: bad liquid number %d.", liquid);
            liquid = obj->value[2] = 0;
        }

        lq = LIQUID(liquid);

        if (lq == NULL)
        {
            bug("Do_drink: bad liquid number %d.", liquid);
            liquid = obj->value[2] = 0;
            lq = LIQUID(0);
        }

        amount = lq->thirst;

        if (obj->value[0]>=0)
              amount = UMIN(amount, obj->value[1]);
        break;
    }
    if (!IS_NPC(ch) && !IS_IMMORTAL(ch)  && ch->pcdata->condition[COND_FULL] > 80)
    {
        char_act("  ,      .", ch);
        return;
    }
    act("$n  $c3{$T}  $c1{$p}.", ch, obj, liquid_name(liquid)/*liq_table[liquid].liq_name*/, TO_ROOM | ACT_TRANS);
    act_puts("  $c3{$T}  $c1{$p}.", ch, obj, liquid_name(liquid)/*liq_table[liquid].liq_name*/, TO_CHAR | ACT_TRANS, POS_DEAD);

    if (ch->fighting)
        WAIT_STATE(ch, 3 * PULSE_VIOLENCE);

    if (!IS_UNDEAD(ch))
    {
        /*gain_condition(ch, COND_DRUNK,   amount * liq_table[liquid].liq_affect[COND_DRUNK] / 36);
        gain_condition(ch, COND_FULL,    amount * liq_table[liquid].liq_affect[COND_FULL] / 2);
        gain_condition(ch, COND_THIRST,  amount * liq_table[liquid].liq_affect[COND_THIRST] / 5);
        gain_condition(ch, COND_HUNGER,  amount * liq_table[liquid].liq_affect[COND_HUNGER] / 1);*/

        gain_condition(ch, COND_DRUNK,   amount * lq->proof  / 36);
        gain_condition(ch, COND_FULL,    amount * lq->full   / 2);
        gain_condition(ch, COND_THIRST,  amount * lq->thirst / 5);
        gain_condition(ch, COND_HUNGER,  amount * lq->food   / 1);

        if (!IS_NPC(ch) && ch->pcdata->condition[COND_DRUNK] > 10)
            char_act(" $gn{}.", ch);
        if (!IS_NPC(ch) && ch->pcdata->condition[COND_FULL] > 60)
            char_act("  .", ch);
        if (!IS_NPC(ch) && ch->pcdata->condition[COND_THIRST] > 60)
            char_act("Your thirst is quenched.", ch);

        if (obj->value[3] != 0 && !saves_spell(obj->level, ch, DAM_POISON))
        {
            /* The drink was poisoned ! */
            AFFECT_DATA     af;

            act("$n     .", ch, NULL, NULL, TO_ROOM);
            char_act("    .", ch);
            af.where        = TO_AFFECTS;
            af.type         = gsn_poison;
            af.level        = number_fuzzy(amount);
            af.duration     = 3 * amount;
            af.location     = APPLY_NONE;
            af.modifier     = 0;
            af.bitvector    = AFF_POISON;
            affect_join(ch, &af);
        }
    }
    if (obj->value[0] > 0)
        obj->value[1] = UMAX(obj->value[1]-amount,0);
    return;
}

void do_eat(CHAR_DATA * ch, const char *argument)
{
    char            arg[MAX_INPUT_LENGTH];
    OBJ_DATA       *obj;
    AFFECT_DATA    *af;

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        char_act(" ?", ch);
        return;
    }
    if ((obj = get_obj_carry(ch, arg)) == NULL)
    {
        char_act("    .", ch);
        return;
    }
    if (!IS_IMMORTAL(ch))
    {
        if ((obj->pIndexData->item_type != ITEM_FOOD
        || IS_SET(obj->extra_flags, ITEM_NOT_EDIBLE))
        && obj->pIndexData->item_type != ITEM_PILL)
        {
            char_act(" '.", ch);
            return;
        }
        if (!IS_NPC(ch) && ch->pcdata->condition[COND_FULL] > 80
        && obj->pIndexData->item_type != ITEM_PILL)
        {
            char_act("  .", ch);
            return;
        }
    }
    act("$n eats $p.", ch, obj, NULL, TO_ROOM);
    act_puts("You eat $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
    if (ch->fighting != NULL)
        WAIT_STATE(ch, 3 * PULSE_VIOLENCE);
    if (IS_UNDEAD(ch))
    {
        if (obj->pIndexData->vnum == OBJ_VNUM_TORN_HEART
        || obj->pIndexData->vnum == OBJ_VNUM_SEVERED_HEAD
        || obj->pIndexData->vnum == OBJ_VNUM_SLICED_ARM
        || obj->pIndexData->vnum == OBJ_VNUM_SLICED_LEG
        || obj->pIndexData->vnum == OBJ_VNUM_GUTS
        || obj->pIndexData->vnum == OBJ_VNUM_BRAINS)
        {
            act("$n looks much better, after using $p.", ch, obj, NULL, TO_ROOM);
            act_puts("You looks much better, after using $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);

            if (obj->pIndexData->vnum == OBJ_VNUM_TORN_HEART)
                ch->hit  += obj->level * 10;
            else
                ch->hit  += obj->level;
            ch->hit  =  UMIN(ch->hit,ch->max_hit);
            ch->mana += obj->level * 2;
            ch->mana =  UMIN(ch->mana,ch->max_mana);
            ch->move += obj->level / 2;
            ch->move =  UMIN(ch->move,ch->max_move);
        }
        extract_obj(obj);

        for (af = ch->affected; af; af = af->next)
        {
            if (af->type == gsn_cause_critical)
            {
                if (number_percent() < get_curr_stat(ch, STAT_LCK))
                {
                    affect_remove(ch, af);
                    char_act("Your wounds stopped bleeding so critically.", ch);
                }
            }
            if (af->type == gsn_cause_serious)
            {
                if (number_percent() < get_curr_stat(ch, STAT_LCK))
                {
                    affect_remove(ch, af);
                    char_act("Your wounds stopped bleeding so seriously.", ch);
                }
            }
            if (af->type == gsn_cause_light)
            {
                if (number_percent() < get_curr_stat(ch, STAT_LCK))
                {
                    affect_remove(ch, af);
                    char_act("Your wounds stopped bleeding.", ch);
                }
            }
        }

        return;
    }

    switch (obj->pIndexData->item_type)
    {
    case ITEM_FOOD:
        if (!IS_NPC(ch))
        {
            int             condition;
            condition = ch->pcdata->condition[COND_HUNGER];
            gain_condition(ch, COND_FULL, obj->value[0] * 2);
            gain_condition(ch, COND_HUNGER, obj->value[1] * 2);
            if (!condition
            && ch->pcdata->condition[COND_HUNGER] > 0)
                char_act("    .", ch);
            else if (ch->pcdata->condition[COND_FULL] > 60)
                char_act("  .", ch);
            if (obj->pIndexData->vnum == OBJ_VNUM_TORN_HEART)
            {
                if (IS_CYBORG(ch))
                    ch->hit = UMIN(ch->max_hit, ch->hit+ch->level*2+obj->level*10);
                else
                    ch->hit = UMIN(ch->max_hit, ch->hit+ch->level+obj->level*5);

                char_act("You feel empowered by the blood of your foe.", ch);
            }
        }
        if (obj->value[3] != 0 && !saves_spell(obj->level, ch, DAM_POISON))
        {
            /* The food was poisoned! */
            AFFECT_DATA     af;

            act("$n     .", ch, NULL, NULL, TO_ROOM);
            char_act("    !", ch);

            af.where        = TO_AFFECTS;
            af.type         = gsn_poison;
            af.level        = number_fuzzy(obj->value[0]);
            af.duration     = 2 * obj->value[0];
            af.location     = APPLY_NONE;
            af.modifier     = 0;
            af.bitvector    = AFF_POISON;
            affect_join(ch, &af);
        }
        break;

    case ITEM_PILL:
        if (ch->level < obj->level)
        {
            char_act("      .", ch);
            extract_obj(obj);
            return;
        }

        obj_cast_spell(obj->value[1], obj->value[0], ch, ch, NULL);
        obj_cast_spell(obj->value[2], obj->value[0], ch, ch, NULL);
        obj_cast_spell(obj->value[3], obj->value[0], ch, ch, NULL);
        obj_cast_spell(obj->value[4], obj->value[0], ch, ch, NULL);

        break;
    }

    extract_obj(obj);
    return;
}

/*
 * Remove an object.
 */
bool remove_obj(CHAR_DATA * ch, int iWear, bool fReplace)
{
    OBJ_DATA       *obj;
    AFFECT_DATA      af;
    if ((obj = get_eq_char(ch, iWear)) == NULL)
        return TRUE;

    if (!fReplace)
        return FALSE;

    if (obj->pIndexData->item_type == ITEM_SHAMAN_TATTOO)
    {
        act_puts("You can't remove $p this way.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        return FALSE;
    }

    if (IS_SET(obj->extra_flags, ITEM_NOREMOVE))
    {
        act_puts("    $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        return FALSE;
    }
    if ((obj->pIndexData->item_type == ITEM_TATTOO) && (!IS_IMMORTAL(ch)))
    {
        act_puts(" $gn{}  $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        return FALSE;
    }
    if (iWear == WEAR_STUCK_IN)
    {
        unequip_char(ch, obj);

        if (get_eq_char(ch, WEAR_STUCK_IN) == NULL)
        {
            if (is_affected(ch, gsn_arrow))
                affect_strip(ch, gsn_arrow);
            if (is_affected(ch, gsn_spear))
                affect_strip(ch, gsn_spear);
            if (is_affected(ch, gsn_shuriken))
                affect_strip(ch, gsn_shuriken);
            if (is_affected(ch, gsn_knife))
                affect_strip(ch, gsn_knife);
        }
        act_puts("  $c3{$p},   .",
            ch, obj, NULL, TO_CHAR, POS_DEAD);
        act("$n  $c3{$p},   .",
            ch, obj, NULL, TO_ROOM);
        if (number_percent() < 60)
        {
            int dam=ch->level-5;
            switch (number_bits(2))
            {
            case 0:
                act_puts("..   $gn{} ,    .",
                    ch, obj, NULL, TO_CHAR, POS_DEAD);
                act("$n   ,    $c1{$gn{}}   .",
                    ch, obj, NULL, TO_ROOM);
                dam*=2;
                break;
            case 1:
                if (!IS_AFFECTED(ch, AFF_CORRUPTION))
                {
                    act_puts("    !      .",
                        ch, obj, NULL, TO_CHAR, POS_DEAD);
                    act("$n   .",
                        ch, obj, NULL, TO_ROOM);
                    af.where     = TO_AFFECTS;
                    af.type      = sn_lookup("corruption");
                    af.level     = ch->level * 3/4;
                    af.duration  = (1 + ch->level / 10);
                    af.location  = APPLY_NONE;
                    af.modifier  = 0;
                    af.bitvector = AFF_CORRUPTION;
                    affect_join(ch,&af);
                }
                break;
            case 2:
                act_puts(" $c1{$p}  ,   .",
                    ch, obj, NULL, TO_CHAR, POS_DEAD);
                dam/=2;
                break;
            case 3:
                break;
            }

            if (dam < ch->hit)
                ch->hit -= dam;
            else
                ch->hit = 1;
        }

        WAIT_STATE(ch, 4);
        return TRUE;
    }
    unequip_char(ch, obj);
    act("$n  $c3{$p}.", ch, obj, NULL, TO_ROOM);
    act_puts("  $c3{$p}.", ch, obj, NULL, TO_CHAR, POS_DEAD);

    if ((obj->pIndexData->item_type == ITEM_WEAPON) && IS_OBJ_STAT(obj,ITEM_DEATH))
    {
        act("The black mist around $p fades away.",ch,obj,NULL,TO_ALL);
        REMOVE_BIT(obj->extra_flags,ITEM_DEATH);
    }
    if ((obj->pIndexData->item_type == ITEM_WEAPON) && IS_OBJ_STAT(obj,ITEM_SINGING))
    {
        act( "$p .",ch,obj,NULL,TO_ALL);
        REMOVE_BIT(obj->extra_flags,ITEM_SINGING);
    }

    if (iWear == WEAR_WIELD
    && (obj = get_eq_char(ch, WEAR_SECOND_WIELD)) != NULL)
    {
        unequip_char(ch, obj);
        equip_char(ch, obj, WEAR_WIELD);

        if (is_affected(ch,gsn_deathgrip) && !IS_OBJ_STAT(obj,ITEM_DEATH))
        {
            SET_BIT( obj->extra_flags, ITEM_DEATH);
            act("$p flickers with dark power.",ch,obj,NULL,TO_ALL);
        }

        if (!is_affected(ch,gsn_deathgrip) && IS_OBJ_STAT(obj,ITEM_DEATH))
        {
            REMOVE_BIT(obj->extra_flags, ITEM_DEATH);
        }

        if (is_affected(ch, gsn_weaponsong) && !IS_OBJ_STAT(obj,ITEM_SINGING))
        {
            int my_chance = get_skill(ch, gsn_weaponsong);

            if (IS_WEAPON_STAT(obj,WEAPON_FLAMING)) my_chance -= 10;
            if (IS_WEAPON_STAT(obj,WEAPON_FROST))my_chance -= 10;
            if (IS_WEAPON_STAT(obj,WEAPON_SHARP)) my_chance -= 10;
            if (IS_WEAPON_STAT(obj,WEAPON_VORPAL)) my_chance -= 10;
            if (IS_WEAPON_STAT(obj,WEAPON_SHOCKING)) my_chance -= 10;
            if (IS_WEAPON_STAT(obj,WEAPON_RADIATION)) my_chance -= 10;

            if (ch->mana > ch->level)
                ch->mana -= ch->level;
            else
            {
                char_act("   ...", ch);
                my_chance = 0;
            }

            if (number_percent() < my_chance)
            {
                SET_BIT( obj->extra_flags, ITEM_SINGING);
                act("$p     .", ch, obj, NULL, TO_CHAR);
                act("$p     $c4{$n}.", ch, obj, ch, TO_NOTVICT);
            } else
            {
                act("$p ..", ch, obj, NULL, TO_CHAR);
            }

        }

        if (!is_affected(ch,gsn_weaponsong) && IS_OBJ_STAT(obj,ITEM_SINGING))
        {
            REMOVE_BIT(obj->extra_flags, ITEM_SINGING);
        }
    }
    return TRUE;
}

/*
 * Wear one object.
 * Optional replacement of existing objects.
 * Big repetitive code, ick.
 */

#define CLASS_RACE_WEAR(loc)                    \
    if (!class_can_wear(ch, loc)) {             \
        act_puts("     $c3{$p}.", ch, obj, NULL, TO_CHAR, POS_DEAD); \
        return;                     \
    }                           \
        if (!race_can_wear(ch, loc)) {                          \
            act_puts("   $c3{$p}.", ch, obj, NULL, TO_CHAR, POS_DEAD); \
            return;                                             \
        }

void wear_obj(CHAR_DATA * ch, OBJ_DATA * obj, bool fReplace)
{
    clan_t *clan;
    int wear_level = get_wear_level(ch, obj);

    if (obj->pIndexData->item_type == ITEM_PILL)
    {
          char_act(" ?      ?", ch);
          return;
    }

    if (obj->pIndexData->item_type == ITEM_KEYRING)
    {
          char_act(" ?         !", ch);
          return;
    }

    if (IS_SET(muddy_mode, MUDDY_RACE_WEAR))
    {
            if (!race_can_wear_material(obj->material, ch->race) && obj->pIndexData->limit < 1 )
            {
                  char_act("Your race cannot wear this material", ch);
                  return;
            }
    }

    if (IS_SET(obj->extra_flags, ITEM_MAGIC))
    {
        clan = CLAN(ch->clan);
        if (IS_SET(clan->flags, CLAN_HATE_MAGIC))
        {
            char_act("     !", ch);
            return;
        }
    }

    if (  IS_SET(obj->extra_flags, ITEM_WARRIOR_ONLY)
    && ((!IS_NPC(ch) &&   !is_class_warrior(ch))
    ||   (IS_NPC(ch) && !IS_SET(ch->pIndexData->act, ACT_WARRIOR)))
    && ch->level < LEVEL_IMMORTAL)
    {
        act("$n   $p,   $p  .",  ch, obj, NULL, TO_ROOM);
        act_puts("   $p,  $p     .", ch, obj, NULL, TO_CHAR, POS_DEAD);
        return;
    }

    if (IS_SET(obj->extra_flags, ITEM_MAGE_ONLY) && !is_class_mage(ch) && ch->level < LEVEL_IMMORTAL)
    {
        act("$n   $p,  pp $p  .", ch, obj, NULL, TO_ROOM);
        act_puts("   $p,  $p     .", ch, obj, NULL, TO_CHAR, POS_DEAD);
        return;
    }

    if (IS_SET(obj->extra_flags, ITEM_HERO_ONLY) && (ch->level < LEVEL_HERO || IS_NPC(ch)))
    {
        act("$n   $p,   $gn{}.", ch, obj, NULL, TO_ROOM);
        act_puts("$n tries to use $p, but is too inexperienced.", ch, obj, NULL, TO_ROOM, POS_RESTING);
        return;
    }

    if (IS_SET(obj->extra_flags, ITEM_GOD_ONLY) && (ch->level < LEVEL_IMMORTAL || IS_NPC(ch)))
    {
        act("$n   $p,   $gn{}.", ch, obj, NULL, TO_ROOM);
        act_puts("$n tries to use $p, but is too inexperienced.", ch, obj, NULL, TO_ROOM, POS_RESTING);
        return;
    }

    if (wear_level < obj->level)
    {
        char_printf(ch, "  %d      .\n", obj->level - wear_level + ch->level);
        act_puts("$n tries to use $p, but is too inexperienced.", ch, obj, NULL, TO_ROOM, POS_RESTING);
        return;
    }

    if (obj->pIndexData->item_type == ITEM_LIGHT)
    {
        CLASS_RACE_WEAR(WEAR_LIGHT);
        if (!remove_obj(ch, WEAR_LIGHT, fReplace))
            return;

        act("$n  $c3{$p}    $c4{$gp{}}.", ch, obj, NULL, TO_ROOM);
        act_puts("  $c3{$p}    $c4{$gp{}}.", ch, obj, NULL, TO_CHAR, POS_DEAD);

        equip_char(ch, obj, WEAR_LIGHT);
        return;
    }

    if (CAN_WEAR(obj, ITEM_WEAR_FINGER))
    {
        CLASS_RACE_WEAR(WEAR_FINGER_L);
        if (get_eq_char(ch, WEAR_FINGER_L) != NULL
        && get_eq_char(ch, WEAR_FINGER_R) != NULL
        && !remove_obj(ch, WEAR_FINGER_L, fReplace)
        && !remove_obj(ch, WEAR_FINGER_R, fReplace))
            return;

        if (get_eq_char(ch, WEAR_FINGER_L) == NULL)
        {
            act("$n  $p     .", ch, obj, NULL, TO_ROOM);
            act_puts("  $p     .", ch, obj, NULL, TO_CHAR, POS_DEAD);
            equip_char(ch, obj, WEAR_FINGER_L);
            return;
        }
        if (get_eq_char(ch, WEAR_FINGER_R) == NULL)
        {
            act("$n  $p     .", ch, obj, NULL, TO_ROOM);
            act_puts("  $p     .", ch, obj, NULL, TO_CHAR, POS_DEAD);
            equip_char(ch, obj, WEAR_FINGER_R);
            return;
        }
        bug("Wear_obj: no free finger.", 0);
        char_act("    .", ch);
        return;
    }
    if (CAN_WEAR(obj, ITEM_WEAR_NECK))
    {
        CLASS_RACE_WEAR(WEAR_NECK_1);
        if (get_eq_char(ch, WEAR_NECK_1) != NULL
        && !remove_obj(ch, WEAR_NECK_1, fReplace))
            return;

        if (get_eq_char(ch, WEAR_NECK_1) == NULL)
        {
            act("$n  $p  $gn{} .", ch, obj, NULL, TO_ROOM);
            act_puts("  $p  .", ch, obj, NULL, TO_CHAR, POS_DEAD);
            equip_char(ch, obj, WEAR_NECK_1);
            return;
        }
    }

    if (CAN_WEAR(obj, ITEM_WEAR_EAR))
    {
        CLASS_RACE_WEAR(WEAR_EAR);
        if (!remove_obj(ch, WEAR_EAR, fReplace))
            return;
        act("$n     $p.", ch, obj, NULL, TO_ROOM);
        act_puts("  $p   .", ch, obj, NULL, TO_CHAR, POS_DEAD);
        equip_char(ch, obj, WEAR_EAR);
        return;
    }

    if (CAN_WEAR(obj, ITEM_WEAR_BODY))
    {
        CLASS_RACE_WEAR(WEAR_BODY);
        if ((is_affected(ch, gsn_thumbling))
        && (get_curr_stat(ch, STAT_STR) < 24))
        {
            act_puts("  ,    $p", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
        }
        if (!remove_obj(ch, WEAR_BODY, fReplace))
            return;
        act("$n    $p.", ch, obj, NULL, TO_ROOM);
        act_puts("  $p  .", ch, obj, NULL, TO_CHAR, POS_DEAD);
        equip_char(ch, obj, WEAR_BODY);
        return;
    }

    if (CAN_WEAR(obj, ITEM_WEAR_HEAD))
    {
        CLASS_RACE_WEAR(WEAR_HEAD);
        if (!remove_obj(ch, WEAR_HEAD, fReplace))
            return;
        act("$n  $p  .", ch, obj, NULL, TO_ROOM);
        act_puts("  $p  .", ch, obj, NULL, TO_CHAR, POS_DEAD);
        equip_char(ch, obj, WEAR_HEAD);
        return;
    }

    if (CAN_WEAR(obj, ITEM_WEAR_LEGS))
    {
        CLASS_RACE_WEAR(WEAR_LEGS);
        if (!remove_obj(ch, WEAR_LEGS, fReplace))
            return;
        act("$n  $p  .", ch, obj, NULL, TO_ROOM);
        act_puts("  $p  ", ch, obj, NULL, TO_CHAR, POS_DEAD);
        equip_char(ch, obj, WEAR_LEGS);
        return;
    }
    if (CAN_WEAR(obj, ITEM_WEAR_FEET))
    {
        CLASS_RACE_WEAR(WEAR_FEET);
        if (!remove_obj(ch, WEAR_FEET, fReplace))
            return;
        act("$n   $p.", ch, obj, NULL, TO_ROOM);
        act_puts("  $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        equip_char(ch, obj, WEAR_FEET);
        return;
    }
    if (CAN_WEAR(obj, ITEM_WEAR_HANDS))
    {
        CLASS_RACE_WEAR(WEAR_HANDS);
        if (!remove_obj(ch, WEAR_HANDS, fReplace))
            return;
        act("$n    $p.", ch, obj, NULL, TO_ROOM);
        act_puts("  $p  .", ch, obj, NULL, TO_CHAR, POS_DEAD);
        equip_char(ch, obj, WEAR_HANDS);
        return;
    }
    if (CAN_WEAR(obj, ITEM_WEAR_ARMS))
    {
        CLASS_RACE_WEAR(WEAR_ARMS);
        if (!remove_obj(ch, WEAR_ARMS, fReplace))
            return;
        act("$n    $p.", ch, obj, NULL, TO_ROOM);
        act_puts("    $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        equip_char(ch, obj, WEAR_ARMS);
        return;
    }
    if (CAN_WEAR(obj, ITEM_WEAR_ABOUT))
    {
        CLASS_RACE_WEAR(WEAR_ABOUT);
        if (!remove_obj(ch, WEAR_ABOUT, fReplace))
            return;
        act("$n   $p.", ch, obj, NULL, TO_ROOM);
        act_puts("   $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        equip_char(ch, obj, WEAR_ABOUT);
        return;
    }
    if (CAN_WEAR(obj, ITEM_WEAR_WAIST))
    {
        CLASS_RACE_WEAR(WEAR_WAIST);
        if (!remove_obj(ch, WEAR_WAIST, fReplace))
            return;
        act("$n  $p.", ch, obj, NULL, TO_ROOM);
        act_puts("  $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        equip_char(ch, obj, WEAR_WAIST);
        return;
    }
    if (CAN_WEAR(obj, ITEM_WEAR_WRIST))
    {
        CLASS_RACE_WEAR(WEAR_WRIST_L);
        if (get_eq_char(ch, WEAR_WRIST_L) != NULL
        && get_eq_char(ch, WEAR_WRIST_R) != NULL
        && !remove_obj(ch, WEAR_WRIST_L, fReplace)
        && !remove_obj(ch, WEAR_WRIST_R, fReplace))
            return;

        if (get_eq_char(ch, WEAR_WRIST_L) == NULL)
        {
            act("$n  $p    .", ch, obj, NULL, TO_ROOM);
            act_puts("  $p    .", ch, obj, NULL, TO_CHAR, POS_DEAD);
            equip_char(ch, obj, WEAR_WRIST_L);
            return;
        }
        if (get_eq_char(ch, WEAR_WRIST_R) == NULL)
        {
            act("$n  $p    .", ch, obj, NULL, TO_ROOM);
            act_puts("  $p    .", ch, obj, NULL, TO_CHAR, POS_DEAD);
            equip_char(ch, obj, WEAR_WRIST_R);
            return;
        }
        bug("Wear_obj: no free wrist.", 0);
        char_act("     2 .", ch);
        return;
    }
    if (CAN_WEAR(obj, ITEM_WEAR_SHIELD))
    {
        OBJ_DATA       *weapon;
        CLASS_RACE_WEAR(WEAR_SHIELD);
        if (get_eq_char(ch, WEAR_SECOND_WIELD) != NULL)
        {
            char_act("    ,    .", ch);
            return;
        }
        if (!remove_obj(ch, WEAR_SHIELD, fReplace))
            return;

        weapon = get_eq_char(ch, WEAR_WIELD);
        if (weapon != NULL && (obj->weight > get_curr_stat(ch, STAT_STR))
        && IS_WEAPON_STAT(weapon, WEAPON_TWO_HANDS))
        {
            char_act("      !", ch);
            return;
        }
        act("$n  $p   .", ch, obj, NULL, TO_ROOM);
        act_puts("  $p   .", ch, obj, NULL, TO_CHAR, POS_DEAD);
        equip_char(ch, obj, WEAR_SHIELD);
        return;
    }
    if (CAN_WEAR(obj, ITEM_WIELD))
    {
        int             skill;
        OBJ_DATA       *dual;
        OBJ_DATA       *shield;
        AFFECT_DATA    *paf;
        CLASS_RACE_WEAR(WEAR_WIELD);

        if ((dual = get_eq_char(ch, WEAR_SECOND_WIELD)) != NULL)
            unequip_char(ch, dual);

        if (!remove_obj(ch, WEAR_WIELD, fReplace))
        {
            if (dual)
                equip_char(ch, dual, WEAR_SECOND_WIELD);
            return;
        }

        if (!IS_NPC(ch) && get_obj_weight(obj) >
            str_app[get_curr_stat(ch, STAT_STR)].wield * 10)
        {
            char_act("     ,     .", ch);
            if (dual)
                equip_char(ch, dual, WEAR_SECOND_WIELD);
            return;
        }
        if (IS_WEAPON_STAT(obj, WEAPON_TWO_HANDS)
        && !IS_NPC(ch) && ch->size < SIZE_LARGE_MIN)
            if (get_eq_char(ch, WEAR_HOLD)
            || ((shield = get_eq_char(ch, WEAR_SHIELD)) != NULL
            && shield->weight > get_curr_stat(ch, STAT_STR))
            || get_eq_char(ch, WEAR_SECOND_WIELD) != NULL)
            {
                char_act("    ,    .", ch);

                if (dual)
                    equip_char(ch, dual, WEAR_SECOND_WIELD);
                return;
            }
        for (paf = ch->affected; paf != NULL; paf = paf->next)
        {
            if (paf->type != gsn_boneshatter || paf->location != APPLY_NONE)
                continue;
            if (paf->modifier > 1)
            {
                char_act("    ,    !", ch);
                return;
            }
            break;
        }
        act("$n wields $p.", ch, obj, NULL, TO_ROOM);
        act_puts("You wield $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        obj = equip_char(ch, obj, WEAR_WIELD);

        if (obj == NULL)
            return;

        if (is_affected(ch,gsn_deathgrip) && !IS_OBJ_STAT(obj,ITEM_DEATH))
        {
            SET_BIT( obj->extra_flags, ITEM_DEATH);
            act("$p flickers with dark power.",ch,obj,NULL,TO_ALL);
        }

        if (!is_affected(ch,gsn_deathgrip) && IS_OBJ_STAT(obj,ITEM_DEATH))
        {
            REMOVE_BIT(obj->extra_flags, ITEM_DEATH);
        }

        if (is_affected(ch,gsn_weaponsong) && !IS_OBJ_STAT(obj,ITEM_SINGING))
        {
            int my_chance = get_skill(ch, gsn_weaponsong);

            if (IS_WEAPON_STAT(obj,WEAPON_FLAMING))     my_chance -= 10;
            if (IS_WEAPON_STAT(obj,WEAPON_FROST))       my_chance -= 10;
            if (IS_WEAPON_STAT(obj,WEAPON_SHARP))       my_chance -= 10;
            if (IS_WEAPON_STAT(obj,WEAPON_VORPAL))      my_chance -= 10;
            if (IS_WEAPON_STAT(obj,WEAPON_SHOCKING))    my_chance -= 10;
            if (IS_WEAPON_STAT(obj,WEAPON_RADIATION))   my_chance -= 10;

            /*if (ch->mana > ch->level)
                ch->mana -= ch->level;
            else
            {
                char_act("   .. ", ch);
                my_chance = 0;
            }*/

            if (number_percent() < my_chance)
            {
                SET_BIT( obj->extra_flags, ITEM_SINGING);
                act("$p     .", ch, obj, NULL, TO_CHAR);
                act("$p     $n.", ch, obj, ch, TO_NOTVICT);
            } else
            {
                act("$p ..", ch, obj, NULL, TO_CHAR);
            }
        }
        if (!is_affected(ch, gsn_weaponsong) && IS_OBJ_STAT(obj, ITEM_SINGING))
        {
            REMOVE_BIT(obj->extra_flags, ITEM_SINGING);
        }

        if (obj->pIndexData->vnum == OBJ_VNUM_PICK)
        {
            act_puts("  $p   ģ !", ch, obj, NULL, TO_CHAR, POS_DEAD);
            return;
        }

        skill = get_weapon_skill(ch, get_weapon_sn(obj));

        if (skill >= 100)
            act_puts("$p     !", ch, obj, NULL, TO_CHAR, POS_DEAD);
        else if (skill > 85)
            act_puts("     $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        else if (skill > 70)
            act_puts("    $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        else if (skill > 50)
            act_puts("    ,   $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        else if (skill > 25)
            act_puts("$p     .", ch, obj, NULL, TO_CHAR, POS_DEAD);
        else if (skill > 1)
            act_puts("      $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        else
            act_puts("        $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        return;
    }
    if (CAN_WEAR(obj, ITEM_HOLD))
    {
        OBJ_DATA       *weapon;
        CLASS_RACE_WEAR(WEAR_HOLD);
        if (get_eq_char(ch, WEAR_SECOND_WIELD) != NULL)
        {
            char_act("      ,    .", ch);
            return;
        }
        weapon = get_eq_char(ch, WEAR_WIELD);
        if (weapon != NULL && ch->size < SIZE_LARGE_MIN
            &&  IS_WEAPON_STAT(weapon, WEAPON_TWO_HANDS))
        {
            char_act("   p  p p    p.", ch);
            return;
        }
        if (!remove_obj(ch, WEAR_HOLD, fReplace))
            return;
        act("$n    $p.", ch, obj, NULL, TO_ROOM);
        act_puts("    $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        equip_char(ch, obj, WEAR_HOLD);
        return;
    }
    if (CAN_WEAR(obj, ITEM_WEAR_FLOAT))
    {
        CLASS_RACE_WEAR(WEAR_FLOAT);
        if (!remove_obj(ch, WEAR_FLOAT, fReplace))
            return;
        act("$n  $p      $gn{}.", ch, obj, NULL, TO_ROOM);
        act_puts("  $p      .", ch, obj, NULL, TO_CHAR, POS_DEAD);
        equip_char(ch, obj, WEAR_FLOAT);
        return;
    }
    if (CAN_WEAR(obj, ITEM_WEAR_TATTOO) && IS_IMMORTAL(ch))
    {
        CLASS_RACE_WEAR(WEAR_TATTOO);
        if (!remove_obj(ch, WEAR_TATTOO, fReplace))
            return;
        act("$n  $p    .", ch, obj, NULL, TO_ROOM);
        act_puts("  $p    .", ch, obj, NULL, TO_CHAR, POS_DEAD);
        equip_char(ch, obj, WEAR_TATTOO);
        return;
    }
    if (CAN_WEAR(obj, ITEM_WEAR_CLANMARK))
    {
        CLASS_RACE_WEAR(WEAR_CLANMARK);
        if (!remove_obj(ch, WEAR_CLANMARK, fReplace))
            return;
        act("$n  $p    .", ch, obj, NULL, TO_ROOM);
        act_puts("  $p    .", ch, obj, NULL, TO_CHAR, POS_DEAD);
        equip_char(ch, obj, WEAR_CLANMARK);
        return;
    }
    if (CAN_WEAR(obj, ITEM_WEAR_PLUG_IN))
    {
        CLASS_RACE_WEAR(WEAR_PLUG_IN);
        if (!remove_obj(ch, WEAR_PLUG_IN, fReplace))
            return;
        act("$n  $p   PCMCIA .", ch, obj, NULL, TO_ROOM);
        act_puts("  $p   PCMCIA .", ch, obj, NULL, TO_CHAR, POS_DEAD);
        equip_char(ch, obj, WEAR_PLUG_IN);
        return;
    }
    if (CAN_WEAR(obj, ITEM_WEAR_TAIL))
    {
        CLASS_RACE_WEAR(WEAR_TAIL);
        if (!remove_obj(ch, WEAR_TAIL, fReplace))
            return;
        act("$n  $p  .", ch, obj, NULL, TO_ROOM);
        act_puts("  $p  .", ch, obj, NULL, TO_CHAR, POS_DEAD);
        equip_char(ch, obj, WEAR_TAIL);
        return;
    }
    if (CAN_WEAR(obj, ITEM_WEAR_FACE))
    {
        CLASS_RACE_WEAR(WEAR_FACE);
        if (!remove_obj(ch, WEAR_FACE, fReplace))
            return;
        act("$n  $p  .", ch, obj, NULL, TO_ROOM);
        act_puts("  $p  .", ch, obj, NULL, TO_CHAR, POS_DEAD);
        equip_char(ch, obj, WEAR_FACE);
        return;
    }

    if (fReplace)
        char_act("   ,      .", ch);
}

void do_wear(CHAR_DATA * ch, const char *argument)
{
    char            arg[MAX_INPUT_LENGTH];
    OBJ_DATA       *obj;
    OBJ_DATA       *obj_next;
    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act(",     ?", ch);
        return;
    }
    if (!str_cmp(arg, "all") || !str_cmp(argument, ""))
        for (obj = ch->carrying; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            if (obj->wear_loc == WEAR_NONE && can_see_obj(ch, obj))
                wear_obj(ch, obj, FALSE);
        }
    else if ((obj = get_obj_carry(ch, arg)) == NULL)
    {
        char_act("   .", ch);
        return;
    }
    else
        wear_obj(ch, obj, TRUE);
}

void do_remove(CHAR_DATA * ch, const char *argument)
{
    char            arg[MAX_INPUT_LENGTH];
    OBJ_DATA       *obj;
    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act(" ?", ch);
        return;
    }
    if (!str_cmp(arg, "all") || !str_cmp(argument, ""))
    {
        OBJ_DATA       *obj_next;

        if (!IS_NPC(ch) && IS_AFFECTED(ch, AFF_CHARM))
        {
            do_say(ch, "     !");
            return;
        }

        for (obj = ch->carrying; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            if (obj->wear_loc != WEAR_NONE && can_see_obj(ch, obj))
                remove_obj(ch, obj->wear_loc, TRUE);
        }
        return;
    }
    if (!str_cmp(arg, "tattoo") || !str_cmp(arg, ""))
    {
        do_remove_tattoo (ch, argument);
        return;
    }

    if ((obj = get_obj_wear(ch, arg)) == NULL)
    {
        char_act("   .", ch);
        return;
    }
    remove_obj(ch, obj->wear_loc, TRUE);
    return;
}

void do_sacrifice(CHAR_DATA * ch, const char *argument)
{
    char            arg[MAX_INPUT_LENGTH];
    OBJ_DATA       *obj;
    OBJ_DATA       *r_next_cont;

    if (!str_cmp(argument, "all") || !str_cmp(argument, ""))
    {
        char_act("    ӣ.", ch);
        for (obj = ch->in_room->contents; obj; obj = r_next_cont)
        {
            r_next_cont = obj->next_content;
            sac_obj_all(ch, obj);
        }
        return;
    }

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0'
        || !str_cmp(arg, ch->name))
    {
        act_puts("$n offers $gn{himself} to gods, who graciously declines.", ch, NULL, NULL, TO_ROOM, POS_RESTING);
        char_act("Gods appreciates your offer and may accept it later.", ch);
        return;
    }

    obj = get_obj_list(ch, arg, ch->in_room->contents);
    if (obj == NULL)
    {
        char_act("You can't find it.", ch);
        return;
    }

    sac_obj(ch, obj);
}

void sac_obj(CHAR_DATA * ch, OBJ_DATA *obj)
{
    int             silver;
    CHAR_DATA      *gch;
    int             members;
    bool            converted_to_gold;

    if ((obj->pIndexData->item_type == ITEM_CORPSE_PC && ch->level < (MAX_LEVEL-1))
    ||  (QUEST_OBJ_FIRST <= obj->pIndexData->vnum && obj->pIndexData->vnum <= QUEST_OBJ_LAST))
    {
        char_act("Gods wouldn't like that.", ch);
        return;
    }

    if (!CAN_WEAR(obj, ITEM_TAKE) || CAN_WEAR(obj, ITEM_WEAR_NOSAC)
                  || IS_SET(obj->extra_flags, ITEM_NOSAC))
    {
        if (!IS_NULLSTR (mlstr_val (obj->description, 0)))
            act_puts("$p is not an acceptable sacrifice.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        return;
    }
    silver = UMAX(1, number_fuzzy(obj->level / 10));

    if (obj->pIndexData->item_type != ITEM_CORPSE_NPC
        &&  obj->pIndexData->item_type != ITEM_CORPSE_PC)
        silver = UMIN(silver, obj->cost);

    if (silver == 1)
        char_act("         .", ch);
    else
        char_printf(ch, "    %d     .\n", silver);

    if (altar_works (ch, ALTAR_GREED_POS) &&
        (obj->pIndexData->item_type == ITEM_CORPSE_NPC))
    {
        char_act("Mystically your silver was converted into {Ygold{x!", ch);
        converted_to_gold = TRUE;
        silver = UMIN ((1 + silver/8), 2);
        ch->gold += silver;
    }
    else
    {
        converted_to_gold = FALSE;
        ch->silver += silver;
    }

    if (IS_SET(ch->plr_flags, PLR_AUTOSPLIT))
    {
        /* AUTOSPLIT code */
        members = 0;
        for (gch = ch->in_room->people; gch != NULL;
            gch = gch->next_in_room)
            if (is_same_group(gch, ch))
                members++;

        if (members > 1 && silver > 1)
        {
            if (converted_to_gold)
                doprintf(do_split, ch, "0 %d", silver);
            else
                doprintf(do_split, ch, "%d", silver);
        }
    }
    act("$n sacrifices $p to gods.", ch, obj, NULL, TO_ROOM);

    if (oprog_call(OPROG_SAC, obj, ch, NULL))
        return;

    wiznet("$N  $p   .",
           ch, obj, WIZ_SACCING, 0, 0);
    if (obj->pIndexData->item_type == ITEM_CORPSE_NPC
        ||  obj->pIndexData->item_type == ITEM_CORPSE_PC)
    {
        OBJ_DATA       *obj_content;
        OBJ_DATA       *obj_next;

        char            buf[MAX_STRING_LENGTH];
        char            buf2[MAX_STRING_LENGTH];
        OBJ_DATA       *two_objs[2];

        bool    fScatter = TRUE;
        int iScatter = 0;

        for (obj_content = obj->contains; obj_content;
            obj_content = obj_next)
        {
            obj_next = obj_content->next_content;
            two_objs[iScatter < 1 ? 0 : 1] = obj_content;
            obj_from_obj(obj_content);
            obj_to_room(obj_content, ch->in_room);
            iScatter++;
        }
        if (iScatter == 1)
        {
            act_puts("    $p.", ch, two_objs[0], NULL, TO_CHAR, POS_DEAD);
            act("$p    $n.", ch, two_objs[0], NULL, TO_ROOM);
        }
        if (iScatter == 2)
        {
            act_puts("    $p  $P.", ch, two_objs[0], two_objs[1], TO_CHAR, POS_DEAD);
            act("$p  $P    $n.", ch, two_objs[0], two_objs[1], TO_ROOM);
        }
        snprintf(buf, sizeof(buf), GETMSG("   ", ch->lang));
        snprintf(buf2, sizeof(buf2), GETMSG("  $n ", ch->lang));
        if (iScatter < 3)
            fScatter = FALSE;
        else if (iScatter < 5)
        {
            strnzcat(buf, sizeof(buf), GETMSG("   ", ch->lang));
            strnzcat(buf2, sizeof(buf2), GETMSG("   ", ch->lang));
        }
        else if (iScatter < 9)
        {
            strnzcat(buf, sizeof(buf), GETMSG("   ", ch->lang));
            strnzcat(buf2, sizeof(buf2), GETMSG("   ", ch->lang));
        }
        else if (iScatter < 15)
        {
            strnzcat(buf, sizeof(buf), GETMSG("   ", ch->lang));
            strnzcat(buf2, sizeof(buf2), GETMSG("   ", ch->lang));
        }
        else
        {
            strnzcat(buf, sizeof(buf), GETMSG("    ", ch->lang));
            strnzcat(buf2, sizeof(buf2), GETMSG("    ", ch->lang));
        }
        strnzcat(buf, sizeof(buf), GETMSG(", ", ch->lang));
        strnzcat(buf2, sizeof(buf2), GETMSG(", ", ch->lang));

        switch (ch->in_room->sector_type)
        {
        case SECT_FIELD:
        case SECT_FOREST:
            strnzcat(buf, sizeof(buf), GETMSG(" .", ch->lang));
            strnzcat(buf2, sizeof(buf2), GETMSG(" .", ch->lang));
            break;
        case SECT_WATER_SWIM:
            strnzcat(buf, sizeof(buf), GETMSG("  .", ch->lang));
            strnzcat(buf2, sizeof(buf2), GETMSG("  .", ch->lang));
            break;
        case SECT_WATER_NOSWIM:
            strnzcat(buf, sizeof(buf), GETMSG("  .", ch->lang));
            strnzcat(buf2, sizeof(buf2), GETMSG("  .", ch->lang));
            break;
        default:
            strnzcat(buf, sizeof(buf), GETMSG(" .", ch->lang));
            strnzcat(buf2, sizeof(buf2), GETMSG(" .", ch->lang));
            break;
        }
        if (fScatter)
        {
            act_puts(buf, ch, NULL, NULL, TO_CHAR, POS_DEAD);
            act(buf2, ch, NULL, NULL, TO_ROOM);
        }
    }
    extract_obj(obj);
}


void sac_obj_all(CHAR_DATA * ch, OBJ_DATA *obj)
{
    int             silver;
    CHAR_DATA      *gch;
    int             members;
    bool            converted_to_gold;

    if ((obj->pIndexData->item_type == ITEM_CORPSE_PC && ch->level < (MAX_LEVEL-1))
        ||  (QUEST_OBJ_FIRST <= obj->pIndexData->vnum &&
             obj->pIndexData->vnum <= QUEST_OBJ_LAST))
    {
        char_act("   .", ch);
        return;
    }

    if (!CAN_WEAR(obj, ITEM_TAKE) || CAN_WEAR(obj, ITEM_WEAR_NOSAC)
                  || IS_SET(obj->extra_flags, ITEM_NOSAC))
    {
        if (!IS_NULLSTR (mlstr_val (obj->description, 0)))
            act_puts("$p is not an acceptable sacrifice.", ch, obj, NULL, TO_CHAR, POS_DEAD);
        return;
    }
    silver = UMAX(1, number_fuzzy(obj->level / 10));

    if (obj->pIndexData->item_type != ITEM_CORPSE_NPC
        &&  obj->pIndexData->item_type != ITEM_CORPSE_PC)
        silver = UMIN(silver, obj->cost);
/*
    if (silver == 1)
        char_act("         .", ch);
    else
        char_printf(ch, "    %d     .\n", silver);
*/

    if (altar_works (ch, ALTAR_GREED_POS) &&
        (obj->pIndexData->item_type == ITEM_CORPSE_NPC))
    {
        converted_to_gold = TRUE;
        silver = UMIN ((1 + silver/8), 2);
        ch->gold += silver;
    }
    else
    {
        converted_to_gold = FALSE;
        ch->silver += silver;
    }

    if (IS_SET(ch->plr_flags, PLR_AUTOSPLIT))
    {
        /* AUTOSPLIT code */
        members = 0;
        for (gch = ch->in_room->people; gch != NULL;
            gch = gch->next_in_room)
            if (is_same_group(gch, ch))
                members++;

        if (members > 1 && silver > 1)
        {
            if (converted_to_gold)
                doprintf(do_split, ch, "0 %d", silver);
            else
                doprintf(do_split, ch, "%d", silver);
        }
    }
//    act("$n sacrifices $p to gods.", ch, obj, NULL, TO_ROOM);

    if (oprog_call(OPROG_SAC, obj, ch, NULL))
        return;

//    wiznet("$N  $p   .", ch, obj, WIZ_SACCING, 0, 0);
    if (obj->pIndexData->item_type == ITEM_CORPSE_NPC
        ||  obj->pIndexData->item_type == ITEM_CORPSE_PC)
    {
        OBJ_DATA       *obj_content;
        OBJ_DATA       *obj_next;

        char            buf[MAX_STRING_LENGTH];
        char            buf2[MAX_STRING_LENGTH];
        OBJ_DATA       *two_objs[2];

        bool    fScatter = TRUE;
        int iScatter = 0;

        for (obj_content = obj->contains; obj_content;
            obj_content = obj_next)
        {
            obj_next = obj_content->next_content;
            two_objs[iScatter < 1 ? 0 : 1] = obj_content;
            obj_from_obj(obj_content);
            obj_to_room(obj_content, ch->in_room);
            iScatter++;
        }
        if (iScatter == 1)
        {
            act_puts("    $p.", ch, two_objs[0], NULL, TO_CHAR, POS_DEAD);
            act("$p    $n.", ch, two_objs[0], NULL, TO_ROOM);
        }
        if (iScatter == 2)
        {
            act_puts("    $p  $P.", ch, two_objs[0], two_objs[1], TO_CHAR, POS_DEAD);
            act("$p  $P    $n.", ch, two_objs[0], two_objs[1], TO_ROOM);
        }
        snprintf(buf, sizeof(buf), GETMSG("   ", ch->lang));
        snprintf(buf2, sizeof(buf2), GETMSG("  $n ", ch->lang));
        if (iScatter < 3)
            fScatter = FALSE;
        else if (iScatter < 5)
        {
            strnzcat(buf, sizeof(buf), GETMSG("   ", ch->lang));
            strnzcat(buf2, sizeof(buf2), GETMSG("   ", ch->lang));
        }
        else if (iScatter < 9)
        {
            strnzcat(buf, sizeof(buf), GETMSG("   ", ch->lang));
            strnzcat(buf2, sizeof(buf2), GETMSG("   ", ch->lang));
        }
        else if (iScatter < 15)
        {
            strnzcat(buf, sizeof(buf), GETMSG("   ", ch->lang));
            strnzcat(buf2, sizeof(buf2), GETMSG("   ", ch->lang));
        }
        else
        {
            strnzcat(buf, sizeof(buf), GETMSG("    ", ch->lang));
            strnzcat(buf2, sizeof(buf2), GETMSG("    ", ch->lang));
        }
        strnzcat(buf, sizeof(buf), GETMSG(", ", ch->lang));
        strnzcat(buf2, sizeof(buf2), GETMSG(", ", ch->lang));

        switch (ch->in_room->sector_type)
        {
        case SECT_FIELD:
        case SECT_FOREST:
            strnzcat(buf, sizeof(buf), GETMSG(" .", ch->lang));
            strnzcat(buf2, sizeof(buf2), GETMSG(" .", ch->lang));
            break;
        case SECT_WATER_SWIM:
            strnzcat(buf, sizeof(buf), GETMSG("  .", ch->lang));
            strnzcat(buf2, sizeof(buf2), GETMSG("  .", ch->lang));
            break;
        case SECT_WATER_NOSWIM:
            strnzcat(buf, sizeof(buf), GETMSG("  .", ch->lang));
            strnzcat(buf2, sizeof(buf2), GETMSG("  .", ch->lang));
            break;
        default:
            strnzcat(buf, sizeof(buf), GETMSG(" .", ch->lang));
            strnzcat(buf2, sizeof(buf2), GETMSG(" .", ch->lang));
            break;
        }
        if (fScatter)
        {
            act_puts(buf, ch, NULL, NULL, TO_CHAR, POS_DEAD);
            act(buf2, ch, NULL, NULL, TO_ROOM);
        }
    }
    extract_obj(obj);
}

void quaff_obj(CHAR_DATA *ch, OBJ_DATA *obj)
{
    act("$n  $p.", ch, obj, NULL, TO_ROOM);
    act_puts("  $p.", ch, obj, NULL, TO_CHAR, POS_DEAD);
    if (!IS_UNDEAD(ch))
    {
        obj_cast_spell(obj->value[1], obj->value[0], ch, ch, NULL);
        obj_cast_spell(obj->value[2], obj->value[0], ch, ch, NULL);
        obj_cast_spell(obj->value[3], obj->value[0], ch, ch, NULL);
        obj_cast_spell(obj->value[4], obj->value[0], ch, ch, NULL);
    }
    if (IS_PUMPED(ch) || ch->fighting != NULL)
        WAIT_STATE(ch, 2 * PULSE_VIOLENCE);

    extract_obj(obj);
    obj_to_char(create_obj(get_obj_index(OBJ_VNUM_POTION_VIAL), 0), ch);
}

void do_quaff(CHAR_DATA * ch, const char *argument)
{
    char            arg[MAX_INPUT_LENGTH];
    OBJ_DATA       *obj;
    clan_t   *clan;
    one_argument(argument, arg, sizeof(arg));


    clan = CLAN(ch->clan);
    if (IS_SET(clan->flags, CLAN_HATE_MAGIC))
    {
        char_act("     !", ch);
        return;
    }

    affect_bit_strip(ch, TO_AFFECTS, AFF_SPELLBANE);
    if (arg[0] == '\0')
    {
        char_act(" (quaff) ?", ch);
        return;
    }

    if ((obj = get_obj_carry(ch, arg)) == NULL)
    {
        char_act("    .", ch);
        return;
    }

    if (obj->pIndexData->item_type != ITEM_POTION)
    {
        char_act("   (quaff)     .", ch);
        return;
    }

    if (ch->level < obj->level)
    {
        char_act("     .", ch);
        return;
    }
    quaff_obj(ch, obj);
}

void do_recite(CHAR_DATA * ch, const char *argument)
{
    char            arg1[MAX_INPUT_LENGTH];
    char            arg2[MAX_INPUT_LENGTH];
    CHAR_DATA      *victim;
    CHAR_DATA      *gch;
    clan_t         *clan;
    OBJ_DATA       *scroll;
    OBJ_DATA       *obj;
    int             sn, level, clevel;

    clan = CLAN(ch->clan);
    if (IS_SET(clan->flags, CLAN_HATE_MAGIC))
    {
        char_act(" ?   ,   !", ch);
        return;
    }

    affect_bit_strip(ch, TO_AFFECTS, AFF_SPELLBANE);
    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));

    if ((scroll = get_obj_carry(ch, arg1)) == NULL)
    {
        char_act("    .", ch);
        return;
    }

    if (scroll->pIndexData->item_type != ITEM_SCROLL)
    {
        char_act("   (recite)  .", ch);
        return;
    }

    if (ch->level < scroll->level
    || (sn = sn_lookup("scrolls")) < 0)
    {
        char_act(",    ,  .", ch);
        return;
    }

    if (room_is_dark(ch) && !IS_OBJ_STAT (scroll, ITEM_GLOW))
    {
        act_puts("  ,   ,    $p.\n",
            ch, scroll, NULL, TO_CHAR, POS_DEAD);
        return;
    }

    obj = NULL;
    if (arg2[0] == '\0')
        victim = ch;
    else if ((victim = get_char_room(ch, arg2)) == NULL
    && (obj = get_obj_here(ch, arg2)) == NULL)
    {
        char_act("    .", ch);
        return;
    }

    if (IS_AFFECTED(ch, AFF_CHARM)
    && (is_safe(ch->master, victim)))
        return;
    act("$n  $p.", ch, scroll, NULL, TO_ROOM);
    act_puts("  $p.", ch, scroll, NULL, TO_CHAR, POS_DEAD);

    if (number_percent() >= get_skill(ch, sn) * 4 / 5)
    {
        char_act("You mispronounce a syllable.", ch);
        check_improve(ch, sn, FALSE, 2);
    } else
    {
        level = scroll->value[0];
        clevel = 0;
        for (gch = char_list; gch != NULL; gch = gch->next)
        {
            if (is_same_group(gch, ch)
            && IS_AFFECTED(gch, AFF_CHARM)
            && (gch->master == ch))
            {
                if (IS_NPC(gch)
                && (gch->pIndexData->vnum == MOB_VNUM_LESSER_GOLEM
                || gch->pIndexData->vnum == MOB_VNUM_STONE_GOLEM
                || gch->pIndexData->vnum == MOB_VNUM_IRON_GOLEM
                || gch->pIndexData->vnum == MOB_VNUM_ADAMANTITE_GOLEM
                || gch->pIndexData->vnum == MOB_VNUM_DIAMOND_GOLEM))
                    continue;
            clevel++;
            }
        }
        level -= number_range(clevel / 2, clevel * 2);
        level = UMAX(1, level);

        obj_cast_spell(scroll->value[1], level, ch, victim, obj);
        obj_cast_spell(scroll->value[2], level, ch, victim, obj);
        obj_cast_spell(scroll->value[3], level, ch, victim, obj);
        obj_cast_spell(scroll->value[4], level, ch, victim, obj);
        check_improve(ch, sn, TRUE, 2);

        if (IS_PUMPED(ch) || ch->fighting != NULL)
            WAIT_STATE(ch, 2 * PULSE_VIOLENCE);
    }

    extract_obj(scroll);
}

void do_brandish(CHAR_DATA * ch, const char *argument)
{
    CHAR_DATA      *vch;
    CHAR_DATA      *gch;
    CHAR_DATA      *vch_next;
    clan_t         *clan;
    OBJ_DATA       *staff;
    int             sn, level, clevel;
    skill_t        *sk;

    clan = CLAN(ch->clan);
    if (IS_SET(clan->flags, CLAN_HATE_MAGIC))
    {
        char_act("?    ?       !", ch);
        return;
    }

    affect_bit_strip(ch, TO_AFFECTS, AFF_SPELLBANE);

    if ((staff = get_eq_char(ch, WEAR_HOLD)) == NULL)
    {
        char_act("     .", ch);
        return;
    }

    if (staff->pIndexData->item_type != ITEM_STAFF)
    {
        char_act("   .", ch);
        return;
    }

    if ((sk = skill_lookup(staff->value[3])) == NULL
    || sk->spell_fun == NULL
    || (sn = sn_lookup("staves")) < 0)
        return;

    WAIT_STATE(ch, 2 * PULSE_VIOLENCE);

    if (staff->value[2] <= 0
    && staff->pIndexData->vnum == OBJ_VNUM_STAFF_EMPOWERED)
    {
        act("  $p    .", ch, staff, NULL, TO_CHAR);
        do_help(ch, "'EMPOWER'");
        return;
    }

    if (IS_AFFECTED(ch, AFF_CHARM))
        return;
    if (staff->value[2] > 0)
    {
        act("$n  $p  .", ch, staff, NULL, TO_ROOM);
        act("  $p  .", ch, staff, NULL, TO_CHAR);
        if (ch->level + 3 < staff->level
        || number_percent() >= 10 + get_skill(ch, sn) * 4 / 5)
        {
            act("    $p  .", ch, staff,
                NULL, TO_CHAR);
            act("...   .", ch, NULL, NULL, TO_ROOM);
            check_improve(ch, sn, FALSE, 2);
        }
        else
        {
            skill_t *spell = skill_lookup(staff->value[3]);

            if (!spell)
                return;

            for (vch = ch->in_room->people; vch; vch = vch_next)
            {
                vch_next = vch->next_in_room;

                switch (sk->target)
                {
                default:
                    return;

                case TAR_IGNORE:
                    if (vch != ch)
                        continue;
                    break;

                case TAR_CHAR_OFFENSIVE:
                    if (IS_NPC(ch) ? IS_NPC(vch) : !IS_NPC(vch))
                        continue;
                    break;

                case TAR_CHAR_DEFENSIVE:
                    if (IS_NPC(ch) ? !IS_NPC(vch) : IS_NPC(vch))
                        continue;
                    break;

                case TAR_CHAR_SELF:
                    if (vch != ch)
                        continue;
                    break;
                }

                if (is_safe(ch, vch))
                    continue;

                level = staff->value[0];
                clevel = 0;
                for (gch = char_list; gch != NULL; gch = gch->next)
                {
                    if (is_same_group(gch, ch)
                    && IS_AFFECTED(gch, AFF_CHARM)
                    && (gch->master == ch))
                    {
                        if (IS_NPC(gch)
                        && (gch->pIndexData->vnum == MOB_VNUM_LESSER_GOLEM
                        || gch->pIndexData->vnum == MOB_VNUM_STONE_GOLEM
                        || gch->pIndexData->vnum == MOB_VNUM_IRON_GOLEM
                        || gch->pIndexData->vnum == MOB_VNUM_ADAMANTITE_GOLEM
                        || gch->pIndexData->vnum == MOB_VNUM_DIAMOND_GOLEM))
                            continue;
                    clevel++;
                    }
                }
                level -= number_range(clevel / 2, clevel * 2);
                level = UMAX(1, level);

                obj_cast_spell(staff->value[3], level, ch, vch, NULL);
                if (IS_SET(spell->flags, SKILL_AREA_ATTACK))
                    break;
            }
            check_improve(ch, sn, TRUE, 2);
        }
    }

    if (--staff->value[2] <= 0
    && staff->pIndexData->vnum != OBJ_VNUM_STAFF_EMPOWERED)
    {
        act("$p $n   .", ch, staff, NULL, TO_ROOM);
        act(" $p   .", ch, staff, NULL, TO_CHAR);
        extract_obj(staff);
    }
}

void do_zap(CHAR_DATA * ch, const char *argument)
{
    char            arg[MAX_INPUT_LENGTH];
    CHAR_DATA      *victim;
    CHAR_DATA      *gch;
    OBJ_DATA       *wand;
    OBJ_DATA       *obj;
    clan_t         *clan;
    int             sn, level, clevel;

    clan = CLAN(ch->clan);
    if (IS_SET(clan->flags, CLAN_HATE_MAGIC))
    {
        char_act("  ,    !", ch);
        return;
    }

    affect_bit_strip(ch, TO_AFFECTS, AFF_SPELLBANE);

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0' && ch->fighting == NULL)
    {
        char_act("   ?", ch);
        return;
    }
    if ((wand = get_eq_char(ch, WEAR_HOLD)) == NULL)
    {
        char_act("      .", ch);
        return;
    }
    if (wand->pIndexData->item_type != ITEM_WAND)
    {
        char_act("   (zap)   .", ch);
        return;
    }

    if ((sn = sn_lookup("wands")) < 0)
        return;

    obj = NULL;
    if (arg[0] == '\0')
    {
        if (ch->fighting != NULL)
        {
            victim = ch->fighting;
        } else
        {
            char_act(" (zap)     ?", ch);
            return;
        }
    }
    else
    {
        if ((victim = get_char_room(ch, arg)) == NULL
        && (obj = get_obj_here(ch, arg)) == NULL)
        {
            char_act("  .", ch);
            return;
        }
    }

    if (IS_AFFECTED(ch, AFF_CHARM) && victim && ch->master
    && is_safe(ch->master, victim))
    {
        char_act(" ?", ch);
        return;
    }

    if (victim && is_safe(ch, victim))
        return;

    WAIT_STATE(ch, 2 * PULSE_VIOLENCE);

    if (wand->value[2] <= 0
    && wand->pIndexData->vnum == OBJ_VNUM_WAND_EMPOWERED)
    {
        act("  $p    .", ch, wand, NULL, TO_CHAR);
        do_help(ch, "'EMPOWER'");
        return;
    }

    if (wand->value[2] > 0)
    {
        if (victim != NULL)
        {
            if (ch != victim)
            {
                act("$n   $N  $p.", ch, wand,
                    victim, TO_ROOM);
                act("   $N  $p.", ch, wand, victim,
                    TO_CHAR);
            } else
            {
                act("$n   $p.", ch, wand, NULL, TO_ROOM);
                act("   $p.", ch, wand, NULL, TO_CHAR);
            }
        } else
        {
            act("$n  $P  $p.", ch, wand, obj, TO_ROOM);
            act("  $P  $p.", ch, wand, obj, TO_CHAR);
        }

        if (ch->level + 5 < wand->level
        || number_percent() >= 20 + get_skill(ch, sn) * 4 / 5)
        {
            act("   $p    .",
                ch, wand, NULL, TO_CHAR);
            act("  $n  $p    .",
                ch, wand, NULL, TO_ROOM);
            check_improve(ch, sn, FALSE, 2);
        } else
        {
            level = wand->value[0];
            clevel = 0;
            for (gch = char_list; gch != NULL; gch = gch->next)
            {
                if (is_same_group(gch, ch)
                && IS_AFFECTED(gch, AFF_CHARM)
                && (gch->master == ch))
                {
                    if (IS_NPC(gch)
                    && (gch->pIndexData->vnum == MOB_VNUM_LESSER_GOLEM
                    || gch->pIndexData->vnum == MOB_VNUM_STONE_GOLEM
                    || gch->pIndexData->vnum == MOB_VNUM_IRON_GOLEM
                    || gch->pIndexData->vnum == MOB_VNUM_ADAMANTITE_GOLEM
                    || gch->pIndexData->vnum == MOB_VNUM_DIAMOND_GOLEM))
                        continue;
                clevel++;
                }
            }
            level -= number_range(clevel / 2, clevel * 2);
            level = UMAX(1, level);

            obj_cast_spell(wand->value[3], level, ch, victim, obj);
            check_improve(ch, sn, TRUE, 2);
        }
    }
    if (--wand->value[2] <= 0
    && wand->pIndexData->vnum != OBJ_VNUM_WAND_EMPOWERED)
    {
        act("$p $n   .", ch, wand, NULL, TO_ROOM);
        act(" $p     .", ch, wand, NULL, TO_CHAR);
        extract_obj(wand);
    }
}

void do_steal(CHAR_DATA * ch, const char *argument)
{
    char            arg1[MAX_INPUT_LENGTH];
    char            arg2[MAX_INPUT_LENGTH];
    CHAR_DATA      *victim;
    OBJ_DATA       *obj;
    OBJ_DATA       *obj_inve;
    int             percent;
    int             sn;
    int             wear_loc;
    char*           appearance_social;
    social_t *soc = NULL;

    bool bool1, bool2, bool3; // hz why, but it is needed

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));

    sn = sn_lookup("steal");
    if ((percent = get_skill(ch, sn)) == 0)
    {
        char_act("?      ,   !", ch);
        return;
    }

    if (arg1[0] == '\0' || arg2[0] == '\0')
    {
        char_act("    ?", ch);
        return;
    }

    if (IS_NPC(ch) && IS_SET(ch->affected_by, AFF_CHARM)
    && (ch->master != NULL))
    {
        char_act("  ,  .", ch);
        return;
    }

    if ((sn = sn_lookup("steal")) < 0)
        return;

    WAIT_STATE(ch, SKILL(sn)->beats);

    if (is_affected(ch, gsn_polymorph))
    {
        char_act("      !", ch);
        return ;
    }

    if ((victim = get_char_room(ch, arg2)) == NULL)
    {
        char_act("  .", ch);
        return;
    }
    if (victim == ch)
    {
        char_act(" .", ch);
        return;
    }

    if (ch->position == POS_FIGHTING)
    {
        char_act("   -   .", ch);
        return;
    }

    if (victim->in_war && victim->war_status == PS_ALIVE)
    {
        char_act("You can't steal during the war - consequences will be fatal.", ch);
        return;
    }

    if (IS_NPC (victim) && IS_SET (victim->pIndexData->act, ACT_CLAN_GUARD))
    {
        act_yell(victim, "     , $i!", ch, NULL);
        multi_hit (victim, ch, TYPE_UNDEFINED);
        return;
    }

    if (is_safe(ch, victim))
        return;

    // TODO: Aseroth -- add associative table for named wear_locs
    appearance_social = "";
    wear_loc = WEAR_NONE;
    if (!str_cmp(arg1, "neck"))
    {
        wear_loc = WEAR_NECK_1;
        appearance_social = "hug";
    }
    else if (!str_cmp(arg1, "wrist_left"))
    {
        wear_loc = WEAR_WRIST_L;
        appearance_social = "shake";
    }
    else if (!str_cmp(arg1, "wrist_right"))
    {
        wear_loc = WEAR_WRIST_R;
        appearance_social = "shake";
    }
    else if (!str_cmp(arg1, "finger_left"))
    {
        wear_loc = WEAR_FINGER_L;
        appearance_social = "shake";
    }
    else if (!str_cmp(arg1, "finger_right"))
    {
        wear_loc = WEAR_FINGER_R;
        appearance_social = "shake";
    }
    else if (!str_cmp(arg1, "hold"))
    {
        wear_loc = WEAR_HOLD;
        appearance_social = "shake";
    }

    if (wear_loc != WEAR_NONE)
        if ((soc = social_lookup(appearance_social, str_prefix)) == NULL)
        {
            bug("do_steal: invalid social: <wear_loc> %d", wear_loc);
        }

    // move this to more convenient position, iffya want
    if (soc)
    {
        interpret_social(soc, ch, arg2);
    }

    percent = ((number_percent() / 2) - (get_curr_stat(ch, STAT_LCK) * 2) +
              (IS_AWAKE(victim) ? 10 : -20) +
              (can_see(victim, ch) ? 5 : -10) +
              (get_curr_stat(victim, STAT_LCK) * 2)); 
    percent += LVL(victim)-LVL(ch);

    if (victim->position == POS_FIGHTING) percent *= 2;

    if ((!IS_NPC(ch) && percent > get_skill(ch, sn))
    || IS_SET(victim->immunes, IMM_IRON)
            // (Kemm) WTF? What does this mean???
            // (sg)   it's is a synonym to 'immune steal', I believe
            //        look tables.c
    || IS_IMMORTAL(victim)
    || (victim->in_room
    && IS_SET(victim->in_room->room_flags, ROOM_BATTLE_ARENA)))
    {
        /*
         * Failure.
         */

        char_act("!", ch);

        if (IS_AFFECTED(ch, AFF_HIDE | AFF_FADE | AFF_TRAP) && !IS_NPC(ch))
        {
            REMOVE_BIT(ch->affected_by, AFF_HIDE | AFF_FADE | AFF_TRAP);
            char_act("You step out of shadows.", ch);
            act_puts("$n steps out of shadows.", ch, NULL, NULL, TO_ROOM, POS_RESTING);
        }

        if (!IS_AFFECTED(victim, AFF_SLEEP))
        {
            victim->position = victim->position == POS_SLEEPING ? POS_STANDING :
                               victim->position;
            act("$n   !\n", ch, NULL, victim, TO_VICT);
        }
        act("$n   $N.\n", ch, NULL, victim, TO_NOTVICT);

        if (IS_AWAKE(victim))
            switch (number_range(0, 3))
            {
            case 0:
                act_yell(victim, "$i -!", ch, NULL);
                break;
            case 1:
                act_yell(victim, "$i      !", ch, NULL);
                break;
            case 2:
                act_yell(victim, "$i   !", ch, NULL);
                break;
            case 3:
                act_yell(victim, "     , $i!", ch, NULL);
                break;
            }

        if (!IS_NPC(ch) && IS_NPC(victim))
        {
            check_improve(ch, sn, FALSE, 2);
            multi_hit(victim, ch, TYPE_UNDEFINED);
        }
        return;
    }

    if (!str_cmp(arg1, "coin")
    || !str_cmp(arg1, "coins")
    || !str_cmp(arg1, "silver")
    || !str_cmp(arg1, "gold"))
    {
        int             amount_s = 0;
        int             amount_g = 0;
        if (!str_cmp(arg1, "silver")
        || !str_cmp(arg1, "coin")
        || !str_cmp(arg1, "coins"))
            amount_s = victim->silver * number_range(1, 20) / 100;
        else if (!str_cmp(arg1, "gold"))
            amount_g = victim->gold * number_range(1, 7) / 100;

        if (amount_s <= 0 && amount_g <= 0)
        {
            char_act("You couldn't get any coins.\n", ch);
            return;
        }

        if (ch->carry_weight + amount_s > can_carry_w(ch)
        || ch->carry_weight + amount_g*100 > can_carry_w(ch))
        {
            char_act("You can't carry that much weight.\n", ch);
            return;
        }

        ch->gold += amount_g;
        victim->gold -= amount_g;
        ch->silver += amount_s;
        victim->silver -= amount_s;
        char_printf(ch, "Bingo!  You got %d %s coins.\n",
                    amount_s != 0 ? amount_s : amount_g,
                    amount_s != 0 ? "silver" : "gold");
        check_improve(ch, sn, TRUE, 2);
        stat_record.gold_stolen += amount_g;
        return;
    }

    if (wear_loc == WEAR_NONE)
    {
        for (obj = victim->carrying; obj; obj = obj->next_content)
            if (obj->wear_loc == WEAR_NONE
            && can_see_obj(ch, obj)
            && is_name(arg1, obj->name))
                break;
    } else
    {
        obj = get_eq_char(victim, wear_loc);
    }

    if (obj == NULL)
    {
        char_act("You can't find it.\n", ch);
        return;
    }

    bool1 = !can_drop_obj(ch, obj);
    bool2 = (IS_OBJ_STAT(obj, ITEM_NOREMOVE) && (wear_loc != WEAR_NONE));
    bool3 = (IS_OBJ_STAT(obj, ITEM_NODROP));
    if ((bool2 || bool3) && bool1)
    {
        char_act("You can't pry it away.\n", ch);
        return;
    }
    if (ch->carry_number + get_obj_number(obj) > can_carry_n(ch))
    {
        char_act("You have your hands full.\n", ch);
        return;
    }
    if (ch->carry_weight + get_obj_weight(obj) > can_carry_w(ch))
    {
        char_act("You can't carry that much weight.\n", ch);
        return;
    }
    if (IS_SET(obj->extra_flags, ITEM_INVENTORY)
    && !IS_NPC(victim))
    {
        char_act("You can't steal that.\n", ch);
        return;
    }
    if (wear_loc != WEAR_NONE && obj->pIndexData->limit != -1 && !IS_NPC(victim))
    {
        char_act("You can't pry it away.\n", ch);
        return;
    }
    if (!can_see_obj(ch, obj))
    {
        char_act("There nothing like this!\n", ch);
        return;
    }
    if (!IS_SET(obj->extra_flags, ITEM_INVENTORY))
    {
        obj_from_char(obj);
        obj_to_char(obj, ch);
        act("You steal $p!", ch, obj, NULL, TO_CHAR);
        check_improve(ch, sn, TRUE, 2);
    } 
    else if (wear_loc == WEAR_NONE) // we'll not mess with inv-items and \w/ steal
    {
        obj_inve = NULL;
        obj_inve = create_obj(obj->pIndexData, 0);
        clone_obj(obj, obj_inve);
        REMOVE_BIT(obj_inve->extra_flags, ITEM_INVENTORY);
        obj_to_char(obj_inve, ch);
        act("You steal $p!", ch, obj, NULL, TO_CHAR);
        check_improve(ch, sn, TRUE, 1);
    }
    oprog_call(OPROG_GET, obj, ch, NULL);
}

/*
 * Shopping commands.
 */
CHAR_DATA * find_keeper(CHAR_DATA * ch)
{
    CHAR_DATA      *keeper;
    SHOP_DATA      *pShop = NULL;

    for (keeper = ch->in_room->people; keeper; keeper = keeper->next_in_room)
    {
        if (IS_NPC(keeper)
            &&  (pShop = keeper->pIndexData->pShop) != NULL)
            break;
    }

    if (pShop == NULL)
    {
        char_act("     .", ch);
        return NULL;
    }

    if (IS_SET(keeper->in_room->area->flags, AREA_HOMETOWN)
        &&  !IS_NPC(ch)
        &&  IS_SET(ch->plr_flags, PLR_WANTED))
    {
        do_say(keeper, "  !");
        act_yell(keeper, "$i !  !\n", ch, NULL);
        agent_net_printf(keeper, ch, ANET_WANTED_FOUND);
        return NULL;
    }

    /*
     * Shop hours.
     */
    if (time_info.hour < pShop->open_hour)
    {
        do_say(keeper, ",   .  .");
        return NULL;
    }
    if (time_info.hour > pShop->close_hour)
    {
        do_say(keeper, ",   .  .");
        return NULL;
    }
    /*
     * Invisible or hidden people.
     */
    if (!can_see(keeper, ch) && !IS_IMMORTAL(ch))
    {
        do_say(keeper, "    .");
        do_scan(keeper, str_empty);
        return NULL;
    }
    return keeper;
}

/* insert an object at the right spot for the keeper */
void obj_to_keeper(OBJ_DATA * obj, CHAR_DATA * ch)
{
    OBJ_DATA       *t_obj, *t_obj_next;
    /* see if any duplicates are found */
    for (t_obj = ch->carrying; t_obj != NULL; t_obj = t_obj_next)
    {
        t_obj_next = t_obj->next_content;

        if (obj->pIndexData == t_obj->pIndexData
            && !mlstr_cmp(obj->short_descr, t_obj->short_descr))
        {
            if (IS_OBJ_STAT(t_obj, ITEM_INVENTORY))
            {
                extract_obj(obj);
                return;
            }
            obj->cost = t_obj->cost;    /* keep it standard */
            break;
        }
    }

    if (t_obj == NULL)
    {
        obj->next_content = ch->carrying;
        ch->carrying = obj;
    }
    else
    {
        obj->next_content = t_obj->next_content;
        t_obj->next_content = obj;
    }

    obj->carried_by = ch;
    obj->in_room = NULL;
    obj->in_obj = NULL;
    ch->carry_number += get_obj_number(obj);
    ch->carry_weight += get_obj_weight(obj);
}

/* get an object from a shopkeeper's list */
OBJ_DATA * get_obj_keeper(CHAR_DATA * ch, CHAR_DATA * keeper, const char *argument)
{
    char            arg[MAX_INPUT_LENGTH];
    OBJ_DATA       *obj;
    int             number;
    int             count = 0;

    if (is_number(argument))
    {
        number = atoi(argument);
        if (number < 1)
            return NULL;
        for (obj = keeper->carrying; obj != NULL; obj = obj->next_content)
        {
            if (obj->wear_loc == WEAR_NONE
                && can_see_obj(keeper, obj)
                && can_see_obj(ch, obj))
            {
                if (++count == number)
                    return obj;
            }
            /* skip other objects of the same name */
            while (obj->next_content != NULL
                   && obj->pIndexData == obj->next_content->pIndexData
                   && !mlstr_cmp(obj->short_descr, obj->next_content->short_descr))
                obj = obj->next_content;
        }
        return NULL;
    }

    number = number_argument(argument, arg, sizeof(arg));
    for (obj = keeper->carrying; obj != NULL; obj = obj->next_content)
    {
        if (obj->wear_loc == WEAR_NONE
            && can_see_obj(keeper, obj)
            && can_see_obj(ch, obj)
            && is_name(arg, obj->name))
        {
            if (++count == number)
                return obj;

            /* skip other objects of the same name */
            while (obj->next_content != NULL
                   && obj->pIndexData == obj->next_content->pIndexData
                   && !mlstr_cmp(obj->short_descr, obj->next_content->short_descr))
                obj = obj->next_content;
        }
    }

    return NULL;
}

uint get_cost(CHAR_DATA * keeper, OBJ_DATA * obj, bool fBuy)
{
    SHOP_DATA * pShop;
    uint        cost;

    if (obj == NULL || (pShop = keeper->pIndexData->pShop) == NULL)
        return 0;

    if (IS_OBJ_STAT(obj, ITEM_NOSELL))
        return 0;

    if (fBuy)
        cost = obj->cost * pShop->profit_buy / 100;
    else
    {
        //OBJ_DATA       *obj2;
        int             itype;
        cost = 0;
        for (itype = 0; itype < MAX_TRADE; itype++)
        {
            if (obj->pIndexData->item_type == pShop->buy_type[itype])
            {
                cost = obj->cost * pShop->profit_sell / 100;
                break;
            }
        }

    /*    if (!IS_OBJ_STAT(obj, ITEM_SELL_EXTRACT))
            for (obj2 = keeper->carrying; obj2; obj2 = obj2->next_content)
            {
                if (obj->pIndexData == obj2->pIndexData
                    &&  !mlstr_cmp(obj->short_descr, obj2->short_descr))
                    extract_obj(obj2); */
//                    SET_BIT(obj->extra_flags, ITEM_INVENTORY);
//                    return 0;
/*
            if (IS_OBJ_STAT(obj2,ITEM_INVENTORY))
                cost /= 2;
            else
                        cost = cost * 3 / 4;
*/
/*            }*/
    }

    if (obj->pIndexData->item_type == ITEM_STAFF
    || obj->pIndexData->item_type == ITEM_WAND)
    {
        if (obj->value[1] == 0)
            cost /= 4;
        else
            cost = cost * obj->value[2] / obj->value[1];
    }
    return cost;
}

void do_buy_pet(CHAR_DATA * ch, const char *argument)
{
    uint        cost, roll;
    char            arg[MAX_INPUT_LENGTH];
    CHAR_DATA   *pet = NULL;
    flag64_t      act;
    ROOM_INDEX_DATA *pRoomIndexNext;
    ROOM_INDEX_DATA *in_room;

    if (IS_NPC(ch))
        return;

    argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        char_act(" ?", ch);
        return;
    }

    pRoomIndexNext = get_room_index(ch->in_room->vnum + 1);
    if (pRoomIndexNext == NULL)
    {
        bug("Do_buy: bad pet shop at vnum %d.", ch->in_room->vnum);
        char_act(",       .", ch);
        return;
    }

    if (is_number(arg))
    {
        int number = atoi(arg);
        int count = 0;
        if (number > 0)
        {
            for (pet = pRoomIndexNext->people; pet; pet = pet->next_in_room)
            {
                if (!IS_NPC(pet))
                    continue;
                if (!IS_SET(pet->pIndexData->act, ACT_PET))
                    continue;
                if (++count == number)
                    break;
            }
        }
    }
    else
    {
        in_room = ch->in_room;
        ch->in_room = pRoomIndexNext;
        pet = get_char_room(ch, arg);
        ch->in_room = in_room;
    }

    if (!pet
        ||  !IS_NPC(pet)
        ||  !IS_SET(act = pet->pIndexData->act, ACT_PET))
    {
        char_act(",       .", ch);
        return;
    }


    if (IS_SET(act, ACT_RIDEABLE))
    {

        if (MOUNTED(ch))
        {
            ch->mount->mount = NULL;
            ch->mount        = NULL;
            do_dismount(ch, str_empty);
        }

        cost = 10 * pet->level;

        if ((ch->silver + 100 * ch->gold) < cost)
        {
            char_act("You can't afford it.", ch);
            return;
        }
        if ((ch->level <= pet->level) || (get_skill(ch, gsn_riding) < 2))
        {
            char_act("    ,    .", ch);
            return;
        }
        deduct_cost(ch, cost);
        pet = create_mob(pet->pIndexData);
        pet->comm = COMM_NOTELL | COMM_NOCHANNELS;

        char_to_room(pet, ch->in_room);
        if (JUST_KILLED(pet))
            return;

        do_mount(ch, pet->name);
        char_act("Enjoy your mount.", ch);
        act("$n bought $N as a mount.", ch, NULL, pet, TO_ROOM);
        return;
    }
    if (ch->pet != NULL)
    {
        char_act("    .", ch);
        return;
    }
    cost = 10 * pet->level;

    if ((ch->silver + 100 * ch->gold) < cost)
    {
        char_act("    .", ch);
        return;
    }
    if (ch->level < pet->level)
    {
        char_act("   ,    .", ch);
        return;
    }
    /* haggle */
    roll = number_percent();
    if (roll < get_skill(ch, gsn_haggle))
    {
        cost -= cost / 2 * roll / 100;
        char_printf(ch, " ,    %d coins.\n",
                    cost);
        check_improve(ch, gsn_haggle, TRUE, 4);
    }
    deduct_cost(ch, cost);
    pet = create_mob(pet->pIndexData);
    SET_BIT(pet->affected_by, AFF_CHARM);
    pet->comm = COMM_NOTELL | COMM_NOCHANNELS;

    argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] != '\0')
        pet->name = str_printf(pet->pIndexData->name, arg);
    pet->description = mlstr_printf(pet->pIndexData->description, ch->name);

    char_to_room(pet, ch->in_room);
    if (JUST_KILLED(pet))
        return;
    add_follower(pet, ch);
    pet->leader = ch;
    ch->pet = pet;
    char_act("  .", ch);
    act("$n  $N.", ch, NULL, pet, TO_ROOM);
}

void do_buy(CHAR_DATA * ch, const char *argument)
{
    uint        cost, roll;
    CHAR_DATA      *keeper;
    OBJ_DATA       *obj, *t_obj;
    char            arg[MAX_INPUT_LENGTH];
    uint        number, count = 1;

    if ((keeper = find_keeper(ch)) == NULL)
        return;

    if (IS_SET(ch->in_room->room_flags, ROOM_PET_SHOP))
    {
        do_buy_pet(ch, argument);
        return;
    }

    number = mult_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0' || number == 0)
    {
        char_act(" ?", ch);
        return;
    }

    if (number < 0)
    {
        char_act("?    .", ch);
        return;
    }

    obj = get_obj_keeper(ch, keeper, arg);
    cost = get_cost(keeper, obj, TRUE);

    if (cost <= 0 || !can_see_obj(ch, obj))
    {
        do_tell_raw(keeper, ch, "    -  '{clist{x'");
        return;
    }
    if (!IS_OBJ_STAT(obj, ITEM_INVENTORY))
    {
        for (t_obj = obj->next_content; count < number && t_obj != NULL;
            t_obj = t_obj->next_content)
        {
            if (t_obj->pIndexData == obj->pIndexData
                && !mlstr_cmp(t_obj->short_descr, obj->short_descr))
                count++;
            else
                break;
        }

        if (count < number)
        {
            act("$n   '{G    .{x'",
                keeper, NULL, ch, TO_VICT);
            ch->reply = keeper;
            return;
        }
    }
    if ((ch->silver + ch->gold * 100) < cost * number)
    {
        if (number > 1)
            act("$n  : '{G   o   .{x'",
                keeper, obj, ch, TO_VICT);
        else
            act("$n  : '{G      $p.{x'",
                keeper, obj, ch, TO_VICT);
        ch->reply = keeper;
        return;
    }
    if (obj->level > get_wear_level(ch, obj))
    {
        act("$n  : '{G    $p  .{x'",
            keeper, obj, ch, TO_VICT);
        ch->reply = keeper;
        return;
    }
    if (ch->carry_number + number * get_obj_number(obj) > can_carry_n(ch))
    {
        char_act("     !", ch);
        return;
    }
    if (ch->carry_weight + number * get_obj_weight(obj) > can_carry_w(ch))
    {
        char_act("     !", ch);
        return;
    }
    /* haggle */
    roll = number_percent();
    if (!IS_OBJ_STAT(obj, ITEM_SELL_EXTRACT)
    && roll < get_skill(ch, gsn_haggle))
    {
        cost -= obj->cost / 2 * roll / 100;
        act("   $N.", ch, NULL, keeper, TO_CHAR);
        check_improve(ch, gsn_haggle, TRUE, 4);
    }
    if (number > 1)
    {
        act("$n  $P[$j].", ch, (const void *) number, obj, TO_ROOM);
        act_puts3("  $P[$j]  $J $qJ{}.", ch, (const void *) number, obj, (const void *) (cost * number), TO_CHAR, POS_RESTING);
    }
    else
    {
        act("$n  $p.", ch, obj, NULL, TO_ROOM);
        act("  $P  $j .", ch, (const void *) cost, obj, TO_CHAR);
    }

    deduct_cost(ch, cost * number);
//    keeper->gold += cost * number / 100;
//    keeper->silver += cost * number - (cost * number / 100) * 100;

    for (count = 0; count < number; count++)
    {
        if (IS_SET(obj->extra_flags, ITEM_INVENTORY))
            t_obj = create_obj(obj->pIndexData, obj->level);
        else
        {
            t_obj = obj;
            obj = obj->next_content;
            obj_from_char(t_obj);
        }

        if (t_obj->timer > 0 && !IS_OBJ_STAT(t_obj, ITEM_HAD_TIMER))
            t_obj->timer = 0;
        REMOVE_BIT(t_obj->extra_flags, ITEM_HAD_TIMER);
        obj_to_char(t_obj, ch);
        if (cost < t_obj->cost)
            t_obj->cost = cost;
    }
}

void do_list(CHAR_DATA * ch, const char *argument)
{
    if (IS_SET(ch->in_room->room_flags, ROOM_PET_SHOP))
    {
        ROOM_INDEX_DATA *pRoomIndexNext;
        CHAR_DATA      *pet;
        bool            found;
        int     scnt;

        pRoomIndexNext = get_room_index(ch->in_room->vnum + 1);
        if (pRoomIndexNext == NULL)
        {
            bug("Do_list: bad pet shop at vnum %d.", ch->in_room->vnum);
            char_act("     .", ch);
            return;
        }
        found = FALSE;
        scnt = 1;
        for (pet = pRoomIndexNext->people; pet; pet = pet->next_in_room)
        {
            if (!IS_NPC(pet))
                continue;   /* :) */
            if (IS_SET(pet->pIndexData->act, ACT_PET))
            {
                const char *name;
                char engname[MAX_STRING_LENGTH];

                if (!found)
                {
                    found = TRUE;
                    char_act("{c {c  :{x", ch);
                }

                name = mlstr_cval(pet->short_descr, ch);
                one_argument(pet->name, engname, sizeof(engname));

                char_printf(ch, "%2d [%2d] %8d - %s\n",
                            scnt++,
                            pet->level,
                            10 * pet->level * pet->level,
                            format_short(pet->short_descr, pet->name, ch, 0));
            }
        }
        if (!found)
            char_act(",        .", ch);
        return;
    }
    else
    {
        CHAR_DATA      *keeper;
        OBJ_DATA       *obj;
        int             cost, count;
        bool            found;
        char            arg[MAX_INPUT_LENGTH];
        int     scnt = 1;
        if ((keeper = find_keeper(ch)) == NULL)
            return;
        one_argument(argument, arg, sizeof(arg));

        found = FALSE;
        for (obj = keeper->carrying; obj; obj = obj->next_content)
        {
            if (obj->wear_loc == WEAR_NONE
                && can_see_obj(ch, obj)
                && (cost = get_cost(keeper, obj, TRUE)) > 0
                && (arg[0] == '\0'
                    || is_name(arg, obj->name)))
            {
                if (!found)
                {
                    found = TRUE;
                    char_act("N. {Y[{R   {Y]{x ", ch);
                }
                if (IS_OBJ_STAT(obj, ITEM_INVENTORY))
                    char_printf(ch, "%2d {Y[{c%2d %5d -- {Y]{x %s\n",
                                scnt, obj->level, cost,
                                format_short(obj->short_descr, obj->name, ch, 0));
                else
                {
                    count = 1;

                    while (obj->next_content != NULL
                           && obj->pIndexData == obj->next_content->pIndexData
                           && !mlstr_cmp(obj->short_descr,
                                         obj->next_content->short_descr))
                    {
                        obj = obj->next_content;
                        count++;
                    }
                    char_printf(ch, "%2d {Y[{x%2d %5d %2d {Y]{x %s\n",
                                scnt, obj->level, cost, count,
                                format_short(obj->short_descr, obj->name, ch, 0));
                }
                scnt++;
            }
        }

        if (!found)
            char_act("     .", ch);
        return;
    }
}

void do_sell(CHAR_DATA * ch, const char *argument)
{
    char            arg[MAX_INPUT_LENGTH];
    CHAR_DATA      *keeper;
    OBJ_DATA       *obj;
    uint        cost, roll;
    uint        gold, silver;

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act(" ?", ch);
        return;
    }
    if ((keeper = find_keeper(ch)) == NULL)
        return;

    if ((obj = get_obj_carry(ch, arg)) == NULL)
    {
        act("$n   '{G    .{x'",
            keeper, NULL, ch, TO_VICT);
        ch->reply = keeper;
        return;
    }
    if (!can_drop_obj(ch, obj))
    {
        char_act("     .", ch);
        return;
    }
    if (!can_see_obj(keeper, obj))
    {
        act("$n     .", keeper, NULL, ch, TO_VICT);
        return;
    }
    if ((cost = get_cost(keeper, obj, FALSE)) <= 0)
    {
        act("$n   $p.", keeper, obj, ch, TO_VICT);
        return;
    }
//    if (cost > (keeper->silver + 100 * keeper->gold))  -.
    if (cost > (keeper->level * 100))
    {
        act("$n  : '{G        $p.{x'",
            keeper, obj, ch, TO_VICT);
        return;
    }
    act("$n  $p.", ch, obj, NULL, TO_ROOM);
    /* haggle */
    roll = number_percent();
    if (!IS_OBJ_STAT(obj, ITEM_SELL_EXTRACT) && roll < get_skill(ch, gsn_haggle))
    {
        roll = get_skill(ch, gsn_haggle) + number_range(1, 20) - 10;
        char_act("   .", ch);
        cost += obj->cost * roll / 200;
//        cost = UMIN(cost, 95 * get_cost(keeper, obj, TRUE) / 100);
//        cost = UMIN(cost, (keeper->level));
        check_improve(ch, gsn_haggle, TRUE, 4);
    }
    silver = cost - (cost / 100) * 100;
    gold = cost / 100;

    if (get_carry_weight(ch) + cost > can_carry_w(ch))
    {
        char_act("     .", ch);
        return;
    }

    if (gold && silver)
        act_puts3("You sell $P for $j gold and $J silver $qJ{pieces}.",ch, (const void *) gold, obj, (const void *) silver, TO_CHAR, POS_RESTING); //T
    else if (gold)
        act_puts("You sell $P for $j gold $qj{pieces}.", ch, (const void *) gold, obj,  TO_CHAR, POS_RESTING); //T
    else if (silver)
        act_puts("You sell $P for $j silver $qj{pieces}.", ch, (const void *) silver, obj, TO_CHAR, POS_RESTING); //T
    ch->gold += gold;
    ch->silver += silver;
//    deduct_cost(keeper, cost/10);

    if (obj->pIndexData->item_type == ITEM_TRASH
    ||  IS_OBJ_STAT(obj, ITEM_SELL_EXTRACT))
        extract_obj(obj);
    else
    {
        obj_from_char(obj);
        if (obj->timer)
            SET_BIT(obj->extra_flags, ITEM_HAD_TIMER);
        else
            obj->timer = number_range(50, 100);
        obj_to_keeper(obj, keeper);
    }
}

void do_value(CHAR_DATA * ch, const char *argument)
{
    char            arg[MAX_INPUT_LENGTH];
    CHAR_DATA      *keeper;
    OBJ_DATA       *obj;
    int             cost;
    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act(" ?", ch);
        return;
    }
    if ((keeper = find_keeper(ch)) == NULL)
        return;

    if ((obj = get_obj_carry(ch, arg)) == NULL)
    {
        act_tell("    .", keeper, NULL, ch);
        ch->reply = keeper;
        return;
    }
    if (!can_see_obj(keeper, obj))
    {
        act("$n      .", keeper, NULL, ch, TO_VICT);
        return;
    }
    if (!can_drop_obj(ch, obj))
    {
        char_act("     .", ch);
        return;
    }
    if ((cost = get_cost(keeper, obj, FALSE)) <= 0)
    {
        act("$n   $p.", keeper, obj, ch, TO_VICT);
        return;
    }
    act_tell2("   $j $qj{}  $J $qJ{} ", keeper, (const void *) (cost - (cost / 100) * 100), ch, (const void *) (cost / 100));
    act_tell("  $p. ...", keeper, obj, ch);

    return;
}

void do_herbs(CHAR_DATA * ch, const char *argument)
{
    CHAR_DATA      *victim;
    char            arg[MAX_INPUT_LENGTH];
    int     sn;

    if (IS_NPC(ch)
        ||  (sn = sn_lookup("herbs")) < 0)
        return;

    one_argument(argument, arg, sizeof(arg));

    if (is_affected(ch, sn))
    {
        char_act("      .", ch);
        return;
    }

    WAIT_STATE(ch, SKILL(sn)->beats);

    if (arg[0] == '\0')
        victim = ch;
    else if ((victim = get_char_room(ch, arg)) == NULL)
    {
        char_act("  .", ch);
        return;
    }

    if (ch->in_room->sector_type != SECT_INSIDE
        &&  ch->in_room->sector_type != SECT_CITY
        &&  number_percent() < get_skill(ch, sn))
    {
        AFFECT_DATA     af;
        af.where = TO_AFFECTS;
        af.type = sn;
        af.level = LVL(ch);
        af.duration = 5;
        af.location = APPLY_NONE;
        af.modifier = 0;
        af.bitvector = 0;

        affect_to_char(ch, &af);

        char_act("    .", ch);
        act("$n     :)~.", ch, NULL, NULL, TO_ROOM);

        if (ch != victim)
        {
            act("$n    .", ch, NULL, victim, TO_VICT);
            act("  $N  .", ch, NULL, victim, TO_CHAR);
            act("$n  $N  .", ch, NULL, victim, TO_NOTVICT);
        }
        if (victim->hit < victim->max_hit)
        {
            char_act("!    !", victim);
            act("$n    !.", victim, NULL, NULL, TO_ROOM);
        }
        if (CAN_HEAL(ch,victim))
        {
            victim->hit = UMIN(victim->max_hit, victim->hit + 5 * LVL(ch));
            check_improve(ch, sn, TRUE, 1);
            if (is_affected(victim, gsn_plague))
            {
                if (check_dispel(LVL(ch), victim, gsn_plague))
                {
                    char_act("  .", victim);
                    act("$n  ,    $gn{}  .",
                        victim, NULL, NULL, TO_ROOM);
                }
            }
            if (is_affected(victim, gsn_poison))
            {
                if (check_dispel(LVL(ch), victim, gsn_poison))
                {
                    char_act(",  , .", victim);
                    act("$n  ,    $gn{}  .",
                        victim, NULL, NULL, TO_ROOM);
                }
            }
        }
        else if (!is_safe(ch,victim))
            damage(ch, victim, 2*LVL(ch), sn, DAM_NONE, TRUE);
    }
    else
    {
        char_act("    ,    .", ch);
        act("$n    .", ch, NULL, NULL, TO_ROOM);
        check_improve(ch, sn, FALSE, 1);
    }
}

void do_lore_raw(CHAR_DATA *ch, OBJ_DATA *obj, BUFFER *output)
{
    int     chance;
    int     percent;
    int     value0, value1, value2, value3, value4;
    int     mana;
    int     max_skill;
    int     sn;

    if ((sn = sn_lookup("lore")) < 0
        ||  (percent = get_skill(ch, sn)) < 10)
    {
        buf_add(output, "      .\n");
        return;
    }

    mana = SKILL(sn)->min_mana;
    if (ch->mana < mana)
    {
        buf_add(output, "   .\n");
        return;
    }
    ch->mana -= mana;
    WAIT_STATE(ch, SKILL(sn)->beats);

    /* a random lore */
    chance = number_percent();

    if (percent < 20)
    {
        buf_printf(output, " '%s'.\n", obj->name);
        check_improve(ch, sn, TRUE, 8);
        return;
    }
    else if (percent < 40)
    {
        buf_printf(output,
                   " '%s'.   %d,  %d.\n",
                   obj->name,
                   chance < 60 ? obj->weight : number_range(1, 2 * obj->weight),
                   chance < 60 ? number_range(1, 2 * obj->cost) : obj->cost
                  );
        if (str_cmp(obj->material, "oldstyle"))
            buf_printf(output, " %s.\n", obj->material);
        check_improve(ch, sn, TRUE, 7);
        return;
    }
    else if (percent < 60)
    {
        buf_printf(output,
                   " '%s'  %d.\n %d,  %d.\n %s.\n",
                   obj->name,
                   obj->weight,
                   chance < 60 ? number_range(1, 2 * obj->cost) : obj->cost,
                   chance < 60 ? obj->level : number_range(1, 2 * obj->level),
                   str_cmp(obj->material, "oldstyle") ? obj->material : "unknown"
                  );
        check_improve(ch, sn, TRUE, 6);
        return;
    }
    else if (percent < 80)
    {
        buf_printf(output,
                   " '%s'  %s, - %s.\n %d,  %d,  %d.\n %s.\n",
                   obj->name,
                   flag_string(item_types, obj->pIndexData->item_type),
                   flag_string(extra_flags, obj->extra_flags),
                   obj->weight,
                   chance < 60 ? number_range(1, 2 * obj->cost) : obj->cost,
                   chance < 60 ? obj->level : number_range(1, 2 * obj->level),
                   str_cmp(obj->material, "oldstyle") ? obj->material : "unknown"
                  );
        check_improve(ch, sn, TRUE, 5);
        return;
    }
    else if (percent < 85)
        buf_printf(output,
                   " '%s'  %s, - %s.\n %d,  %d,  %d.\n %s.\n",
                   obj->name,
                   flag_string(item_types, obj->pIndexData->item_type),
                   flag_string(extra_flags, obj->extra_flags),
                   obj->weight,
                   obj->cost,
                   obj->level,
                   str_cmp(obj->material, "oldstyle") ?
                   obj->material : "unknown"
                  );
    else
        buf_printf(output,
                   " '%s'  %s, - %s.\n %d,  %d,  %d.\n %s.\n",
                   obj->name,
                   flag_string(item_types, obj->pIndexData->item_type),
                   flag_string(extra_flags, obj->extra_flags),
                   obj->weight,
                   obj->cost,
                   obj->level,
                   str_cmp(obj->material, "oldstyle") ?
                   obj->material : "unknown"
                  );

    value0 = obj->value[0];
    value1 = obj->value[1];
    value2 = obj->value[2];
    value3 = obj->value[3];
    value4 = obj->value[4];

    max_skill = skills.nused;

    switch (obj->pIndexData->item_type)
    {
    case ITEM_SCROLL:
    case ITEM_POTION:
    case ITEM_PILL:
        if (percent < 85)
        {
            value0 = number_range(1, 60);
            if (chance > 40)
            {
                value1 = number_range(1, (max_skill - 1));
                if (chance > 60)
                {
                    value2 = number_range(1, (max_skill - 1));
                    if (chance > 80)
                        value3 = number_range(1, (max_skill - 1));
                }
            }
        }
        else
        {
            if (chance > 60)
            {
                value1 = number_range(1, (max_skill - 1));
                if (chance > 80)
                {
                    value2 = number_range(1, (max_skill - 1));
                    if (chance > 95)
                        value3 = number_range(1, (max_skill - 1));
                }
            }
        }

        buf_printf(output, " %d :", obj->value[0]);
        if (value1 >= 0)
            buf_printf(output, " '%s'", skill_name(value1));
        if (value2 >= 0)
            buf_printf(output, " '%s'", skill_name(value2));
        if (value3 >= 0)
            buf_printf(output, " '%s'", skill_name(value3));
        if (value4 >= 0)
            buf_printf(output, " '%s'", skill_name(value4));
        buf_add(output, ".\n");
        break;

    case ITEM_WAND:
    case ITEM_STAFF:
        if (percent < 85)
        {
            value0 = number_range(1, 60);
            if (chance > 40)
            {
                value3 = number_range(1, (max_skill - 1));
                if (chance > 60)
                {
                    value2 = number_range(0, 2 * obj->value[2]);
                    if (chance > 80)
                        value1 = number_range(0, value2);
                }
            }
        }
        else
        {
            if (chance > 60)
            {
                value3 = number_range(1, (max_skill - 1));
                if (chance > 80)
                {
                    value2 = number_range(0, 2 * obj->value[2]);
                    if (chance > 95)
                        value1 = number_range(0, value2);
                }
            }
        }

        buf_printf(output, " %d(%d)  %d  '%s'.\n",
                   value1, value2, value0, skill_name(value3));
        break;

    case ITEM_WEAPON:
        buf_add(output, "  ");
        if (percent < 85)
        {
            value0 = number_range(0, 8);
            if (chance > 33)
            {
                value1 = number_range(1, 2 * obj->value[1]);
                if (chance > 66)
                    value2 = number_range(1, 2 * obj->value[2]);
            }
        }
        else
        {
            if (chance > 50)
            {
                value1 = number_range(1, 2 * obj->value[1]);
                if (chance > 75)
                    value2 = number_range(1, 2 * obj->value[2]);
            }
        }

        buf_printf(output, "%s.\n", flag_string(weapon_class, value0));

        buf_printf(output, " %dd%d (average %d).\n",
                   value1, value2,
                   (1 + value2) * value1 / 2);
        break;

    case ITEM_ARMOR:
        if (percent < 85)
        {
            if (chance > 25)
            {
                value2 = number_range(0, 2 * obj->value[2]);
                if (chance > 45)
                {
                    value0 = number_range(0, 2 * obj->value[0]);
                    if (chance > 65)
                    {
                        value3 = number_range(0, 2 * obj->value[3]);
                        if (chance > 85)
                            value1 = number_range(0, 2 * obj->value[1]);
                    }
                }
            }
        }
        else
        {
            if (chance > 45)
            {
                value2 = number_range(0, 2 * obj->value[2]);
                if (chance > 65)
                {
                    value0 = number_range(0, 2 * obj->value[0]);
                    if (chance > 85)
                    {
                        value3 = number_range(0, 2 * obj->value[3]);
                        if (chance > 95)
                            value1 = number_range(0, 2 * obj->value[1]);
                    }
                }
            }
        }

        buf_printf(output,
                   "  %d  , %d  , %d  ,  %d  .\n",
                   value0, value1, value2, value3);
        break;
    }

    if (percent < 87)
    {
        check_improve(ch, sn, TRUE, 5);
        return;
    }

    if (!IS_SET(obj->extra_flags, ITEM_ENCHANTED))
        format_obj_affects(output, obj->pIndexData->affected,
                           FOA_F_NODURATION);
    format_obj_affects(output, obj->affected, 0);
    check_improve(ch, sn, TRUE, 5);
}

DO_FUN(do_lore)
{
    char        arg[MAX_INPUT_LENGTH];
    BUFFER *    output;
    OBJ_DATA *  obj;

    argument = one_argument(argument, arg, sizeof(arg));
    if (!strcmp(arg, "area"))
    {
        do_lore_area(ch, argument); return;
    }

    if ((obj = get_obj_carry(ch, arg)) == NULL)
    {
        char_act("    .", ch);
        return;
    }

    output = buf_new(-1);
    do_lore_raw(ch, obj, output);
    page_to_char(buf_string(output), ch);
    buf_free(output);
}

void do_butcher(CHAR_DATA * ch, const char *argument)
{
    OBJ_DATA       *obj;
    char            arg[MAX_STRING_LENGTH];
    OBJ_DATA       *tmp_obj;
    OBJ_DATA       *tmp_next;
    int     sn;
    int     chance;

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        char_act("Butcher what?", ch);
        return;
    }
    if ((obj = get_obj_here(ch, arg)) == NULL)
    {
        char_act("    .", ch);
        return;
    }
    if (obj->pIndexData->item_type != ITEM_CORPSE_PC
    &&  obj->pIndexData->item_type != ITEM_CORPSE_NPC )
    {
        char_act("You can't butcher that.", ch);
        return;
    }
    if (obj->carried_by != NULL)
    {
        char_act("  .", ch);
        return;
    }

    if ((sn = sn_lookup("butcher")) < 0
        ||  (chance = get_skill(ch, sn)) == 0)
    {
        char_act("      .", ch);
        return;
    }

    if (!can_loot(ch,obj))
    {
        char_act("     .", ch);
        return;
    }

    obj_from_room(obj);

    for (tmp_obj = obj->contains; tmp_obj != NULL; tmp_obj = tmp_next)
    {
        tmp_next = tmp_obj->next_content;
        obj_from_obj(tmp_obj);
        obj_to_room(tmp_obj, ch->in_room);
    }

    if (number_percent() < chance)
    {
        int             numsteaks;
        int             i;
        OBJ_DATA       *steak;
        numsteaks = number_bits(2) + 1;

        if (numsteaks > 1)
        {
            act("$n  $P   $j $qj{.}",
                ch, (const void *) numsteaks, obj, TO_ROOM);
            act("  $P   $j $qj{}.",
                ch, (const void *) numsteaks, obj, TO_CHAR);
        }
        else
        {
            act("$n  $p   .",
                ch, obj, NULL, TO_ROOM);
            act("  $p   .",
                ch, obj, NULL, TO_CHAR);
        }
        check_improve(ch, sn, TRUE, 1);

        for (i = 0; i < numsteaks; i++)
        {
            steak = create_named_obj(get_obj_index(OBJ_VNUM_STEAK), 0, mlstr_mval(obj->short_descr));
            obj_to_room(steak, ch->in_room);
        }
    }
    else
    {
        act("    $p   .", ch, obj, NULL, TO_CHAR);
        act("$n    $p   .",
            ch, obj, NULL, TO_ROOM);

        check_improve(ch, sn, FALSE, 1);
    }
    extract_obj(obj);
}

void do_scalp(CHAR_DATA * ch, const char *argument)
{
    OBJ_DATA       *obj;
    OBJ_DATA       *corpse;
    OBJ_DATA       *scalp;
    char            arg[MAX_STRING_LENGTH];
    const char     *p;
    OBJ_DATA       *tmp_obj;
    OBJ_DATA       *tmp_next;
    int     sn, chance;

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        char_act("Scalp what?", ch);
        return;
    }
    if ((obj = get_obj_here(ch, arg)) == NULL)
    {
        char_act("    .", ch);
        return;
    }
    if (obj->pIndexData->item_type != ITEM_CORPSE_PC)
    {
        char_act("You can't scalp that.", ch);
        return;
    }
    if (obj->pIndexData->vnum == OBJ_VNUM_CORPSE_PC2)
    {
        char_act("You can't scalp that!", ch);
        return;
    }
    if (obj->carried_by != NULL)
    {
        char_act("  .", ch);
        return;
    }
    if (!can_loot(ch, obj))
    {
        char_act("    .", ch);
        return;
    }

    if ((sn = sn_lookup("scalp")) < 0
    ||  (chance = get_skill(ch, sn)) == 0)
    {
        char_act("      .", ch);
        return;
    }

    p = mlstr_mval(obj->short_descr);
    if (!str_prefix(" ", p))
        p += strlen(" ");

    if (!str_prefix("  ", p))
        p += strlen("  ");

    if (!str_prefix("the corpse of ", p))
        p += strlen("the corpse of ");

    if (!str_prefix("the undead body of ", p))
        p += strlen("the undead body of ");


//    .

    corpse = create_named_obj(get_obj_index(OBJ_VNUM_CORPSE_PC2), obj->level, p);
    corpse->timer   = number_range(5, 10);
    corpse->owner   = str_dup(obj->owner);
//  corpse->owner   = obj->owner;
    corpse->altar   = obj->altar;
    corpse->level   = obj->level;
    corpse->cost    = 0;

    obj_to_room(corpse, obj->in_room);

//    ӣ   .

    for (tmp_obj = obj->contains; tmp_obj != NULL; tmp_obj = tmp_next)
    {
        tmp_next = tmp_obj->next_content;
        obj_from_obj(tmp_obj);
        obj_to_obj(tmp_obj, corpse);
    }

    obj_from_room(obj);

    if (number_percent() < chance)
    {
        act("$n  $p     .", ch, obj, NULL, TO_ROOM);
        act("  $p     .", ch, obj, NULL, TO_CHAR);
        check_improve(ch, sn, TRUE, 1);

        scalp = create_named_obj(get_obj_index(OBJ_VNUM_SEVERED_HEAD), 0, mlstr_mval(obj->short_descr));
        scalp->timer    = 0;
        scalp->level    = 0;
        scalp->owner    = str_dup(obj->owner);
        obj_to_char(scalp, ch);
    }
    else
    {
        act("  $p      .", ch, obj, NULL, TO_CHAR);
        act("$n  $p      .", ch, obj, NULL, TO_ROOM);
        check_improve(ch, sn, FALSE, 1);

        scalp = create_named_obj(get_obj_index(OBJ_VNUM_SEVERED_HEAD), 0, mlstr_mval(obj->short_descr));
        scalp->timer    = number_range(4, 7);
        scalp->level    = 0;
        scalp->owner    = str_dup(obj->owner);
        obj_to_char(scalp, ch);
    }
    extract_obj(obj);
}

void do_balance(CHAR_DATA * ch, const char *argument)
{
    char    buf[160];
    char    arg[MAX_INPUT_LENGTH];
    uint    bank_g;
    uint    bank_s;

    one_argument( argument, arg, sizeof(arg) );

    if (IS_NPC(ch))
    {
        char_act("You don't have a bank account.", ch);
        return;
    }
    if (!IS_SET(ch->in_room->room_flags, ROOM_BANK))
    {
        char_act("You are not in a bank.", ch);
        return;
    }

    if (ch->pcdata->bank_s + ch->pcdata->bank_g == 0)
    {
        char_act("You don't have any money in the bank.", ch);
        return;
    }

    bank_s = ch->pcdata->bank_s;

    if (!str_cmp(arg, "convert")
    || !str_cmp(arg, ""))
    {
        if (bank_s < 100)
        {
            char_act("You don't have enough silver in bank.", ch);
            return;
        }
        ch->pcdata->bank_g += 95 * bank_s / 100 / 100;
        ch->pcdata->bank_s = 0;
//        return;
    }

    bank_g = ch->pcdata->bank_g;
    bank_s = ch->pcdata->bank_s;

    snprintf(buf, sizeof(buf), "You have %s%s%s coin%s in the bank.\n",
        bank_g ? "%ld gold" : str_empty,
        (bank_g) && (bank_s) ? " and " : str_empty,
        bank_s ? "%ld silver" : str_empty,
        bank_s + bank_g > 1 ? "s" : str_empty);
    if (bank_g == 0)
        char_printf(ch, buf, bank_s);
    else
        char_printf(ch, buf, bank_g, bank_s);
}

void do_withdraw(CHAR_DATA * ch, const char *argument)
{
    int amount;
    uint    fee;
    bool    silver = FALSE;
    char    arg[MAX_INPUT_LENGTH];


    if (IS_AFFECTED(ch, AFF_CHARM))
    {
        char_act("  ,       !", ch);
        return;
    }

    if (IS_NPC(ch))
    {
        char_act("You don't have a bank account.", ch);
        return;
    }

    if (!IS_SET(ch->in_room->room_flags, ROOM_BANK))
    {
        char_act("The mosquito by your feet will not give you any money.\n", ch);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        char_act("Withdraw how much?", ch);
        return;
    }

    amount = atoi(arg);
    if (amount <= 0)
    {
        char_act("What?", ch);
        return;
    }

    if (!str_cmp(argument, "silver"))
        silver = TRUE;
    else if (str_cmp(argument, "gold") && argument[0] != '\0')
    {
        char_act("You can withdraw gold and silver coins only.", ch);
        return;
    }

    if ((silver && amount > ch->pcdata->bank_s)
        ||  (!silver && amount > ch->pcdata->bank_g))
    {
        char_act("Sorry, we don't give loans.", ch);
        return;
    }

    fee = UMAX(1, amount * (silver ? 10 : 2) / 100);

    if (get_carry_weight(ch) + (amount - fee) * (silver ? 4 : 1) / 10 >
        can_carry_w(ch))
    {
        char_act("You can't carry that weight.", ch);
        return;
    }

    if (silver)
    {
        ch->silver += amount - fee;
        ch->pcdata->bank_s -= amount;
    }
    else
    {
        ch->gold += amount - fee;
        ch->pcdata->bank_g -= amount;
    }

    char_printf(ch,
            "Here are your %d %s coin(s), "
            "minus a %d coin(s) withdrawal fee.\n",
            amount, silver ? "silver" : "gold", fee);
    act("$n steps up to the teller window.", ch, NULL, NULL, TO_ROOM);
}

void do_deposit(CHAR_DATA * ch, const char *argument)
{
    int amount;
    bool    silver = FALSE;
    char    arg[MAX_INPUT_LENGTH];

    if (IS_NPC(ch))
    {
        char_act("You don't have a bank account.", ch);
        return;
    }

    if (!IS_SET(ch->in_room->room_flags, ROOM_BANK))
    {
        char_act("The ant by your feet can't carry your gold.", ch);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        char_act("Deposit how much?", ch);
        return;
    }

    amount = atoi(arg);
    if (amount <= 0)
    {
        char_act("What?", ch);
        return;
    }

    if (!str_cmp(argument, "silver"))
        silver = TRUE;
    else if (str_cmp(argument, "gold") && argument[0] != '\0')
    {
        char_act("You can deposit gold and silver coins only.", ch);
        return;
    }

    if ((silver && amount > ch->silver)
        ||  (!silver && amount > ch->gold))
    {
        char_act("That's more than you've got.", ch);
        return;
    }

    if (silver)
    {
        ch->pcdata->bank_s += amount;
        ch->silver -= amount;
    }
    else
    {
        ch->pcdata->bank_g += amount;
        ch->gold -= amount;
    }

    if (amount == 1)
        char_printf(ch, "Oh boy! One %s coin?! Wah...\n",
                silver ? "silver" : "gold");
    else
        char_printf(ch, "%d %s coins deposited. Come again soon!\n",
                amount, silver ? "silver" : "gold");
    act("$n steps up to the teller window.", ch, NULL, NULL, TO_ROOM);
}

void do_transaction(CHAR_DATA * ch, const char *argument)
{
    char            arg[MAX_INPUT_LENGTH];
    CHAR_DATA      *victim;
    int amount;
    uint fee;
    bool    silver;

    argument = one_argument(argument, arg, sizeof(arg));

    if (IS_NPC(ch))
    {
        char_act("You don't have a bank account.", ch);
        return;
    }

    if (!IS_SET(ch->in_room->room_flags, ROOM_BANK))
    {
        char_act("   .", ch);
        return;
    }

    if (IS_AFFECTED(ch, AFF_CHARM))
    {
        char_act("        !", ch);
        return;
    }

    amount = atoi(arg);

    argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        char_act(" ? ?", ch);
        return;
    }

    if (amount <= 0
        ||  (str_cmp(arg, "coins") && str_cmp(arg, "coin") &&
             str_cmp(arg, "gold") && str_cmp(arg, "silver")))
    {
        char_act(",      .", ch);
        return;
    }

    silver = str_cmp(arg, "gold");

    argument = one_argument(argument, arg, sizeof(arg));
    if (!str_cmp(arg, "to"))
        argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        do_give(ch, str_empty);
        return;
    }

    if ((victim = get_char_world(ch, arg)) == NULL)
    {
        char_act("  .", ch);
        return;
    }

    if (IS_NPC(victim))
    {
        char_act("      .", ch);
        return;
    }

    if ((!silver && ch->pcdata->bank_g < amount)
        ||  (silver && ch->pcdata->bank_s < amount))
    {
        char_act("    .", ch);
        return;
    }

    fee = UMAX(1, amount * (silver ? 10 : 2) / 100);

    if ((!silver && ch->pcdata->bank_g < amount + fee)
        ||  (silver && ch->pcdata->bank_s < amount +fee))
    {
        char_printf(ch, " %d %s  .\n",
            fee, silver ? "" : "");
        return;
    }

    if (silver)
    {
        ch->pcdata->bank_s -= amount + fee;
        victim->pcdata->bank_s += amount;
    }
    else
    {
        ch->pcdata->bank_g -= amount + fee;
        victim->pcdata->bank_g += amount;
    }

    act_puts3("$n ף   ޣ $J $t.",
        ch, silver ? "silver" : "gold",
        victim, (const void *) amount, TO_VICT | ACT_TRANS, POS_DEAD);
    act_puts3(" ף  ޣ $N $J $qJ{$t} ",
        ch, silver ? "silver" : "gold",
        victim, (const void *) amount, TO_CHAR | ACT_TRANS | ACT_NOLF, POS_RESTING);
    act_puts("( $j $qj{$T})", ch, (const void *) fee,
        silver ? "silver" : "gold", TO_CHAR | ACT_TRANS | ACT_NOUCASE, POS_RESTING);
}

/* wear object as a secondary weapon */
void do_second_wield(CHAR_DATA * ch, const char *argument)
{   clan_t *clan;
    OBJ_DATA *  obj;
    OBJ_DATA *  obj1;
    AFFECT_DATA *paf;
    int     skill;
    int     wear_lev;
    int     qqq;

    if (get_skill(ch, gsn_second_weapon) == 0)
    {
        char_act("       .", ch);
        return;
    }
    if (argument[0] == '\0')
    {
        char_act("     ?", ch);
        return;
    }
    obj = get_obj_carry(ch, argument);

    if (obj == NULL)
    {
        char_act("   .", ch);
        return;
    }

    if (IS_SET(obj->extra_flags, ITEM_MAGIC))
    {
        clan = CLAN(ch->clan);
        if (IS_SET(clan->flags, CLAN_HATE_MAGIC))
        {
            char_act("      !", ch);
            return;
        }
    }

    if (!CAN_WEAR(obj, ITEM_WIELD))
    {
        char_act("        .", ch);
        return;
    }
    if ((get_eq_char(ch, WEAR_SHIELD) != NULL)
    || (get_eq_char(ch, WEAR_HOLD) != NULL))
    {
        char_act("              .", ch);
        return;
    }
    wear_lev = get_wear_level(ch, obj);

    if (wear_lev < obj->level)
    {
        char_printf(ch, "  %d      .\n",
                    obj->level - wear_lev + ch->level);
        act_puts("$n tries to use $p, but is too inexperienced.", ch, obj, NULL, TO_ROOM, POS_RESTING);
        return;
    }


    if ( (obj1 = get_eq_char(ch, WEAR_WIELD)) == NULL)
    {
        char_act("      !", ch);
        return;
    }
    for (paf=ch->affected; paf != NULL; paf = paf->next)
    {
        if (paf->type != gsn_boneshatter || paf->location != APPLY_NONE)
            continue;
        char_act("   ,    !", ch);
        return;
    }

    qqq = (ch->size) + get_curr_stat(ch, STAT_STR);

    if ( !IS_WEAPON_STAT(obj1, WEAPON_TWO_HANDS) && qqq<=33
         && IS_WEAPON_STAT(obj, WEAPON_TWO_HANDS))
    {
        char_act("      .", ch);
        return;
    }

    if (IS_WEAPON_STAT(obj1, WEAPON_TWO_HANDS) && qqq<=30)
    {
        char_act("       !", ch);
        return;
    }

    if (IS_WEAPON_STAT(obj1, WEAPON_TWO_HANDS) && qqq<=33
        && IS_WEAPON_STAT(obj, WEAPON_TWO_HANDS))
    {
        char_act("        !", ch);
        return;
    }

    if (IS_SET(obj->extra_flags, ITEM_GOD_ONLY)
        && (ch->level < LEVEL_IMMORTAL || IS_NPC(ch)))
    {
        act("$n   $p,   .",
            ch, obj, NULL, TO_ROOM);
        act_puts("$n tries to use $p, but is too inexperienced.", ch, obj, NULL, TO_ROOM, POS_RESTING);
        return;
    }

    if (get_obj_weight(obj) >
        (str_app[get_curr_stat(ch, STAT_STR)].wield * ch->size))
    {
        char_act("   ,      .", ch);
        return;
    }
    if (!remove_obj(ch, WEAR_SECOND_WIELD, TRUE))
        return;

    act("$n     $p.", ch, obj, NULL, TO_ROOM);
    act("     $p.", ch, obj, NULL, TO_CHAR);
    obj = equip_char(ch, obj, WEAR_SECOND_WIELD);
    if (obj == NULL)
        return;

    skill = get_weapon_skill(ch, get_weapon_sn(obj));

    if (skill >= 100)
        act("$p   !", ch, obj, NULL, TO_CHAR);
    else if (skill > 85)
        act("     $p.", ch, obj, NULL, TO_CHAR);
    else if (skill > 70)
        act("   $p.", ch, obj, NULL, TO_CHAR);
    else if (skill > 50)
        act(" -   $p.", ch, obj, NULL, TO_CHAR);
    else if (skill > 25)
        act("$p     .", ch, obj, NULL, TO_CHAR);
    else if (skill > 1)
        act("       $p.", ch, obj, NULL, TO_CHAR);
    else
        act("         $p.",
            ch, obj, NULL, TO_CHAR);
}

void do_enchant(CHAR_DATA * ch, const char *argument)
{
    OBJ_DATA *  obj;
    int     chance;
    int     sn;
    int     wear_level;

    if ((sn = sn_lookup("enchant sword")) < 0
        ||  (chance = get_skill(ch, sn)) == 0)
    {
        char_act("?", ch);
        return;
    }

    if (!IS_NPC(ch) && IS_AFFECTED(ch, AFF_CHARM))
    {
        char_act("    -     !", ch);
        return;
    }

    if (argument[0] == '\0')
    {  /* empty */
        char_act("    ?", ch);
        return;
    }
    obj = get_obj_carry(ch, argument);

    if (obj == NULL)
    {
        char_act("   .", ch);
        return;
    }

    wear_level = get_wear_level(ch, obj);
    if (wear_level < obj->level)
    {
        char_printf(ch, "     %d    .\n",
                    obj->level - wear_level + ch->level);
        act("$n   $p,  $gn{}   .",
            ch, obj, NULL, TO_ROOM);
        return;
    }
    if (ch->mana < 100)
    {
        char_act("   .", ch);
        return;
    }

    WAIT_STATE(ch, SKILL(sn)->beats);
    if (number_percent() > chance)
    {
        char_act("    .", ch);
        act("$n   $p,  $gn{}      .",
            ch, obj, NULL, TO_ROOM);
        check_improve(ch, sn, FALSE, 6);
        ch->mana -= 50;
        return;
    }
    ch->mana -= 100;
    spell_enchant_weapon(24, ch->level, ch, obj, TARGET_OBJ);
    check_improve(ch, sn, TRUE, 2);
}

void do_send(CHAR_DATA * ch, const char *argument)
{
    char            arg[MAX_INPUT_LENGTH];
    CHAR_DATA      *victim;
    OBJ_DATA       *obj;

    if (IS_NPC(ch))
        return;

    argument = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("   ?", ch);
        return;
    }

    if (IS_SET(ch->comm, COMM_NOSEND))
    {
        if (!str_cmp(arg, "on"))
        {
            char_act("      .", ch);
            REMOVE_BIT(ch->comm,COMM_NOSEND);
            return;
        }
        else
        {
            char_act("      .", ch);
            char_act(" 'send on',    .", ch);
            return;
        }
    }

    if (!str_cmp(arg, "off"))
    {
        char_act("       .", ch);
        SET_BIT(ch->comm,COMM_NOSEND);
        return;
    }

    if (ch->fighting)
    {
        char_act("     .", ch);
        return;
    }


    if (ch->in_room->sector_type != SECT_CITY)
    {
        char_act("   !..  ..", ch);
        act("$n     ..", ch, NULL, ch, TO_NOTVICT);
        return;
    }

    if (IS_AFFECTED(ch,AFF_FEAR))
    {
        char_act("    !     ģ?", ch);
        return;
    }

    if (ch->position < POS_STANDING)
    {
        char_act(" .", ch);
        return;
    }

//

    if (is_number(arg))
    {
        /* 'give NNNN coins victim' */
        int             amount;
        bool            silver;

        amount = atoi(arg);

        argument = one_argument(argument, arg, sizeof(arg));
        if (arg[0] == '\0')
        {
            do_send(ch, str_empty);
            return;
        }

        if (amount <= 0
            ||  (str_cmp(arg, "coins") && str_cmp(arg, "coin") &&
                 str_cmp(arg, "gold") && str_cmp(arg, "silver")))
        {
            char_act(",      .", ch);
            return;
        }

        silver = str_cmp(arg, "gold");

        argument = one_argument(argument, arg, sizeof(arg));
        if (!str_cmp(arg, "to"))
            argument = one_argument(argument, arg, sizeof(arg));
        if (arg[0] == '\0')
        {
            do_send(ch, str_empty);
            return;
        }

        if ((!silver && ch->gold < amount)
            ||  (silver && ch->silver < amount))
        {
            char_act("    .", ch);
            return;
        }

        if ((victim = get_char_world(ch, arg)) == NULL)
        {
            char_act("  .", ch);
            return;
        }

        if (IS_SET(victim->comm, COMM_NOSEND) && !IS_IMMORTAL(ch))
        {
            char_act("  .", ch);
            return;
        }

        if (IS_NPC(victim))
        {
            char_act("  .", ch);
            return;
        }

        if (IS_AFFECTED(ch, AFF_CHARM))
        {
            char_act("    !", ch);
            return;
        }

        if (victim->in_war && victim->war_status == PS_ALIVE)
        {
            act ("$N is fighting in the war and can't receive your gift now.", ch, NULL, victim, TO_CHAR);
            return;
        }

        if ((silver && get_carry_weight(victim) + amount*SILVER_WEIGHT > can_carry_w(victim))
            || (!silver && get_carry_weight(victim) + amount*GOLD_WEIGHT > can_carry_w(victim)))
        {
            char_act("     .", ch);
            return;
        }

        if (silver)
        {
            ch->silver -= amount;
            victim->silver += amount;
        }
        else
        {
            ch->gold -= amount;
            victim->gold += amount;
        }

        act_puts3("$n   $J $t.", ch, silver ? "silver" : "gold", victim, (const void *) amount, TO_VICT | ACT_TRANS, POS_DEAD);
        act("$n  $N  .", ch, NULL, victim, TO_NOTVICT);
        act_puts3("  $N $J $t.", ch, silver ? "silver" : "gold", victim, (const void *) amount, TO_CHAR | ACT_TRANS, POS_DEAD);

        return;
    }

    if ((obj = get_obj_carry(ch, arg)) == NULL)
    {
        char_act("    .", ch);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));
    if (!str_cmp(arg, "to"))

        argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        do_send(ch, str_empty);
        return;
    }

    if (obj->wear_loc != WEAR_NONE)
    {
        char_act("  .", ch);
        return;
    }

    if (!can_drop_obj(ch, obj))
    {
        char_act("     .", ch);
        return;
    }

    if ((victim = get_char_world(ch, arg)) == NULL)
    {
        char_act("  .", ch);
        return;
    }

    if (IS_SET(victim->comm, COMM_NOSEND) && !IS_IMMORTAL(ch))
    {
        char_act("  .", ch);
        return;
    }

    if (IS_NPC(victim))
    {
        char_act("  .", ch);
        return;
    }

    if (IS_AFFECTED(ch, AFF_CHARM))
    {
        char_act("    !", ch);
        return;
    }

    if (victim->carry_number + get_obj_number(obj) > can_carry_n(victim))
    {
        act(" $N .", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (get_carry_weight(victim) + get_obj_weight(obj) > can_carry_w(victim))
    {
        act("$N     .", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (!can_see_obj(victim, obj))
    {
        act("$N   .", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (IS_NPC(victim))
    {
        act("$N   .", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (obj->pIndexData->limit != -1)
    {
        if ((IS_OBJ_STAT(obj, ITEM_ANTI_EVIL) && IS_EVIL(victim))
            ||  (IS_OBJ_STAT(obj, ITEM_ANTI_GOOD) && IS_GOOD(victim))
            ||  (IS_OBJ_STAT(obj, ITEM_ANTI_NEUTRAL) && IS_NEUTRAL(victim)))
        {
            act("$gN{}       .", ch, NULL, victim, TO_CHAR);
            return;
        }
    }

    obj_from_char(obj);
    obj_to_char(obj, victim);
    act("$n ף     $p  $N.", ch, obj, victim, TO_NOTVICT | ACT_NOTRIG);
    act("$n   $p.", ch, obj, victim, TO_VICT | ACT_NOTRIG);
    act("  $p $N.", ch, obj, victim, TO_CHAR | ACT_NOTRIG);
}

DO_FUN(do_embalmment)
{
    AFFECT_DATA af;
    OBJ_DATA *part;
    char arg[MAX_INPUT_LENGTH];
    int chance = 0, duration = 0;
    int mana;

    WAIT_STATE(ch, MISSING_TARGET_DELAY);

    mana = SKILL(gsn_embalmment)->min_mana;
    if (ch->mana < mana)
    {
        char_act("   .", ch);
        return;
    }

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("    ?", ch);
        return;
    }

    part = get_obj_carry(ch, arg); 
    if (part == NULL)
        part = get_obj_room(ch, arg); 

    if (part == NULL)
    {
        char_act("     .", ch);
        return;
    }

    if ((part->pIndexData->vnum == OBJ_VNUM_SLICED_ARM
         || part->pIndexData->vnum == OBJ_VNUM_SLICED_LEG
         || part->pIndexData->vnum == OBJ_VNUM_SEVERED_HEAD
         || part->pIndexData->vnum == OBJ_VNUM_TORN_HEART
         || part->pIndexData->vnum == OBJ_VNUM_GUTS
         || part->pIndexData->vnum == OBJ_VNUM_BRAINS
         || part->pIndexData->vnum == OBJ_VNUM_CORPSE_NPC)
        && part->timer != 0)
        chance = 0;
    else
    {
        char_act("  .", ch);
        return;
    }

    if (part->pIndexData->vnum == OBJ_VNUM_CORPSE_NPC && ch->class != CLASS_NECROMANCER)
    {
        char_act("You don't know how to embalm corpses.", ch);
        return;
    }

    chance += get_skill(ch, gsn_embalmment) / 3;

    if (chance > 0)
        duration = 1;
    else if (IS_UNDEAD (ch))
        duration = number_fuzzy(2);
    else
        duration = number_fuzzy(3);

    if (is_affected(ch, gsn_embalmment))
    {
        if (chance > 0)
            affect_strip(ch, gsn_embalmment);
        else
            chance -= 100;
    }

    if (IS_UNDEAD(ch))
        chance += 20;

    if (is_class_warrior(ch))
        chance -= 10;

    chance += (get_curr_stat(ch, STAT_INT) + get_curr_stat(ch, STAT_WIS));
    chance += get_curr_stat(ch, STAT_LCK) * 2;

    WAIT_STATE(ch, SKILL(gsn_embalmment)->beats);


    if (!IS_NPC(ch) && number_percent() < chance)
    {
        af.where        = TO_AFFECTS;
        af.type         = gsn_embalmment;
        af.level        = LVL(ch);
        af.duration     = duration;
        af.modifier     = 0;
        af.bitvector    = 0;
        af.location     = 0;
        affect_to_char(ch,&af);

        ch->mana        -= mana;
        part->timer     = part->pIndexData->vnum == OBJ_VNUM_CORPSE_NPC ? 30 : 0;
//        part->owner     = str_empty;
//        free_string (part->owner);
        if (get_wear_level(ch, part) < part->level)
            part->level = LVL (ch);
        check_improve(ch, gsn_embalmment, TRUE, 1);
        act("  $p!", ch, part, NULL, TO_CHAR);
        act("$n  $p!", ch, part, NULL, TO_ROOM);
    }
    else
    {
        char_act("    .  !", ch);
        extract_obj(part);
        ch->mana -= mana/2;
        check_improve(ch, gsn_embalmment, FALSE, 1);
    }
}

DO_FUN(do_examine_deck)
{
    BUFFER* buf;
    CardDeck* deck;

    buf = buf_new(-1);
    deck = pcd;


    if (!deck->visible)
    {
        char_act("This deck is not visible.\n", ch);
        return;
    }
    VisualiseDeck(deck, buf);

    page_to_char(buf_string(buf), ch);
    buf_free(buf);
}

DO_FUN(do_examine_table)
{
    BUFFER* buf;
    CardTable* table;

    buf = buf_new(-1);
    table = pct;

    VisualiseTable(table, buf);

    page_to_char(buf_string(buf), ch);
    buf_free(buf);
}


DO_FUN(do_examine_hand)
{
    BUFFER* buf;
    CardHand* table;

    buf = buf_new(-1);
    table = pch;

    VisualiseHand(table, buf);

    page_to_char(buf_string(buf), ch);
    buf_free(buf);
}

DO_FUN(do_cover_card)
{
    CardTable* ct;
    CardHand* chnd;

    int SourceCard;
    int TargetCard;
    int Orient;

    char arg[MAX_INPUT_LENGTH];
    char CardName1[MAX_STRING_LENGTH] = "\0";
    char CardName2[MAX_STRING_LENGTH] = "\0";
    char message[MAX_STRING_LENGTH]   = "\0";

    if (argument[0] == '\0')
    {
        char_act("Usage: cover <your card> <card on table>\n", ch);
        return;
    }
    argument = one_argument(argument, arg, sizeof(arg));
    SourceCard = atoi(arg);

    if (argument[0] == '\0')
    {
        char_act("Usage: cover <your card> <card on table>\n", ch);
        return;
    }
    argument = one_argument(argument, arg, sizeof(arg));
    TargetCard = atoi(arg);

    if (argument[0] == '\0')
        Orient = 0;
    else
        Orient = 0;

    ct = pct;
    chnd = pch;

    VisualiseCard(chnd->content[SourceCard], 0, 0, CardName1, sizeof(CardName1));
    VisualiseCard(ct->content[TargetCard].card, 0, 0, CardName1, sizeof(CardName2));

    snprintf(message, sizeof(message), "$n ģ %s  %s.", CardName1, CardName2);

    CardCover(SourceCard, TargetCard, ct, pch, Orient);

    act(message, ch, NULL, NULL, TO_ROOM);

    return;
}

DO_FUN(do_lay_card)
{
    CardTable* ct;
    CardHand* chnd;
    CardDeck* cd;

    bool hand = TRUE;
    bool visible;
    int SourceCard;
    int Orient;
    int index;

    char arg[MAX_INPUT_LENGTH];
    char CardName1[MAX_STRING_LENGTH];
    char message[MAX_STRING_LENGTH];

    SourceCard = -1;

    if (argument[0] == '\0')
    {
        char_act("Usage: card_lay <vis | nvis> <number> [index]\n", ch);
        return;
    }
    argument = one_argument(argument, arg, sizeof(arg));
    visible = (!strcmp(arg, "vis"));

    ct = pct;
    chnd = pch;
    cd = pcd;

    if (hand)
    {
        argument = one_argument(argument, arg, sizeof(arg));
        if (!is_number(arg))
        {
            char_act("What lay?", ch);
            return;
        }
        SourceCard = atoi(arg);

        argument = one_argument(argument, arg, sizeof(arg));
        if (argument[0] == '\0')
            index = ct->count;
        else
            index = atoi(arg);

        argument = one_argument(argument, arg, sizeof(arg));
        if (argument[0] == '\0')
            Orient = 0;
        else
            Orient = 0;

        if (SourceCard < 0 || SourceCard > chnd->count-1)
        {
            char_puts("But you haven't such card in your hand!", ch);
            return;
        }
        if (index < 0 || index > ct->count)
        {
            char_puts("But you can't place your card there!", ch);
            return;

        }

        CardLayFromHand(SourceCard, chnd, index, ct, visible, Orient);
    }


    VisualiseCard(chnd->content[SourceCard], 0, 0, CardName1, sizeof(CardName1));

    snprintf(message, sizeof(message), "$n ģ %s  %s  .",
             visible    ? CardName1 : "", hand? "" : "");
    act(message, ch, NULL, NULL, TO_ROOM);

    return;
}

DO_FUN(do_deal_card)
{

    CardHand* chnd;
    CardDeck* cd;
    CardTable* ct;

    bool player = TRUE;
    bool visible;
    int count;
    cards card;

    int i;

    char arg[MAX_INPUT_LENGTH];
    char CardName1[MAX_STRING_LENGTH];
    char message[MAX_STRING_LENGTH];

    if (argument[0] == '\0')
    {
        char_act("Usage: card_deal <vis | nvis> <player | table> <count>\n", ch);
        return;
    }

    card = '\0';

    argument = one_argument(argument, arg, sizeof(arg));
    visible = (!strcmp(arg, "vis"));

    cd = pcd;   // we'll determine available deck here


    chnd = pch; // here we'll have some parsing
    ct = pct;   // or available table

    argument = one_argument(argument, arg, sizeof(arg));

    argument = one_argument(argument, arg, sizeof(arg));
    count = atoi(arg);
    if (count > cd->count)
    {
        char_act("But there aren't so many cards in this deck!\n", ch);
        return;
    }


    for (i = 0; i < count; i++)
    {
        if (player)
        {
            card = CardFromDeck(cd->count-1, cd);
            CardToHand(card, chnd);
        }
        else
        {
            CardLayFromDeck(cd->count-1, cd, ct->count, ct, visible, 0);
        }

        if (visible)
        {
            VisualiseCard(card, 0, 0, CardName1, sizeof(CardName1));
            snprintf(message, sizeof(message), "$n  %s %s.", CardName1, player ? "$N" : " ");

            act(message, ch, ch, NULL, TO_ROOM);
        }
    }
    if (!visible)
    {
        snprintf(message, sizeof(message), "$n  %d %s %s.", count, (count == 1) ? "" : "()", player ? "$N" : " ");
        act(message, ch, ch, ch, TO_ROOM);
    }

}
