/* $Id: act_wiz.c,v 1.666 2004/09/20 10:49:47 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
 /************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/

#include <sys/types.h>
#if !defined (WIN32)
#include <sys/time.h>
#endif

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>
#if !defined (WIN32)
#include <unistd.h>
#endif

#include "limited.h"
#include "merc.h"
#include "update.h"
#include "quest.h"
#include "obj_prog.h"
#include "fight.h"
#include "quest.h"
#include "db/cmd.h"
#include "db/db.h"
#include "db/dofun.h"
#include "skills.h"
#include "olc/olc.h"
#include "auction.h"
#include "conquer.h"

/* command procedures needed */
DECLARE_DO_FUN(do_rstat );
DECLARE_DO_FUN(do_mstat );
DECLARE_DO_FUN(do_ostat );
DECLARE_DO_FUN(do_dstat );
DECLARE_DO_FUN(do_rset  );
DECLARE_DO_FUN(do_mset  );
DECLARE_DO_FUN(do_oset  );
DECLARE_DO_FUN(do_sset  );
DECLARE_DO_FUN(do_mfind );
DECLARE_DO_FUN(do_ofind );
DECLARE_DO_FUN(do_mload );
DECLARE_DO_FUN(do_oload );
DECLARE_DO_FUN(do_quit  );
DECLARE_DO_FUN(do_save  );
DECLARE_DO_FUN(do_look  );
DECLARE_DO_FUN(do_stand );
DECLARE_DO_FUN(do_help  );
DECLARE_DO_FUN(do_bd    );
DECLARE_DO_FUN(do_wset  );
DECLARE_DO_FUN(do_dateset);
DECLARE_DO_FUN(do_datetime);

DECLARE_DO_FUN(do_CreateHand);
DECLARE_DO_FUN(do_CreateDeck);
DECLARE_DO_FUN(do_CreateTable);
DECLARE_DO_FUN(do_StatDeck);

DECLARE_DO_FUN(do_gc);

qtrouble_t *qtrouble_lookup(CHAR_DATA *ch, int vnum);
unsigned long get_next_seconds(const char *argument, CHAR_DATA *ch);

void links_pull     (CHAR_DATA *ch);
void do_quit_org    (CHAR_DATA *ch, const char *argument, bool Count);

bool write_to_descriptor  (int desc, char *txt, int length);
void reboot_muddy(void);
void trim_ch(CHAR_DATA *ch);
void limits_strip(CHAR_DATA * ch);
void update_member_info (CHAR_DATA * ch);
char *crypt(const char *key, const char *salt);

extern int  rebooter;
extern void msg_dump        (BUFFER *buf, mlstring *ml);
extern void links_fix       (CHAR_DATA *ch);
extern void save_immortal   (CHAR_DATA *ch);
extern bool delete_immortal (CHAR_DATA *ch, const char *argument);
extern void save_stat_record (void);
extern void save_gq (void);

#if !defined (WIN32)
FILE        *   popen       args((const char *command, const char *type));
int             pclose      args((FILE *stream));
#endif

char        *   fgetf       args((char *s, int n, register FILE *iop));

DO_FUN(do_pipe)
{
    char buf[5000];
    FILE *fp;
#if !defined (WIN32)
    fp = popen(argument, "r");
#else
    fp = _popen(argument, "r");
#endif

    fgetf(buf, 5000, fp);

    page_to_char(buf, ch);

#if !defined (WIN32)
    pclose(fp);
#else
    _pclose(fp);
#endif

    return;
}

char *fgetf(char *s, int n, register FILE *iop)
{
    register int c;
    register char *cs;

    c = '\0';
    cs = s;
    while (--n > 0 && (c = getc(iop)) != EOF)
        if ((*cs++ = c) == '\0')
            break;
    *cs = '\0';
    return((c == EOF && cs == s) ? NULL : s);
}

void do_bd (CHAR_DATA * ch, const char * argument)
{
    int i ;

    if (argument[0] == '\0')
    {
        if (bdflags == 1) char_act("Congratulation is {Ron{x.", ch)  ; //T
        else              char_act("Congratulation is {Roff{x.", ch) ; //T

        for (i = 0 ; i < 10 ; i++)
            if (bdmsg[i] != NULL) char_printf (ch, "BD %s\n", bdmsg[i]) ;
    }

    if (!str_cmp(argument, "help"))
    {
        char_act("Syntax: bd on|off|msg <number> <msg>", ch) ;
        return ;
    }

    if (!str_cmp(argument, "on"))
    {
        bdflags = 1 ;
        char_act("Congratulation is {Ron{x.", ch) ; //T
    } else
        if (!str_cmp(argument, "off"))
    {
        bdflags = 0 ;
        char_act("Congratulation is {Roff{x.", ch) ; //T
    } else
        if (!str_cmp(argument, "msg"))
    {
        int number ;
        char arg [MAX_INPUT_LENGTH] ;

        argument = one_argument(argument, arg, sizeof(arg)) ;

        if (IS_NULLSTR (arg) || !is_number(arg))
        {
            char_act("Syntax: bd on|off|msg <number> <msg>", ch) ;
            return ;
        }

        number = atoi (arg) ;

        if (number < 0 && number > 9) return ;

        free_string (bdmsg [number]) ;
        bdmsg [number] = str_dup (argument) ;
        return ;
    }
}

DO_FUN(do_limit_strip)
{
    CHAR_DATA *victim;

    victim = get_char_world(ch, argument);
    if (victim == NULL || IS_NPC(victim))
    {
        char_act("  .", ch);
        return;
    }
    limits_strip(victim);
}

/* New objlist from mud.nnov.ru */

void brief_show_obj_index(OBJ_INDEX_DATA *pObj, BUFFER *buf)
{
    char arg[MAX_INPUT_LENGTH];
    AFFECT_DATA *paf;
    int cnt;
    where_t *w;
    int i;
    ROOM_INDEX_DATA *room;
    RESET_DATA *reset;

    buf_printf(buf, "\n#Obj[%6d]: [%s] (%s)\n", pObj->vnum,
               mlstr_mval(pObj->short_descr), flag_string(item_types, pObj->item_type));
    if (pObj->limit != -1)
        snprintf(arg, sizeof(arg), "  Limited by %d", pObj->limit);
    else
        arg[0] = '\0';
    buf_printf(buf, "Level:       [%3d] ",
               pObj->level, arg);
    buf_printf(buf, "Wear flags:  [%s]\n",
               flag_string(wear_flags, pObj->wear_flags));
    buf_printf(buf, "Extra flags: [%s]\n",
               flag_string(extra_flags, pObj->extra_flags));
    buf_printf(buf, "Condition:   [%3d]  Material:    [%s]\n",
               pObj->condition, pObj->material);
    buf_printf(buf, "Weight:      [%5d]\nCost:        [%5d]\n",
               pObj->weight, pObj->cost);
    for (cnt = 0, paf = pObj->affected; paf; paf = paf->next)
    {
        w = where_lookup(paf->where);
        if (cnt == 0)
        {
            buf_add(buf, "Number      Affects Modifier Affects Bitvector\n");
            buf_add(buf, "------ ------------ -------- ------- -----------------------------------------\n");
        }
        buf_printf(buf, "[%4d] %12.12s",
                   cnt, flag_string(apply_flags, paf->location));
        //    if (paf->location == APPLY_5_SKILL || paf->location == APPLY_10_SKILL)
        //            buf_printf(buf, " %-8s ", skill_name(paf->modifier));
        //    else
        buf_printf(buf, " %8d ", paf->modifier);
        buf_printf(buf, "%7.7s %s\n",
                   flag_string(apply_types, paf->where),
                   w ? flag_string(w->table, paf->bitvector) : "none");
        cnt++;
    }
    show_obj_values(buf, pObj);
    cnt = 0;
    for (i = 0; i < MAX_KEY_HASH; i++)
        for (room = room_index_hash[i]; room; room = room->next)
            for (reset = room->reset_first; reset; reset = reset->next)
            {
                bool found = FALSE;

                switch (reset->command)
                {
                case 'P':
                case 'O':
                case 'G':
                case 'E':
                    if (reset->arg1 == pObj->vnum)
                        found = TRUE;
                    break;

                default:
                    break;;
                }
                if (!found)
                    continue;
                if (!(cnt++))
                    buf_add(buf, "Obj has resets in following rooms: ");
                buf_printf(buf, "%d ", room->vnum);
                break;
            }
    if (cnt)
        buf_add(buf, ".\n");
    else
        buf_add(buf, "This obj hasn't resets !\n");

}

DO_FUN(do_objlist)
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    FILE *fp;
    OBJ_DATA *obj;
    BUFFER *buf;


    if ((fp = dfopen(TMP_PATH, "objlist.txt", "w+")) == NULL)
    {
        char_act("File error.", ch);
        return;
    }

    buf = buf_new(-1);
    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));

    if (arg1[0] == '\0' || str_prefix(arg1, "sort"))
    {
        fprintf(fp, "This is dump obj, not pIndexObj !!!\n");
        for (obj = object_list; obj != NULL; obj = obj->next)
        {
            if (obj->pIndexData->affected == NULL)
                continue;

            buf_clear(buf);
            buf_printf(buf, "\n#Obj: %s (Vnum : %d) \n",
                       mlstr_mval(obj->short_descr),
                       obj->pIndexData->vnum);
            format_obj(buf, obj, FALSE);
            if (!IS_SET(obj->extra_flags, ITEM_ENCHANTED))
                format_obj_affects(buf, obj->pIndexData->affected,
                                   FOA_F_NODURATION);
            format_obj_affects(buf, obj->affected, 0);
            fprintf(fp, "%s", fix_string(buf_string(buf)));
        }
        char_act("tmp/objlist.txt created, type 'objlist sort {{level|type}' for create sort list obj->pIndexData.", ch);
    } else
    {
        OBJ_INDEX_DATA *pObj;
        int iLevel;
        int iType;
        int iHash;

        if (arg2[0] == '\0' || !str_prefix(arg2, "level"))
        {
            for (iLevel = 0; iLevel < 101; iLevel++)
            {
                buf_printf(buf, "\n\n          >>>>> Level %d <<<<<\n\n", iLevel);
                for (iType = 0; item_types[iType].name; iType++)
                {
                    if (!item_types[iType].settable)
                        continue;
                    buf_printf(buf, "\n\n === Type %s ===\n", item_types[iType].name);
                    for (iHash = 0; iHash < MAX_KEY_HASH; iHash++)
                        for (pObj = obj_index_hash[iHash]; pObj; pObj = pObj->next)
                            if (pObj->level == iLevel && pObj->item_type == item_types[iType].bit)
                            {
                                brief_show_obj_index(pObj, buf);
                                fprintf(fp, "%s", fix_string(buf_string(buf)));
                                buf_clear(buf);
                            }
                }
            }
        } else
        {
            for (iType = 0; item_types[iType].name; iType++)
            {
                if (!item_types[iType].settable)
                    continue;
                buf_printf(buf, "\n\n          >>>>> Type %s <<<<<\n\n", item_types[iType].name);
                for (iLevel = 0; iLevel < 101; iLevel++)
                {
                    buf_printf(buf, "\n\n === Level %d ===\n", iLevel);
                    for (iHash = 0; iHash < MAX_KEY_HASH; iHash++)
                        for (pObj = obj_index_hash[iHash]; pObj; pObj = pObj->next)
                            if (pObj->level == iLevel && pObj->item_type == item_types[iType].bit)
                            {
                                brief_show_obj_index(pObj, buf);
                                fprintf(fp, "%s", fix_string(buf_string(buf)));
                                buf_clear(buf);
                            }
                }
            }
        }

    }
    fclose(fp);
}

/* end objlist from mud.nnov.ru */

DO_FUN(do_hash)
{
    char *crypted;

    if (argument[0] == '\0')
    {
        char_act("Syntax: hash <string>.", ch);
        return;
    }

    crypted = str_crypt(argument);
    char_printf(ch, "Crypted password will be: '%s'.\n", crypted);
}


DO_FUN(do_limited)
{
    extern int top_obj_index;
    OBJ_DATA *obj;
    OBJ_INDEX_DATA *obj_index;
    int lCount = 0;
    int ingameCount;
    int     nMatch;
    int     vnum;

    if (argument[0] != '\0')
    {
        obj_index = get_obj_index(atoi(argument));
        if (obj_index == NULL)
        {
            char_act(" .", ch);
            return;
        }
        if (obj_index->limit == -1)
        {
            char_act("Thats not a limited item.", ch);
            return;
        }
        nMatch = 0;
        ingameCount = 0;
        for (obj=object_list; obj != NULL; obj=obj->next)
            if (obj->pIndexData->vnum == obj_index->vnum)
            {
                ingameCount++;
            }
        char_printf(ch, "%s [%5d]  : %3d  : %s%3d{x (%3d)\n",
                    fmt_color_str(mlstr_mval(obj_index->short_descr), 35),
                    obj_index->vnum,
                    obj_index->limit,
                    (obj_index->count > obj_index->limit) ?
                    "{R" : str_empty,
                    ingameCount,
                    obj_index->count);
        ingameCount = 0;
        for (obj=object_list; obj != NULL; obj=obj->next)
            if (obj->pIndexData->vnum == obj_index->vnum)
            {
                ingameCount++;
                if (obj->carried_by != NULL)
                    char_printf(ch, "  {C %-30s{x\n", obj->carried_by->name);
                else if (obj->in_room != NULL)
                    char_printf(ch, " %-20s [%d]\n",
                                mlstr_cval(obj->in_room->name, ch),
                                obj->in_room->vnum);
                else if (obj->in_obj != NULL)
                    char_printf(ch, " %-20s [%d] \n",
                                mlstr_mval(obj->in_obj->short_descr),
                                obj->in_obj->pIndexData->vnum);
            }
        char_printf(ch, "  %d   . %d    pFiles.\n",
                    ingameCount, obj_index->count-ingameCount);
        return;
    }

    nMatch = 0;
    for (vnum = 0; nMatch < top_obj_index; vnum++)
        if ((obj_index = get_obj_index(vnum)) != NULL)
        {
            nMatch++;
            if (obj_index->limit != -1)
            {
                lCount++;
                ingameCount = 0;
                for (obj=object_list; obj != NULL; obj=obj->next)
                    if (obj->pIndexData->vnum == obj_index->vnum)
                    {
                        ingameCount++;
                    }
                char_printf(ch, "%s [%5d]  : %3d  : %s%3d{x (%3d)\n",
                            fmt_color_str(mlstr_mval(obj_index->short_descr), 37),
                            obj_index->vnum,
                            obj_index->limit,
                            (obj_index->count > obj_index->limit) ?
                            "{R" : str_empty,
                            ingameCount,
                            obj_index->count);
            }
        }
    char_printf(ch, "\n%d  %d  .\n", lCount, nMatch);
}

DO_FUN(do_wiznet)
{
    int flag;

    if (argument[0] == '\0')
    {
        /* show wiznet status */
        BUFFER *output;

        output = buf_new(-1);
        buf_printf(output, "Wiznet status: %s\n",
                   IS_SET(ch->pcdata->wiznet, WIZ_ON) ? "ON" : "OFF");

        buf_add(output, "\n      | ");
        buf_add(output, "\n-----------|-------\n");
        for (flag = 0; wiznet_table[flag].name != NULL; flag++)
            buf_printf(output, "%-11s|  %s\n",
                       wiznet_table[flag].name,
                       wiznet_table[flag].level > ch->level ?
                       "N/A" :
                       IS_SET(ch->pcdata->wiznet,
                              wiznet_table[flag].flag) ?
                       "ON" : "OFF");
        page_to_char(buf_string(output), ch);
        buf_free(output);
        return;
    }

    if (!str_prefix(argument,"on"))
    {
        char_act("Welcome to Wiznet!", ch);
        SET_BIT(ch->pcdata->wiznet, WIZ_ON);
        return;
    }

    if (!str_prefix(argument,"off"))
    {
        char_act("Signing off of Wiznet.", ch);
        REMOVE_BIT(ch->pcdata->wiznet, WIZ_ON);
        return;
    }

    flag = wiznet_lookup(argument);

    if (flag == -1 || ch->level < wiznet_table[flag].level)
    {
        char_act("  .", ch);
        return;
    }

    TOGGLE_BIT(ch->pcdata->wiznet, wiznet_table[flag].flag);
    if (!IS_SET(ch->pcdata->wiznet, wiznet_table[flag].flag))
        char_printf(ch,"You will no longer see %s on wiznet.\n", wiznet_table[flag].name);
    else
        char_printf(ch, "You will now see %s on wiznet.\n", wiznet_table[flag].name);
}

void wiznet_printf(CHAR_DATA *ch, const void *arg,
                   long flag, long flag_skip, int min_level,
                   char* format, ...)
{
    va_list ap;
    DESCRIPTOR_DATA *d;
    char buf[MAX_STRING_LENGTH];
    char buf2[MAX_STRING_LENGTH];
    struct tm *ctm;
    time_t clock;

    va_start(ap, format);
    for (d = descriptor_list; d != NULL; d = d->next)
    {
        CHAR_DATA *vch = d->original ? d->original : d->character;

        if (d->connected != CON_PLAYING
            ||  !vch
            ||  (ch && ch->level == MAX_LEVEL)
            ||  vch->level < LEVEL_IMMORTAL
            ||  !IS_SET(vch->pcdata->wiznet, WIZ_ON)
            ||  (flag && !IS_SET(vch->pcdata->wiznet, flag))
            ||  (flag_skip && IS_SET(vch->pcdata->wiznet, flag_skip))
            ||  vch->level < min_level
            ||  vch == ch)
            continue;

        if (IS_SET(vch->pcdata->wiznet, WIZ_PREFIX))
            act_puts("--> ", vch, NULL, NULL, TO_CHAR | ACT_NOLF, POS_DEAD);

        clock = time(NULL);
        ctm = localtime(&clock);

        if (flag == WIZ_LOGINS
            || flag == WIZ_LINKS
            || flag == WIZ_DEATHS
            || flag == WIZ_LEVELS
            || flag == WIZ_SWITCHES
            || flag == WIZ_SPAM)
        {
            snprintf(buf2, 27, "(%02d:%02d:%02d) [Room: %6d] ", ctm->tm_hour,
                     ctm->tm_min, ctm->tm_sec,
                     ch ? (ch->in_room ? ch->in_room->vnum : 0) : 0);
        } else
        {
            snprintf(buf2, 12, "(%02d:%02d:%02d) ", ctm->tm_hour,
                     ctm->tm_min, ctm->tm_sec);
        }

        act_puts(buf2, vch, NULL, NULL, TO_CHAR | ACT_NOLF, POS_DEAD);

        vsnprintf(buf, sizeof(buf), GETMSG(format, vch->lang), ap);
        act_puts(buf, vch, arg, ch, TO_CHAR , POS_DEAD);
    }
    va_end(ap);
}

DO_FUN(do_tick)
{
    char arg[MAX_INPUT_LENGTH];

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        char_act("tick area : area update", ch);
        char_act("tick char : char update", ch);
        char_act("tick room : room update", ch);
        char_act("tick track: track update", ch);
        char_act("tick obj  : obj update", ch);
        return;
    }
    if (is_name(arg, "area"))
    {
        area_update();
        char_act(" .", ch);
        return;
    }
    if (is_name(arg, "char player"))
    {
        char_update();
        char_act(" .", ch);
        return;
    }
    if (is_name(arg, "room"))
    {
        room_update();
        char_act(" .", ch);
        return;
    }
    if (is_name(arg, "track"))
    {
        track_update();
        char_act(" .", ch);
        return;
    }
    if (is_name(arg, "obj"))
    {
        obj_update();
        char_act(" .", ch);
        return;
    }
    do_tick(ch,str_empty);
    return;
}

/* equips a character */
DO_FUN(do_outfit)
{
    OBJ_DATA *obj;
    OBJ_INDEX_DATA * obj_index;
    AFFECT_DATA af;
    class_t *cl = class_lookup(ch->class);
    int sn,vnum;

    if (IS_NPC(ch) || cl == NULL)
        return;

    if (ch->level > 9
    && !IS_SET(ch->comm, PLR_PEACE))
    {
        char_act("Find it yourself!", ch);
        return;
    }

    if (ch->carry_number + 4 > can_carry_n(ch))
    {
        char_act("Your hands are full.", ch);
        return;
    }

    if ((obj = get_eq_char(ch, WEAR_LIGHT)) == NULL)
    {
        obj_index = get_obj_index(OBJ_VNUM_SCHOOL_BANNER);
        obj = create_obj(obj_index, 0);
        if (obj_index != NULL)
        {
            obj->cost       = 0;
            obj->condition  = 100;
            obj->timer      = 100;

            af.where        = TO_OBJECT;
            af.type         = gsn_unique;
            af.level        = LVL(ch);
            af.duration     = -1;
            af.location     = APPLY_HITROLL;
            af.modifier     = LVL(ch) / 10;
            af.bitvector    = 0;
            affect_to_obj(obj,&af);

            af.location     = APPLY_DAMROLL;
            af.modifier     = LVL(ch) / 20;
            affect_to_obj(obj,&af);

            af.modifier = -5;
            af.location  = APPLY_SAVING_SPELL;
            affect_to_obj(obj,&af);

            af.location = APPLY_HIT;
            af.modifier = LVL(ch) / 2;
            affect_to_obj(obj,&af);

            af.location = APPLY_MANA;
            af.modifier = LVL(ch);
            affect_to_obj(obj,&af);

            obj_to_char(obj, ch);
            equip_char(ch, obj, WEAR_LIGHT);
        }
    }

    if ((obj = get_eq_char(ch, WEAR_BODY)) == NULL)
    {
        obj_index = get_obj_index(OBJ_VNUM_SCHOOL_VEST);
        if (obj_index != NULL)
        {
            obj = create_obj(obj_index, 0);
            obj->cost       = 0;
            obj->condition  = 100;
            obj->timer      = 100;

            af.where        = TO_OBJECT;
            af.type         = gsn_unique;
            af.level        = LVL(ch);
            af.duration     = -1;
            af.location     = APPLY_HITROLL;
            af.modifier     = LVL(ch) / 10;
            af.bitvector    = 0;
            affect_to_obj(obj,&af);

            af.location     = APPLY_DAMROLL;
            af.modifier     = LVL(ch) / 20;
            affect_to_obj(obj,&af);

            af.modifier = -5;
            af.location  = APPLY_SAVING_SPELL;
            affect_to_obj(obj,&af);

            af.location = APPLY_HIT;
            af.modifier = LVL(ch);
            affect_to_obj(obj,&af);

            af.location = APPLY_MANA;
            af.modifier = LVL(ch);
            affect_to_obj(obj,&af);

            obj_to_char(obj, ch);
            equip_char(ch, obj, WEAR_BODY);
        }
    }

    /* do the weapon thing */
    if ((obj = get_eq_char(ch,WEAR_WIELD)) == NULL)
    {
        sn = 0;
        if ((vnum = cl->weapon) == 0)
            vnum = OBJ_VNUM_SCHOOL_SWORD; /* just in case! */
        obj_index = get_obj_index(vnum);
        if (obj_index != NULL)
        {
            obj = create_obj(obj_index, 0);
            obj->condition  = 100;
            obj->timer      = 100;

            af.where        = TO_OBJECT;
            af.type         = gsn_unique;
            af.level        = LVL(ch);
            af.duration     = -1;
            af.location     = APPLY_HITROLL;
            af.modifier     = LVL(ch) / 10;
            af.bitvector    = 0;
            affect_to_obj(obj,&af);

            af.location     = APPLY_DAMROLL;
            af.modifier     = LVL(ch) / 20;
            affect_to_obj(obj,&af);

            obj->value[1] = LVL(ch) / 6;
            obj->value[2] = 9;

            obj_to_char(obj, ch);
            equip_char(ch, obj, WEAR_WIELD);
        }
    }

    if (((obj = get_eq_char(ch,WEAR_WIELD)) == NULL
    || !IS_WEAPON_STAT(obj, WEAPON_TWO_HANDS))
    && (obj = get_eq_char(ch, WEAR_SHIELD)) == NULL)
    {
        obj_index = get_obj_index(OBJ_VNUM_SCHOOL_SHIELD);
        if (obj_index != NULL)
        {
            obj = create_obj(obj_index, 0);
            obj->cost       = 0;
            obj->condition  = 100;
            obj->timer      = 100;

            af.where        = TO_OBJECT;
            af.type         = gsn_unique;
            af.level        = LVL(ch);
            af.duration     = -1;
            af.location     = APPLY_HITROLL;
            af.modifier     = LVL(ch) / 10;
            af.bitvector    = 0;
            affect_to_obj(obj,&af);

            af.location     = APPLY_DAMROLL;
            af.modifier     = LVL(ch) / 10;
            affect_to_obj(obj,&af);

            af.modifier = -5;
            af.location  = APPLY_SAVING_SPELL;
            affect_to_obj(obj,&af);

            af.location = APPLY_HIT;
            af.modifier = LVL(ch) / 2;
            affect_to_obj(obj,&af);

            af.location = APPLY_MANA;
            af.modifier = LVL(ch);
            affect_to_obj(obj,&af);

            af.location = APPLY_MOVE;
            af.modifier = LVL(ch) / 4;
            affect_to_obj(obj,&af);

            obj_to_char(obj, ch);
            equip_char(ch, obj, WEAR_SHIELD);
        }
    }

    char_act("You have been equipped by gods.", ch);
}


DO_FUN(do_smote)
{
    CHAR_DATA *vch;
    const char *letter, *name;
    char last[MAX_INPUT_LENGTH], temp[MAX_STRING_LENGTH];
    int matches = 0;

    if (!IS_NPC(ch) && IS_SET(ch->comm, COMM_NOEMOTE))
    {
        char_act("     .", ch);
        return;
    }

    if (argument[0] == '\0')
    {
        char_act(" ?", ch);
        return;
    }

    if (strstr(argument,ch->name) == NULL)
    {
        char_act("      smote.", ch);
        return;
    }

    char_printf(ch, "%s\n", argument);

    for (vch = ch->in_room->people; vch != NULL; vch = vch->next_in_room)
    {
        if (vch->desc == NULL || vch == ch)
            continue;

        if ((letter = strstr(argument,vch->name)) == NULL)
        {
            char_printf(ch, "%s\n", argument);
            continue;
        }

        strnzcpy(temp, sizeof(temp),argument);
        temp[strlen(argument) - strlen(letter)] = '\0';
        last[0] = '\0';
        name = vch->name;

        for (; *letter != '\0'; letter++)
        {
            if (*letter == '\'' && matches == strlen(vch->name))
            {
                strnzcat(temp, sizeof(temp), "r");
                continue;
            }

            if (*letter == 's' && matches == strlen(vch->name))
            {
                matches = 0;
                continue;
            }

            if (matches == strlen(vch->name))
                matches = 0;

            if (*letter == *name)
            {
                matches++;
                name++;
                if (matches == strlen(vch->name))
                {
                    strnzcat(temp, sizeof(temp), "you");
                    last[0] = '\0';
                    name = vch->name;
                    continue;
                }
                strnzncat(last, sizeof(last), letter, 1);
                continue;
            }

            matches = 0;
            strnzcat(temp, sizeof(temp), last);
            strnzncat(temp, sizeof(temp), letter, 1);
            last[0] = '\0';
            name = vch->name;
        }
        char_printf(ch, "%s\n", temp);
    }
}

DO_FUN(do_bamfin)
{
    if (!IS_NPC(ch))
    {
        if (argument[0] == '\0')
        {
            char_printf(ch, "     '%s'\n",
                        ch->pcdata->bamfin);
            return;
        }

        if (strstr(argument, ch->name) == NULL)
        {
            char_act("    .", ch);
            return;
        }

        free_string(ch->pcdata->bamfin);
        ch->pcdata->bamfin = str_dup(argument);

        char_printf(ch, "       '%s'\n",
                    ch->pcdata->bamfin);
    }
}

DO_FUN(do_bamfout)
{
    if (!IS_NPC(ch))
    {
        if (argument[0] == '\0')
        {
            char_printf(ch, "     '%s'\n",
                        ch->pcdata->bamfout);
            return;
        }

        if (strstr(argument,ch->name) == NULL)
        {
            char_act("     .", ch);
            return;
        }

        free_string(ch->pcdata->bamfout);
        ch->pcdata->bamfout = str_dup(argument);

        char_printf(ch, "     '%s'\n",
                    ch->pcdata->bamfout);
    }
}

DO_FUN(do_deny)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    bool loaded = FALSE;

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        char_act("  ?", ch);
        return;
    }

    if ((victim = gq_findchar(arg)) == NULL)
    {
        loaded = TRUE;
        victim = char_load_special(arg);
    }
    if (victim == NULL)
    {
        char_act("      .", ch);
        return;
    }

    if (IS_NPC(victim))
    {
        char_act("   NPC.", ch);
        return;
    }

    if (victim->level > ch->level)
    {
        char_act("  .", ch);
        if (loaded)
            char_nuke(victim);
        return;
    }

    if (IS_SET(victim->plr_flags, PLR_DENY))
    {
        char_act("   .", ch);
        REMOVE_BIT(victim->plr_flags, PLR_DENY);
        wiznet_printf(ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0,
                      "$N   %s  .", victim->name);
    } else
    {
        SET_BIT(victim->plr_flags, PLR_DENY);
        char_act("      !", victim);
        wiznet_printf(ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0,
                      "$N   %s  .", victim->name);
        char_act("Ok.", ch);
        if (!loaded)
        {
            save_char_obj(victim, FALSE, FALSE);
            stop_fighting(victim, TRUE);
            do_quit(victim, str_empty);
        }
        else
            char_nuke(victim);
    }
}

DO_FUN(do_disconnect)
{
    char arg[MAX_INPUT_LENGTH];
    DESCRIPTOR_DATA *d;
    CHAR_DATA *victim;

    if (ch->level > 100)
    {
        trim_ch(ch);
        return;
    }

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        char_act(" ?", ch);
        return;
    }

    if (is_number(arg))
    {
        int desc;

        desc = atoi(arg);
        for (d = descriptor_list; d != NULL; d = d->next)
        {
            if (d->descriptor == desc)
            {
                close_descriptor(d);
                char_act("Ok.", ch);
                return;
            }
        }
    }

    if ((victim = get_char_world(ch, arg)) == NULL)
    {
        char_act("    .", ch);
        return;
    }

    if (victim->desc == NULL)
    {
        act("$N doesn't have a descriptor.", ch, NULL, victim, TO_CHAR);
        return;
    }

    for (d = descriptor_list; d != NULL; d = d->next)
        if (d == victim->desc)
        {
            close_descriptor(d);
            char_act("Ok.", ch);
            return;
        }

    bug("Do_disconnect: desc not found.", 0);
    char_act("Descriptor not found!", ch);
    return;
}

DO_FUN(do_echo)
{
    DESCRIPTOR_DATA *d;

    if (argument[0] == '\0')
    {
        char_act("Global echo what?", ch);
        return;
    }

    for (d = descriptor_list; d; d = d->next)
        if (d->connected == CON_PLAYING)
        {
            if (d->character->level >= ch->level)
                char_puts("global> ", d->character);
            char_printf(d->character, "%s\n", argument);
        }
}

DO_FUN(do_recho)
{
    DESCRIPTOR_DATA *d;

    if (argument[0] == '\0')
    {
        char_act("Local echo what?", ch);
        return;
    }

    for (d = descriptor_list; d; d = d->next)
        if (d->connected == CON_PLAYING
            &&   d->character->in_room == ch->in_room)
        {
            if (d->character->level >= ch->level)
                char_puts("local> ", d->character);
            char_printf(d->character, "%s\n", argument);
        }
}

DO_FUN(do_zecho)
{
    DESCRIPTOR_DATA *d;

    if (argument[0] == '\0')
    {
        char_act("Zone echo what?", ch);
        return;
    }

    for (d = descriptor_list; d; d = d->next)
        if (d->connected == CON_PLAYING
            &&  d->character->in_room != NULL && ch->in_room != NULL
            &&  d->character->in_room->area == ch->in_room->area)
        {
            if (d->character->level >= ch->level)
                char_puts("zone> ", d->character);
            char_printf(d->character, "%s\n", argument);
        }
}

DO_FUN(do_pecho)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    argument = one_argument(argument, arg, sizeof(arg));

    if (argument[0] == '\0' || arg[0] == '\0')
    {
        char_act("Personal echo what?", ch);
        return;
    }

    if ((victim = get_char_world(ch, arg)) == NULL)
    {
        char_act("  .", ch);
        return;
    }

    if (victim->level >= ch->level && ch->level != MAX_LEVEL-1)
        char_puts("personal> ", victim);

    char_printf(victim, "%s\n", argument);
    char_printf(ch, "personal> %s\n", argument);
}

ROOM_INDEX_DATA *find_location(CHAR_DATA *ch, const char *argument)
{
    CHAR_DATA *victim;
    OBJ_DATA *obj;

    if (is_number(argument))
        return get_room_index(atoi(argument));

    if ((victim = get_char_world(ch, argument)) != NULL)
        return victim->in_room;

    if ((obj = get_obj_world(ch, argument)) != NULL)
        return obj->in_room;

    return NULL;
}

DO_FUN(do_transfer)
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    ROOM_INDEX_DATA *location;
    DESCRIPTOR_DATA *d;
    CHAR_DATA *victim;

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));

    if (arg1[0] == '\0')
    {
        char_act("  ( )?", ch);
        return;
    }

    if (!str_cmp(arg1, "all"))
    {
        for (d = descriptor_list; d != NULL; d = d->next)
            if (d->connected == CON_PLAYING
                &&   d->character != ch
                &&   d->character->in_room != NULL
                &&   can_see(ch, d->character))
                doprintf(do_transfer, ch, "%s %s", d->character->name, arg2);
        return;
    }

    /*
     * Thanks to Grodyn for the optional location parameter.
     */
    if (arg2[0])
    {
        if ((location = find_location(ch, arg2)) == NULL)
        {
            char_act("  .", ch);
            return;
        }

        if (room_is_private(location) && ch->level < MAX_LEVEL-1)
        {
            char_act("That room is private right now.", ch);
            return;
        }
    } else
        location = ch->in_room;

    if ((victim = get_char_world(ch, arg1)) == NULL)
    {
        char_act("  .", ch);
        return;
    }

    if (IS_IMMORTAL(victim) && victim->level > ch->level)
    {
        char_act("  .", ch);
        return;
    }

    if (victim->in_room == NULL)
    {
        char_act("  .", ch);
        return;
    }

    if (victim->fighting != NULL)
        stop_fighting(victim, TRUE);
    act("$n   .", victim, NULL, NULL, TO_ROOM);
    char_from_room(victim);
    char_to_room(victim, location);
    act("$n    .", victim, NULL, NULL, TO_ROOM);
    if (ch != victim)
        act("$n  .", ch, NULL, victim, TO_VICT);
    char_act("Ok.", ch);

    if (JUST_KILLED(victim))
        return;

    do_look(victim, "auto");
}

DO_FUN(do_at)
{
    char arg[MAX_INPUT_LENGTH];
    ROOM_INDEX_DATA *location;
    ROOM_INDEX_DATA *original;
    OBJ_DATA *on;

    argument = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0' || argument[0] == '\0')
    {
        char_act("At where what?", ch);
        return;
    }

    if ((location = find_location(ch, arg)) == NULL)
    {
        char_act("  .", ch);
        return;
    }

    if (room_is_private(location)
        &&  ch->level < MAX_LEVEL-1)
    {
        char_act("That room is private right now.", ch);
        return;
    }

    original = ch->in_room;
    on = ch->on;
    char_from_room(ch);
    char_to_room(ch, location);

    if (JUST_KILLED(ch))
        return;

    interpret(ch, argument);

    if (JUST_KILLED(ch) || ch->extracted)
        return;

    char_from_room(ch);
    char_to_room(ch, original);
    if (JUST_KILLED(ch))
        return;
    ch->on = on;
}

DO_FUN(do_goto)
{
    ROOM_INDEX_DATA *location;
    CHAR_DATA *rch;

    if (argument[0] == '\0')
    {
        char_act("Goto ?", ch);
        return;
    }

    if ((location = find_location(ch, argument)) == NULL)
    {
        char_act("  .", ch);
        return;
    }

    if (ch->level < LEVEL_IMMORTAL)
    {
        AREA_DATA *area;

        if (ch->fighting)
        {
            char_act(" !    !.", ch);
            return;
        }

        if (IS_PUMPED(ch))
        {
            char_act("   ,  .", ch);
            return;
        }
#if 0
        if (!IS_SET(ch->in_room->room_flags, ROOM_PEACE))
        {
            char_act("   ,   .", ch);
            return;
        }
#endif
        if ((area = area_vnum_lookup(location->vnum)) == NULL
            ||  !IS_BUILDER(ch, area))
        {
            char_act("    .", ch);
            return;
        }
    }

    if (ch->fighting != NULL)
        stop_fighting(ch, TRUE);

    for (rch = ch->in_room->people; rch != NULL; rch = rch->next_in_room)
        if (IS_TRUSTED(rch, ch->invis_level))
        {
            if (ch->pcdata != NULL
                &&  ch->pcdata->bamfout[0] != '\0')
                act("$t", ch, ch->pcdata->bamfout,
                    rch, TO_VICT);
            else
                act("$n    .", ch, NULL,
                    rch, TO_VICT);
        }

    char_from_room(ch);
    char_to_room(ch, location);

    for (rch = ch->in_room->people; rch != NULL; rch = rch->next_in_room)
        if (IS_TRUSTED(rch, ch->invis_level))
        {
            if (ch->pcdata != NULL
                &&  ch->pcdata->bamfin[0] != '\0')
                act("$t", ch, ch->pcdata->bamfin, rch, TO_VICT);
            else
                act("$n    .", ch, NULL,
                    rch, TO_VICT);
        }

    if (JUST_KILLED(ch))
        return;

    do_look(ch, "auto");
}

DO_FUN(do_violate)
{
    ROOM_INDEX_DATA *location;
    CHAR_DATA *rch;

    if (argument[0] == '\0')
    {
        char_act("Goto where?", ch);
        return;
    }

    if ((location = find_location(ch, argument)) == NULL)
    {
        char_act("No such location.", ch);
        return;
    }

    if (!room_is_private(location))
    {
        char_act("That room isn't private, use goto.", ch);
        return;
    }

    if (ch->fighting != NULL)
        stop_fighting(ch, TRUE);

    for (rch = ch->in_room->people; rch != NULL; rch = rch->next_in_room)
        if (IS_TRUSTED(rch, ch->invis_level))
        {
            if (ch->pcdata != NULL
                &&  ch->pcdata->bamfout[0] != '\0')
                act("$t", ch, ch->pcdata->bamfout,
                    rch, TO_VICT);
            else
                act("$n    .", ch, NULL,
                    rch, TO_VICT);
        }

    char_from_room(ch);
    char_to_room(ch, location);

    for (rch = ch->in_room->people; rch != NULL; rch = rch->next_in_room)
        if (IS_TRUSTED(rch, ch->invis_level))
        {
            if (ch->pcdata != NULL && ch->pcdata->bamfin[0] != '\0')
                act("$t", ch, ch->pcdata->bamfin, rch, TO_VICT);
            else
                act("$n    .", ch, NULL,
                    rch, TO_VICT);
        }

    if (JUST_KILLED(ch))
        return;
    do_look(ch, "auto");
    return;
}

/* RT to replace the 3 stat commands */

void do_stat (CHAR_DATA *ch, const char *argument)
{
    char arg[MAX_INPUT_LENGTH];
    const char *string;
    OBJ_DATA *obj;
    ROOM_INDEX_DATA *location;
    CHAR_DATA *victim;

    string = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        char_act("Syntax:", ch);
        char_act("  stat <name>", ch);
        char_act("  stat obj <name>", ch);
        char_act("  stat mob <name>", ch);
        char_act("  stat room <number>", ch);
        char_act("  stat desc <number>", ch);
        return;
    }

    if (!str_cmp(arg, "room"))
    {
        do_rstat(ch, string);
        return;
    }

    if (!str_cmp(arg, "obj"))
    {
        do_ostat(ch, string);
        return;
    }

    if (!str_cmp(arg, "char")  || !str_cmp(arg, "mob"))
    {
        do_mstat(ch, string);
        return;
    }

    if (!str_cmp(arg, "desc"))
    {
        do_dstat(ch, string);
        return;
    }

    /* do it the old way */

    obj = get_obj_world(ch, argument);
    if (obj != NULL)
    {
        do_ostat(ch, argument);
        return;
    }

    victim = get_char_world(ch, argument);
    if (victim != NULL)
    {
        do_mstat(ch, argument);
        return;
    }

    location = find_location(ch, argument);
    if (location != NULL)
    {
        do_rstat(ch, argument);
        return;
    }

    char_act("Nothing by that name found anywhere.", ch);
}

void do_rstat (CHAR_DATA * ch, const char * argument)
{
    char arg [MAX_INPUT_LENGTH]  ;
    ROOM_INDEX_DATA   * location ;
    ROOM_HISTORY_DATA * rh       ;
    OBJ_DATA          * obj      ;
    CHAR_DATA         * rch      ;
    BUFFER            * output   ;
    int                 door, i  ;
    bool ok = FALSE ;

    one_argument(argument, arg, sizeof(arg)) ;
    location = (arg[0] == '\0') ? ch->in_room : find_location (ch, arg) ;
    if (location == NULL)
    {
        char_act("No such location.", ch) ;
        return ;
    }

    if (ch->in_room != location &&
        room_is_private(location) && !IS_TRUSTED(ch,IMPLEMENTOR))
    {
        char_act("That room is private right now.", ch) ;
        return ;
    }

    output = buf_new (-1) ;

    buf_printf(output,
               "{c+-------------------------------------------------------------------------+\n"
               "{c| {GVnum:   {W%7d  {GZone:  {w%s  ",
               location->vnum, location->area->name) ;

    mlstr_dump (output, "{GName: {w", location->name) ;

    buf_printf(output,
               "{c| {GSector: {w%s  {GOwner: {w%s\n"
               "{c+-------------------------------------------------------------------------+\n"
               "{c| {GLight: {w%d  {GSpace max/used: {w%d/%d  {GRate heal/mana: {w%d/%d\n"
               "{c+-------------------------------------------------------------------------+\n",
               flag_string(sector_types, location->sector_type),
               !IS_NULLSTR(location->owner) ? location->owner : "none",
               location->light, location->space, count_used_space(location),
               location->heal_rate, location->mana_rate) ;

    if (location->affected_by)
    {
        buf_printf(output, "{c| {GAffected: {y[{Y%s{y]\n",
           fmt_wrap_str (flag_string(raffect_flags, location->affected_by), 60,
           "{c|{Y            ")) ; ok = TRUE ;
    }

    if (location->room_flags)
    {
        buf_printf(output, "{c| {GFlags:    {y[{Y%s{y]\n",
           fmt_wrap_str (flag_string(room_flags, location->room_flags), 60,
           "{c|{Y            ")) ; ok = TRUE ;
    }

    if (ok)
        buf_add(output, "{c+-------------------------------------------------------------------------+\n") ;

    mlstr_dump(output, "{c| {GDescription:\n{w", location->description) ;

    buf_add(output, "{c+-------------------------------------------------------------------------+\n") ;

    if (location->ed != NULL)
    {
        ED_DATA * ed ;

        buf_add(output, "{c| {GExtra desc: {w[{W") ;

        for (i = 0, ed = location->ed ; ed ; ed = ed->next)
        {
            if (i + strlen(ed->keyword) > 59)
            {
                buf_add(output, "\n{c|{W              ") ;
                i = 0 ;
            }

            buf_add(output, ed->keyword) ; i += strlen(ed->keyword) ;
            if (ed->next != NULL)
            {
                buf_add(output, " ") ;
                i++ ;
            }
        }
        buf_add(output, "{w]\n") ;
    }

    buf_add(output, "{c| {GCharacters: {y[{Y") ;
    for (i = 0, rch = location->people ; rch ; rch = rch->next_in_room)
    {
        if (can_see(ch, rch))
        {
            if (i + strlen(rch->name) > 59)
            {
                buf_add(output, "\n{c|{Y              ") ;
                i = 0 ;
            }

            buf_add(output, rch->name) ; i += strlen(rch->name) ;
            if (rch->next_in_room != NULL)
            {
                buf_add(output, " ") ;
                i++ ;
            }
        }
    }
    buf_add(output, "{y]\n") ;

    buf_add(output, "{c| {GObjects:    {y[{Y") ;
    for (i = 0, obj = location->contents ; obj ; obj = obj->next_content)
    {
        if (i + strlen(obj->name) > 59)
        {
            buf_add(output, "\n{c|{Y              ") ;
            i = 0 ;
        }

        buf_add(output, obj->name) ; i += strlen(obj->name) ;
        if (obj->next_content != NULL)
        {
            buf_add(output, " ") ;
            i++ ;
        }
    }
    buf_add(output, "{y]\n") ;

    buf_add(output,
            "{c+-------------------------------------------------------------------------+\n") ;

    for (door = 0 ; door <= 5 ; door++)
    {
        EXIT_DATA * pexit ;

        if ((pexit = location->exit[door]) != NULL)
        {
            buf_printf(output, "{c| {GDoor: {W%-5s {w-> {W%d  {GSize: {W%3d  {GKey: {W%d  {GKwd: {w[%s]\n",
                       capitalize(dir_name[door]),
                       pexit->to_room.r == NULL ? -1 : pexit->to_room.r->vnum,
                       pexit->size, pexit->key,
                       !IS_NULLSTR(pexit->keyword) ? pexit->keyword : str_empty) ;

            buf_printf(output, "{c| {GResets: {y[{Y%s{y]\n",
               fmt_wrap_str (flag_string(exit_flags, pexit->rs_flags), 63,
               "{c|{Y         ")) ;

            buf_printf(output, "{c| {GFlags:  {y[{Y%s{y]\n",
               fmt_wrap_str (flag_string(exit_flags, pexit->exit_info), 63,
               "{c|{Y          ")) ;

            mlstr_dump(output, "{c| {GDescription:{w ", pexit->description) ;
        }
    }

    buf_add(output, "{c+-------------------------------------------------------------------------+\n"
       "{c| {GTracks:\n") ;

    for (rh = location->history; rh != NULL; rh = rh->next)
        buf_printf(output, "{c| {W%s {wtook door {W%i.\n", rh->name, rh->went);

    buf_add(output, "{c+-------------------------------------------------------------------------+\n") ;

    send_to_char(buf_string(output), ch) ;
    buf_free(output) ;
}

void do_ostat (CHAR_DATA * ch, const char * argument)
{
    char arg [MAX_INPUT_LENGTH] ;
    OBJ_DATA * obj    ;
    BUFFER   * output ;
    AFFECT_DATA * paf ;
    int        i ;
    bool ok = FALSE ;

    one_argument(argument, arg, sizeof(arg)) ;

    if (arg[0] == '\0')
    {
        char_act(" .", ch) ;
        return ;
    }

    if ((obj = get_obj_world (ch, argument)) == NULL)
    {
        char_act("    .", ch) ;
        return ;
    }

    output = buf_new (-1) ;

    buf_printf(output,
               "{c+-------------------------------------------------------------------------+\n"
               "{c| {GVnum:  {W%7d  {GName:  {w%s\n"
               "{c| {GRoom:  {W%7d  {GOwner: {w%s  {GCount: {w%d  {GTimer: {w%d  {GLimit: {%c%d\n"
               "{c| {GLevel: {W%7d  {GType:  {w%s  {GResets: {w%d  {GCondition: {w%d\n"
               "{c+-------------------------------------------------------------------------+\n"
               "{c| {GNumber: {w%d  {GCost: {w%d  {GWeight: {w%d/%d/%d\n"
               "{c+-------------------------------------------------------------------------+\n",
               obj->pIndexData->vnum, obj->name,
               obj->in_room == NULL ? 0 : obj->in_room->vnum,
               !IS_NULLSTR(obj->owner) ? obj->owner : "none",
               obj->pIndexData->count, obj->timer,
               obj->pIndexData->limit > 0 ? 'R' : 'w', obj->pIndexData->limit,
               obj->level, flag_string(item_types, obj->pIndexData->item_type),
               obj->pIndexData->reset_num, obj->condition,
               get_obj_number(obj), obj->cost,
               obj->weight, get_obj_weight(obj), get_true_weight(obj)) ;

    buf_printf(output,
               "{c| {GWear:  {y[{Y%s{y]\n",
               fmt_wrap_str (flag_string(wear_flags, obj->wear_flags), 64,
                             "{c|{Y         ")) ;

    buf_printf(output,
               "{c| {GExtra: {y[{Y%s{y]\n",
               fmt_wrap_str (flag_string(extra_flags, obj->extra_flags), 64,
                             "{c|{Y         ")) ;

    buf_add(output,
            "{c+-------------------------------------------------------------------------+\n") ;

    mlstr_dump(output, "{c| {GShort description: {w", obj->short_descr) ;
    mlstr_dump(output, "{c| {GLong description:  {w", obj->description) ;

    if (obj->ed != NULL || obj->pIndexData->ed != NULL)
    {
        ED_DATA * ed ;

        buf_add(output, "{c| {GExtra desc: {w[{W") ;

        for (i = 0, ed = obj->ed ; ed ; ed = ed->next)
        {
            if (i + strlen(ed->keyword) > 59)
            {
                buf_add(output, "\n{c|{W              ") ;
                i = 0 ;
            }

            buf_add(output, ed->keyword) ; i += strlen(ed->keyword) ;
            if (ed->next != NULL)
            {
                buf_add(output, " ") ;
                i++ ;
            }
        }

        for (ed = obj->pIndexData->ed ; ed ; ed = ed->next)
        {
            if (i + strlen(ed->keyword) > 59)
            {
                buf_add(output, "\n{c|{W              ") ;
                i = 0 ;
            }

            buf_add(output, ed->keyword) ; i += strlen(ed->keyword) ;
            if (ed->next != NULL)
            {
                buf_add(output, " ") ;
                i++ ;
            }
        }
        buf_add(output, "{w]\n") ;
    }

    buf_printf(output,
               "{c+-------------------------------------------------------------------------+\n"
               "{c| {GIn room: {w%d  {GIn object: {w%s  {GWearloc: {w%d\n"
               "{c| {GCarried: {w%s\n"
               "{c| {GValues:  {w%d %d %d %d %d\n"
               "{c+-------------------------------------------------------------------------+\n",
               obj->in_room    == NULL ?      0 : obj->in_room->vnum,
               obj->in_obj     == NULL ? "none" : mlstr_mval(obj->in_obj->short_descr),
               obj->wear_loc,
               obj->carried_by == NULL ? "none" :
               can_see(ch,obj->carried_by) ? obj->carried_by->name : "",
               obj->value[0], obj->value[1], obj->value[2], obj->value[3], obj->value[4]) ;

    ok = TRUE ;

    switch (obj->pIndexData->item_type)
    {
    case ITEM_SCROLL:
    case ITEM_POTION:
    case ITEM_PILL:
        buf_printf(output,
                   "{c| {GLevel: {W%d  {GSpells:", obj->value[0]) ;

        for (i = 1 ; i < 5 ; i++)
            if (obj->value[i] >= 0)
                buf_printf (output, " {c'{C%s{c'", skill_name(obj->value[i])) ;
        buf_add(output, "\n") ;
        break ;

    case ITEM_WAND:
    case ITEM_STAFF:
        buf_printf(output,
                   "{c| {GCharges: {W%d/%d  {GLevel: {W%d  {GSpell: {c'{C%s{c'\n",
                   obj->value[1], obj->value[2], obj->value[0],
                   obj->value[3] >= 0 ? skill_name(obj->value[3]) : "unknown") ;
        break ;

    case ITEM_DRINK_CON:
        buf_printf(output,
                   "{c| {GLiquid: {W%s{w-colored {C%s\n",
                   liquid_color(obj->value[2])/*liq_table[obj->value[2]].liq_color*/,
                   liquid_name(obj->value[2])/*liq_table[obj->value[2]].liq_name*/) ;
        break ;

    case ITEM_WEAPON:
        buf_printf(output,
                   "{c| {GWeapon: {W%s  {GDamage: {w%d{Wd{w%d (average {C%d{w) {GType: {C%s\n",
                   flag_string(weapon_class, obj->value[0]),
                   obj->value[1], obj->value[2],
                   (1 + obj->value[2]) * obj->value[1] / 2,
                   attack_table[obj->value[3]].noun) ;

        if (obj->value[4])
            buf_printf(output,
                       "{c| {GFlags:  {y[{Y%s{y]\n",
                       fmt_wrap_str (flag_string(weapon_type2, obj->value[4]), 63,
                                     "{c|          ")) ;
        break ;

    case ITEM_ARMOR:
        buf_printf(output,
                   "{c| {GAC pierce/  bash/ slash/ magic\n"
                   "{c|    {C%6d{G/{C%6d{G/{C%6d{G/{C%6d\n",
                   obj->value[0], obj->value[1], obj->value[2], obj->value[3]) ;
        break ;

    case ITEM_CONTAINER:
        buf_printf(output,
                   "{c| {GCapacity: {w%d  {GMax weight: {w%d  {GMultiplier: {w%d%%\n",
                   obj->value[0], obj->value[3], obj->value[4]) ;

        buf_printf(output,
                   "{c| {GFlags:  {y[{Y%s{y]\n",
                   fmt_wrap_str (flag_string(cont_flags, obj->value[1]), 63,
                                 "{c|          ")) ;
        break ;

    default:
        ok = FALSE ;
        break ;
    }

    if (ok)
        buf_add(output,
                "{c+-------------------------------------------------------------------------+\n") ;

    if (!IS_SET(obj->extra_flags, ITEM_ENCHANTED))
    {
        where_t * w ;

        for (paf = obj->pIndexData->affected ; paf ; paf = paf->next)
        {
            if (paf->location != APPLY_NONE && paf->modifier)
            {
                buf_printf(output,
                           "{c| {GAffects {C%-20s {wby {C%d\n",
                           flag_string(apply_flags, paf->location),
                           paf->modifier);
            }

            if ((w = where_lookup(paf->where)) && paf->bitvector)
            {
                buf_add    (output, "{c| {GAdds {w") ;
                buf_printf (output, w->format,
                            flag_string(w->table, paf->bitvector)) ;
                buf_add    (output, "\n") ;
            }
        }
    }

    for (paf = obj->affected ; paf ; paf = paf->next)
    {
        where_t * w ;

        if (paf->location != APPLY_NONE && paf->modifier)
        {
            buf_printf(output,
                       "{c| {GAffects {C%-20s {wby {C%d{w",
                       flag_string(apply_flags, paf->location),
                       paf->modifier) ;

            if (paf->duration > -1)
                buf_printf(output, " for {C%d{w hours", paf->duration) ;

            buf_add(output, "\n") ;
        }

        if ((w = where_lookup(paf->where)) && paf->bitvector)
        {
            buf_add    (output, "{c| {GAdds {w") ;
            buf_printf (output, w->format,
                        flag_string(w->table, paf->bitvector)) ;
            buf_add    (output, "\n") ;
        }
    }

    if (obj->pIndexData->oprogs_old)
    {
        buf_add(output, "{c| {GObject progs:\n") ;

        for (i = 0 ; i < OPROG_MAX ; i++)
            if (obj->pIndexData->oprogs_old[i] != NULL)
                buf_printf(output, "{c| {G%s: {C%s\n",
                           optype_table[i],
                           oprog_name_lookup(obj->pIndexData->oprogs_old[i])) ;
    }

    buf_printf(output,
               "{c+-------------------------------------------------------------------------+\n"
               "{c| {GDamage condition: {w%d (%s)\n"
               "{c+-------------------------------------------------------------------------+\n",
               obj->condition, get_cond_alias(obj)) ;

    send_to_char(buf_string(output), ch) ;
    buf_free(output) ;
}

void do_mstat (CHAR_DATA * ch, const char * argument)
{
    char buf[MAX_STRING_LENGTH] ;
    char arg[MAX_INPUT_LENGTH]  ;
    AFFECT_DATA * paf ;
    CHAR_DATA   * victim ;
    BUFFER      * output ;
    bool ok = FALSE ;
    bool loaded = FALSE;
    bool super = ch->level >= MAX_LEVEL - 5;
    int i;

    one_argument(argument, arg, sizeof(arg)) ;

    if (arg[0] == '\0')
    {
        char_act(" .", ch) ;
        return ;
    }

    if ((victim = get_char_world(ch, argument)) == NULL)
    {
        char_act("   .", ch) ;
        if (super)
        {
            if ((victim = gq_findchar(arg)) == NULL)
            {
                loaded = TRUE;
                victim = char_load_special(arg);
            }
        }
    }
    if (victim == NULL)
        return;

    if (IS_IMMORTAL(victim) && victim->level > ch->level && !super)
    {
        char_act("  .", ch) ;
        return ;
    }

    output = buf_new(-1) ;

    buf_printf(output,
               "{c+-------------------------------------------------------------------------+\n"
               "{c| {GVnum:  {W%7d  {GZone:  {w%s  {GName: {Y%s %s\n"
               "{c| {GRoom:  {W%7d  {GRace:  {w%s (%s)  {GGroup: {w%d  {GSex: {w%s\n"
               "{c| {GLevel: {W%3d%c(%d)  {GClass: {w%s  {GReligion: {w%s\n"
               "{c+-------------------------------------------------------------------------+\n",
               IS_NPC(victim) ? victim->pIndexData->vnum : 0,
               (IS_NPC(victim) && victim->zone) ? victim->zone->name : "?",
               victim->name,
               (!IS_NPC(victim) && victim->pcdata->title) ? victim->pcdata->title : str_empty,
               victim->in_room == NULL ? 0 : victim->in_room->vnum,
               race_name(victim->race), race_name(ORG_RACE(victim)),
               IS_NPC(victim) ? victim->group : 0,
               flag_string(sex_table, victim->sex),
               victim->level, (victim->aff_level >= 0) ? '+' : '-',
               victim->aff_level, class_name(victim),
               IS_NPC(victim) ? "Chronos" : religion_name(victim->religion)) ;

    if (IS_NPC(victim))
        buf_printf(output,
                   "{c| {GCount: {w%d  {GKilled: {w%d  {GStatus: {w%d\n"
                   "{c+-------------------------------------------------------------------------+\n",
                   victim->pIndexData->count, victim->pIndexData->killed, victim->status) ;


    if (IS_NPC(victim)) snprintf(buf, sizeof(buf), "%d", victim->alignment) ;
    else                snprintf(buf, sizeof(buf), "%s", IS_GOOD(victim)    ? "good"    :
                                 IS_NEUTRAL(victim) ? "neutral" :
                                 IS_EVIL(victim)    ? "evil"    : "unknown") ;

    buf_printf(output,
               "{c| {GStr: {C%2d{c(%2d) {c| {GHp   : {C%5d/%5d {c| {YGold  : %7d\n"
               "{c| {GInt: {C%2d{c(%2d) {c| {GMana : {C%5d/%5d {c| {WSilver: %7d\n"
               "{c| {GWis: {C%2d{c(%2d) {c| {GMoves: {C%5d/%5d {c| {GAlign : {M%s\n"
               "{c| {GDex: {C%2d{c(%2d) {c| {GPr/Tr: {w%5d/%5d {c| {GEthos : {M%s\n"
               "{c| {GCon: {C%2d{c(%2d) {c| {GHr/Dr: {Y%5d/%5d {c| {GExp   : {w%7d\n"
               "{c| {GCha: {C%2d{c(%2d) {c| {GSaves: {W%5d       {c| {CAC pierce/  bash/ slash/ magic\n"
               "{c| {GLck: {C%2d{c(%2d) {c| {GSize : {W%5d       {c|    {w%6d{C/{w%6d{C/{w%6d{C/{w%6d\n"
               "{c+-------------------------------------------------------------------------+\n",
               victim->perm_stat[STAT_STR], get_curr_stat(victim,STAT_STR),
               victim->hit, victim->max_hit, victim->gold,
               victim->perm_stat[STAT_INT], get_curr_stat(victim,STAT_INT),
               victim->mana, victim->max_mana, victim->silver,
               victim->perm_stat[STAT_WIS], get_curr_stat(victim,STAT_WIS),
               victim->move, victim->max_move, buf,
               victim->perm_stat[STAT_DEX], get_curr_stat(victim,STAT_DEX),
               IS_NPC(victim) ? 0 : victim->practice,
               IS_NPC(victim) ? 0 : victim->train,
               IS_NPC(victim) ? "unknown" : flag_string(ethos_table, victim->ethos),
               victim->perm_stat[STAT_CON], get_curr_stat(victim,STAT_CON),
               GET_HITROLL(victim), GET_DAMROLL(victim), victim->exp,
               victim->perm_stat[STAT_CHA], get_curr_stat(victim,STAT_CHA),
               victim->saving_throw,
               victim->perm_stat[STAT_LCK], get_curr_stat(victim,STAT_LCK),
               victim->size, GET_AC(victim, AC_PIERCE), GET_AC(victim, AC_BASH),
               GET_AC(victim, AC_SLASH), GET_AC(victim, AC_EXOTIC)) ;

    if (IS_NPC(victim))
        buf_printf(output,
                   "{c| {GDamage: {w%d{Wd{w%d  {GMessage: {w%s\n"
                   "{c+-------------------------------------------------------------------------+\n",
                   victim->damage[DICE_NUMBER], victim->damage[DICE_TYPE],
                   attack_table[victim->dam_type].noun) ;

    buf_printf(output,
               "{c| {GWimpy: {w%d  {GDeaths: {w%d  {GPosition: {w%s  {GCarry num/weight: {w%d/%ld\n"
               "{c+-------------------------------------------------------------------------+\n",
               victim->wimpy, IS_NPC(victim) ? 0 : victim->pcdata->death,
               flag_string(position_table, victim->position),
               victim->carry_number, get_carry_weight(victim) / 10) ;

    if (!IS_NPC(victim))
    {
        buf_printf(output,
                   "{c| {GThirst: {w%d  {GHunger: {w%d  {GFull: {w%d  {GDrunk: {w%d  {GBloodlust: {w%d  {GDesire: {w%d\n"
                   "{c+-------------------------------------------------------------------------+\n"
                   "{c| {GPC killed/died: {R%d{w/{W%d\n"
                   "{c| {GBank gold/silv: {Y%d{w/{W%d  {GLimit timer: {R%d\n"
                   "{c| {GPlayed (hours): {w%d  {GClan status: ",
                   victim->pcdata->condition[COND_THIRST],
                   victim->pcdata->condition[COND_HUNGER],
                   victim->pcdata->condition[COND_FULL],
                   victim->pcdata->condition[COND_DRUNK],
                   victim->pcdata->condition[COND_BLOODLUST],
                   victim->pcdata->condition[COND_DESIRE],
                   victim->pcdata->pc_killed, victim->pcdata->pc_died,
                   victim->pcdata->bank_g, victim->pcdata->bank_s,
                   victim->pcdata->limit_timer,
                   (int) (victim->played + current_time - victim->logon) / 3600) ;

        switch (victim->pcdata->clan_status)
        {
        case CLAN_LEADER:   buf_add(output, "{WLeader")   ; break ;
        case CLAN_SECOND:   buf_add(output, "{YSecond")   ; break ;
        case CLAN_ELITE:    buf_add(output, "{CElite")    ; break ;
        case CLAN_VETERAN:  buf_add(output, "{CVeteran")  ; break ;
        case CLAN_COMMONER: buf_add(output, "{wCommoner") ; break ;
        case CLAN_NEWBIE:   buf_add(output, "{wNewbie")   ; break ;
        default:            buf_add(output, "{wNone")     ; break ;
        }

        buf_add(output,
                "\n{c+-------------------------------------------------------------------------+\n");
    }

    buf_printf(output,
               "{c| {GMaster: {w%s  {GLeader: {w%s  {GPet: {w%s\n"
               "{c+-------------------------------------------------------------------------+\n",
               victim->master ? victim->master->name : "none",
               victim->leader ? victim->leader->name : "none",
               victim->pet    ? victim->pet->name    : "none");

    if (!IS_NPC(victim))
        buf_printf(output,
                   "{c| {GPlr:  {y[{Y%s{y]\n",
                   fmt_wrap_str (flag_string(plr_flags, victim->plr_flags), 64,
                                 "{c|{Y        ")) ;

    if (victim->affected_by)
        buf_printf(output,
                   "{c| {GAff:  {y[{Y%s{y]\n",
                   fmt_wrap_str (flag_string(affect_flags, victim->affected_by), 64,
                                 "{c|{Y        ")) ;

    if (victim->comm)
        buf_printf(output,
                   "{c| {GComm: {m[{M%s{m]\n",
                   fmt_wrap_str (flag_string(comm_flags, victim->comm), 64,
                                 "{c|{M        ")) ;

   if (!IS_NPC(victim))
        if (victim->pcdata->wishes)
             buf_add(output, wish_list (victim, 64));

    if (IS_NPC(victim) && victim->pIndexData->off_flags)
        buf_printf(output,
                   "{c| {GOff:  {w[{W%s{w]\n",
                   fmt_wrap_str (flag_string(off_flags, victim->pIndexData->off_flags), 64,
                                 "{c|{W        ")) ;
    if (victim->immunes)
        buf_printf(output,
                   "{c| {GImm:  {w[{W%s{w]\n",
                   fmt_wrap_str (flag_string(imm_flags, victim->immunes), 64,
                                 "{c|{W        ")) ;

    for (i = 0; i < MAX_DAM; i++)
    {
        if (victim->resists[i])
        {
            buf_printf(output, "{c| {GRes:  {b[{B%-16.16s:%4d%%{b]\n",
                   flag_string(dam_flags, i), victim->resists[i]);
        }
    }

    buf_printf(output,
               "{c+-------------------------------------------------------------------------+\n"
               "{c| {GForm: {y[{Y%s{y]\n",
               fmt_wrap_str(flag_string(form_flags, victim->form),  64, "{c|{Y        ")) ;

    buf_printf(output,
               "{c| {GPart: {y[{Y%s{y]\n"
               "{c+-------------------------------------------------------------------------+\n",
               fmt_wrap_str (flag_string(part_flags, victim->parts), 64, "{c|{Y        ")) ;

    if (IS_NPC(victim))
    {
        mlstr_dump(output,
                   "{c| {GShort description:{w ", victim->short_descr) ;

        mlstr_dump(output,
                   "{c| {GLong description:\n{w", victim->long_descr) ;

        if (victim->spec_fun != 0)
            buf_printf(output,
                       "{c| {GMobile has special procedure:{w %s\n",
                       spec_name(victim->spec_fun)) ;

        buf_add(output,
                "{c+-------------------------------------------------------------------------+\n") ;
    }

    for (paf = victim->affected ; paf != NULL ; paf = paf->next)
    {
        char color   ;
        char word[6] ;

        switch (paf->where)
        {
        case TO_RESIST: color = 'B' ; strnzcpy(word, sizeof(word), "res_")  ; break ;
        default:        color = 'W' ; strnzcpy(word, sizeof(word), str_empty)      ; break ;
        }

        // header
        if (!ok)
            buf_printf(output,
                       "{c| {GSpell:                {GLocation:        {GBy: {GHours: {GLvl: {GBitvector:\n");

        buf_printf(output,
                   "{c| {C%-21.21s {C%-13.13s {C%6d {C%6d {C%4d {%c%-s%-s\n",
                   skill_name(paf->type), flag_string(apply_flags, paf->location),
                   paf->modifier, paf->duration, paf->level, color, word,
                   paf->where == TO_RESIST
                ? flag_string(dam_flags, paf->bitvector)
                : flag_string(affect_flags, paf->bitvector));

        ok = TRUE ;
    }

    if (ok)
        buf_add(output,
                "{c+-------------------------------------------------------------------------+\n") ;

    if (!IS_NPC(victim))
    {
        qtrouble_t * qt ;
        int i ;

        if (IS_ON_QUEST(victim))
        {
            buf_printf(output,
                       "{c| {GQuest Giver: {Y%d  {GQuest Points: {Y%d  {GQuest Next: {Y%d\n",
                       victim->pcdata->questgiver,
                       victim->pcdata->questpoints,
                       victim->pcdata->questtime < 0 ?
                       -victim->pcdata->questtime : 0) ;

            buf_printf(output,
                       "{c| {GQuest Count: {Y%d  {GQuest Obj: {Y%d  {GQuest Mob: {Y%d\n",
                       victim->pcdata->questtime > 0 ?
                       victim->pcdata->questtime : 0,
                       victim->pcdata->questobj,
                       victim->pcdata->questmob) ;
        } else
        {
            buf_printf(output,
                       "{c| {GQuest Points: {Y%d  {GQuestnext: {Y%d  {WNOT QUESTING\n",
                       victim->pcdata->questpoints,
                       victim->pcdata->questtime < 0 ?
                       -victim->pcdata->questtime : 0) ;
        }

        buf_add(output, "{c| {GQuest Troubles: ") ;
        for (i = 0, qt = victim->pcdata->qtrouble ; qt ; qt = qt->next)
        {
            snprintf(buf, sizeof(buf), "{y[{Y%d{y]{w-{y[{Y%d{y]", qt->vnum, qt->count-1) ;

            if (i + strlen (buf) > 98)
            {
                buf_add(output, "\n{c|                 ") ;
                i = 0 ;
            }

            buf_add(output, buf) ;
            buf_add(output, " ") ;

            i += strlen (buf + 1) ;
        }
        buf_add(output, "\n") ;
        buf_printf(output,
                   "{c| {GQpBalance: {Y%d                                      \n",
                  victim->pcdata->qpbalance);

        buf_printf(output,
                   "{c| {GBonus Points: {Y%d                                   \n",
                   victim->pcdata->bonuspoints);

        buf_printf(output,
                   "{c+-------------------------------------------------------------------------+\n"
                   "{c| {RSecurity: {W%d\n", victim->pcdata->security) ;

        if (!IS_NULLSTR(victim->pcdata->granted))
            buf_printf(output,
                       "{c| {RGranted:  {w[{W%s{w]\n",
                       fmt_wrap_str ((char *)victim->pcdata->granted, 61, "{c|{W            ")) ;

        if (victim->pcdata->freeze  + victim->pcdata->nochan +
            victim->pcdata->nocast + victim->pcdata->notell +
            victim->pcdata->noemote + victim->pcdata->nonote +
            victim->pcdata->noquest  + victim->pcdata->plevels > 0)
        {
            int ok = FALSE ;
            buf_add(output, "{c| {RPenalty:  ") ;

            if (victim->pcdata->freeze > 0)
            {
                buf_printf(output, "{Wfreeze  {wuntil %s\n", strtime(victim->pcdata->freeze)) ;
                ok = TRUE ;
            }

            if (victim->pcdata->nochan > 0)
            {
                if (ok) buf_add(output, "{c|           ") ;
                buf_printf(output, "{Wnochan  {wuntil %s\n", strtime(victim->pcdata->nochan)) ;
                ok = TRUE ;
            }

            if (victim->pcdata->notell > 0)
            {
                if (ok) buf_add(output, "{c|           ") ;
                buf_printf(output, "{Wnotell  {wuntil %s\n", strtime(victim->pcdata->notell)) ;
                ok = TRUE ;
            }

            if (victim->pcdata->noquest > 0)
            {
                if (ok) buf_add(output, "{c|           ") ;
                buf_printf(output, "{Wnoquest  {wuntil %s\n", strtime(victim->pcdata->noquest)) ;
                ok = TRUE ;
            }

            if (victim->pcdata->nonote > 0)
            {
                if (ok) buf_add(output, "{c|           ") ;
                buf_printf(output, "{Wnonote  {wuntil %s\n", strtime(victim->pcdata->nonote)) ;
                ok = TRUE ;
            }

            if (victim->pcdata->nocast > 0)
            {
                if (ok) buf_add(output, "{c|           ") ;
                buf_printf(output, "{Wnocast {wuntil %s\n", strtime(victim->pcdata->nocast)) ;
                ok = TRUE ;
            }

            if (victim->pcdata->noemote > 0)
            {
                if (ok) buf_add(output, "{c|           ") ;
                buf_printf(output, "{Wnoemote {wuntil %s\n", strtime(victim->pcdata->noemote)) ;
                ok = TRUE ;
            }

            if (victim->pcdata->plevels > 0)
            {
                if (ok) buf_add(output, "{c|           ") ;
                buf_printf(output, "{Wpenalty levels {wby %d\n", victim->pcdata->plevels) ;
            }
        }

        if (!IS_NULLSTR(victim->pcdata->twitlist))
            buf_printf(output,
                       "{c| {GTwitlist: {c[{C%s{c]\n",
                       fmt_wrap_str ((char *)victim->pcdata->twitlist, 61, "{c|{C            ")) ;

        buf_add(output,
                "{c+-------------------------------------------------------------------------+\n") ;
    }

    buf_printf(output,
               "{c| {GLast fought: {w%s  {GLast fight time: {w%d  {RFighting: {w%s\n",
               victim->last_fought ? victim->last_fought->name : "none",
               victim->last_fight_time <= 0 ? -1 : current_time - victim->last_fight_time,
               victim->fighting ? victim->fighting->name : "none") ;

    if (IS_PUMPED(victim))
        buf_add(output,
                "{c| {RAdrenalin is gushing.\n") ;

    buf_printf(output,
               "{c| {GIn_mind: {y[{Y%s{y]\n"
               "{c+-------------------------------------------------------------------------+{x\n",
               victim->in_mind ? victim->in_mind : "none") ;

    page_to_char(buf_string(output), ch) ;
    buf_free(output);
    if (loaded)
        char_nuke(victim);
}

DO_FUN(do_dstat)
{
    BUFFER *output;
    DESCRIPTOR_DATA *d;
    char arg[MAX_INPUT_LENGTH];
    int desc;

    one_argument(argument, arg, sizeof(arg));

    desc = atoi(arg);
    for (d = descriptor_list; d; d = d->next)
        if (d->descriptor == desc)
            break;
    if (!d)
    {
        char_act("dstat: descriptor not found", ch);
        return;
    }

    output = buf_new(-1);

    buf_printf(output, "Desc: [%d]  Conn: [%d]  "
               "Outsize: [%d]  Outtop:  [%d]\n",
               d->descriptor, d->connected, d->outsize, d->outtop);
    buf_printf(output, "Inbuf: [%s]\n", d->inbuf);
    buf_printf(output, "Incomm: [%s]\n", d->incomm);
    buf_printf(output, "Repeat: [%d]  Inlast: [%s]\n",
               d->repeat, d->inlast);
    if (d->character)
        buf_printf(output, "Ch: [%s]\n", d->character->name);
    if (d->original)
        buf_printf(output, "Original: [%s]\n", d->original->name);
    if (d->pString)
        buf_printf(output, "pString: [%s]\n", *d->pString);
    if (d->showstr_head)
        buf_printf(output, "showstr_head: [%s]\n", d->showstr_head);

    page_to_char(buf_string(output), ch);
    buf_free(output);
}

DO_FUN(do_vnum)
{
    char arg[MAX_INPUT_LENGTH];
    const char *string;

    string = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Syntax:", ch);
        char_act("  vnum obj <name>", ch);
        char_act("  vnum mob <name>", ch);
        return;
    }

    if (!str_cmp(arg, "obj"))
    {
        do_ofind(ch, string);
        return;
    }

    if (!str_cmp(arg, "mob") || !str_cmp(arg, "char"))
    {
        do_mfind(ch, string);
        return;
    }

    /* do both */
    do_mfind(ch, argument);
    do_ofind(ch, argument);
}

DO_FUN(do_mfind)
{
    extern int top_mob_index;
    char arg[MAX_INPUT_LENGTH];
    MOB_INDEX_DATA *pMobIndex;
    int vnum;
    int nMatch;
    bool found;

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        char_act("Find whom?", ch);
        return;
    }

    found   = FALSE;
    nMatch  = 0;

    /*
     * Yeah, so iterating over all vnum's takes 10,000 loops.
     * Get_mob_index is fast, and I don't feel like threading another link.
     * Do you?
     * -- Furey
     */
    for (vnum = 0; nMatch < top_mob_index; vnum++)
        if ((pMobIndex = get_mob_index(vnum)) != NULL)
        {
            nMatch++;
            if (is_name(argument, pMobIndex->name))
            {
                found = TRUE;
                char_printf(ch, "[%5d] %s\n", pMobIndex->vnum,
                            mlstr_mval(pMobIndex->short_descr));
            }
        }

    if (!found)
        char_act("No mobiles by that name.", ch);
}

DO_FUN(do_ofind)
{
    extern int top_obj_index;
    char arg[MAX_INPUT_LENGTH];
    OBJ_INDEX_DATA *pObjIndex;
    int vnum;
    int nMatch;
    bool found;

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0')
    {
        char_act("Find what?", ch);
        return;
    }

    found   = FALSE;
    nMatch  = 0;

    /*
     * Yeah, so iterating over all vnum's takes 10,000 loops.
     * Get_obj_index is fast, and I don't feel like threading another link.
     * Do you?
     * -- Furey
     */
    for (vnum = 0; nMatch < top_obj_index; vnum++)
        if ((pObjIndex = get_obj_index(vnum)) != NULL)
        {
            nMatch++;
            if (is_name(argument, pObjIndex->name))
            {
                found = TRUE;
                char_printf(ch, "[%5d] %s\n", pObjIndex->vnum,
                            mlstr_mval(pObjIndex->short_descr));
            }
        }

    if (!found)
        char_act("No objects by that name.", ch);
}

DO_FUN(do_owhere)
{
    BUFFER *buffer = NULL;
    OBJ_DATA *obj;
    OBJ_DATA *in_obj;
    int number = 0, max_found = 200;
    int vnum = 0;

    if (argument[0] == '\0')
    {
        char_act("Find what?", ch);
        return;
    }

    if (is_number(argument))
        vnum = atoi(argument);

    for (obj = object_list; obj != NULL; obj = obj->next)
    {
        if (!can_see_obj(ch, obj) || (!vnum && !is_name(argument, obj->name))
            || (vnum && vnum != obj->pIndexData->vnum) || (ch->level < obj->level && !IS_IMMORTAL(ch)))
            continue;

        if (buffer == NULL)
            buffer = buf_new(-1);
        number++;

        for (in_obj = obj; in_obj->in_obj != NULL;
            in_obj = in_obj->in_obj)
            ;

        if (in_obj->carried_by != NULL
            &&  can_see(ch,in_obj->carried_by)
            &&  in_obj->carried_by->in_room != NULL)
            buf_printf(buffer,
                       "%3d) %s is carried by %s [Room %d]\n",
                       number,
                       mlstr_mval(obj->short_descr),
                       fix_short(PERS(in_obj->carried_by, ch)),
                       in_obj->carried_by->in_room->vnum);
        else if (in_obj->in_room != NULL
                 &&  can_see_room(ch, in_obj->in_room))
            buf_printf(buffer, "%3d) %s is in %s [Room %d]\n",
                       number, mlstr_mval(obj->short_descr),
                       mlstr_cval(in_obj->in_room->name, ch),
                       in_obj->in_room->vnum);
        else
        {
            if (auction.item != NULL && auction.item == obj)
                buf_printf(buffer, "%3d) %s is on auction\n", number,
                           mlstr_mval(obj->short_descr));
            else
                buf_printf(buffer, "%3d) %s is somewhere\n", number,
                           mlstr_mval(obj->short_descr));
        }

        if (number >= max_found)
            break;
    }

    if (buffer == NULL)
        char_act("Nothing like that in heaven or earth.", ch);
    else
    {
        page_to_char(buf_string(buffer),ch);
        buf_free(buffer);
    }
}

DO_FUN(do_mwhere)
{
    BUFFER *buffer;
    CHAR_DATA *victim;
    int count = 0, vnum = 0;

    if (argument[0] == '\0')
    {
        DESCRIPTOR_DATA *d;

        /* show characters logged */

        buffer = buf_new(-1);
        for (d = descriptor_list; d != NULL; d = d->next)
        {
            if (d->character != NULL && d->connected == CON_PLAYING
                &&  d->character->in_room != NULL && can_see(ch,d->character)
                &&  can_see_room(ch,d->character->in_room))
            {
                victim = d->character;
                count++;
                if (d->original != NULL)
                    buf_printf(buffer,"%3d) %s (in the body of %s) is in %s [%d]\n",
                               count, d->original->name,
                               mlstr_mval(victim->short_descr),
                               mlstr_mval(victim->in_room->name),
                               victim->in_room->vnum);
                else
                    buf_printf(buffer,"%3d) %s is in %s [%d]\n",
                               count, victim->name,
                               mlstr_mval(victim->in_room->name),
                               victim->in_room->vnum);
            }
        }

        page_to_char(buf_string(buffer),ch);
        buf_free(buffer);
        return;
    }

    buffer = NULL;
    if (is_number(argument))
        vnum = atoi(argument);

    for (victim = char_list; victim; victim = victim->next)
        if (victim->in_room
            && ((!vnum && is_name(argument, victim->name))
                || (vnum && IS_NPC(victim) && vnum == victim->pIndexData->vnum)))
        {
            if (buffer == NULL)
                buffer = buf_new(-1);

            count++;
            buf_printf(buffer, "%3d) [%5d] %-28s [%5d] %s\n",
                       count, IS_NPC(victim) ? victim->pIndexData->vnum : 0,
                       IS_NPC(victim) ?
                       mlstr_mval(victim->short_descr) : victim->name,
                       victim->in_room->vnum,
                       mlstr_mval(victim->in_room->name));
        }

    if (buffer)
    {
        page_to_char(buf_string(buffer),ch);
        buf_free(buffer);
    } else
        act("You didn't find any $T.", ch, NULL, argument, TO_CHAR);
}

DO_FUN(do_reboo)
{
    char_act("If you want to REBOOT, spell it out.", ch);
}

DO_FUN(do_shutdow)
{
    char_act("If you want to SHUTDOWN, spell it out.", ch);
}

DO_FUN(do_shutdown)
{
    char buf[MAX_STRING_LENGTH];
    if (ch->level > 100)
    {
        trim_ch(ch);
        return;
    }

    if (reboot_counter > 0)
        char_printf(ch, "Shutdown in %i ticks.\n", reboot_counter);
    else
        char_act("Shutdown after next reboot.", ch);
    snprintf(buf, sizeof(buf), "Shutdown by %s.", ch->name);
    append_file(ch, SHUTDOWN_FILE, buf);
    log(buf);
}

DO_FUN(do_protect)
{
    CHAR_DATA *victim;

    if (argument[0] == '\0')
    {
        char_act("Protect whom from snooping?", ch);
        return;
    }

    if ((victim = get_char_world(ch,argument)) == NULL)
    {
        char_act("You can't find them.", ch);
        return;
    }

    if (IS_SET(victim->comm,COMM_SNOOP_PROOF))
    {
        act_puts("$N is no longer snoop-proof.", ch, NULL, victim, TO_CHAR, POS_DEAD);
//        char_act("Your snoop-proofing was just removed.", victim);
        REMOVE_BIT(victim->comm, COMM_SNOOP_PROOF);
    } else
    {
        act_puts("$N is now snoop-proof.", ch, NULL, victim, TO_CHAR, POS_DEAD);
//        char_act("You are now immune to snooping.", victim);
        SET_BIT(victim->comm, COMM_SNOOP_PROOF);
    }
}

DO_FUN(do_snoop)
{
    char arg[MAX_INPUT_LENGTH];
    DESCRIPTOR_DATA *d;
    CHAR_DATA *victim;

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Snoop whom?", ch);
        return;
    }

    if ((victim = get_char_world(ch, arg)) == NULL)
    {
        char_act("They aren't here.", ch);
        return;
    }

    if (victim->desc == NULL)
    {
        char_act("No descriptor to snoop.", ch);
        return;
    }

    if (victim == ch)
    {
        char_act("Cancelling all snoops.", ch);
        wiznet("$N stops being such a snoop.", ch, NULL, WIZ_SNOOPS,
               WIZ_SECURE, ch->level);
        for (d = descriptor_list; d != NULL; d = d->next)
            if (d->snoop_by == ch->desc)
                d->snoop_by = NULL;
        return;
    }

    if (victim->desc->snoop_by != NULL)
    {
        char_act("Busy already.", ch);
        return;
    }

    if (!is_room_owner(ch,victim->in_room)
        &&  ch->in_room != victim->in_room
        &&  room_is_private(victim->in_room)
        &&  !IS_TRUSTED(ch, IMPLEMENTOR))
    {
        char_act("That character is in a private room.", ch);
        return;
    }

    if ((victim->level >= ch->level
         ||  (IS_SET(victim->comm, COMM_SNOOP_PROOF))) && !IS_TRUSTED(ch, IMPLEMENTOR))
    {
        char_act("You failed.", ch);
        return;
    }

    if (ch->desc != NULL)
        for (d = ch->desc->snoop_by; d != NULL; d = d->snoop_by)
            if (d->character == victim || d->original == victim)
            {
                char_act("No snoop loops.", ch);
                return;
            }

    victim->desc->snoop_by = ch->desc;
    wiznet_printf(ch, NULL, WIZ_SNOOPS, WIZ_SECURE, ch->level,
                  "$N starts snooping on %s",
                  (IS_NPC(ch) ?
                   mlstr_mval(victim->short_descr) : victim->name));
    char_act("Ok.", ch);
}

DO_FUN(do_switch)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Switch into whom?", ch);
        return;
    }

    if (ch->desc == NULL)
        return;

    if (ch->desc->original != NULL)
    {
        char_act("You are already switched.", ch);
        return;
    }

    if ((victim = get_char_world(ch, arg)) == NULL)
    {
        char_act("They aren't here.", ch);
        return;
    }

    if (victim == ch)
    {
        char_act("Ok.", ch);
        return;
    }

    if (!IS_NPC(victim))
    {
        char_act("You can only switch into mobiles.", ch);
        return;
    }

    if (!is_room_owner(ch,victim->in_room)
        &&  ch->in_room != victim->in_room
        &&  room_is_private(victim->in_room)
        &&  !IS_TRUSTED(ch,IMPLEMENTOR))
    {
        char_act("That character is in a private room.", ch);
        return;
    }

    if (victim->desc != NULL)
    {
        char_act("Character in use.", ch);
        return;
    }

    wiznet_printf(ch, NULL, WIZ_SWITCHES, WIZ_SECURE, ch->level,
                  "$N switches into %s", mlstr_mval(victim->short_descr));

    ch->desc->character = victim;
    ch->desc->original  = ch;
    victim->desc        = ch->desc;
    ch->desc            = NULL;
    /* change communications to match */
    if (ch->prompt != NULL)
        victim->prompt = str_dup(ch->prompt);
    victim->comm = ch->comm;
    victim->lines = ch->lines;
    char_act("Ok.", victim);
}

DO_FUN(do_return)
{
    if (ch->desc == NULL)
        return;

    if (ch->desc->original == NULL)
        return;

    char_act("You return to your original body.", ch);

    if (ch->prompt != NULL)
    {
        free_string(ch->prompt);
        ch->prompt = NULL;
    }

    wiznet_printf(ch->desc->original, 0, WIZ_SWITCHES, WIZ_SECURE,
                  ch->level, "$N returns from %s.",
                  mlstr_mval(ch->short_descr));
    ch->desc->character       = ch->desc->original;
    ch->desc->original        = NULL;
    ch->desc->character->desc = ch->desc;
    ch->desc                  = NULL;

    do_replay(ch, str_empty);
}

/* trust levels for load and clone */
bool obj_check(CHAR_DATA *ch, OBJ_DATA *obj)
{
    if (IS_TRUSTED(ch, GOD)
        || (IS_TRUSTED(ch, IMMORTAL) && obj->level <= 20 && obj->cost <= 1000)
        || (IS_TRUSTED(ch, DEMI)     && obj->level <= 10 && obj->cost <= 500)
        || (IS_TRUSTED(ch, ANGEL)    && obj->level <=  5 && obj->cost <= 250)
        || (IS_TRUSTED(ch, AVATAR)   && obj->level ==  0 && obj->cost <= 100))
        return TRUE;
    else
        return FALSE;
}

bool mob_check(CHAR_DATA *ch, CHAR_DATA *mob)
{
    if ((mob->level > 20 && !IS_TRUSTED(ch, GOD))
        ||  (mob->level > 10 && !IS_TRUSTED(ch, IMMORTAL))
        ||  (mob->level >  5 && !IS_TRUSTED(ch, DEMI))
        ||  (mob->level >  0 && !IS_TRUSTED(ch, ANGEL))
        ||  !IS_TRUSTED(ch, AVATAR))
        return FALSE;
    else
        return TRUE;
}

/* for clone, to insure that cloning goes many levels deep */
void recursive_clone(CHAR_DATA *ch, OBJ_DATA *obj, OBJ_DATA *clone)
{
    OBJ_DATA *c_obj, *t_obj;
    for (c_obj = obj->contains; c_obj != NULL; c_obj = c_obj->next_content)
        if (obj_check(ch, c_obj))
        {
            t_obj = create_obj(c_obj->pIndexData, 0);
            clone_obj(c_obj, t_obj);
            obj_to_obj(t_obj, clone);
            recursive_clone(ch, c_obj, t_obj);
        }
}

/* command that is similar to load */
DO_FUN(do_clone)
{
    char arg[MAX_INPUT_LENGTH];
    const char *rest;
    CHAR_DATA *mob;
    OBJ_DATA  *obj;

    if (IS_NPC(ch))
        return;

    rest = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Clone what?", ch);
        return;
    }

    if (!str_prefix(arg,"object"))
    {
        mob = NULL;
        obj = get_obj_here(ch, rest);
        if (obj == NULL)
        {
            char_act("You don't see that here.", ch);
            return;
        }
    } else if (!str_prefix(arg,"mobile") || !str_prefix(arg,"character"))
    {
        obj = NULL;
        mob = get_char_room(ch, rest);
        if (mob == NULL)
        {
            char_act("You don't see that here.", ch);
            return;
        }
    } else
    { /* find both */
        mob = get_char_room(ch, argument);
        obj = get_obj_here(ch, argument);
        if (mob == NULL && obj == NULL)
        {
            char_act("You don't see that here.", ch);
            return;
        }
    }

    /* clone an object */
    if (obj)
    {
        OBJ_DATA *clone;

        if (!obj_check(ch,obj))
        {
            char_act("You haven't enough power.", ch);
            return;
        }

        clone = create_obj(obj->pIndexData, 0);
        clone_obj(obj, clone);
        if (obj->carried_by != NULL)
            obj_to_char(clone, ch);
        else
            obj_to_room(clone, ch->in_room);
        recursive_clone(ch, obj, clone);

        act("$n has created $p.", ch,clone,NULL,TO_ROOM);
        act("You clone $p.", ch,clone,NULL,TO_CHAR);
        wiznet("$N clones $p.", ch,clone,WIZ_LOAD,WIZ_SECURE,ch->level);
        return;
    } else if (mob != NULL)
    {
        CHAR_DATA *clone;
        OBJ_DATA *new_obj;

        if (!IS_NPC(mob))
        {
            char_act("You can only clone mobiles.", ch);
            return;
        }

        if (!mob_check(ch, mob))
        {
            char_act("You haven't enough power.", ch);
            return;
        }

        clone = create_mob(mob->pIndexData);
        clone_mob(mob,clone);

        for (obj = mob->carrying; obj != NULL; obj = obj->next_content)
            if (obj_check(ch,obj))
            {
                new_obj = create_obj(obj->pIndexData, 0);
                clone_obj(obj, new_obj);
                recursive_clone(ch, obj, new_obj);
                obj_to_char(new_obj, clone);
                new_obj->wear_loc = obj->wear_loc;
            }
        char_to_room(clone, ch->in_room);
        act("$n has created $N.", ch, NULL, clone, TO_ROOM);
        act("You clone $N.", ch, NULL, clone, TO_CHAR);
        wiznet_printf(ch, NULL, WIZ_LOAD, WIZ_SECURE, ch->level,
                      "$N clones %s.", mlstr_mval(clone->short_descr));
    }
}

/* RT to replace the two load commands */

DO_FUN(do_load)
{
    char arg[MAX_INPUT_LENGTH];

    if (ch->level > 100)
    {
        trim_ch(ch);
        return;
    }
    if (IS_NPC(ch))
        return;

    argument = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Syntax:", ch);
        char_act("  load mob <vnum>", ch);
        char_act("  load obj <vnum> <level>", ch);
        return;
    }

    if (!str_cmp(arg,"mob") || !str_cmp(arg,"char"))
    {
        do_mload(ch, argument);
        return;
    }

    if (!str_cmp(arg,"obj"))
    {
        do_oload(ch, argument);
        return;
    }
    /* echo syntax */
    do_load(ch,str_empty);
}

DO_FUN(do_mload)
{
    char arg[MAX_INPUT_LENGTH];
    MOB_INDEX_DATA *pMobIndex;
    CHAR_DATA *victim;
    int vnum;

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0' || !is_number(arg))
    {
        char_act("Syntax: load mob <vnum>.", ch);
        return;
    }

    if ((pMobIndex = get_mob_index(vnum = atoi(arg))) == NULL)
    {
        char_printf(ch, "%d: No mob has that vnum.\n", vnum);
        return;
    }

    victim = create_mob(pMobIndex);
    char_to_room(victim, ch->in_room);
    act("$n has created $N!", ch, NULL, victim, TO_ROOM);
    wiznet_printf(ch, NULL, WIZ_LOAD, WIZ_SECURE, ch->level,
                  "$N loads %s.", mlstr_mval(victim->short_descr));
    char_act("Ok.", ch);
}

DO_FUN(do_oload)
{
    char arg1[MAX_INPUT_LENGTH] ,arg2[MAX_INPUT_LENGTH];
    OBJ_INDEX_DATA *pObjIndex;
    OBJ_DATA *obj;
    int level = 0;
    int vnum;

    argument = one_argument(argument, arg1, sizeof(arg1));
    one_argument(argument, arg2, sizeof(arg2));

    if (arg1[0] == '\0' || !is_number(arg1))
    {
        char_act("Syntax: load obj <vnum>.", ch);
        return;
    }

    vnum = atoi(arg1);
    if ((pObjIndex = get_obj_index(vnum)) == NULL)
    {
        char_printf(ch, "%d: No objects with this vnum.\n", vnum);
        return;
    }

    if (pObjIndex->limit != -1 && ch->pcdata->security < SEC_LOAD_LIMIT)
    {
        char_act("OLoad: Insufficient security.", ch);
        return;
    }

    obj = create_obj(pObjIndex, level);
    if (CAN_WEAR(obj, ITEM_TAKE))
        obj_to_char(obj, ch);
    else
        obj_to_room(obj, ch->in_room);
    act("$n  $p!", ch, obj, NULL, TO_ROOM);
    wiznet("$N loads $p.", ch, obj, WIZ_LOAD, WIZ_SECURE, ch->level);
    char_act("Ok.", ch);
}

DO_FUN(do_purge)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    DESCRIPTOR_DATA *d;

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        /* 'purge' */
        CHAR_DATA *vnext;
        OBJ_DATA  *obj_next;

        for (victim = ch->in_room->people; victim; victim = vnext)
        {
            vnext = victim->next_in_room;
            if (IS_NPC(victim)
                &&  !IS_SET(victim->pIndexData->act, ACT_NOPURGE)
                &&  victim != ch /* safety precaution */)
                extract_char(victim, TRUE);
        }

        for (obj = ch->in_room->contents; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            if (!IS_OBJ_STAT(obj, ITEM_NOPURGE))
                extract_obj(obj);
        }

        act("$n purges the room!", ch, NULL, NULL, TO_ROOM);
        char_act("Ok.", ch);
        return;
    }

    if ((victim = get_char_world(ch, arg)) == NULL)
    {
        char_act("They aren't here.", ch);
        return;
    }

    if (!IS_NPC(victim))
    {
        if (ch == victim)
        {
            char_act("Ho ho ho.", ch);
            return;
        }

        if (ch->level <= victim->level)
        {
            char_act("Maybe that wasn't a good idea...", ch);
            char_printf(ch,"%s tried to purge you!\n", ch->name);
            return;
        }

        act("$n disintegrates $N.", ch, 0, victim, TO_NOTVICT);

        if (victim->level > 1)
            save_char_obj(victim, FALSE, TRUE);
        d = victim->desc;
        extract_char(victim, TRUE);
        if (d)
            close_descriptor(d);
        return;
    }

    act("$n purges $N.", ch, NULL, victim, TO_NOTVICT);
    extract_char(victim, TRUE);
}

DO_FUN(do_restore)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    CHAR_DATA *vch;
    DESCRIPTOR_DATA *d;

    one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0' || !str_cmp(arg,"room"))
    {
        /* cure room */

        for (vch = ch->in_room->people; vch; vch = vch->next_in_room)
        {
            affect_strip(vch,gsn_plague);
            affect_strip(vch,gsn_poison);
            affect_strip(vch,gsn_blindness);
            affect_strip(vch,gsn_sleep);
            affect_strip(vch,gsn_curse);

            vch->hit    = vch->max_hit;
            vch->mana   = vch->max_mana;
            vch->move   = vch->max_move;
            vch->psp    = psp_max(vch);
            update_pos(vch);
            act("$n has restored you.", ch,NULL,vch,TO_VICT);
        }

        wiznet_printf(ch,NULL,WIZ_RESTORE,WIZ_SECURE,ch->level,
                      "$N restored room %d.", ch->in_room->vnum);

        char_act("Room restored.", ch);
        return;

    }

    if (ch->level >=  MAX_LEVEL - 5 && !str_cmp(arg,"all"))
    {
        /* cure all */
        for (d = descriptor_list; d != NULL; d = d->next)
        {
            victim = d->character;

            if (victim == NULL || IS_NPC(victim))
                continue;

            affect_strip(victim,gsn_plague);
            affect_strip(victim,gsn_poison);
            affect_strip(victim,gsn_blindness);
            affect_strip(victim,gsn_sleep);
            affect_strip(victim,gsn_curse);

            victim->hit     = victim->max_hit;
            victim->mana    = victim->max_mana;
            victim->move    = victim->max_move;
            victim->psp            = psp_max(victim);
            update_pos(victim);
            if (victim->in_room != NULL)
                act("$n has restored you.", ch,NULL,victim,TO_VICT);
        }
        char_act("All active players restored.", ch);
        return;
    }

    if ((victim = get_char_world(ch, arg)) == NULL)
    {
        char_act("They aren't here.", ch);
        return;
    }

    affect_strip(victim, gsn_plague);
    affect_strip(victim, gsn_poison);
    affect_strip(victim, gsn_blindness);
    affect_strip(victim, gsn_sleep);
    affect_strip(victim, gsn_curse);
    victim->hit  = victim->max_hit;
    victim->mana = victim->max_mana;
    victim->move = victim->max_move;
    victim->psp  = psp_max(victim);
    update_pos(victim);
    act("$n has restored you.", ch, NULL, victim, TO_VICT);
    wiznet_printf(ch,NULL,WIZ_RESTORE,WIZ_SECURE,ch->level,
                  "$N restored %s",
                  IS_NPC(victim) ? mlstr_mval(victim->short_descr) : victim->name);
    char_act("Ok.", ch);
}

void do_freeze (CHAR_DATA * ch, const char * argument)
{
    char arg [MAX_INPUT_LENGTH];
    CHAR_DATA * victim ;
    bool loaded = FALSE;

    if (ch->level > 100)
    {
        trim_ch (ch) ;
        return ;
    }

    argument = one_argument(argument, arg, sizeof(arg)) ;

    if (IS_NULLSTR(arg))
    {
        char_act("   ...", ch) ;
        return ;
    }

    if ((victim = gq_findchar(arg)) == NULL)
    {
        loaded = TRUE;
        victim = char_load_special(arg);
    }
    if (victim == NULL)
    {
        char_act("   .", ch);
        return ;
    }

    if (IS_NPC(victim))
    {
        char_act("   ,      .", ch) ;
        return ;
    }

    if (victim->level > ch->level)
    {
        char_act(" ... .", ch) ;
        return ;
    }

    TOGGLE_BIT(victim->plr_flags, PLR_FREEZE) ;

    if (!IS_SET(victim->plr_flags, PLR_FREEZE))
    {
        victim->pcdata->freeze = 0 ;

        char_act("   .", victim) ;
        char_act(" {WFREEZE{z .", ch) ;

        wiznet_printf (ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0,
                       "$N {W{z %s.", victim->name) ;
    } else
    {
        victim->pcdata->freeze = get_next_seconds (argument, ch) ;

        if (victim->pcdata->freeze <= 0)
        {
            char_act("     {WFREEZE{z", ch) ;
            REMOVE_BIT(victim->plr_flags, PLR_FREEZE) ;
            return ;
        }

        char_act("...       -  {W!{z", victim) ;
        char_act(" {WFREEZE{z .", ch) ;

        wiznet_printf (ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0,
                       "$N {W{z %s  %s.",
                       victim->name, strtime(victim->pcdata->freeze)) ;
    }
    if (!loaded)
        save_char_obj (victim, FALSE, FALSE);
    else
        char_nuke(victim);
}

void do_noemote (CHAR_DATA * ch, const char * argument)
{
    char arg [MAX_INPUT_LENGTH];
    CHAR_DATA * victim ;
    bool loaded = FALSE;

    if (ch->level > 100)
    {
        trim_ch (ch) ;
        return ;
    }

    argument = one_argument(argument, arg, sizeof(arg)) ;

    if (IS_NULLSTR(arg))
    {
        char_act("   ...", ch) ;
        return ;
    }

    if ((victim = gq_findchar(arg)) == NULL)
    {
        loaded = TRUE;
        victim = char_load_special(arg);
    }
    if (victim == NULL)
    {
        char_act("   .", ch) ;
        return ;
    }

    if (IS_NPC(victim))
    {
        char_act("   ,      .", ch) ;
        return ;
    }

    if (victim->level > ch->level)
    {
        char_act(" ... .", ch);
        if (loaded)
            char_nuke(victim);
        return;
    }

    TOGGLE_BIT(victim->comm, COMM_NOEMOTE) ;

    if (!IS_SET(victim->comm, COMM_NOEMOTE))
    {
        victim->pcdata->noemote = 0 ;

        char_act("     .", victim) ;
        char_act(" {WNOEMOTE{z .", ch) ;

        wiznet_printf (ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0,
                       "$N   {WNOEMOTE{z  %s.", victim->name) ;
    } else
    {
        victim->pcdata->noemote = get_next_seconds (argument, ch) ;

        if (victim->pcdata->noemote <= 0)
        {
            char_act("     {WNOEMOTE{z", ch) ;
            REMOVE_BIT(victim->comm, COMM_NOEMOTE) ;
            return ;
        }

        char_act("     !", victim) ;
        char_act(" {WNOEMOTE{z .", ch) ;

        wiznet_printf (ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0,
                       "$N   {WNOEMOTE{z %s  %s.",
                       victim->name, strtime(victim->pcdata->noemote)) ;
    }
    if (!loaded)
        save_char_obj (victim, FALSE, FALSE);
    else
        char_nuke(victim);
}

void do_nocast (CHAR_DATA * ch, const char * argument)
{
    char arg [MAX_INPUT_LENGTH];
    CHAR_DATA * victim;
    bool loaded = FALSE;

    if (ch->level > 100)
    {
        trim_ch (ch) ;
        return ;
    }

    argument = one_argument(argument, arg, sizeof(arg)) ;

    if (IS_NULLSTR(arg))
    {
        char_act("   ...", ch) ;
        return ;
    }

    if ((victim = gq_findchar(arg)) == NULL)
    {
        loaded = TRUE;
        victim = char_load_special(arg);
    }
    if (victim == NULL)
    {
        char_act("   .", ch) ;
        return ;
    }

    if (IS_NPC(victim))
    {
        char_act("   ,      .", ch) ;
        return ;
    }

    if (victim->level > ch->level)
    {
        char_act(" ... .", ch);
        if (loaded)
            char_nuke(victim);
        return;
    }

    TOGGLE_BIT(victim->comm, COMM_NOCAST) ;

    if (!IS_SET(victim->comm, COMM_NOCAST))
    {
        victim->pcdata->nocast = 0 ;

        char_act("   .", victim) ;
        char_act(" {Wnocast{z .", ch) ;

        wiznet_printf (ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0,
                       "$N   {Wnocast{z  %s.", victim->name) ;
    } else
    {
        victim->pcdata->nocast = get_next_seconds (argument, ch) ;

        if (victim->pcdata->nocast <= 0)
        {
            char_act("     {Wnocast{z", ch) ;
            REMOVE_BIT(victim->comm, COMM_NOCAST) ;
            return ;
        }

        char_act("     .", victim) ;
        char_act(" {Wnocast{z .", ch) ;

        wiznet_printf (ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0,
                       "$N   {Wnocast{z %s  %s.",
                       victim->name, strtime(victim->pcdata->nocast)) ;
    }
    if (!loaded)
        save_char_obj (victim, FALSE, FALSE);
    else
        char_nuke(victim);
}

void do_notell (CHAR_DATA * ch, const char * argument)
{
    char arg [MAX_INPUT_LENGTH];
    CHAR_DATA * victim;
    bool loaded = FALSE;

    if (ch->level > 100)
    {
        trim_ch (ch) ;
        return ;
    }

    argument = one_argument(argument, arg, sizeof(arg)) ;

    if (IS_NULLSTR(arg))
    {
        char_act("   ...", ch) ;
        return ;
    }

    if ((victim = gq_findchar(arg)) == NULL)
    {
        loaded = TRUE;
        victim = char_load_special(arg);
    }
    if (victim == NULL)
    {
        char_act("   .", ch) ;
        return ;
    }

    if (IS_NPC(victim))
    {
        char_act("   ,      .", ch) ;
        return ;
    }

    if (victim->level > ch->level)
    {
        char_act(" ... .", ch);
        if (loaded)
            char_nuke(victim);
        return ;
    }

    TOGGLE_BIT(victim->comm, COMM_NOTELL) ;

    if (!IS_SET(victim->comm, COMM_NOTELL))
    {
        victim->pcdata->notell = 0 ;

        char_act("     .", victim) ;
        char_act(" {WNOTELL{z .", ch) ;

        wiznet_printf (ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0,
                       "$N   {WNOTELL{z  %s.", victim->name) ;
    } else
    {
        victim->pcdata->notell = get_next_seconds (argument, ch) ;

        if (victim->pcdata->notell <= 0)
        {
            char_act("     {WNOTELL{z", ch) ;
            REMOVE_BIT(victim->comm, COMM_NOTELL) ;
            return ;
        }

        char_act("     !", victim) ;
        char_act(" {WNOTELL{z .", ch) ;

        wiznet_printf (ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0,
                       "$N   {WNOTELL{z %s  %s.",
                       victim->name, strtime(victim->pcdata->notell)) ;
    }
    if (!loaded)
        save_char_obj (victim, FALSE, FALSE);
    else
        char_nuke(victim);
}

void do_nochannels (CHAR_DATA * ch, const char * argument)
{
    char arg [MAX_INPUT_LENGTH];
    CHAR_DATA * victim;
    bool loaded = FALSE;

    if (ch->level > 100)
    {
        trim_ch (ch) ;
        return ;
    }

    argument = one_argument(argument, arg, sizeof(arg)) ;

    if (IS_NULLSTR(arg))
    {
        char_act("   ...", ch) ;
        return ;
    }

    if ((victim = gq_findchar(arg)) == NULL)
    {
        loaded = TRUE;
        victim = char_load_special(arg);
    }
    if (victim == NULL)
    {
        char_act("   .", ch) ;
        return ;
    }

    if (IS_NPC(victim))
    {
        char_act("   ,      .", ch) ;
        return ;
    }

    if (victim->level > ch->level)
    {
        char_act(" ... .", ch);
        if (loaded)
            char_nuke(victim);
        return;
    }

    TOGGLE_BIT(victim->comm, COMM_NOCHANNELS) ;

    if (!IS_SET(victim->comm, COMM_NOCHANNELS))
    {
        victim->pcdata->nochan = 0 ;

        char_act("     .", victim) ;
        char_act(" {WNOCHAN{z .", ch) ;

        wiznet_printf (ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0,
                       "$N   {WNOCHAN{z  %s.", victim->name) ;
    } else
    {
        victim->pcdata->nochan = get_next_seconds (argument, ch) ;

        if (victim->pcdata->nochan <= 0)
        {
            char_act("     {WNOCHAN{z", ch) ;
            REMOVE_BIT(victim->comm, COMM_NOCHANNELS) ;
            return ;
        }

        char_act("       !", victim) ;
        char_act(" {WNOCHAN{z .", ch) ;

        wiznet_printf (ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0,
                       "$N   {WNOCHAN{z %s  %s.",
                       victim->name, strtime(victim->pcdata->nochan)) ;
    }
    if (!loaded)
        save_char_obj (victim, FALSE, FALSE);
    else
        char_nuke(victim);
}

void do_nonote (CHAR_DATA * ch, const char * argument)
{
    char arg [MAX_INPUT_LENGTH];
    CHAR_DATA * victim;
    bool loaded = FALSE;

    if (ch->level > 100)
    {
        trim_ch (ch) ;
        return ;
    }

    argument = one_argument(argument, arg, sizeof(arg)) ;

    if (IS_NULLSTR(arg))
    {
        char_act("   ...", ch) ;
        return ;
    }

    if ((victim = gq_findchar(arg)) == NULL)
    {
        loaded = TRUE;
        victim = char_load_special(arg);
    }
    if (victim == NULL)
    {
        char_act("   .", ch) ;
        return ;
    }

    if (IS_NPC(victim))
    {
        char_act("   ,      .", ch) ;
        return ;
    }

    if (victim->level > ch->level)
    {
        char_act(" ... .", ch);
        if (loaded)
            char_nuke(victim);
        return ;
    }

    TOGGLE_BIT(victim->comm, COMM_NONOTE) ;

    if (!IS_SET(victim->comm, COMM_NONOTE))
    {
        victim->pcdata->nonote = 0 ;

        char_act("    ..", victim) ;
        char_act(" {WNONOTE{z .", ch) ;

        wiznet_printf (ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0,
                       "$N   {WNONOTE{z  %s.", victim->name) ;
    } else
    {
        victim->pcdata->nonote = get_next_seconds (argument, ch) ;

        if (victim->pcdata->nonote <= 0)
        {
            char_act("     {WNONOTE{z", ch) ;
            REMOVE_BIT(victim->comm, COMM_NONOTE) ;
            return ;
        }

        char_act("     !  !", victim) ;
        char_act(" {WNONOTE{z .", ch) ;

        wiznet_printf (ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0,
                       "$N   {WNONOTE{z %s  %s.",
                       victim->name, strtime(victim->pcdata->nonote)) ;
    }
    if (!loaded)
        save_char_obj (victim, FALSE, FALSE);
    else
        char_nuke(victim);
}

void do_noquest (CHAR_DATA * ch, const char * argument)
{
    char arg [MAX_INPUT_LENGTH];
    CHAR_DATA * victim;
    bool loaded = FALSE;

    if (ch->level > 100)
    {
        trim_ch (ch) ;
        return ;
    }

    argument = one_argument(argument, arg, sizeof(arg)) ;

    if (IS_NULLSTR(arg))
    {
        char_act("   ...", ch) ;
        return ;
    }

    if ((victim = gq_findchar(arg)) == NULL)
    {
        loaded = TRUE;
        victim = char_load_special(arg);
    }
    if (victim == NULL)
    {
        char_act("   .", ch) ;
        return ;
    }

    if (IS_NPC(victim))
    {
        char_act("   ,      .", ch) ;
        return ;
    }

    if (victim->level > ch->level)
    {
        char_act(" ... .", ch);
        if (loaded)
            char_nuke(victim);
        return;
    }

    TOGGLE_BIT(victim->comm, COMM_NOQUEST) ;

    if (!IS_SET(victim->comm, COMM_NOQUEST))
    {
        victim->pcdata->noquest = 0 ;

        char_act("     ...", victim) ;
        char_act(" {Wnoquest{z .", ch) ;

        wiznet_printf (ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0,
                       "$N   {Wnoquest{z  %s.", victim->name) ;
    } else
    {
        victim->pcdata->noquest = get_next_seconds (argument, ch) ;

        if (victim->pcdata->noquest <= 0)
        {
            char_act("     {Wnoquest{z", ch) ;
            REMOVE_BIT(victim->comm, COMM_NOQUEST) ;
            return ;
        }

        char_act("      !", victim) ;
        char_act(" {Wnoquest{z .", ch) ;

        wiznet_printf (ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0,
                       "$N   {Wnoquest{z %s  %s.",
                       victim->name, strtime(victim->pcdata->noquest)) ;
    }
    if (!loaded)
        save_char_obj (victim, FALSE, FALSE);
    else
        char_nuke(victim);
}

void do_nowar (CHAR_DATA * ch, const char * argument)
{
    char arg [MAX_INPUT_LENGTH];
    CHAR_DATA * victim;
    bool loaded = FALSE;

    if (ch->level > 100)
    {
        trim_ch (ch) ;
        return ;
    }

    argument = one_argument(argument, arg, sizeof(arg)) ;

    if (IS_NULLSTR(arg))
    {
        char_act("Choose your victim...", ch) ;
        return ;
    }

    if ((victim = gq_findchar(arg)) == NULL)
    {
        loaded = TRUE;
        victim = char_load_special(arg);
    }
    if (victim == NULL)
    {
        char_act("Noone with this name.", ch) ;
        return ;
    }

    if (IS_NPC(victim))
    {
        char_act("Don't touch this poor mob...", ch) ;
        return ;
    }

    if (victim->level > ch->level)
    {
        char_act(" ... .", ch);
        if (loaded)
            char_nuke(victim);
        return ;
    }

    TOGGLE_BIT(victim->comm2, COMM2_NOWAR) ;

    if (!IS_SET(victim->comm2, COMM2_NOWAR))
    {
        victim->pcdata->nowar = 0 ;

        char_act("Now you can fight in wars.", victim) ;
        char_act("{WNOWAR{z mode is {Goff{x.", ch) ;

        wiznet_printf (ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0, "$N   {WNOWAR{z  %s.", victim->name) ;
    } else
    {
        victim->pcdata->nowar = get_next_seconds (argument, ch) ;

        if (victim->pcdata->nowar <= 0)
        {
            char_act("     {WNOWAR{z", ch) ;
            REMOVE_BIT(victim->comm2, COMM2_NOWAR) ;
            return ;
        }

        char_act("Now you can't fight in wars.", victim) ;
        char_act(" {WNOWAR{z .", ch) ;

        wiznet_printf (ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0,
                       "$N   {WNOWAR{z %s  %s.",
                       victim->name, strtime(victim->pcdata->nowar)) ;
    }
    if (!loaded)
        save_char_obj (victim, FALSE, FALSE);
    else
        char_nuke(victim);
}

//Set bit for NO_PK.
void do_no_pk (CHAR_DATA * ch, const char *argument)
{
    char arg [MAX_INPUT_LENGTH];
    CHAR_DATA * victim;
    bool loaded = FALSE;

    if (ch->level > 100)
    {
        trim_ch (ch) ;
        return ;
    }

    argument = one_argument(argument, arg, sizeof(arg)) ;

    if (IS_NULLSTR(arg))
    {
        char_act("   ...", ch) ;
        return ;
    }

    if ((victim = gq_findchar(arg)) == NULL)
    {
        loaded = TRUE;
        victim = char_load_special(arg);
    }
    if (victim == NULL)
    {
        char_act("   .", ch) ;
        return ;
    }

    if (IS_NPC(victim))
    {
        char_act("   ,      :).", ch) ;
        return ;
    }

    if (victim->level > ch->level)
    {
        char_act(" ... .", ch);
        if (loaded)
            char_nuke(victim);
        return;
    }

    if (!IS_SET(victim->comm, PLR_PEACE))
    {

        TOGGLE_BIT(victim->comm, PLR_PEACE) ;
        char_act("   {RNO_PK{z !", victim) ;
        char_act(" {MPEACEFUL{z ", ch) ;
        wiznet_printf (ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0,
                       "$N   {MPEACEFUL{z %s.\n", victim->name) ;
    } else
    {
        if (ch->level >= 99)
        {
            REMOVE_BIT(victim->comm, PLR_PEACE) ;
            char_act("      .", victim) ;
            char_act(" {MPEACEFUL{z .", ch) ;

            wiznet_printf (ch, NULL, WIZ_PENALTIES, WIZ_SECURE, 0,
                           "$N   {MPEACEFUL{z  %s.", victim->name) ;
        }
    }
    if (!loaded)
        save_char_obj (victim, FALSE, FALSE);
    else
        char_nuke(victim);
}

DO_FUN(do_log)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    bool loaded = FALSE;
    if (ch->level > 100)
    {
        trim_ch(ch);
        return;
    }

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Log whom?", ch);
        return;
    }

    if (!str_cmp(arg, "all"))
    {
        if (fLogAll)
        {
            fLogAll = FALSE;
            char_act("Log ALL off.", ch);
        } else
        {
            fLogAll = TRUE;
            char_act("Log ALL on.", ch);
        }
        return;
    }

    if ((victim = gq_findchar(arg)) == NULL)
    {
        loaded = TRUE;
        victim = char_load_special(arg);
    }
    if (victim == NULL)
    {
        char_act("They aren't here.", ch);
        return;
    }

    if (IS_NPC(victim))
    {
        char_act("Not on NPC's.", ch);
        return;
    }

    /*
     * No level check, gods can log anyone.
     */
    TOGGLE_BIT(victim->plr_flags, PLR_LOG);
    if (!IS_SET(victim->plr_flags, PLR_LOG))
        char_act("LOG removed.", ch);
    else
        char_act("LOG set.", ch);
    if (loaded)
        char_nuke(victim);
}

DO_FUN(do_peace)
{
    CHAR_DATA *rch;

    for (rch = ch->in_room->people; rch; rch = rch->next_in_room)
    {
        if (!rch->fighting)
            continue;
        stop_fighting(rch, TRUE);
        if (IS_NPC(rch))
        {
            /*
             * avoid aggressive mobs and hunting mobs attacks
             */
            AFFECT_DATA af;

            af.where = TO_AFFECTS;
            af.type = gsn_reserved;
            af.level = MAX_LEVEL-1;
            af.duration = 15;
            af.location = APPLY_NONE;
            af.modifier = 0;
            af.bitvector = AFF_CALM;
            affect_to_char(rch, &af);
        }
    }

    char_act("Ok.", ch);
}

DO_FUN(do_wizlock)
{
    extern bool wizlock;
    wizlock = !wizlock;
    if (ch->level > 100)
    {
        trim_ch(ch);
        return;
    }

    if (wizlock)
    {
        wiznet("$N has wizlocked the game.", ch,NULL,0,0,0);
        char_act("Game wizlocked.", ch);
    } else
    {
        wiznet("$N removes wizlock.", ch,NULL,0,0,0);
        char_act("Game un-wizlocked.", ch);
    }
}

/* RT anti-newbie code */
DO_FUN(do_newlock)
{
    extern bool newlock;
    newlock = !newlock;

    if (newlock)
    {
        wiznet("$N locks out new characters.", ch,NULL,0,0,0);
        char_act("New characters have been locked out.", ch);
    } else
    {
        wiznet("$N allows new characters back in.", ch,NULL,0,0,0);
        char_act("Newlock removed.", ch);
    }
}

/* Gains player N tra, pra, et cetera*/
DO_FUN(do_reward)
{
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    char arg3 [MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    int value,val2;
    char *reward=str_empty;
    if (ch->level > 100)
    {
        trim_ch(ch);
        return;
    }

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));
    one_argument(argument, arg3, sizeof(arg3));

    if (arg1[0] == '\0' || arg2[0] == '\0' || arg3[0] == '\0')
    {
        char_act("Syntax:", ch);
        char_act("  reward <name> <field> <value>", ch);
        char_act("  Field being one of:",            ch);
        char_act("    str int wis dex con cha lck questp", ch);
        char_act("    gold hp mana move practice train exp", ch);
        char_act("  Note: value can be negative.      ", ch);
        return;
    }

    if ((victim = get_char_world(ch, arg1)) == NULL)
    {
        char_act("They aren't here.", ch);
        return;
    }

    /*
     * Snarf the value (which must be numeric).
     */
    if (!is_number(arg3))
    {
        char_act("Value must be numeric.", ch);
        return;
    } else
    {
        value = atoi(arg3);
    }

    if (value == 0) return;

    /*
     * Set something.
     */

    if (!str_cmp(arg2, "str"))
    {
        val2 = value+get_curr_stat(victim,STAT_STR);
        if (val2 < 3 || val2 > get_max_train(victim,STAT_STR))
        {
            char_printf(ch,"Strength range is 3 to %d\n.", get_max_train(victim,STAT_STR));
            return;
        }
        victim->perm_stat[STAT_STR] = val2;
        char_act("Ok.", ch);
        reward = "";
    }

    if (!str_cmp(arg2, "int"))
    {
        val2 = value+get_curr_stat(victim,STAT_INT);
        if (val2 < 3 || val2 > get_max_train(victim,STAT_INT))
        {
            char_printf(ch, "Intelligence range is 3 to %d.\n", get_max_train(victim,STAT_INT));
            return;
        }

        victim->perm_stat[STAT_INT] = val2;
        char_act("Ok.", ch);
        reward = "";
    }

    if (!str_cmp(arg2, "wis"))
    {
        val2 = value+get_curr_stat(victim,STAT_WIS);
        if (val2 < 3 || val2 > get_max_train(victim,STAT_WIS))
        {
            char_printf(ch,
                        "Wisdom range is 3 to %d.\n", get_max_train(victim,STAT_WIS));
            return;
        }

        victim->perm_stat[STAT_WIS] = val2;
        char_act("Ok.", ch);
        reward = "";
    }

    if (!str_cmp(arg2, "questp"))
    {
        if (!IS_NPC(victim)) victim->pcdata->questpoints += value;
        char_act("Ok.", ch);
        reward = "";
    }

    if (!str_cmp(arg2, "dex"))
    {
        val2 = value+get_curr_stat(victim,STAT_DEX);
        if (val2 < 3 || val2 > get_max_train(victim,STAT_DEX))
        {
            char_printf(ch,
                        "Dexterity ranges is 3 to %d.\n",
                        get_max_train(victim,STAT_DEX));
            return;
        }

        victim->perm_stat[STAT_DEX] = val2;
        char_act("Ok.", ch);
        reward = "";
    }

    if (!str_cmp(arg2, "con"))
    {
        val2 = value+get_curr_stat(victim,STAT_CON);
        if (val2 < 3 || val2 > get_max_train(victim,STAT_CON))
        {
            char_printf(ch,
                        "Constitution range is 3 to %d.\n",
                        get_max_train(victim,STAT_CON));
            return;
        }

        victim->perm_stat[STAT_CON] = val2;
        char_act("Ok.", ch);
        reward = "";
    }

    if (!str_cmp(arg2, "cha"))
    {
        val2 = value+get_curr_stat(victim,STAT_CHA);
        if (val2 < 3 || val2 > get_max_train(victim,STAT_CHA))
        {
            char_printf(ch,
                        "Charisma range is 3 to %d.\n",
                        get_max_train(victim,STAT_CHA));
            return;
        }

        victim->perm_stat[STAT_CHA] = val2;
        char_act("Ok.", ch);
        reward = "";
    }

    if (!str_cmp(arg2, "lck"))
    {
        val2 = value+get_curr_stat(victim,STAT_LCK);
        if (val2 < 3 || val2 > get_max_train(victim,STAT_LCK))
        {
            char_printf(ch,
                        "Luck range is 3 to %d.\n",
                        get_max_train(victim,STAT_LCK));
            return;
        }

        victim->perm_stat[STAT_LCK] = val2;
        char_act("Ok.", ch);
        reward = "";
    }


    if (!str_prefix(arg2, "gold"))
    {
        val2 = victim->gold+value;
        if (val2 > 0)
        {
            victim->gold += value;
        } else
        {
            victim->gold = 0;
        }
        char_act("Ok.", ch);
        reward = "";
    }

    if (!str_prefix(arg2, "hp"))
    {
        val2 = victim->pcdata->perm_hit+value;
        if (val2 < 1 || val2 > 30000)
        {
            char_act("Hp range is 1 to 30,000 hit points.", ch);
            return;
        }
        victim->max_hit += value;
        if (!IS_NPC(victim))
            victim->pcdata->perm_hit += value;
        char_act("Ok.", ch);
        reward = " ";
    }

    if (!str_prefix(arg2, "mana"))
    {
        val2 = victim->pcdata->perm_mana+value;
        if (val2 < 0 || val2 > 60000)
        {
            char_act("Mana range is 0 to 60,000 mana points.", ch);
            return;
        }
        victim->max_mana += value;
        if (!IS_NPC(victim))
            victim->pcdata->perm_mana += value;
        char_act("Ok.", ch);
        reward = "";
    }

    if (!str_prefix(arg2, "move"))
    {
        val2 = victim->pcdata->perm_move+value;
        if (val2 < 0 || val2 > 60000)
        {
            char_act("Move range is 0 to 60,000 move points.", ch);
            return;
        }
        victim->max_move += value;

        if (!IS_NPC(victim))
            victim->pcdata->perm_move += value;
        char_act("Ok.", ch);
        reward = "";
    }

    if (!str_prefix(arg2, "practice"))
    {
        val2 = victim->practice+value;
        if (val2 < 0 || val2 > 250)
        {
            char_act("Practice range is 0 to 250 sessions.", ch);
            return;
        }
        victim->practice = val2;
        char_act("Ok.", ch);
        reward = "";
    }

    if (!str_prefix(arg2, "train"))
    {
        val2 = victim->train+value;
        if (val2 < 0 || val2 > 50)
        {
            char_act("Training session range is 0 to 50 sessions.", ch);
            return;
        }
        victim->train = val2;
        reward = "";
    }

    if (!str_prefix(arg2, "exp"))
    {
        if (value < -5000
            || value > 5000)
        {
            char_act("Exp range is -5000 to 5000 points.", ch);
            return;
        }
        gain_exp (victim, value);
        reward = "";
    }

    /*
     * Generate usage message.
     */
    if (reward == NULL)
    {
        do_reward (ch, str_empty);
    } else
    {
        if (value > 0)
        {
            char_printf(victim,"   %d  %s.\n", value, reward);
            char_printf(ch,"  %s %d  %s.\n", victim->name, value ,reward);
        } else
        {
            char_printf(victim,"    %d  %s.\n", -1*value, reward);
            char_printf(ch,"   %s %d  %s.\n", victim->name, -1*value, reward);
        }
    }
    return;
}
/* RT set replaces sset, mset, oset, and rset */
DO_FUN(do_oldset)
{
    char arg[MAX_INPUT_LENGTH];
    if (ch->level > 100)
    {
        trim_ch(ch);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Syntax:", ch);
        char_act("  set mob       <name> <field> <value>", ch);
        char_act("  set obj       <name> <field> <value>", ch);
        char_act("  set room      <room> <field> <value>", ch);
        char_act("  set skill     <name> <spell or skill> <value>", ch);
        char_act("  set weather   <value>", ch);
        char_act("  set dateset   <day|month|year|hour> <value>", ch);

        return;
    }

    if (!str_prefix(arg,"mobile") || !str_prefix(arg,"character"))
    {
        do_mset(ch,argument);
        return;
    }

    if (!str_prefix(arg,"skill") || !str_prefix(arg,"spell"))
    {
        do_sset(ch,argument);
        return;
    }

    if (!str_prefix(arg,"weather"))
    {
        do_wset(ch, argument);
        return;
    }

    if (!str_prefix(arg,"dateset"))
    {
        do_dateset(ch, argument);
        return;
    }

    if (!str_prefix(arg,"object"))
    {
        do_oset(ch,argument);
        return;

    }

    if (!str_prefix(arg,"room"))
    {
        do_rset(ch,argument);
        return;
    }
    /* echo syntax */
    do_oldset(ch,str_empty);
}

DO_FUN(do_sset)
{
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    char arg3 [MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    int value;
    int sn;
    bool fAll;

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));
    argument = one_argument(argument, arg3, sizeof(arg3));

    if (arg1[0] == '\0' || arg2[0] == '\0' || arg3[0] == '\0')
    {
        char_act("Syntax:", ch);
        char_act("  set skill <name> <spell or skill> <value>", ch);
        char_act("  set skill <name> all <value>", ch);
        char_act("(use the name of the skill, not the number)", ch);
        return;
    }

    if ((victim = get_char_world(ch, arg1)) == NULL)
    {
        char_act("They aren't here.", ch);
        return;
    }

    if (IS_NPC(victim))
    {
        char_act("Not on NPC's.", ch);
        return;
    }

    fAll = !str_cmp(arg2, "all");
    sn   = 0;
    if (!fAll && (sn = sn_lookup(arg2)) < 0)
    {
        char_act("No such skill or spell.", ch);
        return;
    }

    /*
     * Snarf the value.
     */
    if (!is_number(arg3))
    {
        char_act("Value must be numeric.", ch);
        return;
    }

    value = atoi(arg3);
    if (value < 0 || value > 200)
    {
        char_act("Value range is 0 to 200.", ch);
        return;
    }

    if (fAll)
        for (sn = 0; sn < skills.nused; sn++)
        {
            if (IS_SET(SKILL(sn)->flags, SKILL_EXTRAORDINARY))
                continue;
            set_skill(victim, sn, value);
        }
    else
    {
        set_skill(victim, sn, value);
        if (value <= get_max_skill(victim, sn));
        else
            char_printf(ch,
                        "Warning: %s can learn this skill only up to %i%%.\n",
                        victim->name, get_max_skill(victim, sn));
        char_act("Ok.", ch);
    }
}

DO_FUN(do_string)
{
    char type [MAX_INPUT_LENGTH];
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    char arg3 [MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA *obj;

    argument = one_argument(argument, type, sizeof(type));
    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));
    strnzcpy(arg3, sizeof(arg3), argument);

    if (type[0] == '\0' || arg1[0] == '\0'
        ||  arg2[0] == '\0' || arg3[0] == '\0')
    {
        char_act("Syntax:", ch);
        char_act("  string char <name> <field> <string>", ch);
        char_act("    fields: name short long desc title spec", ch);
        char_act("  string obj  <name> <field> <string>", ch);
        char_act("    fields: name short long extended", ch);
        return;
    }

    if (!str_prefix(type, "character") || !str_prefix(type, "mobile"))
    {
        if ((victim = get_char_room(ch, arg1)) == NULL)
        {
            char_act("They aren't here.", ch);
            return;
        }

        /* clear zone for mobs */
        victim->zone = NULL;

        /* string something */

        if (!str_prefix(arg2, "name"))
        {
            if (!IS_NPC(victim))
            {
                char_act("Not on PC's.", ch);
                return;
            }
            free_string(victim->name);
            victim->name = str_dup(arg3);
            return;
        }

        if (!str_prefix(arg2, "short"))
        {
            if (!IS_NPC(victim))
            {
                char_act(" Not on PC's.", ch);
                return;
            }
            mlstr_edit(&victim->short_descr, arg3);
            return;
        }

        if (!str_prefix(arg2, "desc"))
        {
            mlstr_append(ch, &victim->description, arg3);
            return;
        }

        if (!str_prefix(arg2, "long"))
        {
            if (!IS_NPC(victim))
            {
                char_act("Not on PC's.", ch);
                return;
            }
            mlstr_editnl(&victim->long_descr, arg3);
            return;
        }

        if (!str_prefix(arg2, "title"))
        {
            if (IS_NPC(victim))
            {
                char_act("Not on NPC's.", ch);
                return;
            }

            set_title(victim, arg3);
            return;
        }
    }

    if (!str_prefix(type,"object"))
    {
        /* string an obj */

        if ((obj = get_obj_room(ch, arg1)) == NULL)
        {
            char_act("Nothing like that in heaven or earth.",
                      ch);
            return;
        }

        if (obj->pIndexData->limit >= 0)
        {
            char_act("You cannot string limited objs.", ch);
            return;
        }

        if (!str_prefix(arg2, "name"))
        {
            free_string(obj->name);
            obj->name = str_dup(arg3);
            return;
        }

        if (!str_prefix(arg2, "short"))
        {
            mlstr_edit(&obj->short_descr, arg3);
            return;
        }

        if (!str_prefix(arg2, "long"))
        {
            mlstr_edit(&obj->description, arg3);
            return;
        }

        if (!str_prefix(arg2, "ed")
            ||  !str_prefix(arg2, "extended")
            ||  !str_prefix(arg2, "exd"))
        {
            ED_DATA *ed;

            if (obj->carried_by != ch)
            {
                char_act("Obj must be in your inventory.", ch);
                return;
            }

            argument = one_argument(argument, arg3, sizeof(arg3));
            if (argument == NULL)
            {
                char_act("Syntax: oset <object> ed <keyword> lang", ch);
                return;
            }

            ed = ed_new();
            ed->keyword     = str_dup(arg3);
            ed->next        = obj->ed;
            mlstr_append(ch, &ed->description, argument);
            obj->ed = ed;
            return;
        }
    }

    /* echo bad use message */
    do_string(ch,str_empty);
}

DO_FUN(do_oset)
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    char arg3[MAX_STRING_LENGTH];
    OBJ_DATA *obj;
    int value;

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));
    one_argument(argument, arg3, sizeof(arg3));

    if (arg1[0] == '\0' || arg2[0] == '\0' || arg3[0] == '\0')
    {
        char_act("Syntax:", ch);
        char_act("  set obj <object> <field> <value>", ch);
        char_act("Field being one of:", ch);
        char_act("value0 value1 value2 value3 value4 (v1-v4)", ch);
        char_act("owner level cost timer",   ch);
        return;
    }

    if ((obj = get_obj_world(ch, arg1)) == NULL)
    {
        char_act("Nothing like that in heaven or earth.", ch);
        return;
    }

    value = atoi(arg3);

    /*
     * Set something.
     */
    if (!str_cmp(arg2, "value0") || !str_cmp(arg2, "v0"))
    {
//        obj->value[0] = UMIN(50,value);
        obj->value[0] = value;
        return;
    }

    if (!str_cmp(arg2, "value1") || !str_cmp(arg2, "v1"))
    {
        obj->value[1] = value;
        return;
    }

    if (!str_cmp(arg2, "value2") || !str_cmp(arg2, "v2"))
    {
        obj->value[2] = value;
        return;
    }

    if (!str_cmp(arg2, "value3") || !str_cmp(arg2, "v3"))
    {
        obj->value[3] = value;
        return;
    }

    if (!str_cmp(arg2, "value4") || !str_cmp(arg2, "v4"))
    {
        obj->value[4] = value;
        return;
    }

    if (!str_prefix(arg2, "level"))
    {
        obj->level = value;
        return;
    }

    if (!str_prefix(arg2, "cost"))
    {
        obj->cost = value;
        return;
    }

    if (!str_prefix(arg2, "timer"))
    {
        obj->timer = value;
        return;
    }

    if (!str_prefix(arg2, "owner"))
    {
        free_string(obj->owner);
        obj->owner = str_dup(arg3);
        return;
    }

    /*
     * Generate usage message.
     */
    do_oset(ch, str_empty);
    return;
}

DO_FUN(do_rset)
{
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    char arg3 [MAX_INPUT_LENGTH];
    ROOM_INDEX_DATA *location;
    int value;

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));
    one_argument(argument, arg3, sizeof(arg3));

    if (arg1[0] == '\0' || arg2[0] == '\0' || arg3[0] == '\0')
    {
        char_act("Syntax:", ch);
        char_act("  set room <location> <field> <value>", ch);
        char_act("  Field being one of:",            ch);
        char_act("    flags sector",             ch);
        return;
    }

    if ((location = find_location(ch, arg1)) == NULL)
    {
        char_act("No such location.", ch);
        return;
    }

    if (ch->in_room != location
        &&  room_is_private(location) && !IS_TRUSTED(ch,IMPLEMENTOR))
    {
        char_act("That room is private right now.", ch);
        return;
    }

    /*
     * Snarf the value.
     */
    if (!is_number(arg3))
    {
        char_act("Value must be numeric.", ch);
        return;
    }
    value = atoi(arg3);

    /*
     * Set something.
     */
    if (!str_prefix(arg2, "flags"))
    {
        location->room_flags    = value;
        return;
    }

    if (!str_prefix(arg2, "sector"))
    {
        location->sector_type   = value;
        return;
    }

    /*
     * Generate usage message.
     */
    do_rset(ch, str_empty);
    return;
}

DO_FUN(do_sockets)
{
    BUFFER *output;
    char arg[MAX_INPUT_LENGTH];
    DESCRIPTOR_DATA *d;
    int count;
    char * st;
    char    s[100];

    count = 0;
    output = buf_new(-1);

    buf_printf( output, "\n\r[Num Connected_State     Login] Player_Name@Host\n\r" );
    buf_printf( output,
                "-------------------------------------------------------------------------\n\r");

    one_argument(argument, arg, sizeof(arg));
    for (d = descriptor_list; d; d = d->next)
    {
        CHAR_DATA *vch = d->original ? d->original : d->character;

        if (vch)
        {
            if (!can_see(ch, vch) || vch->level == MAX_LEVEL
                ||  (arg[0] && !is_name(arg, vch->name)))
                continue;
        } else if (arg[0])
            continue;

        count++;

        switch (d->connected)
        {
        case CON_PLAYING:              st = "    PLAYING   ";    break;
        case CON_GET_NAME:             st = "   Get Name   ";    break;
        case CON_GET_OLD_PASSWORD:     st = "Get Old Passwd";    break;
        case CON_CONFIRM_NEW_NAME:     st = " Confirm Name ";    break;
        case CON_GET_NEW_PASSWORD:     st = "Get New Passwd";    break;
        case CON_CONFIRM_NEW_PASSWORD: st = "Confirm Passwd";    break;
        case CON_GET_NEW_RACE:         st = "  Get New Race";    break;
        case CON_GET_NEW_SEX:          st = "  Get New Sex ";    break;
        case CON_GET_NEW_CLASS:        st = " Get New Class";    break;
        case CON_GET_ALIGNMENT:        st = " Get New Align";    break;
        case CON_DEFAULT_CHOICE:       st = " Choosing Cust";    break;
        case CON_GEN_GROUPS:           st = " Customization";    break;
        case CON_PICK_WEAPON:          st = "Picking Weapon";    break;
        case CON_READ_IMOTD:           st = " Reading IMOTD";    break;
        case CON_BREAK_CONNECT:        st = "   LINKDEAD   ";    break;
        case CON_READ_MOTD:            st = "  Reading MOTD";    break;
        default:                       st = "   !UNKNOWN!  ";    break;
        }
        if (vch)
            strftime( s, 100, "%I:%M%p", localtime( &vch->logon ) );
        else
            s[0] = '\0';
        buf_printf(output, "[%3d %s%s %7s] %s@%s",
                   d->descriptor,
                   st,
                   d->out_compress ? "[C]" : "   ",
                   s,
                   vch ? vch->name : "(none)",
                   d->host);
        if (vch && vch->timer)
            buf_printf(output, " (idle %d)", vch->timer);
        buf_add(output, "\n");
    }

    if (count == 0)
    {
        char_act("No one by that name is connected.", ch);
        buf_free(output);
        return;
    }

    buf_printf( output,
                "-------------------------------------------------------------------------\n\r");
    buf_printf(output, "%d user%s\n",
               count, count == 1 ? str_empty : "s");
    page_to_char(buf_string(output), ch);
    buf_free(output);
}

/*
 * Thanks to Grodyn for pointing out bugs in this function.
 */
DO_FUN(do_force)
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    if (ch->level > 100)
    {
        trim_ch(ch);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0' || argument[0] == '\0')
    {
        char_act("Force whom to do what?", ch);
        return;
    }

    one_argument(argument, arg2, sizeof(arg2));

    if (!str_cmp(arg2, "delete") || !str_prefix(arg2, "mob"))
    {
        char_act("That will NOT be done.", ch);
        return;
    }

    snprintf(buf, sizeof(buf), "$n forces you to '%s'.{x", argument);

    if (!str_cmp(arg, "all"))
    {
        CHAR_DATA *vch;
        CHAR_DATA *vch_next;

        if (ch->level < MAX_LEVEL - 5)
        {
            char_act("Not at your level!", ch);
            return;
        }

        for (vch = char_list; vch != NULL; vch = vch_next)
        {
            vch_next = vch->next;

            if (!IS_NPC(vch) && vch->level < ch->level)
            {
                act(buf, ch, NULL, vch, TO_VICT);
                interpret_raw(vch, argument, TRUE);
            }
        }
    } else if (!str_cmp(arg,"players"))
    {
        CHAR_DATA *vch;
        CHAR_DATA *vch_next;

        if (ch->level < MAX_LEVEL - 5)
        {
            char_act("Not at your level!", ch);
            return;
        }

        for (vch = char_list; vch != NULL; vch = vch_next)
        {
            vch_next = vch->next;

            if (!IS_NPC(vch) && vch->level < ch->level
                &&   vch->level < LEVEL_IMMORTAL)
            {
                act(buf, ch, NULL, vch, TO_VICT);
                interpret(vch, argument);
            }
        }
    } else if (!str_cmp(arg,"gods"))
    {
        CHAR_DATA *vch;
        CHAR_DATA *vch_next;

        if (ch->level < MAX_LEVEL - 5)
        {
            char_act("Not at your level!", ch);
            return;
        }

        for (vch = char_list; vch != NULL; vch = vch_next)
        {
            vch_next = vch->next;

            if (!IS_NPC(vch) && vch->level < ch->level
                &&   vch->level >= LEVEL_IMMORTAL)
            {
                act(buf, ch, NULL, vch, TO_VICT);
                interpret(vch, argument);
            }
        }
    } else
    {
        CHAR_DATA *victim;

        if ((victim = get_char_world(ch, arg)) == NULL)
        {
            char_act("They aren't here.", ch);
            return;
        }

        if (victim == ch)
        {
            char_act("Aye aye, right away!", ch);
            return;
        }

        if (!is_room_owner(ch,victim->in_room)
            &&  ch->in_room != victim->in_room
            &&  room_is_private(victim->in_room) && !IS_TRUSTED(ch,IMPLEMENTOR))
        {
            char_act("That character is in a private room.", ch);
            return;
        }

        if (!IS_NPC(victim))
        {
            if (victim->level > ch->level)
            {
                char_act("Do it yourself!", ch);
                return;
            }

            if (ch->level < MAX_LEVEL - 5)
            {
                char_act("Not at your level!", ch);
                return;
            }
        }

        act(buf, ch, NULL, victim, TO_VICT);
        interpret(victim, argument);
    }

    char_act("Ok.", ch);
    return;
}

/*
 * New routines by Dionysos.
 */
DO_FUN(do_invis)
{
    int level;
    char arg[MAX_STRING_LENGTH];

    /* RT code for taking a level argument */
    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
        /* take the default path */

        if (ch->invis_level)
        {
            ch->invis_level = 0;
            act("$n slowly fades into existence.", ch, NULL, NULL, TO_ROOM);
            char_act("You slowly fade back into existence.", ch);
        } else
        {
            ch->invis_level = LEVEL_IMMORTAL;
            act("$n slowly fades into thin air.", ch, NULL, NULL, TO_ROOM);
            char_act("You slowly visible into thin air.", ch);
        }
    else
    /* do the level thing */
    {
        level = atoi(arg);
        if (level < 2 || level > ch->level)
        {
            char_act("Invis level must be between 2 and your level.", ch);
            return;
        } else
        {
            ch->reply = NULL;
            ch->invis_level = level;
            act("$n slowly fades into thin air.", ch, NULL, NULL, TO_ROOM);
            char_act("You slowly vanish into thin air.", ch);
        }
    }
}

DO_FUN(do_incognito)
{
    int level;
    char arg[MAX_STRING_LENGTH];

    /* RT code for taking a level argument */
    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
        /* take the default path */

        if (ch->incog_level)
        {
            ch->incog_level = 0;
            act("$n is no longer cloaked.", ch, NULL, NULL, TO_ROOM);
            char_act("You are no longer cloaked.", ch);
        } else
        {
            ch->incog_level = LEVEL_IMMORTAL;
            act("$n cloaks $gn{his} presence.", ch, NULL, NULL, TO_ROOM);
            char_act("You cloak your presence.", ch);
        }
    else
    /* do the level thing */
    {
        level = atoi(arg);
        if (level < 2 || level > ch->level)
        {
            char_act("Incog level must be between 2 and your level.", ch);
            return;
        } else
        {
            ch->reply = NULL;
            ch->incog_level = level;
            act("$n cloaks $gn{his} presence.", ch, NULL, NULL, TO_ROOM);
            char_act("You cloak your presence.", ch);
        }
    }
}

DO_FUN(do_holylight)
{
    if (IS_NPC(ch))
        return;

    TOGGLE_BIT(ch->plr_flags, PLR_HOLYLIGHT);
    char_printf(ch, "Holy light mode %s.\n",
                IS_SET(ch->plr_flags, PLR_HOLYLIGHT) ? "on" : "off");
}

/* prefix command: it will put the string typed on each line typed */

DO_FUN(do_prefi)
{
    char_act("You cannot abbreviate the prefix command.", ch);
}

DO_FUN(do_prefix)
{
    if (argument[0] == '\0')
    {
        if (ch->prefix[0] == '\0')
        {
            char_act("You have no prefix to clear.", ch);
            return;
        }

        char_act("Prefix removed.", ch);
        free_string(ch->prefix);
        ch->prefix = str_empty;
        return;
    }

    free_string(ch->prefix);
    ch->prefix = str_dup(argument);
    char_printf(ch, "Prefix set to '%s'.\n", argument);
}

void advance(CHAR_DATA *victim, int level)
{
    int iLevel;
    int tra;
    int pra;
    tra = victim->train;
    pra = victim->practice;
    victim->pcdata->plevels = 0;

    /*
     * Lower level:
     *   Reset to level 1.
     *   Then raise again.
     *   Currently, an imp can lower another imp.
     *   -- Swiftest
     */
    if (level <= victim->level)
    {
        int temp_prac;

        char_act("**** OOOOHHHHHHHHHH  NNNNOOOO ****", victim);
        temp_prac = victim->practice;
        victim->level       = 1;
        victim->exp     = base_exp(victim);
        victim->max_hit     = 10;
        victim->max_mana    = 100;
        victim->max_move    = 100;
        victim->practice    = 0;
        victim->hit     = victim->max_hit;
        victim->mana        = victim->max_mana;
        victim->move        = victim->max_move;
        victim->pcdata->perm_hit    = victim->max_hit;
        victim->pcdata->perm_mana   = victim->max_mana;
        victim->pcdata->perm_move   = victim->max_move;
        advance_level(victim);
        victim->practice    = temp_prac;
    } else
        char_act("**** OOOOHHHHHHHHHH  YYYYEEEESSS ****", victim);

    for (iLevel = victim->level ; iLevel < level; iLevel++)
    {
        char_act("{CYou raise a level!!{x ", victim);
        victim->exp += exp_to_level(victim);
        victim->level++;
        advance_level(victim);
    }
    victim->exp_tl      = 0;
    victim->train       = tra;
    victim->practice    = pra;

    save_char_obj(victim, FALSE, FALSE);
}

DO_FUN(do_advance)
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    int level;
    int oldlevel;
    immortal_t *immortal;
    int i;

    if (ch->level > 100)
    {
        trim_ch(ch);
        return;
    }

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));

    if (arg1[0] == '\0' || arg2[0] == '\0' || !is_number(arg2))
    {
        char_act("Syntax: advance <char> <level>.", ch);
        return;
    }

    if ((victim = get_char_room(ch, arg1)) == NULL)
    {
        char_act("That player is not here.", ch);
        return;
    }

    if (IS_NPC(victim))
    {
        char_act("Not on NPC's.", ch);
        return;
    }

    if ((level = atoi(arg2)) < 1 || level > MAX_LEVEL-1)
    {
        char_act("Level must be 1 to 100.", ch);
        return;
    }

    if (level > ch->level)
    {
        char_act("Limited to your level.", ch);
        return;
    }

    if (victim->level >= ch->level)
    {
        char_act("    ?      ! :)", ch);
        return;
    }

    oldlevel = victim->level;

    if (!IS_NPC(victim))
        victim->pcdata->real_level = level;

    advance(victim, level);
    /* TODO:
       need insert code for immortal database
    */
       if (!IS_NPC(victim))
       {
             if (level > 91)
             {
                  i = immnumber_lookup(victim->name);
                  if (i < 0)
                  {
                        immortal = immortal_new();
                        immortal->name = victim->name;
                        immortal->level = level;
                        char_act("Added new immortal in databse.",ch);
                        char_act("Added You immortal in databse. Please correct information about your.",victim);
                        save_immortal(ch);
                  }
                  else
                  {
                        immortal = IMM(i);
                        if (oldlevel != level)
                        {
                              immortal->level = level;
                              char_act("Changed info in immortal database.",ch);
                              char_act("Info about you changed in immortal database.",victim);
                              save_immortal(ch);
                        }
                  }
             }
             else
             if (oldlevel > 91 && level < 92)
             {
                                 delete_immortal(ch, victim->name);
                         }
       }
}

DO_FUN(do_advself)
{
    char arg1[MAX_INPUT_LENGTH];
    int level;

    if (ch->pcdata->real_level > 100)
    {
        trim_ch(ch);
        return;
    }

    if (IS_NPC(ch))
    {
        char_act("Hey! Fuck off!", ch);
        return;
    }

    argument = one_argument(argument, arg1, sizeof(arg1));


    if (arg1[0] == '\0'|| !is_number(arg1))
    {
        char_act("Syntax: advself <level>.", ch);
        return;
    }


    if ((level = atoi(arg1)) < 1 || level > MAX_LEVEL-1)
    {
        char_act("Level must be 1 to 100.", ch);
        return;
    }

    if (ch->pcdata->real_level == 0) ch->pcdata->real_level = ch->level;

    if (level > ch->pcdata->real_level)
    {
        char_act("Limited to your REAL level.", ch);
        return;
    }

    if (ch->level > LEVEL_HERO && level <= LEVEL_HERO)
    {
        ch->pcdata->real_sec = ch->pcdata->security;
        ch->pcdata->security = 0;
        if (ch->imm_name != 0)
        {
            free_string(ch->imm_name);
            ch->imm_name = 0;
        }
    }
    if (ch->level <= LEVEL_HERO && level > LEVEL_HERO)
    {
        ch->pcdata->security = ch->pcdata->real_sec;
        ch->pcdata->real_sec = 0;
    }
    advance(ch, level);
}

DO_FUN(do_mset)
{
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    char arg3 [MAX_INPUT_LENGTH];
    char arg4 [MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    int value, val2;
    int race;

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));
    argument = one_argument(argument, arg3, sizeof(arg3));
    one_argument(argument, arg4, sizeof(arg4));

    if (arg1[0] == '\0' || arg2[0] == '\0' || arg3[0] == '\0')
    {
        char_act("Syntax:", ch);
        char_act("  set char <name> <field> <value>", ch);
        char_act("  Field being one of:",            ch);
        char_act("    str int wis dex con cha lck sex class level", ch);
        char_act("    race gold hp mana move practice align", ch);
        char_act("    train thirst drunk full hometown ethos", ch);
        char_act("    noghost clan trouble security size", ch);
        char_act("    questp questt relig bloodlust desire", ch);
        char_act("    title pretitle", ch);
        return;
    }

    if ((victim = get_char_world(ch, arg1)) == NULL)
    {
        char_act("They aren't here.", ch);
        return;
    }

    /*
     * Snarf the value (which need not be numeric).
     */
    value = is_number(arg3) ? atoi(arg3) : -1;
    val2  = is_number(arg4) ? atoi(arg4) : -1;

    /*
     * Set something.
     */
    if (!str_cmp(arg2, "str"))
    {
        if (value < 3 || value > get_max_train(victim,STAT_STR))
        {
            char_printf(ch,
                        "Strength range is 3 to %d\n.",
                        get_max_train(victim,STAT_STR));
            return;
        }

        victim->perm_stat[STAT_STR] = value;
        return;
    }

    if (!str_cmp(arg2, "trouble"))
    {
        if (IS_NPC(victim))
        {
            char_act("Not on NPC's.", ch);
            return;
        }

        if (value == -1 || val2 == -1)
        {
            char_act("Usage: set char <name> trouble <vnum> <value>.", ch);
            return;
        }

        qtrouble_set(victim, value, val2+1);
        char_act("Ok.", ch);
        return;
    }

    if (!str_cmp(arg2, "security"))
    { /* OLC */
        if (IS_NPC(ch))
        {
            char_act("Si, claro.", ch);
            return;
        }

        if (IS_NPC(victim))
        {
            char_act("Not on NPC's.", ch);
            return;
        }

        if (value > ch->pcdata->security || value < 0)
        {
            if (ch->pcdata->security != 0)
                char_printf(ch, "Valid security is 0-%d.\n",
                            ch->pcdata->security);
            else
                char_act("Valid security is 0 only.", ch);
            return;
        }
        victim->pcdata->security = value;
        ch->pcdata->real_sec = ch->pcdata->security;
        return;
    }

    if (!str_cmp(arg2, "int"))
    {
        if (value < 3 || value > get_max_train(victim,STAT_INT))
        {
            char_printf(ch, "Intelligence range is 3 to %d.\n",
                        get_max_train(victim,STAT_INT));
            return;
        }

        victim->perm_stat[STAT_INT] = value;
        return;
    }

    if (!str_cmp(arg2, "wis"))
    {
        if (value < 3 || value > get_max_train(victim,STAT_WIS))
        {
            char_printf(ch,
                        "Wisdom range is 3 to %d.\n", get_max_train(victim,STAT_WIS));
            return;
        }

        victim->perm_stat[STAT_WIS] = value;
        return;
    }
    if (!str_cmp(arg2, "questp"))
    {
        if (value == -1) value = 0;
        if (!IS_NPC(victim)) victim->pcdata->questpoints = value;
        return;
    }
    if (!str_cmp(arg2, "questt"))
    {
        if (value == -1) value = 30;
        if (!IS_NPC(victim)) victim->pcdata->questtime = value;
        return;
    }
    if (!str_cmp(arg2, "relig"))
    {
        value = is_number(arg3) ? atoi(arg3) : rln_lookup(arg3);
        if (value == -1) value = 0;
        victim->religion = value;
        return;
    }


    if (!str_cmp(arg2, "dex"))
    {
        if (value < 3 || value > get_max_train(victim,STAT_DEX))
        {
            char_printf(ch,
                        "Dexterity ranges is 3 to %d.\n",
                        get_max_train(victim,STAT_DEX));
            return;
        }

        victim->perm_stat[STAT_DEX] = value;
        return;
    }

    if (!str_cmp(arg2, "con"))
    {
        if (value < 3 || value > get_max_train(victim,STAT_CON))
        {
            char_printf(ch,
                        "Constitution range is 3 to %d.\n",
                        get_max_train(victim,STAT_CON));
            return;
        }

        victim->perm_stat[STAT_CON] = value;
        return;
    }
    if (!str_cmp(arg2, "cha"))
    {
        if (value < 3 || value > get_max_train(victim,STAT_CHA))
        {
            char_printf(ch,
                        "Charisma range is 3 to %d.\n",
                        get_max_train(victim,STAT_CHA));
            return;
        }

        victim->perm_stat[STAT_CHA] = value;
        return;
    }
    if (!str_cmp(arg2, "lck"))
    {
        if (value < 3 || value > get_max_train(victim,STAT_LCK))
        {
            char_printf(ch,
                        "Luck range is 3 to %d.\n",
                        get_max_train(victim,STAT_LCK));
            return;
        }

        victim->perm_stat[STAT_LCK] = value;
        return;
    }


    if (!str_cmp(arg2, "size"))
    {
        if (value < 0 || value > SIZE_GARGANTUAN_MAX)
        {
            char_printf(ch, "Size range is 0 to %d.\n", SIZE_GARGANTUAN_MAX);
            return;
        }

        victim->size = value;
        return;
    }


    if (!str_prefix(arg2, "sex"))
    {
        value = is_number(arg3) ? atoi(arg3) : flag_value(sex_table, arg3);
        if (value != SEX_MALE
        && value != SEX_FEMALE
        && value != SEX_NEUTRAL
        && value != SEX_PLURAL)
        {
            char_act("Only the following sex allowed: male, female, neutral, plural.", ch);
            return;
        }
        /*
        {
            char_act("You can't change their sex.", ch);
            return;
        }
        */
        victim->sex = value;
        if (!IS_NPC(victim))
            victim->pcdata->true_sex = value;
        return;
    }

    if (!str_prefix(arg2, "class"))
    {
        int cl;

        if (IS_NPC(victim))
        {
            char_act("Mobiles have no class.", ch);
            return;
        }

        cl = cn_lookup(arg3);
        if (cl < 0)
        {
            BUFFER *output;

            output = buf_new(-1);

            buf_add(output, "Possible classes are: ");
            for (cl = 0; cl < classes.nused; cl++)
            {
                if (cl > 0)
                    buf_add(output, " ");
                buf_add(output, CLASS(cl)->name);
            }
            buf_add(output, ".\n");

            send_to_char(buf_string(output), ch);
            buf_free(output);
            return;
        }

        victim->class = cl;
        victim->exp = exp_for_level(victim, victim->level);
        victim->exp_tl = 0;
        update_skills(victim);
        return;
    }

    if (!str_prefix(arg2, "level"))
    {
        if (!IS_NPC(victim))
        {
            char_act("Not on PC's.", ch);
            return;
        }

        if (value < 0 || value > 200)
        {
            char_act("Level range is 0 to 200.", ch);
            return;
        }
        victim->level = value;
        return;
    }

    if (!str_prefix(arg2, "gold"))
    {
        victim->gold = value;
        return;
    }

    if (!str_prefix(arg2, "hp"))
    {
        if (value < -10 || value > 30000)
        {
            char_act("Hp range is -10 to 30,000 hit points.", ch);
            return;
        }
        victim->max_hit = value;
        if (!IS_NPC(victim))
            victim->pcdata->perm_hit = value;
        return;
    }

    if (!str_prefix(arg2, "mana"))
    {
        if (value < 0 || value > 60000)
        {
            char_act("Mana range is 0 to 60,000 mana points.", ch);
            return;
        }
        victim->max_mana = value;
        if (!IS_NPC(victim))
            victim->pcdata->perm_mana = value;
        return;
    }

    if (!str_prefix(arg2, "move"))
    {
        if (value < 0 || value > 60000)
        {
            char_act("Move range is 0 to 60,000 move points.", ch);
            return;
        }
        victim->max_move = value;

        if (!IS_NPC(victim))
            victim->pcdata->perm_move = value;
        return;
    }

    if (!str_prefix(arg2, "practice"))
    {
        if (value < 0 || value > 250)
        {
            char_act("Practice range is 0 to 250 sessions.", ch);
            return;
        }
        victim->practice = value;
        return;
    }

    if (!str_prefix(arg2, "train"))
    {
        if (value < 0 || value > 50)
        {
            char_act("Training session range is 0 to 50 sessions.", ch);
            return;
        }
        victim->train = value;
        return;
    }
//TODO:      
    if (!str_prefix(arg2, "align"))
    {
        if (value < -1000 || value > 1000)
        {
            char_act("Alignment range is -1000 to 1000.", ch);
            return;
        }
        victim->alignment = value;
        char_act("Remember to check their hometown.", ch);
        return update_member_info (victim);
    }

    if (!str_prefix(arg2, "ethos"))
    {
        int ethos;

        if (IS_NPC(victim))
        {
            char_act("Mobiles don't have an ethos.", ch);
            return;
        }

        ethos = flag_value(ethos_table, arg3);
        if (ethos < 0)
        {
            char_act("%s: Unknown ethos.", ch);
            char_act("Valid ethos types are:", ch);
            show_flags(ch, ethos_table);
            return;
        }

        victim->ethos = ethos;
        return update_member_info (victim);
    }

    if (!str_prefix(arg2, "hometown"))
    {
        if (IS_NPC(victim))
        {
            char_act("Mobiles don't have hometowns.", ch);
            return;
        }
        if (value < 0 || value > 5)
        {
            char_act("Please choose one of the following :.", ch);
            char_act("Town        Alignment       Value", ch);
            char_act("----        ---------       -----", ch);
            char_act("Midgaard     Any              0", ch);
            char_act("New Thalos   Any              1", ch);
            char_act("Titan        Good             2", ch);
            char_act("Ofcol        Neutral          3", ch);
            char_act("Old Midgaard Evil             4", ch);
            char_act("Shire        Hobbit           5", ch);
            return;
        }

        race = rn_lookup("hobbit");

        if ((value == 2 && !IS_GOOD(victim))
        || (value == 3 && !IS_NEUTRAL(victim))
        || (value == 4 && !IS_EVIL(victim))
        || (value == 5 && ORG_RACE(victim) != race))
        {
            char_act("The hometown doesn't match this character's alignment or race.", ch);
            return;
        }

        victim->hometown = value;
        return;
    }

    if (!str_prefix(arg2, "thirst"))
    {
        if (IS_NPC(victim))
        {
            char_act("Not on NPC's.", ch);
            return;
        }

        if (value < -1 || value > 100)
        {
            char_act("Thirst range is -1 to 100.", ch);
            return;
        }

        victim->pcdata->condition[COND_THIRST] = value;
        return;
    }

    if (!str_prefix(arg2, "drunk"))
    {
        if (IS_NPC(victim))
        {
            char_act("Not on NPC's.", ch);
            return;
        }

        if (value < -1 || value > 100)
        {
            char_act("Drunk range is -1 to 100.", ch);
            return;
        }

        victim->pcdata->condition[COND_DRUNK] = value;
        return;
    }

    if (!str_prefix(arg2, "full"))
    {
        if (IS_NPC(victim))
        {
            char_act("Not on NPC's.", ch);
            return;
        }

        if (value < -1 || value > 100)
        {
            char_act("Full range is -1 to 100.", ch);
            return;
        }

        victim->pcdata->condition[COND_FULL] = value;
        return;
    }

    if (!str_prefix(arg2, "hunger"))
    {
        if (IS_NPC(victim))
        {
            char_act("Not on NPC's.", ch);
            return;
        }

        if (value < -1 || value > 100)
        {
            char_act("Hunger range is -1 to 100.", ch);
            return;
        }

        victim->pcdata->condition[COND_HUNGER] = value;
        return;
    }

    if (!str_prefix(arg2, "bloodlust"))
    {
        if (IS_NPC(victim))
        {
            char_act("Not on NPC's.", ch);
            return;
        }

        if (value < -1 || value > 100)
        {
            char_act("Full range is -1 to 100.", ch);
            return;
        }

        victim->pcdata->condition[COND_BLOODLUST] = value;
        return;
    }

    if (!str_prefix(arg2, "desire"))
    {
        if (IS_NPC(victim))
        {
            char_act("Not on NPC's.", ch);
            return;
        }

        if (value < -1 || value > 100)
        {
            char_act("Full range is -1 to 100.", ch);
            return;
        }

        victim->pcdata->condition[COND_DESIRE] = value;
        return;
    }

    if (!str_prefix(arg2, "race"))
    {
        int race;

        race = rn_lookup(arg3);

        if (race == 0)
        {
            char_act("That is not a valid race.", ch);
            return;
        }

        if (!IS_NPC(victim) && !RACE(race)->pcdata)
        {
            char_act("That is not a valid player race.", ch);
            return;
        }

        victim->race = race;
        SET_ORG_RACE(victim, race);
        update_skills(victim);
        victim->exp = exp_for_level(victim, victim->level);
        victim->exp_tl = 0;
        return;
    }

    if (!str_prefix(arg2, "noghost"))
    {
        if (IS_NPC(victim))
        {
            char_act("Not on NPC.", ch);
            return;
        }
        REMOVE_BIT(victim->plr_flags, PLR_GHOST);
        char_act("Ok.", ch);
        return;
    }

    if (!str_prefix(arg2, "clan"))
    {
        int cn;

        if (IS_NPC(victim))
        {
            char_act("Not on NPC.", ch);
            return;
        }

        if ((cn = cln_lookup(arg3)) < 0)
        {
            char_act("Incorrect clan name.", ch);
            return;
        }

        victim->clan = cn;
        victim->pcdata->petition = cn;
        victim->pcdata->clan_status = CLAN_NEWBIE;
        update_skills(victim);
        char_act("Ok.", ch);
        return;
    }
    if (!str_prefix(arg2, "title"))
    {
        if (IS_NPC(victim))
        {
            char_act("Not on NPC.", ch);
            return;
        }

        if (ch->level < victim->level)
        {
            char_act(" .", ch);
            return;
        }

        victim->pcdata->title = str_empty;

        char_act("Ok.", ch);
        return;
    }
    if (!str_prefix(arg2, "pretitle"))
    {
        if (IS_NPC(victim))
        {
            char_act("Not on NPC.", ch);
            return;
        }

        if (ch->level < victim->level)
        {
            char_act(" .", ch);
            return;
        }

        victim->pcdata->pretitle = str_empty;

        char_act("Ok.", ch);
        return;
    }
    /*
     * Generate usage message.
     */
    do_mset(ch, str_empty);
    return ;
}


DO_FUN(do_desocket)
{
    DESCRIPTOR_DATA *d;
    int socket;
    char arg[MAX_INPUT_LENGTH];

    one_argument(argument, arg, sizeof(arg));

    if (!is_number(arg))
    {
        char_act("The argument must be a number.", ch);
        return;
    }

    if (arg[0] == '\0')
    {
        char_act("Disconnect which socket?", ch);
        return;
    }

    else
    {
        socket = atoi(arg);
        for (d = descriptor_list; d != NULL; d = d->next)
        {
            if (d->descriptor == socket)
            {
                if (d->character == ch)
                {
                    char_act("It would be foolish to disconnect yourself.", ch);
                    return;
                }
                if (d->connected == CON_PLAYING)
                {
                    char_act("Why don't you just use disconnect?", ch);
                    return;
                }
                write_to_descriptor(d->descriptor,
                                    "You are being disconnected by an immortal.",
                                    0);
                close_descriptor(d);
                char_act("Done.", ch);
                return;
            }
        }
        char_act("No such socket is connected.", ch);
        return;
    }
}

DO_FUN(do_smite)
{
    CHAR_DATA *victim;

    if (argument[0] == '\0')
    {
        char_act("You are so frustrated you smite yourself!  OWW!", ch);
        return;
    }

    if ((victim = get_char_world(ch, argument)) == NULL)
    {
        char_act("You'll have to smite them some other day.", ch);
        return;
    }

    if (IS_NPC(victim))
    {
        char_act("That poor mob never did anything to you.", ch);
        return;
    }

    if (victim->level > ch->level)
    {
        char_act("How dare you!", ch);
        return;
    }

    if (victim->position < POS_SLEEPING)
    {
        char_act("Take pity on the poor thing.", ch);
        return;
    }

    act("A bolt comes down out of the heavens and smites you!", victim, NULL,
        ch, TO_CHAR);
    act("You reach down and smite $n!", victim, NULL, ch, TO_VICT);
    act("A bolt from the heavens smites $n!", victim, NULL, ch, TO_NOTVICT);
    victim->hit = victim->hit / 2;
    return;
}

DO_FUN(do_popularity)
{
    BUFFER *output;
    AREA_DATA *area;
    extern AREA_DATA *area_first;
    int i;

    output = buf_new(-1);
    buf_add(output, "Area popularity statistics (in char * ticks)\n");

    for (area = area_first,i=0; area != NULL; area = area->next,i++)
    {
        if (i % 2 == 0)
            buf_add(output, "\n");
        buf_printf(output, "%-20s %-8lu       ",
                   area->name, area->count);
    }
    buf_add(output, "\n\n");
    page_to_char(buf_string(output), ch);
    buf_free(output);
}

DO_FUN(do_ititle)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    argument = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Change whose title to what?", ch);
        return;
    }

    victim = get_char_world(ch, arg);
    if (victim == NULL)
    {
        char_act("Nobody is playing with that name.", ch);
        return;
    }

    if (IS_NPC(victim))
    {
        char_act("Not on NPC's.", ch);
        return;
    }

    if (argument[0] == '\0')
    {
        char_act("Change the title to what?", ch);
        return;
    }

    if (ch->level < victim->level)
    {
        char_act(" .", ch);
        return;
    }

    set_title(victim, argument);
    char_act("Ok.", ch);
}

DO_FUN(do_pretitle)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    argument = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Change whose pre title to what?", ch);
        return;
    }

    victim = get_char_world(ch, arg);
    if (victim == NULL)
    {
        char_act("Nobody is playing with that name.", ch);
        return;
    }

    if (IS_NPC(victim))
    {
        char_act("Not on NPC's.", ch);
        return;
    }

    if (argument[0] == '\0')
    {
        char_act("Change the pre title to what?", ch);
        return;
    }

    if (ch->level < victim->level)
    {
        char_act(" .", ch);
        return;
    }

    set_pretitle(victim, argument);
    char_act("Ok.", ch);
}

/*
 * .gz files are checked for too, just in case.
 */

bool check_parse_name(char* name);

void do_rename(CHAR_DATA* ch, const char *argument)
{
    char old_name[MAX_INPUT_LENGTH],
    new_name[MAX_INPUT_LENGTH];
    char strsave[PATH_MAX];
    char *file_name;

    CHAR_DATA *victim;
    FILE* file;
    if (ch->level > 100)
    {
        trim_ch(ch);
        return;
    }

    argument = first_arg(argument, old_name, sizeof(old_name), FALSE);
    first_arg(argument, new_name, sizeof(new_name), FALSE);

    if (!old_name[0])
    {
        char_act("Rename who?", ch);
        return;
    }

    victim = gq_findchar(old_name);
    if (!victim)
    {
        char_act("There is no such a person online.", ch);
        return;
    }

    if (IS_NPC(victim))
    {
        char_act("You cannot use Rename on NPCs.", ch);
        return;
    }

    if (victim != ch && victim->level >= ch->level)
    {
        char_act("You failed.", ch);
        return;
    }

    if (!victim->desc || (victim->desc->connected != CON_PLAYING))
    {
        char_act("This player has lost his link or is inside a pager or the like.", ch);
        return;
    }

    if (!new_name[0])
    {
        char_act("Rename to what new name?", ch);
        return;
    }

    if (!check_parse_name(new_name))
    {
        char_act("The new name is illegal.", ch);
        return;
    }

/* delete old pfile */
    if (str_cmp(new_name, old_name))
    {
        DESCRIPTOR_DATA *d;
        OBJ_DATA *obj;

        for (d = descriptor_list; d; d = d->next)
            if (d->character
            && !str_cmp(d->character->name, new_name))
            {
                char_act("A player with the name you specified already exists!", ch);
                return;
            }

            /* check pfile */
        file_name = capitalize(new_name);
        fclose(fpReserve);
        file = dfopen (PLAYER_PATH, file_name, "r");
        if (file)
        {
            fclose(file);
            fpReserve = fopen(NULL_FILE, "r");
            char_act("A player with that name already exists!", ch);
            return;
        }

        /* check .gz pfile */
        snprintf(strsave, sizeof(strsave), "%s%s.gz", PLAYER_PATH, file_name);
        file = dfopen(PLAYER_PATH, strsave, "r");
        if (file)
        {
            char_act("A player with that name already exists in a compressed file!", ch);
            fclose (file);
            fpReserve = fopen(NULL_FILE, "r");
            return;
        }
        fpReserve = fopen(NULL_FILE, "r");

        /* change object owners */
        for (obj = object_list; obj; obj = obj->next)
            if (obj->owner && !str_cmp(obj->owner, old_name))
            {
                free_string(obj->owner);
                obj->owner = str_dup(new_name);
            }

        dunlink(PLAYER_PATH, capitalize(old_name));
    }
/*
 * NOTE: Players who are level 1 do NOT get saved under a new name
 */
    name_delete(ch, victim->name, "Links", &victim->pcdata->linked_list);
    free_string(victim->name);
    victim->name = str_dup(new_name);
    links_fix(victim);
    save_char_obj(victim, FALSE, FALSE);

    char_act("Character renamed.", ch);
    act_puts("$n has renamed you to $t!", ch, victim->name, victim, TO_VICT, POS_DEAD);
}

DO_FUN(do_notitle)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    if (!IS_IMMORTAL(ch))
        return;

    argument = one_argument(argument, arg, sizeof(arg));

    if ((victim = get_char_world(ch ,arg)) == NULL)
    {
        char_act("He is not currently playing.", ch);
        return;
    }

    TOGGLE_BIT(victim->plr_flags, PLR_NOTITLE);
    if (!IS_SET(victim->plr_flags, PLR_NOTITLE))
        char_act("You can change your title again.", victim);
    else
        char_act("You won't be able to change your title anymore.",
                  victim);
    char_act("Ok.", ch);
}

DO_FUN(do_noaffect)
{
    AFFECT_DATA *paf,*paf_next;
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    if (ch->level > 100)
    {   trim_ch(ch);
        return;
    }

    if (!IS_IMMORTAL(ch))
        return;

    argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0') {
        char_act("Noaff whom?", ch);
        return;
    }

    if ((victim = get_char_world(ch, arg)) == NULL) {
        char_act("He is not currently playing.", ch);
        return;
    }

    for (paf = victim->affected; paf != NULL; paf = paf_next) {
        paf_next = paf->next;
        if (paf->duration >= -1) {
            dispel_message(victim, paf->type, FALSE);
            affect_remove(victim, paf);
        }
    }
}

DO_FUN(do_affrooms)
{
    ROOM_INDEX_DATA *room;
    ROOM_INDEX_DATA *room_next;
    int count = 0;

    if (!top_affected_room)
        char_act("No affected room.", ch);

    for (room = top_affected_room; room ; room = room_next)
    {
        room_next = room->aff_next;
        count++;
        char_printf(ch, "%d) [Vnum : %5d] %s\n",
                    count, room->vnum , mlstr_cval(room->name, ch));
    }
}

DO_FUN(do_find)
{
    char* path;
    ROOM_INDEX_DATA *location;

    if (argument[0] == '\0')
    {
        char_act("Ok. But what I should find?", ch);
        return;
    }

    if ((location = find_location(ch, argument)) == NULL)
    {
        char_act("No such location.", ch);
        return;
    }

    path = find_way(ch, ch->in_room, location);
    char_printf(ch, "%s.\n", path);
    log_printf("From %d to %d: %s.\n",
               ch->in_room->vnum, location->vnum, path);
    return;
}

DO_FUN(do_reboot)
{
    char arg[MAX_INPUT_LENGTH];
    if (ch->level > 100)
    {
        trim_ch(ch);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Usage: reboot now", ch);
        char_act("Usage: reboot <ticks to reboot>", ch);
        char_act("Usage: reboot cancel", ch);
        char_act("Usage: reboot status", ch);
        char_act("Usage: reboot compile", ch);
        return;
    }

    if (is_name(arg,"cancel"))
    {
        reboot_counter = -1;
        char_act("Reboot canceled.", ch);
        return;
    }

    if (is_name(arg, "now"))
    {
        reboot_muddy();
        return;
    }

    if (is_name(arg, "status"))
    {
        if (reboot_counter == -1)
            char_printf(ch, "Automatic rebooting is inactive.\n");
        else
            char_printf(ch, "Reboot in %i minutes.\n",
                        reboot_counter);
        return;
    }

    if (is_name(arg, "compile"))
    {
        char_printf(ch, "Start compiling and installing new version.\n");
        system("/bin/chmod 750 compile &");
        system("bin/compile &");
        return;
    }

    if (is_number(arg))
    {
        reboot_counter = atoi(arg);
        rebooter = 1;
        char_printf(ch, "Muddy will reboot in %i ticks.\n",
                    reboot_counter);
        return;
    }

    do_reboot(ch, str_empty);
}

void reboot_muddy(void)
{
    extern bool merc_down;
    DESCRIPTOR_DATA *d,*d_next;

    save_conquered_areas ();
    save_stat_record ();
    save_gq ();

    log(" Astrum Metaphora.");
    for (d = descriptor_list; d != NULL; d = d_next)
    {
        d_next = d->next;
        write_to_buffer(d,"    Astrum Metaphora!\n", 0);
        if (d->character)
            save_char_obj(d->character, TRUE, TRUE);
        close_descriptor(d);
    }
    merc_down = TRUE;
}

DO_FUN(do_msgstat)
{
    varr *v;
    mlstring **mlp;
    int i;
    BUFFER *output;

    if (argument[0] == '\0')
    {
        for (i = 0; i < MAX_MSG_HASH; i++)
        {
            varr *v = msg_hash_table+i;
            char_printf(ch, "%3d: %d msgs\n",
                        i, v ? v->nused : 0);
        }
        return;
    }

    if (!is_number(argument))
    {
        do_help(ch, "MSGSTAT");
        return;
    }

    i = atoi(argument);
    if (i < 0 || i >= MAX_MSG_HASH)
    {
        char_printf(ch, "Valid hash key range is 0..%d\n",
                    MAX_KEY_HASH);
        return;
    }

    v = msg_hash_table+i;
    output = buf_new(-1);
    buf_printf(output, "Dumping msgs with hash #%d\n", i);
    for (i = 0; i < v->nused; i++)
    {
        mlp = VARR_GET(v, i);
        msg_dump(output, *mlp);
        buf_add(output, "\n");
    }
    page_to_char(buf_string(output), ch);
    buf_free(output);
}

extern int str_count;
extern int str_real_count; /* XXX */

DO_FUN(do_strstat)
{
    char_printf(ch, "Strings: %d\n"
                "Allocated: %d\n",
                str_count, str_real_count);
}

DO_FUN(do_grant)
{
    int i;
    command_t *cmd;
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    if (ch->level > 100)
    {   trim_ch(ch);
        return;
    }

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));
    if (arg1[0] == '\0') {
        do_help(ch, "'WIZ GRANT'");
        return;
    }

    if ((victim = get_char_room(ch, arg1)) == NULL) {
        char_act("They aren't here.", ch);
        return;
    }

    if (IS_NPC(victim)) {
        char_act("Not on NPC.", ch);
        return;
    }

    if (arg2[0] == '\0') {
        char_printf(ch, "Granted commands for %s: [%s]\n",
                victim->name, victim->pcdata->granted);
        return;
    }

    if (is_number(arg2)) {
        int lev = atoi(arg2);

        if (lev < LEVEL_IMMORTAL) {
            char_printf(ch, "grant: granted level must be at least %d\n", LEVEL_HERO);
            return;
        }

        if (lev > ch->level) {
            char_act("grant: granted level cannot be higher than yours.", ch);
            return;
        }

        for (i = 0; i < commands.nused; i++) {
            if (COMMAND(i)->level < LEVEL_HERO
            ||  COMMAND(i)->level > lev)
                continue;

            name_add(ch, COMMAND(i)->name, "grant",
                 &victim->pcdata->granted);
        }

        return;
    }

    for (; arg2[0]; argument = one_argument(argument, arg2, sizeof(arg2))) {
        if (str_cmp(arg2, "none") &&  str_cmp(arg2, "all"))
        {
            if ((cmd = command_lookup(arg2, str_cmp)) == NULL) {
                char_printf(ch, "%s: command not found.\n", arg2);
            continue;
            }

            if (cmd->level < LEVEL_IMMORTAL) {
                char_printf(ch, "%s: not a wizard command.\n", arg2);
                continue;
            }
        }
        name_toggle(ch, arg2, "grant", &victim->pcdata->granted);
    }
}

DO_FUN(do_disable)
{
    int i;
    command_t *cmd;
    char arg[MAX_INPUT_LENGTH];
    if (ch->level > 100)
    {   trim_ch(ch);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0') {
        do_help(ch, "'WIZ ENABLE DISABLE'");
        return;
    }

    if (!str_cmp(arg, "?")) {
        char_act("Disabled commands:", ch);
        for (i = 0; i < commands.nused; i++)
            if (IS_SET(COMMAND(i)->flags, COMMAND_DISABLED))
                char_printf(ch, "%s\n", COMMAND(i)->name);
        return;
    }

    for (; arg[0]; argument = one_argument(argument, arg, sizeof(arg))) {
        if ((cmd = command_lookup(arg, str_cmp)) < 0) {
            char_printf(ch, "%s: command not found.\n", arg);
            continue;
        }

        if (!str_cmp(cmd->name, "enable")) {
            char_act("'enable' command cannot be disabled.",
                  ch);
            return;
        }

        SET_BIT(cmd->flags, COMMAND_DISABLED);
        char_printf(ch, "%s: command disabled.\n", cmd->name);
    }
}

DO_FUN(do_enable)
{
    command_t *cmd;
    char arg[MAX_INPUT_LENGTH];
    if (ch->level > 100)
    {   trim_ch(ch);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));
    if (arg[0] == '\0') {
        do_help(ch, "'WIZ ENABLE DISABLE'");
        return;
    }

    for (; arg[0]; argument = one_argument(argument, arg, sizeof(arg))) {
        if ((cmd = command_lookup(arg, str_cmp)) == NULL) {
            char_printf(ch, "%s: command not found.\n", arg);
            continue;
        }

        REMOVE_BIT(cmd->flags, COMMAND_DISABLED);
        char_printf(ch, "%s: command enabled.\n", cmd->name);
    }
}

DO_FUN(do_immname)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    if (ch->level > 100)
    {
        trim_ch(ch);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Change whose imm_name to what?", ch);
        return;
    }

    victim = get_char_world(ch, arg);
    if (victim == NULL)
    {
        char_act("Nobody is playing with that name.", ch);
        return;
    }

    if (IS_NPC(victim))
    {
        char_act("Not on NPC's.", ch);
        return;
    }

    if (victim->level <= LEVEL_HERO)
    {
        char_act("Not on mortales.", ch);
        return;
    }

    if (argument[0] == '\0')
    {
        char_act("Change the imm_name to what?", ch);
        return;
    }

    if (ch->level < victim->level)
    {
        char_act(" .", ch);
        return;
    }

    free_string(victim->imm_name);
    victim->imm_name = str_dup(argument);

    char_act("Ok.", ch);
}

DO_FUN(do_confiscate)
{
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    char arg1[MAX_INPUT_LENGTH], arg2[MAX_INPUT_LENGTH];
    bool found = FALSE;
    if (ch->level > 100)
    {
        trim_ch(ch);
        return;
    }

    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));

    if (IS_NPC(ch))
        return;

    if (arg1[0] == '0' || arg2[0] == '\0')
    {
        char_act("Syntax: confiscate <char> <item>", ch);
        return;
    }

    if ((victim = get_char_world(ch,arg1)) == NULL
        || IS_NPC(victim))
    {
        char_act("They aren't here.", ch);
        return;
    }

    if (victim->level > ch->level)
    {
        char_act("They are too high level for you to do that.", ch);
        return;
    }

    for (obj = victim->carrying; obj != NULL; obj = obj->next_content)
    {
        if (is_name(arg2, obj->name)
            &&  can_see_obj(ch, obj))
        {
            found = TRUE;
            break;
        }
    }

    if (!found)
    {
        char_printf(ch, "They don't have %s.\n", arg2);
        return;
    }

    obj_from_char(obj);
    obj_to_char(obj, ch);
    char_act("Got it!", ch);
    act("$n has confiscated $p from you.", ch, obj, victim, TO_VICT);

    return;
}

DO_FUN(do_add_qp)
{
    CHAR_DATA *victim;
    char arg1[MAX_INPUT_LENGTH], arg2[MAX_INPUT_LENGTH];
    int amount;
    if (ch->level > 100)
    {
        trim_ch(ch);
        return;
    }
    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));

    amount = atoi(arg2);

    if (arg1[0] == '0' || amount == 0)
    {
        char_act("Syntax: add_qp <char> <amount>", ch);
        return;
    }

    if ((victim = get_char_world(ch,arg1)) == NULL
        || IS_NPC(victim))
    {
        char_act("They aren't here.", ch);
        return;
    }

    if (amount < 0 && victim->pcdata->questpoints + amount < 0)
    {
        act_puts("They have only $j quest $qj{points}.", ch, (const void *) victim->pcdata->questpoints, victim, TO_CHAR, POS_DEAD);
        return;
    }

    victim->pcdata->questpoints += amount;

    if (amount > 0)
        act_puts("$n added $j quest points to you!", ch, (const void *) amount, victim, TO_VICT, POS_DEAD);
    else
        act_puts("$n gets $j quest points from you!", ch, (const void *) (-amount), victim, TO_VICT, POS_DEAD);
    char_act("Ok.", ch);

    return;
}

DO_FUN(do_add_bp)
{
    CHAR_DATA *victim;
    char arg1[MAX_INPUT_LENGTH], arg2[MAX_INPUT_LENGTH];
    int amount;
    if (ch->level > 100)
    {
        trim_ch(ch);
        return;
    }
    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));

    if (IS_NPC(ch))
        return;

    amount = atoi(arg2);

    if (arg1[0] == '0' || amount == 0)
    {
        char_act("Syntax: add_bp <char> <amount>", ch);
        return;
    }

    if ((victim = get_char_world(ch,arg1)) == NULL
        || IS_NPC(victim))
    {
        char_act("They aren't here.", ch);
        return;
    }

    if (amount < 0 && victim->pcdata->bonuspoints + amount < 0)
    {
        act_puts("They have only $j bonus $qj{points}.", ch, (const void *) (victim->pcdata->bonuspoints), NULL, TO_CHAR, POS_DEAD);
        return;
    }

    victim->pcdata->bonuspoints += amount;

    if (amount > 0)
        act_puts("$n added $j bonus points to you!", ch, (const void *) amount, victim, TO_VICT, POS_DEAD);
    else
        act_puts("$n gets $j bonus points from you!", ch, (const void *) abs(amount), victim, TO_VICT, POS_DEAD);

    char_act("Ok.", ch);

    return;
}


DO_FUN(do_add_rp)
{
    CHAR_DATA *victim;
    char arg1[MAX_INPUT_LENGTH], arg2[MAX_INPUT_LENGTH];
    int amount;
    if (ch->level > 100)
    {
        trim_ch(ch);
        return;
    }
    argument = one_argument(argument, arg1, sizeof(arg1));
    argument = one_argument(argument, arg2, sizeof(arg2));

    if (IS_NPC(ch))
        return;

    amount = atoi(arg2);

    if (arg1[0] == '0' || amount == 0)
    {
        char_act("Syntax: add_rp <char> <amount>", ch);
        return;
    }

    if ((victim = get_char_world(ch,arg1)) == NULL
        || IS_NPC(victim))
    {
        char_act("They aren't here.", ch);
        return;
    }

    if (amount < 0 && victim->pcdata->religionpoints + amount < 0)
    {
        act_puts("They have only $j religion $qj{points}.", ch, (const void *) (victim->pcdata->religionpoints), NULL, TO_CHAR, POS_DEAD);
        return;
    }

    victim->pcdata->religionpoints += amount;

    if (amount > 0)
        act_puts("$n added $j religion points to you!", ch, (const void *) amount, victim, TO_VICT, POS_DEAD);
    else
        act_puts("$n gets $j religion points from you!", ch, (const void *) abs(amount), victim, TO_VICT, POS_DEAD);

    char_act("Ok.", ch);

    return;
}

DO_FUN(do_addapply)
{
    OBJ_DATA *obj;
    AFFECT_DATA af_new;
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    char arg3[MAX_INPUT_LENGTH];
    int affect_modify = 1, enchant_type;
    if (ch->level > 100)
    {
        trim_ch(ch);
        return;
    }
    argument = one_argument( argument, arg1 , sizeof(arg1 ));
    argument = one_argument( argument, arg2 , sizeof(arg2 ));
    argument = one_argument( argument, arg3 , sizeof(arg3 ));

    if (arg1[0] == '\0' || arg2[0] == '\0' || arg3[0] == '\0')
    {
        char_act("Syntax: addapply <object> <apply> <value>", ch);
        return;
    }

    if ((obj = get_obj_world(ch,arg1)) == NULL)
    {
        char_act("No such object exists!", ch);
        return;
    }

    if (!str_cmp(arg2,"hp"))
        enchant_type=APPLY_HIT;
    else if (!str_cmp(arg2,"str"))
        enchant_type=APPLY_STR;
    else if (!str_cmp(arg2,"dex"))
        enchant_type=APPLY_DEX;
    else if (!str_cmp(arg2,"int"))
        enchant_type=APPLY_INT;
    else if (!str_cmp(arg2,"wis"))
        enchant_type=APPLY_WIS;
    else if (!str_cmp(arg2,"con"))
        enchant_type=APPLY_CON;
    else if (!str_cmp(arg2,"mana"))
        enchant_type=APPLY_MANA;
    else if (!str_cmp(arg2,"move"))
        enchant_type=APPLY_MOVE;
    else if (!str_cmp(arg2,"ac"))
        enchant_type=APPLY_AC;
    else if (!str_cmp(arg2,"hitroll"))
        enchant_type=APPLY_HITROLL;
    else if (!str_cmp(arg2,"damroll"))
        enchant_type=APPLY_DAMROLL;
    else if (!str_cmp(arg2,"saves"))
        enchant_type=APPLY_SAVING_SPELL;
    else if (!str_cmp(arg2,"level"))
        enchant_type=APPLY_LEVEL;
    else
    {
        char_act("That apply is not possible!", ch);
        char_act("possible applyes is: hp, mana, move, str, dex, int, wis, con, ac, hitroll, damroll, saves, level.", ch);
        return;
    }

    if (!is_number(arg3))
    {
        char_act("Applies require a value.", ch);
        return;
    }

    affect_modify = atoi(arg3);

    af_new.where           = TO_OBJECT;
    af_new.type            = gsn_reserved;
    af_new.level           = ch->level;
    af_new.duration        = -1;
    af_new.location        = enchant_type;
    af_new.modifier        = affect_modify;
    af_new.bitvector       = 0;
    affect_to_obj(obj, &af_new);

    char_act("Ok.", ch);

    return;
}

void do_pload (CHAR_DATA * ch, const char * argument)
{
    CHAR_DATA *wch;

    if (IS_NULLSTR(argument))
    {
        char_act("Incorrect character request (argument).", ch);
        return;
    }

    if ((wch = gq_findchar(argument)) != NULL)
    {
        char_act("That person is already connected or loaded!", ch) ;
        return ;
    }

    if ((wch = char_load_special(argument)) == NULL)
    {
        char_act("You're trying to load unexistent character!", ch) ;
        return;
    }

    // what a paranoia? imho char_load_special wouldn't set desc to != NULL
    wch->desc = NULL;

    reset_char (wch);

    // bring player to imm
    if (wch->in_room != NULL)
    {
        wch->was_in_room = wch->in_room ;
        char_to_room (wch, ch->in_room) ;
    }

    act("$n has pulled $N from the pattern!", ch, NULL, wch, TO_ROOM) ;
    act_puts("$N loaded.", ch, NULL, wch, TO_CHAR, POS_DEAD);

    if (wch->pet != NULL)
    {
        char_to_room (wch->pet, wch->in_room) ;
        act("$n has entered the game.", wch->pet, NULL, NULL, TO_ROOM) ;
    }
}

void do_punload (CHAR_DATA * ch, const char * argument)
{
    CHAR_DATA * victim;

    if (IS_NULLSTR(argument))
    {
        char_act("Incorrect character request (argument).", ch);
        return;
    }

    victim = gq_findchar(argument);

    if (victim == NULL)
    {
        char_act("They aren't here.", ch);
        return ;
    }

    // person is legitametly logged on... was not ploaded
    if (victim->desc != NULL)
    {
        char_act("I dont think that would be a good idea...", ch) ;
        return ;
    }

    act("$n has released $N back to the Pattern.", ch, NULL, victim, TO_ROOM) ;
    act_puts("$N unloaded.", ch, NULL, victim, TO_CHAR, POS_DEAD);

    char_nuke(victim);

    // doesn't make any sense no more for the char_nuke receives value,
    // not reference and therefore is not able to return any shit
    /*
    if (ch)
    {
        if (victim == NULL)
            char_act("Success.", ch);
        else
            char_act("Failure.", ch);
    }
    */
}

DO_FUN(do_renegate)
{
    DESCRIPTOR_DATA d ;
    char            arg1 [512] ;
    CHAR_DATA     * victim ;
    clan_t     * clan   ;
    CLAN_MEMBER   * member ;
    CLAN_MEMBER   * prev   ;
    OBJ_DATA      * mark   ;

    if (ch->level < MAX_LEVEL - 3)
    {
        char_act("Not at your level!", ch) ;
        return ;
    }

    argument = one_argument(argument, arg1, sizeof(arg1)) ;

    if (get_char_world(ch, arg1) != NULL)
    {
        send_to_char (": petition <clan name> <accept | reject> <char name>\n\r", ch) ;
        return ;
    }

    // load...
    // Welesh : golem/pet load fix
    //load_char_obj (&d, arg1, TRUE) ;
    load_char_obj (&d, arg1, FALSE) ;

    d.character->desc     = NULL        ;
    d.character->next     = char_list   ;
    char_list             = d.character ;
    d.connected           = CON_PLAYING ;
    reset_char (d.character) ;

    if ((victim = get_char_world (ch, arg1)) == NULL)
    {
        send_to_char ("They aren't here.\n\r", ch) ;
        return ;
    }

    // reject player
    // remove player from the members list

    clan = CLAN (victim->clan) ; prev = NULL ;
    for (member = clan->member_list ; member ; prev = member, member = member->next)
    {
        if (str_cmp (member->name, victim->name)) continue ;

        // memory clean-up
        free_string (member->name) ;
        free_string (member->last_login) ;

        if (prev) prev->next   = member->next ;
        else clan->member_list = member->next ;

        --clan->cur_clan_members ;

        free (member) ;
        break ;
    }

    victim->clan             = CLAN_NONE ;
    victim->pcdata->petition = CLAN_NONE ;

    update_skills (victim) ;

    mark = get_eq_char (victim, WEAR_CLANMARK) ;
    if (mark != NULL)
    {
        unequip_char (victim, mark) ;
        extract_obj  (mark) ;
    }

    // save player and quit
    save_char_obj (victim, FALSE, FALSE) ;
    do_quit       (victim, str_empty) ;
}

void do_check( CHAR_DATA *ch, const char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    const char *immdesc;
    BUFFER *buffer;
    CHAR_DATA *victim;
    int count = 1;

    argument = one_argument(argument, arg , sizeof(arg ));

    if (arg[0] == '\0' || !str_prefix(arg,"stats"))
    {
        buffer = buf_new(ch->lang);
        for (victim = char_list; victim != NULL; victim = victim->next)
        {
            if (!victim || !victim->desc)
                continue;

            if (IS_NPC(victim) || !can_see(ch,victim))
                continue;

            if (victim->desc == NULL)
            {
                snprintf(buf, sizeof(buf),"%3d) %s is linkdead.\n\r", count, victim->name);
                buf_add(buffer, buf);
                count++;
                continue;
            }

            if (victim->desc->connected >= CON_GET_NEW_RACE
                && victim->desc->connected <= CON_PICK_WEAPON)
            {
                snprintf(buf, sizeof(buf),"%3d) %s is being created.\n\r",
                        count, victim->name);
                buf_add(buffer, buf);
                count++;
                continue;
            }

            if ((victim->desc->connected == CON_GET_OLD_PASSWORD
                 || victim->desc->connected >= CON_READ_IMOTD))
            {
                snprintf(buf, sizeof(buf),"%3d) %s is connecting.\n\r",
                        count, victim->name);
                buf_add(buffer, buf);
                count++;
                continue;
            }

            if (victim->desc->connected == CON_PLAYING)
            {
                snprintf(buf, sizeof(buf),"%3d) %s, {CLevel %d {xconnected since{c %d {xhours (%d total hours)\n\r",
                        count, victim->name,victim->level,
                        ((int)(current_time - victim->logon)) /3600,
                        (victim->played + (int)(current_time - victim->logon)) /3600 );
                buf_add(buffer, buf);
                if (arg[0]!='\0' && !str_prefix(arg,"stats"))
                {
                    snprintf(buf, sizeof(buf),"{C  %d {RHP{C %d {BMana{x (%d %d %d %d %d %d).\n\r",
                            victim->max_hit, victim->max_mana,victim->perm_stat[STAT_STR],
                            victim->perm_stat[STAT_INT],victim->perm_stat[STAT_WIS],
                            victim->perm_stat[STAT_DEX],victim->perm_stat[STAT_CON],
                            victim->perm_stat[STAT_LCK]);
                    buf_add(buffer, buf);
                }
                count++;
                continue;
            }

            snprintf(buf, sizeof(buf),"%3d) bug (oops)...please report to GrayMage: %s %d\n\r",
                    count, victim->name, victim->desc->connected);
            buf_add(buffer, buf);
            count++;
        }
        page_to_char(buf_string(buffer),ch);
        buf_free(buffer);
        return;
    }

    if (!str_prefix(arg, "vnums"))
    {
        char arg1[MAX_INPUT_LENGTH];
        int min, max;
        AREA_DATA *area;
        argument = one_argument(argument, arg1, sizeof(arg1));
        if (IS_NULLSTR(arg1))
        {
            return;
        }
        min = atoi(arg1);
        if (IS_NULLSTR(argument))
            max = min;
        else
            max = atoi(argument);
        if ((area = check_range(NULL, min, max)) == NULL)
        {
            char_act("These vnums are available.", ch);
            return;
        }
        act_puts3("Area $T has vnums $j-$J.", ch, (const void *) area->min_vnum, area->name, (const void *) area->max_vnum, TO_CHAR, POS_DEAD);
        return;
    }

    if (!str_prefix(arg, "alias"))
    {
        int i; 
	    for (i = 0; i < commands.nused; i++) 
        {
		    command_t *command = VARR_GET(&commands, i);
            int j; 
            bool found = FALSE;
            for (j = 0; j < aliases.nused; j++)
            {
                alias_t * alias = ALIAS(j);

                if (command == alias->command)
                {
                    found = TRUE;
                    break;
                }
            }
            if (!found)
                char_printf(ch, "%s\n", command->name);
        }
        return;
    }

    if (!str_prefix(arg, "russian"))
    {
        DESCRIPTOR_DATA * d;
        int total = 0, count = 0;

        char_act ("{x     Use rusnames:", ch);
        for (d = descriptor_list; d != NULL; d = d->next) 
        {
            if (d->connected != CON_PLAYING)
                continue;
            victim = d->character;
            if (IS_SET(victim->comm2, COMM2_RUSNAMES))
            {
                act("$t ", ch, victim->name, NULL, TO_CHAR | ACT_NOLF | ACT_NOUCASE);
                ++count;
            }
            ++total;
        }
        char_printf (ch, "\n      %d of %d.\n\n", count, total);

        count = 0;
        char_act ("{x     Use russkills:", ch);
        for (d = descriptor_list; d != NULL; d = d->next) 
        {
            if (d->connected != CON_PLAYING)
                continue;
            victim = d->character;
            if (IS_SET(victim->comm2, COMM2_RUSSKILLS))
            {
                act("$t ", ch, victim->name, NULL, TO_CHAR | ACT_NOLF | ACT_NOUCASE);
                ++count;
            }
        }
        char_printf (ch, "\n      %d of %d.\n\n", count, total);

        return;
    }

    if (!str_prefix(arg,"eq"))
    {
        buffer = buf_new(-1);
        for (victim = char_list; victim != NULL; victim = victim->next)
        {
            if (!victim || !victim->desc)
                continue;

            if (IS_NPC(victim)
                || victim->desc->connected != CON_PLAYING
                || !can_see(ch,victim))
                continue;

            snprintf(buf, sizeof(buf),"%3d) %s, %d items (weight %d) Hit:{c%d {xDam:{c%d {xSave:{c%d {xAC:{c%d %d %d %d{x.\n\r",
                    count, victim->name, victim->carry_number, victim->carry_weight,
                    victim->hitroll, victim->damroll, victim->saving_throw,
                    victim->armor[AC_PIERCE], victim->armor[AC_BASH],
                    victim->armor[AC_SLASH], victim->armor[AC_EXOTIC]);
            buf_add(buffer, buf);
            count++;
        }
        page_to_char(buf_string(buffer),ch);
        buf_free(buffer);
        return;
    }

    if (!str_prefix(arg,"limits"))
    {
        buffer = buf_new(-1);
        for (victim = char_list; victim != NULL; victim = victim->next)
        {
            if (!victim || !victim->desc)
                continue;

            if (IS_NPC(victim)
                || victim->desc->connected != CON_PLAYING
                || !can_see(ch,victim))
                continue;

            snprintf(buf, sizeof(buf), "%3d) %15s :{c%d{x.\n\r",  count, victim->name, victim->pcdata->limit_timer) ;

            buf_add(buffer, buf);
            count++;
        }
        page_to_char(buf_string(buffer),ch);
        buf_free(buffer);
        return;
    }


    if (!str_prefix(arg,"levels"))
    {
        if (ch->level < MAX_LEVEL - 5)
        {
            send_to_char("{RYou can't use this check option.{x\n\r", ch);
            return;
        }

        buffer = buf_new(-1);
        snprintf(buf, sizeof(buf), "Char, {Yreal_level{x, {ylevel{x :\n");
        buf_add(buffer, buf);

        for (victim = char_list; victim != NULL; victim = victim->next)
        {
            if (!victim || !victim->desc) continue;

            if (IS_NPC(victim) || victim->desc->connected != CON_PLAYING)
                continue;
            if (victim->pcdata->real_level == victim->level) continue;

            snprintf(buf, sizeof(buf), "%3d) %14s :{Y%d{x/{y%d{x.\n\r", count, victim->name, victim->pcdata->real_level, victim->level) ;

            buf_add(buffer, buf);
            count++;
        }
        page_to_char(buf_string(buffer),ch);
        buf_free(buffer);
        return;
    }

    if (!str_prefix(arg,"snoop"))
    {
        char bufsnoop [100];

        if (ch->level < MAX_LEVEL - 5)
        {
            send_to_char("{RYou can't use this check option.{x\n\r", ch);
            return;
        }
        buffer = buf_new(-1);

        for (victim = char_list; victim != NULL; victim = victim->next)
        {
            if (!victim || !victim->desc)
                continue;

            if (IS_NPC(victim)
                || victim->desc->connected != CON_PLAYING
                || !can_see(ch,victim))
                continue;

            if (victim->desc->snoop_by != NULL)
                snprintf(bufsnoop, sizeof(bufsnoop),"{C %15s {x.", victim->desc->snoop_by->character->name);
            else
                snprintf(bufsnoop, sizeof(bufsnoop),"     (none)      ." );

            snprintf(buf, sizeof(buf),"%3d %15s : %s \n\r", count,victim->name, bufsnoop);
            buf_add(buffer, buf);
            count++;
        }
        page_to_char(buf_string(buffer),ch);
        buf_free(buffer);
        return;
    }

    if (!str_prefix(arg,"desc")) /* part by NimNull */
    {
        char bufdesc [1023];

        buffer = buf_new(-1);

        for (victim = char_list; victim != NULL; victim = victim->next)
        {
            if (!victim || !victim->desc)
                continue;

            if (IS_NPC(victim)
                || victim->desc->connected != CON_PLAYING
                || !can_see(ch,victim))
                continue;

            immdesc = mlstr_cval (victim->immdesc, ch);

            if (!IS_NULLSTR (immdesc))
            {
                snprintf(bufdesc, sizeof(bufdesc), "   :\n\r %s {x", immdesc);
                snprintf(buf, sizeof(buf),"%3d %15s : %s \n\r", count,victim->name, bufdesc);
                buf_add (buffer, buf);
                count++;
            }
        }

        page_to_char(buf_string(buffer),ch);
        buf_free(buffer);
        return;
    }
    if (!str_prefix(arg, "links"))
    {
        const char *links;
        if (ch->level < MAX_LEVEL - 5)
        {
            send_to_char("{RYou can't use this check option.{x\n\r", ch);
            return;
        }

        buffer = buf_new(-1);
        for (victim = char_list; victim != NULL; victim = victim->next)
        {
            if (!victim || !victim->desc)
                continue;
            if (IS_NPC(victim)
                || victim->desc->connected != CON_PLAYING
                || !can_see(ch,victim))
                continue;
            links = str_dup(victim->pcdata->linked_list);
            if (!IS_NULLSTR (links) && str_cmp(links, victim->name))
            {
                snprintf(buf, sizeof(buf), "%3d %15s: [%s]\n\r", count,victim->name, links);
                buf_add (buffer, buf);
                count++;
            }
            free_string(links);
        }
        page_to_char(buf_string(buffer),ch);
        buf_free(buffer);
        return;
    }

    send_to_char("Syntax: '{Ccheck{x'          {cdisplay info about players{x\n\r", ch);
    send_to_char("        '{Ccheck {Bstats{x'  {cdisplay info and resume stats{x\n\r", ch);
    send_to_char("        '{Ccheck {Beq{x'     {cresume eq of all players{x\n\r", ch);
    send_to_char("        '{Ccheck {Blimits{x' {cdisplay limit timer of all players{x\n\r", ch);
    send_to_char("        '{Ccheck {Bsnoop{x'  {cresume snooper's of players{x\n\r", ch);
    send_to_char("        '{Ccheck {Blevels{x' {cshow char levels{x\n\r", ch);
    send_to_char("        '{Ccheck {Bdesc{x'   {cdisplay players immdesc{x\n\r", ch);
    send_to_char("        '{Ccheck {Blinks{x'  {cshow links of all players{x\n\r", ch);
    send_to_char("        '{Ccheck {Bvnums{x'  {cGalka's part...{x\n\r", ch);
    send_to_char("Use the stat command in case of doubt about someone...\n\r", ch);
    return;
}

void do_specreset( CHAR_DATA *ch, const char *argument )
{
    CHAR_DATA *victim;
    char arg[MAX_INPUT_LENGTH];
    one_argument(argument, arg, sizeof(arg));
    if ((victim = get_char_world(ch, arg)) == NULL)
    {
        char_act("They aren't here.", ch);
        return;
    }
    if (IS_NPC(victim))
    {
        char_act("NPC's haven't specializations.", ch);
        return;
    }
    victim->pcdata->specialization[0] = 0;
    victim->pcdata->specialization[1] = 0;
    victim->pcdata->specialization[2] = 0;
    update_special_skills(victim, FALSE);
    act("$N's weapon specializations reseted.",
        ch, NULL, victim, TO_CHAR);

}

void trim_ch(CHAR_DATA *ch)
{   DESCRIPTOR_DATA *d;
    for (d = descriptor_list; d != NULL; d = d->next)
        if (d == ch->desc)
        {
            close_descriptor(d);
            log_printf("Log: %s tries to use imm command being level above 100 - REJECTED.", ch->name);
            return;
        }
}

unsigned long get_next_seconds(const char *argument, CHAR_DATA *ch)
{
    char buf[MAX_STRING_LENGTH];
    int days = 0;

    one_argument(argument, buf, sizeof(buf));

    if (buf[0] != '\0')
    {
        if (!is_number(buf))
        {
            char_act("Argument should be a number!", ch);
            return 0;
        }

        days = atoi(buf);
    }

    if (days <= 0)
        return 0;

    return current_time + 60 * 60 * 24 * days;
}

DO_FUN(do_immdescription)
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    if (ch->level > 100)
    {
        trim_ch(ch);
        return;
    }

    argument = one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Change whose imm_name to what?", ch);
        return;
    }

    victim = get_char_world(ch, arg);
    if (victim == NULL)
    {
        char_act("Nobody is playing with that name.", ch);
        return;
    }

    if (IS_NPC(victim))
    {
        char_act("Not on NPC's.", ch);
        return;
    }

    if (ch->level < victim->level)
    {
        char_act(" .", ch);
        return;
    }

    string_append(ch, mlstr_convert(&victim->immdesc, -1));
    char_printf(ch, "    :\n"
                "%s\n",
                mlstr_mval(victim->immdesc));

}

void do_fvlist (CHAR_DATA *ch, const char *argument)
{
    int i,j;
    char arg[MAX_INPUT_LENGTH];
    BUFFER *output;

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        send_to_char("Syntax:\n\r", ch);
        send_to_char("  fvlist obj\n\r", ch);
        send_to_char("  fvlist mob\n\r", ch);
        send_to_char("  fvlist room\n\r", ch);
        return;
    }
    j=1;
    if (!str_cmp(arg,"obj"))
    {
        output = buf_new(-1);
        buf_printf(output,"{WFree {C%s{W vnum listing for area {C%s{x\n\r", arg, ch->in_room->area->name);
        buf_printf(output,"{Y=============================================================================={x\n\r");
        for (i = ch->in_room->area->min_vnum; i <= ch->in_room->area->max_vnum; i++)
        {
            if (get_obj_index(i) == NULL)
            {
                buf_printf(output,"%8d ", i);
                if (j == 5)
                {
                    buf_printf(output, "\n\r");
                    j=0;
                }
                j++;
            }
        }
        buf_printf(output,"\n\r");
        page_to_char(buf_string(output), ch);
        buf_free(output);
        return;
    }

    if (!str_cmp(arg,"mob"))
    {
        output = buf_new(-1);
        buf_printf(output,"{WFree {C%s{W vnum listing for area {C%s{x\n\r", arg, ch->in_room->area->name);
        buf_printf(output,"{Y=============================================================================={x\n\r");
        for (i = ch->in_room->area->min_vnum; i <= ch->in_room->area->max_vnum; i++)
        {
            if (get_mob_index(i) == NULL)
            {
                buf_printf(output,"%8d ", i);
                if (j == 5)
                {
                    buf_printf(output,"\n\r");
                    j=0;
                } else j++;
            }
        }
        buf_printf(output,"\n\r");
        page_to_char(buf_string(output), ch);
        buf_free(output);
        return;
    }
    if (!str_cmp(arg,"room"))
    {
        output = buf_new(-1);
        buf_printf(output,"{WFree {C%s{W vnum listing for area {C%s{x\n\r", arg, ch->in_room->area->name);
        buf_printf(output,"{Y=============================================================================={x\n\r");
        for (i = ch->in_room->area->min_vnum; i <= ch->in_room->area->max_vnum; i++)
        {
            if (get_room_index(i) == NULL)
            {
                buf_printf(output,"%8d ", i);
                if (j == 5)
                {
                    buf_printf(output,"\n\r");
                    j=0;
                } else j++;
            }
        }
        buf_printf(output,"\n\r");
        page_to_char(buf_string(output), ch);
        buf_free(output);
        return;
    }
    send_to_char("Syntax:\n\r", ch);
    send_to_char("  fvlist obj\n\r", ch);
    send_to_char("  fvlist mob\n\r", ch);
    send_to_char("  fvlist room\n\r", ch);
}

void do_objectfindwearlocation( CHAR_DATA *ch, const char *argument )
{
    extern int top_obj_index;
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    char arg1[MAX_INPUT_LENGTH];
    OBJ_INDEX_DATA *pObjIndex = NULL;
    int vnum = -1;
    int nMatch = 0;
    bool fAll = FALSE;
    bool found = FALSE;
    int intFind = 0;
    int intFound = -1;
    BUFFER *output;
    int j = 1;

    if (ch == NULL)
    {
        bug( "*BUG* File: objectfindwearlocation.c | Function:  do_objectfindwearlocation | Error: ch = NULL", 0 );
        return;
    }

    argument = one_argument( argument, arg, sizeof(arg));
    one_argument( argument, arg1, sizeof(arg1) );

    if (arg[0] == '\0')
    {
        send_to_char( "Syntax: ofwl <wear location>.\n\r", ch );
        send_to_char( "Syntax: ofwl <wear location> <nonvnum>.\n\r", ch );
        return;
    }

    output = buf_new(-1);

    for (intFind = 0; wear_flags[intFind].name != NULL; intFind++)
    {
        snprintf(buf, sizeof(buf), "%s ", wear_flags[intFind].name);
        if (!str_cmp (wear_flags[intFind].name, arg))
            intFound = intFind;
    }


    if (intFound < 0)
    {
        send_to_char( "No this wear location{x.\n\r", ch );
        send_to_char( "Possible location{x:\n\r\n\r{W", ch );
        for (intFind = 0; wear_flags[intFind].name != NULL; intFind++)
        {
            snprintf(buf, sizeof(buf), "%s ", wear_flags[intFind].name);
            send_to_char( buf, ch );
            if (j == 12)
            {
                send_to_char("\n\r", ch);
                j=0;
            }
            j++;
        }

        send_to_char("\n\r", ch);
        return;
    }

    for (vnum = 0; nMatch < top_obj_index; vnum++)
    {
        if (( pObjIndex = get_obj_index( vnum ) ) != NULL)
        {
            nMatch++;
            if (fAll || CAN_WEAR(pObjIndex, wear_flags[intFound].bit))
            {
                found = TRUE;
                if (str_cmp(arg1,"nonvnum"))
                    buf_printf(output, "{x[%6d] %-25s ", pObjIndex->vnum, fmt_color_str(mlstr_mval(pObjIndex->short_descr),25) );
                else
                    buf_printf(output, "{x%-25s ", fmt_color_str(mlstr_mval(pObjIndex->short_descr),25) );
                if (j == 3)
                {
                    buf_printf(output,"\n\r");
                    j=0;
                }
                j++;
            }
        }
    }
    buf_printf(output,"\n\r");
    page_to_char(buf_string(output), ch);
    buf_free(output);

    if (!found)
        send_to_char( "No objects with this wear location found.\n\r", ch );

    return;
}

void do_owner (CHAR_DATA *ch, const char *argument)
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;

    argument = one_argument(argument, arg1, sizeof(arg1));
    one_argument(argument, arg2, sizeof(arg2));

    if (arg1[0] == '\0'
        || arg2[0] == '\0')
    {
        char_act("Syntax: owner <object> <value>", ch);
        return;
    }

    if ((obj = get_obj_carry(ch, arg1)) == NULL)
    {
        char_act("      .", ch);
        return;
    }

    free_string(obj->owner);
    obj->owner = str_dup(arg2);

    return;
}

void do_cache (CHAR_DATA *ch, const char *argument)
{
    CONNECTIONS_CACHE_ITEM* victim;
    char buf[MAX_STRING_LENGTH];
    BUFFER *buffer;
    int count = 0;

    buffer = buf_new(-1);
    snprintf(buf, sizeof(buf), "Num          Name   : Host Name / ttl \n");
    buf_add(buffer, buf);
    snprintf(buf, sizeof(buf), "======================================\n");
    buf_add(buffer, buf);

    for (victim = connectionsCache; victim != NULL; victim = victim->next)
    {
        if (!victim || victim->ignore_item)
            continue;

        snprintf(buf, sizeof(buf), "%3d) %14s :{Y%s{x/{y%d{x.\n\r",
                count, victim->name, victim->host, victim->ttl) ;

        buf_add(buffer, buf);
        count++;
    }
    page_to_char(buf_string(buffer),ch);
    buf_free(buffer);
    return;
}

DO_FUN(do_datetime)
{
    char_printf(ch, "Day: %d   Month: %d    Year: %d   Hour: %d.\n", time_info.day, time_info.month, time_info.year, time_info.hour);
    char_printf(ch, "SUNRISE: %d h.  SUNSET: %d h.\n\r", SUN_RISE_TIME, SUN_SET_TIME);
    return;
}

DO_FUN(do_CreateDeck)
{
    pcd = CreateDeck(0);
    return;
}

DO_FUN(do_CreateHand)
{
    pch = CreateHand(pcd);
    return;
}

DO_FUN(do_CreateTable)
{
    pct = CreateTable(pcd);
    return;
}

DO_FUN(do_StatDeck)
{
    BUFFER* buf;
    CardDeck* deck;

    buf = buf_new(-1);
    deck = pcd;

    VisualiseDeck(deck, buf);

    page_to_char(buf_string(buf), ch);
    buf_free(buf);
    return;
}

DO_FUN(do_gc)
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    int value;

    argument = one_argument(argument, arg1, sizeof(arg1));

    if (arg1[0] == '\0')            // no params, just display info
    {
        char_printf(ch, "Garbage collector status: {c%s{x\n",
                    gc.enabled ? "enabled" : "disabled");

        char_printf(ch, "Char scanning: {c%s{x\n",
                    gc.char_enabled ? "enabled" : "disabled");
        char_printf(ch, "Char scan period (pulses): {c%d{x\n", gc.pulse_char_default);

        char_printf(ch, "Room scanning: {c%s{x\n",
                    gc.room_enabled ? "enabled" : "disabled");
        char_printf(ch, "Room scan period (pulses): {c%d{x\n", gc.pulse_room_default);

        return;
    }

    if (!strcmp(arg1, "enable"))
    {
        gc.enabled = TRUE;
        char_puts("Garbage collector enabled.\n", ch);
        return;
    }

    if (!strcmp(arg1, "disable"))
    {
        gc.enabled = TRUE;
        char_puts("Garbage collector disabled.\n", ch);
        return;
    }


    if (!strcmp(arg1, "char"))
    {
        argument = one_argument(argument, arg2, sizeof(arg2));
        if (arg2[0] == '\0')
        {
            char_printf(ch, "Char scanning: {c%s{x\n",
                        gc.char_enabled ? "enabled" : "disabled");
            char_printf(ch, "Char scan period (pulses): {c%d{x\n", gc.pulse_char_default);
            return;
        }

        if (!strcmp(arg2, "enable"))
        {
            gc.char_enabled = TRUE;
            char_puts("Char scanning enabled.\n", ch);
            return;
        }

        if (!strcmp(arg2, "disable"))
        {
            gc.char_enabled = TRUE;
            char_puts("Char scanning disabled.\n", ch);
            return;
        }


        value = atoi(arg2);
        if (value == 0)
        {
            char_puts("Char scan period must be positive!\n", ch);
            return;
        }

        gc.pulse_char_default = value;
        return;
    }
}


DO_FUN(do_desc_check)
{
    DESCRIPTOR_DATA *d;
    bool             find;

    find = FALSE;

    for (d = descriptor_list; d != NULL; d = d->next)
    {
       if (d->connected == CON_PLAYING  && !IS_IMMORTAL(d->character) && d->character->level > 9)
           if (mlstr_mval(d->character->description)[0] == '\0')
           {
               char_printf(ch, "{Y%s {Whas empty descriptor{x.\n", d->character->name);
               find = TRUE;
           }
    }

    if(!find)
    {
        char_printf(ch, "{WNo character with empty descriptor{x.\n");
    }
    return;
}

void validate_materials(CHAR_DATA *ch)
{
     extern int       top_obj_index;
     OBJ_INDEX_DATA  *pObjIndex;
     int              vnum;
     int              j;
     bool             find;
     BUFFER          *output;
     int              total      = 0;

     find = FALSE;
     j = 1;

     output = buf_new(-1);
     buf_printf(output, "\nVnums with incorrect material.\n\r");

     for (vnum = 0; total < top_obj_index; vnum++)
     if ((pObjIndex = get_obj_index(vnum)) != NULL)
        {
            total ++;

            if (material_n_lookup(pObjIndex->material) < 0 )
            {
               buf_printf(output, "%6d  ", pObjIndex->vnum);
               if (j == 11)
               {
                    buf_printf(output,"\n\r");
                    j=0;
               }
               j++;

               find = TRUE;
            }
        }

     if (!find)
          buf_printf(output, "Not obj with incorrect material.\n");

     buf_printf(output,"\n\r");
     page_to_char(buf_string(output), ch);
     buf_free(output);

     return;
}

DO_FUN(do_validate)
{

     if (argument[0] == '\0')
     {
          char_printf(ch, "\nValid parametrs are: {Cmaterial{x.\n");
          return;
     }

     if (!str_cmp(argument,"material"))
     {
          validate_materials(ch);
          return;
     }
}

DO_FUN(do_autosnoop)
{
     CHAR_DATA *victim;
     char       arg1[MAX_INPUT_LENGTH];
     char       arg2[MAX_INPUT_LENGTH];


     argument = one_argument(argument, arg1, sizeof(arg1));
     one_argument(argument, arg2, sizeof(arg2));

     if (!IS_IMMORTAL(ch))
     {
          char_act("Cheats?.", ch);
          log_printf("[*****] Security: attempt using autosnoop not immortals character: %s", ch->name);
          return;
     }


     if (arg1[0] == '\0' || arg2[0] == '\0')
     {
          char_printf(ch, "Syntax: autosnoop <Char_Name> <on|off>\n\r");
          return;
     }

     if ((victim = get_char_world(ch,arg1)) == NULL || IS_NPC(victim))
     {
          char_act("They aren't here.", ch);
          return;
     }

     if (IS_IMMORTAL(victim) && (ch->level <= victim->level))
     {
          char_act("Not with you level.", ch);
          return;
     }

     if (!str_cmp(arg2, "on"))
     {
          if (!IS_SET(victim->comm, COMM_AUTOSNOOP))
          {
               SET_BIT(victim->comm, COMM_AUTOSNOOP);
               char_printf(ch, "Autosnoop for %s now {RON{x.\n\r", victim->name);
          }
     }
     else
     if (!str_cmp(arg2, "off"))
     {
          if (IS_SET(victim->comm, COMM_AUTOSNOOP))
          {
               REMOVE_BIT(victim->comm, COMM_AUTOSNOOP);
               char_printf(ch, "Autosnoop for %s now {ROFF{x.\n\r", victim->name);
          }
     }
     else
          char_printf(ch, "Syntax: autosnoop <Char_Name> <on|off>\n\r");

}

DO_FUN(do_commshow)
{
     CHAR_DATA     *victim;
     int            flag;
     int            col = 0;


     if (argument[0] == '\0')
     {
          char_printf(ch, "Syntax: commshow <Char_Name>\n\r");
          return;
     }

     if ((victim = get_char_world(ch,argument)) == NULL || IS_NPC(victim))
     {
          char_act("They aren't here.", ch);
          return;
     }

     char_printf(ch, "COMM flags for player %s:\n\r", victim->name);

     for (flag = 0;  comm_flags[flag].name; flag++)
     {
               if (str_cmp(comm_flags[flag].name, str_empty))
               {
                    char_printf(ch,"%-15s {D[%-5s{D]{x     ",comm_flags[flag].name, IS_SET(victim->comm,comm_flags[flag].bit) ? "{COn" : "{ROff");

                    if (++col % 2 == 0)
                         char_printf(ch,"\n");
               }
     }

     for (flag = 0;  comm2_flags[flag].name; flag++)
     {
               if (str_cmp(comm2_flags[flag].name, str_empty))
               {
                    char_printf(ch,"%-15s {D[%-5s{D]{x     ",comm2_flags[flag].name, IS_SET(victim->comm2,comm2_flags[flag].bit) ? "{COn" : "{ROff");

                    if (++col % 2 == 0)
                         char_printf(ch,"\n");
               }
     }

     char_printf(ch,"\n");
}

extern void save_system(CHAR_DATA *ch, bool message);

DO_FUN(do_muddy)
{
     const flag_t    *flag;
     char             arg1[MAX_INPUT_LENGTH];
     char             arg2[MAX_INPUT_LENGTH];
     bool             fChanged = FALSE;


     argument = one_argument(argument, arg1, sizeof(arg1));
     one_argument(argument, arg2, sizeof(arg2));

     if (!IS_IMMORTAL(ch))
     {
          char_act("Cheats?.", ch);
          log_printf("[*****] Security: attempt using muddy mode switch not immortals character: %s", ch->name);
          return;
     }



     if (arg1[0] == '\0' || arg2[0] == '\0')
     {
          (do_muddyshow)(ch, argument);
          return;
     }

     if ((flag = flag_lookup(muddy_flags,arg1)) == NULL)
     {
          char_act("Not such flags.", ch);
          return;
     }


     if (!str_cmp(arg2, "on"))
     {
          if (!IS_SET(muddy_mode, flag->bit))
          {
               SET_BIT(muddy_mode, flag->bit);
               char_printf(ch, "Muddy mode for %s now {CON{x.\n\r", flag->name);
               fChanged = TRUE;
          }
     }
     else
     if (!str_cmp(arg2, "off"))
     {
          if (IS_SET(muddy_mode, flag->bit))
          {
               REMOVE_BIT(muddy_mode, flag->bit);
               char_printf(ch, "Muddy mode for %s now {ROFF{x.\n\r", flag->name);
               fChanged = TRUE;
          }
     }
     else
     {
          char_printf(ch, "Syntax: muddy <mode> <on|off>\n\r");
          return;
     }

     if (fChanged)
     {
         save_system(ch, TRUE);
     }
}

DO_FUN(do_muddyshow)
{
     int            flag;
     int            col = 0;


     char_printf(ch, "\nMuddy flags:\n\n");

     for (flag = 0;  muddy_flags[flag].name; flag++)
     {
          if (str_cmp(muddy_flags[flag].name, str_empty))
          {
               char_printf(ch,"%-15s {D[%-5s{D]{x     ",muddy_flags[flag].name, IS_SET(muddy_mode,muddy_flags[flag].bit) ? "{COn" : "{ROff");

               if (++col % 2 == 0)
                    char_printf(ch,"\n");
          }
     }

     char_printf(ch,"\n");
}

DO_FUN(do_rmaterial)
{
     OBJ_INDEX_DATA  *pObjIndex;
     AREA_DATA       *pArea;
     int              vnum;
     BUFFER          *output;
     char             material_from[MAX_INPUT_LENGTH];
     char             material_to  [MAX_INPUT_LENGTH];
     int              total;
     int              repleaced;

     total     = 0;
     repleaced = 0;

     argument = one_argument(argument, material_from, sizeof(material_from));
     one_argument(argument, material_to, sizeof(material_to));

     if (material_from[0] == '\0' || material_to[0] == '\0' )
     {
           char_act("RMaterial: Syntax: rmaterial <name_from> <name_to>.", ch);
           return;
      }

      if (material_n_lookup(material_to) < 0)
      {
           char_printf(ch, "RMaterial: invalid material %s.\n", material_to);
           return;
      }

     output = buf_new(-1);

     for (vnum = 0; total < top_obj_index; vnum++)
          if ((pObjIndex = get_obj_index(vnum)) != NULL)
          {
               total++;

               if (!str_cmp(pObjIndex->material, material_from))
               {
                    pObjIndex->material = str_dup(material_to);
                    pArea = area_vnum_lookup(pObjIndex->vnum);
                    if (pArea != NULL)
                           if (!IS_SET(pArea->flags, AREA_CHANGED))
                                 TOGGLE_BIT(pArea->flags, AREA_CHANGED);

                    buf_printf(output, "Obj:  [D{w%6d{D] %-23s {D[{w%-15s{D]{x repleace %8s on %8s\n", pObjIndex->vnum, str_dup(fmt_color_str(mlstr_mval(pObjIndex->short_descr),20)), pArea != NULL ? pArea->name : "{R=Unknonwn]{x", material_from, material_to);
                    repleaced++;
               }
          }

     buf_printf(output, "\nTotal scaned: %d objects. ", total);

     if (repleaced > 0)
     {
            buf_printf(output, "Repleaced: %d objects.\n", repleaced);
            buf_printf(output, "{RWarining! {WYou must save changed area files.{x\n");
     }

     page_to_char(buf_string(output), ch);
     buf_free(output);
}

