/* $Id: align.c,v 1.666 2004/09/20 10:49:47 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include "merc.h"
#include "align.h"

void wrath_of_gods (CHAR_DATA * ch)
{
    int sn_curse;

    if ((sn_curse = sn_lookup("curse")) < 0)
        return;

    if (number_range (1, 1000) < 2)
    {
        char_act ("The gods are infuriated!", ch);
        if (!is_affected (ch, sn_curse))
            spell_curse (sn_curse, ch->level * 3 / 2, ch, (void *) ch, TARGET_CHAR);
    }
}

// message shown to a char when he (she, it) changes alignment
void new_align_msg (CHAR_DATA * ch, int old_align, int new_align) 
{
    if (new_align == RA_GOOD)
    {
        if (old_align == RA_NEUTRAL) // neutral -> good
            char_act ("\n\nYou break your neutrality to serve the {YGOOD{x!\n", ch);
        else if (old_align == RA_EVIL) // evil -> good... almost impossible, but...
            char_act ("\n\nYou are disappointed in the the {RE{rvil{x and hope that the ways of {YGOOD{x will be better.\n", ch);
    }
    else if (new_align == RA_NEUTRAL)
    {
        // evil -> neutral, good -> neutral... the same message
        char_act ("\n\nYou can't fight anymore in the eternal battle between {YGOOD{x and {RE{rvil{x.\nNow you are neutrally aligned.\n", ch);
    }
    else if (new_align == RA_EVIL)
    {
        if (old_align == RA_NEUTRAL) // neutral -> evil
            char_act ("\n\nYou break your neutrality to bring the {RE{rvil{x into this realm!\n", ch);
        else if (old_align == RA_EVIL) // good -> evil... almost impossible, but...
            char_act ("\n\nYou are disappointed in the the {YGOOD{x and ready to spread the {RE{rvil{x all over the world!\n", ch);
    }
}
