/* $Id: argument.h,v 1.666 2004/09/20 10:49:47 shrike Exp $ */


/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

/*
 * flags for get_yyy_xxx
 */
#define GET_F_CHAR_IS_CHAR		(A) // looker is npc/pc
#define GET_F_CHAR_IS_OBJ		(B) // looker is an object (used in obj_progs)
#define GET_F_CHAR_IS_ROOM		(C) // looker is a room    (used in room_progs)

#define GET_F_VICT_IS_CHAR		(D) // we're looking for npc/pc
#define GET_F_VICT_IS_OBJ		(E) // we're looking for an object
#define GET_F_VICT_IS_ROOM		(F) // we're looking for a room (not used)

#define GET_F_NO_CHECK_CAN_SEE	(G) // don't check if looker can see yyy

#define GET_F_REMEMBERED		(H) // argument considered as remembered
									// by looker nickname of yyy
#define GET_F_NAME				(I) // argument considered as real name of yyy
#define GET_F_NULLSTR_OK		(J) // when no argument specified, if this
								    // option set any yyy is ok, if not
									// none of yyy is ok

#define GET_F_IN_ROOM			(K) // yyy should be in looker's room
#define GET_F_NOT_IN_ROOM		(L) // yyy shoudn't be in looker's room
#define GET_F_IN_AREA			(M) // yyy should be in looker's area

#define GET_F_CHECK_FORM		(W) // if argument is a name of form, 
									// we'll search for victim with this form 
#define GET_F_NO_DOPPELGANGER	(X) // can doppelganger fool us? if set, no!

#define	GET_F_WEAR_NONE			(Y)	// obj->wear_loc == WEAR_NONE (inventory)
#define	GET_F_WEAR				(Z)	// obj->wear_loc != WEAR_NONE (worn)   
									   
#define GET_F_IDENTIFIER	(GET_F_REMEMBERED | GET_F_NAME | \
							 GET_F_NULLSTR_OK | GET_F_CHECK_FORM)


/*
 * Character finding procedures
 */

CHAR_DATA * get_char_room_ext     (CHAR_DATA *ch, const char *argument, int flags);
CHAR_DATA * get_char_area_ext     (CHAR_DATA *ch, const char *argument, int flags);
CHAR_DATA * get_char_world_ext    (CHAR_DATA *ch, const char *argument, int flags);
		
CHAR_DATA *  find_char_ext			  (CHAR_DATA *ch, const char *argument, int door, int range, int flags);
CHAR_DATA *  get_char_spell_ext  	  (CHAR_DATA *ch, const char *argument, int *door, int range, int flags);

/*
 * Object finding procedures
 */
		
OBJ_DATA *  get_obj_list_ext      (CHAR_DATA *ch, const char *argument, OBJ_DATA *list, int flags);
OBJ_DATA *  get_obj_carry_ext     (CHAR_DATA *ch, const char *argument, int flags);
OBJ_DATA *  get_obj_wear_ext      (CHAR_DATA *ch, const char *argument, int flags);
OBJ_DATA *  get_obj_here_ext      (CHAR_DATA *ch, const char *argument, int flags);
OBJ_DATA *  get_obj_room_ext      (CHAR_DATA *ch, const char *argument, int flags);
OBJ_DATA *  get_obj_world_ext     (CHAR_DATA *ch, const char *argument, int flags);

/*
 * Commonly used macros
 */

#define get_char_room(ch, argument)				\
	   	get_char_room_ext((ch), (argument), GET_F_CHAR_IS_CHAR)
#define get_char_area(ch, argument)				\
	   	get_char_area_ext((ch), (argument), GET_F_CHAR_IS_CHAR)
#define get_char_world(ch, argument)			\
		get_char_world_ext((ch), (argument), GET_F_CHAR_IS_CHAR)

#define find_char(ch, argument, door, range) 	\
		find_char_ext((ch), (argument), (door), (range), GET_F_CHAR_IS_CHAR)
#define get_char_spell(ch, argument, door, range)	\
		get_char_spell_ext((ch), (argument), (door), (range), GET_F_CHAR_IS_CHAR)


#define get_obj_list(ch, argument, list)	\
		get_obj_list_ext((ch), (argument), (list), GET_F_CHAR_IS_CHAR)
#define get_obj_carry(ch, argument)			\
		get_obj_carry_ext((ch), (argument), GET_F_CHAR_IS_CHAR)
#define get_obj_wear(ch, argument)			\
		get_obj_wear_ext((ch), (argument), GET_F_CHAR_IS_CHAR)
#define get_obj_here(ch, argument)			\
		get_obj_here_ext((ch), (argument), GET_F_CHAR_IS_CHAR)
#define get_obj_room(ch, argument)			\
		get_obj_room_ext((ch), (argument), GET_F_CHAR_IS_CHAR)
#define get_obj_world(ch, argument)			\
		get_obj_world_ext((ch), (argument), GET_F_CHAR_IS_CHAR)
