/*   $Id: artefacts.c,v 1.666 2004/09/20 10:49:47 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

/************************************************************************************
 *   Artefacts. Ideas by: Aseroth, BGII SoA, Aladon                                 *
 *    Code by: Aseroth                                                              *
 ************************************************************************************/
/*
  TODO: artefact table
  func in handle_death
  func to merge artefacts
*/

#include "artefacts.h"

varr artefacts  = {sizeof (artefact_t), 4};

/*


int check_artefact_appearance(CHAR_DATA* killer, CHAR_DATA* victim, 
                              ARTEFACT_DATA* a_list)
{
    ARTEFACT_DATA* artefact;
    int vnum;
    OBJ_DATA* obj;
    OBJ_INDEX_DATA *pObjIndex;
    int count = 0;

    if (a_list == NULL) return 0;
    for (artefact = a_list; artefact != NULL; artefact = artefact->next)
    {
        if (killer->level > artefact->char_level 
            || victim->level < artefact->mob_level
            || !artefact->appearable)
        {
            continue;
        }
        if (number_range(1, artefact->chance) == (artefact->chance/2))
        {
            vnum = artefact->vnum;

            if ((pObjIndex = get_obj_index(vnum)) == NULL)
            {
                log_printf("Artefacts: check_appearance. Invalid object (#%d).\n", vnum);
                return 0;
            }

            if (pObjIndex->limit != -1 && FALSE )
            {
                // TODO: check for limit count not exceeded
                return 0;
            }

            obj = create_obj(pObjIndex, killer->level);
            obj_to_char(obj, victim);
            log_printf("Artefacts: debug, check_spawn %d spawned (1/%d).",
                        pObjIndex->vnum, artefact->chance);
            wiznet("Artefacts: $N got $p", killer, 
                    obj, WIZ_SECURE, 0, killer->level);
            ++count;
        }
    }
    return count;
            
}    
*/

/*
ARTEFACT_DATA*  delete_artefact(ARTEFACT_DATA* artefact, ARTEFACT_DATA* a_list)
{
    ARTEFACT_DATA* a;

    if (a_list == NULL)
    {
        log_printf("Artefacts: delete. List == NULL.");
        return NULL;
    }

    if (artefact == NULL)
    {
        log_printf("Artefacts: delete. Artefact == NULL.");
        return a_list;
    }

    if (artefact == a_list)
        a_list =  artefact->next;
    else
        for (a = a_list; a != NULL; a = a->next)
        {
            if (a->next == artefact)
            {
                a->next = a->next->next;
                break;
            }
        }
    free(artefact);     
    return a_list;
}
*/

/*ARTEFACT_DATA* new_artefact(ARTEFACT_DATA* a_list)
{
    ARTEFACT_DATA* a;

    a = malloc(sizeof(*a));
 
    a->vnum = 0;
    a->next = NULL;
    a->char_level = 0;
    a->mob_level = 0;
    a->chance = 0;
    
    a->parts_count = 0;
    a->part_of = 0;

    if (a_list == NULL)
        a_list = a;
    else
    {
        a->next = a_list;
        a_list = a;
    }

    return a_list;
}
*/

artefact_t * artefact_new ()
{
        artefact_t * artefact;

        meteor                             = varr_enew (&artefacts);
		
        artefact->artefact_parts.nsize    = sizeof (mobject_t);
        meteor->artefact_parts.nstep      = 4;
        meteor->name                      = str_empty;
        meteor->active                    = METEOR_FALSE;
        meteor->area_vnum                 = -1;
        meteor->auto_start                = METEOR_FALSE;
        meteor->curr_tick                 = -1;
        meteor->damage                    = 0;
        meteor->nopk_damage               = METEOR_FALSE;
        meteor->size                      = 1;
        meteor->wait_tick                 = 10;

        return meteor ;
}

/*
bool new_artefact_part(ARTEFACT_DATA* artefact)
{
    int i = artefact->parts_count;

    if (i == MAX_ARTEFACT_PARTS)
        return FALSE;

    ++artefact->parts_count;

    artefact->parts[i].vnum             = 0;
    artefact->parts[i].neccessary       = TRUE;
    artefact->parts[i].chance_reduct    = 0;

    return TRUE;
}
*/

/*
bool del_artefact_part(ARTEFACT_DATA* artefact)
{
    if (artefact -> parts_count == 0) return FALSE;
 
    --artefact->parts_count;
    return TRUE;
}
*/

/*
ARTEFACT_DATA*  get_artefact_by_vnum(int vnum, ARTEFACT_DATA* a_list)
{
    ARTEFACT_DATA* art = NULL;
    ARTEFACT_DATA* a_next = NULL;

    art = a_list;
    while (art != NULL)
    {
        if (art->vnum == vnum) return art;        
        art = art->next;
    }
    return NULL;
};

*/


/*
artefact_check_result check_artefact(int count, ARTEFACT_DATA* artefacts[],
                                    ARTEFACT_DATA* a_list)
{
    ARTEFACT_DATA* art;
    int i;
    int missing;
    int chance;

    artefact_check_result result;

    result.major = CAN_CREATE;
    result.minor = 0;

    if (count < 2) 
    {
        // we can't create nothing from 1 part apriori
        result.major = CANNOT_CREATE_PARTS_MISSING;
        return result;
    }

    art = get_artefact_by_vnum(artefacts[0]->part_of, a_list);
    if (art == NULL)
    {
        result.major = CANNOT_CREATE_PART_INVALID;
        result.minor = 1;
        return result;
    }

    //  --      ?

    for (i = 1; i < count; i++)
    {
        if (!is_part_of(artefacts[i]->vnum, art))
        {
            result.major = CANNOT_CREATE_PART_INVALID;
            result.minor = i;
            return result;
        }
    }  
  
    //  --      
    chance  = 100;      // initial chance to create == 100%
    missing =   0;      // now we've no missing parts

    for (i = 0; i < art->parts_count; i++)
    {
        if (!part_in_array(count, artefacts, art->parts[i].vnum))
        {
            if (art->parts[i].neccessary)
            {
               ++missing;
            }
            else
            {
                chance -= art->parts[i].chance_reduct;
            }
        }
    }
    
    if (missing > 0)
    {
        result.major = CANNOT_CREATE_PARTS_MISSING;
        result.minor = missing;
        return result;
    }

    if (chance != 100)
    {
        result.major = CAN_CREATE_CHANCE_FAILURE;
        result.minor = chance;
        return result;
    }

    return result;
};

*/


/*
bool part_in_array(int count, ARTEFACT_DATA** array, int part_vnum)
{
    int i;

    for (i = 0; i < count; i++)
    {
        if (array[i]->vnum == part_vnum)
            return TRUE;

    }

    return FALSE;
}

*/

/*
bool is_part_of(int vnum, ARTEFACT_DATA* artefact)
{
    int i;

    if (vnum == 0) return FALSE;

    for (i = 0; i < artefact->parts_count; i++)
    {
        if (artefact->parts[i].vnum == vnum)
            return TRUE;

    }

    return FALSE;
}
*/

// report might be 0: report, don't create
//                 1: don't report, just create
//                 3: estimate info



/*
int artefact_check(CHAR_DATA* ch,  const char* argument, int report)
{
    ARTEFACT_DATA* array[MAX_ARTEFACT_PARTS];
    OBJ_DATA* objs[MAX_ARTEFACT_PARTS];
    OBJ_DATA* obj  = NULL;
    OBJ_DATA* obj1 = NULL;

    OBJ_INDEX_DATA *pObjIndex = NULL;

    char arg[MAX_INPUT_LENGTH];
    const char* old_arg;

    char tochar[MAX_STRING_LENGTH];
    char num[MAX_STRING_LENGTH];

    int i = 0;
    int count = 0;

    artefact_check_result result;

    old_arg = argument;

    bool create_object = FALSE;
    int chance = 100;
    CHAR_DATA* forger;
    int fee;

    argument = one_argument(argument, arg, sizeof(arg));    // parse forger
    forger = get_char_room(ch, arg);
    if (forger == NULL)
    {
        char_puts("No one can help you here.\n", ch);
        return 0;
    }

    argument = one_argument(argument, arg, sizeof(arg));
    for (count = 0; arg[0] != '\0'; argument = one_argument(argument, arg, sizeof(arg)))
    {
        if ((obj = get_obj_carry(ch, arg)) == NULL)
        {
            char_puts("You do not have that item.\n", ch);
            return 0;
        }

        objs[count]  = obj;
        array[count] = get_artefact_by_vnum(obj->pIndexData->vnum, artefactList);
        if (array[count] == NULL)
        {
            act("$p is not an artefact!.", ch, obj, NULL, TO_CHAR);
            return 0;
        }

        count++;
        if (count == MAX_ARTEFACT_PARTS)
        {
            char_puts("You've specified too many objects.\n", ch);
            break;
        }
    }
  
    {
        ARTEFACT_DATA* art;
        art =  get_artefact_by_vnum(array[0]->part_of, artefactList);
        if (art == NULL || forger->pIndexData->vnum != art->forger)
        {
            act_say(forger, "I don't know, what to do with $p.", objs[0]);
            return 0;
        }

        if (art == NULL)
            art = array[0];
    
        if (report == 3)
        {
            fee = art->info_fee;
            snprintf(tochar, sizeof(tochar),
                      "I'll take %d gold coins for information.", fee);
            act_say(ch, "$t", tochar);
            fee = art->create_fee;
            snprintf(tochar, sizeof(tochar),
                      "And %d gold coins for creation of this artefact.", fee);
            act_say(ch, "$t", tochar);
            return 0;
        }    
        
        if (report == 0)
            fee = art->info_fee;
        else
            fee = art->create_fee;
    }
 
    result = check_artefact(count, array, artefactList);

    switch (result.major)
    {
        case CAN_CREATE:
            snprintf(tochar, sizeof(tochar),
                     "You can create an artefact from this objects.");
            create_object = TRUE;
            
            break;
        case CAN_CREATE_CHANCE_FAILURE:
            create_object = TRUE;
            chance = result.minor;
            snprintf(tochar, sizeof(tochar),
                      "You can create an artefact, but there are some objects missing, so you have only %d percent chance of success.\n", 
                      chance);
            break;
        case CANNOT_CREATE_PARTS_MISSING:
            if (result.minor == 0)
            {            
                snprintf(tochar, sizeof(tochar), "There are too less parts.");                
                break;
            }
            if (result.minor >= (array[0]->parts_count / 2))
                snprintf(num, sizeof(num), "too many");
            else
                snprintf(num, sizeof(num), "%d", result.minor); 
                
            snprintf(tochar, sizeof(tochar), "There are %s parts missing.", num);
            break;

        case CANNOT_CREATE_PART_INVALID:
            snprintf(tochar, sizeof(tochar), "$P doesn't suit to $p!.");
            obj1 = objs[result.minor];
            obj  = objs[0];
            break;
        default:
            snprintf(tochar, sizeof(tochar), "Hz why!");
    }
    // fee_char(fee);
        
    switch(report)
    {
        case 0:
            act(tochar, ch, obj, obj1, TO_CHAR);        
            break;
        case 2:
            act(tochar, ch, obj, obj1, TO_CHAR);
        case 1:
        {
            if (create_object)
            {       
                bool boom = TRUE;
                if (result.major <= CAN_CREATE_CHANCE_FAILURE)
                {
                    if ((pObjIndex = get_obj_index(array[0]->part_of)) == NULL)
                    {
                        log_printf("Artefacts: artefact_check. Invalid object to create (%d).\n", 
                                    array[0]);
                        return 0;
                    }
                }

                if (pObjIndex->limit != -1 && FALSE )
                {
                    // TODO: check for limit count not exceeded
                    char_puts("You can't create more of this item!\n", ch);
                    return 0;
                }

                act("$n takes parts from $N, merging them into complete object.",
                    forger, obj, ch, TO_NOTVICT);
                act("$n takes parts from you, merging them into complete object.",
                    forger, NULL, ch, TO_VICT);
                act("$n utters the word of unification.",
                    forger, obj, NULL, TO_ROOM);
                act("$n applying reagents.",
                    forger, obj, NULL, TO_ROOM);

                if (number_percent() < chance)
                {
                    obj = create_obj(pObjIndex, pObjIndex->level);
                    obj_to_char(obj, ch);

                    act("$p appears from the bright flash!",
                        forger, obj, NULL, TO_ROOM);

                    boom = FALSE;
                }
                for (i = 0; i < count; i++)
                {
                    obj = objs[i];
                    if (boom)
                    {
                        if (number_range(1, array[0]->part_of) == 1)
                        {
                            act("$p explodes!", forger, obj, NULL, TO_ROOM);
                            obj_from_char(obj);
                            extract_obj(obj);
                        }
                        continue;
                     }
                     obj_from_char(obj);
                     extract_obj(obj);
                }

                break;
            }
            act(tochar, ch, obj, obj1, TO_CHAR);        
            break;
        }
    }
    return 0;
}
  

*/

/*
DO_FUN(do_artefact)
{
    char arg[MAX_INPUT_LENGTH];

    argument = one_argument(argument, arg, sizeof(arg));
    if (!str_cmp(arg, "merge"))
    {
        artefact_check(ch, argument, 1);
        return;

    };

    if (!str_cmp(arg, "check"))
    {
        artefact_check(ch, argument, 0);
        return;
    };


    if (!str_cmp(arg, "estimate"))
    {
        artefact_check(ch, argument, 3);
        return;
    };
}

*/

/*

void artefact_init_dummy()
{
    ARTEFACT_DATA* art; 

    artefactList = new_artefact(artefactList);
    art = artefactList;

    art->vnum = 3001;
    new_artefact_part(art);
    art->parts[0].vnum = 3002;
    new_artefact_part(art);
    art->parts[1].vnum = 3003;
    art->info_fee = 500;
    art->create_fee = 1000;
    art->forger = 3011;

    artefactList = new_artefact(artefactList);
    art = artefactList;
    art->vnum = 3002;
    art->parts_count = 0;
    art->part_of = 3001;
    art->appearable = TRUE;
    art->char_level = 91;
    art->mob_level = 50;
    art->chance = 1000;

    artefactList = new_artefact(artefactList);
    art = artefactList;
    art->vnum = 3003;
    art->parts_count = 0;
    art->part_of = 3001;
    art->appearable = TRUE;
    art->char_level = 91;
    art->mob_level = 50;
    art->chance = 200;

    artefactList = new_artefact(artefactList);
    art = artefactList;
    art->vnum = 3004;
    art->parts_count = 0;
    art->part_of = 0;
    art->appearable = TRUE;
    art->char_level = 91;
    art->mob_level = 50;
    art->chance = 10000;
    art->create_fee = 1;
    art->info_fee = 300;

}

*/