/* $Id: artefacts.h,v 1.666 2004/09/20 10:49:47 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

/************************************************************************************
 *   Artefacts. Ideas by: Aseroth, BGII SoA, Aladon                                 *
 *    Code by: Aseroth                                                              *
 ************************************************************************************/
       
/*
  TODO: artefact table
  func in handle_death
  func to merge artefacts
*/
#ifndef _ARTEFACTS_H_
#define _ARTEFACTS_H_

#include <stdlib.h>
#include <stdio.h>
#include "typedef.h"
#include "merc.h"

#define MAX_ARTEFACT_PARTS 5   // i don't wanna mess with mem_management

typedef struct artefact_part_t            artefact_part_t;
typedef struct artefact_t                 artefact_t;
typedef struct artefact_check_result_s    artefact_check_result;

struct artefact_part_t
{
    int  vnum;
	int  part_type;        
    bool neccessary;
    int  chance_reduct;
};


struct artefact_t
{
    int   vnum;
    bool  appearable;
    int   char_level;     // minimum level of char 
    int   mob_level;      // minimum level of mob
    int   chance;         // chance of artefact appearance is 1/chance
	varr  artefact_parts;
    int   part_of;
    int   forger;
    int   info_fee;
    int   create_fee;
};


artefact_t *      artefact_new    (void);
void              artefact_free   (artefact_t*);


extern varr artefacts;

enum 
{                           
    CAN_CREATE,
    CAN_CREATE_CHANCE_FAILURE,
    CANNOT_CREATE_PARTS_MISSING,
    CANNOT_CREATE_PART_INVALID,
};

typedef int artefact_merge_result;

struct artefact_check_result_s
{
    artefact_merge_result major;
    int                   minor;
};

#define ARTEFACT(arn)          ((artefact_t*) VARR_GET(&artefacts, arn))
#define artefact_lookup(mrn)   ((artefact_t*) varr_get(&artefacts, arn))

#define artefact_parts_lookup(artefact, num) \
    ((artefact_part_t*) varr_bsearch(&artefact->artefact_parts, &num, cmpint))

/*
bool            part_in_array              (int count, ARTEFACT_DATA** array, int part_vnum);
bool            is_part_of                 (int vnum, ARTEFACT_DATA* artefact);
int             check_artefact_appearance  (CHAR_DATA* killer, CHAR_DATA* victim,ARTEFACT_DATA* a_list);

artefact_check_result check_artefact(int count, ARTEFACT_DATA** artefacts, ARTEFACT_DATA* a_list);
*/


#endif
