/* $Id: callback.c,v 1.666 2004/09/20 10:49:47 shrike Exp $ */


/***********************************************************************************
 *  Original code by DalekenMUD 1.12 (C) 2000                                      *
 *  Adapted for current codebase by Shrike aka Sauron at 2004                      *
 *                                                                                 *
 *  This source code can freely be distributed and modified without any            *
 *         restrictions except that all given text cannot be removed               *
 *                         or changed:)                                            *
 ***********************************************************************************/

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


#include <sys/types.h>
#if !defined (WIN32)
#   include <sys/socket.h>
#   include <netinet/in.h>
#   include <arpa/telnet.h>
#   include <arpa/inet.h>
#   include <unistd.h>
#   include <netdb.h>
#   include <sys/wait.h>
#   include <sys/time.h>
#else
#   include <winsock.h>
#   include <sys/timeb.h>
#endif

#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <locale.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "merc.h"


int evn_picklock;
int evn_picktrap;
int evn_mercenary;
int evn_gate_demon;
int evn_raised_undead;
int evn_swan_song;
int evn_char_fall;
int evn_char_sink;
int evn_char_drown;
int evn_char_suffocate;
int evn_web_struggle;
int evn_stand_up;
int evn_regeneration;
int evn_plant_grow;
int evn_plant_die;
int evn_explode;
int evn_obj_decay;
int evn_imp_grab;
int evn_obj_fall;
int evn_spec_fun;
int evn_class_action;
int evn_hunt_fleer;
int evn_scavenge;
int evn_wander;
int evn_cone_remove;
int evn_room_violence;
int evn_prog_trigger;
int evn_prog_wait;
int evn_area_reset;
int evn_char_test;

struct event_table_type event_table [] =
{
    { "char test", &evn_char_test, ecb_char_test           },
    { "",   NULL, NULL, 0     }
};
	
/*
 * Finds an event by name.
 */
int event_lookup( const char *name )
{
    int i;

    for( i = 0; event_table[i].type >= 0; ++i )
    {
        if( !str_cmp( event_table[i].name, name ) )
            return *event_table[i].type;
    }
    return -1;
}


struct event_table_type *event_table_lookup( const char *name )
{
    int i;

    for( i = 0; event_table[i].type >= 0; ++i )
    {
        if( !str_cmp( event_table[i].name, name ) )
            return (event_table + i);
    }
    return NULL;
}

void ecb_char_test (EVENT *e)
{
	log_printf("Test event char");
}
