/* $Id: casino.c,v 1.666 2004/09/20 10:49:47 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


/**********************************************************************************/
/*      Casino Slots written by Nikola Sarcevic of Manga Nation                   */
/*      V1.1 by DSL( Dave Leverich) of Top Secret. topsecret.wolfpaw.net:6942     */
/**********************************************************************************/


#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "merc.h"



void do_gamble(CHAR_DATA * ch, const char *argument)
{
    char    arg[MAX_INPUT_LENGTH];
    uint    bank_g;
    int bet;

    if (IS_AFFECTED(ch, AFF_CHARM))
    {
        char_act("To play on money, you should be self-controlled to the full!", ch); //T
        return;
    }

    if (IS_NPC(ch))
    {
        char_act("      -    !", ch);
        return;
    }
    if (!IS_SET(ch->in_room->room_flags, ROOM_GAMBLE))
    {
        char_act("    .    ,   .", ch);
        return;
    }

    if (ch->pcdata->bank_s + ch->pcdata->bank_g == 0)
    {
        char_act("       - !", ch);
        return;
    }

    if (ch->pcdata->bank_g == 0)
    {
        char_act("    !     !", ch);
        return;
    }

    WAIT_STATE(ch, 1);  



    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("   .", ch);
        bet = 1;
    }
    else
        bet = atoi(arg);

    if (bet < 0)
    {
        char_act("    ?   !", ch);
        return;
    }


    if (ch->pcdata->bank_g >= bet)
    {
        ch->pcdata->bank_g -= bet;

        // Gambling Code...
        if (number_percent() < (get_curr_stat(ch, STAT_LCK)*2))
        {
            ch->gold += bet*2;
            char_printf(ch, "  %d .\n", bet*2);
        }
        else
            char_printf(ch, "  %d .\n", bet);

    }
    else
    {
        char_act("    !", ch);
        bank_g = ch->pcdata->bank_g;
        char_printf(ch, "     %d .\n", bank_g);
        return;
    }
}

//The main functions, in misc.c (or some other file you like).

// deduct bet from a character - This added by DSL to fix money problems in Slots

void deduct_bet (CHAR_DATA * ch, int bet)
{
    int silver = 0, gold = 0;

    silver = UMIN (ch->silver, bet);

    if (silver < bet)
    {
        gold = ((bet - silver + 99) / 100);
        silver = bet - 100 * gold;
    }

    ch->gold -= gold;
    ch->silver -= silver;

    if (ch->gold < 0)
    {
        bug ("deduct bet: gold %d < 0", ch->gold);
        ch->gold = 0;
    }
    if (ch->silver < 0)
    {
        bug ("deduct bet: silver %d < 0", ch->silver);
        ch->silver = 0;
    }
}


// - Slot Machines by Nikola(manga.thedigitalrealities.com port: 6969)
// This short function is for showing the result after it is selected.

void show_slot(CHAR_DATA *ch, int num)
{
    switch(num)
    {
        case 1:
          send_to_char("   {Rcherry{x   ",ch);
          break;
        case 2:
          send_to_char("    {mplum{x    ",ch);
          break;
        case 3:
          send_to_char("   {Mgrape{x    ",ch);
          break;
        case 4:
          send_to_char(" {Gwatermelon{x ",ch);
          break;
        case 5:
          send_to_char("   {yorange{x   ",ch);
          break;
        case 6:
          send_to_char("   {Ylemon{x    ",ch);
          break;
        case 7:
          send_to_char("    {Dbar{x     ",ch);
          break;
        case 8:
          send_to_char("    {Y2{Dbar{x    ",ch);
          break;
        case 9:
          send_to_char("    {R3{Dbar{x    ",ch);
          break;
        case 10:
          send_to_char("   {Bseven{x    ",ch);
          break;
    }
return;
}

// Rolls the slots.

int roll(void)
{
        int num;
        num = number_range(1,10);
        return num;
}



// The main Slots function

void do_slot(CHAR_DATA *ch, const char *argument) 
{
        OBJ_DATA *slot=NULL, *obj;
        char arg1[MAX_INPUT_LENGTH];
        char arg2[MAX_INPUT_LENGTH];
        char buf[MAX_STRING_LENGTH];
        bool CanPlay = TRUE;
        bool winner = FALSE;
        int winnings=0, basebet=0;
        int sa=0, sb=0, sc=0, sd=0, se=0, sf=0, sg=0, sh=0, si=0;

        argument = one_argument( argument, arg1, sizeof(arg1));
        argument = one_argument( argument, arg2, sizeof(arg2));

        if (IS_AFFECTED(ch, AFF_CHARM))
        {
           char_act("To play on money, you should be self-controlled to the full!", ch);
           return;
        }

        // No mobs playing slots
        if(IS_NPC(ch))
        {
          char_act("Mobs cannot gamble.",ch);//T
          return;
        }

	    // Check the room for the object.
        for ( obj = object_list; obj != NULL; obj = obj->next )
        {
          if(!obj->in_room)
            continue;
          if(obj->in_room != ch->in_room)
            continue;
          if (obj->pIndexData->item_type == ITEM_SLOT_MACHINE )
          {
            slot = obj;
            break;
          }
        }
        // No Slot Machine, end it.
        if(slot == NULL)
        {
          char_act("There's no slot machine here.",ch);//T
          return;
        }

        if(arg1[0] == '\0')
        {
         switch (number_range (0,4))
            {
            case 0:
                char_act("The lovely waitress walks up and says '{gYou need to type Slot Play (amount){x'", ch);
                char_act("She then turns away and walks off with a sultry swing to her perfect behind.",ch);
                   break;
            case 1:
                   char_act("A rather homely waitress passes by with the drink tray.",ch);
                   char_act("The waitress says '{gHey, you gotta type 'Slot Play (amount){x'",ch);
                   char_act("She turns and walks away with a limp.",ch);
                   break;
            case 2:
                   char_act("An amazing waitress walks over and bends down in front of you at the machine.", ch);
                   char_act("The waitress says '{gSugar, you need to type 'Slot Play (amount){x'", ch);
                   char_act("\n\r...You're not sure if you heard her though, has her amazing breasts brushed your arm!",ch);
                   break;
            case 3:
                   char_act("A waiter named Juan walks up with a swinging gate.", ch);
                   char_act("Juan says with a Cuban accent '{gHoney, you need to type 'Slot Play (amount){x'", ch);
                   char_act("He gives you a wink and walks away with a saunter.",ch);
                   break;
            case 4:
                   char_act("An amazing waitress walks over and bends down giving you an eyefull.", ch);
                   char_act("The waitress says '{gSugar, you need to type 'Slot Play (amount){x'", ch);

                   send_to_char("{r      ,8X--------8,{x                  {r`88,\n\r"
                                "{r     ,8X---------X8,{x     I,          {r8X-8,\n\r"
                                "{r    ,8X-----------X8,{x     I,        {r`8X-88,\n\r"
                                "{r   ,8X-------------X8b,{x    I,        {r8XXX-88I,\n\r"
                                "{r   8X----------------XX8,{x   I        {r8XX---XX8,\n\r"
                                "{r  8X-------------------X8,{x  I        {r8X------XX8,\n\r",ch);
                   send_to_char("{r  8X------Xz--zX--------X8,{x 8        {r8X-----X---X8,\n\r"
                                "{r  8X-------XzzX---------X8,{x 8       {r(8X------XXX-8,\n\r"
                                "{r  `8X--------------------X,{x 8,     {r,8X---------X8\n\r"
                                "{r    88X------------------X,{x 8     {r,8X---------X8{x\n\r", ch);
                   char_act("\n\r...But you barely hear a word as your eyes are glued to her phenomenal chest.",ch);
                   break;
            default:
                   char_act("You have to use the proper syntax, slot play (bet amount).", ch);
            }
           return;
        }

	//Now for the fun part.

        else if(!strcmp(arg1, "play"))
        {
          if(arg2[0] == '\0')
          {
         switch (number_range (0,4)) // A little humor and spice for the mistyped or 
            {
            case 0:
                char_act("The lovely waitress walks up and says '{gYou need to type Slot Play (amount){x'", ch);
                char_act("She then turns away and walks off with a sultry swing to her perfect behind.",ch);
                   break;
            case 1:
                   char_act("A rather homely waitress passes by with the drink tray.", ch);
                   char_act("The waitress says '{gHey, you gotta type 'Slot Play (amount){x'", ch);
                   char_act("She turns and walks away with a limp.",ch);
                   break;
            case 2:
                   char_act("An amazing waitress walks over and bends down in front of you at the machine.", ch);
                   char_act("The waitress says '{gSugar, you need to type 'Slot Play (amount){x'", ch);
                   char_act("\n\r...You're not sure if you heard her though, has her amazing breasts brushed your arm!",ch);
                   break;
            case 3:
                   char_act("A waiter named Juan walks up with a swinging gate.", ch);
                   char_act("Juan says with a Cuban accent '{gHoney, you need to type 'Slot Play (amount){x'.", ch);
                   char_act("He gives you a wink and walks away with a saunter.",ch);
                   break;
            case 4:
                   char_act("An amazing waitress walks over and bends down giving you an eyefull.", ch);
                   char_act("The waitress says '{gSugar, you need to type 'Slot Play (amount){x'.", ch);
                            
                   send_to_char("{r      ,8X--------8,{x                  {r`88,\n\r"
                                "{r     ,8X---------X8,{x     I,          {r8X-8,\n\r"
                                "{r    ,8X-----------X8,{x     I,        {r`8X-88,\n\r"
                                "{r   ,8X-------------X8b,{x    I,        {r8XXX-88I,\n\r"
                                "{r   8X----------------XX8,{x   I        {r8XX---XX8,\n\r"
                                "{r  8X-------------------X8,{x  I        {r8X------XX8,\n\r",ch);
                   send_to_char("{r  8X------Xz--zX--------X8,{x 8        {r8X-----X---X8,\n\r"
                                "{r  8X-------XzzX---------X8,{x 8       {r(8X------XXX-8,\n\r"
                                "{r  `8X--------------------X,{x 8,     {r,8X---------X8\n\r"
                                "{r    88X------------------X,{x 8     {r,8X---------X8{x\n\r", ch);
                   char_act("\n\r...But you barely hear a word as your eyes are glued to her phenomenal chest.",ch);
                   break;
            default:
                   char_act("You have to use the proper syntax, slot play (bet amount).", ch);
            }
           return;
          }


   //I made it so that only certain amounts can be wagered, it would be
   //entirely possible to remove this and go with however much they want
   //to wager, however I added this to give the slots a touch of reality. - NS

   // I completely changed the argument structure, to allow people some freedom in how
   // they call money, you'll see below. - DSL

/*  if ((!strcmp(arg2, "quarter"))
   || (!strcmp(arg2, "25"))
   || (!strcmp(arg2, "25 cents"))
   || (!strcmp(arg2, ".25")))
    {
      CanPlay = TRUE;
      basebet = 25;
    }
  else if ((!strcmp(arg2, "50 cents"))
   || (!strcmp(arg2, "50"))
   || (!strcmp(arg2, ".50")))
    {
      CanPlay = TRUE;
      basebet = 50;
    }
  else */
  if ((!strcmp(arg2, "1 gold")) || (!strcmp(arg2, "1")))
  {
      CanPlay = TRUE;
      basebet = 100;
  }
  else if ((!strcmp(arg2, "2 gold")) || (!strcmp(arg2, "2")) || (!strcmp(arg2, "2 golds")))
  {
      CanPlay = TRUE;
      basebet = 200;
  }
  else if ((!strcmp(arg2, "4 gold")) || (!strcmp(arg2, "4")) || (!strcmp(arg2, "4 golds")))
  {
      CanPlay = TRUE;
      basebet = 400;
  }
  else if ((!strcmp(arg2, "8 gold")) || (!strcmp(arg2, "8")) || (!strcmp(arg2, "8 golds")))
  {
      CanPlay = TRUE;
      basebet = 800;
  }
  else if ((!strcmp(arg2, "10 gold")) || (!strcmp(arg2, "10")) || (!strcmp(arg2, "10 golds")))
  {
      CanPlay = TRUE;
      basebet = 1000;
  }
  else if ((!strcmp(arg2, "20 gold")) || (!strcmp(arg2, "20")) || (!strcmp(arg2, "20 golds")))
  {
      CanPlay = TRUE;
      basebet = 2000;
  }
  else
  {
      CanPlay = FALSE;
      char_act("You can bet a 1,2,4,8,10 or 20 golds.", ch);
      return;
  }
     // The original gold/silver check was buggy...
     // Had to change it all, funky math and it messed up, so I changed it. - DSL

        if ((ch->silver + 100 * ch->gold) < basebet)
        {
        switch (number_range (0, 5))
           {
           case 0:
              char_act ("Man, you're so pour you could afford the cheap drinks here.", ch);
              break;
           case 1:
              char_act ("You scrounge through your pockets and find some...",ch);
              char_act (" ...lint... but not enough money to play.", ch);
              break;
           case 2:
              char_act ("Someone must have lifted your wallet pal, you don't have enough cash.", ch);
              break;
           case 3:
              char_act ("You got a copier that makes $100s?", ch);
              char_act ("Because you don't have the greenbacks baby.", ch);
              break;
           case 4:
              char_act("Go hold up a liquor store or something, you don't have enough to cover that bet.", ch);
              break;
           case 5:
              char_act ("With what, wooden nickles? Get more cash.", ch);
              break;
           default:
              char_act ("You don't have that much money.", ch);
              break;
           }
            return;
        }

        deduct_bet (ch, basebet);
        // Progressive jackpot DSL... IT WORKS!!
        if (slot->value[0] == SLOT_IS_PROGRESSIVE)
            slot->value[1] += basebet;

	    //'gold' and 'silver' are 'dollars' and 'cents',

          if(basebet == 25)
          {
            char_act ("You put a quarter into the slot machine and pull the handle.",ch);
            act("$n puts a coin in the slot machine and pulls the handle.",ch,NULL,NULL,TO_ROOM);
          }
          else if(basebet == 50)
          {
            char_act ("You put two quarters into the slot machine and pull the handle.",ch);
            act("$n puts a couple coins in the slot machine and pulls the handle.",ch,NULL,NULL,TO_ROOM);
          }
          else if(basebet == 100)
          {
            char_act("You slide a dollar into the slot machine and pull the handle.",ch);
            act("$n slides a dollar in the slot machine and pulls the handle.",ch,NULL,NULL,TO_ROOM);
          }
          else if(basebet > 100)
          {
            sprintf(buf,"You slide %d dollars into the slot machine and pull the handle.\n\r",basebet/100);
            send_to_char(buf,ch);
            act("$n slides some bills in the slot machine and pulls the handle.",ch,NULL,NULL,TO_ROOM);
         }
        char_act ("The machine spins and whirs for a bit.", ch);

        // A slight wait for mortals
        if (!IS_IMMORTAL(ch)) 
            WAIT_STATE (ch, PULSE_VIOLENCE / 3);

	      //Roll the slots!
          sa = roll();
          sb = roll();
          sc = roll();
          sd = roll();
          se = roll();
          sf = roll();
          sg = roll();
          sh = roll();
          si = roll();

	  //The following section reveals the slots to the player.

            send_to_char ("                    .--------.\n\r", ch);
            send_to_char ("                    |Jackpot |\n\r", ch);
            send_to_char ("   _________________|________|_________________\n\r", ch);
            send_to_char ("  |==____________==____________==____________==|\n\r", ch);
            send_to_char ("  |||            ||            ||            |||\n\r", ch);
            send_to_char ("  |||",ch);
            show_slot(ch,sa);
            send_to_char(                  "||",ch);
            show_slot(ch,sb);
            send_to_char(                                "||",ch);
            show_slot(ch,sc);
            send_to_char(                                              "||| __\n\r", ch);
            send_to_char ("  |||____________||____________||____________|||(__)\n\r", ch);
            send_to_char ("  |==____________==____________==____________==| ||\n\r", ch);
            send_to_char ("  |||            ||            ||            ||| ||\n\r", ch);
            send_to_char ("  |||",ch);
            show_slot(ch,sd);
            send_to_char(                  "||",ch);
            show_slot(ch,se);
            send_to_char(                                "||",ch);
            show_slot(ch,sf);
            send_to_char(                                              "||| ||\n\r",ch);
            send_to_char ("  |||____________||____________||____________|||_//\n\r", ch);
            send_to_char ("  |==____________==____________==____________==|_/\n\r", ch);
            send_to_char ("  |||            ||            ||            |||\n\r", ch);
            send_to_char ("  |||",ch);
            show_slot(ch,sg);
            send_to_char(                  "||",ch);
            show_slot(ch,sh);
            send_to_char(                                "||",ch);
            show_slot(ch,si);
            send_to_char(                                              "|||\n\r",ch);
            send_to_char ("  |||____________||____________||____________|||\n\r", ch);
            send_to_char ("  |==________________________________________==|\n\r", ch);
            send_to_char ("  | |________________________________________| |\n\r", ch);
            send_to_char ("  |  |      TOP SECRET - SLOT MACHINES      |  |\n\r", ch);
            send_to_char (" _|  |______________________________________|  |_\n\r", ch);
            send_to_char ("(________________________________________________)\n\r", ch);


	  //Decide whether or not they won.

          if(sa == 1 && sb != 1)
          {
            if(winner == FALSE)
              winner = TRUE;
            winnings += basebet + (basebet/4);
          }
          else if(sa == 1 && sb == 1 && sc != 1)
          {
            if(winner == FALSE)
              winner = TRUE;
            winnings += basebet + (basebet/2);
          }

          if(sd == 1 && se != 1)
          {
            if(winner == FALSE)
              winner = TRUE;
            winnings += basebet + (basebet/4);
          }
          else if(sd == 1 && se == 1 && sf != 1)
          {
            if(winner == FALSE)
              winner = TRUE;
            winnings += basebet + (basebet/2);
          }

          if(sg == 1 && sh != 1)
          {
            if(winner == FALSE)
              winner = TRUE;
            winnings += basebet + (basebet/4);
          }
          else if(sg == 1 && sh == 1 && si != 1)
          {
            if(winner == FALSE)
              winner = TRUE;
            winnings += basebet + (basebet/2);
          }

          if(sa == sb && sb == sc)
          {
            if(winner == FALSE)
              winner = TRUE;
            winnings += basebet * sb;
          }

          if(sd == se && se == sf)
          {
            if(winner == FALSE)
              winner = TRUE;
            winnings += basebet * se;
          }

          if(sg == sh && sh == si)
          {
            if(winner == FALSE)
              winner = TRUE;
            winnings += basebet * sh;
          }

          if(sa == se && se == si)
          {
            if(winner == FALSE)
              winner = TRUE;
            winnings += basebet * se;
          }

          if(sg == se && se == sc)
          {
            if(winner == FALSE)
              winner = TRUE;
            winnings += basebet * se;
          }

          if(sa == sd && sd == sg)
          {
            if(winner == FALSE)
              winner = TRUE;
            winnings += basebet * sd;
          }

          if(sb == se && se == sh)
          {
            if(winner == FALSE)
              winner = TRUE;
            winnings += basebet * se;
          }

          if(sc == sf && sf == si)
          {
            if(winner == FALSE)
              winner = TRUE;
            winnings += basebet * sf;
          }

	  //This is the JACKPOT!  It gives a special message and is therefore
	  //separated from the regular winning check.  I have never hit the
	  //jackpot, so I don't really know if it works right. :-p - NS

      // But I have, it works perfectly now. - DSL
          if(sa == 10 && se == 10 && si == 10 && sg == 10 && sc == 10)
          {
            send_to_char("The red light on top of your machine lights up and spins!!!\n\r\n\r\n\r", ch);
            send_to_char("{WWOOHOOOO!!!{x\n\r{R",ch);
            send_to_char("       ___   ____       ____      ___   ___ \n\r"
                         "      |   |.'    `.   .'    `.   |   | |   |\n\r"
                         "      |   ||    _  `-.|    _  `-.|   | |   |\n\r"
                         "      |   ||   | `   ||   | `   ||   | |   |\n\r"
                         "      |   ||   |_|   ||   | |__.'|   |_/  .'\n\r"
                         " ___  |   ||    _    ||   |  ___ |    _   `.\n\r"
                         "|   | |   ||   | |   ||   | |   ||   | `   |\n\r"
                         "|   | |   ||   | |   ||   | |   ||   | |   |\n\r"
                         "|   `_|   ||   | |   ||   |_/   ||   | |   |\n\r"
                         "`-._____.-'|___| |___|`-._____.-'|___| |___|\n\r", ch);
            send_to_char("      ____       ____      _________  ___ \n\r"
                         "    .'    `.   .'    `.   |         ||   |\n\r"
                         "    |    _  `-.|    _  `-.|__     __||   |\n\r"
                         "    |   | `   ||   | `   |   |   |   |   |\n\r"
                         "    |   | |   ||   | |   |   |   |   |   |\n\r"
                         "    |   |_/   ||   | |   |   |   |   |   |\n\r"
                         "    |    ___.-'|   | |   |   |   |   |___|\n\r"
                         "    |   |      |   | |   |   |   |   _____\n\r"
                         "    |   |      |   |_/   |   |   |   |   |\n\r"
                         "    |___|      `-._____.-'   |___|   |___|\n\r{x", ch);

            act("The red light on top of $n's slot machine lights up and spins!", ch,NULL,NULL,TO_ROOM);
            act       ("{R       ___   ____       ____      ___   ___ \n\r"
                         "      |   |.'    `.   .'    `.   |   | |   |\n\r"
                         "      |   ||    _  `-.|    _  `-.|   | |   |\n\r"
                         "      |   ||   | `   ||   | `   ||   | |   |\n\r"
                         "      |   ||   |_|   ||   | |__.'|   |_/  .'\n\r"
                         " ___  |   ||    _    ||   |  ___ |    _   `.\n\r"
                         "|   | |   ||   | |   ||   | |   ||   | `   |\n\r"
                         "|   | |   ||   | |   ||   | |   ||   | |   |\n\r"
                         "|   `_|   ||   | |   ||   |_/   ||   | |   |\n\r"
                         "`-._____.-'|___| |___|`-._____.-'|___| |___|", ch, NULL, NULL, TO_ROOM);
            act       ("{R      ____       ____      _________  ___ \n\r"
                         "    .'    `.   .'    `.   |         ||   |\n\r"
                         "    |    _  `-.|    _  `-.|__     __||   |\n\r"
                         "    |   | `   ||   | `   |   |   |   |   |\n\r"
                         "    |   | |   ||   | |   |   |   |   |   |\n\r"
                         "    |   |_/   ||   | |   |   |   |   |   |\n\r"
                         "    |    ___.-'|   | |   |   |   |   |___|\n\r"
                         "    |   |      |   | |   |   |   |   _____\n\r"
                         "    |   |      |   |_/   |   |   |   |   |\n\r"
                         "    |___|      `-._____.-'   |___|   |___|{x", ch, NULL, NULL, TO_ROOM);
            if (slot->value[0] == SLOT_IS_PROGRESSIVE)
            {
//                winnings += basebet * 200; // Was 50
                winnings += slot->value[1];
                slot->value[1] = 500000; // Reset the machine to $5,000
                char_act("A guard pushes a money cart out and unlocks the machine.", ch);
                char_act("He proceeds to put a large amount of money back into it.", ch);
                act ("$n sits back as a guard pushes a money cart out and unlocks $s machine.\n\r"
                     "The guard proceeds to put a large sum of money into the machine.\n\r"
                     "He then turns and pushes the cart away.", ch, NULL, NULL, TO_ROOM);

            }
            else
            {
                  winnings += slot->value[1];
            }
            if(winnings < 100)
            {
              sprintf(buf,"{WYou receive %d cents!{x\n\r",winnings);
              send_to_char(buf,ch);
              ch->silver += winnings;
            }
            else if(winnings == 100)
            {
              char_act("{WYou won a buck!{x",ch);
              ch->gold += 1;
            }
            else if(winnings > 100) 
            {
              sprintf(buf,"{WYou won $%d.%2.2d!{x\n\r",winnings/100, (winnings - ((winnings/100) * 100)));
              send_to_char(buf,ch);
              ch->gold += winnings/100;
              ch->silver += (winnings - ((winnings/100) * 100));
            }
          }

	  //Regular winner.

          else if(winner == TRUE)
          {
            char_act("{YDING! DING! DING! A winner!{x",ch);
            act("$n's slot machine flashes and makes loud noises.",ch,NULL,NULL,TO_ROOM);
            if(winnings < 100)
            {
              sprintf(buf,"{WYou won %d cents!{x\n\r",winnings);
              send_to_char(buf,ch);
              ch->silver += winnings;
            }
            else if(winnings == 100)
            {
              char_act("{WYou won a buck!{x",ch);
              ch->gold += 1;
            }
            else if(winnings > 100)
            {
              sprintf(buf,"{WYou won $%d.%2.2d!{x\n\r",winnings/100, (winnings - ((winnings/100) * 100)));
              send_to_char(buf,ch);
              ch->gold += winnings/100;
              ch->silver += (winnings - ((winnings/100) * 100));
            }
            if (slot->value[0] == SLOT_IS_PROGRESSIVE)
              {
                  slot->value[1] -= winnings;
                  if (slot->value[1] <= 0) // No negative amounts now ;p - DSL
                  {
                     slot->value[1] = 250000;
                     char_act ("A guard pushes a money cart out and unlocks the machine.", ch);
                     char_act ("He proceeds to put a large amount of money back into it.", ch);
                     act ("$n sits back as a guard pushes a money cart out and unlocks $s machine.\n\r"
                          "The guard proceeds to put a large sum of money into the machine.\n\r"
                          "He then turns and pushes the cart away.", ch, NULL, NULL, TO_ROOM);
                  }
              }
          }

	  //Loser. :(

          else
          {
         switch (number_range (0,21)) // A little humor and spice for the mistyped or 
            {
            case 0:
            case 1:
            case 2:
            case 3:
            case 4:
            case 5:
            case 6:
            case 7:
            case 8:
            case 9:
                  char_act("\n\r{RDamn.{x\n\rThe one arm bandit struck again... you lost.",ch);
                   break;
            case 10:
            case 11:
            case 12:
            case 13:
            case 14:
            case 15:
            case 16:
            case 17:
            case 18:
                   char_act("\n\rHOLY CRAP!!! You won... not a damned thing.",ch);
                   break;
            case 19:
                   char_act("\n\rAn beautiful waitress walks over and whispers into your ear \"{yYou lost hon{x\".",ch);
                   break;
            case 20:
                   send_to_char("\n\rYou see a sign flashing near the door that reads \n\r"
                                "\"1-800-NO-GAMBLE\"\n\r"
                                "Then below it \"Gamblers Anonymous\"... You lost pal.\n\r",ch);
                   break;
            case 21:
                   char_act("\n\rA sexy chick walks by with her tits bouncing like melons.",ch);
                   send_to_char("{b      ,8X--------8,{x                  {b`88,\n\r"
                                "{b     ,8X---------X8,{x     I,          {b8X-8,\n\r"
                                "{b    ,8X-----------X8,{x     I,        {b`8X-88,\n\r"
                                "{b   ,8X-------------X8b,{x    I,        {b8XXX-88I,\n\r"
                                "{b   8X----------------XX8,{x   I        {b8XX---XX8,\n\r"
                                "{b  8X-------------------X8,{x  I        {b8X------XX8,\n\r",ch);
                   send_to_char("{b  8X------Xz--zX--------X8,{x 8        {b8X-----X---X8,\n\r"
                                "{b  8X-------XzzX---------X8,{x 8       {b(8X------XXX-8,\n\r"
                                "{b  `8X--------------------X,{x 8,     {b,8X---------X8\n\r"
                                "{b    88X------------------X,{x 8     {b,8X---------X8{x\n\r", ch);
                   char_act    ("\n\r...You were so mesmerized you didn't even notice that you lost your bet.",ch);
                   break;
            default:
                   char_act("\n\rHey, does one of each count for anything?\n\r Well shit, try again.", ch);
            }
          }
        return;
        }
        else
        {
          char_act("Slot commands{W: <{xPLAY{W>{x\n\rFor more information see {W'{xHELP SLOTS{W'{x.",ch);
          return;
        }
return;
}

