/* $Id: clan.h,v 1.666 2004/09/20 10:49:47 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/



#ifndef _CLAN_H_
#define _CLAN_H_

/*----------------------------------------------------------------------
 * clan stuff (clan.c)
 */

#include "stock.h"


#define CLAN_NONE    0

/* Clan status */
#define CLAN_LEADER     2
#define CLAN_SECOND     1
#define CLAN_COMMONER   0
#define CLAN_NEWBIE     3
#define CLAN_VETERAN    4
#define CLAN_ELITE      5

/* Clan politics */
#define DIP_ALLY        4
#define DIP_MISTRUST    3
#define DIP_WAR         2
#define DIP_PEACE       1
#define DIP_NEUTRAL     0

#define ALLIANCE_RESTRICT 0
#define ALLIANCE_ALLOW    1


// clan member structure for clanlist command
struct clan_member
{
    struct clan_member * next ;

    const char * name       ;
    const char * last_login ;
    int    rank       ;
    int    level      ;
    int    alignment  ;
    int    ethos      ;
};

typedef struct clan_stat_data CLAN_STAT_DATA;

struct clan_stat_data
{
    // quests
    int quest_requested;
    int quest_completed;

    // global quests
    int gq_join;
    int gq_completed;

    // wars
    int wars_join;
    int wars_win;

    // kills
    int mobs_killed;
    int pc_killed_by_mobs;
    int PK_count;
    int PK_on_CR;
    int PK_clan_defence;
    int death_clan_defence;
    int PK_clan_attack;     // number of kills where raiding
    int death_clan_attack;  // number of deaths when raiding enemy clans

    // clanbank
    int dep_gold;
    int dep_qp;
    int dep_bp;
    int dep_gem;
    int dep_rgem;
    int dep_bgem;
    int dep_mgem;
    int dep_ygem;
    int dep_ggem;
    int dep_wgem;

    int with_gold;
    int with_qp;
    int with_bp;
    int with_gem;
    int with_rgem;
    int with_bgem;
    int with_mgem;
    int with_ygem;
    int with_ggem;
    int with_wgem;

    char * best_explorer_name;
    int best_explored_count;

    char * best_gq_win_name;
    int best_gq_win_count;

    char * best_quest_win_name;
    int best_quest_win_count;
};

/*
 * Clan structure
 */
struct clan_t
{
    const char *name;                    /* clan name */
    const char *file_name;               /* file name */

    int         recall_vnum;             /* recall room vnum */
    const char *msg_prays;               /* what to print in clanrecall */
    const char *msg_vanishes;

    varr        skills;                  /* clan skills */

    flag64_t    flags;                   /* clan flags */

    long        item_time;               /* time without clan item */

    int         obj_vnum;                /* unused (for a while) */
    int         mark_vnum;               /* vnum clan mark */
    int         altar_vnum;
    int         altar_trophy_vnum;
    OBJ_DATA *  altar_ptr;
    OBJ_DATA *  altar_trp;
    OBJ_DATA *  obj_ptr;
    int         bank_questp;
    int         bank_gold;
    int         bank_bonus;
    int         bank_gems;
    int         bank_rgems;
    int         bank_bgems;
    int         bank_ggems;
    int         bank_mgems;
    int         bank_wgems;
    int         bank_ygems;
    int         item_at;
    int         diplomacy[MAX_CLANS];
    int         clan_align;               // for diplomacy. do't allow good + evil clans ally

    int         max_clan_members;
    int         cur_clan_members;
    int         min_clan_level;
    flag64_t    allow_alliance;
    struct      clan_member * member_list;

    int         standard_areaguard_vnum;
    int         veteran_areaguard_vnum;
    int         elite_areaguard_vnum;
    int         areacontrol_rating;        // don't know yet rooms/totalrooms * tick
                                           // or areas*ticks or somthing else...
    int         energy;
    flag64_t    conq_flags;
    CHAR_DATA * advisor;
    CHAR_DATA * spy;
    CHAR_DATA * transporter;
    int         conquered_areas;
    int         area_energy_this_tick;
    int         earned_energy_this_tick;
    CLAN_STAT_DATA history;
    STOCK_DATA  clan_stock;
};

/* clan flags */
#define CLAN_HIDDEN (A)         /* clan will not appear in who */
#define CLAN_RULERS (B)         /* clan which keeping law */
#define CLAN_HATE_MAGIC (C)     /* clan which not use magic */
#define CLAN_LOVE_MAGIC (D)     /* clan which use magic */
#define CLAN_CAN_SEE    (E)     /* clan which buy visibility */
#define CLAN_CHANGED    (Z)

clan_t     *clan_new                    (void);
void        clan_free                   (clan_t*);
int         cln_lookup                  (const char* name);
const char *clan_name                   (int cn);
void        check_clan_item             (clan_t*);
OBJ_DATA   *get_clan_altar              (clan_t *clan);
OBJ_DATA   *get_clan_item               (clan_t *clan);
bool        is_clan_item_in_altar       (clan_t *clan);
bool        is_clan_item_at_enemy       (clan_t *clan);
void        check_clans                 (void);
clan_t     *is_clan_item                (OBJ_DATA *obj);
bool        is_clan_item_ok             (CHAR_DATA *ch);
clan_t     *is_clan_altar               (OBJ_DATA *obj);
int         get_clan_max_percent        (CHAR_DATA *ch, int sn, int skill);

extern varr clans;

#define CLAN(cn)            ((clan_t*) VARR_GET(&clans, cn))
#define clan_lookup(cn)     ((clan_t*) varr_get(&clans, cn))
#define IS_CLAN_SKILL(sk)   (IS_SET(sk->group, GROUP_CLAN))

struct clan_skill_t
{
    int sn;         /* skill number. leave this field first  */
                    /* in order sn_vlookup to work properly  */
    int level;      /* level at which skill become available */
    int percent;    /* initial percent           */
};

#define clan_skill_lookup(clan, sn) \
    ((clan_skill_t*) varr_bsearch(&clan->skills, &sn, cmpint))


typedef struct clanbank_cmds       CLANBANK_CMD;

DECLARE_DO_FUN(clanbank_help       );
//DECLARE_DO_FUN(clanbank_deposit    );
//DECLARE_DO_FUN(clanbank_transaction);
//DECLARE_DO_FUN(clanbank_withdraw   );
//DECLARE_DO_FUN(clanbank_balance    );

struct clanbank_cmds
{
    char        *name          ; // command name
    DO_FUN*      fun           ; // command function
    int          clan_level    ;
};

#endif
