/* $Id: class.c,v 1.666 2004/09/20 10:49:47 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
 /************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/


#include <stdio.h>

#include "merc.h"

varr    classes = { sizeof(class_t), 4};

class_t *class_new(void)
{
    class_t *class;

    class = varr_enew(&classes);
    class->skills.nsize = sizeof(class_skill_t);
    class->skills.nstep = 8;
    class->restrict_sex = -1;
    class->poses.nsize = sizeof(pose_t);
    class->poses.nstep = 4;

    return class;
}

void class_free(class_t *class)
{
    varr_free(&class->skills);
    varr_free(&class->poses);
}

/*
 * guild_check - == 0 - the room is not a guild
 *                > 0 - the room is guild and ch is allowed there
 *                < 0 - the room is guild and ch is not allowed there
 */
int guild_check(CHAR_DATA *ch, ROOM_INDEX_DATA *room)
{
    int class = -1;
    int iClass, iGuild;

    for (iClass = 0; iClass < classes.nused; iClass++)
    {
        class_t *cl = CLASS(iClass);
        for (iGuild = 0; iGuild < cl->guild->nused; iGuild++)
        {
            if (room->vnum == *(int*) VARR_GET(cl->guild, iGuild))
            {
                if (iClass == ch->class)
                    return 1;
                class = iClass;
            }
        }
    }

    if (class == -1)
        return 0;

    if (IS_IMMORTAL(ch))
        return 1;

    return -1;
}

const char *class_name(CHAR_DATA *ch)
{
    class_t *cl;

    if (IS_NPC(ch) || (cl = class_lookup(ch->class)) == NULL)
        return "Mobile";
    return cl->name;
}

int class_dodge(CHAR_DATA *ch)
{
    class_t *cl;

    if (IS_NPC(ch) || (cl = class_lookup(ch->class)) == NULL)
        return 0;
    return cl->dodge;
}

const char *class_who_name(CHAR_DATA *ch)
{
    class_t *cl;

    if (IS_NPC(ch) || (cl = class_lookup(ch->class)) == NULL)
        return "Mob";
    return cl->who_name;
}

/* returns class number */
int cn_lookup(const char *name)
{
    int num;

    for (num = 0; num < classes.nused; num++)
    {
        if (LOWER(name[0]) == LOWER(CLASS(num)->name[0])
            &&  !str_prefix(name, (CLASS(num)->name)))
            return num;
    }

    return -1;
}

/* command for retrieving stats */
int get_curr_stat(CHAR_DATA *ch, int stat)
{
    int max;

    if (IS_NPC(ch) || ch->level >= LEVEL_IMMORTAL)
        max = 25;
    else
        max = UMIN(get_max_train(ch, stat), 25);

    return URANGE(3, ch->perm_stat[stat] + ch->mod_stat[stat], max);
}

/* command for returning max training score */
int get_max_train(CHAR_DATA *ch, int stat)
{
    class_t *cl;
    race_t *r;

    if (IS_NPC(ch) || ch->level >= LEVEL_IMMORTAL)
        return 25;

    if ((cl = class_lookup(ch->class)) == NULL
        ||  (r = race_lookup(ch->pcdata->race)) == NULL
        ||  !r->pcdata)
        return 0;

/* ORG_RACE && RACE serdar*/
    return UMIN(25, 20 + r->pcdata->stats[stat] + cl->stats[stat]);
}

bool clan_ok(CHAR_DATA *ch, int sn)
{
    return TRUE;
}

const char *title_lookup(CHAR_DATA *ch)
{
    class_t *class;

    if ((class = class_lookup(ch->class)) == NULL
        ||  (ch->level < 0 || ch->level > MAX_LEVEL))
        return str_empty;

    return class->titles[ch->level][ch->sex == SEX_MALE ? 0 : 1];
}

int class_can_wear(CHAR_DATA *ch, int location)
{
    class_t *class;

    if ((class = class_lookup(ch->class)) == NULL
        || IS_NPC(ch) || IS_IMMORTAL(ch))
        return 1;

    return class->wear_loc[location];
}

int is_class_mage(CHAR_DATA *ch)
{
    class_t *class;

    if ((class = class_lookup(ch->class)) == NULL)
        return -1;
    if (IS_SET(class->flags, CLASS_MAGIC))
        return 1;
    return 0;
}

int is_class_warrior(CHAR_DATA *ch)
{
    class_t *class;

    if ((class = class_lookup(ch->class)) == NULL)
        return -1;
    if (IS_SET(class->flags, CLASS_WARR))
        return 1;
    return 0;
}

const char *cl_name(int i)
{
     class_t *c = class_lookup(i);

     if (c == NULL)
               return "unknown";
     return c->name;
}

void *class_vlookup(varr *v, const char *name)
{
     int i;
     
     if (IS_NULLSTR(name))
          return NULL;
     
     for (i = 0; i < v->nused; i++) 
     {
          class_t *cl;
          int *psn = (int*) VARR_GET(v, i);
          log_printf("name: %s    psn: %d    i:%d,    nused:%d ", name, psn[i], i, v->nused);
          cl = class_lookup(*psn) ;
          
          if(cl !=NULL)
          {
                    
              if  (!str_prefix(name, cl->name))
              {
                     log_printf("name: %s  clname: %s  psn: %d", name, cl->name, psn[i]);
                     return psn;
              }
          }
          
          if (cl !=NULL)
               log_printf("class %s arg: %s psn:%d i:%d, nused:%d", cl->name, name, psn, i, v->nused);
          else
               log_printf("cl is NULL");
}

return NULL;
}

int cmp_skill_int(const void *p1, const void *p2)
{
     return ((class_skill_t*) p1)->level - ((class_skill_t*) p2)->level;
}
