/*  $Id: comm_act.h,v 1.666 2004/09/20 10:50:15 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/
 


#ifndef _COMM_ACT_H_
#define _COMM_ACT_H_

/* the following 5 act target flags are exclusive */
#define TO_ROOM     (A)
#define TO_NOTVICT  (B)
#define TO_VICT     (C)
#define TO_CHAR     (D)
#define TO_ALL      (E)

#define ACT_TOBUF   (F)
#define ACT_NOTRIG  (G)
#define ACT_NOTWIT  (H)
#define ACT_TRANS   (I) /* do $t and $T translation         */
#define ACT_NODEAF  (J) /* skip is_affected(to, gsn_deafen) chars   */
#define ACT_STRANS  (K) /* do $t and $T slang translation (from ch) */
#define ACT_NOMORTAL    (L) /* skip mortals */
#define ACT_VERBOSE (M) /* skip if (!IS_SET(ch->comm, COMM_VERBOSE)) */
#define ACT_NOLF    (N) /* do not append lf */
#define ACT_NOUCASE (Q) /* do not uppercase first letter*/
#define ACT_FORMSH  (O) /* call format_short for short descrs */
#define ACT_NOFIXSH   (P) /* do not fix char/obj short descrs */ 
#define ACT_NOFIXTEXT   (R) /* do not call fix_short() for text args */
#define ACT_USEOPT      (S) /* force to use opt sex and lang instead of to's */
#define ACT_FORMSH_ALWAYS   (T) /* for memento stuff */

#define ACT_SPEECH(ch)  (ACT_NODEAF | ACT_STRANS | ACT_NOFIXTEXT | ACT_NOTWIT \
            | ACT_NOTRIG | (!IS_NPC(ch) || IS_AFFECTED(ch, AFF_CHARM) ? 0 : ACT_TRANS))

#define char_act(format, ch) \
        act_puts((format), (ch), NULL, NULL, TO_CHAR, POS_DEAD)
#define char_act_trans(format, ch) \
        act_puts((format), (ch), NULL, NULL, TO_CHAR | ACT_TRANS, POS_DEAD)        
#define act(format, ch, arg1, arg2, type) \
        act_puts((format), (ch), (arg1), (arg2), (type), POS_RESTING)
#define act_puts(format, ch, arg1, arg2, type, min_pos) \
        act_puts3((format), (ch), (arg1), (arg2), NULL, (type), (min_pos))
void    act_puts3(const char *format, CHAR_DATA *ch,
          const void *arg1, const void *arg2, const void *arg3, 
          int flags, int min_pos);

void buf_act(BUFFER *buffer, const char *format, CHAR_DATA *ch,
             const void *arg1, const void *arg2, const void *arg3, int flags);

void    act_printf(CHAR_DATA *ch, const void *arg1, const void *arg2,
           int flags, int min_pos, const char* format, ...);
void    act_raw_global(CHAR_DATA *ch, CHAR_DATA *to,
            const void *arg1, const void *arg2,
            const char *str, int flags);
const char* act_speech2(CHAR_DATA *ch, CHAR_DATA *vch, const char *text, const void *arg, const void *arg3);
#define act_speech(ch, vch, text, arg) \
        act_speech2((ch), (vch), (text), (arg), NULL)
void    act_yell(CHAR_DATA *ch, const char *text, const void *arg, const char *format);
void    act_clan(CHAR_DATA *ch, const char *text, const void *arg);
void    act_allytalk(CHAR_DATA *ch, const char *text, const void *arg);
void    act_say(CHAR_DATA *ch, const char *text, const void *arg);
void    act_tell2(const char *text, CHAR_DATA *ch, 
                  const void *arg, CHAR_DATA *victim, const void *arg3);
#define act_tell(text, ch, arg, victim) \
        act_tell2((text), (ch), (arg), (victim), NULL)
#endif
