/* $Id: conquer.h,v 1.666 2004/09/20 10:49:47 shrike Exp $ */
 
 /************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


#ifndef _CONQUER_H
#define _CONQUER_H

// typedef
// command data
struct cmd_data 
{
    char *name;
    void (*do_fn) ( CHAR_DATA *ch, const char* arg );
    int min_position;
    int level;
    int quest_price; // price in qp
    int gold_price;  // price in gold
    int min_clan_status;
    int extra; // keep_hide or not
};
typedef struct cmd_data CMD_DATA;

#define CONQ_FILE_NAME            "conquered.lst"
#define CONQ_CONFIG_FILE          "conquer.conf"

// explore requirement constants
#define EXPLORE_NOT_REQ           0
#define EXPLORE_GUARDROOMS_REQ    1
#define EXPLORE_ALL_AREA_REQ      2

// altar stuff
// positions in area_data->altars and ->priests
#define ALTAR_GREED_POS           0
#define ALTAR_HASTE_POS           1
#define ALTAR_MAGIC_POS           2
#define ALTAR_TRAVEL_POS          3
#define ALTAR_TRANQUILITY_POS     4
#define ALTAR_SUMMONING_POS       5
#define ALTAR_IMMOBILITY_POS      6
#define OUTPOST_POS               7
#define ALTAR_REGENERATION_POS    8
#define ALTAR_EXPERIENCE_POS      9
#define ALTAR_NEGATION_POS        10

//type of hp/mana/moves and bonus modification
#define GAIN_HP                   1
#define GAIN_MANA                 2
#define GAIN_MOVES                3

#define GLOBAL_QUEST_REWARD       4

#define QUEST_REWARD_GOLD         5
#define QUEST_REWARD_QP           6

// areaguard ranks
#define AREAGUARD_STANDARD        0
#define AREAGUARD_VETERAN         1
#define AREAGUARD_ELITE           2

// clan flags 
#define CLAN_WITH_ADVISOR         (A)        // clan which have bought advisor
#define CLAN_WITH_SPY             (B)        // clan which have bought area spy
#define CLAN_WITH_TRANSPORTER     (C)        // clan which have bought mage-transporter
#define CLAN_CAN_CONQUER          (D)        // clan can conquer area

// command permissioms
#define CONQ_ALL                  0        // commands available for all players
#define CONQ_CLAN                 1        // only for clan members
#define CONQ_ELITE                2        // elite and clan leadres
#define CONQ_LEADERS              3        // leader and second

// extra
#define CONQCMD_KEEP_HIDE         (A)      // ch keeps hide/fade etc
#define CONQCMD_IF_PERMITTED      (B)      // only for clans with CLAN_CAN_CONQUER flag
#define CONQCMD_RUS               (C)      // russian command
#define CONQCMD_REUSE_ARG         (D)      // do not consume argument

// altar building options
#define ALTAR_NO_BR               (A)      // clans with CLAN_HATE_MAGIC flag can't build altar
#define ALTAR_NO_CLANAREA         (B)      // altar can't be built in clanarea

// level bonus for summoned mobiles
#define LEVEL_BONUS               number_range (1,3)

// exported functions
void areacontrol_handle_death(CHAR_DATA *ch, CHAR_DATA *victim);
void areacontrol_update (void);
void load_conquered_areas ();
void save_conquered_areas ();
int  areacontrol_modify_gain (CHAR_DATA *ch, int gain, int type);
int  get_world_free_energy(void);
void put_world_free_energy(int new_value); 
void conquer_read_config ( void );

bool parse_command (CHAR_DATA *ch, const char *argument, CMD_DATA cmd_table[]);
void show_command_list (CHAR_DATA *ch, CMD_DATA cmd_table[]); 
bool altar_works (CHAR_DATA * ch, int type);

#endif
