/* $Id: const.h,v 1.666 2004/09/20 10:49:47 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
 /************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/

                                                         
#ifndef _CONST_H_
#define _CONST_H_

/*
 * Data files used by the server.
 *
 * AREA_LIST contains a list of areas to boot.
 * All files are read in completely at bootup.
 * Most output files (bug, idea, typo, shutdown) are append-only.
 *
 * The NULL_FILE is held open so that we have a stream handle in reserve,
 *   so players can go ahead and telnet to all the other descriptors.
 * Then we close it whenever we need to open a file (e.g. a save file).
 */

#if defined (WIN32)
#   include <stdlib.h>
#   define PATH_MAX _MAX_PATH
#   define PATH_SEPARATOR '\\'
#else
#   define PATH_SEPARATOR '/'
#endif

#define TMP_PATH        "tmp"
#define PLAYER_PATH     "player"
#define GODS_PATH       "gods"
#define NOTES_PATH      "notes"
#define MSGDB_PATH      "msgdb"
#define ETC_PATH        "etc"
#define RACES_PATH      "races"
#define CLASSES_PATH    "classes"
#define CLANS_PATH      "clans"
#define RELIGIONS_PATH  "religions"
#define AREA_PATH       "area"
#define LANG_PATH       "lang"
#define LOG_PATH        "log"

#ifdef IMC
#define IMC_PATH    ETC_PATH /* should be "imc", actually,
                              * but i need to pull Illinar's hobbot for that.
                              */
#endif

#define TMP_FILE    "romtmp"

#if defined (WIN32)
#define NULL_FILE    "NUL"   /* To reserve one stream */
#else
#define NULL_FILE    "/dev/null" /* To reserve one stream */
#endif

#define ALIASES_CONF    "aliases.conf"      /* aliases for commands */
#define ARTEFACTS_CONF  "artefacts.conf"    /* for Aseroth's artefacts */
#define PRICES_CONF     "prices.conf"       /* prices */
#define METEORS_CONF    "meteors.conf"      /* meteors */
#define SECURITY_CONF   "security.conf"     /* security */
#define COMMANDS_CONF   "commands.conf"     /* commands */
#define HOMETOWNS_CONF  "hometowns.conf"    /* hometowns */
#define SKILLS_CONF     "skills.conf"       /* skills */
#define SOCIALS_CONF    "socials.conf"      /* socials */
#define LANG_CONF       "lang.conf"         /* lang definitions */
#define SYSTEM_CONF     "system.conf"       /* system configuration */
#define PORTS_CONF      "ports.conf"        /* ports confguration */
#define MSG_FILE        "msgdb.txt"         /* msg db */
#define RIDDLES_CONF    "riddles.txt"
#define IMMORTAL_CONF   "immortals.conf"    /* list of immortals */
#define TATTOO_CONF     "tattoo.conf"       /* list of tattoes */
#define RITUAL_CONF     "ritual.conf"       /* list of rituals */
#define PAINT_CONF      "paint.conf"       /* list of paints */
#define MATERIAL_CONF   "materials.conf"
#define LIQUID_CONF     "liquid.conf"
#define AREA_LIST       "area.lst"          /* list of areas */
#define CLAN_LIST       "clan.lst"          /* list of clans */
#define CLASS_LIST      "class.lst"         /* list of classes */
#define LANG_LIST       "lang.lst"          /* list of languages */
#define RACE_LIST       "race.lst"          /* list of races */
#define RELIGION_LIST   "religion.lst"      /* list of religions */
#define HOLDER_LIST     "holder.lst"        /* list of limit holders */

#define BUG_FILE        "bugs.txt"          /* For 'bug' and bug()*/

#define TYPO_FILE       "typos.txt"         /* For 'typo'*/
#define NOTE_FILE       "notes.not"         /* For 'notes'*/
#define IDEA_FILE       "ideas.not"
#define PENALTY_FILE    "penal.not"
#define NEWS_FILE       "news.not"
#define CHANGES_FILE    "chang.not"
#define SHUTDOWN_FILE   "shutdown.txt"      /* For 'shutdown'*/
#define BAN_FILE        "ban.txt"
#define MAXON_FILE      "maxon.txt"
#define AREASTAT_FILE   "areastat.txt"
#define IMMLOG_FILE     "immortals.log"
#define DEBUG_FILE      "debug.log"
#define CLANBANKLOG_FILE "clanbank.log"

#define RANKING_EXE     "bin/ranking"

/*
 * String and memory management parameters.
 */
#define CRYPT_SALT      "Z0" /* Crypto parametres */
#define MAX_KEY_HASH        1024
#define MAX_STRING_HASH     16384

#define MAX_STRING_LENGTH   8192
#define MAX_INPUT_LENGTH    1024

#define MAX_PROMPT_LENGTH   60
#define MAX_TITLE_LENGTH    45
#define MAX_CHAR_NAME       12
#define PAGELEN         22
#define SCROLL_MIN      16
#define SCROLL_MAX      192

/*
 * Game parameters.
 */

/* align numbers */
enum {
    ANUM_GOOD,
    ANUM_NEUTRAL,
    ANUM_EVIL,

    MAX_ANUM
};

enum {
    STAT_STR,
    STAT_INT,
    STAT_WIS,
    STAT_DEX,
    STAT_CON,
    STAT_CHA,
    STAT_LCK,

    MAX_STAT        /* number of char stats */
};

#define MAX_STATS   MAX_STAT    /* ROM compatibility */

//    (c)Aseroth/Illinar - Limit Strip
#define TICKS_TO_PLAY   120     /*     */
#define DAYS_TO_PLAY    21      /*     */
#define TPH             60      /*     */
#define TPD             TPH*24  /*   -  */
#define LTIMER_DEFAULT  14*TPD  /*    */

#define CACHE_TTL       5       /*       */
#define TFN             (5*TPH) /* tick for newbie =) */

#define PK_MIN_LEVEL        10  /* min PK level */
#define MAX_NEWBIES     120 /* number of newbies allowed */
#define MAX_OLDIES      999 /* number of newbies allowed */
#define MAX_TRADE       5   /* number of trade types for shops */
#define MAX_COND        6   /* number of char condition stats */
#define MAX_DIR         6   /* number of exits */
#define MAX_ALIAS       50  /* number of aliases char can have */
#define RATING_TABLE_SIZE   25  /* rating table size */
#define MAX_LEVEL       101
#define MAX_CLANS       32
#define MAX_CONTACTS    10  /* number of contacts for 1 person allowed */

#define LEVEL_HERO      (MAX_LEVEL - 10)
#define LEVEL_IMMORTAL      (MAX_LEVEL - 9)
#define LEVEL_NEWBIE        5
#define MIN_CLAN_LEVEL     11

#define IMPLEMENTOR     (MAX_LEVEL  - 1)
#define CREATOR         (MAX_LEVEL - 2)
#define SUPREME         (MAX_LEVEL - 3)
#define DEITY           (MAX_LEVEL - 4)
#define GOD             (MAX_LEVEL - 5)
#define IMMORTAL        (MAX_LEVEL - 6)
#define DEMI            (MAX_LEVEL - 7)
#define ANGEL           (MAX_LEVEL - 8)
#define AVATAR          (MAX_LEVEL - 9)
#define HERO            LEVEL_HERO

#define ML  (MAX_LEVEL - 1) /* implementor */
#define L1  (MAX_LEVEL - 2) /* creator */
#define L2  (MAX_LEVEL - 3) /* supreme being */
#define L3  (MAX_LEVEL - 4) /* deity */
#define L4  (MAX_LEVEL - 5) /* god */
#define L5  (MAX_LEVEL - 6) /* immortal */
#define L6  (MAX_LEVEL - 7) /* demigod */
#define L7  (MAX_LEVEL - 8) /* angel */
#define L8  (MAX_LEVEL - 9) /* avatar */
#define IM  LEVEL_IMMORTAL  /* angel */
#define HE  LEVEL_HERO  /* hero */

#define SEC_LOAD_LIMIT      10

#undef ANATOLIA_MACHINE
#if defined(ANATOLIA_MACHINE)
#   define PULSE_PER_SCD        6  /* 6 for comm.c */
#   define PULSE_PER_SECOND     4  /* for update.c */
#   define PULSE_VIOLENCE       (2 *  PULSE_PER_SECOND)
#else
#   define PULSE_PER_SCD        4
#   define PULSE_PER_SECOND     4
#   define PULSE_VIOLENCE       (3 * PULSE_PER_SECOND)
#endif

#define PULSE_MOBILE            (4 * PULSE_PER_SECOND)
#define PULSE_WATER_FLOAT       (4 * PULSE_PER_SECOND)
#define PULSE_MUSIC             (6 * PULSE_PER_SECOND)
#define PULSE_TRACK             (12 * PULSE_PER_SECOND)
#define PULSE_TICK              (50 * PULSE_PER_SECOND) /* 36 saniye */

#define PULSE_LIMIT             (120 * PULSE_TICK) /* when to check for limits */
#define PULSE_RANKING           (47 * PULSE_TICK)  /* when to update ranks */

/* room_affect_update (not room_update) */
#define PULSE_RAFFECT       (3 * PULSE_MOBILE)
#define PULSE_AREA      (110 * PULSE_PER_SECOND) /* 97 saniye */
#define PULSE_AUCTION       (20 * PULSE_PER_SECOND) /* 20 seconds */

#define FIGHT_DELAY_TIME    (20 * PULSE_PER_SECOND)
#define GHOST_DELAY_TIME    600
#define MISSING_TARGET_DELAY    10

/*
 * Well known mob virtual numbers.
 * Defined in #MOBILES.
 */
#define MOB_VNUM_CITYGUARD          3060
#define MOB_VNUM_VAGABOND           3063
#define MOB_VNUM_CAT                3066
#define MOB_VNUM_FIDO               3062
#define MOB_VNUM_SAGE               3162

#define MOB_VNUM_VAMPIRE            3404

#define MOB_VNUM_SHADOW             10
#define MOB_VNUM_SPECIAL_GUARD      11
#define MOB_VNUM_BEAR               12
#define MOB_VNUM_DEMON              13
#define MOB_VNUM_GHOSTDRAGON        14
#define MOB_VNUM_STALKER            15
#define MOB_VNUM_ROBOT              16
#define MOB_VNUM_MIRROR_IMAGE       17
#define MOB_VNUM_UNDEAD             18
#define MOB_VNUM_LION               19
#define MOB_VNUM_WOLF               20
#define MOB_VNUM_LESSER_GOLEM       21
#define MOB_VNUM_STONE_GOLEM        22
#define MOB_VNUM_IRON_GOLEM         23
#define MOB_VNUM_ADAMANTITE_GOLEM   24
#define MOB_VNUM_HUNTER             25
#define MOB_VNUM_SUM_SHADOW         26
#define MOB_VNUM_VAMPIRE_BAT        27
#define MOB_VNUM_DIAMOND_GOLEM      28
#define MOB_VNUM_CREATED_GOLEM      29
#define MOB_VNUM_ARCHON             30
#define MOB_VNUM_DRAGON             31
#define MOB_VNUM_ELM_EARTH          32
#define MOB_VNUM_ELM_AIR            33
#define MOB_VNUM_ELM_WATER          34
#define MOB_VNUM_ELM_FIRE           35
#define MOB_VNUM_ELM_LIGHT          36
#define MOB_VNUM_WEAPON             37
#define MOB_VNUM_ARMOR              38
#define MOB_VNUM_DOG                39
#define MOB_VNUM_FOREST_GIANT       40
#define MOB_VNUM_SOUL               41
#define MOB_VNUM_ANGEL              42
#define MOB_VNUM_DEVIL              43
#define MOB_VNUM_SQUIRE             44
#define MOB_VNUM_TREANT             45

#define MOB_VNUM_ANIMATED_MIN       51
#define MOB_VNUM_ANIMATED_NECK      51
#define MOB_VNUM_ANIMATED_SHIELD    52
#define MOB_VNUM_ANIMATED_FLOAT     53
#define MOB_VNUM_ANIMATED_HANDS     54
#define MOB_VNUM_ANIMATED_ARMS      55
#define MOB_VNUM_ANIMATED_LEGS      56
#define MOB_VNUM_ANIMATED_FEET      57
#define MOB_VNUM_ANIMATED_PLUG_IN   58
#define MOB_VNUM_ANIMATED_BODY      59
#define MOB_VNUM_ANIMATED_WEAPON    60
#define MOB_VNUM_ANIMATED_OTHER     61
#define MOB_VNUM_ANIMATED_HELM      62
#define MOB_VNUM_ANIMATED_MAX       62

#define MOB_VNUM_FIRE_DRAGON        63
#define MOB_VNUM_ICE_DRAGON         64
#define MOB_VNUM_BIG_LION           65


#define MOB_VNUM_PATROLMAN          2106
#define GROUP_VNUM_TROLLS           2100
#define GROUP_VNUM_OGRES            2101

/*
 * Well known object virtual numbers.
 * Defined in #OBJECTS.
 */
#define OBJ_VNUM_SILVER_ONE         1
#define OBJ_VNUM_GOLD_ONE           2
#define OBJ_VNUM_GOLD_SOME          3
#define OBJ_VNUM_SILVER_SOME        4
#define OBJ_VNUM_COINS              5

#define OBJ_VNUM_CORPSE_NPC         10
#define OBJ_VNUM_CORPSE_PC          11
#define OBJ_VNUM_CORPSE_PC2         37
#define OBJ_VNUM_SEVERED_HEAD       12
#define OBJ_VNUM_TORN_HEART         13
#define OBJ_VNUM_SLICED_ARM         14
#define OBJ_VNUM_SLICED_LEG         15
#define OBJ_VNUM_GUTS               16
#define OBJ_VNUM_BRAINS             17
#define OBJ_VNUM_LASER_RIFLE        19
#define OBJ_VNUM_IMPERIAL_PLATE     24

#define OBJ_VNUM_MUSHROOM           20
#define OBJ_VNUM_LIGHT_BALL         21
#define OBJ_VNUM_SPRING             22
#define OBJ_VNUM_DISC               23
#define OBJ_VNUM_DEVICE             29
#define OBJ_VNUM_ANGEL              38
#define OBJ_VNUM_PORTAL             25
#define OBJ_VNUM_DUMMY              30
// VNUMs for EMPOWER stuff...
//#define OBJ_VNUM_FREE           48
#define OBJ_VNUM_WOOD               6515
#define OBJ_VNUM_SCROLL_SCRIBING    41
#define OBJ_VNUM_SCROLL_SCRIBED     49
#define OBJ_VNUM_WAND               6557
#define OBJ_VNUM_WAND_EMPOWERED     6559
#define OBJ_VNUM_STAFF              6560
#define OBJ_VNUM_STAFF_EMPOWERED    6561

#define OBJ_VNUM_ROSE               1001
#define OBJ_VNUM_PIT                3010
#define OBJ_VNUM_WANTED_DESK        2999

#define OBJ_VNUM_SCHOOL_MACE        3700
#define OBJ_VNUM_SCHOOL_DAGGER      3701
#define OBJ_VNUM_SCHOOL_SWORD       3702
#define OBJ_VNUM_SCHOOL_SPEAR       3717
#define OBJ_VNUM_SCHOOL_STAFF       3718
#define OBJ_VNUM_SCHOOL_AXE         3719
#define OBJ_VNUM_SCHOOL_FLAIL       3720
#define OBJ_VNUM_SCHOOL_WHIP        3721
#define OBJ_VNUM_SCHOOL_POLEARM     3722
#define OBJ_VNUM_SCHOOL_BOW         3723
#define OBJ_VNUM_SCHOOL_LANCE       3724

#define OBJ_VNUM_SCHOOL_VEST        3703
#define OBJ_VNUM_SCHOOL_SHIELD      3704
#define OBJ_VNUM_SCHOOL_BANNER      3716

#define OBJ_VNUM_MAP                3162
#define OBJ_VNUM_NMAP1              3385
#define OBJ_VNUM_NMAP2              3386
#define OBJ_VNUM_MAP_NT             3167
#define OBJ_VNUM_MAP_OFCOL          3162
#define OBJ_VNUM_MAP_SM             3164
#define OBJ_VNUM_MAP_TITAN          3382
#define OBJ_VNUM_MAP_OLD            5333

#define OBJ_VNUM_WHISTLE            2116

#define OBJ_VNUM_POTION_VIAL        42
#define OBJ_VNUM_STEAK              27
#define OBJ_VNUM_RANGER_STAFF       28
#define OBJ_VNUM_RANGER_ARROW       6
#define OBJ_VNUM_RANGER_BOW         7
#define OBJ_VNUM_RANGER_QUIVER      15015

#define OBJ_VNUM_DEPUTY_BADGE       70
#define OBJ_VNUM_RULER_BADGE        70
#define OBJ_VNUM_RULER_SHIELD1      71
#define OBJ_VNUM_RULER_SHIELD2      72
#define OBJ_VNUM_RULER_SHIELD3      73
#define OBJ_VNUM_RULER_SHIELD4      74

#define OBJ_VNUM_CHAOS_BLADE        97
#define OBJ_VNUM_BATTERY            34
#define OBJ_VNUM_MINE               35
#define OBJ_VNUM_FUNPILL            36
#define OBJ_VNUM_BLOODY_AXE         8
#define OBJ_VNUM_GRENADE            15004
#define OBJ_VNUM_BERET              76

#define OBJ_VNUM_PLATE              82
#define OBJ_VNUM_R_LIGHTSABER       79
#define OBJ_VNUM_B_LIGHTSABER       80
#define OBJ_VNUM_G_LIGHTSABER       81
#define OBJ_VNUM_M_LIGHTSABER       83
#define OBJ_VNUM_W_LIGHTSABER       90
#define OBJ_VNUM_Y_LIGHTSABER       99

#define OBJ_VNUM_BATTLE_PONCHO      26

#define OBJ_VNUM_POTION_SILVER      43
#define OBJ_VNUM_POTION_GOLDEN      44
#define OBJ_VNUM_POTION_SWIRLING    45
#define OBJ_VNUM_KATANA_SWORD       98

#define OBJ_VNUM_EYED_SWORD         88
#define OBJ_VNUM_FIRE_SHIELD        92
#define OBJ_VNUM_MAGIC_JAR          93

#define OBJ_VNUM_HOLE               6500
#define OBJ_VNUM_STUB               6501

#define OBJ_VNUM_IRON_ORE           6526
#define OBJ_VNUM_CHUNK_IRON         6521
#define OBJ_VNUM_COPPER_ORE         6527
#define OBJ_VNUM_CHUNK_COPPER       6523
#define OBJ_VNUM_GOLD_ORE           6528
#define OBJ_VNUM_CHUNK_GOLD         6524
#define OBJ_VNUM_CHUNK_COAL         6517
#define OBJ_VNUM_GEMS               6525
#define OBJ_VNUM_SKIN               6503

#define OBJ_VNUM_R_GEMS             6551
#define OBJ_VNUM_B_GEMS             6552
#define OBJ_VNUM_G_GEMS             6553
#define OBJ_VNUM_M_GEMS             6554
#define OBJ_VNUM_W_GEMS             6555
#define OBJ_VNUM_Y_GEMS             6556

#define OBJ_VNUM_PICK               6518
#define OBJ_VNUM_HAMMER             6522
#define OBJ_VNUM_PLIERS             6529

#define OBJ_VNUM_FORGE              6547
#define OBJ_VNUM_ANVIL              6548
#define OBJ_VNUM_SMALL_HAMMER       6550

#define OBJ_VNUM_DWARVEN_RING       6530
#define OBJ_VNUM_DWARVEN_SCEPTRE    6531
#define OBJ_VNUM_DWARVEN_BRACER     6532
#define OBJ_VNUM_DWARVEN_BOOTS      6533
#define OBJ_VNUM_DWARVEN_GAUNTLETS  6534
#define OBJ_VNUM_DWARVEN_LEGPLATES  6535
#define OBJ_VNUM_DWARVEN_ARMPLATES  6536
#define OBJ_VNUM_DWARVEN_COLLAR     6537
#define OBJ_VNUM_DWARVEN_CHAINMAIL  6538
#define OBJ_VNUM_DWARVEN_HELMET     6539
#define OBJ_VNUM_DWARVEN_DAGGER     6549
#define OBJ_VNUM_DWARVEN_SWORD      6540
#define OBJ_VNUM_DWARVEN_CLAYMORE   6541
#define OBJ_VNUM_DWARVEN_AXE        6542
#define OBJ_VNUM_DWARVEN_FLAIL      6543
#define OBJ_VNUM_DWARVEN_MACE       6544
#define OBJ_VNUM_DWARVEN_HAULBERD   6545
#define OBJ_VNUM_DWARVEN_SPEAR      6546
#define OBJ_VNUM_DWARVEN_EARRING    6558
#define OBJ_VNUM_DWARVEN_MASK       6562
#define OBJ_VNUM_DWARVEN_SHIELD     6563
#define OBJ_VNUM_DWARVEN_BELT       6564
#define OBJ_VNUM_DWARVEN_CLOAK      6565

#define OBJ_VNUM_SHARPEN_STONE      39

#define OBJ_VNUM_PALADIN_CROSS      51550
#define OBJ_VNUM_APALADIN_CROSS     51551
#define OBJ_VNUM_MARRY_RING         51520
#define OBJ_VNUM_LION_SHIELD        51552

/* vnums for tattoos */
#define OBJ_VNUM_TATTOO_TIMIMM      51
#define OBJ_VNUM_TATTOO_DRACULA     52
#define OBJ_VNUM_TATTOO_GRAYMAGE    53
#define OBJ_VNUM_TATTOO_ASTERN      54
#define OBJ_VNUM_TATTOO_AHURAMAZDA  55
#define OBJ_VNUM_TATTOO_CRAZER      56
#define OBJ_VNUM_TATTOO_KARMAEL     57
#define OBJ_VNUM_TATTOO_PHOBOS      58
#define OBJ_VNUM_TATTOO_ODIN        59
#define OBJ_VNUM_TATTOO_CROM        60
#define OBJ_VNUM_TATTOO_NIMLOTH     61
#define OBJ_VNUM_TATTOO_SLIDER      62
#define OBJ_VNUM_TATTOO_ASEROTH     63
#define OBJ_VNUM_TATTOO_AIS     64
#define OBJ_VNUM_TATTOO_NIMNULL     65
#define OBJ_VNUM_TATTOO_ORLANGUR    66
#define OBJ_VNUM_TATTOO_MONTAARON   67
#define OBJ_VNUM_TATTOO_KEMM        68
#define OBJ_VNUM_TATTOO_KHORNE      69
#define OBJ_VNUM_TATTOO_MORTIE      18
#define OBJ_VNUM_TATTOO_BAST        75
#define OBJ_VNUM_TATTOO_STELLA      78
#define OBJ_VNUM_TATTOO_GALKA       30149
#define OBJ_VNUM_TATTOO_SAMANTA     65008
#define OBJ_VNUM_TATTOO_TRANTOR     35256

#define C_WINDOW_VNUM               15116   // window for wquests
#define C_SHAMAN_TATTOO_VNUM        15117   // "blank" shamans' tattoo
#define C_EMPTY_PAINT_VNUM          15118   // "blank" paint

/*
 * Well known room virtual numbers.
 * Defined in #ROOMS.
 */
#define ROOM_VNUM_RULER_CELL    95106
#define ROOM_VNUM_LIMBO     2
#define ROOM_VNUM_CHAT      1200
#define ROOM_VNUM_TEMPLE    3077
#define ROOM_VNUM_ALTAR     3054
#define ROOM_VNUM_SCHOOL    3700
#define ROOM_VNUM_BALANCE   4500
#define ROOM_VNUM_CIRCLE    4400
#define ROOM_VNUM_DEMISE    4201
#define ROOM_VNUM_HONOR     4300
#define ROOM_VNUM_BATTLE    541

/* RT ASCII conversions -- used so we can have letters in this file */

#define A   ((flag64_t) 1 <<  0)
#define B   ((flag64_t) 1 <<  1)
#define C   ((flag64_t) 1 <<  2)
#define D   ((flag64_t) 1 <<  3)
#define E   ((flag64_t) 1 <<  4)
#define F   ((flag64_t) 1 <<  5)
#define G   ((flag64_t) 1 <<  6)
#define H   ((flag64_t) 1 <<  7)

#define I   ((flag64_t) 1 <<  8)
#define J   ((flag64_t) 1 <<  9)
#define K   ((flag64_t) 1 << 10)
#define L   ((flag64_t) 1 << 11)
#define M   ((flag64_t) 1 << 12)
#define N   ((flag64_t) 1 << 13)
#define O   ((flag64_t) 1 << 14)
#define P   ((flag64_t) 1 << 15)

#define Q   ((flag64_t) 1 << 16)
#define R   ((flag64_t) 1 << 17)
#define S   ((flag64_t) 1 << 18)
#define T   ((flag64_t) 1 << 19)
#define U   ((flag64_t) 1 << 20)
#define V   ((flag64_t) 1 << 21)
#define W   ((flag64_t) 1 << 22)
#define X   ((flag64_t) 1 << 23)

#define Y   ((flag64_t) 1 << 24)
#define Z   ((flag64_t) 1 << 25)
#define aa  ((flag64_t) 1 << 26) /* letters doubled due to conflicts */
#define bb  ((flag64_t) 1 << 27)
#define cc  ((flag64_t) 1 << 28)
#define dd  ((flag64_t) 1 << 29)
#define ee  ((flag64_t) 1 << 30)
#define ff  ((flag64_t) 1 << 31)

#define gg  ((flag64_t) 1 << 32)
#define hh  ((flag64_t) 1 << 33)
#define ii  ((flag64_t) 1 << 34)
#define jj  ((flag64_t) 1 << 35)
#define kk  ((flag64_t) 1 << 36)
#define ll  ((flag64_t) 1 << 37)
#define mm  ((flag64_t) 1 << 38)
#define nn  ((flag64_t) 1 << 39)

#define oo  ((flag64_t) 1 << 40)
#define pp  ((flag64_t) 1 << 41)
#define qq  ((flag64_t) 1 << 42)
#define rr  ((flag64_t) 1 << 43)
#define ss  ((flag64_t) 1 << 44)
#define tt  ((flag64_t) 1 << 45)
#define uu  ((flag64_t) 1 << 46)
#define vv  ((flag64_t) 1 << 47)

#define ww  ((flag64_t) 1 << 48)
#define xx  ((flag64_t) 1 << 49)
#define yy  ((flag64_t) 1 << 50)
#define zz  ((flag64_t) 1 << 51)


/*
 *  Current version of area files
 */
#define CUR_AREA_VERSION    1.04

#endif
