/* $Id: crash.c,v 1.666 2004/09/20 10:49:48 shrike Exp $    */
/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

/*
 * crash.c -- Crash recovery functions.
 * Written for the Labyrinth, Copyright (c) 1995 James Bielman
 * All Rights Reserved
 */

#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include "merc.h"

struct crash_save_data
{
	const char * last_char_issued;
	const char * last_cmd_issued;
};

struct crash_save_data save_info;

void segv_handler( int signal )
{
	char buf[ MAX_STRING_LENGTH ];

	sprintf( buf, "CRASH:: Caught SIGSEGV; Shutting Down.." );
	log_printf ( "%s", buf );

	sprintf( buf, "CRASH:: Last command: [ %s ] %s", save_info.last_char_issued,
		save_info.last_cmd_issued );
	log_printf ( "%s", buf );

	abort( );
}

void crash_install_handlers( void )
{
	save_info.last_char_issued = NULL;
	save_info.last_cmd_issued = NULL;
//	signal( SIGSEGV, segv_handler );
}

void crash_set_last_char( const char *last_char )
{
	if( save_info.last_char_issued != NULL )
	{
		free_string( save_info.last_char_issued );
	}

	save_info.last_char_issued = str_dup( last_char );
}

void crash_set_last_cmd( const char *last_cmd )
{
	if( save_info.last_cmd_issued != NULL )
	{
		free_string( save_info.last_cmd_issued );
	}

	save_info.last_cmd_issued = str_dup( last_cmd );
}
