/*  $Id: cyborg.c,v 1.666 2004/09/20 10:49:48 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "merc.h"
#include "db/lang.h"
#include "comm/comm_act.h"
#include "quest.h"
#include "fight.h"
#include "rating.h"
#include "update.h"
#include "mob_prog.h"
#include "obj_prog.h"

#include "cyborg.h"

DECLARE_DO_FUN(do_yell             );

int     find_battery_id = 0;

void agent_net_printf(CHAR_DATA *ch, CHAR_DATA *victim, int);

static inline bool      check_yell      (CHAR_DATA *ch, CHAR_DATA *victim, bool fighting);
void                    one_hit         (CHAR_DATA *ch, CHAR_DATA *victim, int dt, int loc);
void                    set_fighting    (CHAR_DATA *ch, CHAR_DATA *victim);

/***************************************************************************/

bool recharge_one_battery(OBJ_DATA *item, int add) 
{

    int i,j,curr,count,total;
    char tmp[MAX_STRING_LENGTH];

    strnzncpy(tmp, sizeof(tmp), mlstr_val(item->short_descr,0), MAX_STRING_LENGTH);

    if (!(strstr(tmp,"battery") || strstr(tmp,"accumulator")
    || strstr(tmp,"") || strstr(tmp,""))) 
    {
        return FALSE;
    }

    if (item->value[4] + add < 0) return FALSE;
    if (item->value[4] > item->cost*100 && add > 0) return FALSE;

    curr = UMIN(item->value[4] + add, item->cost/100);
    count = UMIN(curr/100+1, 25);
    total = UMIN(item->cost/10000+1, 25);

    for (i=0; tmp[i] && i<255; i++) 
    {
        if (tmp[i]=='[') break;
    }
    if (count <= total/4) 
    {
        strcpy(tmp+i,"[{R");
    } else if (count <= total/2) 
    {
        strcpy(tmp+i,"[{Y");
    } else 
    {
        strcpy(tmp+i,"[{G");
    }
    i+=3;
    for (j=0; j<count; j++) tmp[i++]='#';
        for ( ; j<total; j++) tmp[i++]=' ';
            strcpy(tmp+i,"{x]");

    item->value[4] = curr;
    mlstr_free(item->short_descr);
    item->short_descr = mlstr_new(tmp);
    return TRUE;
}

void find_battery_reset() 
{
    find_battery_id=0;
}

OBJ_DATA *find_one_battery(CHAR_DATA *ch) 
{
    int i=0;
    OBJ_DATA *obj, *obj_next, *battery;

    battery = NULL;
    for (obj = ch->carrying; obj != NULL; obj = obj_next) 
    {
        obj_next = obj->next_content;
        if (obj->wear_loc != WEAR_NONE && recharge_one_battery(obj, 0)
        && find_battery_id == i++) 
        {
            find_battery_id++;
            battery = obj;
            return battery;
        }
    }
    return NULL;
}

/*
 * recharges battery(s) on a given char.
 * the caller should check if this char is a cyborg.
 */
bool recharge_battery(CHAR_DATA *ch, int add) 
{

    OBJ_DATA *battery;

    find_battery_reset();
    while ((battery=find_one_battery(ch))) 
    {
        if (recharge_one_battery(battery,add)) 
            return TRUE;
    }
    return FALSE;
}

/*
 * called timely from update.c
 */
//inline void cyborg_special_update(CHAR_DATA *ch) 
void cyborg_special_update(CHAR_DATA *ch) 
{
    recharge_battery(ch, 3);
}

/*
 * this skill requires you to be a cyborg
 * takes 100 energy (1 battery indicator)
 * damage is dependant on char's level, damroll and size
 * saves and size protect vs this very well
 */
DO_FUN(do_annihilate)
{
    CHAR_DATA *victim;
    int chance,dam,save,mana;
    int fighting;

    fighting = (ch->fighting != NULL);

    if (!IS_NPC(ch))
    {
        if ((chance = get_skill(ch, gsn_annihilate)) == 0)
        {
            char_act("Huh?", ch);
            return;
        }
    }
    else chance = 100;

    if (!IS_CYBORG(ch))
    {
        char_act("   .\n", ch);
        return;
    }

    mana = SKILL(gsn_annihilate)->min_mana;

    if (ch->mana < mana || !recharge_battery(ch, -100))
    {
        char_act("{R*****{x    .\n", ch);
        return;
    }

    WAIT_STATE(ch, SKILL(gsn_annihilate)->beats);

    if (argument[0] == '\0')
    {
        if ((victim = ch->fighting) == NULL)
        {
            char_act("{R*****{x ..  .", ch);
            recharge_battery(ch,100);
            return;
        }
    } else if ((victim = get_char_room(ch, argument)) == NULL)
    {
        char_act("{R*****{x  ..   .", ch);
        recharge_battery(ch,100);
        return;
    }
    if (!IS_NPC(ch) && IS_AFFECTED(ch,AFF_CHARM) && ch->master == victim)
    {
        act("    $N.", ch, NULL, victim, TO_CHAR);
        return;
    }

    if (is_safe(ch, victim))
        return;

    ch->mana -= mana;

    act_puts("{R*****{x    $N  .", 
        ch, NULL, victim, TO_CHAR, POS_FIGHTING);
    act_puts("{R*****{x $n     .", 
        ch, NULL, victim, TO_VICT, POS_FIGHTING);
    act_puts("{R*****{x $n   $N  .", 
        ch, NULL, victim, TO_NOTVICT, POS_FIGHTING);

    dam = number_range(LVL(ch)*4, LVL(ch)*7) + 20 * ch->size + 2 * ch->damroll;
    dam = 2 * dam*chance/100;

    save = 5;
    save += LVL(victim)-LVL(ch);
    save += victim->saving_throw / 4;
    if (IS_CYBORG(victim))
    {
        save += 20;
        dam /= 2;
    }

    if (IS_MECH(ch))
        save -= 50;

    save += 2 * (victim->size - ch->size);

    if (save > number_percent())
    {
        act_puts("    $N.", 
            ch, NULL, victim, TO_CHAR, POS_FIGHTING);
        act_puts("  $n   .", 
            ch, NULL, victim, TO_VICT, POS_FIGHTING);
        act_puts("$n   $N.", 
            ch, NULL, victim, TO_NOTVICT, POS_FIGHTING);
        check_improve(ch, gsn_annihilate, FALSE, 2);
        damage(ch, victim, 0, gsn_annihilate, DAM_ENERGY, FALSE);
    } else
    {
        if (save*2 < number_percent()) dam = 2*dam/3;
        if (save*2 < number_percent()) dam = 2*dam/3;
        check_improve(ch, gsn_annihilate, TRUE, 2);
        damage(ch, victim, dam, gsn_annihilate, DAM_ENERGY, TRUE);
    }

    if (ch != victim && check_yell(ch, victim, fighting))
    {
        act_yell(victim, " !     !", NULL, NULL);
        agent_net_printf(victim, ch, ANET_ATTACK);
    }
}

int fuzzy_int(int param, int percent)
{
    percent = URANGE(0, percent, 100);
    if (param < 0) 
        param = -param;
    if (number_bits(1))
        param += number_range(0, param*(100-percent)/100);
    else
        param -= number_range(0, param*(100-percent)/100);
    return param;
}

void print_stats(BUFFER *output,int stat,int chance,const char *string)
{
    int i, fuzzy;
    static const char analyse_colors[] = 
    {'r','R','Y','G','B','M','W','W','W','W','W'};

    fuzzy = URANGE(3, fuzzy_int(stat,chance), 50);

    buf_printf(output, "%s:", string);
    if (chance > 65) 
    {
        for (i = 0; i < fuzzy; i++) 
        {
            if (!(i%5)) 
                buf_printf(output, "{%c", analyse_colors[i/5]);
            buf_printf(output, "#");
        }
    }
    else
        buf_printf(output, " ???");
    buf_printf(output, "{x\n");
}


DO_FUN(do_analyse)
{
    int chance, mana;
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    BUFFER *output;
    int i;
    char bufr[MAX_STRING_LENGTH];
    char bufv[MAX_STRING_LENGTH];

    if ((chance = get_skill(ch, gsn_analyse)) == 0)
    {
        char_act("Huh?", ch);
        return;
    }

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Analyse whom?", ch);
        return;
    } else if ((victim = get_char_room(ch, arg)) == NULL) 
    {
        char_act("{R*****{x   .", ch);
        return;
    }

    mana = SKILL(gsn_analyse)->min_mana;

    if (ch->mana < mana)
    {
        char_act("{R*****{x    .", ch);
        return;
    }

    WAIT_STATE(ch, SKILL(gsn_analyse)->beats);

    chance += (LVL(ch) - LVL(victim)) / 2;
    chance += (ch->size - 6) * 3;
//    chance -= number_percent()/2;
    chance += number_percent()/2;

    if (chance > 55)
    {
        ch->mana -= mana;

        output = buf_new(-1);

        buf_printf(output, "{R*****{x Analysing...\n\n");
        act_puts("{R*****{x  $n  .", 
            ch, NULL, victim, TO_VICT, POS_FIGHTING);
        act_puts("{R*****{x  $n  $N.", 
            ch, NULL, victim, TO_NOTVICT, POS_FIGHTING);

        buf_printf(output, "Name: %s\n", victim->name);

        if (chance > 90)
            buf_printf(output, "Level %d", fuzzy_int(victim->level,chance));
        else
            buf_printf(output, "Level ???");
        
        if (chance > 95)
            buf_printf(output, "+%d\n",fuzzy_int(victim->aff_level,chance));
        else
            buf_printf(output, "+??\n");

        if (IS_NPC(victim))
            buf_printf(output, "Align %d\n", victim->alignment);
        else
        {
            buf_printf(output, "Align %s-%s\n",
                flag_string(ethos_table, victim->ethos),
                    IS_GOOD(victim)    ?    "good" :
                    IS_NEUTRAL(victim) ?    "neutral" :
                    IS_EVIL(victim)    ?    "evil" :
                                            "unknown");
        }

        print_stats(output, get_curr_stat(victim, STAT_STR), chance, "Str ");
        print_stats(output, get_curr_stat(victim, STAT_INT), chance, "Int ");
        print_stats(output, get_curr_stat(victim, STAT_WIS), chance, "Wis ");
        print_stats(output, get_curr_stat(victim, STAT_DEX), chance, "Dex ");
        print_stats(output, get_curr_stat(victim, STAT_CON), chance, "Con ");
        print_stats(output, get_curr_stat(victim, STAT_CHA), chance, "Cha ");
        print_stats(output, get_curr_stat(victim, STAT_LCK), chance, "Lck ");
        print_stats(output, victim->size, chance, "Size");

        if (chance > 62)
        {
            buf_printf(output,"Armor: pierce: {m%d{z  bash: {m%d{z slash: {m%d{z  magic: {m%d{z\n",
            fuzzy_int(GET_AC(victim, AC_PIERCE), chance),
            fuzzy_int(GET_AC(victim, AC_BASH), chance),
            fuzzy_int(GET_AC(victim, AC_SLASH), chance),
            fuzzy_int(GET_AC(victim, AC_EXOTIC), chance));
        } else
        {
            buf_printf(output,"Armor: pierce: {m???{z  bash: {m???{z slash: {m???{z  magic: {m???{z\n");
        }

        if (chance > 75)
        {
            buf_printf(output, "Damroll : {G%d{z, Hitroll : {G%d{z,",
                fuzzy_int(GET_DAMROLL(victim), chance),
                fuzzy_int(GET_HITROLL(victim), chance));
        } else
        {
            buf_printf(output, "Damroll : {G???{z, Hitroll : {G???{z,");
        }

        if (chance > 80)
            buf_printf(output, " saves versus spell's {G%d{z\n", fuzzy_int(victim->saving_throw, chance));
        else
            buf_printf(output, " saves versus spell's {G???{z\n");

        if (chance > 85)
        {
            buf_printf(output, "Hp: {R%d/%d{z, Mana: {B%d/%d{z, Move: {g%d/%d{z\n",
                fuzzy_int(victim->hit, chance),
                fuzzy_int(victim->max_hit, chance),
                fuzzy_int(victim->mana, chance),
                fuzzy_int(victim->max_mana, chance),
                fuzzy_int(victim->move, chance),
                fuzzy_int(victim->max_move, chance));
        } else
            buf_printf(output, "Hp : {R????{z, Mana : {B????{z, Move : {g????{z\n");

    bufr[0] = bufv[0] = 0;

        if (chance > 90 && chance < 95)
        {
            for (i = 1; i < MAX_DAM; i++)
            {
                if (victim->resists[i] > 0)
                    strnzcat(bufr, MAX_STRING_LENGTH, flag_string(dam_flags, i));
                else if (victim->resists[i] < 0)
                    strnzcat(bufv, MAX_STRING_LENGTH, flag_string(dam_flags, i));
            }
        }

        if (chance > 94)
        {
            for (i = 1; i < MAX_DAM; i++)
                if (victim->resists[i])
                {
                    buf_printf(output, "Resistance to: %-16.16s: %4d%%\n",
                       flag_string(dam_flags, i), victim->resists[i]);
                }
        } else
        {
            buf_printf(output, "Res: %s\n", bufr);
            buf_printf(output, "Vul: %s\n", bufv);
        }

        if (chance < 100)
        {
            buf_printf(output, " :  %d%%\n",
                    UMIN(number_fuzzy(chance), 100));
        } else
        {
            buf_printf(output, " : %d%%\n", chance);
        }

        page_to_char(buf_string(output), ch);
        buf_free(output);
        check_improve(ch, gsn_analyse, TRUE, 2);
        return;
    }

    ch->mana -= mana / 2;
    check_improve(ch, gsn_analyse, FALSE, 2);
    char_act("{R*****{x Analyse failed.", ch);
}

DO_FUN(do_knowmob)
{
    int chance, mana;
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    BUFFER *output;
    int i;
    char bufr[MAX_STRING_LENGTH];
    char bufv[MAX_STRING_LENGTH];

    if ((chance = get_skill(ch, gsn_knowmob)) == 0)
    {
        char_act("Huh?", ch);
        return;
    }

    one_argument(argument, arg, sizeof(arg));

    if (arg[0] == '\0')
    {
        char_act("Know whom?", ch);
        return;
    } else if ((victim = get_char_room(ch, arg)) == NULL) 
    {
        char_act("  .", ch);
        return;
    }

    mana = SKILL(gsn_knowmob)->min_mana;

    if (ch->mana < mana)
    {
        char_act("   .", ch);
        return;
    }

    if (!IS_NPC(victim))
    {
        char_act("     .", ch);
        return;
    }

    WAIT_STATE(ch, SKILL(gsn_knowmob)->beats);

    chance += (LVL(ch) - LVL(victim)) / 2;
    chance += (ch->size - 6) * 3;
//    chance -= number_percent()/2;
    chance += number_percent()/2;

    if (chance > 55)
    {
        ch->mana -= mana;

        output = buf_new(-1);

        buf_printf(output, "  ...\n\n");
        act_puts("$n       -.", 
            ch, NULL, victim, TO_VICT, POS_FIGHTING);
        act_puts("$n    $N   -.", 
            ch, NULL, victim, TO_NOTVICT, POS_FIGHTING);

        buf_printf(output, "Name: %s\n", victim->name);

        if (chance > 90)
            buf_printf(output, "Level %d", fuzzy_int(victim->level,chance));
        else
            buf_printf(output, "Level ???");
        
        if (chance > 95)
            buf_printf(output, "+%d\n",fuzzy_int(victim->aff_level,chance));
        else
            buf_printf(output, "+??\n");

        if (IS_NPC(victim))
            buf_printf(output, "Align %d\n", victim->alignment);
        else
        {
            buf_printf(output, "Align %s-%s\n",
                flag_string(ethos_table, victim->ethos),
                    IS_GOOD(victim)    ?    "good" :
                    IS_NEUTRAL(victim) ?    "neutral" :
                    IS_EVIL(victim)    ?    "evil" :
                                            "unknown");
        }

        print_stats(output, get_curr_stat(victim, STAT_STR), chance, "Str ");
        print_stats(output, get_curr_stat(victim, STAT_INT), chance, "Int ");
        print_stats(output, get_curr_stat(victim, STAT_WIS), chance, "Wis ");
        print_stats(output, get_curr_stat(victim, STAT_DEX), chance, "Dex ");
        print_stats(output, get_curr_stat(victim, STAT_CON), chance, "Con ");
        print_stats(output, get_curr_stat(victim, STAT_CHA), chance, "Cha ");
        print_stats(output, get_curr_stat(victim, STAT_LCK), chance, "Lck ");
        print_stats(output, victim->size, chance, "Size");

        if (chance > 62)
        {
            buf_printf(output,"Armor: pierce: {m%d{z  bash: {m%d{z slash: {m%d{z  magic: {m%d{z\n",
            fuzzy_int(GET_AC(victim, AC_PIERCE), chance),
            fuzzy_int(GET_AC(victim, AC_BASH), chance),
            fuzzy_int(GET_AC(victim, AC_SLASH), chance),
            fuzzy_int(GET_AC(victim, AC_EXOTIC), chance));
        } else
        {
            buf_printf(output,"Armor: pierce: {m???{z  bash: {m???{z slash: {m???{z  magic: {m???{z\n");
        }

        if (chance > 75)
        {
            buf_printf(output, "Damroll : {G%d{z, Hitroll : {G%d{z,",
                fuzzy_int(GET_DAMROLL(victim), chance),
                fuzzy_int(GET_HITROLL(victim), chance));
        } else
        {
            buf_printf(output, "Damroll : {G???{z, Hitroll : {G???{z,");
        }

        if (chance > 80)
            buf_printf(output, " saves versus spell's {G%d{z\n", fuzzy_int(victim->saving_throw, chance));
        else
            buf_printf(output, " saves versus spell's {G???{z\n");

        if (chance > 85)
        {
            buf_printf(output, "Hp: {R%d/%d{z, Mana: {B%d/%d{z, Move: {g%d/%d{z\n",
                fuzzy_int(victim->hit, chance),
                fuzzy_int(victim->max_hit, chance),
                fuzzy_int(victim->mana, chance),
                fuzzy_int(victim->max_mana, chance),
                fuzzy_int(victim->move, chance),
                fuzzy_int(victim->max_move, chance));
        } else
            buf_printf(output, "Hp : {R????{z, Mana : {B????{z, Move : {g????{z\n");

    bufr[0] = bufv[0] = 0;

        if (chance > 90 && chance < 95)
        {
            for (i = 1; i < MAX_DAM; i++)
            {
                if (victim->resists[i] > 0)
                    strnzcat(bufr, MAX_STRING_LENGTH, flag_string(dam_flags, i));
                else if (victim->resists[i] < 0)
                    strnzcat(bufv, MAX_STRING_LENGTH, flag_string(dam_flags, i));
            }
        }

        if (chance > 94)
        {
            for (i = 1; i < MAX_DAM; i++)
                if (victim->resists[i])
                {
                    buf_printf(output, "Resistance to: %-16.16s: %4d%%\n",
                       flag_string(dam_flags, i), victim->resists[i]);
                }
        } else
        {
            buf_printf(output, "Res: %s\n", bufr);
            buf_printf(output, "Vul: %s\n", bufv);
        }

        if (chance > 100)
        {
            if (victim->immunes)
                buf_printf(output, "Immune to: %s\n",
                       flag_string(imm_flags, victim->immunes));

            if (victim->affected_by)
                buf_printf(output, "Affected by %s\n",
                       flag_string(affect_flags, victim->affected_by));
        }

        if (chance < 100)
        {
            buf_printf(output, " :  %d%%\n",
                    UMIN(number_fuzzy(chance), 100));
        } else
        {
            buf_printf(output, " : %d%%\n", chance);
        }

        page_to_char(buf_string(output), ch);
        buf_free(output);
        check_improve(ch, gsn_knowmob, TRUE, 2);
        return;
    }

    ch->mana -= mana / 2;
    check_improve(ch, gsn_knowmob, FALSE, 2);
    char_act("    .", ch);
}

/*
 * radiation stuff
 */
void radiation_effect(void *vo, int level, int target)
{
    int sn;
    if ((sn=sn_lookup("radiation")) == -1) 
    {
        bug("radiation(): sn_radiation = %d", sn);
        return;
    }

    if (target == TARGET_ROOM)
    {
        ROOM_INDEX_DATA *room = (ROOM_INDEX_DATA *) vo;
        OBJ_DATA *obj, *obj_next;
        AFFECT_DATA af;

        for (obj = room->contents; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            radiation_effect(obj,level,TARGET_OBJ);
        }

        if (IS_ROOM_AFFECTED(room, RAFF_RADIATION)) 
            return;

        af.where     = TO_ROOM_AFFECTS;
        af.type      = sn;
        af.level     = level;
        af.duration  = number_range(af.level/2, af.level);
        af.location  = APPLY_NONE;
        af.modifier  = 0;
        af.bitvector = RAFF_RADIATION;
        affect_join_room(room, &af);

        return;
    }

    if (target == TARGET_CHAR) 
    {

        CHAR_DATA *victim = (CHAR_DATA *) vo;
        OBJ_DATA *obj, *obj_next;
        AFFECT_DATA af;

        for (obj = victim->carrying; obj != NULL; obj = obj_next)
        {
            obj_next = obj->next_content;
            if (!saves_spell(level, victim, DAM_RADIATION))
                radiation_effect(obj,level,TARGET_OBJ);
        }

        if (saves_spell(level, victim, DAM_RADIATION)) 
            return;
        if (number_bits(1)==0) 
            return;

        if (!is_affected(victim, gsn_radiation)) 
        {
            char_act("{y  {Y {y {Y {y...{x", 
                victim);
            act("$n {y {Y {y {Y {y...{x",
                victim, NULL, NULL, TO_ROOM);
        } else 
        {
            switch (number_bits(2)) 
            {
        case 0: char_act("{y {Y {y {Y {y...{x", victim);
            break;
        case 1: char_act("{y {Y{y {Y {y {Y{y...{x", victim);
            break;
        case 2: char_act("{y {Y {y {Y {y...{x", victim);
            break;
        case 3: char_act("{y {Y {y {Y{y {Y...{x", victim);
            break;
            };
            switch (number_bits(2)) 
            {
        case 0: act("$n {y{Y {y {Y {y...{x",victim,NULL,NULL,TO_ROOM);
            break;
        case 1: act("$n {y{Y {y {Y {y...{x",victim,NULL,NULL,TO_ROOM);
            break;
        case 2: act("$n {Y {y {Y {y{Y...{x",victim,NULL,NULL,TO_ROOM);
            break;
        case 3: act("$n {y {Y {y {Y{y...{x",victim,NULL,NULL,TO_ROOM);
            break;
            };
        }

        af.where        = TO_CHAR;
        af.type         = sn;
        af.level        = number_range(level/2, level);
        af.duration     = number_range(level/12, level/9);
        af.location     = APPLY_HIT;
        af.modifier     = -af.level;
        af.bitvector    = 0;
        affect_join(victim, &af);

        return;
    }

    if (target == TARGET_OBJ) 
    {

        OBJ_DATA *obj = (OBJ_DATA *) vo;
        AFFECT_DATA af;
        char tmp[MAX_STRING_LENGTH];
        char tmp2[MAX_STRING_LENGTH];
        int i;
        int cur_color;
        char *c;

        if (number_percent() > 8) 
            return;
        if (IS_OBJ_STAT(obj, ITEM_RADIATION)) 
            return;

        if ((IS_OBJ_STAT(obj, ITEM_QUEST) || IS_WEAPON_STAT(obj, WEAPON_KATANA)
        || obj->pIndexData->limit > 0) && number_percent() > 20) 
            return;

        af.where        = TO_OBJECT;
        af.type         = sn;
        af.level        = number_range(level/2, level);
        af.duration     = number_range(level/2, level);
        af.location     = APPLY_HIT;
        af.modifier     = - number_range(level/8, level/4);
        af.bitvector    = ITEM_RADIATION;
        affect_to_obj(obj,&af);


        cur_color = 0;
        strnzncpy(tmp, sizeof(tmp), mlstr_val(obj->short_descr,0), MAX_STRING_LENGTH);
        c = tmp2;
        strnzcpy(c, sizeof(c),"{y");
        c += 2;
        for (i=0; tmp[i]; i++) 
        {
            if (tmp[i] == '{') 
            {
                i++;
                continue;
            }
            *c++ = tmp[i];
            if (number_bits(2)==1) 
            {
                if (cur_color) 
                    strnzcpy(c, sizeof(c),"{y");
                else 
                    strnzcpy(c, sizeof(c),"{Y");
            cur_color ^= 1;
            c += 2;
            }
        }
        strnzcpy(c, sizeof(c),"{x");
        mlstr_free(obj->short_descr);
        obj->short_descr = mlstr_new(tmp2);

        cur_color = 0;
        strnzncpy(tmp, sizeof(tmp), mlstr_val(obj->description,0), MAX_STRING_LENGTH);
        c = tmp2;
        strnzcpy(c, sizeof(c),"{y");
        c += 2;
        for (i=0; tmp[i]; i++) 
        {
            if (tmp[i] == '{') 
            {
                i++;
                continue;
            }
            *c++ = tmp[i];
            if (number_bits(2)==1) 
            {
                if (cur_color) 
                    strnzcpy(c, sizeof(c),"{y");
                else 
                    strnzcpy(c, sizeof(c),"{Y");
                cur_color ^= 1;
                c += 2;
            }
        }
        strnzcpy(c, sizeof(c),"{x");
        mlstr_free(obj->description);
        obj->description = mlstr_new(tmp2);
    }

}

DO_FUN(do_machinegun)
{
    CHAR_DATA *vch, *vch_next;
    int dam, chance;

    if (!ch->fighting) return;

    act("$n      .",
        ch, NULL, NULL, TO_ROOM);

    for (vch = ch->in_room->people; vch != NULL; vch = vch_next) 
    {
        vch_next = vch->next_in_room;

        if (vch == ch->fighting || vch->fighting == ch || (ch->master 
        && (vch == ch->master->fighting || vch->fighting == ch->master))) 
        {
            chance = 75 + LVL(ch) - LVL(vch);
            chance += 3 * (get_curr_stat(ch,STAT_DEX) 
                - get_curr_stat(vch,STAT_DEX));
            dam = 2*LVL(ch) + ch->damroll + dice(3,30);

            if (chance > number_percent()) 
                damage(ch, vch, dam, gsn_machinegun, DAM_PIERCE, TRUE);
            else
                damage(ch, vch, 0, gsn_machinegun, DAM_PIERCE, DAMF_SHOW | FALSE);
        }
    }
}

DO_FUN(do_flamethrower)
{
    CHAR_DATA *vch, *vch_next;
    int dam, chance;

    if (!ch->fighting) return;

    act("$n         {R !{x",
        ch, NULL, NULL, TO_ROOM);

    for (vch = ch->in_room->people; vch != NULL; vch = vch_next) 
    {
        vch_next = vch->next_in_room;

        if (vch == ch->fighting || vch->fighting == ch || (ch->master
        && (vch == ch->master->fighting || vch->fighting == ch->master))) 
        {
            chance = 65 + LVL(ch) - LVL(vch);
            chance += 3 * (get_curr_stat(ch,STAT_DEX)
                - get_curr_stat(vch,STAT_DEX));
            dam = number_range(2*LVL(ch) + 2*ch->damroll, 
                3*LVL(ch) + 3*ch->damroll) + dice(3,30);

            if (chance > number_percent()) 
            {
                if (!saves_spell(LVL(ch), vch, DAM_FIRE)) 
                    fire_effect(vch,LVL(ch),dam/2,TARGET_CHAR);
                damage(ch, vch, dam, gsn_flamethrower, DAM_FIRE, TRUE);
            } else
                damage(ch, vch, 0, gsn_flamethrower, DAM_FIRE, DAMF_SHOW | FALSE);
        }
    }
}

DO_FUN(do_nuclear_strike)
{
}

bool check_yell(CHAR_DATA *ch, CHAR_DATA *victim, bool fighting)
{
    return (!IS_NPC(ch) && !IS_NPC(victim) && victim->position > POS_STUNNED && !fighting);
}

