/*  $Id: alias.c,v 1.666 2004/09/20 10:50:18 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <stdio.h>

#include "merc.h"

varr aliases = { sizeof(alias_t), 8 };

alias_t *alias_new()
{
	alias_t *alias;
	alias = varr_enew(&aliases);
	return alias;
}

void alias_free(alias_t *alias)
{
	free_string(alias->name);
	free_string(alias->prefix);
	free_string(alias->suffix);
	alias->command = NULL;
}

alias_t *alias_lookup(const char *name,
			int (*cmpfun)(const char *s1, const char *s2))
{
	int i;

	for (i = 0; i < aliases.nused; i++) {
		alias_t *alias = VARR_GET(&aliases, i);
		if (!cmpfun(name, alias->name))
			return alias;
	}

	return NULL;
}

// skill aliases
varr skill_aliases = { sizeof(skill_alias_t), 8 };

skill_alias_t *skill_alias_new()
{
	skill_alias_t *alias;
	alias = varr_enew(&skill_aliases);
	return alias;
}

void skill_alias_free(skill_alias_t *alias)
{
	free_string(alias->name);
	free_string(alias->prefix);
	free_string(alias->suffix);
	alias->skill = NULL;
}

skill_alias_t *skill_alias_lookup(const char *name,
			int (*cmpfun)(const char *s1, const char *s2))
{
	int i;

	for (i = 0; i < skill_aliases.nused; i++) {
		skill_alias_t *alias = VARR_GET(&skill_aliases, i);
		if (!cmpfun(name, alias->name))
			return alias;
	}

	return NULL;
}

// insert skill name instead of alias
void substitute_skill_alias(const char *argument, char *buf, size_t len)
{
    skill_alias_t *alias;
    int i;

    strnzcpy(buf, len, argument);
    for (i = 0; i < skill_aliases.nused; i++)
    {
        alias = SKILL_ALIAS(i);

        if (str_prefix(argument, alias->name))
            continue;

        if (alias->skill == NULL)
            break;

        strnzcpy(buf, len, alias->skill->name);
        break;
    }
}

// insert first suitable alias instead skill name
// used in do_practice etc to translate it all
void antisubstitute_skill_alias(const char *argument, char *buf, size_t len)
{
    skill_alias_t *alias;
    int i;

    strnzcpy(buf, len, argument);
    for (i = 0; i < skill_aliases.nused; i++)
    {
        alias = SKILL_ALIAS(i);

        if (alias->skill == NULL)
            break;

        if (str_cmp(alias->skill->name, argument))
            continue;

        strnzcpy(buf, len, alias->name);
        break;
    }
}
