/*  $Id: alias.h,v 1.666 2004/09/20 10:50:18 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#ifndef _ALIAS_H_
#define _ALIAS_H_

/*
 * Structure for an alias for a command
 */
struct alias_t
{
    const char  * name;
    command_t   * command;
    const char  * prefix;
    const char  * suffix;
};


#define ALIAS(i)    ((alias_t *) VARR_GET(&aliases, i))

extern varr aliases;

alias_t *   alias_new();
void        alias_free(alias_t *alias);
alias_t *   alias_lookup(const char *name, int (*cmpfun)(const char *s1, const char *s2));

// structure for an alias for a spell
void substitute_skill_alias(const char *argument, char *buf, size_t len);
void antisubstitute_skill_alias(const char *argument, char *buf, size_t len);
struct skill_alias_t
{
    const char  * name;
    skill_t     * skill;
    const char  * prefix;
    const char  * suffix;
};


#define SKILL_ALIAS(i) ((skill_alias_t *) VARR_GET(&skill_aliases, i))

extern varr skill_aliases;

skill_alias_t *   skill_alias_new();
void        skill_alias_free(skill_alias_t *alias);
skill_alias_t *   skill_alias_lookup(const char *name, int (*cmpfun)(const char *s1, const char *s2));

#endif
