/*  $Id: cmd.c,v 1.666 2004/09/20 10:50:18 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <stdio.h>

#include "merc.h"

varr commands = { sizeof(command_t), 8 };

command_t *command_new()
{
	command_t *command;
	command = varr_enew(&commands);
	return command;
}

void command_free(command_t *command)
{
	free_string(command->name);
}

command_t *command_lookup(const char *name,
			int (*cmpfun)(const char *s1, const char *s2))
{
	int i;

	for (i = 0; i < commands.nused; i++) {
		command_t *command = VARR_GET(&commands, i);
		if (!cmpfun(name, command->name))
			return command;
	}

	return NULL;
}
