/* $Id: db_alias.c,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <limits.h>
#include <stdio.h>
#include <ctype.h>

#include "typedef.h"
#include "const.h"
#include "varr.h"
#include "alias.h"
#include "cmd.h"
#include "db.h"
#include "str.h"
#include "tables.h"
#include "skills.h"

DECLARE_DBLOAD_FUN(load_alias);
DECLARE_DBLOAD_FUN(load_skill_alias);

DBFUN db_load_aliases[] =
{
    { "ALIAS",      load_alias        },
    { "SKILLALIAS", load_skill_alias  },
    { NULL }
};

DBLOAD_FUN(load_alias)
{
    alias_t *alias = alias_new();

    for (;;)
    {
        char *word = feof(fp) ? "End" : fread_word(fp);
        bool fMatch = FALSE;

        switch (UPPER(word[0]))
        {
        case 'C':
            KEY("Command", alias->command, command_lookup(fread_string(fp), str_cmp));
            break;
        case 'E':
            if (!str_cmp(word, "End"))
            {
                if (IS_NULLSTR(alias->name))
                {
                    db_error("load_alias", "alias name not defined");
                    alias_free(alias);
                    aliases.nused--;
                }
                if (alias->command == NULL)
                {
                    db_error("load_alias", "alias command not defined");
                    alias_free(alias);
                    aliases.nused--;
                }
                return;
            }
            break;
        case 'N':
            SKEY("Name", alias->name);
            break;
        case 'P':
            SKEY("Prefix", alias->prefix);
            break;
        case 'S':
            SKEY("Suffix", alias->suffix);
            break;
        }

        if (!fMatch)
            db_error("load_alias", "%s: Unknown keyword", word);
    }
}

DBLOAD_FUN(load_skill_alias)
{
    skill_alias_t *alias = skill_alias_new();

    for (;;)
    {
        char *word = feof(fp) ? "End" : fread_word(fp);
        bool fMatch = FALSE;
        const char * skill_name = NULL;

        switch (UPPER(word[0]))
        {
        case 'E':
            if (!str_cmp(word, "End"))
            {
                if (IS_NULLSTR(alias->name))
                {
                    db_error("load_alias", "alias name not defined");
                    skill_alias_free(alias);
                    skill_aliases.nused--;
                }
                if (alias->skill == NULL)
                {
                    db_error("load_alias", "alias skill not defined");
                    skill_alias_free(alias);
                    aliases.nused--;
                }
                free_string(skill_name);
                return;
            }
            break;
        case 'N':
            SKEY("Name", alias->name);
            break;
        case 'S':
            if (!str_cmp(word, "Skill"))
            {
                skill_name = fread_string(fp);
                alias->skill = skill_lookup(sn_lookup(skill_name));
                fMatch = TRUE;
            }
            break;
        }

        if (!fMatch)
            db_error("load_skill_alias", "%s: Unknown keyword", word);
    }
}
