/* $Id: db_artefact.c,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <stdio.h>

#include "merc.h"
#include "db.h"
#include "artefacts.h"

DECLARE_DBLOAD_FUN(load_artefact);

DBFUN db_load_artefact[] =
{
	{ "ARTEFACT",   load_artefact},
	{ NULL}
};

DBLOAD_FUN(load_artefact)
{
	artefact_t * artefact;

	artefact = artefact_new();
    
	for (;;)
	{
		char *word = feof(fp) ? "End" : fread_word(fp);
		bool fMatch = FALSE;

		switch (UPPER(word[0]))
		{
		
		case 'E':
			if (!str_cmp(word, "End"))
			{
				if (artefact->vnum < 0)) //TODO: change vnum  validate check
				{
					db_error("load_artefact",
						 "artefact vnum not defined");
					artefact_free(artefact);
					artefacts.nused--;
				}
				return;
			}
			break;
                case 'F':
                        KEY("Forger", artefact->forger,             fread_number(fp));
                        break;
				case 'I':
                        KEY("InfoFee", artefact->info_fee,          fread_number(fp));
                        break;
                case 'C':
				        KEY("Chance", artefact->chance,             fread_number(fp));
                        KEY("CharLevel", artefact->char_level,      fread_number(fp));
						KEY("CreateFee", artefact->create_fee,      fread_number(fp));
                        break;
				case 'M':
                        KEY("MobLevel", artefact->mob_level,        fread_number(fp));
                        break;
				case 'V':
                        KEY("Vnum", artefact->vnum,                 fread_number(fp));
                        break;
				case 'P':
                        KEY("PartOf", artefact->part_of,            fread_number(fp));
						KEY("PartsCount", artefact->parts_count,    fread_number(fp));
						
						if (!str_cmp(word, "Parts"))
						{
							mobject_t *mobject;

							aparts = varr_enew(&artefact->parts);
							aparts->vnum           = fread_number(fp);
							aparts->neccessary     = fread_number(fp);
			                aparts->chance_reduct  = fread_number(fp);
							fMatch = TRUE;
						}
                        break;
                }

		if (!fMatch)
			db_error("load_artefact", "%s: Unknown keyword", word);
	}
}               
