/* $Id: db_class.c,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/
/************************************************************************************
 *     ANATOLIA 2.1 is copyright 1996-1997 Serdar BULUT, Ibrahim CANPUNAR           *
 *     ANATOLIA has been brought to you by ANATOLIA consortium                      *
 *       Serdar BULUT {Chronos}         bulut@rorqual.cc.metu.edu.tr                *
 *       Ibrahim Canpunar  {Asena}      canpunar@rorqual.cc.metu.edu.tr             *
 *       Murat BICER  {KIO}             mbicer@rorqual.cc.metu.edu.tr               *
 *       D.Baris ACAR {Powerman}        dbacar@rorqual.cc.metu.edu.tr               *
 *     By using this code, you have agreed to follow the terms of the               *
 *     ANATOLIA license, in the file Anatolia/anatolia.licence                      *
 ***********************************************************************************/

/************************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,                 *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.            *
 *                                                                                  *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael                   *
 *  Chastain, Michael Quan, and Mitchell Tse.                                       *
 *                                                                                  *
 *  In order to use any part of this Merc Diku Mud, you must comply with            *
 *  both the original Diku license in 'license.doc' as well the Merc                *
 *  license in 'license.txt'.  In particular, you may not remove either of          *
 *  these copyright notices.                                                        *
 *                                                                                  *
 *  Much time and thought has gone into this software and you are                   *
 *  benefitting.  We hope that you share your changes too.  What goes               *
 *  around, comes around.                                                           *
 ************************************************************************************/

/************************************************************************************
*       ROM 2.4 is copyright 1993-1995 Russ Taylor                                  *
*       ROM has been brought to you by the ROM consortium                           *
*           Russ Taylor (rtaylor@pacinfo.com)                                       *
*           Gabrielle Taylor (gtaylor@pacinfo.com)                                  *
*           Brian Moore (rom@rom.efn.org)                                           *
*       By using this code, you have agreed to follow the terms of the              *
*       ROM license, in the file Rom24/doc/rom.license                              *
*************************************************************************************/

/************************************************************************************
 * Copyright (c) 1998 fjoe <fjoe@iclub.nsu.ru>                                      *
 * All rights reserved.                                                             *
 *                                                                                  *
 * Redistribution and use in source and binary forms, with or without               *
 * modification, are permitted provided that the following conditions               *
 * are met:                                                                         *
 * 1. Redistributions of source code must retain the above copyright                *
 *    notice, this list of conditions and the following disclaimer.                 *
 * 2. Redistributions in binary form must reproduce the above copyright             *
 *    notice, this list of conditions and the following disclaimer in the           *
 *    documentation and/or other materials provided with the distribution.          *
 *                                                                                  *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND           *
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE            *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE       *
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE          *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS          *
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)            *
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT       *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY        *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF           *
 * SUCH DAMAGE.                                                                     *
 ************************************************************************************/
 
#include <stdio.h>
#include <string.h>

#include "merc.h"
#include "db.h"

DECLARE_DBLOAD_FUN(load_class);
DECLARE_DBLOAD_FUN(load_pose);

DBFUN db_load_classes[] =
{
        { "CLASS",      load_class      },
        { "POSE",       load_pose       },
        { NULL }
};

static class_t *class_curr;

DBINIT_FUN(init_class)
{
        class_curr = NULL;
}

DBLOAD_FUN(load_class)
{
        int     i;

        class_curr = class_new();
        class_curr->file_name = get_filename(filename);
        class_curr->guild = varr_new(sizeof(int), 4);

        for (i = 0; i < MAX_LEVEL; i++)
                class_curr->titles[i][0] = class_curr->titles[i][1] = str_empty;

    for (i = 0; i < MAX_WEAR; i++)
        class_curr->wear_loc[i] = 1;
 
        for (;;) {
                char *word = feof(fp) ? "End" : fread_word(fp);
                bool fMatch = FALSE;

                switch(UPPER(word[0])) 
                {
                case 'A':
                        KEY("AddExp", class_curr->points, fread_number(fp));
                        break;

                case 'D':
                        KEY("Dodge", class_curr->dodge, fread_number(fp));
                        break;
                
                case 'E':
                        if (!str_cmp(word, "End")) 
                        {
                                if (IS_NULLSTR(class_curr->name)) 
                                {
                                        db_error("load_class", 
                                                 "class name undefined");
                                        class_free(class_curr);
                                        classes.nused--;
                                }
                                varr_qsort(&class_curr->skills, cmpint);
                                return;
                        }

                case 'F':
                        KEY("Flags", class_curr->flags,  fread_fstring(class_flags, fp));
                        break;

                case 'G':
                        if (!str_cmp(word, "GuildRoom")) 
                        {
                                int vnum = fread_number(fp);
                                int *pvnum = varr_enew(class_curr->guild);
                                *pvnum = vnum;
                                fMatch = TRUE;
                        }
                        break;

                case 'H':
                        KEY("HPRate", class_curr->hp_rate, fread_number(fp));
                        break;

                case 'M':
                        KEY("ManaRate", class_curr->mana_rate, fread_number(fp));
                        break;

                case 'N':
                        SKEY("Name", class_curr->name);
                        break;

                case 'R':
                        KEY("RestrictAlign", class_curr->restrict_align, fread_fstring(ralign_names, fp));
                        KEY("RestrictSex", class_curr->restrict_sex,     fread_fstring(restrict_sex_table, fp));
                        KEY("RestrictEthos", class_curr->restrict_ethos, fread_fstring(ethos_table, fp));
                        break;

                case 'S':
                        KEY("SkillAdept", class_curr->skill_adept,  fread_number(fp));
                        KEY("SchoolWeapon", class_curr->weapon,     fread_number(fp));
                        if (!str_cmp(word, "ShortName")) 
                        {
                                const char *p = fread_string(fp);
                                strnzcpy(class_curr->who_name, sizeof(class_curr->who_name), p);
                                free_string(p);
                                fMatch = TRUE;
                        }
                        if (!str_cmp(word, "Skill")) 
                        {
                                class_skill_t *class_skill;

                                class_skill = varr_enew(&class_curr->skills);
                                class_skill->sn = sn_lookup(fread_word(fp));
                                class_skill->level = fread_number(fp);
                                class_skill->rating = fread_number(fp);
                                class_skill->max_percent = fread_number(fp);
                                fMatch = TRUE;
                        }
                        if (!str_cmp(word, "StatMod")) 
                        {
                                for (i = 0; i < MAX_STATS; i++)
                                        class_curr->stats[i] = fread_number(fp);
                                fMatch = TRUE;
                        }
                        break;

                case 'T':
                        KEY("Thac0_00", class_curr->thac0_00, fread_number(fp));
                        KEY("Thac0_32", class_curr->thac0_32, fread_number(fp));
                        if (!str_cmp(word, "Title")) 
                        {
                                int level;
                                int sex;

                                level = fread_number(fp);
                                if (level < 0 || level > MAX_LEVEL-1)
                                        db_error("load_class",
                                                 "invalid level %d", level);
                                sex = fread_fword(sex_table, fp);
                                if (sex == SEX_MALE)
                                        class_curr->titles[level][0] = fread_string(fp);
                                else if (sex == SEX_FEMALE)
                                        class_curr->titles[level][1] = fread_string(fp);
                                else
                                {
                                        fread_string(fp);
//                                      db_error("load_class", "invalid sex");
                                }
                                fMatch = TRUE;
                        }
                        break;

                case 'W':
                        if (!str_cmp(word, "WearLoc")) 
                        {
                            for (i = 0; i < MAX_WEAR; i++)
                                class_curr->wear_loc[i] = fread_number(fp);
                            fMatch = TRUE;
                        }
                        break;
                }

                if (!fMatch)
                        db_error("load_class", "%s: Unknown keyword", word);
        }
}

DBLOAD_FUN(load_pose)
{
        pose_t *pose;

        if (class_curr == NULL) {
                db_error("load_pose", "No #CLASS seen yet");
                return;
        }

        pose = varr_enew(&class_curr->poses);
        pose->self = mlstr_fread(fp);
        pose->others = mlstr_fread(fp);
}
