/* $Id: db_cmd.c,v 1.666 2004/09/20 10:50:19 shrike Exp $ */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <limits.h>
#include <stdio.h>
#include <ctype.h>

#include "typedef.h"
#include "const.h"
#include "varr.h"
#include "cmd.h"
#include "db.h"
#include "str.h"
#include "tables.h"

extern namedp_t dofun_table[];

DECLARE_DBLOAD_FUN(load_command);

DBFUN db_load_commands[] =
{
	{ "COMMAND",	load_command	},
	{ NULL }
};

DBLOAD_FUN(load_command)
{
	command_t *command = command_new();

	for (;;) {
		char *word = feof(fp) ? "End" : fread_word(fp);
		bool fMatch = FALSE;

		switch (UPPER(word[0])) {
		case 'D':
			KEY("DoFun", command->do_fun, fread_namedp(dofun_table, fp));
			break;
		case 'E':
			if (!str_cmp(word, "End")) {
				if (IS_NULLSTR(command->name)) {
					db_error("load_command", "command name not defined");
					command_free(command);
					commands.nused--;
				}
				if (command->do_fun == NULL) {
					db_error("load_command", "command dofun not defined");
					command_free(command);
					commands.nused--;
				}
				return;
			}
			break;
		case 'F':
			KEY("Flags", command->flags, fread_fstring(command_flags, fp));
		case 'L':
			KEY("Level", command->level, fread_fword(level_table, fp));
			KEY("Log", command->log, fread_fword(log_flags, fp));
			break;
		case 'N':
			SKEY("Name", command->name);
			break;
		case 'M':
			KEY("MinPos", command->position, fread_fword(position_table, fp));
			break;
		
		}

		if (!fMatch) 
			db_error("load_command", "%s: Unknown keyword", word);
	}
}
