/* $Id: db_immortal.c,v 1.666 2004/09/20 10:50:19 shrike Exp $ */
 
/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/

#include <stdio.h>

#include "merc.h"
#include "db.h"
#include "immortal.h"

DECLARE_DBLOAD_FUN(load_immortal);

DBFUN db_load_immortal[] =
{
	{ "IMMORTAL",   load_immortal},
	{ NULL}
};

DBLOAD_FUN(load_immortal)
{
    immortal_t * immortal;

    immortal = immortal_new();
    
    for (;;)
    {
        char *word = feof(fp) ? "End" : fread_word(fp);
        bool fMatch = FALSE;

        switch (UPPER(word[0]))
        {

        case 'E':
            if (!str_cmp(word, "End"))
            {
                if (IS_NULLSTR(immortal->name))
                {
                    db_error("load_immortal",
                             "immortal name not defined");
                    immortal_free(immortal);
                    immortals.nused--;
                }
                return;
            }
            KEY("EmailSec",    immortal->email_sec_level, fread_number(fp));
            SKEY("Email",      immortal->email);
            break;
        case 'I':
            KEY("ICQSec",      immortal->icq_sec_level,   fread_number(fp));
            SKEY("ICQ",        immortal->icq);
            break;
        case 'N':
            SKEY("Name",       immortal->name);
            break;
        case 'B':
            SKEY("Birthday",   immortal->birthday);
            break;    
        case 'A':
            SKEY("AccessTime", immortal->phone_time_access);
            break;
        case 'L':
            KEY("Level",       immortal->level,            fread_number(fp));
            break;
        case 'P':
            KEY("PhoneSec",    immortal->phone_sec_level,  fread_number(fp));
            SKEY("Phone",      immortal->phone);
            break;
        case 'C':
            SKEY("Comment",    immortal->comment);
            break;
        case 'R':
            SKEY("RealName",   immortal->realname);
            break;
        }

        if (!fMatch)
            db_error("load_meteor", "%s: Unknown keyword", word);
    }
}
