/* $Id: db_liquid.c,v 1.666 2004/09/20 10:50:19 shrike Exp $  */

/************************************************************************************
 *    Copyright 2004 Astrum Metaphora consortium                                    *
 *                                                                                  *
 *    Licensed under the Apache License, Version 2.0 (the "License");               *
 *    you may not use this file except in compliance with the License.              *
 *    You may obtain a copy of the License at                                       *
 *                                                                                  *
 *    http://www.apache.org/licenses/LICENSE-2.0                                    *
 *                                                                                  *
 *    Unless required by applicable law or agreed to in writing, software           *
 *    distributed under the License is distributed on an "AS IS" BASIS,             *
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.      *
 *    See the License for the specific language governing permissions and           *
 *    limitations under the License.                                                *
 *                                                                                  *
 ************************************************************************************/ 

#include <stdio.h>

#include "merc.h"
#include "db.h"


DECLARE_DBLOAD_FUN(load_liquid);

DBFUN db_load_liquid[] =
{
     { "LIQUID",   load_liquid},
     { NULL}
};

DBLOAD_FUN(load_liquid)
{
     liquid_t *liquid;

     liquid = liquid_new();
     
     for (;;)
     {
          char *word = feof(fp) ? "End" : fread_word(fp);
          bool fMatch = FALSE;

          switch (UPPER(word[0]))
          {
          
          case 'E':
               if (!str_cmp(word, "End"))
               {
                         if (IS_NULLSTR(liquid->name))
                         {
                                   db_error("load_liquid",
                                            "liquid name not defined");
                                   liquid_free(liquid);
                                   liquids.nused--;
                         }
                         return;
               }
               break;
          case 'C':
               SKEY("Color",    liquid->color);
               break;     
          case 'F':
               KEY("Flags",     liquid->flag,         fread_fstring(liquid_flags, fp));
               KEY("Full",      liquid->full,         fread_number(fp));
               KEY("Food",      liquid->food,         fread_number(fp));
               break;
          case 'N':
               SKEY("Name",     liquid->name);
               break;
          case 'P':
               KEY("Proof",     liquid->proof,        fread_number(fp));
               break;
          case 'S':
               KEY("Ssize",     liquid->ssize,        fread_number(fp));
               break;
          case 'T':
               KEY("Thirst",    liquid->thirst,       fread_number(fp));
               break;
          }

          if (!fMatch)
               db_error("load_liquid", "%s: Unknown keyword", word);
     }
}
